// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains information about the phone configuration settings for a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPhoneConfig {
    /// <p>The phone type.</p>
    pub phone_type: std::option::Option<crate::model::PhoneType>,
    /// <p>The Auto accept setting.</p>
    pub auto_accept: bool,
    /// <p>The After Call Work (ACW) timeout setting, in seconds.</p>
    pub after_contact_work_time_limit: i32,
    /// <p>The phone number for the user's desk phone.</p>
    pub desk_phone_number: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserPhoneConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPhoneConfig");
        formatter.field("phone_type", &self.phone_type);
        formatter.field("auto_accept", &self.auto_accept);
        formatter.field(
            "after_contact_work_time_limit",
            &self.after_contact_work_time_limit,
        );
        formatter.field("desk_phone_number", &self.desk_phone_number);
        formatter.finish()
    }
}
/// See [`UserPhoneConfig`](crate::model::UserPhoneConfig)
pub mod user_phone_config {
    /// A builder for [`UserPhoneConfig`](crate::model::UserPhoneConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_type: std::option::Option<crate::model::PhoneType>,
        pub(crate) auto_accept: std::option::Option<bool>,
        pub(crate) after_contact_work_time_limit: std::option::Option<i32>,
        pub(crate) desk_phone_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The phone type.</p>
        pub fn phone_type(mut self, input: crate::model::PhoneType) -> Self {
            self.phone_type = Some(input);
            self
        }
        /// <p>The phone type.</p>
        pub fn set_phone_type(
            mut self,
            input: std::option::Option<crate::model::PhoneType>,
        ) -> Self {
            self.phone_type = input;
            self
        }
        /// <p>The Auto accept setting.</p>
        pub fn auto_accept(mut self, input: bool) -> Self {
            self.auto_accept = Some(input);
            self
        }
        /// <p>The Auto accept setting.</p>
        pub fn set_auto_accept(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_accept = input;
            self
        }
        /// <p>The After Call Work (ACW) timeout setting, in seconds.</p>
        pub fn after_contact_work_time_limit(mut self, input: i32) -> Self {
            self.after_contact_work_time_limit = Some(input);
            self
        }
        /// <p>The After Call Work (ACW) timeout setting, in seconds.</p>
        pub fn set_after_contact_work_time_limit(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.after_contact_work_time_limit = input;
            self
        }
        /// <p>The phone number for the user's desk phone.</p>
        pub fn desk_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.desk_phone_number = Some(input.into());
            self
        }
        /// <p>The phone number for the user's desk phone.</p>
        pub fn set_desk_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.desk_phone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPhoneConfig`](crate::model::UserPhoneConfig)
        pub fn build(self) -> crate::model::UserPhoneConfig {
            crate::model::UserPhoneConfig {
                phone_type: self.phone_type,
                auto_accept: self.auto_accept.unwrap_or_default(),
                after_contact_work_time_limit: self
                    .after_contact_work_time_limit
                    .unwrap_or_default(),
                desk_phone_number: self.desk_phone_number,
            }
        }
    }
}
impl UserPhoneConfig {
    /// Creates a new builder-style object to manufacture [`UserPhoneConfig`](crate::model::UserPhoneConfig)
    pub fn builder() -> crate::model::user_phone_config::Builder {
        crate::model::user_phone_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhoneType {
    #[allow(missing_docs)] // documentation missing in model
    DeskPhone,
    #[allow(missing_docs)] // documentation missing in model
    SoftPhone,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhoneType {
    fn from(s: &str) -> Self {
        match s {
            "DESK_PHONE" => PhoneType::DeskPhone,
            "SOFT_PHONE" => PhoneType::SoftPhone,
            other => PhoneType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhoneType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhoneType::from(s))
    }
}
impl PhoneType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhoneType::DeskPhone => "DESK_PHONE",
            PhoneType::SoftPhone => "SOFT_PHONE",
            PhoneType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DESK_PHONE", "SOFT_PHONE"]
    }
}
impl AsRef<str> for PhoneType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the identity of a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserIdentityInfo {
    /// <p>The first name. This is required if you are using Amazon Connect or SAML for identity
    /// management.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The last name. This is required if you are using Amazon Connect or SAML for identity
    /// management.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The email address. If you are using SAML for identity management and include this parameter,
    /// an error is returned.</p>
    pub email: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserIdentityInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserIdentityInfo");
        formatter.field("first_name", &self.first_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("email", &self.email);
        formatter.finish()
    }
}
/// See [`UserIdentityInfo`](crate::model::UserIdentityInfo)
pub mod user_identity_info {
    /// A builder for [`UserIdentityInfo`](crate::model::UserIdentityInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The first name. This is required if you are using Amazon Connect or SAML for identity
        /// management.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The first name. This is required if you are using Amazon Connect or SAML for identity
        /// management.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The last name. This is required if you are using Amazon Connect or SAML for identity
        /// management.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The last name. This is required if you are using Amazon Connect or SAML for identity
        /// management.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The email address. If you are using SAML for identity management and include this parameter,
        /// an error is returned.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address. If you are using SAML for identity management and include this parameter,
        /// an error is returned.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// Consumes the builder and constructs a [`UserIdentityInfo`](crate::model::UserIdentityInfo)
        pub fn build(self) -> crate::model::UserIdentityInfo {
            crate::model::UserIdentityInfo {
                first_name: self.first_name,
                last_name: self.last_name,
                email: self.email,
            }
        }
    }
}
impl UserIdentityInfo {
    /// Creates a new builder-style object to manufacture [`UserIdentityInfo`](crate::model::UserIdentityInfo)
    pub fn builder() -> crate::model::user_identity_info::Builder {
        crate::model::user_identity_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Contact,
    #[allow(missing_docs)] // documentation missing in model
    ContactFlow,
    #[allow(missing_docs)] // documentation missing in model
    HierarchyGroup,
    #[allow(missing_docs)] // documentation missing in model
    HierarchyLevel,
    #[allow(missing_docs)] // documentation missing in model
    Instance,
    #[allow(missing_docs)] // documentation missing in model
    Participant,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "CONTACT" => ResourceType::Contact,
            "CONTACT_FLOW" => ResourceType::ContactFlow,
            "HIERARCHY_GROUP" => ResourceType::HierarchyGroup,
            "HIERARCHY_LEVEL" => ResourceType::HierarchyLevel,
            "INSTANCE" => ResourceType::Instance,
            "PARTICIPANT" => ResourceType::Participant,
            "USER" => ResourceType::User,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Contact => "CONTACT",
            ResourceType::ContactFlow => "CONTACT_FLOW",
            ResourceType::HierarchyGroup => "HIERARCHY_GROUP",
            ResourceType::HierarchyLevel => "HIERARCHY_LEVEL",
            ResourceType::Instance => "INSTANCE",
            ResourceType::Participant => "PARTICIPANT",
            ResourceType::User => "USER",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONTACT",
            "CONTACT_FLOW",
            "HIERARCHY_GROUP",
            "HIERARCHY_LEVEL",
            "INSTANCE",
            "PARTICIPANT",
            "USER",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the level hierarchy to update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HierarchyStructureUpdate {
    /// <p>The
    /// update
    /// for level one.</p>
    pub level_one: std::option::Option<crate::model::HierarchyLevelUpdate>,
    /// <p>The update for level two.</p>
    pub level_two: std::option::Option<crate::model::HierarchyLevelUpdate>,
    /// <p>The update for level three.</p>
    pub level_three: std::option::Option<crate::model::HierarchyLevelUpdate>,
    /// <p>The update for level four.</p>
    pub level_four: std::option::Option<crate::model::HierarchyLevelUpdate>,
    /// <p>The update for level five.</p>
    pub level_five: std::option::Option<crate::model::HierarchyLevelUpdate>,
}
impl std::fmt::Debug for HierarchyStructureUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HierarchyStructureUpdate");
        formatter.field("level_one", &self.level_one);
        formatter.field("level_two", &self.level_two);
        formatter.field("level_three", &self.level_three);
        formatter.field("level_four", &self.level_four);
        formatter.field("level_five", &self.level_five);
        formatter.finish()
    }
}
/// See [`HierarchyStructureUpdate`](crate::model::HierarchyStructureUpdate)
pub mod hierarchy_structure_update {
    /// A builder for [`HierarchyStructureUpdate`](crate::model::HierarchyStructureUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) level_one: std::option::Option<crate::model::HierarchyLevelUpdate>,
        pub(crate) level_two: std::option::Option<crate::model::HierarchyLevelUpdate>,
        pub(crate) level_three: std::option::Option<crate::model::HierarchyLevelUpdate>,
        pub(crate) level_four: std::option::Option<crate::model::HierarchyLevelUpdate>,
        pub(crate) level_five: std::option::Option<crate::model::HierarchyLevelUpdate>,
    }
    impl Builder {
        /// <p>The
        /// update
        /// for level one.</p>
        pub fn level_one(mut self, input: crate::model::HierarchyLevelUpdate) -> Self {
            self.level_one = Some(input);
            self
        }
        /// <p>The
        /// update
        /// for level one.</p>
        pub fn set_level_one(
            mut self,
            input: std::option::Option<crate::model::HierarchyLevelUpdate>,
        ) -> Self {
            self.level_one = input;
            self
        }
        /// <p>The update for level two.</p>
        pub fn level_two(mut self, input: crate::model::HierarchyLevelUpdate) -> Self {
            self.level_two = Some(input);
            self
        }
        /// <p>The update for level two.</p>
        pub fn set_level_two(
            mut self,
            input: std::option::Option<crate::model::HierarchyLevelUpdate>,
        ) -> Self {
            self.level_two = input;
            self
        }
        /// <p>The update for level three.</p>
        pub fn level_three(mut self, input: crate::model::HierarchyLevelUpdate) -> Self {
            self.level_three = Some(input);
            self
        }
        /// <p>The update for level three.</p>
        pub fn set_level_three(
            mut self,
            input: std::option::Option<crate::model::HierarchyLevelUpdate>,
        ) -> Self {
            self.level_three = input;
            self
        }
        /// <p>The update for level four.</p>
        pub fn level_four(mut self, input: crate::model::HierarchyLevelUpdate) -> Self {
            self.level_four = Some(input);
            self
        }
        /// <p>The update for level four.</p>
        pub fn set_level_four(
            mut self,
            input: std::option::Option<crate::model::HierarchyLevelUpdate>,
        ) -> Self {
            self.level_four = input;
            self
        }
        /// <p>The update for level five.</p>
        pub fn level_five(mut self, input: crate::model::HierarchyLevelUpdate) -> Self {
            self.level_five = Some(input);
            self
        }
        /// <p>The update for level five.</p>
        pub fn set_level_five(
            mut self,
            input: std::option::Option<crate::model::HierarchyLevelUpdate>,
        ) -> Self {
            self.level_five = input;
            self
        }
        /// Consumes the builder and constructs a [`HierarchyStructureUpdate`](crate::model::HierarchyStructureUpdate)
        pub fn build(self) -> crate::model::HierarchyStructureUpdate {
            crate::model::HierarchyStructureUpdate {
                level_one: self.level_one,
                level_two: self.level_two,
                level_three: self.level_three,
                level_four: self.level_four,
                level_five: self.level_five,
            }
        }
    }
}
impl HierarchyStructureUpdate {
    /// Creates a new builder-style object to manufacture [`HierarchyStructureUpdate`](crate::model::HierarchyStructureUpdate)
    pub fn builder() -> crate::model::hierarchy_structure_update::Builder {
        crate::model::hierarchy_structure_update::Builder::default()
    }
}

/// <p>Contains information about the hierarchy level to update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HierarchyLevelUpdate {
    /// <p>The name of the user hierarchy level. Must not be more than 50 characters.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HierarchyLevelUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HierarchyLevelUpdate");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`HierarchyLevelUpdate`](crate::model::HierarchyLevelUpdate)
pub mod hierarchy_level_update {
    /// A builder for [`HierarchyLevelUpdate`](crate::model::HierarchyLevelUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user hierarchy level. Must not be more than 50 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the user hierarchy level. Must not be more than 50 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`HierarchyLevelUpdate`](crate::model::HierarchyLevelUpdate)
        pub fn build(self) -> crate::model::HierarchyLevelUpdate {
            crate::model::HierarchyLevelUpdate { name: self.name }
        }
    }
}
impl HierarchyLevelUpdate {
    /// Creates a new builder-style object to manufacture [`HierarchyLevelUpdate`](crate::model::HierarchyLevelUpdate)
    pub fn builder() -> crate::model::hierarchy_level_update::Builder {
        crate::model::hierarchy_level_update::Builder::default()
    }
}

/// <p>Contains information about the queue and channel for which priority and delay can be
/// set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoutingProfileQueueConfig {
    /// <p>Contains information about a queue resource.</p>
    pub queue_reference: std::option::Option<crate::model::RoutingProfileQueueReference>,
    /// <p>The order in which contacts are to be handled for the queue. For more information, see
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
    /// delay</a>.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The delay, in seconds, a contact should be in the queue before they are routed to an
    /// available agent. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
    /// delay</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    pub delay: std::option::Option<i32>,
}
impl std::fmt::Debug for RoutingProfileQueueConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoutingProfileQueueConfig");
        formatter.field("queue_reference", &self.queue_reference);
        formatter.field("priority", &self.priority);
        formatter.field("delay", &self.delay);
        formatter.finish()
    }
}
/// See [`RoutingProfileQueueConfig`](crate::model::RoutingProfileQueueConfig)
pub mod routing_profile_queue_config {
    /// A builder for [`RoutingProfileQueueConfig`](crate::model::RoutingProfileQueueConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue_reference: std::option::Option<crate::model::RoutingProfileQueueReference>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) delay: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Contains information about a queue resource.</p>
        pub fn queue_reference(
            mut self,
            input: crate::model::RoutingProfileQueueReference,
        ) -> Self {
            self.queue_reference = Some(input);
            self
        }
        /// <p>Contains information about a queue resource.</p>
        pub fn set_queue_reference(
            mut self,
            input: std::option::Option<crate::model::RoutingProfileQueueReference>,
        ) -> Self {
            self.queue_reference = input;
            self
        }
        /// <p>The order in which contacts are to be handled for the queue. For more information, see
        /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
        /// delay</a>.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The order in which contacts are to be handled for the queue. For more information, see
        /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
        /// delay</a>.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The delay, in seconds, a contact should be in the queue before they are routed to an
        /// available agent. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
        /// delay</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        pub fn delay(mut self, input: i32) -> Self {
            self.delay = Some(input);
            self
        }
        /// <p>The delay, in seconds, a contact should be in the queue before they are routed to an
        /// available agent. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
        /// delay</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        pub fn set_delay(mut self, input: std::option::Option<i32>) -> Self {
            self.delay = input;
            self
        }
        /// Consumes the builder and constructs a [`RoutingProfileQueueConfig`](crate::model::RoutingProfileQueueConfig)
        pub fn build(self) -> crate::model::RoutingProfileQueueConfig {
            crate::model::RoutingProfileQueueConfig {
                queue_reference: self.queue_reference,
                priority: self.priority,
                delay: self.delay,
            }
        }
    }
}
impl RoutingProfileQueueConfig {
    /// Creates a new builder-style object to manufacture [`RoutingProfileQueueConfig`](crate::model::RoutingProfileQueueConfig)
    pub fn builder() -> crate::model::routing_profile_queue_config::Builder {
        crate::model::routing_profile_queue_config::Builder::default()
    }
}

/// <p>Contains the channel and queue identifier for a routing profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoutingProfileQueueReference {
    /// <p>The identifier for the queue.</p>
    pub queue_id: std::option::Option<std::string::String>,
    /// <p>The channels agents can handle in the Contact Control Panel (CCP) for this routing
    /// profile.</p>
    pub channel: std::option::Option<crate::model::Channel>,
}
impl std::fmt::Debug for RoutingProfileQueueReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoutingProfileQueueReference");
        formatter.field("queue_id", &self.queue_id);
        formatter.field("channel", &self.channel);
        formatter.finish()
    }
}
/// See [`RoutingProfileQueueReference`](crate::model::RoutingProfileQueueReference)
pub mod routing_profile_queue_reference {
    /// A builder for [`RoutingProfileQueueReference`](crate::model::RoutingProfileQueueReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue_id: std::option::Option<std::string::String>,
        pub(crate) channel: std::option::Option<crate::model::Channel>,
    }
    impl Builder {
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_id = Some(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_id = input;
            self
        }
        /// <p>The channels agents can handle in the Contact Control Panel (CCP) for this routing
        /// profile.</p>
        pub fn channel(mut self, input: crate::model::Channel) -> Self {
            self.channel = Some(input);
            self
        }
        /// <p>The channels agents can handle in the Contact Control Panel (CCP) for this routing
        /// profile.</p>
        pub fn set_channel(mut self, input: std::option::Option<crate::model::Channel>) -> Self {
            self.channel = input;
            self
        }
        /// Consumes the builder and constructs a [`RoutingProfileQueueReference`](crate::model::RoutingProfileQueueReference)
        pub fn build(self) -> crate::model::RoutingProfileQueueReference {
            crate::model::RoutingProfileQueueReference {
                queue_id: self.queue_id,
                channel: self.channel,
            }
        }
    }
}
impl RoutingProfileQueueReference {
    /// Creates a new builder-style object to manufacture [`RoutingProfileQueueReference`](crate::model::RoutingProfileQueueReference)
    pub fn builder() -> crate::model::routing_profile_queue_reference::Builder {
        crate::model::routing_profile_queue_reference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Channel {
    #[allow(missing_docs)] // documentation missing in model
    Chat,
    #[allow(missing_docs)] // documentation missing in model
    Task,
    #[allow(missing_docs)] // documentation missing in model
    Voice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Channel {
    fn from(s: &str) -> Self {
        match s {
            "CHAT" => Channel::Chat,
            "TASK" => Channel::Task,
            "VOICE" => Channel::Voice,
            other => Channel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Channel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Channel::from(s))
    }
}
impl Channel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Channel::Chat => "CHAT",
            Channel::Task => "TASK",
            Channel::Voice => "VOICE",
            Channel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CHAT", "TASK", "VOICE"]
    }
}
impl AsRef<str> for Channel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about which channels are supported, and how many contacts an agent can
/// have on a channel simultaneously.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaConcurrency {
    /// <p>The channels that agents can handle in the Contact Control Panel (CCP).</p>
    pub channel: std::option::Option<crate::model::Channel>,
    /// <p>The number of contacts an agent can have on a channel simultaneously.</p>
    /// <p>Valid Range for <code>VOICE</code>: Minimum value of 1. Maximum value of 1.</p>
    /// <p>Valid Range for <code>CHAT</code>: Minimum value of 1. Maximum value of 10.</p>
    /// <p>Valid Range for <code>TASK</code>: Minimum value of 1. Maximum value of 10.</p>
    pub concurrency: i32,
}
impl std::fmt::Debug for MediaConcurrency {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaConcurrency");
        formatter.field("channel", &self.channel);
        formatter.field("concurrency", &self.concurrency);
        formatter.finish()
    }
}
/// See [`MediaConcurrency`](crate::model::MediaConcurrency)
pub mod media_concurrency {
    /// A builder for [`MediaConcurrency`](crate::model::MediaConcurrency)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel: std::option::Option<crate::model::Channel>,
        pub(crate) concurrency: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP).</p>
        pub fn channel(mut self, input: crate::model::Channel) -> Self {
            self.channel = Some(input);
            self
        }
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP).</p>
        pub fn set_channel(mut self, input: std::option::Option<crate::model::Channel>) -> Self {
            self.channel = input;
            self
        }
        /// <p>The number of contacts an agent can have on a channel simultaneously.</p>
        /// <p>Valid Range for <code>VOICE</code>: Minimum value of 1. Maximum value of 1.</p>
        /// <p>Valid Range for <code>CHAT</code>: Minimum value of 1. Maximum value of 10.</p>
        /// <p>Valid Range for <code>TASK</code>: Minimum value of 1. Maximum value of 10.</p>
        pub fn concurrency(mut self, input: i32) -> Self {
            self.concurrency = Some(input);
            self
        }
        /// <p>The number of contacts an agent can have on a channel simultaneously.</p>
        /// <p>Valid Range for <code>VOICE</code>: Minimum value of 1. Maximum value of 1.</p>
        /// <p>Valid Range for <code>CHAT</code>: Minimum value of 1. Maximum value of 10.</p>
        /// <p>Valid Range for <code>TASK</code>: Minimum value of 1. Maximum value of 10.</p>
        pub fn set_concurrency(mut self, input: std::option::Option<i32>) -> Self {
            self.concurrency = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaConcurrency`](crate::model::MediaConcurrency)
        pub fn build(self) -> crate::model::MediaConcurrency {
            crate::model::MediaConcurrency {
                channel: self.channel,
                concurrency: self.concurrency.unwrap_or_default(),
            }
        }
    }
}
impl MediaConcurrency {
    /// Creates a new builder-style object to manufacture [`MediaConcurrency`](crate::model::MediaConcurrency)
    pub fn builder() -> crate::model::media_concurrency::Builder {
        crate::model::media_concurrency::Builder::default()
    }
}

/// <p>Contains configuration settings for a quick connect.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QuickConnectConfig {
    /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
    /// prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE). </p>
    pub quick_connect_type: std::option::Option<crate::model::QuickConnectType>,
    /// <p>The user configuration. This is required only if QuickConnectType is USER.</p>
    pub user_config: std::option::Option<crate::model::UserQuickConnectConfig>,
    /// <p>The queue configuration. This is required only if QuickConnectType is QUEUE.</p>
    pub queue_config: std::option::Option<crate::model::QueueQuickConnectConfig>,
    /// <p>The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.</p>
    pub phone_config: std::option::Option<crate::model::PhoneNumberQuickConnectConfig>,
}
impl std::fmt::Debug for QuickConnectConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QuickConnectConfig");
        formatter.field("quick_connect_type", &self.quick_connect_type);
        formatter.field("user_config", &self.user_config);
        formatter.field("queue_config", &self.queue_config);
        formatter.field("phone_config", &self.phone_config);
        formatter.finish()
    }
}
/// See [`QuickConnectConfig`](crate::model::QuickConnectConfig)
pub mod quick_connect_config {
    /// A builder for [`QuickConnectConfig`](crate::model::QuickConnectConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quick_connect_type: std::option::Option<crate::model::QuickConnectType>,
        pub(crate) user_config: std::option::Option<crate::model::UserQuickConnectConfig>,
        pub(crate) queue_config: std::option::Option<crate::model::QueueQuickConnectConfig>,
        pub(crate) phone_config: std::option::Option<crate::model::PhoneNumberQuickConnectConfig>,
    }
    impl Builder {
        /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
        /// prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE). </p>
        pub fn quick_connect_type(mut self, input: crate::model::QuickConnectType) -> Self {
            self.quick_connect_type = Some(input);
            self
        }
        /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
        /// prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE). </p>
        pub fn set_quick_connect_type(
            mut self,
            input: std::option::Option<crate::model::QuickConnectType>,
        ) -> Self {
            self.quick_connect_type = input;
            self
        }
        /// <p>The user configuration. This is required only if QuickConnectType is USER.</p>
        pub fn user_config(mut self, input: crate::model::UserQuickConnectConfig) -> Self {
            self.user_config = Some(input);
            self
        }
        /// <p>The user configuration. This is required only if QuickConnectType is USER.</p>
        pub fn set_user_config(
            mut self,
            input: std::option::Option<crate::model::UserQuickConnectConfig>,
        ) -> Self {
            self.user_config = input;
            self
        }
        /// <p>The queue configuration. This is required only if QuickConnectType is QUEUE.</p>
        pub fn queue_config(mut self, input: crate::model::QueueQuickConnectConfig) -> Self {
            self.queue_config = Some(input);
            self
        }
        /// <p>The queue configuration. This is required only if QuickConnectType is QUEUE.</p>
        pub fn set_queue_config(
            mut self,
            input: std::option::Option<crate::model::QueueQuickConnectConfig>,
        ) -> Self {
            self.queue_config = input;
            self
        }
        /// <p>The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.</p>
        pub fn phone_config(mut self, input: crate::model::PhoneNumberQuickConnectConfig) -> Self {
            self.phone_config = Some(input);
            self
        }
        /// <p>The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.</p>
        pub fn set_phone_config(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberQuickConnectConfig>,
        ) -> Self {
            self.phone_config = input;
            self
        }
        /// Consumes the builder and constructs a [`QuickConnectConfig`](crate::model::QuickConnectConfig)
        pub fn build(self) -> crate::model::QuickConnectConfig {
            crate::model::QuickConnectConfig {
                quick_connect_type: self.quick_connect_type,
                user_config: self.user_config,
                queue_config: self.queue_config,
                phone_config: self.phone_config,
            }
        }
    }
}
impl QuickConnectConfig {
    /// Creates a new builder-style object to manufacture [`QuickConnectConfig`](crate::model::QuickConnectConfig)
    pub fn builder() -> crate::model::quick_connect_config::Builder {
        crate::model::quick_connect_config::Builder::default()
    }
}

/// <p>Contains information about a phone number for a quick connect.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumberQuickConnectConfig {
    /// <p>The phone number in E.164 format.</p>
    pub phone_number: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PhoneNumberQuickConnectConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumberQuickConnectConfig");
        formatter.field("phone_number", &self.phone_number);
        formatter.finish()
    }
}
/// See [`PhoneNumberQuickConnectConfig`](crate::model::PhoneNumberQuickConnectConfig)
pub mod phone_number_quick_connect_config {
    /// A builder for [`PhoneNumberQuickConnectConfig`](crate::model::PhoneNumberQuickConnectConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The phone number in E.164 format.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number in E.164 format.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumberQuickConnectConfig`](crate::model::PhoneNumberQuickConnectConfig)
        pub fn build(self) -> crate::model::PhoneNumberQuickConnectConfig {
            crate::model::PhoneNumberQuickConnectConfig {
                phone_number: self.phone_number,
            }
        }
    }
}
impl PhoneNumberQuickConnectConfig {
    /// Creates a new builder-style object to manufacture [`PhoneNumberQuickConnectConfig`](crate::model::PhoneNumberQuickConnectConfig)
    pub fn builder() -> crate::model::phone_number_quick_connect_config::Builder {
        crate::model::phone_number_quick_connect_config::Builder::default()
    }
}

/// <p>Contains information about a queue for a quick connect. The contact flow must be of type
/// Transfer to Queue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueueQuickConnectConfig {
    /// <p>The identifier for the queue.</p>
    pub queue_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the contact flow.</p>
    pub contact_flow_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for QueueQuickConnectConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueueQuickConnectConfig");
        formatter.field("queue_id", &self.queue_id);
        formatter.field("contact_flow_id", &self.contact_flow_id);
        formatter.finish()
    }
}
/// See [`QueueQuickConnectConfig`](crate::model::QueueQuickConnectConfig)
pub mod queue_quick_connect_config {
    /// A builder for [`QueueQuickConnectConfig`](crate::model::QueueQuickConnectConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue_id: std::option::Option<std::string::String>,
        pub(crate) contact_flow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_id = Some(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_id = input;
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_flow_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_flow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`QueueQuickConnectConfig`](crate::model::QueueQuickConnectConfig)
        pub fn build(self) -> crate::model::QueueQuickConnectConfig {
            crate::model::QueueQuickConnectConfig {
                queue_id: self.queue_id,
                contact_flow_id: self.contact_flow_id,
            }
        }
    }
}
impl QueueQuickConnectConfig {
    /// Creates a new builder-style object to manufacture [`QueueQuickConnectConfig`](crate::model::QueueQuickConnectConfig)
    pub fn builder() -> crate::model::queue_quick_connect_config::Builder {
        crate::model::queue_quick_connect_config::Builder::default()
    }
}

/// <p>Contains information about the quick connect configuration settings for a user. The contact
/// flow must be of type Transfer to Agent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserQuickConnectConfig {
    /// <p>The identifier of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the contact flow.</p>
    pub contact_flow_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserQuickConnectConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserQuickConnectConfig");
        formatter.field("user_id", &self.user_id);
        formatter.field("contact_flow_id", &self.contact_flow_id);
        formatter.finish()
    }
}
/// See [`UserQuickConnectConfig`](crate::model::UserQuickConnectConfig)
pub mod user_quick_connect_config {
    /// A builder for [`UserQuickConnectConfig`](crate::model::UserQuickConnectConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) contact_flow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_flow_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_flow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UserQuickConnectConfig`](crate::model::UserQuickConnectConfig)
        pub fn build(self) -> crate::model::UserQuickConnectConfig {
            crate::model::UserQuickConnectConfig {
                user_id: self.user_id,
                contact_flow_id: self.contact_flow_id,
            }
        }
    }
}
impl UserQuickConnectConfig {
    /// Creates a new builder-style object to manufacture [`UserQuickConnectConfig`](crate::model::UserQuickConnectConfig)
    pub fn builder() -> crate::model::user_quick_connect_config::Builder {
        crate::model::user_quick_connect_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QuickConnectType {
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumber,
    #[allow(missing_docs)] // documentation missing in model
    Queue,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QuickConnectType {
    fn from(s: &str) -> Self {
        match s {
            "PHONE_NUMBER" => QuickConnectType::PhoneNumber,
            "QUEUE" => QuickConnectType::Queue,
            "USER" => QuickConnectType::User,
            other => QuickConnectType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QuickConnectType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QuickConnectType::from(s))
    }
}
impl QuickConnectType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QuickConnectType::PhoneNumber => "PHONE_NUMBER",
            QuickConnectType::Queue => "QUEUE",
            QuickConnectType::User => "USER",
            QuickConnectType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PHONE_NUMBER", "QUEUE", "USER"]
    }
}
impl AsRef<str> for QuickConnectType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QueueStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QueueStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => QueueStatus::Disabled,
            "ENABLED" => QueueStatus::Enabled,
            other => QueueStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QueueStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QueueStatus::from(s))
    }
}
impl QueueStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QueueStatus::Disabled => "DISABLED",
            QueueStatus::Enabled => "ENABLED",
            QueueStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for QueueStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutboundCallerConfig {
    /// <p>The caller ID name.</p>
    pub outbound_caller_id_name: std::option::Option<std::string::String>,
    /// <p>The caller ID number.</p>
    pub outbound_caller_id_number_id: std::option::Option<std::string::String>,
    /// <p>The outbound whisper flow to be used during an outbound call.</p>
    pub outbound_flow_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OutboundCallerConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutboundCallerConfig");
        formatter.field("outbound_caller_id_name", &self.outbound_caller_id_name);
        formatter.field(
            "outbound_caller_id_number_id",
            &self.outbound_caller_id_number_id,
        );
        formatter.field("outbound_flow_id", &self.outbound_flow_id);
        formatter.finish()
    }
}
/// See [`OutboundCallerConfig`](crate::model::OutboundCallerConfig)
pub mod outbound_caller_config {
    /// A builder for [`OutboundCallerConfig`](crate::model::OutboundCallerConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outbound_caller_id_name: std::option::Option<std::string::String>,
        pub(crate) outbound_caller_id_number_id: std::option::Option<std::string::String>,
        pub(crate) outbound_flow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The caller ID name.</p>
        pub fn outbound_caller_id_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.outbound_caller_id_name = Some(input.into());
            self
        }
        /// <p>The caller ID name.</p>
        pub fn set_outbound_caller_id_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.outbound_caller_id_name = input;
            self
        }
        /// <p>The caller ID number.</p>
        pub fn outbound_caller_id_number_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.outbound_caller_id_number_id = Some(input.into());
            self
        }
        /// <p>The caller ID number.</p>
        pub fn set_outbound_caller_id_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.outbound_caller_id_number_id = input;
            self
        }
        /// <p>The outbound whisper flow to be used during an outbound call.</p>
        pub fn outbound_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outbound_flow_id = Some(input.into());
            self
        }
        /// <p>The outbound whisper flow to be used during an outbound call.</p>
        pub fn set_outbound_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.outbound_flow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`OutboundCallerConfig`](crate::model::OutboundCallerConfig)
        pub fn build(self) -> crate::model::OutboundCallerConfig {
            crate::model::OutboundCallerConfig {
                outbound_caller_id_name: self.outbound_caller_id_name,
                outbound_caller_id_number_id: self.outbound_caller_id_number_id,
                outbound_flow_id: self.outbound_flow_id,
            }
        }
    }
}
impl OutboundCallerConfig {
    /// Creates a new builder-style object to manufacture [`OutboundCallerConfig`](crate::model::OutboundCallerConfig)
    pub fn builder() -> crate::model::outbound_caller_config::Builder {
        crate::model::outbound_caller_config::Builder::default()
    }
}

/// <p>The storage configuration for the instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceStorageConfig {
    /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>A valid storage type.</p>
    pub storage_type: std::option::Option<crate::model::StorageType>,
    /// <p>The S3 bucket
    /// configuration.</p>
    pub s3_config: std::option::Option<crate::model::S3Config>,
    /// <p>The configuration of the Kinesis video stream.</p>
    pub kinesis_video_stream_config: std::option::Option<crate::model::KinesisVideoStreamConfig>,
    /// <p>The configuration of the Kinesis data stream.</p>
    pub kinesis_stream_config: std::option::Option<crate::model::KinesisStreamConfig>,
    /// <p>The configuration of the Kinesis Firehose delivery stream.</p>
    pub kinesis_firehose_config: std::option::Option<crate::model::KinesisFirehoseConfig>,
}
impl std::fmt::Debug for InstanceStorageConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceStorageConfig");
        formatter.field("association_id", &self.association_id);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("s3_config", &self.s3_config);
        formatter.field(
            "kinesis_video_stream_config",
            &self.kinesis_video_stream_config,
        );
        formatter.field("kinesis_stream_config", &self.kinesis_stream_config);
        formatter.field("kinesis_firehose_config", &self.kinesis_firehose_config);
        formatter.finish()
    }
}
/// See [`InstanceStorageConfig`](crate::model::InstanceStorageConfig)
pub mod instance_storage_config {
    /// A builder for [`InstanceStorageConfig`](crate::model::InstanceStorageConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<crate::model::StorageType>,
        pub(crate) s3_config: std::option::Option<crate::model::S3Config>,
        pub(crate) kinesis_video_stream_config:
            std::option::Option<crate::model::KinesisVideoStreamConfig>,
        pub(crate) kinesis_stream_config: std::option::Option<crate::model::KinesisStreamConfig>,
        pub(crate) kinesis_firehose_config:
            std::option::Option<crate::model::KinesisFirehoseConfig>,
    }
    impl Builder {
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>A valid storage type.</p>
        pub fn storage_type(mut self, input: crate::model::StorageType) -> Self {
            self.storage_type = Some(input);
            self
        }
        /// <p>A valid storage type.</p>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The S3 bucket
        /// configuration.</p>
        pub fn s3_config(mut self, input: crate::model::S3Config) -> Self {
            self.s3_config = Some(input);
            self
        }
        /// <p>The S3 bucket
        /// configuration.</p>
        pub fn set_s3_config(mut self, input: std::option::Option<crate::model::S3Config>) -> Self {
            self.s3_config = input;
            self
        }
        /// <p>The configuration of the Kinesis video stream.</p>
        pub fn kinesis_video_stream_config(
            mut self,
            input: crate::model::KinesisVideoStreamConfig,
        ) -> Self {
            self.kinesis_video_stream_config = Some(input);
            self
        }
        /// <p>The configuration of the Kinesis video stream.</p>
        pub fn set_kinesis_video_stream_config(
            mut self,
            input: std::option::Option<crate::model::KinesisVideoStreamConfig>,
        ) -> Self {
            self.kinesis_video_stream_config = input;
            self
        }
        /// <p>The configuration of the Kinesis data stream.</p>
        pub fn kinesis_stream_config(mut self, input: crate::model::KinesisStreamConfig) -> Self {
            self.kinesis_stream_config = Some(input);
            self
        }
        /// <p>The configuration of the Kinesis data stream.</p>
        pub fn set_kinesis_stream_config(
            mut self,
            input: std::option::Option<crate::model::KinesisStreamConfig>,
        ) -> Self {
            self.kinesis_stream_config = input;
            self
        }
        /// <p>The configuration of the Kinesis Firehose delivery stream.</p>
        pub fn kinesis_firehose_config(
            mut self,
            input: crate::model::KinesisFirehoseConfig,
        ) -> Self {
            self.kinesis_firehose_config = Some(input);
            self
        }
        /// <p>The configuration of the Kinesis Firehose delivery stream.</p>
        pub fn set_kinesis_firehose_config(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseConfig>,
        ) -> Self {
            self.kinesis_firehose_config = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceStorageConfig`](crate::model::InstanceStorageConfig)
        pub fn build(self) -> crate::model::InstanceStorageConfig {
            crate::model::InstanceStorageConfig {
                association_id: self.association_id,
                storage_type: self.storage_type,
                s3_config: self.s3_config,
                kinesis_video_stream_config: self.kinesis_video_stream_config,
                kinesis_stream_config: self.kinesis_stream_config,
                kinesis_firehose_config: self.kinesis_firehose_config,
            }
        }
    }
}
impl InstanceStorageConfig {
    /// Creates a new builder-style object to manufacture [`InstanceStorageConfig`](crate::model::InstanceStorageConfig)
    pub fn builder() -> crate::model::instance_storage_config::Builder {
        crate::model::instance_storage_config::Builder::default()
    }
}

/// <p>Configuration information of a Kinesis Data Firehose delivery stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseConfig {
    /// <p>The Amazon Resource Name (ARN) of the delivery stream.</p>
    pub firehose_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisFirehoseConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseConfig");
        formatter.field("firehose_arn", &self.firehose_arn);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseConfig`](crate::model::KinesisFirehoseConfig)
pub mod kinesis_firehose_config {
    /// A builder for [`KinesisFirehoseConfig`](crate::model::KinesisFirehoseConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firehose_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the delivery stream.</p>
        pub fn firehose_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firehose_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the delivery stream.</p>
        pub fn set_firehose_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firehose_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseConfig`](crate::model::KinesisFirehoseConfig)
        pub fn build(self) -> crate::model::KinesisFirehoseConfig {
            crate::model::KinesisFirehoseConfig {
                firehose_arn: self.firehose_arn,
            }
        }
    }
}
impl KinesisFirehoseConfig {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseConfig`](crate::model::KinesisFirehoseConfig)
    pub fn builder() -> crate::model::kinesis_firehose_config::Builder {
        crate::model::kinesis_firehose_config::Builder::default()
    }
}

/// <p>Configuration information of a Kinesis data stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisStreamConfig {
    /// <p>The Amazon Resource Name (ARN) of the data stream.</p>
    pub stream_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisStreamConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisStreamConfig");
        formatter.field("stream_arn", &self.stream_arn);
        formatter.finish()
    }
}
/// See [`KinesisStreamConfig`](crate::model::KinesisStreamConfig)
pub mod kinesis_stream_config {
    /// A builder for [`KinesisStreamConfig`](crate::model::KinesisStreamConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the data stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the data stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisStreamConfig`](crate::model::KinesisStreamConfig)
        pub fn build(self) -> crate::model::KinesisStreamConfig {
            crate::model::KinesisStreamConfig {
                stream_arn: self.stream_arn,
            }
        }
    }
}
impl KinesisStreamConfig {
    /// Creates a new builder-style object to manufacture [`KinesisStreamConfig`](crate::model::KinesisStreamConfig)
    pub fn builder() -> crate::model::kinesis_stream_config::Builder {
        crate::model::kinesis_stream_config::Builder::default()
    }
}

/// <p>Configuration information of a Kinesis video stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisVideoStreamConfig {
    /// <p>The prefix of the video stream.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>The number of hours data is retained in the stream. Kinesis Video Streams retains the data
    /// in a data store that is associated with the stream.</p>
    /// <p>The default value is 0, indicating that the stream does not persist data.</p>
    pub retention_period_hours: i32,
    /// <p>The encryption configuration.</p>
    pub encryption_config: std::option::Option<crate::model::EncryptionConfig>,
}
impl std::fmt::Debug for KinesisVideoStreamConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisVideoStreamConfig");
        formatter.field("prefix", &self.prefix);
        formatter.field("retention_period_hours", &self.retention_period_hours);
        formatter.field("encryption_config", &self.encryption_config);
        formatter.finish()
    }
}
/// See [`KinesisVideoStreamConfig`](crate::model::KinesisVideoStreamConfig)
pub mod kinesis_video_stream_config {
    /// A builder for [`KinesisVideoStreamConfig`](crate::model::KinesisVideoStreamConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) retention_period_hours: std::option::Option<i32>,
        pub(crate) encryption_config: std::option::Option<crate::model::EncryptionConfig>,
    }
    impl Builder {
        /// <p>The prefix of the video stream.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix of the video stream.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>The number of hours data is retained in the stream. Kinesis Video Streams retains the data
        /// in a data store that is associated with the stream.</p>
        /// <p>The default value is 0, indicating that the stream does not persist data.</p>
        pub fn retention_period_hours(mut self, input: i32) -> Self {
            self.retention_period_hours = Some(input);
            self
        }
        /// <p>The number of hours data is retained in the stream. Kinesis Video Streams retains the data
        /// in a data store that is associated with the stream.</p>
        /// <p>The default value is 0, indicating that the stream does not persist data.</p>
        pub fn set_retention_period_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period_hours = input;
            self
        }
        /// <p>The encryption configuration.</p>
        pub fn encryption_config(mut self, input: crate::model::EncryptionConfig) -> Self {
            self.encryption_config = Some(input);
            self
        }
        /// <p>The encryption configuration.</p>
        pub fn set_encryption_config(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfig>,
        ) -> Self {
            self.encryption_config = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisVideoStreamConfig`](crate::model::KinesisVideoStreamConfig)
        pub fn build(self) -> crate::model::KinesisVideoStreamConfig {
            crate::model::KinesisVideoStreamConfig {
                prefix: self.prefix,
                retention_period_hours: self.retention_period_hours.unwrap_or_default(),
                encryption_config: self.encryption_config,
            }
        }
    }
}
impl KinesisVideoStreamConfig {
    /// Creates a new builder-style object to manufacture [`KinesisVideoStreamConfig`](crate::model::KinesisVideoStreamConfig)
    pub fn builder() -> crate::model::kinesis_video_stream_config::Builder {
        crate::model::kinesis_video_stream_config::Builder::default()
    }
}

/// <p>The encryption configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionConfig {
    /// <p>The type of encryption.</p>
    pub encryption_type: std::option::Option<crate::model::EncryptionType>,
    /// <p>The full ARN of the encryption key. </p>
    /// <note>
    /// <p>Be sure to provide the full ARN of the encryption key, not just the ID.</p>
    /// </note>
    pub key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionConfig");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("key_id", &self.key_id);
        formatter.finish()
    }
}
/// See [`EncryptionConfig`](crate::model::EncryptionConfig)
pub mod encryption_config {
    /// A builder for [`EncryptionConfig`](crate::model::EncryptionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_type: std::option::Option<crate::model::EncryptionType>,
        pub(crate) key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of encryption.</p>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The type of encryption.</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// <p>The full ARN of the encryption key. </p>
        /// <note>
        /// <p>Be sure to provide the full ARN of the encryption key, not just the ID.</p>
        /// </note>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The full ARN of the encryption key. </p>
        /// <note>
        /// <p>Be sure to provide the full ARN of the encryption key, not just the ID.</p>
        /// </note>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionConfig`](crate::model::EncryptionConfig)
        pub fn build(self) -> crate::model::EncryptionConfig {
            crate::model::EncryptionConfig {
                encryption_type: self.encryption_type,
                key_id: self.key_id,
            }
        }
    }
}
impl EncryptionConfig {
    /// Creates a new builder-style object to manufacture [`EncryptionConfig`](crate::model::EncryptionConfig)
    pub fn builder() -> crate::model::encryption_config::Builder {
        crate::model::encryption_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionType {
    #[allow(missing_docs)] // documentation missing in model
    Kms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionType {
    fn from(s: &str) -> Self {
        match s {
            "KMS" => EncryptionType::Kms,
            other => EncryptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionType::from(s))
    }
}
impl EncryptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionType::Kms => "KMS",
            EncryptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KMS"]
    }
}
impl AsRef<str> for EncryptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the Amazon Simple Storage Service (Amazon S3) storage type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Config {
    /// <p>The S3 bucket name.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The S3 bucket prefix.</p>
    pub bucket_prefix: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 encryption configuration.</p>
    pub encryption_config: std::option::Option<crate::model::EncryptionConfig>,
}
impl std::fmt::Debug for S3Config {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Config");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("bucket_prefix", &self.bucket_prefix);
        formatter.field("encryption_config", &self.encryption_config);
        formatter.finish()
    }
}
/// See [`S3Config`](crate::model::S3Config)
pub mod s3_config {
    /// A builder for [`S3Config`](crate::model::S3Config)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) bucket_prefix: std::option::Option<std::string::String>,
        pub(crate) encryption_config: std::option::Option<crate::model::EncryptionConfig>,
    }
    impl Builder {
        /// <p>The S3 bucket name.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The S3 bucket name.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The S3 bucket prefix.</p>
        pub fn bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_prefix = Some(input.into());
            self
        }
        /// <p>The S3 bucket prefix.</p>
        pub fn set_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_prefix = input;
            self
        }
        /// <p>The Amazon S3 encryption configuration.</p>
        pub fn encryption_config(mut self, input: crate::model::EncryptionConfig) -> Self {
            self.encryption_config = Some(input);
            self
        }
        /// <p>The Amazon S3 encryption configuration.</p>
        pub fn set_encryption_config(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfig>,
        ) -> Self {
            self.encryption_config = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Config`](crate::model::S3Config)
        pub fn build(self) -> crate::model::S3Config {
            crate::model::S3Config {
                bucket_name: self.bucket_name,
                bucket_prefix: self.bucket_prefix,
                encryption_config: self.encryption_config,
            }
        }
    }
}
impl S3Config {
    /// Creates a new builder-style object to manufacture [`S3Config`](crate::model::S3Config)
    pub fn builder() -> crate::model::s3_config::Builder {
        crate::model::s3_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageType {
    #[allow(missing_docs)] // documentation missing in model
    KinesisFirehose,
    #[allow(missing_docs)] // documentation missing in model
    KinesisStream,
    #[allow(missing_docs)] // documentation missing in model
    KinesisVideoStream,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageType {
    fn from(s: &str) -> Self {
        match s {
            "KINESIS_FIREHOSE" => StorageType::KinesisFirehose,
            "KINESIS_STREAM" => StorageType::KinesisStream,
            "KINESIS_VIDEO_STREAM" => StorageType::KinesisVideoStream,
            "S3" => StorageType::S3,
            other => StorageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageType::from(s))
    }
}
impl StorageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageType::KinesisFirehose => "KINESIS_FIREHOSE",
            StorageType::KinesisStream => "KINESIS_STREAM",
            StorageType::KinesisVideoStream => "KINESIS_VIDEO_STREAM",
            StorageType::S3 => "S3",
            StorageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "KINESIS_FIREHOSE",
            "KINESIS_STREAM",
            "KINESIS_VIDEO_STREAM",
            "S3",
        ]
    }
}
impl AsRef<str> for StorageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceStorageResourceType {
    #[allow(missing_docs)] // documentation missing in model
    AgentEvents,
    #[allow(missing_docs)] // documentation missing in model
    CallRecordings,
    #[allow(missing_docs)] // documentation missing in model
    ChatTranscripts,
    #[allow(missing_docs)] // documentation missing in model
    ContactTraceRecords,
    #[allow(missing_docs)] // documentation missing in model
    MediaStreams,
    #[allow(missing_docs)] // documentation missing in model
    ScheduledReports,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceStorageResourceType {
    fn from(s: &str) -> Self {
        match s {
            "AGENT_EVENTS" => InstanceStorageResourceType::AgentEvents,
            "CALL_RECORDINGS" => InstanceStorageResourceType::CallRecordings,
            "CHAT_TRANSCRIPTS" => InstanceStorageResourceType::ChatTranscripts,
            "CONTACT_TRACE_RECORDS" => InstanceStorageResourceType::ContactTraceRecords,
            "MEDIA_STREAMS" => InstanceStorageResourceType::MediaStreams,
            "SCHEDULED_REPORTS" => InstanceStorageResourceType::ScheduledReports,
            other => InstanceStorageResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceStorageResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceStorageResourceType::from(s))
    }
}
impl InstanceStorageResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceStorageResourceType::AgentEvents => "AGENT_EVENTS",
            InstanceStorageResourceType::CallRecordings => "CALL_RECORDINGS",
            InstanceStorageResourceType::ChatTranscripts => "CHAT_TRANSCRIPTS",
            InstanceStorageResourceType::ContactTraceRecords => "CONTACT_TRACE_RECORDS",
            InstanceStorageResourceType::MediaStreams => "MEDIA_STREAMS",
            InstanceStorageResourceType::ScheduledReports => "SCHEDULED_REPORTS",
            InstanceStorageResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AGENT_EVENTS",
            "CALL_RECORDINGS",
            "CHAT_TRANSCRIPTS",
            "CONTACT_TRACE_RECORDS",
            "MEDIA_STREAMS",
            "SCHEDULED_REPORTS",
        ]
    }
}
impl AsRef<str> for InstanceStorageResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceAttributeType {
    #[allow(missing_docs)] // documentation missing in model
    AutoResolveBestVoices,
    #[allow(missing_docs)] // documentation missing in model
    ContactflowLogs,
    #[allow(missing_docs)] // documentation missing in model
    ContactLens,
    #[allow(missing_docs)] // documentation missing in model
    EarlyMedia,
    #[allow(missing_docs)] // documentation missing in model
    InboundCalls,
    #[allow(missing_docs)] // documentation missing in model
    OutboundCalls,
    #[allow(missing_docs)] // documentation missing in model
    UseCustomTtsVoices,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceAttributeType {
    fn from(s: &str) -> Self {
        match s {
            "AUTO_RESOLVE_BEST_VOICES" => InstanceAttributeType::AutoResolveBestVoices,
            "CONTACTFLOW_LOGS" => InstanceAttributeType::ContactflowLogs,
            "CONTACT_LENS" => InstanceAttributeType::ContactLens,
            "EARLY_MEDIA" => InstanceAttributeType::EarlyMedia,
            "INBOUND_CALLS" => InstanceAttributeType::InboundCalls,
            "OUTBOUND_CALLS" => InstanceAttributeType::OutboundCalls,
            "USE_CUSTOM_TTS_VOICES" => InstanceAttributeType::UseCustomTtsVoices,
            other => InstanceAttributeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceAttributeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceAttributeType::from(s))
    }
}
impl InstanceAttributeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceAttributeType::AutoResolveBestVoices => "AUTO_RESOLVE_BEST_VOICES",
            InstanceAttributeType::ContactflowLogs => "CONTACTFLOW_LOGS",
            InstanceAttributeType::ContactLens => "CONTACT_LENS",
            InstanceAttributeType::EarlyMedia => "EARLY_MEDIA",
            InstanceAttributeType::InboundCalls => "INBOUND_CALLS",
            InstanceAttributeType::OutboundCalls => "OUTBOUND_CALLS",
            InstanceAttributeType::UseCustomTtsVoices => "USE_CUSTOM_TTS_VOICES",
            InstanceAttributeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AUTO_RESOLVE_BEST_VOICES",
            "CONTACTFLOW_LOGS",
            "CONTACT_LENS",
            "EARLY_MEDIA",
            "INBOUND_CALLS",
            "OUTBOUND_CALLS",
            "USE_CUSTOM_TTS_VOICES",
        ]
    }
}
impl AsRef<str> for InstanceAttributeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the hours of operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HoursOfOperationConfig {
    /// <p>The day that the hours of operation applies to.</p>
    pub day: std::option::Option<crate::model::HoursOfOperationDays>,
    /// <p>The start time that your contact center opens.</p>
    pub start_time: std::option::Option<crate::model::HoursOfOperationTimeSlice>,
    /// <p>The end time that your contact center closes.</p>
    pub end_time: std::option::Option<crate::model::HoursOfOperationTimeSlice>,
}
impl std::fmt::Debug for HoursOfOperationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HoursOfOperationConfig");
        formatter.field("day", &self.day);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`HoursOfOperationConfig`](crate::model::HoursOfOperationConfig)
pub mod hours_of_operation_config {
    /// A builder for [`HoursOfOperationConfig`](crate::model::HoursOfOperationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) day: std::option::Option<crate::model::HoursOfOperationDays>,
        pub(crate) start_time: std::option::Option<crate::model::HoursOfOperationTimeSlice>,
        pub(crate) end_time: std::option::Option<crate::model::HoursOfOperationTimeSlice>,
    }
    impl Builder {
        /// <p>The day that the hours of operation applies to.</p>
        pub fn day(mut self, input: crate::model::HoursOfOperationDays) -> Self {
            self.day = Some(input);
            self
        }
        /// <p>The day that the hours of operation applies to.</p>
        pub fn set_day(
            mut self,
            input: std::option::Option<crate::model::HoursOfOperationDays>,
        ) -> Self {
            self.day = input;
            self
        }
        /// <p>The start time that your contact center opens.</p>
        pub fn start_time(mut self, input: crate::model::HoursOfOperationTimeSlice) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time that your contact center opens.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<crate::model::HoursOfOperationTimeSlice>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time that your contact center closes.</p>
        pub fn end_time(mut self, input: crate::model::HoursOfOperationTimeSlice) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time that your contact center closes.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<crate::model::HoursOfOperationTimeSlice>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`HoursOfOperationConfig`](crate::model::HoursOfOperationConfig)
        pub fn build(self) -> crate::model::HoursOfOperationConfig {
            crate::model::HoursOfOperationConfig {
                day: self.day,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl HoursOfOperationConfig {
    /// Creates a new builder-style object to manufacture [`HoursOfOperationConfig`](crate::model::HoursOfOperationConfig)
    pub fn builder() -> crate::model::hours_of_operation_config::Builder {
        crate::model::hours_of_operation_config::Builder::default()
    }
}

/// <p>The start time or end time for an hours of operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HoursOfOperationTimeSlice {
    /// <p>The hours.</p>
    pub hours: std::option::Option<i32>,
    /// <p>The minutes.</p>
    pub minutes: std::option::Option<i32>,
}
impl std::fmt::Debug for HoursOfOperationTimeSlice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HoursOfOperationTimeSlice");
        formatter.field("hours", &self.hours);
        formatter.field("minutes", &self.minutes);
        formatter.finish()
    }
}
/// See [`HoursOfOperationTimeSlice`](crate::model::HoursOfOperationTimeSlice)
pub mod hours_of_operation_time_slice {
    /// A builder for [`HoursOfOperationTimeSlice`](crate::model::HoursOfOperationTimeSlice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hours: std::option::Option<i32>,
        pub(crate) minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The hours.</p>
        pub fn hours(mut self, input: i32) -> Self {
            self.hours = Some(input);
            self
        }
        /// <p>The hours.</p>
        pub fn set_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.hours = input;
            self
        }
        /// <p>The minutes.</p>
        pub fn minutes(mut self, input: i32) -> Self {
            self.minutes = Some(input);
            self
        }
        /// <p>The minutes.</p>
        pub fn set_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`HoursOfOperationTimeSlice`](crate::model::HoursOfOperationTimeSlice)
        pub fn build(self) -> crate::model::HoursOfOperationTimeSlice {
            crate::model::HoursOfOperationTimeSlice {
                hours: self.hours,
                minutes: self.minutes,
            }
        }
    }
}
impl HoursOfOperationTimeSlice {
    /// Creates a new builder-style object to manufacture [`HoursOfOperationTimeSlice`](crate::model::HoursOfOperationTimeSlice)
    pub fn builder() -> crate::model::hours_of_operation_time_slice::Builder {
        crate::model::hours_of_operation_time_slice::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HoursOfOperationDays {
    #[allow(missing_docs)] // documentation missing in model
    Friday,
    #[allow(missing_docs)] // documentation missing in model
    Monday,
    #[allow(missing_docs)] // documentation missing in model
    Saturday,
    #[allow(missing_docs)] // documentation missing in model
    Sunday,
    #[allow(missing_docs)] // documentation missing in model
    Thursday,
    #[allow(missing_docs)] // documentation missing in model
    Tuesday,
    #[allow(missing_docs)] // documentation missing in model
    Wednesday,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HoursOfOperationDays {
    fn from(s: &str) -> Self {
        match s {
            "FRIDAY" => HoursOfOperationDays::Friday,
            "MONDAY" => HoursOfOperationDays::Monday,
            "SATURDAY" => HoursOfOperationDays::Saturday,
            "SUNDAY" => HoursOfOperationDays::Sunday,
            "THURSDAY" => HoursOfOperationDays::Thursday,
            "TUESDAY" => HoursOfOperationDays::Tuesday,
            "WEDNESDAY" => HoursOfOperationDays::Wednesday,
            other => HoursOfOperationDays::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HoursOfOperationDays {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HoursOfOperationDays::from(s))
    }
}
impl HoursOfOperationDays {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HoursOfOperationDays::Friday => "FRIDAY",
            HoursOfOperationDays::Monday => "MONDAY",
            HoursOfOperationDays::Saturday => "SATURDAY",
            HoursOfOperationDays::Sunday => "SUNDAY",
            HoursOfOperationDays::Thursday => "THURSDAY",
            HoursOfOperationDays::Tuesday => "TUESDAY",
            HoursOfOperationDays::Wednesday => "WEDNESDAY",
            HoursOfOperationDays::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FRIDAY",
            "MONDAY",
            "SATURDAY",
            "SUNDAY",
            "THURSDAY",
            "TUESDAY",
            "WEDNESDAY",
        ]
    }
}
impl AsRef<str> for HoursOfOperationDays {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a problem detail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProblemDetail {
    /// <p>The problem detail's message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProblemDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProblemDetail");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ProblemDetail`](crate::model::ProblemDetail)
pub mod problem_detail {
    /// A builder for [`ProblemDetail`](crate::model::ProblemDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The problem detail's message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The problem detail's message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProblemDetail`](crate::model::ProblemDetail)
        pub fn build(self) -> crate::model::ProblemDetail {
            crate::model::ProblemDetail {
                message: self.message,
            }
        }
    }
}
impl ProblemDetail {
    /// Creates a new builder-style object to manufacture [`ProblemDetail`](crate::model::ProblemDetail)
    pub fn builder() -> crate::model::problem_detail::Builder {
        crate::model::problem_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AgentStatusState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AgentStatusState {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => AgentStatusState::Disabled,
            "ENABLED" => AgentStatusState::Enabled,
            other => AgentStatusState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AgentStatusState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AgentStatusState::from(s))
    }
}
impl AgentStatusState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AgentStatusState::Disabled => "DISABLED",
            AgentStatusState::Enabled => "ENABLED",
            AgentStatusState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for AgentStatusState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A link that an agent selects to complete a given task. You can have up to 4,096 UTF-8 bytes
/// across all references for a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Reference {
    /// <p>A formatted URL that displays to an agent in the Contact Control Panel (CCP)</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>A valid
    /// URL.</p>
    pub r#type: std::option::Option<crate::model::ReferenceType>,
}
impl std::fmt::Debug for Reference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Reference");
        formatter.field("value", &self.value);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Reference`](crate::model::Reference)
pub mod reference {
    /// A builder for [`Reference`](crate::model::Reference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ReferenceType>,
    }
    impl Builder {
        /// <p>A formatted URL that displays to an agent in the Contact Control Panel (CCP)</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A formatted URL that displays to an agent in the Contact Control Panel (CCP)</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>A valid
        /// URL.</p>
        pub fn r#type(mut self, input: crate::model::ReferenceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>A valid
        /// URL.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ReferenceType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Reference`](crate::model::Reference)
        pub fn build(self) -> crate::model::Reference {
            crate::model::Reference {
                value: self.value,
                r#type: self.r#type,
            }
        }
    }
}
impl Reference {
    /// Creates a new builder-style object to manufacture [`Reference`](crate::model::Reference)
    pub fn builder() -> crate::model::reference::Builder {
        crate::model::reference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReferenceType {
    #[allow(missing_docs)] // documentation missing in model
    Url,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReferenceType {
    fn from(s: &str) -> Self {
        match s {
            "URL" => ReferenceType::Url,
            other => ReferenceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReferenceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReferenceType::from(s))
    }
}
impl ReferenceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReferenceType::Url => "URL",
            ReferenceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["URL"]
    }
}
impl AsRef<str> for ReferenceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TrafficType {
    #[allow(missing_docs)] // documentation missing in model
    Campaign,
    #[allow(missing_docs)] // documentation missing in model
    General,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TrafficType {
    fn from(s: &str) -> Self {
        match s {
            "CAMPAIGN" => TrafficType::Campaign,
            "GENERAL" => TrafficType::General,
            other => TrafficType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TrafficType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TrafficType::from(s))
    }
}
impl TrafficType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TrafficType::Campaign => "CAMPAIGN",
            TrafficType::General => "GENERAL",
            TrafficType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CAMPAIGN", "GENERAL"]
    }
}
impl AsRef<str> for TrafficType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration of the answering machine detection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnswerMachineDetectionConfig {
    /// <p>The flag to indicate if answer machine detection analysis needs to be performed for a voice
    /// call. If set to <code>true</code>, <code>TrafficType</code> must be set as <code>CAMPAIGN</code>.
    /// </p>
    pub enable_answer_machine_detection: bool,
    /// <p>Wait for the answering machine prompt.</p>
    pub await_answer_machine_prompt: bool,
}
impl std::fmt::Debug for AnswerMachineDetectionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnswerMachineDetectionConfig");
        formatter.field(
            "enable_answer_machine_detection",
            &self.enable_answer_machine_detection,
        );
        formatter.field(
            "await_answer_machine_prompt",
            &self.await_answer_machine_prompt,
        );
        formatter.finish()
    }
}
/// See [`AnswerMachineDetectionConfig`](crate::model::AnswerMachineDetectionConfig)
pub mod answer_machine_detection_config {
    /// A builder for [`AnswerMachineDetectionConfig`](crate::model::AnswerMachineDetectionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_answer_machine_detection: std::option::Option<bool>,
        pub(crate) await_answer_machine_prompt: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The flag to indicate if answer machine detection analysis needs to be performed for a voice
        /// call. If set to <code>true</code>, <code>TrafficType</code> must be set as <code>CAMPAIGN</code>.
        /// </p>
        pub fn enable_answer_machine_detection(mut self, input: bool) -> Self {
            self.enable_answer_machine_detection = Some(input);
            self
        }
        /// <p>The flag to indicate if answer machine detection analysis needs to be performed for a voice
        /// call. If set to <code>true</code>, <code>TrafficType</code> must be set as <code>CAMPAIGN</code>.
        /// </p>
        pub fn set_enable_answer_machine_detection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_answer_machine_detection = input;
            self
        }
        /// <p>Wait for the answering machine prompt.</p>
        pub fn await_answer_machine_prompt(mut self, input: bool) -> Self {
            self.await_answer_machine_prompt = Some(input);
            self
        }
        /// <p>Wait for the answering machine prompt.</p>
        pub fn set_await_answer_machine_prompt(mut self, input: std::option::Option<bool>) -> Self {
            self.await_answer_machine_prompt = input;
            self
        }
        /// Consumes the builder and constructs a [`AnswerMachineDetectionConfig`](crate::model::AnswerMachineDetectionConfig)
        pub fn build(self) -> crate::model::AnswerMachineDetectionConfig {
            crate::model::AnswerMachineDetectionConfig {
                enable_answer_machine_detection: self
                    .enable_answer_machine_detection
                    .unwrap_or_default(),
                await_answer_machine_prompt: self.await_answer_machine_prompt.unwrap_or_default(),
            }
        }
    }
}
impl AnswerMachineDetectionConfig {
    /// Creates a new builder-style object to manufacture [`AnswerMachineDetectionConfig`](crate::model::AnswerMachineDetectionConfig)
    pub fn builder() -> crate::model::answer_machine_detection_config::Builder {
        crate::model::answer_machine_detection_config::Builder::default()
    }
}

/// <p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChatStreamingConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon Resource Name (ARN) of the streaming endpoint that is used
    /// to publish real-time message streaming for chat conversations.</p>
    pub streaming_endpoint_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChatStreamingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChatStreamingConfiguration");
        formatter.field("streaming_endpoint_arn", &self.streaming_endpoint_arn);
        formatter.finish()
    }
}
/// See [`ChatStreamingConfiguration`](crate::model::ChatStreamingConfiguration)
pub mod chat_streaming_configuration {
    /// A builder for [`ChatStreamingConfiguration`](crate::model::ChatStreamingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon Resource Name (ARN) of the streaming endpoint that is used
        /// to publish real-time message streaming for chat conversations.</p>
        pub fn streaming_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.streaming_endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon Resource Name (ARN) of the streaming endpoint that is used
        /// to publish real-time message streaming for chat conversations.</p>
        pub fn set_streaming_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.streaming_endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ChatStreamingConfiguration`](crate::model::ChatStreamingConfiguration)
        pub fn build(self) -> crate::model::ChatStreamingConfiguration {
            crate::model::ChatStreamingConfiguration {
                streaming_endpoint_arn: self.streaming_endpoint_arn,
            }
        }
    }
}
impl ChatStreamingConfiguration {
    /// Creates a new builder-style object to manufacture [`ChatStreamingConfiguration`](crate::model::ChatStreamingConfiguration)
    pub fn builder() -> crate::model::chat_streaming_configuration::Builder {
        crate::model::chat_streaming_configuration::Builder::default()
    }
}

/// <p>Contains information about the recording configuration settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoiceRecordingConfiguration {
    /// <p>Identifies which track is being recorded.</p>
    pub voice_recording_track: std::option::Option<crate::model::VoiceRecordingTrack>,
}
impl std::fmt::Debug for VoiceRecordingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoiceRecordingConfiguration");
        formatter.field("voice_recording_track", &self.voice_recording_track);
        formatter.finish()
    }
}
/// See [`VoiceRecordingConfiguration`](crate::model::VoiceRecordingConfiguration)
pub mod voice_recording_configuration {
    /// A builder for [`VoiceRecordingConfiguration`](crate::model::VoiceRecordingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_recording_track: std::option::Option<crate::model::VoiceRecordingTrack>,
    }
    impl Builder {
        /// <p>Identifies which track is being recorded.</p>
        pub fn voice_recording_track(mut self, input: crate::model::VoiceRecordingTrack) -> Self {
            self.voice_recording_track = Some(input);
            self
        }
        /// <p>Identifies which track is being recorded.</p>
        pub fn set_voice_recording_track(
            mut self,
            input: std::option::Option<crate::model::VoiceRecordingTrack>,
        ) -> Self {
            self.voice_recording_track = input;
            self
        }
        /// Consumes the builder and constructs a [`VoiceRecordingConfiguration`](crate::model::VoiceRecordingConfiguration)
        pub fn build(self) -> crate::model::VoiceRecordingConfiguration {
            crate::model::VoiceRecordingConfiguration {
                voice_recording_track: self.voice_recording_track,
            }
        }
    }
}
impl VoiceRecordingConfiguration {
    /// Creates a new builder-style object to manufacture [`VoiceRecordingConfiguration`](crate::model::VoiceRecordingConfiguration)
    pub fn builder() -> crate::model::voice_recording_configuration::Builder {
        crate::model::voice_recording_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VoiceRecordingTrack {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    FromAgent,
    #[allow(missing_docs)] // documentation missing in model
    ToAgent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VoiceRecordingTrack {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => VoiceRecordingTrack::All,
            "FROM_AGENT" => VoiceRecordingTrack::FromAgent,
            "TO_AGENT" => VoiceRecordingTrack::ToAgent,
            other => VoiceRecordingTrack::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VoiceRecordingTrack {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VoiceRecordingTrack::from(s))
    }
}
impl VoiceRecordingTrack {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VoiceRecordingTrack::All => "ALL",
            VoiceRecordingTrack::FromAgent => "FROM_AGENT",
            VoiceRecordingTrack::ToAgent => "TO_AGENT",
            VoiceRecordingTrack::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "FROM_AGENT", "TO_AGENT"]
    }
}
impl AsRef<str> for VoiceRecordingTrack {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A chat message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChatMessage {
    /// <p>The type of the content. Supported types are text and plain.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The content of the chat message.</p>
    pub content: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChatMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChatMessage");
        formatter.field("content_type", &self.content_type);
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`ChatMessage`](crate::model::ChatMessage)
pub mod chat_message {
    /// A builder for [`ChatMessage`](crate::model::ChatMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the content. Supported types are text and plain.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The type of the content. Supported types are text and plain.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The content of the chat message.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the chat message.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`ChatMessage`](crate::model::ChatMessage)
        pub fn build(self) -> crate::model::ChatMessage {
            crate::model::ChatMessage {
                content_type: self.content_type,
                content: self.content,
            }
        }
    }
}
impl ChatMessage {
    /// Creates a new builder-style object to manufacture [`ChatMessage`](crate::model::ChatMessage)
    pub fn builder() -> crate::model::chat_message::Builder {
        crate::model::chat_message::Builder::default()
    }
}

/// <p>The customer's details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParticipantDetails {
    /// <p>Display name of the participant.</p>
    pub display_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParticipantDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParticipantDetails");
        formatter.field("display_name", &self.display_name);
        formatter.finish()
    }
}
/// See [`ParticipantDetails`](crate::model::ParticipantDetails)
pub mod participant_details {
    /// A builder for [`ParticipantDetails`](crate::model::ParticipantDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) display_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Display name of the participant.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>Display name of the participant.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ParticipantDetails`](crate::model::ParticipantDetails)
        pub fn build(self) -> crate::model::ParticipantDetails {
            crate::model::ParticipantDetails {
                display_name: self.display_name,
            }
        }
    }
}
impl ParticipantDetails {
    /// Creates a new builder-style object to manufacture [`ParticipantDetails`](crate::model::ParticipantDetails)
    pub fn builder() -> crate::model::participant_details::Builder {
        crate::model::participant_details::Builder::default()
    }
}

/// <p>Contains summary information about a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserSummary {
    /// <p>The identifier of the user account.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the user account.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Connect user name of the user account.</p>
    pub username: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}
/// See [`UserSummary`](crate::model::UserSummary)
pub mod user_summary {
    /// A builder for [`UserSummary`](crate::model::UserSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the user account.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user account.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user account.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Connect user name of the user account.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The Amazon Connect user name of the user account.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`UserSummary`](crate::model::UserSummary)
        pub fn build(self) -> crate::model::UserSummary {
            crate::model::UserSummary {
                id: self.id,
                arn: self.arn,
                username: self.username,
            }
        }
    }
}
impl UserSummary {
    /// Creates a new builder-style object to manufacture [`UserSummary`](crate::model::UserSummary)
    pub fn builder() -> crate::model::user_summary::Builder {
        crate::model::user_summary::Builder::default()
    }
}

/// <p>Contains summary information about a hierarchy group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HierarchyGroupSummary {
    /// <p>The identifier of the hierarchy group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the hierarchy group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the hierarchy group.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HierarchyGroupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HierarchyGroupSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`HierarchyGroupSummary`](crate::model::HierarchyGroupSummary)
pub mod hierarchy_group_summary {
    /// A builder for [`HierarchyGroupSummary`](crate::model::HierarchyGroupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the hierarchy group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hierarchy group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hierarchy group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the hierarchy group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hierarchy group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`HierarchyGroupSummary`](crate::model::HierarchyGroupSummary)
        pub fn build(self) -> crate::model::HierarchyGroupSummary {
            crate::model::HierarchyGroupSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl HierarchyGroupSummary {
    /// Creates a new builder-style object to manufacture [`HierarchyGroupSummary`](crate::model::HierarchyGroupSummary)
    pub fn builder() -> crate::model::hierarchy_group_summary::Builder {
        crate::model::hierarchy_group_summary::Builder::default()
    }
}

/// <p>Contains the
/// use
/// case.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UseCase {
    /// <p>The identifier for the use case.</p>
    pub use_case_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the use case.</p>
    pub use_case_arn: std::option::Option<std::string::String>,
    /// <p>The type of use case to associate to the integration association. Each integration
    /// association can have only one of each use case type.</p>
    pub use_case_type: std::option::Option<crate::model::UseCaseType>,
}
impl std::fmt::Debug for UseCase {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UseCase");
        formatter.field("use_case_id", &self.use_case_id);
        formatter.field("use_case_arn", &self.use_case_arn);
        formatter.field("use_case_type", &self.use_case_type);
        formatter.finish()
    }
}
/// See [`UseCase`](crate::model::UseCase)
pub mod use_case {
    /// A builder for [`UseCase`](crate::model::UseCase)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) use_case_id: std::option::Option<std::string::String>,
        pub(crate) use_case_arn: std::option::Option<std::string::String>,
        pub(crate) use_case_type: std::option::Option<crate::model::UseCaseType>,
    }
    impl Builder {
        /// <p>The identifier for the use case.</p>
        pub fn use_case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.use_case_id = Some(input.into());
            self
        }
        /// <p>The identifier for the use case.</p>
        pub fn set_use_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.use_case_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the use case.</p>
        pub fn use_case_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.use_case_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the use case.</p>
        pub fn set_use_case_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.use_case_arn = input;
            self
        }
        /// <p>The type of use case to associate to the integration association. Each integration
        /// association can have only one of each use case type.</p>
        pub fn use_case_type(mut self, input: crate::model::UseCaseType) -> Self {
            self.use_case_type = Some(input);
            self
        }
        /// <p>The type of use case to associate to the integration association. Each integration
        /// association can have only one of each use case type.</p>
        pub fn set_use_case_type(
            mut self,
            input: std::option::Option<crate::model::UseCaseType>,
        ) -> Self {
            self.use_case_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UseCase`](crate::model::UseCase)
        pub fn build(self) -> crate::model::UseCase {
            crate::model::UseCase {
                use_case_id: self.use_case_id,
                use_case_arn: self.use_case_arn,
                use_case_type: self.use_case_type,
            }
        }
    }
}
impl UseCase {
    /// Creates a new builder-style object to manufacture [`UseCase`](crate::model::UseCase)
    pub fn builder() -> crate::model::use_case::Builder {
        crate::model::use_case::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UseCaseType {
    #[allow(missing_docs)] // documentation missing in model
    ConnectCampaigns,
    #[allow(missing_docs)] // documentation missing in model
    RulesEvaluation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UseCaseType {
    fn from(s: &str) -> Self {
        match s {
            "CONNECT_CAMPAIGNS" => UseCaseType::ConnectCampaigns,
            "RULES_EVALUATION" => UseCaseType::RulesEvaluation,
            other => UseCaseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UseCaseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UseCaseType::from(s))
    }
}
impl UseCaseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UseCaseType::ConnectCampaigns => "CONNECT_CAMPAIGNS",
            UseCaseType::RulesEvaluation => "RULES_EVALUATION",
            UseCaseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECT_CAMPAIGNS", "RULES_EVALUATION"]
    }
}
impl AsRef<str> for UseCaseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a security profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityProfileSummary {
    /// <p>The identifier of the security profile.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the security profile.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the security profile.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SecurityProfileSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityProfileSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`SecurityProfileSummary`](crate::model::SecurityProfileSummary)
pub mod security_profile_summary {
    /// A builder for [`SecurityProfileSummary`](crate::model::SecurityProfileSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the security profile.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the security profile.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the security profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the security profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the security profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the security profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityProfileSummary`](crate::model::SecurityProfileSummary)
        pub fn build(self) -> crate::model::SecurityProfileSummary {
            crate::model::SecurityProfileSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl SecurityProfileSummary {
    /// Creates a new builder-style object to manufacture [`SecurityProfileSummary`](crate::model::SecurityProfileSummary)
    pub fn builder() -> crate::model::security_profile_summary::Builder {
        crate::model::security_profile_summary::Builder::default()
    }
}

/// <p>Configuration information of the security key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityKey {
    /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The key of the security key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>When the security key was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for SecurityKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityKey");
        formatter.field("association_id", &self.association_id);
        formatter.field("key", &self.key);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`SecurityKey`](crate::model::SecurityKey)
pub mod security_key {
    /// A builder for [`SecurityKey`](crate::model::SecurityKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>The key of the security key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the security key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>When the security key was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the security key was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityKey`](crate::model::SecurityKey)
        pub fn build(self) -> crate::model::SecurityKey {
            crate::model::SecurityKey {
                association_id: self.association_id,
                key: self.key,
                creation_time: self.creation_time,
            }
        }
    }
}
impl SecurityKey {
    /// Creates a new builder-style object to manufacture [`SecurityKey`](crate::model::SecurityKey)
    pub fn builder() -> crate::model::security_key::Builder {
        crate::model::security_key::Builder::default()
    }
}

/// <p>Contains summary information about a routing profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoutingProfileSummary {
    /// <p>The identifier of the routing profile.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the routing profile.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the routing profile.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RoutingProfileSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoutingProfileSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`RoutingProfileSummary`](crate::model::RoutingProfileSummary)
pub mod routing_profile_summary {
    /// A builder for [`RoutingProfileSummary`](crate::model::RoutingProfileSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the routing profile.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the routing profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the routing profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`RoutingProfileSummary`](crate::model::RoutingProfileSummary)
        pub fn build(self) -> crate::model::RoutingProfileSummary {
            crate::model::RoutingProfileSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl RoutingProfileSummary {
    /// Creates a new builder-style object to manufacture [`RoutingProfileSummary`](crate::model::RoutingProfileSummary)
    pub fn builder() -> crate::model::routing_profile_summary::Builder {
        crate::model::routing_profile_summary::Builder::default()
    }
}

/// <p>Contains summary information about a routing profile queue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoutingProfileQueueConfigSummary {
    /// <p>The identifier for the queue.</p>
    pub queue_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the queue.</p>
    pub queue_arn: std::option::Option<std::string::String>,
    /// <p>The name of the queue.</p>
    pub queue_name: std::option::Option<std::string::String>,
    /// <p>The order in which contacts are to be handled for the queue. For more information, see
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
    /// delay</a>.</p>
    pub priority: i32,
    /// <p>The delay, in seconds, that a contact should be in the queue before they are routed to an
    /// available agent. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
    /// delay</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    pub delay: i32,
    /// <p>The channels this queue supports.</p>
    pub channel: std::option::Option<crate::model::Channel>,
}
impl std::fmt::Debug for RoutingProfileQueueConfigSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoutingProfileQueueConfigSummary");
        formatter.field("queue_id", &self.queue_id);
        formatter.field("queue_arn", &self.queue_arn);
        formatter.field("queue_name", &self.queue_name);
        formatter.field("priority", &self.priority);
        formatter.field("delay", &self.delay);
        formatter.field("channel", &self.channel);
        formatter.finish()
    }
}
/// See [`RoutingProfileQueueConfigSummary`](crate::model::RoutingProfileQueueConfigSummary)
pub mod routing_profile_queue_config_summary {
    /// A builder for [`RoutingProfileQueueConfigSummary`](crate::model::RoutingProfileQueueConfigSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue_id: std::option::Option<std::string::String>,
        pub(crate) queue_arn: std::option::Option<std::string::String>,
        pub(crate) queue_name: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) delay: std::option::Option<i32>,
        pub(crate) channel: std::option::Option<crate::model::Channel>,
    }
    impl Builder {
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_id = Some(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the queue.</p>
        pub fn queue_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the queue.</p>
        pub fn set_queue_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_arn = input;
            self
        }
        /// <p>The name of the queue.</p>
        pub fn queue_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_name = Some(input.into());
            self
        }
        /// <p>The name of the queue.</p>
        pub fn set_queue_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_name = input;
            self
        }
        /// <p>The order in which contacts are to be handled for the queue. For more information, see
        /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
        /// delay</a>.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The order in which contacts are to be handled for the queue. For more information, see
        /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
        /// delay</a>.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The delay, in seconds, that a contact should be in the queue before they are routed to an
        /// available agent. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
        /// delay</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        pub fn delay(mut self, input: i32) -> Self {
            self.delay = Some(input);
            self
        }
        /// <p>The delay, in seconds, that a contact should be in the queue before they are routed to an
        /// available agent. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and
        /// delay</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        pub fn set_delay(mut self, input: std::option::Option<i32>) -> Self {
            self.delay = input;
            self
        }
        /// <p>The channels this queue supports.</p>
        pub fn channel(mut self, input: crate::model::Channel) -> Self {
            self.channel = Some(input);
            self
        }
        /// <p>The channels this queue supports.</p>
        pub fn set_channel(mut self, input: std::option::Option<crate::model::Channel>) -> Self {
            self.channel = input;
            self
        }
        /// Consumes the builder and constructs a [`RoutingProfileQueueConfigSummary`](crate::model::RoutingProfileQueueConfigSummary)
        pub fn build(self) -> crate::model::RoutingProfileQueueConfigSummary {
            crate::model::RoutingProfileQueueConfigSummary {
                queue_id: self.queue_id,
                queue_arn: self.queue_arn,
                queue_name: self.queue_name,
                priority: self.priority.unwrap_or_default(),
                delay: self.delay.unwrap_or_default(),
                channel: self.channel,
            }
        }
    }
}
impl RoutingProfileQueueConfigSummary {
    /// Creates a new builder-style object to manufacture [`RoutingProfileQueueConfigSummary`](crate::model::RoutingProfileQueueConfigSummary)
    pub fn builder() -> crate::model::routing_profile_queue_config_summary::Builder {
        crate::model::routing_profile_queue_config_summary::Builder::default()
    }
}

/// <p>Contains summary information about a quick connect.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QuickConnectSummary {
    /// <p>The identifier for the quick connect.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the quick connect.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the quick connect.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
    /// prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>
    pub quick_connect_type: std::option::Option<crate::model::QuickConnectType>,
}
impl std::fmt::Debug for QuickConnectSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QuickConnectSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("quick_connect_type", &self.quick_connect_type);
        formatter.finish()
    }
}
/// See [`QuickConnectSummary`](crate::model::QuickConnectSummary)
pub mod quick_connect_summary {
    /// A builder for [`QuickConnectSummary`](crate::model::QuickConnectSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) quick_connect_type: std::option::Option<crate::model::QuickConnectType>,
    }
    impl Builder {
        /// <p>The identifier for the quick connect.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the quick connect.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the quick connect.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
        /// prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>
        pub fn quick_connect_type(mut self, input: crate::model::QuickConnectType) -> Self {
            self.quick_connect_type = Some(input);
            self
        }
        /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
        /// prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>
        pub fn set_quick_connect_type(
            mut self,
            input: std::option::Option<crate::model::QuickConnectType>,
        ) -> Self {
            self.quick_connect_type = input;
            self
        }
        /// Consumes the builder and constructs a [`QuickConnectSummary`](crate::model::QuickConnectSummary)
        pub fn build(self) -> crate::model::QuickConnectSummary {
            crate::model::QuickConnectSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                quick_connect_type: self.quick_connect_type,
            }
        }
    }
}
impl QuickConnectSummary {
    /// Creates a new builder-style object to manufacture [`QuickConnectSummary`](crate::model::QuickConnectSummary)
    pub fn builder() -> crate::model::quick_connect_summary::Builder {
        crate::model::quick_connect_summary::Builder::default()
    }
}

/// <p>Contains summary information about a queue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueueSummary {
    /// <p>The identifier of the queue.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the queue.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the queue.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of queue.</p>
    pub queue_type: std::option::Option<crate::model::QueueType>,
}
impl std::fmt::Debug for QueueSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueueSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("queue_type", &self.queue_type);
        formatter.finish()
    }
}
/// See [`QueueSummary`](crate::model::QueueSummary)
pub mod queue_summary {
    /// A builder for [`QueueSummary`](crate::model::QueueSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) queue_type: std::option::Option<crate::model::QueueType>,
    }
    impl Builder {
        /// <p>The identifier of the queue.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the queue.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the queue.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the queue.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the queue.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the queue.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of queue.</p>
        pub fn queue_type(mut self, input: crate::model::QueueType) -> Self {
            self.queue_type = Some(input);
            self
        }
        /// <p>The type of queue.</p>
        pub fn set_queue_type(
            mut self,
            input: std::option::Option<crate::model::QueueType>,
        ) -> Self {
            self.queue_type = input;
            self
        }
        /// Consumes the builder and constructs a [`QueueSummary`](crate::model::QueueSummary)
        pub fn build(self) -> crate::model::QueueSummary {
            crate::model::QueueSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                queue_type: self.queue_type,
            }
        }
    }
}
impl QueueSummary {
    /// Creates a new builder-style object to manufacture [`QueueSummary`](crate::model::QueueSummary)
    pub fn builder() -> crate::model::queue_summary::Builder {
        crate::model::queue_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QueueType {
    #[allow(missing_docs)] // documentation missing in model
    Agent,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QueueType {
    fn from(s: &str) -> Self {
        match s {
            "AGENT" => QueueType::Agent,
            "STANDARD" => QueueType::Standard,
            other => QueueType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QueueType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QueueType::from(s))
    }
}
impl QueueType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QueueType::Agent => "AGENT",
            QueueType::Standard => "STANDARD",
            QueueType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AGENT", "STANDARD"]
    }
}
impl AsRef<str> for QueueType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the prompt.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PromptSummary {
    /// <p>The identifier of the prompt.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the prompt.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the prompt.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PromptSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PromptSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`PromptSummary`](crate::model::PromptSummary)
pub mod prompt_summary {
    /// A builder for [`PromptSummary`](crate::model::PromptSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the prompt.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the prompt.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the prompt.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the prompt.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the prompt.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the prompt.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`PromptSummary`](crate::model::PromptSummary)
        pub fn build(self) -> crate::model::PromptSummary {
            crate::model::PromptSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl PromptSummary {
    /// Creates a new builder-style object to manufacture [`PromptSummary`](crate::model::PromptSummary)
    pub fn builder() -> crate::model::prompt_summary::Builder {
        crate::model::prompt_summary::Builder::default()
    }
}

/// <p>Contains summary information about a phone number for a contact center.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumberSummary {
    /// <p>The identifier of the phone number.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the phone number.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The phone number.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The type of phone number.</p>
    pub phone_number_type: std::option::Option<crate::model::PhoneNumberType>,
    /// <p>The ISO country code.</p>
    pub phone_number_country_code: std::option::Option<crate::model::PhoneNumberCountryCode>,
}
impl std::fmt::Debug for PhoneNumberSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumberSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("phone_number_type", &self.phone_number_type);
        formatter.field("phone_number_country_code", &self.phone_number_country_code);
        formatter.finish()
    }
}
/// See [`PhoneNumberSummary`](crate::model::PhoneNumberSummary)
pub mod phone_number_summary {
    /// A builder for [`PhoneNumberSummary`](crate::model::PhoneNumberSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) phone_number_type: std::option::Option<crate::model::PhoneNumberType>,
        pub(crate) phone_number_country_code:
            std::option::Option<crate::model::PhoneNumberCountryCode>,
    }
    impl Builder {
        /// <p>The identifier of the phone number.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the phone number.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the phone number.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the phone number.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The phone number.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The type of phone number.</p>
        pub fn phone_number_type(mut self, input: crate::model::PhoneNumberType) -> Self {
            self.phone_number_type = Some(input);
            self
        }
        /// <p>The type of phone number.</p>
        pub fn set_phone_number_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberType>,
        ) -> Self {
            self.phone_number_type = input;
            self
        }
        /// <p>The ISO country code.</p>
        pub fn phone_number_country_code(
            mut self,
            input: crate::model::PhoneNumberCountryCode,
        ) -> Self {
            self.phone_number_country_code = Some(input);
            self
        }
        /// <p>The ISO country code.</p>
        pub fn set_phone_number_country_code(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberCountryCode>,
        ) -> Self {
            self.phone_number_country_code = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumberSummary`](crate::model::PhoneNumberSummary)
        pub fn build(self) -> crate::model::PhoneNumberSummary {
            crate::model::PhoneNumberSummary {
                id: self.id,
                arn: self.arn,
                phone_number: self.phone_number,
                phone_number_type: self.phone_number_type,
                phone_number_country_code: self.phone_number_country_code,
            }
        }
    }
}
impl PhoneNumberSummary {
    /// Creates a new builder-style object to manufacture [`PhoneNumberSummary`](crate::model::PhoneNumberSummary)
    pub fn builder() -> crate::model::phone_number_summary::Builder {
        crate::model::phone_number_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhoneNumberCountryCode {
    #[allow(missing_docs)] // documentation missing in model
    Ad,
    #[allow(missing_docs)] // documentation missing in model
    Ae,
    #[allow(missing_docs)] // documentation missing in model
    Af,
    #[allow(missing_docs)] // documentation missing in model
    Ag,
    #[allow(missing_docs)] // documentation missing in model
    Ai,
    #[allow(missing_docs)] // documentation missing in model
    Al,
    #[allow(missing_docs)] // documentation missing in model
    Am,
    #[allow(missing_docs)] // documentation missing in model
    An,
    #[allow(missing_docs)] // documentation missing in model
    Ao,
    #[allow(missing_docs)] // documentation missing in model
    Aq,
    #[allow(missing_docs)] // documentation missing in model
    Ar,
    #[allow(missing_docs)] // documentation missing in model
    As,
    #[allow(missing_docs)] // documentation missing in model
    At,
    #[allow(missing_docs)] // documentation missing in model
    Au,
    #[allow(missing_docs)] // documentation missing in model
    Aw,
    #[allow(missing_docs)] // documentation missing in model
    Az,
    #[allow(missing_docs)] // documentation missing in model
    Ba,
    #[allow(missing_docs)] // documentation missing in model
    Bb,
    #[allow(missing_docs)] // documentation missing in model
    Bd,
    #[allow(missing_docs)] // documentation missing in model
    Be,
    #[allow(missing_docs)] // documentation missing in model
    Bf,
    #[allow(missing_docs)] // documentation missing in model
    Bg,
    #[allow(missing_docs)] // documentation missing in model
    Bh,
    #[allow(missing_docs)] // documentation missing in model
    Bi,
    #[allow(missing_docs)] // documentation missing in model
    Bj,
    #[allow(missing_docs)] // documentation missing in model
    Bl,
    #[allow(missing_docs)] // documentation missing in model
    Bm,
    #[allow(missing_docs)] // documentation missing in model
    Bn,
    #[allow(missing_docs)] // documentation missing in model
    Bo,
    #[allow(missing_docs)] // documentation missing in model
    Br,
    #[allow(missing_docs)] // documentation missing in model
    Bs,
    #[allow(missing_docs)] // documentation missing in model
    Bt,
    #[allow(missing_docs)] // documentation missing in model
    Bw,
    #[allow(missing_docs)] // documentation missing in model
    By,
    #[allow(missing_docs)] // documentation missing in model
    Bz,
    #[allow(missing_docs)] // documentation missing in model
    Ca,
    #[allow(missing_docs)] // documentation missing in model
    Cc,
    #[allow(missing_docs)] // documentation missing in model
    Cd,
    #[allow(missing_docs)] // documentation missing in model
    Cf,
    #[allow(missing_docs)] // documentation missing in model
    Cg,
    #[allow(missing_docs)] // documentation missing in model
    Ch,
    #[allow(missing_docs)] // documentation missing in model
    Ci,
    #[allow(missing_docs)] // documentation missing in model
    Ck,
    #[allow(missing_docs)] // documentation missing in model
    Cl,
    #[allow(missing_docs)] // documentation missing in model
    Cm,
    #[allow(missing_docs)] // documentation missing in model
    Cn,
    #[allow(missing_docs)] // documentation missing in model
    Co,
    #[allow(missing_docs)] // documentation missing in model
    Cr,
    #[allow(missing_docs)] // documentation missing in model
    Cu,
    #[allow(missing_docs)] // documentation missing in model
    Cv,
    #[allow(missing_docs)] // documentation missing in model
    Cw,
    #[allow(missing_docs)] // documentation missing in model
    Cx,
    #[allow(missing_docs)] // documentation missing in model
    Cy,
    #[allow(missing_docs)] // documentation missing in model
    Cz,
    #[allow(missing_docs)] // documentation missing in model
    De,
    #[allow(missing_docs)] // documentation missing in model
    Dj,
    #[allow(missing_docs)] // documentation missing in model
    Dk,
    #[allow(missing_docs)] // documentation missing in model
    Dm,
    #[allow(missing_docs)] // documentation missing in model
    Do,
    #[allow(missing_docs)] // documentation missing in model
    Dz,
    #[allow(missing_docs)] // documentation missing in model
    Ec,
    #[allow(missing_docs)] // documentation missing in model
    Ee,
    #[allow(missing_docs)] // documentation missing in model
    Eg,
    #[allow(missing_docs)] // documentation missing in model
    Eh,
    #[allow(missing_docs)] // documentation missing in model
    Er,
    #[allow(missing_docs)] // documentation missing in model
    Es,
    #[allow(missing_docs)] // documentation missing in model
    Et,
    #[allow(missing_docs)] // documentation missing in model
    Fi,
    #[allow(missing_docs)] // documentation missing in model
    Fj,
    #[allow(missing_docs)] // documentation missing in model
    Fk,
    #[allow(missing_docs)] // documentation missing in model
    Fm,
    #[allow(missing_docs)] // documentation missing in model
    Fo,
    #[allow(missing_docs)] // documentation missing in model
    Fr,
    #[allow(missing_docs)] // documentation missing in model
    Ga,
    #[allow(missing_docs)] // documentation missing in model
    Gb,
    #[allow(missing_docs)] // documentation missing in model
    Gd,
    #[allow(missing_docs)] // documentation missing in model
    Ge,
    #[allow(missing_docs)] // documentation missing in model
    Gg,
    #[allow(missing_docs)] // documentation missing in model
    Gh,
    #[allow(missing_docs)] // documentation missing in model
    Gi,
    #[allow(missing_docs)] // documentation missing in model
    Gl,
    #[allow(missing_docs)] // documentation missing in model
    Gm,
    #[allow(missing_docs)] // documentation missing in model
    Gn,
    #[allow(missing_docs)] // documentation missing in model
    Gq,
    #[allow(missing_docs)] // documentation missing in model
    Gr,
    #[allow(missing_docs)] // documentation missing in model
    Gt,
    #[allow(missing_docs)] // documentation missing in model
    Gu,
    #[allow(missing_docs)] // documentation missing in model
    Gw,
    #[allow(missing_docs)] // documentation missing in model
    Gy,
    #[allow(missing_docs)] // documentation missing in model
    Hk,
    #[allow(missing_docs)] // documentation missing in model
    Hn,
    #[allow(missing_docs)] // documentation missing in model
    Hr,
    #[allow(missing_docs)] // documentation missing in model
    Ht,
    #[allow(missing_docs)] // documentation missing in model
    Hu,
    #[allow(missing_docs)] // documentation missing in model
    Id,
    #[allow(missing_docs)] // documentation missing in model
    Ie,
    #[allow(missing_docs)] // documentation missing in model
    Il,
    #[allow(missing_docs)] // documentation missing in model
    Im,
    #[allow(missing_docs)] // documentation missing in model
    In,
    #[allow(missing_docs)] // documentation missing in model
    Io,
    #[allow(missing_docs)] // documentation missing in model
    Iq,
    #[allow(missing_docs)] // documentation missing in model
    Ir,
    #[allow(missing_docs)] // documentation missing in model
    Is,
    #[allow(missing_docs)] // documentation missing in model
    It,
    #[allow(missing_docs)] // documentation missing in model
    Je,
    #[allow(missing_docs)] // documentation missing in model
    Jm,
    #[allow(missing_docs)] // documentation missing in model
    Jo,
    #[allow(missing_docs)] // documentation missing in model
    Jp,
    #[allow(missing_docs)] // documentation missing in model
    Ke,
    #[allow(missing_docs)] // documentation missing in model
    Kg,
    #[allow(missing_docs)] // documentation missing in model
    Kh,
    #[allow(missing_docs)] // documentation missing in model
    Ki,
    #[allow(missing_docs)] // documentation missing in model
    Km,
    #[allow(missing_docs)] // documentation missing in model
    Kn,
    #[allow(missing_docs)] // documentation missing in model
    Kp,
    #[allow(missing_docs)] // documentation missing in model
    Kr,
    #[allow(missing_docs)] // documentation missing in model
    Kw,
    #[allow(missing_docs)] // documentation missing in model
    Ky,
    #[allow(missing_docs)] // documentation missing in model
    Kz,
    #[allow(missing_docs)] // documentation missing in model
    La,
    #[allow(missing_docs)] // documentation missing in model
    Lb,
    #[allow(missing_docs)] // documentation missing in model
    Lc,
    #[allow(missing_docs)] // documentation missing in model
    Li,
    #[allow(missing_docs)] // documentation missing in model
    Lk,
    #[allow(missing_docs)] // documentation missing in model
    Lr,
    #[allow(missing_docs)] // documentation missing in model
    Ls,
    #[allow(missing_docs)] // documentation missing in model
    Lt,
    #[allow(missing_docs)] // documentation missing in model
    Lu,
    #[allow(missing_docs)] // documentation missing in model
    Lv,
    #[allow(missing_docs)] // documentation missing in model
    Ly,
    #[allow(missing_docs)] // documentation missing in model
    Ma,
    #[allow(missing_docs)] // documentation missing in model
    Mc,
    #[allow(missing_docs)] // documentation missing in model
    Md,
    #[allow(missing_docs)] // documentation missing in model
    Me,
    #[allow(missing_docs)] // documentation missing in model
    Mf,
    #[allow(missing_docs)] // documentation missing in model
    Mg,
    #[allow(missing_docs)] // documentation missing in model
    Mh,
    #[allow(missing_docs)] // documentation missing in model
    Mk,
    #[allow(missing_docs)] // documentation missing in model
    Ml,
    #[allow(missing_docs)] // documentation missing in model
    Mm,
    #[allow(missing_docs)] // documentation missing in model
    Mn,
    #[allow(missing_docs)] // documentation missing in model
    Mo,
    #[allow(missing_docs)] // documentation missing in model
    Mp,
    #[allow(missing_docs)] // documentation missing in model
    Mr,
    #[allow(missing_docs)] // documentation missing in model
    Ms,
    #[allow(missing_docs)] // documentation missing in model
    Mt,
    #[allow(missing_docs)] // documentation missing in model
    Mu,
    #[allow(missing_docs)] // documentation missing in model
    Mv,
    #[allow(missing_docs)] // documentation missing in model
    Mw,
    #[allow(missing_docs)] // documentation missing in model
    Mx,
    #[allow(missing_docs)] // documentation missing in model
    My,
    #[allow(missing_docs)] // documentation missing in model
    Mz,
    #[allow(missing_docs)] // documentation missing in model
    Na,
    #[allow(missing_docs)] // documentation missing in model
    Nc,
    #[allow(missing_docs)] // documentation missing in model
    Ne,
    #[allow(missing_docs)] // documentation missing in model
    Ng,
    #[allow(missing_docs)] // documentation missing in model
    Ni,
    #[allow(missing_docs)] // documentation missing in model
    Nl,
    #[allow(missing_docs)] // documentation missing in model
    No,
    #[allow(missing_docs)] // documentation missing in model
    Np,
    #[allow(missing_docs)] // documentation missing in model
    Nr,
    #[allow(missing_docs)] // documentation missing in model
    Nu,
    #[allow(missing_docs)] // documentation missing in model
    Nz,
    #[allow(missing_docs)] // documentation missing in model
    Om,
    #[allow(missing_docs)] // documentation missing in model
    Pa,
    #[allow(missing_docs)] // documentation missing in model
    Pe,
    #[allow(missing_docs)] // documentation missing in model
    Pf,
    #[allow(missing_docs)] // documentation missing in model
    Pg,
    #[allow(missing_docs)] // documentation missing in model
    Ph,
    #[allow(missing_docs)] // documentation missing in model
    Pk,
    #[allow(missing_docs)] // documentation missing in model
    Pl,
    #[allow(missing_docs)] // documentation missing in model
    Pm,
    #[allow(missing_docs)] // documentation missing in model
    Pn,
    #[allow(missing_docs)] // documentation missing in model
    Pr,
    #[allow(missing_docs)] // documentation missing in model
    Pt,
    #[allow(missing_docs)] // documentation missing in model
    Pw,
    #[allow(missing_docs)] // documentation missing in model
    Py,
    #[allow(missing_docs)] // documentation missing in model
    Qa,
    #[allow(missing_docs)] // documentation missing in model
    Re,
    #[allow(missing_docs)] // documentation missing in model
    Ro,
    #[allow(missing_docs)] // documentation missing in model
    Rs,
    #[allow(missing_docs)] // documentation missing in model
    Ru,
    #[allow(missing_docs)] // documentation missing in model
    Rw,
    #[allow(missing_docs)] // documentation missing in model
    Sa,
    #[allow(missing_docs)] // documentation missing in model
    Sb,
    #[allow(missing_docs)] // documentation missing in model
    Sc,
    #[allow(missing_docs)] // documentation missing in model
    Sd,
    #[allow(missing_docs)] // documentation missing in model
    Se,
    #[allow(missing_docs)] // documentation missing in model
    Sg,
    #[allow(missing_docs)] // documentation missing in model
    Sh,
    #[allow(missing_docs)] // documentation missing in model
    Si,
    #[allow(missing_docs)] // documentation missing in model
    Sj,
    #[allow(missing_docs)] // documentation missing in model
    Sk,
    #[allow(missing_docs)] // documentation missing in model
    Sl,
    #[allow(missing_docs)] // documentation missing in model
    Sm,
    #[allow(missing_docs)] // documentation missing in model
    Sn,
    #[allow(missing_docs)] // documentation missing in model
    So,
    #[allow(missing_docs)] // documentation missing in model
    Sr,
    #[allow(missing_docs)] // documentation missing in model
    St,
    #[allow(missing_docs)] // documentation missing in model
    Sv,
    #[allow(missing_docs)] // documentation missing in model
    Sx,
    #[allow(missing_docs)] // documentation missing in model
    Sy,
    #[allow(missing_docs)] // documentation missing in model
    Sz,
    #[allow(missing_docs)] // documentation missing in model
    Tc,
    #[allow(missing_docs)] // documentation missing in model
    Td,
    #[allow(missing_docs)] // documentation missing in model
    Tg,
    #[allow(missing_docs)] // documentation missing in model
    Th,
    #[allow(missing_docs)] // documentation missing in model
    Tj,
    #[allow(missing_docs)] // documentation missing in model
    Tk,
    #[allow(missing_docs)] // documentation missing in model
    Tl,
    #[allow(missing_docs)] // documentation missing in model
    Tm,
    #[allow(missing_docs)] // documentation missing in model
    Tn,
    #[allow(missing_docs)] // documentation missing in model
    To,
    #[allow(missing_docs)] // documentation missing in model
    Tr,
    #[allow(missing_docs)] // documentation missing in model
    Tt,
    #[allow(missing_docs)] // documentation missing in model
    Tv,
    #[allow(missing_docs)] // documentation missing in model
    Tw,
    #[allow(missing_docs)] // documentation missing in model
    Tz,
    #[allow(missing_docs)] // documentation missing in model
    Ua,
    #[allow(missing_docs)] // documentation missing in model
    Ug,
    #[allow(missing_docs)] // documentation missing in model
    Us,
    #[allow(missing_docs)] // documentation missing in model
    Uy,
    #[allow(missing_docs)] // documentation missing in model
    Uz,
    #[allow(missing_docs)] // documentation missing in model
    Va,
    #[allow(missing_docs)] // documentation missing in model
    Vc,
    #[allow(missing_docs)] // documentation missing in model
    Ve,
    #[allow(missing_docs)] // documentation missing in model
    Vg,
    #[allow(missing_docs)] // documentation missing in model
    Vi,
    #[allow(missing_docs)] // documentation missing in model
    Vn,
    #[allow(missing_docs)] // documentation missing in model
    Vu,
    #[allow(missing_docs)] // documentation missing in model
    Wf,
    #[allow(missing_docs)] // documentation missing in model
    Ws,
    #[allow(missing_docs)] // documentation missing in model
    Ye,
    #[allow(missing_docs)] // documentation missing in model
    Yt,
    #[allow(missing_docs)] // documentation missing in model
    Za,
    #[allow(missing_docs)] // documentation missing in model
    Zm,
    #[allow(missing_docs)] // documentation missing in model
    Zw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhoneNumberCountryCode {
    fn from(s: &str) -> Self {
        match s {
            "AD" => PhoneNumberCountryCode::Ad,
            "AE" => PhoneNumberCountryCode::Ae,
            "AF" => PhoneNumberCountryCode::Af,
            "AG" => PhoneNumberCountryCode::Ag,
            "AI" => PhoneNumberCountryCode::Ai,
            "AL" => PhoneNumberCountryCode::Al,
            "AM" => PhoneNumberCountryCode::Am,
            "AN" => PhoneNumberCountryCode::An,
            "AO" => PhoneNumberCountryCode::Ao,
            "AQ" => PhoneNumberCountryCode::Aq,
            "AR" => PhoneNumberCountryCode::Ar,
            "AS" => PhoneNumberCountryCode::As,
            "AT" => PhoneNumberCountryCode::At,
            "AU" => PhoneNumberCountryCode::Au,
            "AW" => PhoneNumberCountryCode::Aw,
            "AZ" => PhoneNumberCountryCode::Az,
            "BA" => PhoneNumberCountryCode::Ba,
            "BB" => PhoneNumberCountryCode::Bb,
            "BD" => PhoneNumberCountryCode::Bd,
            "BE" => PhoneNumberCountryCode::Be,
            "BF" => PhoneNumberCountryCode::Bf,
            "BG" => PhoneNumberCountryCode::Bg,
            "BH" => PhoneNumberCountryCode::Bh,
            "BI" => PhoneNumberCountryCode::Bi,
            "BJ" => PhoneNumberCountryCode::Bj,
            "BL" => PhoneNumberCountryCode::Bl,
            "BM" => PhoneNumberCountryCode::Bm,
            "BN" => PhoneNumberCountryCode::Bn,
            "BO" => PhoneNumberCountryCode::Bo,
            "BR" => PhoneNumberCountryCode::Br,
            "BS" => PhoneNumberCountryCode::Bs,
            "BT" => PhoneNumberCountryCode::Bt,
            "BW" => PhoneNumberCountryCode::Bw,
            "BY" => PhoneNumberCountryCode::By,
            "BZ" => PhoneNumberCountryCode::Bz,
            "CA" => PhoneNumberCountryCode::Ca,
            "CC" => PhoneNumberCountryCode::Cc,
            "CD" => PhoneNumberCountryCode::Cd,
            "CF" => PhoneNumberCountryCode::Cf,
            "CG" => PhoneNumberCountryCode::Cg,
            "CH" => PhoneNumberCountryCode::Ch,
            "CI" => PhoneNumberCountryCode::Ci,
            "CK" => PhoneNumberCountryCode::Ck,
            "CL" => PhoneNumberCountryCode::Cl,
            "CM" => PhoneNumberCountryCode::Cm,
            "CN" => PhoneNumberCountryCode::Cn,
            "CO" => PhoneNumberCountryCode::Co,
            "CR" => PhoneNumberCountryCode::Cr,
            "CU" => PhoneNumberCountryCode::Cu,
            "CV" => PhoneNumberCountryCode::Cv,
            "CW" => PhoneNumberCountryCode::Cw,
            "CX" => PhoneNumberCountryCode::Cx,
            "CY" => PhoneNumberCountryCode::Cy,
            "CZ" => PhoneNumberCountryCode::Cz,
            "DE" => PhoneNumberCountryCode::De,
            "DJ" => PhoneNumberCountryCode::Dj,
            "DK" => PhoneNumberCountryCode::Dk,
            "DM" => PhoneNumberCountryCode::Dm,
            "DO" => PhoneNumberCountryCode::Do,
            "DZ" => PhoneNumberCountryCode::Dz,
            "EC" => PhoneNumberCountryCode::Ec,
            "EE" => PhoneNumberCountryCode::Ee,
            "EG" => PhoneNumberCountryCode::Eg,
            "EH" => PhoneNumberCountryCode::Eh,
            "ER" => PhoneNumberCountryCode::Er,
            "ES" => PhoneNumberCountryCode::Es,
            "ET" => PhoneNumberCountryCode::Et,
            "FI" => PhoneNumberCountryCode::Fi,
            "FJ" => PhoneNumberCountryCode::Fj,
            "FK" => PhoneNumberCountryCode::Fk,
            "FM" => PhoneNumberCountryCode::Fm,
            "FO" => PhoneNumberCountryCode::Fo,
            "FR" => PhoneNumberCountryCode::Fr,
            "GA" => PhoneNumberCountryCode::Ga,
            "GB" => PhoneNumberCountryCode::Gb,
            "GD" => PhoneNumberCountryCode::Gd,
            "GE" => PhoneNumberCountryCode::Ge,
            "GG" => PhoneNumberCountryCode::Gg,
            "GH" => PhoneNumberCountryCode::Gh,
            "GI" => PhoneNumberCountryCode::Gi,
            "GL" => PhoneNumberCountryCode::Gl,
            "GM" => PhoneNumberCountryCode::Gm,
            "GN" => PhoneNumberCountryCode::Gn,
            "GQ" => PhoneNumberCountryCode::Gq,
            "GR" => PhoneNumberCountryCode::Gr,
            "GT" => PhoneNumberCountryCode::Gt,
            "GU" => PhoneNumberCountryCode::Gu,
            "GW" => PhoneNumberCountryCode::Gw,
            "GY" => PhoneNumberCountryCode::Gy,
            "HK" => PhoneNumberCountryCode::Hk,
            "HN" => PhoneNumberCountryCode::Hn,
            "HR" => PhoneNumberCountryCode::Hr,
            "HT" => PhoneNumberCountryCode::Ht,
            "HU" => PhoneNumberCountryCode::Hu,
            "ID" => PhoneNumberCountryCode::Id,
            "IE" => PhoneNumberCountryCode::Ie,
            "IL" => PhoneNumberCountryCode::Il,
            "IM" => PhoneNumberCountryCode::Im,
            "IN" => PhoneNumberCountryCode::In,
            "IO" => PhoneNumberCountryCode::Io,
            "IQ" => PhoneNumberCountryCode::Iq,
            "IR" => PhoneNumberCountryCode::Ir,
            "IS" => PhoneNumberCountryCode::Is,
            "IT" => PhoneNumberCountryCode::It,
            "JE" => PhoneNumberCountryCode::Je,
            "JM" => PhoneNumberCountryCode::Jm,
            "JO" => PhoneNumberCountryCode::Jo,
            "JP" => PhoneNumberCountryCode::Jp,
            "KE" => PhoneNumberCountryCode::Ke,
            "KG" => PhoneNumberCountryCode::Kg,
            "KH" => PhoneNumberCountryCode::Kh,
            "KI" => PhoneNumberCountryCode::Ki,
            "KM" => PhoneNumberCountryCode::Km,
            "KN" => PhoneNumberCountryCode::Kn,
            "KP" => PhoneNumberCountryCode::Kp,
            "KR" => PhoneNumberCountryCode::Kr,
            "KW" => PhoneNumberCountryCode::Kw,
            "KY" => PhoneNumberCountryCode::Ky,
            "KZ" => PhoneNumberCountryCode::Kz,
            "LA" => PhoneNumberCountryCode::La,
            "LB" => PhoneNumberCountryCode::Lb,
            "LC" => PhoneNumberCountryCode::Lc,
            "LI" => PhoneNumberCountryCode::Li,
            "LK" => PhoneNumberCountryCode::Lk,
            "LR" => PhoneNumberCountryCode::Lr,
            "LS" => PhoneNumberCountryCode::Ls,
            "LT" => PhoneNumberCountryCode::Lt,
            "LU" => PhoneNumberCountryCode::Lu,
            "LV" => PhoneNumberCountryCode::Lv,
            "LY" => PhoneNumberCountryCode::Ly,
            "MA" => PhoneNumberCountryCode::Ma,
            "MC" => PhoneNumberCountryCode::Mc,
            "MD" => PhoneNumberCountryCode::Md,
            "ME" => PhoneNumberCountryCode::Me,
            "MF" => PhoneNumberCountryCode::Mf,
            "MG" => PhoneNumberCountryCode::Mg,
            "MH" => PhoneNumberCountryCode::Mh,
            "MK" => PhoneNumberCountryCode::Mk,
            "ML" => PhoneNumberCountryCode::Ml,
            "MM" => PhoneNumberCountryCode::Mm,
            "MN" => PhoneNumberCountryCode::Mn,
            "MO" => PhoneNumberCountryCode::Mo,
            "MP" => PhoneNumberCountryCode::Mp,
            "MR" => PhoneNumberCountryCode::Mr,
            "MS" => PhoneNumberCountryCode::Ms,
            "MT" => PhoneNumberCountryCode::Mt,
            "MU" => PhoneNumberCountryCode::Mu,
            "MV" => PhoneNumberCountryCode::Mv,
            "MW" => PhoneNumberCountryCode::Mw,
            "MX" => PhoneNumberCountryCode::Mx,
            "MY" => PhoneNumberCountryCode::My,
            "MZ" => PhoneNumberCountryCode::Mz,
            "NA" => PhoneNumberCountryCode::Na,
            "NC" => PhoneNumberCountryCode::Nc,
            "NE" => PhoneNumberCountryCode::Ne,
            "NG" => PhoneNumberCountryCode::Ng,
            "NI" => PhoneNumberCountryCode::Ni,
            "NL" => PhoneNumberCountryCode::Nl,
            "NO" => PhoneNumberCountryCode::No,
            "NP" => PhoneNumberCountryCode::Np,
            "NR" => PhoneNumberCountryCode::Nr,
            "NU" => PhoneNumberCountryCode::Nu,
            "NZ" => PhoneNumberCountryCode::Nz,
            "OM" => PhoneNumberCountryCode::Om,
            "PA" => PhoneNumberCountryCode::Pa,
            "PE" => PhoneNumberCountryCode::Pe,
            "PF" => PhoneNumberCountryCode::Pf,
            "PG" => PhoneNumberCountryCode::Pg,
            "PH" => PhoneNumberCountryCode::Ph,
            "PK" => PhoneNumberCountryCode::Pk,
            "PL" => PhoneNumberCountryCode::Pl,
            "PM" => PhoneNumberCountryCode::Pm,
            "PN" => PhoneNumberCountryCode::Pn,
            "PR" => PhoneNumberCountryCode::Pr,
            "PT" => PhoneNumberCountryCode::Pt,
            "PW" => PhoneNumberCountryCode::Pw,
            "PY" => PhoneNumberCountryCode::Py,
            "QA" => PhoneNumberCountryCode::Qa,
            "RE" => PhoneNumberCountryCode::Re,
            "RO" => PhoneNumberCountryCode::Ro,
            "RS" => PhoneNumberCountryCode::Rs,
            "RU" => PhoneNumberCountryCode::Ru,
            "RW" => PhoneNumberCountryCode::Rw,
            "SA" => PhoneNumberCountryCode::Sa,
            "SB" => PhoneNumberCountryCode::Sb,
            "SC" => PhoneNumberCountryCode::Sc,
            "SD" => PhoneNumberCountryCode::Sd,
            "SE" => PhoneNumberCountryCode::Se,
            "SG" => PhoneNumberCountryCode::Sg,
            "SH" => PhoneNumberCountryCode::Sh,
            "SI" => PhoneNumberCountryCode::Si,
            "SJ" => PhoneNumberCountryCode::Sj,
            "SK" => PhoneNumberCountryCode::Sk,
            "SL" => PhoneNumberCountryCode::Sl,
            "SM" => PhoneNumberCountryCode::Sm,
            "SN" => PhoneNumberCountryCode::Sn,
            "SO" => PhoneNumberCountryCode::So,
            "SR" => PhoneNumberCountryCode::Sr,
            "ST" => PhoneNumberCountryCode::St,
            "SV" => PhoneNumberCountryCode::Sv,
            "SX" => PhoneNumberCountryCode::Sx,
            "SY" => PhoneNumberCountryCode::Sy,
            "SZ" => PhoneNumberCountryCode::Sz,
            "TC" => PhoneNumberCountryCode::Tc,
            "TD" => PhoneNumberCountryCode::Td,
            "TG" => PhoneNumberCountryCode::Tg,
            "TH" => PhoneNumberCountryCode::Th,
            "TJ" => PhoneNumberCountryCode::Tj,
            "TK" => PhoneNumberCountryCode::Tk,
            "TL" => PhoneNumberCountryCode::Tl,
            "TM" => PhoneNumberCountryCode::Tm,
            "TN" => PhoneNumberCountryCode::Tn,
            "TO" => PhoneNumberCountryCode::To,
            "TR" => PhoneNumberCountryCode::Tr,
            "TT" => PhoneNumberCountryCode::Tt,
            "TV" => PhoneNumberCountryCode::Tv,
            "TW" => PhoneNumberCountryCode::Tw,
            "TZ" => PhoneNumberCountryCode::Tz,
            "UA" => PhoneNumberCountryCode::Ua,
            "UG" => PhoneNumberCountryCode::Ug,
            "US" => PhoneNumberCountryCode::Us,
            "UY" => PhoneNumberCountryCode::Uy,
            "UZ" => PhoneNumberCountryCode::Uz,
            "VA" => PhoneNumberCountryCode::Va,
            "VC" => PhoneNumberCountryCode::Vc,
            "VE" => PhoneNumberCountryCode::Ve,
            "VG" => PhoneNumberCountryCode::Vg,
            "VI" => PhoneNumberCountryCode::Vi,
            "VN" => PhoneNumberCountryCode::Vn,
            "VU" => PhoneNumberCountryCode::Vu,
            "WF" => PhoneNumberCountryCode::Wf,
            "WS" => PhoneNumberCountryCode::Ws,
            "YE" => PhoneNumberCountryCode::Ye,
            "YT" => PhoneNumberCountryCode::Yt,
            "ZA" => PhoneNumberCountryCode::Za,
            "ZM" => PhoneNumberCountryCode::Zm,
            "ZW" => PhoneNumberCountryCode::Zw,
            other => PhoneNumberCountryCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhoneNumberCountryCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhoneNumberCountryCode::from(s))
    }
}
impl PhoneNumberCountryCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhoneNumberCountryCode::Ad => "AD",
            PhoneNumberCountryCode::Ae => "AE",
            PhoneNumberCountryCode::Af => "AF",
            PhoneNumberCountryCode::Ag => "AG",
            PhoneNumberCountryCode::Ai => "AI",
            PhoneNumberCountryCode::Al => "AL",
            PhoneNumberCountryCode::Am => "AM",
            PhoneNumberCountryCode::An => "AN",
            PhoneNumberCountryCode::Ao => "AO",
            PhoneNumberCountryCode::Aq => "AQ",
            PhoneNumberCountryCode::Ar => "AR",
            PhoneNumberCountryCode::As => "AS",
            PhoneNumberCountryCode::At => "AT",
            PhoneNumberCountryCode::Au => "AU",
            PhoneNumberCountryCode::Aw => "AW",
            PhoneNumberCountryCode::Az => "AZ",
            PhoneNumberCountryCode::Ba => "BA",
            PhoneNumberCountryCode::Bb => "BB",
            PhoneNumberCountryCode::Bd => "BD",
            PhoneNumberCountryCode::Be => "BE",
            PhoneNumberCountryCode::Bf => "BF",
            PhoneNumberCountryCode::Bg => "BG",
            PhoneNumberCountryCode::Bh => "BH",
            PhoneNumberCountryCode::Bi => "BI",
            PhoneNumberCountryCode::Bj => "BJ",
            PhoneNumberCountryCode::Bl => "BL",
            PhoneNumberCountryCode::Bm => "BM",
            PhoneNumberCountryCode::Bn => "BN",
            PhoneNumberCountryCode::Bo => "BO",
            PhoneNumberCountryCode::Br => "BR",
            PhoneNumberCountryCode::Bs => "BS",
            PhoneNumberCountryCode::Bt => "BT",
            PhoneNumberCountryCode::Bw => "BW",
            PhoneNumberCountryCode::By => "BY",
            PhoneNumberCountryCode::Bz => "BZ",
            PhoneNumberCountryCode::Ca => "CA",
            PhoneNumberCountryCode::Cc => "CC",
            PhoneNumberCountryCode::Cd => "CD",
            PhoneNumberCountryCode::Cf => "CF",
            PhoneNumberCountryCode::Cg => "CG",
            PhoneNumberCountryCode::Ch => "CH",
            PhoneNumberCountryCode::Ci => "CI",
            PhoneNumberCountryCode::Ck => "CK",
            PhoneNumberCountryCode::Cl => "CL",
            PhoneNumberCountryCode::Cm => "CM",
            PhoneNumberCountryCode::Cn => "CN",
            PhoneNumberCountryCode::Co => "CO",
            PhoneNumberCountryCode::Cr => "CR",
            PhoneNumberCountryCode::Cu => "CU",
            PhoneNumberCountryCode::Cv => "CV",
            PhoneNumberCountryCode::Cw => "CW",
            PhoneNumberCountryCode::Cx => "CX",
            PhoneNumberCountryCode::Cy => "CY",
            PhoneNumberCountryCode::Cz => "CZ",
            PhoneNumberCountryCode::De => "DE",
            PhoneNumberCountryCode::Dj => "DJ",
            PhoneNumberCountryCode::Dk => "DK",
            PhoneNumberCountryCode::Dm => "DM",
            PhoneNumberCountryCode::Do => "DO",
            PhoneNumberCountryCode::Dz => "DZ",
            PhoneNumberCountryCode::Ec => "EC",
            PhoneNumberCountryCode::Ee => "EE",
            PhoneNumberCountryCode::Eg => "EG",
            PhoneNumberCountryCode::Eh => "EH",
            PhoneNumberCountryCode::Er => "ER",
            PhoneNumberCountryCode::Es => "ES",
            PhoneNumberCountryCode::Et => "ET",
            PhoneNumberCountryCode::Fi => "FI",
            PhoneNumberCountryCode::Fj => "FJ",
            PhoneNumberCountryCode::Fk => "FK",
            PhoneNumberCountryCode::Fm => "FM",
            PhoneNumberCountryCode::Fo => "FO",
            PhoneNumberCountryCode::Fr => "FR",
            PhoneNumberCountryCode::Ga => "GA",
            PhoneNumberCountryCode::Gb => "GB",
            PhoneNumberCountryCode::Gd => "GD",
            PhoneNumberCountryCode::Ge => "GE",
            PhoneNumberCountryCode::Gg => "GG",
            PhoneNumberCountryCode::Gh => "GH",
            PhoneNumberCountryCode::Gi => "GI",
            PhoneNumberCountryCode::Gl => "GL",
            PhoneNumberCountryCode::Gm => "GM",
            PhoneNumberCountryCode::Gn => "GN",
            PhoneNumberCountryCode::Gq => "GQ",
            PhoneNumberCountryCode::Gr => "GR",
            PhoneNumberCountryCode::Gt => "GT",
            PhoneNumberCountryCode::Gu => "GU",
            PhoneNumberCountryCode::Gw => "GW",
            PhoneNumberCountryCode::Gy => "GY",
            PhoneNumberCountryCode::Hk => "HK",
            PhoneNumberCountryCode::Hn => "HN",
            PhoneNumberCountryCode::Hr => "HR",
            PhoneNumberCountryCode::Ht => "HT",
            PhoneNumberCountryCode::Hu => "HU",
            PhoneNumberCountryCode::Id => "ID",
            PhoneNumberCountryCode::Ie => "IE",
            PhoneNumberCountryCode::Il => "IL",
            PhoneNumberCountryCode::Im => "IM",
            PhoneNumberCountryCode::In => "IN",
            PhoneNumberCountryCode::Io => "IO",
            PhoneNumberCountryCode::Iq => "IQ",
            PhoneNumberCountryCode::Ir => "IR",
            PhoneNumberCountryCode::Is => "IS",
            PhoneNumberCountryCode::It => "IT",
            PhoneNumberCountryCode::Je => "JE",
            PhoneNumberCountryCode::Jm => "JM",
            PhoneNumberCountryCode::Jo => "JO",
            PhoneNumberCountryCode::Jp => "JP",
            PhoneNumberCountryCode::Ke => "KE",
            PhoneNumberCountryCode::Kg => "KG",
            PhoneNumberCountryCode::Kh => "KH",
            PhoneNumberCountryCode::Ki => "KI",
            PhoneNumberCountryCode::Km => "KM",
            PhoneNumberCountryCode::Kn => "KN",
            PhoneNumberCountryCode::Kp => "KP",
            PhoneNumberCountryCode::Kr => "KR",
            PhoneNumberCountryCode::Kw => "KW",
            PhoneNumberCountryCode::Ky => "KY",
            PhoneNumberCountryCode::Kz => "KZ",
            PhoneNumberCountryCode::La => "LA",
            PhoneNumberCountryCode::Lb => "LB",
            PhoneNumberCountryCode::Lc => "LC",
            PhoneNumberCountryCode::Li => "LI",
            PhoneNumberCountryCode::Lk => "LK",
            PhoneNumberCountryCode::Lr => "LR",
            PhoneNumberCountryCode::Ls => "LS",
            PhoneNumberCountryCode::Lt => "LT",
            PhoneNumberCountryCode::Lu => "LU",
            PhoneNumberCountryCode::Lv => "LV",
            PhoneNumberCountryCode::Ly => "LY",
            PhoneNumberCountryCode::Ma => "MA",
            PhoneNumberCountryCode::Mc => "MC",
            PhoneNumberCountryCode::Md => "MD",
            PhoneNumberCountryCode::Me => "ME",
            PhoneNumberCountryCode::Mf => "MF",
            PhoneNumberCountryCode::Mg => "MG",
            PhoneNumberCountryCode::Mh => "MH",
            PhoneNumberCountryCode::Mk => "MK",
            PhoneNumberCountryCode::Ml => "ML",
            PhoneNumberCountryCode::Mm => "MM",
            PhoneNumberCountryCode::Mn => "MN",
            PhoneNumberCountryCode::Mo => "MO",
            PhoneNumberCountryCode::Mp => "MP",
            PhoneNumberCountryCode::Mr => "MR",
            PhoneNumberCountryCode::Ms => "MS",
            PhoneNumberCountryCode::Mt => "MT",
            PhoneNumberCountryCode::Mu => "MU",
            PhoneNumberCountryCode::Mv => "MV",
            PhoneNumberCountryCode::Mw => "MW",
            PhoneNumberCountryCode::Mx => "MX",
            PhoneNumberCountryCode::My => "MY",
            PhoneNumberCountryCode::Mz => "MZ",
            PhoneNumberCountryCode::Na => "NA",
            PhoneNumberCountryCode::Nc => "NC",
            PhoneNumberCountryCode::Ne => "NE",
            PhoneNumberCountryCode::Ng => "NG",
            PhoneNumberCountryCode::Ni => "NI",
            PhoneNumberCountryCode::Nl => "NL",
            PhoneNumberCountryCode::No => "NO",
            PhoneNumberCountryCode::Np => "NP",
            PhoneNumberCountryCode::Nr => "NR",
            PhoneNumberCountryCode::Nu => "NU",
            PhoneNumberCountryCode::Nz => "NZ",
            PhoneNumberCountryCode::Om => "OM",
            PhoneNumberCountryCode::Pa => "PA",
            PhoneNumberCountryCode::Pe => "PE",
            PhoneNumberCountryCode::Pf => "PF",
            PhoneNumberCountryCode::Pg => "PG",
            PhoneNumberCountryCode::Ph => "PH",
            PhoneNumberCountryCode::Pk => "PK",
            PhoneNumberCountryCode::Pl => "PL",
            PhoneNumberCountryCode::Pm => "PM",
            PhoneNumberCountryCode::Pn => "PN",
            PhoneNumberCountryCode::Pr => "PR",
            PhoneNumberCountryCode::Pt => "PT",
            PhoneNumberCountryCode::Pw => "PW",
            PhoneNumberCountryCode::Py => "PY",
            PhoneNumberCountryCode::Qa => "QA",
            PhoneNumberCountryCode::Re => "RE",
            PhoneNumberCountryCode::Ro => "RO",
            PhoneNumberCountryCode::Rs => "RS",
            PhoneNumberCountryCode::Ru => "RU",
            PhoneNumberCountryCode::Rw => "RW",
            PhoneNumberCountryCode::Sa => "SA",
            PhoneNumberCountryCode::Sb => "SB",
            PhoneNumberCountryCode::Sc => "SC",
            PhoneNumberCountryCode::Sd => "SD",
            PhoneNumberCountryCode::Se => "SE",
            PhoneNumberCountryCode::Sg => "SG",
            PhoneNumberCountryCode::Sh => "SH",
            PhoneNumberCountryCode::Si => "SI",
            PhoneNumberCountryCode::Sj => "SJ",
            PhoneNumberCountryCode::Sk => "SK",
            PhoneNumberCountryCode::Sl => "SL",
            PhoneNumberCountryCode::Sm => "SM",
            PhoneNumberCountryCode::Sn => "SN",
            PhoneNumberCountryCode::So => "SO",
            PhoneNumberCountryCode::Sr => "SR",
            PhoneNumberCountryCode::St => "ST",
            PhoneNumberCountryCode::Sv => "SV",
            PhoneNumberCountryCode::Sx => "SX",
            PhoneNumberCountryCode::Sy => "SY",
            PhoneNumberCountryCode::Sz => "SZ",
            PhoneNumberCountryCode::Tc => "TC",
            PhoneNumberCountryCode::Td => "TD",
            PhoneNumberCountryCode::Tg => "TG",
            PhoneNumberCountryCode::Th => "TH",
            PhoneNumberCountryCode::Tj => "TJ",
            PhoneNumberCountryCode::Tk => "TK",
            PhoneNumberCountryCode::Tl => "TL",
            PhoneNumberCountryCode::Tm => "TM",
            PhoneNumberCountryCode::Tn => "TN",
            PhoneNumberCountryCode::To => "TO",
            PhoneNumberCountryCode::Tr => "TR",
            PhoneNumberCountryCode::Tt => "TT",
            PhoneNumberCountryCode::Tv => "TV",
            PhoneNumberCountryCode::Tw => "TW",
            PhoneNumberCountryCode::Tz => "TZ",
            PhoneNumberCountryCode::Ua => "UA",
            PhoneNumberCountryCode::Ug => "UG",
            PhoneNumberCountryCode::Us => "US",
            PhoneNumberCountryCode::Uy => "UY",
            PhoneNumberCountryCode::Uz => "UZ",
            PhoneNumberCountryCode::Va => "VA",
            PhoneNumberCountryCode::Vc => "VC",
            PhoneNumberCountryCode::Ve => "VE",
            PhoneNumberCountryCode::Vg => "VG",
            PhoneNumberCountryCode::Vi => "VI",
            PhoneNumberCountryCode::Vn => "VN",
            PhoneNumberCountryCode::Vu => "VU",
            PhoneNumberCountryCode::Wf => "WF",
            PhoneNumberCountryCode::Ws => "WS",
            PhoneNumberCountryCode::Ye => "YE",
            PhoneNumberCountryCode::Yt => "YT",
            PhoneNumberCountryCode::Za => "ZA",
            PhoneNumberCountryCode::Zm => "ZM",
            PhoneNumberCountryCode::Zw => "ZW",
            PhoneNumberCountryCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU",
            "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN",
            "BO", "BR", "BS", "BT", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI",
            "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CW", "CX", "CY", "CZ", "DE", "DJ",
            "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK",
            "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GG", "GH", "GI", "GL", "GM", "GN", "GQ",
            "GR", "GT", "GU", "GW", "GY", "HK", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM",
            "IN", "IO", "IQ", "IR", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI",
            "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS",
            "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MH", "MK", "ML", "MM",
            "MN", "MO", "MP", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC",
            "NE", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG",
            "PH", "PK", "PL", "PM", "PN", "PR", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU",
            "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN",
            "SO", "SR", "ST", "SV", "SX", "SY", "SZ", "TC", "TD", "TG", "TH", "TJ", "TK", "TL",
            "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "US", "UY", "UZ", "VA",
            "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "ZA", "ZM", "ZW",
        ]
    }
}
impl AsRef<str> for PhoneNumberCountryCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhoneNumberType {
    #[allow(missing_docs)] // documentation missing in model
    Did,
    #[allow(missing_docs)] // documentation missing in model
    TollFree,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhoneNumberType {
    fn from(s: &str) -> Self {
        match s {
            "DID" => PhoneNumberType::Did,
            "TOLL_FREE" => PhoneNumberType::TollFree,
            other => PhoneNumberType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhoneNumberType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhoneNumberType::from(s))
    }
}
impl PhoneNumberType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhoneNumberType::Did => "DID",
            PhoneNumberType::TollFree => "TOLL_FREE",
            PhoneNumberType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DID", "TOLL_FREE"]
    }
}
impl AsRef<str> for PhoneNumberType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration information of an Amazon Lex bot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LexBot {
    /// <p>The name of the Amazon Lex bot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Region that the Amazon Lex bot was created in.</p>
    pub lex_region: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LexBot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LexBot");
        formatter.field("name", &self.name);
        formatter.field("lex_region", &self.lex_region);
        formatter.finish()
    }
}
/// See [`LexBot`](crate::model::LexBot)
pub mod lex_bot {
    /// A builder for [`LexBot`](crate::model::LexBot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) lex_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Region that the Amazon Lex bot was created in.</p>
        pub fn lex_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.lex_region = Some(input.into());
            self
        }
        /// <p>The Region that the Amazon Lex bot was created in.</p>
        pub fn set_lex_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lex_region = input;
            self
        }
        /// Consumes the builder and constructs a [`LexBot`](crate::model::LexBot)
        pub fn build(self) -> crate::model::LexBot {
            crate::model::LexBot {
                name: self.name,
                lex_region: self.lex_region,
            }
        }
    }
}
impl LexBot {
    /// Creates a new builder-style object to manufacture [`LexBot`](crate::model::LexBot)
    pub fn builder() -> crate::model::lex_bot::Builder {
        crate::model::lex_bot::Builder::default()
    }
}

/// <p>Contains summary information about the associated AppIntegrations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntegrationAssociationSummary {
    /// <p>The identifier for the AppIntegration association.</p>
    pub integration_association_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the AppIntegration association.</p>
    pub integration_association_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The integration type.</p>
    pub integration_type: std::option::Option<crate::model::IntegrationType>,
    /// <p>The Amazon Resource Name (ARN) for the AppIntegration.</p>
    pub integration_arn: std::option::Option<std::string::String>,
    /// <p>The URL for the external application.</p>
    pub source_application_url: std::option::Option<std::string::String>,
    /// <p>The user-provided, friendly name for the external application.</p>
    pub source_application_name: std::option::Option<std::string::String>,
    /// <p>The name of the source.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
}
impl std::fmt::Debug for IntegrationAssociationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntegrationAssociationSummary");
        formatter.field(
            "integration_association_id",
            &self.integration_association_id,
        );
        formatter.field(
            "integration_association_arn",
            &self.integration_association_arn,
        );
        formatter.field("instance_id", &self.instance_id);
        formatter.field("integration_type", &self.integration_type);
        formatter.field("integration_arn", &self.integration_arn);
        formatter.field("source_application_url", &self.source_application_url);
        formatter.field("source_application_name", &self.source_application_name);
        formatter.field("source_type", &self.source_type);
        formatter.finish()
    }
}
/// See [`IntegrationAssociationSummary`](crate::model::IntegrationAssociationSummary)
pub mod integration_association_summary {
    /// A builder for [`IntegrationAssociationSummary`](crate::model::IntegrationAssociationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) integration_association_id: std::option::Option<std::string::String>,
        pub(crate) integration_association_arn: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) integration_type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) integration_arn: std::option::Option<std::string::String>,
        pub(crate) source_application_url: std::option::Option<std::string::String>,
        pub(crate) source_application_name: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
    }
    impl Builder {
        /// <p>The identifier for the AppIntegration association.</p>
        pub fn integration_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_association_id = Some(input.into());
            self
        }
        /// <p>The identifier for the AppIntegration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_association_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the AppIntegration association.</p>
        pub fn integration_association_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.integration_association_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the AppIntegration association.</p>
        pub fn set_integration_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_association_arn = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The integration type.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.integration_type = Some(input);
            self
        }
        /// <p>The integration type.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.integration_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the AppIntegration.</p>
        pub fn integration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the AppIntegration.</p>
        pub fn set_integration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_arn = input;
            self
        }
        /// <p>The URL for the external application.</p>
        pub fn source_application_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_application_url = Some(input.into());
            self
        }
        /// <p>The URL for the external application.</p>
        pub fn set_source_application_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_application_url = input;
            self
        }
        /// <p>The user-provided, friendly name for the external application.</p>
        pub fn source_application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_application_name = Some(input.into());
            self
        }
        /// <p>The user-provided, friendly name for the external application.</p>
        pub fn set_source_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_application_name = input;
            self
        }
        /// <p>The name of the source.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The name of the source.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// Consumes the builder and constructs a [`IntegrationAssociationSummary`](crate::model::IntegrationAssociationSummary)
        pub fn build(self) -> crate::model::IntegrationAssociationSummary {
            crate::model::IntegrationAssociationSummary {
                integration_association_id: self.integration_association_id,
                integration_association_arn: self.integration_association_arn,
                instance_id: self.instance_id,
                integration_type: self.integration_type,
                integration_arn: self.integration_arn,
                source_application_url: self.source_application_url,
                source_application_name: self.source_application_name,
                source_type: self.source_type,
            }
        }
    }
}
impl IntegrationAssociationSummary {
    /// Creates a new builder-style object to manufacture [`IntegrationAssociationSummary`](crate::model::IntegrationAssociationSummary)
    pub fn builder() -> crate::model::integration_association_summary::Builder {
        crate::model::integration_association_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    Salesforce,
    #[allow(missing_docs)] // documentation missing in model
    Zendesk,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "SALESFORCE" => SourceType::Salesforce,
            "ZENDESK" => SourceType::Zendesk,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::Salesforce => "SALESFORCE",
            SourceType::Zendesk => "ZENDESK",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SALESFORCE", "ZENDESK"]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IntegrationType {
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    PinpointApp,
    #[allow(missing_docs)] // documentation missing in model
    VoiceId,
    #[allow(missing_docs)] // documentation missing in model
    WisdomAssistant,
    #[allow(missing_docs)] // documentation missing in model
    WisdomKnowledgeBase,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IntegrationType {
    fn from(s: &str) -> Self {
        match s {
            "EVENT" => IntegrationType::Event,
            "PINPOINT_APP" => IntegrationType::PinpointApp,
            "VOICE_ID" => IntegrationType::VoiceId,
            "WISDOM_ASSISTANT" => IntegrationType::WisdomAssistant,
            "WISDOM_KNOWLEDGE_BASE" => IntegrationType::WisdomKnowledgeBase,
            other => IntegrationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IntegrationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IntegrationType::from(s))
    }
}
impl IntegrationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IntegrationType::Event => "EVENT",
            IntegrationType::PinpointApp => "PINPOINT_APP",
            IntegrationType::VoiceId => "VOICE_ID",
            IntegrationType::WisdomAssistant => "WISDOM_ASSISTANT",
            IntegrationType::WisdomKnowledgeBase => "WISDOM_KNOWLEDGE_BASE",
            IntegrationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EVENT",
            "PINPOINT_APP",
            "VOICE_ID",
            "WISDOM_ASSISTANT",
            "WISDOM_KNOWLEDGE_BASE",
        ]
    }
}
impl AsRef<str> for IntegrationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceSummary {
    /// <p>The identifier of the instance.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the instance.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The identity management type of the instance.</p>
    pub identity_management_type: std::option::Option<crate::model::DirectoryType>,
    /// <p>The alias of the instance.</p>
    pub instance_alias: std::option::Option<std::string::String>,
    /// <p>When the instance was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The service role of the instance.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>The state of the instance.</p>
    pub instance_status: std::option::Option<crate::model::InstanceStatus>,
    /// <p>Whether inbound calls are enabled.</p>
    pub inbound_calls_enabled: std::option::Option<bool>,
    /// <p>Whether outbound calls are enabled.</p>
    pub outbound_calls_enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for InstanceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("identity_management_type", &self.identity_management_type);
        formatter.field("instance_alias", &"*** Sensitive Data Redacted ***");
        formatter.field("created_time", &self.created_time);
        formatter.field("service_role", &self.service_role);
        formatter.field("instance_status", &self.instance_status);
        formatter.field("inbound_calls_enabled", &self.inbound_calls_enabled);
        formatter.field("outbound_calls_enabled", &self.outbound_calls_enabled);
        formatter.finish()
    }
}
/// See [`InstanceSummary`](crate::model::InstanceSummary)
pub mod instance_summary {
    /// A builder for [`InstanceSummary`](crate::model::InstanceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) identity_management_type: std::option::Option<crate::model::DirectoryType>,
        pub(crate) instance_alias: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) instance_status: std::option::Option<crate::model::InstanceStatus>,
        pub(crate) inbound_calls_enabled: std::option::Option<bool>,
        pub(crate) outbound_calls_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of the instance.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the instance.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The identity management type of the instance.</p>
        pub fn identity_management_type(mut self, input: crate::model::DirectoryType) -> Self {
            self.identity_management_type = Some(input);
            self
        }
        /// <p>The identity management type of the instance.</p>
        pub fn set_identity_management_type(
            mut self,
            input: std::option::Option<crate::model::DirectoryType>,
        ) -> Self {
            self.identity_management_type = input;
            self
        }
        /// <p>The alias of the instance.</p>
        pub fn instance_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_alias = Some(input.into());
            self
        }
        /// <p>The alias of the instance.</p>
        pub fn set_instance_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_alias = input;
            self
        }
        /// <p>When the instance was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the instance was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The service role of the instance.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The service role of the instance.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>The state of the instance.</p>
        pub fn instance_status(mut self, input: crate::model::InstanceStatus) -> Self {
            self.instance_status = Some(input);
            self
        }
        /// <p>The state of the instance.</p>
        pub fn set_instance_status(
            mut self,
            input: std::option::Option<crate::model::InstanceStatus>,
        ) -> Self {
            self.instance_status = input;
            self
        }
        /// <p>Whether inbound calls are enabled.</p>
        pub fn inbound_calls_enabled(mut self, input: bool) -> Self {
            self.inbound_calls_enabled = Some(input);
            self
        }
        /// <p>Whether inbound calls are enabled.</p>
        pub fn set_inbound_calls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inbound_calls_enabled = input;
            self
        }
        /// <p>Whether outbound calls are enabled.</p>
        pub fn outbound_calls_enabled(mut self, input: bool) -> Self {
            self.outbound_calls_enabled = Some(input);
            self
        }
        /// <p>Whether outbound calls are enabled.</p>
        pub fn set_outbound_calls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.outbound_calls_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceSummary`](crate::model::InstanceSummary)
        pub fn build(self) -> crate::model::InstanceSummary {
            crate::model::InstanceSummary {
                id: self.id,
                arn: self.arn,
                identity_management_type: self.identity_management_type,
                instance_alias: self.instance_alias,
                created_time: self.created_time,
                service_role: self.service_role,
                instance_status: self.instance_status,
                inbound_calls_enabled: self.inbound_calls_enabled,
                outbound_calls_enabled: self.outbound_calls_enabled,
            }
        }
    }
}
impl InstanceSummary {
    /// Creates a new builder-style object to manufacture [`InstanceSummary`](crate::model::InstanceSummary)
    pub fn builder() -> crate::model::instance_summary::Builder {
        crate::model::instance_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreationFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreationInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => InstanceStatus::Active,
            "CREATION_FAILED" => InstanceStatus::CreationFailed,
            "CREATION_IN_PROGRESS" => InstanceStatus::CreationInProgress,
            other => InstanceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceStatus::from(s))
    }
}
impl InstanceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceStatus::Active => "ACTIVE",
            InstanceStatus::CreationFailed => "CREATION_FAILED",
            InstanceStatus::CreationInProgress => "CREATION_IN_PROGRESS",
            InstanceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATION_FAILED", "CREATION_IN_PROGRESS"]
    }
}
impl AsRef<str> for InstanceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DirectoryType {
    #[allow(missing_docs)] // documentation missing in model
    ConnectManaged,
    #[allow(missing_docs)] // documentation missing in model
    ExistingDirectory,
    #[allow(missing_docs)] // documentation missing in model
    Saml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DirectoryType {
    fn from(s: &str) -> Self {
        match s {
            "CONNECT_MANAGED" => DirectoryType::ConnectManaged,
            "EXISTING_DIRECTORY" => DirectoryType::ExistingDirectory,
            "SAML" => DirectoryType::Saml,
            other => DirectoryType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DirectoryType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DirectoryType::from(s))
    }
}
impl DirectoryType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DirectoryType::ConnectManaged => "CONNECT_MANAGED",
            DirectoryType::ExistingDirectory => "EXISTING_DIRECTORY",
            DirectoryType::Saml => "SAML",
            DirectoryType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECT_MANAGED", "EXISTING_DIRECTORY", "SAML"]
    }
}
impl AsRef<str> for DirectoryType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A toggle for an individual feature at the instance level.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attribute {
    /// <p>The type of attribute.</p>
    pub attribute_type: std::option::Option<crate::model::InstanceAttributeType>,
    /// <p>The value of the attribute.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Attribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attribute");
        formatter.field("attribute_type", &self.attribute_type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Attribute`](crate::model::Attribute)
pub mod attribute {
    /// A builder for [`Attribute`](crate::model::Attribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_type: std::option::Option<crate::model::InstanceAttributeType>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of attribute.</p>
        pub fn attribute_type(mut self, input: crate::model::InstanceAttributeType) -> Self {
            self.attribute_type = Some(input);
            self
        }
        /// <p>The type of attribute.</p>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<crate::model::InstanceAttributeType>,
        ) -> Self {
            self.attribute_type = input;
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Attribute`](crate::model::Attribute)
        pub fn build(self) -> crate::model::Attribute {
            crate::model::Attribute {
                attribute_type: self.attribute_type,
                value: self.value,
            }
        }
    }
}
impl Attribute {
    /// Creates a new builder-style object to manufacture [`Attribute`](crate::model::Attribute)
    pub fn builder() -> crate::model::attribute::Builder {
        crate::model::attribute::Builder::default()
    }
}

/// <p>Contains summary information about hours of operation for a contact center.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HoursOfOperationSummary {
    /// <p>The identifier of the hours of operation.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the hours of operation.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the hours of operation.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HoursOfOperationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HoursOfOperationSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`HoursOfOperationSummary`](crate::model::HoursOfOperationSummary)
pub mod hours_of_operation_summary {
    /// A builder for [`HoursOfOperationSummary`](crate::model::HoursOfOperationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the hours of operation.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the hours of operation.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hours of operation.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hours of operation.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`HoursOfOperationSummary`](crate::model::HoursOfOperationSummary)
        pub fn build(self) -> crate::model::HoursOfOperationSummary {
            crate::model::HoursOfOperationSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl HoursOfOperationSummary {
    /// Creates a new builder-style object to manufacture [`HoursOfOperationSummary`](crate::model::HoursOfOperationSummary)
    pub fn builder() -> crate::model::hours_of_operation_summary::Builder {
        crate::model::hours_of_operation_summary::Builder::default()
    }
}

/// <p>Contains summary information about a contact flow.</p>
/// <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect
/// Flow language</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactFlowSummary {
    /// <p>The identifier of the contact flow.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the contact flow.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the contact flow.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of contact flow.</p>
    pub contact_flow_type: std::option::Option<crate::model::ContactFlowType>,
}
impl std::fmt::Debug for ContactFlowSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactFlowSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("contact_flow_type", &self.contact_flow_type);
        formatter.finish()
    }
}
/// See [`ContactFlowSummary`](crate::model::ContactFlowSummary)
pub mod contact_flow_summary {
    /// A builder for [`ContactFlowSummary`](crate::model::ContactFlowSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) contact_flow_type: std::option::Option<crate::model::ContactFlowType>,
    }
    impl Builder {
        /// <p>The identifier of the contact flow.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact flow.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact flow.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of contact flow.</p>
        pub fn contact_flow_type(mut self, input: crate::model::ContactFlowType) -> Self {
            self.contact_flow_type = Some(input);
            self
        }
        /// <p>The type of contact flow.</p>
        pub fn set_contact_flow_type(
            mut self,
            input: std::option::Option<crate::model::ContactFlowType>,
        ) -> Self {
            self.contact_flow_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactFlowSummary`](crate::model::ContactFlowSummary)
        pub fn build(self) -> crate::model::ContactFlowSummary {
            crate::model::ContactFlowSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                contact_flow_type: self.contact_flow_type,
            }
        }
    }
}
impl ContactFlowSummary {
    /// Creates a new builder-style object to manufacture [`ContactFlowSummary`](crate::model::ContactFlowSummary)
    pub fn builder() -> crate::model::contact_flow_summary::Builder {
        crate::model::contact_flow_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContactFlowType {
    #[allow(missing_docs)] // documentation missing in model
    AgentHold,
    #[allow(missing_docs)] // documentation missing in model
    AgentTransfer,
    #[allow(missing_docs)] // documentation missing in model
    AgentWhisper,
    #[allow(missing_docs)] // documentation missing in model
    ContactFlow,
    #[allow(missing_docs)] // documentation missing in model
    CustomerHold,
    #[allow(missing_docs)] // documentation missing in model
    CustomerQueue,
    #[allow(missing_docs)] // documentation missing in model
    CustomerWhisper,
    #[allow(missing_docs)] // documentation missing in model
    OutboundWhisper,
    #[allow(missing_docs)] // documentation missing in model
    QueueTransfer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContactFlowType {
    fn from(s: &str) -> Self {
        match s {
            "AGENT_HOLD" => ContactFlowType::AgentHold,
            "AGENT_TRANSFER" => ContactFlowType::AgentTransfer,
            "AGENT_WHISPER" => ContactFlowType::AgentWhisper,
            "CONTACT_FLOW" => ContactFlowType::ContactFlow,
            "CUSTOMER_HOLD" => ContactFlowType::CustomerHold,
            "CUSTOMER_QUEUE" => ContactFlowType::CustomerQueue,
            "CUSTOMER_WHISPER" => ContactFlowType::CustomerWhisper,
            "OUTBOUND_WHISPER" => ContactFlowType::OutboundWhisper,
            "QUEUE_TRANSFER" => ContactFlowType::QueueTransfer,
            other => ContactFlowType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContactFlowType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContactFlowType::from(s))
    }
}
impl ContactFlowType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContactFlowType::AgentHold => "AGENT_HOLD",
            ContactFlowType::AgentTransfer => "AGENT_TRANSFER",
            ContactFlowType::AgentWhisper => "AGENT_WHISPER",
            ContactFlowType::ContactFlow => "CONTACT_FLOW",
            ContactFlowType::CustomerHold => "CUSTOMER_HOLD",
            ContactFlowType::CustomerQueue => "CUSTOMER_QUEUE",
            ContactFlowType::CustomerWhisper => "CUSTOMER_WHISPER",
            ContactFlowType::OutboundWhisper => "OUTBOUND_WHISPER",
            ContactFlowType::QueueTransfer => "QUEUE_TRANSFER",
            ContactFlowType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AGENT_HOLD",
            "AGENT_TRANSFER",
            "AGENT_WHISPER",
            "CONTACT_FLOW",
            "CUSTOMER_HOLD",
            "CUSTOMER_QUEUE",
            "CUSTOMER_WHISPER",
            "OUTBOUND_WHISPER",
            "QUEUE_TRANSFER",
        ]
    }
}
impl AsRef<str> for ContactFlowType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration information of an Amazon Lex or Amazon Lex V2 bot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LexBotConfig {
    /// <p>Configuration information of an Amazon Lex bot.</p>
    pub lex_bot: std::option::Option<crate::model::LexBot>,
    /// <p>Configuration information of an Amazon Lex V2 bot.</p>
    pub lex_v2_bot: std::option::Option<crate::model::LexV2Bot>,
}
impl std::fmt::Debug for LexBotConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LexBotConfig");
        formatter.field("lex_bot", &self.lex_bot);
        formatter.field("lex_v2_bot", &self.lex_v2_bot);
        formatter.finish()
    }
}
/// See [`LexBotConfig`](crate::model::LexBotConfig)
pub mod lex_bot_config {
    /// A builder for [`LexBotConfig`](crate::model::LexBotConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lex_bot: std::option::Option<crate::model::LexBot>,
        pub(crate) lex_v2_bot: std::option::Option<crate::model::LexV2Bot>,
    }
    impl Builder {
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn lex_bot(mut self, input: crate::model::LexBot) -> Self {
            self.lex_bot = Some(input);
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn set_lex_bot(mut self, input: std::option::Option<crate::model::LexBot>) -> Self {
            self.lex_bot = input;
            self
        }
        /// <p>Configuration information of an Amazon Lex V2 bot.</p>
        pub fn lex_v2_bot(mut self, input: crate::model::LexV2Bot) -> Self {
            self.lex_v2_bot = Some(input);
            self
        }
        /// <p>Configuration information of an Amazon Lex V2 bot.</p>
        pub fn set_lex_v2_bot(
            mut self,
            input: std::option::Option<crate::model::LexV2Bot>,
        ) -> Self {
            self.lex_v2_bot = input;
            self
        }
        /// Consumes the builder and constructs a [`LexBotConfig`](crate::model::LexBotConfig)
        pub fn build(self) -> crate::model::LexBotConfig {
            crate::model::LexBotConfig {
                lex_bot: self.lex_bot,
                lex_v2_bot: self.lex_v2_bot,
            }
        }
    }
}
impl LexBotConfig {
    /// Creates a new builder-style object to manufacture [`LexBotConfig`](crate::model::LexBotConfig)
    pub fn builder() -> crate::model::lex_bot_config::Builder {
        crate::model::lex_bot_config::Builder::default()
    }
}

/// <p>Configuration information of an Amazon Lex V2 bot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LexV2Bot {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Lex V2 bot.</p>
    pub alias_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LexV2Bot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LexV2Bot");
        formatter.field("alias_arn", &self.alias_arn);
        formatter.finish()
    }
}
/// See [`LexV2Bot`](crate::model::LexV2Bot)
pub mod lex_v2_bot {
    /// A builder for [`LexV2Bot`](crate::model::LexV2Bot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon Lex V2 bot.</p>
        pub fn alias_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Lex V2 bot.</p>
        pub fn set_alias_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LexV2Bot`](crate::model::LexV2Bot)
        pub fn build(self) -> crate::model::LexV2Bot {
            crate::model::LexV2Bot {
                alias_arn: self.alias_arn,
            }
        }
    }
}
impl LexV2Bot {
    /// Creates a new builder-style object to manufacture [`LexV2Bot`](crate::model::LexV2Bot)
    pub fn builder() -> crate::model::lex_v2_bot::Builder {
        crate::model::lex_v2_bot::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LexVersion {
    #[allow(missing_docs)] // documentation missing in model
    V1,
    #[allow(missing_docs)] // documentation missing in model
    V2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LexVersion {
    fn from(s: &str) -> Self {
        match s {
            "V1" => LexVersion::V1,
            "V2" => LexVersion::V2,
            other => LexVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LexVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LexVersion::from(s))
    }
}
impl LexVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LexVersion::V1 => "V1",
            LexVersion::V2 => "V2",
            LexVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["V1", "V2"]
    }
}
impl AsRef<str> for LexVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information for an agent status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentStatusSummary {
    /// <p>The identifier for an agent status.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the agent status.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the agent status.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the agent status.</p>
    pub r#type: std::option::Option<crate::model::AgentStatusType>,
}
impl std::fmt::Debug for AgentStatusSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentStatusSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AgentStatusSummary`](crate::model::AgentStatusSummary)
pub mod agent_status_summary {
    /// A builder for [`AgentStatusSummary`](crate::model::AgentStatusSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::AgentStatusType>,
    }
    impl Builder {
        /// <p>The identifier for an agent status.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for an agent status.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the agent status.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the agent status.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the agent status.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the agent status.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the agent status.</p>
        pub fn r#type(mut self, input: crate::model::AgentStatusType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the agent status.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AgentStatusType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentStatusSummary`](crate::model::AgentStatusSummary)
        pub fn build(self) -> crate::model::AgentStatusSummary {
            crate::model::AgentStatusSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl AgentStatusSummary {
    /// Creates a new builder-style object to manufacture [`AgentStatusSummary`](crate::model::AgentStatusSummary)
    pub fn builder() -> crate::model::agent_status_summary::Builder {
        crate::model::agent_status_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AgentStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Offline,
    #[allow(missing_docs)] // documentation missing in model
    Routable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AgentStatusType {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOM" => AgentStatusType::Custom,
            "OFFLINE" => AgentStatusType::Offline,
            "ROUTABLE" => AgentStatusType::Routable,
            other => AgentStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AgentStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AgentStatusType::from(s))
    }
}
impl AgentStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AgentStatusType::Custom => "CUSTOM",
            AgentStatusType::Offline => "OFFLINE",
            AgentStatusType::Routable => "ROUTABLE",
            AgentStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUSTOM", "OFFLINE", "ROUTABLE"]
    }
}
impl AsRef<str> for AgentStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the historical metrics retrieved.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HistoricalMetricResult {
    /// <p>The dimension for the metrics.</p>
    pub dimensions: std::option::Option<crate::model::Dimensions>,
    /// <p>The set of metrics.</p>
    pub collections: std::option::Option<std::vec::Vec<crate::model::HistoricalMetricData>>,
}
impl std::fmt::Debug for HistoricalMetricResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HistoricalMetricResult");
        formatter.field("dimensions", &self.dimensions);
        formatter.field("collections", &self.collections);
        formatter.finish()
    }
}
/// See [`HistoricalMetricResult`](crate::model::HistoricalMetricResult)
pub mod historical_metric_result {
    /// A builder for [`HistoricalMetricResult`](crate::model::HistoricalMetricResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<crate::model::Dimensions>,
        pub(crate) collections:
            std::option::Option<std::vec::Vec<crate::model::HistoricalMetricData>>,
    }
    impl Builder {
        /// <p>The dimension for the metrics.</p>
        pub fn dimensions(mut self, input: crate::model::Dimensions) -> Self {
            self.dimensions = Some(input);
            self
        }
        /// <p>The dimension for the metrics.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<crate::model::Dimensions>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Appends an item to `collections`.
        ///
        /// To override the contents of this collection use [`set_collections`](Self::set_collections).
        ///
        /// <p>The set of metrics.</p>
        pub fn collections(mut self, input: impl Into<crate::model::HistoricalMetricData>) -> Self {
            let mut v = self.collections.unwrap_or_default();
            v.push(input.into());
            self.collections = Some(v);
            self
        }
        /// <p>The set of metrics.</p>
        pub fn set_collections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HistoricalMetricData>>,
        ) -> Self {
            self.collections = input;
            self
        }
        /// Consumes the builder and constructs a [`HistoricalMetricResult`](crate::model::HistoricalMetricResult)
        pub fn build(self) -> crate::model::HistoricalMetricResult {
            crate::model::HistoricalMetricResult {
                dimensions: self.dimensions,
                collections: self.collections,
            }
        }
    }
}
impl HistoricalMetricResult {
    /// Creates a new builder-style object to manufacture [`HistoricalMetricResult`](crate::model::HistoricalMetricResult)
    pub fn builder() -> crate::model::historical_metric_result::Builder {
        crate::model::historical_metric_result::Builder::default()
    }
}

/// <p>Contains the data for a historical metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HistoricalMetricData {
    /// <p>Information about the metric.</p>
    pub metric: std::option::Option<crate::model::HistoricalMetric>,
    /// <p>The value of the metric.</p>
    pub value: std::option::Option<f64>,
}
impl std::fmt::Debug for HistoricalMetricData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HistoricalMetricData");
        formatter.field("metric", &self.metric);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`HistoricalMetricData`](crate::model::HistoricalMetricData)
pub mod historical_metric_data {
    /// A builder for [`HistoricalMetricData`](crate::model::HistoricalMetricData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<crate::model::HistoricalMetric>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Information about the metric.</p>
        pub fn metric(mut self, input: crate::model::HistoricalMetric) -> Self {
            self.metric = Some(input);
            self
        }
        /// <p>Information about the metric.</p>
        pub fn set_metric(
            mut self,
            input: std::option::Option<crate::model::HistoricalMetric>,
        ) -> Self {
            self.metric = input;
            self
        }
        /// <p>The value of the metric.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the metric.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`HistoricalMetricData`](crate::model::HistoricalMetricData)
        pub fn build(self) -> crate::model::HistoricalMetricData {
            crate::model::HistoricalMetricData {
                metric: self.metric,
                value: self.value,
            }
        }
    }
}
impl HistoricalMetricData {
    /// Creates a new builder-style object to manufacture [`HistoricalMetricData`](crate::model::HistoricalMetricData)
    pub fn builder() -> crate::model::historical_metric_data::Builder {
        crate::model::historical_metric_data::Builder::default()
    }
}

/// <p>Contains information about a historical metric. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator
/// Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HistoricalMetric {
    /// <p>The name of the metric.</p>
    pub name: std::option::Option<crate::model::HistoricalMetricName>,
    /// <p>The threshold for the metric, used with service level metrics.</p>
    pub threshold: std::option::Option<crate::model::Threshold>,
    /// <p>The statistic for the metric.</p>
    pub statistic: std::option::Option<crate::model::Statistic>,
    /// <p>The unit for the metric.</p>
    pub unit: std::option::Option<crate::model::Unit>,
}
impl std::fmt::Debug for HistoricalMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HistoricalMetric");
        formatter.field("name", &self.name);
        formatter.field("threshold", &self.threshold);
        formatter.field("statistic", &self.statistic);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`HistoricalMetric`](crate::model::HistoricalMetric)
pub mod historical_metric {
    /// A builder for [`HistoricalMetric`](crate::model::HistoricalMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::HistoricalMetricName>,
        pub(crate) threshold: std::option::Option<crate::model::Threshold>,
        pub(crate) statistic: std::option::Option<crate::model::Statistic>,
        pub(crate) unit: std::option::Option<crate::model::Unit>,
    }
    impl Builder {
        /// <p>The name of the metric.</p>
        pub fn name(mut self, input: crate::model::HistoricalMetricName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the metric.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::HistoricalMetricName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The threshold for the metric, used with service level metrics.</p>
        pub fn threshold(mut self, input: crate::model::Threshold) -> Self {
            self.threshold = Some(input);
            self
        }
        /// <p>The threshold for the metric, used with service level metrics.</p>
        pub fn set_threshold(
            mut self,
            input: std::option::Option<crate::model::Threshold>,
        ) -> Self {
            self.threshold = input;
            self
        }
        /// <p>The statistic for the metric.</p>
        pub fn statistic(mut self, input: crate::model::Statistic) -> Self {
            self.statistic = Some(input);
            self
        }
        /// <p>The statistic for the metric.</p>
        pub fn set_statistic(
            mut self,
            input: std::option::Option<crate::model::Statistic>,
        ) -> Self {
            self.statistic = input;
            self
        }
        /// <p>The unit for the metric.</p>
        pub fn unit(mut self, input: crate::model::Unit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit for the metric.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::Unit>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`HistoricalMetric`](crate::model::HistoricalMetric)
        pub fn build(self) -> crate::model::HistoricalMetric {
            crate::model::HistoricalMetric {
                name: self.name,
                threshold: self.threshold,
                statistic: self.statistic,
                unit: self.unit,
            }
        }
    }
}
impl HistoricalMetric {
    /// Creates a new builder-style object to manufacture [`HistoricalMetric`](crate::model::HistoricalMetric)
    pub fn builder() -> crate::model::historical_metric::Builder {
        crate::model::historical_metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Unit {
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    Percent,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Unit {
    fn from(s: &str) -> Self {
        match s {
            "COUNT" => Unit::Count,
            "PERCENT" => Unit::Percent,
            "SECONDS" => Unit::Seconds,
            other => Unit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Unit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Unit::from(s))
    }
}
impl Unit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Unit::Count => "COUNT",
            Unit::Percent => "PERCENT",
            Unit::Seconds => "SECONDS",
            Unit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COUNT", "PERCENT", "SECONDS"]
    }
}
impl AsRef<str> for Unit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Statistic {
    #[allow(missing_docs)] // documentation missing in model
    Avg,
    #[allow(missing_docs)] // documentation missing in model
    Max,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Statistic {
    fn from(s: &str) -> Self {
        match s {
            "AVG" => Statistic::Avg,
            "MAX" => Statistic::Max,
            "SUM" => Statistic::Sum,
            other => Statistic::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Statistic {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Statistic::from(s))
    }
}
impl Statistic {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Statistic::Avg => "AVG",
            Statistic::Max => "MAX",
            Statistic::Sum => "SUM",
            Statistic::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVG", "MAX", "SUM"]
    }
}
impl AsRef<str> for Statistic {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the threshold for service level metrics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Threshold {
    /// <p>The type of comparison. Only "less than" (LT) comparisons are supported.</p>
    pub comparison: std::option::Option<crate::model::Comparison>,
    /// <p>The threshold value to compare.</p>
    pub threshold_value: std::option::Option<f64>,
}
impl std::fmt::Debug for Threshold {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Threshold");
        formatter.field("comparison", &self.comparison);
        formatter.field("threshold_value", &self.threshold_value);
        formatter.finish()
    }
}
/// See [`Threshold`](crate::model::Threshold)
pub mod threshold {
    /// A builder for [`Threshold`](crate::model::Threshold)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparison: std::option::Option<crate::model::Comparison>,
        pub(crate) threshold_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The type of comparison. Only "less than" (LT) comparisons are supported.</p>
        pub fn comparison(mut self, input: crate::model::Comparison) -> Self {
            self.comparison = Some(input);
            self
        }
        /// <p>The type of comparison. Only "less than" (LT) comparisons are supported.</p>
        pub fn set_comparison(
            mut self,
            input: std::option::Option<crate::model::Comparison>,
        ) -> Self {
            self.comparison = input;
            self
        }
        /// <p>The threshold value to compare.</p>
        pub fn threshold_value(mut self, input: f64) -> Self {
            self.threshold_value = Some(input);
            self
        }
        /// <p>The threshold value to compare.</p>
        pub fn set_threshold_value(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Threshold`](crate::model::Threshold)
        pub fn build(self) -> crate::model::Threshold {
            crate::model::Threshold {
                comparison: self.comparison,
                threshold_value: self.threshold_value,
            }
        }
    }
}
impl Threshold {
    /// Creates a new builder-style object to manufacture [`Threshold`](crate::model::Threshold)
    pub fn builder() -> crate::model::threshold::Builder {
        crate::model::threshold::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Comparison {
    #[allow(missing_docs)] // documentation missing in model
    Lt,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Comparison {
    fn from(s: &str) -> Self {
        match s {
            "LT" => Comparison::Lt,
            other => Comparison::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Comparison {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Comparison::from(s))
    }
}
impl Comparison {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Comparison::Lt => "LT",
            Comparison::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LT"]
    }
}
impl AsRef<str> for Comparison {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The historical metric names.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HistoricalMetricName {
    #[allow(missing_docs)] // documentation missing in model
    AbandonTime,
    #[allow(missing_docs)] // documentation missing in model
    AfterContactWorkTime,
    #[allow(missing_docs)] // documentation missing in model
    ApiContactsHandled,
    #[allow(missing_docs)] // documentation missing in model
    CallbackContactsHandled,
    #[allow(missing_docs)] // documentation missing in model
    ContactsAbandoned,
    #[allow(missing_docs)] // documentation missing in model
    ContactsAgentHungUpFirst,
    #[allow(missing_docs)] // documentation missing in model
    ContactsConsulted,
    #[allow(missing_docs)] // documentation missing in model
    ContactsHandled,
    #[allow(missing_docs)] // documentation missing in model
    ContactsHandledIncoming,
    #[allow(missing_docs)] // documentation missing in model
    ContactsHandledOutbound,
    #[allow(missing_docs)] // documentation missing in model
    ContactsHoldAbandons,
    #[allow(missing_docs)] // documentation missing in model
    ContactsMissed,
    #[allow(missing_docs)] // documentation missing in model
    ContactsQueued,
    #[allow(missing_docs)] // documentation missing in model
    ContactsTransferredIn,
    #[allow(missing_docs)] // documentation missing in model
    ContactsTransferredInFromQueue,
    #[allow(missing_docs)] // documentation missing in model
    ContactsTransferredOut,
    #[allow(missing_docs)] // documentation missing in model
    ContactsTransferredOutFromQueue,
    #[allow(missing_docs)] // documentation missing in model
    HandleTime,
    #[allow(missing_docs)] // documentation missing in model
    HoldTime,
    #[allow(missing_docs)] // documentation missing in model
    InteractionAndHoldTime,
    #[allow(missing_docs)] // documentation missing in model
    InteractionTime,
    #[allow(missing_docs)] // documentation missing in model
    Occupancy,
    #[allow(missing_docs)] // documentation missing in model
    QueuedTime,
    #[allow(missing_docs)] // documentation missing in model
    QueueAnswerTime,
    #[allow(missing_docs)] // documentation missing in model
    ServiceLevel,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HistoricalMetricName {
    fn from(s: &str) -> Self {
        match s {
            "ABANDON_TIME" => HistoricalMetricName::AbandonTime,
            "AFTER_CONTACT_WORK_TIME" => HistoricalMetricName::AfterContactWorkTime,
            "API_CONTACTS_HANDLED" => HistoricalMetricName::ApiContactsHandled,
            "CALLBACK_CONTACTS_HANDLED" => HistoricalMetricName::CallbackContactsHandled,
            "CONTACTS_ABANDONED" => HistoricalMetricName::ContactsAbandoned,
            "CONTACTS_AGENT_HUNG_UP_FIRST" => HistoricalMetricName::ContactsAgentHungUpFirst,
            "CONTACTS_CONSULTED" => HistoricalMetricName::ContactsConsulted,
            "CONTACTS_HANDLED" => HistoricalMetricName::ContactsHandled,
            "CONTACTS_HANDLED_INCOMING" => HistoricalMetricName::ContactsHandledIncoming,
            "CONTACTS_HANDLED_OUTBOUND" => HistoricalMetricName::ContactsHandledOutbound,
            "CONTACTS_HOLD_ABANDONS" => HistoricalMetricName::ContactsHoldAbandons,
            "CONTACTS_MISSED" => HistoricalMetricName::ContactsMissed,
            "CONTACTS_QUEUED" => HistoricalMetricName::ContactsQueued,
            "CONTACTS_TRANSFERRED_IN" => HistoricalMetricName::ContactsTransferredIn,
            "CONTACTS_TRANSFERRED_IN_FROM_QUEUE" => {
                HistoricalMetricName::ContactsTransferredInFromQueue
            }
            "CONTACTS_TRANSFERRED_OUT" => HistoricalMetricName::ContactsTransferredOut,
            "CONTACTS_TRANSFERRED_OUT_FROM_QUEUE" => {
                HistoricalMetricName::ContactsTransferredOutFromQueue
            }
            "HANDLE_TIME" => HistoricalMetricName::HandleTime,
            "HOLD_TIME" => HistoricalMetricName::HoldTime,
            "INTERACTION_AND_HOLD_TIME" => HistoricalMetricName::InteractionAndHoldTime,
            "INTERACTION_TIME" => HistoricalMetricName::InteractionTime,
            "OCCUPANCY" => HistoricalMetricName::Occupancy,
            "QUEUED_TIME" => HistoricalMetricName::QueuedTime,
            "QUEUE_ANSWER_TIME" => HistoricalMetricName::QueueAnswerTime,
            "SERVICE_LEVEL" => HistoricalMetricName::ServiceLevel,
            other => HistoricalMetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HistoricalMetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HistoricalMetricName::from(s))
    }
}
impl HistoricalMetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HistoricalMetricName::AbandonTime => "ABANDON_TIME",
            HistoricalMetricName::AfterContactWorkTime => "AFTER_CONTACT_WORK_TIME",
            HistoricalMetricName::ApiContactsHandled => "API_CONTACTS_HANDLED",
            HistoricalMetricName::CallbackContactsHandled => "CALLBACK_CONTACTS_HANDLED",
            HistoricalMetricName::ContactsAbandoned => "CONTACTS_ABANDONED",
            HistoricalMetricName::ContactsAgentHungUpFirst => "CONTACTS_AGENT_HUNG_UP_FIRST",
            HistoricalMetricName::ContactsConsulted => "CONTACTS_CONSULTED",
            HistoricalMetricName::ContactsHandled => "CONTACTS_HANDLED",
            HistoricalMetricName::ContactsHandledIncoming => "CONTACTS_HANDLED_INCOMING",
            HistoricalMetricName::ContactsHandledOutbound => "CONTACTS_HANDLED_OUTBOUND",
            HistoricalMetricName::ContactsHoldAbandons => "CONTACTS_HOLD_ABANDONS",
            HistoricalMetricName::ContactsMissed => "CONTACTS_MISSED",
            HistoricalMetricName::ContactsQueued => "CONTACTS_QUEUED",
            HistoricalMetricName::ContactsTransferredIn => "CONTACTS_TRANSFERRED_IN",
            HistoricalMetricName::ContactsTransferredInFromQueue => {
                "CONTACTS_TRANSFERRED_IN_FROM_QUEUE"
            }
            HistoricalMetricName::ContactsTransferredOut => "CONTACTS_TRANSFERRED_OUT",
            HistoricalMetricName::ContactsTransferredOutFromQueue => {
                "CONTACTS_TRANSFERRED_OUT_FROM_QUEUE"
            }
            HistoricalMetricName::HandleTime => "HANDLE_TIME",
            HistoricalMetricName::HoldTime => "HOLD_TIME",
            HistoricalMetricName::InteractionAndHoldTime => "INTERACTION_AND_HOLD_TIME",
            HistoricalMetricName::InteractionTime => "INTERACTION_TIME",
            HistoricalMetricName::Occupancy => "OCCUPANCY",
            HistoricalMetricName::QueuedTime => "QUEUED_TIME",
            HistoricalMetricName::QueueAnswerTime => "QUEUE_ANSWER_TIME",
            HistoricalMetricName::ServiceLevel => "SERVICE_LEVEL",
            HistoricalMetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ABANDON_TIME",
            "AFTER_CONTACT_WORK_TIME",
            "API_CONTACTS_HANDLED",
            "CALLBACK_CONTACTS_HANDLED",
            "CONTACTS_ABANDONED",
            "CONTACTS_AGENT_HUNG_UP_FIRST",
            "CONTACTS_CONSULTED",
            "CONTACTS_HANDLED",
            "CONTACTS_HANDLED_INCOMING",
            "CONTACTS_HANDLED_OUTBOUND",
            "CONTACTS_HOLD_ABANDONS",
            "CONTACTS_MISSED",
            "CONTACTS_QUEUED",
            "CONTACTS_TRANSFERRED_IN",
            "CONTACTS_TRANSFERRED_IN_FROM_QUEUE",
            "CONTACTS_TRANSFERRED_OUT",
            "CONTACTS_TRANSFERRED_OUT_FROM_QUEUE",
            "HANDLE_TIME",
            "HOLD_TIME",
            "INTERACTION_AND_HOLD_TIME",
            "INTERACTION_TIME",
            "OCCUPANCY",
            "QUEUED_TIME",
            "QUEUE_ANSWER_TIME",
            "SERVICE_LEVEL",
        ]
    }
}
impl AsRef<str> for HistoricalMetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the dimensions for a set of metrics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Dimensions {
    /// <p>Information about the queue for which metrics are returned.</p>
    pub queue: std::option::Option<crate::model::QueueReference>,
    /// <p>The channel used for grouping and filters.</p>
    pub channel: std::option::Option<crate::model::Channel>,
}
impl std::fmt::Debug for Dimensions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Dimensions");
        formatter.field("queue", &self.queue);
        formatter.field("channel", &self.channel);
        formatter.finish()
    }
}
/// See [`Dimensions`](crate::model::Dimensions)
pub mod dimensions {
    /// A builder for [`Dimensions`](crate::model::Dimensions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue: std::option::Option<crate::model::QueueReference>,
        pub(crate) channel: std::option::Option<crate::model::Channel>,
    }
    impl Builder {
        /// <p>Information about the queue for which metrics are returned.</p>
        pub fn queue(mut self, input: crate::model::QueueReference) -> Self {
            self.queue = Some(input);
            self
        }
        /// <p>Information about the queue for which metrics are returned.</p>
        pub fn set_queue(
            mut self,
            input: std::option::Option<crate::model::QueueReference>,
        ) -> Self {
            self.queue = input;
            self
        }
        /// <p>The channel used for grouping and filters.</p>
        pub fn channel(mut self, input: crate::model::Channel) -> Self {
            self.channel = Some(input);
            self
        }
        /// <p>The channel used for grouping and filters.</p>
        pub fn set_channel(mut self, input: std::option::Option<crate::model::Channel>) -> Self {
            self.channel = input;
            self
        }
        /// Consumes the builder and constructs a [`Dimensions`](crate::model::Dimensions)
        pub fn build(self) -> crate::model::Dimensions {
            crate::model::Dimensions {
                queue: self.queue,
                channel: self.channel,
            }
        }
    }
}
impl Dimensions {
    /// Creates a new builder-style object to manufacture [`Dimensions`](crate::model::Dimensions)
    pub fn builder() -> crate::model::dimensions::Builder {
        crate::model::dimensions::Builder::default()
    }
}

/// <p>Contains information about a queue resource for which metrics are returned.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueueReference {
    /// <p>The identifier of the queue.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the queue.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for QueueReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueueReference");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`QueueReference`](crate::model::QueueReference)
pub mod queue_reference {
    /// A builder for [`QueueReference`](crate::model::QueueReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the queue.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the queue.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the queue.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the queue.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`QueueReference`](crate::model::QueueReference)
        pub fn build(self) -> crate::model::QueueReference {
            crate::model::QueueReference {
                id: self.id,
                arn: self.arn,
            }
        }
    }
}
impl QueueReference {
    /// Creates a new builder-style object to manufacture [`QueueReference`](crate::model::QueueReference)
    pub fn builder() -> crate::model::queue_reference::Builder {
        crate::model::queue_reference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Grouping {
    #[allow(missing_docs)] // documentation missing in model
    Channel,
    #[allow(missing_docs)] // documentation missing in model
    Queue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Grouping {
    fn from(s: &str) -> Self {
        match s {
            "CHANNEL" => Grouping::Channel,
            "QUEUE" => Grouping::Queue,
            other => Grouping::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Grouping {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Grouping::from(s))
    }
}
impl Grouping {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Grouping::Channel => "CHANNEL",
            Grouping::Queue => "QUEUE",
            Grouping::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CHANNEL", "QUEUE"]
    }
}
impl AsRef<str> for Grouping {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the filter to apply when retrieving metrics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filters {
    /// <p>The queues to use to filter the metrics. You can specify up to 100 queues per
    /// request.</p>
    pub queues: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The channel to use to filter the metrics.</p>
    pub channels: std::option::Option<std::vec::Vec<crate::model::Channel>>,
}
impl std::fmt::Debug for Filters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filters");
        formatter.field("queues", &self.queues);
        formatter.field("channels", &self.channels);
        formatter.finish()
    }
}
/// See [`Filters`](crate::model::Filters)
pub mod filters {
    /// A builder for [`Filters`](crate::model::Filters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queues: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) channels: std::option::Option<std::vec::Vec<crate::model::Channel>>,
    }
    impl Builder {
        /// Appends an item to `queues`.
        ///
        /// To override the contents of this collection use [`set_queues`](Self::set_queues).
        ///
        /// <p>The queues to use to filter the metrics. You can specify up to 100 queues per
        /// request.</p>
        pub fn queues(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.queues.unwrap_or_default();
            v.push(input.into());
            self.queues = Some(v);
            self
        }
        /// <p>The queues to use to filter the metrics. You can specify up to 100 queues per
        /// request.</p>
        pub fn set_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.queues = input;
            self
        }
        /// Appends an item to `channels`.
        ///
        /// To override the contents of this collection use [`set_channels`](Self::set_channels).
        ///
        /// <p>The channel to use to filter the metrics.</p>
        pub fn channels(mut self, input: impl Into<crate::model::Channel>) -> Self {
            let mut v = self.channels.unwrap_or_default();
            v.push(input.into());
            self.channels = Some(v);
            self
        }
        /// <p>The channel to use to filter the metrics.</p>
        pub fn set_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        ) -> Self {
            self.channels = input;
            self
        }
        /// Consumes the builder and constructs a [`Filters`](crate::model::Filters)
        pub fn build(self) -> crate::model::Filters {
            crate::model::Filters {
                queues: self.queues,
                channels: self.channels,
            }
        }
    }
}
impl Filters {
    /// Creates a new builder-style object to manufacture [`Filters`](crate::model::Filters)
    pub fn builder() -> crate::model::filters::Builder {
        crate::model::filters::Builder::default()
    }
}

/// <p>Contains credentials to use for federation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Credentials {
    /// <p>An access token generated for a federated user to access Amazon Connect.</p>
    pub access_token: std::option::Option<std::string::String>,
    /// <p>A token generated with an expiration time for the session a user is logged in to
    /// Amazon Connect.</p>
    pub access_token_expiration: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Renews a token generated for a user to access the Amazon Connect instance.</p>
    pub refresh_token: std::option::Option<std::string::String>,
    /// <p>Renews the expiration timer for a generated token.</p>
    pub refresh_token_expiration: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Credentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Credentials");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("access_token_expiration", &self.access_token_expiration);
        formatter.field("refresh_token", &"*** Sensitive Data Redacted ***");
        formatter.field("refresh_token_expiration", &self.refresh_token_expiration);
        formatter.finish()
    }
}
/// See [`Credentials`](crate::model::Credentials)
pub mod credentials {
    /// A builder for [`Credentials`](crate::model::Credentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) access_token_expiration: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) refresh_token: std::option::Option<std::string::String>,
        pub(crate) refresh_token_expiration: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>An access token generated for a federated user to access Amazon Connect.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>An access token generated for a federated user to access Amazon Connect.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p>A token generated with an expiration time for the session a user is logged in to
        /// Amazon Connect.</p>
        pub fn access_token_expiration(mut self, input: aws_smithy_types::Instant) -> Self {
            self.access_token_expiration = Some(input);
            self
        }
        /// <p>A token generated with an expiration time for the session a user is logged in to
        /// Amazon Connect.</p>
        pub fn set_access_token_expiration(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.access_token_expiration = input;
            self
        }
        /// <p>Renews a token generated for a user to access the Amazon Connect instance.</p>
        pub fn refresh_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.refresh_token = Some(input.into());
            self
        }
        /// <p>Renews a token generated for a user to access the Amazon Connect instance.</p>
        pub fn set_refresh_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.refresh_token = input;
            self
        }
        /// <p>Renews the expiration timer for a generated token.</p>
        pub fn refresh_token_expiration(mut self, input: aws_smithy_types::Instant) -> Self {
            self.refresh_token_expiration = Some(input);
            self
        }
        /// <p>Renews the expiration timer for a generated token.</p>
        pub fn set_refresh_token_expiration(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.refresh_token_expiration = input;
            self
        }
        /// Consumes the builder and constructs a [`Credentials`](crate::model::Credentials)
        pub fn build(self) -> crate::model::Credentials {
            crate::model::Credentials {
                access_token: self.access_token,
                access_token_expiration: self.access_token_expiration,
                refresh_token: self.refresh_token,
                refresh_token_expiration: self.refresh_token_expiration,
            }
        }
    }
}
impl Credentials {
    /// Creates a new builder-style object to manufacture [`Credentials`](crate::model::Credentials)
    pub fn builder() -> crate::model::credentials::Builder {
        crate::model::credentials::Builder::default()
    }
}

/// <p>Contains information about a set of real-time metrics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CurrentMetricResult {
    /// <p>The dimensions for the metrics.</p>
    pub dimensions: std::option::Option<crate::model::Dimensions>,
    /// <p>The set of metrics.</p>
    pub collections: std::option::Option<std::vec::Vec<crate::model::CurrentMetricData>>,
}
impl std::fmt::Debug for CurrentMetricResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CurrentMetricResult");
        formatter.field("dimensions", &self.dimensions);
        formatter.field("collections", &self.collections);
        formatter.finish()
    }
}
/// See [`CurrentMetricResult`](crate::model::CurrentMetricResult)
pub mod current_metric_result {
    /// A builder for [`CurrentMetricResult`](crate::model::CurrentMetricResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimensions: std::option::Option<crate::model::Dimensions>,
        pub(crate) collections: std::option::Option<std::vec::Vec<crate::model::CurrentMetricData>>,
    }
    impl Builder {
        /// <p>The dimensions for the metrics.</p>
        pub fn dimensions(mut self, input: crate::model::Dimensions) -> Self {
            self.dimensions = Some(input);
            self
        }
        /// <p>The dimensions for the metrics.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<crate::model::Dimensions>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Appends an item to `collections`.
        ///
        /// To override the contents of this collection use [`set_collections`](Self::set_collections).
        ///
        /// <p>The set of metrics.</p>
        pub fn collections(mut self, input: impl Into<crate::model::CurrentMetricData>) -> Self {
            let mut v = self.collections.unwrap_or_default();
            v.push(input.into());
            self.collections = Some(v);
            self
        }
        /// <p>The set of metrics.</p>
        pub fn set_collections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CurrentMetricData>>,
        ) -> Self {
            self.collections = input;
            self
        }
        /// Consumes the builder and constructs a [`CurrentMetricResult`](crate::model::CurrentMetricResult)
        pub fn build(self) -> crate::model::CurrentMetricResult {
            crate::model::CurrentMetricResult {
                dimensions: self.dimensions,
                collections: self.collections,
            }
        }
    }
}
impl CurrentMetricResult {
    /// Creates a new builder-style object to manufacture [`CurrentMetricResult`](crate::model::CurrentMetricResult)
    pub fn builder() -> crate::model::current_metric_result::Builder {
        crate::model::current_metric_result::Builder::default()
    }
}

/// <p>Contains the data for a real-time metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CurrentMetricData {
    /// <p>Information about the metric.</p>
    pub metric: std::option::Option<crate::model::CurrentMetric>,
    /// <p>The value of the metric.</p>
    pub value: std::option::Option<f64>,
}
impl std::fmt::Debug for CurrentMetricData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CurrentMetricData");
        formatter.field("metric", &self.metric);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CurrentMetricData`](crate::model::CurrentMetricData)
pub mod current_metric_data {
    /// A builder for [`CurrentMetricData`](crate::model::CurrentMetricData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<crate::model::CurrentMetric>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Information about the metric.</p>
        pub fn metric(mut self, input: crate::model::CurrentMetric) -> Self {
            self.metric = Some(input);
            self
        }
        /// <p>Information about the metric.</p>
        pub fn set_metric(
            mut self,
            input: std::option::Option<crate::model::CurrentMetric>,
        ) -> Self {
            self.metric = input;
            self
        }
        /// <p>The value of the metric.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the metric.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CurrentMetricData`](crate::model::CurrentMetricData)
        pub fn build(self) -> crate::model::CurrentMetricData {
            crate::model::CurrentMetricData {
                metric: self.metric,
                value: self.value,
            }
        }
    }
}
impl CurrentMetricData {
    /// Creates a new builder-style object to manufacture [`CurrentMetricData`](crate::model::CurrentMetricData)
    pub fn builder() -> crate::model::current_metric_data::Builder {
        crate::model::current_metric_data::Builder::default()
    }
}

/// <p>Contains information about a real-time metric. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator
/// Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CurrentMetric {
    /// <p>The name of the metric.</p>
    pub name: std::option::Option<crate::model::CurrentMetricName>,
    /// <p>The unit for the metric.</p>
    pub unit: std::option::Option<crate::model::Unit>,
}
impl std::fmt::Debug for CurrentMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CurrentMetric");
        formatter.field("name", &self.name);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`CurrentMetric`](crate::model::CurrentMetric)
pub mod current_metric {
    /// A builder for [`CurrentMetric`](crate::model::CurrentMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::CurrentMetricName>,
        pub(crate) unit: std::option::Option<crate::model::Unit>,
    }
    impl Builder {
        /// <p>The name of the metric.</p>
        pub fn name(mut self, input: crate::model::CurrentMetricName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the metric.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::CurrentMetricName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The unit for the metric.</p>
        pub fn unit(mut self, input: crate::model::Unit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit for the metric.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::Unit>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`CurrentMetric`](crate::model::CurrentMetric)
        pub fn build(self) -> crate::model::CurrentMetric {
            crate::model::CurrentMetric {
                name: self.name,
                unit: self.unit,
            }
        }
    }
}
impl CurrentMetric {
    /// Creates a new builder-style object to manufacture [`CurrentMetric`](crate::model::CurrentMetric)
    pub fn builder() -> crate::model::current_metric::Builder {
        crate::model::current_metric::Builder::default()
    }
}

/// <p>The current metric names.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CurrentMetricName {
    #[allow(missing_docs)] // documentation missing in model
    AgentsAfterContactWork,
    #[allow(missing_docs)] // documentation missing in model
    AgentsAvailable,
    #[allow(missing_docs)] // documentation missing in model
    AgentsError,
    #[allow(missing_docs)] // documentation missing in model
    AgentsNonProductive,
    #[allow(missing_docs)] // documentation missing in model
    AgentsOnline,
    #[allow(missing_docs)] // documentation missing in model
    AgentsOnCall,
    #[allow(missing_docs)] // documentation missing in model
    AgentsOnContact,
    #[allow(missing_docs)] // documentation missing in model
    AgentsStaffed,
    #[allow(missing_docs)] // documentation missing in model
    ContactsInQueue,
    #[allow(missing_docs)] // documentation missing in model
    ContactsScheduled,
    #[allow(missing_docs)] // documentation missing in model
    OldestContactAge,
    #[allow(missing_docs)] // documentation missing in model
    SlotsActive,
    #[allow(missing_docs)] // documentation missing in model
    SlotsAvailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CurrentMetricName {
    fn from(s: &str) -> Self {
        match s {
            "AGENTS_AFTER_CONTACT_WORK" => CurrentMetricName::AgentsAfterContactWork,
            "AGENTS_AVAILABLE" => CurrentMetricName::AgentsAvailable,
            "AGENTS_ERROR" => CurrentMetricName::AgentsError,
            "AGENTS_NON_PRODUCTIVE" => CurrentMetricName::AgentsNonProductive,
            "AGENTS_ONLINE" => CurrentMetricName::AgentsOnline,
            "AGENTS_ON_CALL" => CurrentMetricName::AgentsOnCall,
            "AGENTS_ON_CONTACT" => CurrentMetricName::AgentsOnContact,
            "AGENTS_STAFFED" => CurrentMetricName::AgentsStaffed,
            "CONTACTS_IN_QUEUE" => CurrentMetricName::ContactsInQueue,
            "CONTACTS_SCHEDULED" => CurrentMetricName::ContactsScheduled,
            "OLDEST_CONTACT_AGE" => CurrentMetricName::OldestContactAge,
            "SLOTS_ACTIVE" => CurrentMetricName::SlotsActive,
            "SLOTS_AVAILABLE" => CurrentMetricName::SlotsAvailable,
            other => CurrentMetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CurrentMetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CurrentMetricName::from(s))
    }
}
impl CurrentMetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CurrentMetricName::AgentsAfterContactWork => "AGENTS_AFTER_CONTACT_WORK",
            CurrentMetricName::AgentsAvailable => "AGENTS_AVAILABLE",
            CurrentMetricName::AgentsError => "AGENTS_ERROR",
            CurrentMetricName::AgentsNonProductive => "AGENTS_NON_PRODUCTIVE",
            CurrentMetricName::AgentsOnline => "AGENTS_ONLINE",
            CurrentMetricName::AgentsOnCall => "AGENTS_ON_CALL",
            CurrentMetricName::AgentsOnContact => "AGENTS_ON_CONTACT",
            CurrentMetricName::AgentsStaffed => "AGENTS_STAFFED",
            CurrentMetricName::ContactsInQueue => "CONTACTS_IN_QUEUE",
            CurrentMetricName::ContactsScheduled => "CONTACTS_SCHEDULED",
            CurrentMetricName::OldestContactAge => "OLDEST_CONTACT_AGE",
            CurrentMetricName::SlotsActive => "SLOTS_ACTIVE",
            CurrentMetricName::SlotsAvailable => "SLOTS_AVAILABLE",
            CurrentMetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AGENTS_AFTER_CONTACT_WORK",
            "AGENTS_AVAILABLE",
            "AGENTS_ERROR",
            "AGENTS_NON_PRODUCTIVE",
            "AGENTS_ONLINE",
            "AGENTS_ON_CALL",
            "AGENTS_ON_CONTACT",
            "AGENTS_STAFFED",
            "CONTACTS_IN_QUEUE",
            "CONTACTS_SCHEDULED",
            "OLDEST_CONTACT_AGE",
            "SLOTS_ACTIVE",
            "SLOTS_AVAILABLE",
        ]
    }
}
impl AsRef<str> for CurrentMetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a hierarchy structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HierarchyStructure {
    /// <p>Information about level one.</p>
    pub level_one: std::option::Option<crate::model::HierarchyLevel>,
    /// <p>Information about level two.</p>
    pub level_two: std::option::Option<crate::model::HierarchyLevel>,
    /// <p>Information about level three.</p>
    pub level_three: std::option::Option<crate::model::HierarchyLevel>,
    /// <p>Information about level four.</p>
    pub level_four: std::option::Option<crate::model::HierarchyLevel>,
    /// <p>Information about level five.</p>
    pub level_five: std::option::Option<crate::model::HierarchyLevel>,
}
impl std::fmt::Debug for HierarchyStructure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HierarchyStructure");
        formatter.field("level_one", &self.level_one);
        formatter.field("level_two", &self.level_two);
        formatter.field("level_three", &self.level_three);
        formatter.field("level_four", &self.level_four);
        formatter.field("level_five", &self.level_five);
        formatter.finish()
    }
}
/// See [`HierarchyStructure`](crate::model::HierarchyStructure)
pub mod hierarchy_structure {
    /// A builder for [`HierarchyStructure`](crate::model::HierarchyStructure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) level_one: std::option::Option<crate::model::HierarchyLevel>,
        pub(crate) level_two: std::option::Option<crate::model::HierarchyLevel>,
        pub(crate) level_three: std::option::Option<crate::model::HierarchyLevel>,
        pub(crate) level_four: std::option::Option<crate::model::HierarchyLevel>,
        pub(crate) level_five: std::option::Option<crate::model::HierarchyLevel>,
    }
    impl Builder {
        /// <p>Information about level one.</p>
        pub fn level_one(mut self, input: crate::model::HierarchyLevel) -> Self {
            self.level_one = Some(input);
            self
        }
        /// <p>Information about level one.</p>
        pub fn set_level_one(
            mut self,
            input: std::option::Option<crate::model::HierarchyLevel>,
        ) -> Self {
            self.level_one = input;
            self
        }
        /// <p>Information about level two.</p>
        pub fn level_two(mut self, input: crate::model::HierarchyLevel) -> Self {
            self.level_two = Some(input);
            self
        }
        /// <p>Information about level two.</p>
        pub fn set_level_two(
            mut self,
            input: std::option::Option<crate::model::HierarchyLevel>,
        ) -> Self {
            self.level_two = input;
            self
        }
        /// <p>Information about level three.</p>
        pub fn level_three(mut self, input: crate::model::HierarchyLevel) -> Self {
            self.level_three = Some(input);
            self
        }
        /// <p>Information about level three.</p>
        pub fn set_level_three(
            mut self,
            input: std::option::Option<crate::model::HierarchyLevel>,
        ) -> Self {
            self.level_three = input;
            self
        }
        /// <p>Information about level four.</p>
        pub fn level_four(mut self, input: crate::model::HierarchyLevel) -> Self {
            self.level_four = Some(input);
            self
        }
        /// <p>Information about level four.</p>
        pub fn set_level_four(
            mut self,
            input: std::option::Option<crate::model::HierarchyLevel>,
        ) -> Self {
            self.level_four = input;
            self
        }
        /// <p>Information about level five.</p>
        pub fn level_five(mut self, input: crate::model::HierarchyLevel) -> Self {
            self.level_five = Some(input);
            self
        }
        /// <p>Information about level five.</p>
        pub fn set_level_five(
            mut self,
            input: std::option::Option<crate::model::HierarchyLevel>,
        ) -> Self {
            self.level_five = input;
            self
        }
        /// Consumes the builder and constructs a [`HierarchyStructure`](crate::model::HierarchyStructure)
        pub fn build(self) -> crate::model::HierarchyStructure {
            crate::model::HierarchyStructure {
                level_one: self.level_one,
                level_two: self.level_two,
                level_three: self.level_three,
                level_four: self.level_four,
                level_five: self.level_five,
            }
        }
    }
}
impl HierarchyStructure {
    /// Creates a new builder-style object to manufacture [`HierarchyStructure`](crate::model::HierarchyStructure)
    pub fn builder() -> crate::model::hierarchy_structure::Builder {
        crate::model::hierarchy_structure::Builder::default()
    }
}

/// <p>Contains information about a hierarchy level.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HierarchyLevel {
    /// <p>The identifier of the hierarchy level.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the hierarchy level.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the hierarchy level.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HierarchyLevel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HierarchyLevel");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`HierarchyLevel`](crate::model::HierarchyLevel)
pub mod hierarchy_level {
    /// A builder for [`HierarchyLevel`](crate::model::HierarchyLevel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the hierarchy level.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the hierarchy level.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hierarchy level.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hierarchy level.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the hierarchy level.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hierarchy level.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`HierarchyLevel`](crate::model::HierarchyLevel)
        pub fn build(self) -> crate::model::HierarchyLevel {
            crate::model::HierarchyLevel {
                id: self.id,
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl HierarchyLevel {
    /// Creates a new builder-style object to manufacture [`HierarchyLevel`](crate::model::HierarchyLevel)
    pub fn builder() -> crate::model::hierarchy_level::Builder {
        crate::model::hierarchy_level::Builder::default()
    }
}

/// <p>Contains information about a hierarchy group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HierarchyGroup {
    /// <p>The identifier of the hierarchy group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the hierarchy group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the hierarchy group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The identifier of the level in the hierarchy group.</p>
    pub level_id: std::option::Option<std::string::String>,
    /// <p>Information about the levels in the hierarchy group.</p>
    pub hierarchy_path: std::option::Option<crate::model::HierarchyPath>,
}
impl std::fmt::Debug for HierarchyGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HierarchyGroup");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("level_id", &self.level_id);
        formatter.field("hierarchy_path", &self.hierarchy_path);
        formatter.finish()
    }
}
/// See [`HierarchyGroup`](crate::model::HierarchyGroup)
pub mod hierarchy_group {
    /// A builder for [`HierarchyGroup`](crate::model::HierarchyGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) level_id: std::option::Option<std::string::String>,
        pub(crate) hierarchy_path: std::option::Option<crate::model::HierarchyPath>,
    }
    impl Builder {
        /// <p>The identifier of the hierarchy group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hierarchy group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hierarchy group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the hierarchy group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hierarchy group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier of the level in the hierarchy group.</p>
        pub fn level_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.level_id = Some(input.into());
            self
        }
        /// <p>The identifier of the level in the hierarchy group.</p>
        pub fn set_level_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.level_id = input;
            self
        }
        /// <p>Information about the levels in the hierarchy group.</p>
        pub fn hierarchy_path(mut self, input: crate::model::HierarchyPath) -> Self {
            self.hierarchy_path = Some(input);
            self
        }
        /// <p>Information about the levels in the hierarchy group.</p>
        pub fn set_hierarchy_path(
            mut self,
            input: std::option::Option<crate::model::HierarchyPath>,
        ) -> Self {
            self.hierarchy_path = input;
            self
        }
        /// Consumes the builder and constructs a [`HierarchyGroup`](crate::model::HierarchyGroup)
        pub fn build(self) -> crate::model::HierarchyGroup {
            crate::model::HierarchyGroup {
                id: self.id,
                arn: self.arn,
                name: self.name,
                level_id: self.level_id,
                hierarchy_path: self.hierarchy_path,
            }
        }
    }
}
impl HierarchyGroup {
    /// Creates a new builder-style object to manufacture [`HierarchyGroup`](crate::model::HierarchyGroup)
    pub fn builder() -> crate::model::hierarchy_group::Builder {
        crate::model::hierarchy_group::Builder::default()
    }
}

/// <p>Contains information about the levels of a hierarchy group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HierarchyPath {
    /// <p>Information about level one.</p>
    pub level_one: std::option::Option<crate::model::HierarchyGroupSummary>,
    /// <p>Information about level two.</p>
    pub level_two: std::option::Option<crate::model::HierarchyGroupSummary>,
    /// <p>Information about level three.</p>
    pub level_three: std::option::Option<crate::model::HierarchyGroupSummary>,
    /// <p>Information about level four.</p>
    pub level_four: std::option::Option<crate::model::HierarchyGroupSummary>,
    /// <p>Information about level five.</p>
    pub level_five: std::option::Option<crate::model::HierarchyGroupSummary>,
}
impl std::fmt::Debug for HierarchyPath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HierarchyPath");
        formatter.field("level_one", &self.level_one);
        formatter.field("level_two", &self.level_two);
        formatter.field("level_three", &self.level_three);
        formatter.field("level_four", &self.level_four);
        formatter.field("level_five", &self.level_five);
        formatter.finish()
    }
}
/// See [`HierarchyPath`](crate::model::HierarchyPath)
pub mod hierarchy_path {
    /// A builder for [`HierarchyPath`](crate::model::HierarchyPath)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) level_one: std::option::Option<crate::model::HierarchyGroupSummary>,
        pub(crate) level_two: std::option::Option<crate::model::HierarchyGroupSummary>,
        pub(crate) level_three: std::option::Option<crate::model::HierarchyGroupSummary>,
        pub(crate) level_four: std::option::Option<crate::model::HierarchyGroupSummary>,
        pub(crate) level_five: std::option::Option<crate::model::HierarchyGroupSummary>,
    }
    impl Builder {
        /// <p>Information about level one.</p>
        pub fn level_one(mut self, input: crate::model::HierarchyGroupSummary) -> Self {
            self.level_one = Some(input);
            self
        }
        /// <p>Information about level one.</p>
        pub fn set_level_one(
            mut self,
            input: std::option::Option<crate::model::HierarchyGroupSummary>,
        ) -> Self {
            self.level_one = input;
            self
        }
        /// <p>Information about level two.</p>
        pub fn level_two(mut self, input: crate::model::HierarchyGroupSummary) -> Self {
            self.level_two = Some(input);
            self
        }
        /// <p>Information about level two.</p>
        pub fn set_level_two(
            mut self,
            input: std::option::Option<crate::model::HierarchyGroupSummary>,
        ) -> Self {
            self.level_two = input;
            self
        }
        /// <p>Information about level three.</p>
        pub fn level_three(mut self, input: crate::model::HierarchyGroupSummary) -> Self {
            self.level_three = Some(input);
            self
        }
        /// <p>Information about level three.</p>
        pub fn set_level_three(
            mut self,
            input: std::option::Option<crate::model::HierarchyGroupSummary>,
        ) -> Self {
            self.level_three = input;
            self
        }
        /// <p>Information about level four.</p>
        pub fn level_four(mut self, input: crate::model::HierarchyGroupSummary) -> Self {
            self.level_four = Some(input);
            self
        }
        /// <p>Information about level four.</p>
        pub fn set_level_four(
            mut self,
            input: std::option::Option<crate::model::HierarchyGroupSummary>,
        ) -> Self {
            self.level_four = input;
            self
        }
        /// <p>Information about level five.</p>
        pub fn level_five(mut self, input: crate::model::HierarchyGroupSummary) -> Self {
            self.level_five = Some(input);
            self
        }
        /// <p>Information about level five.</p>
        pub fn set_level_five(
            mut self,
            input: std::option::Option<crate::model::HierarchyGroupSummary>,
        ) -> Self {
            self.level_five = input;
            self
        }
        /// Consumes the builder and constructs a [`HierarchyPath`](crate::model::HierarchyPath)
        pub fn build(self) -> crate::model::HierarchyPath {
            crate::model::HierarchyPath {
                level_one: self.level_one,
                level_two: self.level_two,
                level_three: self.level_three,
                level_four: self.level_four,
                level_five: self.level_five,
            }
        }
    }
}
impl HierarchyPath {
    /// Creates a new builder-style object to manufacture [`HierarchyPath`](crate::model::HierarchyPath)
    pub fn builder() -> crate::model::hierarchy_path::Builder {
        crate::model::hierarchy_path::Builder::default()
    }
}

/// <p>Contains information about a user account for a Amazon Connect instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct User {
    /// <p>The identifier of the user account.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the user account.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The user name assigned to the user account.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>Information about the user identity.</p>
    pub identity_info: std::option::Option<crate::model::UserIdentityInfo>,
    /// <p>Information about the phone configuration for the user.</p>
    pub phone_config: std::option::Option<crate::model::UserPhoneConfig>,
    /// <p>The identifier of the user account in the directory used for identity management.</p>
    pub directory_user_id: std::option::Option<std::string::String>,
    /// <p>The identifiers of the security profiles for the user.</p>
    pub security_profile_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The identifier of the routing profile for the user.</p>
    pub routing_profile_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the hierarchy group for the user.</p>
    pub hierarchy_group_id: std::option::Option<std::string::String>,
    /// <p>The
    /// tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for User {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("User");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("username", &self.username);
        formatter.field("identity_info", &self.identity_info);
        formatter.field("phone_config", &self.phone_config);
        formatter.field("directory_user_id", &self.directory_user_id);
        formatter.field("security_profile_ids", &self.security_profile_ids);
        formatter.field("routing_profile_id", &self.routing_profile_id);
        formatter.field("hierarchy_group_id", &self.hierarchy_group_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`User`](crate::model::User)
pub mod user {
    /// A builder for [`User`](crate::model::User)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) identity_info: std::option::Option<crate::model::UserIdentityInfo>,
        pub(crate) phone_config: std::option::Option<crate::model::UserPhoneConfig>,
        pub(crate) directory_user_id: std::option::Option<std::string::String>,
        pub(crate) security_profile_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) routing_profile_id: std::option::Option<std::string::String>,
        pub(crate) hierarchy_group_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the user account.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user account.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user account.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The user name assigned to the user account.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name assigned to the user account.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>Information about the user identity.</p>
        pub fn identity_info(mut self, input: crate::model::UserIdentityInfo) -> Self {
            self.identity_info = Some(input);
            self
        }
        /// <p>Information about the user identity.</p>
        pub fn set_identity_info(
            mut self,
            input: std::option::Option<crate::model::UserIdentityInfo>,
        ) -> Self {
            self.identity_info = input;
            self
        }
        /// <p>Information about the phone configuration for the user.</p>
        pub fn phone_config(mut self, input: crate::model::UserPhoneConfig) -> Self {
            self.phone_config = Some(input);
            self
        }
        /// <p>Information about the phone configuration for the user.</p>
        pub fn set_phone_config(
            mut self,
            input: std::option::Option<crate::model::UserPhoneConfig>,
        ) -> Self {
            self.phone_config = input;
            self
        }
        /// <p>The identifier of the user account in the directory used for identity management.</p>
        pub fn directory_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user account in the directory used for identity management.</p>
        pub fn set_directory_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_user_id = input;
            self
        }
        /// Appends an item to `security_profile_ids`.
        ///
        /// To override the contents of this collection use [`set_security_profile_ids`](Self::set_security_profile_ids).
        ///
        /// <p>The identifiers of the security profiles for the user.</p>
        pub fn security_profile_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_profile_ids.unwrap_or_default();
            v.push(input.into());
            self.security_profile_ids = Some(v);
            self
        }
        /// <p>The identifiers of the security profiles for the user.</p>
        pub fn set_security_profile_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_profile_ids = input;
            self
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_profile_id = Some(input.into());
            self
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_profile_id = input;
            self
        }
        /// <p>The identifier of the hierarchy group for the user.</p>
        pub fn hierarchy_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hierarchy_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the hierarchy group for the user.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hierarchy_group_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The
        /// tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The
        /// tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`User`](crate::model::User)
        pub fn build(self) -> crate::model::User {
            crate::model::User {
                id: self.id,
                arn: self.arn,
                username: self.username,
                identity_info: self.identity_info,
                phone_config: self.phone_config,
                directory_user_id: self.directory_user_id,
                security_profile_ids: self.security_profile_ids,
                routing_profile_id: self.routing_profile_id,
                hierarchy_group_id: self.hierarchy_group_id,
                tags: self.tags,
            }
        }
    }
}
impl User {
    /// Creates a new builder-style object to manufacture [`User`](crate::model::User)
    pub fn builder() -> crate::model::user::Builder {
        crate::model::user::Builder::default()
    }
}

/// <p>Contains information about a routing profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoutingProfile {
    /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The name of the routing profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the routing profile.</p>
    pub routing_profile_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the routing profile.</p>
    pub routing_profile_id: std::option::Option<std::string::String>,
    /// <p>The description of the routing profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The channels agents can handle in the Contact Control Panel (CCP) for this routing
    /// profile.</p>
    pub media_concurrencies: std::option::Option<std::vec::Vec<crate::model::MediaConcurrency>>,
    /// <p>The identifier of the default outbound queue for this routing profile.</p>
    pub default_outbound_queue_id: std::option::Option<std::string::String>,
    /// <p>One or more tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for RoutingProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoutingProfile");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("name", &self.name);
        formatter.field("routing_profile_arn", &self.routing_profile_arn);
        formatter.field("routing_profile_id", &self.routing_profile_id);
        formatter.field("description", &self.description);
        formatter.field("media_concurrencies", &self.media_concurrencies);
        formatter.field("default_outbound_queue_id", &self.default_outbound_queue_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`RoutingProfile`](crate::model::RoutingProfile)
pub mod routing_profile {
    /// A builder for [`RoutingProfile`](crate::model::RoutingProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) routing_profile_arn: std::option::Option<std::string::String>,
        pub(crate) routing_profile_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) media_concurrencies:
            std::option::Option<std::vec::Vec<crate::model::MediaConcurrency>>,
        pub(crate) default_outbound_queue_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The name of the routing profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the routing profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing profile.</p>
        pub fn routing_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_profile_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing profile.</p>
        pub fn set_routing_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_profile_arn = input;
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_profile_id = Some(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_profile_id = input;
            self
        }
        /// <p>The description of the routing profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the routing profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `media_concurrencies`.
        ///
        /// To override the contents of this collection use [`set_media_concurrencies`](Self::set_media_concurrencies).
        ///
        /// <p>The channels agents can handle in the Contact Control Panel (CCP) for this routing
        /// profile.</p>
        pub fn media_concurrencies(
            mut self,
            input: impl Into<crate::model::MediaConcurrency>,
        ) -> Self {
            let mut v = self.media_concurrencies.unwrap_or_default();
            v.push(input.into());
            self.media_concurrencies = Some(v);
            self
        }
        /// <p>The channels agents can handle in the Contact Control Panel (CCP) for this routing
        /// profile.</p>
        pub fn set_media_concurrencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConcurrency>>,
        ) -> Self {
            self.media_concurrencies = input;
            self
        }
        /// <p>The identifier of the default outbound queue for this routing profile.</p>
        pub fn default_outbound_queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_outbound_queue_id = Some(input.into());
            self
        }
        /// <p>The identifier of the default outbound queue for this routing profile.</p>
        pub fn set_default_outbound_queue_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_outbound_queue_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RoutingProfile`](crate::model::RoutingProfile)
        pub fn build(self) -> crate::model::RoutingProfile {
            crate::model::RoutingProfile {
                instance_id: self.instance_id,
                name: self.name,
                routing_profile_arn: self.routing_profile_arn,
                routing_profile_id: self.routing_profile_id,
                description: self.description,
                media_concurrencies: self.media_concurrencies,
                default_outbound_queue_id: self.default_outbound_queue_id,
                tags: self.tags,
            }
        }
    }
}
impl RoutingProfile {
    /// Creates a new builder-style object to manufacture [`RoutingProfile`](crate::model::RoutingProfile)
    pub fn builder() -> crate::model::routing_profile::Builder {
        crate::model::routing_profile::Builder::default()
    }
}

/// <p>Contains information about a quick connect.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QuickConnect {
    /// <p>The Amazon Resource Name (ARN) of the quick connect.</p>
    pub quick_connect_arn: std::option::Option<std::string::String>,
    /// <p>The identifier for the quick connect.</p>
    pub quick_connect_id: std::option::Option<std::string::String>,
    /// <p>The name of the quick connect.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Contains information about the quick connect.</p>
    pub quick_connect_config: std::option::Option<crate::model::QuickConnectConfig>,
    /// <p>One or more tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for QuickConnect {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QuickConnect");
        formatter.field("quick_connect_arn", &self.quick_connect_arn);
        formatter.field("quick_connect_id", &self.quick_connect_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("quick_connect_config", &self.quick_connect_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`QuickConnect`](crate::model::QuickConnect)
pub mod quick_connect {
    /// A builder for [`QuickConnect`](crate::model::QuickConnect)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quick_connect_arn: std::option::Option<std::string::String>,
        pub(crate) quick_connect_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) quick_connect_config: std::option::Option<crate::model::QuickConnectConfig>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the quick connect.</p>
        pub fn quick_connect_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.quick_connect_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the quick connect.</p>
        pub fn set_quick_connect_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quick_connect_arn = input;
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn quick_connect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.quick_connect_id = Some(input.into());
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_quick_connect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quick_connect_id = input;
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Contains information about the quick connect.</p>
        pub fn quick_connect_config(mut self, input: crate::model::QuickConnectConfig) -> Self {
            self.quick_connect_config = Some(input);
            self
        }
        /// <p>Contains information about the quick connect.</p>
        pub fn set_quick_connect_config(
            mut self,
            input: std::option::Option<crate::model::QuickConnectConfig>,
        ) -> Self {
            self.quick_connect_config = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`QuickConnect`](crate::model::QuickConnect)
        pub fn build(self) -> crate::model::QuickConnect {
            crate::model::QuickConnect {
                quick_connect_arn: self.quick_connect_arn,
                quick_connect_id: self.quick_connect_id,
                name: self.name,
                description: self.description,
                quick_connect_config: self.quick_connect_config,
                tags: self.tags,
            }
        }
    }
}
impl QuickConnect {
    /// Creates a new builder-style object to manufacture [`QuickConnect`](crate::model::QuickConnect)
    pub fn builder() -> crate::model::quick_connect::Builder {
        crate::model::quick_connect::Builder::default()
    }
}

/// <p>Contains information about a queue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Queue {
    /// <p>The name of the queue.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the queue.</p>
    pub queue_arn: std::option::Option<std::string::String>,
    /// <p>The identifier for the queue.</p>
    pub queue_id: std::option::Option<std::string::String>,
    /// <p>The description of the queue.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
    pub outbound_caller_config: std::option::Option<crate::model::OutboundCallerConfig>,
    /// <p>The identifier for the hours of operation.</p>
    pub hours_of_operation_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
    pub max_contacts: std::option::Option<i32>,
    /// <p>The status of the queue.</p>
    pub status: std::option::Option<crate::model::QueueStatus>,
    /// <p>One or more tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Queue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Queue");
        formatter.field("name", &self.name);
        formatter.field("queue_arn", &self.queue_arn);
        formatter.field("queue_id", &self.queue_id);
        formatter.field("description", &self.description);
        formatter.field("outbound_caller_config", &self.outbound_caller_config);
        formatter.field("hours_of_operation_id", &self.hours_of_operation_id);
        formatter.field("max_contacts", &self.max_contacts);
        formatter.field("status", &self.status);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Queue`](crate::model::Queue)
pub mod queue {
    /// A builder for [`Queue`](crate::model::Queue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) queue_arn: std::option::Option<std::string::String>,
        pub(crate) queue_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) outbound_caller_config: std::option::Option<crate::model::OutboundCallerConfig>,
        pub(crate) hours_of_operation_id: std::option::Option<std::string::String>,
        pub(crate) max_contacts: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::QueueStatus>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the queue.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the queue.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the queue.</p>
        pub fn queue_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the queue.</p>
        pub fn set_queue_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_arn = input;
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_id = Some(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_id = input;
            self
        }
        /// <p>The description of the queue.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the queue.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn outbound_caller_config(mut self, input: crate::model::OutboundCallerConfig) -> Self {
            self.outbound_caller_config = Some(input);
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn set_outbound_caller_config(
            mut self,
            input: std::option::Option<crate::model::OutboundCallerConfig>,
        ) -> Self {
            self.outbound_caller_config = input;
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hours_of_operation_id = Some(input.into());
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hours_of_operation_id = input;
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn max_contacts(mut self, input: i32) -> Self {
            self.max_contacts = Some(input);
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn set_max_contacts(mut self, input: std::option::Option<i32>) -> Self {
            self.max_contacts = input;
            self
        }
        /// <p>The status of the queue.</p>
        pub fn status(mut self, input: crate::model::QueueStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the queue.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::QueueStatus>) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Queue`](crate::model::Queue)
        pub fn build(self) -> crate::model::Queue {
            crate::model::Queue {
                name: self.name,
                queue_arn: self.queue_arn,
                queue_id: self.queue_id,
                description: self.description,
                outbound_caller_config: self.outbound_caller_config,
                hours_of_operation_id: self.hours_of_operation_id,
                max_contacts: self.max_contacts,
                status: self.status,
                tags: self.tags,
            }
        }
    }
}
impl Queue {
    /// Creates a new builder-style object to manufacture [`Queue`](crate::model::Queue)
    pub fn builder() -> crate::model::queue::Builder {
        crate::model::queue::Builder::default()
    }
}

/// <p>The Amazon Connect instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the instance.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The identity management type.</p>
    pub identity_management_type: std::option::Option<crate::model::DirectoryType>,
    /// <p>The alias of instance.</p>
    pub instance_alias: std::option::Option<std::string::String>,
    /// <p>When the instance was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The service role of the instance.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>The state of the instance.</p>
    pub instance_status: std::option::Option<crate::model::InstanceStatus>,
    /// <p>Relevant
    /// details why the instance was not successfully created. </p>
    pub status_reason: std::option::Option<crate::model::InstanceStatusReason>,
    /// <p>Whether inbound calls are enabled.</p>
    pub inbound_calls_enabled: std::option::Option<bool>,
    /// <p>Whether outbound calls are enabled.</p>
    pub outbound_calls_enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("identity_management_type", &self.identity_management_type);
        formatter.field("instance_alias", &"*** Sensitive Data Redacted ***");
        formatter.field("created_time", &self.created_time);
        formatter.field("service_role", &self.service_role);
        formatter.field("instance_status", &self.instance_status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("inbound_calls_enabled", &self.inbound_calls_enabled);
        formatter.field("outbound_calls_enabled", &self.outbound_calls_enabled);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) identity_management_type: std::option::Option<crate::model::DirectoryType>,
        pub(crate) instance_alias: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) instance_status: std::option::Option<crate::model::InstanceStatus>,
        pub(crate) status_reason: std::option::Option<crate::model::InstanceStatusReason>,
        pub(crate) inbound_calls_enabled: std::option::Option<bool>,
        pub(crate) outbound_calls_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The identity management type.</p>
        pub fn identity_management_type(mut self, input: crate::model::DirectoryType) -> Self {
            self.identity_management_type = Some(input);
            self
        }
        /// <p>The identity management type.</p>
        pub fn set_identity_management_type(
            mut self,
            input: std::option::Option<crate::model::DirectoryType>,
        ) -> Self {
            self.identity_management_type = input;
            self
        }
        /// <p>The alias of instance.</p>
        pub fn instance_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_alias = Some(input.into());
            self
        }
        /// <p>The alias of instance.</p>
        pub fn set_instance_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_alias = input;
            self
        }
        /// <p>When the instance was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>When the instance was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The service role of the instance.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The service role of the instance.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>The state of the instance.</p>
        pub fn instance_status(mut self, input: crate::model::InstanceStatus) -> Self {
            self.instance_status = Some(input);
            self
        }
        /// <p>The state of the instance.</p>
        pub fn set_instance_status(
            mut self,
            input: std::option::Option<crate::model::InstanceStatus>,
        ) -> Self {
            self.instance_status = input;
            self
        }
        /// <p>Relevant
        /// details why the instance was not successfully created. </p>
        pub fn status_reason(mut self, input: crate::model::InstanceStatusReason) -> Self {
            self.status_reason = Some(input);
            self
        }
        /// <p>Relevant
        /// details why the instance was not successfully created. </p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<crate::model::InstanceStatusReason>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>Whether inbound calls are enabled.</p>
        pub fn inbound_calls_enabled(mut self, input: bool) -> Self {
            self.inbound_calls_enabled = Some(input);
            self
        }
        /// <p>Whether inbound calls are enabled.</p>
        pub fn set_inbound_calls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inbound_calls_enabled = input;
            self
        }
        /// <p>Whether outbound calls are enabled.</p>
        pub fn outbound_calls_enabled(mut self, input: bool) -> Self {
            self.outbound_calls_enabled = Some(input);
            self
        }
        /// <p>Whether outbound calls are enabled.</p>
        pub fn set_outbound_calls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.outbound_calls_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance {
                id: self.id,
                arn: self.arn,
                identity_management_type: self.identity_management_type,
                instance_alias: self.instance_alias,
                created_time: self.created_time,
                service_role: self.service_role,
                instance_status: self.instance_status,
                status_reason: self.status_reason,
                inbound_calls_enabled: self.inbound_calls_enabled,
                outbound_calls_enabled: self.outbound_calls_enabled,
            }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

/// <p>Relevant
/// details why the instance was not successfully created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceStatusReason {
    /// <p>The message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceStatusReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceStatusReason");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`InstanceStatusReason`](crate::model::InstanceStatusReason)
pub mod instance_status_reason {
    /// A builder for [`InstanceStatusReason`](crate::model::InstanceStatusReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceStatusReason`](crate::model::InstanceStatusReason)
        pub fn build(self) -> crate::model::InstanceStatusReason {
            crate::model::InstanceStatusReason {
                message: self.message,
            }
        }
    }
}
impl InstanceStatusReason {
    /// Creates a new builder-style object to manufacture [`InstanceStatusReason`](crate::model::InstanceStatusReason)
    pub fn builder() -> crate::model::instance_status_reason::Builder {
        crate::model::instance_status_reason::Builder::default()
    }
}

/// <p>Information about of the hours of operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HoursOfOperation {
    /// <p>The identifier for the hours of operation.</p>
    pub hours_of_operation_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the hours of operation.</p>
    pub hours_of_operation_arn: std::option::Option<std::string::String>,
    /// <p>The name for the hours of operation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description for the hours of operation.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The time zone for the hours of operation.</p>
    pub time_zone: std::option::Option<std::string::String>,
    /// <p>Configuration information for the hours of operation.</p>
    pub config: std::option::Option<std::vec::Vec<crate::model::HoursOfOperationConfig>>,
    /// <p>One or more tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for HoursOfOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HoursOfOperation");
        formatter.field("hours_of_operation_id", &self.hours_of_operation_id);
        formatter.field("hours_of_operation_arn", &self.hours_of_operation_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("time_zone", &self.time_zone);
        formatter.field("config", &self.config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`HoursOfOperation`](crate::model::HoursOfOperation)
pub mod hours_of_operation {
    /// A builder for [`HoursOfOperation`](crate::model::HoursOfOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hours_of_operation_id: std::option::Option<std::string::String>,
        pub(crate) hours_of_operation_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) time_zone: std::option::Option<std::string::String>,
        pub(crate) config: std::option::Option<std::vec::Vec<crate::model::HoursOfOperationConfig>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hours_of_operation_id = Some(input.into());
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hours_of_operation_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the hours of operation.</p>
        pub fn hours_of_operation_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hours_of_operation_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the hours of operation.</p>
        pub fn set_hours_of_operation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hours_of_operation_arn = input;
            self
        }
        /// <p>The name for the hours of operation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the hours of operation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description for the hours of operation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the hours of operation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The time zone for the hours of operation.</p>
        pub fn time_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone = Some(input.into());
            self
        }
        /// <p>The time zone for the hours of operation.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone = input;
            self
        }
        /// Appends an item to `config`.
        ///
        /// To override the contents of this collection use [`set_config`](Self::set_config).
        ///
        /// <p>Configuration information for the hours of operation.</p>
        pub fn config(mut self, input: impl Into<crate::model::HoursOfOperationConfig>) -> Self {
            let mut v = self.config.unwrap_or_default();
            v.push(input.into());
            self.config = Some(v);
            self
        }
        /// <p>Configuration information for the hours of operation.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HoursOfOperationConfig>>,
        ) -> Self {
            self.config = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`HoursOfOperation`](crate::model::HoursOfOperation)
        pub fn build(self) -> crate::model::HoursOfOperation {
            crate::model::HoursOfOperation {
                hours_of_operation_id: self.hours_of_operation_id,
                hours_of_operation_arn: self.hours_of_operation_arn,
                name: self.name,
                description: self.description,
                time_zone: self.time_zone,
                config: self.config,
                tags: self.tags,
            }
        }
    }
}
impl HoursOfOperation {
    /// Creates a new builder-style object to manufacture [`HoursOfOperation`](crate::model::HoursOfOperation)
    pub fn builder() -> crate::model::hours_of_operation::Builder {
        crate::model::hours_of_operation::Builder::default()
    }
}

/// <p>Contains information about a contact flow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactFlow {
    /// <p>The Amazon Resource Name (ARN) of the contact flow.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the contact flow.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the contact flow.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator
    /// Guide</i>.</p>
    pub r#type: std::option::Option<crate::model::ContactFlowType>,
    /// <p>The description of the contact flow.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The content of the contact flow.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>One or more tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ContactFlow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactFlow");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("content", &self.content);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ContactFlow`](crate::model::ContactFlow)
pub mod contact_flow {
    /// A builder for [`ContactFlow`](crate::model::ContactFlow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ContactFlowType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact flow.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact flow.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator
        /// Guide</i>.</p>
        pub fn r#type(mut self, input: crate::model::ContactFlowType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator
        /// Guide</i>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ContactFlowType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The description of the contact flow.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the contact flow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The content of the contact flow.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the contact flow.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactFlow`](crate::model::ContactFlow)
        pub fn build(self) -> crate::model::ContactFlow {
            crate::model::ContactFlow {
                arn: self.arn,
                id: self.id,
                name: self.name,
                r#type: self.r#type,
                description: self.description,
                content: self.content,
                tags: self.tags,
            }
        }
    }
}
impl ContactFlow {
    /// Creates a new builder-style object to manufacture [`ContactFlow`](crate::model::ContactFlow)
    pub fn builder() -> crate::model::contact_flow::Builder {
        crate::model::contact_flow::Builder::default()
    }
}

/// <p>Contains information about an agent status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentStatus {
    /// <p>The Amazon Resource Name (ARN) of the agent status.</p>
    pub agent_status_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the agent status.</p>
    pub agent_status_id: std::option::Option<std::string::String>,
    /// <p>The name of the agent status.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the agent status.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of agent status.</p>
    pub r#type: std::option::Option<crate::model::AgentStatusType>,
    /// <p>The display order of the agent status.</p>
    pub display_order: std::option::Option<i32>,
    /// <p>The state of the agent status.</p>
    pub state: std::option::Option<crate::model::AgentStatusState>,
    /// <p>One or more tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for AgentStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentStatus");
        formatter.field("agent_status_arn", &self.agent_status_arn);
        formatter.field("agent_status_id", &self.agent_status_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("display_order", &self.display_order);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AgentStatus`](crate::model::AgentStatus)
pub mod agent_status {
    /// A builder for [`AgentStatus`](crate::model::AgentStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_status_arn: std::option::Option<std::string::String>,
        pub(crate) agent_status_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::AgentStatusType>,
        pub(crate) display_order: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::AgentStatusState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the agent status.</p>
        pub fn agent_status_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_status_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agent status.</p>
        pub fn set_agent_status_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_status_arn = input;
            self
        }
        /// <p>The identifier of the agent status.</p>
        pub fn agent_status_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_status_id = Some(input.into());
            self
        }
        /// <p>The identifier of the agent status.</p>
        pub fn set_agent_status_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_status_id = input;
            self
        }
        /// <p>The name of the agent status.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the agent status.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the agent status.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the agent status.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of agent status.</p>
        pub fn r#type(mut self, input: crate::model::AgentStatusType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of agent status.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AgentStatusType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The display order of the agent status.</p>
        pub fn display_order(mut self, input: i32) -> Self {
            self.display_order = Some(input);
            self
        }
        /// <p>The display order of the agent status.</p>
        pub fn set_display_order(mut self, input: std::option::Option<i32>) -> Self {
            self.display_order = input;
            self
        }
        /// <p>The state of the agent status.</p>
        pub fn state(mut self, input: crate::model::AgentStatusState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the agent status.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AgentStatusState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentStatus`](crate::model::AgentStatus)
        pub fn build(self) -> crate::model::AgentStatus {
            crate::model::AgentStatus {
                agent_status_arn: self.agent_status_arn,
                agent_status_id: self.agent_status_id,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                display_order: self.display_order,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl AgentStatus {
    /// Creates a new builder-style object to manufacture [`AgentStatus`](crate::model::AgentStatus)
    pub fn builder() -> crate::model::agent_status::Builder {
        crate::model::agent_status::Builder::default()
    }
}
