// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateApprovedOrigin`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_approved_origin`](crate::client::Client::associate_approved_origin).
///
/// See [`crate::client::fluent_builders::AssociateApprovedOrigin`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateApprovedOrigin {
    _private: (),
}
impl AssociateApprovedOrigin {
    /// Creates a new builder-style object to manufacture [`AssociateApprovedOriginInput`](crate::input::AssociateApprovedOriginInput)
    pub fn builder() -> crate::input::associate_approved_origin_input::Builder {
        crate::input::associate_approved_origin_input::Builder::default()
    }
    /// Creates a new `AssociateApprovedOrigin` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateApprovedOrigin {
    type Output = std::result::Result<
        crate::output::AssociateApprovedOriginOutput,
        crate::error::AssociateApprovedOriginError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_approved_origin_error(response)
        } else {
            crate::operation_deser::parse_associate_approved_origin_response(response)
        }
    }
}

/// Operation shape for `AssociateBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_bot`](crate::client::Client::associate_bot).
///
/// See [`crate::client::fluent_builders::AssociateBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateBot {
    _private: (),
}
impl AssociateBot {
    /// Creates a new builder-style object to manufacture [`AssociateBotInput`](crate::input::AssociateBotInput)
    pub fn builder() -> crate::input::associate_bot_input::Builder {
        crate::input::associate_bot_input::Builder::default()
    }
    /// Creates a new `AssociateBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateBot {
    type Output =
        std::result::Result<crate::output::AssociateBotOutput, crate::error::AssociateBotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_bot_error(response)
        } else {
            crate::operation_deser::parse_associate_bot_response(response)
        }
    }
}

/// Operation shape for `AssociateInstanceStorageConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_instance_storage_config`](crate::client::Client::associate_instance_storage_config).
///
/// See [`crate::client::fluent_builders::AssociateInstanceStorageConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateInstanceStorageConfig {
    _private: (),
}
impl AssociateInstanceStorageConfig {
    /// Creates a new builder-style object to manufacture [`AssociateInstanceStorageConfigInput`](crate::input::AssociateInstanceStorageConfigInput)
    pub fn builder() -> crate::input::associate_instance_storage_config_input::Builder {
        crate::input::associate_instance_storage_config_input::Builder::default()
    }
    /// Creates a new `AssociateInstanceStorageConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateInstanceStorageConfig {
    type Output = std::result::Result<
        crate::output::AssociateInstanceStorageConfigOutput,
        crate::error::AssociateInstanceStorageConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_instance_storage_config_error(response)
        } else {
            crate::operation_deser::parse_associate_instance_storage_config_response(response)
        }
    }
}

/// Operation shape for `AssociateLambdaFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_lambda_function`](crate::client::Client::associate_lambda_function).
///
/// See [`crate::client::fluent_builders::AssociateLambdaFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateLambdaFunction {
    _private: (),
}
impl AssociateLambdaFunction {
    /// Creates a new builder-style object to manufacture [`AssociateLambdaFunctionInput`](crate::input::AssociateLambdaFunctionInput)
    pub fn builder() -> crate::input::associate_lambda_function_input::Builder {
        crate::input::associate_lambda_function_input::Builder::default()
    }
    /// Creates a new `AssociateLambdaFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateLambdaFunction {
    type Output = std::result::Result<
        crate::output::AssociateLambdaFunctionOutput,
        crate::error::AssociateLambdaFunctionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_lambda_function_error(response)
        } else {
            crate::operation_deser::parse_associate_lambda_function_response(response)
        }
    }
}

/// Operation shape for `AssociateLexBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_lex_bot`](crate::client::Client::associate_lex_bot).
///
/// See [`crate::client::fluent_builders::AssociateLexBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateLexBot {
    _private: (),
}
impl AssociateLexBot {
    /// Creates a new builder-style object to manufacture [`AssociateLexBotInput`](crate::input::AssociateLexBotInput)
    pub fn builder() -> crate::input::associate_lex_bot_input::Builder {
        crate::input::associate_lex_bot_input::Builder::default()
    }
    /// Creates a new `AssociateLexBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateLexBot {
    type Output = std::result::Result<
        crate::output::AssociateLexBotOutput,
        crate::error::AssociateLexBotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_lex_bot_error(response)
        } else {
            crate::operation_deser::parse_associate_lex_bot_response(response)
        }
    }
}

/// Operation shape for `AssociateQueueQuickConnects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_queue_quick_connects`](crate::client::Client::associate_queue_quick_connects).
///
/// See [`crate::client::fluent_builders::AssociateQueueQuickConnects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateQueueQuickConnects {
    _private: (),
}
impl AssociateQueueQuickConnects {
    /// Creates a new builder-style object to manufacture [`AssociateQueueQuickConnectsInput`](crate::input::AssociateQueueQuickConnectsInput)
    pub fn builder() -> crate::input::associate_queue_quick_connects_input::Builder {
        crate::input::associate_queue_quick_connects_input::Builder::default()
    }
    /// Creates a new `AssociateQueueQuickConnects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateQueueQuickConnects {
    type Output = std::result::Result<
        crate::output::AssociateQueueQuickConnectsOutput,
        crate::error::AssociateQueueQuickConnectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_queue_quick_connects_error(response)
        } else {
            crate::operation_deser::parse_associate_queue_quick_connects_response(response)
        }
    }
}

/// Operation shape for `AssociateRoutingProfileQueues`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_routing_profile_queues`](crate::client::Client::associate_routing_profile_queues).
///
/// See [`crate::client::fluent_builders::AssociateRoutingProfileQueues`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateRoutingProfileQueues {
    _private: (),
}
impl AssociateRoutingProfileQueues {
    /// Creates a new builder-style object to manufacture [`AssociateRoutingProfileQueuesInput`](crate::input::AssociateRoutingProfileQueuesInput)
    pub fn builder() -> crate::input::associate_routing_profile_queues_input::Builder {
        crate::input::associate_routing_profile_queues_input::Builder::default()
    }
    /// Creates a new `AssociateRoutingProfileQueues` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateRoutingProfileQueues {
    type Output = std::result::Result<
        crate::output::AssociateRoutingProfileQueuesOutput,
        crate::error::AssociateRoutingProfileQueuesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_routing_profile_queues_error(response)
        } else {
            crate::operation_deser::parse_associate_routing_profile_queues_response(response)
        }
    }
}

/// Operation shape for `AssociateSecurityKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_security_key`](crate::client::Client::associate_security_key).
///
/// See [`crate::client::fluent_builders::AssociateSecurityKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateSecurityKey {
    _private: (),
}
impl AssociateSecurityKey {
    /// Creates a new builder-style object to manufacture [`AssociateSecurityKeyInput`](crate::input::AssociateSecurityKeyInput)
    pub fn builder() -> crate::input::associate_security_key_input::Builder {
        crate::input::associate_security_key_input::Builder::default()
    }
    /// Creates a new `AssociateSecurityKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateSecurityKey {
    type Output = std::result::Result<
        crate::output::AssociateSecurityKeyOutput,
        crate::error::AssociateSecurityKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_security_key_error(response)
        } else {
            crate::operation_deser::parse_associate_security_key_response(response)
        }
    }
}

/// Operation shape for `CreateAgentStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_agent_status`](crate::client::Client::create_agent_status).
///
/// See [`crate::client::fluent_builders::CreateAgentStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAgentStatus {
    _private: (),
}
impl CreateAgentStatus {
    /// Creates a new builder-style object to manufacture [`CreateAgentStatusInput`](crate::input::CreateAgentStatusInput)
    pub fn builder() -> crate::input::create_agent_status_input::Builder {
        crate::input::create_agent_status_input::Builder::default()
    }
    /// Creates a new `CreateAgentStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAgentStatus {
    type Output = std::result::Result<
        crate::output::CreateAgentStatusOutput,
        crate::error::CreateAgentStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_agent_status_error(response)
        } else {
            crate::operation_deser::parse_create_agent_status_response(response)
        }
    }
}

/// Operation shape for `CreateContactFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_contact_flow`](crate::client::Client::create_contact_flow).
///
/// See [`crate::client::fluent_builders::CreateContactFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateContactFlow {
    _private: (),
}
impl CreateContactFlow {
    /// Creates a new builder-style object to manufacture [`CreateContactFlowInput`](crate::input::CreateContactFlowInput)
    pub fn builder() -> crate::input::create_contact_flow_input::Builder {
        crate::input::create_contact_flow_input::Builder::default()
    }
    /// Creates a new `CreateContactFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateContactFlow {
    type Output = std::result::Result<
        crate::output::CreateContactFlowOutput,
        crate::error::CreateContactFlowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_contact_flow_error(response)
        } else {
            crate::operation_deser::parse_create_contact_flow_response(response)
        }
    }
}

/// Operation shape for `CreateHoursOfOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_hours_of_operation`](crate::client::Client::create_hours_of_operation).
///
/// See [`crate::client::fluent_builders::CreateHoursOfOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHoursOfOperation {
    _private: (),
}
impl CreateHoursOfOperation {
    /// Creates a new builder-style object to manufacture [`CreateHoursOfOperationInput`](crate::input::CreateHoursOfOperationInput)
    pub fn builder() -> crate::input::create_hours_of_operation_input::Builder {
        crate::input::create_hours_of_operation_input::Builder::default()
    }
    /// Creates a new `CreateHoursOfOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHoursOfOperation {
    type Output = std::result::Result<
        crate::output::CreateHoursOfOperationOutput,
        crate::error::CreateHoursOfOperationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_hours_of_operation_error(response)
        } else {
            crate::operation_deser::parse_create_hours_of_operation_response(response)
        }
    }
}

/// Operation shape for `CreateInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_instance`](crate::client::Client::create_instance).
///
/// See [`crate::client::fluent_builders::CreateInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInstance {
    _private: (),
}
impl CreateInstance {
    /// Creates a new builder-style object to manufacture [`CreateInstanceInput`](crate::input::CreateInstanceInput)
    pub fn builder() -> crate::input::create_instance_input::Builder {
        crate::input::create_instance_input::Builder::default()
    }
    /// Creates a new `CreateInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInstance {
    type Output =
        std::result::Result<crate::output::CreateInstanceOutput, crate::error::CreateInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_instance_error(response)
        } else {
            crate::operation_deser::parse_create_instance_response(response)
        }
    }
}

/// Operation shape for `CreateIntegrationAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_integration_association`](crate::client::Client::create_integration_association).
///
/// See [`crate::client::fluent_builders::CreateIntegrationAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIntegrationAssociation {
    _private: (),
}
impl CreateIntegrationAssociation {
    /// Creates a new builder-style object to manufacture [`CreateIntegrationAssociationInput`](crate::input::CreateIntegrationAssociationInput)
    pub fn builder() -> crate::input::create_integration_association_input::Builder {
        crate::input::create_integration_association_input::Builder::default()
    }
    /// Creates a new `CreateIntegrationAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIntegrationAssociation {
    type Output = std::result::Result<
        crate::output::CreateIntegrationAssociationOutput,
        crate::error::CreateIntegrationAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_integration_association_error(response)
        } else {
            crate::operation_deser::parse_create_integration_association_response(response)
        }
    }
}

/// Operation shape for `CreateQueue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_queue`](crate::client::Client::create_queue).
///
/// See [`crate::client::fluent_builders::CreateQueue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateQueue {
    _private: (),
}
impl CreateQueue {
    /// Creates a new builder-style object to manufacture [`CreateQueueInput`](crate::input::CreateQueueInput)
    pub fn builder() -> crate::input::create_queue_input::Builder {
        crate::input::create_queue_input::Builder::default()
    }
    /// Creates a new `CreateQueue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateQueue {
    type Output =
        std::result::Result<crate::output::CreateQueueOutput, crate::error::CreateQueueError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_queue_error(response)
        } else {
            crate::operation_deser::parse_create_queue_response(response)
        }
    }
}

/// Operation shape for `CreateQuickConnect`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_quick_connect`](crate::client::Client::create_quick_connect).
///
/// See [`crate::client::fluent_builders::CreateQuickConnect`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateQuickConnect {
    _private: (),
}
impl CreateQuickConnect {
    /// Creates a new builder-style object to manufacture [`CreateQuickConnectInput`](crate::input::CreateQuickConnectInput)
    pub fn builder() -> crate::input::create_quick_connect_input::Builder {
        crate::input::create_quick_connect_input::Builder::default()
    }
    /// Creates a new `CreateQuickConnect` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateQuickConnect {
    type Output = std::result::Result<
        crate::output::CreateQuickConnectOutput,
        crate::error::CreateQuickConnectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_quick_connect_error(response)
        } else {
            crate::operation_deser::parse_create_quick_connect_response(response)
        }
    }
}

/// Operation shape for `CreateRoutingProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_routing_profile`](crate::client::Client::create_routing_profile).
///
/// See [`crate::client::fluent_builders::CreateRoutingProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRoutingProfile {
    _private: (),
}
impl CreateRoutingProfile {
    /// Creates a new builder-style object to manufacture [`CreateRoutingProfileInput`](crate::input::CreateRoutingProfileInput)
    pub fn builder() -> crate::input::create_routing_profile_input::Builder {
        crate::input::create_routing_profile_input::Builder::default()
    }
    /// Creates a new `CreateRoutingProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRoutingProfile {
    type Output = std::result::Result<
        crate::output::CreateRoutingProfileOutput,
        crate::error::CreateRoutingProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_routing_profile_error(response)
        } else {
            crate::operation_deser::parse_create_routing_profile_response(response)
        }
    }
}

/// Operation shape for `CreateUseCase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_use_case`](crate::client::Client::create_use_case).
///
/// See [`crate::client::fluent_builders::CreateUseCase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUseCase {
    _private: (),
}
impl CreateUseCase {
    /// Creates a new builder-style object to manufacture [`CreateUseCaseInput`](crate::input::CreateUseCaseInput)
    pub fn builder() -> crate::input::create_use_case_input::Builder {
        crate::input::create_use_case_input::Builder::default()
    }
    /// Creates a new `CreateUseCase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUseCase {
    type Output =
        std::result::Result<crate::output::CreateUseCaseOutput, crate::error::CreateUseCaseError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_use_case_error(response)
        } else {
            crate::operation_deser::parse_create_use_case_response(response)
        }
    }
}

/// Operation shape for `CreateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user`](crate::client::Client::create_user).
///
/// See [`crate::client::fluent_builders::CreateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUser {
    _private: (),
}
impl CreateUser {
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
    /// Creates a new `CreateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUser {
    type Output =
        std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_error(response)
        } else {
            crate::operation_deser::parse_create_user_response(response)
        }
    }
}

/// Operation shape for `CreateUserHierarchyGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user_hierarchy_group`](crate::client::Client::create_user_hierarchy_group).
///
/// See [`crate::client::fluent_builders::CreateUserHierarchyGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUserHierarchyGroup {
    _private: (),
}
impl CreateUserHierarchyGroup {
    /// Creates a new builder-style object to manufacture [`CreateUserHierarchyGroupInput`](crate::input::CreateUserHierarchyGroupInput)
    pub fn builder() -> crate::input::create_user_hierarchy_group_input::Builder {
        crate::input::create_user_hierarchy_group_input::Builder::default()
    }
    /// Creates a new `CreateUserHierarchyGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUserHierarchyGroup {
    type Output = std::result::Result<
        crate::output::CreateUserHierarchyGroupOutput,
        crate::error::CreateUserHierarchyGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_hierarchy_group_error(response)
        } else {
            crate::operation_deser::parse_create_user_hierarchy_group_response(response)
        }
    }
}

/// Operation shape for `DeleteHoursOfOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_hours_of_operation`](crate::client::Client::delete_hours_of_operation).
///
/// See [`crate::client::fluent_builders::DeleteHoursOfOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteHoursOfOperation {
    _private: (),
}
impl DeleteHoursOfOperation {
    /// Creates a new builder-style object to manufacture [`DeleteHoursOfOperationInput`](crate::input::DeleteHoursOfOperationInput)
    pub fn builder() -> crate::input::delete_hours_of_operation_input::Builder {
        crate::input::delete_hours_of_operation_input::Builder::default()
    }
    /// Creates a new `DeleteHoursOfOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteHoursOfOperation {
    type Output = std::result::Result<
        crate::output::DeleteHoursOfOperationOutput,
        crate::error::DeleteHoursOfOperationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_hours_of_operation_error(response)
        } else {
            crate::operation_deser::parse_delete_hours_of_operation_response(response)
        }
    }
}

/// Operation shape for `DeleteInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_instance`](crate::client::Client::delete_instance).
///
/// See [`crate::client::fluent_builders::DeleteInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInstance {
    _private: (),
}
impl DeleteInstance {
    /// Creates a new builder-style object to manufacture [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
    pub fn builder() -> crate::input::delete_instance_input::Builder {
        crate::input::delete_instance_input::Builder::default()
    }
    /// Creates a new `DeleteInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInstance {
    type Output =
        std::result::Result<crate::output::DeleteInstanceOutput, crate::error::DeleteInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_instance_error(response)
        } else {
            crate::operation_deser::parse_delete_instance_response(response)
        }
    }
}

/// Operation shape for `DeleteIntegrationAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_integration_association`](crate::client::Client::delete_integration_association).
///
/// See [`crate::client::fluent_builders::DeleteIntegrationAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIntegrationAssociation {
    _private: (),
}
impl DeleteIntegrationAssociation {
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationAssociationInput`](crate::input::DeleteIntegrationAssociationInput)
    pub fn builder() -> crate::input::delete_integration_association_input::Builder {
        crate::input::delete_integration_association_input::Builder::default()
    }
    /// Creates a new `DeleteIntegrationAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIntegrationAssociation {
    type Output = std::result::Result<
        crate::output::DeleteIntegrationAssociationOutput,
        crate::error::DeleteIntegrationAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_integration_association_error(response)
        } else {
            crate::operation_deser::parse_delete_integration_association_response(response)
        }
    }
}

/// Operation shape for `DeleteQuickConnect`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_quick_connect`](crate::client::Client::delete_quick_connect).
///
/// See [`crate::client::fluent_builders::DeleteQuickConnect`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteQuickConnect {
    _private: (),
}
impl DeleteQuickConnect {
    /// Creates a new builder-style object to manufacture [`DeleteQuickConnectInput`](crate::input::DeleteQuickConnectInput)
    pub fn builder() -> crate::input::delete_quick_connect_input::Builder {
        crate::input::delete_quick_connect_input::Builder::default()
    }
    /// Creates a new `DeleteQuickConnect` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteQuickConnect {
    type Output = std::result::Result<
        crate::output::DeleteQuickConnectOutput,
        crate::error::DeleteQuickConnectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_quick_connect_error(response)
        } else {
            crate::operation_deser::parse_delete_quick_connect_response(response)
        }
    }
}

/// Operation shape for `DeleteUseCase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_use_case`](crate::client::Client::delete_use_case).
///
/// See [`crate::client::fluent_builders::DeleteUseCase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUseCase {
    _private: (),
}
impl DeleteUseCase {
    /// Creates a new builder-style object to manufacture [`DeleteUseCaseInput`](crate::input::DeleteUseCaseInput)
    pub fn builder() -> crate::input::delete_use_case_input::Builder {
        crate::input::delete_use_case_input::Builder::default()
    }
    /// Creates a new `DeleteUseCase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUseCase {
    type Output =
        std::result::Result<crate::output::DeleteUseCaseOutput, crate::error::DeleteUseCaseError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_use_case_error(response)
        } else {
            crate::operation_deser::parse_delete_use_case_response(response)
        }
    }
}

/// Operation shape for `DeleteUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user`](crate::client::Client::delete_user).
///
/// See [`crate::client::fluent_builders::DeleteUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUser {
    _private: (),
}
impl DeleteUser {
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
    /// Creates a new `DeleteUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUser {
    type Output =
        std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_error(response)
        } else {
            crate::operation_deser::parse_delete_user_response(response)
        }
    }
}

/// Operation shape for `DeleteUserHierarchyGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_hierarchy_group`](crate::client::Client::delete_user_hierarchy_group).
///
/// See [`crate::client::fluent_builders::DeleteUserHierarchyGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserHierarchyGroup {
    _private: (),
}
impl DeleteUserHierarchyGroup {
    /// Creates a new builder-style object to manufacture [`DeleteUserHierarchyGroupInput`](crate::input::DeleteUserHierarchyGroupInput)
    pub fn builder() -> crate::input::delete_user_hierarchy_group_input::Builder {
        crate::input::delete_user_hierarchy_group_input::Builder::default()
    }
    /// Creates a new `DeleteUserHierarchyGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserHierarchyGroup {
    type Output = std::result::Result<
        crate::output::DeleteUserHierarchyGroupOutput,
        crate::error::DeleteUserHierarchyGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_hierarchy_group_error(response)
        } else {
            crate::operation_deser::parse_delete_user_hierarchy_group_response(response)
        }
    }
}

/// Operation shape for `DescribeAgentStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_agent_status`](crate::client::Client::describe_agent_status).
///
/// See [`crate::client::fluent_builders::DescribeAgentStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAgentStatus {
    _private: (),
}
impl DescribeAgentStatus {
    /// Creates a new builder-style object to manufacture [`DescribeAgentStatusInput`](crate::input::DescribeAgentStatusInput)
    pub fn builder() -> crate::input::describe_agent_status_input::Builder {
        crate::input::describe_agent_status_input::Builder::default()
    }
    /// Creates a new `DescribeAgentStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAgentStatus {
    type Output = std::result::Result<
        crate::output::DescribeAgentStatusOutput,
        crate::error::DescribeAgentStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_agent_status_error(response)
        } else {
            crate::operation_deser::parse_describe_agent_status_response(response)
        }
    }
}

/// Operation shape for `DescribeContactFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_contact_flow`](crate::client::Client::describe_contact_flow).
///
/// See [`crate::client::fluent_builders::DescribeContactFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeContactFlow {
    _private: (),
}
impl DescribeContactFlow {
    /// Creates a new builder-style object to manufacture [`DescribeContactFlowInput`](crate::input::DescribeContactFlowInput)
    pub fn builder() -> crate::input::describe_contact_flow_input::Builder {
        crate::input::describe_contact_flow_input::Builder::default()
    }
    /// Creates a new `DescribeContactFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeContactFlow {
    type Output = std::result::Result<
        crate::output::DescribeContactFlowOutput,
        crate::error::DescribeContactFlowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_contact_flow_error(response)
        } else {
            crate::operation_deser::parse_describe_contact_flow_response(response)
        }
    }
}

/// Operation shape for `DescribeHoursOfOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_hours_of_operation`](crate::client::Client::describe_hours_of_operation).
///
/// See [`crate::client::fluent_builders::DescribeHoursOfOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeHoursOfOperation {
    _private: (),
}
impl DescribeHoursOfOperation {
    /// Creates a new builder-style object to manufacture [`DescribeHoursOfOperationInput`](crate::input::DescribeHoursOfOperationInput)
    pub fn builder() -> crate::input::describe_hours_of_operation_input::Builder {
        crate::input::describe_hours_of_operation_input::Builder::default()
    }
    /// Creates a new `DescribeHoursOfOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeHoursOfOperation {
    type Output = std::result::Result<
        crate::output::DescribeHoursOfOperationOutput,
        crate::error::DescribeHoursOfOperationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_hours_of_operation_error(response)
        } else {
            crate::operation_deser::parse_describe_hours_of_operation_response(response)
        }
    }
}

/// Operation shape for `DescribeInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance`](crate::client::Client::describe_instance).
///
/// See [`crate::client::fluent_builders::DescribeInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstance {
    _private: (),
}
impl DescribeInstance {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceInput`](crate::input::DescribeInstanceInput)
    pub fn builder() -> crate::input::describe_instance_input::Builder {
        crate::input::describe_instance_input::Builder::default()
    }
    /// Creates a new `DescribeInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstance {
    type Output = std::result::Result<
        crate::output::DescribeInstanceOutput,
        crate::error::DescribeInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_response(response)
        }
    }
}

/// Operation shape for `DescribeInstanceAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_attribute`](crate::client::Client::describe_instance_attribute).
///
/// See [`crate::client::fluent_builders::DescribeInstanceAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceAttribute {
    _private: (),
}
impl DescribeInstanceAttribute {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceAttributeInput`](crate::input::DescribeInstanceAttributeInput)
    pub fn builder() -> crate::input::describe_instance_attribute_input::Builder {
        crate::input::describe_instance_attribute_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceAttribute {
    type Output = std::result::Result<
        crate::output::DescribeInstanceAttributeOutput,
        crate::error::DescribeInstanceAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_attribute_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_attribute_response(response)
        }
    }
}

/// Operation shape for `DescribeInstanceStorageConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_storage_config`](crate::client::Client::describe_instance_storage_config).
///
/// See [`crate::client::fluent_builders::DescribeInstanceStorageConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceStorageConfig {
    _private: (),
}
impl DescribeInstanceStorageConfig {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceStorageConfigInput`](crate::input::DescribeInstanceStorageConfigInput)
    pub fn builder() -> crate::input::describe_instance_storage_config_input::Builder {
        crate::input::describe_instance_storage_config_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceStorageConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceStorageConfig {
    type Output = std::result::Result<
        crate::output::DescribeInstanceStorageConfigOutput,
        crate::error::DescribeInstanceStorageConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_storage_config_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_storage_config_response(response)
        }
    }
}

/// Operation shape for `DescribeQueue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_queue`](crate::client::Client::describe_queue).
///
/// See [`crate::client::fluent_builders::DescribeQueue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeQueue {
    _private: (),
}
impl DescribeQueue {
    /// Creates a new builder-style object to manufacture [`DescribeQueueInput`](crate::input::DescribeQueueInput)
    pub fn builder() -> crate::input::describe_queue_input::Builder {
        crate::input::describe_queue_input::Builder::default()
    }
    /// Creates a new `DescribeQueue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeQueue {
    type Output =
        std::result::Result<crate::output::DescribeQueueOutput, crate::error::DescribeQueueError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_queue_error(response)
        } else {
            crate::operation_deser::parse_describe_queue_response(response)
        }
    }
}

/// Operation shape for `DescribeQuickConnect`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_quick_connect`](crate::client::Client::describe_quick_connect).
///
/// See [`crate::client::fluent_builders::DescribeQuickConnect`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeQuickConnect {
    _private: (),
}
impl DescribeQuickConnect {
    /// Creates a new builder-style object to manufacture [`DescribeQuickConnectInput`](crate::input::DescribeQuickConnectInput)
    pub fn builder() -> crate::input::describe_quick_connect_input::Builder {
        crate::input::describe_quick_connect_input::Builder::default()
    }
    /// Creates a new `DescribeQuickConnect` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeQuickConnect {
    type Output = std::result::Result<
        crate::output::DescribeQuickConnectOutput,
        crate::error::DescribeQuickConnectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_quick_connect_error(response)
        } else {
            crate::operation_deser::parse_describe_quick_connect_response(response)
        }
    }
}

/// Operation shape for `DescribeRoutingProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_routing_profile`](crate::client::Client::describe_routing_profile).
///
/// See [`crate::client::fluent_builders::DescribeRoutingProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRoutingProfile {
    _private: (),
}
impl DescribeRoutingProfile {
    /// Creates a new builder-style object to manufacture [`DescribeRoutingProfileInput`](crate::input::DescribeRoutingProfileInput)
    pub fn builder() -> crate::input::describe_routing_profile_input::Builder {
        crate::input::describe_routing_profile_input::Builder::default()
    }
    /// Creates a new `DescribeRoutingProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRoutingProfile {
    type Output = std::result::Result<
        crate::output::DescribeRoutingProfileOutput,
        crate::error::DescribeRoutingProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_routing_profile_error(response)
        } else {
            crate::operation_deser::parse_describe_routing_profile_response(response)
        }
    }
}

/// Operation shape for `DescribeUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user`](crate::client::Client::describe_user).
///
/// See [`crate::client::fluent_builders::DescribeUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUser {
    _private: (),
}
impl DescribeUser {
    /// Creates a new builder-style object to manufacture [`DescribeUserInput`](crate::input::DescribeUserInput)
    pub fn builder() -> crate::input::describe_user_input::Builder {
        crate::input::describe_user_input::Builder::default()
    }
    /// Creates a new `DescribeUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUser {
    type Output =
        std::result::Result<crate::output::DescribeUserOutput, crate::error::DescribeUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_error(response)
        } else {
            crate::operation_deser::parse_describe_user_response(response)
        }
    }
}

/// Operation shape for `DescribeUserHierarchyGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user_hierarchy_group`](crate::client::Client::describe_user_hierarchy_group).
///
/// See [`crate::client::fluent_builders::DescribeUserHierarchyGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUserHierarchyGroup {
    _private: (),
}
impl DescribeUserHierarchyGroup {
    /// Creates a new builder-style object to manufacture [`DescribeUserHierarchyGroupInput`](crate::input::DescribeUserHierarchyGroupInput)
    pub fn builder() -> crate::input::describe_user_hierarchy_group_input::Builder {
        crate::input::describe_user_hierarchy_group_input::Builder::default()
    }
    /// Creates a new `DescribeUserHierarchyGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUserHierarchyGroup {
    type Output = std::result::Result<
        crate::output::DescribeUserHierarchyGroupOutput,
        crate::error::DescribeUserHierarchyGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_hierarchy_group_error(response)
        } else {
            crate::operation_deser::parse_describe_user_hierarchy_group_response(response)
        }
    }
}

/// Operation shape for `DescribeUserHierarchyStructure`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user_hierarchy_structure`](crate::client::Client::describe_user_hierarchy_structure).
///
/// See [`crate::client::fluent_builders::DescribeUserHierarchyStructure`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUserHierarchyStructure {
    _private: (),
}
impl DescribeUserHierarchyStructure {
    /// Creates a new builder-style object to manufacture [`DescribeUserHierarchyStructureInput`](crate::input::DescribeUserHierarchyStructureInput)
    pub fn builder() -> crate::input::describe_user_hierarchy_structure_input::Builder {
        crate::input::describe_user_hierarchy_structure_input::Builder::default()
    }
    /// Creates a new `DescribeUserHierarchyStructure` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUserHierarchyStructure {
    type Output = std::result::Result<
        crate::output::DescribeUserHierarchyStructureOutput,
        crate::error::DescribeUserHierarchyStructureError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_hierarchy_structure_error(response)
        } else {
            crate::operation_deser::parse_describe_user_hierarchy_structure_response(response)
        }
    }
}

/// Operation shape for `DisassociateApprovedOrigin`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_approved_origin`](crate::client::Client::disassociate_approved_origin).
///
/// See [`crate::client::fluent_builders::DisassociateApprovedOrigin`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateApprovedOrigin {
    _private: (),
}
impl DisassociateApprovedOrigin {
    /// Creates a new builder-style object to manufacture [`DisassociateApprovedOriginInput`](crate::input::DisassociateApprovedOriginInput)
    pub fn builder() -> crate::input::disassociate_approved_origin_input::Builder {
        crate::input::disassociate_approved_origin_input::Builder::default()
    }
    /// Creates a new `DisassociateApprovedOrigin` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateApprovedOrigin {
    type Output = std::result::Result<
        crate::output::DisassociateApprovedOriginOutput,
        crate::error::DisassociateApprovedOriginError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_approved_origin_error(response)
        } else {
            crate::operation_deser::parse_disassociate_approved_origin_response(response)
        }
    }
}

/// Operation shape for `DisassociateBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_bot`](crate::client::Client::disassociate_bot).
///
/// See [`crate::client::fluent_builders::DisassociateBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateBot {
    _private: (),
}
impl DisassociateBot {
    /// Creates a new builder-style object to manufacture [`DisassociateBotInput`](crate::input::DisassociateBotInput)
    pub fn builder() -> crate::input::disassociate_bot_input::Builder {
        crate::input::disassociate_bot_input::Builder::default()
    }
    /// Creates a new `DisassociateBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateBot {
    type Output = std::result::Result<
        crate::output::DisassociateBotOutput,
        crate::error::DisassociateBotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_bot_error(response)
        } else {
            crate::operation_deser::parse_disassociate_bot_response(response)
        }
    }
}

/// Operation shape for `DisassociateInstanceStorageConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_instance_storage_config`](crate::client::Client::disassociate_instance_storage_config).
///
/// See [`crate::client::fluent_builders::DisassociateInstanceStorageConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateInstanceStorageConfig {
    _private: (),
}
impl DisassociateInstanceStorageConfig {
    /// Creates a new builder-style object to manufacture [`DisassociateInstanceStorageConfigInput`](crate::input::DisassociateInstanceStorageConfigInput)
    pub fn builder() -> crate::input::disassociate_instance_storage_config_input::Builder {
        crate::input::disassociate_instance_storage_config_input::Builder::default()
    }
    /// Creates a new `DisassociateInstanceStorageConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateInstanceStorageConfig {
    type Output = std::result::Result<
        crate::output::DisassociateInstanceStorageConfigOutput,
        crate::error::DisassociateInstanceStorageConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_instance_storage_config_error(response)
        } else {
            crate::operation_deser::parse_disassociate_instance_storage_config_response(response)
        }
    }
}

/// Operation shape for `DisassociateLambdaFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_lambda_function`](crate::client::Client::disassociate_lambda_function).
///
/// See [`crate::client::fluent_builders::DisassociateLambdaFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateLambdaFunction {
    _private: (),
}
impl DisassociateLambdaFunction {
    /// Creates a new builder-style object to manufacture [`DisassociateLambdaFunctionInput`](crate::input::DisassociateLambdaFunctionInput)
    pub fn builder() -> crate::input::disassociate_lambda_function_input::Builder {
        crate::input::disassociate_lambda_function_input::Builder::default()
    }
    /// Creates a new `DisassociateLambdaFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateLambdaFunction {
    type Output = std::result::Result<
        crate::output::DisassociateLambdaFunctionOutput,
        crate::error::DisassociateLambdaFunctionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_lambda_function_error(response)
        } else {
            crate::operation_deser::parse_disassociate_lambda_function_response(response)
        }
    }
}

/// Operation shape for `DisassociateLexBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_lex_bot`](crate::client::Client::disassociate_lex_bot).
///
/// See [`crate::client::fluent_builders::DisassociateLexBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateLexBot {
    _private: (),
}
impl DisassociateLexBot {
    /// Creates a new builder-style object to manufacture [`DisassociateLexBotInput`](crate::input::DisassociateLexBotInput)
    pub fn builder() -> crate::input::disassociate_lex_bot_input::Builder {
        crate::input::disassociate_lex_bot_input::Builder::default()
    }
    /// Creates a new `DisassociateLexBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateLexBot {
    type Output = std::result::Result<
        crate::output::DisassociateLexBotOutput,
        crate::error::DisassociateLexBotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_lex_bot_error(response)
        } else {
            crate::operation_deser::parse_disassociate_lex_bot_response(response)
        }
    }
}

/// Operation shape for `DisassociateQueueQuickConnects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_queue_quick_connects`](crate::client::Client::disassociate_queue_quick_connects).
///
/// See [`crate::client::fluent_builders::DisassociateQueueQuickConnects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateQueueQuickConnects {
    _private: (),
}
impl DisassociateQueueQuickConnects {
    /// Creates a new builder-style object to manufacture [`DisassociateQueueQuickConnectsInput`](crate::input::DisassociateQueueQuickConnectsInput)
    pub fn builder() -> crate::input::disassociate_queue_quick_connects_input::Builder {
        crate::input::disassociate_queue_quick_connects_input::Builder::default()
    }
    /// Creates a new `DisassociateQueueQuickConnects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateQueueQuickConnects {
    type Output = std::result::Result<
        crate::output::DisassociateQueueQuickConnectsOutput,
        crate::error::DisassociateQueueQuickConnectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_queue_quick_connects_error(response)
        } else {
            crate::operation_deser::parse_disassociate_queue_quick_connects_response(response)
        }
    }
}

/// Operation shape for `DisassociateRoutingProfileQueues`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_routing_profile_queues`](crate::client::Client::disassociate_routing_profile_queues).
///
/// See [`crate::client::fluent_builders::DisassociateRoutingProfileQueues`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateRoutingProfileQueues {
    _private: (),
}
impl DisassociateRoutingProfileQueues {
    /// Creates a new builder-style object to manufacture [`DisassociateRoutingProfileQueuesInput`](crate::input::DisassociateRoutingProfileQueuesInput)
    pub fn builder() -> crate::input::disassociate_routing_profile_queues_input::Builder {
        crate::input::disassociate_routing_profile_queues_input::Builder::default()
    }
    /// Creates a new `DisassociateRoutingProfileQueues` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateRoutingProfileQueues {
    type Output = std::result::Result<
        crate::output::DisassociateRoutingProfileQueuesOutput,
        crate::error::DisassociateRoutingProfileQueuesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_routing_profile_queues_error(response)
        } else {
            crate::operation_deser::parse_disassociate_routing_profile_queues_response(response)
        }
    }
}

/// Operation shape for `DisassociateSecurityKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_security_key`](crate::client::Client::disassociate_security_key).
///
/// See [`crate::client::fluent_builders::DisassociateSecurityKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateSecurityKey {
    _private: (),
}
impl DisassociateSecurityKey {
    /// Creates a new builder-style object to manufacture [`DisassociateSecurityKeyInput`](crate::input::DisassociateSecurityKeyInput)
    pub fn builder() -> crate::input::disassociate_security_key_input::Builder {
        crate::input::disassociate_security_key_input::Builder::default()
    }
    /// Creates a new `DisassociateSecurityKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateSecurityKey {
    type Output = std::result::Result<
        crate::output::DisassociateSecurityKeyOutput,
        crate::error::DisassociateSecurityKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_security_key_error(response)
        } else {
            crate::operation_deser::parse_disassociate_security_key_response(response)
        }
    }
}

/// Operation shape for `GetContactAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_contact_attributes`](crate::client::Client::get_contact_attributes).
///
/// See [`crate::client::fluent_builders::GetContactAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContactAttributes {
    _private: (),
}
impl GetContactAttributes {
    /// Creates a new builder-style object to manufacture [`GetContactAttributesInput`](crate::input::GetContactAttributesInput)
    pub fn builder() -> crate::input::get_contact_attributes_input::Builder {
        crate::input::get_contact_attributes_input::Builder::default()
    }
    /// Creates a new `GetContactAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContactAttributes {
    type Output = std::result::Result<
        crate::output::GetContactAttributesOutput,
        crate::error::GetContactAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_contact_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_contact_attributes_response(response)
        }
    }
}

/// Operation shape for `GetCurrentMetricData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_current_metric_data`](crate::client::Client::get_current_metric_data).
///
/// See [`crate::client::fluent_builders::GetCurrentMetricData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCurrentMetricData {
    _private: (),
}
impl GetCurrentMetricData {
    /// Creates a new builder-style object to manufacture [`GetCurrentMetricDataInput`](crate::input::GetCurrentMetricDataInput)
    pub fn builder() -> crate::input::get_current_metric_data_input::Builder {
        crate::input::get_current_metric_data_input::Builder::default()
    }
    /// Creates a new `GetCurrentMetricData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCurrentMetricData {
    type Output = std::result::Result<
        crate::output::GetCurrentMetricDataOutput,
        crate::error::GetCurrentMetricDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_current_metric_data_error(response)
        } else {
            crate::operation_deser::parse_get_current_metric_data_response(response)
        }
    }
}

/// Operation shape for `GetFederationToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_federation_token`](crate::client::Client::get_federation_token).
///
/// See [`crate::client::fluent_builders::GetFederationToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFederationToken {
    _private: (),
}
impl GetFederationToken {
    /// Creates a new builder-style object to manufacture [`GetFederationTokenInput`](crate::input::GetFederationTokenInput)
    pub fn builder() -> crate::input::get_federation_token_input::Builder {
        crate::input::get_federation_token_input::Builder::default()
    }
    /// Creates a new `GetFederationToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFederationToken {
    type Output = std::result::Result<
        crate::output::GetFederationTokenOutput,
        crate::error::GetFederationTokenError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_federation_token_error(response)
        } else {
            crate::operation_deser::parse_get_federation_token_response(response)
        }
    }
}

/// Operation shape for `GetMetricData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_metric_data`](crate::client::Client::get_metric_data).
///
/// See [`crate::client::fluent_builders::GetMetricData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMetricData {
    _private: (),
}
impl GetMetricData {
    /// Creates a new builder-style object to manufacture [`GetMetricDataInput`](crate::input::GetMetricDataInput)
    pub fn builder() -> crate::input::get_metric_data_input::Builder {
        crate::input::get_metric_data_input::Builder::default()
    }
    /// Creates a new `GetMetricData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMetricData {
    type Output =
        std::result::Result<crate::output::GetMetricDataOutput, crate::error::GetMetricDataError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_metric_data_error(response)
        } else {
            crate::operation_deser::parse_get_metric_data_response(response)
        }
    }
}

/// Operation shape for `ListAgentStatuses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_agent_statuses`](crate::client::Client::list_agent_statuses).
///
/// See [`crate::client::fluent_builders::ListAgentStatuses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAgentStatuses {
    _private: (),
}
impl ListAgentStatuses {
    /// Creates a new builder-style object to manufacture [`ListAgentStatusesInput`](crate::input::ListAgentStatusesInput)
    pub fn builder() -> crate::input::list_agent_statuses_input::Builder {
        crate::input::list_agent_statuses_input::Builder::default()
    }
    /// Creates a new `ListAgentStatuses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAgentStatuses {
    type Output = std::result::Result<
        crate::output::ListAgentStatusesOutput,
        crate::error::ListAgentStatusesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_agent_statuses_error(response)
        } else {
            crate::operation_deser::parse_list_agent_statuses_response(response)
        }
    }
}

/// Operation shape for `ListApprovedOrigins`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_approved_origins`](crate::client::Client::list_approved_origins).
///
/// See [`crate::client::fluent_builders::ListApprovedOrigins`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApprovedOrigins {
    _private: (),
}
impl ListApprovedOrigins {
    /// Creates a new builder-style object to manufacture [`ListApprovedOriginsInput`](crate::input::ListApprovedOriginsInput)
    pub fn builder() -> crate::input::list_approved_origins_input::Builder {
        crate::input::list_approved_origins_input::Builder::default()
    }
    /// Creates a new `ListApprovedOrigins` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApprovedOrigins {
    type Output = std::result::Result<
        crate::output::ListApprovedOriginsOutput,
        crate::error::ListApprovedOriginsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_approved_origins_error(response)
        } else {
            crate::operation_deser::parse_list_approved_origins_response(response)
        }
    }
}

/// Operation shape for `ListBots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bots`](crate::client::Client::list_bots).
///
/// See [`crate::client::fluent_builders::ListBots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBots {
    _private: (),
}
impl ListBots {
    /// Creates a new builder-style object to manufacture [`ListBotsInput`](crate::input::ListBotsInput)
    pub fn builder() -> crate::input::list_bots_input::Builder {
        crate::input::list_bots_input::Builder::default()
    }
    /// Creates a new `ListBots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBots {
    type Output = std::result::Result<crate::output::ListBotsOutput, crate::error::ListBotsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bots_error(response)
        } else {
            crate::operation_deser::parse_list_bots_response(response)
        }
    }
}

/// Operation shape for `ListContactFlows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_contact_flows`](crate::client::Client::list_contact_flows).
///
/// See [`crate::client::fluent_builders::ListContactFlows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListContactFlows {
    _private: (),
}
impl ListContactFlows {
    /// Creates a new builder-style object to manufacture [`ListContactFlowsInput`](crate::input::ListContactFlowsInput)
    pub fn builder() -> crate::input::list_contact_flows_input::Builder {
        crate::input::list_contact_flows_input::Builder::default()
    }
    /// Creates a new `ListContactFlows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListContactFlows {
    type Output = std::result::Result<
        crate::output::ListContactFlowsOutput,
        crate::error::ListContactFlowsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_contact_flows_error(response)
        } else {
            crate::operation_deser::parse_list_contact_flows_response(response)
        }
    }
}

/// Operation shape for `ListHoursOfOperations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_hours_of_operations`](crate::client::Client::list_hours_of_operations).
///
/// See [`crate::client::fluent_builders::ListHoursOfOperations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHoursOfOperations {
    _private: (),
}
impl ListHoursOfOperations {
    /// Creates a new builder-style object to manufacture [`ListHoursOfOperationsInput`](crate::input::ListHoursOfOperationsInput)
    pub fn builder() -> crate::input::list_hours_of_operations_input::Builder {
        crate::input::list_hours_of_operations_input::Builder::default()
    }
    /// Creates a new `ListHoursOfOperations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHoursOfOperations {
    type Output = std::result::Result<
        crate::output::ListHoursOfOperationsOutput,
        crate::error::ListHoursOfOperationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_hours_of_operations_error(response)
        } else {
            crate::operation_deser::parse_list_hours_of_operations_response(response)
        }
    }
}

/// Operation shape for `ListInstanceAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_instance_attributes`](crate::client::Client::list_instance_attributes).
///
/// See [`crate::client::fluent_builders::ListInstanceAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInstanceAttributes {
    _private: (),
}
impl ListInstanceAttributes {
    /// Creates a new builder-style object to manufacture [`ListInstanceAttributesInput`](crate::input::ListInstanceAttributesInput)
    pub fn builder() -> crate::input::list_instance_attributes_input::Builder {
        crate::input::list_instance_attributes_input::Builder::default()
    }
    /// Creates a new `ListInstanceAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInstanceAttributes {
    type Output = std::result::Result<
        crate::output::ListInstanceAttributesOutput,
        crate::error::ListInstanceAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_instance_attributes_error(response)
        } else {
            crate::operation_deser::parse_list_instance_attributes_response(response)
        }
    }
}

/// Operation shape for `ListInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_instances`](crate::client::Client::list_instances).
///
/// See [`crate::client::fluent_builders::ListInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInstances {
    _private: (),
}
impl ListInstances {
    /// Creates a new builder-style object to manufacture [`ListInstancesInput`](crate::input::ListInstancesInput)
    pub fn builder() -> crate::input::list_instances_input::Builder {
        crate::input::list_instances_input::Builder::default()
    }
    /// Creates a new `ListInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInstances {
    type Output =
        std::result::Result<crate::output::ListInstancesOutput, crate::error::ListInstancesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_instances_error(response)
        } else {
            crate::operation_deser::parse_list_instances_response(response)
        }
    }
}

/// Operation shape for `ListInstanceStorageConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_instance_storage_configs`](crate::client::Client::list_instance_storage_configs).
///
/// See [`crate::client::fluent_builders::ListInstanceStorageConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInstanceStorageConfigs {
    _private: (),
}
impl ListInstanceStorageConfigs {
    /// Creates a new builder-style object to manufacture [`ListInstanceStorageConfigsInput`](crate::input::ListInstanceStorageConfigsInput)
    pub fn builder() -> crate::input::list_instance_storage_configs_input::Builder {
        crate::input::list_instance_storage_configs_input::Builder::default()
    }
    /// Creates a new `ListInstanceStorageConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInstanceStorageConfigs {
    type Output = std::result::Result<
        crate::output::ListInstanceStorageConfigsOutput,
        crate::error::ListInstanceStorageConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_instance_storage_configs_error(response)
        } else {
            crate::operation_deser::parse_list_instance_storage_configs_response(response)
        }
    }
}

/// Operation shape for `ListIntegrationAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_integration_associations`](crate::client::Client::list_integration_associations).
///
/// See [`crate::client::fluent_builders::ListIntegrationAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIntegrationAssociations {
    _private: (),
}
impl ListIntegrationAssociations {
    /// Creates a new builder-style object to manufacture [`ListIntegrationAssociationsInput`](crate::input::ListIntegrationAssociationsInput)
    pub fn builder() -> crate::input::list_integration_associations_input::Builder {
        crate::input::list_integration_associations_input::Builder::default()
    }
    /// Creates a new `ListIntegrationAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIntegrationAssociations {
    type Output = std::result::Result<
        crate::output::ListIntegrationAssociationsOutput,
        crate::error::ListIntegrationAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_integration_associations_error(response)
        } else {
            crate::operation_deser::parse_list_integration_associations_response(response)
        }
    }
}

/// Operation shape for `ListLambdaFunctions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_lambda_functions`](crate::client::Client::list_lambda_functions).
///
/// See [`crate::client::fluent_builders::ListLambdaFunctions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLambdaFunctions {
    _private: (),
}
impl ListLambdaFunctions {
    /// Creates a new builder-style object to manufacture [`ListLambdaFunctionsInput`](crate::input::ListLambdaFunctionsInput)
    pub fn builder() -> crate::input::list_lambda_functions_input::Builder {
        crate::input::list_lambda_functions_input::Builder::default()
    }
    /// Creates a new `ListLambdaFunctions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLambdaFunctions {
    type Output = std::result::Result<
        crate::output::ListLambdaFunctionsOutput,
        crate::error::ListLambdaFunctionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_lambda_functions_error(response)
        } else {
            crate::operation_deser::parse_list_lambda_functions_response(response)
        }
    }
}

/// Operation shape for `ListLexBots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_lex_bots`](crate::client::Client::list_lex_bots).
///
/// See [`crate::client::fluent_builders::ListLexBots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLexBots {
    _private: (),
}
impl ListLexBots {
    /// Creates a new builder-style object to manufacture [`ListLexBotsInput`](crate::input::ListLexBotsInput)
    pub fn builder() -> crate::input::list_lex_bots_input::Builder {
        crate::input::list_lex_bots_input::Builder::default()
    }
    /// Creates a new `ListLexBots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLexBots {
    type Output =
        std::result::Result<crate::output::ListLexBotsOutput, crate::error::ListLexBotsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_lex_bots_error(response)
        } else {
            crate::operation_deser::parse_list_lex_bots_response(response)
        }
    }
}

/// Operation shape for `ListPhoneNumbers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_phone_numbers`](crate::client::Client::list_phone_numbers).
///
/// See [`crate::client::fluent_builders::ListPhoneNumbers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPhoneNumbers {
    _private: (),
}
impl ListPhoneNumbers {
    /// Creates a new builder-style object to manufacture [`ListPhoneNumbersInput`](crate::input::ListPhoneNumbersInput)
    pub fn builder() -> crate::input::list_phone_numbers_input::Builder {
        crate::input::list_phone_numbers_input::Builder::default()
    }
    /// Creates a new `ListPhoneNumbers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPhoneNumbers {
    type Output = std::result::Result<
        crate::output::ListPhoneNumbersOutput,
        crate::error::ListPhoneNumbersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_phone_numbers_error(response)
        } else {
            crate::operation_deser::parse_list_phone_numbers_response(response)
        }
    }
}

/// Operation shape for `ListPrompts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_prompts`](crate::client::Client::list_prompts).
///
/// See [`crate::client::fluent_builders::ListPrompts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPrompts {
    _private: (),
}
impl ListPrompts {
    /// Creates a new builder-style object to manufacture [`ListPromptsInput`](crate::input::ListPromptsInput)
    pub fn builder() -> crate::input::list_prompts_input::Builder {
        crate::input::list_prompts_input::Builder::default()
    }
    /// Creates a new `ListPrompts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPrompts {
    type Output =
        std::result::Result<crate::output::ListPromptsOutput, crate::error::ListPromptsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_prompts_error(response)
        } else {
            crate::operation_deser::parse_list_prompts_response(response)
        }
    }
}

/// Operation shape for `ListQueueQuickConnects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_queue_quick_connects`](crate::client::Client::list_queue_quick_connects).
///
/// See [`crate::client::fluent_builders::ListQueueQuickConnects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListQueueQuickConnects {
    _private: (),
}
impl ListQueueQuickConnects {
    /// Creates a new builder-style object to manufacture [`ListQueueQuickConnectsInput`](crate::input::ListQueueQuickConnectsInput)
    pub fn builder() -> crate::input::list_queue_quick_connects_input::Builder {
        crate::input::list_queue_quick_connects_input::Builder::default()
    }
    /// Creates a new `ListQueueQuickConnects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListQueueQuickConnects {
    type Output = std::result::Result<
        crate::output::ListQueueQuickConnectsOutput,
        crate::error::ListQueueQuickConnectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_queue_quick_connects_error(response)
        } else {
            crate::operation_deser::parse_list_queue_quick_connects_response(response)
        }
    }
}

/// Operation shape for `ListQueues`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_queues`](crate::client::Client::list_queues).
///
/// See [`crate::client::fluent_builders::ListQueues`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListQueues {
    _private: (),
}
impl ListQueues {
    /// Creates a new builder-style object to manufacture [`ListQueuesInput`](crate::input::ListQueuesInput)
    pub fn builder() -> crate::input::list_queues_input::Builder {
        crate::input::list_queues_input::Builder::default()
    }
    /// Creates a new `ListQueues` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListQueues {
    type Output =
        std::result::Result<crate::output::ListQueuesOutput, crate::error::ListQueuesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_queues_error(response)
        } else {
            crate::operation_deser::parse_list_queues_response(response)
        }
    }
}

/// Operation shape for `ListQuickConnects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_quick_connects`](crate::client::Client::list_quick_connects).
///
/// See [`crate::client::fluent_builders::ListQuickConnects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListQuickConnects {
    _private: (),
}
impl ListQuickConnects {
    /// Creates a new builder-style object to manufacture [`ListQuickConnectsInput`](crate::input::ListQuickConnectsInput)
    pub fn builder() -> crate::input::list_quick_connects_input::Builder {
        crate::input::list_quick_connects_input::Builder::default()
    }
    /// Creates a new `ListQuickConnects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListQuickConnects {
    type Output = std::result::Result<
        crate::output::ListQuickConnectsOutput,
        crate::error::ListQuickConnectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_quick_connects_error(response)
        } else {
            crate::operation_deser::parse_list_quick_connects_response(response)
        }
    }
}

/// Operation shape for `ListRoutingProfileQueues`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_routing_profile_queues`](crate::client::Client::list_routing_profile_queues).
///
/// See [`crate::client::fluent_builders::ListRoutingProfileQueues`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRoutingProfileQueues {
    _private: (),
}
impl ListRoutingProfileQueues {
    /// Creates a new builder-style object to manufacture [`ListRoutingProfileQueuesInput`](crate::input::ListRoutingProfileQueuesInput)
    pub fn builder() -> crate::input::list_routing_profile_queues_input::Builder {
        crate::input::list_routing_profile_queues_input::Builder::default()
    }
    /// Creates a new `ListRoutingProfileQueues` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRoutingProfileQueues {
    type Output = std::result::Result<
        crate::output::ListRoutingProfileQueuesOutput,
        crate::error::ListRoutingProfileQueuesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_routing_profile_queues_error(response)
        } else {
            crate::operation_deser::parse_list_routing_profile_queues_response(response)
        }
    }
}

/// Operation shape for `ListRoutingProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_routing_profiles`](crate::client::Client::list_routing_profiles).
///
/// See [`crate::client::fluent_builders::ListRoutingProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRoutingProfiles {
    _private: (),
}
impl ListRoutingProfiles {
    /// Creates a new builder-style object to manufacture [`ListRoutingProfilesInput`](crate::input::ListRoutingProfilesInput)
    pub fn builder() -> crate::input::list_routing_profiles_input::Builder {
        crate::input::list_routing_profiles_input::Builder::default()
    }
    /// Creates a new `ListRoutingProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRoutingProfiles {
    type Output = std::result::Result<
        crate::output::ListRoutingProfilesOutput,
        crate::error::ListRoutingProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_routing_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_routing_profiles_response(response)
        }
    }
}

/// Operation shape for `ListSecurityKeys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_security_keys`](crate::client::Client::list_security_keys).
///
/// See [`crate::client::fluent_builders::ListSecurityKeys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSecurityKeys {
    _private: (),
}
impl ListSecurityKeys {
    /// Creates a new builder-style object to manufacture [`ListSecurityKeysInput`](crate::input::ListSecurityKeysInput)
    pub fn builder() -> crate::input::list_security_keys_input::Builder {
        crate::input::list_security_keys_input::Builder::default()
    }
    /// Creates a new `ListSecurityKeys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSecurityKeys {
    type Output = std::result::Result<
        crate::output::ListSecurityKeysOutput,
        crate::error::ListSecurityKeysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_security_keys_error(response)
        } else {
            crate::operation_deser::parse_list_security_keys_response(response)
        }
    }
}

/// Operation shape for `ListSecurityProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_security_profiles`](crate::client::Client::list_security_profiles).
///
/// See [`crate::client::fluent_builders::ListSecurityProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSecurityProfiles {
    _private: (),
}
impl ListSecurityProfiles {
    /// Creates a new builder-style object to manufacture [`ListSecurityProfilesInput`](crate::input::ListSecurityProfilesInput)
    pub fn builder() -> crate::input::list_security_profiles_input::Builder {
        crate::input::list_security_profiles_input::Builder::default()
    }
    /// Creates a new `ListSecurityProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSecurityProfiles {
    type Output = std::result::Result<
        crate::output::ListSecurityProfilesOutput,
        crate::error::ListSecurityProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_security_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_security_profiles_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListUseCases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_use_cases`](crate::client::Client::list_use_cases).
///
/// See [`crate::client::fluent_builders::ListUseCases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUseCases {
    _private: (),
}
impl ListUseCases {
    /// Creates a new builder-style object to manufacture [`ListUseCasesInput`](crate::input::ListUseCasesInput)
    pub fn builder() -> crate::input::list_use_cases_input::Builder {
        crate::input::list_use_cases_input::Builder::default()
    }
    /// Creates a new `ListUseCases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUseCases {
    type Output =
        std::result::Result<crate::output::ListUseCasesOutput, crate::error::ListUseCasesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_use_cases_error(response)
        } else {
            crate::operation_deser::parse_list_use_cases_response(response)
        }
    }
}

/// Operation shape for `ListUserHierarchyGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_user_hierarchy_groups`](crate::client::Client::list_user_hierarchy_groups).
///
/// See [`crate::client::fluent_builders::ListUserHierarchyGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUserHierarchyGroups {
    _private: (),
}
impl ListUserHierarchyGroups {
    /// Creates a new builder-style object to manufacture [`ListUserHierarchyGroupsInput`](crate::input::ListUserHierarchyGroupsInput)
    pub fn builder() -> crate::input::list_user_hierarchy_groups_input::Builder {
        crate::input::list_user_hierarchy_groups_input::Builder::default()
    }
    /// Creates a new `ListUserHierarchyGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUserHierarchyGroups {
    type Output = std::result::Result<
        crate::output::ListUserHierarchyGroupsOutput,
        crate::error::ListUserHierarchyGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_user_hierarchy_groups_error(response)
        } else {
            crate::operation_deser::parse_list_user_hierarchy_groups_response(response)
        }
    }
}

/// Operation shape for `ListUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_users`](crate::client::Client::list_users).
///
/// See [`crate::client::fluent_builders::ListUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUsers {
    _private: (),
}
impl ListUsers {
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
    /// Creates a new `ListUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUsers {
    type Output = std::result::Result<crate::output::ListUsersOutput, crate::error::ListUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_users_error(response)
        } else {
            crate::operation_deser::parse_list_users_response(response)
        }
    }
}

/// Operation shape for `ResumeContactRecording`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resume_contact_recording`](crate::client::Client::resume_contact_recording).
///
/// See [`crate::client::fluent_builders::ResumeContactRecording`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResumeContactRecording {
    _private: (),
}
impl ResumeContactRecording {
    /// Creates a new builder-style object to manufacture [`ResumeContactRecordingInput`](crate::input::ResumeContactRecordingInput)
    pub fn builder() -> crate::input::resume_contact_recording_input::Builder {
        crate::input::resume_contact_recording_input::Builder::default()
    }
    /// Creates a new `ResumeContactRecording` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResumeContactRecording {
    type Output = std::result::Result<
        crate::output::ResumeContactRecordingOutput,
        crate::error::ResumeContactRecordingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resume_contact_recording_error(response)
        } else {
            crate::operation_deser::parse_resume_contact_recording_response(response)
        }
    }
}

/// Operation shape for `StartChatContact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_chat_contact`](crate::client::Client::start_chat_contact).
///
/// See [`crate::client::fluent_builders::StartChatContact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartChatContact {
    _private: (),
}
impl StartChatContact {
    /// Creates a new builder-style object to manufacture [`StartChatContactInput`](crate::input::StartChatContactInput)
    pub fn builder() -> crate::input::start_chat_contact_input::Builder {
        crate::input::start_chat_contact_input::Builder::default()
    }
    /// Creates a new `StartChatContact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartChatContact {
    type Output = std::result::Result<
        crate::output::StartChatContactOutput,
        crate::error::StartChatContactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_chat_contact_error(response)
        } else {
            crate::operation_deser::parse_start_chat_contact_response(response)
        }
    }
}

/// Operation shape for `StartContactRecording`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_contact_recording`](crate::client::Client::start_contact_recording).
///
/// See [`crate::client::fluent_builders::StartContactRecording`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartContactRecording {
    _private: (),
}
impl StartContactRecording {
    /// Creates a new builder-style object to manufacture [`StartContactRecordingInput`](crate::input::StartContactRecordingInput)
    pub fn builder() -> crate::input::start_contact_recording_input::Builder {
        crate::input::start_contact_recording_input::Builder::default()
    }
    /// Creates a new `StartContactRecording` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartContactRecording {
    type Output = std::result::Result<
        crate::output::StartContactRecordingOutput,
        crate::error::StartContactRecordingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_contact_recording_error(response)
        } else {
            crate::operation_deser::parse_start_contact_recording_response(response)
        }
    }
}

/// Operation shape for `StartOutboundVoiceContact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_outbound_voice_contact`](crate::client::Client::start_outbound_voice_contact).
///
/// See [`crate::client::fluent_builders::StartOutboundVoiceContact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartOutboundVoiceContact {
    _private: (),
}
impl StartOutboundVoiceContact {
    /// Creates a new builder-style object to manufacture [`StartOutboundVoiceContactInput`](crate::input::StartOutboundVoiceContactInput)
    pub fn builder() -> crate::input::start_outbound_voice_contact_input::Builder {
        crate::input::start_outbound_voice_contact_input::Builder::default()
    }
    /// Creates a new `StartOutboundVoiceContact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartOutboundVoiceContact {
    type Output = std::result::Result<
        crate::output::StartOutboundVoiceContactOutput,
        crate::error::StartOutboundVoiceContactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_outbound_voice_contact_error(response)
        } else {
            crate::operation_deser::parse_start_outbound_voice_contact_response(response)
        }
    }
}

/// Operation shape for `StartTaskContact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_task_contact`](crate::client::Client::start_task_contact).
///
/// See [`crate::client::fluent_builders::StartTaskContact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartTaskContact {
    _private: (),
}
impl StartTaskContact {
    /// Creates a new builder-style object to manufacture [`StartTaskContactInput`](crate::input::StartTaskContactInput)
    pub fn builder() -> crate::input::start_task_contact_input::Builder {
        crate::input::start_task_contact_input::Builder::default()
    }
    /// Creates a new `StartTaskContact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartTaskContact {
    type Output = std::result::Result<
        crate::output::StartTaskContactOutput,
        crate::error::StartTaskContactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_task_contact_error(response)
        } else {
            crate::operation_deser::parse_start_task_contact_response(response)
        }
    }
}

/// Operation shape for `StopContact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_contact`](crate::client::Client::stop_contact).
///
/// See [`crate::client::fluent_builders::StopContact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopContact {
    _private: (),
}
impl StopContact {
    /// Creates a new builder-style object to manufacture [`StopContactInput`](crate::input::StopContactInput)
    pub fn builder() -> crate::input::stop_contact_input::Builder {
        crate::input::stop_contact_input::Builder::default()
    }
    /// Creates a new `StopContact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopContact {
    type Output =
        std::result::Result<crate::output::StopContactOutput, crate::error::StopContactError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_contact_error(response)
        } else {
            crate::operation_deser::parse_stop_contact_response(response)
        }
    }
}

/// Operation shape for `StopContactRecording`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_contact_recording`](crate::client::Client::stop_contact_recording).
///
/// See [`crate::client::fluent_builders::StopContactRecording`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopContactRecording {
    _private: (),
}
impl StopContactRecording {
    /// Creates a new builder-style object to manufacture [`StopContactRecordingInput`](crate::input::StopContactRecordingInput)
    pub fn builder() -> crate::input::stop_contact_recording_input::Builder {
        crate::input::stop_contact_recording_input::Builder::default()
    }
    /// Creates a new `StopContactRecording` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopContactRecording {
    type Output = std::result::Result<
        crate::output::StopContactRecordingOutput,
        crate::error::StopContactRecordingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_contact_recording_error(response)
        } else {
            crate::operation_deser::parse_stop_contact_recording_response(response)
        }
    }
}

/// Operation shape for `SuspendContactRecording`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`suspend_contact_recording`](crate::client::Client::suspend_contact_recording).
///
/// See [`crate::client::fluent_builders::SuspendContactRecording`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SuspendContactRecording {
    _private: (),
}
impl SuspendContactRecording {
    /// Creates a new builder-style object to manufacture [`SuspendContactRecordingInput`](crate::input::SuspendContactRecordingInput)
    pub fn builder() -> crate::input::suspend_contact_recording_input::Builder {
        crate::input::suspend_contact_recording_input::Builder::default()
    }
    /// Creates a new `SuspendContactRecording` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SuspendContactRecording {
    type Output = std::result::Result<
        crate::output::SuspendContactRecordingOutput,
        crate::error::SuspendContactRecordingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_suspend_contact_recording_error(response)
        } else {
            crate::operation_deser::parse_suspend_contact_recording_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAgentStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_agent_status`](crate::client::Client::update_agent_status).
///
/// See [`crate::client::fluent_builders::UpdateAgentStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAgentStatus {
    _private: (),
}
impl UpdateAgentStatus {
    /// Creates a new builder-style object to manufacture [`UpdateAgentStatusInput`](crate::input::UpdateAgentStatusInput)
    pub fn builder() -> crate::input::update_agent_status_input::Builder {
        crate::input::update_agent_status_input::Builder::default()
    }
    /// Creates a new `UpdateAgentStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAgentStatus {
    type Output = std::result::Result<
        crate::output::UpdateAgentStatusOutput,
        crate::error::UpdateAgentStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_agent_status_error(response)
        } else {
            crate::operation_deser::parse_update_agent_status_response(response)
        }
    }
}

/// Operation shape for `UpdateContactAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_contact_attributes`](crate::client::Client::update_contact_attributes).
///
/// See [`crate::client::fluent_builders::UpdateContactAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateContactAttributes {
    _private: (),
}
impl UpdateContactAttributes {
    /// Creates a new builder-style object to manufacture [`UpdateContactAttributesInput`](crate::input::UpdateContactAttributesInput)
    pub fn builder() -> crate::input::update_contact_attributes_input::Builder {
        crate::input::update_contact_attributes_input::Builder::default()
    }
    /// Creates a new `UpdateContactAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateContactAttributes {
    type Output = std::result::Result<
        crate::output::UpdateContactAttributesOutput,
        crate::error::UpdateContactAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_contact_attributes_error(response)
        } else {
            crate::operation_deser::parse_update_contact_attributes_response(response)
        }
    }
}

/// Operation shape for `UpdateContactFlowContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_contact_flow_content`](crate::client::Client::update_contact_flow_content).
///
/// See [`crate::client::fluent_builders::UpdateContactFlowContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateContactFlowContent {
    _private: (),
}
impl UpdateContactFlowContent {
    /// Creates a new builder-style object to manufacture [`UpdateContactFlowContentInput`](crate::input::UpdateContactFlowContentInput)
    pub fn builder() -> crate::input::update_contact_flow_content_input::Builder {
        crate::input::update_contact_flow_content_input::Builder::default()
    }
    /// Creates a new `UpdateContactFlowContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateContactFlowContent {
    type Output = std::result::Result<
        crate::output::UpdateContactFlowContentOutput,
        crate::error::UpdateContactFlowContentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_contact_flow_content_error(response)
        } else {
            crate::operation_deser::parse_update_contact_flow_content_response(response)
        }
    }
}

/// Operation shape for `UpdateContactFlowName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_contact_flow_name`](crate::client::Client::update_contact_flow_name).
///
/// See [`crate::client::fluent_builders::UpdateContactFlowName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateContactFlowName {
    _private: (),
}
impl UpdateContactFlowName {
    /// Creates a new builder-style object to manufacture [`UpdateContactFlowNameInput`](crate::input::UpdateContactFlowNameInput)
    pub fn builder() -> crate::input::update_contact_flow_name_input::Builder {
        crate::input::update_contact_flow_name_input::Builder::default()
    }
    /// Creates a new `UpdateContactFlowName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateContactFlowName {
    type Output = std::result::Result<
        crate::output::UpdateContactFlowNameOutput,
        crate::error::UpdateContactFlowNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_contact_flow_name_error(response)
        } else {
            crate::operation_deser::parse_update_contact_flow_name_response(response)
        }
    }
}

/// Operation shape for `UpdateHoursOfOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_hours_of_operation`](crate::client::Client::update_hours_of_operation).
///
/// See [`crate::client::fluent_builders::UpdateHoursOfOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateHoursOfOperation {
    _private: (),
}
impl UpdateHoursOfOperation {
    /// Creates a new builder-style object to manufacture [`UpdateHoursOfOperationInput`](crate::input::UpdateHoursOfOperationInput)
    pub fn builder() -> crate::input::update_hours_of_operation_input::Builder {
        crate::input::update_hours_of_operation_input::Builder::default()
    }
    /// Creates a new `UpdateHoursOfOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateHoursOfOperation {
    type Output = std::result::Result<
        crate::output::UpdateHoursOfOperationOutput,
        crate::error::UpdateHoursOfOperationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_hours_of_operation_error(response)
        } else {
            crate::operation_deser::parse_update_hours_of_operation_response(response)
        }
    }
}

/// Operation shape for `UpdateInstanceAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_instance_attribute`](crate::client::Client::update_instance_attribute).
///
/// See [`crate::client::fluent_builders::UpdateInstanceAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateInstanceAttribute {
    _private: (),
}
impl UpdateInstanceAttribute {
    /// Creates a new builder-style object to manufacture [`UpdateInstanceAttributeInput`](crate::input::UpdateInstanceAttributeInput)
    pub fn builder() -> crate::input::update_instance_attribute_input::Builder {
        crate::input::update_instance_attribute_input::Builder::default()
    }
    /// Creates a new `UpdateInstanceAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateInstanceAttribute {
    type Output = std::result::Result<
        crate::output::UpdateInstanceAttributeOutput,
        crate::error::UpdateInstanceAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_instance_attribute_error(response)
        } else {
            crate::operation_deser::parse_update_instance_attribute_response(response)
        }
    }
}

/// Operation shape for `UpdateInstanceStorageConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_instance_storage_config`](crate::client::Client::update_instance_storage_config).
///
/// See [`crate::client::fluent_builders::UpdateInstanceStorageConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateInstanceStorageConfig {
    _private: (),
}
impl UpdateInstanceStorageConfig {
    /// Creates a new builder-style object to manufacture [`UpdateInstanceStorageConfigInput`](crate::input::UpdateInstanceStorageConfigInput)
    pub fn builder() -> crate::input::update_instance_storage_config_input::Builder {
        crate::input::update_instance_storage_config_input::Builder::default()
    }
    /// Creates a new `UpdateInstanceStorageConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateInstanceStorageConfig {
    type Output = std::result::Result<
        crate::output::UpdateInstanceStorageConfigOutput,
        crate::error::UpdateInstanceStorageConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_instance_storage_config_error(response)
        } else {
            crate::operation_deser::parse_update_instance_storage_config_response(response)
        }
    }
}

/// Operation shape for `UpdateQueueHoursOfOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_queue_hours_of_operation`](crate::client::Client::update_queue_hours_of_operation).
///
/// See [`crate::client::fluent_builders::UpdateQueueHoursOfOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateQueueHoursOfOperation {
    _private: (),
}
impl UpdateQueueHoursOfOperation {
    /// Creates a new builder-style object to manufacture [`UpdateQueueHoursOfOperationInput`](crate::input::UpdateQueueHoursOfOperationInput)
    pub fn builder() -> crate::input::update_queue_hours_of_operation_input::Builder {
        crate::input::update_queue_hours_of_operation_input::Builder::default()
    }
    /// Creates a new `UpdateQueueHoursOfOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateQueueHoursOfOperation {
    type Output = std::result::Result<
        crate::output::UpdateQueueHoursOfOperationOutput,
        crate::error::UpdateQueueHoursOfOperationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_queue_hours_of_operation_error(response)
        } else {
            crate::operation_deser::parse_update_queue_hours_of_operation_response(response)
        }
    }
}

/// Operation shape for `UpdateQueueMaxContacts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_queue_max_contacts`](crate::client::Client::update_queue_max_contacts).
///
/// See [`crate::client::fluent_builders::UpdateQueueMaxContacts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateQueueMaxContacts {
    _private: (),
}
impl UpdateQueueMaxContacts {
    /// Creates a new builder-style object to manufacture [`UpdateQueueMaxContactsInput`](crate::input::UpdateQueueMaxContactsInput)
    pub fn builder() -> crate::input::update_queue_max_contacts_input::Builder {
        crate::input::update_queue_max_contacts_input::Builder::default()
    }
    /// Creates a new `UpdateQueueMaxContacts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateQueueMaxContacts {
    type Output = std::result::Result<
        crate::output::UpdateQueueMaxContactsOutput,
        crate::error::UpdateQueueMaxContactsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_queue_max_contacts_error(response)
        } else {
            crate::operation_deser::parse_update_queue_max_contacts_response(response)
        }
    }
}

/// Operation shape for `UpdateQueueName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_queue_name`](crate::client::Client::update_queue_name).
///
/// See [`crate::client::fluent_builders::UpdateQueueName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateQueueName {
    _private: (),
}
impl UpdateQueueName {
    /// Creates a new builder-style object to manufacture [`UpdateQueueNameInput`](crate::input::UpdateQueueNameInput)
    pub fn builder() -> crate::input::update_queue_name_input::Builder {
        crate::input::update_queue_name_input::Builder::default()
    }
    /// Creates a new `UpdateQueueName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateQueueName {
    type Output = std::result::Result<
        crate::output::UpdateQueueNameOutput,
        crate::error::UpdateQueueNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_queue_name_error(response)
        } else {
            crate::operation_deser::parse_update_queue_name_response(response)
        }
    }
}

/// Operation shape for `UpdateQueueOutboundCallerConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_queue_outbound_caller_config`](crate::client::Client::update_queue_outbound_caller_config).
///
/// See [`crate::client::fluent_builders::UpdateQueueOutboundCallerConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateQueueOutboundCallerConfig {
    _private: (),
}
impl UpdateQueueOutboundCallerConfig {
    /// Creates a new builder-style object to manufacture [`UpdateQueueOutboundCallerConfigInput`](crate::input::UpdateQueueOutboundCallerConfigInput)
    pub fn builder() -> crate::input::update_queue_outbound_caller_config_input::Builder {
        crate::input::update_queue_outbound_caller_config_input::Builder::default()
    }
    /// Creates a new `UpdateQueueOutboundCallerConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateQueueOutboundCallerConfig {
    type Output = std::result::Result<
        crate::output::UpdateQueueOutboundCallerConfigOutput,
        crate::error::UpdateQueueOutboundCallerConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_queue_outbound_caller_config_error(response)
        } else {
            crate::operation_deser::parse_update_queue_outbound_caller_config_response(response)
        }
    }
}

/// Operation shape for `UpdateQueueStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_queue_status`](crate::client::Client::update_queue_status).
///
/// See [`crate::client::fluent_builders::UpdateQueueStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateQueueStatus {
    _private: (),
}
impl UpdateQueueStatus {
    /// Creates a new builder-style object to manufacture [`UpdateQueueStatusInput`](crate::input::UpdateQueueStatusInput)
    pub fn builder() -> crate::input::update_queue_status_input::Builder {
        crate::input::update_queue_status_input::Builder::default()
    }
    /// Creates a new `UpdateQueueStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateQueueStatus {
    type Output = std::result::Result<
        crate::output::UpdateQueueStatusOutput,
        crate::error::UpdateQueueStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_queue_status_error(response)
        } else {
            crate::operation_deser::parse_update_queue_status_response(response)
        }
    }
}

/// Operation shape for `UpdateQuickConnectConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_quick_connect_config`](crate::client::Client::update_quick_connect_config).
///
/// See [`crate::client::fluent_builders::UpdateQuickConnectConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateQuickConnectConfig {
    _private: (),
}
impl UpdateQuickConnectConfig {
    /// Creates a new builder-style object to manufacture [`UpdateQuickConnectConfigInput`](crate::input::UpdateQuickConnectConfigInput)
    pub fn builder() -> crate::input::update_quick_connect_config_input::Builder {
        crate::input::update_quick_connect_config_input::Builder::default()
    }
    /// Creates a new `UpdateQuickConnectConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateQuickConnectConfig {
    type Output = std::result::Result<
        crate::output::UpdateQuickConnectConfigOutput,
        crate::error::UpdateQuickConnectConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_quick_connect_config_error(response)
        } else {
            crate::operation_deser::parse_update_quick_connect_config_response(response)
        }
    }
}

/// Operation shape for `UpdateQuickConnectName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_quick_connect_name`](crate::client::Client::update_quick_connect_name).
///
/// See [`crate::client::fluent_builders::UpdateQuickConnectName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateQuickConnectName {
    _private: (),
}
impl UpdateQuickConnectName {
    /// Creates a new builder-style object to manufacture [`UpdateQuickConnectNameInput`](crate::input::UpdateQuickConnectNameInput)
    pub fn builder() -> crate::input::update_quick_connect_name_input::Builder {
        crate::input::update_quick_connect_name_input::Builder::default()
    }
    /// Creates a new `UpdateQuickConnectName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateQuickConnectName {
    type Output = std::result::Result<
        crate::output::UpdateQuickConnectNameOutput,
        crate::error::UpdateQuickConnectNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_quick_connect_name_error(response)
        } else {
            crate::operation_deser::parse_update_quick_connect_name_response(response)
        }
    }
}

/// Operation shape for `UpdateRoutingProfileConcurrency`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_routing_profile_concurrency`](crate::client::Client::update_routing_profile_concurrency).
///
/// See [`crate::client::fluent_builders::UpdateRoutingProfileConcurrency`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRoutingProfileConcurrency {
    _private: (),
}
impl UpdateRoutingProfileConcurrency {
    /// Creates a new builder-style object to manufacture [`UpdateRoutingProfileConcurrencyInput`](crate::input::UpdateRoutingProfileConcurrencyInput)
    pub fn builder() -> crate::input::update_routing_profile_concurrency_input::Builder {
        crate::input::update_routing_profile_concurrency_input::Builder::default()
    }
    /// Creates a new `UpdateRoutingProfileConcurrency` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRoutingProfileConcurrency {
    type Output = std::result::Result<
        crate::output::UpdateRoutingProfileConcurrencyOutput,
        crate::error::UpdateRoutingProfileConcurrencyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_routing_profile_concurrency_error(response)
        } else {
            crate::operation_deser::parse_update_routing_profile_concurrency_response(response)
        }
    }
}

/// Operation shape for `UpdateRoutingProfileDefaultOutboundQueue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_routing_profile_default_outbound_queue`](crate::client::Client::update_routing_profile_default_outbound_queue).
///
/// See [`crate::client::fluent_builders::UpdateRoutingProfileDefaultOutboundQueue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRoutingProfileDefaultOutboundQueue {
    _private: (),
}
impl UpdateRoutingProfileDefaultOutboundQueue {
    /// Creates a new builder-style object to manufacture [`UpdateRoutingProfileDefaultOutboundQueueInput`](crate::input::UpdateRoutingProfileDefaultOutboundQueueInput)
    pub fn builder() -> crate::input::update_routing_profile_default_outbound_queue_input::Builder {
        crate::input::update_routing_profile_default_outbound_queue_input::Builder::default()
    }
    /// Creates a new `UpdateRoutingProfileDefaultOutboundQueue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRoutingProfileDefaultOutboundQueue {
    type Output = std::result::Result<
        crate::output::UpdateRoutingProfileDefaultOutboundQueueOutput,
        crate::error::UpdateRoutingProfileDefaultOutboundQueueError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_routing_profile_default_outbound_queue_error(
                response,
            )
        } else {
            crate::operation_deser::parse_update_routing_profile_default_outbound_queue_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateRoutingProfileName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_routing_profile_name`](crate::client::Client::update_routing_profile_name).
///
/// See [`crate::client::fluent_builders::UpdateRoutingProfileName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRoutingProfileName {
    _private: (),
}
impl UpdateRoutingProfileName {
    /// Creates a new builder-style object to manufacture [`UpdateRoutingProfileNameInput`](crate::input::UpdateRoutingProfileNameInput)
    pub fn builder() -> crate::input::update_routing_profile_name_input::Builder {
        crate::input::update_routing_profile_name_input::Builder::default()
    }
    /// Creates a new `UpdateRoutingProfileName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRoutingProfileName {
    type Output = std::result::Result<
        crate::output::UpdateRoutingProfileNameOutput,
        crate::error::UpdateRoutingProfileNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_routing_profile_name_error(response)
        } else {
            crate::operation_deser::parse_update_routing_profile_name_response(response)
        }
    }
}

/// Operation shape for `UpdateRoutingProfileQueues`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_routing_profile_queues`](crate::client::Client::update_routing_profile_queues).
///
/// See [`crate::client::fluent_builders::UpdateRoutingProfileQueues`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRoutingProfileQueues {
    _private: (),
}
impl UpdateRoutingProfileQueues {
    /// Creates a new builder-style object to manufacture [`UpdateRoutingProfileQueuesInput`](crate::input::UpdateRoutingProfileQueuesInput)
    pub fn builder() -> crate::input::update_routing_profile_queues_input::Builder {
        crate::input::update_routing_profile_queues_input::Builder::default()
    }
    /// Creates a new `UpdateRoutingProfileQueues` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRoutingProfileQueues {
    type Output = std::result::Result<
        crate::output::UpdateRoutingProfileQueuesOutput,
        crate::error::UpdateRoutingProfileQueuesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_routing_profile_queues_error(response)
        } else {
            crate::operation_deser::parse_update_routing_profile_queues_response(response)
        }
    }
}

/// Operation shape for `UpdateUserHierarchy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_hierarchy`](crate::client::Client::update_user_hierarchy).
///
/// See [`crate::client::fluent_builders::UpdateUserHierarchy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserHierarchy {
    _private: (),
}
impl UpdateUserHierarchy {
    /// Creates a new builder-style object to manufacture [`UpdateUserHierarchyInput`](crate::input::UpdateUserHierarchyInput)
    pub fn builder() -> crate::input::update_user_hierarchy_input::Builder {
        crate::input::update_user_hierarchy_input::Builder::default()
    }
    /// Creates a new `UpdateUserHierarchy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserHierarchy {
    type Output = std::result::Result<
        crate::output::UpdateUserHierarchyOutput,
        crate::error::UpdateUserHierarchyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_hierarchy_error(response)
        } else {
            crate::operation_deser::parse_update_user_hierarchy_response(response)
        }
    }
}

/// Operation shape for `UpdateUserHierarchyGroupName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_hierarchy_group_name`](crate::client::Client::update_user_hierarchy_group_name).
///
/// See [`crate::client::fluent_builders::UpdateUserHierarchyGroupName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserHierarchyGroupName {
    _private: (),
}
impl UpdateUserHierarchyGroupName {
    /// Creates a new builder-style object to manufacture [`UpdateUserHierarchyGroupNameInput`](crate::input::UpdateUserHierarchyGroupNameInput)
    pub fn builder() -> crate::input::update_user_hierarchy_group_name_input::Builder {
        crate::input::update_user_hierarchy_group_name_input::Builder::default()
    }
    /// Creates a new `UpdateUserHierarchyGroupName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserHierarchyGroupName {
    type Output = std::result::Result<
        crate::output::UpdateUserHierarchyGroupNameOutput,
        crate::error::UpdateUserHierarchyGroupNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_hierarchy_group_name_error(response)
        } else {
            crate::operation_deser::parse_update_user_hierarchy_group_name_response(response)
        }
    }
}

/// Operation shape for `UpdateUserHierarchyStructure`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_hierarchy_structure`](crate::client::Client::update_user_hierarchy_structure).
///
/// See [`crate::client::fluent_builders::UpdateUserHierarchyStructure`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserHierarchyStructure {
    _private: (),
}
impl UpdateUserHierarchyStructure {
    /// Creates a new builder-style object to manufacture [`UpdateUserHierarchyStructureInput`](crate::input::UpdateUserHierarchyStructureInput)
    pub fn builder() -> crate::input::update_user_hierarchy_structure_input::Builder {
        crate::input::update_user_hierarchy_structure_input::Builder::default()
    }
    /// Creates a new `UpdateUserHierarchyStructure` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserHierarchyStructure {
    type Output = std::result::Result<
        crate::output::UpdateUserHierarchyStructureOutput,
        crate::error::UpdateUserHierarchyStructureError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_hierarchy_structure_error(response)
        } else {
            crate::operation_deser::parse_update_user_hierarchy_structure_response(response)
        }
    }
}

/// Operation shape for `UpdateUserIdentityInfo`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_identity_info`](crate::client::Client::update_user_identity_info).
///
/// See [`crate::client::fluent_builders::UpdateUserIdentityInfo`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserIdentityInfo {
    _private: (),
}
impl UpdateUserIdentityInfo {
    /// Creates a new builder-style object to manufacture [`UpdateUserIdentityInfoInput`](crate::input::UpdateUserIdentityInfoInput)
    pub fn builder() -> crate::input::update_user_identity_info_input::Builder {
        crate::input::update_user_identity_info_input::Builder::default()
    }
    /// Creates a new `UpdateUserIdentityInfo` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserIdentityInfo {
    type Output = std::result::Result<
        crate::output::UpdateUserIdentityInfoOutput,
        crate::error::UpdateUserIdentityInfoError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_identity_info_error(response)
        } else {
            crate::operation_deser::parse_update_user_identity_info_response(response)
        }
    }
}

/// Operation shape for `UpdateUserPhoneConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_phone_config`](crate::client::Client::update_user_phone_config).
///
/// See [`crate::client::fluent_builders::UpdateUserPhoneConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserPhoneConfig {
    _private: (),
}
impl UpdateUserPhoneConfig {
    /// Creates a new builder-style object to manufacture [`UpdateUserPhoneConfigInput`](crate::input::UpdateUserPhoneConfigInput)
    pub fn builder() -> crate::input::update_user_phone_config_input::Builder {
        crate::input::update_user_phone_config_input::Builder::default()
    }
    /// Creates a new `UpdateUserPhoneConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserPhoneConfig {
    type Output = std::result::Result<
        crate::output::UpdateUserPhoneConfigOutput,
        crate::error::UpdateUserPhoneConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_phone_config_error(response)
        } else {
            crate::operation_deser::parse_update_user_phone_config_response(response)
        }
    }
}

/// Operation shape for `UpdateUserRoutingProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_routing_profile`](crate::client::Client::update_user_routing_profile).
///
/// See [`crate::client::fluent_builders::UpdateUserRoutingProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserRoutingProfile {
    _private: (),
}
impl UpdateUserRoutingProfile {
    /// Creates a new builder-style object to manufacture [`UpdateUserRoutingProfileInput`](crate::input::UpdateUserRoutingProfileInput)
    pub fn builder() -> crate::input::update_user_routing_profile_input::Builder {
        crate::input::update_user_routing_profile_input::Builder::default()
    }
    /// Creates a new `UpdateUserRoutingProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserRoutingProfile {
    type Output = std::result::Result<
        crate::output::UpdateUserRoutingProfileOutput,
        crate::error::UpdateUserRoutingProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_routing_profile_error(response)
        } else {
            crate::operation_deser::parse_update_user_routing_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateUserSecurityProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_security_profiles`](crate::client::Client::update_user_security_profiles).
///
/// See [`crate::client::fluent_builders::UpdateUserSecurityProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserSecurityProfiles {
    _private: (),
}
impl UpdateUserSecurityProfiles {
    /// Creates a new builder-style object to manufacture [`UpdateUserSecurityProfilesInput`](crate::input::UpdateUserSecurityProfilesInput)
    pub fn builder() -> crate::input::update_user_security_profiles_input::Builder {
        crate::input::update_user_security_profiles_input::Builder::default()
    }
    /// Creates a new `UpdateUserSecurityProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserSecurityProfiles {
    type Output = std::result::Result<
        crate::output::UpdateUserSecurityProfilesOutput,
        crate::error::UpdateUserSecurityProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_security_profiles_error(response)
        } else {
            crate::operation_deser::parse_update_user_security_profiles_response(response)
        }
    }
}
