// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>You have specified a template that is not valid or supported.</p>
    ConformancePackTemplateValidationException(
        crate::error::ConformancePackTemplateValidationException,
    ),
    /// <p>Your Amazon S3 bucket policy does not permit Config to write to it.</p>
    InsufficientDeliveryPolicyException(crate::error::InsufficientDeliveryPolicyException),
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li>
    /// <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p> </li>
    /// <li> <p>For PutOrganizationConfigRule, organization config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p>
    /// <ul>
    /// <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>To read Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>You have provided a configuration recorder name that is not valid.</p>
    InvalidConfigurationRecorderNameException(
        crate::error::InvalidConfigurationRecorderNameException,
    ),
    /// <p>The specified delivery channel name is not valid.</p>
    InvalidDeliveryChannelNameException(crate::error::InvalidDeliveryChannelNameException),
    /// <p>The syntax of the query is incorrect.</p>
    InvalidExpressionException(crate::error::InvalidExpressionException),
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Config throws an exception if the recording group does not contain a valid list of resource types. Invalid values might also be incorrectly formatted.</p>
    InvalidRecordingGroupException(crate::error::InvalidRecordingGroupException),
    /// <p>The specified <code>ResultToken</code> is invalid.</p>
    InvalidResultTokenException(crate::error::InvalidResultTokenException),
    /// <p>You have provided a null or empty role ARN.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>The specified Amazon S3 key prefix is not valid.</p>
    InvalidS3KeyPrefixException(crate::error::InvalidS3KeyPrefixException),
    /// <p>The specified Amazon KMS Key ARN is not valid.</p>
    InvalidS3KmsKeyArnException(crate::error::InvalidS3KmsKeyArnException),
    /// <p>The specified Amazon SNS topic does not exist.</p>
    InvalidSnsTopicArnException(crate::error::InvalidSnsTopicArnException),
    /// <p>The specified time range is not valid. The earlier time is not chronologically before the later time.</p>
    InvalidTimeRangeException(crate::error::InvalidTimeRangeException),
    /// <p>You cannot delete the delivery channel you specified because the configuration recorder is running.</p>
    LastDeliveryChannelDeleteFailedException(
        crate::error::LastDeliveryChannelDeleteFailedException,
    ),
    /// <p>For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if an evaluation is in progress or if you call the <code>StartConfigRulesEvaluation</code> API more than once per minute.</p>
    /// <p>For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and aggregators exceeds the limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>You have reached the limit (100,000) of active custom resource types in your account. Delete unused resources using <code>DeleteResourceConfig</code>.</p>
    MaxActiveResourcesExceededException(crate::error::MaxActiveResourcesExceededException),
    /// <p>Failed to add the Config rule because the account already contains the maximum number of 150 rules. Consider deleting any deactivated rules before you add new rules.</p>
    MaxNumberOfConfigRulesExceededException(crate::error::MaxNumberOfConfigRulesExceededException),
    /// <p>You have reached the limit of the number of recorders you can create.</p>
    MaxNumberOfConfigurationRecordersExceededException(
        crate::error::MaxNumberOfConfigurationRecordersExceededException,
    ),
    /// <p>You have reached the limit (6) of the number of conformance packs in an account (6 conformance pack with 25 Config rules per pack).</p>
    MaxNumberOfConformancePacksExceededException(
        crate::error::MaxNumberOfConformancePacksExceededException,
    ),
    /// <p>You have reached the limit of the number of delivery channels you can create.</p>
    MaxNumberOfDeliveryChannelsExceededException(
        crate::error::MaxNumberOfDeliveryChannelsExceededException,
    ),
    /// <p>You have reached the limit of the number of organization config rules you can create.</p>
    MaxNumberOfOrganizationConfigRulesExceededException(
        crate::error::MaxNumberOfOrganizationConfigRulesExceededException,
    ),
    /// <p>You have reached the limit (6) of the number of organization conformance packs in an account (6 conformance pack with 25 Config rules per pack per account).</p>
    MaxNumberOfOrganizationConformancePacksExceededException(
        crate::error::MaxNumberOfOrganizationConformancePacksExceededException,
    ),
    /// <p>Failed to add the retention configuration because a retention configuration with that name already exists.</p>
    MaxNumberOfRetentionConfigurationsExceededException(
        crate::error::MaxNumberOfRetentionConfigurationsExceededException,
    ),
    /// <p>There are no configuration recorders available to provide the role needed to describe your resources. Create a configuration recorder.</p>
    NoAvailableConfigurationRecorderException(
        crate::error::NoAvailableConfigurationRecorderException,
    ),
    /// <p>There is no delivery channel available to record configurations.</p>
    NoAvailableDeliveryChannelException(crate::error::NoAvailableDeliveryChannelException),
    /// <p>Organization is no longer available.</p>
    NoAvailableOrganizationException(crate::error::NoAvailableOrganizationException),
    /// <p>There is no configuration recorder running.</p>
    NoRunningConfigurationRecorderException(crate::error::NoRunningConfigurationRecorderException),
    /// <p>The specified Amazon S3 bucket does not exist.</p>
    NoSuchBucketException(crate::error::NoSuchBucketException),
    /// <p>One or more Config rules in the request are invalid. Verify that the rule names are correct and try again.</p>
    NoSuchConfigRuleException(crate::error::NoSuchConfigRuleException),
    /// <p>Config rule that you passed in the filter does not exist.</p>
    NoSuchConfigRuleInConformancePackException(
        crate::error::NoSuchConfigRuleInConformancePackException,
    ),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// <p>You have specified a configuration recorder that does not exist.</p>
    NoSuchConfigurationRecorderException(crate::error::NoSuchConfigurationRecorderException),
    /// <p>You specified one or more conformance packs that do not exist.</p>
    NoSuchConformancePackException(crate::error::NoSuchConformancePackException),
    /// <p>You have specified a delivery channel that does not exist.</p>
    NoSuchDeliveryChannelException(crate::error::NoSuchDeliveryChannelException),
    /// <p>You specified one or more organization config rules that do not exist.</p>
    NoSuchOrganizationConfigRuleException(crate::error::NoSuchOrganizationConfigRuleException),
    /// <p>Config organization conformance pack that you passed in the filter does not exist.</p>
    /// <p>For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not exist.</p>
    NoSuchOrganizationConformancePackException(
        crate::error::NoSuchOrganizationConformancePackException,
    ),
    /// <p>You specified an Config rule without a remediation configuration.</p>
    NoSuchRemediationConfigurationException(crate::error::NoSuchRemediationConfigurationException),
    /// <p>You tried to delete a remediation exception that does not exist.</p>
    NoSuchRemediationExceptionException(crate::error::NoSuchRemediationExceptionException),
    /// <p>You have specified a retention configuration that does not exist.</p>
    NoSuchRetentionConfigurationException(crate::error::NoSuchRetentionConfigurationException),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// <p>Config resource cannot be created because your organization does not have all features enabled.</p>
    OrganizationAllFeaturesNotEnabledException(
        crate::error::OrganizationAllFeaturesNotEnabledException,
    ),
    /// <p>You have specified a template that is not valid or supported.</p>
    OrganizationConformancePackTemplateValidationException(
        crate::error::OrganizationConformancePackTemplateValidationException,
    ),
    /// <p>The configuration item size is outside the allowable range.</p>
    OversizedConfigurationItemException(crate::error::OversizedConfigurationItemException),
    /// <p>Remediation action is in progress. You can either cancel execution in Amazon Web Services Systems Manager or wait and try again later. </p>
    RemediationInProgressException(crate::error::RemediationInProgressException),
    /// <p>Two users are trying to modify the same query at the same time. Wait for a moment and try again.</p>
    ResourceConcurrentModificationException(crate::error::ResourceConcurrentModificationException),
    /// <p>You see this exception in the following cases: </p>
    /// <ul>
    /// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
    /// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// </ul>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>You have specified a resource that is either unknown or has not been discovered.</p>
    ResourceNotDiscoveredException(crate::error::ResourceNotDiscoveredException),
    /// <p>You have specified a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached the limit of the number of tags you can use. You have more than 50 tags.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ConformancePackTemplateValidationException(inner) => inner.fmt(f),
            Error::InsufficientDeliveryPolicyException(inner) => inner.fmt(f),
            Error::InsufficientPermissionsException(inner) => inner.fmt(f),
            Error::InvalidConfigurationRecorderNameException(inner) => inner.fmt(f),
            Error::InvalidDeliveryChannelNameException(inner) => inner.fmt(f),
            Error::InvalidExpressionException(inner) => inner.fmt(f),
            Error::InvalidLimitException(inner) => inner.fmt(f),
            Error::InvalidNextTokenException(inner) => inner.fmt(f),
            Error::InvalidParameterValueException(inner) => inner.fmt(f),
            Error::InvalidRecordingGroupException(inner) => inner.fmt(f),
            Error::InvalidResultTokenException(inner) => inner.fmt(f),
            Error::InvalidRoleException(inner) => inner.fmt(f),
            Error::InvalidS3KeyPrefixException(inner) => inner.fmt(f),
            Error::InvalidS3KmsKeyArnException(inner) => inner.fmt(f),
            Error::InvalidSnsTopicArnException(inner) => inner.fmt(f),
            Error::InvalidTimeRangeException(inner) => inner.fmt(f),
            Error::LastDeliveryChannelDeleteFailedException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::MaxActiveResourcesExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfConfigRulesExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfConfigurationRecordersExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfConformancePacksExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfDeliveryChannelsExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfOrganizationConfigRulesExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfOrganizationConformancePacksExceededException(inner) => inner.fmt(f),
            Error::MaxNumberOfRetentionConfigurationsExceededException(inner) => inner.fmt(f),
            Error::NoAvailableConfigurationRecorderException(inner) => inner.fmt(f),
            Error::NoAvailableDeliveryChannelException(inner) => inner.fmt(f),
            Error::NoAvailableOrganizationException(inner) => inner.fmt(f),
            Error::NoRunningConfigurationRecorderException(inner) => inner.fmt(f),
            Error::NoSuchBucketException(inner) => inner.fmt(f),
            Error::NoSuchConfigRuleException(inner) => inner.fmt(f),
            Error::NoSuchConfigRuleInConformancePackException(inner) => inner.fmt(f),
            Error::NoSuchConfigurationAggregatorException(inner) => inner.fmt(f),
            Error::NoSuchConfigurationRecorderException(inner) => inner.fmt(f),
            Error::NoSuchConformancePackException(inner) => inner.fmt(f),
            Error::NoSuchDeliveryChannelException(inner) => inner.fmt(f),
            Error::NoSuchOrganizationConfigRuleException(inner) => inner.fmt(f),
            Error::NoSuchOrganizationConformancePackException(inner) => inner.fmt(f),
            Error::NoSuchRemediationConfigurationException(inner) => inner.fmt(f),
            Error::NoSuchRemediationExceptionException(inner) => inner.fmt(f),
            Error::NoSuchRetentionConfigurationException(inner) => inner.fmt(f),
            Error::OrganizationAccessDeniedException(inner) => inner.fmt(f),
            Error::OrganizationAllFeaturesNotEnabledException(inner) => inner.fmt(f),
            Error::OrganizationConformancePackTemplateValidationException(inner) => inner.fmt(f),
            Error::OversizedConfigurationItemException(inner) => inner.fmt(f),
            Error::RemediationInProgressException(inner) => inner.fmt(f),
            Error::ResourceConcurrentModificationException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::ResourceNotDiscoveredException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::TooManyTagsException(inner) => inner.fmt(f),
            Error::ValidationException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::BatchGetAggregateResourceConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::BatchGetAggregateResourceConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchGetAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::BatchGetAggregateResourceConfigErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::BatchGetAggregateResourceConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetResourceConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetResourceConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchGetResourceConfigErrorKind::NoAvailableConfigurationRecorderException(inner) => Error::NoAvailableConfigurationRecorderException(inner),
                crate::error::BatchGetResourceConfigErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::BatchGetResourceConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteAggregationAuthorizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteAggregationAuthorizationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteAggregationAuthorizationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteAggregationAuthorizationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteConfigRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteConfigRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteConfigRuleErrorKind::NoSuchConfigRuleException(inner) => {
                    Error::NoSuchConfigRuleException(inner)
                }
                crate::error::DeleteConfigRuleErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeleteConfigRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationAggregatorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationAggregatorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteConfigurationAggregatorErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::DeleteConfigurationAggregatorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationRecorderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationRecorderError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(inner) => Error::NoSuchConfigurationRecorderException(inner),
                crate::error::DeleteConfigurationRecorderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteConformancePackError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteConformancePackError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteConformancePackErrorKind::NoSuchConformancePackException(
                    inner,
                ) => Error::NoSuchConformancePackException(inner),
                crate::error::DeleteConformancePackErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeleteConformancePackErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDeliveryChannelError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDeliveryChannelError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDeliveryChannelErrorKind::LastDeliveryChannelDeleteFailedException(inner) => Error::LastDeliveryChannelDeleteFailedException(inner),
                crate::error::DeleteDeliveryChannelErrorKind::NoSuchDeliveryChannelException(inner) => Error::NoSuchDeliveryChannelException(inner),
                crate::error::DeleteDeliveryChannelErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEvaluationResultsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteEvaluationResultsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteEvaluationResultsErrorKind::NoSuchConfigRuleException(
                    inner,
                ) => Error::NoSuchConfigRuleException(inner),
                crate::error::DeleteEvaluationResultsErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeleteEvaluationResultsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationConfigRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationConfigRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteOrganizationConfigRuleErrorKind::NoSuchOrganizationConfigRuleException(inner) => Error::NoSuchOrganizationConfigRuleException(inner),
                crate::error::DeleteOrganizationConfigRuleErrorKind::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
                crate::error::DeleteOrganizationConfigRuleErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::DeleteOrganizationConfigRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationConformancePackError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteOrganizationConformancePackError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteOrganizationConformancePackErrorKind::NoSuchOrganizationConformancePackException(inner) => Error::NoSuchOrganizationConformancePackException(inner),
                crate::error::DeleteOrganizationConformancePackErrorKind::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
                crate::error::DeleteOrganizationConformancePackErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::DeleteOrganizationConformancePackErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeletePendingAggregationRequestError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeletePendingAggregationRequestError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeletePendingAggregationRequestErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeletePendingAggregationRequestErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteRemediationConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteRemediationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteRemediationConfigurationErrorKind::InsufficientPermissionsException(inner) => Error::InsufficientPermissionsException(inner),
                crate::error::DeleteRemediationConfigurationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteRemediationConfigurationErrorKind::NoSuchRemediationConfigurationException(inner) => Error::NoSuchRemediationConfigurationException(inner),
                crate::error::DeleteRemediationConfigurationErrorKind::RemediationInProgressException(inner) => Error::RemediationInProgressException(inner),
                crate::error::DeleteRemediationConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteRemediationExceptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteRemediationExceptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteRemediationExceptionsErrorKind::NoSuchRemediationExceptionException(inner) => Error::NoSuchRemediationExceptionException(inner),
                crate::error::DeleteRemediationExceptionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteResourceConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteResourceConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteResourceConfigErrorKind::NoRunningConfigurationRecorderException(inner) => Error::NoRunningConfigurationRecorderException(inner),
                crate::error::DeleteResourceConfigErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::DeleteResourceConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteRetentionConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteRetentionConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteRetentionConfigurationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteRetentionConfigurationErrorKind::NoSuchRetentionConfigurationException(inner) => Error::NoSuchRetentionConfigurationException(inner),
                crate::error::DeleteRetentionConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteStoredQueryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteStoredQueryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteStoredQueryErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteStoredQueryErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DeleteStoredQueryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeliverConfigSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeliverConfigSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeliverConfigSnapshotErrorKind::NoAvailableConfigurationRecorderException(inner) => Error::NoAvailableConfigurationRecorderException(inner),
                crate::error::DeliverConfigSnapshotErrorKind::NoRunningConfigurationRecorderException(inner) => Error::NoRunningConfigurationRecorderException(inner),
                crate::error::DeliverConfigSnapshotErrorKind::NoSuchDeliveryChannelException(inner) => Error::NoSuchDeliveryChannelException(inner),
                crate::error::DeliverConfigSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeAggregateComplianceByConfigRulesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeAggregateComplianceByConfigRulesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeAggregateComplianceByConfigRulesErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribeAggregateComplianceByConfigRulesErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeAggregateComplianceByConfigRulesErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::DescribeAggregateComplianceByConfigRulesErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::DescribeAggregateComplianceByConfigRulesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeAggregateComplianceByConformancePacksError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeAggregateComplianceByConformancePacksError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeAggregateComplianceByConformancePacksErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribeAggregateComplianceByConformancePacksErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeAggregateComplianceByConformancePacksErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::DescribeAggregateComplianceByConformancePacksErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::DescribeAggregateComplianceByConformancePacksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeAggregationAuthorizationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeAggregationAuthorizationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeAggregationAuthorizationsErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribeAggregationAuthorizationsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeAggregationAuthorizationsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeAggregationAuthorizationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeComplianceByConfigRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeComplianceByConfigRuleError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeComplianceByConfigRuleErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeComplianceByConfigRuleErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeComplianceByConfigRuleErrorKind::NoSuchConfigRuleException(inner) => Error::NoSuchConfigRuleException(inner),
                crate::error::DescribeComplianceByConfigRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeComplianceByResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeComplianceByResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeComplianceByResourceErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeComplianceByResourceErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeComplianceByResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeConfigRuleEvaluationStatusError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeConfigRuleEvaluationStatusError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeConfigRuleEvaluationStatusErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeConfigRuleEvaluationStatusErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeConfigRuleEvaluationStatusErrorKind::NoSuchConfigRuleException(inner) => Error::NoSuchConfigRuleException(inner),
                crate::error::DescribeConfigRuleEvaluationStatusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeConfigRulesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeConfigRulesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeConfigRulesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::DescribeConfigRulesErrorKind::NoSuchConfigRuleException(inner) => {
                    Error::NoSuchConfigRuleException(inner)
                }
                crate::error::DescribeConfigRulesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationAggregatorsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeConfigurationAggregatorsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeConfigurationAggregatorsErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribeConfigurationAggregatorsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeConfigurationAggregatorsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeConfigurationAggregatorsErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::DescribeConfigurationAggregatorsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeConfigurationAggregatorSourcesStatusError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeConfigurationAggregatorSourcesStatusError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeConfigurationAggregatorSourcesStatusErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::DescribeConfigurationAggregatorSourcesStatusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationRecordersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeConfigurationRecordersError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeConfigurationRecordersErrorKind::NoSuchConfigurationRecorderException(inner) => Error::NoSuchConfigurationRecorderException(inner),
                crate::error::DescribeConfigurationRecordersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeConfigurationRecorderStatusError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeConfigurationRecorderStatusError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeConfigurationRecorderStatusErrorKind::NoSuchConfigurationRecorderException(inner) => Error::NoSuchConfigurationRecorderException(inner),
                crate::error::DescribeConfigurationRecorderStatusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeConformancePackComplianceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeConformancePackComplianceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeConformancePackComplianceErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribeConformancePackComplianceErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeConformancePackComplianceErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeConformancePackComplianceErrorKind::NoSuchConfigRuleInConformancePackException(inner) => Error::NoSuchConfigRuleInConformancePackException(inner),
                crate::error::DescribeConformancePackComplianceErrorKind::NoSuchConformancePackException(inner) => Error::NoSuchConformancePackException(inner),
                crate::error::DescribeConformancePackComplianceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeConformancePacksError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeConformancePacksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeConformancePacksErrorKind::InvalidLimitException(inner) => {
                    Error::InvalidLimitException(inner)
                }
                crate::error::DescribeConformancePacksErrorKind::InvalidNextTokenException(
                    inner,
                ) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeConformancePacksErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeConformancePacksErrorKind::NoSuchConformancePackException(
                    inner,
                ) => Error::NoSuchConformancePackException(inner),
                crate::error::DescribeConformancePacksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeConformancePackStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeConformancePackStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeConformancePackStatusErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribeConformancePackStatusErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeConformancePackStatusErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeConformancePackStatusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDeliveryChannelsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDeliveryChannelsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDeliveryChannelsErrorKind::NoSuchDeliveryChannelException(
                    inner,
                ) => Error::NoSuchDeliveryChannelException(inner),
                crate::error::DescribeDeliveryChannelsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDeliveryChannelStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDeliveryChannelStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDeliveryChannelStatusErrorKind::NoSuchDeliveryChannelException(inner) => Error::NoSuchDeliveryChannelException(inner),
                crate::error::DescribeDeliveryChannelStatusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationConfigRulesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeOrganizationConfigRulesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeOrganizationConfigRulesErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribeOrganizationConfigRulesErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeOrganizationConfigRulesErrorKind::NoSuchOrganizationConfigRuleException(inner) => Error::NoSuchOrganizationConfigRuleException(inner),
                crate::error::DescribeOrganizationConfigRulesErrorKind::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
                crate::error::DescribeOrganizationConfigRulesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeOrganizationConfigRuleStatusesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeOrganizationConfigRuleStatusesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeOrganizationConfigRuleStatusesErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribeOrganizationConfigRuleStatusesErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeOrganizationConfigRuleStatusesErrorKind::NoSuchOrganizationConfigRuleException(inner) => Error::NoSuchOrganizationConfigRuleException(inner),
                crate::error::DescribeOrganizationConfigRuleStatusesErrorKind::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
                crate::error::DescribeOrganizationConfigRuleStatusesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeOrganizationConformancePacksError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeOrganizationConformancePacksError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeOrganizationConformancePacksErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribeOrganizationConformancePacksErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeOrganizationConformancePacksErrorKind::NoSuchOrganizationConformancePackException(inner) => Error::NoSuchOrganizationConformancePackException(inner),
                crate::error::DescribeOrganizationConformancePacksErrorKind::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
                crate::error::DescribeOrganizationConformancePacksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeOrganizationConformancePackStatusesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeOrganizationConformancePackStatusesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeOrganizationConformancePackStatusesErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribeOrganizationConformancePackStatusesErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeOrganizationConformancePackStatusesErrorKind::NoSuchOrganizationConformancePackException(inner) => Error::NoSuchOrganizationConformancePackException(inner),
                crate::error::DescribeOrganizationConformancePackStatusesErrorKind::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
                crate::error::DescribeOrganizationConformancePackStatusesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribePendingAggregationRequestsError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribePendingAggregationRequestsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribePendingAggregationRequestsErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::DescribePendingAggregationRequestsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribePendingAggregationRequestsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribePendingAggregationRequestsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeRemediationConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeRemediationConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeRemediationConfigurationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeRemediationExceptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeRemediationExceptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeRemediationExceptionsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeRemediationExceptionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeRemediationExceptionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeRemediationExecutionStatusError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeRemediationExecutionStatusError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeRemediationExecutionStatusErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeRemediationExecutionStatusErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeRemediationExecutionStatusErrorKind::NoSuchRemediationConfigurationException(inner) => Error::NoSuchRemediationConfigurationException(inner),
                crate::error::DescribeRemediationExecutionStatusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeRetentionConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeRetentionConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeRetentionConfigurationsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeRetentionConfigurationsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeRetentionConfigurationsErrorKind::NoSuchRetentionConfigurationException(inner) => Error::NoSuchRetentionConfigurationException(inner),
                crate::error::DescribeRetentionConfigurationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetAggregateComplianceDetailsByConfigRuleError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetAggregateComplianceDetailsByConfigRuleError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetAggregateComplianceDetailsByConfigRuleErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::GetAggregateComplianceDetailsByConfigRuleErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetAggregateComplianceDetailsByConfigRuleErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::GetAggregateComplianceDetailsByConfigRuleErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::GetAggregateComplianceDetailsByConfigRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetAggregateConfigRuleComplianceSummaryError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetAggregateConfigRuleComplianceSummaryError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetAggregateConfigRuleComplianceSummaryErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::GetAggregateConfigRuleComplianceSummaryErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetAggregateConfigRuleComplianceSummaryErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::GetAggregateConfigRuleComplianceSummaryErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::GetAggregateConfigRuleComplianceSummaryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetAggregateConformancePackComplianceSummaryError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetAggregateConformancePackComplianceSummaryError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetAggregateConformancePackComplianceSummaryErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::GetAggregateConformancePackComplianceSummaryErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetAggregateConformancePackComplianceSummaryErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::GetAggregateConformancePackComplianceSummaryErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::GetAggregateConformancePackComplianceSummaryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetAggregateDiscoveredResourceCountsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetAggregateDiscoveredResourceCountsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetAggregateDiscoveredResourceCountsErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::GetAggregateDiscoveredResourceCountsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetAggregateDiscoveredResourceCountsErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::GetAggregateDiscoveredResourceCountsErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::GetAggregateDiscoveredResourceCountsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAggregateResourceConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetAggregateResourceConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::GetAggregateResourceConfigErrorKind::OversizedConfigurationItemException(inner) => Error::OversizedConfigurationItemException(inner),
                crate::error::GetAggregateResourceConfigErrorKind::ResourceNotDiscoveredException(inner) => Error::ResourceNotDiscoveredException(inner),
                crate::error::GetAggregateResourceConfigErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::GetAggregateResourceConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetComplianceDetailsByConfigRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetComplianceDetailsByConfigRuleError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetComplianceDetailsByConfigRuleErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetComplianceDetailsByConfigRuleErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::GetComplianceDetailsByConfigRuleErrorKind::NoSuchConfigRuleException(inner) => Error::NoSuchConfigRuleException(inner),
                crate::error::GetComplianceDetailsByConfigRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetComplianceDetailsByResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetComplianceDetailsByResourceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetComplianceDetailsByResourceErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::GetComplianceDetailsByResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetComplianceSummaryByConfigRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetComplianceSummaryByConfigRuleError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetComplianceSummaryByConfigRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::GetComplianceSummaryByResourceTypeError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetComplianceSummaryByResourceTypeError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetComplianceSummaryByResourceTypeErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::GetComplianceSummaryByResourceTypeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetConformancePackComplianceDetailsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetConformancePackComplianceDetailsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetConformancePackComplianceDetailsErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::GetConformancePackComplianceDetailsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetConformancePackComplianceDetailsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::GetConformancePackComplianceDetailsErrorKind::NoSuchConfigRuleInConformancePackException(inner) => Error::NoSuchConfigRuleInConformancePackException(inner),
                crate::error::GetConformancePackComplianceDetailsErrorKind::NoSuchConformancePackException(inner) => Error::NoSuchConformancePackException(inner),
                crate::error::GetConformancePackComplianceDetailsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetConformancePackComplianceSummaryError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetConformancePackComplianceSummaryError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetConformancePackComplianceSummaryErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::GetConformancePackComplianceSummaryErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetConformancePackComplianceSummaryErrorKind::NoSuchConformancePackException(inner) => Error::NoSuchConformancePackException(inner),
                crate::error::GetConformancePackComplianceSummaryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDiscoveredResourceCountsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDiscoveredResourceCountsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDiscoveredResourceCountsErrorKind::InvalidLimitException(
                    inner,
                ) => Error::InvalidLimitException(inner),
                crate::error::GetDiscoveredResourceCountsErrorKind::InvalidNextTokenException(
                    inner,
                ) => Error::InvalidNextTokenException(inner),
                crate::error::GetDiscoveredResourceCountsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetDiscoveredResourceCountsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetOrganizationConfigRuleDetailedStatusError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetOrganizationConfigRuleDetailedStatusError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetOrganizationConfigRuleDetailedStatusErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::GetOrganizationConfigRuleDetailedStatusErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetOrganizationConfigRuleDetailedStatusErrorKind::NoSuchOrganizationConfigRuleException(inner) => Error::NoSuchOrganizationConfigRuleException(inner),
                crate::error::GetOrganizationConfigRuleDetailedStatusErrorKind::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
                crate::error::GetOrganizationConfigRuleDetailedStatusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetOrganizationConformancePackDetailedStatusError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetOrganizationConformancePackDetailedStatusError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetOrganizationConformancePackDetailedStatusErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::GetOrganizationConformancePackDetailedStatusErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetOrganizationConformancePackDetailedStatusErrorKind::NoSuchOrganizationConformancePackException(inner) => Error::NoSuchOrganizationConformancePackException(inner),
                crate::error::GetOrganizationConformancePackDetailedStatusErrorKind::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
                crate::error::GetOrganizationConformancePackDetailedStatusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResourceConfigHistoryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResourceConfigHistoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetResourceConfigHistoryErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::GetResourceConfigHistoryErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetResourceConfigHistoryErrorKind::InvalidTimeRangeException(inner) => Error::InvalidTimeRangeException(inner),
                crate::error::GetResourceConfigHistoryErrorKind::NoAvailableConfigurationRecorderException(inner) => Error::NoAvailableConfigurationRecorderException(inner),
                crate::error::GetResourceConfigHistoryErrorKind::ResourceNotDiscoveredException(inner) => Error::ResourceNotDiscoveredException(inner),
                crate::error::GetResourceConfigHistoryErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::GetResourceConfigHistoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetStoredQueryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetStoredQueryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetStoredQueryErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetStoredQueryErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetStoredQueryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListAggregateDiscoveredResourcesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListAggregateDiscoveredResourcesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListAggregateDiscoveredResourcesErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::ListAggregateDiscoveredResourcesErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListAggregateDiscoveredResourcesErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::ListAggregateDiscoveredResourcesErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::ListAggregateDiscoveredResourcesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDiscoveredResourcesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDiscoveredResourcesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListDiscoveredResourcesErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::ListDiscoveredResourcesErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListDiscoveredResourcesErrorKind::NoAvailableConfigurationRecorderException(inner) => Error::NoAvailableConfigurationRecorderException(inner),
                crate::error::ListDiscoveredResourcesErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::ListDiscoveredResourcesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListStoredQueriesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListStoredQueriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListStoredQueriesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListStoredQueriesErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListStoredQueriesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::InvalidLimitException(inner) => {
                    Error::InvalidLimitException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutAggregationAuthorizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutAggregationAuthorizationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutAggregationAuthorizationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::PutAggregationAuthorizationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutConfigRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutConfigRuleError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutConfigRuleErrorKind::InsufficientPermissionsException(inner) => {
                    Error::InsufficientPermissionsException(inner)
                }
                crate::error::PutConfigRuleErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::PutConfigRuleErrorKind::MaxNumberOfConfigRulesExceededException(
                    inner,
                ) => Error::MaxNumberOfConfigRulesExceededException(inner),
                crate::error::PutConfigRuleErrorKind::NoAvailableConfigurationRecorderException(
                    inner,
                ) => Error::NoAvailableConfigurationRecorderException(inner),
                crate::error::PutConfigRuleErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::PutConfigRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutConfigurationAggregatorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutConfigurationAggregatorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutConfigurationAggregatorErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::PutConfigurationAggregatorErrorKind::InvalidRoleException(inner) => Error::InvalidRoleException(inner),
                crate::error::PutConfigurationAggregatorErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::PutConfigurationAggregatorErrorKind::NoAvailableOrganizationException(inner) => Error::NoAvailableOrganizationException(inner),
                crate::error::PutConfigurationAggregatorErrorKind::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
                crate::error::PutConfigurationAggregatorErrorKind::OrganizationAllFeaturesNotEnabledException(inner) => Error::OrganizationAllFeaturesNotEnabledException(inner),
                crate::error::PutConfigurationAggregatorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutConfigurationRecorderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutConfigurationRecorderError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutConfigurationRecorderErrorKind::InvalidConfigurationRecorderNameException(inner) => Error::InvalidConfigurationRecorderNameException(inner),
                crate::error::PutConfigurationRecorderErrorKind::InvalidRecordingGroupException(inner) => Error::InvalidRecordingGroupException(inner),
                crate::error::PutConfigurationRecorderErrorKind::InvalidRoleException(inner) => Error::InvalidRoleException(inner),
                crate::error::PutConfigurationRecorderErrorKind::MaxNumberOfConfigurationRecordersExceededException(inner) => Error::MaxNumberOfConfigurationRecordersExceededException(inner),
                crate::error::PutConfigurationRecorderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutConformancePackError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutConformancePackError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutConformancePackErrorKind::ConformancePackTemplateValidationException(inner) => Error::ConformancePackTemplateValidationException(inner),
                crate::error::PutConformancePackErrorKind::InsufficientPermissionsException(inner) => Error::InsufficientPermissionsException(inner),
                crate::error::PutConformancePackErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::PutConformancePackErrorKind::MaxNumberOfConformancePacksExceededException(inner) => Error::MaxNumberOfConformancePacksExceededException(inner),
                crate::error::PutConformancePackErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::PutConformancePackErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutDeliveryChannelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutDeliveryChannelError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutDeliveryChannelErrorKind::InsufficientDeliveryPolicyException(inner) => Error::InsufficientDeliveryPolicyException(inner),
                crate::error::PutDeliveryChannelErrorKind::InvalidDeliveryChannelNameException(inner) => Error::InvalidDeliveryChannelNameException(inner),
                crate::error::PutDeliveryChannelErrorKind::InvalidS3KeyPrefixException(inner) => Error::InvalidS3KeyPrefixException(inner),
                crate::error::PutDeliveryChannelErrorKind::InvalidS3KmsKeyArnException(inner) => Error::InvalidS3KmsKeyArnException(inner),
                crate::error::PutDeliveryChannelErrorKind::InvalidSnsTopicArnException(inner) => Error::InvalidSnsTopicArnException(inner),
                crate::error::PutDeliveryChannelErrorKind::MaxNumberOfDeliveryChannelsExceededException(inner) => Error::MaxNumberOfDeliveryChannelsExceededException(inner),
                crate::error::PutDeliveryChannelErrorKind::NoAvailableConfigurationRecorderException(inner) => Error::NoAvailableConfigurationRecorderException(inner),
                crate::error::PutDeliveryChannelErrorKind::NoSuchBucketException(inner) => Error::NoSuchBucketException(inner),
                crate::error::PutDeliveryChannelErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutEvaluationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutEvaluationsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutEvaluationsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::PutEvaluationsErrorKind::InvalidResultTokenException(inner) => {
                    Error::InvalidResultTokenException(inner)
                }
                crate::error::PutEvaluationsErrorKind::NoSuchConfigRuleException(inner) => {
                    Error::NoSuchConfigRuleException(inner)
                }
                crate::error::PutEvaluationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutExternalEvaluationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutExternalEvaluationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutExternalEvaluationErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::PutExternalEvaluationErrorKind::NoSuchConfigRuleException(inner) => {
                    Error::NoSuchConfigRuleException(inner)
                }
                crate::error::PutExternalEvaluationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutOrganizationConfigRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutOrganizationConfigRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutOrganizationConfigRuleErrorKind::InsufficientPermissionsException(inner) => Error::InsufficientPermissionsException(inner),
                crate::error::PutOrganizationConfigRuleErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::PutOrganizationConfigRuleErrorKind::MaxNumberOfOrganizationConfigRulesExceededException(inner) => Error::MaxNumberOfOrganizationConfigRulesExceededException(inner),
                crate::error::PutOrganizationConfigRuleErrorKind::NoAvailableOrganizationException(inner) => Error::NoAvailableOrganizationException(inner),
                crate::error::PutOrganizationConfigRuleErrorKind::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
                crate::error::PutOrganizationConfigRuleErrorKind::OrganizationAllFeaturesNotEnabledException(inner) => Error::OrganizationAllFeaturesNotEnabledException(inner),
                crate::error::PutOrganizationConfigRuleErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::PutOrganizationConfigRuleErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::PutOrganizationConfigRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::PutOrganizationConformancePackError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::PutOrganizationConformancePackError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutOrganizationConformancePackErrorKind::InsufficientPermissionsException(inner) => Error::InsufficientPermissionsException(inner),
                crate::error::PutOrganizationConformancePackErrorKind::MaxNumberOfOrganizationConformancePacksExceededException(inner) => Error::MaxNumberOfOrganizationConformancePacksExceededException(inner),
                crate::error::PutOrganizationConformancePackErrorKind::NoAvailableOrganizationException(inner) => Error::NoAvailableOrganizationException(inner),
                crate::error::PutOrganizationConformancePackErrorKind::OrganizationAccessDeniedException(inner) => Error::OrganizationAccessDeniedException(inner),
                crate::error::PutOrganizationConformancePackErrorKind::OrganizationAllFeaturesNotEnabledException(inner) => Error::OrganizationAllFeaturesNotEnabledException(inner),
                crate::error::PutOrganizationConformancePackErrorKind::OrganizationConformancePackTemplateValidationException(inner) => Error::OrganizationConformancePackTemplateValidationException(inner),
                crate::error::PutOrganizationConformancePackErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::PutOrganizationConformancePackErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::PutOrganizationConformancePackErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutRemediationConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutRemediationConfigurationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutRemediationConfigurationsErrorKind::InsufficientPermissionsException(inner) => Error::InsufficientPermissionsException(inner),
                crate::error::PutRemediationConfigurationsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::PutRemediationConfigurationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutRemediationExceptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutRemediationExceptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutRemediationExceptionsErrorKind::InsufficientPermissionsException(inner) => Error::InsufficientPermissionsException(inner),
                crate::error::PutRemediationExceptionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::PutRemediationExceptionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutResourceConfigError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutResourceConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutResourceConfigErrorKind::InsufficientPermissionsException(inner) => Error::InsufficientPermissionsException(inner),
                crate::error::PutResourceConfigErrorKind::MaxActiveResourcesExceededException(inner) => Error::MaxActiveResourcesExceededException(inner),
                crate::error::PutResourceConfigErrorKind::NoRunningConfigurationRecorderException(inner) => Error::NoRunningConfigurationRecorderException(inner),
                crate::error::PutResourceConfigErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::PutResourceConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutRetentionConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutRetentionConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutRetentionConfigurationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::PutRetentionConfigurationErrorKind::MaxNumberOfRetentionConfigurationsExceededException(inner) => Error::MaxNumberOfRetentionConfigurationsExceededException(inner),
                crate::error::PutRetentionConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutStoredQueryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutStoredQueryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutStoredQueryErrorKind::ResourceConcurrentModificationException(
                    inner,
                ) => Error::ResourceConcurrentModificationException(inner),
                crate::error::PutStoredQueryErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::PutStoredQueryErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::PutStoredQueryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SelectAggregateResourceConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SelectAggregateResourceConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::SelectAggregateResourceConfigErrorKind::InvalidExpressionException(inner) => Error::InvalidExpressionException(inner),
                crate::error::SelectAggregateResourceConfigErrorKind::InvalidLimitException(inner) => Error::InvalidLimitException(inner),
                crate::error::SelectAggregateResourceConfigErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::SelectAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(inner) => Error::NoSuchConfigurationAggregatorException(inner),
                crate::error::SelectAggregateResourceConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SelectResourceConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SelectResourceConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SelectResourceConfigErrorKind::InvalidExpressionException(inner) => {
                    Error::InvalidExpressionException(inner)
                }
                crate::error::SelectResourceConfigErrorKind::InvalidLimitException(inner) => {
                    Error::InvalidLimitException(inner)
                }
                crate::error::SelectResourceConfigErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::SelectResourceConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartConfigRulesEvaluationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartConfigRulesEvaluationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartConfigRulesEvaluationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::StartConfigRulesEvaluationErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::StartConfigRulesEvaluationErrorKind::NoSuchConfigRuleException(inner) => Error::NoSuchConfigRuleException(inner),
                crate::error::StartConfigRulesEvaluationErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::StartConfigRulesEvaluationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartConfigurationRecorderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartConfigurationRecorderError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartConfigurationRecorderErrorKind::NoAvailableDeliveryChannelException(inner) => Error::NoAvailableDeliveryChannelException(inner),
                crate::error::StartConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(inner) => Error::NoSuchConfigurationRecorderException(inner),
                crate::error::StartConfigurationRecorderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartRemediationExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartRemediationExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartRemediationExecutionErrorKind::InsufficientPermissionsException(inner) => Error::InsufficientPermissionsException(inner),
                crate::error::StartRemediationExecutionErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::StartRemediationExecutionErrorKind::NoSuchRemediationConfigurationException(inner) => Error::NoSuchRemediationConfigurationException(inner),
                crate::error::StartRemediationExecutionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopConfigurationRecorderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopConfigurationRecorderError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(inner) => Error::NoSuchConfigurationRecorderException(inner),
                crate::error::StopConfigurationRecorderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::TagResourceErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
