// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchGetAggregateResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetAggregateResourceConfigError {
    /// Kind of error that occurred.
    pub kind: BatchGetAggregateResourceConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetAggregateResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetAggregateResourceConfigErrorKind {
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetAggregateResourceConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(
                _inner,
            ) => _inner.fmt(f),
            BatchGetAggregateResourceConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchGetAggregateResourceConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetAggregateResourceConfigError {
    fn code(&self) -> Option<&str> {
        BatchGetAggregateResourceConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetAggregateResourceConfigError {
    /// Creates a new `BatchGetAggregateResourceConfigError`.
    pub fn new(
        kind: BatchGetAggregateResourceConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetAggregateResourceConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetAggregateResourceConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetAggregateResourceConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetAggregateResourceConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetAggregateResourceConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetAggregateResourceConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchGetAggregateResourceConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(
                _inner,
            ) => Some(_inner),
            BatchGetAggregateResourceConfigErrorKind::ValidationException(_inner) => Some(_inner),
            BatchGetAggregateResourceConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetResourceConfigError {
    /// Kind of error that occurred.
    pub kind: BatchGetResourceConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetResourceConfigErrorKind {
    /// <p>There are no configuration recorders available to provide the role needed to describe your resources. Create a configuration recorder.</p>
    NoAvailableConfigurationRecorderException(
        crate::error::NoAvailableConfigurationRecorderException,
    ),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetResourceConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetResourceConfigErrorKind::NoAvailableConfigurationRecorderException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetResourceConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchGetResourceConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetResourceConfigError {
    fn code(&self) -> Option<&str> {
        BatchGetResourceConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetResourceConfigError {
    /// Creates a new `BatchGetResourceConfigError`.
    pub fn new(kind: BatchGetResourceConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetResourceConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetResourceConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetResourceConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetResourceConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetResourceConfigErrorKind::NoAvailableConfigurationRecorderException`.
    pub fn is_no_available_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetResourceConfigErrorKind::NoAvailableConfigurationRecorderException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetResourceConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetResourceConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchGetResourceConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetResourceConfigErrorKind::NoAvailableConfigurationRecorderException(_inner) => {
                Some(_inner)
            }
            BatchGetResourceConfigErrorKind::ValidationException(_inner) => Some(_inner),
            BatchGetResourceConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAggregationAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAggregationAuthorizationError {
    /// Kind of error that occurred.
    pub kind: DeleteAggregationAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAggregationAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAggregationAuthorizationErrorKind {
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAggregationAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAggregationAuthorizationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAggregationAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAggregationAuthorizationError {
    fn code(&self) -> Option<&str> {
        DeleteAggregationAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAggregationAuthorizationError {
    /// Creates a new `DeleteAggregationAuthorizationError`.
    pub fn new(
        kind: DeleteAggregationAuthorizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAggregationAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAggregationAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAggregationAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAggregationAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAggregationAuthorizationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAggregationAuthorizationErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for DeleteAggregationAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAggregationAuthorizationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteAggregationAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigRuleErrorKind {
    /// <p>One or more Config rules in the request are invalid. Verify that the rule names are correct and try again.</p>
    NoSuchConfigRuleException(crate::error::NoSuchConfigRuleException),
    /// <p>You see this exception in the following cases: </p>
    /// <ul>
    /// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
    /// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// </ul>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigRuleErrorKind::NoSuchConfigRuleException(_inner) => _inner.fmt(f),
            DeleteConfigRuleErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteConfigRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigRuleError {
    fn code(&self) -> Option<&str> {
        DeleteConfigRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigRuleError {
    /// Creates a new `DeleteConfigRuleError`.
    pub fn new(kind: DeleteConfigRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConfigRuleErrorKind::NoSuchConfigRuleException`.
    pub fn is_no_such_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigRuleErrorKind::NoSuchConfigRuleException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigRuleErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigRuleErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteConfigRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigRuleErrorKind::NoSuchConfigRuleException(_inner) => Some(_inner),
            DeleteConfigRuleErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteConfigRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfigurationAggregator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationAggregatorError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationAggregatorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationAggregator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationAggregatorErrorKind {
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationAggregatorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationAggregatorErrorKind::NoSuchConfigurationAggregatorException(
                _inner,
            ) => _inner.fmt(f),
            DeleteConfigurationAggregatorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationAggregatorError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationAggregatorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigurationAggregatorError {
    /// Creates a new `DeleteConfigurationAggregatorError`.
    pub fn new(
        kind: DeleteConfigurationAggregatorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationAggregatorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationAggregatorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationAggregatorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationAggregatorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConfigurationAggregatorErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationAggregatorErrorKind::NoSuchConfigurationAggregatorException(_)
        )
    }
}
impl std::error::Error for DeleteConfigurationAggregatorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationAggregatorErrorKind::NoSuchConfigurationAggregatorException(
                _inner,
            ) => Some(_inner),
            DeleteConfigurationAggregatorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfigurationRecorder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationRecorderError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationRecorderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationRecorder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationRecorderErrorKind {
    /// <p>You have specified a configuration recorder that does not exist.</p>
    NoSuchConfigurationRecorderException(crate::error::NoSuchConfigurationRecorderException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationRecorderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConfigurationRecorderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationRecorderError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationRecorderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigurationRecorderError {
    /// Creates a new `DeleteConfigurationRecorderError`.
    pub fn new(kind: DeleteConfigurationRecorderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationRecorderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationRecorderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationRecorderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationRecorderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException`.
    pub fn is_no_such_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(_)
        )
    }
}
impl std::error::Error for DeleteConfigurationRecorderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(_inner) => {
                Some(_inner)
            }
            DeleteConfigurationRecorderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConformancePack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConformancePackError {
    /// Kind of error that occurred.
    pub kind: DeleteConformancePackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConformancePack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConformancePackErrorKind {
    /// <p>You specified one or more conformance packs that do not exist.</p>
    NoSuchConformancePackException(crate::error::NoSuchConformancePackException),
    /// <p>You see this exception in the following cases: </p>
    /// <ul>
    /// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
    /// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// </ul>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConformancePackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConformancePackErrorKind::NoSuchConformancePackException(_inner) => _inner.fmt(f),
            DeleteConformancePackErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteConformancePackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConformancePackError {
    fn code(&self) -> Option<&str> {
        DeleteConformancePackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConformancePackError {
    /// Creates a new `DeleteConformancePackError`.
    pub fn new(kind: DeleteConformancePackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConformancePackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConformancePackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConformancePackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConformancePackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConformancePackErrorKind::NoSuchConformancePackException`.
    pub fn is_no_such_conformance_pack_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConformancePackErrorKind::NoSuchConformancePackException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConformancePackErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConformancePackErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteConformancePackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConformancePackErrorKind::NoSuchConformancePackException(_inner) => Some(_inner),
            DeleteConformancePackErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteConformancePackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDeliveryChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDeliveryChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteDeliveryChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDeliveryChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDeliveryChannelErrorKind {
    /// <p>You cannot delete the delivery channel you specified because the configuration recorder is running.</p>
    LastDeliveryChannelDeleteFailedException(
        crate::error::LastDeliveryChannelDeleteFailedException,
    ),
    /// <p>You have specified a delivery channel that does not exist.</p>
    NoSuchDeliveryChannelException(crate::error::NoSuchDeliveryChannelException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDeliveryChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDeliveryChannelErrorKind::LastDeliveryChannelDeleteFailedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteDeliveryChannelErrorKind::NoSuchDeliveryChannelException(_inner) => _inner.fmt(f),
            DeleteDeliveryChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDeliveryChannelError {
    fn code(&self) -> Option<&str> {
        DeleteDeliveryChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDeliveryChannelError {
    /// Creates a new `DeleteDeliveryChannelError`.
    pub fn new(kind: DeleteDeliveryChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDeliveryChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDeliveryChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDeliveryChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDeliveryChannelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDeliveryChannelErrorKind::LastDeliveryChannelDeleteFailedException`.
    pub fn is_last_delivery_channel_delete_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeliveryChannelErrorKind::LastDeliveryChannelDeleteFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeliveryChannelErrorKind::NoSuchDeliveryChannelException`.
    pub fn is_no_such_delivery_channel_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeliveryChannelErrorKind::NoSuchDeliveryChannelException(_)
        )
    }
}
impl std::error::Error for DeleteDeliveryChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDeliveryChannelErrorKind::LastDeliveryChannelDeleteFailedException(_inner) => {
                Some(_inner)
            }
            DeleteDeliveryChannelErrorKind::NoSuchDeliveryChannelException(_inner) => Some(_inner),
            DeleteDeliveryChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEvaluationResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEvaluationResultsError {
    /// Kind of error that occurred.
    pub kind: DeleteEvaluationResultsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEvaluationResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEvaluationResultsErrorKind {
    /// <p>One or more Config rules in the request are invalid. Verify that the rule names are correct and try again.</p>
    NoSuchConfigRuleException(crate::error::NoSuchConfigRuleException),
    /// <p>You see this exception in the following cases: </p>
    /// <ul>
    /// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
    /// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// </ul>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEvaluationResultsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEvaluationResultsErrorKind::NoSuchConfigRuleException(_inner) => _inner.fmt(f),
            DeleteEvaluationResultsErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteEvaluationResultsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEvaluationResultsError {
    fn code(&self) -> Option<&str> {
        DeleteEvaluationResultsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEvaluationResultsError {
    /// Creates a new `DeleteEvaluationResultsError`.
    pub fn new(kind: DeleteEvaluationResultsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEvaluationResultsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEvaluationResultsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEvaluationResultsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEvaluationResultsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEvaluationResultsErrorKind::NoSuchConfigRuleException`.
    pub fn is_no_such_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEvaluationResultsErrorKind::NoSuchConfigRuleException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEvaluationResultsErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEvaluationResultsErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteEvaluationResultsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEvaluationResultsErrorKind::NoSuchConfigRuleException(_inner) => Some(_inner),
            DeleteEvaluationResultsErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteEvaluationResultsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOrganizationConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOrganizationConfigRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteOrganizationConfigRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOrganizationConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOrganizationConfigRuleErrorKind {
    /// <p>You specified one or more organization config rules that do not exist.</p>
    NoSuchOrganizationConfigRuleException(crate::error::NoSuchOrganizationConfigRuleException),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// <p>You see this exception in the following cases: </p>
    /// <ul>
    /// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
    /// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// </ul>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOrganizationConfigRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOrganizationConfigRuleErrorKind::NoSuchOrganizationConfigRuleException(
                _inner,
            ) => _inner.fmt(f),
            DeleteOrganizationConfigRuleErrorKind::OrganizationAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteOrganizationConfigRuleErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteOrganizationConfigRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOrganizationConfigRuleError {
    fn code(&self) -> Option<&str> {
        DeleteOrganizationConfigRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOrganizationConfigRuleError {
    /// Creates a new `DeleteOrganizationConfigRuleError`.
    pub fn new(kind: DeleteOrganizationConfigRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOrganizationConfigRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOrganizationConfigRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOrganizationConfigRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOrganizationConfigRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOrganizationConfigRuleErrorKind::NoSuchOrganizationConfigRuleException`.
    pub fn is_no_such_organization_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationConfigRuleErrorKind::NoSuchOrganizationConfigRuleException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationConfigRuleErrorKind::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationConfigRuleErrorKind::OrganizationAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationConfigRuleErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationConfigRuleErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteOrganizationConfigRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOrganizationConfigRuleErrorKind::NoSuchOrganizationConfigRuleException(
                _inner,
            ) => Some(_inner),
            DeleteOrganizationConfigRuleErrorKind::OrganizationAccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteOrganizationConfigRuleErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteOrganizationConfigRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOrganizationConformancePack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOrganizationConformancePackError {
    /// Kind of error that occurred.
    pub kind: DeleteOrganizationConformancePackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOrganizationConformancePack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOrganizationConformancePackErrorKind {
    /// <p>Config organization conformance pack that you passed in the filter does not exist.</p>
    /// <p>For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not exist.</p>
    NoSuchOrganizationConformancePackException(
        crate::error::NoSuchOrganizationConformancePackException,
    ),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// <p>You see this exception in the following cases: </p>
    /// <ul>
    /// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
    /// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// </ul>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOrganizationConformancePackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOrganizationConformancePackErrorKind::NoSuchOrganizationConformancePackException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteOrganizationConformancePackErrorKind::OrganizationAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteOrganizationConformancePackErrorKind::ResourceInUseException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteOrganizationConformancePackErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOrganizationConformancePackError {
    fn code(&self) -> Option<&str> {
        DeleteOrganizationConformancePackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOrganizationConformancePackError {
    /// Creates a new `DeleteOrganizationConformancePackError`.
    pub fn new(
        kind: DeleteOrganizationConformancePackErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOrganizationConformancePackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOrganizationConformancePackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOrganizationConformancePackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOrganizationConformancePackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOrganizationConformancePackErrorKind::NoSuchOrganizationConformancePackException`.
    pub fn is_no_such_organization_conformance_pack_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationConformancePackErrorKind::NoSuchOrganizationConformancePackException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationConformancePackErrorKind::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationConformancePackErrorKind::OrganizationAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOrganizationConformancePackErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOrganizationConformancePackErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteOrganizationConformancePackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOrganizationConformancePackErrorKind::NoSuchOrganizationConformancePackException(_inner) =>
            Some(_inner)
            ,
            DeleteOrganizationConformancePackErrorKind::OrganizationAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            DeleteOrganizationConformancePackErrorKind::ResourceInUseException(_inner) =>
            Some(_inner)
            ,
            DeleteOrganizationConformancePackErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeletePendingAggregationRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePendingAggregationRequestError {
    /// Kind of error that occurred.
    pub kind: DeletePendingAggregationRequestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePendingAggregationRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePendingAggregationRequestErrorKind {
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePendingAggregationRequestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePendingAggregationRequestErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeletePendingAggregationRequestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePendingAggregationRequestError {
    fn code(&self) -> Option<&str> {
        DeletePendingAggregationRequestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePendingAggregationRequestError {
    /// Creates a new `DeletePendingAggregationRequestError`.
    pub fn new(
        kind: DeletePendingAggregationRequestErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePendingAggregationRequestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePendingAggregationRequestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePendingAggregationRequestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePendingAggregationRequestErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePendingAggregationRequestErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePendingAggregationRequestErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for DeletePendingAggregationRequestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePendingAggregationRequestErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeletePendingAggregationRequestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRemediationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRemediationConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteRemediationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRemediationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRemediationConfigurationErrorKind {
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li>
    /// <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p> </li>
    /// <li> <p>For PutOrganizationConfigRule, organization config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p>
    /// <ul>
    /// <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>To read Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You specified an Config rule without a remediation configuration.</p>
    NoSuchRemediationConfigurationException(crate::error::NoSuchRemediationConfigurationException),
    /// <p>Remediation action is in progress. You can either cancel execution in Amazon Web Services Systems Manager or wait and try again later. </p>
    RemediationInProgressException(crate::error::RemediationInProgressException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRemediationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRemediationConfigurationErrorKind::InsufficientPermissionsException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRemediationConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRemediationConfigurationErrorKind::NoSuchRemediationConfigurationException(
                _inner,
            ) => _inner.fmt(f),
            DeleteRemediationConfigurationErrorKind::RemediationInProgressException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRemediationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRemediationConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteRemediationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRemediationConfigurationError {
    /// Creates a new `DeleteRemediationConfigurationError`.
    pub fn new(
        kind: DeleteRemediationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRemediationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRemediationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRemediationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRemediationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRemediationConfigurationErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRemediationConfigurationErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRemediationConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRemediationConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRemediationConfigurationErrorKind::NoSuchRemediationConfigurationException`.
    pub fn is_no_such_remediation_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRemediationConfigurationErrorKind::NoSuchRemediationConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRemediationConfigurationErrorKind::RemediationInProgressException`.
    pub fn is_remediation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRemediationConfigurationErrorKind::RemediationInProgressException(_)
        )
    }
}
impl std::error::Error for DeleteRemediationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRemediationConfigurationErrorKind::InsufficientPermissionsException(_inner) => {
                Some(_inner)
            }
            DeleteRemediationConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteRemediationConfigurationErrorKind::NoSuchRemediationConfigurationException(
                _inner,
            ) => Some(_inner),
            DeleteRemediationConfigurationErrorKind::RemediationInProgressException(_inner) => {
                Some(_inner)
            }
            DeleteRemediationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRemediationExceptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRemediationExceptionsError {
    /// Kind of error that occurred.
    pub kind: DeleteRemediationExceptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRemediationExceptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRemediationExceptionsErrorKind {
    /// <p>You tried to delete a remediation exception that does not exist.</p>
    NoSuchRemediationExceptionException(crate::error::NoSuchRemediationExceptionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRemediationExceptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRemediationExceptionsErrorKind::NoSuchRemediationExceptionException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRemediationExceptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRemediationExceptionsError {
    fn code(&self) -> Option<&str> {
        DeleteRemediationExceptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRemediationExceptionsError {
    /// Creates a new `DeleteRemediationExceptionsError`.
    pub fn new(kind: DeleteRemediationExceptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRemediationExceptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRemediationExceptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRemediationExceptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRemediationExceptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRemediationExceptionsErrorKind::NoSuchRemediationExceptionException`.
    pub fn is_no_such_remediation_exception_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRemediationExceptionsErrorKind::NoSuchRemediationExceptionException(_)
        )
    }
}
impl std::error::Error for DeleteRemediationExceptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRemediationExceptionsErrorKind::NoSuchRemediationExceptionException(_inner) => {
                Some(_inner)
            }
            DeleteRemediationExceptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourceConfigError {
    /// Kind of error that occurred.
    pub kind: DeleteResourceConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourceConfigErrorKind {
    /// <p>There is no configuration recorder running.</p>
    NoRunningConfigurationRecorderException(crate::error::NoRunningConfigurationRecorderException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourceConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourceConfigErrorKind::NoRunningConfigurationRecorderException(_inner) => {
                _inner.fmt(f)
            }
            DeleteResourceConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteResourceConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourceConfigError {
    fn code(&self) -> Option<&str> {
        DeleteResourceConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourceConfigError {
    /// Creates a new `DeleteResourceConfigError`.
    pub fn new(kind: DeleteResourceConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourceConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourceConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourceConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourceConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourceConfigErrorKind::NoRunningConfigurationRecorderException`.
    pub fn is_no_running_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceConfigErrorKind::NoRunningConfigurationRecorderException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteResourceConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourceConfigErrorKind::NoRunningConfigurationRecorderException(_inner) => {
                Some(_inner)
            }
            DeleteResourceConfigErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteResourceConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRetentionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRetentionConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteRetentionConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRetentionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRetentionConfigurationErrorKind {
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You have specified a retention configuration that does not exist.</p>
    NoSuchRetentionConfigurationException(crate::error::NoSuchRetentionConfigurationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRetentionConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRetentionConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRetentionConfigurationErrorKind::NoSuchRetentionConfigurationException(
                _inner,
            ) => _inner.fmt(f),
            DeleteRetentionConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRetentionConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteRetentionConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRetentionConfigurationError {
    /// Creates a new `DeleteRetentionConfigurationError`.
    pub fn new(kind: DeleteRetentionConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRetentionConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRetentionConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRetentionConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRetentionConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRetentionConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRetentionConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRetentionConfigurationErrorKind::NoSuchRetentionConfigurationException`.
    pub fn is_no_such_retention_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRetentionConfigurationErrorKind::NoSuchRetentionConfigurationException(_)
        )
    }
}
impl std::error::Error for DeleteRetentionConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRetentionConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteRetentionConfigurationErrorKind::NoSuchRetentionConfigurationException(
                _inner,
            ) => Some(_inner),
            DeleteRetentionConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStoredQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStoredQueryError {
    /// Kind of error that occurred.
    pub kind: DeleteStoredQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStoredQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStoredQueryErrorKind {
    /// <p>You have specified a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStoredQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStoredQueryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStoredQueryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteStoredQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStoredQueryError {
    fn code(&self) -> Option<&str> {
        DeleteStoredQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStoredQueryError {
    /// Creates a new `DeleteStoredQueryError`.
    pub fn new(kind: DeleteStoredQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStoredQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStoredQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStoredQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStoredQueryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStoredQueryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStoredQueryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStoredQueryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStoredQueryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteStoredQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStoredQueryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStoredQueryErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteStoredQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeliverConfigSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeliverConfigSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeliverConfigSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeliverConfigSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeliverConfigSnapshotErrorKind {
    /// <p>There are no configuration recorders available to provide the role needed to describe your resources. Create a configuration recorder.</p>
    NoAvailableConfigurationRecorderException(
        crate::error::NoAvailableConfigurationRecorderException,
    ),
    /// <p>There is no configuration recorder running.</p>
    NoRunningConfigurationRecorderException(crate::error::NoRunningConfigurationRecorderException),
    /// <p>You have specified a delivery channel that does not exist.</p>
    NoSuchDeliveryChannelException(crate::error::NoSuchDeliveryChannelException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeliverConfigSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeliverConfigSnapshotErrorKind::NoAvailableConfigurationRecorderException(_inner) => {
                _inner.fmt(f)
            }
            DeliverConfigSnapshotErrorKind::NoRunningConfigurationRecorderException(_inner) => {
                _inner.fmt(f)
            }
            DeliverConfigSnapshotErrorKind::NoSuchDeliveryChannelException(_inner) => _inner.fmt(f),
            DeliverConfigSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeliverConfigSnapshotError {
    fn code(&self) -> Option<&str> {
        DeliverConfigSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeliverConfigSnapshotError {
    /// Creates a new `DeliverConfigSnapshotError`.
    pub fn new(kind: DeliverConfigSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeliverConfigSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeliverConfigSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeliverConfigSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeliverConfigSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeliverConfigSnapshotErrorKind::NoAvailableConfigurationRecorderException`.
    pub fn is_no_available_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeliverConfigSnapshotErrorKind::NoAvailableConfigurationRecorderException(_)
        )
    }
    /// Returns `true` if the error kind is `DeliverConfigSnapshotErrorKind::NoRunningConfigurationRecorderException`.
    pub fn is_no_running_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeliverConfigSnapshotErrorKind::NoRunningConfigurationRecorderException(_)
        )
    }
    /// Returns `true` if the error kind is `DeliverConfigSnapshotErrorKind::NoSuchDeliveryChannelException`.
    pub fn is_no_such_delivery_channel_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeliverConfigSnapshotErrorKind::NoSuchDeliveryChannelException(_)
        )
    }
}
impl std::error::Error for DeliverConfigSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeliverConfigSnapshotErrorKind::NoAvailableConfigurationRecorderException(_inner) => {
                Some(_inner)
            }
            DeliverConfigSnapshotErrorKind::NoRunningConfigurationRecorderException(_inner) => {
                Some(_inner)
            }
            DeliverConfigSnapshotErrorKind::NoSuchDeliveryChannelException(_inner) => Some(_inner),
            DeliverConfigSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAggregateComplianceByConfigRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAggregateComplianceByConfigRulesError {
    /// Kind of error that occurred.
    pub kind: DescribeAggregateComplianceByConfigRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAggregateComplianceByConfigRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAggregateComplianceByConfigRulesErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAggregateComplianceByConfigRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAggregateComplianceByConfigRulesErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeAggregateComplianceByConfigRulesErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeAggregateComplianceByConfigRulesErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeAggregateComplianceByConfigRulesErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeAggregateComplianceByConfigRulesErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAggregateComplianceByConfigRulesError {
    fn code(&self) -> Option<&str> {
        DescribeAggregateComplianceByConfigRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAggregateComplianceByConfigRulesError {
    /// Creates a new `DescribeAggregateComplianceByConfigRulesError`.
    pub fn new(
        kind: DescribeAggregateComplianceByConfigRulesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAggregateComplianceByConfigRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAggregateComplianceByConfigRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAggregateComplianceByConfigRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAggregateComplianceByConfigRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAggregateComplianceByConfigRulesErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAggregateComplianceByConfigRulesErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAggregateComplianceByConfigRulesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAggregateComplianceByConfigRulesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAggregateComplianceByConfigRulesErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(&self.kind, DescribeAggregateComplianceByConfigRulesErrorKind::NoSuchConfigurationAggregatorException(_))
    }
    /// Returns `true` if the error kind is `DescribeAggregateComplianceByConfigRulesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAggregateComplianceByConfigRulesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeAggregateComplianceByConfigRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAggregateComplianceByConfigRulesErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            DescribeAggregateComplianceByConfigRulesErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            DescribeAggregateComplianceByConfigRulesErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            Some(_inner)
            ,
            DescribeAggregateComplianceByConfigRulesErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            DescribeAggregateComplianceByConfigRulesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeAggregateComplianceByConformancePacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAggregateComplianceByConformancePacksError {
    /// Kind of error that occurred.
    pub kind: DescribeAggregateComplianceByConformancePacksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAggregateComplianceByConformancePacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAggregateComplianceByConformancePacksErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAggregateComplianceByConformancePacksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAggregateComplianceByConformancePacksErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeAggregateComplianceByConformancePacksErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeAggregateComplianceByConformancePacksErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeAggregateComplianceByConformancePacksErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeAggregateComplianceByConformancePacksErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeAggregateComplianceByConformancePacksError
{
    fn code(&self) -> Option<&str> {
        DescribeAggregateComplianceByConformancePacksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAggregateComplianceByConformancePacksError {
    /// Creates a new `DescribeAggregateComplianceByConformancePacksError`.
    pub fn new(
        kind: DescribeAggregateComplianceByConformancePacksErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAggregateComplianceByConformancePacksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAggregateComplianceByConformancePacksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAggregateComplianceByConformancePacksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAggregateComplianceByConformancePacksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAggregateComplianceByConformancePacksErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAggregateComplianceByConformancePacksErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAggregateComplianceByConformancePacksErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAggregateComplianceByConformancePacksErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAggregateComplianceByConformancePacksErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(&self.kind, DescribeAggregateComplianceByConformancePacksErrorKind::NoSuchConfigurationAggregatorException(_))
    }
    /// Returns `true` if the error kind is `DescribeAggregateComplianceByConformancePacksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAggregateComplianceByConformancePacksErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeAggregateComplianceByConformancePacksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAggregateComplianceByConformancePacksErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            DescribeAggregateComplianceByConformancePacksErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            DescribeAggregateComplianceByConformancePacksErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            Some(_inner)
            ,
            DescribeAggregateComplianceByConformancePacksErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            DescribeAggregateComplianceByConformancePacksErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeAggregationAuthorizations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAggregationAuthorizationsError {
    /// Kind of error that occurred.
    pub kind: DescribeAggregationAuthorizationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAggregationAuthorizations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAggregationAuthorizationsErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAggregationAuthorizationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAggregationAuthorizationsErrorKind::InvalidLimitException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAggregationAuthorizationsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAggregationAuthorizationsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAggregationAuthorizationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAggregationAuthorizationsError {
    fn code(&self) -> Option<&str> {
        DescribeAggregationAuthorizationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAggregationAuthorizationsError {
    /// Creates a new `DescribeAggregationAuthorizationsError`.
    pub fn new(
        kind: DescribeAggregationAuthorizationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAggregationAuthorizationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAggregationAuthorizationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAggregationAuthorizationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAggregationAuthorizationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAggregationAuthorizationsErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAggregationAuthorizationsErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAggregationAuthorizationsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAggregationAuthorizationsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAggregationAuthorizationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAggregationAuthorizationsErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for DescribeAggregationAuthorizationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAggregationAuthorizationsErrorKind::InvalidLimitException(_inner) => {
                Some(_inner)
            }
            DescribeAggregationAuthorizationsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeAggregationAuthorizationsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeAggregationAuthorizationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeComplianceByConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeComplianceByConfigRuleError {
    /// Kind of error that occurred.
    pub kind: DescribeComplianceByConfigRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeComplianceByConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeComplianceByConfigRuleErrorKind {
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more Config rules in the request are invalid. Verify that the rule names are correct and try again.</p>
    NoSuchConfigRuleException(crate::error::NoSuchConfigRuleException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeComplianceByConfigRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeComplianceByConfigRuleErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeComplianceByConfigRuleErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeComplianceByConfigRuleErrorKind::NoSuchConfigRuleException(_inner) => {
                _inner.fmt(f)
            }
            DescribeComplianceByConfigRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeComplianceByConfigRuleError {
    fn code(&self) -> Option<&str> {
        DescribeComplianceByConfigRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeComplianceByConfigRuleError {
    /// Creates a new `DescribeComplianceByConfigRuleError`.
    pub fn new(
        kind: DescribeComplianceByConfigRuleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeComplianceByConfigRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeComplianceByConfigRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeComplianceByConfigRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeComplianceByConfigRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeComplianceByConfigRuleErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComplianceByConfigRuleErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComplianceByConfigRuleErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComplianceByConfigRuleErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComplianceByConfigRuleErrorKind::NoSuchConfigRuleException`.
    pub fn is_no_such_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComplianceByConfigRuleErrorKind::NoSuchConfigRuleException(_)
        )
    }
}
impl std::error::Error for DescribeComplianceByConfigRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeComplianceByConfigRuleErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeComplianceByConfigRuleErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeComplianceByConfigRuleErrorKind::NoSuchConfigRuleException(_inner) => {
                Some(_inner)
            }
            DescribeComplianceByConfigRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeComplianceByResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeComplianceByResourceError {
    /// Kind of error that occurred.
    pub kind: DescribeComplianceByResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeComplianceByResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeComplianceByResourceErrorKind {
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeComplianceByResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeComplianceByResourceErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeComplianceByResourceErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeComplianceByResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeComplianceByResourceError {
    fn code(&self) -> Option<&str> {
        DescribeComplianceByResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeComplianceByResourceError {
    /// Creates a new `DescribeComplianceByResourceError`.
    pub fn new(kind: DescribeComplianceByResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeComplianceByResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeComplianceByResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeComplianceByResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeComplianceByResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeComplianceByResourceErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComplianceByResourceErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComplianceByResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComplianceByResourceErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for DescribeComplianceByResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeComplianceByResourceErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeComplianceByResourceErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeComplianceByResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConfigRuleEvaluationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigRuleEvaluationStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigRuleEvaluationStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfigRuleEvaluationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigRuleEvaluationStatusErrorKind {
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more Config rules in the request are invalid. Verify that the rule names are correct and try again.</p>
    NoSuchConfigRuleException(crate::error::NoSuchConfigRuleException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigRuleEvaluationStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigRuleEvaluationStatusErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConfigRuleEvaluationStatusErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConfigRuleEvaluationStatusErrorKind::NoSuchConfigRuleException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConfigRuleEvaluationStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConfigRuleEvaluationStatusError {
    fn code(&self) -> Option<&str> {
        DescribeConfigRuleEvaluationStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConfigRuleEvaluationStatusError {
    /// Creates a new `DescribeConfigRuleEvaluationStatusError`.
    pub fn new(
        kind: DescribeConfigRuleEvaluationStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigRuleEvaluationStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigRuleEvaluationStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigRuleEvaluationStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigRuleEvaluationStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConfigRuleEvaluationStatusErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigRuleEvaluationStatusErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigRuleEvaluationStatusErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigRuleEvaluationStatusErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigRuleEvaluationStatusErrorKind::NoSuchConfigRuleException`.
    pub fn is_no_such_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigRuleEvaluationStatusErrorKind::NoSuchConfigRuleException(_)
        )
    }
}
impl std::error::Error for DescribeConfigRuleEvaluationStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigRuleEvaluationStatusErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeConfigRuleEvaluationStatusErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeConfigRuleEvaluationStatusErrorKind::NoSuchConfigRuleException(_inner) => {
                Some(_inner)
            }
            DescribeConfigRuleEvaluationStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConfigRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigRulesError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfigRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigRulesErrorKind {
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more Config rules in the request are invalid. Verify that the rule names are correct and try again.</p>
    NoSuchConfigRuleException(crate::error::NoSuchConfigRuleException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigRulesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeConfigRulesErrorKind::NoSuchConfigRuleException(_inner) => _inner.fmt(f),
            DescribeConfigRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConfigRulesError {
    fn code(&self) -> Option<&str> {
        DescribeConfigRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConfigRulesError {
    /// Creates a new `DescribeConfigRulesError`.
    pub fn new(kind: DescribeConfigRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConfigRulesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigRulesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigRulesErrorKind::NoSuchConfigRuleException`.
    pub fn is_no_such_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigRulesErrorKind::NoSuchConfigRuleException(_)
        )
    }
}
impl std::error::Error for DescribeConfigRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigRulesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeConfigRulesErrorKind::NoSuchConfigRuleException(_inner) => Some(_inner),
            DescribeConfigRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConfigurationAggregators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigurationAggregatorsError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigurationAggregatorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfigurationAggregators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigurationAggregatorsErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigurationAggregatorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigurationAggregatorsErrorKind::InvalidLimitException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConfigurationAggregatorsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConfigurationAggregatorsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConfigurationAggregatorsErrorKind::NoSuchConfigurationAggregatorException(
                _inner,
            ) => _inner.fmt(f),
            DescribeConfigurationAggregatorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConfigurationAggregatorsError {
    fn code(&self) -> Option<&str> {
        DescribeConfigurationAggregatorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConfigurationAggregatorsError {
    /// Creates a new `DescribeConfigurationAggregatorsError`.
    pub fn new(
        kind: DescribeConfigurationAggregatorsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigurationAggregatorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigurationAggregatorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigurationAggregatorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigurationAggregatorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConfigurationAggregatorsErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationAggregatorsErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationAggregatorsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationAggregatorsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationAggregatorsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationAggregatorsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationAggregatorsErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationAggregatorsErrorKind::NoSuchConfigurationAggregatorException(_)
        )
    }
}
impl std::error::Error for DescribeConfigurationAggregatorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigurationAggregatorsErrorKind::InvalidLimitException(_inner) => {
                Some(_inner)
            }
            DescribeConfigurationAggregatorsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeConfigurationAggregatorsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeConfigurationAggregatorsErrorKind::NoSuchConfigurationAggregatorException(
                _inner,
            ) => Some(_inner),
            DescribeConfigurationAggregatorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConfigurationAggregatorSourcesStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigurationAggregatorSourcesStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigurationAggregatorSourcesStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfigurationAggregatorSourcesStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigurationAggregatorSourcesStatusErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigurationAggregatorSourcesStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidParameterValueException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeConfigurationAggregatorSourcesStatusErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeConfigurationAggregatorSourcesStatusErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeConfigurationAggregatorSourcesStatusError
{
    fn code(&self) -> Option<&str> {
        DescribeConfigurationAggregatorSourcesStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConfigurationAggregatorSourcesStatusError {
    /// Creates a new `DescribeConfigurationAggregatorSourcesStatusError`.
    pub fn new(
        kind: DescribeConfigurationAggregatorSourcesStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigurationAggregatorSourcesStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigurationAggregatorSourcesStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigurationAggregatorSourcesStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigurationAggregatorSourcesStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidParameterValueException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DescribeConfigurationAggregatorSourcesStatusErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(&self.kind, DescribeConfigurationAggregatorSourcesStatusErrorKind::NoSuchConfigurationAggregatorException(_))
    }
}
impl std::error::Error for DescribeConfigurationAggregatorSourcesStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            DescribeConfigurationAggregatorSourcesStatusErrorKind::InvalidParameterValueException(_inner) =>
            Some(_inner)
            ,
            DescribeConfigurationAggregatorSourcesStatusErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            Some(_inner)
            ,
            DescribeConfigurationAggregatorSourcesStatusErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeConfigurationRecorders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigurationRecordersError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigurationRecordersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfigurationRecorders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigurationRecordersErrorKind {
    /// <p>You have specified a configuration recorder that does not exist.</p>
    NoSuchConfigurationRecorderException(crate::error::NoSuchConfigurationRecorderException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigurationRecordersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigurationRecordersErrorKind::NoSuchConfigurationRecorderException(
                _inner,
            ) => _inner.fmt(f),
            DescribeConfigurationRecordersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConfigurationRecordersError {
    fn code(&self) -> Option<&str> {
        DescribeConfigurationRecordersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConfigurationRecordersError {
    /// Creates a new `DescribeConfigurationRecordersError`.
    pub fn new(
        kind: DescribeConfigurationRecordersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigurationRecordersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigurationRecordersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigurationRecordersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigurationRecordersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConfigurationRecordersErrorKind::NoSuchConfigurationRecorderException`.
    pub fn is_no_such_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationRecordersErrorKind::NoSuchConfigurationRecorderException(_)
        )
    }
}
impl std::error::Error for DescribeConfigurationRecordersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigurationRecordersErrorKind::NoSuchConfigurationRecorderException(
                _inner,
            ) => Some(_inner),
            DescribeConfigurationRecordersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConfigurationRecorderStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigurationRecorderStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigurationRecorderStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfigurationRecorderStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigurationRecorderStatusErrorKind {
    /// <p>You have specified a configuration recorder that does not exist.</p>
    NoSuchConfigurationRecorderException(crate::error::NoSuchConfigurationRecorderException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigurationRecorderStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigurationRecorderStatusErrorKind::NoSuchConfigurationRecorderException(
                _inner,
            ) => _inner.fmt(f),
            DescribeConfigurationRecorderStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConfigurationRecorderStatusError {
    fn code(&self) -> Option<&str> {
        DescribeConfigurationRecorderStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConfigurationRecorderStatusError {
    /// Creates a new `DescribeConfigurationRecorderStatusError`.
    pub fn new(
        kind: DescribeConfigurationRecorderStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigurationRecorderStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigurationRecorderStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigurationRecorderStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigurationRecorderStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConfigurationRecorderStatusErrorKind::NoSuchConfigurationRecorderException`.
    pub fn is_no_such_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationRecorderStatusErrorKind::NoSuchConfigurationRecorderException(_)
        )
    }
}
impl std::error::Error for DescribeConfigurationRecorderStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigurationRecorderStatusErrorKind::NoSuchConfigurationRecorderException(
                _inner,
            ) => Some(_inner),
            DescribeConfigurationRecorderStatusErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeConformancePackCompliance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConformancePackComplianceError {
    /// Kind of error that occurred.
    pub kind: DescribeConformancePackComplianceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConformancePackCompliance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConformancePackComplianceErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Config rule that you passed in the filter does not exist.</p>
    NoSuchConfigRuleInConformancePackException(
        crate::error::NoSuchConfigRuleInConformancePackException,
    ),
    /// <p>You specified one or more conformance packs that do not exist.</p>
    NoSuchConformancePackException(crate::error::NoSuchConformancePackException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConformancePackComplianceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConformancePackComplianceErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeConformancePackComplianceErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeConformancePackComplianceErrorKind::InvalidParameterValueException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeConformancePackComplianceErrorKind::NoSuchConfigRuleInConformancePackException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeConformancePackComplianceErrorKind::NoSuchConformancePackException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeConformancePackComplianceErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConformancePackComplianceError {
    fn code(&self) -> Option<&str> {
        DescribeConformancePackComplianceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConformancePackComplianceError {
    /// Creates a new `DescribeConformancePackComplianceError`.
    pub fn new(
        kind: DescribeConformancePackComplianceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConformancePackComplianceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConformancePackComplianceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConformancePackComplianceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConformancePackComplianceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConformancePackComplianceErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePackComplianceErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConformancePackComplianceErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePackComplianceErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConformancePackComplianceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePackComplianceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConformancePackComplianceErrorKind::NoSuchConfigRuleInConformancePackException`.
    pub fn is_no_such_config_rule_in_conformance_pack_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePackComplianceErrorKind::NoSuchConfigRuleInConformancePackException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DescribeConformancePackComplianceErrorKind::NoSuchConformancePackException`.
    pub fn is_no_such_conformance_pack_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePackComplianceErrorKind::NoSuchConformancePackException(_)
        )
    }
}
impl std::error::Error for DescribeConformancePackComplianceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConformancePackComplianceErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            DescribeConformancePackComplianceErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            DescribeConformancePackComplianceErrorKind::InvalidParameterValueException(_inner) =>
            Some(_inner)
            ,
            DescribeConformancePackComplianceErrorKind::NoSuchConfigRuleInConformancePackException(_inner) =>
            Some(_inner)
            ,
            DescribeConformancePackComplianceErrorKind::NoSuchConformancePackException(_inner) =>
            Some(_inner)
            ,
            DescribeConformancePackComplianceErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeConformancePacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConformancePacksError {
    /// Kind of error that occurred.
    pub kind: DescribeConformancePacksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConformancePacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConformancePacksErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You specified one or more conformance packs that do not exist.</p>
    NoSuchConformancePackException(crate::error::NoSuchConformancePackException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConformancePacksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConformancePacksErrorKind::InvalidLimitException(_inner) => _inner.fmt(f),
            DescribeConformancePacksErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeConformancePacksErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConformancePacksErrorKind::NoSuchConformancePackException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConformancePacksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConformancePacksError {
    fn code(&self) -> Option<&str> {
        DescribeConformancePacksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConformancePacksError {
    /// Creates a new `DescribeConformancePacksError`.
    pub fn new(kind: DescribeConformancePacksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConformancePacksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConformancePacksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConformancePacksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConformancePacksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConformancePacksErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePacksErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConformancePacksErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePacksErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConformancePacksErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePacksErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConformancePacksErrorKind::NoSuchConformancePackException`.
    pub fn is_no_such_conformance_pack_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePacksErrorKind::NoSuchConformancePackException(_)
        )
    }
}
impl std::error::Error for DescribeConformancePacksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConformancePacksErrorKind::InvalidLimitException(_inner) => Some(_inner),
            DescribeConformancePacksErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeConformancePacksErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeConformancePacksErrorKind::NoSuchConformancePackException(_inner) => {
                Some(_inner)
            }
            DescribeConformancePacksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConformancePackStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConformancePackStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeConformancePackStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConformancePackStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConformancePackStatusErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConformancePackStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConformancePackStatusErrorKind::InvalidLimitException(_inner) => _inner.fmt(f),
            DescribeConformancePackStatusErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConformancePackStatusErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConformancePackStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConformancePackStatusError {
    fn code(&self) -> Option<&str> {
        DescribeConformancePackStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConformancePackStatusError {
    /// Creates a new `DescribeConformancePackStatusError`.
    pub fn new(
        kind: DescribeConformancePackStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConformancePackStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConformancePackStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConformancePackStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConformancePackStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConformancePackStatusErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePackStatusErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConformancePackStatusErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePackStatusErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConformancePackStatusErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConformancePackStatusErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for DescribeConformancePackStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConformancePackStatusErrorKind::InvalidLimitException(_inner) => Some(_inner),
            DescribeConformancePackStatusErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeConformancePackStatusErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeConformancePackStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDeliveryChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDeliveryChannelsError {
    /// Kind of error that occurred.
    pub kind: DescribeDeliveryChannelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDeliveryChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDeliveryChannelsErrorKind {
    /// <p>You have specified a delivery channel that does not exist.</p>
    NoSuchDeliveryChannelException(crate::error::NoSuchDeliveryChannelException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDeliveryChannelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDeliveryChannelsErrorKind::NoSuchDeliveryChannelException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDeliveryChannelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDeliveryChannelsError {
    fn code(&self) -> Option<&str> {
        DescribeDeliveryChannelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDeliveryChannelsError {
    /// Creates a new `DescribeDeliveryChannelsError`.
    pub fn new(kind: DescribeDeliveryChannelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDeliveryChannelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDeliveryChannelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDeliveryChannelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDeliveryChannelsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDeliveryChannelsErrorKind::NoSuchDeliveryChannelException`.
    pub fn is_no_such_delivery_channel_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeliveryChannelsErrorKind::NoSuchDeliveryChannelException(_)
        )
    }
}
impl std::error::Error for DescribeDeliveryChannelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDeliveryChannelsErrorKind::NoSuchDeliveryChannelException(_inner) => {
                Some(_inner)
            }
            DescribeDeliveryChannelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDeliveryChannelStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDeliveryChannelStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeDeliveryChannelStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDeliveryChannelStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDeliveryChannelStatusErrorKind {
    /// <p>You have specified a delivery channel that does not exist.</p>
    NoSuchDeliveryChannelException(crate::error::NoSuchDeliveryChannelException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDeliveryChannelStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDeliveryChannelStatusErrorKind::NoSuchDeliveryChannelException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDeliveryChannelStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDeliveryChannelStatusError {
    fn code(&self) -> Option<&str> {
        DescribeDeliveryChannelStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDeliveryChannelStatusError {
    /// Creates a new `DescribeDeliveryChannelStatusError`.
    pub fn new(
        kind: DescribeDeliveryChannelStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDeliveryChannelStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDeliveryChannelStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDeliveryChannelStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDeliveryChannelStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDeliveryChannelStatusErrorKind::NoSuchDeliveryChannelException`.
    pub fn is_no_such_delivery_channel_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeliveryChannelStatusErrorKind::NoSuchDeliveryChannelException(_)
        )
    }
}
impl std::error::Error for DescribeDeliveryChannelStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDeliveryChannelStatusErrorKind::NoSuchDeliveryChannelException(_inner) => {
                Some(_inner)
            }
            DescribeDeliveryChannelStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrganizationConfigRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrganizationConfigRulesError {
    /// Kind of error that occurred.
    pub kind: DescribeOrganizationConfigRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrganizationConfigRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrganizationConfigRulesErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You specified one or more organization config rules that do not exist.</p>
    NoSuchOrganizationConfigRuleException(crate::error::NoSuchOrganizationConfigRuleException),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrganizationConfigRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrganizationConfigRulesErrorKind::InvalidLimitException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigRulesErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigRulesErrorKind::NoSuchOrganizationConfigRuleException(
                _inner,
            ) => _inner.fmt(f),
            DescribeOrganizationConfigRulesErrorKind::OrganizationAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrganizationConfigRulesError {
    fn code(&self) -> Option<&str> {
        DescribeOrganizationConfigRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrganizationConfigRulesError {
    /// Creates a new `DescribeOrganizationConfigRulesError`.
    pub fn new(
        kind: DescribeOrganizationConfigRulesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrganizationConfigRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrganizationConfigRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrganizationConfigRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrganizationConfigRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigRulesErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigRulesErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigRulesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigRulesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigRulesErrorKind::NoSuchOrganizationConfigRuleException`.
    pub fn is_no_such_organization_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigRulesErrorKind::NoSuchOrganizationConfigRuleException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigRulesErrorKind::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigRulesErrorKind::OrganizationAccessDeniedException(_)
        )
    }
}
impl std::error::Error for DescribeOrganizationConfigRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrganizationConfigRulesErrorKind::InvalidLimitException(_inner) => Some(_inner),
            DescribeOrganizationConfigRulesErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationConfigRulesErrorKind::NoSuchOrganizationConfigRuleException(
                _inner,
            ) => Some(_inner),
            DescribeOrganizationConfigRulesErrorKind::OrganizationAccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationConfigRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrganizationConfigRuleStatuses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrganizationConfigRuleStatusesError {
    /// Kind of error that occurred.
    pub kind: DescribeOrganizationConfigRuleStatusesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrganizationConfigRuleStatuses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrganizationConfigRuleStatusesErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You specified one or more organization config rules that do not exist.</p>
    NoSuchOrganizationConfigRuleException(crate::error::NoSuchOrganizationConfigRuleException),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrganizationConfigRuleStatusesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrganizationConfigRuleStatusesErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConfigRuleStatusesErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConfigRuleStatusesErrorKind::NoSuchOrganizationConfigRuleException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConfigRuleStatusesErrorKind::OrganizationAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConfigRuleStatusesErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrganizationConfigRuleStatusesError {
    fn code(&self) -> Option<&str> {
        DescribeOrganizationConfigRuleStatusesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrganizationConfigRuleStatusesError {
    /// Creates a new `DescribeOrganizationConfigRuleStatusesError`.
    pub fn new(
        kind: DescribeOrganizationConfigRuleStatusesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrganizationConfigRuleStatusesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrganizationConfigRuleStatusesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrganizationConfigRuleStatusesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrganizationConfigRuleStatusesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigRuleStatusesErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigRuleStatusesErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigRuleStatusesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigRuleStatusesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigRuleStatusesErrorKind::NoSuchOrganizationConfigRuleException`.
    pub fn is_no_such_organization_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigRuleStatusesErrorKind::NoSuchOrganizationConfigRuleException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigRuleStatusesErrorKind::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigRuleStatusesErrorKind::OrganizationAccessDeniedException(_)
        )
    }
}
impl std::error::Error for DescribeOrganizationConfigRuleStatusesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrganizationConfigRuleStatusesErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConfigRuleStatusesErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConfigRuleStatusesErrorKind::NoSuchOrganizationConfigRuleException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConfigRuleStatusesErrorKind::OrganizationAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConfigRuleStatusesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeOrganizationConformancePacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrganizationConformancePacksError {
    /// Kind of error that occurred.
    pub kind: DescribeOrganizationConformancePacksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrganizationConformancePacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrganizationConformancePacksErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Config organization conformance pack that you passed in the filter does not exist.</p>
    /// <p>For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not exist.</p>
    NoSuchOrganizationConformancePackException(
        crate::error::NoSuchOrganizationConformancePackException,
    ),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrganizationConformancePacksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrganizationConformancePacksErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConformancePacksErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConformancePacksErrorKind::NoSuchOrganizationConformancePackException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConformancePacksErrorKind::OrganizationAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConformancePacksErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrganizationConformancePacksError {
    fn code(&self) -> Option<&str> {
        DescribeOrganizationConformancePacksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrganizationConformancePacksError {
    /// Creates a new `DescribeOrganizationConformancePacksError`.
    pub fn new(
        kind: DescribeOrganizationConformancePacksErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrganizationConformancePacksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrganizationConformancePacksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrganizationConformancePacksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrganizationConformancePacksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConformancePacksErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConformancePacksErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConformancePacksErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConformancePacksErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConformancePacksErrorKind::NoSuchOrganizationConformancePackException`.
    pub fn is_no_such_organization_conformance_pack_exception(&self) -> bool {
        matches!(&self.kind, DescribeOrganizationConformancePacksErrorKind::NoSuchOrganizationConformancePackException(_))
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConformancePacksErrorKind::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConformancePacksErrorKind::OrganizationAccessDeniedException(_)
        )
    }
}
impl std::error::Error for DescribeOrganizationConformancePacksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrganizationConformancePacksErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConformancePacksErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConformancePacksErrorKind::NoSuchOrganizationConformancePackException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConformancePacksErrorKind::OrganizationAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConformancePacksErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeOrganizationConformancePackStatuses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrganizationConformancePackStatusesError {
    /// Kind of error that occurred.
    pub kind: DescribeOrganizationConformancePackStatusesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrganizationConformancePackStatuses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrganizationConformancePackStatusesErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Config organization conformance pack that you passed in the filter does not exist.</p>
    /// <p>For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not exist.</p>
    NoSuchOrganizationConformancePackException(
        crate::error::NoSuchOrganizationConformancePackException,
    ),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrganizationConformancePackStatusesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrganizationConformancePackStatusesErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConformancePackStatusesErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConformancePackStatusesErrorKind::NoSuchOrganizationConformancePackException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConformancePackStatusesErrorKind::OrganizationAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeOrganizationConformancePackStatusesErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeOrganizationConformancePackStatusesError
{
    fn code(&self) -> Option<&str> {
        DescribeOrganizationConformancePackStatusesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrganizationConformancePackStatusesError {
    /// Creates a new `DescribeOrganizationConformancePackStatusesError`.
    pub fn new(
        kind: DescribeOrganizationConformancePackStatusesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrganizationConformancePackStatusesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrganizationConformancePackStatusesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrganizationConformancePackStatusesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrganizationConformancePackStatusesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConformancePackStatusesErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConformancePackStatusesErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConformancePackStatusesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConformancePackStatusesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConformancePackStatusesErrorKind::NoSuchOrganizationConformancePackException`.
    pub fn is_no_such_organization_conformance_pack_exception(&self) -> bool {
        matches!(&self.kind, DescribeOrganizationConformancePackStatusesErrorKind::NoSuchOrganizationConformancePackException(_))
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConformancePackStatusesErrorKind::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConformancePackStatusesErrorKind::OrganizationAccessDeniedException(
                _
            )
        )
    }
}
impl std::error::Error for DescribeOrganizationConformancePackStatusesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrganizationConformancePackStatusesErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConformancePackStatusesErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConformancePackStatusesErrorKind::NoSuchOrganizationConformancePackException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConformancePackStatusesErrorKind::OrganizationAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            DescribeOrganizationConformancePackStatusesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribePendingAggregationRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePendingAggregationRequestsError {
    /// Kind of error that occurred.
    pub kind: DescribePendingAggregationRequestsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePendingAggregationRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePendingAggregationRequestsErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePendingAggregationRequestsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePendingAggregationRequestsErrorKind::InvalidLimitException(_inner) => {
                _inner.fmt(f)
            }
            DescribePendingAggregationRequestsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribePendingAggregationRequestsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribePendingAggregationRequestsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePendingAggregationRequestsError {
    fn code(&self) -> Option<&str> {
        DescribePendingAggregationRequestsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePendingAggregationRequestsError {
    /// Creates a new `DescribePendingAggregationRequestsError`.
    pub fn new(
        kind: DescribePendingAggregationRequestsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePendingAggregationRequestsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePendingAggregationRequestsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePendingAggregationRequestsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePendingAggregationRequestsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePendingAggregationRequestsErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePendingAggregationRequestsErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePendingAggregationRequestsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePendingAggregationRequestsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePendingAggregationRequestsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePendingAggregationRequestsErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for DescribePendingAggregationRequestsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePendingAggregationRequestsErrorKind::InvalidLimitException(_inner) => {
                Some(_inner)
            }
            DescribePendingAggregationRequestsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribePendingAggregationRequestsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribePendingAggregationRequestsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRemediationConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRemediationConfigurationsError {
    /// Kind of error that occurred.
    pub kind: DescribeRemediationConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRemediationConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRemediationConfigurationsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRemediationConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRemediationConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRemediationConfigurationsError {
    fn code(&self) -> Option<&str> {
        DescribeRemediationConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRemediationConfigurationsError {
    /// Creates a new `DescribeRemediationConfigurationsError`.
    pub fn new(
        kind: DescribeRemediationConfigurationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRemediationConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRemediationConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRemediationConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRemediationConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeRemediationConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRemediationConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRemediationExceptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRemediationExceptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeRemediationExceptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRemediationExceptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRemediationExceptionsErrorKind {
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRemediationExceptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRemediationExceptionsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeRemediationExceptionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeRemediationExceptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRemediationExceptionsError {
    fn code(&self) -> Option<&str> {
        DescribeRemediationExceptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRemediationExceptionsError {
    /// Creates a new `DescribeRemediationExceptionsError`.
    pub fn new(
        kind: DescribeRemediationExceptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRemediationExceptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRemediationExceptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRemediationExceptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRemediationExceptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRemediationExceptionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRemediationExceptionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRemediationExceptionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRemediationExceptionsErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for DescribeRemediationExceptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRemediationExceptionsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeRemediationExceptionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeRemediationExceptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRemediationExecutionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRemediationExecutionStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeRemediationExecutionStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRemediationExecutionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRemediationExecutionStatusErrorKind {
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You specified an Config rule without a remediation configuration.</p>
    NoSuchRemediationConfigurationException(crate::error::NoSuchRemediationConfigurationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRemediationExecutionStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRemediationExecutionStatusErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeRemediationExecutionStatusErrorKind::InvalidParameterValueException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeRemediationExecutionStatusErrorKind::NoSuchRemediationConfigurationException(_inner) =>
            _inner.fmt(f)
            ,
            DescribeRemediationExecutionStatusErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRemediationExecutionStatusError {
    fn code(&self) -> Option<&str> {
        DescribeRemediationExecutionStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRemediationExecutionStatusError {
    /// Creates a new `DescribeRemediationExecutionStatusError`.
    pub fn new(
        kind: DescribeRemediationExecutionStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRemediationExecutionStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRemediationExecutionStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRemediationExecutionStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRemediationExecutionStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRemediationExecutionStatusErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRemediationExecutionStatusErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRemediationExecutionStatusErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRemediationExecutionStatusErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRemediationExecutionStatusErrorKind::NoSuchRemediationConfigurationException`.
    pub fn is_no_such_remediation_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRemediationExecutionStatusErrorKind::NoSuchRemediationConfigurationException(_)
        )
    }
}
impl std::error::Error for DescribeRemediationExecutionStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRemediationExecutionStatusErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            DescribeRemediationExecutionStatusErrorKind::InvalidParameterValueException(_inner) =>
            Some(_inner)
            ,
            DescribeRemediationExecutionStatusErrorKind::NoSuchRemediationConfigurationException(_inner) =>
            Some(_inner)
            ,
            DescribeRemediationExecutionStatusErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeRetentionConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRetentionConfigurationsError {
    /// Kind of error that occurred.
    pub kind: DescribeRetentionConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRetentionConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRetentionConfigurationsErrorKind {
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You have specified a retention configuration that does not exist.</p>
    NoSuchRetentionConfigurationException(crate::error::NoSuchRetentionConfigurationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRetentionConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRetentionConfigurationsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeRetentionConfigurationsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeRetentionConfigurationsErrorKind::NoSuchRetentionConfigurationException(
                _inner,
            ) => _inner.fmt(f),
            DescribeRetentionConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRetentionConfigurationsError {
    fn code(&self) -> Option<&str> {
        DescribeRetentionConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRetentionConfigurationsError {
    /// Creates a new `DescribeRetentionConfigurationsError`.
    pub fn new(
        kind: DescribeRetentionConfigurationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRetentionConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRetentionConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRetentionConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRetentionConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRetentionConfigurationsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRetentionConfigurationsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRetentionConfigurationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRetentionConfigurationsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRetentionConfigurationsErrorKind::NoSuchRetentionConfigurationException`.
    pub fn is_no_such_retention_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRetentionConfigurationsErrorKind::NoSuchRetentionConfigurationException(_)
        )
    }
}
impl std::error::Error for DescribeRetentionConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRetentionConfigurationsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeRetentionConfigurationsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeRetentionConfigurationsErrorKind::NoSuchRetentionConfigurationException(
                _inner,
            ) => Some(_inner),
            DescribeRetentionConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAggregateComplianceDetailsByConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAggregateComplianceDetailsByConfigRuleError {
    /// Kind of error that occurred.
    pub kind: GetAggregateComplianceDetailsByConfigRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAggregateComplianceDetailsByConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAggregateComplianceDetailsByConfigRuleErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAggregateComplianceDetailsByConfigRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAggregateComplianceDetailsByConfigRuleErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateComplianceDetailsByConfigRuleErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateComplianceDetailsByConfigRuleErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateComplianceDetailsByConfigRuleErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateComplianceDetailsByConfigRuleErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAggregateComplianceDetailsByConfigRuleError {
    fn code(&self) -> Option<&str> {
        GetAggregateComplianceDetailsByConfigRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAggregateComplianceDetailsByConfigRuleError {
    /// Creates a new `GetAggregateComplianceDetailsByConfigRuleError`.
    pub fn new(
        kind: GetAggregateComplianceDetailsByConfigRuleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAggregateComplianceDetailsByConfigRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAggregateComplianceDetailsByConfigRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAggregateComplianceDetailsByConfigRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAggregateComplianceDetailsByConfigRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAggregateComplianceDetailsByConfigRuleErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateComplianceDetailsByConfigRuleErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAggregateComplianceDetailsByConfigRuleErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateComplianceDetailsByConfigRuleErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAggregateComplianceDetailsByConfigRuleErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(&self.kind, GetAggregateComplianceDetailsByConfigRuleErrorKind::NoSuchConfigurationAggregatorException(_))
    }
    /// Returns `true` if the error kind is `GetAggregateComplianceDetailsByConfigRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateComplianceDetailsByConfigRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetAggregateComplianceDetailsByConfigRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAggregateComplianceDetailsByConfigRuleErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            GetAggregateComplianceDetailsByConfigRuleErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            GetAggregateComplianceDetailsByConfigRuleErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            Some(_inner)
            ,
            GetAggregateComplianceDetailsByConfigRuleErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            GetAggregateComplianceDetailsByConfigRuleErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetAggregateConfigRuleComplianceSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAggregateConfigRuleComplianceSummaryError {
    /// Kind of error that occurred.
    pub kind: GetAggregateConfigRuleComplianceSummaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAggregateConfigRuleComplianceSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAggregateConfigRuleComplianceSummaryErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAggregateConfigRuleComplianceSummaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAggregateConfigRuleComplianceSummaryErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateConfigRuleComplianceSummaryErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateConfigRuleComplianceSummaryErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateConfigRuleComplianceSummaryErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateConfigRuleComplianceSummaryErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAggregateConfigRuleComplianceSummaryError {
    fn code(&self) -> Option<&str> {
        GetAggregateConfigRuleComplianceSummaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAggregateConfigRuleComplianceSummaryError {
    /// Creates a new `GetAggregateConfigRuleComplianceSummaryError`.
    pub fn new(
        kind: GetAggregateConfigRuleComplianceSummaryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAggregateConfigRuleComplianceSummaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAggregateConfigRuleComplianceSummaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAggregateConfigRuleComplianceSummaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAggregateConfigRuleComplianceSummaryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAggregateConfigRuleComplianceSummaryErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateConfigRuleComplianceSummaryErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAggregateConfigRuleComplianceSummaryErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateConfigRuleComplianceSummaryErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAggregateConfigRuleComplianceSummaryErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(&self.kind, GetAggregateConfigRuleComplianceSummaryErrorKind::NoSuchConfigurationAggregatorException(_))
    }
    /// Returns `true` if the error kind is `GetAggregateConfigRuleComplianceSummaryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateConfigRuleComplianceSummaryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetAggregateConfigRuleComplianceSummaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAggregateConfigRuleComplianceSummaryErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            GetAggregateConfigRuleComplianceSummaryErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            GetAggregateConfigRuleComplianceSummaryErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            Some(_inner)
            ,
            GetAggregateConfigRuleComplianceSummaryErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            GetAggregateConfigRuleComplianceSummaryErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetAggregateConformancePackComplianceSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAggregateConformancePackComplianceSummaryError {
    /// Kind of error that occurred.
    pub kind: GetAggregateConformancePackComplianceSummaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAggregateConformancePackComplianceSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAggregateConformancePackComplianceSummaryErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAggregateConformancePackComplianceSummaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAggregateConformancePackComplianceSummaryErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateConformancePackComplianceSummaryErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateConformancePackComplianceSummaryErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateConformancePackComplianceSummaryErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateConformancePackComplianceSummaryErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for GetAggregateConformancePackComplianceSummaryError
{
    fn code(&self) -> Option<&str> {
        GetAggregateConformancePackComplianceSummaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAggregateConformancePackComplianceSummaryError {
    /// Creates a new `GetAggregateConformancePackComplianceSummaryError`.
    pub fn new(
        kind: GetAggregateConformancePackComplianceSummaryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAggregateConformancePackComplianceSummaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAggregateConformancePackComplianceSummaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAggregateConformancePackComplianceSummaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAggregateConformancePackComplianceSummaryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAggregateConformancePackComplianceSummaryErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateConformancePackComplianceSummaryErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAggregateConformancePackComplianceSummaryErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateConformancePackComplianceSummaryErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAggregateConformancePackComplianceSummaryErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(&self.kind, GetAggregateConformancePackComplianceSummaryErrorKind::NoSuchConfigurationAggregatorException(_))
    }
    /// Returns `true` if the error kind is `GetAggregateConformancePackComplianceSummaryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateConformancePackComplianceSummaryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetAggregateConformancePackComplianceSummaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAggregateConformancePackComplianceSummaryErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            GetAggregateConformancePackComplianceSummaryErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            GetAggregateConformancePackComplianceSummaryErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            Some(_inner)
            ,
            GetAggregateConformancePackComplianceSummaryErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            GetAggregateConformancePackComplianceSummaryErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetAggregateDiscoveredResourceCounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAggregateDiscoveredResourceCountsError {
    /// Kind of error that occurred.
    pub kind: GetAggregateDiscoveredResourceCountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAggregateDiscoveredResourceCounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAggregateDiscoveredResourceCountsErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAggregateDiscoveredResourceCountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAggregateDiscoveredResourceCountsErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateDiscoveredResourceCountsErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateDiscoveredResourceCountsErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateDiscoveredResourceCountsErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            GetAggregateDiscoveredResourceCountsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAggregateDiscoveredResourceCountsError {
    fn code(&self) -> Option<&str> {
        GetAggregateDiscoveredResourceCountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAggregateDiscoveredResourceCountsError {
    /// Creates a new `GetAggregateDiscoveredResourceCountsError`.
    pub fn new(
        kind: GetAggregateDiscoveredResourceCountsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAggregateDiscoveredResourceCountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAggregateDiscoveredResourceCountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAggregateDiscoveredResourceCountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAggregateDiscoveredResourceCountsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAggregateDiscoveredResourceCountsErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateDiscoveredResourceCountsErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAggregateDiscoveredResourceCountsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateDiscoveredResourceCountsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAggregateDiscoveredResourceCountsErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateDiscoveredResourceCountsErrorKind::NoSuchConfigurationAggregatorException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `GetAggregateDiscoveredResourceCountsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateDiscoveredResourceCountsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetAggregateDiscoveredResourceCountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAggregateDiscoveredResourceCountsErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            GetAggregateDiscoveredResourceCountsErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            GetAggregateDiscoveredResourceCountsErrorKind::NoSuchConfigurationAggregatorException(_inner) =>
            Some(_inner)
            ,
            GetAggregateDiscoveredResourceCountsErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            GetAggregateDiscoveredResourceCountsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetAggregateResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAggregateResourceConfigError {
    /// Kind of error that occurred.
    pub kind: GetAggregateResourceConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAggregateResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAggregateResourceConfigErrorKind {
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// <p>The configuration item size is outside the allowable range.</p>
    OversizedConfigurationItemException(crate::error::OversizedConfigurationItemException),
    /// <p>You have specified a resource that is either unknown or has not been discovered.</p>
    ResourceNotDiscoveredException(crate::error::ResourceNotDiscoveredException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAggregateResourceConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(_inner) => {
                _inner.fmt(f)
            }
            GetAggregateResourceConfigErrorKind::OversizedConfigurationItemException(_inner) => {
                _inner.fmt(f)
            }
            GetAggregateResourceConfigErrorKind::ResourceNotDiscoveredException(_inner) => {
                _inner.fmt(f)
            }
            GetAggregateResourceConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAggregateResourceConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAggregateResourceConfigError {
    fn code(&self) -> Option<&str> {
        GetAggregateResourceConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAggregateResourceConfigError {
    /// Creates a new `GetAggregateResourceConfigError`.
    pub fn new(kind: GetAggregateResourceConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAggregateResourceConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAggregateResourceConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAggregateResourceConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAggregateResourceConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAggregateResourceConfigErrorKind::OversizedConfigurationItemException`.
    pub fn is_oversized_configuration_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateResourceConfigErrorKind::OversizedConfigurationItemException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAggregateResourceConfigErrorKind::ResourceNotDiscoveredException`.
    pub fn is_resource_not_discovered_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateResourceConfigErrorKind::ResourceNotDiscoveredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAggregateResourceConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAggregateResourceConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetAggregateResourceConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(_inner) => {
                Some(_inner)
            }
            GetAggregateResourceConfigErrorKind::OversizedConfigurationItemException(_inner) => {
                Some(_inner)
            }
            GetAggregateResourceConfigErrorKind::ResourceNotDiscoveredException(_inner) => {
                Some(_inner)
            }
            GetAggregateResourceConfigErrorKind::ValidationException(_inner) => Some(_inner),
            GetAggregateResourceConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetComplianceDetailsByConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetComplianceDetailsByConfigRuleError {
    /// Kind of error that occurred.
    pub kind: GetComplianceDetailsByConfigRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetComplianceDetailsByConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetComplianceDetailsByConfigRuleErrorKind {
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more Config rules in the request are invalid. Verify that the rule names are correct and try again.</p>
    NoSuchConfigRuleException(crate::error::NoSuchConfigRuleException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetComplianceDetailsByConfigRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetComplianceDetailsByConfigRuleErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetComplianceDetailsByConfigRuleErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetComplianceDetailsByConfigRuleErrorKind::NoSuchConfigRuleException(_inner) => {
                _inner.fmt(f)
            }
            GetComplianceDetailsByConfigRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetComplianceDetailsByConfigRuleError {
    fn code(&self) -> Option<&str> {
        GetComplianceDetailsByConfigRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetComplianceDetailsByConfigRuleError {
    /// Creates a new `GetComplianceDetailsByConfigRuleError`.
    pub fn new(
        kind: GetComplianceDetailsByConfigRuleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetComplianceDetailsByConfigRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetComplianceDetailsByConfigRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetComplianceDetailsByConfigRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetComplianceDetailsByConfigRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetComplianceDetailsByConfigRuleErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComplianceDetailsByConfigRuleErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComplianceDetailsByConfigRuleErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComplianceDetailsByConfigRuleErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComplianceDetailsByConfigRuleErrorKind::NoSuchConfigRuleException`.
    pub fn is_no_such_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComplianceDetailsByConfigRuleErrorKind::NoSuchConfigRuleException(_)
        )
    }
}
impl std::error::Error for GetComplianceDetailsByConfigRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetComplianceDetailsByConfigRuleErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            GetComplianceDetailsByConfigRuleErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetComplianceDetailsByConfigRuleErrorKind::NoSuchConfigRuleException(_inner) => {
                Some(_inner)
            }
            GetComplianceDetailsByConfigRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetComplianceDetailsByResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetComplianceDetailsByResourceError {
    /// Kind of error that occurred.
    pub kind: GetComplianceDetailsByResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetComplianceDetailsByResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetComplianceDetailsByResourceErrorKind {
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetComplianceDetailsByResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetComplianceDetailsByResourceErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetComplianceDetailsByResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetComplianceDetailsByResourceError {
    fn code(&self) -> Option<&str> {
        GetComplianceDetailsByResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetComplianceDetailsByResourceError {
    /// Creates a new `GetComplianceDetailsByResourceError`.
    pub fn new(
        kind: GetComplianceDetailsByResourceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetComplianceDetailsByResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetComplianceDetailsByResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetComplianceDetailsByResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetComplianceDetailsByResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetComplianceDetailsByResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComplianceDetailsByResourceErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for GetComplianceDetailsByResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetComplianceDetailsByResourceErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetComplianceDetailsByResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetComplianceSummaryByConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetComplianceSummaryByConfigRuleError {
    /// Kind of error that occurred.
    pub kind: GetComplianceSummaryByConfigRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetComplianceSummaryByConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetComplianceSummaryByConfigRuleErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetComplianceSummaryByConfigRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetComplianceSummaryByConfigRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetComplianceSummaryByConfigRuleError {
    fn code(&self) -> Option<&str> {
        GetComplianceSummaryByConfigRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetComplianceSummaryByConfigRuleError {
    /// Creates a new `GetComplianceSummaryByConfigRuleError`.
    pub fn new(
        kind: GetComplianceSummaryByConfigRuleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetComplianceSummaryByConfigRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetComplianceSummaryByConfigRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetComplianceSummaryByConfigRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetComplianceSummaryByConfigRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetComplianceSummaryByConfigRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetComplianceSummaryByConfigRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetComplianceSummaryByResourceType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetComplianceSummaryByResourceTypeError {
    /// Kind of error that occurred.
    pub kind: GetComplianceSummaryByResourceTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetComplianceSummaryByResourceType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetComplianceSummaryByResourceTypeErrorKind {
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetComplianceSummaryByResourceTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetComplianceSummaryByResourceTypeErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetComplianceSummaryByResourceTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetComplianceSummaryByResourceTypeError {
    fn code(&self) -> Option<&str> {
        GetComplianceSummaryByResourceTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetComplianceSummaryByResourceTypeError {
    /// Creates a new `GetComplianceSummaryByResourceTypeError`.
    pub fn new(
        kind: GetComplianceSummaryByResourceTypeErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetComplianceSummaryByResourceTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetComplianceSummaryByResourceTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetComplianceSummaryByResourceTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetComplianceSummaryByResourceTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetComplianceSummaryByResourceTypeErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComplianceSummaryByResourceTypeErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for GetComplianceSummaryByResourceTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetComplianceSummaryByResourceTypeErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetComplianceSummaryByResourceTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConformancePackComplianceDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConformancePackComplianceDetailsError {
    /// Kind of error that occurred.
    pub kind: GetConformancePackComplianceDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConformancePackComplianceDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConformancePackComplianceDetailsErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Config rule that you passed in the filter does not exist.</p>
    NoSuchConfigRuleInConformancePackException(
        crate::error::NoSuchConfigRuleInConformancePackException,
    ),
    /// <p>You specified one or more conformance packs that do not exist.</p>
    NoSuchConformancePackException(crate::error::NoSuchConformancePackException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConformancePackComplianceDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConformancePackComplianceDetailsErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            GetConformancePackComplianceDetailsErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            GetConformancePackComplianceDetailsErrorKind::InvalidParameterValueException(_inner) =>
            _inner.fmt(f)
            ,
            GetConformancePackComplianceDetailsErrorKind::NoSuchConfigRuleInConformancePackException(_inner) =>
            _inner.fmt(f)
            ,
            GetConformancePackComplianceDetailsErrorKind::NoSuchConformancePackException(_inner) =>
            _inner.fmt(f)
            ,
            GetConformancePackComplianceDetailsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConformancePackComplianceDetailsError {
    fn code(&self) -> Option<&str> {
        GetConformancePackComplianceDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConformancePackComplianceDetailsError {
    /// Creates a new `GetConformancePackComplianceDetailsError`.
    pub fn new(
        kind: GetConformancePackComplianceDetailsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConformancePackComplianceDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConformancePackComplianceDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConformancePackComplianceDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConformancePackComplianceDetailsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConformancePackComplianceDetailsErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConformancePackComplianceDetailsErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConformancePackComplianceDetailsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConformancePackComplianceDetailsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConformancePackComplianceDetailsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConformancePackComplianceDetailsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConformancePackComplianceDetailsErrorKind::NoSuchConfigRuleInConformancePackException`.
    pub fn is_no_such_config_rule_in_conformance_pack_exception(&self) -> bool {
        matches!(&self.kind, GetConformancePackComplianceDetailsErrorKind::NoSuchConfigRuleInConformancePackException(_))
    }
    /// Returns `true` if the error kind is `GetConformancePackComplianceDetailsErrorKind::NoSuchConformancePackException`.
    pub fn is_no_such_conformance_pack_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConformancePackComplianceDetailsErrorKind::NoSuchConformancePackException(_)
        )
    }
}
impl std::error::Error for GetConformancePackComplianceDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConformancePackComplianceDetailsErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            GetConformancePackComplianceDetailsErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            GetConformancePackComplianceDetailsErrorKind::InvalidParameterValueException(_inner) =>
            Some(_inner)
            ,
            GetConformancePackComplianceDetailsErrorKind::NoSuchConfigRuleInConformancePackException(_inner) =>
            Some(_inner)
            ,
            GetConformancePackComplianceDetailsErrorKind::NoSuchConformancePackException(_inner) =>
            Some(_inner)
            ,
            GetConformancePackComplianceDetailsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetConformancePackComplianceSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConformancePackComplianceSummaryError {
    /// Kind of error that occurred.
    pub kind: GetConformancePackComplianceSummaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConformancePackComplianceSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConformancePackComplianceSummaryErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You specified one or more conformance packs that do not exist.</p>
    NoSuchConformancePackException(crate::error::NoSuchConformancePackException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConformancePackComplianceSummaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConformancePackComplianceSummaryErrorKind::InvalidLimitException(_inner) => {
                _inner.fmt(f)
            }
            GetConformancePackComplianceSummaryErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetConformancePackComplianceSummaryErrorKind::NoSuchConformancePackException(
                _inner,
            ) => _inner.fmt(f),
            GetConformancePackComplianceSummaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConformancePackComplianceSummaryError {
    fn code(&self) -> Option<&str> {
        GetConformancePackComplianceSummaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConformancePackComplianceSummaryError {
    /// Creates a new `GetConformancePackComplianceSummaryError`.
    pub fn new(
        kind: GetConformancePackComplianceSummaryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConformancePackComplianceSummaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConformancePackComplianceSummaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConformancePackComplianceSummaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConformancePackComplianceSummaryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConformancePackComplianceSummaryErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConformancePackComplianceSummaryErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConformancePackComplianceSummaryErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConformancePackComplianceSummaryErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConformancePackComplianceSummaryErrorKind::NoSuchConformancePackException`.
    pub fn is_no_such_conformance_pack_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConformancePackComplianceSummaryErrorKind::NoSuchConformancePackException(_)
        )
    }
}
impl std::error::Error for GetConformancePackComplianceSummaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConformancePackComplianceSummaryErrorKind::InvalidLimitException(_inner) => {
                Some(_inner)
            }
            GetConformancePackComplianceSummaryErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            GetConformancePackComplianceSummaryErrorKind::NoSuchConformancePackException(
                _inner,
            ) => Some(_inner),
            GetConformancePackComplianceSummaryErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetDiscoveredResourceCounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDiscoveredResourceCountsError {
    /// Kind of error that occurred.
    pub kind: GetDiscoveredResourceCountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDiscoveredResourceCounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDiscoveredResourceCountsErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDiscoveredResourceCountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDiscoveredResourceCountsErrorKind::InvalidLimitException(_inner) => _inner.fmt(f),
            GetDiscoveredResourceCountsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetDiscoveredResourceCountsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDiscoveredResourceCountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDiscoveredResourceCountsError {
    fn code(&self) -> Option<&str> {
        GetDiscoveredResourceCountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDiscoveredResourceCountsError {
    /// Creates a new `GetDiscoveredResourceCountsError`.
    pub fn new(kind: GetDiscoveredResourceCountsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDiscoveredResourceCountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDiscoveredResourceCountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDiscoveredResourceCountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDiscoveredResourceCountsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDiscoveredResourceCountsErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiscoveredResourceCountsErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDiscoveredResourceCountsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiscoveredResourceCountsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDiscoveredResourceCountsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiscoveredResourceCountsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetDiscoveredResourceCountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDiscoveredResourceCountsErrorKind::InvalidLimitException(_inner) => Some(_inner),
            GetDiscoveredResourceCountsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetDiscoveredResourceCountsErrorKind::ValidationException(_inner) => Some(_inner),
            GetDiscoveredResourceCountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOrganizationConfigRuleDetailedStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOrganizationConfigRuleDetailedStatusError {
    /// Kind of error that occurred.
    pub kind: GetOrganizationConfigRuleDetailedStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOrganizationConfigRuleDetailedStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOrganizationConfigRuleDetailedStatusErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You specified one or more organization config rules that do not exist.</p>
    NoSuchOrganizationConfigRuleException(crate::error::NoSuchOrganizationConfigRuleException),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOrganizationConfigRuleDetailedStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOrganizationConfigRuleDetailedStatusErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            GetOrganizationConfigRuleDetailedStatusErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            GetOrganizationConfigRuleDetailedStatusErrorKind::NoSuchOrganizationConfigRuleException(_inner) =>
            _inner.fmt(f)
            ,
            GetOrganizationConfigRuleDetailedStatusErrorKind::OrganizationAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            GetOrganizationConfigRuleDetailedStatusErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOrganizationConfigRuleDetailedStatusError {
    fn code(&self) -> Option<&str> {
        GetOrganizationConfigRuleDetailedStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOrganizationConfigRuleDetailedStatusError {
    /// Creates a new `GetOrganizationConfigRuleDetailedStatusError`.
    pub fn new(
        kind: GetOrganizationConfigRuleDetailedStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOrganizationConfigRuleDetailedStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOrganizationConfigRuleDetailedStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOrganizationConfigRuleDetailedStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOrganizationConfigRuleDetailedStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOrganizationConfigRuleDetailedStatusErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOrganizationConfigRuleDetailedStatusErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOrganizationConfigRuleDetailedStatusErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOrganizationConfigRuleDetailedStatusErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOrganizationConfigRuleDetailedStatusErrorKind::NoSuchOrganizationConfigRuleException`.
    pub fn is_no_such_organization_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOrganizationConfigRuleDetailedStatusErrorKind::NoSuchOrganizationConfigRuleException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `GetOrganizationConfigRuleDetailedStatusErrorKind::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOrganizationConfigRuleDetailedStatusErrorKind::OrganizationAccessDeniedException(_)
        )
    }
}
impl std::error::Error for GetOrganizationConfigRuleDetailedStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOrganizationConfigRuleDetailedStatusErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            GetOrganizationConfigRuleDetailedStatusErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            GetOrganizationConfigRuleDetailedStatusErrorKind::NoSuchOrganizationConfigRuleException(_inner) =>
            Some(_inner)
            ,
            GetOrganizationConfigRuleDetailedStatusErrorKind::OrganizationAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            GetOrganizationConfigRuleDetailedStatusErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetOrganizationConformancePackDetailedStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOrganizationConformancePackDetailedStatusError {
    /// Kind of error that occurred.
    pub kind: GetOrganizationConformancePackDetailedStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOrganizationConformancePackDetailedStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOrganizationConformancePackDetailedStatusErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Config organization conformance pack that you passed in the filter does not exist.</p>
    /// <p>For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not exist.</p>
    NoSuchOrganizationConformancePackException(
        crate::error::NoSuchOrganizationConformancePackException,
    ),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOrganizationConformancePackDetailedStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOrganizationConformancePackDetailedStatusErrorKind::InvalidLimitException(_inner) =>
            _inner.fmt(f)
            ,
            GetOrganizationConformancePackDetailedStatusErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            GetOrganizationConformancePackDetailedStatusErrorKind::NoSuchOrganizationConformancePackException(_inner) =>
            _inner.fmt(f)
            ,
            GetOrganizationConformancePackDetailedStatusErrorKind::OrganizationAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            GetOrganizationConformancePackDetailedStatusErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for GetOrganizationConformancePackDetailedStatusError
{
    fn code(&self) -> Option<&str> {
        GetOrganizationConformancePackDetailedStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOrganizationConformancePackDetailedStatusError {
    /// Creates a new `GetOrganizationConformancePackDetailedStatusError`.
    pub fn new(
        kind: GetOrganizationConformancePackDetailedStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOrganizationConformancePackDetailedStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOrganizationConformancePackDetailedStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOrganizationConformancePackDetailedStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOrganizationConformancePackDetailedStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOrganizationConformancePackDetailedStatusErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOrganizationConformancePackDetailedStatusErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOrganizationConformancePackDetailedStatusErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOrganizationConformancePackDetailedStatusErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOrganizationConformancePackDetailedStatusErrorKind::NoSuchOrganizationConformancePackException`.
    pub fn is_no_such_organization_conformance_pack_exception(&self) -> bool {
        matches!(&self.kind, GetOrganizationConformancePackDetailedStatusErrorKind::NoSuchOrganizationConformancePackException(_))
    }
    /// Returns `true` if the error kind is `GetOrganizationConformancePackDetailedStatusErrorKind::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetOrganizationConformancePackDetailedStatusErrorKind::OrganizationAccessDeniedException(_))
    }
}
impl std::error::Error for GetOrganizationConformancePackDetailedStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOrganizationConformancePackDetailedStatusErrorKind::InvalidLimitException(_inner) =>
            Some(_inner)
            ,
            GetOrganizationConformancePackDetailedStatusErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            GetOrganizationConformancePackDetailedStatusErrorKind::NoSuchOrganizationConformancePackException(_inner) =>
            Some(_inner)
            ,
            GetOrganizationConformancePackDetailedStatusErrorKind::OrganizationAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            GetOrganizationConformancePackDetailedStatusErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetResourceConfigHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceConfigHistoryError {
    /// Kind of error that occurred.
    pub kind: GetResourceConfigHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourceConfigHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceConfigHistoryErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The specified time range is not valid. The earlier time is not chronologically before the later time.</p>
    InvalidTimeRangeException(crate::error::InvalidTimeRangeException),
    /// <p>There are no configuration recorders available to provide the role needed to describe your resources. Create a configuration recorder.</p>
    NoAvailableConfigurationRecorderException(
        crate::error::NoAvailableConfigurationRecorderException,
    ),
    /// <p>You have specified a resource that is either unknown or has not been discovered.</p>
    ResourceNotDiscoveredException(crate::error::ResourceNotDiscoveredException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceConfigHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceConfigHistoryErrorKind::InvalidLimitException(_inner) => _inner.fmt(f),
            GetResourceConfigHistoryErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetResourceConfigHistoryErrorKind::InvalidTimeRangeException(_inner) => _inner.fmt(f),
            GetResourceConfigHistoryErrorKind::NoAvailableConfigurationRecorderException(
                _inner,
            ) => _inner.fmt(f),
            GetResourceConfigHistoryErrorKind::ResourceNotDiscoveredException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceConfigHistoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetResourceConfigHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceConfigHistoryError {
    fn code(&self) -> Option<&str> {
        GetResourceConfigHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceConfigHistoryError {
    /// Creates a new `GetResourceConfigHistoryError`.
    pub fn new(kind: GetResourceConfigHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceConfigHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceConfigHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceConfigHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceConfigHistoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourceConfigHistoryErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceConfigHistoryErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceConfigHistoryErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceConfigHistoryErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceConfigHistoryErrorKind::InvalidTimeRangeException`.
    pub fn is_invalid_time_range_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceConfigHistoryErrorKind::InvalidTimeRangeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceConfigHistoryErrorKind::NoAvailableConfigurationRecorderException`.
    pub fn is_no_available_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceConfigHistoryErrorKind::NoAvailableConfigurationRecorderException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceConfigHistoryErrorKind::ResourceNotDiscoveredException`.
    pub fn is_resource_not_discovered_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceConfigHistoryErrorKind::ResourceNotDiscoveredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceConfigHistoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceConfigHistoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetResourceConfigHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceConfigHistoryErrorKind::InvalidLimitException(_inner) => Some(_inner),
            GetResourceConfigHistoryErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetResourceConfigHistoryErrorKind::InvalidTimeRangeException(_inner) => Some(_inner),
            GetResourceConfigHistoryErrorKind::NoAvailableConfigurationRecorderException(
                _inner,
            ) => Some(_inner),
            GetResourceConfigHistoryErrorKind::ResourceNotDiscoveredException(_inner) => {
                Some(_inner)
            }
            GetResourceConfigHistoryErrorKind::ValidationException(_inner) => Some(_inner),
            GetResourceConfigHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStoredQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStoredQueryError {
    /// Kind of error that occurred.
    pub kind: GetStoredQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStoredQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStoredQueryErrorKind {
    /// <p>You have specified a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStoredQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStoredQueryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStoredQueryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStoredQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStoredQueryError {
    fn code(&self) -> Option<&str> {
        GetStoredQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStoredQueryError {
    /// Creates a new `GetStoredQueryError`.
    pub fn new(kind: GetStoredQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStoredQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStoredQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStoredQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStoredQueryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetStoredQueryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStoredQueryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStoredQueryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetStoredQueryErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetStoredQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStoredQueryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStoredQueryErrorKind::ValidationException(_inner) => Some(_inner),
            GetStoredQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAggregateDiscoveredResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAggregateDiscoveredResourcesError {
    /// Kind of error that occurred.
    pub kind: ListAggregateDiscoveredResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAggregateDiscoveredResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAggregateDiscoveredResourcesErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAggregateDiscoveredResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAggregateDiscoveredResourcesErrorKind::InvalidLimitException(_inner) => {
                _inner.fmt(f)
            }
            ListAggregateDiscoveredResourcesErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            ListAggregateDiscoveredResourcesErrorKind::NoSuchConfigurationAggregatorException(
                _inner,
            ) => _inner.fmt(f),
            ListAggregateDiscoveredResourcesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAggregateDiscoveredResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAggregateDiscoveredResourcesError {
    fn code(&self) -> Option<&str> {
        ListAggregateDiscoveredResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAggregateDiscoveredResourcesError {
    /// Creates a new `ListAggregateDiscoveredResourcesError`.
    pub fn new(
        kind: ListAggregateDiscoveredResourcesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAggregateDiscoveredResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAggregateDiscoveredResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAggregateDiscoveredResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAggregateDiscoveredResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAggregateDiscoveredResourcesErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAggregateDiscoveredResourcesErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAggregateDiscoveredResourcesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAggregateDiscoveredResourcesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAggregateDiscoveredResourcesErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAggregateDiscoveredResourcesErrorKind::NoSuchConfigurationAggregatorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAggregateDiscoveredResourcesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAggregateDiscoveredResourcesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAggregateDiscoveredResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAggregateDiscoveredResourcesErrorKind::InvalidLimitException(_inner) => {
                Some(_inner)
            }
            ListAggregateDiscoveredResourcesErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            ListAggregateDiscoveredResourcesErrorKind::NoSuchConfigurationAggregatorException(
                _inner,
            ) => Some(_inner),
            ListAggregateDiscoveredResourcesErrorKind::ValidationException(_inner) => Some(_inner),
            ListAggregateDiscoveredResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDiscoveredResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDiscoveredResourcesError {
    /// Kind of error that occurred.
    pub kind: ListDiscoveredResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDiscoveredResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDiscoveredResourcesErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>There are no configuration recorders available to provide the role needed to describe your resources. Create a configuration recorder.</p>
    NoAvailableConfigurationRecorderException(
        crate::error::NoAvailableConfigurationRecorderException,
    ),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDiscoveredResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDiscoveredResourcesErrorKind::InvalidLimitException(_inner) => _inner.fmt(f),
            ListDiscoveredResourcesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDiscoveredResourcesErrorKind::NoAvailableConfigurationRecorderException(_inner) => {
                _inner.fmt(f)
            }
            ListDiscoveredResourcesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDiscoveredResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDiscoveredResourcesError {
    fn code(&self) -> Option<&str> {
        ListDiscoveredResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDiscoveredResourcesError {
    /// Creates a new `ListDiscoveredResourcesError`.
    pub fn new(kind: ListDiscoveredResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDiscoveredResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDiscoveredResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDiscoveredResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDiscoveredResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDiscoveredResourcesErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoveredResourcesErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDiscoveredResourcesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoveredResourcesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDiscoveredResourcesErrorKind::NoAvailableConfigurationRecorderException`.
    pub fn is_no_available_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoveredResourcesErrorKind::NoAvailableConfigurationRecorderException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDiscoveredResourcesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoveredResourcesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListDiscoveredResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDiscoveredResourcesErrorKind::InvalidLimitException(_inner) => Some(_inner),
            ListDiscoveredResourcesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDiscoveredResourcesErrorKind::NoAvailableConfigurationRecorderException(_inner) => {
                Some(_inner)
            }
            ListDiscoveredResourcesErrorKind::ValidationException(_inner) => Some(_inner),
            ListDiscoveredResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStoredQueries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStoredQueriesError {
    /// Kind of error that occurred.
    pub kind: ListStoredQueriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStoredQueries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStoredQueriesErrorKind {
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStoredQueriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStoredQueriesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListStoredQueriesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListStoredQueriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStoredQueriesError {
    fn code(&self) -> Option<&str> {
        ListStoredQueriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStoredQueriesError {
    /// Creates a new `ListStoredQueriesError`.
    pub fn new(kind: ListStoredQueriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStoredQueriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStoredQueriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStoredQueriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStoredQueriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStoredQueriesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStoredQueriesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStoredQueriesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStoredQueriesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListStoredQueriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStoredQueriesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListStoredQueriesErrorKind::ValidationException(_inner) => Some(_inner),
            ListStoredQueriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You have specified a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidLimitException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidLimitException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAggregationAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAggregationAuthorizationError {
    /// Kind of error that occurred.
    pub kind: PutAggregationAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAggregationAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAggregationAuthorizationErrorKind {
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAggregationAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAggregationAuthorizationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutAggregationAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAggregationAuthorizationError {
    fn code(&self) -> Option<&str> {
        PutAggregationAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAggregationAuthorizationError {
    /// Creates a new `PutAggregationAuthorizationError`.
    pub fn new(kind: PutAggregationAuthorizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAggregationAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAggregationAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAggregationAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAggregationAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAggregationAuthorizationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAggregationAuthorizationErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for PutAggregationAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAggregationAuthorizationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            PutAggregationAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutConfigRuleError {
    /// Kind of error that occurred.
    pub kind: PutConfigRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutConfigRuleErrorKind {
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li>
    /// <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p> </li>
    /// <li> <p>For PutOrganizationConfigRule, organization config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p>
    /// <ul>
    /// <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>To read Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Failed to add the Config rule because the account already contains the maximum number of 150 rules. Consider deleting any deactivated rules before you add new rules.</p>
    MaxNumberOfConfigRulesExceededException(crate::error::MaxNumberOfConfigRulesExceededException),
    /// <p>There are no configuration recorders available to provide the role needed to describe your resources. Create a configuration recorder.</p>
    NoAvailableConfigurationRecorderException(
        crate::error::NoAvailableConfigurationRecorderException,
    ),
    /// <p>You see this exception in the following cases: </p>
    /// <ul>
    /// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
    /// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// </ul>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutConfigRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutConfigRuleErrorKind::InsufficientPermissionsException(_inner) => _inner.fmt(f),
            PutConfigRuleErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            PutConfigRuleErrorKind::MaxNumberOfConfigRulesExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigRuleErrorKind::NoAvailableConfigurationRecorderException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigRuleErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            PutConfigRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutConfigRuleError {
    fn code(&self) -> Option<&str> {
        PutConfigRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutConfigRuleError {
    /// Creates a new `PutConfigRuleError`.
    pub fn new(kind: PutConfigRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutConfigRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutConfigRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutConfigRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutConfigRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutConfigRuleErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigRuleErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigRuleErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigRuleErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigRuleErrorKind::MaxNumberOfConfigRulesExceededException`.
    pub fn is_max_number_of_config_rules_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigRuleErrorKind::MaxNumberOfConfigRulesExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigRuleErrorKind::NoAvailableConfigurationRecorderException`.
    pub fn is_no_available_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigRuleErrorKind::NoAvailableConfigurationRecorderException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigRuleErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigRuleErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for PutConfigRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutConfigRuleErrorKind::InsufficientPermissionsException(_inner) => Some(_inner),
            PutConfigRuleErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PutConfigRuleErrorKind::MaxNumberOfConfigRulesExceededException(_inner) => Some(_inner),
            PutConfigRuleErrorKind::NoAvailableConfigurationRecorderException(_inner) => {
                Some(_inner)
            }
            PutConfigRuleErrorKind::ResourceInUseException(_inner) => Some(_inner),
            PutConfigRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutConfigurationAggregator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutConfigurationAggregatorError {
    /// Kind of error that occurred.
    pub kind: PutConfigurationAggregatorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutConfigurationAggregator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutConfigurationAggregatorErrorKind {
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You have provided a null or empty role ARN.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if an evaluation is in progress or if you call the <code>StartConfigRulesEvaluation</code> API more than once per minute.</p>
    /// <p>For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and aggregators exceeds the limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Organization is no longer available.</p>
    NoAvailableOrganizationException(crate::error::NoAvailableOrganizationException),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// <p>Config resource cannot be created because your organization does not have all features enabled.</p>
    OrganizationAllFeaturesNotEnabledException(
        crate::error::OrganizationAllFeaturesNotEnabledException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutConfigurationAggregatorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutConfigurationAggregatorErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationAggregatorErrorKind::InvalidRoleException(_inner) => _inner.fmt(f),
            PutConfigurationAggregatorErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutConfigurationAggregatorErrorKind::NoAvailableOrganizationException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationAggregatorErrorKind::OrganizationAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            PutConfigurationAggregatorErrorKind::OrganizationAllFeaturesNotEnabledException(
                _inner,
            ) => _inner.fmt(f),
            PutConfigurationAggregatorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutConfigurationAggregatorError {
    fn code(&self) -> Option<&str> {
        PutConfigurationAggregatorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutConfigurationAggregatorError {
    /// Creates a new `PutConfigurationAggregatorError`.
    pub fn new(kind: PutConfigurationAggregatorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutConfigurationAggregatorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutConfigurationAggregatorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutConfigurationAggregatorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutConfigurationAggregatorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutConfigurationAggregatorErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationAggregatorErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationAggregatorErrorKind::InvalidRoleException`.
    pub fn is_invalid_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationAggregatorErrorKind::InvalidRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationAggregatorErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationAggregatorErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationAggregatorErrorKind::NoAvailableOrganizationException`.
    pub fn is_no_available_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationAggregatorErrorKind::NoAvailableOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationAggregatorErrorKind::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationAggregatorErrorKind::OrganizationAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationAggregatorErrorKind::OrganizationAllFeaturesNotEnabledException`.
    pub fn is_organization_all_features_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationAggregatorErrorKind::OrganizationAllFeaturesNotEnabledException(_)
        )
    }
}
impl std::error::Error for PutConfigurationAggregatorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutConfigurationAggregatorErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            PutConfigurationAggregatorErrorKind::InvalidRoleException(_inner) => Some(_inner),
            PutConfigurationAggregatorErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutConfigurationAggregatorErrorKind::NoAvailableOrganizationException(_inner) => {
                Some(_inner)
            }
            PutConfigurationAggregatorErrorKind::OrganizationAccessDeniedException(_inner) => {
                Some(_inner)
            }
            PutConfigurationAggregatorErrorKind::OrganizationAllFeaturesNotEnabledException(
                _inner,
            ) => Some(_inner),
            PutConfigurationAggregatorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutConfigurationRecorder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutConfigurationRecorderError {
    /// Kind of error that occurred.
    pub kind: PutConfigurationRecorderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutConfigurationRecorder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutConfigurationRecorderErrorKind {
    /// <p>You have provided a configuration recorder name that is not valid.</p>
    InvalidConfigurationRecorderNameException(
        crate::error::InvalidConfigurationRecorderNameException,
    ),
    /// <p>Config throws an exception if the recording group does not contain a valid list of resource types. Invalid values might also be incorrectly formatted.</p>
    InvalidRecordingGroupException(crate::error::InvalidRecordingGroupException),
    /// <p>You have provided a null or empty role ARN.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>You have reached the limit of the number of recorders you can create.</p>
    MaxNumberOfConfigurationRecordersExceededException(
        crate::error::MaxNumberOfConfigurationRecordersExceededException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutConfigurationRecorderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutConfigurationRecorderErrorKind::InvalidConfigurationRecorderNameException(_inner) =>
            _inner.fmt(f)
            ,
            PutConfigurationRecorderErrorKind::InvalidRecordingGroupException(_inner) =>
            _inner.fmt(f)
            ,
            PutConfigurationRecorderErrorKind::InvalidRoleException(_inner) =>
            _inner.fmt(f)
            ,
            PutConfigurationRecorderErrorKind::MaxNumberOfConfigurationRecordersExceededException(_inner) =>
            _inner.fmt(f)
            ,
            PutConfigurationRecorderErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutConfigurationRecorderError {
    fn code(&self) -> Option<&str> {
        PutConfigurationRecorderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutConfigurationRecorderError {
    /// Creates a new `PutConfigurationRecorderError`.
    pub fn new(kind: PutConfigurationRecorderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutConfigurationRecorderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutConfigurationRecorderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutConfigurationRecorderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutConfigurationRecorderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutConfigurationRecorderErrorKind::InvalidConfigurationRecorderNameException`.
    pub fn is_invalid_configuration_recorder_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationRecorderErrorKind::InvalidConfigurationRecorderNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationRecorderErrorKind::InvalidRecordingGroupException`.
    pub fn is_invalid_recording_group_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationRecorderErrorKind::InvalidRecordingGroupException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationRecorderErrorKind::InvalidRoleException`.
    pub fn is_invalid_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationRecorderErrorKind::InvalidRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConfigurationRecorderErrorKind::MaxNumberOfConfigurationRecordersExceededException`.
    pub fn is_max_number_of_configuration_recorders_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationRecorderErrorKind::MaxNumberOfConfigurationRecordersExceededException(
                _
            )
        )
    }
}
impl std::error::Error for PutConfigurationRecorderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutConfigurationRecorderErrorKind::InvalidConfigurationRecorderNameException(_inner) =>
            Some(_inner)
            ,
            PutConfigurationRecorderErrorKind::InvalidRecordingGroupException(_inner) =>
            Some(_inner)
            ,
            PutConfigurationRecorderErrorKind::InvalidRoleException(_inner) =>
            Some(_inner)
            ,
            PutConfigurationRecorderErrorKind::MaxNumberOfConfigurationRecordersExceededException(_inner) =>
            Some(_inner)
            ,
            PutConfigurationRecorderErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `PutConformancePack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutConformancePackError {
    /// Kind of error that occurred.
    pub kind: PutConformancePackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutConformancePack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutConformancePackErrorKind {
    /// <p>You have specified a template that is not valid or supported.</p>
    ConformancePackTemplateValidationException(
        crate::error::ConformancePackTemplateValidationException,
    ),
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li>
    /// <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p> </li>
    /// <li> <p>For PutOrganizationConfigRule, organization config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p>
    /// <ul>
    /// <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>To read Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You have reached the limit (6) of the number of conformance packs in an account (6 conformance pack with 25 Config rules per pack).</p>
    MaxNumberOfConformancePacksExceededException(
        crate::error::MaxNumberOfConformancePacksExceededException,
    ),
    /// <p>You see this exception in the following cases: </p>
    /// <ul>
    /// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
    /// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// </ul>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutConformancePackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutConformancePackErrorKind::ConformancePackTemplateValidationException(_inner) => {
                _inner.fmt(f)
            }
            PutConformancePackErrorKind::InsufficientPermissionsException(_inner) => _inner.fmt(f),
            PutConformancePackErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            PutConformancePackErrorKind::MaxNumberOfConformancePacksExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutConformancePackErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            PutConformancePackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutConformancePackError {
    fn code(&self) -> Option<&str> {
        PutConformancePackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutConformancePackError {
    /// Creates a new `PutConformancePackError`.
    pub fn new(kind: PutConformancePackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutConformancePackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutConformancePackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutConformancePackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutConformancePackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutConformancePackErrorKind::ConformancePackTemplateValidationException`.
    pub fn is_conformance_pack_template_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConformancePackErrorKind::ConformancePackTemplateValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConformancePackErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConformancePackErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConformancePackErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConformancePackErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConformancePackErrorKind::MaxNumberOfConformancePacksExceededException`.
    pub fn is_max_number_of_conformance_packs_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConformancePackErrorKind::MaxNumberOfConformancePacksExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutConformancePackErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConformancePackErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for PutConformancePackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutConformancePackErrorKind::ConformancePackTemplateValidationException(_inner) => {
                Some(_inner)
            }
            PutConformancePackErrorKind::InsufficientPermissionsException(_inner) => Some(_inner),
            PutConformancePackErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PutConformancePackErrorKind::MaxNumberOfConformancePacksExceededException(_inner) => {
                Some(_inner)
            }
            PutConformancePackErrorKind::ResourceInUseException(_inner) => Some(_inner),
            PutConformancePackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDeliveryChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDeliveryChannelError {
    /// Kind of error that occurred.
    pub kind: PutDeliveryChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDeliveryChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDeliveryChannelErrorKind {
    /// <p>Your Amazon S3 bucket policy does not permit Config to write to it.</p>
    InsufficientDeliveryPolicyException(crate::error::InsufficientDeliveryPolicyException),
    /// <p>The specified delivery channel name is not valid.</p>
    InvalidDeliveryChannelNameException(crate::error::InvalidDeliveryChannelNameException),
    /// <p>The specified Amazon S3 key prefix is not valid.</p>
    InvalidS3KeyPrefixException(crate::error::InvalidS3KeyPrefixException),
    /// <p>The specified Amazon KMS Key ARN is not valid.</p>
    InvalidS3KmsKeyArnException(crate::error::InvalidS3KmsKeyArnException),
    /// <p>The specified Amazon SNS topic does not exist.</p>
    InvalidSnsTopicArnException(crate::error::InvalidSnsTopicArnException),
    /// <p>You have reached the limit of the number of delivery channels you can create.</p>
    MaxNumberOfDeliveryChannelsExceededException(
        crate::error::MaxNumberOfDeliveryChannelsExceededException,
    ),
    /// <p>There are no configuration recorders available to provide the role needed to describe your resources. Create a configuration recorder.</p>
    NoAvailableConfigurationRecorderException(
        crate::error::NoAvailableConfigurationRecorderException,
    ),
    /// <p>The specified Amazon S3 bucket does not exist.</p>
    NoSuchBucketException(crate::error::NoSuchBucketException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDeliveryChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDeliveryChannelErrorKind::InsufficientDeliveryPolicyException(_inner) => {
                _inner.fmt(f)
            }
            PutDeliveryChannelErrorKind::InvalidDeliveryChannelNameException(_inner) => {
                _inner.fmt(f)
            }
            PutDeliveryChannelErrorKind::InvalidS3KeyPrefixException(_inner) => _inner.fmt(f),
            PutDeliveryChannelErrorKind::InvalidS3KmsKeyArnException(_inner) => _inner.fmt(f),
            PutDeliveryChannelErrorKind::InvalidSnsTopicArnException(_inner) => _inner.fmt(f),
            PutDeliveryChannelErrorKind::MaxNumberOfDeliveryChannelsExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutDeliveryChannelErrorKind::NoAvailableConfigurationRecorderException(_inner) => {
                _inner.fmt(f)
            }
            PutDeliveryChannelErrorKind::NoSuchBucketException(_inner) => _inner.fmt(f),
            PutDeliveryChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDeliveryChannelError {
    fn code(&self) -> Option<&str> {
        PutDeliveryChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDeliveryChannelError {
    /// Creates a new `PutDeliveryChannelError`.
    pub fn new(kind: PutDeliveryChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDeliveryChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDeliveryChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDeliveryChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDeliveryChannelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutDeliveryChannelErrorKind::InsufficientDeliveryPolicyException`.
    pub fn is_insufficient_delivery_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliveryChannelErrorKind::InsufficientDeliveryPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDeliveryChannelErrorKind::InvalidDeliveryChannelNameException`.
    pub fn is_invalid_delivery_channel_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliveryChannelErrorKind::InvalidDeliveryChannelNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDeliveryChannelErrorKind::InvalidS3KeyPrefixException`.
    pub fn is_invalid_s3_key_prefix_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliveryChannelErrorKind::InvalidS3KeyPrefixException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDeliveryChannelErrorKind::InvalidS3KmsKeyArnException`.
    pub fn is_invalid_s3_kms_key_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliveryChannelErrorKind::InvalidS3KmsKeyArnException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDeliveryChannelErrorKind::InvalidSnsTopicArnException`.
    pub fn is_invalid_sns_topic_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliveryChannelErrorKind::InvalidSnsTopicArnException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDeliveryChannelErrorKind::MaxNumberOfDeliveryChannelsExceededException`.
    pub fn is_max_number_of_delivery_channels_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliveryChannelErrorKind::MaxNumberOfDeliveryChannelsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDeliveryChannelErrorKind::NoAvailableConfigurationRecorderException`.
    pub fn is_no_available_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliveryChannelErrorKind::NoAvailableConfigurationRecorderException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDeliveryChannelErrorKind::NoSuchBucketException`.
    pub fn is_no_such_bucket_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDeliveryChannelErrorKind::NoSuchBucketException(_)
        )
    }
}
impl std::error::Error for PutDeliveryChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDeliveryChannelErrorKind::InsufficientDeliveryPolicyException(_inner) => {
                Some(_inner)
            }
            PutDeliveryChannelErrorKind::InvalidDeliveryChannelNameException(_inner) => {
                Some(_inner)
            }
            PutDeliveryChannelErrorKind::InvalidS3KeyPrefixException(_inner) => Some(_inner),
            PutDeliveryChannelErrorKind::InvalidS3KmsKeyArnException(_inner) => Some(_inner),
            PutDeliveryChannelErrorKind::InvalidSnsTopicArnException(_inner) => Some(_inner),
            PutDeliveryChannelErrorKind::MaxNumberOfDeliveryChannelsExceededException(_inner) => {
                Some(_inner)
            }
            PutDeliveryChannelErrorKind::NoAvailableConfigurationRecorderException(_inner) => {
                Some(_inner)
            }
            PutDeliveryChannelErrorKind::NoSuchBucketException(_inner) => Some(_inner),
            PutDeliveryChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutEvaluations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutEvaluationsError {
    /// Kind of error that occurred.
    pub kind: PutEvaluationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutEvaluations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutEvaluationsErrorKind {
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified <code>ResultToken</code> is invalid.</p>
    InvalidResultTokenException(crate::error::InvalidResultTokenException),
    /// <p>One or more Config rules in the request are invalid. Verify that the rule names are correct and try again.</p>
    NoSuchConfigRuleException(crate::error::NoSuchConfigRuleException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutEvaluationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutEvaluationsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            PutEvaluationsErrorKind::InvalidResultTokenException(_inner) => _inner.fmt(f),
            PutEvaluationsErrorKind::NoSuchConfigRuleException(_inner) => _inner.fmt(f),
            PutEvaluationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutEvaluationsError {
    fn code(&self) -> Option<&str> {
        PutEvaluationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutEvaluationsError {
    /// Creates a new `PutEvaluationsError`.
    pub fn new(kind: PutEvaluationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutEvaluationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutEvaluationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutEvaluationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutEvaluationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutEvaluationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEvaluationsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEvaluationsErrorKind::InvalidResultTokenException`.
    pub fn is_invalid_result_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEvaluationsErrorKind::InvalidResultTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEvaluationsErrorKind::NoSuchConfigRuleException`.
    pub fn is_no_such_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEvaluationsErrorKind::NoSuchConfigRuleException(_)
        )
    }
}
impl std::error::Error for PutEvaluationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutEvaluationsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PutEvaluationsErrorKind::InvalidResultTokenException(_inner) => Some(_inner),
            PutEvaluationsErrorKind::NoSuchConfigRuleException(_inner) => Some(_inner),
            PutEvaluationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutExternalEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutExternalEvaluationError {
    /// Kind of error that occurred.
    pub kind: PutExternalEvaluationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutExternalEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutExternalEvaluationErrorKind {
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more Config rules in the request are invalid. Verify that the rule names are correct and try again.</p>
    NoSuchConfigRuleException(crate::error::NoSuchConfigRuleException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutExternalEvaluationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutExternalEvaluationErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            PutExternalEvaluationErrorKind::NoSuchConfigRuleException(_inner) => _inner.fmt(f),
            PutExternalEvaluationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutExternalEvaluationError {
    fn code(&self) -> Option<&str> {
        PutExternalEvaluationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutExternalEvaluationError {
    /// Creates a new `PutExternalEvaluationError`.
    pub fn new(kind: PutExternalEvaluationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutExternalEvaluationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutExternalEvaluationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutExternalEvaluationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutExternalEvaluationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutExternalEvaluationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutExternalEvaluationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutExternalEvaluationErrorKind::NoSuchConfigRuleException`.
    pub fn is_no_such_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutExternalEvaluationErrorKind::NoSuchConfigRuleException(_)
        )
    }
}
impl std::error::Error for PutExternalEvaluationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutExternalEvaluationErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PutExternalEvaluationErrorKind::NoSuchConfigRuleException(_inner) => Some(_inner),
            PutExternalEvaluationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutOrganizationConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutOrganizationConfigRuleError {
    /// Kind of error that occurred.
    pub kind: PutOrganizationConfigRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutOrganizationConfigRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutOrganizationConfigRuleErrorKind {
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li>
    /// <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p> </li>
    /// <li> <p>For PutOrganizationConfigRule, organization config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p>
    /// <ul>
    /// <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>To read Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You have reached the limit of the number of organization config rules you can create.</p>
    MaxNumberOfOrganizationConfigRulesExceededException(
        crate::error::MaxNumberOfOrganizationConfigRulesExceededException,
    ),
    /// <p>Organization is no longer available.</p>
    NoAvailableOrganizationException(crate::error::NoAvailableOrganizationException),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// <p>Config resource cannot be created because your organization does not have all features enabled.</p>
    OrganizationAllFeaturesNotEnabledException(
        crate::error::OrganizationAllFeaturesNotEnabledException,
    ),
    /// <p>You see this exception in the following cases: </p>
    /// <ul>
    /// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
    /// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// </ul>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutOrganizationConfigRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutOrganizationConfigRuleErrorKind::InsufficientPermissionsException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConfigRuleErrorKind::InvalidParameterValueException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConfigRuleErrorKind::MaxNumberOfOrganizationConfigRulesExceededException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConfigRuleErrorKind::NoAvailableOrganizationException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConfigRuleErrorKind::OrganizationAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConfigRuleErrorKind::OrganizationAllFeaturesNotEnabledException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConfigRuleErrorKind::ResourceInUseException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConfigRuleErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConfigRuleErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutOrganizationConfigRuleError {
    fn code(&self) -> Option<&str> {
        PutOrganizationConfigRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutOrganizationConfigRuleError {
    /// Creates a new `PutOrganizationConfigRuleError`.
    pub fn new(kind: PutOrganizationConfigRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutOrganizationConfigRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutOrganizationConfigRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutOrganizationConfigRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutOrganizationConfigRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutOrganizationConfigRuleErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConfigRuleErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConfigRuleErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConfigRuleErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConfigRuleErrorKind::MaxNumberOfOrganizationConfigRulesExceededException`.
    pub fn is_max_number_of_organization_config_rules_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConfigRuleErrorKind::MaxNumberOfOrganizationConfigRulesExceededException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConfigRuleErrorKind::NoAvailableOrganizationException`.
    pub fn is_no_available_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConfigRuleErrorKind::NoAvailableOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConfigRuleErrorKind::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConfigRuleErrorKind::OrganizationAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConfigRuleErrorKind::OrganizationAllFeaturesNotEnabledException`.
    pub fn is_organization_all_features_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConfigRuleErrorKind::OrganizationAllFeaturesNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConfigRuleErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConfigRuleErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConfigRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConfigRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutOrganizationConfigRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutOrganizationConfigRuleErrorKind::InsufficientPermissionsException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConfigRuleErrorKind::InvalidParameterValueException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConfigRuleErrorKind::MaxNumberOfOrganizationConfigRulesExceededException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConfigRuleErrorKind::NoAvailableOrganizationException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConfigRuleErrorKind::OrganizationAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConfigRuleErrorKind::OrganizationAllFeaturesNotEnabledException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConfigRuleErrorKind::ResourceInUseException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConfigRuleErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConfigRuleErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `PutOrganizationConformancePack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutOrganizationConformancePackError {
    /// Kind of error that occurred.
    pub kind: PutOrganizationConformancePackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutOrganizationConformancePack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutOrganizationConformancePackErrorKind {
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li>
    /// <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p> </li>
    /// <li> <p>For PutOrganizationConfigRule, organization config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p>
    /// <ul>
    /// <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>To read Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>You have reached the limit (6) of the number of organization conformance packs in an account (6 conformance pack with 25 Config rules per pack per account).</p>
    MaxNumberOfOrganizationConformancePacksExceededException(
        crate::error::MaxNumberOfOrganizationConformancePacksExceededException,
    ),
    /// <p>Organization is no longer available.</p>
    NoAvailableOrganizationException(crate::error::NoAvailableOrganizationException),
    /// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
    /// <ul>
    /// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
    /// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
    /// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
    /// </ul>
    /// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
    OrganizationAccessDeniedException(crate::error::OrganizationAccessDeniedException),
    /// <p>Config resource cannot be created because your organization does not have all features enabled.</p>
    OrganizationAllFeaturesNotEnabledException(
        crate::error::OrganizationAllFeaturesNotEnabledException,
    ),
    /// <p>You have specified a template that is not valid or supported.</p>
    OrganizationConformancePackTemplateValidationException(
        crate::error::OrganizationConformancePackTemplateValidationException,
    ),
    /// <p>You see this exception in the following cases: </p>
    /// <ul>
    /// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
    /// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// </ul>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutOrganizationConformancePackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutOrganizationConformancePackErrorKind::InsufficientPermissionsException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConformancePackErrorKind::MaxNumberOfOrganizationConformancePacksExceededException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConformancePackErrorKind::NoAvailableOrganizationException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConformancePackErrorKind::OrganizationAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConformancePackErrorKind::OrganizationAllFeaturesNotEnabledException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConformancePackErrorKind::OrganizationConformancePackTemplateValidationException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConformancePackErrorKind::ResourceInUseException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConformancePackErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            PutOrganizationConformancePackErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutOrganizationConformancePackError {
    fn code(&self) -> Option<&str> {
        PutOrganizationConformancePackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutOrganizationConformancePackError {
    /// Creates a new `PutOrganizationConformancePackError`.
    pub fn new(
        kind: PutOrganizationConformancePackErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutOrganizationConformancePackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutOrganizationConformancePackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutOrganizationConformancePackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutOrganizationConformancePackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConformancePackErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackErrorKind::MaxNumberOfOrganizationConformancePacksExceededException`.
    pub fn is_max_number_of_organization_conformance_packs_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutOrganizationConformancePackErrorKind::MaxNumberOfOrganizationConformancePacksExceededException(_))
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackErrorKind::NoAvailableOrganizationException`.
    pub fn is_no_available_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConformancePackErrorKind::NoAvailableOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackErrorKind::OrganizationAccessDeniedException`.
    pub fn is_organization_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConformancePackErrorKind::OrganizationAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackErrorKind::OrganizationAllFeaturesNotEnabledException`.
    pub fn is_organization_all_features_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConformancePackErrorKind::OrganizationAllFeaturesNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackErrorKind::OrganizationConformancePackTemplateValidationException`.
    pub fn is_organization_conformance_pack_template_validation_exception(&self) -> bool {
        matches!(&self.kind, PutOrganizationConformancePackErrorKind::OrganizationConformancePackTemplateValidationException(_))
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConformancePackErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `PutOrganizationConformancePackErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutOrganizationConformancePackErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutOrganizationConformancePackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutOrganizationConformancePackErrorKind::InsufficientPermissionsException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConformancePackErrorKind::MaxNumberOfOrganizationConformancePacksExceededException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConformancePackErrorKind::NoAvailableOrganizationException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConformancePackErrorKind::OrganizationAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConformancePackErrorKind::OrganizationAllFeaturesNotEnabledException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConformancePackErrorKind::OrganizationConformancePackTemplateValidationException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConformancePackErrorKind::ResourceInUseException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConformancePackErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            PutOrganizationConformancePackErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `PutRemediationConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRemediationConfigurationsError {
    /// Kind of error that occurred.
    pub kind: PutRemediationConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRemediationConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRemediationConfigurationsErrorKind {
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li>
    /// <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p> </li>
    /// <li> <p>For PutOrganizationConfigRule, organization config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p>
    /// <ul>
    /// <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>To read Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRemediationConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRemediationConfigurationsErrorKind::InsufficientPermissionsException(_inner) => {
                _inner.fmt(f)
            }
            PutRemediationConfigurationsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutRemediationConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRemediationConfigurationsError {
    fn code(&self) -> Option<&str> {
        PutRemediationConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRemediationConfigurationsError {
    /// Creates a new `PutRemediationConfigurationsError`.
    pub fn new(kind: PutRemediationConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRemediationConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRemediationConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRemediationConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRemediationConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRemediationConfigurationsErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRemediationConfigurationsErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRemediationConfigurationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRemediationConfigurationsErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for PutRemediationConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRemediationConfigurationsErrorKind::InsufficientPermissionsException(_inner) => {
                Some(_inner)
            }
            PutRemediationConfigurationsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            PutRemediationConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRemediationExceptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRemediationExceptionsError {
    /// Kind of error that occurred.
    pub kind: PutRemediationExceptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRemediationExceptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRemediationExceptionsErrorKind {
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li>
    /// <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p> </li>
    /// <li> <p>For PutOrganizationConfigRule, organization config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p>
    /// <ul>
    /// <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>To read Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRemediationExceptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRemediationExceptionsErrorKind::InsufficientPermissionsException(_inner) => {
                _inner.fmt(f)
            }
            PutRemediationExceptionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutRemediationExceptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRemediationExceptionsError {
    fn code(&self) -> Option<&str> {
        PutRemediationExceptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRemediationExceptionsError {
    /// Creates a new `PutRemediationExceptionsError`.
    pub fn new(kind: PutRemediationExceptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRemediationExceptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRemediationExceptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRemediationExceptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRemediationExceptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRemediationExceptionsErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRemediationExceptionsErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRemediationExceptionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRemediationExceptionsErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for PutRemediationExceptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRemediationExceptionsErrorKind::InsufficientPermissionsException(_inner) => {
                Some(_inner)
            }
            PutRemediationExceptionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            PutRemediationExceptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourceConfigError {
    /// Kind of error that occurred.
    pub kind: PutResourceConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourceConfigErrorKind {
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li>
    /// <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p> </li>
    /// <li> <p>For PutOrganizationConfigRule, organization config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p>
    /// <ul>
    /// <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>To read Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>You have reached the limit (100,000) of active custom resource types in your account. Delete unused resources using <code>DeleteResourceConfig</code>.</p>
    MaxActiveResourcesExceededException(crate::error::MaxActiveResourcesExceededException),
    /// <p>There is no configuration recorder running.</p>
    NoRunningConfigurationRecorderException(crate::error::NoRunningConfigurationRecorderException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourceConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourceConfigErrorKind::InsufficientPermissionsException(_inner) => _inner.fmt(f),
            PutResourceConfigErrorKind::MaxActiveResourcesExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutResourceConfigErrorKind::NoRunningConfigurationRecorderException(_inner) => {
                _inner.fmt(f)
            }
            PutResourceConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutResourceConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourceConfigError {
    fn code(&self) -> Option<&str> {
        PutResourceConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourceConfigError {
    /// Creates a new `PutResourceConfigError`.
    pub fn new(kind: PutResourceConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourceConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourceConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourceConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourceConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutResourceConfigErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceConfigErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceConfigErrorKind::MaxActiveResourcesExceededException`.
    pub fn is_max_active_resources_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceConfigErrorKind::MaxActiveResourcesExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceConfigErrorKind::NoRunningConfigurationRecorderException`.
    pub fn is_no_running_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceConfigErrorKind::NoRunningConfigurationRecorderException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutResourceConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourceConfigErrorKind::InsufficientPermissionsException(_inner) => Some(_inner),
            PutResourceConfigErrorKind::MaxActiveResourcesExceededException(_inner) => Some(_inner),
            PutResourceConfigErrorKind::NoRunningConfigurationRecorderException(_inner) => {
                Some(_inner)
            }
            PutResourceConfigErrorKind::ValidationException(_inner) => Some(_inner),
            PutResourceConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRetentionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRetentionConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutRetentionConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRetentionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRetentionConfigurationErrorKind {
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Failed to add the retention configuration because a retention configuration with that name already exists.</p>
    MaxNumberOfRetentionConfigurationsExceededException(
        crate::error::MaxNumberOfRetentionConfigurationsExceededException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRetentionConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRetentionConfigurationErrorKind::InvalidParameterValueException(_inner) =>
            _inner.fmt(f)
            ,
            PutRetentionConfigurationErrorKind::MaxNumberOfRetentionConfigurationsExceededException(_inner) =>
            _inner.fmt(f)
            ,
            PutRetentionConfigurationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRetentionConfigurationError {
    fn code(&self) -> Option<&str> {
        PutRetentionConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRetentionConfigurationError {
    /// Creates a new `PutRetentionConfigurationError`.
    pub fn new(kind: PutRetentionConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRetentionConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRetentionConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRetentionConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRetentionConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRetentionConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRetentionConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRetentionConfigurationErrorKind::MaxNumberOfRetentionConfigurationsExceededException`.
    pub fn is_max_number_of_retention_configurations_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRetentionConfigurationErrorKind::MaxNumberOfRetentionConfigurationsExceededException(
                _
            )
        )
    }
}
impl std::error::Error for PutRetentionConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRetentionConfigurationErrorKind::InvalidParameterValueException(_inner) =>
            Some(_inner)
            ,
            PutRetentionConfigurationErrorKind::MaxNumberOfRetentionConfigurationsExceededException(_inner) =>
            Some(_inner)
            ,
            PutRetentionConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `PutStoredQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutStoredQueryError {
    /// Kind of error that occurred.
    pub kind: PutStoredQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutStoredQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutStoredQueryErrorKind {
    /// <p>Two users are trying to modify the same query at the same time. Wait for a moment and try again.</p>
    ResourceConcurrentModificationException(crate::error::ResourceConcurrentModificationException),
    /// <p>You have reached the limit of the number of tags you can use. You have more than 50 tags.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutStoredQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutStoredQueryErrorKind::ResourceConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            PutStoredQueryErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            PutStoredQueryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutStoredQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutStoredQueryError {
    fn code(&self) -> Option<&str> {
        PutStoredQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutStoredQueryError {
    /// Creates a new `PutStoredQueryError`.
    pub fn new(kind: PutStoredQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutStoredQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutStoredQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutStoredQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutStoredQueryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutStoredQueryErrorKind::ResourceConcurrentModificationException`.
    pub fn is_resource_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStoredQueryErrorKind::ResourceConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutStoredQueryErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, PutStoredQueryErrorKind::TooManyTagsException(_))
    }
    /// Returns `true` if the error kind is `PutStoredQueryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutStoredQueryErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutStoredQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutStoredQueryErrorKind::ResourceConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            PutStoredQueryErrorKind::TooManyTagsException(_inner) => Some(_inner),
            PutStoredQueryErrorKind::ValidationException(_inner) => Some(_inner),
            PutStoredQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SelectAggregateResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SelectAggregateResourceConfigError {
    /// Kind of error that occurred.
    pub kind: SelectAggregateResourceConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SelectAggregateResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SelectAggregateResourceConfigErrorKind {
    /// <p>The syntax of the query is incorrect.</p>
    InvalidExpressionException(crate::error::InvalidExpressionException),
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You have specified a configuration aggregator that does not exist.</p>
    NoSuchConfigurationAggregatorException(crate::error::NoSuchConfigurationAggregatorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SelectAggregateResourceConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SelectAggregateResourceConfigErrorKind::InvalidExpressionException(_inner) => {
                _inner.fmt(f)
            }
            SelectAggregateResourceConfigErrorKind::InvalidLimitException(_inner) => _inner.fmt(f),
            SelectAggregateResourceConfigErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            SelectAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(
                _inner,
            ) => _inner.fmt(f),
            SelectAggregateResourceConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SelectAggregateResourceConfigError {
    fn code(&self) -> Option<&str> {
        SelectAggregateResourceConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SelectAggregateResourceConfigError {
    /// Creates a new `SelectAggregateResourceConfigError`.
    pub fn new(
        kind: SelectAggregateResourceConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SelectAggregateResourceConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SelectAggregateResourceConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SelectAggregateResourceConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SelectAggregateResourceConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SelectAggregateResourceConfigErrorKind::InvalidExpressionException`.
    pub fn is_invalid_expression_exception(&self) -> bool {
        matches!(
            &self.kind,
            SelectAggregateResourceConfigErrorKind::InvalidExpressionException(_)
        )
    }
    /// Returns `true` if the error kind is `SelectAggregateResourceConfigErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            SelectAggregateResourceConfigErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `SelectAggregateResourceConfigErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            SelectAggregateResourceConfigErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `SelectAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException`.
    pub fn is_no_such_configuration_aggregator_exception(&self) -> bool {
        matches!(
            &self.kind,
            SelectAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(_)
        )
    }
}
impl std::error::Error for SelectAggregateResourceConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SelectAggregateResourceConfigErrorKind::InvalidExpressionException(_inner) => {
                Some(_inner)
            }
            SelectAggregateResourceConfigErrorKind::InvalidLimitException(_inner) => Some(_inner),
            SelectAggregateResourceConfigErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            SelectAggregateResourceConfigErrorKind::NoSuchConfigurationAggregatorException(
                _inner,
            ) => Some(_inner),
            SelectAggregateResourceConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SelectResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SelectResourceConfigError {
    /// Kind of error that occurred.
    pub kind: SelectResourceConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SelectResourceConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SelectResourceConfigErrorKind {
    /// <p>The syntax of the query is incorrect.</p>
    InvalidExpressionException(crate::error::InvalidExpressionException),
    /// <p>The specified limit is outside the allowable range.</p>
    InvalidLimitException(crate::error::InvalidLimitException),
    /// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SelectResourceConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SelectResourceConfigErrorKind::InvalidExpressionException(_inner) => _inner.fmt(f),
            SelectResourceConfigErrorKind::InvalidLimitException(_inner) => _inner.fmt(f),
            SelectResourceConfigErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            SelectResourceConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SelectResourceConfigError {
    fn code(&self) -> Option<&str> {
        SelectResourceConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SelectResourceConfigError {
    /// Creates a new `SelectResourceConfigError`.
    pub fn new(kind: SelectResourceConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SelectResourceConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SelectResourceConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SelectResourceConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SelectResourceConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SelectResourceConfigErrorKind::InvalidExpressionException`.
    pub fn is_invalid_expression_exception(&self) -> bool {
        matches!(
            &self.kind,
            SelectResourceConfigErrorKind::InvalidExpressionException(_)
        )
    }
    /// Returns `true` if the error kind is `SelectResourceConfigErrorKind::InvalidLimitException`.
    pub fn is_invalid_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            SelectResourceConfigErrorKind::InvalidLimitException(_)
        )
    }
    /// Returns `true` if the error kind is `SelectResourceConfigErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            SelectResourceConfigErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for SelectResourceConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SelectResourceConfigErrorKind::InvalidExpressionException(_inner) => Some(_inner),
            SelectResourceConfigErrorKind::InvalidLimitException(_inner) => Some(_inner),
            SelectResourceConfigErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            SelectResourceConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartConfigRulesEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartConfigRulesEvaluationError {
    /// Kind of error that occurred.
    pub kind: StartConfigRulesEvaluationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartConfigRulesEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartConfigRulesEvaluationErrorKind {
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if an evaluation is in progress or if you call the <code>StartConfigRulesEvaluation</code> API more than once per minute.</p>
    /// <p>For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and aggregators exceeds the limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more Config rules in the request are invalid. Verify that the rule names are correct and try again.</p>
    NoSuchConfigRuleException(crate::error::NoSuchConfigRuleException),
    /// <p>You see this exception in the following cases: </p>
    /// <ul>
    /// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
    /// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
    /// </ul>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartConfigRulesEvaluationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartConfigRulesEvaluationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            StartConfigRulesEvaluationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartConfigRulesEvaluationErrorKind::NoSuchConfigRuleException(_inner) => _inner.fmt(f),
            StartConfigRulesEvaluationErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            StartConfigRulesEvaluationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartConfigRulesEvaluationError {
    fn code(&self) -> Option<&str> {
        StartConfigRulesEvaluationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartConfigRulesEvaluationError {
    /// Creates a new `StartConfigRulesEvaluationError`.
    pub fn new(kind: StartConfigRulesEvaluationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartConfigRulesEvaluationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartConfigRulesEvaluationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartConfigRulesEvaluationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartConfigRulesEvaluationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartConfigRulesEvaluationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartConfigRulesEvaluationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StartConfigRulesEvaluationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartConfigRulesEvaluationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartConfigRulesEvaluationErrorKind::NoSuchConfigRuleException`.
    pub fn is_no_such_config_rule_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartConfigRulesEvaluationErrorKind::NoSuchConfigRuleException(_)
        )
    }
    /// Returns `true` if the error kind is `StartConfigRulesEvaluationErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartConfigRulesEvaluationErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for StartConfigRulesEvaluationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartConfigRulesEvaluationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            StartConfigRulesEvaluationErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartConfigRulesEvaluationErrorKind::NoSuchConfigRuleException(_inner) => Some(_inner),
            StartConfigRulesEvaluationErrorKind::ResourceInUseException(_inner) => Some(_inner),
            StartConfigRulesEvaluationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartConfigurationRecorder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartConfigurationRecorderError {
    /// Kind of error that occurred.
    pub kind: StartConfigurationRecorderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartConfigurationRecorder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartConfigurationRecorderErrorKind {
    /// <p>There is no delivery channel available to record configurations.</p>
    NoAvailableDeliveryChannelException(crate::error::NoAvailableDeliveryChannelException),
    /// <p>You have specified a configuration recorder that does not exist.</p>
    NoSuchConfigurationRecorderException(crate::error::NoSuchConfigurationRecorderException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartConfigurationRecorderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartConfigurationRecorderErrorKind::NoAvailableDeliveryChannelException(_inner) => {
                _inner.fmt(f)
            }
            StartConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(_inner) => {
                _inner.fmt(f)
            }
            StartConfigurationRecorderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartConfigurationRecorderError {
    fn code(&self) -> Option<&str> {
        StartConfigurationRecorderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartConfigurationRecorderError {
    /// Creates a new `StartConfigurationRecorderError`.
    pub fn new(kind: StartConfigurationRecorderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartConfigurationRecorderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartConfigurationRecorderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartConfigurationRecorderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartConfigurationRecorderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartConfigurationRecorderErrorKind::NoAvailableDeliveryChannelException`.
    pub fn is_no_available_delivery_channel_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartConfigurationRecorderErrorKind::NoAvailableDeliveryChannelException(_)
        )
    }
    /// Returns `true` if the error kind is `StartConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException`.
    pub fn is_no_such_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(_)
        )
    }
}
impl std::error::Error for StartConfigurationRecorderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartConfigurationRecorderErrorKind::NoAvailableDeliveryChannelException(_inner) => {
                Some(_inner)
            }
            StartConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(_inner) => {
                Some(_inner)
            }
            StartConfigurationRecorderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartRemediationExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartRemediationExecutionError {
    /// Kind of error that occurred.
    pub kind: StartRemediationExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartRemediationExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartRemediationExecutionErrorKind {
    /// <p>Indicates one of the following errors:</p>
    /// <ul>
    /// <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li>
    /// <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p> </li>
    /// <li> <p>For PutOrganizationConfigRule, organization config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p>
    /// <ul>
    /// <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
    /// <li> <p>To read Amazon S3 bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    InsufficientPermissionsException(crate::error::InsufficientPermissionsException),
    /// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You specified an Config rule without a remediation configuration.</p>
    NoSuchRemediationConfigurationException(crate::error::NoSuchRemediationConfigurationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartRemediationExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartRemediationExecutionErrorKind::InsufficientPermissionsException(_inner) => {
                _inner.fmt(f)
            }
            StartRemediationExecutionErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            StartRemediationExecutionErrorKind::NoSuchRemediationConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            StartRemediationExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartRemediationExecutionError {
    fn code(&self) -> Option<&str> {
        StartRemediationExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartRemediationExecutionError {
    /// Creates a new `StartRemediationExecutionError`.
    pub fn new(kind: StartRemediationExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartRemediationExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartRemediationExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartRemediationExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartRemediationExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartRemediationExecutionErrorKind::InsufficientPermissionsException`.
    pub fn is_insufficient_permissions_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRemediationExecutionErrorKind::InsufficientPermissionsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRemediationExecutionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRemediationExecutionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRemediationExecutionErrorKind::NoSuchRemediationConfigurationException`.
    pub fn is_no_such_remediation_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRemediationExecutionErrorKind::NoSuchRemediationConfigurationException(_)
        )
    }
}
impl std::error::Error for StartRemediationExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartRemediationExecutionErrorKind::InsufficientPermissionsException(_inner) => {
                Some(_inner)
            }
            StartRemediationExecutionErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            StartRemediationExecutionErrorKind::NoSuchRemediationConfigurationException(_inner) => {
                Some(_inner)
            }
            StartRemediationExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopConfigurationRecorder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopConfigurationRecorderError {
    /// Kind of error that occurred.
    pub kind: StopConfigurationRecorderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopConfigurationRecorder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopConfigurationRecorderErrorKind {
    /// <p>You have specified a configuration recorder that does not exist.</p>
    NoSuchConfigurationRecorderException(crate::error::NoSuchConfigurationRecorderException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopConfigurationRecorderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(_inner) => {
                _inner.fmt(f)
            }
            StopConfigurationRecorderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopConfigurationRecorderError {
    fn code(&self) -> Option<&str> {
        StopConfigurationRecorderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopConfigurationRecorderError {
    /// Creates a new `StopConfigurationRecorderError`.
    pub fn new(kind: StopConfigurationRecorderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopConfigurationRecorderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopConfigurationRecorderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopConfigurationRecorderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopConfigurationRecorderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException`.
    pub fn is_no_such_configuration_recorder_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(_)
        )
    }
}
impl std::error::Error for StopConfigurationRecorderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopConfigurationRecorderErrorKind::NoSuchConfigurationRecorderException(_inner) => {
                Some(_inner)
            }
            StopConfigurationRecorderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You have specified a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached the limit of the number of tags you can use. You have more than 50 tags.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You have specified a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested action is not valid.</p>
    /// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
    /// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The requested action is not valid.</p>
/// <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p>
/// <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>You have specified a resource that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>You have reached the limit of the number of tags you can use. You have more than 50 tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>You have specified a configuration recorder that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchConfigurationRecorderException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchConfigurationRecorderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchConfigurationRecorderException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchConfigurationRecorderException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchConfigurationRecorderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchConfigurationRecorderException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchConfigurationRecorderException {}
/// See [`NoSuchConfigurationRecorderException`](crate::error::NoSuchConfigurationRecorderException)
pub mod no_such_configuration_recorder_exception {
    /// A builder for [`NoSuchConfigurationRecorderException`](crate::error::NoSuchConfigurationRecorderException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchConfigurationRecorderException`](crate::error::NoSuchConfigurationRecorderException)
        pub fn build(self) -> crate::error::NoSuchConfigurationRecorderException {
            crate::error::NoSuchConfigurationRecorderException {
                message: self.message,
            }
        }
    }
}
impl NoSuchConfigurationRecorderException {
    /// Creates a new builder-style object to manufacture [`NoSuchConfigurationRecorderException`](crate::error::NoSuchConfigurationRecorderException)
    pub fn builder() -> crate::error::no_such_configuration_recorder_exception::Builder {
        crate::error::no_such_configuration_recorder_exception::Builder::default()
    }
}

/// <p>You specified an Config rule without a remediation configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchRemediationConfigurationException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchRemediationConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchRemediationConfigurationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchRemediationConfigurationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchRemediationConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchRemediationConfigurationException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchRemediationConfigurationException {}
/// See [`NoSuchRemediationConfigurationException`](crate::error::NoSuchRemediationConfigurationException)
pub mod no_such_remediation_configuration_exception {
    /// A builder for [`NoSuchRemediationConfigurationException`](crate::error::NoSuchRemediationConfigurationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchRemediationConfigurationException`](crate::error::NoSuchRemediationConfigurationException)
        pub fn build(self) -> crate::error::NoSuchRemediationConfigurationException {
            crate::error::NoSuchRemediationConfigurationException {
                message: self.message,
            }
        }
    }
}
impl NoSuchRemediationConfigurationException {
    /// Creates a new builder-style object to manufacture [`NoSuchRemediationConfigurationException`](crate::error::NoSuchRemediationConfigurationException)
    pub fn builder() -> crate::error::no_such_remediation_configuration_exception::Builder {
        crate::error::no_such_remediation_configuration_exception::Builder::default()
    }
}

/// <p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValueException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValueException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValueException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValueException {}
/// See [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
pub mod invalid_parameter_value_exception {
    /// A builder for [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
        pub fn build(self) -> crate::error::InvalidParameterValueException {
            crate::error::InvalidParameterValueException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterValueException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    pub fn builder() -> crate::error::invalid_parameter_value_exception::Builder {
        crate::error::invalid_parameter_value_exception::Builder::default()
    }
}

/// <p>Indicates one of the following errors:</p>
/// <ul>
/// <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li>
/// <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.</p> </li>
/// <li> <p>For PutOrganizationConfigRule, organization config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
/// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p>
/// <ul>
/// <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li>
/// <li> <p>To read Amazon S3 bucket.</p> </li>
/// </ul> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientPermissionsException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientPermissionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientPermissionsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientPermissionsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientPermissionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientPermissionsException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientPermissionsException {}
/// See [`InsufficientPermissionsException`](crate::error::InsufficientPermissionsException)
pub mod insufficient_permissions_exception {
    /// A builder for [`InsufficientPermissionsException`](crate::error::InsufficientPermissionsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientPermissionsException`](crate::error::InsufficientPermissionsException)
        pub fn build(self) -> crate::error::InsufficientPermissionsException {
            crate::error::InsufficientPermissionsException {
                message: self.message,
            }
        }
    }
}
impl InsufficientPermissionsException {
    /// Creates a new builder-style object to manufacture [`InsufficientPermissionsException`](crate::error::InsufficientPermissionsException)
    pub fn builder() -> crate::error::insufficient_permissions_exception::Builder {
        crate::error::insufficient_permissions_exception::Builder::default()
    }
}

/// <p>There is no delivery channel available to record configurations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoAvailableDeliveryChannelException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoAvailableDeliveryChannelException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoAvailableDeliveryChannelException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoAvailableDeliveryChannelException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoAvailableDeliveryChannelException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoAvailableDeliveryChannelException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoAvailableDeliveryChannelException {}
/// See [`NoAvailableDeliveryChannelException`](crate::error::NoAvailableDeliveryChannelException)
pub mod no_available_delivery_channel_exception {
    /// A builder for [`NoAvailableDeliveryChannelException`](crate::error::NoAvailableDeliveryChannelException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoAvailableDeliveryChannelException`](crate::error::NoAvailableDeliveryChannelException)
        pub fn build(self) -> crate::error::NoAvailableDeliveryChannelException {
            crate::error::NoAvailableDeliveryChannelException {
                message: self.message,
            }
        }
    }
}
impl NoAvailableDeliveryChannelException {
    /// Creates a new builder-style object to manufacture [`NoAvailableDeliveryChannelException`](crate::error::NoAvailableDeliveryChannelException)
    pub fn builder() -> crate::error::no_available_delivery_channel_exception::Builder {
        crate::error::no_available_delivery_channel_exception::Builder::default()
    }
}

/// <p>You see this exception in the following cases: </p>
/// <ul>
/// <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li>
/// <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li>
/// <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li>
/// <li> <p>For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again later.</p> </li>
/// <li> <p>For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request again later.</p> </li>
/// <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
/// <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>One or more Config rules in the request are invalid. Verify that the rule names are correct and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchConfigRuleException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchConfigRuleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchConfigRuleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchConfigRuleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchConfigRuleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchConfigRuleException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchConfigRuleException {}
/// See [`NoSuchConfigRuleException`](crate::error::NoSuchConfigRuleException)
pub mod no_such_config_rule_exception {
    /// A builder for [`NoSuchConfigRuleException`](crate::error::NoSuchConfigRuleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchConfigRuleException`](crate::error::NoSuchConfigRuleException)
        pub fn build(self) -> crate::error::NoSuchConfigRuleException {
            crate::error::NoSuchConfigRuleException {
                message: self.message,
            }
        }
    }
}
impl NoSuchConfigRuleException {
    /// Creates a new builder-style object to manufacture [`NoSuchConfigRuleException`](crate::error::NoSuchConfigRuleException)
    pub fn builder() -> crate::error::no_such_config_rule_exception::Builder {
        crate::error::no_such_config_rule_exception::Builder::default()
    }
}

/// <p>For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if an evaluation is in progress or if you call the <code>StartConfigRulesEvaluation</code> API more than once per minute.</p>
/// <p>For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and aggregators exceeds the limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The specified limit is outside the allowable range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLimitException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidLimitException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLimitException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLimitException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLimitException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLimitException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLimitException {}
/// See [`InvalidLimitException`](crate::error::InvalidLimitException)
pub mod invalid_limit_exception {
    /// A builder for [`InvalidLimitException`](crate::error::InvalidLimitException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLimitException`](crate::error::InvalidLimitException)
        pub fn build(self) -> crate::error::InvalidLimitException {
            crate::error::InvalidLimitException {
                message: self.message,
            }
        }
    }
}
impl InvalidLimitException {
    /// Creates a new builder-style object to manufacture [`InvalidLimitException`](crate::error::InvalidLimitException)
    pub fn builder() -> crate::error::invalid_limit_exception::Builder {
        crate::error::invalid_limit_exception::Builder::default()
    }
}

/// <p>The syntax of the query is incorrect.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidExpressionException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidExpressionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidExpressionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidExpressionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidExpressionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidExpressionException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidExpressionException {}
/// See [`InvalidExpressionException`](crate::error::InvalidExpressionException)
pub mod invalid_expression_exception {
    /// A builder for [`InvalidExpressionException`](crate::error::InvalidExpressionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidExpressionException`](crate::error::InvalidExpressionException)
        pub fn build(self) -> crate::error::InvalidExpressionException {
            crate::error::InvalidExpressionException {
                message: self.message,
            }
        }
    }
}
impl InvalidExpressionException {
    /// Creates a new builder-style object to manufacture [`InvalidExpressionException`](crate::error::InvalidExpressionException)
    pub fn builder() -> crate::error::invalid_expression_exception::Builder {
        crate::error::invalid_expression_exception::Builder::default()
    }
}

/// <p>You have specified a configuration aggregator that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchConfigurationAggregatorException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchConfigurationAggregatorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchConfigurationAggregatorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchConfigurationAggregatorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchConfigurationAggregatorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchConfigurationAggregatorException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchConfigurationAggregatorException {}
/// See [`NoSuchConfigurationAggregatorException`](crate::error::NoSuchConfigurationAggregatorException)
pub mod no_such_configuration_aggregator_exception {
    /// A builder for [`NoSuchConfigurationAggregatorException`](crate::error::NoSuchConfigurationAggregatorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchConfigurationAggregatorException`](crate::error::NoSuchConfigurationAggregatorException)
        pub fn build(self) -> crate::error::NoSuchConfigurationAggregatorException {
            crate::error::NoSuchConfigurationAggregatorException {
                message: self.message,
            }
        }
    }
}
impl NoSuchConfigurationAggregatorException {
    /// Creates a new builder-style object to manufacture [`NoSuchConfigurationAggregatorException`](crate::error::NoSuchConfigurationAggregatorException)
    pub fn builder() -> crate::error::no_such_configuration_aggregator_exception::Builder {
        crate::error::no_such_configuration_aggregator_exception::Builder::default()
    }
}

/// <p>Two users are trying to modify the same query at the same time. Wait for a moment and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceConcurrentModificationException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceConcurrentModificationException {}
/// See [`ResourceConcurrentModificationException`](crate::error::ResourceConcurrentModificationException)
pub mod resource_concurrent_modification_exception {
    /// A builder for [`ResourceConcurrentModificationException`](crate::error::ResourceConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceConcurrentModificationException`](crate::error::ResourceConcurrentModificationException)
        pub fn build(self) -> crate::error::ResourceConcurrentModificationException {
            crate::error::ResourceConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ResourceConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ResourceConcurrentModificationException`](crate::error::ResourceConcurrentModificationException)
    pub fn builder() -> crate::error::resource_concurrent_modification_exception::Builder {
        crate::error::resource_concurrent_modification_exception::Builder::default()
    }
}

/// <p>Failed to add the retention configuration because a retention configuration with that name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxNumberOfRetentionConfigurationsExceededException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxNumberOfRetentionConfigurationsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxNumberOfRetentionConfigurationsExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxNumberOfRetentionConfigurationsExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxNumberOfRetentionConfigurationsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaxNumberOfRetentionConfigurationsExceededException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxNumberOfRetentionConfigurationsExceededException {}
/// See [`MaxNumberOfRetentionConfigurationsExceededException`](crate::error::MaxNumberOfRetentionConfigurationsExceededException)
pub mod max_number_of_retention_configurations_exceeded_exception {
    /// A builder for [`MaxNumberOfRetentionConfigurationsExceededException`](crate::error::MaxNumberOfRetentionConfigurationsExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxNumberOfRetentionConfigurationsExceededException`](crate::error::MaxNumberOfRetentionConfigurationsExceededException)
        pub fn build(self) -> crate::error::MaxNumberOfRetentionConfigurationsExceededException {
            crate::error::MaxNumberOfRetentionConfigurationsExceededException {
                message: self.message,
            }
        }
    }
}
impl MaxNumberOfRetentionConfigurationsExceededException {
    /// Creates a new builder-style object to manufacture [`MaxNumberOfRetentionConfigurationsExceededException`](crate::error::MaxNumberOfRetentionConfigurationsExceededException)
    pub fn builder(
    ) -> crate::error::max_number_of_retention_configurations_exceeded_exception::Builder {
        crate::error::max_number_of_retention_configurations_exceeded_exception::Builder::default()
    }
}

/// <p>There is no configuration recorder running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoRunningConfigurationRecorderException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoRunningConfigurationRecorderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoRunningConfigurationRecorderException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoRunningConfigurationRecorderException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoRunningConfigurationRecorderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoRunningConfigurationRecorderException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoRunningConfigurationRecorderException {}
/// See [`NoRunningConfigurationRecorderException`](crate::error::NoRunningConfigurationRecorderException)
pub mod no_running_configuration_recorder_exception {
    /// A builder for [`NoRunningConfigurationRecorderException`](crate::error::NoRunningConfigurationRecorderException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoRunningConfigurationRecorderException`](crate::error::NoRunningConfigurationRecorderException)
        pub fn build(self) -> crate::error::NoRunningConfigurationRecorderException {
            crate::error::NoRunningConfigurationRecorderException {
                message: self.message,
            }
        }
    }
}
impl NoRunningConfigurationRecorderException {
    /// Creates a new builder-style object to manufacture [`NoRunningConfigurationRecorderException`](crate::error::NoRunningConfigurationRecorderException)
    pub fn builder() -> crate::error::no_running_configuration_recorder_exception::Builder {
        crate::error::no_running_configuration_recorder_exception::Builder::default()
    }
}

/// <p>You have reached the limit (100,000) of active custom resource types in your account. Delete unused resources using <code>DeleteResourceConfig</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxActiveResourcesExceededException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxActiveResourcesExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxActiveResourcesExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxActiveResourcesExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxActiveResourcesExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaxActiveResourcesExceededException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxActiveResourcesExceededException {}
/// See [`MaxActiveResourcesExceededException`](crate::error::MaxActiveResourcesExceededException)
pub mod max_active_resources_exceeded_exception {
    /// A builder for [`MaxActiveResourcesExceededException`](crate::error::MaxActiveResourcesExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxActiveResourcesExceededException`](crate::error::MaxActiveResourcesExceededException)
        pub fn build(self) -> crate::error::MaxActiveResourcesExceededException {
            crate::error::MaxActiveResourcesExceededException {
                message: self.message,
            }
        }
    }
}
impl MaxActiveResourcesExceededException {
    /// Creates a new builder-style object to manufacture [`MaxActiveResourcesExceededException`](crate::error::MaxActiveResourcesExceededException)
    pub fn builder() -> crate::error::max_active_resources_exceeded_exception::Builder {
        crate::error::max_active_resources_exceeded_exception::Builder::default()
    }
}

/// <p>You have specified a template that is not valid or supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationConformancePackTemplateValidationException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationConformancePackTemplateValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("OrganizationConformancePackTemplateValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OrganizationConformancePackTemplateValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationConformancePackTemplateValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationConformancePackTemplateValidationException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationConformancePackTemplateValidationException {}
/// See [`OrganizationConformancePackTemplateValidationException`](crate::error::OrganizationConformancePackTemplateValidationException)
pub mod organization_conformance_pack_template_validation_exception {
    /// A builder for [`OrganizationConformancePackTemplateValidationException`](crate::error::OrganizationConformancePackTemplateValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationConformancePackTemplateValidationException`](crate::error::OrganizationConformancePackTemplateValidationException)
        pub fn build(self) -> crate::error::OrganizationConformancePackTemplateValidationException {
            crate::error::OrganizationConformancePackTemplateValidationException {
                message: self.message,
            }
        }
    }
}
impl OrganizationConformancePackTemplateValidationException {
    /// Creates a new builder-style object to manufacture [`OrganizationConformancePackTemplateValidationException`](crate::error::OrganizationConformancePackTemplateValidationException)
    pub fn builder(
    ) -> crate::error::organization_conformance_pack_template_validation_exception::Builder {
        crate::error::organization_conformance_pack_template_validation_exception::Builder::default(
        )
    }
}

/// <p>Config resource cannot be created because your organization does not have all features enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationAllFeaturesNotEnabledException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationAllFeaturesNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationAllFeaturesNotEnabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OrganizationAllFeaturesNotEnabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationAllFeaturesNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationAllFeaturesNotEnabledException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationAllFeaturesNotEnabledException {}
/// See [`OrganizationAllFeaturesNotEnabledException`](crate::error::OrganizationAllFeaturesNotEnabledException)
pub mod organization_all_features_not_enabled_exception {
    /// A builder for [`OrganizationAllFeaturesNotEnabledException`](crate::error::OrganizationAllFeaturesNotEnabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationAllFeaturesNotEnabledException`](crate::error::OrganizationAllFeaturesNotEnabledException)
        pub fn build(self) -> crate::error::OrganizationAllFeaturesNotEnabledException {
            crate::error::OrganizationAllFeaturesNotEnabledException {
                message: self.message,
            }
        }
    }
}
impl OrganizationAllFeaturesNotEnabledException {
    /// Creates a new builder-style object to manufacture [`OrganizationAllFeaturesNotEnabledException`](crate::error::OrganizationAllFeaturesNotEnabledException)
    pub fn builder() -> crate::error::organization_all_features_not_enabled_exception::Builder {
        crate::error::organization_all_features_not_enabled_exception::Builder::default()
    }
}

/// <p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p>
/// <ul>
/// <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li>
/// <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
/// <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li>
/// <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li>
/// </ul>
/// <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationAccessDeniedException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationAccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationAccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OrganizationAccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationAccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationAccessDeniedException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationAccessDeniedException {}
/// See [`OrganizationAccessDeniedException`](crate::error::OrganizationAccessDeniedException)
pub mod organization_access_denied_exception {
    /// A builder for [`OrganizationAccessDeniedException`](crate::error::OrganizationAccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationAccessDeniedException`](crate::error::OrganizationAccessDeniedException)
        pub fn build(self) -> crate::error::OrganizationAccessDeniedException {
            crate::error::OrganizationAccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl OrganizationAccessDeniedException {
    /// Creates a new builder-style object to manufacture [`OrganizationAccessDeniedException`](crate::error::OrganizationAccessDeniedException)
    pub fn builder() -> crate::error::organization_access_denied_exception::Builder {
        crate::error::organization_access_denied_exception::Builder::default()
    }
}

/// <p>Organization is no longer available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoAvailableOrganizationException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoAvailableOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoAvailableOrganizationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoAvailableOrganizationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoAvailableOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoAvailableOrganizationException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoAvailableOrganizationException {}
/// See [`NoAvailableOrganizationException`](crate::error::NoAvailableOrganizationException)
pub mod no_available_organization_exception {
    /// A builder for [`NoAvailableOrganizationException`](crate::error::NoAvailableOrganizationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoAvailableOrganizationException`](crate::error::NoAvailableOrganizationException)
        pub fn build(self) -> crate::error::NoAvailableOrganizationException {
            crate::error::NoAvailableOrganizationException {
                message: self.message,
            }
        }
    }
}
impl NoAvailableOrganizationException {
    /// Creates a new builder-style object to manufacture [`NoAvailableOrganizationException`](crate::error::NoAvailableOrganizationException)
    pub fn builder() -> crate::error::no_available_organization_exception::Builder {
        crate::error::no_available_organization_exception::Builder::default()
    }
}

/// <p>You have reached the limit (6) of the number of organization conformance packs in an account (6 conformance pack with 25 Config rules per pack per account).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxNumberOfOrganizationConformancePacksExceededException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxNumberOfOrganizationConformancePacksExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("MaxNumberOfOrganizationConformancePacksExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxNumberOfOrganizationConformancePacksExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxNumberOfOrganizationConformancePacksExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "MaxNumberOfOrganizationConformancePacksExceededException"
        )?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxNumberOfOrganizationConformancePacksExceededException {}
/// See [`MaxNumberOfOrganizationConformancePacksExceededException`](crate::error::MaxNumberOfOrganizationConformancePacksExceededException)
pub mod max_number_of_organization_conformance_packs_exceeded_exception {
    /// A builder for [`MaxNumberOfOrganizationConformancePacksExceededException`](crate::error::MaxNumberOfOrganizationConformancePacksExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxNumberOfOrganizationConformancePacksExceededException`](crate::error::MaxNumberOfOrganizationConformancePacksExceededException)
        pub fn build(
            self,
        ) -> crate::error::MaxNumberOfOrganizationConformancePacksExceededException {
            crate::error::MaxNumberOfOrganizationConformancePacksExceededException {
                message: self.message,
            }
        }
    }
}
impl MaxNumberOfOrganizationConformancePacksExceededException {
    /// Creates a new builder-style object to manufacture [`MaxNumberOfOrganizationConformancePacksExceededException`](crate::error::MaxNumberOfOrganizationConformancePacksExceededException)
    pub fn builder(
    ) -> crate::error::max_number_of_organization_conformance_packs_exceeded_exception::Builder
    {
        crate::error::max_number_of_organization_conformance_packs_exceeded_exception::Builder::default()
    }
}

/// <p>You have reached the limit of the number of organization config rules you can create.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxNumberOfOrganizationConfigRulesExceededException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxNumberOfOrganizationConfigRulesExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxNumberOfOrganizationConfigRulesExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxNumberOfOrganizationConfigRulesExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxNumberOfOrganizationConfigRulesExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaxNumberOfOrganizationConfigRulesExceededException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxNumberOfOrganizationConfigRulesExceededException {}
/// See [`MaxNumberOfOrganizationConfigRulesExceededException`](crate::error::MaxNumberOfOrganizationConfigRulesExceededException)
pub mod max_number_of_organization_config_rules_exceeded_exception {
    /// A builder for [`MaxNumberOfOrganizationConfigRulesExceededException`](crate::error::MaxNumberOfOrganizationConfigRulesExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxNumberOfOrganizationConfigRulesExceededException`](crate::error::MaxNumberOfOrganizationConfigRulesExceededException)
        pub fn build(self) -> crate::error::MaxNumberOfOrganizationConfigRulesExceededException {
            crate::error::MaxNumberOfOrganizationConfigRulesExceededException {
                message: self.message,
            }
        }
    }
}
impl MaxNumberOfOrganizationConfigRulesExceededException {
    /// Creates a new builder-style object to manufacture [`MaxNumberOfOrganizationConfigRulesExceededException`](crate::error::MaxNumberOfOrganizationConfigRulesExceededException)
    pub fn builder(
    ) -> crate::error::max_number_of_organization_config_rules_exceeded_exception::Builder {
        crate::error::max_number_of_organization_config_rules_exceeded_exception::Builder::default()
    }
}

/// <p>The specified <code>ResultToken</code> is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResultTokenException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResultTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResultTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResultTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResultTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResultTokenException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResultTokenException {}
/// See [`InvalidResultTokenException`](crate::error::InvalidResultTokenException)
pub mod invalid_result_token_exception {
    /// A builder for [`InvalidResultTokenException`](crate::error::InvalidResultTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResultTokenException`](crate::error::InvalidResultTokenException)
        pub fn build(self) -> crate::error::InvalidResultTokenException {
            crate::error::InvalidResultTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidResultTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidResultTokenException`](crate::error::InvalidResultTokenException)
    pub fn builder() -> crate::error::invalid_result_token_exception::Builder {
        crate::error::invalid_result_token_exception::Builder::default()
    }
}

/// <p>The specified Amazon S3 bucket does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchBucketException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchBucketException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchBucketException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchBucketException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchBucketException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchBucketException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchBucketException {}
/// See [`NoSuchBucketException`](crate::error::NoSuchBucketException)
pub mod no_such_bucket_exception {
    /// A builder for [`NoSuchBucketException`](crate::error::NoSuchBucketException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchBucketException`](crate::error::NoSuchBucketException)
        pub fn build(self) -> crate::error::NoSuchBucketException {
            crate::error::NoSuchBucketException {
                message: self.message,
            }
        }
    }
}
impl NoSuchBucketException {
    /// Creates a new builder-style object to manufacture [`NoSuchBucketException`](crate::error::NoSuchBucketException)
    pub fn builder() -> crate::error::no_such_bucket_exception::Builder {
        crate::error::no_such_bucket_exception::Builder::default()
    }
}

/// <p>There are no configuration recorders available to provide the role needed to describe your resources. Create a configuration recorder.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoAvailableConfigurationRecorderException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoAvailableConfigurationRecorderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoAvailableConfigurationRecorderException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoAvailableConfigurationRecorderException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoAvailableConfigurationRecorderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoAvailableConfigurationRecorderException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoAvailableConfigurationRecorderException {}
/// See [`NoAvailableConfigurationRecorderException`](crate::error::NoAvailableConfigurationRecorderException)
pub mod no_available_configuration_recorder_exception {
    /// A builder for [`NoAvailableConfigurationRecorderException`](crate::error::NoAvailableConfigurationRecorderException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoAvailableConfigurationRecorderException`](crate::error::NoAvailableConfigurationRecorderException)
        pub fn build(self) -> crate::error::NoAvailableConfigurationRecorderException {
            crate::error::NoAvailableConfigurationRecorderException {
                message: self.message,
            }
        }
    }
}
impl NoAvailableConfigurationRecorderException {
    /// Creates a new builder-style object to manufacture [`NoAvailableConfigurationRecorderException`](crate::error::NoAvailableConfigurationRecorderException)
    pub fn builder() -> crate::error::no_available_configuration_recorder_exception::Builder {
        crate::error::no_available_configuration_recorder_exception::Builder::default()
    }
}

/// <p>You have reached the limit of the number of delivery channels you can create.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxNumberOfDeliveryChannelsExceededException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxNumberOfDeliveryChannelsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxNumberOfDeliveryChannelsExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxNumberOfDeliveryChannelsExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxNumberOfDeliveryChannelsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaxNumberOfDeliveryChannelsExceededException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxNumberOfDeliveryChannelsExceededException {}
/// See [`MaxNumberOfDeliveryChannelsExceededException`](crate::error::MaxNumberOfDeliveryChannelsExceededException)
pub mod max_number_of_delivery_channels_exceeded_exception {
    /// A builder for [`MaxNumberOfDeliveryChannelsExceededException`](crate::error::MaxNumberOfDeliveryChannelsExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxNumberOfDeliveryChannelsExceededException`](crate::error::MaxNumberOfDeliveryChannelsExceededException)
        pub fn build(self) -> crate::error::MaxNumberOfDeliveryChannelsExceededException {
            crate::error::MaxNumberOfDeliveryChannelsExceededException {
                message: self.message,
            }
        }
    }
}
impl MaxNumberOfDeliveryChannelsExceededException {
    /// Creates a new builder-style object to manufacture [`MaxNumberOfDeliveryChannelsExceededException`](crate::error::MaxNumberOfDeliveryChannelsExceededException)
    pub fn builder() -> crate::error::max_number_of_delivery_channels_exceeded_exception::Builder {
        crate::error::max_number_of_delivery_channels_exceeded_exception::Builder::default()
    }
}

/// <p>The specified Amazon SNS topic does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSnsTopicArnException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSnsTopicArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSnsTopicArnException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSnsTopicArnException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSnsTopicArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidSnsTopicArnException [InvalidSNSTopicARNException]"
        )?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSnsTopicArnException {}
/// See [`InvalidSnsTopicArnException`](crate::error::InvalidSnsTopicArnException)
pub mod invalid_sns_topic_arn_exception {
    /// A builder for [`InvalidSnsTopicArnException`](crate::error::InvalidSnsTopicArnException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSnsTopicArnException`](crate::error::InvalidSnsTopicArnException)
        pub fn build(self) -> crate::error::InvalidSnsTopicArnException {
            crate::error::InvalidSnsTopicArnException {
                message: self.message,
            }
        }
    }
}
impl InvalidSnsTopicArnException {
    /// Creates a new builder-style object to manufacture [`InvalidSnsTopicArnException`](crate::error::InvalidSnsTopicArnException)
    pub fn builder() -> crate::error::invalid_sns_topic_arn_exception::Builder {
        crate::error::invalid_sns_topic_arn_exception::Builder::default()
    }
}

/// <p>The specified Amazon KMS Key ARN is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidS3KmsKeyArnException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidS3KmsKeyArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidS3KmsKeyArnException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidS3KmsKeyArnException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidS3KmsKeyArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidS3KmsKeyArnException")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidS3KmsKeyArnException {}
/// See [`InvalidS3KmsKeyArnException`](crate::error::InvalidS3KmsKeyArnException)
pub mod invalid_s3_kms_key_arn_exception {
    /// A builder for [`InvalidS3KmsKeyArnException`](crate::error::InvalidS3KmsKeyArnException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidS3KmsKeyArnException`](crate::error::InvalidS3KmsKeyArnException)
        pub fn build(self) -> crate::error::InvalidS3KmsKeyArnException {
            crate::error::InvalidS3KmsKeyArnException {
                message: self.message,
            }
        }
    }
}
impl InvalidS3KmsKeyArnException {
    /// Creates a new builder-style object to manufacture [`InvalidS3KmsKeyArnException`](crate::error::InvalidS3KmsKeyArnException)
    pub fn builder() -> crate::error::invalid_s3_kms_key_arn_exception::Builder {
        crate::error::invalid_s3_kms_key_arn_exception::Builder::default()
    }
}

/// <p>The specified Amazon S3 key prefix is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidS3KeyPrefixException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidS3KeyPrefixException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidS3KeyPrefixException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidS3KeyPrefixException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidS3KeyPrefixException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidS3KeyPrefixException")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidS3KeyPrefixException {}
/// See [`InvalidS3KeyPrefixException`](crate::error::InvalidS3KeyPrefixException)
pub mod invalid_s3_key_prefix_exception {
    /// A builder for [`InvalidS3KeyPrefixException`](crate::error::InvalidS3KeyPrefixException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidS3KeyPrefixException`](crate::error::InvalidS3KeyPrefixException)
        pub fn build(self) -> crate::error::InvalidS3KeyPrefixException {
            crate::error::InvalidS3KeyPrefixException {
                message: self.message,
            }
        }
    }
}
impl InvalidS3KeyPrefixException {
    /// Creates a new builder-style object to manufacture [`InvalidS3KeyPrefixException`](crate::error::InvalidS3KeyPrefixException)
    pub fn builder() -> crate::error::invalid_s3_key_prefix_exception::Builder {
        crate::error::invalid_s3_key_prefix_exception::Builder::default()
    }
}

/// <p>The specified delivery channel name is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDeliveryChannelNameException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDeliveryChannelNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDeliveryChannelNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDeliveryChannelNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDeliveryChannelNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDeliveryChannelNameException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDeliveryChannelNameException {}
/// See [`InvalidDeliveryChannelNameException`](crate::error::InvalidDeliveryChannelNameException)
pub mod invalid_delivery_channel_name_exception {
    /// A builder for [`InvalidDeliveryChannelNameException`](crate::error::InvalidDeliveryChannelNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDeliveryChannelNameException`](crate::error::InvalidDeliveryChannelNameException)
        pub fn build(self) -> crate::error::InvalidDeliveryChannelNameException {
            crate::error::InvalidDeliveryChannelNameException {
                message: self.message,
            }
        }
    }
}
impl InvalidDeliveryChannelNameException {
    /// Creates a new builder-style object to manufacture [`InvalidDeliveryChannelNameException`](crate::error::InvalidDeliveryChannelNameException)
    pub fn builder() -> crate::error::invalid_delivery_channel_name_exception::Builder {
        crate::error::invalid_delivery_channel_name_exception::Builder::default()
    }
}

/// <p>Your Amazon S3 bucket policy does not permit Config to write to it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientDeliveryPolicyException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientDeliveryPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientDeliveryPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientDeliveryPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientDeliveryPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientDeliveryPolicyException")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientDeliveryPolicyException {}
/// See [`InsufficientDeliveryPolicyException`](crate::error::InsufficientDeliveryPolicyException)
pub mod insufficient_delivery_policy_exception {
    /// A builder for [`InsufficientDeliveryPolicyException`](crate::error::InsufficientDeliveryPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientDeliveryPolicyException`](crate::error::InsufficientDeliveryPolicyException)
        pub fn build(self) -> crate::error::InsufficientDeliveryPolicyException {
            crate::error::InsufficientDeliveryPolicyException {
                message: self.message,
            }
        }
    }
}
impl InsufficientDeliveryPolicyException {
    /// Creates a new builder-style object to manufacture [`InsufficientDeliveryPolicyException`](crate::error::InsufficientDeliveryPolicyException)
    pub fn builder() -> crate::error::insufficient_delivery_policy_exception::Builder {
        crate::error::insufficient_delivery_policy_exception::Builder::default()
    }
}

/// <p>You have reached the limit (6) of the number of conformance packs in an account (6 conformance pack with 25 Config rules per pack).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxNumberOfConformancePacksExceededException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxNumberOfConformancePacksExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxNumberOfConformancePacksExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxNumberOfConformancePacksExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxNumberOfConformancePacksExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaxNumberOfConformancePacksExceededException")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxNumberOfConformancePacksExceededException {}
/// See [`MaxNumberOfConformancePacksExceededException`](crate::error::MaxNumberOfConformancePacksExceededException)
pub mod max_number_of_conformance_packs_exceeded_exception {
    /// A builder for [`MaxNumberOfConformancePacksExceededException`](crate::error::MaxNumberOfConformancePacksExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxNumberOfConformancePacksExceededException`](crate::error::MaxNumberOfConformancePacksExceededException)
        pub fn build(self) -> crate::error::MaxNumberOfConformancePacksExceededException {
            crate::error::MaxNumberOfConformancePacksExceededException {
                message: self.message,
            }
        }
    }
}
impl MaxNumberOfConformancePacksExceededException {
    /// Creates a new builder-style object to manufacture [`MaxNumberOfConformancePacksExceededException`](crate::error::MaxNumberOfConformancePacksExceededException)
    pub fn builder() -> crate::error::max_number_of_conformance_packs_exceeded_exception::Builder {
        crate::error::max_number_of_conformance_packs_exceeded_exception::Builder::default()
    }
}

/// <p>You have specified a template that is not valid or supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConformancePackTemplateValidationException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConformancePackTemplateValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConformancePackTemplateValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConformancePackTemplateValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConformancePackTemplateValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConformancePackTemplateValidationException")?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConformancePackTemplateValidationException {}
/// See [`ConformancePackTemplateValidationException`](crate::error::ConformancePackTemplateValidationException)
pub mod conformance_pack_template_validation_exception {
    /// A builder for [`ConformancePackTemplateValidationException`](crate::error::ConformancePackTemplateValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConformancePackTemplateValidationException`](crate::error::ConformancePackTemplateValidationException)
        pub fn build(self) -> crate::error::ConformancePackTemplateValidationException {
            crate::error::ConformancePackTemplateValidationException {
                message: self.message,
            }
        }
    }
}
impl ConformancePackTemplateValidationException {
    /// Creates a new builder-style object to manufacture [`ConformancePackTemplateValidationException`](crate::error::ConformancePackTemplateValidationException)
    pub fn builder() -> crate::error::conformance_pack_template_validation_exception::Builder {
        crate::error::conformance_pack_template_validation_exception::Builder::default()
    }
}

/// <p>You have reached the limit of the number of recorders you can create.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxNumberOfConfigurationRecordersExceededException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxNumberOfConfigurationRecordersExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxNumberOfConfigurationRecordersExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxNumberOfConfigurationRecordersExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxNumberOfConfigurationRecordersExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaxNumberOfConfigurationRecordersExceededException")?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxNumberOfConfigurationRecordersExceededException {}
/// See [`MaxNumberOfConfigurationRecordersExceededException`](crate::error::MaxNumberOfConfigurationRecordersExceededException)
pub mod max_number_of_configuration_recorders_exceeded_exception {
    /// A builder for [`MaxNumberOfConfigurationRecordersExceededException`](crate::error::MaxNumberOfConfigurationRecordersExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxNumberOfConfigurationRecordersExceededException`](crate::error::MaxNumberOfConfigurationRecordersExceededException)
        pub fn build(self) -> crate::error::MaxNumberOfConfigurationRecordersExceededException {
            crate::error::MaxNumberOfConfigurationRecordersExceededException {
                message: self.message,
            }
        }
    }
}
impl MaxNumberOfConfigurationRecordersExceededException {
    /// Creates a new builder-style object to manufacture [`MaxNumberOfConfigurationRecordersExceededException`](crate::error::MaxNumberOfConfigurationRecordersExceededException)
    pub fn builder(
    ) -> crate::error::max_number_of_configuration_recorders_exceeded_exception::Builder {
        crate::error::max_number_of_configuration_recorders_exceeded_exception::Builder::default()
    }
}

/// <p>You have provided a null or empty role ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRoleException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRoleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRoleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRoleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRoleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRoleException")?;
        if let Some(inner_38) = &self.message {
            write!(f, ": {}", inner_38)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRoleException {}
/// See [`InvalidRoleException`](crate::error::InvalidRoleException)
pub mod invalid_role_exception {
    /// A builder for [`InvalidRoleException`](crate::error::InvalidRoleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRoleException`](crate::error::InvalidRoleException)
        pub fn build(self) -> crate::error::InvalidRoleException {
            crate::error::InvalidRoleException {
                message: self.message,
            }
        }
    }
}
impl InvalidRoleException {
    /// Creates a new builder-style object to manufacture [`InvalidRoleException`](crate::error::InvalidRoleException)
    pub fn builder() -> crate::error::invalid_role_exception::Builder {
        crate::error::invalid_role_exception::Builder::default()
    }
}

/// <p>Config throws an exception if the recording group does not contain a valid list of resource types. Invalid values might also be incorrectly formatted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRecordingGroupException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRecordingGroupException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRecordingGroupException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRecordingGroupException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRecordingGroupException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRecordingGroupException")?;
        if let Some(inner_39) = &self.message {
            write!(f, ": {}", inner_39)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRecordingGroupException {}
/// See [`InvalidRecordingGroupException`](crate::error::InvalidRecordingGroupException)
pub mod invalid_recording_group_exception {
    /// A builder for [`InvalidRecordingGroupException`](crate::error::InvalidRecordingGroupException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRecordingGroupException`](crate::error::InvalidRecordingGroupException)
        pub fn build(self) -> crate::error::InvalidRecordingGroupException {
            crate::error::InvalidRecordingGroupException {
                message: self.message,
            }
        }
    }
}
impl InvalidRecordingGroupException {
    /// Creates a new builder-style object to manufacture [`InvalidRecordingGroupException`](crate::error::InvalidRecordingGroupException)
    pub fn builder() -> crate::error::invalid_recording_group_exception::Builder {
        crate::error::invalid_recording_group_exception::Builder::default()
    }
}

/// <p>You have provided a configuration recorder name that is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidConfigurationRecorderNameException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidConfigurationRecorderNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidConfigurationRecorderNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidConfigurationRecorderNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidConfigurationRecorderNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidConfigurationRecorderNameException")?;
        if let Some(inner_40) = &self.message {
            write!(f, ": {}", inner_40)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidConfigurationRecorderNameException {}
/// See [`InvalidConfigurationRecorderNameException`](crate::error::InvalidConfigurationRecorderNameException)
pub mod invalid_configuration_recorder_name_exception {
    /// A builder for [`InvalidConfigurationRecorderNameException`](crate::error::InvalidConfigurationRecorderNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidConfigurationRecorderNameException`](crate::error::InvalidConfigurationRecorderNameException)
        pub fn build(self) -> crate::error::InvalidConfigurationRecorderNameException {
            crate::error::InvalidConfigurationRecorderNameException {
                message: self.message,
            }
        }
    }
}
impl InvalidConfigurationRecorderNameException {
    /// Creates a new builder-style object to manufacture [`InvalidConfigurationRecorderNameException`](crate::error::InvalidConfigurationRecorderNameException)
    pub fn builder() -> crate::error::invalid_configuration_recorder_name_exception::Builder {
        crate::error::invalid_configuration_recorder_name_exception::Builder::default()
    }
}

/// <p>Failed to add the Config rule because the account already contains the maximum number of 150 rules. Consider deleting any deactivated rules before you add new rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxNumberOfConfigRulesExceededException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxNumberOfConfigRulesExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxNumberOfConfigRulesExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxNumberOfConfigRulesExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxNumberOfConfigRulesExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaxNumberOfConfigRulesExceededException")?;
        if let Some(inner_41) = &self.message {
            write!(f, ": {}", inner_41)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxNumberOfConfigRulesExceededException {}
/// See [`MaxNumberOfConfigRulesExceededException`](crate::error::MaxNumberOfConfigRulesExceededException)
pub mod max_number_of_config_rules_exceeded_exception {
    /// A builder for [`MaxNumberOfConfigRulesExceededException`](crate::error::MaxNumberOfConfigRulesExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxNumberOfConfigRulesExceededException`](crate::error::MaxNumberOfConfigRulesExceededException)
        pub fn build(self) -> crate::error::MaxNumberOfConfigRulesExceededException {
            crate::error::MaxNumberOfConfigRulesExceededException {
                message: self.message,
            }
        }
    }
}
impl MaxNumberOfConfigRulesExceededException {
    /// Creates a new builder-style object to manufacture [`MaxNumberOfConfigRulesExceededException`](crate::error::MaxNumberOfConfigRulesExceededException)
    pub fn builder() -> crate::error::max_number_of_config_rules_exceeded_exception::Builder {
        crate::error::max_number_of_config_rules_exceeded_exception::Builder::default()
    }
}

/// <p>You have specified a resource that is either unknown or has not been discovered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotDiscoveredException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotDiscoveredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotDiscoveredException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotDiscoveredException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotDiscoveredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotDiscoveredException")?;
        if let Some(inner_42) = &self.message {
            write!(f, ": {}", inner_42)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotDiscoveredException {}
/// See [`ResourceNotDiscoveredException`](crate::error::ResourceNotDiscoveredException)
pub mod resource_not_discovered_exception {
    /// A builder for [`ResourceNotDiscoveredException`](crate::error::ResourceNotDiscoveredException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotDiscoveredException`](crate::error::ResourceNotDiscoveredException)
        pub fn build(self) -> crate::error::ResourceNotDiscoveredException {
            crate::error::ResourceNotDiscoveredException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotDiscoveredException {
    /// Creates a new builder-style object to manufacture [`ResourceNotDiscoveredException`](crate::error::ResourceNotDiscoveredException)
    pub fn builder() -> crate::error::resource_not_discovered_exception::Builder {
        crate::error::resource_not_discovered_exception::Builder::default()
    }
}

/// <p>The specified time range is not valid. The earlier time is not chronologically before the later time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTimeRangeException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTimeRangeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTimeRangeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTimeRangeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTimeRangeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTimeRangeException")?;
        if let Some(inner_43) = &self.message {
            write!(f, ": {}", inner_43)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTimeRangeException {}
/// See [`InvalidTimeRangeException`](crate::error::InvalidTimeRangeException)
pub mod invalid_time_range_exception {
    /// A builder for [`InvalidTimeRangeException`](crate::error::InvalidTimeRangeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTimeRangeException`](crate::error::InvalidTimeRangeException)
        pub fn build(self) -> crate::error::InvalidTimeRangeException {
            crate::error::InvalidTimeRangeException {
                message: self.message,
            }
        }
    }
}
impl InvalidTimeRangeException {
    /// Creates a new builder-style object to manufacture [`InvalidTimeRangeException`](crate::error::InvalidTimeRangeException)
    pub fn builder() -> crate::error::invalid_time_range_exception::Builder {
        crate::error::invalid_time_range_exception::Builder::default()
    }
}

/// <p>Config organization conformance pack that you passed in the filter does not exist.</p>
/// <p>For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchOrganizationConformancePackException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchOrganizationConformancePackException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchOrganizationConformancePackException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchOrganizationConformancePackException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchOrganizationConformancePackException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchOrganizationConformancePackException")?;
        if let Some(inner_44) = &self.message {
            write!(f, ": {}", inner_44)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchOrganizationConformancePackException {}
/// See [`NoSuchOrganizationConformancePackException`](crate::error::NoSuchOrganizationConformancePackException)
pub mod no_such_organization_conformance_pack_exception {
    /// A builder for [`NoSuchOrganizationConformancePackException`](crate::error::NoSuchOrganizationConformancePackException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchOrganizationConformancePackException`](crate::error::NoSuchOrganizationConformancePackException)
        pub fn build(self) -> crate::error::NoSuchOrganizationConformancePackException {
            crate::error::NoSuchOrganizationConformancePackException {
                message: self.message,
            }
        }
    }
}
impl NoSuchOrganizationConformancePackException {
    /// Creates a new builder-style object to manufacture [`NoSuchOrganizationConformancePackException`](crate::error::NoSuchOrganizationConformancePackException)
    pub fn builder() -> crate::error::no_such_organization_conformance_pack_exception::Builder {
        crate::error::no_such_organization_conformance_pack_exception::Builder::default()
    }
}

/// <p>You specified one or more organization config rules that do not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchOrganizationConfigRuleException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchOrganizationConfigRuleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchOrganizationConfigRuleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchOrganizationConfigRuleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchOrganizationConfigRuleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchOrganizationConfigRuleException")?;
        if let Some(inner_45) = &self.message {
            write!(f, ": {}", inner_45)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchOrganizationConfigRuleException {}
/// See [`NoSuchOrganizationConfigRuleException`](crate::error::NoSuchOrganizationConfigRuleException)
pub mod no_such_organization_config_rule_exception {
    /// A builder for [`NoSuchOrganizationConfigRuleException`](crate::error::NoSuchOrganizationConfigRuleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchOrganizationConfigRuleException`](crate::error::NoSuchOrganizationConfigRuleException)
        pub fn build(self) -> crate::error::NoSuchOrganizationConfigRuleException {
            crate::error::NoSuchOrganizationConfigRuleException {
                message: self.message,
            }
        }
    }
}
impl NoSuchOrganizationConfigRuleException {
    /// Creates a new builder-style object to manufacture [`NoSuchOrganizationConfigRuleException`](crate::error::NoSuchOrganizationConfigRuleException)
    pub fn builder() -> crate::error::no_such_organization_config_rule_exception::Builder {
        crate::error::no_such_organization_config_rule_exception::Builder::default()
    }
}

/// <p>You specified one or more conformance packs that do not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchConformancePackException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchConformancePackException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchConformancePackException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchConformancePackException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchConformancePackException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchConformancePackException")?;
        if let Some(inner_46) = &self.message {
            write!(f, ": {}", inner_46)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchConformancePackException {}
/// See [`NoSuchConformancePackException`](crate::error::NoSuchConformancePackException)
pub mod no_such_conformance_pack_exception {
    /// A builder for [`NoSuchConformancePackException`](crate::error::NoSuchConformancePackException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchConformancePackException`](crate::error::NoSuchConformancePackException)
        pub fn build(self) -> crate::error::NoSuchConformancePackException {
            crate::error::NoSuchConformancePackException {
                message: self.message,
            }
        }
    }
}
impl NoSuchConformancePackException {
    /// Creates a new builder-style object to manufacture [`NoSuchConformancePackException`](crate::error::NoSuchConformancePackException)
    pub fn builder() -> crate::error::no_such_conformance_pack_exception::Builder {
        crate::error::no_such_conformance_pack_exception::Builder::default()
    }
}

/// <p>Config rule that you passed in the filter does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchConfigRuleInConformancePackException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchConfigRuleInConformancePackException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchConfigRuleInConformancePackException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchConfigRuleInConformancePackException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchConfigRuleInConformancePackException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchConfigRuleInConformancePackException")?;
        if let Some(inner_47) = &self.message {
            write!(f, ": {}", inner_47)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchConfigRuleInConformancePackException {}
/// See [`NoSuchConfigRuleInConformancePackException`](crate::error::NoSuchConfigRuleInConformancePackException)
pub mod no_such_config_rule_in_conformance_pack_exception {
    /// A builder for [`NoSuchConfigRuleInConformancePackException`](crate::error::NoSuchConfigRuleInConformancePackException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchConfigRuleInConformancePackException`](crate::error::NoSuchConfigRuleInConformancePackException)
        pub fn build(self) -> crate::error::NoSuchConfigRuleInConformancePackException {
            crate::error::NoSuchConfigRuleInConformancePackException {
                message: self.message,
            }
        }
    }
}
impl NoSuchConfigRuleInConformancePackException {
    /// Creates a new builder-style object to manufacture [`NoSuchConfigRuleInConformancePackException`](crate::error::NoSuchConfigRuleInConformancePackException)
    pub fn builder() -> crate::error::no_such_config_rule_in_conformance_pack_exception::Builder {
        crate::error::no_such_config_rule_in_conformance_pack_exception::Builder::default()
    }
}

/// <p>The configuration item size is outside the allowable range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OversizedConfigurationItemException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OversizedConfigurationItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OversizedConfigurationItemException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OversizedConfigurationItemException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OversizedConfigurationItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OversizedConfigurationItemException")?;
        if let Some(inner_48) = &self.message {
            write!(f, ": {}", inner_48)?;
        }
        Ok(())
    }
}
impl std::error::Error for OversizedConfigurationItemException {}
/// See [`OversizedConfigurationItemException`](crate::error::OversizedConfigurationItemException)
pub mod oversized_configuration_item_exception {
    /// A builder for [`OversizedConfigurationItemException`](crate::error::OversizedConfigurationItemException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OversizedConfigurationItemException`](crate::error::OversizedConfigurationItemException)
        pub fn build(self) -> crate::error::OversizedConfigurationItemException {
            crate::error::OversizedConfigurationItemException {
                message: self.message,
            }
        }
    }
}
impl OversizedConfigurationItemException {
    /// Creates a new builder-style object to manufacture [`OversizedConfigurationItemException`](crate::error::OversizedConfigurationItemException)
    pub fn builder() -> crate::error::oversized_configuration_item_exception::Builder {
        crate::error::oversized_configuration_item_exception::Builder::default()
    }
}

/// <p>You have specified a retention configuration that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchRetentionConfigurationException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchRetentionConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchRetentionConfigurationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchRetentionConfigurationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchRetentionConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchRetentionConfigurationException")?;
        if let Some(inner_49) = &self.message {
            write!(f, ": {}", inner_49)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchRetentionConfigurationException {}
/// See [`NoSuchRetentionConfigurationException`](crate::error::NoSuchRetentionConfigurationException)
pub mod no_such_retention_configuration_exception {
    /// A builder for [`NoSuchRetentionConfigurationException`](crate::error::NoSuchRetentionConfigurationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchRetentionConfigurationException`](crate::error::NoSuchRetentionConfigurationException)
        pub fn build(self) -> crate::error::NoSuchRetentionConfigurationException {
            crate::error::NoSuchRetentionConfigurationException {
                message: self.message,
            }
        }
    }
}
impl NoSuchRetentionConfigurationException {
    /// Creates a new builder-style object to manufacture [`NoSuchRetentionConfigurationException`](crate::error::NoSuchRetentionConfigurationException)
    pub fn builder() -> crate::error::no_such_retention_configuration_exception::Builder {
        crate::error::no_such_retention_configuration_exception::Builder::default()
    }
}

/// <p>You have specified a delivery channel that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchDeliveryChannelException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchDeliveryChannelException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchDeliveryChannelException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchDeliveryChannelException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchDeliveryChannelException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchDeliveryChannelException")?;
        if let Some(inner_50) = &self.message {
            write!(f, ": {}", inner_50)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchDeliveryChannelException {}
/// See [`NoSuchDeliveryChannelException`](crate::error::NoSuchDeliveryChannelException)
pub mod no_such_delivery_channel_exception {
    /// A builder for [`NoSuchDeliveryChannelException`](crate::error::NoSuchDeliveryChannelException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchDeliveryChannelException`](crate::error::NoSuchDeliveryChannelException)
        pub fn build(self) -> crate::error::NoSuchDeliveryChannelException {
            crate::error::NoSuchDeliveryChannelException {
                message: self.message,
            }
        }
    }
}
impl NoSuchDeliveryChannelException {
    /// Creates a new builder-style object to manufacture [`NoSuchDeliveryChannelException`](crate::error::NoSuchDeliveryChannelException)
    pub fn builder() -> crate::error::no_such_delivery_channel_exception::Builder {
        crate::error::no_such_delivery_channel_exception::Builder::default()
    }
}

/// <p>You tried to delete a remediation exception that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchRemediationExceptionException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchRemediationExceptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchRemediationExceptionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchRemediationExceptionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchRemediationExceptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchRemediationExceptionException")?;
        if let Some(inner_51) = &self.message {
            write!(f, ": {}", inner_51)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchRemediationExceptionException {}
/// See [`NoSuchRemediationExceptionException`](crate::error::NoSuchRemediationExceptionException)
pub mod no_such_remediation_exception_exception {
    /// A builder for [`NoSuchRemediationExceptionException`](crate::error::NoSuchRemediationExceptionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchRemediationExceptionException`](crate::error::NoSuchRemediationExceptionException)
        pub fn build(self) -> crate::error::NoSuchRemediationExceptionException {
            crate::error::NoSuchRemediationExceptionException {
                message: self.message,
            }
        }
    }
}
impl NoSuchRemediationExceptionException {
    /// Creates a new builder-style object to manufacture [`NoSuchRemediationExceptionException`](crate::error::NoSuchRemediationExceptionException)
    pub fn builder() -> crate::error::no_such_remediation_exception_exception::Builder {
        crate::error::no_such_remediation_exception_exception::Builder::default()
    }
}

/// <p>Remediation action is in progress. You can either cancel execution in Amazon Web Services Systems Manager or wait and try again later. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemediationInProgressException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemediationInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemediationInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RemediationInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RemediationInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RemediationInProgressException")?;
        if let Some(inner_52) = &self.message {
            write!(f, ": {}", inner_52)?;
        }
        Ok(())
    }
}
impl std::error::Error for RemediationInProgressException {}
/// See [`RemediationInProgressException`](crate::error::RemediationInProgressException)
pub mod remediation_in_progress_exception {
    /// A builder for [`RemediationInProgressException`](crate::error::RemediationInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RemediationInProgressException`](crate::error::RemediationInProgressException)
        pub fn build(self) -> crate::error::RemediationInProgressException {
            crate::error::RemediationInProgressException {
                message: self.message,
            }
        }
    }
}
impl RemediationInProgressException {
    /// Creates a new builder-style object to manufacture [`RemediationInProgressException`](crate::error::RemediationInProgressException)
    pub fn builder() -> crate::error::remediation_in_progress_exception::Builder {
        crate::error::remediation_in_progress_exception::Builder::default()
    }
}

/// <p>You cannot delete the delivery channel you specified because the configuration recorder is running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LastDeliveryChannelDeleteFailedException {
    /// <p>Error executing the command</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LastDeliveryChannelDeleteFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LastDeliveryChannelDeleteFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LastDeliveryChannelDeleteFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LastDeliveryChannelDeleteFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LastDeliveryChannelDeleteFailedException")?;
        if let Some(inner_53) = &self.message {
            write!(f, ": {}", inner_53)?;
        }
        Ok(())
    }
}
impl std::error::Error for LastDeliveryChannelDeleteFailedException {}
/// See [`LastDeliveryChannelDeleteFailedException`](crate::error::LastDeliveryChannelDeleteFailedException)
pub mod last_delivery_channel_delete_failed_exception {
    /// A builder for [`LastDeliveryChannelDeleteFailedException`](crate::error::LastDeliveryChannelDeleteFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error executing the command</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error executing the command</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LastDeliveryChannelDeleteFailedException`](crate::error::LastDeliveryChannelDeleteFailedException)
        pub fn build(self) -> crate::error::LastDeliveryChannelDeleteFailedException {
            crate::error::LastDeliveryChannelDeleteFailedException {
                message: self.message,
            }
        }
    }
}
impl LastDeliveryChannelDeleteFailedException {
    /// Creates a new builder-style object to manufacture [`LastDeliveryChannelDeleteFailedException`](crate::error::LastDeliveryChannelDeleteFailedException)
    pub fn builder() -> crate::error::last_delivery_channel_delete_failed_exception::Builder {
        crate::error::last_delivery_channel_delete_failed_exception::Builder::default()
    }
}
