// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Config
///
/// Client for invoking operations on AWS Config. Each operation on AWS Config is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_config::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_config::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_config::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchGetAggregateResourceConfig` operation.
    ///
    /// See [`BatchGetAggregateResourceConfig`](crate::client::fluent_builders::BatchGetAggregateResourceConfig) for more information about the
    /// operation and its arguments.
    pub fn batch_get_aggregate_resource_config(
        &self,
    ) -> fluent_builders::BatchGetAggregateResourceConfig<C, M, R> {
        fluent_builders::BatchGetAggregateResourceConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetResourceConfig` operation.
    ///
    /// See [`BatchGetResourceConfig`](crate::client::fluent_builders::BatchGetResourceConfig) for more information about the
    /// operation and its arguments.
    pub fn batch_get_resource_config(&self) -> fluent_builders::BatchGetResourceConfig<C, M, R> {
        fluent_builders::BatchGetResourceConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAggregationAuthorization` operation.
    ///
    /// See [`DeleteAggregationAuthorization`](crate::client::fluent_builders::DeleteAggregationAuthorization) for more information about the
    /// operation and its arguments.
    pub fn delete_aggregation_authorization(
        &self,
    ) -> fluent_builders::DeleteAggregationAuthorization<C, M, R> {
        fluent_builders::DeleteAggregationAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConfigRule` operation.
    ///
    /// See [`DeleteConfigRule`](crate::client::fluent_builders::DeleteConfigRule) for more information about the
    /// operation and its arguments.
    pub fn delete_config_rule(&self) -> fluent_builders::DeleteConfigRule<C, M, R> {
        fluent_builders::DeleteConfigRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConfigurationAggregator` operation.
    ///
    /// See [`DeleteConfigurationAggregator`](crate::client::fluent_builders::DeleteConfigurationAggregator) for more information about the
    /// operation and its arguments.
    pub fn delete_configuration_aggregator(
        &self,
    ) -> fluent_builders::DeleteConfigurationAggregator<C, M, R> {
        fluent_builders::DeleteConfigurationAggregator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConfigurationRecorder` operation.
    ///
    /// See [`DeleteConfigurationRecorder`](crate::client::fluent_builders::DeleteConfigurationRecorder) for more information about the
    /// operation and its arguments.
    pub fn delete_configuration_recorder(
        &self,
    ) -> fluent_builders::DeleteConfigurationRecorder<C, M, R> {
        fluent_builders::DeleteConfigurationRecorder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConformancePack` operation.
    ///
    /// See [`DeleteConformancePack`](crate::client::fluent_builders::DeleteConformancePack) for more information about the
    /// operation and its arguments.
    pub fn delete_conformance_pack(&self) -> fluent_builders::DeleteConformancePack<C, M, R> {
        fluent_builders::DeleteConformancePack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDeliveryChannel` operation.
    ///
    /// See [`DeleteDeliveryChannel`](crate::client::fluent_builders::DeleteDeliveryChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_delivery_channel(&self) -> fluent_builders::DeleteDeliveryChannel<C, M, R> {
        fluent_builders::DeleteDeliveryChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEvaluationResults` operation.
    ///
    /// See [`DeleteEvaluationResults`](crate::client::fluent_builders::DeleteEvaluationResults) for more information about the
    /// operation and its arguments.
    pub fn delete_evaluation_results(&self) -> fluent_builders::DeleteEvaluationResults<C, M, R> {
        fluent_builders::DeleteEvaluationResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOrganizationConfigRule` operation.
    ///
    /// See [`DeleteOrganizationConfigRule`](crate::client::fluent_builders::DeleteOrganizationConfigRule) for more information about the
    /// operation and its arguments.
    pub fn delete_organization_config_rule(
        &self,
    ) -> fluent_builders::DeleteOrganizationConfigRule<C, M, R> {
        fluent_builders::DeleteOrganizationConfigRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOrganizationConformancePack` operation.
    ///
    /// See [`DeleteOrganizationConformancePack`](crate::client::fluent_builders::DeleteOrganizationConformancePack) for more information about the
    /// operation and its arguments.
    pub fn delete_organization_conformance_pack(
        &self,
    ) -> fluent_builders::DeleteOrganizationConformancePack<C, M, R> {
        fluent_builders::DeleteOrganizationConformancePack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePendingAggregationRequest` operation.
    ///
    /// See [`DeletePendingAggregationRequest`](crate::client::fluent_builders::DeletePendingAggregationRequest) for more information about the
    /// operation and its arguments.
    pub fn delete_pending_aggregation_request(
        &self,
    ) -> fluent_builders::DeletePendingAggregationRequest<C, M, R> {
        fluent_builders::DeletePendingAggregationRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRemediationConfiguration` operation.
    ///
    /// See [`DeleteRemediationConfiguration`](crate::client::fluent_builders::DeleteRemediationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_remediation_configuration(
        &self,
    ) -> fluent_builders::DeleteRemediationConfiguration<C, M, R> {
        fluent_builders::DeleteRemediationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRemediationExceptions` operation.
    ///
    /// See [`DeleteRemediationExceptions`](crate::client::fluent_builders::DeleteRemediationExceptions) for more information about the
    /// operation and its arguments.
    pub fn delete_remediation_exceptions(
        &self,
    ) -> fluent_builders::DeleteRemediationExceptions<C, M, R> {
        fluent_builders::DeleteRemediationExceptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourceConfig` operation.
    ///
    /// See [`DeleteResourceConfig`](crate::client::fluent_builders::DeleteResourceConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_config(&self) -> fluent_builders::DeleteResourceConfig<C, M, R> {
        fluent_builders::DeleteResourceConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRetentionConfiguration` operation.
    ///
    /// See [`DeleteRetentionConfiguration`](crate::client::fluent_builders::DeleteRetentionConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_retention_configuration(
        &self,
    ) -> fluent_builders::DeleteRetentionConfiguration<C, M, R> {
        fluent_builders::DeleteRetentionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStoredQuery` operation.
    ///
    /// See [`DeleteStoredQuery`](crate::client::fluent_builders::DeleteStoredQuery) for more information about the
    /// operation and its arguments.
    pub fn delete_stored_query(&self) -> fluent_builders::DeleteStoredQuery<C, M, R> {
        fluent_builders::DeleteStoredQuery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeliverConfigSnapshot` operation.
    ///
    /// See [`DeliverConfigSnapshot`](crate::client::fluent_builders::DeliverConfigSnapshot) for more information about the
    /// operation and its arguments.
    pub fn deliver_config_snapshot(&self) -> fluent_builders::DeliverConfigSnapshot<C, M, R> {
        fluent_builders::DeliverConfigSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAggregateComplianceByConfigRules` operation.
    ///
    /// See [`DescribeAggregateComplianceByConfigRules`](crate::client::fluent_builders::DescribeAggregateComplianceByConfigRules) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeAggregateComplianceByConfigRules::into_paginator).
    pub fn describe_aggregate_compliance_by_config_rules(
        &self,
    ) -> fluent_builders::DescribeAggregateComplianceByConfigRules<C, M, R> {
        fluent_builders::DescribeAggregateComplianceByConfigRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAggregateComplianceByConformancePacks` operation.
    ///
    /// See [`DescribeAggregateComplianceByConformancePacks`](crate::client::fluent_builders::DescribeAggregateComplianceByConformancePacks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeAggregateComplianceByConformancePacks::into_paginator).
    pub fn describe_aggregate_compliance_by_conformance_packs(
        &self,
    ) -> fluent_builders::DescribeAggregateComplianceByConformancePacks<C, M, R> {
        fluent_builders::DescribeAggregateComplianceByConformancePacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAggregationAuthorizations` operation.
    ///
    /// See [`DescribeAggregationAuthorizations`](crate::client::fluent_builders::DescribeAggregationAuthorizations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeAggregationAuthorizations::into_paginator).
    pub fn describe_aggregation_authorizations(
        &self,
    ) -> fluent_builders::DescribeAggregationAuthorizations<C, M, R> {
        fluent_builders::DescribeAggregationAuthorizations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeComplianceByConfigRule` operation.
    ///
    /// See [`DescribeComplianceByConfigRule`](crate::client::fluent_builders::DescribeComplianceByConfigRule) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeComplianceByConfigRule::into_paginator).
    pub fn describe_compliance_by_config_rule(
        &self,
    ) -> fluent_builders::DescribeComplianceByConfigRule<C, M, R> {
        fluent_builders::DescribeComplianceByConfigRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeComplianceByResource` operation.
    ///
    /// See [`DescribeComplianceByResource`](crate::client::fluent_builders::DescribeComplianceByResource) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeComplianceByResource::into_paginator).
    pub fn describe_compliance_by_resource(
        &self,
    ) -> fluent_builders::DescribeComplianceByResource<C, M, R> {
        fluent_builders::DescribeComplianceByResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfigRuleEvaluationStatus` operation.
    ///
    /// See [`DescribeConfigRuleEvaluationStatus`](crate::client::fluent_builders::DescribeConfigRuleEvaluationStatus) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeConfigRuleEvaluationStatus::into_paginator).
    pub fn describe_config_rule_evaluation_status(
        &self,
    ) -> fluent_builders::DescribeConfigRuleEvaluationStatus<C, M, R> {
        fluent_builders::DescribeConfigRuleEvaluationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfigRules` operation.
    ///
    /// See [`DescribeConfigRules`](crate::client::fluent_builders::DescribeConfigRules) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeConfigRules::into_paginator).
    pub fn describe_config_rules(&self) -> fluent_builders::DescribeConfigRules<C, M, R> {
        fluent_builders::DescribeConfigRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfigurationAggregators` operation.
    ///
    /// See [`DescribeConfigurationAggregators`](crate::client::fluent_builders::DescribeConfigurationAggregators) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeConfigurationAggregators::into_paginator).
    pub fn describe_configuration_aggregators(
        &self,
    ) -> fluent_builders::DescribeConfigurationAggregators<C, M, R> {
        fluent_builders::DescribeConfigurationAggregators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfigurationAggregatorSourcesStatus` operation.
    ///
    /// See [`DescribeConfigurationAggregatorSourcesStatus`](crate::client::fluent_builders::DescribeConfigurationAggregatorSourcesStatus) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeConfigurationAggregatorSourcesStatus::into_paginator).
    pub fn describe_configuration_aggregator_sources_status(
        &self,
    ) -> fluent_builders::DescribeConfigurationAggregatorSourcesStatus<C, M, R> {
        fluent_builders::DescribeConfigurationAggregatorSourcesStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfigurationRecorders` operation.
    ///
    /// See [`DescribeConfigurationRecorders`](crate::client::fluent_builders::DescribeConfigurationRecorders) for more information about the
    /// operation and its arguments.
    pub fn describe_configuration_recorders(
        &self,
    ) -> fluent_builders::DescribeConfigurationRecorders<C, M, R> {
        fluent_builders::DescribeConfigurationRecorders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfigurationRecorderStatus` operation.
    ///
    /// See [`DescribeConfigurationRecorderStatus`](crate::client::fluent_builders::DescribeConfigurationRecorderStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_configuration_recorder_status(
        &self,
    ) -> fluent_builders::DescribeConfigurationRecorderStatus<C, M, R> {
        fluent_builders::DescribeConfigurationRecorderStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConformancePackCompliance` operation.
    ///
    /// See [`DescribeConformancePackCompliance`](crate::client::fluent_builders::DescribeConformancePackCompliance) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeConformancePackCompliance::into_paginator).
    pub fn describe_conformance_pack_compliance(
        &self,
    ) -> fluent_builders::DescribeConformancePackCompliance<C, M, R> {
        fluent_builders::DescribeConformancePackCompliance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConformancePacks` operation.
    ///
    /// See [`DescribeConformancePacks`](crate::client::fluent_builders::DescribeConformancePacks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeConformancePacks::into_paginator).
    pub fn describe_conformance_packs(&self) -> fluent_builders::DescribeConformancePacks<C, M, R> {
        fluent_builders::DescribeConformancePacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConformancePackStatus` operation.
    ///
    /// See [`DescribeConformancePackStatus`](crate::client::fluent_builders::DescribeConformancePackStatus) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeConformancePackStatus::into_paginator).
    pub fn describe_conformance_pack_status(
        &self,
    ) -> fluent_builders::DescribeConformancePackStatus<C, M, R> {
        fluent_builders::DescribeConformancePackStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDeliveryChannels` operation.
    ///
    /// See [`DescribeDeliveryChannels`](crate::client::fluent_builders::DescribeDeliveryChannels) for more information about the
    /// operation and its arguments.
    pub fn describe_delivery_channels(&self) -> fluent_builders::DescribeDeliveryChannels<C, M, R> {
        fluent_builders::DescribeDeliveryChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDeliveryChannelStatus` operation.
    ///
    /// See [`DescribeDeliveryChannelStatus`](crate::client::fluent_builders::DescribeDeliveryChannelStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_delivery_channel_status(
        &self,
    ) -> fluent_builders::DescribeDeliveryChannelStatus<C, M, R> {
        fluent_builders::DescribeDeliveryChannelStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganizationConfigRules` operation.
    ///
    /// See [`DescribeOrganizationConfigRules`](crate::client::fluent_builders::DescribeOrganizationConfigRules) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeOrganizationConfigRules::into_paginator).
    pub fn describe_organization_config_rules(
        &self,
    ) -> fluent_builders::DescribeOrganizationConfigRules<C, M, R> {
        fluent_builders::DescribeOrganizationConfigRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganizationConfigRuleStatuses` operation.
    ///
    /// See [`DescribeOrganizationConfigRuleStatuses`](crate::client::fluent_builders::DescribeOrganizationConfigRuleStatuses) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeOrganizationConfigRuleStatuses::into_paginator).
    pub fn describe_organization_config_rule_statuses(
        &self,
    ) -> fluent_builders::DescribeOrganizationConfigRuleStatuses<C, M, R> {
        fluent_builders::DescribeOrganizationConfigRuleStatuses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganizationConformancePacks` operation.
    ///
    /// See [`DescribeOrganizationConformancePacks`](crate::client::fluent_builders::DescribeOrganizationConformancePacks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeOrganizationConformancePacks::into_paginator).
    pub fn describe_organization_conformance_packs(
        &self,
    ) -> fluent_builders::DescribeOrganizationConformancePacks<C, M, R> {
        fluent_builders::DescribeOrganizationConformancePacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganizationConformancePackStatuses` operation.
    ///
    /// See [`DescribeOrganizationConformancePackStatuses`](crate::client::fluent_builders::DescribeOrganizationConformancePackStatuses) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeOrganizationConformancePackStatuses::into_paginator).
    pub fn describe_organization_conformance_pack_statuses(
        &self,
    ) -> fluent_builders::DescribeOrganizationConformancePackStatuses<C, M, R> {
        fluent_builders::DescribeOrganizationConformancePackStatuses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePendingAggregationRequests` operation.
    ///
    /// See [`DescribePendingAggregationRequests`](crate::client::fluent_builders::DescribePendingAggregationRequests) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribePendingAggregationRequests::into_paginator).
    pub fn describe_pending_aggregation_requests(
        &self,
    ) -> fluent_builders::DescribePendingAggregationRequests<C, M, R> {
        fluent_builders::DescribePendingAggregationRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRemediationConfigurations` operation.
    ///
    /// See [`DescribeRemediationConfigurations`](crate::client::fluent_builders::DescribeRemediationConfigurations) for more information about the
    /// operation and its arguments.
    pub fn describe_remediation_configurations(
        &self,
    ) -> fluent_builders::DescribeRemediationConfigurations<C, M, R> {
        fluent_builders::DescribeRemediationConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRemediationExceptions` operation.
    ///
    /// See [`DescribeRemediationExceptions`](crate::client::fluent_builders::DescribeRemediationExceptions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeRemediationExceptions::into_paginator).
    pub fn describe_remediation_exceptions(
        &self,
    ) -> fluent_builders::DescribeRemediationExceptions<C, M, R> {
        fluent_builders::DescribeRemediationExceptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRemediationExecutionStatus` operation.
    ///
    /// See [`DescribeRemediationExecutionStatus`](crate::client::fluent_builders::DescribeRemediationExecutionStatus) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeRemediationExecutionStatus::into_paginator).
    pub fn describe_remediation_execution_status(
        &self,
    ) -> fluent_builders::DescribeRemediationExecutionStatus<C, M, R> {
        fluent_builders::DescribeRemediationExecutionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRetentionConfigurations` operation.
    ///
    /// See [`DescribeRetentionConfigurations`](crate::client::fluent_builders::DescribeRetentionConfigurations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeRetentionConfigurations::into_paginator).
    pub fn describe_retention_configurations(
        &self,
    ) -> fluent_builders::DescribeRetentionConfigurations<C, M, R> {
        fluent_builders::DescribeRetentionConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAggregateComplianceDetailsByConfigRule` operation.
    ///
    /// See [`GetAggregateComplianceDetailsByConfigRule`](crate::client::fluent_builders::GetAggregateComplianceDetailsByConfigRule) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetAggregateComplianceDetailsByConfigRule::into_paginator).
    pub fn get_aggregate_compliance_details_by_config_rule(
        &self,
    ) -> fluent_builders::GetAggregateComplianceDetailsByConfigRule<C, M, R> {
        fluent_builders::GetAggregateComplianceDetailsByConfigRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAggregateConfigRuleComplianceSummary` operation.
    ///
    /// See [`GetAggregateConfigRuleComplianceSummary`](crate::client::fluent_builders::GetAggregateConfigRuleComplianceSummary) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetAggregateConfigRuleComplianceSummary::into_paginator).
    pub fn get_aggregate_config_rule_compliance_summary(
        &self,
    ) -> fluent_builders::GetAggregateConfigRuleComplianceSummary<C, M, R> {
        fluent_builders::GetAggregateConfigRuleComplianceSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAggregateConformancePackComplianceSummary` operation.
    ///
    /// See [`GetAggregateConformancePackComplianceSummary`](crate::client::fluent_builders::GetAggregateConformancePackComplianceSummary) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetAggregateConformancePackComplianceSummary::into_paginator).
    pub fn get_aggregate_conformance_pack_compliance_summary(
        &self,
    ) -> fluent_builders::GetAggregateConformancePackComplianceSummary<C, M, R> {
        fluent_builders::GetAggregateConformancePackComplianceSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAggregateDiscoveredResourceCounts` operation.
    ///
    /// See [`GetAggregateDiscoveredResourceCounts`](crate::client::fluent_builders::GetAggregateDiscoveredResourceCounts) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetAggregateDiscoveredResourceCounts::into_paginator).
    pub fn get_aggregate_discovered_resource_counts(
        &self,
    ) -> fluent_builders::GetAggregateDiscoveredResourceCounts<C, M, R> {
        fluent_builders::GetAggregateDiscoveredResourceCounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAggregateResourceConfig` operation.
    ///
    /// See [`GetAggregateResourceConfig`](crate::client::fluent_builders::GetAggregateResourceConfig) for more information about the
    /// operation and its arguments.
    pub fn get_aggregate_resource_config(
        &self,
    ) -> fluent_builders::GetAggregateResourceConfig<C, M, R> {
        fluent_builders::GetAggregateResourceConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetComplianceDetailsByConfigRule` operation.
    ///
    /// See [`GetComplianceDetailsByConfigRule`](crate::client::fluent_builders::GetComplianceDetailsByConfigRule) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetComplianceDetailsByConfigRule::into_paginator).
    pub fn get_compliance_details_by_config_rule(
        &self,
    ) -> fluent_builders::GetComplianceDetailsByConfigRule<C, M, R> {
        fluent_builders::GetComplianceDetailsByConfigRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetComplianceDetailsByResource` operation.
    ///
    /// See [`GetComplianceDetailsByResource`](crate::client::fluent_builders::GetComplianceDetailsByResource) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetComplianceDetailsByResource::into_paginator).
    pub fn get_compliance_details_by_resource(
        &self,
    ) -> fluent_builders::GetComplianceDetailsByResource<C, M, R> {
        fluent_builders::GetComplianceDetailsByResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetComplianceSummaryByConfigRule` operation.
    ///
    /// See [`GetComplianceSummaryByConfigRule`](crate::client::fluent_builders::GetComplianceSummaryByConfigRule) for more information about the
    /// operation and its arguments.
    pub fn get_compliance_summary_by_config_rule(
        &self,
    ) -> fluent_builders::GetComplianceSummaryByConfigRule<C, M, R> {
        fluent_builders::GetComplianceSummaryByConfigRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetComplianceSummaryByResourceType` operation.
    ///
    /// See [`GetComplianceSummaryByResourceType`](crate::client::fluent_builders::GetComplianceSummaryByResourceType) for more information about the
    /// operation and its arguments.
    pub fn get_compliance_summary_by_resource_type(
        &self,
    ) -> fluent_builders::GetComplianceSummaryByResourceType<C, M, R> {
        fluent_builders::GetComplianceSummaryByResourceType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConformancePackComplianceDetails` operation.
    ///
    /// See [`GetConformancePackComplianceDetails`](crate::client::fluent_builders::GetConformancePackComplianceDetails) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetConformancePackComplianceDetails::into_paginator).
    pub fn get_conformance_pack_compliance_details(
        &self,
    ) -> fluent_builders::GetConformancePackComplianceDetails<C, M, R> {
        fluent_builders::GetConformancePackComplianceDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConformancePackComplianceSummary` operation.
    ///
    /// See [`GetConformancePackComplianceSummary`](crate::client::fluent_builders::GetConformancePackComplianceSummary) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetConformancePackComplianceSummary::into_paginator).
    pub fn get_conformance_pack_compliance_summary(
        &self,
    ) -> fluent_builders::GetConformancePackComplianceSummary<C, M, R> {
        fluent_builders::GetConformancePackComplianceSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDiscoveredResourceCounts` operation.
    ///
    /// See [`GetDiscoveredResourceCounts`](crate::client::fluent_builders::GetDiscoveredResourceCounts) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetDiscoveredResourceCounts::into_paginator).
    pub fn get_discovered_resource_counts(
        &self,
    ) -> fluent_builders::GetDiscoveredResourceCounts<C, M, R> {
        fluent_builders::GetDiscoveredResourceCounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOrganizationConfigRuleDetailedStatus` operation.
    ///
    /// See [`GetOrganizationConfigRuleDetailedStatus`](crate::client::fluent_builders::GetOrganizationConfigRuleDetailedStatus) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetOrganizationConfigRuleDetailedStatus::into_paginator).
    pub fn get_organization_config_rule_detailed_status(
        &self,
    ) -> fluent_builders::GetOrganizationConfigRuleDetailedStatus<C, M, R> {
        fluent_builders::GetOrganizationConfigRuleDetailedStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOrganizationConformancePackDetailedStatus` operation.
    ///
    /// See [`GetOrganizationConformancePackDetailedStatus`](crate::client::fluent_builders::GetOrganizationConformancePackDetailedStatus) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetOrganizationConformancePackDetailedStatus::into_paginator).
    pub fn get_organization_conformance_pack_detailed_status(
        &self,
    ) -> fluent_builders::GetOrganizationConformancePackDetailedStatus<C, M, R> {
        fluent_builders::GetOrganizationConformancePackDetailedStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourceConfigHistory` operation.
    ///
    /// See [`GetResourceConfigHistory`](crate::client::fluent_builders::GetResourceConfigHistory) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetResourceConfigHistory::into_paginator).
    pub fn get_resource_config_history(
        &self,
    ) -> fluent_builders::GetResourceConfigHistory<C, M, R> {
        fluent_builders::GetResourceConfigHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStoredQuery` operation.
    ///
    /// See [`GetStoredQuery`](crate::client::fluent_builders::GetStoredQuery) for more information about the
    /// operation and its arguments.
    pub fn get_stored_query(&self) -> fluent_builders::GetStoredQuery<C, M, R> {
        fluent_builders::GetStoredQuery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAggregateDiscoveredResources` operation.
    ///
    /// See [`ListAggregateDiscoveredResources`](crate::client::fluent_builders::ListAggregateDiscoveredResources) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAggregateDiscoveredResources::into_paginator).
    pub fn list_aggregate_discovered_resources(
        &self,
    ) -> fluent_builders::ListAggregateDiscoveredResources<C, M, R> {
        fluent_builders::ListAggregateDiscoveredResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDiscoveredResources` operation.
    ///
    /// See [`ListDiscoveredResources`](crate::client::fluent_builders::ListDiscoveredResources) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDiscoveredResources::into_paginator).
    pub fn list_discovered_resources(&self) -> fluent_builders::ListDiscoveredResources<C, M, R> {
        fluent_builders::ListDiscoveredResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStoredQueries` operation.
    ///
    /// See [`ListStoredQueries`](crate::client::fluent_builders::ListStoredQueries) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListStoredQueries::into_paginator).
    pub fn list_stored_queries(&self) -> fluent_builders::ListStoredQueries<C, M, R> {
        fluent_builders::ListStoredQueries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAggregationAuthorization` operation.
    ///
    /// See [`PutAggregationAuthorization`](crate::client::fluent_builders::PutAggregationAuthorization) for more information about the
    /// operation and its arguments.
    pub fn put_aggregation_authorization(
        &self,
    ) -> fluent_builders::PutAggregationAuthorization<C, M, R> {
        fluent_builders::PutAggregationAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutConfigRule` operation.
    ///
    /// See [`PutConfigRule`](crate::client::fluent_builders::PutConfigRule) for more information about the
    /// operation and its arguments.
    pub fn put_config_rule(&self) -> fluent_builders::PutConfigRule<C, M, R> {
        fluent_builders::PutConfigRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutConfigurationAggregator` operation.
    ///
    /// See [`PutConfigurationAggregator`](crate::client::fluent_builders::PutConfigurationAggregator) for more information about the
    /// operation and its arguments.
    pub fn put_configuration_aggregator(
        &self,
    ) -> fluent_builders::PutConfigurationAggregator<C, M, R> {
        fluent_builders::PutConfigurationAggregator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutConfigurationRecorder` operation.
    ///
    /// See [`PutConfigurationRecorder`](crate::client::fluent_builders::PutConfigurationRecorder) for more information about the
    /// operation and its arguments.
    pub fn put_configuration_recorder(&self) -> fluent_builders::PutConfigurationRecorder<C, M, R> {
        fluent_builders::PutConfigurationRecorder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutConformancePack` operation.
    ///
    /// See [`PutConformancePack`](crate::client::fluent_builders::PutConformancePack) for more information about the
    /// operation and its arguments.
    pub fn put_conformance_pack(&self) -> fluent_builders::PutConformancePack<C, M, R> {
        fluent_builders::PutConformancePack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutDeliveryChannel` operation.
    ///
    /// See [`PutDeliveryChannel`](crate::client::fluent_builders::PutDeliveryChannel) for more information about the
    /// operation and its arguments.
    pub fn put_delivery_channel(&self) -> fluent_builders::PutDeliveryChannel<C, M, R> {
        fluent_builders::PutDeliveryChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEvaluations` operation.
    ///
    /// See [`PutEvaluations`](crate::client::fluent_builders::PutEvaluations) for more information about the
    /// operation and its arguments.
    pub fn put_evaluations(&self) -> fluent_builders::PutEvaluations<C, M, R> {
        fluent_builders::PutEvaluations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutExternalEvaluation` operation.
    ///
    /// See [`PutExternalEvaluation`](crate::client::fluent_builders::PutExternalEvaluation) for more information about the
    /// operation and its arguments.
    pub fn put_external_evaluation(&self) -> fluent_builders::PutExternalEvaluation<C, M, R> {
        fluent_builders::PutExternalEvaluation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutOrganizationConfigRule` operation.
    ///
    /// See [`PutOrganizationConfigRule`](crate::client::fluent_builders::PutOrganizationConfigRule) for more information about the
    /// operation and its arguments.
    pub fn put_organization_config_rule(
        &self,
    ) -> fluent_builders::PutOrganizationConfigRule<C, M, R> {
        fluent_builders::PutOrganizationConfigRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutOrganizationConformancePack` operation.
    ///
    /// See [`PutOrganizationConformancePack`](crate::client::fluent_builders::PutOrganizationConformancePack) for more information about the
    /// operation and its arguments.
    pub fn put_organization_conformance_pack(
        &self,
    ) -> fluent_builders::PutOrganizationConformancePack<C, M, R> {
        fluent_builders::PutOrganizationConformancePack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRemediationConfigurations` operation.
    ///
    /// See [`PutRemediationConfigurations`](crate::client::fluent_builders::PutRemediationConfigurations) for more information about the
    /// operation and its arguments.
    pub fn put_remediation_configurations(
        &self,
    ) -> fluent_builders::PutRemediationConfigurations<C, M, R> {
        fluent_builders::PutRemediationConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRemediationExceptions` operation.
    ///
    /// See [`PutRemediationExceptions`](crate::client::fluent_builders::PutRemediationExceptions) for more information about the
    /// operation and its arguments.
    pub fn put_remediation_exceptions(&self) -> fluent_builders::PutRemediationExceptions<C, M, R> {
        fluent_builders::PutRemediationExceptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutResourceConfig` operation.
    ///
    /// See [`PutResourceConfig`](crate::client::fluent_builders::PutResourceConfig) for more information about the
    /// operation and its arguments.
    pub fn put_resource_config(&self) -> fluent_builders::PutResourceConfig<C, M, R> {
        fluent_builders::PutResourceConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRetentionConfiguration` operation.
    ///
    /// See [`PutRetentionConfiguration`](crate::client::fluent_builders::PutRetentionConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_retention_configuration(
        &self,
    ) -> fluent_builders::PutRetentionConfiguration<C, M, R> {
        fluent_builders::PutRetentionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutStoredQuery` operation.
    ///
    /// See [`PutStoredQuery`](crate::client::fluent_builders::PutStoredQuery) for more information about the
    /// operation and its arguments.
    pub fn put_stored_query(&self) -> fluent_builders::PutStoredQuery<C, M, R> {
        fluent_builders::PutStoredQuery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SelectAggregateResourceConfig` operation.
    ///
    /// See [`SelectAggregateResourceConfig`](crate::client::fluent_builders::SelectAggregateResourceConfig) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::SelectAggregateResourceConfig::into_paginator).
    pub fn select_aggregate_resource_config(
        &self,
    ) -> fluent_builders::SelectAggregateResourceConfig<C, M, R> {
        fluent_builders::SelectAggregateResourceConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SelectResourceConfig` operation.
    ///
    /// See [`SelectResourceConfig`](crate::client::fluent_builders::SelectResourceConfig) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::SelectResourceConfig::into_paginator).
    pub fn select_resource_config(&self) -> fluent_builders::SelectResourceConfig<C, M, R> {
        fluent_builders::SelectResourceConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartConfigRulesEvaluation` operation.
    ///
    /// See [`StartConfigRulesEvaluation`](crate::client::fluent_builders::StartConfigRulesEvaluation) for more information about the
    /// operation and its arguments.
    pub fn start_config_rules_evaluation(
        &self,
    ) -> fluent_builders::StartConfigRulesEvaluation<C, M, R> {
        fluent_builders::StartConfigRulesEvaluation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartConfigurationRecorder` operation.
    ///
    /// See [`StartConfigurationRecorder`](crate::client::fluent_builders::StartConfigurationRecorder) for more information about the
    /// operation and its arguments.
    pub fn start_configuration_recorder(
        &self,
    ) -> fluent_builders::StartConfigurationRecorder<C, M, R> {
        fluent_builders::StartConfigurationRecorder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartRemediationExecution` operation.
    ///
    /// See [`StartRemediationExecution`](crate::client::fluent_builders::StartRemediationExecution) for more information about the
    /// operation and its arguments.
    pub fn start_remediation_execution(
        &self,
    ) -> fluent_builders::StartRemediationExecution<C, M, R> {
        fluent_builders::StartRemediationExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopConfigurationRecorder` operation.
    ///
    /// See [`StopConfigurationRecorder`](crate::client::fluent_builders::StopConfigurationRecorder) for more information about the
    /// operation and its arguments.
    pub fn stop_configuration_recorder(
        &self,
    ) -> fluent_builders::StopConfigurationRecorder<C, M, R> {
        fluent_builders::StopConfigurationRecorder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchGetAggregateResourceConfig`.
    ///
    /// <p>Returns the current configuration items for resources that are present in your Config aggregator. The operation also returns a list of resources that are not processed in the current request. If there are no unprocessed resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list. </p> <note>
    /// <ul>
    /// <li> <p>The API does not return results for deleted resources.</p> </li>
    /// <li> <p> The API does not return tags and relationships.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetAggregateResourceConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_aggregate_resource_config_input::Builder,
    }
    impl<C, M, R> BatchGetAggregateResourceConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetAggregateResourceConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetAggregateResourceConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetAggregateResourceConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetAggregateResourceConfigInputOperationOutputAlias,
                crate::output::BatchGetAggregateResourceConfigOutput,
                crate::error::BatchGetAggregateResourceConfigError,
                crate::input::BatchGetAggregateResourceConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// Appends an item to `ResourceIdentifiers`.
        ///
        /// To override the contents of this collection use [`set_resource_identifiers`](Self::set_resource_identifiers).
        ///
        /// <p>A list of aggregate ResourceIdentifiers objects. </p>
        pub fn resource_identifiers(
            mut self,
            input: crate::model::AggregateResourceIdentifier,
        ) -> Self {
            self.inner = self.inner.resource_identifiers(input);
            self
        }
        /// <p>A list of aggregate ResourceIdentifiers objects. </p>
        pub fn set_resource_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregateResourceIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifiers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetResourceConfig`.
    ///
    /// <p>Returns the <code>BaseConfigurationItem</code> for one or more requested resources. The operation also returns a list of resources that are not processed in the current request. If there are no unprocessed resources, the operation returns an empty unprocessedResourceKeys list. </p> <note>
    /// <ul>
    /// <li> <p>The API does not return results for deleted resources.</p> </li>
    /// <li> <p> The API does not return any tags for the requested resources. This information is filtered out of the supplementaryConfiguration section of the API response.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetResourceConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_resource_config_input::Builder,
    }
    impl<C, M, R> BatchGetResourceConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetResourceConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetResourceConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetResourceConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetResourceConfigInputOperationOutputAlias,
                crate::output::BatchGetResourceConfigOutput,
                crate::error::BatchGetResourceConfigError,
                crate::input::BatchGetResourceConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `resourceKeys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID.</p>
        pub fn resource_keys(mut self, input: crate::model::ResourceKey) -> Self {
            self.inner = self.inner.resource_keys(input);
            self
        }
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID.</p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
        ) -> Self {
            self.inner = self.inner.set_resource_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAggregationAuthorization`.
    ///
    /// <p>Deletes the authorization granted to the specified configuration aggregator account in a specified region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAggregationAuthorization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_aggregation_authorization_input::Builder,
    }
    impl<C, M, R> DeleteAggregationAuthorization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAggregationAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAggregationAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAggregationAuthorizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAggregationAuthorizationInputOperationOutputAlias,
                crate::output::DeleteAggregationAuthorizationOutput,
                crate::error::DeleteAggregationAuthorizationError,
                crate::input::DeleteAggregationAuthorizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
        pub fn authorized_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorized_account_id(input.into());
            self
        }
        /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
        pub fn set_authorized_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorized_account_id(input);
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn authorized_aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorized_aws_region(input.into());
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn set_authorized_aws_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorized_aws_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigRule`.
    ///
    /// <p>Deletes the specified Config rule and all of its evaluation results.</p>
    /// <p>Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a rule while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request for the rule, you will receive a <code>ResourceInUseException</code>.</p>
    /// <p>You can check the state of a rule by using the <code>DescribeConfigRules</code> request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_config_rule_input::Builder,
    }
    impl<C, M, R> DeleteConfigRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConfigRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConfigRuleInputOperationOutputAlias,
                crate::output::DeleteConfigRuleOutput,
                crate::error::DeleteConfigRuleError,
                crate::input::DeleteConfigRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Config rule that you want to delete.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_name(input.into());
            self
        }
        /// <p>The name of the Config rule that you want to delete.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationAggregator`.
    ///
    /// <p>Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationAggregator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_configuration_aggregator_input::Builder,
    }
    impl<C, M, R> DeleteConfigurationAggregator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConfigurationAggregator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationAggregatorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationAggregatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConfigurationAggregatorInputOperationOutputAlias,
                crate::output::DeleteConfigurationAggregatorOutput,
                crate::error::DeleteConfigurationAggregatorError,
                crate::input::DeleteConfigurationAggregatorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationRecorder`.
    ///
    /// <p>Deletes the configuration recorder.</p>
    /// <p>After the configuration recorder is deleted, Config will not record resource configuration changes until you create a new configuration recorder.</p>
    /// <p>This action does not delete the configuration information that was previously recorded. You will be able to access the previously recorded information by using the <code>GetResourceConfigHistory</code> action, but you will not be able to access this information in the Config console until you create a new configuration recorder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationRecorder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_configuration_recorder_input::Builder,
    }
    impl<C, M, R> DeleteConfigurationRecorder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConfigurationRecorder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationRecorderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationRecorderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConfigurationRecorderInputOperationOutputAlias,
                crate::output::DeleteConfigurationRecorderOutput,
                crate::error::DeleteConfigurationRecorderError,
                crate::input::DeleteConfigurationRecorderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration recorder to be deleted. You can retrieve the name of your configuration recorder by using the <code>DescribeConfigurationRecorders</code> action.</p>
        pub fn configuration_recorder_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_recorder_name(input.into());
            self
        }
        /// <p>The name of the configuration recorder to be deleted. You can retrieve the name of your configuration recorder by using the <code>DescribeConfigurationRecorders</code> action.</p>
        pub fn set_configuration_recorder_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_recorder_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConformancePack`.
    ///
    /// <p>Deletes the specified conformance pack and all the Config rules, remediation actions, and all evaluation results within that conformance pack.</p>
    /// <p>Config sets the conformance pack to <code>DELETE_IN_PROGRESS</code> until the deletion is complete. You cannot update a conformance pack while it is in this state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConformancePack<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_conformance_pack_input::Builder,
    }
    impl<C, M, R> DeleteConformancePack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConformancePack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConformancePackOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConformancePackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConformancePackInputOperationOutputAlias,
                crate::output::DeleteConformancePackOutput,
                crate::error::DeleteConformancePackError,
                crate::input::DeleteConformancePackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the conformance pack you want to delete.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conformance_pack_name(input.into());
            self
        }
        /// <p>Name of the conformance pack you want to delete.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_conformance_pack_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeliveryChannel`.
    ///
    /// <p>Deletes the delivery channel.</p>
    /// <p>Before you can delete the delivery channel, you must stop the configuration recorder by using the <code>StopConfigurationRecorder</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDeliveryChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_delivery_channel_input::Builder,
    }
    impl<C, M, R> DeleteDeliveryChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeliveryChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeliveryChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeliveryChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeliveryChannelInputOperationOutputAlias,
                crate::output::DeleteDeliveryChannelOutput,
                crate::error::DeleteDeliveryChannelError,
                crate::input::DeleteDeliveryChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery channel to delete.</p>
        pub fn delivery_channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_channel_name(input.into());
            self
        }
        /// <p>The name of the delivery channel to delete.</p>
        pub fn set_delivery_channel_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_channel_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEvaluationResults`.
    ///
    /// <p>Deletes the evaluation results for the specified Config rule. You can specify one Config rule per request. After you delete the evaluation results, you can call the <code>StartConfigRulesEvaluation</code> API to start evaluating your Amazon Web Services resources against the rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEvaluationResults<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_evaluation_results_input::Builder,
    }
    impl<C, M, R> DeleteEvaluationResults<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEvaluationResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEvaluationResultsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEvaluationResultsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEvaluationResultsInputOperationOutputAlias,
                crate::output::DeleteEvaluationResultsOutput,
                crate::error::DeleteEvaluationResultsError,
                crate::input::DeleteEvaluationResultsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Config rule for which you want to delete the evaluation results.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_name(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want to delete the evaluation results.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOrganizationConfigRule`.
    ///
    /// <p>Deletes the specified organization config rule and all of its evaluation results from all member accounts in that organization. </p>
    /// <p>Only a master account and a delegated administrator account can delete an organization config rule. When calling this API with a delegated administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added.</p>
    /// <p>Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a rule while it is in this state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOrganizationConfigRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_organization_config_rule_input::Builder,
    }
    impl<C, M, R> DeleteOrganizationConfigRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOrganizationConfigRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOrganizationConfigRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationConfigRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOrganizationConfigRuleInputOperationOutputAlias,
                crate::output::DeleteOrganizationConfigRuleOutput,
                crate::error::DeleteOrganizationConfigRuleError,
                crate::input::DeleteOrganizationConfigRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of organization config rule that you want to delete.</p>
        pub fn organization_config_rule_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organization_config_rule_name(input.into());
            self
        }
        /// <p>The name of organization config rule that you want to delete.</p>
        pub fn set_organization_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_config_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOrganizationConformancePack`.
    ///
    /// <p>Deletes the specified organization conformance pack and all of the config rules and remediation actions from all member accounts in that organization. </p>
    /// <p> Only a master account or a delegated administrator account can delete an organization conformance pack. When calling this API with a delegated administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added.</p>
    /// <p>Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a conformance pack while it is in this state. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOrganizationConformancePack<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_organization_conformance_pack_input::Builder,
    }
    impl<C, M, R> DeleteOrganizationConformancePack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOrganizationConformancePack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOrganizationConformancePackOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOrganizationConformancePackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOrganizationConformancePackInputOperationOutputAlias,
                crate::output::DeleteOrganizationConformancePackOutput,
                crate::error::DeleteOrganizationConformancePackError,
                crate::input::DeleteOrganizationConformancePackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of organization conformance pack that you want to delete.</p>
        pub fn organization_conformance_pack_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organization_conformance_pack_name(input.into());
            self
        }
        /// <p>The name of organization conformance pack that you want to delete.</p>
        pub fn set_organization_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_conformance_pack_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePendingAggregationRequest`.
    ///
    /// <p>Deletes pending authorization requests for a specified aggregator account in a specified region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePendingAggregationRequest<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_pending_aggregation_request_input::Builder,
    }
    impl<C, M, R> DeletePendingAggregationRequest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePendingAggregationRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePendingAggregationRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePendingAggregationRequestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePendingAggregationRequestInputOperationOutputAlias,
                crate::output::DeletePendingAggregationRequestOutput,
                crate::error::DeletePendingAggregationRequestError,
                crate::input::DeletePendingAggregationRequestInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
        pub fn requester_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requester_account_id(input.into());
            self
        }
        /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
        pub fn set_requester_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requester_account_id(input);
            self
        }
        /// <p>The region requesting to aggregate data.</p>
        pub fn requester_aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requester_aws_region(input.into());
            self
        }
        /// <p>The region requesting to aggregate data.</p>
        pub fn set_requester_aws_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_requester_aws_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRemediationConfiguration`.
    ///
    /// <p>Deletes the remediation configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRemediationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_remediation_configuration_input::Builder,
    }
    impl<C, M, R> DeleteRemediationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRemediationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRemediationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRemediationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRemediationConfigurationInputOperationOutputAlias,
                crate::output::DeleteRemediationConfigurationOutput,
                crate::error::DeleteRemediationConfigurationError,
                crate::input::DeleteRemediationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Config rule for which you want to delete remediation configuration.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_name(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want to delete remediation configuration.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_name(input);
            self
        }
        /// <p>The type of a resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The type of a resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRemediationExceptions`.
    ///
    /// <p>Deletes one or more remediation exceptions mentioned in the resource keys.</p> <note>
    /// <p>Config generates a remediation exception when a problem occurs executing a remediation action to a specific resource. Remediation exceptions blocks auto-remediation until the exception is cleared.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRemediationExceptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_remediation_exceptions_input::Builder,
    }
    impl<C, M, R> DeleteRemediationExceptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRemediationExceptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRemediationExceptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRemediationExceptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRemediationExceptionsInputOperationOutputAlias,
                crate::output::DeleteRemediationExceptionsOutput,
                crate::error::DeleteRemediationExceptionsError,
                crate::input::DeleteRemediationExceptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Config rule for which you want to delete remediation exception configuration.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_name(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want to delete remediation exception configuration.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_name(input);
            self
        }
        /// Appends an item to `ResourceKeys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn resource_keys(
            mut self,
            input: crate::model::RemediationExceptionResourceKey,
        ) -> Self {
            self.inner = self.inner.resource_keys(input);
            self
        }
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RemediationExceptionResourceKey>,
            >,
        ) -> Self {
            self.inner = self.inner.set_resource_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourceConfig`.
    ///
    /// <p>Records the configuration state for a custom resource that has been deleted. This API records a new ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this resource in your Config History. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourceConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_config_input::Builder,
    }
    impl<C, M, R> DeleteResourceConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourceConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourceConfigInputOperationOutputAlias,
                crate::output::DeleteResourceConfigOutput,
                crate::error::DeleteResourceConfigError,
                crate::input::DeleteResourceConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>Unique identifier of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>Unique identifier of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRetentionConfiguration`.
    ///
    /// <p>Deletes the retention configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRetentionConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_retention_configuration_input::Builder,
    }
    impl<C, M, R> DeleteRetentionConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRetentionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRetentionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRetentionConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRetentionConfigurationInputOperationOutputAlias,
                crate::output::DeleteRetentionConfigurationOutput,
                crate::error::DeleteRetentionConfigurationError,
                crate::input::DeleteRetentionConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the retention configuration to delete.</p>
        pub fn retention_configuration_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.retention_configuration_name(input.into());
            self
        }
        /// <p>The name of the retention configuration to delete.</p>
        pub fn set_retention_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_retention_configuration_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStoredQuery`.
    ///
    /// <p>Deletes the stored query for a single Amazon Web Services account and a single Amazon Web Services Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStoredQuery<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stored_query_input::Builder,
    }
    impl<C, M, R> DeleteStoredQuery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStoredQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStoredQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStoredQueryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStoredQueryInputOperationOutputAlias,
                crate::output::DeleteStoredQueryOutput,
                crate::error::DeleteStoredQueryError,
                crate::input::DeleteStoredQueryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the query that you want to delete.</p>
        pub fn query_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_name(input.into());
            self
        }
        /// <p>The name of the query that you want to delete.</p>
        pub fn set_query_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeliverConfigSnapshot`.
    ///
    /// <p>Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After the delivery has started, Config sends the following notifications using an Amazon SNS topic that you have specified.</p>
    /// <ul>
    /// <li> <p>Notification of the start of the delivery.</p> </li>
    /// <li> <p>Notification of the completion of the delivery, if the delivery was successfully completed.</p> </li>
    /// <li> <p>Notification of delivery failure, if the delivery failed.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeliverConfigSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deliver_config_snapshot_input::Builder,
    }
    impl<C, M, R> DeliverConfigSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeliverConfigSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeliverConfigSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeliverConfigSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeliverConfigSnapshotInputOperationOutputAlias,
                crate::output::DeliverConfigSnapshotOutput,
                crate::error::DeliverConfigSnapshotError,
                crate::input::DeliverConfigSnapshotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the delivery channel through which the snapshot is delivered.</p>
        pub fn delivery_channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_channel_name(input.into());
            self
        }
        /// <p>The name of the delivery channel through which the snapshot is delivered.</p>
        pub fn set_delivery_channel_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_channel_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAggregateComplianceByConfigRules`.
    ///
    /// <p>Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant rules. Does not display rules that do not have compliance results. </p> <note>
    /// <p>The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed on the next page.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAggregateComplianceByConfigRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_aggregate_compliance_by_config_rules_input::Builder,
    }
    impl<C, M, R> DescribeAggregateComplianceByConfigRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAggregateComplianceByConfigRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAggregateComplianceByConfigRulesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAggregateComplianceByConfigRulesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAggregateComplianceByConfigRulesInputOperationOutputAlias,
                crate::output::DescribeAggregateComplianceByConfigRulesOutput,
                crate::error::DescribeAggregateComplianceByConfigRulesError,
                crate::input::DescribeAggregateComplianceByConfigRulesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAggregateComplianceByConfigRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeAggregateComplianceByConfigRulesPaginator<C, M, R> {
            crate::paginator::DescribeAggregateComplianceByConfigRulesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// <p>Filters the results by ConfigRuleComplianceFilters object. </p>
        pub fn filters(mut self, input: crate::model::ConfigRuleComplianceFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters the results by ConfigRuleComplianceFilters object. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ConfigRuleComplianceFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAggregateComplianceByConformancePacks`.
    ///
    /// <p>Returns a list of the conformance packs and their associated compliance status with the count of compliant and noncompliant Config rules within each conformance pack. Also returns the total rule count which includes compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.</p> <note>
    /// <p>The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed on the next page.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAggregateComplianceByConformancePacks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_aggregate_compliance_by_conformance_packs_input::Builder,
    }
    impl<C, M, R> DescribeAggregateComplianceByConformancePacks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAggregateComplianceByConformancePacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DescribeAggregateComplianceByConformancePacksOutput, aws_smithy_http::result::SdkError<crate::error::DescribeAggregateComplianceByConformancePacksError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DescribeAggregateComplianceByConformancePacksInputOperationOutputAlias,
                                    crate::output::DescribeAggregateComplianceByConformancePacksOutput,
                                    crate::error::DescribeAggregateComplianceByConformancePacksError,
                                    crate::input::DescribeAggregateComplianceByConformancePacksInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAggregateComplianceByConformancePacksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeAggregateComplianceByConformancePacksPaginator<C, M, R>
        {
            crate::paginator::DescribeAggregateComplianceByConformancePacksPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// <p>Filters the result by <code>AggregateConformancePackComplianceFilters</code> object.</p>
        pub fn filters(
            mut self,
            input: crate::model::AggregateConformancePackComplianceFilters,
        ) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters the result by <code>AggregateConformancePackComplianceFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::AggregateConformancePackComplianceFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of conformance packs compliance details returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of conformance packs compliance details returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAggregationAuthorizations`.
    ///
    /// <p>Returns a list of authorizations granted to various aggregator accounts and regions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAggregationAuthorizations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_aggregation_authorizations_input::Builder,
    }
    impl<C, M, R> DescribeAggregationAuthorizations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAggregationAuthorizations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAggregationAuthorizationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAggregationAuthorizationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAggregationAuthorizationsInputOperationOutputAlias,
                crate::output::DescribeAggregationAuthorizationsOutput,
                crate::error::DescribeAggregationAuthorizationsError,
                crate::input::DescribeAggregationAuthorizationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAggregationAuthorizationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeAggregationAuthorizationsPaginator<C, M, R> {
            crate::paginator::DescribeAggregationAuthorizationsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The maximum number of AggregationAuthorizations returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of AggregationAuthorizations returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeComplianceByConfigRule`.
    ///
    /// <p>Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this action returns the number of Amazon Web Services resources that do not comply with the rule.</p>
    /// <p>A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these resources do not comply.</p>
    /// <p>If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result might indicate one of the following conditions:</p>
    /// <ul>
    /// <li> <p>Config has never invoked an evaluation for the rule. To check whether it has, use the <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and <code>LastFailedInvocationTime</code>.</p> </li>
    /// <li> <p>The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.</p> </li>
    /// <li> <p>The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if the resources were deleted or removed from the rule's scope.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeComplianceByConfigRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_compliance_by_config_rule_input::Builder,
    }
    impl<C, M, R> DescribeComplianceByConfigRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeComplianceByConfigRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeComplianceByConfigRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeComplianceByConfigRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeComplianceByConfigRuleInputOperationOutputAlias,
                crate::output::DescribeComplianceByConfigRuleOutput,
                crate::error::DescribeComplianceByConfigRuleError,
                crate::input::DescribeComplianceByConfigRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeComplianceByConfigRulePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeComplianceByConfigRulePaginator<C, M, R> {
            crate::paginator::DescribeComplianceByConfigRulePaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `ConfigRuleNames`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>Specify one or more Config rule names to filter the results by rule.</p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_names(input.into());
            self
        }
        /// <p>Specify one or more Config rule names to filter the results by rule.</p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_names(input);
            self
        }
        /// Appends an item to `ComplianceTypes`.
        ///
        /// To override the contents of this collection use [`set_compliance_types`](Self::set_compliance_types).
        ///
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.</p>
        pub fn compliance_types(mut self, input: crate::model::ComplianceType) -> Self {
            self.inner = self.inner.compliance_types(input);
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.</p>
        pub fn set_compliance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        ) -> Self {
            self.inner = self.inner.set_compliance_types(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeComplianceByResource`.
    ///
    /// <p>Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this action returns the number of Config rules that the resource does not comply with.</p>
    /// <p>A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does not comply with one or more of these rules.</p>
    /// <p>If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This result might indicate one of the following conditions about the rules that evaluate the resource:</p>
    /// <ul>
    /// <li> <p>Config has never invoked an evaluation for the rule. To check whether it has, use the <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and <code>LastFailedInvocationTime</code>.</p> </li>
    /// <li> <p>The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.</p> </li>
    /// <li> <p>The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if the resources were deleted or removed from the rule's scope.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeComplianceByResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_compliance_by_resource_input::Builder,
    }
    impl<C, M, R> DescribeComplianceByResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeComplianceByResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeComplianceByResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeComplianceByResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeComplianceByResourceInputOperationOutputAlias,
                crate::output::DescribeComplianceByResourceOutput,
                crate::error::DescribeComplianceByResourceError,
                crate::input::DescribeComplianceByResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeComplianceByResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeComplianceByResourcePaginator<C, M, R> {
            crate::paginator::DescribeComplianceByResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The types of Amazon Web Services resources for which you want compliance information (for example, <code>AWS::EC2::Instance</code>). For this action, you can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The types of Amazon Web Services resources for which you want compliance information (for example, <code>AWS::EC2::Instance</code>). For this action, you can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ID of the Amazon Web Services resource for which you want compliance information. You can specify only one resource ID. If you specify a resource ID, you must also specify a type for <code>ResourceType</code>.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services resource for which you want compliance information. You can specify only one resource ID. If you specify a resource ID, you must also specify a type for <code>ResourceType</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `ComplianceTypes`.
        ///
        /// To override the contents of this collection use [`set_compliance_types`](Self::set_compliance_types).
        ///
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>
        pub fn compliance_types(mut self, input: crate::model::ComplianceType) -> Self {
            self.inner = self.inner.compliance_types(input);
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>
        pub fn set_compliance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        ) -> Self {
            self.inner = self.inner.set_compliance_types(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigRuleEvaluationStatus`.
    ///
    /// <p>Returns status information for each of your Config managed rules. The status includes information such as the last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the last failure.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigRuleEvaluationStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_config_rule_evaluation_status_input::Builder,
    }
    impl<C, M, R> DescribeConfigRuleEvaluationStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigRuleEvaluationStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigRuleEvaluationStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeConfigRuleEvaluationStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigRuleEvaluationStatusInputOperationOutputAlias,
                crate::output::DescribeConfigRuleEvaluationStatusOutput,
                crate::error::DescribeConfigRuleEvaluationStatusError,
                crate::input::DescribeConfigRuleEvaluationStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeConfigRuleEvaluationStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeConfigRuleEvaluationStatusPaginator<C, M, R> {
            crate::paginator::DescribeConfigRuleEvaluationStatusPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `ConfigRuleNames`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>The name of the Config managed rules for which you want status information. If you do not specify any names, Config returns status information for all Config managed rules that you use.</p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_names(input.into());
            self
        }
        /// <p>The name of the Config managed rules for which you want status information. If you do not specify any names, Config returns status information for all Config managed rules that you use.</p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_names(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of rule evaluation results that you want returned.</p>
        /// <p>This parameter is required if the rule limit for your account is more than the default of 150 rules.</p>
        /// <p>For information about requesting a rule limit increase, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">Config Limits</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The number of rule evaluation results that you want returned.</p>
        /// <p>This parameter is required if the rule limit for your account is more than the default of 150 rules.</p>
        /// <p>For information about requesting a rule limit increase, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">Config Limits</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigRules`.
    ///
    /// <p>Returns details about your Config rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_config_rules_input::Builder,
    }
    impl<C, M, R> DescribeConfigRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigRulesInputOperationOutputAlias,
                crate::output::DescribeConfigRulesOutput,
                crate::error::DescribeConfigRulesError,
                crate::input::DescribeConfigRulesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeConfigRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeConfigRulesPaginator<C, M, R> {
            crate::paginator::DescribeConfigRulesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `ConfigRuleNames`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>The names of the Config rules for which you want details. If you do not specify any names, Config returns details for all your rules.</p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_names(input.into());
            self
        }
        /// <p>The names of the Config rules for which you want details. If you do not specify any names, Config returns details for all your rules.</p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_names(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationAggregators`.
    ///
    /// <p>Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified, this action returns the details for all the configuration aggregators associated with the account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigurationAggregators<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configuration_aggregators_input::Builder,
    }
    impl<C, M, R> DescribeConfigurationAggregators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigurationAggregators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationAggregatorsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationAggregatorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationAggregatorsInputOperationOutputAlias,
                crate::output::DescribeConfigurationAggregatorsOutput,
                crate::error::DescribeConfigurationAggregatorsError,
                crate::input::DescribeConfigurationAggregatorsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeConfigurationAggregatorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeConfigurationAggregatorsPaginator<C, M, R> {
            crate::paginator::DescribeConfigurationAggregatorsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `ConfigurationAggregatorNames`.
        ///
        /// To override the contents of this collection use [`set_configuration_aggregator_names`](Self::set_configuration_aggregator_names).
        ///
        /// <p>The name of the configuration aggregators.</p>
        pub fn configuration_aggregator_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_names(input.into());
            self
        }
        /// <p>The name of the configuration aggregators.</p>
        pub fn set_configuration_aggregator_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_names(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of configuration aggregators returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of configuration aggregators returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationAggregatorSourcesStatus`.
    ///
    /// <p>Returns status information for sources within an aggregator. The status includes information about the last time Config verified authorization between the source account and an aggregator account. In case of a failure, the status contains the related error code or message. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigurationAggregatorSourcesStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configuration_aggregator_sources_status_input::Builder,
    }
    impl<C, M, R> DescribeConfigurationAggregatorSourcesStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigurationAggregatorSourcesStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationAggregatorSourcesStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeConfigurationAggregatorSourcesStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationAggregatorSourcesStatusInputOperationOutputAlias,
                crate::output::DescribeConfigurationAggregatorSourcesStatusOutput,
                crate::error::DescribeConfigurationAggregatorSourcesStatusError,
                crate::input::DescribeConfigurationAggregatorSourcesStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeConfigurationAggregatorSourcesStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeConfigurationAggregatorSourcesStatusPaginator<C, M, R>
        {
            crate::paginator::DescribeConfigurationAggregatorSourcesStatusPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// Appends an item to `UpdateStatus`.
        ///
        /// To override the contents of this collection use [`set_update_status`](Self::set_update_status).
        ///
        /// <p>Filters the status type.</p>
        /// <ul>
        /// <li> <p>Valid value FAILED indicates errors while moving data.</p> </li>
        /// <li> <p>Valid value SUCCEEDED indicates the data was successfully moved.</p> </li>
        /// <li> <p>Valid value OUTDATED indicates the data is not the most recent.</p> </li>
        /// </ul>
        pub fn update_status(mut self, input: crate::model::AggregatedSourceStatusType) -> Self {
            self.inner = self.inner.update_status(input);
            self
        }
        /// <p>Filters the status type.</p>
        /// <ul>
        /// <li> <p>Valid value FAILED indicates errors while moving data.</p> </li>
        /// <li> <p>Valid value SUCCEEDED indicates the data was successfully moved.</p> </li>
        /// <li> <p>Valid value OUTDATED indicates the data is not the most recent.</p> </li>
        /// </ul>
        pub fn set_update_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregatedSourceStatusType>>,
        ) -> Self {
            self.inner = self.inner.set_update_status(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationRecorders`.
    ///
    /// <p>Returns the details for the specified configuration recorders. If the configuration recorder is not specified, this action returns the details for all configuration recorders associated with the account.</p> <note>
    /// <p>Currently, you can specify only one configuration recorder per region in your account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigurationRecorders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configuration_recorders_input::Builder,
    }
    impl<C, M, R> DescribeConfigurationRecorders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigurationRecorders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationRecordersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationRecordersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationRecordersInputOperationOutputAlias,
                crate::output::DescribeConfigurationRecordersOutput,
                crate::error::DescribeConfigurationRecordersError,
                crate::input::DescribeConfigurationRecordersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ConfigurationRecorderNames`.
        ///
        /// To override the contents of this collection use [`set_configuration_recorder_names`](Self::set_configuration_recorder_names).
        ///
        /// <p>A list of configuration recorder names.</p>
        pub fn configuration_recorder_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_recorder_names(input.into());
            self
        }
        /// <p>A list of configuration recorder names.</p>
        pub fn set_configuration_recorder_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_recorder_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationRecorderStatus`.
    ///
    /// <p>Returns the current status of the specified configuration recorder. If a configuration recorder is not specified, this action returns the status of all configuration recorders associated with the account.</p> <note>
    /// <p>Currently, you can specify only one configuration recorder per region in your account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigurationRecorderStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configuration_recorder_status_input::Builder,
    }
    impl<C, M, R> DescribeConfigurationRecorderStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigurationRecorderStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationRecorderStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeConfigurationRecorderStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationRecorderStatusInputOperationOutputAlias,
                crate::output::DescribeConfigurationRecorderStatusOutput,
                crate::error::DescribeConfigurationRecorderStatusError,
                crate::input::DescribeConfigurationRecorderStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ConfigurationRecorderNames`.
        ///
        /// To override the contents of this collection use [`set_configuration_recorder_names`](Self::set_configuration_recorder_names).
        ///
        /// <p>The name(s) of the configuration recorder. If the name is not specified, the action returns the current status of all the configuration recorders associated with the account.</p>
        pub fn configuration_recorder_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_recorder_names(input.into());
            self
        }
        /// <p>The name(s) of the configuration recorder. If the name is not specified, the action returns the current status of all the configuration recorders associated with the account.</p>
        pub fn set_configuration_recorder_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_recorder_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConformancePackCompliance`.
    ///
    /// <p>Returns compliance details for each rule in that conformance pack.</p> <note>
    /// <p>You must provide exact rule names.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConformancePackCompliance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_conformance_pack_compliance_input::Builder,
    }
    impl<C, M, R> DescribeConformancePackCompliance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConformancePackCompliance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConformancePackComplianceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConformancePackComplianceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConformancePackComplianceInputOperationOutputAlias,
                crate::output::DescribeConformancePackComplianceOutput,
                crate::error::DescribeConformancePackComplianceError,
                crate::input::DescribeConformancePackComplianceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeConformancePackCompliancePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeConformancePackCompliancePaginator<C, M, R> {
            crate::paginator::DescribeConformancePackCompliancePaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>Name of the conformance pack.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conformance_pack_name(input.into());
            self
        }
        /// <p>Name of the conformance pack.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_conformance_pack_name(input);
            self
        }
        /// <p>A <code>ConformancePackComplianceFilters</code> object.</p>
        pub fn filters(mut self, input: crate::model::ConformancePackComplianceFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A <code>ConformancePackComplianceFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ConformancePackComplianceFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of Config rules within a conformance pack are returned on each page.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of Config rules within a conformance pack are returned on each page.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConformancePacks`.
    ///
    /// <p>Returns a list of one or more conformance packs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConformancePacks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_conformance_packs_input::Builder,
    }
    impl<C, M, R> DescribeConformancePacks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConformancePacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConformancePacksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConformancePacksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConformancePacksInputOperationOutputAlias,
                crate::output::DescribeConformancePacksOutput,
                crate::error::DescribeConformancePacksError,
                crate::input::DescribeConformancePacksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeConformancePacksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeConformancePacksPaginator<C, M, R> {
            crate::paginator::DescribeConformancePacksPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `ConformancePackNames`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_names`](Self::set_conformance_pack_names).
        ///
        /// <p>Comma-separated list of conformance pack names for which you want details. If you do not specify any names, Config returns details for all your conformance packs. </p>
        pub fn conformance_pack_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conformance_pack_names(input.into());
            self
        }
        /// <p>Comma-separated list of conformance pack names for which you want details. If you do not specify any names, Config returns details for all your conformance packs. </p>
        pub fn set_conformance_pack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_conformance_pack_names(input);
            self
        }
        /// <p>The maximum number of conformance packs returned on each page.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of conformance packs returned on each page.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConformancePackStatus`.
    ///
    /// <p>Provides one or more conformance packs deployment status.</p> <note>
    /// <p>If there are no conformance packs then you will see an empty result.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConformancePackStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_conformance_pack_status_input::Builder,
    }
    impl<C, M, R> DescribeConformancePackStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConformancePackStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConformancePackStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConformancePackStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConformancePackStatusInputOperationOutputAlias,
                crate::output::DescribeConformancePackStatusOutput,
                crate::error::DescribeConformancePackStatusError,
                crate::input::DescribeConformancePackStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeConformancePackStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeConformancePackStatusPaginator<C, M, R> {
            crate::paginator::DescribeConformancePackStatusPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `ConformancePackNames`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_names`](Self::set_conformance_pack_names).
        ///
        /// <p>Comma-separated list of conformance pack names.</p>
        pub fn conformance_pack_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conformance_pack_names(input.into());
            self
        }
        /// <p>Comma-separated list of conformance pack names.</p>
        pub fn set_conformance_pack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_conformance_pack_names(input);
            self
        }
        /// <p>The maximum number of conformance packs status returned on each page.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of conformance packs status returned on each page.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDeliveryChannels`.
    ///
    /// <p>Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns the details of all delivery channels associated with the account.</p> <note>
    /// <p>Currently, you can specify only one delivery channel per region in your account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDeliveryChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_delivery_channels_input::Builder,
    }
    impl<C, M, R> DescribeDeliveryChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDeliveryChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeliveryChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeliveryChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDeliveryChannelsInputOperationOutputAlias,
                crate::output::DescribeDeliveryChannelsOutput,
                crate::error::DescribeDeliveryChannelsError,
                crate::input::DescribeDeliveryChannelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DeliveryChannelNames`.
        ///
        /// To override the contents of this collection use [`set_delivery_channel_names`](Self::set_delivery_channel_names).
        ///
        /// <p>A list of delivery channel names.</p>
        pub fn delivery_channel_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_channel_names(input.into());
            self
        }
        /// <p>A list of delivery channel names.</p>
        pub fn set_delivery_channel_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_delivery_channel_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDeliveryChannelStatus`.
    ///
    /// <p>Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action returns the current status of all delivery channels associated with the account.</p> <note>
    /// <p>Currently, you can specify only one delivery channel per region in your account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDeliveryChannelStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_delivery_channel_status_input::Builder,
    }
    impl<C, M, R> DescribeDeliveryChannelStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDeliveryChannelStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeliveryChannelStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeliveryChannelStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDeliveryChannelStatusInputOperationOutputAlias,
                crate::output::DescribeDeliveryChannelStatusOutput,
                crate::error::DescribeDeliveryChannelStatusError,
                crate::input::DescribeDeliveryChannelStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DeliveryChannelNames`.
        ///
        /// To override the contents of this collection use [`set_delivery_channel_names`](Self::set_delivery_channel_names).
        ///
        /// <p>A list of delivery channel names.</p>
        pub fn delivery_channel_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_channel_names(input.into());
            self
        }
        /// <p>A list of delivery channel names.</p>
        pub fn set_delivery_channel_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_delivery_channel_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationConfigRules`.
    ///
    /// <p>Returns a list of organization config rules. </p> <note>
    /// <p>When you specify the limit and the next token, you receive a paginated response. Limit and next token are not applicable if you specify organization config rule names. It is only applicable, when you request all the organization config rules.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationConfigRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_config_rules_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationConfigRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationConfigRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationConfigRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationConfigRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationConfigRulesInputOperationOutputAlias,
                crate::output::DescribeOrganizationConfigRulesOutput,
                crate::error::DescribeOrganizationConfigRulesError,
                crate::input::DescribeOrganizationConfigRulesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOrganizationConfigRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeOrganizationConfigRulesPaginator<C, M, R> {
            crate::paginator::DescribeOrganizationConfigRulesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `OrganizationConfigRuleNames`.
        ///
        /// To override the contents of this collection use [`set_organization_config_rule_names`](Self::set_organization_config_rule_names).
        ///
        /// <p>The names of organization config rules for which you want details. If you do not specify any names, Config returns details for all your organization config rules.</p>
        pub fn organization_config_rule_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organization_config_rule_names(input.into());
            self
        }
        /// <p>The names of organization config rules for which you want details. If you do not specify any names, Config returns details for all your organization config rules.</p>
        pub fn set_organization_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organization_config_rule_names(input);
            self
        }
        /// <p>The maximum number of organization config rules returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of organization config rules returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationConfigRuleStatuses`.
    ///
    /// <p>Provides organization config rule deployment status for an organization.</p> <note>
    /// <p>The status is not considered successful until organization config rule is successfully deployed in all the member accounts with an exception of excluded accounts.</p>
    /// <p>When you specify the limit and the next token, you receive a paginated response. Limit and next token are not applicable if you specify organization config rule names. It is only applicable, when you request all the organization config rules.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationConfigRuleStatuses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_config_rule_statuses_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationConfigRuleStatuses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationConfigRuleStatuses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationConfigRuleStatusesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOrganizationConfigRuleStatusesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationConfigRuleStatusesInputOperationOutputAlias,
                crate::output::DescribeOrganizationConfigRuleStatusesOutput,
                crate::error::DescribeOrganizationConfigRuleStatusesError,
                crate::input::DescribeOrganizationConfigRuleStatusesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOrganizationConfigRuleStatusesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeOrganizationConfigRuleStatusesPaginator<C, M, R> {
            crate::paginator::DescribeOrganizationConfigRuleStatusesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `OrganizationConfigRuleNames`.
        ///
        /// To override the contents of this collection use [`set_organization_config_rule_names`](Self::set_organization_config_rule_names).
        ///
        /// <p>The names of organization config rules for which you want status details. If you do not specify any names, Config returns details for all your organization Config rules.</p>
        pub fn organization_config_rule_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organization_config_rule_names(input.into());
            self
        }
        /// <p>The names of organization config rules for which you want status details. If you do not specify any names, Config returns details for all your organization Config rules.</p>
        pub fn set_organization_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organization_config_rule_names(input);
            self
        }
        /// <p>The maximum number of <code>OrganizationConfigRuleStatuses</code> returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of <code>OrganizationConfigRuleStatuses</code> returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationConformancePacks`.
    ///
    /// <p>Returns a list of organization conformance packs. </p> <note>
    /// <p>When you specify the limit and the next token, you receive a paginated response. </p>
    /// <p>Limit and next token are not applicable if you specify organization conformance packs names. They are only applicable, when you request all the organization conformance packs. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationConformancePacks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_conformance_packs_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationConformancePacks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationConformancePacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationConformancePacksOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOrganizationConformancePacksError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationConformancePacksInputOperationOutputAlias,
                crate::output::DescribeOrganizationConformancePacksOutput,
                crate::error::DescribeOrganizationConformancePacksError,
                crate::input::DescribeOrganizationConformancePacksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOrganizationConformancePacksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeOrganizationConformancePacksPaginator<C, M, R> {
            crate::paginator::DescribeOrganizationConformancePacksPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `OrganizationConformancePackNames`.
        ///
        /// To override the contents of this collection use [`set_organization_conformance_pack_names`](Self::set_organization_conformance_pack_names).
        ///
        /// <p>The name that you assign to an organization conformance pack.</p>
        pub fn organization_conformance_pack_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organization_conformance_pack_names(input.into());
            self
        }
        /// <p>The name that you assign to an organization conformance pack.</p>
        pub fn set_organization_conformance_pack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organization_conformance_pack_names(input);
            self
        }
        /// <p>The maximum number of organization config packs returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of organization config packs returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationConformancePackStatuses`.
    ///
    /// <p>Provides organization conformance pack deployment status for an organization. </p> <note>
    /// <p>The status is not considered successful until organization conformance pack is successfully deployed in all the member accounts with an exception of excluded accounts.</p>
    /// <p>When you specify the limit and the next token, you receive a paginated response. Limit and next token are not applicable if you specify organization conformance pack names. They are only applicable, when you request all the organization conformance packs.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationConformancePackStatuses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_conformance_pack_statuses_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationConformancePackStatuses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationConformancePackStatuses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationConformancePackStatusesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOrganizationConformancePackStatusesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationConformancePackStatusesInputOperationOutputAlias,
                crate::output::DescribeOrganizationConformancePackStatusesOutput,
                crate::error::DescribeOrganizationConformancePackStatusesError,
                crate::input::DescribeOrganizationConformancePackStatusesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOrganizationConformancePackStatusesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeOrganizationConformancePackStatusesPaginator<C, M, R>
        {
            crate::paginator::DescribeOrganizationConformancePackStatusesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `OrganizationConformancePackNames`.
        ///
        /// To override the contents of this collection use [`set_organization_conformance_pack_names`](Self::set_organization_conformance_pack_names).
        ///
        /// <p>The names of organization conformance packs for which you want status details. If you do not specify any names, Config returns details for all your organization conformance packs. </p>
        pub fn organization_conformance_pack_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organization_conformance_pack_names(input.into());
            self
        }
        /// <p>The names of organization conformance packs for which you want status details. If you do not specify any names, Config returns details for all your organization conformance packs. </p>
        pub fn set_organization_conformance_pack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organization_conformance_pack_names(input);
            self
        }
        /// <p>The maximum number of OrganizationConformancePackStatuses returned on each page. If you do no specify a number, Config uses the default. The default is 100. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of OrganizationConformancePackStatuses returned on each page. If you do no specify a number, Config uses the default. The default is 100. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePendingAggregationRequests`.
    ///
    /// <p>Returns a list of all pending aggregation requests.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePendingAggregationRequests<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pending_aggregation_requests_input::Builder,
    }
    impl<C, M, R> DescribePendingAggregationRequests<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePendingAggregationRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePendingAggregationRequestsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribePendingAggregationRequestsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePendingAggregationRequestsInputOperationOutputAlias,
                crate::output::DescribePendingAggregationRequestsOutput,
                crate::error::DescribePendingAggregationRequestsError,
                crate::input::DescribePendingAggregationRequestsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePendingAggregationRequestsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribePendingAggregationRequestsPaginator<C, M, R> {
            crate::paginator::DescribePendingAggregationRequestsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRemediationConfigurations`.
    ///
    /// <p>Returns the details of one or more remediation configurations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRemediationConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_remediation_configurations_input::Builder,
    }
    impl<C, M, R> DescribeRemediationConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRemediationConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRemediationConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRemediationConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRemediationConfigurationsInputOperationOutputAlias,
                crate::output::DescribeRemediationConfigurationsOutput,
                crate::error::DescribeRemediationConfigurationsError,
                crate::input::DescribeRemediationConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ConfigRuleNames`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>A list of Config rule names of remediation configurations for which you want details. </p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_names(input.into());
            self
        }
        /// <p>A list of Config rule names of remediation configurations for which you want details. </p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRemediationExceptions`.
    ///
    /// <p>Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set of resources that includes an explanation of an exception and the time when the exception will be deleted. When you specify the limit and the next token, you receive a paginated response. </p> <note>
    /// <p>Config generates a remediation exception when a problem occurs executing a remediation action to a specific resource. Remediation exceptions blocks auto-remediation until the exception is cleared.</p>
    /// <p>When you specify the limit and the next token, you receive a paginated response. </p>
    /// <p>Limit and next token are not applicable if you request resources in batch. It is only applicable, when you request all resources.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRemediationExceptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_remediation_exceptions_input::Builder,
    }
    impl<C, M, R> DescribeRemediationExceptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRemediationExceptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRemediationExceptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRemediationExceptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRemediationExceptionsInputOperationOutputAlias,
                crate::output::DescribeRemediationExceptionsOutput,
                crate::error::DescribeRemediationExceptionsError,
                crate::input::DescribeRemediationExceptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeRemediationExceptionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeRemediationExceptionsPaginator<C, M, R> {
            crate::paginator::DescribeRemediationExceptionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the Config rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_name(input.into());
            self
        }
        /// <p>The name of the Config rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_name(input);
            self
        }
        /// Appends an item to `ResourceKeys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn resource_keys(
            mut self,
            input: crate::model::RemediationExceptionResourceKey,
        ) -> Self {
            self.inner = self.inner.resource_keys(input);
            self
        }
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RemediationExceptionResourceKey>,
            >,
        ) -> Self {
            self.inner = self.inner.set_resource_keys(input);
            self
        }
        /// <p>The maximum number of RemediationExceptionResourceKey returned on each page. The default is 25. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of RemediationExceptionResourceKey returned on each page. The default is 25. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRemediationExecutionStatus`.
    ///
    /// <p>Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when steps for the remediation execution occur, and any error messages for steps that have failed. When you specify the limit and the next token, you receive a paginated response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRemediationExecutionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_remediation_execution_status_input::Builder,
    }
    impl<C, M, R> DescribeRemediationExecutionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRemediationExecutionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRemediationExecutionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeRemediationExecutionStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRemediationExecutionStatusInputOperationOutputAlias,
                crate::output::DescribeRemediationExecutionStatusOutput,
                crate::error::DescribeRemediationExecutionStatusError,
                crate::input::DescribeRemediationExecutionStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeRemediationExecutionStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeRemediationExecutionStatusPaginator<C, M, R> {
            crate::paginator::DescribeRemediationExecutionStatusPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>A list of Config rule names.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_name(input.into());
            self
        }
        /// <p>A list of Config rule names.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_name(input);
            self
        }
        /// Appends an item to `ResourceKeys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
        pub fn resource_keys(mut self, input: crate::model::ResourceKey) -> Self {
            self.inner = self.inner.resource_keys(input);
            self
        }
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
        ) -> Self {
            self.inner = self.inner.set_resource_keys(input);
            self
        }
        /// <p>The maximum number of RemediationExecutionStatuses returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of RemediationExecutionStatuses returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRetentionConfigurations`.
    ///
    /// <p>Returns the details of one or more retention configurations. If the retention configuration name is not specified, this action returns the details for all the retention configurations for that account.</p> <note>
    /// <p>Currently, Config supports only one retention configuration per region in your account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRetentionConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_retention_configurations_input::Builder,
    }
    impl<C, M, R> DescribeRetentionConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRetentionConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRetentionConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRetentionConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRetentionConfigurationsInputOperationOutputAlias,
                crate::output::DescribeRetentionConfigurationsOutput,
                crate::error::DescribeRetentionConfigurationsError,
                crate::input::DescribeRetentionConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeRetentionConfigurationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeRetentionConfigurationsPaginator<C, M, R> {
            crate::paginator::DescribeRetentionConfigurationsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `RetentionConfigurationNames`.
        ///
        /// To override the contents of this collection use [`set_retention_configuration_names`](Self::set_retention_configuration_names).
        ///
        /// <p>A list of names of retention configurations for which you want details. If you do not specify a name, Config returns details for all the retention configurations for that account.</p> <note>
        /// <p>Currently, Config supports only one retention configuration per region in your account.</p>
        /// </note>
        pub fn retention_configuration_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.retention_configuration_names(input.into());
            self
        }
        /// <p>A list of names of retention configurations for which you want details. If you do not specify a name, Config returns details for all the retention configurations for that account.</p> <note>
        /// <p>Currently, Config supports only one retention configuration per region in your account.</p>
        /// </note>
        pub fn set_retention_configuration_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_retention_configuration_names(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAggregateComplianceDetailsByConfigRule`.
    ///
    /// <p>Returns the evaluation results for the specified Config rule for a specific resource in a rule. The results indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule. </p> <note>
    /// <p>The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed on the next page.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAggregateComplianceDetailsByConfigRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_aggregate_compliance_details_by_config_rule_input::Builder,
    }
    impl<C, M, R> GetAggregateComplianceDetailsByConfigRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAggregateComplianceDetailsByConfigRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAggregateComplianceDetailsByConfigRuleOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAggregateComplianceDetailsByConfigRuleError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAggregateComplianceDetailsByConfigRuleInputOperationOutputAlias,
                crate::output::GetAggregateComplianceDetailsByConfigRuleOutput,
                crate::error::GetAggregateComplianceDetailsByConfigRuleError,
                crate::input::GetAggregateComplianceDetailsByConfigRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetAggregateComplianceDetailsByConfigRulePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetAggregateComplianceDetailsByConfigRulePaginator<C, M, R> {
            crate::paginator::GetAggregateComplianceDetailsByConfigRulePaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// <p>The name of the Config rule for which you want compliance information.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_name(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want compliance information.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_name(input);
            self
        }
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The source region from where the data is aggregated.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The source region from where the data is aggregated.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The resource compliance status.</p> <note>
        /// <p>For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, Config supports only the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.</p>
        /// </note>
        pub fn compliance_type(mut self, input: crate::model::ComplianceType) -> Self {
            self.inner = self.inner.compliance_type(input);
            self
        }
        /// <p>The resource compliance status.</p> <note>
        /// <p>For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, Config supports only the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.</p>
        /// </note>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceType>,
        ) -> Self {
            self.inner = self.inner.set_compliance_type(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 50. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 50. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAggregateConfigRuleComplianceSummary`.
    ///
    /// <p>Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.</p> <note>
    /// <p>The results can return an empty result page, but if you have a nextToken, the results are displayed on the next page.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAggregateConfigRuleComplianceSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_aggregate_config_rule_compliance_summary_input::Builder,
    }
    impl<C, M, R> GetAggregateConfigRuleComplianceSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAggregateConfigRuleComplianceSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAggregateConfigRuleComplianceSummaryOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAggregateConfigRuleComplianceSummaryError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAggregateConfigRuleComplianceSummaryInputOperationOutputAlias,
                crate::output::GetAggregateConfigRuleComplianceSummaryOutput,
                crate::error::GetAggregateConfigRuleComplianceSummaryError,
                crate::input::GetAggregateConfigRuleComplianceSummaryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetAggregateConfigRuleComplianceSummaryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetAggregateConfigRuleComplianceSummaryPaginator<C, M, R> {
            crate::paginator::GetAggregateConfigRuleComplianceSummaryPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// <p>Filters the results based on the ConfigRuleComplianceSummaryFilters object.</p>
        pub fn filters(mut self, input: crate::model::ConfigRuleComplianceSummaryFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters the results based on the ConfigRuleComplianceSummaryFilters object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ConfigRuleComplianceSummaryFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Groups the result based on ACCOUNT_ID or AWS_REGION.</p>
        pub fn group_by_key(
            mut self,
            input: crate::model::ConfigRuleComplianceSummaryGroupKey,
        ) -> Self {
            self.inner = self.inner.group_by_key(input);
            self
        }
        /// <p>Groups the result based on ACCOUNT_ID or AWS_REGION.</p>
        pub fn set_group_by_key(
            mut self,
            input: std::option::Option<crate::model::ConfigRuleComplianceSummaryGroupKey>,
        ) -> Self {
            self.inner = self.inner.set_group_by_key(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAggregateConformancePackComplianceSummary`.
    ///
    /// <p>Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon Web Services Region.</p> <note>
    /// <p>The results can return an empty result page, but if you have a nextToken, the results are displayed on the next page.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAggregateConformancePackComplianceSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_aggregate_conformance_pack_compliance_summary_input::Builder,
    }
    impl<C, M, R> GetAggregateConformancePackComplianceSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAggregateConformancePackComplianceSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAggregateConformancePackComplianceSummaryOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAggregateConformancePackComplianceSummaryError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAggregateConformancePackComplianceSummaryInputOperationOutputAlias,
                crate::output::GetAggregateConformancePackComplianceSummaryOutput,
                crate::error::GetAggregateConformancePackComplianceSummaryError,
                crate::input::GetAggregateConformancePackComplianceSummaryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetAggregateConformancePackComplianceSummaryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetAggregateConformancePackComplianceSummaryPaginator<C, M, R>
        {
            crate::paginator::GetAggregateConformancePackComplianceSummaryPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// <p>Filters the results based on the <code>AggregateConformancePackComplianceSummaryFilters</code> object.</p>
        pub fn filters(
            mut self,
            input: crate::model::AggregateConformancePackComplianceSummaryFilters,
        ) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters the results based on the <code>AggregateConformancePackComplianceSummaryFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                crate::model::AggregateConformancePackComplianceSummaryFilters,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>
        pub fn group_by_key(
            mut self,
            input: crate::model::AggregateConformancePackComplianceSummaryGroupKey,
        ) -> Self {
            self.inner = self.inner.group_by_key(input);
            self
        }
        /// <p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>
        pub fn set_group_by_key(
            mut self,
            input: std::option::Option<
                crate::model::AggregateConformancePackComplianceSummaryGroupKey,
            >,
        ) -> Self {
            self.inner = self.inner.set_group_by_key(input);
            self
        }
        /// <p>The maximum number of results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAggregateDiscoveredResourceCounts`.
    ///
    /// <p>Returns the resource counts across accounts and regions that are present in your Config aggregator. You can request the resource counts by providing filters and GroupByKey.</p>
    /// <p>For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAggregateDiscoveredResourceCounts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_aggregate_discovered_resource_counts_input::Builder,
    }
    impl<C, M, R> GetAggregateDiscoveredResourceCounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAggregateDiscoveredResourceCounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAggregateDiscoveredResourceCountsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAggregateDiscoveredResourceCountsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAggregateDiscoveredResourceCountsInputOperationOutputAlias,
                crate::output::GetAggregateDiscoveredResourceCountsOutput,
                crate::error::GetAggregateDiscoveredResourceCountsError,
                crate::input::GetAggregateDiscoveredResourceCountsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetAggregateDiscoveredResourceCountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetAggregateDiscoveredResourceCountsPaginator<C, M, R> {
            crate::paginator::GetAggregateDiscoveredResourceCountsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// <p>Filters the results based on the <code>ResourceCountFilters</code> object.</p>
        pub fn filters(mut self, input: crate::model::ResourceCountFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters the results based on the <code>ResourceCountFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ResourceCountFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The key to group the resource counts.</p>
        pub fn group_by_key(mut self, input: crate::model::ResourceCountGroupKey) -> Self {
            self.inner = self.inner.group_by_key(input);
            self
        }
        /// <p>The key to group the resource counts.</p>
        pub fn set_group_by_key(
            mut self,
            input: std::option::Option<crate::model::ResourceCountGroupKey>,
        ) -> Self {
            self.inner = self.inner.set_group_by_key(input);
            self
        }
        /// <p>The maximum number of <code>GroupedResourceCount</code> objects returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of <code>GroupedResourceCount</code> objects returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAggregateResourceConfig`.
    ///
    /// <p>Returns configuration item that is aggregated for your specific resource in a specific source account and region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAggregateResourceConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_aggregate_resource_config_input::Builder,
    }
    impl<C, M, R> GetAggregateResourceConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAggregateResourceConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAggregateResourceConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAggregateResourceConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAggregateResourceConfigInputOperationOutputAlias,
                crate::output::GetAggregateResourceConfigOutput,
                crate::error::GetAggregateResourceConfigError,
                crate::input::GetAggregateResourceConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// <p>An object that identifies aggregate resource.</p>
        pub fn resource_identifier(
            mut self,
            input: crate::model::AggregateResourceIdentifier,
        ) -> Self {
            self.inner = self.inner.resource_identifier(input);
            self
        }
        /// <p>An object that identifies aggregate resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::AggregateResourceIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComplianceDetailsByConfigRule`.
    ///
    /// <p>Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComplianceDetailsByConfigRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_compliance_details_by_config_rule_input::Builder,
    }
    impl<C, M, R> GetComplianceDetailsByConfigRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetComplianceDetailsByConfigRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComplianceDetailsByConfigRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComplianceDetailsByConfigRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetComplianceDetailsByConfigRuleInputOperationOutputAlias,
                crate::output::GetComplianceDetailsByConfigRuleOutput,
                crate::error::GetComplianceDetailsByConfigRuleError,
                crate::input::GetComplianceDetailsByConfigRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetComplianceDetailsByConfigRulePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetComplianceDetailsByConfigRulePaginator<C, M, R> {
            crate::paginator::GetComplianceDetailsByConfigRulePaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the Config rule for which you want compliance information.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_name(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want compliance information.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_name(input);
            self
        }
        /// Appends an item to `ComplianceTypes`.
        ///
        /// To override the contents of this collection use [`set_compliance_types`](Self::set_compliance_types).
        ///
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
        pub fn compliance_types(mut self, input: crate::model::ComplianceType) -> Self {
            self.inner = self.inner.compliance_types(input);
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
        pub fn set_compliance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        ) -> Self {
            self.inner = self.inner.set_compliance_types(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComplianceDetailsByResource`.
    ///
    /// <p>Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config rules were used to evaluate the resource, when each rule was last used, and whether the resource complies with each rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComplianceDetailsByResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_compliance_details_by_resource_input::Builder,
    }
    impl<C, M, R> GetComplianceDetailsByResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetComplianceDetailsByResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComplianceDetailsByResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComplianceDetailsByResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetComplianceDetailsByResourceInputOperationOutputAlias,
                crate::output::GetComplianceDetailsByResourceOutput,
                crate::error::GetComplianceDetailsByResourceError,
                crate::input::GetComplianceDetailsByResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetComplianceDetailsByResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetComplianceDetailsByResourcePaginator<C, M, R> {
            crate::paginator::GetComplianceDetailsByResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The type of the Amazon Web Services resource for which you want compliance information.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The type of the Amazon Web Services resource for which you want compliance information.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ID of the Amazon Web Services resource for which you want compliance information.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services resource for which you want compliance information.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `ComplianceTypes`.
        ///
        /// To override the contents of this collection use [`set_compliance_types`](Self::set_compliance_types).
        ///
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
        pub fn compliance_types(mut self, input: crate::model::ComplianceType) -> Self {
            self.inner = self.inner.compliance_types(input);
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
        pub fn set_compliance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        ) -> Self {
            self.inner = self.inner.set_compliance_types(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComplianceSummaryByConfigRule`.
    ///
    /// <p>Returns the number of Config rules that are compliant and noncompliant, up to a maximum of 25 for each.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComplianceSummaryByConfigRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_compliance_summary_by_config_rule_input::Builder,
    }
    impl<C, M, R> GetComplianceSummaryByConfigRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetComplianceSummaryByConfigRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComplianceSummaryByConfigRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComplianceSummaryByConfigRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetComplianceSummaryByConfigRuleInputOperationOutputAlias,
                crate::output::GetComplianceSummaryByConfigRuleOutput,
                crate::error::GetComplianceSummaryByConfigRuleError,
                crate::input::GetComplianceSummaryByConfigRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetComplianceSummaryByResourceType`.
    ///
    /// <p>Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or more resource types to get these numbers for each resource type. The maximum number returned is 100.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComplianceSummaryByResourceType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_compliance_summary_by_resource_type_input::Builder,
    }
    impl<C, M, R> GetComplianceSummaryByResourceType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetComplianceSummaryByResourceType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComplianceSummaryByResourceTypeOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetComplianceSummaryByResourceTypeError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetComplianceSummaryByResourceTypeInputOperationOutputAlias,
                crate::output::GetComplianceSummaryByResourceTypeOutput,
                crate::error::GetComplianceSummaryByResourceTypeError,
                crate::input::GetComplianceSummaryByResourceTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ResourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>Specify one or more resource types to get the number of resources that are compliant and the number that are noncompliant for each resource type.</p>
        /// <p>For this request, you can specify an Amazon Web Services resource type such as <code>AWS::EC2::Instance</code>. You can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_types(input.into());
            self
        }
        /// <p>Specify one or more resource types to get the number of resources that are compliant and the number that are noncompliant for each resource type.</p>
        /// <p>For this request, you can specify an Amazon Web Services resource type such as <code>AWS::EC2::Instance</code>. You can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConformancePackComplianceDetails`.
    ///
    /// <p>Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by conformance pack.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConformancePackComplianceDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_conformance_pack_compliance_details_input::Builder,
    }
    impl<C, M, R> GetConformancePackComplianceDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConformancePackComplianceDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConformancePackComplianceDetailsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetConformancePackComplianceDetailsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConformancePackComplianceDetailsInputOperationOutputAlias,
                crate::output::GetConformancePackComplianceDetailsOutput,
                crate::error::GetConformancePackComplianceDetailsError,
                crate::input::GetConformancePackComplianceDetailsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetConformancePackComplianceDetailsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetConformancePackComplianceDetailsPaginator<C, M, R> {
            crate::paginator::GetConformancePackComplianceDetailsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>Name of the conformance pack.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conformance_pack_name(input.into());
            self
        }
        /// <p>Name of the conformance pack.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_conformance_pack_name(input);
            self
        }
        /// <p>A <code>ConformancePackEvaluationFilters</code> object.</p>
        pub fn filters(mut self, input: crate::model::ConformancePackEvaluationFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A <code>ConformancePackEvaluationFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ConformancePackEvaluationFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConformancePackComplianceSummary`.
    ///
    /// <p>Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules in that conformance pack.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConformancePackComplianceSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_conformance_pack_compliance_summary_input::Builder,
    }
    impl<C, M, R> GetConformancePackComplianceSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConformancePackComplianceSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConformancePackComplianceSummaryOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetConformancePackComplianceSummaryError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConformancePackComplianceSummaryInputOperationOutputAlias,
                crate::output::GetConformancePackComplianceSummaryOutput,
                crate::error::GetConformancePackComplianceSummaryError,
                crate::input::GetConformancePackComplianceSummaryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetConformancePackComplianceSummaryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetConformancePackComplianceSummaryPaginator<C, M, R> {
            crate::paginator::GetConformancePackComplianceSummaryPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `ConformancePackNames`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_names`](Self::set_conformance_pack_names).
        ///
        /// <p>Names of conformance packs.</p>
        pub fn conformance_pack_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conformance_pack_names(input.into());
            self
        }
        /// <p>Names of conformance packs.</p>
        pub fn set_conformance_pack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_conformance_pack_names(input);
            self
        }
        /// <p>The maximum number of conformance packs returned on each page.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of conformance packs returned on each page.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDiscoveredResourceCounts`.
    ///
    /// <p>Returns the resource types, the number of each resource type, and the total number of resources that Config is recording in this region for your Amazon Web Services account. </p>
    /// <p class="title"> <b>Example</b> </p>
    /// <ol>
    /// <li> <p>Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets.</p> </li>
    /// <li> <p>You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource types. </p> </li>
    /// <li> <p>Config returns the following:</p>
    /// <ul>
    /// <li> <p>The resource types (EC2 instances, IAM users, and S3 buckets).</p> </li>
    /// <li> <p>The number of each resource type (25, 20, and 15).</p> </li>
    /// <li> <p>The total number of all resources (60).</p> </li>
    /// </ul> </li>
    /// </ol>
    /// <p>The response is paginated. By default, Config lists 100 <code>ResourceCount</code> objects on each page. You can customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.</p> <note>
    /// <p>If you make a call to the <code>GetDiscoveredResourceCounts</code> action, you might not immediately receive resource counts in the following situations:</p>
    /// <ul>
    /// <li> <p>You are a new Config customer.</p> </li>
    /// <li> <p>You just enabled resource recording.</p> </li>
    /// </ul>
    /// <p>It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the <code>GetDiscoveredResourceCounts</code> action. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDiscoveredResourceCounts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_discovered_resource_counts_input::Builder,
    }
    impl<C, M, R> GetDiscoveredResourceCounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDiscoveredResourceCounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDiscoveredResourceCountsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDiscoveredResourceCountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDiscoveredResourceCountsInputOperationOutputAlias,
                crate::output::GetDiscoveredResourceCountsOutput,
                crate::error::GetDiscoveredResourceCountsError,
                crate::input::GetDiscoveredResourceCountsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetDiscoveredResourceCountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetDiscoveredResourceCountsPaginator<C, M, R> {
            crate::paginator::GetDiscoveredResourceCountsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `resourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The comma-separated list that specifies the resource types that you want Config to return (for example, <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).</p>
        /// <p>If a value for <code>resourceTypes</code> is not specified, Config returns all resource types that Config is recording in the region for your account.</p> <note>
        /// <p>If the configuration recorder is turned off, Config returns an empty list of <code>ResourceCount</code> objects. If the configuration recorder is not recording a specific resource type (for example, S3 buckets), that resource type is not returned in the list of <code>ResourceCount</code> objects.</p>
        /// </note>
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_types(input.into());
            self
        }
        /// <p>The comma-separated list that specifies the resource types that you want Config to return (for example, <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).</p>
        /// <p>If a value for <code>resourceTypes</code> is not specified, Config returns all resource types that Config is recording in the region for your account.</p> <note>
        /// <p>If the configuration recorder is turned off, Config returns an empty list of <code>ResourceCount</code> objects. If the configuration recorder is not recording a specific resource type (for example, S3 buckets), that resource type is not returned in the list of <code>ResourceCount</code> objects.</p>
        /// </note>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
        /// <p>The maximum number of <code>ResourceCount</code> objects returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of <code>ResourceCount</code> objects returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOrganizationConfigRuleDetailedStatus`.
    ///
    /// <p>Returns detailed status for each member account within an organization for a given organization config rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOrganizationConfigRuleDetailedStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_organization_config_rule_detailed_status_input::Builder,
    }
    impl<C, M, R> GetOrganizationConfigRuleDetailedStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOrganizationConfigRuleDetailedStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOrganizationConfigRuleDetailedStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetOrganizationConfigRuleDetailedStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOrganizationConfigRuleDetailedStatusInputOperationOutputAlias,
                crate::output::GetOrganizationConfigRuleDetailedStatusOutput,
                crate::error::GetOrganizationConfigRuleDetailedStatusError,
                crate::input::GetOrganizationConfigRuleDetailedStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetOrganizationConfigRuleDetailedStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetOrganizationConfigRuleDetailedStatusPaginator<C, M, R> {
            crate::paginator::GetOrganizationConfigRuleDetailedStatusPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of organization config rule for which you want status details for member accounts.</p>
        pub fn organization_config_rule_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organization_config_rule_name(input.into());
            self
        }
        /// <p>The name of organization config rule for which you want status details for member accounts.</p>
        pub fn set_organization_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_config_rule_name(input);
            self
        }
        /// <p>A <code>StatusDetailFilters</code> object.</p>
        pub fn filters(mut self, input: crate::model::StatusDetailFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A <code>StatusDetailFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::StatusDetailFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of <code>OrganizationConfigRuleDetailedStatus</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of <code>OrganizationConfigRuleDetailedStatus</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOrganizationConformancePackDetailedStatus`.
    ///
    /// <p>Returns detailed status for each member account within an organization for a given organization conformance pack.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOrganizationConformancePackDetailedStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_organization_conformance_pack_detailed_status_input::Builder,
    }
    impl<C, M, R> GetOrganizationConformancePackDetailedStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOrganizationConformancePackDetailedStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOrganizationConformancePackDetailedStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetOrganizationConformancePackDetailedStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOrganizationConformancePackDetailedStatusInputOperationOutputAlias,
                crate::output::GetOrganizationConformancePackDetailedStatusOutput,
                crate::error::GetOrganizationConformancePackDetailedStatusError,
                crate::input::GetOrganizationConformancePackDetailedStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetOrganizationConformancePackDetailedStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetOrganizationConformancePackDetailedStatusPaginator<C, M, R>
        {
            crate::paginator::GetOrganizationConformancePackDetailedStatusPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of organization conformance pack for which you want status details for member accounts.</p>
        pub fn organization_conformance_pack_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organization_conformance_pack_name(input.into());
            self
        }
        /// <p>The name of organization conformance pack for which you want status details for member accounts.</p>
        pub fn set_organization_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_conformance_pack_name(input);
            self
        }
        /// <p>An <code>OrganizationResourceDetailedStatusFilters</code> object.</p>
        pub fn filters(
            mut self,
            input: crate::model::OrganizationResourceDetailedStatusFilters,
        ) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An <code>OrganizationResourceDetailedStatusFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::OrganizationResourceDetailedStatusFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of <code>OrganizationConformancePackDetailedStatuses</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of <code>OrganizationConformancePackDetailedStatuses</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceConfigHistory`.
    ///
    /// <p>Returns a list of <code>ConfigurationItems</code> for the specified resource. The list contains details about each state of the resource during the specified time interval. If you specified a retention period to retain your <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), Config returns the <code>ConfigurationItems</code> for the specified retention period. </p>
    /// <p>The response is paginated. By default, Config returns a limit of 10 configuration items per page. You can customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.</p> <note>
    /// <p>Each call to the API is limited to span a duration of seven days. It is likely that the number of records returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the <code>nextToken</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourceConfigHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_config_history_input::Builder,
    }
    impl<C, M, R> GetResourceConfigHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceConfigHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceConfigHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceConfigHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceConfigHistoryInputOperationOutputAlias,
                crate::output::GetResourceConfigHistoryOutput,
                crate::error::GetResourceConfigHistoryError,
                crate::input::GetResourceConfigHistoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetResourceConfigHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetResourceConfigHistoryPaginator<C, M, R> {
            crate::paginator::GetResourceConfigHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The time stamp that indicates a later time. If not specified, current time is taken.</p>
        pub fn later_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.later_time(input);
            self
        }
        /// <p>The time stamp that indicates a later time. If not specified, current time is taken.</p>
        pub fn set_later_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_later_time(input);
            self
        }
        /// <p>The time stamp that indicates an earlier time. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
        pub fn earlier_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.earlier_time(input);
            self
        }
        /// <p>The time stamp that indicates an earlier time. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
        pub fn set_earlier_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_earlier_time(input);
            self
        }
        /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
        pub fn chronological_order(mut self, input: crate::model::ChronologicalOrder) -> Self {
            self.inner = self.inner.chronological_order(input);
            self
        }
        /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
        pub fn set_chronological_order(
            mut self,
            input: std::option::Option<crate::model::ChronologicalOrder>,
        ) -> Self {
            self.inner = self.inner.set_chronological_order(input);
            self
        }
        /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStoredQuery`.
    ///
    /// <p>Returns the details of a specific stored query.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStoredQuery<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stored_query_input::Builder,
    }
    impl<C, M, R> GetStoredQuery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStoredQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStoredQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStoredQueryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStoredQueryInputOperationOutputAlias,
                crate::output::GetStoredQueryOutput,
                crate::error::GetStoredQueryError,
                crate::input::GetStoredQueryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the query.</p>
        pub fn query_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_name(input.into());
            self
        }
        /// <p>The name of the query.</p>
        pub fn set_query_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAggregateDiscoveredResources`.
    ///
    /// <p>Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom resource name, source account, and source region. You can narrow the results to include only resources that have specific resource IDs, or a resource name, or source account ID, or source region.</p>
    /// <p>For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type <code>AWS::EC2::Instance</code> then the API returns all the EC2 instance identifiers of accountID 12345678910 and region us-east-1.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAggregateDiscoveredResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_aggregate_discovered_resources_input::Builder,
    }
    impl<C, M, R> ListAggregateDiscoveredResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAggregateDiscoveredResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAggregateDiscoveredResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAggregateDiscoveredResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAggregateDiscoveredResourcesInputOperationOutputAlias,
                crate::output::ListAggregateDiscoveredResourcesOutput,
                crate::error::ListAggregateDiscoveredResourcesError,
                crate::input::ListAggregateDiscoveredResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAggregateDiscoveredResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAggregateDiscoveredResourcesPaginator<C, M, R> {
            crate::paginator::ListAggregateDiscoveredResourcesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the configuration aggregator. </p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator. </p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// <p>The type of resources that you want Config to list in the response.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of resources that you want Config to list in the response.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>Filters the results based on the <code>ResourceFilters</code> object.</p>
        pub fn filters(mut self, input: crate::model::ResourceFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters the results based on the <code>ResourceFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ResourceFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDiscoveredResources`.
    ///
    /// <p>Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of resources that Config has discovered, including those that Config is not currently recording. You can narrow the results to include only resources that have specific resource IDs or a resource name.</p> <note>
    /// <p>You can specify either resource IDs or a resource name, but not both, in the same request.</p>
    /// </note>
    /// <p>The response is paginated. By default, Config lists 100 resource identifiers on each page. You can customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDiscoveredResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_discovered_resources_input::Builder,
    }
    impl<C, M, R> ListDiscoveredResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDiscoveredResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDiscoveredResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDiscoveredResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDiscoveredResourcesInputOperationOutputAlias,
                crate::output::ListDiscoveredResourcesOutput,
                crate::error::ListDiscoveredResourcesError,
                crate::input::ListDiscoveredResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDiscoveredResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDiscoveredResourcesPaginator<C, M, R> {
            crate::paginator::ListDiscoveredResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The type of resources that you want Config to list in the response.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of resources that you want Config to list in the response.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `resourceIds`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The IDs of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_ids(input.into());
            self
        }
        /// <p>The IDs of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_ids(input);
            self
        }
        /// <p>The custom name of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The custom name of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Specifies whether Config includes deleted resources in the results. By default, deleted resources are not included.</p>
        pub fn include_deleted_resources(mut self, input: bool) -> Self {
            self.inner = self.inner.include_deleted_resources(input);
            self
        }
        /// <p>Specifies whether Config includes deleted resources in the results. By default, deleted resources are not included.</p>
        pub fn set_include_deleted_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_deleted_resources(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStoredQueries`.
    ///
    /// <p>Lists the stored queries for a single Amazon Web Services account and a single Amazon Web Services Region. The default is 100. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStoredQueries<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stored_queries_input::Builder,
    }
    impl<C, M, R> ListStoredQueries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStoredQueries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStoredQueriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStoredQueriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStoredQueriesInputOperationOutputAlias,
                crate::output::ListStoredQueriesOutput,
                crate::error::ListStoredQueriesError,
                crate::input::ListStoredQueriesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStoredQueriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStoredQueriesPaginator<C, M, R> {
            crate::paginator::ListStoredQueriesPaginator::new(self.handle, self.inner)
        }
        /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for Config resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator<C, M, R> {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAggregationAuthorization`.
    ///
    /// <p>Authorizes the aggregator account and region to collect data from the source account and region. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAggregationAuthorization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_aggregation_authorization_input::Builder,
    }
    impl<C, M, R> PutAggregationAuthorization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAggregationAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAggregationAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAggregationAuthorizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAggregationAuthorizationInputOperationOutputAlias,
                crate::output::PutAggregationAuthorizationOutput,
                crate::error::PutAggregationAuthorizationError,
                crate::input::PutAggregationAuthorizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
        pub fn authorized_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorized_account_id(input.into());
            self
        }
        /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
        pub fn set_authorized_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorized_account_id(input);
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn authorized_aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorized_aws_region(input.into());
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn set_authorized_aws_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorized_aws_region(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tag object.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of tag object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigRule`.
    ///
    /// <p>Adds or updates an Config rule for evaluating whether your Amazon Web Services resources comply with your desired configurations.</p>
    /// <p>You can use this action for custom Config rules and Config managed rules. A custom Config rule is a rule that you develop and maintain. An Config managed rule is a customizable, predefined rule that Config provides.</p>
    /// <p>If you are adding a new custom Config rule, you must first create the Lambda function that the rule invokes to evaluate your resources. When you use the <code>PutConfigRule</code> action to add the rule to Config, you must specify the Amazon Resource Name (ARN) that Lambda assigns to the function. Specify the ARN for the <code>SourceIdentifier</code> key. This key is part of the <code>Source</code> object, which is part of the <code>ConfigRule</code> object. </p>
    /// <p>If you are adding an Config managed rule, specify the rule's identifier for the <code>SourceIdentifier</code> key. To reference Config managed rule identifiers, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">About Config managed rules</a>.</p>
    /// <p>For any new rule that you add, specify the <code>ConfigRuleName</code> in the <code>ConfigRule</code> object. Do not specify the <code>ConfigRuleArn</code> or the <code>ConfigRuleId</code>. These values are generated by Config for new rules.</p>
    /// <p>If you are updating a rule that you added previously, you can specify the rule by <code>ConfigRuleName</code>, <code>ConfigRuleId</code>, or <code>ConfigRuleArn</code> in the <code>ConfigRule</code> data type that you use in this request.</p>
    /// <p>The maximum number of rules that Config supports is 150.</p>
    /// <p>For information about requesting a rule limit increase, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">Config Limits</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    /// <p>For more information about developing and using Config rules, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating Amazon Web Services resource Configurations with Config</a> in the <i>Config Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_config_rule_input::Builder,
    }
    impl<C, M, R> PutConfigRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutConfigRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::PutConfigRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutConfigRuleInputOperationOutputAlias,
                crate::output::PutConfigRuleOutput,
                crate::error::PutConfigRuleError,
                crate::input::PutConfigRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule that you want to add to your account.</p>
        pub fn config_rule(mut self, input: crate::model::ConfigRule) -> Self {
            self.inner = self.inner.config_rule(input);
            self
        }
        /// <p>The rule that you want to add to your account.</p>
        pub fn set_config_rule(
            mut self,
            input: std::option::Option<crate::model::ConfigRule>,
        ) -> Self {
            self.inner = self.inner.set_config_rule(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tag object.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of tag object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationAggregator`.
    ///
    /// <p>Creates and updates the configuration aggregator with the selected source accounts and regions. The source account can be individual account(s) or an organization.</p>
    /// <p> <code>accountIds</code> that are passed will be replaced with existing accounts. If you want to add additional accounts into the aggregator, call <code>DescribeAggregator</code> to get the previous accounts and then append new ones.</p> <note>
    /// <p>Config should be enabled in source accounts and regions you want to aggregate.</p>
    /// <p>If your source type is an organization, you must be signed in to the management account or a registered delegated administrator and all the features must be enabled in your organization. If the caller is a management account, Config calls <code>EnableAwsServiceAccess</code> API to enable integration between Config and Organizations. If the caller is a registered delegated administrator, Config calls <code>ListDelegatedAdministrators</code> API to verify whether the caller is a valid delegated administrator.</p>
    /// <p>To register a delegated administrator, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli">Register a Delegated Administrator</a> in the Config developer guide. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationAggregator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_configuration_aggregator_input::Builder,
    }
    impl<C, M, R> PutConfigurationAggregator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutConfigurationAggregator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationAggregatorOutput,
            aws_smithy_http::result::SdkError<crate::error::PutConfigurationAggregatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutConfigurationAggregatorInputOperationOutputAlias,
                crate::output::PutConfigurationAggregatorOutput,
                crate::error::PutConfigurationAggregatorError,
                crate::input::PutConfigurationAggregatorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// Appends an item to `AccountAggregationSources`.
        ///
        /// To override the contents of this collection use [`set_account_aggregation_sources`](Self::set_account_aggregation_sources).
        ///
        /// <p>A list of AccountAggregationSource object. </p>
        pub fn account_aggregation_sources(
            mut self,
            input: crate::model::AccountAggregationSource,
        ) -> Self {
            self.inner = self.inner.account_aggregation_sources(input);
            self
        }
        /// <p>A list of AccountAggregationSource object. </p>
        pub fn set_account_aggregation_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountAggregationSource>>,
        ) -> Self {
            self.inner = self.inner.set_account_aggregation_sources(input);
            self
        }
        /// <p>An OrganizationAggregationSource object.</p>
        pub fn organization_aggregation_source(
            mut self,
            input: crate::model::OrganizationAggregationSource,
        ) -> Self {
            self.inner = self.inner.organization_aggregation_source(input);
            self
        }
        /// <p>An OrganizationAggregationSource object.</p>
        pub fn set_organization_aggregation_source(
            mut self,
            input: std::option::Option<crate::model::OrganizationAggregationSource>,
        ) -> Self {
            self.inner = self.inner.set_organization_aggregation_source(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tag object.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of tag object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationRecorder`.
    ///
    /// <p>Creates a new configuration recorder to record the selected resource configurations.</p>
    /// <p>You can use this action to change the role <code>roleARN</code> or the <code>recordingGroup</code> of an existing recorder. To change the role, call the action on the existing configuration recorder and specify a role.</p> <note>
    /// <p>Currently, you can specify only one configuration recorder per region in your account.</p>
    /// <p>If <code>ConfigurationRecorder</code> does not have the <b>recordingGroup</b> parameter specified, the default is to record all supported resource types.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationRecorder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_configuration_recorder_input::Builder,
    }
    impl<C, M, R> PutConfigurationRecorder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutConfigurationRecorder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationRecorderOutput,
            aws_smithy_http::result::SdkError<crate::error::PutConfigurationRecorderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutConfigurationRecorderInputOperationOutputAlias,
                crate::output::PutConfigurationRecorderOutput,
                crate::error::PutConfigurationRecorderError,
                crate::input::PutConfigurationRecorderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The configuration recorder object that records each configuration change made to the resources.</p>
        pub fn configuration_recorder(
            mut self,
            input: crate::model::ConfigurationRecorder,
        ) -> Self {
            self.inner = self.inner.configuration_recorder(input);
            self
        }
        /// <p>The configuration recorder object that records each configuration change made to the resources.</p>
        pub fn set_configuration_recorder(
            mut self,
            input: std::option::Option<crate::model::ConfigurationRecorder>,
        ) -> Self {
            self.inner = self.inner.set_configuration_recorder(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConformancePack`.
    ///
    /// <p>Creates or updates a conformance pack. A conformance pack is a collection of Config rules that can be easily deployed in an account and a region and across Amazon Web Services Organization.</p>
    /// <p>This API creates a service linked role <code>AWSServiceRoleForConfigConforms</code> in your account. The service linked role is created only when the role does not exist in your account. </p> <note>
    /// <p>You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both. If you provide both Config uses the <code>TemplateS3Uri</code> parameter and ignores the <code>TemplateBody</code> parameter.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConformancePack<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_conformance_pack_input::Builder,
    }
    impl<C, M, R> PutConformancePack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutConformancePack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConformancePackOutput,
            aws_smithy_http::result::SdkError<crate::error::PutConformancePackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutConformancePackInputOperationOutputAlias,
                crate::output::PutConformancePackOutput,
                crate::error::PutConformancePackError,
                crate::input::PutConformancePackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the conformance pack you want to create.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conformance_pack_name(input.into());
            self
        }
        /// <p>Name of the conformance pack you want to create.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_conformance_pack_name(input);
            self
        }
        /// <p>Location of file containing the template body (<code>s3://bucketname/prefix</code>). The uri must point to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same region as the conformance pack. </p> <note>
        /// <p>You must have access to read Amazon S3 bucket.</p>
        /// </note>
        pub fn template_s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_s3_uri(input.into());
            self
        }
        /// <p>Location of file containing the template body (<code>s3://bucketname/prefix</code>). The uri must point to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same region as the conformance pack. </p> <note>
        /// <p>You must have access to read Amazon S3 bucket.</p>
        /// </note>
        pub fn set_template_s3_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_s3_uri(input);
            self
        }
        /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p> <note>
        /// <p>You can only use a YAML template with one resource type, that is, config rule and a remediation action. </p>
        /// </note>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(input.into());
            self
        }
        /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p> <note>
        /// <p>You can only use a YAML template with one resource type, that is, config rule and a remediation action. </p>
        /// </note>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn delivery_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_s3_bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn set_delivery_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_s3_bucket(input);
            self
        }
        /// <p>The prefix for the Amazon S3 bucket. </p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn delivery_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_s3_key_prefix(input.into());
            self
        }
        /// <p>The prefix for the Amazon S3 bucket. </p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn set_delivery_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_s3_key_prefix(input);
            self
        }
        /// Appends an item to `ConformancePackInputParameters`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_input_parameters`](Self::set_conformance_pack_input_parameters).
        ///
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn conformance_pack_input_parameters(
            mut self,
            input: crate::model::ConformancePackInputParameter,
        ) -> Self {
            self.inner = self.inner.conformance_pack_input_parameters(input);
            self
        }
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn set_conformance_pack_input_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
        ) -> Self {
            self.inner = self.inner.set_conformance_pack_input_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDeliveryChannel`.
    ///
    /// <p>Creates a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS topic.</p>
    /// <p>Before you can create a delivery channel, you must create a configuration recorder.</p>
    /// <p>You can use this action to change the Amazon S3 bucket or an Amazon SNS topic of the existing delivery channel. To change the Amazon S3 bucket or an Amazon SNS topic, call this action and specify the changed values for the S3 bucket and the SNS topic. If you specify a different value for either the S3 bucket or the SNS topic, this action will keep the existing value for the parameter that is not changed.</p> <note>
    /// <p>You can have only one delivery channel per region in your account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDeliveryChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_delivery_channel_input::Builder,
    }
    impl<C, M, R> PutDeliveryChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDeliveryChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDeliveryChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDeliveryChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDeliveryChannelInputOperationOutputAlias,
                crate::output::PutDeliveryChannelOutput,
                crate::error::PutDeliveryChannelError,
                crate::input::PutDeliveryChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket and to an Amazon SNS topic.</p>
        pub fn delivery_channel(mut self, input: crate::model::DeliveryChannel) -> Self {
            self.inner = self.inner.delivery_channel(input);
            self
        }
        /// <p>The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket and to an Amazon SNS topic.</p>
        pub fn set_delivery_channel(
            mut self,
            input: std::option::Option<crate::model::DeliveryChannel>,
        ) -> Self {
            self.inner = self.inner.set_delivery_channel(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEvaluations`.
    ///
    /// <p>Used by an Lambda function to deliver evaluation results to Config. This action is required in every Lambda function that is invoked by an Config rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEvaluations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_evaluations_input::Builder,
    }
    impl<C, M, R> PutEvaluations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEvaluations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEvaluationsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEvaluationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEvaluationsInputOperationOutputAlias,
                crate::output::PutEvaluationsOutput,
                crate::error::PutEvaluationsError,
                crate::input::PutEvaluationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Evaluations`.
        ///
        /// To override the contents of this collection use [`set_evaluations`](Self::set_evaluations).
        ///
        /// <p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>
        pub fn evaluations(mut self, input: crate::model::Evaluation) -> Self {
            self.inner = self.inner.evaluations(input);
            self
        }
        /// <p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>
        pub fn set_evaluations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Evaluation>>,
        ) -> Self {
            self.inner = self.inner.set_evaluations(input);
            self
        }
        /// <p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>
        pub fn result_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.result_token(input.into());
            self
        }
        /// <p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>
        pub fn set_result_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_result_token(input);
            self
        }
        /// <p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p> <note>
        /// <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p>
        /// </note>
        pub fn test_mode(mut self, input: bool) -> Self {
            self.inner = self.inner.test_mode(input);
            self
        }
        /// <p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p> <note>
        /// <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p>
        /// </note>
        pub fn set_test_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_test_mode(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutExternalEvaluation`.
    ///
    /// <p>Add or updates the evaluations for process checks. This API checks if the rule is a process check when the name of the Config rule is provided.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutExternalEvaluation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_external_evaluation_input::Builder,
    }
    impl<C, M, R> PutExternalEvaluation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutExternalEvaluation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutExternalEvaluationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutExternalEvaluationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutExternalEvaluationInputOperationOutputAlias,
                crate::output::PutExternalEvaluationOutput,
                crate::error::PutExternalEvaluationError,
                crate::input::PutExternalEvaluationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Config rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_name(input.into());
            self
        }
        /// <p>The name of the Config rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_name(input);
            self
        }
        /// <p>An <code>ExternalEvaluation</code> object that provides details about compliance.</p>
        pub fn external_evaluation(mut self, input: crate::model::ExternalEvaluation) -> Self {
            self.inner = self.inner.external_evaluation(input);
            self
        }
        /// <p>An <code>ExternalEvaluation</code> object that provides details about compliance.</p>
        pub fn set_external_evaluation(
            mut self,
            input: std::option::Option<crate::model::ExternalEvaluation>,
        ) -> Self {
            self.inner = self.inner.set_external_evaluation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutOrganizationConfigRule`.
    ///
    /// <p>Adds or updates organization config rule for your entire organization evaluating whether your Amazon Web Services resources comply with your desired configurations.</p>
    /// <p> Only a master account and a delegated administrator can create or update an organization config rule. When calling this API with a delegated administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added. </p>
    /// <p>This API enables organization service access through the <code>EnableAWSServiceAccess</code> action and creates a service linked role <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the master or delegated administrator account of your organization. The service linked role is created only when the role does not exist in the caller account. Config verifies the existence of role with <code>GetRole</code> action.</p>
    /// <p>To use this API with delegated administrator, register a delegated administrator by calling Amazon Web Services Organization <code>register-delegated-administrator</code> for <code>config-multiaccountsetup.amazonaws.com</code>. </p>
    /// <p>You can use this action to create both custom Config rules and Config managed rules. If you are adding a new custom Config rule, you must first create Lambda function in the master account or a delegated administrator that the rule invokes to evaluate your resources. You also need to create an IAM role in the managed-account that can be assumed by the Lambda function. When you use the <code>PutOrganizationConfigRule</code> action to add the rule to Config, you must specify the Amazon Resource Name (ARN) that Lambda assigns to the function. If you are adding an Config managed rule, specify the rule's identifier for the <code>RuleIdentifier</code> key.</p>
    /// <p>The maximum number of organization config rules that Config supports is 150 and 3 delegated administrator per organization. </p> <note>
    /// <p>Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.</p>
    /// <p>Specify either <code>OrganizationCustomRuleMetadata</code> or <code>OrganizationManagedRuleMetadata</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutOrganizationConfigRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_organization_config_rule_input::Builder,
    }
    impl<C, M, R> PutOrganizationConfigRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutOrganizationConfigRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutOrganizationConfigRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::PutOrganizationConfigRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutOrganizationConfigRuleInputOperationOutputAlias,
                crate::output::PutOrganizationConfigRuleOutput,
                crate::error::PutOrganizationConfigRuleError,
                crate::input::PutOrganizationConfigRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that you assign to an organization config rule.</p>
        pub fn organization_config_rule_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organization_config_rule_name(input.into());
            self
        }
        /// <p>The name that you assign to an organization config rule.</p>
        pub fn set_organization_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_config_rule_name(input);
            self
        }
        /// <p>An <code>OrganizationManagedRuleMetadata</code> object. </p>
        pub fn organization_managed_rule_metadata(
            mut self,
            input: crate::model::OrganizationManagedRuleMetadata,
        ) -> Self {
            self.inner = self.inner.organization_managed_rule_metadata(input);
            self
        }
        /// <p>An <code>OrganizationManagedRuleMetadata</code> object. </p>
        pub fn set_organization_managed_rule_metadata(
            mut self,
            input: std::option::Option<crate::model::OrganizationManagedRuleMetadata>,
        ) -> Self {
            self.inner = self.inner.set_organization_managed_rule_metadata(input);
            self
        }
        /// <p>An <code>OrganizationCustomRuleMetadata</code> object.</p>
        pub fn organization_custom_rule_metadata(
            mut self,
            input: crate::model::OrganizationCustomRuleMetadata,
        ) -> Self {
            self.inner = self.inner.organization_custom_rule_metadata(input);
            self
        }
        /// <p>An <code>OrganizationCustomRuleMetadata</code> object.</p>
        pub fn set_organization_custom_rule_metadata(
            mut self,
            input: std::option::Option<crate::model::OrganizationCustomRuleMetadata>,
        ) -> Self {
            self.inner = self.inner.set_organization_custom_rule_metadata(input);
            self
        }
        /// Appends an item to `ExcludedAccounts`.
        ///
        /// To override the contents of this collection use [`set_excluded_accounts`](Self::set_excluded_accounts).
        ///
        /// <p>A comma-separated list of accounts that you want to exclude from an organization config rule.</p>
        pub fn excluded_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.excluded_accounts(input.into());
            self
        }
        /// <p>A comma-separated list of accounts that you want to exclude from an organization config rule.</p>
        pub fn set_excluded_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_excluded_accounts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutOrganizationConformancePack`.
    ///
    /// <p>Deploys conformance packs across member accounts in an Amazon Web Services Organization.</p>
    /// <p>Only a master account and a delegated administrator can call this API. When calling this API with a delegated administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added.</p>
    /// <p>This API enables organization service access for <code>config-multiaccountsetup.amazonaws.com</code> through the <code>EnableAWSServiceAccess</code> action and creates a service linked role <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the master or delegated administrator account of your organization. The service linked role is created only when the role does not exist in the caller account. To use this API with delegated administrator, register a delegated administrator by calling Amazon Web Services Organization <code>register-delegate-admin</code> for <code>config-multiaccountsetup.amazonaws.com</code>.</p> <note>
    /// <p>Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.</p>
    /// <p>You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both. If you provide both Config uses the <code>TemplateS3Uri</code> parameter and ignores the <code>TemplateBody</code> parameter.</p>
    /// <p>Config sets the state of a conformance pack to CREATE_IN_PROGRESS and UPDATE_IN_PROGRESS until the conformance pack is created or updated. You cannot update a conformance pack while it is in this state.</p>
    /// <p>You can create 50 conformance packs with 25 Config rules in each pack and 3 delegated administrator per organization. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutOrganizationConformancePack<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_organization_conformance_pack_input::Builder,
    }
    impl<C, M, R> PutOrganizationConformancePack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutOrganizationConformancePack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutOrganizationConformancePackOutput,
            aws_smithy_http::result::SdkError<crate::error::PutOrganizationConformancePackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutOrganizationConformancePackInputOperationOutputAlias,
                crate::output::PutOrganizationConformancePackOutput,
                crate::error::PutOrganizationConformancePackError,
                crate::input::PutOrganizationConformancePackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the organization conformance pack you want to create.</p>
        pub fn organization_conformance_pack_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organization_conformance_pack_name(input.into());
            self
        }
        /// <p>Name of the organization conformance pack you want to create.</p>
        pub fn set_organization_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_conformance_pack_name(input);
            self
        }
        /// <p>Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).</p> <note>
        /// <p>You must have access to read Amazon S3 bucket.</p>
        /// </note>
        pub fn template_s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_s3_uri(input.into());
            self
        }
        /// <p>Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).</p> <note>
        /// <p>You must have access to read Amazon S3 bucket.</p>
        /// </note>
        pub fn set_template_s3_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_s3_uri(input);
            self
        }
        /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(input.into());
            self
        }
        /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
        /// <p>This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.</p>
        /// </note>
        pub fn delivery_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_s3_bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
        /// <p>This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.</p>
        /// </note>
        pub fn set_delivery_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_s3_bucket(input);
            self
        }
        /// <p>The prefix for the Amazon S3 bucket.</p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn delivery_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delivery_s3_key_prefix(input.into());
            self
        }
        /// <p>The prefix for the Amazon S3 bucket.</p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn set_delivery_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delivery_s3_key_prefix(input);
            self
        }
        /// Appends an item to `ConformancePackInputParameters`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_input_parameters`](Self::set_conformance_pack_input_parameters).
        ///
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn conformance_pack_input_parameters(
            mut self,
            input: crate::model::ConformancePackInputParameter,
        ) -> Self {
            self.inner = self.inner.conformance_pack_input_parameters(input);
            self
        }
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn set_conformance_pack_input_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
        ) -> Self {
            self.inner = self.inner.set_conformance_pack_input_parameters(input);
            self
        }
        /// Appends an item to `ExcludedAccounts`.
        ///
        /// To override the contents of this collection use [`set_excluded_accounts`](Self::set_excluded_accounts).
        ///
        /// <p>A list of Amazon Web Services accounts to be excluded from an organization conformance pack while deploying a conformance pack.</p>
        pub fn excluded_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.excluded_accounts(input.into());
            self
        }
        /// <p>A list of Amazon Web Services accounts to be excluded from an organization conformance pack while deploying a conformance pack.</p>
        pub fn set_excluded_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_excluded_accounts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRemediationConfigurations`.
    ///
    /// <p>Adds or updates the remediation configuration with a specific Config rule with the selected target or action. The API creates the <code>RemediationConfiguration</code> object for the Config rule. The Config rule must already exist for you to add a remediation configuration. The target (SSM document) must exist and have permissions to use the target. </p> <note>
    /// <p>If you make backward incompatible changes to the SSM document, you must call this again to ensure the remediations can run.</p>
    /// <p>This API does not support adding remediation configurations for service-linked Config Rules such as Organization Config rules, the rules deployed by conformance packs, and rules deployed by Amazon Web Services Security Hub.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRemediationConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_remediation_configurations_input::Builder,
    }
    impl<C, M, R> PutRemediationConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRemediationConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRemediationConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRemediationConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRemediationConfigurationsInputOperationOutputAlias,
                crate::output::PutRemediationConfigurationsOutput,
                crate::error::PutRemediationConfigurationsError,
                crate::input::PutRemediationConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `RemediationConfigurations`.
        ///
        /// To override the contents of this collection use [`set_remediation_configurations`](Self::set_remediation_configurations).
        ///
        /// <p>A list of remediation configuration objects.</p>
        pub fn remediation_configurations(
            mut self,
            input: crate::model::RemediationConfiguration,
        ) -> Self {
            self.inner = self.inner.remediation_configurations(input);
            self
        }
        /// <p>A list of remediation configuration objects.</p>
        pub fn set_remediation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RemediationConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_remediation_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRemediationExceptions`.
    ///
    /// <p>A remediation exception is when a specific resource is no longer considered for auto-remediation. This API adds a new exception or updates an existing exception for a specific resource with a specific Config rule. </p> <note>
    /// <p>Config generates a remediation exception when a problem occurs executing a remediation action to a specific resource. Remediation exceptions blocks auto-remediation until the exception is cleared.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRemediationExceptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_remediation_exceptions_input::Builder,
    }
    impl<C, M, R> PutRemediationExceptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRemediationExceptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRemediationExceptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRemediationExceptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRemediationExceptionsInputOperationOutputAlias,
                crate::output::PutRemediationExceptionsOutput,
                crate::error::PutRemediationExceptionsError,
                crate::input::PutRemediationExceptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Config rule for which you want to create remediation exception.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_name(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want to create remediation exception.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_name(input);
            self
        }
        /// Appends an item to `ResourceKeys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn resource_keys(
            mut self,
            input: crate::model::RemediationExceptionResourceKey,
        ) -> Self {
            self.inner = self.inner.resource_keys(input);
            self
        }
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RemediationExceptionResourceKey>,
            >,
        ) -> Self {
            self.inner = self.inner.set_resource_keys(input);
            self
        }
        /// <p>The message contains an explanation of the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message(input.into());
            self
        }
        /// <p>The message contains an explanation of the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message(input);
            self
        }
        /// <p>The exception is automatically deleted after the expiration date.</p>
        pub fn expiration_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.expiration_time(input);
            self
        }
        /// <p>The exception is automatically deleted after the expiration date.</p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_expiration_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourceConfig`.
    ///
    /// <p>Records the configuration state for the resource provided in the request. The configuration state of a resource is represented in Config as Configuration Items. Once this API records the configuration item, you can retrieve the list of configuration items for the custom resource type using existing Config APIs. </p> <note>
    /// <p>The custom resource type must be registered with CloudFormation. This API accepts the configuration item registered with CloudFormation.</p>
    /// <p>When you call this API, Config only stores configuration state of the resource provided in the request. This API does not change or remediate the configuration of the resource. </p>
    /// <p>Write-only schema properites are not recorded as part of the published configuration item.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourceConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resource_config_input::Builder,
    }
    impl<C, M, R> PutResourceConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResourceConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourceConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourceConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResourceConfigInputOperationOutputAlias,
                crate::output::PutResourceConfigOutput,
                crate::error::PutResourceConfigError,
                crate::input::PutResourceConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the resource. The custom resource type must be registered with CloudFormation. </p> <note>
        /// <p>You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the first part of the ResourceType up to the first ::.</p>
        /// </note>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The type of the resource. The custom resource type must be registered with CloudFormation. </p> <note>
        /// <p>You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the first part of the ResourceType up to the first ::.</p>
        /// </note>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>Version of the schema registered for the ResourceType in CloudFormation.</p>
        pub fn schema_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_version_id(input.into());
            self
        }
        /// <p>Version of the schema registered for the ResourceType in CloudFormation.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_version_id(input);
            self
        }
        /// <p>Unique identifier of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>Unique identifier of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Name of the resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>Name of the resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>The configuration object of the resource in valid JSON format. It must match the schema registered with CloudFormation.</p> <note>
        /// <p>The configuration JSON must not exceed 64 KB.</p>
        /// </note>
        pub fn configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration(input.into());
            self
        }
        /// <p>The configuration object of the resource in valid JSON format. It must match the schema registered with CloudFormation.</p> <note>
        /// <p>The configuration JSON must not exceed 64 KB.</p>
        /// </note>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRetentionConfiguration`.
    ///
    /// <p>Creates and updates the retention configuration with details about retention period (number of days) that Config stores your historical information. The API creates the <code>RetentionConfiguration</code> object and names the object as <b>default</b>. When you have a <code>RetentionConfiguration</code> object named <b>default</b>, calling the API modifies the default object. </p> <note>
    /// <p>Currently, Config supports only one retention configuration per region in your account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRetentionConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_retention_configuration_input::Builder,
    }
    impl<C, M, R> PutRetentionConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRetentionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRetentionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRetentionConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRetentionConfigurationInputOperationOutputAlias,
                crate::output::PutRetentionConfigurationOutput,
                crate::error::PutRetentionConfigurationError,
                crate::input::PutRetentionConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Number of days Config stores your historical information.</p> <note>
        /// <p>Currently, only applicable to the configuration item history.</p>
        /// </note>
        pub fn retention_period_in_days(mut self, input: i32) -> Self {
            self.inner = self.inner.retention_period_in_days(input);
            self
        }
        /// <p>Number of days Config stores your historical information.</p> <note>
        /// <p>Currently, only applicable to the configuration item history.</p>
        /// </note>
        pub fn set_retention_period_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_retention_period_in_days(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutStoredQuery`.
    ///
    /// <p>Saves a new query or updates an existing saved query. The <code>QueryName</code> must be unique for a single Amazon Web Services account and a single Amazon Web Services Region. You can create upto 300 queries in a single Amazon Web Services account and a single Amazon Web Services Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutStoredQuery<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_stored_query_input::Builder,
    }
    impl<C, M, R> PutStoredQuery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutStoredQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutStoredQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::PutStoredQueryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutStoredQueryInputOperationOutputAlias,
                crate::output::PutStoredQueryOutput,
                crate::error::PutStoredQueryError,
                crate::input::PutStoredQueryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and <code>Expression</code>.</p> <note>
        /// <p>When you are creating a query, you must provide a query name and an expression. When you are updating a query, you must provide a query name but updating the description is optional.</p>
        /// </note>
        pub fn stored_query(mut self, input: crate::model::StoredQuery) -> Self {
            self.inner = self.inner.stored_query(input);
            self
        }
        /// <p>A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and <code>Expression</code>.</p> <note>
        /// <p>When you are creating a query, you must provide a query name and an expression. When you are updating a query, you must provide a query name but updating the description is optional.</p>
        /// </note>
        pub fn set_stored_query(
            mut self,
            input: std::option::Option<crate::model::StoredQuery>,
        ) -> Self {
            self.inner = self.inner.set_stored_query(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tags</code> object.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of <code>Tags</code> object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SelectAggregateResourceConfig`.
    ///
    /// <p>Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of Amazon Web Services resources across multiple accounts and regions, performs the corresponding search, and returns resource configurations matching the properties.</p>
    /// <p>For more information about query components, see the <a href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b> </a> section in the Config Developer Guide.</p> <note>
    /// <p>If you run an aggregation query (i.e., using <code>GROUP BY</code> or using aggregate functions such as <code>COUNT</code>; e.g., <code>SELECT resourceId, COUNT(*) WHERE resourceType = 'AWS::IAM::Role' GROUP BY resourceId</code>) and do not specify the <code>MaxResults</code> or the <code>Limit</code> query parameters, the default page size is set to 500.</p>
    /// <p>If you run a non-aggregation query (i.e., not using <code>GROUP BY</code> or aggregate function; e.g., <code>SELECT * WHERE resourceType = 'AWS::IAM::Role'</code>) and do not specify the <code>MaxResults</code> or the <code>Limit</code> query parameters, the default page size is set to 25.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SelectAggregateResourceConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::select_aggregate_resource_config_input::Builder,
    }
    impl<C, M, R> SelectAggregateResourceConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SelectAggregateResourceConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SelectAggregateResourceConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::SelectAggregateResourceConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SelectAggregateResourceConfigInputOperationOutputAlias,
                crate::output::SelectAggregateResourceConfigOutput,
                crate::error::SelectAggregateResourceConfigError,
                crate::input::SelectAggregateResourceConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SelectAggregateResourceConfigPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::SelectAggregateResourceConfigPaginator<C, M, R> {
            crate::paginator::SelectAggregateResourceConfigPaginator::new(self.handle, self.inner)
        }
        /// <p>The SQL query SELECT command. </p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(input.into());
            self
        }
        /// <p>The SQL query SELECT command. </p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_aggregator_name(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_aggregator_name(input);
            self
        }
        /// <p>The maximum number of query results returned on each page. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of query results returned on each page. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The maximum number of query results returned on each page. Config also allows the Limit request parameter.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of query results returned on each page. Config also allows the Limit request parameter.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SelectResourceConfig`.
    ///
    /// <p>Accepts a structured query language (SQL) <code>SELECT</code> command, performs the corresponding search, and returns resource configurations matching the properties.</p>
    /// <p>For more information about query components, see the <a href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b> </a> section in the Config Developer Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SelectResourceConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::select_resource_config_input::Builder,
    }
    impl<C, M, R> SelectResourceConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SelectResourceConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SelectResourceConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::SelectResourceConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SelectResourceConfigInputOperationOutputAlias,
                crate::output::SelectResourceConfigOutput,
                crate::error::SelectResourceConfigError,
                crate::input::SelectResourceConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SelectResourceConfigPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SelectResourceConfigPaginator<C, M, R> {
            crate::paginator::SelectResourceConfigPaginator::new(self.handle, self.inner)
        }
        /// <p>The SQL query <code>SELECT</code> command.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(input.into());
            self
        }
        /// <p>The SQL query <code>SELECT</code> command.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>The maximum number of query results returned on each page. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of query results returned on each page. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartConfigRulesEvaluation`.
    ///
    /// <p>Runs an on-demand evaluation for the specified Config rules against the last known configuration state of the resources. Use <code>StartConfigRulesEvaluation</code> when you want to test that a rule you updated is working as expected. <code>StartConfigRulesEvaluation</code> does not re-record the latest configuration state for your resources. It re-runs an evaluation against the last known state of your resources. </p>
    /// <p>You can specify up to 25 Config rules per request. </p>
    /// <p>An existing <code>StartConfigRulesEvaluation</code> call for the specified rules must complete before you can call the API again. If you chose to have Config stream to an Amazon SNS topic, you will receive a <code>ConfigRuleEvaluationStarted</code> notification when the evaluation starts.</p> <note>
    /// <p>You don't need to call the <code>StartConfigRulesEvaluation</code> API to run an evaluation for a new rule. When you create a rule, Config evaluates your resources against the rule automatically. </p>
    /// </note>
    /// <p>The <code>StartConfigRulesEvaluation</code> API is useful if you want to run on-demand evaluations, such as the following example:</p>
    /// <ol>
    /// <li> <p>You have a custom rule that evaluates your IAM resources every 24 hours.</p> </li>
    /// <li> <p>You update your Lambda function to add additional conditions to your rule.</p> </li>
    /// <li> <p>Instead of waiting for the next periodic evaluation, you call the <code>StartConfigRulesEvaluation</code> API.</p> </li>
    /// <li> <p>Config invokes your Lambda function and evaluates your IAM resources.</p> </li>
    /// <li> <p>Your custom rule will still run periodic evaluations every 24 hours.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartConfigRulesEvaluation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_config_rules_evaluation_input::Builder,
    }
    impl<C, M, R> StartConfigRulesEvaluation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartConfigRulesEvaluation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartConfigRulesEvaluationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartConfigRulesEvaluationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartConfigRulesEvaluationInputOperationOutputAlias,
                crate::output::StartConfigRulesEvaluationOutput,
                crate::error::StartConfigRulesEvaluationError,
                crate::input::StartConfigRulesEvaluationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ConfigRuleNames`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>The list of names of Config rules that you want to run evaluations for.</p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_names(input.into());
            self
        }
        /// <p>The list of names of Config rules that you want to run evaluations for.</p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartConfigurationRecorder`.
    ///
    /// <p>Starts recording configurations of the Amazon Web Services resources you have selected to record in your Amazon Web Services account.</p>
    /// <p>You must have created at least one delivery channel to successfully start the configuration recorder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartConfigurationRecorder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_configuration_recorder_input::Builder,
    }
    impl<C, M, R> StartConfigurationRecorder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartConfigurationRecorder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartConfigurationRecorderOutput,
            aws_smithy_http::result::SdkError<crate::error::StartConfigurationRecorderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartConfigurationRecorderInputOperationOutputAlias,
                crate::output::StartConfigurationRecorderOutput,
                crate::error::StartConfigurationRecorderError,
                crate::input::StartConfigurationRecorderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
        pub fn configuration_recorder_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_recorder_name(input.into());
            self
        }
        /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
        pub fn set_configuration_recorder_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_recorder_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartRemediationExecution`.
    ///
    /// <p>Runs an on-demand remediation for the specified Config rules against the last known remediation configuration. It runs an execution against the current state of your resources. Remediation execution is asynchronous.</p>
    /// <p>You can specify up to 100 resource keys per request. An existing StartRemediationExecution call for the specified resource keys must complete before you can call the API again.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartRemediationExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_remediation_execution_input::Builder,
    }
    impl<C, M, R> StartRemediationExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartRemediationExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartRemediationExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartRemediationExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartRemediationExecutionInputOperationOutputAlias,
                crate::output::StartRemediationExecutionOutput,
                crate::error::StartRemediationExecutionError,
                crate::input::StartRemediationExecutionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The list of names of Config rules that you want to run remediation execution for.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_rule_name(input.into());
            self
        }
        /// <p>The list of names of Config rules that you want to run remediation execution for.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_config_rule_name(input);
            self
        }
        /// Appends an item to `ResourceKeys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
        pub fn resource_keys(mut self, input: crate::model::ResourceKey) -> Self {
            self.inner = self.inner.resource_keys(input);
            self
        }
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
        ) -> Self {
            self.inner = self.inner.set_resource_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopConfigurationRecorder`.
    ///
    /// <p>Stops recording configurations of the Amazon Web Services resources you have selected to record in your Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopConfigurationRecorder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_configuration_recorder_input::Builder,
    }
    impl<C, M, R> StopConfigurationRecorder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopConfigurationRecorder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopConfigurationRecorderOutput,
            aws_smithy_http::result::SdkError<crate::error::StopConfigurationRecorderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopConfigurationRecorderInputOperationOutputAlias,
                crate::output::StopConfigurationRecorderOutput,
                crate::error::StopConfigurationRecorderError,
                crate::input::StopConfigurationRecorderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
        pub fn configuration_recorder_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.configuration_recorder_name(input.into());
            self
        }
        /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
        pub fn set_configuration_recorder_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_recorder_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tag object.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of tag object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes specified tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
