// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchGetAggregateResourceConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_aggregate_resource_config`](crate::client::Client::batch_get_aggregate_resource_config).
///
/// See [`crate::client::fluent_builders::BatchGetAggregateResourceConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetAggregateResourceConfig {
    _private: (),
}
impl BatchGetAggregateResourceConfig {
    /// Creates a new builder-style object to manufacture [`BatchGetAggregateResourceConfigInput`](crate::input::BatchGetAggregateResourceConfigInput)
    pub fn builder() -> crate::input::batch_get_aggregate_resource_config_input::Builder {
        crate::input::batch_get_aggregate_resource_config_input::Builder::default()
    }
    /// Creates a new `BatchGetAggregateResourceConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetAggregateResourceConfig {
    type Output = std::result::Result<
        crate::output::BatchGetAggregateResourceConfigOutput,
        crate::error::BatchGetAggregateResourceConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_aggregate_resource_config_error(response)
        } else {
            crate::operation_deser::parse_batch_get_aggregate_resource_config_response(response)
        }
    }
}

/// Operation shape for `BatchGetResourceConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_resource_config`](crate::client::Client::batch_get_resource_config).
///
/// See [`crate::client::fluent_builders::BatchGetResourceConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetResourceConfig {
    _private: (),
}
impl BatchGetResourceConfig {
    /// Creates a new builder-style object to manufacture [`BatchGetResourceConfigInput`](crate::input::BatchGetResourceConfigInput)
    pub fn builder() -> crate::input::batch_get_resource_config_input::Builder {
        crate::input::batch_get_resource_config_input::Builder::default()
    }
    /// Creates a new `BatchGetResourceConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetResourceConfig {
    type Output = std::result::Result<
        crate::output::BatchGetResourceConfigOutput,
        crate::error::BatchGetResourceConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_resource_config_error(response)
        } else {
            crate::operation_deser::parse_batch_get_resource_config_response(response)
        }
    }
}

/// Operation shape for `DeleteAggregationAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_aggregation_authorization`](crate::client::Client::delete_aggregation_authorization).
///
/// See [`crate::client::fluent_builders::DeleteAggregationAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAggregationAuthorization {
    _private: (),
}
impl DeleteAggregationAuthorization {
    /// Creates a new builder-style object to manufacture [`DeleteAggregationAuthorizationInput`](crate::input::DeleteAggregationAuthorizationInput)
    pub fn builder() -> crate::input::delete_aggregation_authorization_input::Builder {
        crate::input::delete_aggregation_authorization_input::Builder::default()
    }
    /// Creates a new `DeleteAggregationAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAggregationAuthorization {
    type Output = std::result::Result<
        crate::output::DeleteAggregationAuthorizationOutput,
        crate::error::DeleteAggregationAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_aggregation_authorization_error(response)
        } else {
            crate::operation_deser::parse_delete_aggregation_authorization_response(response)
        }
    }
}

/// Operation shape for `DeleteConfigRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_config_rule`](crate::client::Client::delete_config_rule).
///
/// See [`crate::client::fluent_builders::DeleteConfigRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConfigRule {
    _private: (),
}
impl DeleteConfigRule {
    /// Creates a new builder-style object to manufacture [`DeleteConfigRuleInput`](crate::input::DeleteConfigRuleInput)
    pub fn builder() -> crate::input::delete_config_rule_input::Builder {
        crate::input::delete_config_rule_input::Builder::default()
    }
    /// Creates a new `DeleteConfigRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConfigRule {
    type Output = std::result::Result<
        crate::output::DeleteConfigRuleOutput,
        crate::error::DeleteConfigRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_config_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_config_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteConfigurationAggregator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_configuration_aggregator`](crate::client::Client::delete_configuration_aggregator).
///
/// See [`crate::client::fluent_builders::DeleteConfigurationAggregator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConfigurationAggregator {
    _private: (),
}
impl DeleteConfigurationAggregator {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationAggregatorInput`](crate::input::DeleteConfigurationAggregatorInput)
    pub fn builder() -> crate::input::delete_configuration_aggregator_input::Builder {
        crate::input::delete_configuration_aggregator_input::Builder::default()
    }
    /// Creates a new `DeleteConfigurationAggregator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConfigurationAggregator {
    type Output = std::result::Result<
        crate::output::DeleteConfigurationAggregatorOutput,
        crate::error::DeleteConfigurationAggregatorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_configuration_aggregator_error(response)
        } else {
            crate::operation_deser::parse_delete_configuration_aggregator_response(response)
        }
    }
}

/// Operation shape for `DeleteConfigurationRecorder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_configuration_recorder`](crate::client::Client::delete_configuration_recorder).
///
/// See [`crate::client::fluent_builders::DeleteConfigurationRecorder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConfigurationRecorder {
    _private: (),
}
impl DeleteConfigurationRecorder {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationRecorderInput`](crate::input::DeleteConfigurationRecorderInput)
    pub fn builder() -> crate::input::delete_configuration_recorder_input::Builder {
        crate::input::delete_configuration_recorder_input::Builder::default()
    }
    /// Creates a new `DeleteConfigurationRecorder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConfigurationRecorder {
    type Output = std::result::Result<
        crate::output::DeleteConfigurationRecorderOutput,
        crate::error::DeleteConfigurationRecorderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_configuration_recorder_error(response)
        } else {
            crate::operation_deser::parse_delete_configuration_recorder_response(response)
        }
    }
}

/// Operation shape for `DeleteConformancePack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_conformance_pack`](crate::client::Client::delete_conformance_pack).
///
/// See [`crate::client::fluent_builders::DeleteConformancePack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConformancePack {
    _private: (),
}
impl DeleteConformancePack {
    /// Creates a new builder-style object to manufacture [`DeleteConformancePackInput`](crate::input::DeleteConformancePackInput)
    pub fn builder() -> crate::input::delete_conformance_pack_input::Builder {
        crate::input::delete_conformance_pack_input::Builder::default()
    }
    /// Creates a new `DeleteConformancePack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConformancePack {
    type Output = std::result::Result<
        crate::output::DeleteConformancePackOutput,
        crate::error::DeleteConformancePackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_conformance_pack_error(response)
        } else {
            crate::operation_deser::parse_delete_conformance_pack_response(response)
        }
    }
}

/// Operation shape for `DeleteDeliveryChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_delivery_channel`](crate::client::Client::delete_delivery_channel).
///
/// See [`crate::client::fluent_builders::DeleteDeliveryChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDeliveryChannel {
    _private: (),
}
impl DeleteDeliveryChannel {
    /// Creates a new builder-style object to manufacture [`DeleteDeliveryChannelInput`](crate::input::DeleteDeliveryChannelInput)
    pub fn builder() -> crate::input::delete_delivery_channel_input::Builder {
        crate::input::delete_delivery_channel_input::Builder::default()
    }
    /// Creates a new `DeleteDeliveryChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDeliveryChannel {
    type Output = std::result::Result<
        crate::output::DeleteDeliveryChannelOutput,
        crate::error::DeleteDeliveryChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_delivery_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_delivery_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteEvaluationResults`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_evaluation_results`](crate::client::Client::delete_evaluation_results).
///
/// See [`crate::client::fluent_builders::DeleteEvaluationResults`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEvaluationResults {
    _private: (),
}
impl DeleteEvaluationResults {
    /// Creates a new builder-style object to manufacture [`DeleteEvaluationResultsInput`](crate::input::DeleteEvaluationResultsInput)
    pub fn builder() -> crate::input::delete_evaluation_results_input::Builder {
        crate::input::delete_evaluation_results_input::Builder::default()
    }
    /// Creates a new `DeleteEvaluationResults` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEvaluationResults {
    type Output = std::result::Result<
        crate::output::DeleteEvaluationResultsOutput,
        crate::error::DeleteEvaluationResultsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_evaluation_results_error(response)
        } else {
            crate::operation_deser::parse_delete_evaluation_results_response(response)
        }
    }
}

/// Operation shape for `DeleteOrganizationConfigRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_organization_config_rule`](crate::client::Client::delete_organization_config_rule).
///
/// See [`crate::client::fluent_builders::DeleteOrganizationConfigRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOrganizationConfigRule {
    _private: (),
}
impl DeleteOrganizationConfigRule {
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationConfigRuleInput`](crate::input::DeleteOrganizationConfigRuleInput)
    pub fn builder() -> crate::input::delete_organization_config_rule_input::Builder {
        crate::input::delete_organization_config_rule_input::Builder::default()
    }
    /// Creates a new `DeleteOrganizationConfigRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOrganizationConfigRule {
    type Output = std::result::Result<
        crate::output::DeleteOrganizationConfigRuleOutput,
        crate::error::DeleteOrganizationConfigRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_organization_config_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_organization_config_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteOrganizationConformancePack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_organization_conformance_pack`](crate::client::Client::delete_organization_conformance_pack).
///
/// See [`crate::client::fluent_builders::DeleteOrganizationConformancePack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOrganizationConformancePack {
    _private: (),
}
impl DeleteOrganizationConformancePack {
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationConformancePackInput`](crate::input::DeleteOrganizationConformancePackInput)
    pub fn builder() -> crate::input::delete_organization_conformance_pack_input::Builder {
        crate::input::delete_organization_conformance_pack_input::Builder::default()
    }
    /// Creates a new `DeleteOrganizationConformancePack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOrganizationConformancePack {
    type Output = std::result::Result<
        crate::output::DeleteOrganizationConformancePackOutput,
        crate::error::DeleteOrganizationConformancePackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_organization_conformance_pack_error(response)
        } else {
            crate::operation_deser::parse_delete_organization_conformance_pack_response(response)
        }
    }
}

/// Operation shape for `DeletePendingAggregationRequest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_pending_aggregation_request`](crate::client::Client::delete_pending_aggregation_request).
///
/// See [`crate::client::fluent_builders::DeletePendingAggregationRequest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePendingAggregationRequest {
    _private: (),
}
impl DeletePendingAggregationRequest {
    /// Creates a new builder-style object to manufacture [`DeletePendingAggregationRequestInput`](crate::input::DeletePendingAggregationRequestInput)
    pub fn builder() -> crate::input::delete_pending_aggregation_request_input::Builder {
        crate::input::delete_pending_aggregation_request_input::Builder::default()
    }
    /// Creates a new `DeletePendingAggregationRequest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePendingAggregationRequest {
    type Output = std::result::Result<
        crate::output::DeletePendingAggregationRequestOutput,
        crate::error::DeletePendingAggregationRequestError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_pending_aggregation_request_error(response)
        } else {
            crate::operation_deser::parse_delete_pending_aggregation_request_response(response)
        }
    }
}

/// Operation shape for `DeleteRemediationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_remediation_configuration`](crate::client::Client::delete_remediation_configuration).
///
/// See [`crate::client::fluent_builders::DeleteRemediationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRemediationConfiguration {
    _private: (),
}
impl DeleteRemediationConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteRemediationConfigurationInput`](crate::input::DeleteRemediationConfigurationInput)
    pub fn builder() -> crate::input::delete_remediation_configuration_input::Builder {
        crate::input::delete_remediation_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteRemediationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRemediationConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteRemediationConfigurationOutput,
        crate::error::DeleteRemediationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_remediation_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_remediation_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteRemediationExceptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_remediation_exceptions`](crate::client::Client::delete_remediation_exceptions).
///
/// See [`crate::client::fluent_builders::DeleteRemediationExceptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRemediationExceptions {
    _private: (),
}
impl DeleteRemediationExceptions {
    /// Creates a new builder-style object to manufacture [`DeleteRemediationExceptionsInput`](crate::input::DeleteRemediationExceptionsInput)
    pub fn builder() -> crate::input::delete_remediation_exceptions_input::Builder {
        crate::input::delete_remediation_exceptions_input::Builder::default()
    }
    /// Creates a new `DeleteRemediationExceptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRemediationExceptions {
    type Output = std::result::Result<
        crate::output::DeleteRemediationExceptionsOutput,
        crate::error::DeleteRemediationExceptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_remediation_exceptions_error(response)
        } else {
            crate::operation_deser::parse_delete_remediation_exceptions_response(response)
        }
    }
}

/// Operation shape for `DeleteResourceConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_config`](crate::client::Client::delete_resource_config).
///
/// See [`crate::client::fluent_builders::DeleteResourceConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourceConfig {
    _private: (),
}
impl DeleteResourceConfig {
    /// Creates a new builder-style object to manufacture [`DeleteResourceConfigInput`](crate::input::DeleteResourceConfigInput)
    pub fn builder() -> crate::input::delete_resource_config_input::Builder {
        crate::input::delete_resource_config_input::Builder::default()
    }
    /// Creates a new `DeleteResourceConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourceConfig {
    type Output = std::result::Result<
        crate::output::DeleteResourceConfigOutput,
        crate::error::DeleteResourceConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_config_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_config_response(response)
        }
    }
}

/// Operation shape for `DeleteRetentionConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_retention_configuration`](crate::client::Client::delete_retention_configuration).
///
/// See [`crate::client::fluent_builders::DeleteRetentionConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRetentionConfiguration {
    _private: (),
}
impl DeleteRetentionConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteRetentionConfigurationInput`](crate::input::DeleteRetentionConfigurationInput)
    pub fn builder() -> crate::input::delete_retention_configuration_input::Builder {
        crate::input::delete_retention_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteRetentionConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRetentionConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteRetentionConfigurationOutput,
        crate::error::DeleteRetentionConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_retention_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_retention_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteStoredQuery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stored_query`](crate::client::Client::delete_stored_query).
///
/// See [`crate::client::fluent_builders::DeleteStoredQuery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStoredQuery {
    _private: (),
}
impl DeleteStoredQuery {
    /// Creates a new builder-style object to manufacture [`DeleteStoredQueryInput`](crate::input::DeleteStoredQueryInput)
    pub fn builder() -> crate::input::delete_stored_query_input::Builder {
        crate::input::delete_stored_query_input::Builder::default()
    }
    /// Creates a new `DeleteStoredQuery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStoredQuery {
    type Output = std::result::Result<
        crate::output::DeleteStoredQueryOutput,
        crate::error::DeleteStoredQueryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_stored_query_error(response)
        } else {
            crate::operation_deser::parse_delete_stored_query_response(response)
        }
    }
}

/// Operation shape for `DeliverConfigSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deliver_config_snapshot`](crate::client::Client::deliver_config_snapshot).
///
/// See [`crate::client::fluent_builders::DeliverConfigSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeliverConfigSnapshot {
    _private: (),
}
impl DeliverConfigSnapshot {
    /// Creates a new builder-style object to manufacture [`DeliverConfigSnapshotInput`](crate::input::DeliverConfigSnapshotInput)
    pub fn builder() -> crate::input::deliver_config_snapshot_input::Builder {
        crate::input::deliver_config_snapshot_input::Builder::default()
    }
    /// Creates a new `DeliverConfigSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeliverConfigSnapshot {
    type Output = std::result::Result<
        crate::output::DeliverConfigSnapshotOutput,
        crate::error::DeliverConfigSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deliver_config_snapshot_error(response)
        } else {
            crate::operation_deser::parse_deliver_config_snapshot_response(response)
        }
    }
}

/// Operation shape for `DescribeAggregateComplianceByConfigRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_aggregate_compliance_by_config_rules`](crate::client::Client::describe_aggregate_compliance_by_config_rules).
///
/// See [`crate::client::fluent_builders::DescribeAggregateComplianceByConfigRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAggregateComplianceByConfigRules {
    _private: (),
}
impl DescribeAggregateComplianceByConfigRules {
    /// Creates a new builder-style object to manufacture [`DescribeAggregateComplianceByConfigRulesInput`](crate::input::DescribeAggregateComplianceByConfigRulesInput)
    pub fn builder() -> crate::input::describe_aggregate_compliance_by_config_rules_input::Builder {
        crate::input::describe_aggregate_compliance_by_config_rules_input::Builder::default()
    }
    /// Creates a new `DescribeAggregateComplianceByConfigRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAggregateComplianceByConfigRules {
    type Output = std::result::Result<
        crate::output::DescribeAggregateComplianceByConfigRulesOutput,
        crate::error::DescribeAggregateComplianceByConfigRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_aggregate_compliance_by_config_rules_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_aggregate_compliance_by_config_rules_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeAggregateComplianceByConformancePacks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_aggregate_compliance_by_conformance_packs`](crate::client::Client::describe_aggregate_compliance_by_conformance_packs).
///
/// See [`crate::client::fluent_builders::DescribeAggregateComplianceByConformancePacks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAggregateComplianceByConformancePacks {
    _private: (),
}
impl DescribeAggregateComplianceByConformancePacks {
    /// Creates a new builder-style object to manufacture [`DescribeAggregateComplianceByConformancePacksInput`](crate::input::DescribeAggregateComplianceByConformancePacksInput)
    pub fn builder(
    ) -> crate::input::describe_aggregate_compliance_by_conformance_packs_input::Builder {
        crate::input::describe_aggregate_compliance_by_conformance_packs_input::Builder::default()
    }
    /// Creates a new `DescribeAggregateComplianceByConformancePacks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeAggregateComplianceByConformancePacks
{
    type Output = std::result::Result<
        crate::output::DescribeAggregateComplianceByConformancePacksOutput,
        crate::error::DescribeAggregateComplianceByConformancePacksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_aggregate_compliance_by_conformance_packs_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_aggregate_compliance_by_conformance_packs_response(response)
        }
    }
}

/// Operation shape for `DescribeAggregationAuthorizations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_aggregation_authorizations`](crate::client::Client::describe_aggregation_authorizations).
///
/// See [`crate::client::fluent_builders::DescribeAggregationAuthorizations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAggregationAuthorizations {
    _private: (),
}
impl DescribeAggregationAuthorizations {
    /// Creates a new builder-style object to manufacture [`DescribeAggregationAuthorizationsInput`](crate::input::DescribeAggregationAuthorizationsInput)
    pub fn builder() -> crate::input::describe_aggregation_authorizations_input::Builder {
        crate::input::describe_aggregation_authorizations_input::Builder::default()
    }
    /// Creates a new `DescribeAggregationAuthorizations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAggregationAuthorizations {
    type Output = std::result::Result<
        crate::output::DescribeAggregationAuthorizationsOutput,
        crate::error::DescribeAggregationAuthorizationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_aggregation_authorizations_error(response)
        } else {
            crate::operation_deser::parse_describe_aggregation_authorizations_response(response)
        }
    }
}

/// Operation shape for `DescribeComplianceByConfigRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_compliance_by_config_rule`](crate::client::Client::describe_compliance_by_config_rule).
///
/// See [`crate::client::fluent_builders::DescribeComplianceByConfigRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeComplianceByConfigRule {
    _private: (),
}
impl DescribeComplianceByConfigRule {
    /// Creates a new builder-style object to manufacture [`DescribeComplianceByConfigRuleInput`](crate::input::DescribeComplianceByConfigRuleInput)
    pub fn builder() -> crate::input::describe_compliance_by_config_rule_input::Builder {
        crate::input::describe_compliance_by_config_rule_input::Builder::default()
    }
    /// Creates a new `DescribeComplianceByConfigRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeComplianceByConfigRule {
    type Output = std::result::Result<
        crate::output::DescribeComplianceByConfigRuleOutput,
        crate::error::DescribeComplianceByConfigRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_compliance_by_config_rule_error(response)
        } else {
            crate::operation_deser::parse_describe_compliance_by_config_rule_response(response)
        }
    }
}

/// Operation shape for `DescribeComplianceByResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_compliance_by_resource`](crate::client::Client::describe_compliance_by_resource).
///
/// See [`crate::client::fluent_builders::DescribeComplianceByResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeComplianceByResource {
    _private: (),
}
impl DescribeComplianceByResource {
    /// Creates a new builder-style object to manufacture [`DescribeComplianceByResourceInput`](crate::input::DescribeComplianceByResourceInput)
    pub fn builder() -> crate::input::describe_compliance_by_resource_input::Builder {
        crate::input::describe_compliance_by_resource_input::Builder::default()
    }
    /// Creates a new `DescribeComplianceByResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeComplianceByResource {
    type Output = std::result::Result<
        crate::output::DescribeComplianceByResourceOutput,
        crate::error::DescribeComplianceByResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_compliance_by_resource_error(response)
        } else {
            crate::operation_deser::parse_describe_compliance_by_resource_response(response)
        }
    }
}

/// Operation shape for `DescribeConfigRuleEvaluationStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_config_rule_evaluation_status`](crate::client::Client::describe_config_rule_evaluation_status).
///
/// See [`crate::client::fluent_builders::DescribeConfigRuleEvaluationStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConfigRuleEvaluationStatus {
    _private: (),
}
impl DescribeConfigRuleEvaluationStatus {
    /// Creates a new builder-style object to manufacture [`DescribeConfigRuleEvaluationStatusInput`](crate::input::DescribeConfigRuleEvaluationStatusInput)
    pub fn builder() -> crate::input::describe_config_rule_evaluation_status_input::Builder {
        crate::input::describe_config_rule_evaluation_status_input::Builder::default()
    }
    /// Creates a new `DescribeConfigRuleEvaluationStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConfigRuleEvaluationStatus {
    type Output = std::result::Result<
        crate::output::DescribeConfigRuleEvaluationStatusOutput,
        crate::error::DescribeConfigRuleEvaluationStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_config_rule_evaluation_status_error(response)
        } else {
            crate::operation_deser::parse_describe_config_rule_evaluation_status_response(response)
        }
    }
}

/// Operation shape for `DescribeConfigRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_config_rules`](crate::client::Client::describe_config_rules).
///
/// See [`crate::client::fluent_builders::DescribeConfigRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConfigRules {
    _private: (),
}
impl DescribeConfigRules {
    /// Creates a new builder-style object to manufacture [`DescribeConfigRulesInput`](crate::input::DescribeConfigRulesInput)
    pub fn builder() -> crate::input::describe_config_rules_input::Builder {
        crate::input::describe_config_rules_input::Builder::default()
    }
    /// Creates a new `DescribeConfigRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConfigRules {
    type Output = std::result::Result<
        crate::output::DescribeConfigRulesOutput,
        crate::error::DescribeConfigRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_config_rules_error(response)
        } else {
            crate::operation_deser::parse_describe_config_rules_response(response)
        }
    }
}

/// Operation shape for `DescribeConfigurationAggregators`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_configuration_aggregators`](crate::client::Client::describe_configuration_aggregators).
///
/// See [`crate::client::fluent_builders::DescribeConfigurationAggregators`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConfigurationAggregators {
    _private: (),
}
impl DescribeConfigurationAggregators {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationAggregatorsInput`](crate::input::DescribeConfigurationAggregatorsInput)
    pub fn builder() -> crate::input::describe_configuration_aggregators_input::Builder {
        crate::input::describe_configuration_aggregators_input::Builder::default()
    }
    /// Creates a new `DescribeConfigurationAggregators` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConfigurationAggregators {
    type Output = std::result::Result<
        crate::output::DescribeConfigurationAggregatorsOutput,
        crate::error::DescribeConfigurationAggregatorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_configuration_aggregators_error(response)
        } else {
            crate::operation_deser::parse_describe_configuration_aggregators_response(response)
        }
    }
}

/// Operation shape for `DescribeConfigurationAggregatorSourcesStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_configuration_aggregator_sources_status`](crate::client::Client::describe_configuration_aggregator_sources_status).
///
/// See [`crate::client::fluent_builders::DescribeConfigurationAggregatorSourcesStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConfigurationAggregatorSourcesStatus {
    _private: (),
}
impl DescribeConfigurationAggregatorSourcesStatus {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationAggregatorSourcesStatusInput`](crate::input::DescribeConfigurationAggregatorSourcesStatusInput)
    pub fn builder() -> crate::input::describe_configuration_aggregator_sources_status_input::Builder
    {
        crate::input::describe_configuration_aggregator_sources_status_input::Builder::default()
    }
    /// Creates a new `DescribeConfigurationAggregatorSourcesStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeConfigurationAggregatorSourcesStatus
{
    type Output = std::result::Result<
        crate::output::DescribeConfigurationAggregatorSourcesStatusOutput,
        crate::error::DescribeConfigurationAggregatorSourcesStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_configuration_aggregator_sources_status_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_configuration_aggregator_sources_status_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeConfigurationRecorders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_configuration_recorders`](crate::client::Client::describe_configuration_recorders).
///
/// See [`crate::client::fluent_builders::DescribeConfigurationRecorders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConfigurationRecorders {
    _private: (),
}
impl DescribeConfigurationRecorders {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationRecordersInput`](crate::input::DescribeConfigurationRecordersInput)
    pub fn builder() -> crate::input::describe_configuration_recorders_input::Builder {
        crate::input::describe_configuration_recorders_input::Builder::default()
    }
    /// Creates a new `DescribeConfigurationRecorders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConfigurationRecorders {
    type Output = std::result::Result<
        crate::output::DescribeConfigurationRecordersOutput,
        crate::error::DescribeConfigurationRecordersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_configuration_recorders_error(response)
        } else {
            crate::operation_deser::parse_describe_configuration_recorders_response(response)
        }
    }
}

/// Operation shape for `DescribeConfigurationRecorderStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_configuration_recorder_status`](crate::client::Client::describe_configuration_recorder_status).
///
/// See [`crate::client::fluent_builders::DescribeConfigurationRecorderStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConfigurationRecorderStatus {
    _private: (),
}
impl DescribeConfigurationRecorderStatus {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationRecorderStatusInput`](crate::input::DescribeConfigurationRecorderStatusInput)
    pub fn builder() -> crate::input::describe_configuration_recorder_status_input::Builder {
        crate::input::describe_configuration_recorder_status_input::Builder::default()
    }
    /// Creates a new `DescribeConfigurationRecorderStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConfigurationRecorderStatus {
    type Output = std::result::Result<
        crate::output::DescribeConfigurationRecorderStatusOutput,
        crate::error::DescribeConfigurationRecorderStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_configuration_recorder_status_error(response)
        } else {
            crate::operation_deser::parse_describe_configuration_recorder_status_response(response)
        }
    }
}

/// Operation shape for `DescribeConformancePackCompliance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_conformance_pack_compliance`](crate::client::Client::describe_conformance_pack_compliance).
///
/// See [`crate::client::fluent_builders::DescribeConformancePackCompliance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConformancePackCompliance {
    _private: (),
}
impl DescribeConformancePackCompliance {
    /// Creates a new builder-style object to manufacture [`DescribeConformancePackComplianceInput`](crate::input::DescribeConformancePackComplianceInput)
    pub fn builder() -> crate::input::describe_conformance_pack_compliance_input::Builder {
        crate::input::describe_conformance_pack_compliance_input::Builder::default()
    }
    /// Creates a new `DescribeConformancePackCompliance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConformancePackCompliance {
    type Output = std::result::Result<
        crate::output::DescribeConformancePackComplianceOutput,
        crate::error::DescribeConformancePackComplianceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_conformance_pack_compliance_error(response)
        } else {
            crate::operation_deser::parse_describe_conformance_pack_compliance_response(response)
        }
    }
}

/// Operation shape for `DescribeConformancePacks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_conformance_packs`](crate::client::Client::describe_conformance_packs).
///
/// See [`crate::client::fluent_builders::DescribeConformancePacks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConformancePacks {
    _private: (),
}
impl DescribeConformancePacks {
    /// Creates a new builder-style object to manufacture [`DescribeConformancePacksInput`](crate::input::DescribeConformancePacksInput)
    pub fn builder() -> crate::input::describe_conformance_packs_input::Builder {
        crate::input::describe_conformance_packs_input::Builder::default()
    }
    /// Creates a new `DescribeConformancePacks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConformancePacks {
    type Output = std::result::Result<
        crate::output::DescribeConformancePacksOutput,
        crate::error::DescribeConformancePacksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_conformance_packs_error(response)
        } else {
            crate::operation_deser::parse_describe_conformance_packs_response(response)
        }
    }
}

/// Operation shape for `DescribeConformancePackStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_conformance_pack_status`](crate::client::Client::describe_conformance_pack_status).
///
/// See [`crate::client::fluent_builders::DescribeConformancePackStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConformancePackStatus {
    _private: (),
}
impl DescribeConformancePackStatus {
    /// Creates a new builder-style object to manufacture [`DescribeConformancePackStatusInput`](crate::input::DescribeConformancePackStatusInput)
    pub fn builder() -> crate::input::describe_conformance_pack_status_input::Builder {
        crate::input::describe_conformance_pack_status_input::Builder::default()
    }
    /// Creates a new `DescribeConformancePackStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConformancePackStatus {
    type Output = std::result::Result<
        crate::output::DescribeConformancePackStatusOutput,
        crate::error::DescribeConformancePackStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_conformance_pack_status_error(response)
        } else {
            crate::operation_deser::parse_describe_conformance_pack_status_response(response)
        }
    }
}

/// Operation shape for `DescribeDeliveryChannels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_delivery_channels`](crate::client::Client::describe_delivery_channels).
///
/// See [`crate::client::fluent_builders::DescribeDeliveryChannels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDeliveryChannels {
    _private: (),
}
impl DescribeDeliveryChannels {
    /// Creates a new builder-style object to manufacture [`DescribeDeliveryChannelsInput`](crate::input::DescribeDeliveryChannelsInput)
    pub fn builder() -> crate::input::describe_delivery_channels_input::Builder {
        crate::input::describe_delivery_channels_input::Builder::default()
    }
    /// Creates a new `DescribeDeliveryChannels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDeliveryChannels {
    type Output = std::result::Result<
        crate::output::DescribeDeliveryChannelsOutput,
        crate::error::DescribeDeliveryChannelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_delivery_channels_error(response)
        } else {
            crate::operation_deser::parse_describe_delivery_channels_response(response)
        }
    }
}

/// Operation shape for `DescribeDeliveryChannelStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_delivery_channel_status`](crate::client::Client::describe_delivery_channel_status).
///
/// See [`crate::client::fluent_builders::DescribeDeliveryChannelStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDeliveryChannelStatus {
    _private: (),
}
impl DescribeDeliveryChannelStatus {
    /// Creates a new builder-style object to manufacture [`DescribeDeliveryChannelStatusInput`](crate::input::DescribeDeliveryChannelStatusInput)
    pub fn builder() -> crate::input::describe_delivery_channel_status_input::Builder {
        crate::input::describe_delivery_channel_status_input::Builder::default()
    }
    /// Creates a new `DescribeDeliveryChannelStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDeliveryChannelStatus {
    type Output = std::result::Result<
        crate::output::DescribeDeliveryChannelStatusOutput,
        crate::error::DescribeDeliveryChannelStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_delivery_channel_status_error(response)
        } else {
            crate::operation_deser::parse_describe_delivery_channel_status_response(response)
        }
    }
}

/// Operation shape for `DescribeOrganizationConfigRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organization_config_rules`](crate::client::Client::describe_organization_config_rules).
///
/// See [`crate::client::fluent_builders::DescribeOrganizationConfigRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganizationConfigRules {
    _private: (),
}
impl DescribeOrganizationConfigRules {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigRulesInput`](crate::input::DescribeOrganizationConfigRulesInput)
    pub fn builder() -> crate::input::describe_organization_config_rules_input::Builder {
        crate::input::describe_organization_config_rules_input::Builder::default()
    }
    /// Creates a new `DescribeOrganizationConfigRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrganizationConfigRules {
    type Output = std::result::Result<
        crate::output::DescribeOrganizationConfigRulesOutput,
        crate::error::DescribeOrganizationConfigRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organization_config_rules_error(response)
        } else {
            crate::operation_deser::parse_describe_organization_config_rules_response(response)
        }
    }
}

/// Operation shape for `DescribeOrganizationConfigRuleStatuses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organization_config_rule_statuses`](crate::client::Client::describe_organization_config_rule_statuses).
///
/// See [`crate::client::fluent_builders::DescribeOrganizationConfigRuleStatuses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganizationConfigRuleStatuses {
    _private: (),
}
impl DescribeOrganizationConfigRuleStatuses {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigRuleStatusesInput`](crate::input::DescribeOrganizationConfigRuleStatusesInput)
    pub fn builder() -> crate::input::describe_organization_config_rule_statuses_input::Builder {
        crate::input::describe_organization_config_rule_statuses_input::Builder::default()
    }
    /// Creates a new `DescribeOrganizationConfigRuleStatuses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrganizationConfigRuleStatuses {
    type Output = std::result::Result<
        crate::output::DescribeOrganizationConfigRuleStatusesOutput,
        crate::error::DescribeOrganizationConfigRuleStatusesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organization_config_rule_statuses_error(response)
        } else {
            crate::operation_deser::parse_describe_organization_config_rule_statuses_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeOrganizationConformancePacks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organization_conformance_packs`](crate::client::Client::describe_organization_conformance_packs).
///
/// See [`crate::client::fluent_builders::DescribeOrganizationConformancePacks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganizationConformancePacks {
    _private: (),
}
impl DescribeOrganizationConformancePacks {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConformancePacksInput`](crate::input::DescribeOrganizationConformancePacksInput)
    pub fn builder() -> crate::input::describe_organization_conformance_packs_input::Builder {
        crate::input::describe_organization_conformance_packs_input::Builder::default()
    }
    /// Creates a new `DescribeOrganizationConformancePacks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrganizationConformancePacks {
    type Output = std::result::Result<
        crate::output::DescribeOrganizationConformancePacksOutput,
        crate::error::DescribeOrganizationConformancePacksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organization_conformance_packs_error(response)
        } else {
            crate::operation_deser::parse_describe_organization_conformance_packs_response(response)
        }
    }
}

/// Operation shape for `DescribeOrganizationConformancePackStatuses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organization_conformance_pack_statuses`](crate::client::Client::describe_organization_conformance_pack_statuses).
///
/// See [`crate::client::fluent_builders::DescribeOrganizationConformancePackStatuses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganizationConformancePackStatuses {
    _private: (),
}
impl DescribeOrganizationConformancePackStatuses {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConformancePackStatusesInput`](crate::input::DescribeOrganizationConformancePackStatusesInput)
    pub fn builder() -> crate::input::describe_organization_conformance_pack_statuses_input::Builder
    {
        crate::input::describe_organization_conformance_pack_statuses_input::Builder::default()
    }
    /// Creates a new `DescribeOrganizationConformancePackStatuses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeOrganizationConformancePackStatuses
{
    type Output = std::result::Result<
        crate::output::DescribeOrganizationConformancePackStatusesOutput,
        crate::error::DescribeOrganizationConformancePackStatusesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organization_conformance_pack_statuses_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_organization_conformance_pack_statuses_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribePendingAggregationRequests`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_pending_aggregation_requests`](crate::client::Client::describe_pending_aggregation_requests).
///
/// See [`crate::client::fluent_builders::DescribePendingAggregationRequests`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePendingAggregationRequests {
    _private: (),
}
impl DescribePendingAggregationRequests {
    /// Creates a new builder-style object to manufacture [`DescribePendingAggregationRequestsInput`](crate::input::DescribePendingAggregationRequestsInput)
    pub fn builder() -> crate::input::describe_pending_aggregation_requests_input::Builder {
        crate::input::describe_pending_aggregation_requests_input::Builder::default()
    }
    /// Creates a new `DescribePendingAggregationRequests` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePendingAggregationRequests {
    type Output = std::result::Result<
        crate::output::DescribePendingAggregationRequestsOutput,
        crate::error::DescribePendingAggregationRequestsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_pending_aggregation_requests_error(response)
        } else {
            crate::operation_deser::parse_describe_pending_aggregation_requests_response(response)
        }
    }
}

/// Operation shape for `DescribeRemediationConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_remediation_configurations`](crate::client::Client::describe_remediation_configurations).
///
/// See [`crate::client::fluent_builders::DescribeRemediationConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRemediationConfigurations {
    _private: (),
}
impl DescribeRemediationConfigurations {
    /// Creates a new builder-style object to manufacture [`DescribeRemediationConfigurationsInput`](crate::input::DescribeRemediationConfigurationsInput)
    pub fn builder() -> crate::input::describe_remediation_configurations_input::Builder {
        crate::input::describe_remediation_configurations_input::Builder::default()
    }
    /// Creates a new `DescribeRemediationConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRemediationConfigurations {
    type Output = std::result::Result<
        crate::output::DescribeRemediationConfigurationsOutput,
        crate::error::DescribeRemediationConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_remediation_configurations_error(response)
        } else {
            crate::operation_deser::parse_describe_remediation_configurations_response(response)
        }
    }
}

/// Operation shape for `DescribeRemediationExceptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_remediation_exceptions`](crate::client::Client::describe_remediation_exceptions).
///
/// See [`crate::client::fluent_builders::DescribeRemediationExceptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRemediationExceptions {
    _private: (),
}
impl DescribeRemediationExceptions {
    /// Creates a new builder-style object to manufacture [`DescribeRemediationExceptionsInput`](crate::input::DescribeRemediationExceptionsInput)
    pub fn builder() -> crate::input::describe_remediation_exceptions_input::Builder {
        crate::input::describe_remediation_exceptions_input::Builder::default()
    }
    /// Creates a new `DescribeRemediationExceptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRemediationExceptions {
    type Output = std::result::Result<
        crate::output::DescribeRemediationExceptionsOutput,
        crate::error::DescribeRemediationExceptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_remediation_exceptions_error(response)
        } else {
            crate::operation_deser::parse_describe_remediation_exceptions_response(response)
        }
    }
}

/// Operation shape for `DescribeRemediationExecutionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_remediation_execution_status`](crate::client::Client::describe_remediation_execution_status).
///
/// See [`crate::client::fluent_builders::DescribeRemediationExecutionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRemediationExecutionStatus {
    _private: (),
}
impl DescribeRemediationExecutionStatus {
    /// Creates a new builder-style object to manufacture [`DescribeRemediationExecutionStatusInput`](crate::input::DescribeRemediationExecutionStatusInput)
    pub fn builder() -> crate::input::describe_remediation_execution_status_input::Builder {
        crate::input::describe_remediation_execution_status_input::Builder::default()
    }
    /// Creates a new `DescribeRemediationExecutionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRemediationExecutionStatus {
    type Output = std::result::Result<
        crate::output::DescribeRemediationExecutionStatusOutput,
        crate::error::DescribeRemediationExecutionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_remediation_execution_status_error(response)
        } else {
            crate::operation_deser::parse_describe_remediation_execution_status_response(response)
        }
    }
}

/// Operation shape for `DescribeRetentionConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_retention_configurations`](crate::client::Client::describe_retention_configurations).
///
/// See [`crate::client::fluent_builders::DescribeRetentionConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRetentionConfigurations {
    _private: (),
}
impl DescribeRetentionConfigurations {
    /// Creates a new builder-style object to manufacture [`DescribeRetentionConfigurationsInput`](crate::input::DescribeRetentionConfigurationsInput)
    pub fn builder() -> crate::input::describe_retention_configurations_input::Builder {
        crate::input::describe_retention_configurations_input::Builder::default()
    }
    /// Creates a new `DescribeRetentionConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRetentionConfigurations {
    type Output = std::result::Result<
        crate::output::DescribeRetentionConfigurationsOutput,
        crate::error::DescribeRetentionConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_retention_configurations_error(response)
        } else {
            crate::operation_deser::parse_describe_retention_configurations_response(response)
        }
    }
}

/// Operation shape for `GetAggregateComplianceDetailsByConfigRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_aggregate_compliance_details_by_config_rule`](crate::client::Client::get_aggregate_compliance_details_by_config_rule).
///
/// See [`crate::client::fluent_builders::GetAggregateComplianceDetailsByConfigRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAggregateComplianceDetailsByConfigRule {
    _private: (),
}
impl GetAggregateComplianceDetailsByConfigRule {
    /// Creates a new builder-style object to manufacture [`GetAggregateComplianceDetailsByConfigRuleInput`](crate::input::GetAggregateComplianceDetailsByConfigRuleInput)
    pub fn builder() -> crate::input::get_aggregate_compliance_details_by_config_rule_input::Builder
    {
        crate::input::get_aggregate_compliance_details_by_config_rule_input::Builder::default()
    }
    /// Creates a new `GetAggregateComplianceDetailsByConfigRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAggregateComplianceDetailsByConfigRule {
    type Output = std::result::Result<
        crate::output::GetAggregateComplianceDetailsByConfigRuleOutput,
        crate::error::GetAggregateComplianceDetailsByConfigRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_aggregate_compliance_details_by_config_rule_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_aggregate_compliance_details_by_config_rule_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAggregateConfigRuleComplianceSummary`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_aggregate_config_rule_compliance_summary`](crate::client::Client::get_aggregate_config_rule_compliance_summary).
///
/// See [`crate::client::fluent_builders::GetAggregateConfigRuleComplianceSummary`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAggregateConfigRuleComplianceSummary {
    _private: (),
}
impl GetAggregateConfigRuleComplianceSummary {
    /// Creates a new builder-style object to manufacture [`GetAggregateConfigRuleComplianceSummaryInput`](crate::input::GetAggregateConfigRuleComplianceSummaryInput)
    pub fn builder() -> crate::input::get_aggregate_config_rule_compliance_summary_input::Builder {
        crate::input::get_aggregate_config_rule_compliance_summary_input::Builder::default()
    }
    /// Creates a new `GetAggregateConfigRuleComplianceSummary` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAggregateConfigRuleComplianceSummary {
    type Output = std::result::Result<
        crate::output::GetAggregateConfigRuleComplianceSummaryOutput,
        crate::error::GetAggregateConfigRuleComplianceSummaryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_aggregate_config_rule_compliance_summary_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_aggregate_config_rule_compliance_summary_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAggregateConformancePackComplianceSummary`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_aggregate_conformance_pack_compliance_summary`](crate::client::Client::get_aggregate_conformance_pack_compliance_summary).
///
/// See [`crate::client::fluent_builders::GetAggregateConformancePackComplianceSummary`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAggregateConformancePackComplianceSummary {
    _private: (),
}
impl GetAggregateConformancePackComplianceSummary {
    /// Creates a new builder-style object to manufacture [`GetAggregateConformancePackComplianceSummaryInput`](crate::input::GetAggregateConformancePackComplianceSummaryInput)
    pub fn builder(
    ) -> crate::input::get_aggregate_conformance_pack_compliance_summary_input::Builder {
        crate::input::get_aggregate_conformance_pack_compliance_summary_input::Builder::default()
    }
    /// Creates a new `GetAggregateConformancePackComplianceSummary` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for GetAggregateConformancePackComplianceSummary
{
    type Output = std::result::Result<
        crate::output::GetAggregateConformancePackComplianceSummaryOutput,
        crate::error::GetAggregateConformancePackComplianceSummaryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_aggregate_conformance_pack_compliance_summary_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_aggregate_conformance_pack_compliance_summary_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAggregateDiscoveredResourceCounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_aggregate_discovered_resource_counts`](crate::client::Client::get_aggregate_discovered_resource_counts).
///
/// See [`crate::client::fluent_builders::GetAggregateDiscoveredResourceCounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAggregateDiscoveredResourceCounts {
    _private: (),
}
impl GetAggregateDiscoveredResourceCounts {
    /// Creates a new builder-style object to manufacture [`GetAggregateDiscoveredResourceCountsInput`](crate::input::GetAggregateDiscoveredResourceCountsInput)
    pub fn builder() -> crate::input::get_aggregate_discovered_resource_counts_input::Builder {
        crate::input::get_aggregate_discovered_resource_counts_input::Builder::default()
    }
    /// Creates a new `GetAggregateDiscoveredResourceCounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAggregateDiscoveredResourceCounts {
    type Output = std::result::Result<
        crate::output::GetAggregateDiscoveredResourceCountsOutput,
        crate::error::GetAggregateDiscoveredResourceCountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_aggregate_discovered_resource_counts_error(response)
        } else {
            crate::operation_deser::parse_get_aggregate_discovered_resource_counts_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAggregateResourceConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_aggregate_resource_config`](crate::client::Client::get_aggregate_resource_config).
///
/// See [`crate::client::fluent_builders::GetAggregateResourceConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAggregateResourceConfig {
    _private: (),
}
impl GetAggregateResourceConfig {
    /// Creates a new builder-style object to manufacture [`GetAggregateResourceConfigInput`](crate::input::GetAggregateResourceConfigInput)
    pub fn builder() -> crate::input::get_aggregate_resource_config_input::Builder {
        crate::input::get_aggregate_resource_config_input::Builder::default()
    }
    /// Creates a new `GetAggregateResourceConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAggregateResourceConfig {
    type Output = std::result::Result<
        crate::output::GetAggregateResourceConfigOutput,
        crate::error::GetAggregateResourceConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_aggregate_resource_config_error(response)
        } else {
            crate::operation_deser::parse_get_aggregate_resource_config_response(response)
        }
    }
}

/// Operation shape for `GetComplianceDetailsByConfigRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_compliance_details_by_config_rule`](crate::client::Client::get_compliance_details_by_config_rule).
///
/// See [`crate::client::fluent_builders::GetComplianceDetailsByConfigRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetComplianceDetailsByConfigRule {
    _private: (),
}
impl GetComplianceDetailsByConfigRule {
    /// Creates a new builder-style object to manufacture [`GetComplianceDetailsByConfigRuleInput`](crate::input::GetComplianceDetailsByConfigRuleInput)
    pub fn builder() -> crate::input::get_compliance_details_by_config_rule_input::Builder {
        crate::input::get_compliance_details_by_config_rule_input::Builder::default()
    }
    /// Creates a new `GetComplianceDetailsByConfigRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetComplianceDetailsByConfigRule {
    type Output = std::result::Result<
        crate::output::GetComplianceDetailsByConfigRuleOutput,
        crate::error::GetComplianceDetailsByConfigRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_compliance_details_by_config_rule_error(response)
        } else {
            crate::operation_deser::parse_get_compliance_details_by_config_rule_response(response)
        }
    }
}

/// Operation shape for `GetComplianceDetailsByResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_compliance_details_by_resource`](crate::client::Client::get_compliance_details_by_resource).
///
/// See [`crate::client::fluent_builders::GetComplianceDetailsByResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetComplianceDetailsByResource {
    _private: (),
}
impl GetComplianceDetailsByResource {
    /// Creates a new builder-style object to manufacture [`GetComplianceDetailsByResourceInput`](crate::input::GetComplianceDetailsByResourceInput)
    pub fn builder() -> crate::input::get_compliance_details_by_resource_input::Builder {
        crate::input::get_compliance_details_by_resource_input::Builder::default()
    }
    /// Creates a new `GetComplianceDetailsByResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetComplianceDetailsByResource {
    type Output = std::result::Result<
        crate::output::GetComplianceDetailsByResourceOutput,
        crate::error::GetComplianceDetailsByResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_compliance_details_by_resource_error(response)
        } else {
            crate::operation_deser::parse_get_compliance_details_by_resource_response(response)
        }
    }
}

/// Operation shape for `GetComplianceSummaryByConfigRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_compliance_summary_by_config_rule`](crate::client::Client::get_compliance_summary_by_config_rule).
///
/// See [`crate::client::fluent_builders::GetComplianceSummaryByConfigRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetComplianceSummaryByConfigRule {
    _private: (),
}
impl GetComplianceSummaryByConfigRule {
    /// Creates a new builder-style object to manufacture [`GetComplianceSummaryByConfigRuleInput`](crate::input::GetComplianceSummaryByConfigRuleInput)
    pub fn builder() -> crate::input::get_compliance_summary_by_config_rule_input::Builder {
        crate::input::get_compliance_summary_by_config_rule_input::Builder::default()
    }
    /// Creates a new `GetComplianceSummaryByConfigRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetComplianceSummaryByConfigRule {
    type Output = std::result::Result<
        crate::output::GetComplianceSummaryByConfigRuleOutput,
        crate::error::GetComplianceSummaryByConfigRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_compliance_summary_by_config_rule_error(response)
        } else {
            crate::operation_deser::parse_get_compliance_summary_by_config_rule_response(response)
        }
    }
}

/// Operation shape for `GetComplianceSummaryByResourceType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_compliance_summary_by_resource_type`](crate::client::Client::get_compliance_summary_by_resource_type).
///
/// See [`crate::client::fluent_builders::GetComplianceSummaryByResourceType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetComplianceSummaryByResourceType {
    _private: (),
}
impl GetComplianceSummaryByResourceType {
    /// Creates a new builder-style object to manufacture [`GetComplianceSummaryByResourceTypeInput`](crate::input::GetComplianceSummaryByResourceTypeInput)
    pub fn builder() -> crate::input::get_compliance_summary_by_resource_type_input::Builder {
        crate::input::get_compliance_summary_by_resource_type_input::Builder::default()
    }
    /// Creates a new `GetComplianceSummaryByResourceType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetComplianceSummaryByResourceType {
    type Output = std::result::Result<
        crate::output::GetComplianceSummaryByResourceTypeOutput,
        crate::error::GetComplianceSummaryByResourceTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_compliance_summary_by_resource_type_error(response)
        } else {
            crate::operation_deser::parse_get_compliance_summary_by_resource_type_response(response)
        }
    }
}

/// Operation shape for `GetConformancePackComplianceDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_conformance_pack_compliance_details`](crate::client::Client::get_conformance_pack_compliance_details).
///
/// See [`crate::client::fluent_builders::GetConformancePackComplianceDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConformancePackComplianceDetails {
    _private: (),
}
impl GetConformancePackComplianceDetails {
    /// Creates a new builder-style object to manufacture [`GetConformancePackComplianceDetailsInput`](crate::input::GetConformancePackComplianceDetailsInput)
    pub fn builder() -> crate::input::get_conformance_pack_compliance_details_input::Builder {
        crate::input::get_conformance_pack_compliance_details_input::Builder::default()
    }
    /// Creates a new `GetConformancePackComplianceDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConformancePackComplianceDetails {
    type Output = std::result::Result<
        crate::output::GetConformancePackComplianceDetailsOutput,
        crate::error::GetConformancePackComplianceDetailsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_conformance_pack_compliance_details_error(response)
        } else {
            crate::operation_deser::parse_get_conformance_pack_compliance_details_response(response)
        }
    }
}

/// Operation shape for `GetConformancePackComplianceSummary`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_conformance_pack_compliance_summary`](crate::client::Client::get_conformance_pack_compliance_summary).
///
/// See [`crate::client::fluent_builders::GetConformancePackComplianceSummary`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConformancePackComplianceSummary {
    _private: (),
}
impl GetConformancePackComplianceSummary {
    /// Creates a new builder-style object to manufacture [`GetConformancePackComplianceSummaryInput`](crate::input::GetConformancePackComplianceSummaryInput)
    pub fn builder() -> crate::input::get_conformance_pack_compliance_summary_input::Builder {
        crate::input::get_conformance_pack_compliance_summary_input::Builder::default()
    }
    /// Creates a new `GetConformancePackComplianceSummary` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConformancePackComplianceSummary {
    type Output = std::result::Result<
        crate::output::GetConformancePackComplianceSummaryOutput,
        crate::error::GetConformancePackComplianceSummaryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_conformance_pack_compliance_summary_error(response)
        } else {
            crate::operation_deser::parse_get_conformance_pack_compliance_summary_response(response)
        }
    }
}

/// Operation shape for `GetDiscoveredResourceCounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_discovered_resource_counts`](crate::client::Client::get_discovered_resource_counts).
///
/// See [`crate::client::fluent_builders::GetDiscoveredResourceCounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDiscoveredResourceCounts {
    _private: (),
}
impl GetDiscoveredResourceCounts {
    /// Creates a new builder-style object to manufacture [`GetDiscoveredResourceCountsInput`](crate::input::GetDiscoveredResourceCountsInput)
    pub fn builder() -> crate::input::get_discovered_resource_counts_input::Builder {
        crate::input::get_discovered_resource_counts_input::Builder::default()
    }
    /// Creates a new `GetDiscoveredResourceCounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDiscoveredResourceCounts {
    type Output = std::result::Result<
        crate::output::GetDiscoveredResourceCountsOutput,
        crate::error::GetDiscoveredResourceCountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_discovered_resource_counts_error(response)
        } else {
            crate::operation_deser::parse_get_discovered_resource_counts_response(response)
        }
    }
}

/// Operation shape for `GetOrganizationConfigRuleDetailedStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_organization_config_rule_detailed_status`](crate::client::Client::get_organization_config_rule_detailed_status).
///
/// See [`crate::client::fluent_builders::GetOrganizationConfigRuleDetailedStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOrganizationConfigRuleDetailedStatus {
    _private: (),
}
impl GetOrganizationConfigRuleDetailedStatus {
    /// Creates a new builder-style object to manufacture [`GetOrganizationConfigRuleDetailedStatusInput`](crate::input::GetOrganizationConfigRuleDetailedStatusInput)
    pub fn builder() -> crate::input::get_organization_config_rule_detailed_status_input::Builder {
        crate::input::get_organization_config_rule_detailed_status_input::Builder::default()
    }
    /// Creates a new `GetOrganizationConfigRuleDetailedStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOrganizationConfigRuleDetailedStatus {
    type Output = std::result::Result<
        crate::output::GetOrganizationConfigRuleDetailedStatusOutput,
        crate::error::GetOrganizationConfigRuleDetailedStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_organization_config_rule_detailed_status_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_organization_config_rule_detailed_status_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetOrganizationConformancePackDetailedStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_organization_conformance_pack_detailed_status`](crate::client::Client::get_organization_conformance_pack_detailed_status).
///
/// See [`crate::client::fluent_builders::GetOrganizationConformancePackDetailedStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOrganizationConformancePackDetailedStatus {
    _private: (),
}
impl GetOrganizationConformancePackDetailedStatus {
    /// Creates a new builder-style object to manufacture [`GetOrganizationConformancePackDetailedStatusInput`](crate::input::GetOrganizationConformancePackDetailedStatusInput)
    pub fn builder(
    ) -> crate::input::get_organization_conformance_pack_detailed_status_input::Builder {
        crate::input::get_organization_conformance_pack_detailed_status_input::Builder::default()
    }
    /// Creates a new `GetOrganizationConformancePackDetailedStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for GetOrganizationConformancePackDetailedStatus
{
    type Output = std::result::Result<
        crate::output::GetOrganizationConformancePackDetailedStatusOutput,
        crate::error::GetOrganizationConformancePackDetailedStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_organization_conformance_pack_detailed_status_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_organization_conformance_pack_detailed_status_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetResourceConfigHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_config_history`](crate::client::Client::get_resource_config_history).
///
/// See [`crate::client::fluent_builders::GetResourceConfigHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourceConfigHistory {
    _private: (),
}
impl GetResourceConfigHistory {
    /// Creates a new builder-style object to manufacture [`GetResourceConfigHistoryInput`](crate::input::GetResourceConfigHistoryInput)
    pub fn builder() -> crate::input::get_resource_config_history_input::Builder {
        crate::input::get_resource_config_history_input::Builder::default()
    }
    /// Creates a new `GetResourceConfigHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourceConfigHistory {
    type Output = std::result::Result<
        crate::output::GetResourceConfigHistoryOutput,
        crate::error::GetResourceConfigHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_config_history_error(response)
        } else {
            crate::operation_deser::parse_get_resource_config_history_response(response)
        }
    }
}

/// Operation shape for `GetStoredQuery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_stored_query`](crate::client::Client::get_stored_query).
///
/// See [`crate::client::fluent_builders::GetStoredQuery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStoredQuery {
    _private: (),
}
impl GetStoredQuery {
    /// Creates a new builder-style object to manufacture [`GetStoredQueryInput`](crate::input::GetStoredQueryInput)
    pub fn builder() -> crate::input::get_stored_query_input::Builder {
        crate::input::get_stored_query_input::Builder::default()
    }
    /// Creates a new `GetStoredQuery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStoredQuery {
    type Output =
        std::result::Result<crate::output::GetStoredQueryOutput, crate::error::GetStoredQueryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_stored_query_error(response)
        } else {
            crate::operation_deser::parse_get_stored_query_response(response)
        }
    }
}

/// Operation shape for `ListAggregateDiscoveredResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_aggregate_discovered_resources`](crate::client::Client::list_aggregate_discovered_resources).
///
/// See [`crate::client::fluent_builders::ListAggregateDiscoveredResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAggregateDiscoveredResources {
    _private: (),
}
impl ListAggregateDiscoveredResources {
    /// Creates a new builder-style object to manufacture [`ListAggregateDiscoveredResourcesInput`](crate::input::ListAggregateDiscoveredResourcesInput)
    pub fn builder() -> crate::input::list_aggregate_discovered_resources_input::Builder {
        crate::input::list_aggregate_discovered_resources_input::Builder::default()
    }
    /// Creates a new `ListAggregateDiscoveredResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAggregateDiscoveredResources {
    type Output = std::result::Result<
        crate::output::ListAggregateDiscoveredResourcesOutput,
        crate::error::ListAggregateDiscoveredResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_aggregate_discovered_resources_error(response)
        } else {
            crate::operation_deser::parse_list_aggregate_discovered_resources_response(response)
        }
    }
}

/// Operation shape for `ListDiscoveredResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_discovered_resources`](crate::client::Client::list_discovered_resources).
///
/// See [`crate::client::fluent_builders::ListDiscoveredResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDiscoveredResources {
    _private: (),
}
impl ListDiscoveredResources {
    /// Creates a new builder-style object to manufacture [`ListDiscoveredResourcesInput`](crate::input::ListDiscoveredResourcesInput)
    pub fn builder() -> crate::input::list_discovered_resources_input::Builder {
        crate::input::list_discovered_resources_input::Builder::default()
    }
    /// Creates a new `ListDiscoveredResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDiscoveredResources {
    type Output = std::result::Result<
        crate::output::ListDiscoveredResourcesOutput,
        crate::error::ListDiscoveredResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_discovered_resources_error(response)
        } else {
            crate::operation_deser::parse_list_discovered_resources_response(response)
        }
    }
}

/// Operation shape for `ListStoredQueries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_stored_queries`](crate::client::Client::list_stored_queries).
///
/// See [`crate::client::fluent_builders::ListStoredQueries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStoredQueries {
    _private: (),
}
impl ListStoredQueries {
    /// Creates a new builder-style object to manufacture [`ListStoredQueriesInput`](crate::input::ListStoredQueriesInput)
    pub fn builder() -> crate::input::list_stored_queries_input::Builder {
        crate::input::list_stored_queries_input::Builder::default()
    }
    /// Creates a new `ListStoredQueries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStoredQueries {
    type Output = std::result::Result<
        crate::output::ListStoredQueriesOutput,
        crate::error::ListStoredQueriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_stored_queries_error(response)
        } else {
            crate::operation_deser::parse_list_stored_queries_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutAggregationAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_aggregation_authorization`](crate::client::Client::put_aggregation_authorization).
///
/// See [`crate::client::fluent_builders::PutAggregationAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAggregationAuthorization {
    _private: (),
}
impl PutAggregationAuthorization {
    /// Creates a new builder-style object to manufacture [`PutAggregationAuthorizationInput`](crate::input::PutAggregationAuthorizationInput)
    pub fn builder() -> crate::input::put_aggregation_authorization_input::Builder {
        crate::input::put_aggregation_authorization_input::Builder::default()
    }
    /// Creates a new `PutAggregationAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAggregationAuthorization {
    type Output = std::result::Result<
        crate::output::PutAggregationAuthorizationOutput,
        crate::error::PutAggregationAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_aggregation_authorization_error(response)
        } else {
            crate::operation_deser::parse_put_aggregation_authorization_response(response)
        }
    }
}

/// Operation shape for `PutConfigRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_config_rule`](crate::client::Client::put_config_rule).
///
/// See [`crate::client::fluent_builders::PutConfigRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutConfigRule {
    _private: (),
}
impl PutConfigRule {
    /// Creates a new builder-style object to manufacture [`PutConfigRuleInput`](crate::input::PutConfigRuleInput)
    pub fn builder() -> crate::input::put_config_rule_input::Builder {
        crate::input::put_config_rule_input::Builder::default()
    }
    /// Creates a new `PutConfigRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutConfigRule {
    type Output =
        std::result::Result<crate::output::PutConfigRuleOutput, crate::error::PutConfigRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_config_rule_error(response)
        } else {
            crate::operation_deser::parse_put_config_rule_response(response)
        }
    }
}

/// Operation shape for `PutConfigurationAggregator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_configuration_aggregator`](crate::client::Client::put_configuration_aggregator).
///
/// See [`crate::client::fluent_builders::PutConfigurationAggregator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutConfigurationAggregator {
    _private: (),
}
impl PutConfigurationAggregator {
    /// Creates a new builder-style object to manufacture [`PutConfigurationAggregatorInput`](crate::input::PutConfigurationAggregatorInput)
    pub fn builder() -> crate::input::put_configuration_aggregator_input::Builder {
        crate::input::put_configuration_aggregator_input::Builder::default()
    }
    /// Creates a new `PutConfigurationAggregator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutConfigurationAggregator {
    type Output = std::result::Result<
        crate::output::PutConfigurationAggregatorOutput,
        crate::error::PutConfigurationAggregatorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_configuration_aggregator_error(response)
        } else {
            crate::operation_deser::parse_put_configuration_aggregator_response(response)
        }
    }
}

/// Operation shape for `PutConfigurationRecorder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_configuration_recorder`](crate::client::Client::put_configuration_recorder).
///
/// See [`crate::client::fluent_builders::PutConfigurationRecorder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutConfigurationRecorder {
    _private: (),
}
impl PutConfigurationRecorder {
    /// Creates a new builder-style object to manufacture [`PutConfigurationRecorderInput`](crate::input::PutConfigurationRecorderInput)
    pub fn builder() -> crate::input::put_configuration_recorder_input::Builder {
        crate::input::put_configuration_recorder_input::Builder::default()
    }
    /// Creates a new `PutConfigurationRecorder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutConfigurationRecorder {
    type Output = std::result::Result<
        crate::output::PutConfigurationRecorderOutput,
        crate::error::PutConfigurationRecorderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_configuration_recorder_error(response)
        } else {
            crate::operation_deser::parse_put_configuration_recorder_response(response)
        }
    }
}

/// Operation shape for `PutConformancePack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_conformance_pack`](crate::client::Client::put_conformance_pack).
///
/// See [`crate::client::fluent_builders::PutConformancePack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutConformancePack {
    _private: (),
}
impl PutConformancePack {
    /// Creates a new builder-style object to manufacture [`PutConformancePackInput`](crate::input::PutConformancePackInput)
    pub fn builder() -> crate::input::put_conformance_pack_input::Builder {
        crate::input::put_conformance_pack_input::Builder::default()
    }
    /// Creates a new `PutConformancePack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutConformancePack {
    type Output = std::result::Result<
        crate::output::PutConformancePackOutput,
        crate::error::PutConformancePackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_conformance_pack_error(response)
        } else {
            crate::operation_deser::parse_put_conformance_pack_response(response)
        }
    }
}

/// Operation shape for `PutDeliveryChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_delivery_channel`](crate::client::Client::put_delivery_channel).
///
/// See [`crate::client::fluent_builders::PutDeliveryChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDeliveryChannel {
    _private: (),
}
impl PutDeliveryChannel {
    /// Creates a new builder-style object to manufacture [`PutDeliveryChannelInput`](crate::input::PutDeliveryChannelInput)
    pub fn builder() -> crate::input::put_delivery_channel_input::Builder {
        crate::input::put_delivery_channel_input::Builder::default()
    }
    /// Creates a new `PutDeliveryChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDeliveryChannel {
    type Output = std::result::Result<
        crate::output::PutDeliveryChannelOutput,
        crate::error::PutDeliveryChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_delivery_channel_error(response)
        } else {
            crate::operation_deser::parse_put_delivery_channel_response(response)
        }
    }
}

/// Operation shape for `PutEvaluations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_evaluations`](crate::client::Client::put_evaluations).
///
/// See [`crate::client::fluent_builders::PutEvaluations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutEvaluations {
    _private: (),
}
impl PutEvaluations {
    /// Creates a new builder-style object to manufacture [`PutEvaluationsInput`](crate::input::PutEvaluationsInput)
    pub fn builder() -> crate::input::put_evaluations_input::Builder {
        crate::input::put_evaluations_input::Builder::default()
    }
    /// Creates a new `PutEvaluations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutEvaluations {
    type Output =
        std::result::Result<crate::output::PutEvaluationsOutput, crate::error::PutEvaluationsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_evaluations_error(response)
        } else {
            crate::operation_deser::parse_put_evaluations_response(response)
        }
    }
}

/// Operation shape for `PutExternalEvaluation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_external_evaluation`](crate::client::Client::put_external_evaluation).
///
/// See [`crate::client::fluent_builders::PutExternalEvaluation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutExternalEvaluation {
    _private: (),
}
impl PutExternalEvaluation {
    /// Creates a new builder-style object to manufacture [`PutExternalEvaluationInput`](crate::input::PutExternalEvaluationInput)
    pub fn builder() -> crate::input::put_external_evaluation_input::Builder {
        crate::input::put_external_evaluation_input::Builder::default()
    }
    /// Creates a new `PutExternalEvaluation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutExternalEvaluation {
    type Output = std::result::Result<
        crate::output::PutExternalEvaluationOutput,
        crate::error::PutExternalEvaluationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_external_evaluation_error(response)
        } else {
            crate::operation_deser::parse_put_external_evaluation_response(response)
        }
    }
}

/// Operation shape for `PutOrganizationConfigRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_organization_config_rule`](crate::client::Client::put_organization_config_rule).
///
/// See [`crate::client::fluent_builders::PutOrganizationConfigRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutOrganizationConfigRule {
    _private: (),
}
impl PutOrganizationConfigRule {
    /// Creates a new builder-style object to manufacture [`PutOrganizationConfigRuleInput`](crate::input::PutOrganizationConfigRuleInput)
    pub fn builder() -> crate::input::put_organization_config_rule_input::Builder {
        crate::input::put_organization_config_rule_input::Builder::default()
    }
    /// Creates a new `PutOrganizationConfigRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutOrganizationConfigRule {
    type Output = std::result::Result<
        crate::output::PutOrganizationConfigRuleOutput,
        crate::error::PutOrganizationConfigRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_organization_config_rule_error(response)
        } else {
            crate::operation_deser::parse_put_organization_config_rule_response(response)
        }
    }
}

/// Operation shape for `PutOrganizationConformancePack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_organization_conformance_pack`](crate::client::Client::put_organization_conformance_pack).
///
/// See [`crate::client::fluent_builders::PutOrganizationConformancePack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutOrganizationConformancePack {
    _private: (),
}
impl PutOrganizationConformancePack {
    /// Creates a new builder-style object to manufacture [`PutOrganizationConformancePackInput`](crate::input::PutOrganizationConformancePackInput)
    pub fn builder() -> crate::input::put_organization_conformance_pack_input::Builder {
        crate::input::put_organization_conformance_pack_input::Builder::default()
    }
    /// Creates a new `PutOrganizationConformancePack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutOrganizationConformancePack {
    type Output = std::result::Result<
        crate::output::PutOrganizationConformancePackOutput,
        crate::error::PutOrganizationConformancePackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_organization_conformance_pack_error(response)
        } else {
            crate::operation_deser::parse_put_organization_conformance_pack_response(response)
        }
    }
}

/// Operation shape for `PutRemediationConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_remediation_configurations`](crate::client::Client::put_remediation_configurations).
///
/// See [`crate::client::fluent_builders::PutRemediationConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRemediationConfigurations {
    _private: (),
}
impl PutRemediationConfigurations {
    /// Creates a new builder-style object to manufacture [`PutRemediationConfigurationsInput`](crate::input::PutRemediationConfigurationsInput)
    pub fn builder() -> crate::input::put_remediation_configurations_input::Builder {
        crate::input::put_remediation_configurations_input::Builder::default()
    }
    /// Creates a new `PutRemediationConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRemediationConfigurations {
    type Output = std::result::Result<
        crate::output::PutRemediationConfigurationsOutput,
        crate::error::PutRemediationConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_remediation_configurations_error(response)
        } else {
            crate::operation_deser::parse_put_remediation_configurations_response(response)
        }
    }
}

/// Operation shape for `PutRemediationExceptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_remediation_exceptions`](crate::client::Client::put_remediation_exceptions).
///
/// See [`crate::client::fluent_builders::PutRemediationExceptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRemediationExceptions {
    _private: (),
}
impl PutRemediationExceptions {
    /// Creates a new builder-style object to manufacture [`PutRemediationExceptionsInput`](crate::input::PutRemediationExceptionsInput)
    pub fn builder() -> crate::input::put_remediation_exceptions_input::Builder {
        crate::input::put_remediation_exceptions_input::Builder::default()
    }
    /// Creates a new `PutRemediationExceptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRemediationExceptions {
    type Output = std::result::Result<
        crate::output::PutRemediationExceptionsOutput,
        crate::error::PutRemediationExceptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_remediation_exceptions_error(response)
        } else {
            crate::operation_deser::parse_put_remediation_exceptions_response(response)
        }
    }
}

/// Operation shape for `PutResourceConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_resource_config`](crate::client::Client::put_resource_config).
///
/// See [`crate::client::fluent_builders::PutResourceConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutResourceConfig {
    _private: (),
}
impl PutResourceConfig {
    /// Creates a new builder-style object to manufacture [`PutResourceConfigInput`](crate::input::PutResourceConfigInput)
    pub fn builder() -> crate::input::put_resource_config_input::Builder {
        crate::input::put_resource_config_input::Builder::default()
    }
    /// Creates a new `PutResourceConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutResourceConfig {
    type Output = std::result::Result<
        crate::output::PutResourceConfigOutput,
        crate::error::PutResourceConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_resource_config_error(response)
        } else {
            crate::operation_deser::parse_put_resource_config_response(response)
        }
    }
}

/// Operation shape for `PutRetentionConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_retention_configuration`](crate::client::Client::put_retention_configuration).
///
/// See [`crate::client::fluent_builders::PutRetentionConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRetentionConfiguration {
    _private: (),
}
impl PutRetentionConfiguration {
    /// Creates a new builder-style object to manufacture [`PutRetentionConfigurationInput`](crate::input::PutRetentionConfigurationInput)
    pub fn builder() -> crate::input::put_retention_configuration_input::Builder {
        crate::input::put_retention_configuration_input::Builder::default()
    }
    /// Creates a new `PutRetentionConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRetentionConfiguration {
    type Output = std::result::Result<
        crate::output::PutRetentionConfigurationOutput,
        crate::error::PutRetentionConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_retention_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_retention_configuration_response(response)
        }
    }
}

/// Operation shape for `PutStoredQuery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_stored_query`](crate::client::Client::put_stored_query).
///
/// See [`crate::client::fluent_builders::PutStoredQuery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutStoredQuery {
    _private: (),
}
impl PutStoredQuery {
    /// Creates a new builder-style object to manufacture [`PutStoredQueryInput`](crate::input::PutStoredQueryInput)
    pub fn builder() -> crate::input::put_stored_query_input::Builder {
        crate::input::put_stored_query_input::Builder::default()
    }
    /// Creates a new `PutStoredQuery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutStoredQuery {
    type Output =
        std::result::Result<crate::output::PutStoredQueryOutput, crate::error::PutStoredQueryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_stored_query_error(response)
        } else {
            crate::operation_deser::parse_put_stored_query_response(response)
        }
    }
}

/// Operation shape for `SelectAggregateResourceConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`select_aggregate_resource_config`](crate::client::Client::select_aggregate_resource_config).
///
/// See [`crate::client::fluent_builders::SelectAggregateResourceConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SelectAggregateResourceConfig {
    _private: (),
}
impl SelectAggregateResourceConfig {
    /// Creates a new builder-style object to manufacture [`SelectAggregateResourceConfigInput`](crate::input::SelectAggregateResourceConfigInput)
    pub fn builder() -> crate::input::select_aggregate_resource_config_input::Builder {
        crate::input::select_aggregate_resource_config_input::Builder::default()
    }
    /// Creates a new `SelectAggregateResourceConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SelectAggregateResourceConfig {
    type Output = std::result::Result<
        crate::output::SelectAggregateResourceConfigOutput,
        crate::error::SelectAggregateResourceConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_select_aggregate_resource_config_error(response)
        } else {
            crate::operation_deser::parse_select_aggregate_resource_config_response(response)
        }
    }
}

/// Operation shape for `SelectResourceConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`select_resource_config`](crate::client::Client::select_resource_config).
///
/// See [`crate::client::fluent_builders::SelectResourceConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SelectResourceConfig {
    _private: (),
}
impl SelectResourceConfig {
    /// Creates a new builder-style object to manufacture [`SelectResourceConfigInput`](crate::input::SelectResourceConfigInput)
    pub fn builder() -> crate::input::select_resource_config_input::Builder {
        crate::input::select_resource_config_input::Builder::default()
    }
    /// Creates a new `SelectResourceConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SelectResourceConfig {
    type Output = std::result::Result<
        crate::output::SelectResourceConfigOutput,
        crate::error::SelectResourceConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_select_resource_config_error(response)
        } else {
            crate::operation_deser::parse_select_resource_config_response(response)
        }
    }
}

/// Operation shape for `StartConfigRulesEvaluation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_config_rules_evaluation`](crate::client::Client::start_config_rules_evaluation).
///
/// See [`crate::client::fluent_builders::StartConfigRulesEvaluation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartConfigRulesEvaluation {
    _private: (),
}
impl StartConfigRulesEvaluation {
    /// Creates a new builder-style object to manufacture [`StartConfigRulesEvaluationInput`](crate::input::StartConfigRulesEvaluationInput)
    pub fn builder() -> crate::input::start_config_rules_evaluation_input::Builder {
        crate::input::start_config_rules_evaluation_input::Builder::default()
    }
    /// Creates a new `StartConfigRulesEvaluation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartConfigRulesEvaluation {
    type Output = std::result::Result<
        crate::output::StartConfigRulesEvaluationOutput,
        crate::error::StartConfigRulesEvaluationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_config_rules_evaluation_error(response)
        } else {
            crate::operation_deser::parse_start_config_rules_evaluation_response(response)
        }
    }
}

/// Operation shape for `StartConfigurationRecorder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_configuration_recorder`](crate::client::Client::start_configuration_recorder).
///
/// See [`crate::client::fluent_builders::StartConfigurationRecorder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartConfigurationRecorder {
    _private: (),
}
impl StartConfigurationRecorder {
    /// Creates a new builder-style object to manufacture [`StartConfigurationRecorderInput`](crate::input::StartConfigurationRecorderInput)
    pub fn builder() -> crate::input::start_configuration_recorder_input::Builder {
        crate::input::start_configuration_recorder_input::Builder::default()
    }
    /// Creates a new `StartConfigurationRecorder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartConfigurationRecorder {
    type Output = std::result::Result<
        crate::output::StartConfigurationRecorderOutput,
        crate::error::StartConfigurationRecorderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_configuration_recorder_error(response)
        } else {
            crate::operation_deser::parse_start_configuration_recorder_response(response)
        }
    }
}

/// Operation shape for `StartRemediationExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_remediation_execution`](crate::client::Client::start_remediation_execution).
///
/// See [`crate::client::fluent_builders::StartRemediationExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartRemediationExecution {
    _private: (),
}
impl StartRemediationExecution {
    /// Creates a new builder-style object to manufacture [`StartRemediationExecutionInput`](crate::input::StartRemediationExecutionInput)
    pub fn builder() -> crate::input::start_remediation_execution_input::Builder {
        crate::input::start_remediation_execution_input::Builder::default()
    }
    /// Creates a new `StartRemediationExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartRemediationExecution {
    type Output = std::result::Result<
        crate::output::StartRemediationExecutionOutput,
        crate::error::StartRemediationExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_remediation_execution_error(response)
        } else {
            crate::operation_deser::parse_start_remediation_execution_response(response)
        }
    }
}

/// Operation shape for `StopConfigurationRecorder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_configuration_recorder`](crate::client::Client::stop_configuration_recorder).
///
/// See [`crate::client::fluent_builders::StopConfigurationRecorder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopConfigurationRecorder {
    _private: (),
}
impl StopConfigurationRecorder {
    /// Creates a new builder-style object to manufacture [`StopConfigurationRecorderInput`](crate::input::StopConfigurationRecorderInput)
    pub fn builder() -> crate::input::stop_configuration_recorder_input::Builder {
        crate::input::stop_configuration_recorder_input::Builder::default()
    }
    /// Creates a new `StopConfigurationRecorder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopConfigurationRecorder {
    type Output = std::result::Result<
        crate::output::StopConfigurationRecorderOutput,
        crate::error::StopConfigurationRecorderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_configuration_recorder_error(response)
        } else {
            crate::operation_deser::parse_stop_configuration_recorder_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}
