// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The tags for the resource. The metadata that you apply to a resource to help you categorize and organize them.
/// Each tag consists of a key and an optional value, both of which you define.
/// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The details that identify a resource within Config, including
/// the resource type and resource ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceKey {
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The ID of the resource (for example., sg-xxxxxx). </p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl ResourceKey {
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx). </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceKey");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
/// See [`ResourceKey`](crate::model::ResourceKey)
pub mod resource_key {
    /// A builder for [`ResourceKey`](crate::model::ResourceKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource (for example., sg-xxxxxx). </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource (for example., sg-xxxxxx). </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceKey`](crate::model::ResourceKey)
        pub fn build(self) -> crate::model::ResourceKey {
            crate::model::ResourceKey {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
            }
        }
    }
}
impl ResourceKey {
    /// Creates a new builder-style object to manufacture [`ResourceKey`](crate::model::ResourceKey)
    pub fn builder() -> crate::model::resource_key::Builder {
        crate::model::resource_key::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Certificate,
    #[allow(missing_docs)] // documentation missing in model
    RestApi,
    #[allow(missing_docs)] // documentation missing in model
    Stage,
    #[allow(missing_docs)] // documentation missing in model
    Api,
    #[allow(missing_docs)] // documentation missing in model
    StageV2,
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingGroup,
    #[allow(missing_docs)] // documentation missing in model
    LaunchConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    ScalingPolicy,
    #[allow(missing_docs)] // documentation missing in model
    ScheduledAction,
    #[allow(missing_docs)] // documentation missing in model
    BackupPlan,
    #[allow(missing_docs)] // documentation missing in model
    BackupSelection,
    #[allow(missing_docs)] // documentation missing in model
    BackupVault,
    #[allow(missing_docs)] // documentation missing in model
    BackupRecoveryPoint,
    #[allow(missing_docs)] // documentation missing in model
    Stack,
    #[allow(missing_docs)] // documentation missing in model
    Distribution,
    #[allow(missing_docs)] // documentation missing in model
    StreamingDistribution,
    #[allow(missing_docs)] // documentation missing in model
    Trail,
    #[allow(missing_docs)] // documentation missing in model
    Alarm,
    #[allow(missing_docs)] // documentation missing in model
    Project,
    #[allow(missing_docs)] // documentation missing in model
    Pipeline,
    #[allow(missing_docs)] // documentation missing in model
    ConformancePackCompliance,
    #[allow(missing_docs)] // documentation missing in model
    ResourceCompliance,
    #[allow(missing_docs)] // documentation missing in model
    Table,
    #[allow(missing_docs)] // documentation missing in model
    CustomerGateway,
    #[allow(missing_docs)] // documentation missing in model
    Eip,
    #[allow(missing_docs)] // documentation missing in model
    EgressOnlyInternetGateway,
    #[allow(missing_docs)] // documentation missing in model
    FlowLog,
    #[allow(missing_docs)] // documentation missing in model
    Host,
    #[allow(missing_docs)] // documentation missing in model
    Instance,
    #[allow(missing_docs)] // documentation missing in model
    InternetGateway,
    #[allow(missing_docs)] // documentation missing in model
    NatGateway,
    #[allow(missing_docs)] // documentation missing in model
    NetworkAcl,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInterface,
    #[allow(missing_docs)] // documentation missing in model
    RegisteredHaInstance,
    #[allow(missing_docs)] // documentation missing in model
    RouteTable,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    Subnet,
    #[allow(missing_docs)] // documentation missing in model
    Vpc,
    #[allow(missing_docs)] // documentation missing in model
    VpcEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    VpcEndpointService,
    #[allow(missing_docs)] // documentation missing in model
    VpcPeeringConnection,
    #[allow(missing_docs)] // documentation missing in model
    VpnConnection,
    #[allow(missing_docs)] // documentation missing in model
    VpnGateway,
    #[allow(missing_docs)] // documentation missing in model
    Volume,
    #[allow(missing_docs)] // documentation missing in model
    EcrRepository,
    #[allow(missing_docs)] // documentation missing in model
    EcsCluster,
    #[allow(missing_docs)] // documentation missing in model
    EcsService,
    #[allow(missing_docs)] // documentation missing in model
    EcsTaskDefinition,
    #[allow(missing_docs)] // documentation missing in model
    EfsAccessPoint,
    #[allow(missing_docs)] // documentation missing in model
    EfsFileSystem,
    #[allow(missing_docs)] // documentation missing in model
    EksCluster,
    #[allow(missing_docs)] // documentation missing in model
    Application,
    #[allow(missing_docs)] // documentation missing in model
    ApplicationVersion,
    #[allow(missing_docs)] // documentation missing in model
    Environment,
    #[allow(missing_docs)] // documentation missing in model
    LoadBalancer,
    #[allow(missing_docs)] // documentation missing in model
    LoadBalancerV2,
    #[allow(missing_docs)] // documentation missing in model
    Domain,
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    Policy,
    #[allow(missing_docs)] // documentation missing in model
    Role,
    #[allow(missing_docs)] // documentation missing in model
    User,
    #[allow(missing_docs)] // documentation missing in model
    Key,
    #[allow(missing_docs)] // documentation missing in model
    Function,
    #[allow(missing_docs)] // documentation missing in model
    NetworkFirewallFirewall,
    #[allow(missing_docs)] // documentation missing in model
    NetworkFirewallFirewallPolicy,
    #[allow(missing_docs)] // documentation missing in model
    NetworkFirewallRuleGroup,
    #[allow(missing_docs)] // documentation missing in model
    OpenSearchDomain,
    #[allow(missing_docs)] // documentation missing in model
    QldbLedger,
    #[allow(missing_docs)] // documentation missing in model
    DbCluster,
    #[allow(missing_docs)] // documentation missing in model
    DbClusterSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    DbInstance,
    #[allow(missing_docs)] // documentation missing in model
    DbSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    DbSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    DbSubnetGroup,
    #[allow(missing_docs)] // documentation missing in model
    EventSubscription,
    #[allow(missing_docs)] // documentation missing in model
    Cluster,
    #[allow(missing_docs)] // documentation missing in model
    ClusterParameterGroup,
    #[allow(missing_docs)] // documentation missing in model
    ClusterSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    ClusterSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    ClusterSubnetGroup,
    #[allow(missing_docs)] // documentation missing in model
    RedshiftEventSubscription,
    #[allow(missing_docs)] // documentation missing in model
    AccountPublicAccessBlock,
    #[allow(missing_docs)] // documentation missing in model
    Bucket,
    #[allow(missing_docs)] // documentation missing in model
    Topic,
    #[allow(missing_docs)] // documentation missing in model
    Queue,
    #[allow(missing_docs)] // documentation missing in model
    AssociationCompliance,
    #[allow(missing_docs)] // documentation missing in model
    FileData,
    #[allow(missing_docs)] // documentation missing in model
    ManagedInstanceInventory,
    #[allow(missing_docs)] // documentation missing in model
    PatchCompliance,
    #[allow(missing_docs)] // documentation missing in model
    Secret,
    #[allow(missing_docs)] // documentation missing in model
    CloudFormationProduct,
    #[allow(missing_docs)] // documentation missing in model
    CloudFormationProvisionedProduct,
    #[allow(missing_docs)] // documentation missing in model
    Portfolio,
    #[allow(missing_docs)] // documentation missing in model
    Protection,
    #[allow(missing_docs)] // documentation missing in model
    RegionalProtection,
    #[allow(missing_docs)] // documentation missing in model
    RateBasedRule,
    #[allow(missing_docs)] // documentation missing in model
    Rule,
    #[allow(missing_docs)] // documentation missing in model
    RuleGroup,
    #[allow(missing_docs)] // documentation missing in model
    WebAcl,
    #[allow(missing_docs)] // documentation missing in model
    RegionalRateBasedRule,
    #[allow(missing_docs)] // documentation missing in model
    RegionalRule,
    #[allow(missing_docs)] // documentation missing in model
    RegionalRuleGroup,
    #[allow(missing_docs)] // documentation missing in model
    RegionalWebAcl,
    #[allow(missing_docs)] // documentation missing in model
    IpSetV2,
    #[allow(missing_docs)] // documentation missing in model
    ManagedRuleSetV2,
    #[allow(missing_docs)] // documentation missing in model
    RegexPatternSetV2,
    #[allow(missing_docs)] // documentation missing in model
    RuleGroupV2,
    #[allow(missing_docs)] // documentation missing in model
    WebAclv2,
    #[allow(missing_docs)] // documentation missing in model
    EncryptionConfig,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "AWS::ACM::Certificate" => ResourceType::Certificate,
            "AWS::ApiGateway::RestApi" => ResourceType::RestApi,
            "AWS::ApiGateway::Stage" => ResourceType::Stage,
            "AWS::ApiGatewayV2::Api" => ResourceType::Api,
            "AWS::ApiGatewayV2::Stage" => ResourceType::StageV2,
            "AWS::AutoScaling::AutoScalingGroup" => ResourceType::AutoScalingGroup,
            "AWS::AutoScaling::LaunchConfiguration" => ResourceType::LaunchConfiguration,
            "AWS::AutoScaling::ScalingPolicy" => ResourceType::ScalingPolicy,
            "AWS::AutoScaling::ScheduledAction" => ResourceType::ScheduledAction,
            "AWS::Backup::BackupPlan" => ResourceType::BackupPlan,
            "AWS::Backup::BackupSelection" => ResourceType::BackupSelection,
            "AWS::Backup::BackupVault" => ResourceType::BackupVault,
            "AWS::Backup::RecoveryPoint" => ResourceType::BackupRecoveryPoint,
            "AWS::CloudFormation::Stack" => ResourceType::Stack,
            "AWS::CloudFront::Distribution" => ResourceType::Distribution,
            "AWS::CloudFront::StreamingDistribution" => ResourceType::StreamingDistribution,
            "AWS::CloudTrail::Trail" => ResourceType::Trail,
            "AWS::CloudWatch::Alarm" => ResourceType::Alarm,
            "AWS::CodeBuild::Project" => ResourceType::Project,
            "AWS::CodePipeline::Pipeline" => ResourceType::Pipeline,
            "AWS::Config::ConformancePackCompliance" => ResourceType::ConformancePackCompliance,
            "AWS::Config::ResourceCompliance" => ResourceType::ResourceCompliance,
            "AWS::DynamoDB::Table" => ResourceType::Table,
            "AWS::EC2::CustomerGateway" => ResourceType::CustomerGateway,
            "AWS::EC2::EIP" => ResourceType::Eip,
            "AWS::EC2::EgressOnlyInternetGateway" => ResourceType::EgressOnlyInternetGateway,
            "AWS::EC2::FlowLog" => ResourceType::FlowLog,
            "AWS::EC2::Host" => ResourceType::Host,
            "AWS::EC2::Instance" => ResourceType::Instance,
            "AWS::EC2::InternetGateway" => ResourceType::InternetGateway,
            "AWS::EC2::NatGateway" => ResourceType::NatGateway,
            "AWS::EC2::NetworkAcl" => ResourceType::NetworkAcl,
            "AWS::EC2::NetworkInterface" => ResourceType::NetworkInterface,
            "AWS::EC2::RegisteredHAInstance" => ResourceType::RegisteredHaInstance,
            "AWS::EC2::RouteTable" => ResourceType::RouteTable,
            "AWS::EC2::SecurityGroup" => ResourceType::SecurityGroup,
            "AWS::EC2::Subnet" => ResourceType::Subnet,
            "AWS::EC2::VPC" => ResourceType::Vpc,
            "AWS::EC2::VPCEndpoint" => ResourceType::VpcEndpoint,
            "AWS::EC2::VPCEndpointService" => ResourceType::VpcEndpointService,
            "AWS::EC2::VPCPeeringConnection" => ResourceType::VpcPeeringConnection,
            "AWS::EC2::VPNConnection" => ResourceType::VpnConnection,
            "AWS::EC2::VPNGateway" => ResourceType::VpnGateway,
            "AWS::EC2::Volume" => ResourceType::Volume,
            "AWS::ECR::Repository" => ResourceType::EcrRepository,
            "AWS::ECS::Cluster" => ResourceType::EcsCluster,
            "AWS::ECS::Service" => ResourceType::EcsService,
            "AWS::ECS::TaskDefinition" => ResourceType::EcsTaskDefinition,
            "AWS::EFS::AccessPoint" => ResourceType::EfsAccessPoint,
            "AWS::EFS::FileSystem" => ResourceType::EfsFileSystem,
            "AWS::EKS::Cluster" => ResourceType::EksCluster,
            "AWS::ElasticBeanstalk::Application" => ResourceType::Application,
            "AWS::ElasticBeanstalk::ApplicationVersion" => ResourceType::ApplicationVersion,
            "AWS::ElasticBeanstalk::Environment" => ResourceType::Environment,
            "AWS::ElasticLoadBalancing::LoadBalancer" => ResourceType::LoadBalancer,
            "AWS::ElasticLoadBalancingV2::LoadBalancer" => ResourceType::LoadBalancerV2,
            "AWS::Elasticsearch::Domain" => ResourceType::Domain,
            "AWS::IAM::Group" => ResourceType::Group,
            "AWS::IAM::Policy" => ResourceType::Policy,
            "AWS::IAM::Role" => ResourceType::Role,
            "AWS::IAM::User" => ResourceType::User,
            "AWS::KMS::Key" => ResourceType::Key,
            "AWS::Lambda::Function" => ResourceType::Function,
            "AWS::NetworkFirewall::Firewall" => ResourceType::NetworkFirewallFirewall,
            "AWS::NetworkFirewall::FirewallPolicy" => ResourceType::NetworkFirewallFirewallPolicy,
            "AWS::NetworkFirewall::RuleGroup" => ResourceType::NetworkFirewallRuleGroup,
            "AWS::OpenSearch::Domain" => ResourceType::OpenSearchDomain,
            "AWS::QLDB::Ledger" => ResourceType::QldbLedger,
            "AWS::RDS::DBCluster" => ResourceType::DbCluster,
            "AWS::RDS::DBClusterSnapshot" => ResourceType::DbClusterSnapshot,
            "AWS::RDS::DBInstance" => ResourceType::DbInstance,
            "AWS::RDS::DBSecurityGroup" => ResourceType::DbSecurityGroup,
            "AWS::RDS::DBSnapshot" => ResourceType::DbSnapshot,
            "AWS::RDS::DBSubnetGroup" => ResourceType::DbSubnetGroup,
            "AWS::RDS::EventSubscription" => ResourceType::EventSubscription,
            "AWS::Redshift::Cluster" => ResourceType::Cluster,
            "AWS::Redshift::ClusterParameterGroup" => ResourceType::ClusterParameterGroup,
            "AWS::Redshift::ClusterSecurityGroup" => ResourceType::ClusterSecurityGroup,
            "AWS::Redshift::ClusterSnapshot" => ResourceType::ClusterSnapshot,
            "AWS::Redshift::ClusterSubnetGroup" => ResourceType::ClusterSubnetGroup,
            "AWS::Redshift::EventSubscription" => ResourceType::RedshiftEventSubscription,
            "AWS::S3::AccountPublicAccessBlock" => ResourceType::AccountPublicAccessBlock,
            "AWS::S3::Bucket" => ResourceType::Bucket,
            "AWS::SNS::Topic" => ResourceType::Topic,
            "AWS::SQS::Queue" => ResourceType::Queue,
            "AWS::SSM::AssociationCompliance" => ResourceType::AssociationCompliance,
            "AWS::SSM::FileData" => ResourceType::FileData,
            "AWS::SSM::ManagedInstanceInventory" => ResourceType::ManagedInstanceInventory,
            "AWS::SSM::PatchCompliance" => ResourceType::PatchCompliance,
            "AWS::SecretsManager::Secret" => ResourceType::Secret,
            "AWS::ServiceCatalog::CloudFormationProduct" => ResourceType::CloudFormationProduct,
            "AWS::ServiceCatalog::CloudFormationProvisionedProduct" => {
                ResourceType::CloudFormationProvisionedProduct
            }
            "AWS::ServiceCatalog::Portfolio" => ResourceType::Portfolio,
            "AWS::Shield::Protection" => ResourceType::Protection,
            "AWS::ShieldRegional::Protection" => ResourceType::RegionalProtection,
            "AWS::WAF::RateBasedRule" => ResourceType::RateBasedRule,
            "AWS::WAF::Rule" => ResourceType::Rule,
            "AWS::WAF::RuleGroup" => ResourceType::RuleGroup,
            "AWS::WAF::WebACL" => ResourceType::WebAcl,
            "AWS::WAFRegional::RateBasedRule" => ResourceType::RegionalRateBasedRule,
            "AWS::WAFRegional::Rule" => ResourceType::RegionalRule,
            "AWS::WAFRegional::RuleGroup" => ResourceType::RegionalRuleGroup,
            "AWS::WAFRegional::WebACL" => ResourceType::RegionalWebAcl,
            "AWS::WAFv2::IPSet" => ResourceType::IpSetV2,
            "AWS::WAFv2::ManagedRuleSet" => ResourceType::ManagedRuleSetV2,
            "AWS::WAFv2::RegexPatternSet" => ResourceType::RegexPatternSetV2,
            "AWS::WAFv2::RuleGroup" => ResourceType::RuleGroupV2,
            "AWS::WAFv2::WebACL" => ResourceType::WebAclv2,
            "AWS::XRay::EncryptionConfig" => ResourceType::EncryptionConfig,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Certificate => "AWS::ACM::Certificate",
            ResourceType::RestApi => "AWS::ApiGateway::RestApi",
            ResourceType::Stage => "AWS::ApiGateway::Stage",
            ResourceType::Api => "AWS::ApiGatewayV2::Api",
            ResourceType::StageV2 => "AWS::ApiGatewayV2::Stage",
            ResourceType::AutoScalingGroup => "AWS::AutoScaling::AutoScalingGroup",
            ResourceType::LaunchConfiguration => "AWS::AutoScaling::LaunchConfiguration",
            ResourceType::ScalingPolicy => "AWS::AutoScaling::ScalingPolicy",
            ResourceType::ScheduledAction => "AWS::AutoScaling::ScheduledAction",
            ResourceType::BackupPlan => "AWS::Backup::BackupPlan",
            ResourceType::BackupSelection => "AWS::Backup::BackupSelection",
            ResourceType::BackupVault => "AWS::Backup::BackupVault",
            ResourceType::BackupRecoveryPoint => "AWS::Backup::RecoveryPoint",
            ResourceType::Stack => "AWS::CloudFormation::Stack",
            ResourceType::Distribution => "AWS::CloudFront::Distribution",
            ResourceType::StreamingDistribution => "AWS::CloudFront::StreamingDistribution",
            ResourceType::Trail => "AWS::CloudTrail::Trail",
            ResourceType::Alarm => "AWS::CloudWatch::Alarm",
            ResourceType::Project => "AWS::CodeBuild::Project",
            ResourceType::Pipeline => "AWS::CodePipeline::Pipeline",
            ResourceType::ConformancePackCompliance => "AWS::Config::ConformancePackCompliance",
            ResourceType::ResourceCompliance => "AWS::Config::ResourceCompliance",
            ResourceType::Table => "AWS::DynamoDB::Table",
            ResourceType::CustomerGateway => "AWS::EC2::CustomerGateway",
            ResourceType::Eip => "AWS::EC2::EIP",
            ResourceType::EgressOnlyInternetGateway => "AWS::EC2::EgressOnlyInternetGateway",
            ResourceType::FlowLog => "AWS::EC2::FlowLog",
            ResourceType::Host => "AWS::EC2::Host",
            ResourceType::Instance => "AWS::EC2::Instance",
            ResourceType::InternetGateway => "AWS::EC2::InternetGateway",
            ResourceType::NatGateway => "AWS::EC2::NatGateway",
            ResourceType::NetworkAcl => "AWS::EC2::NetworkAcl",
            ResourceType::NetworkInterface => "AWS::EC2::NetworkInterface",
            ResourceType::RegisteredHaInstance => "AWS::EC2::RegisteredHAInstance",
            ResourceType::RouteTable => "AWS::EC2::RouteTable",
            ResourceType::SecurityGroup => "AWS::EC2::SecurityGroup",
            ResourceType::Subnet => "AWS::EC2::Subnet",
            ResourceType::Vpc => "AWS::EC2::VPC",
            ResourceType::VpcEndpoint => "AWS::EC2::VPCEndpoint",
            ResourceType::VpcEndpointService => "AWS::EC2::VPCEndpointService",
            ResourceType::VpcPeeringConnection => "AWS::EC2::VPCPeeringConnection",
            ResourceType::VpnConnection => "AWS::EC2::VPNConnection",
            ResourceType::VpnGateway => "AWS::EC2::VPNGateway",
            ResourceType::Volume => "AWS::EC2::Volume",
            ResourceType::EcrRepository => "AWS::ECR::Repository",
            ResourceType::EcsCluster => "AWS::ECS::Cluster",
            ResourceType::EcsService => "AWS::ECS::Service",
            ResourceType::EcsTaskDefinition => "AWS::ECS::TaskDefinition",
            ResourceType::EfsAccessPoint => "AWS::EFS::AccessPoint",
            ResourceType::EfsFileSystem => "AWS::EFS::FileSystem",
            ResourceType::EksCluster => "AWS::EKS::Cluster",
            ResourceType::Application => "AWS::ElasticBeanstalk::Application",
            ResourceType::ApplicationVersion => "AWS::ElasticBeanstalk::ApplicationVersion",
            ResourceType::Environment => "AWS::ElasticBeanstalk::Environment",
            ResourceType::LoadBalancer => "AWS::ElasticLoadBalancing::LoadBalancer",
            ResourceType::LoadBalancerV2 => "AWS::ElasticLoadBalancingV2::LoadBalancer",
            ResourceType::Domain => "AWS::Elasticsearch::Domain",
            ResourceType::Group => "AWS::IAM::Group",
            ResourceType::Policy => "AWS::IAM::Policy",
            ResourceType::Role => "AWS::IAM::Role",
            ResourceType::User => "AWS::IAM::User",
            ResourceType::Key => "AWS::KMS::Key",
            ResourceType::Function => "AWS::Lambda::Function",
            ResourceType::NetworkFirewallFirewall => "AWS::NetworkFirewall::Firewall",
            ResourceType::NetworkFirewallFirewallPolicy => "AWS::NetworkFirewall::FirewallPolicy",
            ResourceType::NetworkFirewallRuleGroup => "AWS::NetworkFirewall::RuleGroup",
            ResourceType::OpenSearchDomain => "AWS::OpenSearch::Domain",
            ResourceType::QldbLedger => "AWS::QLDB::Ledger",
            ResourceType::DbCluster => "AWS::RDS::DBCluster",
            ResourceType::DbClusterSnapshot => "AWS::RDS::DBClusterSnapshot",
            ResourceType::DbInstance => "AWS::RDS::DBInstance",
            ResourceType::DbSecurityGroup => "AWS::RDS::DBSecurityGroup",
            ResourceType::DbSnapshot => "AWS::RDS::DBSnapshot",
            ResourceType::DbSubnetGroup => "AWS::RDS::DBSubnetGroup",
            ResourceType::EventSubscription => "AWS::RDS::EventSubscription",
            ResourceType::Cluster => "AWS::Redshift::Cluster",
            ResourceType::ClusterParameterGroup => "AWS::Redshift::ClusterParameterGroup",
            ResourceType::ClusterSecurityGroup => "AWS::Redshift::ClusterSecurityGroup",
            ResourceType::ClusterSnapshot => "AWS::Redshift::ClusterSnapshot",
            ResourceType::ClusterSubnetGroup => "AWS::Redshift::ClusterSubnetGroup",
            ResourceType::RedshiftEventSubscription => "AWS::Redshift::EventSubscription",
            ResourceType::AccountPublicAccessBlock => "AWS::S3::AccountPublicAccessBlock",
            ResourceType::Bucket => "AWS::S3::Bucket",
            ResourceType::Topic => "AWS::SNS::Topic",
            ResourceType::Queue => "AWS::SQS::Queue",
            ResourceType::AssociationCompliance => "AWS::SSM::AssociationCompliance",
            ResourceType::FileData => "AWS::SSM::FileData",
            ResourceType::ManagedInstanceInventory => "AWS::SSM::ManagedInstanceInventory",
            ResourceType::PatchCompliance => "AWS::SSM::PatchCompliance",
            ResourceType::Secret => "AWS::SecretsManager::Secret",
            ResourceType::CloudFormationProduct => "AWS::ServiceCatalog::CloudFormationProduct",
            ResourceType::CloudFormationProvisionedProduct => {
                "AWS::ServiceCatalog::CloudFormationProvisionedProduct"
            }
            ResourceType::Portfolio => "AWS::ServiceCatalog::Portfolio",
            ResourceType::Protection => "AWS::Shield::Protection",
            ResourceType::RegionalProtection => "AWS::ShieldRegional::Protection",
            ResourceType::RateBasedRule => "AWS::WAF::RateBasedRule",
            ResourceType::Rule => "AWS::WAF::Rule",
            ResourceType::RuleGroup => "AWS::WAF::RuleGroup",
            ResourceType::WebAcl => "AWS::WAF::WebACL",
            ResourceType::RegionalRateBasedRule => "AWS::WAFRegional::RateBasedRule",
            ResourceType::RegionalRule => "AWS::WAFRegional::Rule",
            ResourceType::RegionalRuleGroup => "AWS::WAFRegional::RuleGroup",
            ResourceType::RegionalWebAcl => "AWS::WAFRegional::WebACL",
            ResourceType::IpSetV2 => "AWS::WAFv2::IPSet",
            ResourceType::ManagedRuleSetV2 => "AWS::WAFv2::ManagedRuleSet",
            ResourceType::RegexPatternSetV2 => "AWS::WAFv2::RegexPatternSet",
            ResourceType::RuleGroupV2 => "AWS::WAFv2::RuleGroup",
            ResourceType::WebAclv2 => "AWS::WAFv2::WebACL",
            ResourceType::EncryptionConfig => "AWS::XRay::EncryptionConfig",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS::ACM::Certificate",
            "AWS::ApiGateway::RestApi",
            "AWS::ApiGateway::Stage",
            "AWS::ApiGatewayV2::Api",
            "AWS::ApiGatewayV2::Stage",
            "AWS::AutoScaling::AutoScalingGroup",
            "AWS::AutoScaling::LaunchConfiguration",
            "AWS::AutoScaling::ScalingPolicy",
            "AWS::AutoScaling::ScheduledAction",
            "AWS::Backup::BackupPlan",
            "AWS::Backup::BackupSelection",
            "AWS::Backup::BackupVault",
            "AWS::Backup::RecoveryPoint",
            "AWS::CloudFormation::Stack",
            "AWS::CloudFront::Distribution",
            "AWS::CloudFront::StreamingDistribution",
            "AWS::CloudTrail::Trail",
            "AWS::CloudWatch::Alarm",
            "AWS::CodeBuild::Project",
            "AWS::CodePipeline::Pipeline",
            "AWS::Config::ConformancePackCompliance",
            "AWS::Config::ResourceCompliance",
            "AWS::DynamoDB::Table",
            "AWS::EC2::CustomerGateway",
            "AWS::EC2::EIP",
            "AWS::EC2::EgressOnlyInternetGateway",
            "AWS::EC2::FlowLog",
            "AWS::EC2::Host",
            "AWS::EC2::Instance",
            "AWS::EC2::InternetGateway",
            "AWS::EC2::NatGateway",
            "AWS::EC2::NetworkAcl",
            "AWS::EC2::NetworkInterface",
            "AWS::EC2::RegisteredHAInstance",
            "AWS::EC2::RouteTable",
            "AWS::EC2::SecurityGroup",
            "AWS::EC2::Subnet",
            "AWS::EC2::VPC",
            "AWS::EC2::VPCEndpoint",
            "AWS::EC2::VPCEndpointService",
            "AWS::EC2::VPCPeeringConnection",
            "AWS::EC2::VPNConnection",
            "AWS::EC2::VPNGateway",
            "AWS::EC2::Volume",
            "AWS::ECR::Repository",
            "AWS::ECS::Cluster",
            "AWS::ECS::Service",
            "AWS::ECS::TaskDefinition",
            "AWS::EFS::AccessPoint",
            "AWS::EFS::FileSystem",
            "AWS::EKS::Cluster",
            "AWS::ElasticBeanstalk::Application",
            "AWS::ElasticBeanstalk::ApplicationVersion",
            "AWS::ElasticBeanstalk::Environment",
            "AWS::ElasticLoadBalancing::LoadBalancer",
            "AWS::ElasticLoadBalancingV2::LoadBalancer",
            "AWS::Elasticsearch::Domain",
            "AWS::IAM::Group",
            "AWS::IAM::Policy",
            "AWS::IAM::Role",
            "AWS::IAM::User",
            "AWS::KMS::Key",
            "AWS::Lambda::Function",
            "AWS::NetworkFirewall::Firewall",
            "AWS::NetworkFirewall::FirewallPolicy",
            "AWS::NetworkFirewall::RuleGroup",
            "AWS::OpenSearch::Domain",
            "AWS::QLDB::Ledger",
            "AWS::RDS::DBCluster",
            "AWS::RDS::DBClusterSnapshot",
            "AWS::RDS::DBInstance",
            "AWS::RDS::DBSecurityGroup",
            "AWS::RDS::DBSnapshot",
            "AWS::RDS::DBSubnetGroup",
            "AWS::RDS::EventSubscription",
            "AWS::Redshift::Cluster",
            "AWS::Redshift::ClusterParameterGroup",
            "AWS::Redshift::ClusterSecurityGroup",
            "AWS::Redshift::ClusterSnapshot",
            "AWS::Redshift::ClusterSubnetGroup",
            "AWS::Redshift::EventSubscription",
            "AWS::S3::AccountPublicAccessBlock",
            "AWS::S3::Bucket",
            "AWS::SNS::Topic",
            "AWS::SQS::Queue",
            "AWS::SSM::AssociationCompliance",
            "AWS::SSM::FileData",
            "AWS::SSM::ManagedInstanceInventory",
            "AWS::SSM::PatchCompliance",
            "AWS::SecretsManager::Secret",
            "AWS::ServiceCatalog::CloudFormationProduct",
            "AWS::ServiceCatalog::CloudFormationProvisionedProduct",
            "AWS::ServiceCatalog::Portfolio",
            "AWS::Shield::Protection",
            "AWS::ShieldRegional::Protection",
            "AWS::WAF::RateBasedRule",
            "AWS::WAF::Rule",
            "AWS::WAF::RuleGroup",
            "AWS::WAF::WebACL",
            "AWS::WAFRegional::RateBasedRule",
            "AWS::WAFRegional::Rule",
            "AWS::WAFRegional::RuleGroup",
            "AWS::WAFRegional::WebACL",
            "AWS::WAFv2::IPSet",
            "AWS::WAFv2::ManagedRuleSet",
            "AWS::WAFv2::RegexPatternSet",
            "AWS::WAFv2::RuleGroup",
            "AWS::WAFv2::WebACL",
            "AWS::XRay::EncryptionConfig",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about the query.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryInfo {
    /// <p>Returns a <code>FieldInfo</code> object.</p>
    pub select_fields: std::option::Option<std::vec::Vec<crate::model::FieldInfo>>,
}
impl QueryInfo {
    /// <p>Returns a <code>FieldInfo</code> object.</p>
    pub fn select_fields(&self) -> std::option::Option<&[crate::model::FieldInfo]> {
        self.select_fields.as_deref()
    }
}
impl std::fmt::Debug for QueryInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryInfo");
        formatter.field("select_fields", &self.select_fields);
        formatter.finish()
    }
}
/// See [`QueryInfo`](crate::model::QueryInfo)
pub mod query_info {
    /// A builder for [`QueryInfo`](crate::model::QueryInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) select_fields: std::option::Option<std::vec::Vec<crate::model::FieldInfo>>,
    }
    impl Builder {
        /// Appends an item to `select_fields`.
        ///
        /// To override the contents of this collection use [`set_select_fields`](Self::set_select_fields).
        ///
        /// <p>Returns a <code>FieldInfo</code> object.</p>
        pub fn select_fields(mut self, input: impl Into<crate::model::FieldInfo>) -> Self {
            let mut v = self.select_fields.unwrap_or_default();
            v.push(input.into());
            self.select_fields = Some(v);
            self
        }
        /// <p>Returns a <code>FieldInfo</code> object.</p>
        pub fn set_select_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FieldInfo>>,
        ) -> Self {
            self.select_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryInfo`](crate::model::QueryInfo)
        pub fn build(self) -> crate::model::QueryInfo {
            crate::model::QueryInfo {
                select_fields: self.select_fields,
            }
        }
    }
}
impl QueryInfo {
    /// Creates a new builder-style object to manufacture [`QueryInfo`](crate::model::QueryInfo)
    pub fn builder() -> crate::model::query_info::Builder {
        crate::model::query_info::Builder::default()
    }
}

/// <p>Details about the fields such as name of the field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldInfo {
    /// <p>Name of the field.</p>
    pub name: std::option::Option<std::string::String>,
}
impl FieldInfo {
    /// <p>Name of the field.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for FieldInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldInfo");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`FieldInfo`](crate::model::FieldInfo)
pub mod field_info {
    /// A builder for [`FieldInfo`](crate::model::FieldInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the field.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the field.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldInfo`](crate::model::FieldInfo)
        pub fn build(self) -> crate::model::FieldInfo {
            crate::model::FieldInfo { name: self.name }
        }
    }
}
impl FieldInfo {
    /// Creates a new builder-style object to manufacture [`FieldInfo`](crate::model::FieldInfo)
    pub fn builder() -> crate::model::field_info::Builder {
        crate::model::field_info::Builder::default()
    }
}

/// <p>Provides the details of a stored query.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StoredQuery {
    /// <p>The ID of the query.</p>
    pub query_id: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
    pub query_arn: std::option::Option<std::string::String>,
    /// <p>The name of the query.</p>
    pub query_name: std::option::Option<std::string::String>,
    /// <p>A unique description for the query.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The expression of the query. For example, <code>SELECT
    /// resourceId,
    /// resourceType,
    /// supplementaryConfiguration.BucketVersioningConfiguration.status
    /// WHERE
    /// resourceType = 'AWS::S3::Bucket'
    /// AND supplementaryConfiguration.BucketVersioningConfiguration.status = 'Off'.</code>
    /// </p>
    pub expression: std::option::Option<std::string::String>,
}
impl StoredQuery {
    /// <p>The ID of the query.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
    pub fn query_arn(&self) -> std::option::Option<&str> {
        self.query_arn.as_deref()
    }
    /// <p>The name of the query.</p>
    pub fn query_name(&self) -> std::option::Option<&str> {
        self.query_name.as_deref()
    }
    /// <p>A unique description for the query.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The expression of the query. For example, <code>SELECT
    /// resourceId,
    /// resourceType,
    /// supplementaryConfiguration.BucketVersioningConfiguration.status
    /// WHERE
    /// resourceType = 'AWS::S3::Bucket'
    /// AND supplementaryConfiguration.BucketVersioningConfiguration.status = 'Off'.</code>
    /// </p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
}
impl std::fmt::Debug for StoredQuery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StoredQuery");
        formatter.field("query_id", &self.query_id);
        formatter.field("query_arn", &self.query_arn);
        formatter.field("query_name", &self.query_name);
        formatter.field("description", &self.description);
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}
/// See [`StoredQuery`](crate::model::StoredQuery)
pub mod stored_query {
    /// A builder for [`StoredQuery`](crate::model::StoredQuery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_id: std::option::Option<std::string::String>,
        pub(crate) query_arn: std::option::Option<std::string::String>,
        pub(crate) query_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the query.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of the query.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
        pub fn query_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
        pub fn set_query_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_arn = input;
            self
        }
        /// <p>The name of the query.</p>
        pub fn query_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_name = Some(input.into());
            self
        }
        /// <p>The name of the query.</p>
        pub fn set_query_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_name = input;
            self
        }
        /// <p>A unique description for the query.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A unique description for the query.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The expression of the query. For example, <code>SELECT
        /// resourceId,
        /// resourceType,
        /// supplementaryConfiguration.BucketVersioningConfiguration.status
        /// WHERE
        /// resourceType = 'AWS::S3::Bucket'
        /// AND supplementaryConfiguration.BucketVersioningConfiguration.status = 'Off'.</code>
        /// </p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The expression of the query. For example, <code>SELECT
        /// resourceId,
        /// resourceType,
        /// supplementaryConfiguration.BucketVersioningConfiguration.status
        /// WHERE
        /// resourceType = 'AWS::S3::Bucket'
        /// AND supplementaryConfiguration.BucketVersioningConfiguration.status = 'Off'.</code>
        /// </p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`StoredQuery`](crate::model::StoredQuery)
        pub fn build(self) -> crate::model::StoredQuery {
            crate::model::StoredQuery {
                query_id: self.query_id,
                query_arn: self.query_arn,
                query_name: self.query_name,
                description: self.description,
                expression: self.expression,
            }
        }
    }
}
impl StoredQuery {
    /// Creates a new builder-style object to manufacture [`StoredQuery`](crate::model::StoredQuery)
    pub fn builder() -> crate::model::stored_query::Builder {
        crate::model::stored_query::Builder::default()
    }
}

/// <p>An object with the name of the retention configuration and the retention period in days. The object stores the configuration for data retention in Config.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetentionConfiguration {
    /// <p>The name of the retention configuration object.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Number of days Config stores your historical information.</p>
    /// <note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    pub retention_period_in_days: i32,
}
impl RetentionConfiguration {
    /// <p>The name of the retention configuration object.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Number of days Config stores your historical information.</p>
    /// <note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    pub fn retention_period_in_days(&self) -> i32 {
        self.retention_period_in_days
    }
}
impl std::fmt::Debug for RetentionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetentionConfiguration");
        formatter.field("name", &self.name);
        formatter.field("retention_period_in_days", &self.retention_period_in_days);
        formatter.finish()
    }
}
/// See [`RetentionConfiguration`](crate::model::RetentionConfiguration)
pub mod retention_configuration {
    /// A builder for [`RetentionConfiguration`](crate::model::RetentionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) retention_period_in_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the retention configuration object.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the retention configuration object.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Number of days Config stores your historical information.</p>
        /// <note>
        /// <p>Currently, only applicable to the configuration item history.</p>
        /// </note>
        pub fn retention_period_in_days(mut self, input: i32) -> Self {
            self.retention_period_in_days = Some(input);
            self
        }
        /// <p>Number of days Config stores your historical information.</p>
        /// <note>
        /// <p>Currently, only applicable to the configuration item history.</p>
        /// </note>
        pub fn set_retention_period_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period_in_days = input;
            self
        }
        /// Consumes the builder and constructs a [`RetentionConfiguration`](crate::model::RetentionConfiguration)
        pub fn build(self) -> crate::model::RetentionConfiguration {
            crate::model::RetentionConfiguration {
                name: self.name,
                retention_period_in_days: self.retention_period_in_days.unwrap_or_default(),
            }
        }
    }
}
impl RetentionConfiguration {
    /// Creates a new builder-style object to manufacture [`RetentionConfiguration`](crate::model::RetentionConfiguration)
    pub fn builder() -> crate::model::retention_configuration::Builder {
        crate::model::retention_configuration::Builder::default()
    }
}

/// <p>List of each of the failed remediation exceptions with specific reasons.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedRemediationExceptionBatch {
    /// <p>Returns a failure message. For example, the auto-remediation has failed.</p>
    pub failure_message: std::option::Option<std::string::String>,
    /// <p>Returns remediation exception resource key object of the failed items.</p>
    pub failed_items: std::option::Option<std::vec::Vec<crate::model::RemediationException>>,
}
impl FailedRemediationExceptionBatch {
    /// <p>Returns a failure message. For example, the auto-remediation has failed.</p>
    pub fn failure_message(&self) -> std::option::Option<&str> {
        self.failure_message.as_deref()
    }
    /// <p>Returns remediation exception resource key object of the failed items.</p>
    pub fn failed_items(&self) -> std::option::Option<&[crate::model::RemediationException]> {
        self.failed_items.as_deref()
    }
}
impl std::fmt::Debug for FailedRemediationExceptionBatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedRemediationExceptionBatch");
        formatter.field("failure_message", &self.failure_message);
        formatter.field("failed_items", &self.failed_items);
        formatter.finish()
    }
}
/// See [`FailedRemediationExceptionBatch`](crate::model::FailedRemediationExceptionBatch)
pub mod failed_remediation_exception_batch {
    /// A builder for [`FailedRemediationExceptionBatch`](crate::model::FailedRemediationExceptionBatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_message: std::option::Option<std::string::String>,
        pub(crate) failed_items:
            std::option::Option<std::vec::Vec<crate::model::RemediationException>>,
    }
    impl Builder {
        /// <p>Returns a failure message. For example, the auto-remediation has failed.</p>
        pub fn failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_message = Some(input.into());
            self
        }
        /// <p>Returns a failure message. For example, the auto-remediation has failed.</p>
        pub fn set_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_message = input;
            self
        }
        /// Appends an item to `failed_items`.
        ///
        /// To override the contents of this collection use [`set_failed_items`](Self::set_failed_items).
        ///
        /// <p>Returns remediation exception resource key object of the failed items.</p>
        pub fn failed_items(
            mut self,
            input: impl Into<crate::model::RemediationException>,
        ) -> Self {
            let mut v = self.failed_items.unwrap_or_default();
            v.push(input.into());
            self.failed_items = Some(v);
            self
        }
        /// <p>Returns remediation exception resource key object of the failed items.</p>
        pub fn set_failed_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RemediationException>>,
        ) -> Self {
            self.failed_items = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedRemediationExceptionBatch`](crate::model::FailedRemediationExceptionBatch)
        pub fn build(self) -> crate::model::FailedRemediationExceptionBatch {
            crate::model::FailedRemediationExceptionBatch {
                failure_message: self.failure_message,
                failed_items: self.failed_items,
            }
        }
    }
}
impl FailedRemediationExceptionBatch {
    /// Creates a new builder-style object to manufacture [`FailedRemediationExceptionBatch`](crate::model::FailedRemediationExceptionBatch)
    pub fn builder() -> crate::model::failed_remediation_exception_batch::Builder {
        crate::model::failed_remediation_exception_batch::Builder::default()
    }
}

/// <p>An object that represents the details about the remediation exception. The details include the rule name, an explanation of an exception, the time when the exception will be deleted, the resource ID, and resource type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemediationException {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>The type of a resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>An explanation of an remediation exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time when the remediation exception will be deleted.</p>
    pub expiration_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl RemediationException {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>The type of a resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>An explanation of an remediation exception.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time when the remediation exception will be deleted.</p>
    pub fn expiration_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration_time.as_ref()
    }
}
impl std::fmt::Debug for RemediationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemediationException");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("message", &self.message);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.finish()
    }
}
/// See [`RemediationException`](crate::model::RemediationException)
pub mod remediation_exception {
    /// A builder for [`RemediationException`](crate::model::RemediationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) expiration_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the Config rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>The type of a resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of a resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>An explanation of an remediation exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An explanation of an remediation exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time when the remediation exception will be deleted.</p>
        pub fn expiration_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration_time = Some(input);
            self
        }
        /// <p>The time when the remediation exception will be deleted.</p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration_time = input;
            self
        }
        /// Consumes the builder and constructs a [`RemediationException`](crate::model::RemediationException)
        pub fn build(self) -> crate::model::RemediationException {
            crate::model::RemediationException {
                config_rule_name: self.config_rule_name,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                message: self.message,
                expiration_time: self.expiration_time,
            }
        }
    }
}
impl RemediationException {
    /// Creates a new builder-style object to manufacture [`RemediationException`](crate::model::RemediationException)
    pub fn builder() -> crate::model::remediation_exception::Builder {
        crate::model::remediation_exception::Builder::default()
    }
}

/// <p>The details that identify a resource within Config, including the resource type and resource ID. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemediationExceptionResourceKey {
    /// <p>The type of a resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl RemediationExceptionResourceKey {
    /// <p>The type of a resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for RemediationExceptionResourceKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemediationExceptionResourceKey");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
/// See [`RemediationExceptionResourceKey`](crate::model::RemediationExceptionResourceKey)
pub mod remediation_exception_resource_key {
    /// A builder for [`RemediationExceptionResourceKey`](crate::model::RemediationExceptionResourceKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of a resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of a resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemediationExceptionResourceKey`](crate::model::RemediationExceptionResourceKey)
        pub fn build(self) -> crate::model::RemediationExceptionResourceKey {
            crate::model::RemediationExceptionResourceKey {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
            }
        }
    }
}
impl RemediationExceptionResourceKey {
    /// Creates a new builder-style object to manufacture [`RemediationExceptionResourceKey`](crate::model::RemediationExceptionResourceKey)
    pub fn builder() -> crate::model::remediation_exception_resource_key::Builder {
        crate::model::remediation_exception_resource_key::Builder::default()
    }
}

/// <p>List of each of the failed remediations with specific reasons.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedRemediationBatch {
    /// <p>Returns a failure message. For example, the resource is already compliant.</p>
    pub failure_message: std::option::Option<std::string::String>,
    /// <p>Returns remediation configurations of the failed items.</p>
    pub failed_items: std::option::Option<std::vec::Vec<crate::model::RemediationConfiguration>>,
}
impl FailedRemediationBatch {
    /// <p>Returns a failure message. For example, the resource is already compliant.</p>
    pub fn failure_message(&self) -> std::option::Option<&str> {
        self.failure_message.as_deref()
    }
    /// <p>Returns remediation configurations of the failed items.</p>
    pub fn failed_items(&self) -> std::option::Option<&[crate::model::RemediationConfiguration]> {
        self.failed_items.as_deref()
    }
}
impl std::fmt::Debug for FailedRemediationBatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedRemediationBatch");
        formatter.field("failure_message", &self.failure_message);
        formatter.field("failed_items", &self.failed_items);
        formatter.finish()
    }
}
/// See [`FailedRemediationBatch`](crate::model::FailedRemediationBatch)
pub mod failed_remediation_batch {
    /// A builder for [`FailedRemediationBatch`](crate::model::FailedRemediationBatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_message: std::option::Option<std::string::String>,
        pub(crate) failed_items:
            std::option::Option<std::vec::Vec<crate::model::RemediationConfiguration>>,
    }
    impl Builder {
        /// <p>Returns a failure message. For example, the resource is already compliant.</p>
        pub fn failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_message = Some(input.into());
            self
        }
        /// <p>Returns a failure message. For example, the resource is already compliant.</p>
        pub fn set_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_message = input;
            self
        }
        /// Appends an item to `failed_items`.
        ///
        /// To override the contents of this collection use [`set_failed_items`](Self::set_failed_items).
        ///
        /// <p>Returns remediation configurations of the failed items.</p>
        pub fn failed_items(
            mut self,
            input: impl Into<crate::model::RemediationConfiguration>,
        ) -> Self {
            let mut v = self.failed_items.unwrap_or_default();
            v.push(input.into());
            self.failed_items = Some(v);
            self
        }
        /// <p>Returns remediation configurations of the failed items.</p>
        pub fn set_failed_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RemediationConfiguration>>,
        ) -> Self {
            self.failed_items = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedRemediationBatch`](crate::model::FailedRemediationBatch)
        pub fn build(self) -> crate::model::FailedRemediationBatch {
            crate::model::FailedRemediationBatch {
                failure_message: self.failure_message,
                failed_items: self.failed_items,
            }
        }
    }
}
impl FailedRemediationBatch {
    /// Creates a new builder-style object to manufacture [`FailedRemediationBatch`](crate::model::FailedRemediationBatch)
    pub fn builder() -> crate::model::failed_remediation_batch::Builder {
        crate::model::failed_remediation_batch::Builder::default()
    }
}

/// <p>An object that represents the details about the remediation configuration that includes the remediation action, parameters, and data to execute the action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemediationConfiguration {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>The type of the target. Target executes remediation. For example, SSM document.</p>
    pub target_type: std::option::Option<crate::model::RemediationTargetType>,
    /// <p>Target ID is the name of the public document.</p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p>Version of the target. For example, version of the SSM document.</p>
    /// <note>
    /// <p>If you make backward incompatible changes to the SSM document,
    /// you must call PutRemediationConfiguration API again to ensure the remediations can run.</p>
    /// </note>
    pub target_version: std::option::Option<std::string::String>,
    /// <p>An object of the RemediationParameterValue.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::RemediationParameterValue>,
    >,
    /// <p>The type of a resource. </p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The remediation is triggered automatically.</p>
    pub automatic: bool,
    /// <p>An ExecutionControls object.</p>
    pub execution_controls: std::option::Option<crate::model::ExecutionControls>,
    /// <p>The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.</p>
    /// <p>For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds,
    ///
    /// Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.</p>
    pub maximum_automatic_attempts: std::option::Option<i32>,
    /// <p>Maximum time in seconds that Config runs auto-remediation. If you do not select a number, the default is 60 seconds. </p>
    /// <p>For example, if you specify RetryAttemptSeconds as 50 seconds and MaximumAutomaticAttempts as 5,
    /// Config will run auto-remediations 5 times within 50 seconds before throwing an exception.</p>
    pub retry_attempt_seconds: std::option::Option<i64>,
    /// <p>Amazon Resource Name (ARN) of remediation configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Name of the service that owns the service linked rule, if applicable.</p>
    pub created_by_service: std::option::Option<std::string::String>,
}
impl RemediationConfiguration {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>The type of the target. Target executes remediation. For example, SSM document.</p>
    pub fn target_type(&self) -> std::option::Option<&crate::model::RemediationTargetType> {
        self.target_type.as_ref()
    }
    /// <p>Target ID is the name of the public document.</p>
    pub fn target_id(&self) -> std::option::Option<&str> {
        self.target_id.as_deref()
    }
    /// <p>Version of the target. For example, version of the SSM document.</p>
    /// <note>
    /// <p>If you make backward incompatible changes to the SSM document,
    /// you must call PutRemediationConfiguration API again to ensure the remediations can run.</p>
    /// </note>
    pub fn target_version(&self) -> std::option::Option<&str> {
        self.target_version.as_deref()
    }
    /// <p>An object of the RemediationParameterValue.</p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::RemediationParameterValue>,
    > {
        self.parameters.as_ref()
    }
    /// <p>The type of a resource. </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The remediation is triggered automatically.</p>
    pub fn automatic(&self) -> bool {
        self.automatic
    }
    /// <p>An ExecutionControls object.</p>
    pub fn execution_controls(&self) -> std::option::Option<&crate::model::ExecutionControls> {
        self.execution_controls.as_ref()
    }
    /// <p>The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.</p>
    /// <p>For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds,
    ///
    /// Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.</p>
    pub fn maximum_automatic_attempts(&self) -> std::option::Option<i32> {
        self.maximum_automatic_attempts
    }
    /// <p>Maximum time in seconds that Config runs auto-remediation. If you do not select a number, the default is 60 seconds. </p>
    /// <p>For example, if you specify RetryAttemptSeconds as 50 seconds and MaximumAutomaticAttempts as 5,
    /// Config will run auto-remediations 5 times within 50 seconds before throwing an exception.</p>
    pub fn retry_attempt_seconds(&self) -> std::option::Option<i64> {
        self.retry_attempt_seconds
    }
    /// <p>Amazon Resource Name (ARN) of remediation configuration.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Name of the service that owns the service linked rule, if applicable.</p>
    pub fn created_by_service(&self) -> std::option::Option<&str> {
        self.created_by_service.as_deref()
    }
}
impl std::fmt::Debug for RemediationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemediationConfiguration");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("target_type", &self.target_type);
        formatter.field("target_id", &self.target_id);
        formatter.field("target_version", &self.target_version);
        formatter.field("parameters", &self.parameters);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("automatic", &self.automatic);
        formatter.field("execution_controls", &self.execution_controls);
        formatter.field(
            "maximum_automatic_attempts",
            &self.maximum_automatic_attempts,
        );
        formatter.field("retry_attempt_seconds", &self.retry_attempt_seconds);
        formatter.field("arn", &self.arn);
        formatter.field("created_by_service", &self.created_by_service);
        formatter.finish()
    }
}
/// See [`RemediationConfiguration`](crate::model::RemediationConfiguration)
pub mod remediation_configuration {
    /// A builder for [`RemediationConfiguration`](crate::model::RemediationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) target_type: std::option::Option<crate::model::RemediationTargetType>,
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) target_version: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::RemediationParameterValue>,
        >,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) automatic: std::option::Option<bool>,
        pub(crate) execution_controls: std::option::Option<crate::model::ExecutionControls>,
        pub(crate) maximum_automatic_attempts: std::option::Option<i32>,
        pub(crate) retry_attempt_seconds: std::option::Option<i64>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_by_service: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Config rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>The type of the target. Target executes remediation. For example, SSM document.</p>
        pub fn target_type(mut self, input: crate::model::RemediationTargetType) -> Self {
            self.target_type = Some(input);
            self
        }
        /// <p>The type of the target. Target executes remediation. For example, SSM document.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::RemediationTargetType>,
        ) -> Self {
            self.target_type = input;
            self
        }
        /// <p>Target ID is the name of the public document.</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>Target ID is the name of the public document.</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p>Version of the target. For example, version of the SSM document.</p>
        /// <note>
        /// <p>If you make backward incompatible changes to the SSM document,
        /// you must call PutRemediationConfiguration API again to ensure the remediations can run.</p>
        /// </note>
        pub fn target_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_version = Some(input.into());
            self
        }
        /// <p>Version of the target. For example, version of the SSM document.</p>
        /// <note>
        /// <p>If you make backward incompatible changes to the SSM document,
        /// you must call PutRemediationConfiguration API again to ensure the remediations can run.</p>
        /// </note>
        pub fn set_target_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_version = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>An object of the RemediationParameterValue.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::RemediationParameterValue>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>An object of the RemediationParameterValue.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::RemediationParameterValue,
                >,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The type of a resource. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of a resource. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The remediation is triggered automatically.</p>
        pub fn automatic(mut self, input: bool) -> Self {
            self.automatic = Some(input);
            self
        }
        /// <p>The remediation is triggered automatically.</p>
        pub fn set_automatic(mut self, input: std::option::Option<bool>) -> Self {
            self.automatic = input;
            self
        }
        /// <p>An ExecutionControls object.</p>
        pub fn execution_controls(mut self, input: crate::model::ExecutionControls) -> Self {
            self.execution_controls = Some(input);
            self
        }
        /// <p>An ExecutionControls object.</p>
        pub fn set_execution_controls(
            mut self,
            input: std::option::Option<crate::model::ExecutionControls>,
        ) -> Self {
            self.execution_controls = input;
            self
        }
        /// <p>The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.</p>
        /// <p>For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds,
        ///
        /// Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.</p>
        pub fn maximum_automatic_attempts(mut self, input: i32) -> Self {
            self.maximum_automatic_attempts = Some(input);
            self
        }
        /// <p>The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.</p>
        /// <p>For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds,
        ///
        /// Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.</p>
        pub fn set_maximum_automatic_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_automatic_attempts = input;
            self
        }
        /// <p>Maximum time in seconds that Config runs auto-remediation. If you do not select a number, the default is 60 seconds. </p>
        /// <p>For example, if you specify RetryAttemptSeconds as 50 seconds and MaximumAutomaticAttempts as 5,
        /// Config will run auto-remediations 5 times within 50 seconds before throwing an exception.</p>
        pub fn retry_attempt_seconds(mut self, input: i64) -> Self {
            self.retry_attempt_seconds = Some(input);
            self
        }
        /// <p>Maximum time in seconds that Config runs auto-remediation. If you do not select a number, the default is 60 seconds. </p>
        /// <p>For example, if you specify RetryAttemptSeconds as 50 seconds and MaximumAutomaticAttempts as 5,
        /// Config will run auto-remediations 5 times within 50 seconds before throwing an exception.</p>
        pub fn set_retry_attempt_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.retry_attempt_seconds = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of remediation configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of remediation configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Name of the service that owns the service linked rule, if applicable.</p>
        pub fn created_by_service(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_service = Some(input.into());
            self
        }
        /// <p>Name of the service that owns the service linked rule, if applicable.</p>
        pub fn set_created_by_service(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_service = input;
            self
        }
        /// Consumes the builder and constructs a [`RemediationConfiguration`](crate::model::RemediationConfiguration)
        pub fn build(self) -> crate::model::RemediationConfiguration {
            crate::model::RemediationConfiguration {
                config_rule_name: self.config_rule_name,
                target_type: self.target_type,
                target_id: self.target_id,
                target_version: self.target_version,
                parameters: self.parameters,
                resource_type: self.resource_type,
                automatic: self.automatic.unwrap_or_default(),
                execution_controls: self.execution_controls,
                maximum_automatic_attempts: self.maximum_automatic_attempts,
                retry_attempt_seconds: self.retry_attempt_seconds,
                arn: self.arn,
                created_by_service: self.created_by_service,
            }
        }
    }
}
impl RemediationConfiguration {
    /// Creates a new builder-style object to manufacture [`RemediationConfiguration`](crate::model::RemediationConfiguration)
    pub fn builder() -> crate::model::remediation_configuration::Builder {
        crate::model::remediation_configuration::Builder::default()
    }
}

/// <p>The controls that Config uses for executing remediations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionControls {
    /// <p>A SsmControls object.</p>
    pub ssm_controls: std::option::Option<crate::model::SsmControls>,
}
impl ExecutionControls {
    /// <p>A SsmControls object.</p>
    pub fn ssm_controls(&self) -> std::option::Option<&crate::model::SsmControls> {
        self.ssm_controls.as_ref()
    }
}
impl std::fmt::Debug for ExecutionControls {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionControls");
        formatter.field("ssm_controls", &self.ssm_controls);
        formatter.finish()
    }
}
/// See [`ExecutionControls`](crate::model::ExecutionControls)
pub mod execution_controls {
    /// A builder for [`ExecutionControls`](crate::model::ExecutionControls)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ssm_controls: std::option::Option<crate::model::SsmControls>,
    }
    impl Builder {
        /// <p>A SsmControls object.</p>
        pub fn ssm_controls(mut self, input: crate::model::SsmControls) -> Self {
            self.ssm_controls = Some(input);
            self
        }
        /// <p>A SsmControls object.</p>
        pub fn set_ssm_controls(
            mut self,
            input: std::option::Option<crate::model::SsmControls>,
        ) -> Self {
            self.ssm_controls = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionControls`](crate::model::ExecutionControls)
        pub fn build(self) -> crate::model::ExecutionControls {
            crate::model::ExecutionControls {
                ssm_controls: self.ssm_controls,
            }
        }
    }
}
impl ExecutionControls {
    /// Creates a new builder-style object to manufacture [`ExecutionControls`](crate::model::ExecutionControls)
    pub fn builder() -> crate::model::execution_controls::Builder {
        crate::model::execution_controls::Builder::default()
    }
}

/// <p>Amazon Web Services Systems Manager (SSM) specific remediation controls.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SsmControls {
    /// <p>The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. You can specify a percentage, such as 10%. The default value is 10. </p>
    pub concurrent_execution_rate_percentage: std::option::Option<i32>,
    /// <p>The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule.
    /// You can specify a percentage of errors, for example 10%. If you do not specifiy a percentage, the default is 50%.
    /// For example, if you set the ErrorPercentage to 40% for 10 non-compliant resources, then SSM stops running the automations when the fifth error is received. </p>
    pub error_percentage: std::option::Option<i32>,
}
impl SsmControls {
    /// <p>The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. You can specify a percentage, such as 10%. The default value is 10. </p>
    pub fn concurrent_execution_rate_percentage(&self) -> std::option::Option<i32> {
        self.concurrent_execution_rate_percentage
    }
    /// <p>The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule.
    /// You can specify a percentage of errors, for example 10%. If you do not specifiy a percentage, the default is 50%.
    /// For example, if you set the ErrorPercentage to 40% for 10 non-compliant resources, then SSM stops running the automations when the fifth error is received. </p>
    pub fn error_percentage(&self) -> std::option::Option<i32> {
        self.error_percentage
    }
}
impl std::fmt::Debug for SsmControls {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SsmControls");
        formatter.field(
            "concurrent_execution_rate_percentage",
            &self.concurrent_execution_rate_percentage,
        );
        formatter.field("error_percentage", &self.error_percentage);
        formatter.finish()
    }
}
/// See [`SsmControls`](crate::model::SsmControls)
pub mod ssm_controls {
    /// A builder for [`SsmControls`](crate::model::SsmControls)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) concurrent_execution_rate_percentage: std::option::Option<i32>,
        pub(crate) error_percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. You can specify a percentage, such as 10%. The default value is 10. </p>
        pub fn concurrent_execution_rate_percentage(mut self, input: i32) -> Self {
            self.concurrent_execution_rate_percentage = Some(input);
            self
        }
        /// <p>The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. You can specify a percentage, such as 10%. The default value is 10. </p>
        pub fn set_concurrent_execution_rate_percentage(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.concurrent_execution_rate_percentage = input;
            self
        }
        /// <p>The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule.
        /// You can specify a percentage of errors, for example 10%. If you do not specifiy a percentage, the default is 50%.
        /// For example, if you set the ErrorPercentage to 40% for 10 non-compliant resources, then SSM stops running the automations when the fifth error is received. </p>
        pub fn error_percentage(mut self, input: i32) -> Self {
            self.error_percentage = Some(input);
            self
        }
        /// <p>The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule.
        /// You can specify a percentage of errors, for example 10%. If you do not specifiy a percentage, the default is 50%.
        /// For example, if you set the ErrorPercentage to 40% for 10 non-compliant resources, then SSM stops running the automations when the fifth error is received. </p>
        pub fn set_error_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.error_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`SsmControls`](crate::model::SsmControls)
        pub fn build(self) -> crate::model::SsmControls {
            crate::model::SsmControls {
                concurrent_execution_rate_percentage: self.concurrent_execution_rate_percentage,
                error_percentage: self.error_percentage,
            }
        }
    }
}
impl SsmControls {
    /// Creates a new builder-style object to manufacture [`SsmControls`](crate::model::SsmControls)
    pub fn builder() -> crate::model::ssm_controls::Builder {
        crate::model::ssm_controls::Builder::default()
    }
}

/// <p>The value is either a dynamic (resource) value or a static value. You must select either a dynamic value or a static value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemediationParameterValue {
    /// <p>The value is dynamic and changes at run-time.</p>
    pub resource_value: std::option::Option<crate::model::ResourceValue>,
    /// <p>The value is static and does not change at run-time.</p>
    pub static_value: std::option::Option<crate::model::StaticValue>,
}
impl RemediationParameterValue {
    /// <p>The value is dynamic and changes at run-time.</p>
    pub fn resource_value(&self) -> std::option::Option<&crate::model::ResourceValue> {
        self.resource_value.as_ref()
    }
    /// <p>The value is static and does not change at run-time.</p>
    pub fn static_value(&self) -> std::option::Option<&crate::model::StaticValue> {
        self.static_value.as_ref()
    }
}
impl std::fmt::Debug for RemediationParameterValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemediationParameterValue");
        formatter.field("resource_value", &self.resource_value);
        formatter.field("static_value", &self.static_value);
        formatter.finish()
    }
}
/// See [`RemediationParameterValue`](crate::model::RemediationParameterValue)
pub mod remediation_parameter_value {
    /// A builder for [`RemediationParameterValue`](crate::model::RemediationParameterValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_value: std::option::Option<crate::model::ResourceValue>,
        pub(crate) static_value: std::option::Option<crate::model::StaticValue>,
    }
    impl Builder {
        /// <p>The value is dynamic and changes at run-time.</p>
        pub fn resource_value(mut self, input: crate::model::ResourceValue) -> Self {
            self.resource_value = Some(input);
            self
        }
        /// <p>The value is dynamic and changes at run-time.</p>
        pub fn set_resource_value(
            mut self,
            input: std::option::Option<crate::model::ResourceValue>,
        ) -> Self {
            self.resource_value = input;
            self
        }
        /// <p>The value is static and does not change at run-time.</p>
        pub fn static_value(mut self, input: crate::model::StaticValue) -> Self {
            self.static_value = Some(input);
            self
        }
        /// <p>The value is static and does not change at run-time.</p>
        pub fn set_static_value(
            mut self,
            input: std::option::Option<crate::model::StaticValue>,
        ) -> Self {
            self.static_value = input;
            self
        }
        /// Consumes the builder and constructs a [`RemediationParameterValue`](crate::model::RemediationParameterValue)
        pub fn build(self) -> crate::model::RemediationParameterValue {
            crate::model::RemediationParameterValue {
                resource_value: self.resource_value,
                static_value: self.static_value,
            }
        }
    }
}
impl RemediationParameterValue {
    /// Creates a new builder-style object to manufacture [`RemediationParameterValue`](crate::model::RemediationParameterValue)
    pub fn builder() -> crate::model::remediation_parameter_value::Builder {
        crate::model::remediation_parameter_value::Builder::default()
    }
}

/// <p>The static value of the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StaticValue {
    /// <p>A list of values. For example, the ARN of the assumed role. </p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl StaticValue {
    /// <p>A list of values. For example, the ARN of the assumed role. </p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for StaticValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StaticValue");
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`StaticValue`](crate::model::StaticValue)
pub mod static_value {
    /// A builder for [`StaticValue`](crate::model::StaticValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of values. For example, the ARN of the assumed role. </p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of values. For example, the ARN of the assumed role. </p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`StaticValue`](crate::model::StaticValue)
        pub fn build(self) -> crate::model::StaticValue {
            crate::model::StaticValue {
                values: self.values,
            }
        }
    }
}
impl StaticValue {
    /// Creates a new builder-style object to manufacture [`StaticValue`](crate::model::StaticValue)
    pub fn builder() -> crate::model::static_value::Builder {
        crate::model::static_value::Builder::default()
    }
}

/// <p>The dynamic value of the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceValue {
    /// <p>The value is a resource ID.</p>
    pub value: std::option::Option<crate::model::ResourceValueType>,
}
impl ResourceValue {
    /// <p>The value is a resource ID.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::ResourceValueType> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for ResourceValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceValue");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ResourceValue`](crate::model::ResourceValue)
pub mod resource_value {
    /// A builder for [`ResourceValue`](crate::model::ResourceValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<crate::model::ResourceValueType>,
    }
    impl Builder {
        /// <p>The value is a resource ID.</p>
        pub fn value(mut self, input: crate::model::ResourceValueType) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value is a resource ID.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::ResourceValueType>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceValue`](crate::model::ResourceValue)
        pub fn build(self) -> crate::model::ResourceValue {
            crate::model::ResourceValue { value: self.value }
        }
    }
}
impl ResourceValue {
    /// Creates a new builder-style object to manufacture [`ResourceValue`](crate::model::ResourceValue)
    pub fn builder() -> crate::model::resource_value::Builder {
        crate::model::resource_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceValueType {
    #[allow(missing_docs)] // documentation missing in model
    ResourceId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceValueType {
    fn from(s: &str) -> Self {
        match s {
            "RESOURCE_ID" => ResourceValueType::ResourceId,
            other => ResourceValueType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceValueType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceValueType::from(s))
    }
}
impl ResourceValueType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceValueType::ResourceId => "RESOURCE_ID",
            ResourceValueType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RESOURCE_ID"]
    }
}
impl AsRef<str> for ResourceValueType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RemediationTargetType {
    #[allow(missing_docs)] // documentation missing in model
    SsmDocument,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RemediationTargetType {
    fn from(s: &str) -> Self {
        match s {
            "SSM_DOCUMENT" => RemediationTargetType::SsmDocument,
            other => RemediationTargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RemediationTargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RemediationTargetType::from(s))
    }
}
impl RemediationTargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RemediationTargetType::SsmDocument => "SSM_DOCUMENT",
            RemediationTargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SSM_DOCUMENT"]
    }
}
impl AsRef<str> for RemediationTargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Input parameters in the form of key-value pairs for the conformance pack, both of which you define.
/// Keys can have a maximum character length of 255 characters, and values can have a maximum length of 4096 characters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConformancePackInputParameter {
    /// <p>One part of a key-value pair.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>Another part of the key-value pair. </p>
    pub parameter_value: std::option::Option<std::string::String>,
}
impl ConformancePackInputParameter {
    /// <p>One part of a key-value pair.</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>Another part of the key-value pair. </p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
}
impl std::fmt::Debug for ConformancePackInputParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConformancePackInputParameter");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.finish()
    }
}
/// See [`ConformancePackInputParameter`](crate::model::ConformancePackInputParameter)
pub mod conformance_pack_input_parameter {
    /// A builder for [`ConformancePackInputParameter`](crate::model::ConformancePackInputParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One part of a key-value pair.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>Another part of the key-value pair. </p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>Another part of the key-value pair. </p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ConformancePackInputParameter`](crate::model::ConformancePackInputParameter)
        pub fn build(self) -> crate::model::ConformancePackInputParameter {
            crate::model::ConformancePackInputParameter {
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
            }
        }
    }
}
impl ConformancePackInputParameter {
    /// Creates a new builder-style object to manufacture [`ConformancePackInputParameter`](crate::model::ConformancePackInputParameter)
    pub fn builder() -> crate::model::conformance_pack_input_parameter::Builder {
        crate::model::conformance_pack_input_parameter::Builder::default()
    }
}

/// <p>An object that specifies organization custom rule metadata such as resource type, resource ID of Amazon Web Services resource, Lambda function ARN,
/// and organization trigger types that trigger Config to evaluate your Amazon Web Services resources against a rule.
/// It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationCustomRuleMetadata {
    /// <p>The description that you provide for organization config rule.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The lambda function ARN.</p>
    pub lambda_function_arn: std::option::Option<std::string::String>,
    /// <p>The type of notification that triggers Config to run an evaluation for a rule. You can specify the following notification types:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item.
    /// Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code>.</p>
    /// </li>
    /// </ul>
    pub organization_config_rule_trigger_types:
        std::option::Option<std::vec::Vec<crate::model::OrganizationConfigRuleTriggerType>>,
    /// <p>A string, in JSON format, that is passed to organization config rule Lambda function.</p>
    pub input_parameters: std::option::Option<std::string::String>,
    /// <p>The maximum frequency with which Config runs evaluations for a rule.
    /// Your custom rule is triggered when Config delivers the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p>
    /// <note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
    /// value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub maximum_execution_frequency: std::option::Option<crate::model::MaximumExecutionFrequency>,
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub resource_types_scope: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub resource_id_scope: std::option::Option<std::string::String>,
    /// <p>One part of a key-value pair that make up a tag.
    /// A key is a general label that acts like a category for more specific tag values. </p>
    pub tag_key_scope: std::option::Option<std::string::String>,
    /// <p>The optional part of a key-value pair that make up a tag.
    /// A value acts as a descriptor within a tag category (key). </p>
    pub tag_value_scope: std::option::Option<std::string::String>,
}
impl OrganizationCustomRuleMetadata {
    /// <p>The description that you provide for organization config rule.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The lambda function ARN.</p>
    pub fn lambda_function_arn(&self) -> std::option::Option<&str> {
        self.lambda_function_arn.as_deref()
    }
    /// <p>The type of notification that triggers Config to run an evaluation for a rule. You can specify the following notification types:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item.
    /// Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code>.</p>
    /// </li>
    /// </ul>
    pub fn organization_config_rule_trigger_types(
        &self,
    ) -> std::option::Option<&[crate::model::OrganizationConfigRuleTriggerType]> {
        self.organization_config_rule_trigger_types.as_deref()
    }
    /// <p>A string, in JSON format, that is passed to organization config rule Lambda function.</p>
    pub fn input_parameters(&self) -> std::option::Option<&str> {
        self.input_parameters.as_deref()
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule.
    /// Your custom rule is triggered when Config delivers the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p>
    /// <note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
    /// value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub fn maximum_execution_frequency(
        &self,
    ) -> std::option::Option<&crate::model::MaximumExecutionFrequency> {
        self.maximum_execution_frequency.as_ref()
    }
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_types_scope(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_types_scope.as_deref()
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_id_scope(&self) -> std::option::Option<&str> {
        self.resource_id_scope.as_deref()
    }
    /// <p>One part of a key-value pair that make up a tag.
    /// A key is a general label that acts like a category for more specific tag values. </p>
    pub fn tag_key_scope(&self) -> std::option::Option<&str> {
        self.tag_key_scope.as_deref()
    }
    /// <p>The optional part of a key-value pair that make up a tag.
    /// A value acts as a descriptor within a tag category (key). </p>
    pub fn tag_value_scope(&self) -> std::option::Option<&str> {
        self.tag_value_scope.as_deref()
    }
}
impl std::fmt::Debug for OrganizationCustomRuleMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationCustomRuleMetadata");
        formatter.field("description", &self.description);
        formatter.field("lambda_function_arn", &self.lambda_function_arn);
        formatter.field(
            "organization_config_rule_trigger_types",
            &self.organization_config_rule_trigger_types,
        );
        formatter.field("input_parameters", &self.input_parameters);
        formatter.field(
            "maximum_execution_frequency",
            &self.maximum_execution_frequency,
        );
        formatter.field("resource_types_scope", &self.resource_types_scope);
        formatter.field("resource_id_scope", &self.resource_id_scope);
        formatter.field("tag_key_scope", &self.tag_key_scope);
        formatter.field("tag_value_scope", &self.tag_value_scope);
        formatter.finish()
    }
}
/// See [`OrganizationCustomRuleMetadata`](crate::model::OrganizationCustomRuleMetadata)
pub mod organization_custom_rule_metadata {
    /// A builder for [`OrganizationCustomRuleMetadata`](crate::model::OrganizationCustomRuleMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) lambda_function_arn: std::option::Option<std::string::String>,
        pub(crate) organization_config_rule_trigger_types:
            std::option::Option<std::vec::Vec<crate::model::OrganizationConfigRuleTriggerType>>,
        pub(crate) input_parameters: std::option::Option<std::string::String>,
        pub(crate) maximum_execution_frequency:
            std::option::Option<crate::model::MaximumExecutionFrequency>,
        pub(crate) resource_types_scope: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_id_scope: std::option::Option<std::string::String>,
        pub(crate) tag_key_scope: std::option::Option<std::string::String>,
        pub(crate) tag_value_scope: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The description that you provide for organization config rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description that you provide for organization config rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The lambda function ARN.</p>
        pub fn lambda_function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_function_arn = Some(input.into());
            self
        }
        /// <p>The lambda function ARN.</p>
        pub fn set_lambda_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lambda_function_arn = input;
            self
        }
        /// Appends an item to `organization_config_rule_trigger_types`.
        ///
        /// To override the contents of this collection use [`set_organization_config_rule_trigger_types`](Self::set_organization_config_rule_trigger_types).
        ///
        /// <p>The type of notification that triggers Config to run an evaluation for a rule. You can specify the following notification types:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item.
        /// Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code>.</p>
        /// </li>
        /// </ul>
        pub fn organization_config_rule_trigger_types(
            mut self,
            input: impl Into<crate::model::OrganizationConfigRuleTriggerType>,
        ) -> Self {
            let mut v = self
                .organization_config_rule_trigger_types
                .unwrap_or_default();
            v.push(input.into());
            self.organization_config_rule_trigger_types = Some(v);
            self
        }
        /// <p>The type of notification that triggers Config to run an evaluation for a rule. You can specify the following notification types:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item.
        /// Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_organization_config_rule_trigger_types(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::OrganizationConfigRuleTriggerType>,
            >,
        ) -> Self {
            self.organization_config_rule_trigger_types = input;
            self
        }
        /// <p>A string, in JSON format, that is passed to organization config rule Lambda function.</p>
        pub fn input_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_parameters = Some(input.into());
            self
        }
        /// <p>A string, in JSON format, that is passed to organization config rule Lambda function.</p>
        pub fn set_input_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_parameters = input;
            self
        }
        /// <p>The maximum frequency with which Config runs evaluations for a rule.
        /// Your custom rule is triggered when Config delivers the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p>
        /// <note>
        /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
        /// value for the <code>MaximumExecutionFrequency</code> parameter.</p>
        /// </note>
        pub fn maximum_execution_frequency(
            mut self,
            input: crate::model::MaximumExecutionFrequency,
        ) -> Self {
            self.maximum_execution_frequency = Some(input);
            self
        }
        /// <p>The maximum frequency with which Config runs evaluations for a rule.
        /// Your custom rule is triggered when Config delivers the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p>
        /// <note>
        /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
        /// value for the <code>MaximumExecutionFrequency</code> parameter.</p>
        /// </note>
        pub fn set_maximum_execution_frequency(
            mut self,
            input: std::option::Option<crate::model::MaximumExecutionFrequency>,
        ) -> Self {
            self.maximum_execution_frequency = input;
            self
        }
        /// Appends an item to `resource_types_scope`.
        ///
        /// To override the contents of this collection use [`set_resource_types_scope`](Self::set_resource_types_scope).
        ///
        /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
        pub fn resource_types_scope(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_types_scope.unwrap_or_default();
            v.push(input.into());
            self.resource_types_scope = Some(v);
            self
        }
        /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
        pub fn set_resource_types_scope(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_types_scope = input;
            self
        }
        /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
        pub fn resource_id_scope(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id_scope = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
        pub fn set_resource_id_scope(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_id_scope = input;
            self
        }
        /// <p>One part of a key-value pair that make up a tag.
        /// A key is a general label that acts like a category for more specific tag values. </p>
        pub fn tag_key_scope(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key_scope = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that make up a tag.
        /// A key is a general label that acts like a category for more specific tag values. </p>
        pub fn set_tag_key_scope(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tag_key_scope = input;
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag.
        /// A value acts as a descriptor within a tag category (key). </p>
        pub fn tag_value_scope(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_value_scope = Some(input.into());
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag.
        /// A value acts as a descriptor within a tag category (key). </p>
        pub fn set_tag_value_scope(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tag_value_scope = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationCustomRuleMetadata`](crate::model::OrganizationCustomRuleMetadata)
        pub fn build(self) -> crate::model::OrganizationCustomRuleMetadata {
            crate::model::OrganizationCustomRuleMetadata {
                description: self.description,
                lambda_function_arn: self.lambda_function_arn,
                organization_config_rule_trigger_types: self.organization_config_rule_trigger_types,
                input_parameters: self.input_parameters,
                maximum_execution_frequency: self.maximum_execution_frequency,
                resource_types_scope: self.resource_types_scope,
                resource_id_scope: self.resource_id_scope,
                tag_key_scope: self.tag_key_scope,
                tag_value_scope: self.tag_value_scope,
            }
        }
    }
}
impl OrganizationCustomRuleMetadata {
    /// Creates a new builder-style object to manufacture [`OrganizationCustomRuleMetadata`](crate::model::OrganizationCustomRuleMetadata)
    pub fn builder() -> crate::model::organization_custom_rule_metadata::Builder {
        crate::model::organization_custom_rule_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MaximumExecutionFrequency {
    #[allow(missing_docs)] // documentation missing in model
    OneHour,
    #[allow(missing_docs)] // documentation missing in model
    SixHours,
    #[allow(missing_docs)] // documentation missing in model
    ThreeHours,
    #[allow(missing_docs)] // documentation missing in model
    TwelveHours,
    #[allow(missing_docs)] // documentation missing in model
    TwentyFourHours,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MaximumExecutionFrequency {
    fn from(s: &str) -> Self {
        match s {
            "One_Hour" => MaximumExecutionFrequency::OneHour,
            "Six_Hours" => MaximumExecutionFrequency::SixHours,
            "Three_Hours" => MaximumExecutionFrequency::ThreeHours,
            "Twelve_Hours" => MaximumExecutionFrequency::TwelveHours,
            "TwentyFour_Hours" => MaximumExecutionFrequency::TwentyFourHours,
            other => MaximumExecutionFrequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MaximumExecutionFrequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MaximumExecutionFrequency::from(s))
    }
}
impl MaximumExecutionFrequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MaximumExecutionFrequency::OneHour => "One_Hour",
            MaximumExecutionFrequency::SixHours => "Six_Hours",
            MaximumExecutionFrequency::ThreeHours => "Three_Hours",
            MaximumExecutionFrequency::TwelveHours => "Twelve_Hours",
            MaximumExecutionFrequency::TwentyFourHours => "TwentyFour_Hours",
            MaximumExecutionFrequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "One_Hour",
            "Six_Hours",
            "Three_Hours",
            "Twelve_Hours",
            "TwentyFour_Hours",
        ]
    }
}
impl AsRef<str> for MaximumExecutionFrequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrganizationConfigRuleTriggerType {
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationItemChangeNotification,
    #[allow(missing_docs)] // documentation missing in model
    OversizedConfigurationItemChangeNotifcation,
    #[allow(missing_docs)] // documentation missing in model
    ScheduledNotification,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrganizationConfigRuleTriggerType {
    fn from(s: &str) -> Self {
        match s {
            "ConfigurationItemChangeNotification" => {
                OrganizationConfigRuleTriggerType::ConfigurationItemChangeNotification
            }
            "OversizedConfigurationItemChangeNotification" => {
                OrganizationConfigRuleTriggerType::OversizedConfigurationItemChangeNotifcation
            }
            "ScheduledNotification" => OrganizationConfigRuleTriggerType::ScheduledNotification,
            other => OrganizationConfigRuleTriggerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrganizationConfigRuleTriggerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrganizationConfigRuleTriggerType::from(s))
    }
}
impl OrganizationConfigRuleTriggerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrganizationConfigRuleTriggerType::ConfigurationItemChangeNotification => {
                "ConfigurationItemChangeNotification"
            }
            OrganizationConfigRuleTriggerType::OversizedConfigurationItemChangeNotifcation => {
                "OversizedConfigurationItemChangeNotification"
            }
            OrganizationConfigRuleTriggerType::ScheduledNotification => "ScheduledNotification",
            OrganizationConfigRuleTriggerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ConfigurationItemChangeNotification",
            "OversizedConfigurationItemChangeNotification",
            "ScheduledNotification",
        ]
    }
}
impl AsRef<str> for OrganizationConfigRuleTriggerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that specifies organization managed rule metadata such as resource type and ID of Amazon Web Services resource along with the rule identifier.
/// It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationManagedRuleMetadata {
    /// <p>The description that you provide for organization config rule.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>For organization config managed rules, a predefined identifier from a
    /// list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed
    /// rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
    pub rule_identifier: std::option::Option<std::string::String>,
    /// <p>A string, in JSON format, that is passed to organization config rule Lambda function.</p>
    pub input_parameters: std::option::Option<std::string::String>,
    /// <p>The maximum frequency with which Config runs evaluations for a rule. You are using an Config managed rule that is triggered at a periodic frequency.</p>
    /// <note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
    /// value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub maximum_execution_frequency: std::option::Option<crate::model::MaximumExecutionFrequency>,
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub resource_types_scope: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub resource_id_scope: std::option::Option<std::string::String>,
    /// <p>One part of a key-value pair that make up a tag.
    /// A key is a general label that acts like a category for more specific tag values. </p>
    pub tag_key_scope: std::option::Option<std::string::String>,
    /// <p>The optional part of a key-value pair that make up a tag.
    /// A value acts as a descriptor within a tag category (key).</p>
    pub tag_value_scope: std::option::Option<std::string::String>,
}
impl OrganizationManagedRuleMetadata {
    /// <p>The description that you provide for organization config rule.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>For organization config managed rules, a predefined identifier from a
    /// list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed
    /// rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
    pub fn rule_identifier(&self) -> std::option::Option<&str> {
        self.rule_identifier.as_deref()
    }
    /// <p>A string, in JSON format, that is passed to organization config rule Lambda function.</p>
    pub fn input_parameters(&self) -> std::option::Option<&str> {
        self.input_parameters.as_deref()
    }
    /// <p>The maximum frequency with which Config runs evaluations for a rule. You are using an Config managed rule that is triggered at a periodic frequency.</p>
    /// <note>
    /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
    /// value for the <code>MaximumExecutionFrequency</code> parameter.</p>
    /// </note>
    pub fn maximum_execution_frequency(
        &self,
    ) -> std::option::Option<&crate::model::MaximumExecutionFrequency> {
        self.maximum_execution_frequency.as_ref()
    }
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_types_scope(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_types_scope.as_deref()
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_id_scope(&self) -> std::option::Option<&str> {
        self.resource_id_scope.as_deref()
    }
    /// <p>One part of a key-value pair that make up a tag.
    /// A key is a general label that acts like a category for more specific tag values. </p>
    pub fn tag_key_scope(&self) -> std::option::Option<&str> {
        self.tag_key_scope.as_deref()
    }
    /// <p>The optional part of a key-value pair that make up a tag.
    /// A value acts as a descriptor within a tag category (key).</p>
    pub fn tag_value_scope(&self) -> std::option::Option<&str> {
        self.tag_value_scope.as_deref()
    }
}
impl std::fmt::Debug for OrganizationManagedRuleMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationManagedRuleMetadata");
        formatter.field("description", &self.description);
        formatter.field("rule_identifier", &self.rule_identifier);
        formatter.field("input_parameters", &self.input_parameters);
        formatter.field(
            "maximum_execution_frequency",
            &self.maximum_execution_frequency,
        );
        formatter.field("resource_types_scope", &self.resource_types_scope);
        formatter.field("resource_id_scope", &self.resource_id_scope);
        formatter.field("tag_key_scope", &self.tag_key_scope);
        formatter.field("tag_value_scope", &self.tag_value_scope);
        formatter.finish()
    }
}
/// See [`OrganizationManagedRuleMetadata`](crate::model::OrganizationManagedRuleMetadata)
pub mod organization_managed_rule_metadata {
    /// A builder for [`OrganizationManagedRuleMetadata`](crate::model::OrganizationManagedRuleMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) rule_identifier: std::option::Option<std::string::String>,
        pub(crate) input_parameters: std::option::Option<std::string::String>,
        pub(crate) maximum_execution_frequency:
            std::option::Option<crate::model::MaximumExecutionFrequency>,
        pub(crate) resource_types_scope: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_id_scope: std::option::Option<std::string::String>,
        pub(crate) tag_key_scope: std::option::Option<std::string::String>,
        pub(crate) tag_value_scope: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The description that you provide for organization config rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description that you provide for organization config rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>For organization config managed rules, a predefined identifier from a
        /// list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed
        /// rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
        pub fn rule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_identifier = Some(input.into());
            self
        }
        /// <p>For organization config managed rules, a predefined identifier from a
        /// list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed
        /// rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
        pub fn set_rule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_identifier = input;
            self
        }
        /// <p>A string, in JSON format, that is passed to organization config rule Lambda function.</p>
        pub fn input_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_parameters = Some(input.into());
            self
        }
        /// <p>A string, in JSON format, that is passed to organization config rule Lambda function.</p>
        pub fn set_input_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_parameters = input;
            self
        }
        /// <p>The maximum frequency with which Config runs evaluations for a rule. You are using an Config managed rule that is triggered at a periodic frequency.</p>
        /// <note>
        /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
        /// value for the <code>MaximumExecutionFrequency</code> parameter.</p>
        /// </note>
        pub fn maximum_execution_frequency(
            mut self,
            input: crate::model::MaximumExecutionFrequency,
        ) -> Self {
            self.maximum_execution_frequency = Some(input);
            self
        }
        /// <p>The maximum frequency with which Config runs evaluations for a rule. You are using an Config managed rule that is triggered at a periodic frequency.</p>
        /// <note>
        /// <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid
        /// value for the <code>MaximumExecutionFrequency</code> parameter.</p>
        /// </note>
        pub fn set_maximum_execution_frequency(
            mut self,
            input: std::option::Option<crate::model::MaximumExecutionFrequency>,
        ) -> Self {
            self.maximum_execution_frequency = input;
            self
        }
        /// Appends an item to `resource_types_scope`.
        ///
        /// To override the contents of this collection use [`set_resource_types_scope`](Self::set_resource_types_scope).
        ///
        /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
        pub fn resource_types_scope(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_types_scope.unwrap_or_default();
            v.push(input.into());
            self.resource_types_scope = Some(v);
            self
        }
        /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
        pub fn set_resource_types_scope(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_types_scope = input;
            self
        }
        /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
        pub fn resource_id_scope(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id_scope = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
        pub fn set_resource_id_scope(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_id_scope = input;
            self
        }
        /// <p>One part of a key-value pair that make up a tag.
        /// A key is a general label that acts like a category for more specific tag values. </p>
        pub fn tag_key_scope(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key_scope = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that make up a tag.
        /// A key is a general label that acts like a category for more specific tag values. </p>
        pub fn set_tag_key_scope(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tag_key_scope = input;
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag.
        /// A value acts as a descriptor within a tag category (key).</p>
        pub fn tag_value_scope(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_value_scope = Some(input.into());
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag.
        /// A value acts as a descriptor within a tag category (key).</p>
        pub fn set_tag_value_scope(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tag_value_scope = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationManagedRuleMetadata`](crate::model::OrganizationManagedRuleMetadata)
        pub fn build(self) -> crate::model::OrganizationManagedRuleMetadata {
            crate::model::OrganizationManagedRuleMetadata {
                description: self.description,
                rule_identifier: self.rule_identifier,
                input_parameters: self.input_parameters,
                maximum_execution_frequency: self.maximum_execution_frequency,
                resource_types_scope: self.resource_types_scope,
                resource_id_scope: self.resource_id_scope,
                tag_key_scope: self.tag_key_scope,
                tag_value_scope: self.tag_value_scope,
            }
        }
    }
}
impl OrganizationManagedRuleMetadata {
    /// Creates a new builder-style object to manufacture [`OrganizationManagedRuleMetadata`](crate::model::OrganizationManagedRuleMetadata)
    pub fn builder() -> crate::model::organization_managed_rule_metadata::Builder {
        crate::model::organization_managed_rule_metadata::Builder::default()
    }
}

/// <p>Identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that it was evaluated against.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExternalEvaluation {
    /// <p>The evaluated compliance resource type. Config accepts <code>AWS::::Account</code> resource type.</p>
    pub compliance_resource_type: std::option::Option<std::string::String>,
    /// <p>The evaluated compliance resource ID. Config accepts only Amazon Web Services account ID.</p>
    pub compliance_resource_id: std::option::Option<std::string::String>,
    /// <p>The compliance of the Amazon Web Services resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and <code>NOT_APPLICABLE</code>.</p>
    pub compliance_type: std::option::Option<crate::model::ComplianceType>,
    /// <p>Supplementary information about the reason of compliance. For example, this task was completed on a specific date.</p>
    pub annotation: std::option::Option<std::string::String>,
    /// <p>The time when the compliance was recorded. </p>
    pub ordering_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl ExternalEvaluation {
    /// <p>The evaluated compliance resource type. Config accepts <code>AWS::::Account</code> resource type.</p>
    pub fn compliance_resource_type(&self) -> std::option::Option<&str> {
        self.compliance_resource_type.as_deref()
    }
    /// <p>The evaluated compliance resource ID. Config accepts only Amazon Web Services account ID.</p>
    pub fn compliance_resource_id(&self) -> std::option::Option<&str> {
        self.compliance_resource_id.as_deref()
    }
    /// <p>The compliance of the Amazon Web Services resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and <code>NOT_APPLICABLE</code>.</p>
    pub fn compliance_type(&self) -> std::option::Option<&crate::model::ComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>Supplementary information about the reason of compliance. For example, this task was completed on a specific date.</p>
    pub fn annotation(&self) -> std::option::Option<&str> {
        self.annotation.as_deref()
    }
    /// <p>The time when the compliance was recorded. </p>
    pub fn ordering_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.ordering_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ExternalEvaluation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExternalEvaluation");
        formatter.field("compliance_resource_type", &self.compliance_resource_type);
        formatter.field("compliance_resource_id", &self.compliance_resource_id);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("annotation", &self.annotation);
        formatter.field("ordering_timestamp", &self.ordering_timestamp);
        formatter.finish()
    }
}
/// See [`ExternalEvaluation`](crate::model::ExternalEvaluation)
pub mod external_evaluation {
    /// A builder for [`ExternalEvaluation`](crate::model::ExternalEvaluation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_resource_type: std::option::Option<std::string::String>,
        pub(crate) compliance_resource_id: std::option::Option<std::string::String>,
        pub(crate) compliance_type: std::option::Option<crate::model::ComplianceType>,
        pub(crate) annotation: std::option::Option<std::string::String>,
        pub(crate) ordering_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The evaluated compliance resource type. Config accepts <code>AWS::::Account</code> resource type.</p>
        pub fn compliance_resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_resource_type = Some(input.into());
            self
        }
        /// <p>The evaluated compliance resource type. Config accepts <code>AWS::::Account</code> resource type.</p>
        pub fn set_compliance_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_resource_type = input;
            self
        }
        /// <p>The evaluated compliance resource ID. Config accepts only Amazon Web Services account ID.</p>
        pub fn compliance_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_resource_id = Some(input.into());
            self
        }
        /// <p>The evaluated compliance resource ID. Config accepts only Amazon Web Services account ID.</p>
        pub fn set_compliance_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_resource_id = input;
            self
        }
        /// <p>The compliance of the Amazon Web Services resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and <code>NOT_APPLICABLE</code>.</p>
        pub fn compliance_type(mut self, input: crate::model::ComplianceType) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>The compliance of the Amazon Web Services resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and <code>NOT_APPLICABLE</code>.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>Supplementary information about the reason of compliance. For example, this task was completed on a specific date.</p>
        pub fn annotation(mut self, input: impl Into<std::string::String>) -> Self {
            self.annotation = Some(input.into());
            self
        }
        /// <p>Supplementary information about the reason of compliance. For example, this task was completed on a specific date.</p>
        pub fn set_annotation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.annotation = input;
            self
        }
        /// <p>The time when the compliance was recorded. </p>
        pub fn ordering_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.ordering_timestamp = Some(input);
            self
        }
        /// <p>The time when the compliance was recorded. </p>
        pub fn set_ordering_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.ordering_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ExternalEvaluation`](crate::model::ExternalEvaluation)
        pub fn build(self) -> crate::model::ExternalEvaluation {
            crate::model::ExternalEvaluation {
                compliance_resource_type: self.compliance_resource_type,
                compliance_resource_id: self.compliance_resource_id,
                compliance_type: self.compliance_type,
                annotation: self.annotation,
                ordering_timestamp: self.ordering_timestamp,
            }
        }
    }
}
impl ExternalEvaluation {
    /// Creates a new builder-style object to manufacture [`ExternalEvaluation`](crate::model::ExternalEvaluation)
    pub fn builder() -> crate::model::external_evaluation::Builder {
        crate::model::external_evaluation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComplianceType {
    #[allow(missing_docs)] // documentation missing in model
    Compliant,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientData,
    #[allow(missing_docs)] // documentation missing in model
    NonCompliant,
    #[allow(missing_docs)] // documentation missing in model
    NotApplicable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComplianceType {
    fn from(s: &str) -> Self {
        match s {
            "COMPLIANT" => ComplianceType::Compliant,
            "INSUFFICIENT_DATA" => ComplianceType::InsufficientData,
            "NON_COMPLIANT" => ComplianceType::NonCompliant,
            "NOT_APPLICABLE" => ComplianceType::NotApplicable,
            other => ComplianceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComplianceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComplianceType::from(s))
    }
}
impl ComplianceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComplianceType::Compliant => "COMPLIANT",
            ComplianceType::InsufficientData => "INSUFFICIENT_DATA",
            ComplianceType::NonCompliant => "NON_COMPLIANT",
            ComplianceType::NotApplicable => "NOT_APPLICABLE",
            ComplianceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLIANT",
            "INSUFFICIENT_DATA",
            "NON_COMPLIANT",
            "NOT_APPLICABLE",
        ]
    }
}
impl AsRef<str> for ComplianceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Identifies an Amazon Web Services resource and indicates whether it complies
/// with the Config rule that it was evaluated against.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Evaluation {
    /// <p>The type of Amazon Web Services resource that was evaluated.</p>
    pub compliance_resource_type: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub compliance_resource_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the Amazon Web Services resource complies with the Config
    /// rule that it was evaluated against.</p>
    /// <p>For the <code>Evaluation</code> data type, Config supports
    /// only the <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
    /// <code>NOT_APPLICABLE</code> values. Config does not support
    /// the <code>INSUFFICIENT_DATA</code> value for this data
    /// type.</p>
    /// <p>Similarly, Config does not accept
    /// <code>INSUFFICIENT_DATA</code> as the value for
    /// <code>ComplianceType</code> from a <code>PutEvaluations</code>
    /// request. For example, an Lambda function for a custom Config
    /// rule cannot pass an <code>INSUFFICIENT_DATA</code> value to Config.</p>
    pub compliance_type: std::option::Option<crate::model::ComplianceType>,
    /// <p>Supplementary information about how the evaluation determined
    /// the compliance.</p>
    pub annotation: std::option::Option<std::string::String>,
    /// <p>The time of the event in Config that triggered the
    /// evaluation. For event-based evaluations, the time indicates when Config created the configuration item that triggered the evaluation.
    /// For periodic evaluations, the time indicates when Config
    /// triggered the evaluation at the frequency that you specified (for
    /// example, every 24 hours).</p>
    pub ordering_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl Evaluation {
    /// <p>The type of Amazon Web Services resource that was evaluated.</p>
    pub fn compliance_resource_type(&self) -> std::option::Option<&str> {
        self.compliance_resource_type.as_deref()
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn compliance_resource_id(&self) -> std::option::Option<&str> {
        self.compliance_resource_id.as_deref()
    }
    /// <p>Indicates whether the Amazon Web Services resource complies with the Config
    /// rule that it was evaluated against.</p>
    /// <p>For the <code>Evaluation</code> data type, Config supports
    /// only the <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
    /// <code>NOT_APPLICABLE</code> values. Config does not support
    /// the <code>INSUFFICIENT_DATA</code> value for this data
    /// type.</p>
    /// <p>Similarly, Config does not accept
    /// <code>INSUFFICIENT_DATA</code> as the value for
    /// <code>ComplianceType</code> from a <code>PutEvaluations</code>
    /// request. For example, an Lambda function for a custom Config
    /// rule cannot pass an <code>INSUFFICIENT_DATA</code> value to Config.</p>
    pub fn compliance_type(&self) -> std::option::Option<&crate::model::ComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>Supplementary information about how the evaluation determined
    /// the compliance.</p>
    pub fn annotation(&self) -> std::option::Option<&str> {
        self.annotation.as_deref()
    }
    /// <p>The time of the event in Config that triggered the
    /// evaluation. For event-based evaluations, the time indicates when Config created the configuration item that triggered the evaluation.
    /// For periodic evaluations, the time indicates when Config
    /// triggered the evaluation at the frequency that you specified (for
    /// example, every 24 hours).</p>
    pub fn ordering_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.ordering_timestamp.as_ref()
    }
}
impl std::fmt::Debug for Evaluation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Evaluation");
        formatter.field("compliance_resource_type", &self.compliance_resource_type);
        formatter.field("compliance_resource_id", &self.compliance_resource_id);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("annotation", &self.annotation);
        formatter.field("ordering_timestamp", &self.ordering_timestamp);
        formatter.finish()
    }
}
/// See [`Evaluation`](crate::model::Evaluation)
pub mod evaluation {
    /// A builder for [`Evaluation`](crate::model::Evaluation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_resource_type: std::option::Option<std::string::String>,
        pub(crate) compliance_resource_id: std::option::Option<std::string::String>,
        pub(crate) compliance_type: std::option::Option<crate::model::ComplianceType>,
        pub(crate) annotation: std::option::Option<std::string::String>,
        pub(crate) ordering_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The type of Amazon Web Services resource that was evaluated.</p>
        pub fn compliance_resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_resource_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services resource that was evaluated.</p>
        pub fn set_compliance_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_resource_type = input;
            self
        }
        /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
        pub fn compliance_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
        pub fn set_compliance_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_resource_id = input;
            self
        }
        /// <p>Indicates whether the Amazon Web Services resource complies with the Config
        /// rule that it was evaluated against.</p>
        /// <p>For the <code>Evaluation</code> data type, Config supports
        /// only the <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
        /// <code>NOT_APPLICABLE</code> values. Config does not support
        /// the <code>INSUFFICIENT_DATA</code> value for this data
        /// type.</p>
        /// <p>Similarly, Config does not accept
        /// <code>INSUFFICIENT_DATA</code> as the value for
        /// <code>ComplianceType</code> from a <code>PutEvaluations</code>
        /// request. For example, an Lambda function for a custom Config
        /// rule cannot pass an <code>INSUFFICIENT_DATA</code> value to Config.</p>
        pub fn compliance_type(mut self, input: crate::model::ComplianceType) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>Indicates whether the Amazon Web Services resource complies with the Config
        /// rule that it was evaluated against.</p>
        /// <p>For the <code>Evaluation</code> data type, Config supports
        /// only the <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
        /// <code>NOT_APPLICABLE</code> values. Config does not support
        /// the <code>INSUFFICIENT_DATA</code> value for this data
        /// type.</p>
        /// <p>Similarly, Config does not accept
        /// <code>INSUFFICIENT_DATA</code> as the value for
        /// <code>ComplianceType</code> from a <code>PutEvaluations</code>
        /// request. For example, an Lambda function for a custom Config
        /// rule cannot pass an <code>INSUFFICIENT_DATA</code> value to Config.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>Supplementary information about how the evaluation determined
        /// the compliance.</p>
        pub fn annotation(mut self, input: impl Into<std::string::String>) -> Self {
            self.annotation = Some(input.into());
            self
        }
        /// <p>Supplementary information about how the evaluation determined
        /// the compliance.</p>
        pub fn set_annotation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.annotation = input;
            self
        }
        /// <p>The time of the event in Config that triggered the
        /// evaluation. For event-based evaluations, the time indicates when Config created the configuration item that triggered the evaluation.
        /// For periodic evaluations, the time indicates when Config
        /// triggered the evaluation at the frequency that you specified (for
        /// example, every 24 hours).</p>
        pub fn ordering_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.ordering_timestamp = Some(input);
            self
        }
        /// <p>The time of the event in Config that triggered the
        /// evaluation. For event-based evaluations, the time indicates when Config created the configuration item that triggered the evaluation.
        /// For periodic evaluations, the time indicates when Config
        /// triggered the evaluation at the frequency that you specified (for
        /// example, every 24 hours).</p>
        pub fn set_ordering_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.ordering_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`Evaluation`](crate::model::Evaluation)
        pub fn build(self) -> crate::model::Evaluation {
            crate::model::Evaluation {
                compliance_resource_type: self.compliance_resource_type,
                compliance_resource_id: self.compliance_resource_id,
                compliance_type: self.compliance_type,
                annotation: self.annotation,
                ordering_timestamp: self.ordering_timestamp,
            }
        }
    }
}
impl Evaluation {
    /// Creates a new builder-style object to manufacture [`Evaluation`](crate::model::Evaluation)
    pub fn builder() -> crate::model::evaluation::Builder {
        crate::model::evaluation::Builder::default()
    }
}

/// <p>The channel through which Config delivers notifications and
/// updated configuration states.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeliveryChannel {
    /// <p>The name of the delivery channel. By default, Config
    /// assigns the name "default" when creating the delivery channel. To
    /// change the delivery channel name, you must use the
    /// DeleteDeliveryChannel action to delete your current delivery
    /// channel, and then you must use the PutDeliveryChannel command to
    /// create a delivery channel that has the desired name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket to which Config delivers
    /// configuration snapshots and configuration history files.</p>
    /// <p>If you specify a bucket that belongs to another Amazon Web Services account,
    /// that bucket must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the Config
    /// Developer Guide.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The prefix for the specified Amazon S3 bucket.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key (KMS key) used to encrypt objects delivered by Config.
    /// Must belong to the same Region as the destination S3 bucket.</p>
    pub s3_kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which
    /// Config sends notifications about configuration
    /// changes.</p>
    /// <p>If you choose a topic from another account, the topic must have
    /// policies that grant access permissions to Config. For more
    /// information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the Config
    /// Developer Guide.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The options for how often Config delivers configuration
    /// snapshots to the Amazon S3 bucket.</p>
    pub config_snapshot_delivery_properties:
        std::option::Option<crate::model::ConfigSnapshotDeliveryProperties>,
}
impl DeliveryChannel {
    /// <p>The name of the delivery channel. By default, Config
    /// assigns the name "default" when creating the delivery channel. To
    /// change the delivery channel name, you must use the
    /// DeleteDeliveryChannel action to delete your current delivery
    /// channel, and then you must use the PutDeliveryChannel command to
    /// create a delivery channel that has the desired name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket to which Config delivers
    /// configuration snapshots and configuration history files.</p>
    /// <p>If you specify a bucket that belongs to another Amazon Web Services account,
    /// that bucket must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the Config
    /// Developer Guide.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>The prefix for the specified Amazon S3 bucket.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key (KMS key) used to encrypt objects delivered by Config.
    /// Must belong to the same Region as the destination S3 bucket.</p>
    pub fn s3_kms_key_arn(&self) -> std::option::Option<&str> {
        self.s3_kms_key_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which
    /// Config sends notifications about configuration
    /// changes.</p>
    /// <p>If you choose a topic from another account, the topic must have
    /// policies that grant access permissions to Config. For more
    /// information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the Config
    /// Developer Guide.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The options for how often Config delivers configuration
    /// snapshots to the Amazon S3 bucket.</p>
    pub fn config_snapshot_delivery_properties(
        &self,
    ) -> std::option::Option<&crate::model::ConfigSnapshotDeliveryProperties> {
        self.config_snapshot_delivery_properties.as_ref()
    }
}
impl std::fmt::Debug for DeliveryChannel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeliveryChannel");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("s3_kms_key_arn", &self.s3_kms_key_arn);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field(
            "config_snapshot_delivery_properties",
            &self.config_snapshot_delivery_properties,
        );
        formatter.finish()
    }
}
/// See [`DeliveryChannel`](crate::model::DeliveryChannel)
pub mod delivery_channel {
    /// A builder for [`DeliveryChannel`](crate::model::DeliveryChannel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) s3_kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) config_snapshot_delivery_properties:
            std::option::Option<crate::model::ConfigSnapshotDeliveryProperties>,
    }
    impl Builder {
        /// <p>The name of the delivery channel. By default, Config
        /// assigns the name "default" when creating the delivery channel. To
        /// change the delivery channel name, you must use the
        /// DeleteDeliveryChannel action to delete your current delivery
        /// channel, and then you must use the PutDeliveryChannel command to
        /// create a delivery channel that has the desired name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the delivery channel. By default, Config
        /// assigns the name "default" when creating the delivery channel. To
        /// change the delivery channel name, you must use the
        /// DeleteDeliveryChannel action to delete your current delivery
        /// channel, and then you must use the PutDeliveryChannel command to
        /// create a delivery channel that has the desired name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket to which Config delivers
        /// configuration snapshots and configuration history files.</p>
        /// <p>If you specify a bucket that belongs to another Amazon Web Services account,
        /// that bucket must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the Config
        /// Developer Guide.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket to which Config delivers
        /// configuration snapshots and configuration history files.</p>
        /// <p>If you specify a bucket that belongs to another Amazon Web Services account,
        /// that bucket must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the Config
        /// Developer Guide.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The prefix for the specified Amazon S3 bucket.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The prefix for the specified Amazon S3 bucket.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key (KMS key) used to encrypt objects delivered by Config.
        /// Must belong to the same Region as the destination S3 bucket.</p>
        pub fn s3_kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key (KMS key) used to encrypt objects delivered by Config.
        /// Must belong to the same Region as the destination S3 bucket.</p>
        pub fn set_s3_kms_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_kms_key_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which
        /// Config sends notifications about configuration
        /// changes.</p>
        /// <p>If you choose a topic from another account, the topic must have
        /// policies that grant access permissions to Config. For more
        /// information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the Config
        /// Developer Guide.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which
        /// Config sends notifications about configuration
        /// changes.</p>
        /// <p>If you choose a topic from another account, the topic must have
        /// policies that grant access permissions to Config. For more
        /// information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the Config
        /// Developer Guide.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The options for how often Config delivers configuration
        /// snapshots to the Amazon S3 bucket.</p>
        pub fn config_snapshot_delivery_properties(
            mut self,
            input: crate::model::ConfigSnapshotDeliveryProperties,
        ) -> Self {
            self.config_snapshot_delivery_properties = Some(input);
            self
        }
        /// <p>The options for how often Config delivers configuration
        /// snapshots to the Amazon S3 bucket.</p>
        pub fn set_config_snapshot_delivery_properties(
            mut self,
            input: std::option::Option<crate::model::ConfigSnapshotDeliveryProperties>,
        ) -> Self {
            self.config_snapshot_delivery_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`DeliveryChannel`](crate::model::DeliveryChannel)
        pub fn build(self) -> crate::model::DeliveryChannel {
            crate::model::DeliveryChannel {
                name: self.name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                s3_kms_key_arn: self.s3_kms_key_arn,
                sns_topic_arn: self.sns_topic_arn,
                config_snapshot_delivery_properties: self.config_snapshot_delivery_properties,
            }
        }
    }
}
impl DeliveryChannel {
    /// Creates a new builder-style object to manufacture [`DeliveryChannel`](crate::model::DeliveryChannel)
    pub fn builder() -> crate::model::delivery_channel::Builder {
        crate::model::delivery_channel::Builder::default()
    }
}

/// <p>Provides options for how often Config delivers
/// configuration snapshots to the Amazon S3 bucket in your delivery
/// channel.</p>
///
///
///
///
/// <p>The frequency for a rule that triggers evaluations for your
/// resources when Config delivers the configuration snapshot is set
/// by one of two values, depending on which is less frequent:</p>
///
/// <ul>
/// <li>
/// <p>The value for the <code>deliveryFrequency</code>
/// parameter within the delivery channel configuration, which
/// sets how often Config delivers configuration snapshots.
/// This value also sets how often Config invokes
/// evaluations for Config rules.</p>
/// </li>
/// <li>
/// <p>The value for the
/// <code>MaximumExecutionFrequency</code> parameter, which
/// sets the maximum frequency with which Config invokes
/// evaluations for the rule. For more information, see <a>ConfigRule</a>.</p>
/// </li>
/// </ul>
///
/// <p>If the <code>deliveryFrequency</code> value is less frequent
/// than the <code>MaximumExecutionFrequency</code> value for a rule,
/// Config invokes the rule only as often as the
/// <code>deliveryFrequency</code> value.</p>
///
/// <ol>
/// <li>
/// <p>For example, you want your rule to run evaluations when
/// Config delivers the configuration snapshot.</p>
/// </li>
/// <li>
/// <p>You specify the <code>MaximumExecutionFrequency</code>
/// value for <code>Six_Hours</code>. </p>
/// </li>
/// <li>
/// <p>You then specify the delivery channel
/// <code>deliveryFrequency</code> value for
/// <code>TwentyFour_Hours</code>.</p>
/// </li>
/// <li>
/// <p>Because the value for <code>deliveryFrequency</code> is
/// less frequent than <code>MaximumExecutionFrequency</code>,
/// Config invokes evaluations for the rule every 24 hours.
/// </p>
/// </li>
/// </ol>
///
///
/// <p>You should set the <code>MaximumExecutionFrequency</code> value
/// to be at least as frequent as the <code>deliveryFrequency</code>
/// value. You can view the <code>deliveryFrequency</code> value by
/// using the <code>DescribeDeliveryChannnels</code> action.</p>
///
/// <p>To update the <code>deliveryFrequency</code> with which Config delivers your configuration snapshots, use the
/// <code>PutDeliveryChannel</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigSnapshotDeliveryProperties {
    /// <p>The frequency with which Config delivers configuration
    /// snapshots.</p>
    pub delivery_frequency: std::option::Option<crate::model::MaximumExecutionFrequency>,
}
impl ConfigSnapshotDeliveryProperties {
    /// <p>The frequency with which Config delivers configuration
    /// snapshots.</p>
    pub fn delivery_frequency(
        &self,
    ) -> std::option::Option<&crate::model::MaximumExecutionFrequency> {
        self.delivery_frequency.as_ref()
    }
}
impl std::fmt::Debug for ConfigSnapshotDeliveryProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigSnapshotDeliveryProperties");
        formatter.field("delivery_frequency", &self.delivery_frequency);
        formatter.finish()
    }
}
/// See [`ConfigSnapshotDeliveryProperties`](crate::model::ConfigSnapshotDeliveryProperties)
pub mod config_snapshot_delivery_properties {
    /// A builder for [`ConfigSnapshotDeliveryProperties`](crate::model::ConfigSnapshotDeliveryProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_frequency: std::option::Option<crate::model::MaximumExecutionFrequency>,
    }
    impl Builder {
        /// <p>The frequency with which Config delivers configuration
        /// snapshots.</p>
        pub fn delivery_frequency(
            mut self,
            input: crate::model::MaximumExecutionFrequency,
        ) -> Self {
            self.delivery_frequency = Some(input);
            self
        }
        /// <p>The frequency with which Config delivers configuration
        /// snapshots.</p>
        pub fn set_delivery_frequency(
            mut self,
            input: std::option::Option<crate::model::MaximumExecutionFrequency>,
        ) -> Self {
            self.delivery_frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigSnapshotDeliveryProperties`](crate::model::ConfigSnapshotDeliveryProperties)
        pub fn build(self) -> crate::model::ConfigSnapshotDeliveryProperties {
            crate::model::ConfigSnapshotDeliveryProperties {
                delivery_frequency: self.delivery_frequency,
            }
        }
    }
}
impl ConfigSnapshotDeliveryProperties {
    /// Creates a new builder-style object to manufacture [`ConfigSnapshotDeliveryProperties`](crate::model::ConfigSnapshotDeliveryProperties)
    pub fn builder() -> crate::model::config_snapshot_delivery_properties::Builder {
        crate::model::config_snapshot_delivery_properties::Builder::default()
    }
}

/// <p>An object that represents the recording of configuration
/// changes of an Amazon Web Services resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationRecorder {
    /// <p>The name of the recorder. By default, Config automatically
    /// assigns the name "default" when creating the configuration recorder.
    /// You cannot change the assigned name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the IAM role used to describe the
    /// Amazon Web Services resources associated with the account.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the types of Amazon Web Services resources for which Config
    /// records configuration changes.</p>
    pub recording_group: std::option::Option<crate::model::RecordingGroup>,
}
impl ConfigurationRecorder {
    /// <p>The name of the recorder. By default, Config automatically
    /// assigns the name "default" when creating the configuration recorder.
    /// You cannot change the assigned name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the IAM role used to describe the
    /// Amazon Web Services resources associated with the account.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Specifies the types of Amazon Web Services resources for which Config
    /// records configuration changes.</p>
    pub fn recording_group(&self) -> std::option::Option<&crate::model::RecordingGroup> {
        self.recording_group.as_ref()
    }
}
impl std::fmt::Debug for ConfigurationRecorder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationRecorder");
        formatter.field("name", &self.name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("recording_group", &self.recording_group);
        formatter.finish()
    }
}
/// See [`ConfigurationRecorder`](crate::model::ConfigurationRecorder)
pub mod configuration_recorder {
    /// A builder for [`ConfigurationRecorder`](crate::model::ConfigurationRecorder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) recording_group: std::option::Option<crate::model::RecordingGroup>,
    }
    impl Builder {
        /// <p>The name of the recorder. By default, Config automatically
        /// assigns the name "default" when creating the configuration recorder.
        /// You cannot change the assigned name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recorder. By default, Config automatically
        /// assigns the name "default" when creating the configuration recorder.
        /// You cannot change the assigned name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the IAM role used to describe the
        /// Amazon Web Services resources associated with the account.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the IAM role used to describe the
        /// Amazon Web Services resources associated with the account.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Specifies the types of Amazon Web Services resources for which Config
        /// records configuration changes.</p>
        pub fn recording_group(mut self, input: crate::model::RecordingGroup) -> Self {
            self.recording_group = Some(input);
            self
        }
        /// <p>Specifies the types of Amazon Web Services resources for which Config
        /// records configuration changes.</p>
        pub fn set_recording_group(
            mut self,
            input: std::option::Option<crate::model::RecordingGroup>,
        ) -> Self {
            self.recording_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationRecorder`](crate::model::ConfigurationRecorder)
        pub fn build(self) -> crate::model::ConfigurationRecorder {
            crate::model::ConfigurationRecorder {
                name: self.name,
                role_arn: self.role_arn,
                recording_group: self.recording_group,
            }
        }
    }
}
impl ConfigurationRecorder {
    /// Creates a new builder-style object to manufacture [`ConfigurationRecorder`](crate::model::ConfigurationRecorder)
    pub fn builder() -> crate::model::configuration_recorder::Builder {
        crate::model::configuration_recorder::Builder::default()
    }
}

/// <p>Specifies the types of Amazon Web Services resource for which Config
/// records configuration changes.</p>
/// <p>In the recording group, you specify whether all supported types
/// or specific types of resources are recorded.</p>
/// <p>By default, Config records configuration changes for all
/// supported types of regional resources that Config discovers in
/// the region in which it is running. Regional resources are tied to a
/// region and can be used only in that region. Examples of regional
/// resources are EC2 instances and EBS volumes.</p>
/// <p>You can also have Config record configuration changes for
/// supported types of global resources (for example, IAM resources).
/// Global resources are not tied to an individual region and can be
/// used in all regions.</p>
/// <important>
/// <p>The configuration details for any global resource are the
/// same in all regions. If you customize Config in multiple
/// regions to record global resources, it will create multiple
/// configuration items each time a global resource changes: one
/// configuration item for each region. These configuration items
/// will contain identical data. To prevent duplicate configuration
/// items, you should consider customizing Config in only one
/// region to record global resources, unless you want the
/// configuration items to be available in multiple
/// regions.</p>
/// </important>
/// <p>If you don't want Config to record all resources, you can
/// specify which types of resources it will record with the
/// <code>resourceTypes</code> parameter.</p>
/// <p>For a list of supported resource types, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Resource Types</a>.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html">Selecting Which Resources Config Records</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordingGroup {
    /// <p>Specifies whether Config records configuration changes for
    /// every supported type of regional resource.</p>
    /// <p>If you set this option to <code>true</code>, when Config
    /// adds support for a new type of regional resource, it starts
    /// recording resources of that type automatically.</p>
    /// <p>If you set this option to <code>true</code>, you cannot
    /// enumerate a list of <code>resourceTypes</code>.</p>
    pub all_supported: bool,
    /// <p>Specifies whether Config includes all supported types of
    /// global resources (for example, IAM resources) with the resources
    /// that it records.</p>
    /// <p>Before you can set this option to <code>true</code>, you must
    /// set the <code>allSupported</code> option to
    /// <code>true</code>.</p>
    /// <p>If you set this option to <code>true</code>, when Config
    /// adds support for a new type of global resource, it starts recording
    /// resources of that type automatically.</p>
    /// <p>The configuration details for any global resource are the same
    /// in all regions. To prevent duplicate configuration items, you should
    /// consider customizing Config in only one region to record global
    /// resources.</p>
    pub include_global_resource_types: bool,
    /// <p>A comma-separated list that specifies the types of Amazon Web Services
    /// resources for which Config records configuration changes (for
    /// example, <code>AWS::EC2::Instance</code> or
    /// <code>AWS::CloudTrail::Trail</code>).</p>
    /// <p>To record all configuration changes, you must
    /// set the <code>allSupported</code> option to
    /// <code>true</code>.</p>
    /// <p>If you set this option to <code>false</code>, when Config
    /// adds support for a new type of resource, it will not record
    /// resources of that type unless you manually add that type to your
    /// recording group.</p>
    /// <p>For a list of valid <code>resourceTypes</code> values, see the
    /// <b>resourceType Value</b> column in
    /// <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Amazon Web Services resource Types</a>.</p>
    pub resource_types: std::option::Option<std::vec::Vec<crate::model::ResourceType>>,
}
impl RecordingGroup {
    /// <p>Specifies whether Config records configuration changes for
    /// every supported type of regional resource.</p>
    /// <p>If you set this option to <code>true</code>, when Config
    /// adds support for a new type of regional resource, it starts
    /// recording resources of that type automatically.</p>
    /// <p>If you set this option to <code>true</code>, you cannot
    /// enumerate a list of <code>resourceTypes</code>.</p>
    pub fn all_supported(&self) -> bool {
        self.all_supported
    }
    /// <p>Specifies whether Config includes all supported types of
    /// global resources (for example, IAM resources) with the resources
    /// that it records.</p>
    /// <p>Before you can set this option to <code>true</code>, you must
    /// set the <code>allSupported</code> option to
    /// <code>true</code>.</p>
    /// <p>If you set this option to <code>true</code>, when Config
    /// adds support for a new type of global resource, it starts recording
    /// resources of that type automatically.</p>
    /// <p>The configuration details for any global resource are the same
    /// in all regions. To prevent duplicate configuration items, you should
    /// consider customizing Config in only one region to record global
    /// resources.</p>
    pub fn include_global_resource_types(&self) -> bool {
        self.include_global_resource_types
    }
    /// <p>A comma-separated list that specifies the types of Amazon Web Services
    /// resources for which Config records configuration changes (for
    /// example, <code>AWS::EC2::Instance</code> or
    /// <code>AWS::CloudTrail::Trail</code>).</p>
    /// <p>To record all configuration changes, you must
    /// set the <code>allSupported</code> option to
    /// <code>true</code>.</p>
    /// <p>If you set this option to <code>false</code>, when Config
    /// adds support for a new type of resource, it will not record
    /// resources of that type unless you manually add that type to your
    /// recording group.</p>
    /// <p>For a list of valid <code>resourceTypes</code> values, see the
    /// <b>resourceType Value</b> column in
    /// <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Amazon Web Services resource Types</a>.</p>
    pub fn resource_types(&self) -> std::option::Option<&[crate::model::ResourceType]> {
        self.resource_types.as_deref()
    }
}
impl std::fmt::Debug for RecordingGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordingGroup");
        formatter.field("all_supported", &self.all_supported);
        formatter.field(
            "include_global_resource_types",
            &self.include_global_resource_types,
        );
        formatter.field("resource_types", &self.resource_types);
        formatter.finish()
    }
}
/// See [`RecordingGroup`](crate::model::RecordingGroup)
pub mod recording_group {
    /// A builder for [`RecordingGroup`](crate::model::RecordingGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) all_supported: std::option::Option<bool>,
        pub(crate) include_global_resource_types: std::option::Option<bool>,
        pub(crate) resource_types: std::option::Option<std::vec::Vec<crate::model::ResourceType>>,
    }
    impl Builder {
        /// <p>Specifies whether Config records configuration changes for
        /// every supported type of regional resource.</p>
        /// <p>If you set this option to <code>true</code>, when Config
        /// adds support for a new type of regional resource, it starts
        /// recording resources of that type automatically.</p>
        /// <p>If you set this option to <code>true</code>, you cannot
        /// enumerate a list of <code>resourceTypes</code>.</p>
        pub fn all_supported(mut self, input: bool) -> Self {
            self.all_supported = Some(input);
            self
        }
        /// <p>Specifies whether Config records configuration changes for
        /// every supported type of regional resource.</p>
        /// <p>If you set this option to <code>true</code>, when Config
        /// adds support for a new type of regional resource, it starts
        /// recording resources of that type automatically.</p>
        /// <p>If you set this option to <code>true</code>, you cannot
        /// enumerate a list of <code>resourceTypes</code>.</p>
        pub fn set_all_supported(mut self, input: std::option::Option<bool>) -> Self {
            self.all_supported = input;
            self
        }
        /// <p>Specifies whether Config includes all supported types of
        /// global resources (for example, IAM resources) with the resources
        /// that it records.</p>
        /// <p>Before you can set this option to <code>true</code>, you must
        /// set the <code>allSupported</code> option to
        /// <code>true</code>.</p>
        /// <p>If you set this option to <code>true</code>, when Config
        /// adds support for a new type of global resource, it starts recording
        /// resources of that type automatically.</p>
        /// <p>The configuration details for any global resource are the same
        /// in all regions. To prevent duplicate configuration items, you should
        /// consider customizing Config in only one region to record global
        /// resources.</p>
        pub fn include_global_resource_types(mut self, input: bool) -> Self {
            self.include_global_resource_types = Some(input);
            self
        }
        /// <p>Specifies whether Config includes all supported types of
        /// global resources (for example, IAM resources) with the resources
        /// that it records.</p>
        /// <p>Before you can set this option to <code>true</code>, you must
        /// set the <code>allSupported</code> option to
        /// <code>true</code>.</p>
        /// <p>If you set this option to <code>true</code>, when Config
        /// adds support for a new type of global resource, it starts recording
        /// resources of that type automatically.</p>
        /// <p>The configuration details for any global resource are the same
        /// in all regions. To prevent duplicate configuration items, you should
        /// consider customizing Config in only one region to record global
        /// resources.</p>
        pub fn set_include_global_resource_types(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_global_resource_types = input;
            self
        }
        /// Appends an item to `resource_types`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>A comma-separated list that specifies the types of Amazon Web Services
        /// resources for which Config records configuration changes (for
        /// example, <code>AWS::EC2::Instance</code> or
        /// <code>AWS::CloudTrail::Trail</code>).</p>
        /// <p>To record all configuration changes, you must
        /// set the <code>allSupported</code> option to
        /// <code>true</code>.</p>
        /// <p>If you set this option to <code>false</code>, when Config
        /// adds support for a new type of resource, it will not record
        /// resources of that type unless you manually add that type to your
        /// recording group.</p>
        /// <p>For a list of valid <code>resourceTypes</code> values, see the
        /// <b>resourceType Value</b> column in
        /// <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Amazon Web Services resource Types</a>.</p>
        pub fn resource_types(mut self, input: impl Into<crate::model::ResourceType>) -> Self {
            let mut v = self.resource_types.unwrap_or_default();
            v.push(input.into());
            self.resource_types = Some(v);
            self
        }
        /// <p>A comma-separated list that specifies the types of Amazon Web Services
        /// resources for which Config records configuration changes (for
        /// example, <code>AWS::EC2::Instance</code> or
        /// <code>AWS::CloudTrail::Trail</code>).</p>
        /// <p>To record all configuration changes, you must
        /// set the <code>allSupported</code> option to
        /// <code>true</code>.</p>
        /// <p>If you set this option to <code>false</code>, when Config
        /// adds support for a new type of resource, it will not record
        /// resources of that type unless you manually add that type to your
        /// recording group.</p>
        /// <p>For a list of valid <code>resourceTypes</code> values, see the
        /// <b>resourceType Value</b> column in
        /// <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Amazon Web Services resource Types</a>.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceType>>,
        ) -> Self {
            self.resource_types = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordingGroup`](crate::model::RecordingGroup)
        pub fn build(self) -> crate::model::RecordingGroup {
            crate::model::RecordingGroup {
                all_supported: self.all_supported.unwrap_or_default(),
                include_global_resource_types: self
                    .include_global_resource_types
                    .unwrap_or_default(),
                resource_types: self.resource_types,
            }
        }
    }
}
impl RecordingGroup {
    /// Creates a new builder-style object to manufacture [`RecordingGroup`](crate::model::RecordingGroup)
    pub fn builder() -> crate::model::recording_group::Builder {
        crate::model::recording_group::Builder::default()
    }
}

/// <p>The details about the configuration aggregator, including
/// information about source accounts, regions, and metadata of the
/// aggregator. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationAggregator {
    /// <p>The name of the aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the aggregator.</p>
    pub configuration_aggregator_arn: std::option::Option<std::string::String>,
    /// <p>Provides a list of source accounts and regions to be
    /// aggregated.</p>
    pub account_aggregation_sources:
        std::option::Option<std::vec::Vec<crate::model::AccountAggregationSource>>,
    /// <p>Provides an organization and list of regions to be
    /// aggregated.</p>
    pub organization_aggregation_source:
        std::option::Option<crate::model::OrganizationAggregationSource>,
    /// <p>The time stamp when the configuration aggregator was
    /// created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time of the last update.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Amazon Web Services service that created the configuration aggregator.</p>
    pub created_by: std::option::Option<std::string::String>,
}
impl ConfigurationAggregator {
    /// <p>The name of the aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the aggregator.</p>
    pub fn configuration_aggregator_arn(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_arn.as_deref()
    }
    /// <p>Provides a list of source accounts and regions to be
    /// aggregated.</p>
    pub fn account_aggregation_sources(
        &self,
    ) -> std::option::Option<&[crate::model::AccountAggregationSource]> {
        self.account_aggregation_sources.as_deref()
    }
    /// <p>Provides an organization and list of regions to be
    /// aggregated.</p>
    pub fn organization_aggregation_source(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationAggregationSource> {
        self.organization_aggregation_source.as_ref()
    }
    /// <p>The time stamp when the configuration aggregator was
    /// created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time of the last update.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>Amazon Web Services service that created the configuration aggregator.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
}
impl std::fmt::Debug for ConfigurationAggregator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationAggregator");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field(
            "configuration_aggregator_arn",
            &self.configuration_aggregator_arn,
        );
        formatter.field(
            "account_aggregation_sources",
            &self.account_aggregation_sources,
        );
        formatter.field(
            "organization_aggregation_source",
            &self.organization_aggregation_source,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_by", &self.created_by);
        formatter.finish()
    }
}
/// See [`ConfigurationAggregator`](crate::model::ConfigurationAggregator)
pub mod configuration_aggregator {
    /// A builder for [`ConfigurationAggregator`](crate::model::ConfigurationAggregator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) configuration_aggregator_arn: std::option::Option<std::string::String>,
        pub(crate) account_aggregation_sources:
            std::option::Option<std::vec::Vec<crate::model::AccountAggregationSource>>,
        pub(crate) organization_aggregation_source:
            std::option::Option<crate::model::OrganizationAggregationSource>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the aggregator.</p>
        pub fn configuration_aggregator_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the aggregator.</p>
        pub fn set_configuration_aggregator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_arn = input;
            self
        }
        /// Appends an item to `account_aggregation_sources`.
        ///
        /// To override the contents of this collection use [`set_account_aggregation_sources`](Self::set_account_aggregation_sources).
        ///
        /// <p>Provides a list of source accounts and regions to be
        /// aggregated.</p>
        pub fn account_aggregation_sources(
            mut self,
            input: impl Into<crate::model::AccountAggregationSource>,
        ) -> Self {
            let mut v = self.account_aggregation_sources.unwrap_or_default();
            v.push(input.into());
            self.account_aggregation_sources = Some(v);
            self
        }
        /// <p>Provides a list of source accounts and regions to be
        /// aggregated.</p>
        pub fn set_account_aggregation_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountAggregationSource>>,
        ) -> Self {
            self.account_aggregation_sources = input;
            self
        }
        /// <p>Provides an organization and list of regions to be
        /// aggregated.</p>
        pub fn organization_aggregation_source(
            mut self,
            input: crate::model::OrganizationAggregationSource,
        ) -> Self {
            self.organization_aggregation_source = Some(input);
            self
        }
        /// <p>Provides an organization and list of regions to be
        /// aggregated.</p>
        pub fn set_organization_aggregation_source(
            mut self,
            input: std::option::Option<crate::model::OrganizationAggregationSource>,
        ) -> Self {
            self.organization_aggregation_source = input;
            self
        }
        /// <p>The time stamp when the configuration aggregator was
        /// created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time stamp when the configuration aggregator was
        /// created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time of the last update.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time of the last update.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Amazon Web Services service that created the configuration aggregator.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>Amazon Web Services service that created the configuration aggregator.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationAggregator`](crate::model::ConfigurationAggregator)
        pub fn build(self) -> crate::model::ConfigurationAggregator {
            crate::model::ConfigurationAggregator {
                configuration_aggregator_name: self.configuration_aggregator_name,
                configuration_aggregator_arn: self.configuration_aggregator_arn,
                account_aggregation_sources: self.account_aggregation_sources,
                organization_aggregation_source: self.organization_aggregation_source,
                creation_time: self.creation_time,
                last_updated_time: self.last_updated_time,
                created_by: self.created_by,
            }
        }
    }
}
impl ConfigurationAggregator {
    /// Creates a new builder-style object to manufacture [`ConfigurationAggregator`](crate::model::ConfigurationAggregator)
    pub fn builder() -> crate::model::configuration_aggregator::Builder {
        crate::model::configuration_aggregator::Builder::default()
    }
}

/// <p>This object contains regions to set up the aggregator and an IAM
/// role to retrieve organization details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationAggregationSource {
    /// <p>ARN of the IAM role used to retrieve Amazon Web Services Organization details
    /// associated with the aggregator account.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The source regions being aggregated.</p>
    pub aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If true, aggregate existing Config regions and future
    /// regions.</p>
    pub all_aws_regions: bool,
}
impl OrganizationAggregationSource {
    /// <p>ARN of the IAM role used to retrieve Amazon Web Services Organization details
    /// associated with the aggregator account.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The source regions being aggregated.</p>
    pub fn aws_regions(&self) -> std::option::Option<&[std::string::String]> {
        self.aws_regions.as_deref()
    }
    /// <p>If true, aggregate existing Config regions and future
    /// regions.</p>
    pub fn all_aws_regions(&self) -> bool {
        self.all_aws_regions
    }
}
impl std::fmt::Debug for OrganizationAggregationSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationAggregationSource");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("aws_regions", &self.aws_regions);
        formatter.field("all_aws_regions", &self.all_aws_regions);
        formatter.finish()
    }
}
/// See [`OrganizationAggregationSource`](crate::model::OrganizationAggregationSource)
pub mod organization_aggregation_source {
    /// A builder for [`OrganizationAggregationSource`](crate::model::OrganizationAggregationSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) all_aws_regions: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>ARN of the IAM role used to retrieve Amazon Web Services Organization details
        /// associated with the aggregator account.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role used to retrieve Amazon Web Services Organization details
        /// associated with the aggregator account.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `aws_regions`.
        ///
        /// To override the contents of this collection use [`set_aws_regions`](Self::set_aws_regions).
        ///
        /// <p>The source regions being aggregated.</p>
        pub fn aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.aws_regions.unwrap_or_default();
            v.push(input.into());
            self.aws_regions = Some(v);
            self
        }
        /// <p>The source regions being aggregated.</p>
        pub fn set_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.aws_regions = input;
            self
        }
        /// <p>If true, aggregate existing Config regions and future
        /// regions.</p>
        pub fn all_aws_regions(mut self, input: bool) -> Self {
            self.all_aws_regions = Some(input);
            self
        }
        /// <p>If true, aggregate existing Config regions and future
        /// regions.</p>
        pub fn set_all_aws_regions(mut self, input: std::option::Option<bool>) -> Self {
            self.all_aws_regions = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationAggregationSource`](crate::model::OrganizationAggregationSource)
        pub fn build(self) -> crate::model::OrganizationAggregationSource {
            crate::model::OrganizationAggregationSource {
                role_arn: self.role_arn,
                aws_regions: self.aws_regions,
                all_aws_regions: self.all_aws_regions.unwrap_or_default(),
            }
        }
    }
}
impl OrganizationAggregationSource {
    /// Creates a new builder-style object to manufacture [`OrganizationAggregationSource`](crate::model::OrganizationAggregationSource)
    pub fn builder() -> crate::model::organization_aggregation_source::Builder {
        crate::model::organization_aggregation_source::Builder::default()
    }
}

/// <p>A collection of accounts and regions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAggregationSource {
    /// <p>The 12-digit account ID of the account being aggregated.
    /// </p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If true, aggregate existing Config regions and future
    /// regions.</p>
    pub all_aws_regions: bool,
    /// <p>The source regions being aggregated.</p>
    pub aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AccountAggregationSource {
    /// <p>The 12-digit account ID of the account being aggregated.
    /// </p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
    /// <p>If true, aggregate existing Config regions and future
    /// regions.</p>
    pub fn all_aws_regions(&self) -> bool {
        self.all_aws_regions
    }
    /// <p>The source regions being aggregated.</p>
    pub fn aws_regions(&self) -> std::option::Option<&[std::string::String]> {
        self.aws_regions.as_deref()
    }
}
impl std::fmt::Debug for AccountAggregationSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAggregationSource");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("all_aws_regions", &self.all_aws_regions);
        formatter.field("aws_regions", &self.aws_regions);
        formatter.finish()
    }
}
/// See [`AccountAggregationSource`](crate::model::AccountAggregationSource)
pub mod account_aggregation_source {
    /// A builder for [`AccountAggregationSource`](crate::model::AccountAggregationSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) all_aws_regions: std::option::Option<bool>,
        pub(crate) aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The 12-digit account ID of the account being aggregated.
        /// </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The 12-digit account ID of the account being aggregated.
        /// </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// <p>If true, aggregate existing Config regions and future
        /// regions.</p>
        pub fn all_aws_regions(mut self, input: bool) -> Self {
            self.all_aws_regions = Some(input);
            self
        }
        /// <p>If true, aggregate existing Config regions and future
        /// regions.</p>
        pub fn set_all_aws_regions(mut self, input: std::option::Option<bool>) -> Self {
            self.all_aws_regions = input;
            self
        }
        /// Appends an item to `aws_regions`.
        ///
        /// To override the contents of this collection use [`set_aws_regions`](Self::set_aws_regions).
        ///
        /// <p>The source regions being aggregated.</p>
        pub fn aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.aws_regions.unwrap_or_default();
            v.push(input.into());
            self.aws_regions = Some(v);
            self
        }
        /// <p>The source regions being aggregated.</p>
        pub fn set_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.aws_regions = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAggregationSource`](crate::model::AccountAggregationSource)
        pub fn build(self) -> crate::model::AccountAggregationSource {
            crate::model::AccountAggregationSource {
                account_ids: self.account_ids,
                all_aws_regions: self.all_aws_regions.unwrap_or_default(),
                aws_regions: self.aws_regions,
            }
        }
    }
}
impl AccountAggregationSource {
    /// Creates a new builder-style object to manufacture [`AccountAggregationSource`](crate::model::AccountAggregationSource)
    pub fn builder() -> crate::model::account_aggregation_source::Builder {
        crate::model::account_aggregation_source::Builder::default()
    }
}

/// <p>An Config rule represents an Lambda function that you
/// create for a custom rule or a predefined function for an Config managed
/// rule. The function evaluates configuration items to assess whether
/// your Amazon Web Services resources comply with your desired configurations. This
/// function can run when Config detects a configuration change to
/// an Amazon Web Services resource and at a periodic frequency that you choose (for
/// example, every 24 hours).</p>
///
/// <note>
/// <p>You can use the Amazon Web Services CLI and Amazon Web Services SDKs if you want to create
/// a rule that triggers evaluations for your resources when Config delivers the configuration snapshot. For more
/// information, see <a>ConfigSnapshotDeliveryProperties</a>.</p>
/// </note>
/// <p>For more information about developing and using Config
/// rules, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating Amazon Web Services resource Configurations with Config</a>
/// in the <i>Config Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigRule {
    /// <p>The name that you assign to the Config rule. The name is
    /// required if you are adding a new rule.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Config
    /// rule.</p>
    pub config_rule_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the Config rule.</p>
    pub config_rule_id: std::option::Option<std::string::String>,
    /// <p>The description that you provide for the Config
    /// rule.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Defines which resources can trigger an evaluation for the rule.
    /// The scope can include one or more resource types, a combination of
    /// one resource type and one resource ID, or a combination of a tag key
    /// and value. Specify a scope to constrain the resources that can
    /// trigger an evaluation for the rule. If you do not specify a scope,
    /// evaluations are triggered when any resource in the recording group
    /// changes.</p>
    /// <note>
    /// <p>The scope can be empty. </p>
    /// </note>
    pub scope: std::option::Option<crate::model::Scope>,
    /// <p>Provides the rule owner (Amazon Web Services or customer), the rule identifier,
    /// and the notifications that cause the function to evaluate your Amazon Web Services
    /// resources.</p>
    pub source: std::option::Option<crate::model::Source>,
    /// <p>A string, in JSON format, that is passed to the Config rule
    /// Lambda function.</p>
    pub input_parameters: std::option::Option<std::string::String>,
    /// <p>The maximum frequency with which Config runs evaluations
    /// for a rule. You can specify a value for
    /// <code>MaximumExecutionFrequency</code> when:</p>
    /// <ul>
    /// <li>
    /// <p>You are using an Config managed rule that is triggered at
    /// a periodic frequency.</p>
    /// </li>
    /// <li>
    /// <p>Your custom rule is triggered when Config delivers
    /// the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p>
    /// </li>
    /// </ul>
    ///
    ///
    ///
    /// <note>
    /// <p>By default, rules with a periodic trigger are evaluated
    /// every 24 hours. To change the frequency, specify a valid value
    /// for the <code>MaximumExecutionFrequency</code>
    /// parameter.</p>
    /// </note>
    pub maximum_execution_frequency: std::option::Option<crate::model::MaximumExecutionFrequency>,
    /// <p>Indicates whether the Config rule is active or is currently
    /// being deleted by Config. It can also indicate the evaluation
    /// status for the Config rule.</p>
    ///
    /// <p>Config sets the state of the rule to
    /// <code>EVALUATING</code> temporarily after you use the
    /// <code>StartConfigRulesEvaluation</code> request to evaluate your
    /// resources against the Config rule.</p>
    ///
    /// <p>Config sets the state of the rule to
    /// <code>DELETING_RESULTS</code> temporarily after you use the
    /// <code>DeleteEvaluationResults</code> request to delete the
    /// current evaluation results for the Config rule.</p>
    ///
    /// <p>Config temporarily sets the state of a rule to
    /// <code>DELETING</code> after you use the
    /// <code>DeleteConfigRule</code> request to delete the rule. After
    /// Config deletes the rule, the rule and all of its evaluations are
    /// erased and are no longer available.</p>
    pub config_rule_state: std::option::Option<crate::model::ConfigRuleState>,
    /// <p>Service principal name of the service that created the
    /// rule.</p>
    /// <note>
    /// <p>The field is populated only if the service linked rule is
    /// created by a service. The field is empty if you create your own
    /// rule.</p>
    /// </note>
    pub created_by: std::option::Option<std::string::String>,
}
impl ConfigRule {
    /// <p>The name that you assign to the Config rule. The name is
    /// required if you are adding a new rule.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Config
    /// rule.</p>
    pub fn config_rule_arn(&self) -> std::option::Option<&str> {
        self.config_rule_arn.as_deref()
    }
    /// <p>The ID of the Config rule.</p>
    pub fn config_rule_id(&self) -> std::option::Option<&str> {
        self.config_rule_id.as_deref()
    }
    /// <p>The description that you provide for the Config
    /// rule.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Defines which resources can trigger an evaluation for the rule.
    /// The scope can include one or more resource types, a combination of
    /// one resource type and one resource ID, or a combination of a tag key
    /// and value. Specify a scope to constrain the resources that can
    /// trigger an evaluation for the rule. If you do not specify a scope,
    /// evaluations are triggered when any resource in the recording group
    /// changes.</p>
    /// <note>
    /// <p>The scope can be empty. </p>
    /// </note>
    pub fn scope(&self) -> std::option::Option<&crate::model::Scope> {
        self.scope.as_ref()
    }
    /// <p>Provides the rule owner (Amazon Web Services or customer), the rule identifier,
    /// and the notifications that cause the function to evaluate your Amazon Web Services
    /// resources.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::Source> {
        self.source.as_ref()
    }
    /// <p>A string, in JSON format, that is passed to the Config rule
    /// Lambda function.</p>
    pub fn input_parameters(&self) -> std::option::Option<&str> {
        self.input_parameters.as_deref()
    }
    /// <p>The maximum frequency with which Config runs evaluations
    /// for a rule. You can specify a value for
    /// <code>MaximumExecutionFrequency</code> when:</p>
    /// <ul>
    /// <li>
    /// <p>You are using an Config managed rule that is triggered at
    /// a periodic frequency.</p>
    /// </li>
    /// <li>
    /// <p>Your custom rule is triggered when Config delivers
    /// the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p>
    /// </li>
    /// </ul>
    ///
    ///
    ///
    /// <note>
    /// <p>By default, rules with a periodic trigger are evaluated
    /// every 24 hours. To change the frequency, specify a valid value
    /// for the <code>MaximumExecutionFrequency</code>
    /// parameter.</p>
    /// </note>
    pub fn maximum_execution_frequency(
        &self,
    ) -> std::option::Option<&crate::model::MaximumExecutionFrequency> {
        self.maximum_execution_frequency.as_ref()
    }
    /// <p>Indicates whether the Config rule is active or is currently
    /// being deleted by Config. It can also indicate the evaluation
    /// status for the Config rule.</p>
    ///
    /// <p>Config sets the state of the rule to
    /// <code>EVALUATING</code> temporarily after you use the
    /// <code>StartConfigRulesEvaluation</code> request to evaluate your
    /// resources against the Config rule.</p>
    ///
    /// <p>Config sets the state of the rule to
    /// <code>DELETING_RESULTS</code> temporarily after you use the
    /// <code>DeleteEvaluationResults</code> request to delete the
    /// current evaluation results for the Config rule.</p>
    ///
    /// <p>Config temporarily sets the state of a rule to
    /// <code>DELETING</code> after you use the
    /// <code>DeleteConfigRule</code> request to delete the rule. After
    /// Config deletes the rule, the rule and all of its evaluations are
    /// erased and are no longer available.</p>
    pub fn config_rule_state(&self) -> std::option::Option<&crate::model::ConfigRuleState> {
        self.config_rule_state.as_ref()
    }
    /// <p>Service principal name of the service that created the
    /// rule.</p>
    /// <note>
    /// <p>The field is populated only if the service linked rule is
    /// created by a service. The field is empty if you create your own
    /// rule.</p>
    /// </note>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
}
impl std::fmt::Debug for ConfigRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigRule");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("config_rule_arn", &self.config_rule_arn);
        formatter.field("config_rule_id", &self.config_rule_id);
        formatter.field("description", &self.description);
        formatter.field("scope", &self.scope);
        formatter.field("source", &self.source);
        formatter.field("input_parameters", &self.input_parameters);
        formatter.field(
            "maximum_execution_frequency",
            &self.maximum_execution_frequency,
        );
        formatter.field("config_rule_state", &self.config_rule_state);
        formatter.field("created_by", &self.created_by);
        formatter.finish()
    }
}
/// See [`ConfigRule`](crate::model::ConfigRule)
pub mod config_rule {
    /// A builder for [`ConfigRule`](crate::model::ConfigRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) config_rule_arn: std::option::Option<std::string::String>,
        pub(crate) config_rule_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) scope: std::option::Option<crate::model::Scope>,
        pub(crate) source: std::option::Option<crate::model::Source>,
        pub(crate) input_parameters: std::option::Option<std::string::String>,
        pub(crate) maximum_execution_frequency:
            std::option::Option<crate::model::MaximumExecutionFrequency>,
        pub(crate) config_rule_state: std::option::Option<crate::model::ConfigRuleState>,
        pub(crate) created_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name that you assign to the Config rule. The name is
        /// required if you are adding a new rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name that you assign to the Config rule. The name is
        /// required if you are adding a new rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Config
        /// rule.</p>
        pub fn config_rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Config
        /// rule.</p>
        pub fn set_config_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_arn = input;
            self
        }
        /// <p>The ID of the Config rule.</p>
        pub fn config_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_id = Some(input.into());
            self
        }
        /// <p>The ID of the Config rule.</p>
        pub fn set_config_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_id = input;
            self
        }
        /// <p>The description that you provide for the Config
        /// rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description that you provide for the Config
        /// rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Defines which resources can trigger an evaluation for the rule.
        /// The scope can include one or more resource types, a combination of
        /// one resource type and one resource ID, or a combination of a tag key
        /// and value. Specify a scope to constrain the resources that can
        /// trigger an evaluation for the rule. If you do not specify a scope,
        /// evaluations are triggered when any resource in the recording group
        /// changes.</p>
        /// <note>
        /// <p>The scope can be empty. </p>
        /// </note>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p>Defines which resources can trigger an evaluation for the rule.
        /// The scope can include one or more resource types, a combination of
        /// one resource type and one resource ID, or a combination of a tag key
        /// and value. Specify a scope to constrain the resources that can
        /// trigger an evaluation for the rule. If you do not specify a scope,
        /// evaluations are triggered when any resource in the recording group
        /// changes.</p>
        /// <note>
        /// <p>The scope can be empty. </p>
        /// </note>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.scope = input;
            self
        }
        /// <p>Provides the rule owner (Amazon Web Services or customer), the rule identifier,
        /// and the notifications that cause the function to evaluate your Amazon Web Services
        /// resources.</p>
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>Provides the rule owner (Amazon Web Services or customer), the rule identifier,
        /// and the notifications that cause the function to evaluate your Amazon Web Services
        /// resources.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.source = input;
            self
        }
        /// <p>A string, in JSON format, that is passed to the Config rule
        /// Lambda function.</p>
        pub fn input_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_parameters = Some(input.into());
            self
        }
        /// <p>A string, in JSON format, that is passed to the Config rule
        /// Lambda function.</p>
        pub fn set_input_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_parameters = input;
            self
        }
        /// <p>The maximum frequency with which Config runs evaluations
        /// for a rule. You can specify a value for
        /// <code>MaximumExecutionFrequency</code> when:</p>
        /// <ul>
        /// <li>
        /// <p>You are using an Config managed rule that is triggered at
        /// a periodic frequency.</p>
        /// </li>
        /// <li>
        /// <p>Your custom rule is triggered when Config delivers
        /// the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p>
        /// </li>
        /// </ul>
        ///
        ///
        ///
        /// <note>
        /// <p>By default, rules with a periodic trigger are evaluated
        /// every 24 hours. To change the frequency, specify a valid value
        /// for the <code>MaximumExecutionFrequency</code>
        /// parameter.</p>
        /// </note>
        pub fn maximum_execution_frequency(
            mut self,
            input: crate::model::MaximumExecutionFrequency,
        ) -> Self {
            self.maximum_execution_frequency = Some(input);
            self
        }
        /// <p>The maximum frequency with which Config runs evaluations
        /// for a rule. You can specify a value for
        /// <code>MaximumExecutionFrequency</code> when:</p>
        /// <ul>
        /// <li>
        /// <p>You are using an Config managed rule that is triggered at
        /// a periodic frequency.</p>
        /// </li>
        /// <li>
        /// <p>Your custom rule is triggered when Config delivers
        /// the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p>
        /// </li>
        /// </ul>
        ///
        ///
        ///
        /// <note>
        /// <p>By default, rules with a periodic trigger are evaluated
        /// every 24 hours. To change the frequency, specify a valid value
        /// for the <code>MaximumExecutionFrequency</code>
        /// parameter.</p>
        /// </note>
        pub fn set_maximum_execution_frequency(
            mut self,
            input: std::option::Option<crate::model::MaximumExecutionFrequency>,
        ) -> Self {
            self.maximum_execution_frequency = input;
            self
        }
        /// <p>Indicates whether the Config rule is active or is currently
        /// being deleted by Config. It can also indicate the evaluation
        /// status for the Config rule.</p>
        ///
        /// <p>Config sets the state of the rule to
        /// <code>EVALUATING</code> temporarily after you use the
        /// <code>StartConfigRulesEvaluation</code> request to evaluate your
        /// resources against the Config rule.</p>
        ///
        /// <p>Config sets the state of the rule to
        /// <code>DELETING_RESULTS</code> temporarily after you use the
        /// <code>DeleteEvaluationResults</code> request to delete the
        /// current evaluation results for the Config rule.</p>
        ///
        /// <p>Config temporarily sets the state of a rule to
        /// <code>DELETING</code> after you use the
        /// <code>DeleteConfigRule</code> request to delete the rule. After
        /// Config deletes the rule, the rule and all of its evaluations are
        /// erased and are no longer available.</p>
        pub fn config_rule_state(mut self, input: crate::model::ConfigRuleState) -> Self {
            self.config_rule_state = Some(input);
            self
        }
        /// <p>Indicates whether the Config rule is active or is currently
        /// being deleted by Config. It can also indicate the evaluation
        /// status for the Config rule.</p>
        ///
        /// <p>Config sets the state of the rule to
        /// <code>EVALUATING</code> temporarily after you use the
        /// <code>StartConfigRulesEvaluation</code> request to evaluate your
        /// resources against the Config rule.</p>
        ///
        /// <p>Config sets the state of the rule to
        /// <code>DELETING_RESULTS</code> temporarily after you use the
        /// <code>DeleteEvaluationResults</code> request to delete the
        /// current evaluation results for the Config rule.</p>
        ///
        /// <p>Config temporarily sets the state of a rule to
        /// <code>DELETING</code> after you use the
        /// <code>DeleteConfigRule</code> request to delete the rule. After
        /// Config deletes the rule, the rule and all of its evaluations are
        /// erased and are no longer available.</p>
        pub fn set_config_rule_state(
            mut self,
            input: std::option::Option<crate::model::ConfigRuleState>,
        ) -> Self {
            self.config_rule_state = input;
            self
        }
        /// <p>Service principal name of the service that created the
        /// rule.</p>
        /// <note>
        /// <p>The field is populated only if the service linked rule is
        /// created by a service. The field is empty if you create your own
        /// rule.</p>
        /// </note>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>Service principal name of the service that created the
        /// rule.</p>
        /// <note>
        /// <p>The field is populated only if the service linked rule is
        /// created by a service. The field is empty if you create your own
        /// rule.</p>
        /// </note>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigRule`](crate::model::ConfigRule)
        pub fn build(self) -> crate::model::ConfigRule {
            crate::model::ConfigRule {
                config_rule_name: self.config_rule_name,
                config_rule_arn: self.config_rule_arn,
                config_rule_id: self.config_rule_id,
                description: self.description,
                scope: self.scope,
                source: self.source,
                input_parameters: self.input_parameters,
                maximum_execution_frequency: self.maximum_execution_frequency,
                config_rule_state: self.config_rule_state,
                created_by: self.created_by,
            }
        }
    }
}
impl ConfigRule {
    /// Creates a new builder-style object to manufacture [`ConfigRule`](crate::model::ConfigRule)
    pub fn builder() -> crate::model::config_rule::Builder {
        crate::model::config_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigRuleState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    DeletingResults,
    #[allow(missing_docs)] // documentation missing in model
    Evaluating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigRuleState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ConfigRuleState::Active,
            "DELETING" => ConfigRuleState::Deleting,
            "DELETING_RESULTS" => ConfigRuleState::DeletingResults,
            "EVALUATING" => ConfigRuleState::Evaluating,
            other => ConfigRuleState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigRuleState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigRuleState::from(s))
    }
}
impl ConfigRuleState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigRuleState::Active => "ACTIVE",
            ConfigRuleState::Deleting => "DELETING",
            ConfigRuleState::DeletingResults => "DELETING_RESULTS",
            ConfigRuleState::Evaluating => "EVALUATING",
            ConfigRuleState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETING", "DELETING_RESULTS", "EVALUATING"]
    }
}
impl AsRef<str> for ConfigRuleState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the Config rule owner (Amazon Web Services or customer), the rule
/// identifier, and the events that trigger the evaluation of your Amazon Web Services
/// resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Source {
    /// <p>Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
    pub owner: std::option::Option<crate::model::Owner>,
    /// <p>For Config managed rules, a predefined identifier from a
    /// list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed
    /// rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
    /// <p>For custom rules, the identifier is the Amazon Resource Name
    /// (ARN) of the rule's Lambda function, such as
    /// <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.</p>
    pub source_identifier: std::option::Option<std::string::String>,
    /// <p>Provides the source and type of the event that causes Config to evaluate your Amazon Web Services resources.</p>
    pub source_details: std::option::Option<std::vec::Vec<crate::model::SourceDetail>>,
}
impl Source {
    /// <p>Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Owner> {
        self.owner.as_ref()
    }
    /// <p>For Config managed rules, a predefined identifier from a
    /// list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed
    /// rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
    /// <p>For custom rules, the identifier is the Amazon Resource Name
    /// (ARN) of the rule's Lambda function, such as
    /// <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.</p>
    pub fn source_identifier(&self) -> std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
    /// <p>Provides the source and type of the event that causes Config to evaluate your Amazon Web Services resources.</p>
    pub fn source_details(&self) -> std::option::Option<&[crate::model::SourceDetail]> {
        self.source_details.as_deref()
    }
}
impl std::fmt::Debug for Source {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Source");
        formatter.field("owner", &self.owner);
        formatter.field("source_identifier", &self.source_identifier);
        formatter.field("source_details", &self.source_details);
        formatter.finish()
    }
}
/// See [`Source`](crate::model::Source)
pub mod source {
    /// A builder for [`Source`](crate::model::Source)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner: std::option::Option<crate::model::Owner>,
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_details: std::option::Option<std::vec::Vec<crate::model::SourceDetail>>,
    }
    impl Builder {
        /// <p>Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
        pub fn owner(mut self, input: crate::model::Owner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Owner>) -> Self {
            self.owner = input;
            self
        }
        /// <p>For Config managed rules, a predefined identifier from a
        /// list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed
        /// rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
        /// <p>For custom rules, the identifier is the Amazon Resource Name
        /// (ARN) of the rule's Lambda function, such as
        /// <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>For Config managed rules, a predefined identifier from a
        /// list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed
        /// rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>
        /// <p>For custom rules, the identifier is the Amazon Resource Name
        /// (ARN) of the rule's Lambda function, such as
        /// <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// Appends an item to `source_details`.
        ///
        /// To override the contents of this collection use [`set_source_details`](Self::set_source_details).
        ///
        /// <p>Provides the source and type of the event that causes Config to evaluate your Amazon Web Services resources.</p>
        pub fn source_details(mut self, input: impl Into<crate::model::SourceDetail>) -> Self {
            let mut v = self.source_details.unwrap_or_default();
            v.push(input.into());
            self.source_details = Some(v);
            self
        }
        /// <p>Provides the source and type of the event that causes Config to evaluate your Amazon Web Services resources.</p>
        pub fn set_source_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceDetail>>,
        ) -> Self {
            self.source_details = input;
            self
        }
        /// Consumes the builder and constructs a [`Source`](crate::model::Source)
        pub fn build(self) -> crate::model::Source {
            crate::model::Source {
                owner: self.owner,
                source_identifier: self.source_identifier,
                source_details: self.source_details,
            }
        }
    }
}
impl Source {
    /// Creates a new builder-style object to manufacture [`Source`](crate::model::Source)
    pub fn builder() -> crate::model::source::Builder {
        crate::model::source::Builder::default()
    }
}

/// <p>Provides the source and the message types that trigger Config to evaluate your Amazon Web Services resources against a rule. It also
/// provides the frequency with which you want Config to run
/// evaluations for the rule if the trigger type is periodic. You can
/// specify the parameter values for <code>SourceDetail</code> only for
/// custom rules. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceDetail {
    /// <p>The source of the event, such as an Amazon Web Services service, that triggers
    /// Config to evaluate your Amazon Web Services resources.</p>
    pub event_source: std::option::Option<crate::model::EventSource>,
    /// <p>The type of notification that triggers Config to run an
    /// evaluation for a rule. You can specify the following notification
    /// types:</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ConfigurationItemChangeNotification</code> - Triggers
    /// an evaluation when Config delivers a configuration item
    /// as a result of a resource change.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OversizedConfigurationItemChangeNotification</code>
    /// - Triggers an evaluation when Config delivers an
    /// oversized configuration item. Config may generate this
    /// notification type when a resource changes and the
    /// notification exceeds the maximum size allowed by Amazon
    /// SNS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ScheduledNotification</code> - Triggers a
    /// periodic evaluation at the frequency specified for
    /// <code>MaximumExecutionFrequency</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConfigurationSnapshotDeliveryCompleted</code> -
    /// Triggers a periodic evaluation when Config delivers a
    /// configuration snapshot.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>If you want your custom rule to be triggered by configuration
    /// changes, specify two SourceDetail objects, one for
    /// <code>ConfigurationItemChangeNotification</code> and one for
    /// <code>OversizedConfigurationItemChangeNotification</code>.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
    /// <p>The frequency at which you want Config to run evaluations
    /// for a custom rule with a periodic trigger. If you specify a value
    /// for <code>MaximumExecutionFrequency</code>, then
    /// <code>MessageType</code> must use the
    /// <code>ScheduledNotification</code> value.</p>
    ///
    ///
    ///
    ///
    ///
    /// <note>
    /// <p>By default, rules with a periodic trigger are evaluated
    /// every 24 hours. To change the frequency, specify a valid value
    /// for the <code>MaximumExecutionFrequency</code>
    /// parameter.</p>
    /// <p>Based on the valid value you choose, Config runs
    /// evaluations once for each valid value. For example, if you
    /// choose <code>Three_Hours</code>, Config runs evaluations
    /// once every three hours. In this case, <code>Three_Hours</code>
    /// is the frequency of this rule. </p>
    /// </note>
    pub maximum_execution_frequency: std::option::Option<crate::model::MaximumExecutionFrequency>,
}
impl SourceDetail {
    /// <p>The source of the event, such as an Amazon Web Services service, that triggers
    /// Config to evaluate your Amazon Web Services resources.</p>
    pub fn event_source(&self) -> std::option::Option<&crate::model::EventSource> {
        self.event_source.as_ref()
    }
    /// <p>The type of notification that triggers Config to run an
    /// evaluation for a rule. You can specify the following notification
    /// types:</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ConfigurationItemChangeNotification</code> - Triggers
    /// an evaluation when Config delivers a configuration item
    /// as a result of a resource change.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OversizedConfigurationItemChangeNotification</code>
    /// - Triggers an evaluation when Config delivers an
    /// oversized configuration item. Config may generate this
    /// notification type when a resource changes and the
    /// notification exceeds the maximum size allowed by Amazon
    /// SNS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ScheduledNotification</code> - Triggers a
    /// periodic evaluation at the frequency specified for
    /// <code>MaximumExecutionFrequency</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConfigurationSnapshotDeliveryCompleted</code> -
    /// Triggers a periodic evaluation when Config delivers a
    /// configuration snapshot.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>If you want your custom rule to be triggered by configuration
    /// changes, specify two SourceDetail objects, one for
    /// <code>ConfigurationItemChangeNotification</code> and one for
    /// <code>OversizedConfigurationItemChangeNotification</code>.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
    /// <p>The frequency at which you want Config to run evaluations
    /// for a custom rule with a periodic trigger. If you specify a value
    /// for <code>MaximumExecutionFrequency</code>, then
    /// <code>MessageType</code> must use the
    /// <code>ScheduledNotification</code> value.</p>
    ///
    ///
    ///
    ///
    ///
    /// <note>
    /// <p>By default, rules with a periodic trigger are evaluated
    /// every 24 hours. To change the frequency, specify a valid value
    /// for the <code>MaximumExecutionFrequency</code>
    /// parameter.</p>
    /// <p>Based on the valid value you choose, Config runs
    /// evaluations once for each valid value. For example, if you
    /// choose <code>Three_Hours</code>, Config runs evaluations
    /// once every three hours. In this case, <code>Three_Hours</code>
    /// is the frequency of this rule. </p>
    /// </note>
    pub fn maximum_execution_frequency(
        &self,
    ) -> std::option::Option<&crate::model::MaximumExecutionFrequency> {
        self.maximum_execution_frequency.as_ref()
    }
}
impl std::fmt::Debug for SourceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceDetail");
        formatter.field("event_source", &self.event_source);
        formatter.field("message_type", &self.message_type);
        formatter.field(
            "maximum_execution_frequency",
            &self.maximum_execution_frequency,
        );
        formatter.finish()
    }
}
/// See [`SourceDetail`](crate::model::SourceDetail)
pub mod source_detail {
    /// A builder for [`SourceDetail`](crate::model::SourceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_source: std::option::Option<crate::model::EventSource>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
        pub(crate) maximum_execution_frequency:
            std::option::Option<crate::model::MaximumExecutionFrequency>,
    }
    impl Builder {
        /// <p>The source of the event, such as an Amazon Web Services service, that triggers
        /// Config to evaluate your Amazon Web Services resources.</p>
        pub fn event_source(mut self, input: crate::model::EventSource) -> Self {
            self.event_source = Some(input);
            self
        }
        /// <p>The source of the event, such as an Amazon Web Services service, that triggers
        /// Config to evaluate your Amazon Web Services resources.</p>
        pub fn set_event_source(
            mut self,
            input: std::option::Option<crate::model::EventSource>,
        ) -> Self {
            self.event_source = input;
            self
        }
        /// <p>The type of notification that triggers Config to run an
        /// evaluation for a rule. You can specify the following notification
        /// types:</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConfigurationItemChangeNotification</code> - Triggers
        /// an evaluation when Config delivers a configuration item
        /// as a result of a resource change.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OversizedConfigurationItemChangeNotification</code>
        /// - Triggers an evaluation when Config delivers an
        /// oversized configuration item. Config may generate this
        /// notification type when a resource changes and the
        /// notification exceeds the maximum size allowed by Amazon
        /// SNS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ScheduledNotification</code> - Triggers a
        /// periodic evaluation at the frequency specified for
        /// <code>MaximumExecutionFrequency</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfigurationSnapshotDeliveryCompleted</code> -
        /// Triggers a periodic evaluation when Config delivers a
        /// configuration snapshot.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>If you want your custom rule to be triggered by configuration
        /// changes, specify two SourceDetail objects, one for
        /// <code>ConfigurationItemChangeNotification</code> and one for
        /// <code>OversizedConfigurationItemChangeNotification</code>.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>The type of notification that triggers Config to run an
        /// evaluation for a rule. You can specify the following notification
        /// types:</p>
        ///
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConfigurationItemChangeNotification</code> - Triggers
        /// an evaluation when Config delivers a configuration item
        /// as a result of a resource change.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OversizedConfigurationItemChangeNotification</code>
        /// - Triggers an evaluation when Config delivers an
        /// oversized configuration item. Config may generate this
        /// notification type when a resource changes and the
        /// notification exceeds the maximum size allowed by Amazon
        /// SNS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ScheduledNotification</code> - Triggers a
        /// periodic evaluation at the frequency specified for
        /// <code>MaximumExecutionFrequency</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfigurationSnapshotDeliveryCompleted</code> -
        /// Triggers a periodic evaluation when Config delivers a
        /// configuration snapshot.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>If you want your custom rule to be triggered by configuration
        /// changes, specify two SourceDetail objects, one for
        /// <code>ConfigurationItemChangeNotification</code> and one for
        /// <code>OversizedConfigurationItemChangeNotification</code>.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// <p>The frequency at which you want Config to run evaluations
        /// for a custom rule with a periodic trigger. If you specify a value
        /// for <code>MaximumExecutionFrequency</code>, then
        /// <code>MessageType</code> must use the
        /// <code>ScheduledNotification</code> value.</p>
        ///
        ///
        ///
        ///
        ///
        /// <note>
        /// <p>By default, rules with a periodic trigger are evaluated
        /// every 24 hours. To change the frequency, specify a valid value
        /// for the <code>MaximumExecutionFrequency</code>
        /// parameter.</p>
        /// <p>Based on the valid value you choose, Config runs
        /// evaluations once for each valid value. For example, if you
        /// choose <code>Three_Hours</code>, Config runs evaluations
        /// once every three hours. In this case, <code>Three_Hours</code>
        /// is the frequency of this rule. </p>
        /// </note>
        pub fn maximum_execution_frequency(
            mut self,
            input: crate::model::MaximumExecutionFrequency,
        ) -> Self {
            self.maximum_execution_frequency = Some(input);
            self
        }
        /// <p>The frequency at which you want Config to run evaluations
        /// for a custom rule with a periodic trigger. If you specify a value
        /// for <code>MaximumExecutionFrequency</code>, then
        /// <code>MessageType</code> must use the
        /// <code>ScheduledNotification</code> value.</p>
        ///
        ///
        ///
        ///
        ///
        /// <note>
        /// <p>By default, rules with a periodic trigger are evaluated
        /// every 24 hours. To change the frequency, specify a valid value
        /// for the <code>MaximumExecutionFrequency</code>
        /// parameter.</p>
        /// <p>Based on the valid value you choose, Config runs
        /// evaluations once for each valid value. For example, if you
        /// choose <code>Three_Hours</code>, Config runs evaluations
        /// once every three hours. In this case, <code>Three_Hours</code>
        /// is the frequency of this rule. </p>
        /// </note>
        pub fn set_maximum_execution_frequency(
            mut self,
            input: std::option::Option<crate::model::MaximumExecutionFrequency>,
        ) -> Self {
            self.maximum_execution_frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceDetail`](crate::model::SourceDetail)
        pub fn build(self) -> crate::model::SourceDetail {
            crate::model::SourceDetail {
                event_source: self.event_source,
                message_type: self.message_type,
                maximum_execution_frequency: self.maximum_execution_frequency,
            }
        }
    }
}
impl SourceDetail {
    /// Creates a new builder-style object to manufacture [`SourceDetail`](crate::model::SourceDetail)
    pub fn builder() -> crate::model::source_detail::Builder {
        crate::model::source_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageType {
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationItemChangeNotification,
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationSnapshotDeliveryCompleted,
    #[allow(missing_docs)] // documentation missing in model
    OversizedConfigurationItemChangeNotification,
    #[allow(missing_docs)] // documentation missing in model
    ScheduledNotification,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageType {
    fn from(s: &str) -> Self {
        match s {
            "ConfigurationItemChangeNotification" => {
                MessageType::ConfigurationItemChangeNotification
            }
            "ConfigurationSnapshotDeliveryCompleted" => {
                MessageType::ConfigurationSnapshotDeliveryCompleted
            }
            "OversizedConfigurationItemChangeNotification" => {
                MessageType::OversizedConfigurationItemChangeNotification
            }
            "ScheduledNotification" => MessageType::ScheduledNotification,
            other => MessageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageType::from(s))
    }
}
impl MessageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageType::ConfigurationItemChangeNotification => {
                "ConfigurationItemChangeNotification"
            }
            MessageType::ConfigurationSnapshotDeliveryCompleted => {
                "ConfigurationSnapshotDeliveryCompleted"
            }
            MessageType::OversizedConfigurationItemChangeNotification => {
                "OversizedConfigurationItemChangeNotification"
            }
            MessageType::ScheduledNotification => "ScheduledNotification",
            MessageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ConfigurationItemChangeNotification",
            "ConfigurationSnapshotDeliveryCompleted",
            "OversizedConfigurationItemChangeNotification",
            "ScheduledNotification",
        ]
    }
}
impl AsRef<str> for MessageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventSource {
    #[allow(missing_docs)] // documentation missing in model
    AwsConfig,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventSource {
    fn from(s: &str) -> Self {
        match s {
            "aws.config" => EventSource::AwsConfig,
            other => EventSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventSource::from(s))
    }
}
impl EventSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventSource::AwsConfig => "aws.config",
            EventSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["aws.config"]
    }
}
impl AsRef<str> for EventSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Owner {
    #[allow(missing_docs)] // documentation missing in model
    Aws,
    #[allow(missing_docs)] // documentation missing in model
    CustomLambda,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Owner {
    fn from(s: &str) -> Self {
        match s {
            "AWS" => Owner::Aws,
            "CUSTOM_LAMBDA" => Owner::CustomLambda,
            other => Owner::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Owner {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Owner::from(s))
    }
}
impl Owner {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Owner::Aws => "AWS",
            Owner::CustomLambda => "CUSTOM_LAMBDA",
            Owner::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS", "CUSTOM_LAMBDA"]
    }
}
impl AsRef<str> for Owner {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines which resources trigger an evaluation for an Config
/// rule. The scope can include one or more resource types, a
/// combination of a tag key and value, or a combination of one resource
/// type and one resource ID. Specify a scope to constrain which
/// resources trigger an evaluation for a rule. Otherwise, evaluations
/// for the rule are triggered when any resource in your recording group
/// changes in configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Scope {
    /// <p>The resource types of only those Amazon Web Services resources that you want to
    /// trigger an evaluation for the rule. You can only specify one type if
    /// you also specify a resource ID for
    /// <code>ComplianceResourceId</code>.</p>
    pub compliance_resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tag key that is applied to only those Amazon Web Services resources that
    /// you want to trigger an evaluation for the rule.</p>
    pub tag_key: std::option::Option<std::string::String>,
    /// <p>The tag value applied to only those Amazon Web Services resources that you want
    /// to trigger an evaluation for the rule. If you specify a value for
    /// <code>TagValue</code>, you must also specify a value for
    /// <code>TagKey</code>.</p>
    pub tag_value: std::option::Option<std::string::String>,
    /// <p>The ID of the only Amazon Web Services resource that you want to trigger an
    /// evaluation for the rule. If you specify a resource ID, you must
    /// specify one resource type for
    /// <code>ComplianceResourceTypes</code>.</p>
    pub compliance_resource_id: std::option::Option<std::string::String>,
}
impl Scope {
    /// <p>The resource types of only those Amazon Web Services resources that you want to
    /// trigger an evaluation for the rule. You can only specify one type if
    /// you also specify a resource ID for
    /// <code>ComplianceResourceId</code>.</p>
    pub fn compliance_resource_types(&self) -> std::option::Option<&[std::string::String]> {
        self.compliance_resource_types.as_deref()
    }
    /// <p>The tag key that is applied to only those Amazon Web Services resources that
    /// you want to trigger an evaluation for the rule.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
    /// <p>The tag value applied to only those Amazon Web Services resources that you want
    /// to trigger an evaluation for the rule. If you specify a value for
    /// <code>TagValue</code>, you must also specify a value for
    /// <code>TagKey</code>.</p>
    pub fn tag_value(&self) -> std::option::Option<&str> {
        self.tag_value.as_deref()
    }
    /// <p>The ID of the only Amazon Web Services resource that you want to trigger an
    /// evaluation for the rule. If you specify a resource ID, you must
    /// specify one resource type for
    /// <code>ComplianceResourceTypes</code>.</p>
    pub fn compliance_resource_id(&self) -> std::option::Option<&str> {
        self.compliance_resource_id.as_deref()
    }
}
impl std::fmt::Debug for Scope {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Scope");
        formatter.field("compliance_resource_types", &self.compliance_resource_types);
        formatter.field("tag_key", &self.tag_key);
        formatter.field("tag_value", &self.tag_value);
        formatter.field("compliance_resource_id", &self.compliance_resource_id);
        formatter.finish()
    }
}
/// See [`Scope`](crate::model::Scope)
pub mod scope {
    /// A builder for [`Scope`](crate::model::Scope)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_resource_types:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_key: std::option::Option<std::string::String>,
        pub(crate) tag_value: std::option::Option<std::string::String>,
        pub(crate) compliance_resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `compliance_resource_types`.
        ///
        /// To override the contents of this collection use [`set_compliance_resource_types`](Self::set_compliance_resource_types).
        ///
        /// <p>The resource types of only those Amazon Web Services resources that you want to
        /// trigger an evaluation for the rule. You can only specify one type if
        /// you also specify a resource ID for
        /// <code>ComplianceResourceId</code>.</p>
        pub fn compliance_resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.compliance_resource_types.unwrap_or_default();
            v.push(input.into());
            self.compliance_resource_types = Some(v);
            self
        }
        /// <p>The resource types of only those Amazon Web Services resources that you want to
        /// trigger an evaluation for the rule. You can only specify one type if
        /// you also specify a resource ID for
        /// <code>ComplianceResourceId</code>.</p>
        pub fn set_compliance_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.compliance_resource_types = input;
            self
        }
        /// <p>The tag key that is applied to only those Amazon Web Services resources that
        /// you want to trigger an evaluation for the rule.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The tag key that is applied to only those Amazon Web Services resources that
        /// you want to trigger an evaluation for the rule.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// <p>The tag value applied to only those Amazon Web Services resources that you want
        /// to trigger an evaluation for the rule. If you specify a value for
        /// <code>TagValue</code>, you must also specify a value for
        /// <code>TagKey</code>.</p>
        pub fn tag_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_value = Some(input.into());
            self
        }
        /// <p>The tag value applied to only those Amazon Web Services resources that you want
        /// to trigger an evaluation for the rule. If you specify a value for
        /// <code>TagValue</code>, you must also specify a value for
        /// <code>TagKey</code>.</p>
        pub fn set_tag_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_value = input;
            self
        }
        /// <p>The ID of the only Amazon Web Services resource that you want to trigger an
        /// evaluation for the rule. If you specify a resource ID, you must
        /// specify one resource type for
        /// <code>ComplianceResourceTypes</code>.</p>
        pub fn compliance_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the only Amazon Web Services resource that you want to trigger an
        /// evaluation for the rule. If you specify a resource ID, you must
        /// specify one resource type for
        /// <code>ComplianceResourceTypes</code>.</p>
        pub fn set_compliance_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Scope`](crate::model::Scope)
        pub fn build(self) -> crate::model::Scope {
            crate::model::Scope {
                compliance_resource_types: self.compliance_resource_types,
                tag_key: self.tag_key,
                tag_value: self.tag_value,
                compliance_resource_id: self.compliance_resource_id,
            }
        }
    }
}
impl Scope {
    /// Creates a new builder-style object to manufacture [`Scope`](crate::model::Scope)
    pub fn builder() -> crate::model::scope::Builder {
        crate::model::scope::Builder::default()
    }
}

/// <p>An object that represents the authorizations granted to
/// aggregator accounts and regions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregationAuthorization {
    /// <p>The Amazon Resource Name (ARN) of the aggregation
    /// object.</p>
    pub aggregation_authorization_arn: std::option::Option<std::string::String>,
    /// <p>The 12-digit account ID of the account authorized to aggregate
    /// data.</p>
    pub authorized_account_id: std::option::Option<std::string::String>,
    /// <p>The region authorized to collect aggregated data.</p>
    pub authorized_aws_region: std::option::Option<std::string::String>,
    /// <p>The time stamp when the aggregation authorization was
    /// created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl AggregationAuthorization {
    /// <p>The Amazon Resource Name (ARN) of the aggregation
    /// object.</p>
    pub fn aggregation_authorization_arn(&self) -> std::option::Option<&str> {
        self.aggregation_authorization_arn.as_deref()
    }
    /// <p>The 12-digit account ID of the account authorized to aggregate
    /// data.</p>
    pub fn authorized_account_id(&self) -> std::option::Option<&str> {
        self.authorized_account_id.as_deref()
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn authorized_aws_region(&self) -> std::option::Option<&str> {
        self.authorized_aws_region.as_deref()
    }
    /// <p>The time stamp when the aggregation authorization was
    /// created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for AggregationAuthorization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregationAuthorization");
        formatter.field(
            "aggregation_authorization_arn",
            &self.aggregation_authorization_arn,
        );
        formatter.field("authorized_account_id", &self.authorized_account_id);
        formatter.field("authorized_aws_region", &self.authorized_aws_region);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`AggregationAuthorization`](crate::model::AggregationAuthorization)
pub mod aggregation_authorization {
    /// A builder for [`AggregationAuthorization`](crate::model::AggregationAuthorization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aggregation_authorization_arn: std::option::Option<std::string::String>,
        pub(crate) authorized_account_id: std::option::Option<std::string::String>,
        pub(crate) authorized_aws_region: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the aggregation
        /// object.</p>
        pub fn aggregation_authorization_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.aggregation_authorization_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the aggregation
        /// object.</p>
        pub fn set_aggregation_authorization_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aggregation_authorization_arn = input;
            self
        }
        /// <p>The 12-digit account ID of the account authorized to aggregate
        /// data.</p>
        pub fn authorized_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorized_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the account authorized to aggregate
        /// data.</p>
        pub fn set_authorized_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorized_account_id = input;
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn authorized_aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorized_aws_region = Some(input.into());
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn set_authorized_aws_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorized_aws_region = input;
            self
        }
        /// <p>The time stamp when the aggregation authorization was
        /// created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time stamp when the aggregation authorization was
        /// created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregationAuthorization`](crate::model::AggregationAuthorization)
        pub fn build(self) -> crate::model::AggregationAuthorization {
            crate::model::AggregationAuthorization {
                aggregation_authorization_arn: self.aggregation_authorization_arn,
                authorized_account_id: self.authorized_account_id,
                authorized_aws_region: self.authorized_aws_region,
                creation_time: self.creation_time,
            }
        }
    }
}
impl AggregationAuthorization {
    /// Creates a new builder-style object to manufacture [`AggregationAuthorization`](crate::model::AggregationAuthorization)
    pub fn builder() -> crate::model::aggregation_authorization::Builder {
        crate::model::aggregation_authorization::Builder::default()
    }
}

/// <p>Returns details of a specific query. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StoredQueryMetadata {
    /// <p>The ID of the query. </p>
    pub query_id: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
    pub query_arn: std::option::Option<std::string::String>,
    /// <p>The name of the query.</p>
    pub query_name: std::option::Option<std::string::String>,
    /// <p>A unique description for the query.</p>
    pub description: std::option::Option<std::string::String>,
}
impl StoredQueryMetadata {
    /// <p>The ID of the query. </p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
    pub fn query_arn(&self) -> std::option::Option<&str> {
        self.query_arn.as_deref()
    }
    /// <p>The name of the query.</p>
    pub fn query_name(&self) -> std::option::Option<&str> {
        self.query_name.as_deref()
    }
    /// <p>A unique description for the query.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for StoredQueryMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StoredQueryMetadata");
        formatter.field("query_id", &self.query_id);
        formatter.field("query_arn", &self.query_arn);
        formatter.field("query_name", &self.query_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`StoredQueryMetadata`](crate::model::StoredQueryMetadata)
pub mod stored_query_metadata {
    /// A builder for [`StoredQueryMetadata`](crate::model::StoredQueryMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_id: std::option::Option<std::string::String>,
        pub(crate) query_arn: std::option::Option<std::string::String>,
        pub(crate) query_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the query. </p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of the query. </p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
        pub fn query_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>
        pub fn set_query_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_arn = input;
            self
        }
        /// <p>The name of the query.</p>
        pub fn query_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_name = Some(input.into());
            self
        }
        /// <p>The name of the query.</p>
        pub fn set_query_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_name = input;
            self
        }
        /// <p>A unique description for the query.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A unique description for the query.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`StoredQueryMetadata`](crate::model::StoredQueryMetadata)
        pub fn build(self) -> crate::model::StoredQueryMetadata {
            crate::model::StoredQueryMetadata {
                query_id: self.query_id,
                query_arn: self.query_arn,
                query_name: self.query_name,
                description: self.description,
            }
        }
    }
}
impl StoredQueryMetadata {
    /// Creates a new builder-style object to manufacture [`StoredQueryMetadata`](crate::model::StoredQueryMetadata)
    pub fn builder() -> crate::model::stored_query_metadata::Builder {
        crate::model::stored_query_metadata::Builder::default()
    }
}

/// <p>The details that identify a resource that is discovered by Config, including the resource type, ID, and (if available) the
/// custom resource name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceIdentifier {
    /// <p>The type of resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The ID of the resource (for example,
    /// <code>sg-xxxxxx</code>).</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The custom name of the resource (if available).</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The time that the resource was deleted.</p>
    pub resource_deletion_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ResourceIdentifier {
    /// <p>The type of resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the resource (for example,
    /// <code>sg-xxxxxx</code>).</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The custom name of the resource (if available).</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The time that the resource was deleted.</p>
    pub fn resource_deletion_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.resource_deletion_time.as_ref()
    }
}
impl std::fmt::Debug for ResourceIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceIdentifier");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_name", &self.resource_name);
        formatter.field("resource_deletion_time", &self.resource_deletion_time);
        formatter.finish()
    }
}
/// See [`ResourceIdentifier`](crate::model::ResourceIdentifier)
pub mod resource_identifier {
    /// A builder for [`ResourceIdentifier`](crate::model::ResourceIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) resource_deletion_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The type of resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource (for example,
        /// <code>sg-xxxxxx</code>).</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource (for example,
        /// <code>sg-xxxxxx</code>).</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The custom name of the resource (if available).</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The custom name of the resource (if available).</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The time that the resource was deleted.</p>
        pub fn resource_deletion_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.resource_deletion_time = Some(input);
            self
        }
        /// <p>The time that the resource was deleted.</p>
        pub fn set_resource_deletion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.resource_deletion_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceIdentifier`](crate::model::ResourceIdentifier)
        pub fn build(self) -> crate::model::ResourceIdentifier {
            crate::model::ResourceIdentifier {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                resource_name: self.resource_name,
                resource_deletion_time: self.resource_deletion_time,
            }
        }
    }
}
impl ResourceIdentifier {
    /// Creates a new builder-style object to manufacture [`ResourceIdentifier`](crate::model::ResourceIdentifier)
    pub fn builder() -> crate::model::resource_identifier::Builder {
        crate::model::resource_identifier::Builder::default()
    }
}

/// <p>The details that identify a resource that is collected by Config aggregator, including the resource type, ID, (if available) the custom resource name, the source account, and source region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregateResourceIdentifier {
    /// <p>The 12-digit account ID of the source account.</p>
    pub source_account_id: std::option::Option<std::string::String>,
    /// <p>The source region where data is aggregated.</p>
    pub source_region: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the Amazon Web Services resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The name of the Amazon Web Services resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl AggregateResourceIdentifier {
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn source_account_id(&self) -> std::option::Option<&str> {
        self.source_account_id.as_deref()
    }
    /// <p>The source region where data is aggregated.</p>
    pub fn source_region(&self) -> std::option::Option<&str> {
        self.source_region.as_deref()
    }
    /// <p>The ID of the Amazon Web Services resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the Amazon Web Services resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The name of the Amazon Web Services resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for AggregateResourceIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregateResourceIdentifier");
        formatter.field("source_account_id", &self.source_account_id);
        formatter.field("source_region", &self.source_region);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
/// See [`AggregateResourceIdentifier`](crate::model::AggregateResourceIdentifier)
pub mod aggregate_resource_identifier {
    /// A builder for [`AggregateResourceIdentifier`](crate::model::AggregateResourceIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_account_id: std::option::Option<std::string::String>,
        pub(crate) source_region: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn source_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn set_source_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_account_id = input;
            self
        }
        /// <p>The source region where data is aggregated.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_region = Some(input.into());
            self
        }
        /// <p>The source region where data is aggregated.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_region = input;
            self
        }
        /// <p>The ID of the Amazon Web Services resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the Amazon Web Services resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the Amazon Web Services resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The name of the Amazon Web Services resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregateResourceIdentifier`](crate::model::AggregateResourceIdentifier)
        pub fn build(self) -> crate::model::AggregateResourceIdentifier {
            crate::model::AggregateResourceIdentifier {
                source_account_id: self.source_account_id,
                source_region: self.source_region,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                resource_name: self.resource_name,
            }
        }
    }
}
impl AggregateResourceIdentifier {
    /// Creates a new builder-style object to manufacture [`AggregateResourceIdentifier`](crate::model::AggregateResourceIdentifier)
    pub fn builder() -> crate::model::aggregate_resource_identifier::Builder {
        crate::model::aggregate_resource_identifier::Builder::default()
    }
}

/// <p>Filters the results by resource account ID, region, resource ID, and resource name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceFilters {
    /// <p>The 12-digit source account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The name of the resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The source region.</p>
    pub region: std::option::Option<std::string::String>,
}
impl ResourceFilters {
    /// <p>The 12-digit source account ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The name of the resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The source region.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl std::fmt::Debug for ResourceFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceFilters");
        formatter.field("account_id", &self.account_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_name", &self.resource_name);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`ResourceFilters`](crate::model::ResourceFilters)
pub mod resource_filters {
    /// A builder for [`ResourceFilters`](crate::model::ResourceFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 12-digit source account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit source account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The source region.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The source region.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceFilters`](crate::model::ResourceFilters)
        pub fn build(self) -> crate::model::ResourceFilters {
            crate::model::ResourceFilters {
                account_id: self.account_id,
                resource_id: self.resource_id,
                resource_name: self.resource_name,
                region: self.region,
            }
        }
    }
}
impl ResourceFilters {
    /// Creates a new builder-style object to manufacture [`ResourceFilters`](crate::model::ResourceFilters)
    pub fn builder() -> crate::model::resource_filters::Builder {
        crate::model::resource_filters::Builder::default()
    }
}

/// <p>A list that contains detailed configurations of a specified
/// resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationItem {
    /// <p>The version number of the resource configuration.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The 12-digit Amazon Web Services account ID associated with the
    /// resource.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The time when the configuration recording was
    /// initiated.</p>
    pub configuration_item_capture_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The configuration item status. The valid values are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated</p>
    /// </li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered</p>
    /// </li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
    /// </li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p>
    /// </li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The CIs do not incur any cost.</p>
    /// </note>
    pub configuration_item_status: std::option::Option<crate::model::ConfigurationItemStatus>,
    /// <p>An identifier that indicates the ordering of the configuration
    /// items of a resource.</p>
    pub configuration_state_id: std::option::Option<std::string::String>,
    /// <p>Unique MD5 hash that represents the configuration item's
    /// state.</p>
    /// <p>You can use MD5 hash to compare the states of two or more
    /// configuration items that are associated with the same
    /// resource.</p>
    pub configuration_item_md5_hash: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) associated with the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of Amazon Web Services resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The ID of the resource (for example,
    /// <code>sg-xxxxxx</code>).</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The custom name of the resource, if available.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The region where the resource resides.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>The Availability Zone associated with the resource.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The time stamp when the resource was created.</p>
    pub resource_creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A mapping of key value tags associated with the
    /// resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of CloudTrail event IDs.</p>
    /// <p>A populated field indicates that the current configuration was
    /// initiated by the events recorded in the CloudTrail log. For more
    /// information about CloudTrail, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">What Is CloudTrail</a>.</p>
    /// <p>An empty field indicates that the current configuration was not
    /// initiated by any event. As of Version 1.3, the relatedEvents field is empty.
    /// You can access the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html">LookupEvents API</a> in the <i>CloudTrail API Reference</i> to retrieve the events for the resource.</p>
    pub related_events: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of related Amazon Web Services resources.</p>
    pub relationships: std::option::Option<std::vec::Vec<crate::model::Relationship>>,
    /// <p>The description of the resource configuration.</p>
    pub configuration: std::option::Option<std::string::String>,
    /// <p>Configuration attributes that Config returns for certain
    /// resource types to supplement the information returned for the
    /// <code>configuration</code> parameter.</p>
    pub supplementary_configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ConfigurationItem {
    /// <p>The version number of the resource configuration.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The 12-digit Amazon Web Services account ID associated with the
    /// resource.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The time when the configuration recording was
    /// initiated.</p>
    pub fn configuration_item_capture_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.configuration_item_capture_time.as_ref()
    }
    /// <p>The configuration item status. The valid values are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated</p>
    /// </li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered</p>
    /// </li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
    /// </li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p>
    /// </li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The CIs do not incur any cost.</p>
    /// </note>
    pub fn configuration_item_status(
        &self,
    ) -> std::option::Option<&crate::model::ConfigurationItemStatus> {
        self.configuration_item_status.as_ref()
    }
    /// <p>An identifier that indicates the ordering of the configuration
    /// items of a resource.</p>
    pub fn configuration_state_id(&self) -> std::option::Option<&str> {
        self.configuration_state_id.as_deref()
    }
    /// <p>Unique MD5 hash that represents the configuration item's
    /// state.</p>
    /// <p>You can use MD5 hash to compare the states of two or more
    /// configuration items that are associated with the same
    /// resource.</p>
    pub fn configuration_item_md5_hash(&self) -> std::option::Option<&str> {
        self.configuration_item_md5_hash.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) associated with the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of Amazon Web Services resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the resource (for example,
    /// <code>sg-xxxxxx</code>).</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The custom name of the resource, if available.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The region where the resource resides.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>The Availability Zone associated with the resource.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The time stamp when the resource was created.</p>
    pub fn resource_creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.resource_creation_time.as_ref()
    }
    /// <p>A mapping of key value tags associated with the
    /// resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A list of CloudTrail event IDs.</p>
    /// <p>A populated field indicates that the current configuration was
    /// initiated by the events recorded in the CloudTrail log. For more
    /// information about CloudTrail, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">What Is CloudTrail</a>.</p>
    /// <p>An empty field indicates that the current configuration was not
    /// initiated by any event. As of Version 1.3, the relatedEvents field is empty.
    /// You can access the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html">LookupEvents API</a> in the <i>CloudTrail API Reference</i> to retrieve the events for the resource.</p>
    pub fn related_events(&self) -> std::option::Option<&[std::string::String]> {
        self.related_events.as_deref()
    }
    /// <p>A list of related Amazon Web Services resources.</p>
    pub fn relationships(&self) -> std::option::Option<&[crate::model::Relationship]> {
        self.relationships.as_deref()
    }
    /// <p>The description of the resource configuration.</p>
    pub fn configuration(&self) -> std::option::Option<&str> {
        self.configuration.as_deref()
    }
    /// <p>Configuration attributes that Config returns for certain
    /// resource types to supplement the information returned for the
    /// <code>configuration</code> parameter.</p>
    pub fn supplementary_configuration(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.supplementary_configuration.as_ref()
    }
}
impl std::fmt::Debug for ConfigurationItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationItem");
        formatter.field("version", &self.version);
        formatter.field("account_id", &self.account_id);
        formatter.field(
            "configuration_item_capture_time",
            &self.configuration_item_capture_time,
        );
        formatter.field("configuration_item_status", &self.configuration_item_status);
        formatter.field("configuration_state_id", &self.configuration_state_id);
        formatter.field(
            "configuration_item_md5_hash",
            &self.configuration_item_md5_hash,
        );
        formatter.field("arn", &self.arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_name", &self.resource_name);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("resource_creation_time", &self.resource_creation_time);
        formatter.field("tags", &self.tags);
        formatter.field("related_events", &self.related_events);
        formatter.field("relationships", &self.relationships);
        formatter.field("configuration", &self.configuration);
        formatter.field(
            "supplementary_configuration",
            &self.supplementary_configuration,
        );
        formatter.finish()
    }
}
/// See [`ConfigurationItem`](crate::model::ConfigurationItem)
pub mod configuration_item {
    /// A builder for [`ConfigurationItem`](crate::model::ConfigurationItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) configuration_item_capture_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) configuration_item_status:
            std::option::Option<crate::model::ConfigurationItemStatus>,
        pub(crate) configuration_state_id: std::option::Option<std::string::String>,
        pub(crate) configuration_item_md5_hash: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) resource_creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) related_events: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) relationships: std::option::Option<std::vec::Vec<crate::model::Relationship>>,
        pub(crate) configuration: std::option::Option<std::string::String>,
        pub(crate) supplementary_configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The version number of the resource configuration.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version number of the resource configuration.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID associated with the
        /// resource.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID associated with the
        /// resource.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The time when the configuration recording was
        /// initiated.</p>
        pub fn configuration_item_capture_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.configuration_item_capture_time = Some(input);
            self
        }
        /// <p>The time when the configuration recording was
        /// initiated.</p>
        pub fn set_configuration_item_capture_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.configuration_item_capture_time = input;
            self
        }
        /// <p>The configuration item status. The valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>OK – The resource configuration has been updated</p>
        /// </li>
        /// <li>
        /// <p>ResourceDiscovered – The resource was newly discovered</p>
        /// </li>
        /// <li>
        /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
        /// </li>
        /// <li>
        /// <p>ResourceDeleted – The resource was deleted</p>
        /// </li>
        /// <li>
        /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The CIs do not incur any cost.</p>
        /// </note>
        pub fn configuration_item_status(
            mut self,
            input: crate::model::ConfigurationItemStatus,
        ) -> Self {
            self.configuration_item_status = Some(input);
            self
        }
        /// <p>The configuration item status. The valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>OK – The resource configuration has been updated</p>
        /// </li>
        /// <li>
        /// <p>ResourceDiscovered – The resource was newly discovered</p>
        /// </li>
        /// <li>
        /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
        /// </li>
        /// <li>
        /// <p>ResourceDeleted – The resource was deleted</p>
        /// </li>
        /// <li>
        /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The CIs do not incur any cost.</p>
        /// </note>
        pub fn set_configuration_item_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationItemStatus>,
        ) -> Self {
            self.configuration_item_status = input;
            self
        }
        /// <p>An identifier that indicates the ordering of the configuration
        /// items of a resource.</p>
        pub fn configuration_state_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_state_id = Some(input.into());
            self
        }
        /// <p>An identifier that indicates the ordering of the configuration
        /// items of a resource.</p>
        pub fn set_configuration_state_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_state_id = input;
            self
        }
        /// <p>Unique MD5 hash that represents the configuration item's
        /// state.</p>
        /// <p>You can use MD5 hash to compare the states of two or more
        /// configuration items that are associated with the same
        /// resource.</p>
        pub fn configuration_item_md5_hash(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_item_md5_hash = Some(input.into());
            self
        }
        /// <p>Unique MD5 hash that represents the configuration item's
        /// state.</p>
        /// <p>You can use MD5 hash to compare the states of two or more
        /// configuration items that are associated with the same
        /// resource.</p>
        pub fn set_configuration_item_md5_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_item_md5_hash = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) associated with the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) associated with the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of Amazon Web Services resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of Amazon Web Services resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource (for example,
        /// <code>sg-xxxxxx</code>).</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource (for example,
        /// <code>sg-xxxxxx</code>).</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The custom name of the resource, if available.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The custom name of the resource, if available.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The region where the resource resides.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The region where the resource resides.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>The Availability Zone associated with the resource.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone associated with the resource.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The time stamp when the resource was created.</p>
        pub fn resource_creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.resource_creation_time = Some(input);
            self
        }
        /// <p>The time stamp when the resource was created.</p>
        pub fn set_resource_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.resource_creation_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A mapping of key value tags associated with the
        /// resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A mapping of key value tags associated with the
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `related_events`.
        ///
        /// To override the contents of this collection use [`set_related_events`](Self::set_related_events).
        ///
        /// <p>A list of CloudTrail event IDs.</p>
        /// <p>A populated field indicates that the current configuration was
        /// initiated by the events recorded in the CloudTrail log. For more
        /// information about CloudTrail, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">What Is CloudTrail</a>.</p>
        /// <p>An empty field indicates that the current configuration was not
        /// initiated by any event. As of Version 1.3, the relatedEvents field is empty.
        /// You can access the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html">LookupEvents API</a> in the <i>CloudTrail API Reference</i> to retrieve the events for the resource.</p>
        pub fn related_events(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.related_events.unwrap_or_default();
            v.push(input.into());
            self.related_events = Some(v);
            self
        }
        /// <p>A list of CloudTrail event IDs.</p>
        /// <p>A populated field indicates that the current configuration was
        /// initiated by the events recorded in the CloudTrail log. For more
        /// information about CloudTrail, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">What Is CloudTrail</a>.</p>
        /// <p>An empty field indicates that the current configuration was not
        /// initiated by any event. As of Version 1.3, the relatedEvents field is empty.
        /// You can access the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html">LookupEvents API</a> in the <i>CloudTrail API Reference</i> to retrieve the events for the resource.</p>
        pub fn set_related_events(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.related_events = input;
            self
        }
        /// Appends an item to `relationships`.
        ///
        /// To override the contents of this collection use [`set_relationships`](Self::set_relationships).
        ///
        /// <p>A list of related Amazon Web Services resources.</p>
        pub fn relationships(mut self, input: impl Into<crate::model::Relationship>) -> Self {
            let mut v = self.relationships.unwrap_or_default();
            v.push(input.into());
            self.relationships = Some(v);
            self
        }
        /// <p>A list of related Amazon Web Services resources.</p>
        pub fn set_relationships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Relationship>>,
        ) -> Self {
            self.relationships = input;
            self
        }
        /// <p>The description of the resource configuration.</p>
        pub fn configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration = Some(input.into());
            self
        }
        /// <p>The description of the resource configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Adds a key-value pair to `supplementary_configuration`.
        ///
        /// To override the contents of this collection use [`set_supplementary_configuration`](Self::set_supplementary_configuration).
        ///
        /// <p>Configuration attributes that Config returns for certain
        /// resource types to supplement the information returned for the
        /// <code>configuration</code> parameter.</p>
        pub fn supplementary_configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.supplementary_configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.supplementary_configuration = Some(hash_map);
            self
        }
        /// <p>Configuration attributes that Config returns for certain
        /// resource types to supplement the information returned for the
        /// <code>configuration</code> parameter.</p>
        pub fn set_supplementary_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.supplementary_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationItem`](crate::model::ConfigurationItem)
        pub fn build(self) -> crate::model::ConfigurationItem {
            crate::model::ConfigurationItem {
                version: self.version,
                account_id: self.account_id,
                configuration_item_capture_time: self.configuration_item_capture_time,
                configuration_item_status: self.configuration_item_status,
                configuration_state_id: self.configuration_state_id,
                configuration_item_md5_hash: self.configuration_item_md5_hash,
                arn: self.arn,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                resource_name: self.resource_name,
                aws_region: self.aws_region,
                availability_zone: self.availability_zone,
                resource_creation_time: self.resource_creation_time,
                tags: self.tags,
                related_events: self.related_events,
                relationships: self.relationships,
                configuration: self.configuration,
                supplementary_configuration: self.supplementary_configuration,
            }
        }
    }
}
impl ConfigurationItem {
    /// Creates a new builder-style object to manufacture [`ConfigurationItem`](crate::model::ConfigurationItem)
    pub fn builder() -> crate::model::configuration_item::Builder {
        crate::model::configuration_item::Builder::default()
    }
}

/// <p>The relationship of the related resource to the main
/// resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Relationship {
    /// <p>The resource type of the related resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The ID of the related resource (for example,
    /// <code>sg-xxxxxx</code>).</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The custom name of the related resource, if
    /// available.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The type of relationship with the related resource.</p>
    pub relationship_name: std::option::Option<std::string::String>,
}
impl Relationship {
    /// <p>The resource type of the related resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the related resource (for example,
    /// <code>sg-xxxxxx</code>).</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The custom name of the related resource, if
    /// available.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The type of relationship with the related resource.</p>
    pub fn relationship_name(&self) -> std::option::Option<&str> {
        self.relationship_name.as_deref()
    }
}
impl std::fmt::Debug for Relationship {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Relationship");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_name", &self.resource_name);
        formatter.field("relationship_name", &self.relationship_name);
        formatter.finish()
    }
}
/// See [`Relationship`](crate::model::Relationship)
pub mod relationship {
    /// A builder for [`Relationship`](crate::model::Relationship)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) relationship_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource type of the related resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type of the related resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the related resource (for example,
        /// <code>sg-xxxxxx</code>).</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the related resource (for example,
        /// <code>sg-xxxxxx</code>).</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The custom name of the related resource, if
        /// available.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The custom name of the related resource, if
        /// available.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The type of relationship with the related resource.</p>
        pub fn relationship_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.relationship_name = Some(input.into());
            self
        }
        /// <p>The type of relationship with the related resource.</p>
        pub fn set_relationship_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relationship_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Relationship`](crate::model::Relationship)
        pub fn build(self) -> crate::model::Relationship {
            crate::model::Relationship {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                resource_name: self.resource_name,
                relationship_name: self.relationship_name,
            }
        }
    }
}
impl Relationship {
    /// Creates a new builder-style object to manufacture [`Relationship`](crate::model::Relationship)
    pub fn builder() -> crate::model::relationship::Builder {
        crate::model::relationship::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationItemStatus {
    #[allow(missing_docs)] // documentation missing in model
    Ok,
    #[allow(missing_docs)] // documentation missing in model
    ResourceDeleted,
    #[allow(missing_docs)] // documentation missing in model
    ResourceDeletedNotRecorded,
    #[allow(missing_docs)] // documentation missing in model
    ResourceDiscovered,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotRecorded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationItemStatus {
    fn from(s: &str) -> Self {
        match s {
            "OK" => ConfigurationItemStatus::Ok,
            "ResourceDeleted" => ConfigurationItemStatus::ResourceDeleted,
            "ResourceDeletedNotRecorded" => ConfigurationItemStatus::ResourceDeletedNotRecorded,
            "ResourceDiscovered" => ConfigurationItemStatus::ResourceDiscovered,
            "ResourceNotRecorded" => ConfigurationItemStatus::ResourceNotRecorded,
            other => ConfigurationItemStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationItemStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationItemStatus::from(s))
    }
}
impl ConfigurationItemStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationItemStatus::Ok => "OK",
            ConfigurationItemStatus::ResourceDeleted => "ResourceDeleted",
            ConfigurationItemStatus::ResourceDeletedNotRecorded => "ResourceDeletedNotRecorded",
            ConfigurationItemStatus::ResourceDiscovered => "ResourceDiscovered",
            ConfigurationItemStatus::ResourceNotRecorded => "ResourceNotRecorded",
            ConfigurationItemStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "OK",
            "ResourceDeleted",
            "ResourceDeletedNotRecorded",
            "ResourceDiscovered",
            "ResourceNotRecorded",
        ]
    }
}
impl AsRef<str> for ConfigurationItemStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChronologicalOrder {
    #[allow(missing_docs)] // documentation missing in model
    Forward,
    #[allow(missing_docs)] // documentation missing in model
    Reverse,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChronologicalOrder {
    fn from(s: &str) -> Self {
        match s {
            "Forward" => ChronologicalOrder::Forward,
            "Reverse" => ChronologicalOrder::Reverse,
            other => ChronologicalOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChronologicalOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChronologicalOrder::from(s))
    }
}
impl ChronologicalOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChronologicalOrder::Forward => "Forward",
            ChronologicalOrder::Reverse => "Reverse",
            ChronologicalOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Forward", "Reverse"]
    }
}
impl AsRef<str> for ChronologicalOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Organization conformance pack creation or deletion status in each member account.
/// This includes the name of the conformance pack, the status, error code and error message
/// when the conformance pack creation or deletion failed. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationConformancePackDetailedStatus {
    /// <p>The 12-digit account ID of a member account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of conformance pack deployed in the member account.</p>
    pub conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>Indicates deployment status for conformance pack in a member account.
    /// When master account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account.
    /// When master account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account.   
    /// Conformance pack status is deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
    /// </p>
    /// <p> Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::OrganizationResourceDetailedStatus>,
    /// <p>An error code that is returned when conformance pack creation or
    /// deletion failed in the member account. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>An error message indicating that conformance pack account creation or deletion
    /// has failed due to an error in the member account. </p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The timestamp of the last status update.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl OrganizationConformancePackDetailedStatus {
    /// <p>The 12-digit account ID of a member account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of conformance pack deployed in the member account.</p>
    pub fn conformance_pack_name(&self) -> std::option::Option<&str> {
        self.conformance_pack_name.as_deref()
    }
    /// <p>Indicates deployment status for conformance pack in a member account.
    /// When master account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account.
    /// When master account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account.   
    /// Conformance pack status is deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
    /// </p>
    /// <p> Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::OrganizationResourceDetailedStatus> {
        self.status.as_ref()
    }
    /// <p>An error code that is returned when conformance pack creation or
    /// deletion failed in the member account. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>An error message indicating that conformance pack account creation or deletion
    /// has failed due to an error in the member account. </p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The timestamp of the last status update.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for OrganizationConformancePackDetailedStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationConformancePackDetailedStatus");
        formatter.field("account_id", &self.account_id);
        formatter.field("conformance_pack_name", &self.conformance_pack_name);
        formatter.field("status", &self.status);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`OrganizationConformancePackDetailedStatus`](crate::model::OrganizationConformancePackDetailedStatus)
pub mod organization_conformance_pack_detailed_status {
    /// A builder for [`OrganizationConformancePackDetailedStatus`](crate::model::OrganizationConformancePackDetailedStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OrganizationResourceDetailedStatus>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The 12-digit account ID of a member account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of a member account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of conformance pack deployed in the member account.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_name = Some(input.into());
            self
        }
        /// <p>The name of conformance pack deployed in the member account.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_name = input;
            self
        }
        /// <p>Indicates deployment status for conformance pack in a member account.
        /// When master account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account.
        /// When master account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account.   
        /// Conformance pack status is deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
        /// </p>
        /// <p> Config sets the state of the conformance pack to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::OrganizationResourceDetailedStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Indicates deployment status for conformance pack in a member account.
        /// When master account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account.
        /// When master account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account.   
        /// Conformance pack status is deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
        /// </p>
        /// <p> Config sets the state of the conformance pack to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OrganizationResourceDetailedStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>An error code that is returned when conformance pack creation or
        /// deletion failed in the member account. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>An error code that is returned when conformance pack creation or
        /// deletion failed in the member account. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>An error message indicating that conformance pack account creation or deletion
        /// has failed due to an error in the member account. </p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>An error message indicating that conformance pack account creation or deletion
        /// has failed due to an error in the member account. </p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The timestamp of the last status update.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The timestamp of the last status update.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationConformancePackDetailedStatus`](crate::model::OrganizationConformancePackDetailedStatus)
        pub fn build(self) -> crate::model::OrganizationConformancePackDetailedStatus {
            crate::model::OrganizationConformancePackDetailedStatus {
                account_id: self.account_id,
                conformance_pack_name: self.conformance_pack_name,
                status: self.status,
                error_code: self.error_code,
                error_message: self.error_message,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl OrganizationConformancePackDetailedStatus {
    /// Creates a new builder-style object to manufacture [`OrganizationConformancePackDetailedStatus`](crate::model::OrganizationConformancePackDetailedStatus)
    pub fn builder() -> crate::model::organization_conformance_pack_detailed_status::Builder {
        crate::model::organization_conformance_pack_detailed_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrganizationResourceDetailedStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    CreateSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateSuccessful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrganizationResourceDetailedStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => OrganizationResourceDetailedStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => OrganizationResourceDetailedStatus::CreateInProgress,
            "CREATE_SUCCESSFUL" => OrganizationResourceDetailedStatus::CreateSuccessful,
            "DELETE_FAILED" => OrganizationResourceDetailedStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => OrganizationResourceDetailedStatus::DeleteInProgress,
            "DELETE_SUCCESSFUL" => OrganizationResourceDetailedStatus::DeleteSuccessful,
            "UPDATE_FAILED" => OrganizationResourceDetailedStatus::UpdateFailed,
            "UPDATE_IN_PROGRESS" => OrganizationResourceDetailedStatus::UpdateInProgress,
            "UPDATE_SUCCESSFUL" => OrganizationResourceDetailedStatus::UpdateSuccessful,
            other => OrganizationResourceDetailedStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrganizationResourceDetailedStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrganizationResourceDetailedStatus::from(s))
    }
}
impl OrganizationResourceDetailedStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrganizationResourceDetailedStatus::CreateFailed => "CREATE_FAILED",
            OrganizationResourceDetailedStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            OrganizationResourceDetailedStatus::CreateSuccessful => "CREATE_SUCCESSFUL",
            OrganizationResourceDetailedStatus::DeleteFailed => "DELETE_FAILED",
            OrganizationResourceDetailedStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            OrganizationResourceDetailedStatus::DeleteSuccessful => "DELETE_SUCCESSFUL",
            OrganizationResourceDetailedStatus::UpdateFailed => "UPDATE_FAILED",
            OrganizationResourceDetailedStatus::UpdateInProgress => "UPDATE_IN_PROGRESS",
            OrganizationResourceDetailedStatus::UpdateSuccessful => "UPDATE_SUCCESSFUL",
            OrganizationResourceDetailedStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "CREATE_SUCCESSFUL",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "DELETE_SUCCESSFUL",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
            "UPDATE_SUCCESSFUL",
        ]
    }
}
impl AsRef<str> for OrganizationResourceDetailedStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Status filter object to filter results based on specific member account ID or status type for an organization conformance pack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationResourceDetailedStatusFilters {
    /// <p>The 12-digit account ID of the member account within an organization.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Indicates deployment status for conformance pack in a member account.
    /// When master account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account.
    /// When master account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account.   
    /// Conformance pack status is deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
    /// </p>
    /// <p> Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::OrganizationResourceDetailedStatus>,
}
impl OrganizationResourceDetailedStatusFilters {
    /// <p>The 12-digit account ID of the member account within an organization.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Indicates deployment status for conformance pack in a member account.
    /// When master account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account.
    /// When master account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account.   
    /// Conformance pack status is deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
    /// </p>
    /// <p> Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::OrganizationResourceDetailedStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for OrganizationResourceDetailedStatusFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationResourceDetailedStatusFilters");
        formatter.field("account_id", &self.account_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`OrganizationResourceDetailedStatusFilters`](crate::model::OrganizationResourceDetailedStatusFilters)
pub mod organization_resource_detailed_status_filters {
    /// A builder for [`OrganizationResourceDetailedStatusFilters`](crate::model::OrganizationResourceDetailedStatusFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OrganizationResourceDetailedStatus>,
    }
    impl Builder {
        /// <p>The 12-digit account ID of the member account within an organization.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the member account within an organization.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Indicates deployment status for conformance pack in a member account.
        /// When master account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account.
        /// When master account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account.   
        /// Conformance pack status is deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
        /// </p>
        /// <p> Config sets the state of the conformance pack to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::OrganizationResourceDetailedStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Indicates deployment status for conformance pack in a member account.
        /// When master account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account.
        /// When master account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account.   
        /// Conformance pack status is deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
        /// </p>
        /// <p> Config sets the state of the conformance pack to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OrganizationResourceDetailedStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationResourceDetailedStatusFilters`](crate::model::OrganizationResourceDetailedStatusFilters)
        pub fn build(self) -> crate::model::OrganizationResourceDetailedStatusFilters {
            crate::model::OrganizationResourceDetailedStatusFilters {
                account_id: self.account_id,
                status: self.status,
            }
        }
    }
}
impl OrganizationResourceDetailedStatusFilters {
    /// Creates a new builder-style object to manufacture [`OrganizationResourceDetailedStatusFilters`](crate::model::OrganizationResourceDetailedStatusFilters)
    pub fn builder() -> crate::model::organization_resource_detailed_status_filters::Builder {
        crate::model::organization_resource_detailed_status_filters::Builder::default()
    }
}

/// <p>Organization config rule creation or deletion status in each member account. This includes the name of the rule, the status, error code and error message when the rule creation or deletion failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberAccountStatus {
    /// <p>The 12-digit account ID of a member account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of config rule deployed in the member account.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>Indicates deployment status for config rule in the member account.
    /// When master account calls <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member account.
    /// When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config rule status is updated in the member account.   
    /// Config rule status is deleted when the master account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
    /// </p>
    /// <p> Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when config rule creation has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.</p>
    /// </li>
    /// </ul>
    pub member_account_rule_status: std::option::Option<crate::model::MemberAccountRuleStatus>,
    /// <p>An error code that is returned when config rule creation or deletion failed in the member account.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>An error message indicating that config rule account creation or deletion has failed due to an error in the member account.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The timestamp of the last status update.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl MemberAccountStatus {
    /// <p>The 12-digit account ID of a member account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of config rule deployed in the member account.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>Indicates deployment status for config rule in the member account.
    /// When master account calls <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member account.
    /// When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config rule status is updated in the member account.   
    /// Config rule status is deleted when the master account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
    /// </p>
    /// <p> Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when config rule creation has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.</p>
    /// </li>
    /// </ul>
    pub fn member_account_rule_status(
        &self,
    ) -> std::option::Option<&crate::model::MemberAccountRuleStatus> {
        self.member_account_rule_status.as_ref()
    }
    /// <p>An error code that is returned when config rule creation or deletion failed in the member account.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>An error message indicating that config rule account creation or deletion has failed due to an error in the member account.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The timestamp of the last status update.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for MemberAccountStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberAccountStatus");
        formatter.field("account_id", &self.account_id);
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field(
            "member_account_rule_status",
            &self.member_account_rule_status,
        );
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`MemberAccountStatus`](crate::model::MemberAccountStatus)
pub mod member_account_status {
    /// A builder for [`MemberAccountStatus`](crate::model::MemberAccountStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) member_account_rule_status:
            std::option::Option<crate::model::MemberAccountRuleStatus>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The 12-digit account ID of a member account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of a member account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of config rule deployed in the member account.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of config rule deployed in the member account.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>Indicates deployment status for config rule in the member account.
        /// When master account calls <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member account.
        /// When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config rule status is updated in the member account.   
        /// Config rule status is deleted when the master account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
        /// </p>
        /// <p> Config sets the state of the rule to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when config rule creation has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.</p>
        /// </li>
        /// </ul>
        pub fn member_account_rule_status(
            mut self,
            input: crate::model::MemberAccountRuleStatus,
        ) -> Self {
            self.member_account_rule_status = Some(input);
            self
        }
        /// <p>Indicates deployment status for config rule in the member account.
        /// When master account calls <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member account.
        /// When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config rule status is updated in the member account.   
        /// Config rule status is deleted when the master account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
        /// </p>
        /// <p> Config sets the state of the rule to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when config rule creation has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.</p>
        /// </li>
        /// </ul>
        pub fn set_member_account_rule_status(
            mut self,
            input: std::option::Option<crate::model::MemberAccountRuleStatus>,
        ) -> Self {
            self.member_account_rule_status = input;
            self
        }
        /// <p>An error code that is returned when config rule creation or deletion failed in the member account.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>An error code that is returned when config rule creation or deletion failed in the member account.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>An error message indicating that config rule account creation or deletion has failed due to an error in the member account.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>An error message indicating that config rule account creation or deletion has failed due to an error in the member account.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The timestamp of the last status update.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The timestamp of the last status update.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberAccountStatus`](crate::model::MemberAccountStatus)
        pub fn build(self) -> crate::model::MemberAccountStatus {
            crate::model::MemberAccountStatus {
                account_id: self.account_id,
                config_rule_name: self.config_rule_name,
                member_account_rule_status: self.member_account_rule_status,
                error_code: self.error_code,
                error_message: self.error_message,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl MemberAccountStatus {
    /// Creates a new builder-style object to manufacture [`MemberAccountStatus`](crate::model::MemberAccountStatus)
    pub fn builder() -> crate::model::member_account_status::Builder {
        crate::model::member_account_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MemberAccountRuleStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    CreateSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateSuccessful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MemberAccountRuleStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => MemberAccountRuleStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => MemberAccountRuleStatus::CreateInProgress,
            "CREATE_SUCCESSFUL" => MemberAccountRuleStatus::CreateSuccessful,
            "DELETE_FAILED" => MemberAccountRuleStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => MemberAccountRuleStatus::DeleteInProgress,
            "DELETE_SUCCESSFUL" => MemberAccountRuleStatus::DeleteSuccessful,
            "UPDATE_FAILED" => MemberAccountRuleStatus::UpdateFailed,
            "UPDATE_IN_PROGRESS" => MemberAccountRuleStatus::UpdateInProgress,
            "UPDATE_SUCCESSFUL" => MemberAccountRuleStatus::UpdateSuccessful,
            other => MemberAccountRuleStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MemberAccountRuleStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MemberAccountRuleStatus::from(s))
    }
}
impl MemberAccountRuleStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MemberAccountRuleStatus::CreateFailed => "CREATE_FAILED",
            MemberAccountRuleStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            MemberAccountRuleStatus::CreateSuccessful => "CREATE_SUCCESSFUL",
            MemberAccountRuleStatus::DeleteFailed => "DELETE_FAILED",
            MemberAccountRuleStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            MemberAccountRuleStatus::DeleteSuccessful => "DELETE_SUCCESSFUL",
            MemberAccountRuleStatus::UpdateFailed => "UPDATE_FAILED",
            MemberAccountRuleStatus::UpdateInProgress => "UPDATE_IN_PROGRESS",
            MemberAccountRuleStatus::UpdateSuccessful => "UPDATE_SUCCESSFUL",
            MemberAccountRuleStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "CREATE_SUCCESSFUL",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "DELETE_SUCCESSFUL",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
            "UPDATE_SUCCESSFUL",
        ]
    }
}
impl AsRef<str> for MemberAccountRuleStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Status filter object to filter results based on specific member account ID or status type for an organization config rule. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatusDetailFilters {
    /// <p>The 12-digit account ID of the member account within an organization.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Indicates deployment status for config rule in the member account.
    /// When master account calls <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member account.
    /// When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config rule status is updated in the member account.   
    /// Config rule status is deleted when the master account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
    /// </p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when config rule creation has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.</p>
    /// </li>
    /// </ul>
    pub member_account_rule_status: std::option::Option<crate::model::MemberAccountRuleStatus>,
}
impl StatusDetailFilters {
    /// <p>The 12-digit account ID of the member account within an organization.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Indicates deployment status for config rule in the member account.
    /// When master account calls <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member account.
    /// When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config rule status is updated in the member account.   
    /// Config rule status is deleted when the master account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
    /// </p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when config rule creation has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.</p>
    /// </li>
    /// </ul>
    pub fn member_account_rule_status(
        &self,
    ) -> std::option::Option<&crate::model::MemberAccountRuleStatus> {
        self.member_account_rule_status.as_ref()
    }
}
impl std::fmt::Debug for StatusDetailFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatusDetailFilters");
        formatter.field("account_id", &self.account_id);
        formatter.field(
            "member_account_rule_status",
            &self.member_account_rule_status,
        );
        formatter.finish()
    }
}
/// See [`StatusDetailFilters`](crate::model::StatusDetailFilters)
pub mod status_detail_filters {
    /// A builder for [`StatusDetailFilters`](crate::model::StatusDetailFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) member_account_rule_status:
            std::option::Option<crate::model::MemberAccountRuleStatus>,
    }
    impl Builder {
        /// <p>The 12-digit account ID of the member account within an organization.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the member account within an organization.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Indicates deployment status for config rule in the member account.
        /// When master account calls <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member account.
        /// When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config rule status is updated in the member account.   
        /// Config rule status is deleted when the master account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
        /// </p>
        /// <p>Config sets the state of the rule to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when config rule creation has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.</p>
        /// </li>
        /// </ul>
        pub fn member_account_rule_status(
            mut self,
            input: crate::model::MemberAccountRuleStatus,
        ) -> Self {
            self.member_account_rule_status = Some(input);
            self
        }
        /// <p>Indicates deployment status for config rule in the member account.
        /// When master account calls <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member account.
        /// When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config rule status is updated in the member account.   
        /// Config rule status is deleted when the master account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
        /// </p>
        /// <p>Config sets the state of the rule to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when config rule creation has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.</p>
        /// </li>
        /// </ul>
        pub fn set_member_account_rule_status(
            mut self,
            input: std::option::Option<crate::model::MemberAccountRuleStatus>,
        ) -> Self {
            self.member_account_rule_status = input;
            self
        }
        /// Consumes the builder and constructs a [`StatusDetailFilters`](crate::model::StatusDetailFilters)
        pub fn build(self) -> crate::model::StatusDetailFilters {
            crate::model::StatusDetailFilters {
                account_id: self.account_id,
                member_account_rule_status: self.member_account_rule_status,
            }
        }
    }
}
impl StatusDetailFilters {
    /// Creates a new builder-style object to manufacture [`StatusDetailFilters`](crate::model::StatusDetailFilters)
    pub fn builder() -> crate::model::status_detail_filters::Builder {
        crate::model::status_detail_filters::Builder::default()
    }
}

/// <p>An object that contains the resource type and the number of
/// resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceCount {
    /// <p>The resource type (for example,
    /// <code>"AWS::EC2::Instance"</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The number of resources.</p>
    pub count: i64,
}
impl ResourceCount {
    /// <p>The resource type (for example,
    /// <code>"AWS::EC2::Instance"</code>).</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The number of resources.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
}
impl std::fmt::Debug for ResourceCount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceCount");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`ResourceCount`](crate::model::ResourceCount)
pub mod resource_count {
    /// A builder for [`ResourceCount`](crate::model::ResourceCount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The resource type (for example,
        /// <code>"AWS::EC2::Instance"</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type (for example,
        /// <code>"AWS::EC2::Instance"</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The number of resources.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of resources.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceCount`](crate::model::ResourceCount)
        pub fn build(self) -> crate::model::ResourceCount {
            crate::model::ResourceCount {
                resource_type: self.resource_type,
                count: self.count.unwrap_or_default(),
            }
        }
    }
}
impl ResourceCount {
    /// Creates a new builder-style object to manufacture [`ResourceCount`](crate::model::ResourceCount)
    pub fn builder() -> crate::model::resource_count::Builder {
        crate::model::resource_count::Builder::default()
    }
}

/// <p>Summary includes the name and status of the conformance pack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConformancePackComplianceSummary {
    /// <p>The name of the conformance pack name.</p>
    pub conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>The status of the conformance pack. The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code> and <code>INSUFFICIENT_DATA</code>.</p>
    pub conformance_pack_compliance_status:
        std::option::Option<crate::model::ConformancePackComplianceType>,
}
impl ConformancePackComplianceSummary {
    /// <p>The name of the conformance pack name.</p>
    pub fn conformance_pack_name(&self) -> std::option::Option<&str> {
        self.conformance_pack_name.as_deref()
    }
    /// <p>The status of the conformance pack. The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code> and <code>INSUFFICIENT_DATA</code>.</p>
    pub fn conformance_pack_compliance_status(
        &self,
    ) -> std::option::Option<&crate::model::ConformancePackComplianceType> {
        self.conformance_pack_compliance_status.as_ref()
    }
}
impl std::fmt::Debug for ConformancePackComplianceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConformancePackComplianceSummary");
        formatter.field("conformance_pack_name", &self.conformance_pack_name);
        formatter.field(
            "conformance_pack_compliance_status",
            &self.conformance_pack_compliance_status,
        );
        formatter.finish()
    }
}
/// See [`ConformancePackComplianceSummary`](crate::model::ConformancePackComplianceSummary)
pub mod conformance_pack_compliance_summary {
    /// A builder for [`ConformancePackComplianceSummary`](crate::model::ConformancePackComplianceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_compliance_status:
            std::option::Option<crate::model::ConformancePackComplianceType>,
    }
    impl Builder {
        /// <p>The name of the conformance pack name.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_name = Some(input.into());
            self
        }
        /// <p>The name of the conformance pack name.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_name = input;
            self
        }
        /// <p>The status of the conformance pack. The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code> and <code>INSUFFICIENT_DATA</code>.</p>
        pub fn conformance_pack_compliance_status(
            mut self,
            input: crate::model::ConformancePackComplianceType,
        ) -> Self {
            self.conformance_pack_compliance_status = Some(input);
            self
        }
        /// <p>The status of the conformance pack. The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code> and <code>INSUFFICIENT_DATA</code>.</p>
        pub fn set_conformance_pack_compliance_status(
            mut self,
            input: std::option::Option<crate::model::ConformancePackComplianceType>,
        ) -> Self {
            self.conformance_pack_compliance_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ConformancePackComplianceSummary`](crate::model::ConformancePackComplianceSummary)
        pub fn build(self) -> crate::model::ConformancePackComplianceSummary {
            crate::model::ConformancePackComplianceSummary {
                conformance_pack_name: self.conformance_pack_name,
                conformance_pack_compliance_status: self.conformance_pack_compliance_status,
            }
        }
    }
}
impl ConformancePackComplianceSummary {
    /// Creates a new builder-style object to manufacture [`ConformancePackComplianceSummary`](crate::model::ConformancePackComplianceSummary)
    pub fn builder() -> crate::model::conformance_pack_compliance_summary::Builder {
        crate::model::conformance_pack_compliance_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConformancePackComplianceType {
    #[allow(missing_docs)] // documentation missing in model
    Compliant,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientData,
    #[allow(missing_docs)] // documentation missing in model
    NonCompliant,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConformancePackComplianceType {
    fn from(s: &str) -> Self {
        match s {
            "COMPLIANT" => ConformancePackComplianceType::Compliant,
            "INSUFFICIENT_DATA" => ConformancePackComplianceType::InsufficientData,
            "NON_COMPLIANT" => ConformancePackComplianceType::NonCompliant,
            other => ConformancePackComplianceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConformancePackComplianceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConformancePackComplianceType::from(s))
    }
}
impl ConformancePackComplianceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConformancePackComplianceType::Compliant => "COMPLIANT",
            ConformancePackComplianceType::InsufficientData => "INSUFFICIENT_DATA",
            ConformancePackComplianceType::NonCompliant => "NON_COMPLIANT",
            ConformancePackComplianceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLIANT", "INSUFFICIENT_DATA", "NON_COMPLIANT"]
    }
}
impl AsRef<str> for ConformancePackComplianceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of a conformance pack evaluation. Provides Config rule and Amazon Web Services resource type that was evaluated, the compliance of the conformance pack, related time stamps, and supplementary information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConformancePackEvaluationResult {
    /// <p>The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
    pub compliance_type: std::option::Option<crate::model::ConformancePackComplianceType>,
    /// <p>Uniquely identifies an evaluation result.</p>
    pub evaluation_result_identifier: std::option::Option<crate::model::EvaluationResultIdentifier>,
    /// <p>The time when Config rule evaluated Amazon Web Services resource.</p>
    pub config_rule_invoked_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when Config recorded the evaluation result. </p>
    pub result_recorded_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Supplementary information about how the evaluation determined the compliance. </p>
    pub annotation: std::option::Option<std::string::String>,
}
impl ConformancePackEvaluationResult {
    /// <p>The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
    pub fn compliance_type(
        &self,
    ) -> std::option::Option<&crate::model::ConformancePackComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>Uniquely identifies an evaluation result.</p>
    pub fn evaluation_result_identifier(
        &self,
    ) -> std::option::Option<&crate::model::EvaluationResultIdentifier> {
        self.evaluation_result_identifier.as_ref()
    }
    /// <p>The time when Config rule evaluated Amazon Web Services resource.</p>
    pub fn config_rule_invoked_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.config_rule_invoked_time.as_ref()
    }
    /// <p>The time when Config recorded the evaluation result. </p>
    pub fn result_recorded_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.result_recorded_time.as_ref()
    }
    /// <p>Supplementary information about how the evaluation determined the compliance. </p>
    pub fn annotation(&self) -> std::option::Option<&str> {
        self.annotation.as_deref()
    }
}
impl std::fmt::Debug for ConformancePackEvaluationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConformancePackEvaluationResult");
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field(
            "evaluation_result_identifier",
            &self.evaluation_result_identifier,
        );
        formatter.field("config_rule_invoked_time", &self.config_rule_invoked_time);
        formatter.field("result_recorded_time", &self.result_recorded_time);
        formatter.field("annotation", &self.annotation);
        formatter.finish()
    }
}
/// See [`ConformancePackEvaluationResult`](crate::model::ConformancePackEvaluationResult)
pub mod conformance_pack_evaluation_result {
    /// A builder for [`ConformancePackEvaluationResult`](crate::model::ConformancePackEvaluationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_type:
            std::option::Option<crate::model::ConformancePackComplianceType>,
        pub(crate) evaluation_result_identifier:
            std::option::Option<crate::model::EvaluationResultIdentifier>,
        pub(crate) config_rule_invoked_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) result_recorded_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) annotation: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
        pub fn compliance_type(
            mut self,
            input: crate::model::ConformancePackComplianceType,
        ) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ConformancePackComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>Uniquely identifies an evaluation result.</p>
        pub fn evaluation_result_identifier(
            mut self,
            input: crate::model::EvaluationResultIdentifier,
        ) -> Self {
            self.evaluation_result_identifier = Some(input);
            self
        }
        /// <p>Uniquely identifies an evaluation result.</p>
        pub fn set_evaluation_result_identifier(
            mut self,
            input: std::option::Option<crate::model::EvaluationResultIdentifier>,
        ) -> Self {
            self.evaluation_result_identifier = input;
            self
        }
        /// <p>The time when Config rule evaluated Amazon Web Services resource.</p>
        pub fn config_rule_invoked_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.config_rule_invoked_time = Some(input);
            self
        }
        /// <p>The time when Config rule evaluated Amazon Web Services resource.</p>
        pub fn set_config_rule_invoked_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.config_rule_invoked_time = input;
            self
        }
        /// <p>The time when Config recorded the evaluation result. </p>
        pub fn result_recorded_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.result_recorded_time = Some(input);
            self
        }
        /// <p>The time when Config recorded the evaluation result. </p>
        pub fn set_result_recorded_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.result_recorded_time = input;
            self
        }
        /// <p>Supplementary information about how the evaluation determined the compliance. </p>
        pub fn annotation(mut self, input: impl Into<std::string::String>) -> Self {
            self.annotation = Some(input.into());
            self
        }
        /// <p>Supplementary information about how the evaluation determined the compliance. </p>
        pub fn set_annotation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.annotation = input;
            self
        }
        /// Consumes the builder and constructs a [`ConformancePackEvaluationResult`](crate::model::ConformancePackEvaluationResult)
        pub fn build(self) -> crate::model::ConformancePackEvaluationResult {
            crate::model::ConformancePackEvaluationResult {
                compliance_type: self.compliance_type,
                evaluation_result_identifier: self.evaluation_result_identifier,
                config_rule_invoked_time: self.config_rule_invoked_time,
                result_recorded_time: self.result_recorded_time,
                annotation: self.annotation,
            }
        }
    }
}
impl ConformancePackEvaluationResult {
    /// Creates a new builder-style object to manufacture [`ConformancePackEvaluationResult`](crate::model::ConformancePackEvaluationResult)
    pub fn builder() -> crate::model::conformance_pack_evaluation_result::Builder {
        crate::model::conformance_pack_evaluation_result::Builder::default()
    }
}

/// <p>Uniquely identifies an evaluation result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationResultIdentifier {
    /// <p>Identifies an Config rule used to evaluate an Amazon Web Services resource,
    /// and provides the type and ID of the evaluated resource.</p>
    pub evaluation_result_qualifier: std::option::Option<crate::model::EvaluationResultQualifier>,
    /// <p>The time of the event that triggered the evaluation of your Amazon Web Services
    /// resources. The time can indicate when Config delivered a
    /// configuration item change notification, or it can indicate when Config delivered the configuration snapshot, depending on which
    /// event triggered the evaluation.</p>
    pub ordering_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl EvaluationResultIdentifier {
    /// <p>Identifies an Config rule used to evaluate an Amazon Web Services resource,
    /// and provides the type and ID of the evaluated resource.</p>
    pub fn evaluation_result_qualifier(
        &self,
    ) -> std::option::Option<&crate::model::EvaluationResultQualifier> {
        self.evaluation_result_qualifier.as_ref()
    }
    /// <p>The time of the event that triggered the evaluation of your Amazon Web Services
    /// resources. The time can indicate when Config delivered a
    /// configuration item change notification, or it can indicate when Config delivered the configuration snapshot, depending on which
    /// event triggered the evaluation.</p>
    pub fn ordering_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.ordering_timestamp.as_ref()
    }
}
impl std::fmt::Debug for EvaluationResultIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationResultIdentifier");
        formatter.field(
            "evaluation_result_qualifier",
            &self.evaluation_result_qualifier,
        );
        formatter.field("ordering_timestamp", &self.ordering_timestamp);
        formatter.finish()
    }
}
/// See [`EvaluationResultIdentifier`](crate::model::EvaluationResultIdentifier)
pub mod evaluation_result_identifier {
    /// A builder for [`EvaluationResultIdentifier`](crate::model::EvaluationResultIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_result_qualifier:
            std::option::Option<crate::model::EvaluationResultQualifier>,
        pub(crate) ordering_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Identifies an Config rule used to evaluate an Amazon Web Services resource,
        /// and provides the type and ID of the evaluated resource.</p>
        pub fn evaluation_result_qualifier(
            mut self,
            input: crate::model::EvaluationResultQualifier,
        ) -> Self {
            self.evaluation_result_qualifier = Some(input);
            self
        }
        /// <p>Identifies an Config rule used to evaluate an Amazon Web Services resource,
        /// and provides the type and ID of the evaluated resource.</p>
        pub fn set_evaluation_result_qualifier(
            mut self,
            input: std::option::Option<crate::model::EvaluationResultQualifier>,
        ) -> Self {
            self.evaluation_result_qualifier = input;
            self
        }
        /// <p>The time of the event that triggered the evaluation of your Amazon Web Services
        /// resources. The time can indicate when Config delivered a
        /// configuration item change notification, or it can indicate when Config delivered the configuration snapshot, depending on which
        /// event triggered the evaluation.</p>
        pub fn ordering_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.ordering_timestamp = Some(input);
            self
        }
        /// <p>The time of the event that triggered the evaluation of your Amazon Web Services
        /// resources. The time can indicate when Config delivered a
        /// configuration item change notification, or it can indicate when Config delivered the configuration snapshot, depending on which
        /// event triggered the evaluation.</p>
        pub fn set_ordering_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.ordering_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationResultIdentifier`](crate::model::EvaluationResultIdentifier)
        pub fn build(self) -> crate::model::EvaluationResultIdentifier {
            crate::model::EvaluationResultIdentifier {
                evaluation_result_qualifier: self.evaluation_result_qualifier,
                ordering_timestamp: self.ordering_timestamp,
            }
        }
    }
}
impl EvaluationResultIdentifier {
    /// Creates a new builder-style object to manufacture [`EvaluationResultIdentifier`](crate::model::EvaluationResultIdentifier)
    pub fn builder() -> crate::model::evaluation_result_identifier::Builder {
        crate::model::evaluation_result_identifier::Builder::default()
    }
}

/// <p>Identifies an Config rule that evaluated an Amazon Web Services resource,
/// and provides the type and ID of the resource that the rule
/// evaluated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationResultQualifier {
    /// <p>The name of the Config rule that was used in the
    /// evaluation.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>The type of Amazon Web Services resource that was evaluated.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The ID of the evaluated Amazon Web Services resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl EvaluationResultQualifier {
    /// <p>The name of the Config rule that was used in the
    /// evaluation.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>The type of Amazon Web Services resource that was evaluated.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The ID of the evaluated Amazon Web Services resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for EvaluationResultQualifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationResultQualifier");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
/// See [`EvaluationResultQualifier`](crate::model::EvaluationResultQualifier)
pub mod evaluation_result_qualifier {
    /// A builder for [`EvaluationResultQualifier`](crate::model::EvaluationResultQualifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Config rule that was used in the
        /// evaluation.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule that was used in the
        /// evaluation.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>The type of Amazon Web Services resource that was evaluated.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services resource that was evaluated.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the evaluated Amazon Web Services resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the evaluated Amazon Web Services resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationResultQualifier`](crate::model::EvaluationResultQualifier)
        pub fn build(self) -> crate::model::EvaluationResultQualifier {
            crate::model::EvaluationResultQualifier {
                config_rule_name: self.config_rule_name,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
            }
        }
    }
}
impl EvaluationResultQualifier {
    /// Creates a new builder-style object to manufacture [`EvaluationResultQualifier`](crate::model::EvaluationResultQualifier)
    pub fn builder() -> crate::model::evaluation_result_qualifier::Builder {
        crate::model::evaluation_result_qualifier::Builder::default()
    }
}

/// <p>Filters a conformance pack by Config rule names, compliance types, Amazon Web Services resource types, and resource IDs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConformancePackEvaluationFilters {
    /// <p>Filters the results by Config rule names.</p>
    pub config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
    pub compliance_type: std::option::Option<crate::model::ConformancePackComplianceType>,
    /// <p>Filters the results by the resource type (for example, <code>"AWS::EC2::Instance"</code>). </p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Filters the results by resource IDs.</p>
    /// <note>
    /// <p>This is valid only when you provide resource type. If there is no resource type, you will see an error.</p>
    /// </note>
    pub resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ConformancePackEvaluationFilters {
    /// <p>Filters the results by Config rule names.</p>
    pub fn config_rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.config_rule_names.as_deref()
    }
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
    pub fn compliance_type(
        &self,
    ) -> std::option::Option<&crate::model::ConformancePackComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>Filters the results by the resource type (for example, <code>"AWS::EC2::Instance"</code>). </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Filters the results by resource IDs.</p>
    /// <note>
    /// <p>This is valid only when you provide resource type. If there is no resource type, you will see an error.</p>
    /// </note>
    pub fn resource_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_ids.as_deref()
    }
}
impl std::fmt::Debug for ConformancePackEvaluationFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConformancePackEvaluationFilters");
        formatter.field("config_rule_names", &self.config_rule_names);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_ids", &self.resource_ids);
        formatter.finish()
    }
}
/// See [`ConformancePackEvaluationFilters`](crate::model::ConformancePackEvaluationFilters)
pub mod conformance_pack_evaluation_filters {
    /// A builder for [`ConformancePackEvaluationFilters`](crate::model::ConformancePackEvaluationFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) compliance_type:
            std::option::Option<crate::model::ConformancePackComplianceType>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `config_rule_names`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>Filters the results by Config rule names.</p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.config_rule_names.unwrap_or_default();
            v.push(input.into());
            self.config_rule_names = Some(v);
            self
        }
        /// <p>Filters the results by Config rule names.</p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.config_rule_names = input;
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
        pub fn compliance_type(
            mut self,
            input: crate::model::ConformancePackComplianceType,
        ) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ConformancePackComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>Filters the results by the resource type (for example, <code>"AWS::EC2::Instance"</code>). </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Filters the results by the resource type (for example, <code>"AWS::EC2::Instance"</code>). </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_ids`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>Filters the results by resource IDs.</p>
        /// <note>
        /// <p>This is valid only when you provide resource type. If there is no resource type, you will see an error.</p>
        /// </note>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_ids.unwrap_or_default();
            v.push(input.into());
            self.resource_ids = Some(v);
            self
        }
        /// <p>Filters the results by resource IDs.</p>
        /// <note>
        /// <p>This is valid only when you provide resource type. If there is no resource type, you will see an error.</p>
        /// </note>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ConformancePackEvaluationFilters`](crate::model::ConformancePackEvaluationFilters)
        pub fn build(self) -> crate::model::ConformancePackEvaluationFilters {
            crate::model::ConformancePackEvaluationFilters {
                config_rule_names: self.config_rule_names,
                compliance_type: self.compliance_type,
                resource_type: self.resource_type,
                resource_ids: self.resource_ids,
            }
        }
    }
}
impl ConformancePackEvaluationFilters {
    /// Creates a new builder-style object to manufacture [`ConformancePackEvaluationFilters`](crate::model::ConformancePackEvaluationFilters)
    pub fn builder() -> crate::model::conformance_pack_evaluation_filters::Builder {
        crate::model::conformance_pack_evaluation_filters::Builder::default()
    }
}

/// <p>The number of Amazon Web Services resources of a specific type that are
/// compliant or noncompliant, up to a maximum of 100 for
/// each.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceSummaryByResourceType {
    /// <p>The type of Amazon Web Services resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The number of Amazon Web Services resources that are compliant or noncompliant,
    /// up to a maximum of 100 for each.</p>
    pub compliance_summary: std::option::Option<crate::model::ComplianceSummary>,
}
impl ComplianceSummaryByResourceType {
    /// <p>The type of Amazon Web Services resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The number of Amazon Web Services resources that are compliant or noncompliant,
    /// up to a maximum of 100 for each.</p>
    pub fn compliance_summary(&self) -> std::option::Option<&crate::model::ComplianceSummary> {
        self.compliance_summary.as_ref()
    }
}
impl std::fmt::Debug for ComplianceSummaryByResourceType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceSummaryByResourceType");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("compliance_summary", &self.compliance_summary);
        formatter.finish()
    }
}
/// See [`ComplianceSummaryByResourceType`](crate::model::ComplianceSummaryByResourceType)
pub mod compliance_summary_by_resource_type {
    /// A builder for [`ComplianceSummaryByResourceType`](crate::model::ComplianceSummaryByResourceType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) compliance_summary: std::option::Option<crate::model::ComplianceSummary>,
    }
    impl Builder {
        /// <p>The type of Amazon Web Services resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The number of Amazon Web Services resources that are compliant or noncompliant,
        /// up to a maximum of 100 for each.</p>
        pub fn compliance_summary(mut self, input: crate::model::ComplianceSummary) -> Self {
            self.compliance_summary = Some(input);
            self
        }
        /// <p>The number of Amazon Web Services resources that are compliant or noncompliant,
        /// up to a maximum of 100 for each.</p>
        pub fn set_compliance_summary(
            mut self,
            input: std::option::Option<crate::model::ComplianceSummary>,
        ) -> Self {
            self.compliance_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceSummaryByResourceType`](crate::model::ComplianceSummaryByResourceType)
        pub fn build(self) -> crate::model::ComplianceSummaryByResourceType {
            crate::model::ComplianceSummaryByResourceType {
                resource_type: self.resource_type,
                compliance_summary: self.compliance_summary,
            }
        }
    }
}
impl ComplianceSummaryByResourceType {
    /// Creates a new builder-style object to manufacture [`ComplianceSummaryByResourceType`](crate::model::ComplianceSummaryByResourceType)
    pub fn builder() -> crate::model::compliance_summary_by_resource_type::Builder {
        crate::model::compliance_summary_by_resource_type::Builder::default()
    }
}

/// <p>The number of Config rules or Amazon Web Services resources that are
/// compliant and noncompliant.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceSummary {
    /// <p>The number of Config rules or Amazon Web Services resources that are
    /// compliant, up to a maximum of 25 for rules and 100 for
    /// resources.</p>
    pub compliant_resource_count: std::option::Option<crate::model::ComplianceContributorCount>,
    /// <p>The number of Config rules or Amazon Web Services resources that are
    /// noncompliant, up to a maximum of 25 for rules and 100 for
    /// resources.</p>
    pub non_compliant_resource_count: std::option::Option<crate::model::ComplianceContributorCount>,
    /// <p>The time that Config created the compliance
    /// summary.</p>
    pub compliance_summary_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl ComplianceSummary {
    /// <p>The number of Config rules or Amazon Web Services resources that are
    /// compliant, up to a maximum of 25 for rules and 100 for
    /// resources.</p>
    pub fn compliant_resource_count(
        &self,
    ) -> std::option::Option<&crate::model::ComplianceContributorCount> {
        self.compliant_resource_count.as_ref()
    }
    /// <p>The number of Config rules or Amazon Web Services resources that are
    /// noncompliant, up to a maximum of 25 for rules and 100 for
    /// resources.</p>
    pub fn non_compliant_resource_count(
        &self,
    ) -> std::option::Option<&crate::model::ComplianceContributorCount> {
        self.non_compliant_resource_count.as_ref()
    }
    /// <p>The time that Config created the compliance
    /// summary.</p>
    pub fn compliance_summary_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.compliance_summary_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ComplianceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceSummary");
        formatter.field("compliant_resource_count", &self.compliant_resource_count);
        formatter.field(
            "non_compliant_resource_count",
            &self.non_compliant_resource_count,
        );
        formatter.field(
            "compliance_summary_timestamp",
            &self.compliance_summary_timestamp,
        );
        formatter.finish()
    }
}
/// See [`ComplianceSummary`](crate::model::ComplianceSummary)
pub mod compliance_summary {
    /// A builder for [`ComplianceSummary`](crate::model::ComplianceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliant_resource_count:
            std::option::Option<crate::model::ComplianceContributorCount>,
        pub(crate) non_compliant_resource_count:
            std::option::Option<crate::model::ComplianceContributorCount>,
        pub(crate) compliance_summary_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The number of Config rules or Amazon Web Services resources that are
        /// compliant, up to a maximum of 25 for rules and 100 for
        /// resources.</p>
        pub fn compliant_resource_count(
            mut self,
            input: crate::model::ComplianceContributorCount,
        ) -> Self {
            self.compliant_resource_count = Some(input);
            self
        }
        /// <p>The number of Config rules or Amazon Web Services resources that are
        /// compliant, up to a maximum of 25 for rules and 100 for
        /// resources.</p>
        pub fn set_compliant_resource_count(
            mut self,
            input: std::option::Option<crate::model::ComplianceContributorCount>,
        ) -> Self {
            self.compliant_resource_count = input;
            self
        }
        /// <p>The number of Config rules or Amazon Web Services resources that are
        /// noncompliant, up to a maximum of 25 for rules and 100 for
        /// resources.</p>
        pub fn non_compliant_resource_count(
            mut self,
            input: crate::model::ComplianceContributorCount,
        ) -> Self {
            self.non_compliant_resource_count = Some(input);
            self
        }
        /// <p>The number of Config rules or Amazon Web Services resources that are
        /// noncompliant, up to a maximum of 25 for rules and 100 for
        /// resources.</p>
        pub fn set_non_compliant_resource_count(
            mut self,
            input: std::option::Option<crate::model::ComplianceContributorCount>,
        ) -> Self {
            self.non_compliant_resource_count = input;
            self
        }
        /// <p>The time that Config created the compliance
        /// summary.</p>
        pub fn compliance_summary_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.compliance_summary_timestamp = Some(input);
            self
        }
        /// <p>The time that Config created the compliance
        /// summary.</p>
        pub fn set_compliance_summary_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.compliance_summary_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceSummary`](crate::model::ComplianceSummary)
        pub fn build(self) -> crate::model::ComplianceSummary {
            crate::model::ComplianceSummary {
                compliant_resource_count: self.compliant_resource_count,
                non_compliant_resource_count: self.non_compliant_resource_count,
                compliance_summary_timestamp: self.compliance_summary_timestamp,
            }
        }
    }
}
impl ComplianceSummary {
    /// Creates a new builder-style object to manufacture [`ComplianceSummary`](crate::model::ComplianceSummary)
    pub fn builder() -> crate::model::compliance_summary::Builder {
        crate::model::compliance_summary::Builder::default()
    }
}

/// <p>The number of Amazon Web Services resources or Config rules responsible for
/// the current compliance of the item, up to a maximum
/// number.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceContributorCount {
    /// <p>The number of Amazon Web Services resources or Config rules responsible for
    /// the current compliance of the item.</p>
    pub capped_count: i32,
    /// <p>Indicates whether the maximum count is reached.</p>
    pub cap_exceeded: bool,
}
impl ComplianceContributorCount {
    /// <p>The number of Amazon Web Services resources or Config rules responsible for
    /// the current compliance of the item.</p>
    pub fn capped_count(&self) -> i32 {
        self.capped_count
    }
    /// <p>Indicates whether the maximum count is reached.</p>
    pub fn cap_exceeded(&self) -> bool {
        self.cap_exceeded
    }
}
impl std::fmt::Debug for ComplianceContributorCount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceContributorCount");
        formatter.field("capped_count", &self.capped_count);
        formatter.field("cap_exceeded", &self.cap_exceeded);
        formatter.finish()
    }
}
/// See [`ComplianceContributorCount`](crate::model::ComplianceContributorCount)
pub mod compliance_contributor_count {
    /// A builder for [`ComplianceContributorCount`](crate::model::ComplianceContributorCount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capped_count: std::option::Option<i32>,
        pub(crate) cap_exceeded: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The number of Amazon Web Services resources or Config rules responsible for
        /// the current compliance of the item.</p>
        pub fn capped_count(mut self, input: i32) -> Self {
            self.capped_count = Some(input);
            self
        }
        /// <p>The number of Amazon Web Services resources or Config rules responsible for
        /// the current compliance of the item.</p>
        pub fn set_capped_count(mut self, input: std::option::Option<i32>) -> Self {
            self.capped_count = input;
            self
        }
        /// <p>Indicates whether the maximum count is reached.</p>
        pub fn cap_exceeded(mut self, input: bool) -> Self {
            self.cap_exceeded = Some(input);
            self
        }
        /// <p>Indicates whether the maximum count is reached.</p>
        pub fn set_cap_exceeded(mut self, input: std::option::Option<bool>) -> Self {
            self.cap_exceeded = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceContributorCount`](crate::model::ComplianceContributorCount)
        pub fn build(self) -> crate::model::ComplianceContributorCount {
            crate::model::ComplianceContributorCount {
                capped_count: self.capped_count.unwrap_or_default(),
                cap_exceeded: self.cap_exceeded.unwrap_or_default(),
            }
        }
    }
}
impl ComplianceContributorCount {
    /// Creates a new builder-style object to manufacture [`ComplianceContributorCount`](crate::model::ComplianceContributorCount)
    pub fn builder() -> crate::model::compliance_contributor_count::Builder {
        crate::model::compliance_contributor_count::Builder::default()
    }
}

/// <p>The details of an Config evaluation. Provides the Amazon Web Services
/// resource that was evaluated, the compliance of the resource, related
/// time stamps, and supplementary information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationResult {
    /// <p>Uniquely identifies the evaluation result.</p>
    pub evaluation_result_identifier: std::option::Option<crate::model::EvaluationResultIdentifier>,
    /// <p>Indicates whether the Amazon Web Services resource complies with the Config
    /// rule that evaluated it.</p>
    /// <p>For the <code>EvaluationResult</code> data type, Config
    /// supports only the <code>COMPLIANT</code>,
    /// <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values.
    /// Config does not support the <code>INSUFFICIENT_DATA</code> value
    /// for the <code>EvaluationResult</code> data type.</p>
    pub compliance_type: std::option::Option<crate::model::ComplianceType>,
    /// <p>The time when Config recorded the evaluation
    /// result.</p>
    pub result_recorded_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the Config rule evaluated the Amazon Web Services
    /// resource.</p>
    pub config_rule_invoked_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Supplementary information about how the evaluation determined
    /// the compliance.</p>
    pub annotation: std::option::Option<std::string::String>,
    /// <p>An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the Amazon Web Services resource being
    /// evaluated, and the event that triggered the evaluation.</p>
    pub result_token: std::option::Option<std::string::String>,
}
impl EvaluationResult {
    /// <p>Uniquely identifies the evaluation result.</p>
    pub fn evaluation_result_identifier(
        &self,
    ) -> std::option::Option<&crate::model::EvaluationResultIdentifier> {
        self.evaluation_result_identifier.as_ref()
    }
    /// <p>Indicates whether the Amazon Web Services resource complies with the Config
    /// rule that evaluated it.</p>
    /// <p>For the <code>EvaluationResult</code> data type, Config
    /// supports only the <code>COMPLIANT</code>,
    /// <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values.
    /// Config does not support the <code>INSUFFICIENT_DATA</code> value
    /// for the <code>EvaluationResult</code> data type.</p>
    pub fn compliance_type(&self) -> std::option::Option<&crate::model::ComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>The time when Config recorded the evaluation
    /// result.</p>
    pub fn result_recorded_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.result_recorded_time.as_ref()
    }
    /// <p>The time when the Config rule evaluated the Amazon Web Services
    /// resource.</p>
    pub fn config_rule_invoked_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.config_rule_invoked_time.as_ref()
    }
    /// <p>Supplementary information about how the evaluation determined
    /// the compliance.</p>
    pub fn annotation(&self) -> std::option::Option<&str> {
        self.annotation.as_deref()
    }
    /// <p>An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the Amazon Web Services resource being
    /// evaluated, and the event that triggered the evaluation.</p>
    pub fn result_token(&self) -> std::option::Option<&str> {
        self.result_token.as_deref()
    }
}
impl std::fmt::Debug for EvaluationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationResult");
        formatter.field(
            "evaluation_result_identifier",
            &self.evaluation_result_identifier,
        );
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("result_recorded_time", &self.result_recorded_time);
        formatter.field("config_rule_invoked_time", &self.config_rule_invoked_time);
        formatter.field("annotation", &self.annotation);
        formatter.field("result_token", &self.result_token);
        formatter.finish()
    }
}
/// See [`EvaluationResult`](crate::model::EvaluationResult)
pub mod evaluation_result {
    /// A builder for [`EvaluationResult`](crate::model::EvaluationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_result_identifier:
            std::option::Option<crate::model::EvaluationResultIdentifier>,
        pub(crate) compliance_type: std::option::Option<crate::model::ComplianceType>,
        pub(crate) result_recorded_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) config_rule_invoked_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) annotation: std::option::Option<std::string::String>,
        pub(crate) result_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies the evaluation result.</p>
        pub fn evaluation_result_identifier(
            mut self,
            input: crate::model::EvaluationResultIdentifier,
        ) -> Self {
            self.evaluation_result_identifier = Some(input);
            self
        }
        /// <p>Uniquely identifies the evaluation result.</p>
        pub fn set_evaluation_result_identifier(
            mut self,
            input: std::option::Option<crate::model::EvaluationResultIdentifier>,
        ) -> Self {
            self.evaluation_result_identifier = input;
            self
        }
        /// <p>Indicates whether the Amazon Web Services resource complies with the Config
        /// rule that evaluated it.</p>
        /// <p>For the <code>EvaluationResult</code> data type, Config
        /// supports only the <code>COMPLIANT</code>,
        /// <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values.
        /// Config does not support the <code>INSUFFICIENT_DATA</code> value
        /// for the <code>EvaluationResult</code> data type.</p>
        pub fn compliance_type(mut self, input: crate::model::ComplianceType) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>Indicates whether the Amazon Web Services resource complies with the Config
        /// rule that evaluated it.</p>
        /// <p>For the <code>EvaluationResult</code> data type, Config
        /// supports only the <code>COMPLIANT</code>,
        /// <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values.
        /// Config does not support the <code>INSUFFICIENT_DATA</code> value
        /// for the <code>EvaluationResult</code> data type.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>The time when Config recorded the evaluation
        /// result.</p>
        pub fn result_recorded_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.result_recorded_time = Some(input);
            self
        }
        /// <p>The time when Config recorded the evaluation
        /// result.</p>
        pub fn set_result_recorded_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.result_recorded_time = input;
            self
        }
        /// <p>The time when the Config rule evaluated the Amazon Web Services
        /// resource.</p>
        pub fn config_rule_invoked_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.config_rule_invoked_time = Some(input);
            self
        }
        /// <p>The time when the Config rule evaluated the Amazon Web Services
        /// resource.</p>
        pub fn set_config_rule_invoked_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.config_rule_invoked_time = input;
            self
        }
        /// <p>Supplementary information about how the evaluation determined
        /// the compliance.</p>
        pub fn annotation(mut self, input: impl Into<std::string::String>) -> Self {
            self.annotation = Some(input.into());
            self
        }
        /// <p>Supplementary information about how the evaluation determined
        /// the compliance.</p>
        pub fn set_annotation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.annotation = input;
            self
        }
        /// <p>An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the Amazon Web Services resource being
        /// evaluated, and the event that triggered the evaluation.</p>
        pub fn result_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_token = Some(input.into());
            self
        }
        /// <p>An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the Amazon Web Services resource being
        /// evaluated, and the event that triggered the evaluation.</p>
        pub fn set_result_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result_token = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationResult`](crate::model::EvaluationResult)
        pub fn build(self) -> crate::model::EvaluationResult {
            crate::model::EvaluationResult {
                evaluation_result_identifier: self.evaluation_result_identifier,
                compliance_type: self.compliance_type,
                result_recorded_time: self.result_recorded_time,
                config_rule_invoked_time: self.config_rule_invoked_time,
                annotation: self.annotation,
                result_token: self.result_token,
            }
        }
    }
}
impl EvaluationResult {
    /// Creates a new builder-style object to manufacture [`EvaluationResult`](crate::model::EvaluationResult)
    pub fn builder() -> crate::model::evaluation_result::Builder {
        crate::model::evaluation_result::Builder::default()
    }
}

/// <p>The count of resources that are grouped by the group name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupedResourceCount {
    /// <p>The name of the group that can be region, account ID, or resource type. For example, region1, region2 if the region was chosen as <code>GroupByKey</code>.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The number of resources in the group.</p>
    pub resource_count: i64,
}
impl GroupedResourceCount {
    /// <p>The name of the group that can be region, account ID, or resource type. For example, region1, region2 if the region was chosen as <code>GroupByKey</code>.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The number of resources in the group.</p>
    pub fn resource_count(&self) -> i64 {
        self.resource_count
    }
}
impl std::fmt::Debug for GroupedResourceCount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupedResourceCount");
        formatter.field("group_name", &self.group_name);
        formatter.field("resource_count", &self.resource_count);
        formatter.finish()
    }
}
/// See [`GroupedResourceCount`](crate::model::GroupedResourceCount)
pub mod grouped_resource_count {
    /// A builder for [`GroupedResourceCount`](crate::model::GroupedResourceCount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) resource_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the group that can be region, account ID, or resource type. For example, region1, region2 if the region was chosen as <code>GroupByKey</code>.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group that can be region, account ID, or resource type. For example, region1, region2 if the region was chosen as <code>GroupByKey</code>.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The number of resources in the group.</p>
        pub fn resource_count(mut self, input: i64) -> Self {
            self.resource_count = Some(input);
            self
        }
        /// <p>The number of resources in the group.</p>
        pub fn set_resource_count(mut self, input: std::option::Option<i64>) -> Self {
            self.resource_count = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupedResourceCount`](crate::model::GroupedResourceCount)
        pub fn build(self) -> crate::model::GroupedResourceCount {
            crate::model::GroupedResourceCount {
                group_name: self.group_name,
                resource_count: self.resource_count.unwrap_or_default(),
            }
        }
    }
}
impl GroupedResourceCount {
    /// Creates a new builder-style object to manufacture [`GroupedResourceCount`](crate::model::GroupedResourceCount)
    pub fn builder() -> crate::model::grouped_resource_count::Builder {
        crate::model::grouped_resource_count::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceCountGroupKey {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    AwsRegion,
    #[allow(missing_docs)] // documentation missing in model
    ResourceType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceCountGroupKey {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_ID" => ResourceCountGroupKey::AccountId,
            "AWS_REGION" => ResourceCountGroupKey::AwsRegion,
            "RESOURCE_TYPE" => ResourceCountGroupKey::ResourceType,
            other => ResourceCountGroupKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceCountGroupKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceCountGroupKey::from(s))
    }
}
impl ResourceCountGroupKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceCountGroupKey::AccountId => "ACCOUNT_ID",
            ResourceCountGroupKey::AwsRegion => "AWS_REGION",
            ResourceCountGroupKey::ResourceType => "RESOURCE_TYPE",
            ResourceCountGroupKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT_ID", "AWS_REGION", "RESOURCE_TYPE"]
    }
}
impl AsRef<str> for ResourceCountGroupKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Filters the resource count based on account ID, region, and resource type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceCountFilters {
    /// <p>The type of the Amazon Web Services resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The 12-digit ID of the account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The region where the account is located.</p>
    pub region: std::option::Option<std::string::String>,
}
impl ResourceCountFilters {
    /// <p>The type of the Amazon Web Services resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The 12-digit ID of the account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The region where the account is located.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl std::fmt::Debug for ResourceCountFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceCountFilters");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("account_id", &self.account_id);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`ResourceCountFilters`](crate::model::ResourceCountFilters)
pub mod resource_count_filters {
    /// A builder for [`ResourceCountFilters`](crate::model::ResourceCountFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the Amazon Web Services resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the Amazon Web Services resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The 12-digit ID of the account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit ID of the account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The region where the account is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The region where the account is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceCountFilters`](crate::model::ResourceCountFilters)
        pub fn build(self) -> crate::model::ResourceCountFilters {
            crate::model::ResourceCountFilters {
                resource_type: self.resource_type,
                account_id: self.account_id,
                region: self.region,
            }
        }
    }
}
impl ResourceCountFilters {
    /// Creates a new builder-style object to manufacture [`ResourceCountFilters`](crate::model::ResourceCountFilters)
    pub fn builder() -> crate::model::resource_count_filters::Builder {
        crate::model::resource_count_filters::Builder::default()
    }
}

/// <p>Provides a summary of compliance based on either account ID or region. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregateConformancePackComplianceSummary {
    /// <p>Returns an <code>AggregateConformancePackComplianceCount</code> object. </p>
    pub compliance_summary:
        std::option::Option<crate::model::AggregateConformancePackComplianceCount>,
    /// <p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>
    pub group_name: std::option::Option<std::string::String>,
}
impl AggregateConformancePackComplianceSummary {
    /// <p>Returns an <code>AggregateConformancePackComplianceCount</code> object. </p>
    pub fn compliance_summary(
        &self,
    ) -> std::option::Option<&crate::model::AggregateConformancePackComplianceCount> {
        self.compliance_summary.as_ref()
    }
    /// <p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
}
impl std::fmt::Debug for AggregateConformancePackComplianceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregateConformancePackComplianceSummary");
        formatter.field("compliance_summary", &self.compliance_summary);
        formatter.field("group_name", &self.group_name);
        formatter.finish()
    }
}
/// See [`AggregateConformancePackComplianceSummary`](crate::model::AggregateConformancePackComplianceSummary)
pub mod aggregate_conformance_pack_compliance_summary {
    /// A builder for [`AggregateConformancePackComplianceSummary`](crate::model::AggregateConformancePackComplianceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_summary:
            std::option::Option<crate::model::AggregateConformancePackComplianceCount>,
        pub(crate) group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns an <code>AggregateConformancePackComplianceCount</code> object. </p>
        pub fn compliance_summary(
            mut self,
            input: crate::model::AggregateConformancePackComplianceCount,
        ) -> Self {
            self.compliance_summary = Some(input);
            self
        }
        /// <p>Returns an <code>AggregateConformancePackComplianceCount</code> object. </p>
        pub fn set_compliance_summary(
            mut self,
            input: std::option::Option<crate::model::AggregateConformancePackComplianceCount>,
        ) -> Self {
            self.compliance_summary = input;
            self
        }
        /// <p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregateConformancePackComplianceSummary`](crate::model::AggregateConformancePackComplianceSummary)
        pub fn build(self) -> crate::model::AggregateConformancePackComplianceSummary {
            crate::model::AggregateConformancePackComplianceSummary {
                compliance_summary: self.compliance_summary,
                group_name: self.group_name,
            }
        }
    }
}
impl AggregateConformancePackComplianceSummary {
    /// Creates a new builder-style object to manufacture [`AggregateConformancePackComplianceSummary`](crate::model::AggregateConformancePackComplianceSummary)
    pub fn builder() -> crate::model::aggregate_conformance_pack_compliance_summary::Builder {
        crate::model::aggregate_conformance_pack_compliance_summary::Builder::default()
    }
}

/// <p>The number of conformance packs that are compliant and noncompliant.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregateConformancePackComplianceCount {
    /// <p>Number of compliant conformance packs.</p>
    pub compliant_conformance_pack_count: i32,
    /// <p>Number of noncompliant conformance packs.</p>
    pub non_compliant_conformance_pack_count: i32,
}
impl AggregateConformancePackComplianceCount {
    /// <p>Number of compliant conformance packs.</p>
    pub fn compliant_conformance_pack_count(&self) -> i32 {
        self.compliant_conformance_pack_count
    }
    /// <p>Number of noncompliant conformance packs.</p>
    pub fn non_compliant_conformance_pack_count(&self) -> i32 {
        self.non_compliant_conformance_pack_count
    }
}
impl std::fmt::Debug for AggregateConformancePackComplianceCount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregateConformancePackComplianceCount");
        formatter.field(
            "compliant_conformance_pack_count",
            &self.compliant_conformance_pack_count,
        );
        formatter.field(
            "non_compliant_conformance_pack_count",
            &self.non_compliant_conformance_pack_count,
        );
        formatter.finish()
    }
}
/// See [`AggregateConformancePackComplianceCount`](crate::model::AggregateConformancePackComplianceCount)
pub mod aggregate_conformance_pack_compliance_count {
    /// A builder for [`AggregateConformancePackComplianceCount`](crate::model::AggregateConformancePackComplianceCount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliant_conformance_pack_count: std::option::Option<i32>,
        pub(crate) non_compliant_conformance_pack_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Number of compliant conformance packs.</p>
        pub fn compliant_conformance_pack_count(mut self, input: i32) -> Self {
            self.compliant_conformance_pack_count = Some(input);
            self
        }
        /// <p>Number of compliant conformance packs.</p>
        pub fn set_compliant_conformance_pack_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.compliant_conformance_pack_count = input;
            self
        }
        /// <p>Number of noncompliant conformance packs.</p>
        pub fn non_compliant_conformance_pack_count(mut self, input: i32) -> Self {
            self.non_compliant_conformance_pack_count = Some(input);
            self
        }
        /// <p>Number of noncompliant conformance packs.</p>
        pub fn set_non_compliant_conformance_pack_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.non_compliant_conformance_pack_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregateConformancePackComplianceCount`](crate::model::AggregateConformancePackComplianceCount)
        pub fn build(self) -> crate::model::AggregateConformancePackComplianceCount {
            crate::model::AggregateConformancePackComplianceCount {
                compliant_conformance_pack_count: self
                    .compliant_conformance_pack_count
                    .unwrap_or_default(),
                non_compliant_conformance_pack_count: self
                    .non_compliant_conformance_pack_count
                    .unwrap_or_default(),
            }
        }
    }
}
impl AggregateConformancePackComplianceCount {
    /// Creates a new builder-style object to manufacture [`AggregateConformancePackComplianceCount`](crate::model::AggregateConformancePackComplianceCount)
    pub fn builder() -> crate::model::aggregate_conformance_pack_compliance_count::Builder {
        crate::model::aggregate_conformance_pack_compliance_count::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregateConformancePackComplianceSummaryGroupKey {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    AwsRegion,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregateConformancePackComplianceSummaryGroupKey {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_ID" => AggregateConformancePackComplianceSummaryGroupKey::AccountId,
            "AWS_REGION" => AggregateConformancePackComplianceSummaryGroupKey::AwsRegion,
            other => AggregateConformancePackComplianceSummaryGroupKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregateConformancePackComplianceSummaryGroupKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregateConformancePackComplianceSummaryGroupKey::from(s))
    }
}
impl AggregateConformancePackComplianceSummaryGroupKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregateConformancePackComplianceSummaryGroupKey::AccountId => "ACCOUNT_ID",
            AggregateConformancePackComplianceSummaryGroupKey::AwsRegion => "AWS_REGION",
            AggregateConformancePackComplianceSummaryGroupKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT_ID", "AWS_REGION"]
    }
}
impl AsRef<str> for AggregateConformancePackComplianceSummaryGroupKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Filters the results based on account ID and region. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregateConformancePackComplianceSummaryFilters {
    /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
    pub aws_region: std::option::Option<std::string::String>,
}
impl AggregateConformancePackComplianceSummaryFilters {
    /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl std::fmt::Debug for AggregateConformancePackComplianceSummaryFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregateConformancePackComplianceSummaryFilters");
        formatter.field("account_id", &self.account_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.finish()
    }
}
/// See [`AggregateConformancePackComplianceSummaryFilters`](crate::model::AggregateConformancePackComplianceSummaryFilters)
pub mod aggregate_conformance_pack_compliance_summary_filters {
    /// A builder for [`AggregateConformancePackComplianceSummaryFilters`](crate::model::AggregateConformancePackComplianceSummaryFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregateConformancePackComplianceSummaryFilters`](crate::model::AggregateConformancePackComplianceSummaryFilters)
        pub fn build(self) -> crate::model::AggregateConformancePackComplianceSummaryFilters {
            crate::model::AggregateConformancePackComplianceSummaryFilters {
                account_id: self.account_id,
                aws_region: self.aws_region,
            }
        }
    }
}
impl AggregateConformancePackComplianceSummaryFilters {
    /// Creates a new builder-style object to manufacture [`AggregateConformancePackComplianceSummaryFilters`](crate::model::AggregateConformancePackComplianceSummaryFilters)
    pub fn builder() -> crate::model::aggregate_conformance_pack_compliance_summary_filters::Builder
    {
        crate::model::aggregate_conformance_pack_compliance_summary_filters::Builder::default()
    }
}

/// <p>Returns the number of compliant and noncompliant rules for one
/// or more accounts and regions in an aggregator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregateComplianceCount {
    /// <p>The 12-digit account ID or region based on the GroupByKey
    /// value.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The number of compliant and noncompliant Config
    /// rules.</p>
    pub compliance_summary: std::option::Option<crate::model::ComplianceSummary>,
}
impl AggregateComplianceCount {
    /// <p>The 12-digit account ID or region based on the GroupByKey
    /// value.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The number of compliant and noncompliant Config
    /// rules.</p>
    pub fn compliance_summary(&self) -> std::option::Option<&crate::model::ComplianceSummary> {
        self.compliance_summary.as_ref()
    }
}
impl std::fmt::Debug for AggregateComplianceCount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregateComplianceCount");
        formatter.field("group_name", &self.group_name);
        formatter.field("compliance_summary", &self.compliance_summary);
        formatter.finish()
    }
}
/// See [`AggregateComplianceCount`](crate::model::AggregateComplianceCount)
pub mod aggregate_compliance_count {
    /// A builder for [`AggregateComplianceCount`](crate::model::AggregateComplianceCount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) compliance_summary: std::option::Option<crate::model::ComplianceSummary>,
    }
    impl Builder {
        /// <p>The 12-digit account ID or region based on the GroupByKey
        /// value.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID or region based on the GroupByKey
        /// value.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The number of compliant and noncompliant Config
        /// rules.</p>
        pub fn compliance_summary(mut self, input: crate::model::ComplianceSummary) -> Self {
            self.compliance_summary = Some(input);
            self
        }
        /// <p>The number of compliant and noncompliant Config
        /// rules.</p>
        pub fn set_compliance_summary(
            mut self,
            input: std::option::Option<crate::model::ComplianceSummary>,
        ) -> Self {
            self.compliance_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregateComplianceCount`](crate::model::AggregateComplianceCount)
        pub fn build(self) -> crate::model::AggregateComplianceCount {
            crate::model::AggregateComplianceCount {
                group_name: self.group_name,
                compliance_summary: self.compliance_summary,
            }
        }
    }
}
impl AggregateComplianceCount {
    /// Creates a new builder-style object to manufacture [`AggregateComplianceCount`](crate::model::AggregateComplianceCount)
    pub fn builder() -> crate::model::aggregate_compliance_count::Builder {
        crate::model::aggregate_compliance_count::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigRuleComplianceSummaryGroupKey {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    AwsRegion,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigRuleComplianceSummaryGroupKey {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_ID" => ConfigRuleComplianceSummaryGroupKey::AccountId,
            "AWS_REGION" => ConfigRuleComplianceSummaryGroupKey::AwsRegion,
            other => ConfigRuleComplianceSummaryGroupKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigRuleComplianceSummaryGroupKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigRuleComplianceSummaryGroupKey::from(s))
    }
}
impl ConfigRuleComplianceSummaryGroupKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigRuleComplianceSummaryGroupKey::AccountId => "ACCOUNT_ID",
            ConfigRuleComplianceSummaryGroupKey::AwsRegion => "AWS_REGION",
            ConfigRuleComplianceSummaryGroupKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT_ID", "AWS_REGION"]
    }
}
impl AsRef<str> for ConfigRuleComplianceSummaryGroupKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Filters the results based on the account IDs and
/// regions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigRuleComplianceSummaryFilters {
    /// <p>The 12-digit account ID of the source account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The source region where the data is aggregated.</p>
    pub aws_region: std::option::Option<std::string::String>,
}
impl ConfigRuleComplianceSummaryFilters {
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The source region where the data is aggregated.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl std::fmt::Debug for ConfigRuleComplianceSummaryFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigRuleComplianceSummaryFilters");
        formatter.field("account_id", &self.account_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.finish()
    }
}
/// See [`ConfigRuleComplianceSummaryFilters`](crate::model::ConfigRuleComplianceSummaryFilters)
pub mod config_rule_compliance_summary_filters {
    /// A builder for [`ConfigRuleComplianceSummaryFilters`](crate::model::ConfigRuleComplianceSummaryFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The source region where the data is aggregated.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The source region where the data is aggregated.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigRuleComplianceSummaryFilters`](crate::model::ConfigRuleComplianceSummaryFilters)
        pub fn build(self) -> crate::model::ConfigRuleComplianceSummaryFilters {
            crate::model::ConfigRuleComplianceSummaryFilters {
                account_id: self.account_id,
                aws_region: self.aws_region,
            }
        }
    }
}
impl ConfigRuleComplianceSummaryFilters {
    /// Creates a new builder-style object to manufacture [`ConfigRuleComplianceSummaryFilters`](crate::model::ConfigRuleComplianceSummaryFilters)
    pub fn builder() -> crate::model::config_rule_compliance_summary_filters::Builder {
        crate::model::config_rule_compliance_summary_filters::Builder::default()
    }
}

/// <p>The details of an Config evaluation for an account ID and
/// region in an aggregator. Provides the Amazon Web Services resource that was
/// evaluated, the compliance of the resource, related time stamps, and
/// supplementary information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregateEvaluationResult {
    /// <p>Uniquely identifies the evaluation result.</p>
    pub evaluation_result_identifier: std::option::Option<crate::model::EvaluationResultIdentifier>,
    /// <p>The resource compliance status.</p>
    /// <p>For the <code>AggregationEvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code> and
    /// <code>NON_COMPLIANT</code>. Config does not support the
    /// <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code>
    /// value.</p>
    pub compliance_type: std::option::Option<crate::model::ComplianceType>,
    /// <p>The time when Config recorded the aggregate evaluation
    /// result.</p>
    pub result_recorded_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the Config rule evaluated the Amazon Web Services
    /// resource.</p>
    pub config_rule_invoked_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Supplementary information about how the agrregate evaluation
    /// determined the compliance.</p>
    pub annotation: std::option::Option<std::string::String>,
    /// <p>The 12-digit account ID of the source account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The source region from where the data is aggregated.</p>
    pub aws_region: std::option::Option<std::string::String>,
}
impl AggregateEvaluationResult {
    /// <p>Uniquely identifies the evaluation result.</p>
    pub fn evaluation_result_identifier(
        &self,
    ) -> std::option::Option<&crate::model::EvaluationResultIdentifier> {
        self.evaluation_result_identifier.as_ref()
    }
    /// <p>The resource compliance status.</p>
    /// <p>For the <code>AggregationEvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code> and
    /// <code>NON_COMPLIANT</code>. Config does not support the
    /// <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code>
    /// value.</p>
    pub fn compliance_type(&self) -> std::option::Option<&crate::model::ComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>The time when Config recorded the aggregate evaluation
    /// result.</p>
    pub fn result_recorded_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.result_recorded_time.as_ref()
    }
    /// <p>The time when the Config rule evaluated the Amazon Web Services
    /// resource.</p>
    pub fn config_rule_invoked_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.config_rule_invoked_time.as_ref()
    }
    /// <p>Supplementary information about how the agrregate evaluation
    /// determined the compliance.</p>
    pub fn annotation(&self) -> std::option::Option<&str> {
        self.annotation.as_deref()
    }
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The source region from where the data is aggregated.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl std::fmt::Debug for AggregateEvaluationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregateEvaluationResult");
        formatter.field(
            "evaluation_result_identifier",
            &self.evaluation_result_identifier,
        );
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("result_recorded_time", &self.result_recorded_time);
        formatter.field("config_rule_invoked_time", &self.config_rule_invoked_time);
        formatter.field("annotation", &self.annotation);
        formatter.field("account_id", &self.account_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.finish()
    }
}
/// See [`AggregateEvaluationResult`](crate::model::AggregateEvaluationResult)
pub mod aggregate_evaluation_result {
    /// A builder for [`AggregateEvaluationResult`](crate::model::AggregateEvaluationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_result_identifier:
            std::option::Option<crate::model::EvaluationResultIdentifier>,
        pub(crate) compliance_type: std::option::Option<crate::model::ComplianceType>,
        pub(crate) result_recorded_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) config_rule_invoked_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) annotation: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies the evaluation result.</p>
        pub fn evaluation_result_identifier(
            mut self,
            input: crate::model::EvaluationResultIdentifier,
        ) -> Self {
            self.evaluation_result_identifier = Some(input);
            self
        }
        /// <p>Uniquely identifies the evaluation result.</p>
        pub fn set_evaluation_result_identifier(
            mut self,
            input: std::option::Option<crate::model::EvaluationResultIdentifier>,
        ) -> Self {
            self.evaluation_result_identifier = input;
            self
        }
        /// <p>The resource compliance status.</p>
        /// <p>For the <code>AggregationEvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code> and
        /// <code>NON_COMPLIANT</code>. Config does not support the
        /// <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code>
        /// value.</p>
        pub fn compliance_type(mut self, input: crate::model::ComplianceType) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>The resource compliance status.</p>
        /// <p>For the <code>AggregationEvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code> and
        /// <code>NON_COMPLIANT</code>. Config does not support the
        /// <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code>
        /// value.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>The time when Config recorded the aggregate evaluation
        /// result.</p>
        pub fn result_recorded_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.result_recorded_time = Some(input);
            self
        }
        /// <p>The time when Config recorded the aggregate evaluation
        /// result.</p>
        pub fn set_result_recorded_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.result_recorded_time = input;
            self
        }
        /// <p>The time when the Config rule evaluated the Amazon Web Services
        /// resource.</p>
        pub fn config_rule_invoked_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.config_rule_invoked_time = Some(input);
            self
        }
        /// <p>The time when the Config rule evaluated the Amazon Web Services
        /// resource.</p>
        pub fn set_config_rule_invoked_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.config_rule_invoked_time = input;
            self
        }
        /// <p>Supplementary information about how the agrregate evaluation
        /// determined the compliance.</p>
        pub fn annotation(mut self, input: impl Into<std::string::String>) -> Self {
            self.annotation = Some(input.into());
            self
        }
        /// <p>Supplementary information about how the agrregate evaluation
        /// determined the compliance.</p>
        pub fn set_annotation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.annotation = input;
            self
        }
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The source region from where the data is aggregated.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The source region from where the data is aggregated.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregateEvaluationResult`](crate::model::AggregateEvaluationResult)
        pub fn build(self) -> crate::model::AggregateEvaluationResult {
            crate::model::AggregateEvaluationResult {
                evaluation_result_identifier: self.evaluation_result_identifier,
                compliance_type: self.compliance_type,
                result_recorded_time: self.result_recorded_time,
                config_rule_invoked_time: self.config_rule_invoked_time,
                annotation: self.annotation,
                account_id: self.account_id,
                aws_region: self.aws_region,
            }
        }
    }
}
impl AggregateEvaluationResult {
    /// Creates a new builder-style object to manufacture [`AggregateEvaluationResult`](crate::model::AggregateEvaluationResult)
    pub fn builder() -> crate::model::aggregate_evaluation_result::Builder {
        crate::model::aggregate_evaluation_result::Builder::default()
    }
}

/// <p>Provides details of the current status of the invoked remediation action for that resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemediationExecutionStatus {
    /// <p>The details that identify a resource within Config, including
    /// the resource type and resource ID.</p>
    pub resource_key: std::option::Option<crate::model::ResourceKey>,
    /// <p>ENUM of the values.</p>
    pub state: std::option::Option<crate::model::RemediationExecutionState>,
    /// <p>Details of every step.</p>
    pub step_details: std::option::Option<std::vec::Vec<crate::model::RemediationExecutionStep>>,
    /// <p>Start time when the remediation was executed.</p>
    pub invocation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the remediation execution was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl RemediationExecutionStatus {
    /// <p>The details that identify a resource within Config, including
    /// the resource type and resource ID.</p>
    pub fn resource_key(&self) -> std::option::Option<&crate::model::ResourceKey> {
        self.resource_key.as_ref()
    }
    /// <p>ENUM of the values.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::RemediationExecutionState> {
        self.state.as_ref()
    }
    /// <p>Details of every step.</p>
    pub fn step_details(&self) -> std::option::Option<&[crate::model::RemediationExecutionStep]> {
        self.step_details.as_deref()
    }
    /// <p>Start time when the remediation was executed.</p>
    pub fn invocation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.invocation_time.as_ref()
    }
    /// <p>The time when the remediation execution was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for RemediationExecutionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemediationExecutionStatus");
        formatter.field("resource_key", &self.resource_key);
        formatter.field("state", &self.state);
        formatter.field("step_details", &self.step_details);
        formatter.field("invocation_time", &self.invocation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`RemediationExecutionStatus`](crate::model::RemediationExecutionStatus)
pub mod remediation_execution_status {
    /// A builder for [`RemediationExecutionStatus`](crate::model::RemediationExecutionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_key: std::option::Option<crate::model::ResourceKey>,
        pub(crate) state: std::option::Option<crate::model::RemediationExecutionState>,
        pub(crate) step_details:
            std::option::Option<std::vec::Vec<crate::model::RemediationExecutionStep>>,
        pub(crate) invocation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The details that identify a resource within Config, including
        /// the resource type and resource ID.</p>
        pub fn resource_key(mut self, input: crate::model::ResourceKey) -> Self {
            self.resource_key = Some(input);
            self
        }
        /// <p>The details that identify a resource within Config, including
        /// the resource type and resource ID.</p>
        pub fn set_resource_key(
            mut self,
            input: std::option::Option<crate::model::ResourceKey>,
        ) -> Self {
            self.resource_key = input;
            self
        }
        /// <p>ENUM of the values.</p>
        pub fn state(mut self, input: crate::model::RemediationExecutionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>ENUM of the values.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::RemediationExecutionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `step_details`.
        ///
        /// To override the contents of this collection use [`set_step_details`](Self::set_step_details).
        ///
        /// <p>Details of every step.</p>
        pub fn step_details(
            mut self,
            input: impl Into<crate::model::RemediationExecutionStep>,
        ) -> Self {
            let mut v = self.step_details.unwrap_or_default();
            v.push(input.into());
            self.step_details = Some(v);
            self
        }
        /// <p>Details of every step.</p>
        pub fn set_step_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RemediationExecutionStep>>,
        ) -> Self {
            self.step_details = input;
            self
        }
        /// <p>Start time when the remediation was executed.</p>
        pub fn invocation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.invocation_time = Some(input);
            self
        }
        /// <p>Start time when the remediation was executed.</p>
        pub fn set_invocation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.invocation_time = input;
            self
        }
        /// <p>The time when the remediation execution was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time when the remediation execution was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`RemediationExecutionStatus`](crate::model::RemediationExecutionStatus)
        pub fn build(self) -> crate::model::RemediationExecutionStatus {
            crate::model::RemediationExecutionStatus {
                resource_key: self.resource_key,
                state: self.state,
                step_details: self.step_details,
                invocation_time: self.invocation_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl RemediationExecutionStatus {
    /// Creates a new builder-style object to manufacture [`RemediationExecutionStatus`](crate::model::RemediationExecutionStatus)
    pub fn builder() -> crate::model::remediation_execution_status::Builder {
        crate::model::remediation_execution_status::Builder::default()
    }
}

/// <p>Name of the step from the SSM document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemediationExecutionStep {
    /// <p>The details of the step.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The valid status of the step.</p>
    pub state: std::option::Option<crate::model::RemediationExecutionStepState>,
    /// <p>An error message if the step was interrupted during execution.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The time when the step started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the step stopped.</p>
    pub stop_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl RemediationExecutionStep {
    /// <p>The details of the step.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The valid status of the step.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::RemediationExecutionStepState> {
        self.state.as_ref()
    }
    /// <p>An error message if the step was interrupted during execution.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The time when the step started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time when the step stopped.</p>
    pub fn stop_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.stop_time.as_ref()
    }
}
impl std::fmt::Debug for RemediationExecutionStep {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemediationExecutionStep");
        formatter.field("name", &self.name);
        formatter.field("state", &self.state);
        formatter.field("error_message", &self.error_message);
        formatter.field("start_time", &self.start_time);
        formatter.field("stop_time", &self.stop_time);
        formatter.finish()
    }
}
/// See [`RemediationExecutionStep`](crate::model::RemediationExecutionStep)
pub mod remediation_execution_step {
    /// A builder for [`RemediationExecutionStep`](crate::model::RemediationExecutionStep)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::RemediationExecutionStepState>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) stop_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The details of the step.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The details of the step.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The valid status of the step.</p>
        pub fn state(mut self, input: crate::model::RemediationExecutionStepState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The valid status of the step.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::RemediationExecutionStepState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>An error message if the step was interrupted during execution.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>An error message if the step was interrupted during execution.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The time when the step started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time when the step started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time when the step stopped.</p>
        pub fn stop_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.stop_time = Some(input);
            self
        }
        /// <p>The time when the step stopped.</p>
        pub fn set_stop_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.stop_time = input;
            self
        }
        /// Consumes the builder and constructs a [`RemediationExecutionStep`](crate::model::RemediationExecutionStep)
        pub fn build(self) -> crate::model::RemediationExecutionStep {
            crate::model::RemediationExecutionStep {
                name: self.name,
                state: self.state,
                error_message: self.error_message,
                start_time: self.start_time,
                stop_time: self.stop_time,
            }
        }
    }
}
impl RemediationExecutionStep {
    /// Creates a new builder-style object to manufacture [`RemediationExecutionStep`](crate::model::RemediationExecutionStep)
    pub fn builder() -> crate::model::remediation_execution_step::Builder {
        crate::model::remediation_execution_step::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RemediationExecutionStepState {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RemediationExecutionStepState {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => RemediationExecutionStepState::Failed,
            "PENDING" => RemediationExecutionStepState::Pending,
            "SUCCEEDED" => RemediationExecutionStepState::Succeeded,
            other => RemediationExecutionStepState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RemediationExecutionStepState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RemediationExecutionStepState::from(s))
    }
}
impl RemediationExecutionStepState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RemediationExecutionStepState::Failed => "FAILED",
            RemediationExecutionStepState::Pending => "PENDING",
            RemediationExecutionStepState::Succeeded => "SUCCEEDED",
            RemediationExecutionStepState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING", "SUCCEEDED"]
    }
}
impl AsRef<str> for RemediationExecutionStepState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RemediationExecutionState {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RemediationExecutionState {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => RemediationExecutionState::Failed,
            "IN_PROGRESS" => RemediationExecutionState::InProgress,
            "QUEUED" => RemediationExecutionState::Queued,
            "SUCCEEDED" => RemediationExecutionState::Succeeded,
            other => RemediationExecutionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RemediationExecutionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RemediationExecutionState::from(s))
    }
}
impl RemediationExecutionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RemediationExecutionState::Failed => "FAILED",
            RemediationExecutionState::InProgress => "IN_PROGRESS",
            RemediationExecutionState::Queued => "QUEUED",
            RemediationExecutionState::Succeeded => "SUCCEEDED",
            RemediationExecutionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "QUEUED", "SUCCEEDED"]
    }
}
impl AsRef<str> for RemediationExecutionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the account ID and region of an
/// aggregator account that is requesting authorization but is not yet
/// authorized.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingAggregationRequest {
    /// <p>The 12-digit account ID of the account requesting to aggregate
    /// data.</p>
    pub requester_account_id: std::option::Option<std::string::String>,
    /// <p>The region requesting to aggregate data. </p>
    pub requester_aws_region: std::option::Option<std::string::String>,
}
impl PendingAggregationRequest {
    /// <p>The 12-digit account ID of the account requesting to aggregate
    /// data.</p>
    pub fn requester_account_id(&self) -> std::option::Option<&str> {
        self.requester_account_id.as_deref()
    }
    /// <p>The region requesting to aggregate data. </p>
    pub fn requester_aws_region(&self) -> std::option::Option<&str> {
        self.requester_aws_region.as_deref()
    }
}
impl std::fmt::Debug for PendingAggregationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingAggregationRequest");
        formatter.field("requester_account_id", &self.requester_account_id);
        formatter.field("requester_aws_region", &self.requester_aws_region);
        formatter.finish()
    }
}
/// See [`PendingAggregationRequest`](crate::model::PendingAggregationRequest)
pub mod pending_aggregation_request {
    /// A builder for [`PendingAggregationRequest`](crate::model::PendingAggregationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) requester_account_id: std::option::Option<std::string::String>,
        pub(crate) requester_aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 12-digit account ID of the account requesting to aggregate
        /// data.</p>
        pub fn requester_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the account requesting to aggregate
        /// data.</p>
        pub fn set_requester_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requester_account_id = input;
            self
        }
        /// <p>The region requesting to aggregate data. </p>
        pub fn requester_aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester_aws_region = Some(input.into());
            self
        }
        /// <p>The region requesting to aggregate data. </p>
        pub fn set_requester_aws_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requester_aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingAggregationRequest`](crate::model::PendingAggregationRequest)
        pub fn build(self) -> crate::model::PendingAggregationRequest {
            crate::model::PendingAggregationRequest {
                requester_account_id: self.requester_account_id,
                requester_aws_region: self.requester_aws_region,
            }
        }
    }
}
impl PendingAggregationRequest {
    /// Creates a new builder-style object to manufacture [`PendingAggregationRequest`](crate::model::PendingAggregationRequest)
    pub fn builder() -> crate::model::pending_aggregation_request::Builder {
        crate::model::pending_aggregation_request::Builder::default()
    }
}

/// <p>Returns the status for an organization conformance pack in an organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationConformancePackStatus {
    /// <p>The name that you assign to organization conformance pack.</p>
    pub organization_conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>Indicates deployment status of an organization conformance pack.
    /// When master account calls PutOrganizationConformancePack for the first time,
    /// conformance pack status is created in all the member accounts.
    /// When master account calls PutOrganizationConformancePack for the second time,
    /// conformance pack status is updated in all the member accounts.
    /// Additionally, conformance pack status is updated when one or more member accounts join or leave an
    /// organization.   
    /// Conformance pack status is deleted when the master account deletes
    /// OrganizationConformancePack in all the member accounts and disables service
    /// access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in all the member accounts. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member accounts within that organization.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member accounts within that organization.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted from all the member accounts.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in all the member accounts.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member accounts within that organization.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::OrganizationResourceStatus>,
    /// <p>An error code that is returned when organization conformance pack creation or deletion has failed in a member account. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>An error message indicating that organization conformance pack creation or deletion failed due to an error. </p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The timestamp of the last update.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl OrganizationConformancePackStatus {
    /// <p>The name that you assign to organization conformance pack.</p>
    pub fn organization_conformance_pack_name(&self) -> std::option::Option<&str> {
        self.organization_conformance_pack_name.as_deref()
    }
    /// <p>Indicates deployment status of an organization conformance pack.
    /// When master account calls PutOrganizationConformancePack for the first time,
    /// conformance pack status is created in all the member accounts.
    /// When master account calls PutOrganizationConformancePack for the second time,
    /// conformance pack status is updated in all the member accounts.
    /// Additionally, conformance pack status is updated when one or more member accounts join or leave an
    /// organization.   
    /// Conformance pack status is deleted when the master account deletes
    /// OrganizationConformancePack in all the member accounts and disables service
    /// access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in all the member accounts. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member accounts within that organization.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member accounts within that organization.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted from all the member accounts.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in all the member accounts.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member accounts within that organization.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::OrganizationResourceStatus> {
        self.status.as_ref()
    }
    /// <p>An error code that is returned when organization conformance pack creation or deletion has failed in a member account. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>An error message indicating that organization conformance pack creation or deletion failed due to an error. </p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The timestamp of the last update.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for OrganizationConformancePackStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationConformancePackStatus");
        formatter.field(
            "organization_conformance_pack_name",
            &self.organization_conformance_pack_name,
        );
        formatter.field("status", &self.status);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`OrganizationConformancePackStatus`](crate::model::OrganizationConformancePackStatus)
pub mod organization_conformance_pack_status {
    /// A builder for [`OrganizationConformancePackStatus`](crate::model::OrganizationConformancePackStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OrganizationResourceStatus>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name that you assign to organization conformance pack.</p>
        pub fn organization_conformance_pack_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_name = Some(input.into());
            self
        }
        /// <p>The name that you assign to organization conformance pack.</p>
        pub fn set_organization_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_name = input;
            self
        }
        /// <p>Indicates deployment status of an organization conformance pack.
        /// When master account calls PutOrganizationConformancePack for the first time,
        /// conformance pack status is created in all the member accounts.
        /// When master account calls PutOrganizationConformancePack for the second time,
        /// conformance pack status is updated in all the member accounts.
        /// Additionally, conformance pack status is updated when one or more member accounts join or leave an
        /// organization.   
        /// Conformance pack status is deleted when the master account deletes
        /// OrganizationConformancePack in all the member accounts and disables service
        /// access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
        /// <p>Config sets the state of the conformance pack to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in all the member accounts. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member accounts within that organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member accounts within that organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted from all the member accounts.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in all the member accounts.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member accounts within that organization.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::OrganizationResourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Indicates deployment status of an organization conformance pack.
        /// When master account calls PutOrganizationConformancePack for the first time,
        /// conformance pack status is created in all the member accounts.
        /// When master account calls PutOrganizationConformancePack for the second time,
        /// conformance pack status is updated in all the member accounts.
        /// Additionally, conformance pack status is updated when one or more member accounts join or leave an
        /// organization.   
        /// Conformance pack status is deleted when the master account deletes
        /// OrganizationConformancePack in all the member accounts and disables service
        /// access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
        /// <p>Config sets the state of the conformance pack to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in all the member accounts. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member accounts within that organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member accounts within that organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted from all the member accounts.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in all the member accounts.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member accounts within that organization.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OrganizationResourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>An error code that is returned when organization conformance pack creation or deletion has failed in a member account. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>An error code that is returned when organization conformance pack creation or deletion has failed in a member account. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>An error message indicating that organization conformance pack creation or deletion failed due to an error. </p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>An error message indicating that organization conformance pack creation or deletion failed due to an error. </p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The timestamp of the last update.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The timestamp of the last update.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationConformancePackStatus`](crate::model::OrganizationConformancePackStatus)
        pub fn build(self) -> crate::model::OrganizationConformancePackStatus {
            crate::model::OrganizationConformancePackStatus {
                organization_conformance_pack_name: self.organization_conformance_pack_name,
                status: self.status,
                error_code: self.error_code,
                error_message: self.error_message,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl OrganizationConformancePackStatus {
    /// Creates a new builder-style object to manufacture [`OrganizationConformancePackStatus`](crate::model::OrganizationConformancePackStatus)
    pub fn builder() -> crate::model::organization_conformance_pack_status::Builder {
        crate::model::organization_conformance_pack_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrganizationResourceStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    CreateSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateSuccessful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrganizationResourceStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => OrganizationResourceStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => OrganizationResourceStatus::CreateInProgress,
            "CREATE_SUCCESSFUL" => OrganizationResourceStatus::CreateSuccessful,
            "DELETE_FAILED" => OrganizationResourceStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => OrganizationResourceStatus::DeleteInProgress,
            "DELETE_SUCCESSFUL" => OrganizationResourceStatus::DeleteSuccessful,
            "UPDATE_FAILED" => OrganizationResourceStatus::UpdateFailed,
            "UPDATE_IN_PROGRESS" => OrganizationResourceStatus::UpdateInProgress,
            "UPDATE_SUCCESSFUL" => OrganizationResourceStatus::UpdateSuccessful,
            other => OrganizationResourceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrganizationResourceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrganizationResourceStatus::from(s))
    }
}
impl OrganizationResourceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrganizationResourceStatus::CreateFailed => "CREATE_FAILED",
            OrganizationResourceStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            OrganizationResourceStatus::CreateSuccessful => "CREATE_SUCCESSFUL",
            OrganizationResourceStatus::DeleteFailed => "DELETE_FAILED",
            OrganizationResourceStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            OrganizationResourceStatus::DeleteSuccessful => "DELETE_SUCCESSFUL",
            OrganizationResourceStatus::UpdateFailed => "UPDATE_FAILED",
            OrganizationResourceStatus::UpdateInProgress => "UPDATE_IN_PROGRESS",
            OrganizationResourceStatus::UpdateSuccessful => "UPDATE_SUCCESSFUL",
            OrganizationResourceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "CREATE_SUCCESSFUL",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "DELETE_SUCCESSFUL",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
            "UPDATE_SUCCESSFUL",
        ]
    }
}
impl AsRef<str> for OrganizationResourceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An organization conformance pack that has information about conformance packs that Config creates in member accounts. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationConformancePack {
    /// <p>The name you assign to an organization conformance pack.</p>
    pub organization_conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of organization conformance pack.</p>
    pub organization_conformance_pack_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.  </p>
    /// <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub delivery_s3_bucket: std::option::Option<std::string::String>,
    /// <p>Any folder structure you want to add to an Amazon S3 bucket.</p>
    /// <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub delivery_s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub conformance_pack_input_parameters:
        std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
    /// <p>A comma-separated list of accounts excluded from organization conformance pack.</p>
    pub excluded_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Last time when organization conformation pack was updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl OrganizationConformancePack {
    /// <p>The name you assign to an organization conformance pack.</p>
    pub fn organization_conformance_pack_name(&self) -> std::option::Option<&str> {
        self.organization_conformance_pack_name.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of organization conformance pack.</p>
    pub fn organization_conformance_pack_arn(&self) -> std::option::Option<&str> {
        self.organization_conformance_pack_arn.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.  </p>
    /// <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_bucket(&self) -> std::option::Option<&str> {
        self.delivery_s3_bucket.as_deref()
    }
    /// <p>Any folder structure you want to add to an Amazon S3 bucket.</p>
    /// <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_key_prefix(&self) -> std::option::Option<&str> {
        self.delivery_s3_key_prefix.as_deref()
    }
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub fn conformance_pack_input_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::ConformancePackInputParameter]> {
        self.conformance_pack_input_parameters.as_deref()
    }
    /// <p>A comma-separated list of accounts excluded from organization conformance pack.</p>
    pub fn excluded_accounts(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_accounts.as_deref()
    }
    /// <p>Last time when organization conformation pack was updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for OrganizationConformancePack {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationConformancePack");
        formatter.field(
            "organization_conformance_pack_name",
            &self.organization_conformance_pack_name,
        );
        formatter.field(
            "organization_conformance_pack_arn",
            &self.organization_conformance_pack_arn,
        );
        formatter.field("delivery_s3_bucket", &self.delivery_s3_bucket);
        formatter.field("delivery_s3_key_prefix", &self.delivery_s3_key_prefix);
        formatter.field(
            "conformance_pack_input_parameters",
            &self.conformance_pack_input_parameters,
        );
        formatter.field("excluded_accounts", &self.excluded_accounts);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`OrganizationConformancePack`](crate::model::OrganizationConformancePack)
pub mod organization_conformance_pack {
    /// A builder for [`OrganizationConformancePack`](crate::model::OrganizationConformancePack)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) organization_conformance_pack_arn: std::option::Option<std::string::String>,
        pub(crate) delivery_s3_bucket: std::option::Option<std::string::String>,
        pub(crate) delivery_s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_input_parameters:
            std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
        pub(crate) excluded_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name you assign to an organization conformance pack.</p>
        pub fn organization_conformance_pack_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_name = Some(input.into());
            self
        }
        /// <p>The name you assign to an organization conformance pack.</p>
        pub fn set_organization_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_name = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of organization conformance pack.</p>
        pub fn organization_conformance_pack_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of organization conformance pack.</p>
        pub fn set_organization_conformance_pack_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_arn = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.  </p>
        /// <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn delivery_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.  </p>
        /// <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn set_delivery_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_s3_bucket = input;
            self
        }
        /// <p>Any folder structure you want to add to an Amazon S3 bucket.</p>
        /// <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn delivery_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_s3_key_prefix = Some(input.into());
            self
        }
        /// <p>Any folder structure you want to add to an Amazon S3 bucket.</p>
        /// <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn set_delivery_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_s3_key_prefix = input;
            self
        }
        /// Appends an item to `conformance_pack_input_parameters`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_input_parameters`](Self::set_conformance_pack_input_parameters).
        ///
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn conformance_pack_input_parameters(
            mut self,
            input: impl Into<crate::model::ConformancePackInputParameter>,
        ) -> Self {
            let mut v = self.conformance_pack_input_parameters.unwrap_or_default();
            v.push(input.into());
            self.conformance_pack_input_parameters = Some(v);
            self
        }
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn set_conformance_pack_input_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
        ) -> Self {
            self.conformance_pack_input_parameters = input;
            self
        }
        /// Appends an item to `excluded_accounts`.
        ///
        /// To override the contents of this collection use [`set_excluded_accounts`](Self::set_excluded_accounts).
        ///
        /// <p>A comma-separated list of accounts excluded from organization conformance pack.</p>
        pub fn excluded_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_accounts.unwrap_or_default();
            v.push(input.into());
            self.excluded_accounts = Some(v);
            self
        }
        /// <p>A comma-separated list of accounts excluded from organization conformance pack.</p>
        pub fn set_excluded_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_accounts = input;
            self
        }
        /// <p>Last time when organization conformation pack was updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>Last time when organization conformation pack was updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationConformancePack`](crate::model::OrganizationConformancePack)
        pub fn build(self) -> crate::model::OrganizationConformancePack {
            crate::model::OrganizationConformancePack {
                organization_conformance_pack_name: self.organization_conformance_pack_name,
                organization_conformance_pack_arn: self.organization_conformance_pack_arn,
                delivery_s3_bucket: self.delivery_s3_bucket,
                delivery_s3_key_prefix: self.delivery_s3_key_prefix,
                conformance_pack_input_parameters: self.conformance_pack_input_parameters,
                excluded_accounts: self.excluded_accounts,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl OrganizationConformancePack {
    /// Creates a new builder-style object to manufacture [`OrganizationConformancePack`](crate::model::OrganizationConformancePack)
    pub fn builder() -> crate::model::organization_conformance_pack::Builder {
        crate::model::organization_conformance_pack::Builder::default()
    }
}

/// <p>Returns the status for an organization config rule in an organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationConfigRuleStatus {
    /// <p>The name that you assign to organization config rule.</p>
    pub organization_config_rule_name: std::option::Option<std::string::String>,
    /// <p>Indicates deployment status of an organization config rule.
    /// When master account calls PutOrganizationConfigRule action for the first time, config rule status is created in all the member accounts.
    /// When master account calls PutOrganizationConfigRule action for the second time, config rule status is updated in all the member accounts. Additionally, config rule status is updated when one or more member accounts join or leave an organization.   
    /// Config rule status is deleted when the master account deletes OrganizationConfigRule in all the member accounts and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all the member accounts. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member accounts within that organization.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member accounts within that organization.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all the member accounts.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all the member accounts.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member accounts within that organization.</p>
    /// </li>
    /// </ul>
    pub organization_rule_status: std::option::Option<crate::model::OrganizationRuleStatus>,
    /// <p>An error code that is returned when organization config rule creation or deletion has failed.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>An error message indicating that organization config rule creation or deletion failed due to an error.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The timestamp of the last update.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl OrganizationConfigRuleStatus {
    /// <p>The name that you assign to organization config rule.</p>
    pub fn organization_config_rule_name(&self) -> std::option::Option<&str> {
        self.organization_config_rule_name.as_deref()
    }
    /// <p>Indicates deployment status of an organization config rule.
    /// When master account calls PutOrganizationConfigRule action for the first time, config rule status is created in all the member accounts.
    /// When master account calls PutOrganizationConfigRule action for the second time, config rule status is updated in all the member accounts. Additionally, config rule status is updated when one or more member accounts join or leave an organization.   
    /// Config rule status is deleted when the master account deletes OrganizationConfigRule in all the member accounts and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all the member accounts. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member accounts within that organization.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member accounts within that organization.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all the member accounts.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all the member accounts.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member accounts within that organization.</p>
    /// </li>
    /// </ul>
    pub fn organization_rule_status(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationRuleStatus> {
        self.organization_rule_status.as_ref()
    }
    /// <p>An error code that is returned when organization config rule creation or deletion has failed.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>An error message indicating that organization config rule creation or deletion failed due to an error.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The timestamp of the last update.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for OrganizationConfigRuleStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationConfigRuleStatus");
        formatter.field(
            "organization_config_rule_name",
            &self.organization_config_rule_name,
        );
        formatter.field("organization_rule_status", &self.organization_rule_status);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`OrganizationConfigRuleStatus`](crate::model::OrganizationConfigRuleStatus)
pub mod organization_config_rule_status {
    /// A builder for [`OrganizationConfigRuleStatus`](crate::model::OrganizationConfigRuleStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_config_rule_name: std::option::Option<std::string::String>,
        pub(crate) organization_rule_status:
            std::option::Option<crate::model::OrganizationRuleStatus>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name that you assign to organization config rule.</p>
        pub fn organization_config_rule_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = Some(input.into());
            self
        }
        /// <p>The name that you assign to organization config rule.</p>
        pub fn set_organization_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = input;
            self
        }
        /// <p>Indicates deployment status of an organization config rule.
        /// When master account calls PutOrganizationConfigRule action for the first time, config rule status is created in all the member accounts.
        /// When master account calls PutOrganizationConfigRule action for the second time, config rule status is updated in all the member accounts. Additionally, config rule status is updated when one or more member accounts join or leave an organization.   
        /// Config rule status is deleted when the master account deletes OrganizationConfigRule in all the member accounts and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
        /// <p>Config sets the state of the rule to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all the member accounts. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member accounts within that organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member accounts within that organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all the member accounts.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all the member accounts.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member accounts within that organization.</p>
        /// </li>
        /// </ul>
        pub fn organization_rule_status(
            mut self,
            input: crate::model::OrganizationRuleStatus,
        ) -> Self {
            self.organization_rule_status = Some(input);
            self
        }
        /// <p>Indicates deployment status of an organization config rule.
        /// When master account calls PutOrganizationConfigRule action for the first time, config rule status is created in all the member accounts.
        /// When master account calls PutOrganizationConfigRule action for the second time, config rule status is updated in all the member accounts. Additionally, config rule status is updated when one or more member accounts join or leave an organization.   
        /// Config rule status is deleted when the master account deletes OrganizationConfigRule in all the member accounts and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
        /// <p>Config sets the state of the rule to:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all the member accounts. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member accounts within that organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member accounts within that organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all the member accounts.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all the member accounts.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member accounts within that organization.</p>
        /// </li>
        /// </ul>
        pub fn set_organization_rule_status(
            mut self,
            input: std::option::Option<crate::model::OrganizationRuleStatus>,
        ) -> Self {
            self.organization_rule_status = input;
            self
        }
        /// <p>An error code that is returned when organization config rule creation or deletion has failed.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>An error code that is returned when organization config rule creation or deletion has failed.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>An error message indicating that organization config rule creation or deletion failed due to an error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>An error message indicating that organization config rule creation or deletion failed due to an error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The timestamp of the last update.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The timestamp of the last update.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationConfigRuleStatus`](crate::model::OrganizationConfigRuleStatus)
        pub fn build(self) -> crate::model::OrganizationConfigRuleStatus {
            crate::model::OrganizationConfigRuleStatus {
                organization_config_rule_name: self.organization_config_rule_name,
                organization_rule_status: self.organization_rule_status,
                error_code: self.error_code,
                error_message: self.error_message,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl OrganizationConfigRuleStatus {
    /// Creates a new builder-style object to manufacture [`OrganizationConfigRuleStatus`](crate::model::OrganizationConfigRuleStatus)
    pub fn builder() -> crate::model::organization_config_rule_status::Builder {
        crate::model::organization_config_rule_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrganizationRuleStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    CreateSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateSuccessful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrganizationRuleStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => OrganizationRuleStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => OrganizationRuleStatus::CreateInProgress,
            "CREATE_SUCCESSFUL" => OrganizationRuleStatus::CreateSuccessful,
            "DELETE_FAILED" => OrganizationRuleStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => OrganizationRuleStatus::DeleteInProgress,
            "DELETE_SUCCESSFUL" => OrganizationRuleStatus::DeleteSuccessful,
            "UPDATE_FAILED" => OrganizationRuleStatus::UpdateFailed,
            "UPDATE_IN_PROGRESS" => OrganizationRuleStatus::UpdateInProgress,
            "UPDATE_SUCCESSFUL" => OrganizationRuleStatus::UpdateSuccessful,
            other => OrganizationRuleStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrganizationRuleStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrganizationRuleStatus::from(s))
    }
}
impl OrganizationRuleStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrganizationRuleStatus::CreateFailed => "CREATE_FAILED",
            OrganizationRuleStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            OrganizationRuleStatus::CreateSuccessful => "CREATE_SUCCESSFUL",
            OrganizationRuleStatus::DeleteFailed => "DELETE_FAILED",
            OrganizationRuleStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            OrganizationRuleStatus::DeleteSuccessful => "DELETE_SUCCESSFUL",
            OrganizationRuleStatus::UpdateFailed => "UPDATE_FAILED",
            OrganizationRuleStatus::UpdateInProgress => "UPDATE_IN_PROGRESS",
            OrganizationRuleStatus::UpdateSuccessful => "UPDATE_SUCCESSFUL",
            OrganizationRuleStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "CREATE_SUCCESSFUL",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "DELETE_SUCCESSFUL",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
            "UPDATE_SUCCESSFUL",
        ]
    }
}
impl AsRef<str> for OrganizationRuleStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An organization config rule that has information about config rules that Config creates in member accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationConfigRule {
    /// <p>The name that you assign to organization config rule.</p>
    pub organization_config_rule_name: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of organization config rule.</p>
    pub organization_config_rule_arn: std::option::Option<std::string::String>,
    /// <p>An <code>OrganizationManagedRuleMetadata</code> object.</p>
    pub organization_managed_rule_metadata:
        std::option::Option<crate::model::OrganizationManagedRuleMetadata>,
    /// <p>An <code>OrganizationCustomRuleMetadata</code> object.</p>
    pub organization_custom_rule_metadata:
        std::option::Option<crate::model::OrganizationCustomRuleMetadata>,
    /// <p>A comma-separated list of accounts excluded from organization config rule.</p>
    pub excluded_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The timestamp of the last update.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl OrganizationConfigRule {
    /// <p>The name that you assign to organization config rule.</p>
    pub fn organization_config_rule_name(&self) -> std::option::Option<&str> {
        self.organization_config_rule_name.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of organization config rule.</p>
    pub fn organization_config_rule_arn(&self) -> std::option::Option<&str> {
        self.organization_config_rule_arn.as_deref()
    }
    /// <p>An <code>OrganizationManagedRuleMetadata</code> object.</p>
    pub fn organization_managed_rule_metadata(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationManagedRuleMetadata> {
        self.organization_managed_rule_metadata.as_ref()
    }
    /// <p>An <code>OrganizationCustomRuleMetadata</code> object.</p>
    pub fn organization_custom_rule_metadata(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationCustomRuleMetadata> {
        self.organization_custom_rule_metadata.as_ref()
    }
    /// <p>A comma-separated list of accounts excluded from organization config rule.</p>
    pub fn excluded_accounts(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_accounts.as_deref()
    }
    /// <p>The timestamp of the last update.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for OrganizationConfigRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationConfigRule");
        formatter.field(
            "organization_config_rule_name",
            &self.organization_config_rule_name,
        );
        formatter.field(
            "organization_config_rule_arn",
            &self.organization_config_rule_arn,
        );
        formatter.field(
            "organization_managed_rule_metadata",
            &self.organization_managed_rule_metadata,
        );
        formatter.field(
            "organization_custom_rule_metadata",
            &self.organization_custom_rule_metadata,
        );
        formatter.field("excluded_accounts", &self.excluded_accounts);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`OrganizationConfigRule`](crate::model::OrganizationConfigRule)
pub mod organization_config_rule {
    /// A builder for [`OrganizationConfigRule`](crate::model::OrganizationConfigRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_config_rule_name: std::option::Option<std::string::String>,
        pub(crate) organization_config_rule_arn: std::option::Option<std::string::String>,
        pub(crate) organization_managed_rule_metadata:
            std::option::Option<crate::model::OrganizationManagedRuleMetadata>,
        pub(crate) organization_custom_rule_metadata:
            std::option::Option<crate::model::OrganizationCustomRuleMetadata>,
        pub(crate) excluded_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name that you assign to organization config rule.</p>
        pub fn organization_config_rule_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = Some(input.into());
            self
        }
        /// <p>The name that you assign to organization config rule.</p>
        pub fn set_organization_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of organization config rule.</p>
        pub fn organization_config_rule_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_config_rule_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of organization config rule.</p>
        pub fn set_organization_config_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_config_rule_arn = input;
            self
        }
        /// <p>An <code>OrganizationManagedRuleMetadata</code> object.</p>
        pub fn organization_managed_rule_metadata(
            mut self,
            input: crate::model::OrganizationManagedRuleMetadata,
        ) -> Self {
            self.organization_managed_rule_metadata = Some(input);
            self
        }
        /// <p>An <code>OrganizationManagedRuleMetadata</code> object.</p>
        pub fn set_organization_managed_rule_metadata(
            mut self,
            input: std::option::Option<crate::model::OrganizationManagedRuleMetadata>,
        ) -> Self {
            self.organization_managed_rule_metadata = input;
            self
        }
        /// <p>An <code>OrganizationCustomRuleMetadata</code> object.</p>
        pub fn organization_custom_rule_metadata(
            mut self,
            input: crate::model::OrganizationCustomRuleMetadata,
        ) -> Self {
            self.organization_custom_rule_metadata = Some(input);
            self
        }
        /// <p>An <code>OrganizationCustomRuleMetadata</code> object.</p>
        pub fn set_organization_custom_rule_metadata(
            mut self,
            input: std::option::Option<crate::model::OrganizationCustomRuleMetadata>,
        ) -> Self {
            self.organization_custom_rule_metadata = input;
            self
        }
        /// Appends an item to `excluded_accounts`.
        ///
        /// To override the contents of this collection use [`set_excluded_accounts`](Self::set_excluded_accounts).
        ///
        /// <p>A comma-separated list of accounts excluded from organization config rule.</p>
        pub fn excluded_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_accounts.unwrap_or_default();
            v.push(input.into());
            self.excluded_accounts = Some(v);
            self
        }
        /// <p>A comma-separated list of accounts excluded from organization config rule.</p>
        pub fn set_excluded_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_accounts = input;
            self
        }
        /// <p>The timestamp of the last update.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The timestamp of the last update.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationConfigRule`](crate::model::OrganizationConfigRule)
        pub fn build(self) -> crate::model::OrganizationConfigRule {
            crate::model::OrganizationConfigRule {
                organization_config_rule_name: self.organization_config_rule_name,
                organization_config_rule_arn: self.organization_config_rule_arn,
                organization_managed_rule_metadata: self.organization_managed_rule_metadata,
                organization_custom_rule_metadata: self.organization_custom_rule_metadata,
                excluded_accounts: self.excluded_accounts,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl OrganizationConfigRule {
    /// Creates a new builder-style object to manufacture [`OrganizationConfigRule`](crate::model::OrganizationConfigRule)
    pub fn builder() -> crate::model::organization_config_rule::Builder {
        crate::model::organization_config_rule::Builder::default()
    }
}

/// <p>The status of a specified delivery channel.</p>
/// <p>Valid values: <code>Success</code> | <code>Failure</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeliveryChannelStatus {
    /// <p>The name of the delivery channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list containing the status of the delivery of the snapshot to
    /// the specified Amazon S3 bucket.</p>
    pub config_snapshot_delivery_info: std::option::Option<crate::model::ConfigExportDeliveryInfo>,
    /// <p>A list that contains the status of the delivery of the
    /// configuration history to the specified Amazon S3 bucket.</p>
    pub config_history_delivery_info: std::option::Option<crate::model::ConfigExportDeliveryInfo>,
    /// <p>A list containing the status of the delivery of the
    /// configuration stream notification to the specified Amazon SNS
    /// topic.</p>
    pub config_stream_delivery_info: std::option::Option<crate::model::ConfigStreamDeliveryInfo>,
}
impl DeliveryChannelStatus {
    /// <p>The name of the delivery channel.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list containing the status of the delivery of the snapshot to
    /// the specified Amazon S3 bucket.</p>
    pub fn config_snapshot_delivery_info(
        &self,
    ) -> std::option::Option<&crate::model::ConfigExportDeliveryInfo> {
        self.config_snapshot_delivery_info.as_ref()
    }
    /// <p>A list that contains the status of the delivery of the
    /// configuration history to the specified Amazon S3 bucket.</p>
    pub fn config_history_delivery_info(
        &self,
    ) -> std::option::Option<&crate::model::ConfigExportDeliveryInfo> {
        self.config_history_delivery_info.as_ref()
    }
    /// <p>A list containing the status of the delivery of the
    /// configuration stream notification to the specified Amazon SNS
    /// topic.</p>
    pub fn config_stream_delivery_info(
        &self,
    ) -> std::option::Option<&crate::model::ConfigStreamDeliveryInfo> {
        self.config_stream_delivery_info.as_ref()
    }
}
impl std::fmt::Debug for DeliveryChannelStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeliveryChannelStatus");
        formatter.field("name", &self.name);
        formatter.field(
            "config_snapshot_delivery_info",
            &self.config_snapshot_delivery_info,
        );
        formatter.field(
            "config_history_delivery_info",
            &self.config_history_delivery_info,
        );
        formatter.field(
            "config_stream_delivery_info",
            &self.config_stream_delivery_info,
        );
        formatter.finish()
    }
}
/// See [`DeliveryChannelStatus`](crate::model::DeliveryChannelStatus)
pub mod delivery_channel_status {
    /// A builder for [`DeliveryChannelStatus`](crate::model::DeliveryChannelStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) config_snapshot_delivery_info:
            std::option::Option<crate::model::ConfigExportDeliveryInfo>,
        pub(crate) config_history_delivery_info:
            std::option::Option<crate::model::ConfigExportDeliveryInfo>,
        pub(crate) config_stream_delivery_info:
            std::option::Option<crate::model::ConfigStreamDeliveryInfo>,
    }
    impl Builder {
        /// <p>The name of the delivery channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the delivery channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A list containing the status of the delivery of the snapshot to
        /// the specified Amazon S3 bucket.</p>
        pub fn config_snapshot_delivery_info(
            mut self,
            input: crate::model::ConfigExportDeliveryInfo,
        ) -> Self {
            self.config_snapshot_delivery_info = Some(input);
            self
        }
        /// <p>A list containing the status of the delivery of the snapshot to
        /// the specified Amazon S3 bucket.</p>
        pub fn set_config_snapshot_delivery_info(
            mut self,
            input: std::option::Option<crate::model::ConfigExportDeliveryInfo>,
        ) -> Self {
            self.config_snapshot_delivery_info = input;
            self
        }
        /// <p>A list that contains the status of the delivery of the
        /// configuration history to the specified Amazon S3 bucket.</p>
        pub fn config_history_delivery_info(
            mut self,
            input: crate::model::ConfigExportDeliveryInfo,
        ) -> Self {
            self.config_history_delivery_info = Some(input);
            self
        }
        /// <p>A list that contains the status of the delivery of the
        /// configuration history to the specified Amazon S3 bucket.</p>
        pub fn set_config_history_delivery_info(
            mut self,
            input: std::option::Option<crate::model::ConfigExportDeliveryInfo>,
        ) -> Self {
            self.config_history_delivery_info = input;
            self
        }
        /// <p>A list containing the status of the delivery of the
        /// configuration stream notification to the specified Amazon SNS
        /// topic.</p>
        pub fn config_stream_delivery_info(
            mut self,
            input: crate::model::ConfigStreamDeliveryInfo,
        ) -> Self {
            self.config_stream_delivery_info = Some(input);
            self
        }
        /// <p>A list containing the status of the delivery of the
        /// configuration stream notification to the specified Amazon SNS
        /// topic.</p>
        pub fn set_config_stream_delivery_info(
            mut self,
            input: std::option::Option<crate::model::ConfigStreamDeliveryInfo>,
        ) -> Self {
            self.config_stream_delivery_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DeliveryChannelStatus`](crate::model::DeliveryChannelStatus)
        pub fn build(self) -> crate::model::DeliveryChannelStatus {
            crate::model::DeliveryChannelStatus {
                name: self.name,
                config_snapshot_delivery_info: self.config_snapshot_delivery_info,
                config_history_delivery_info: self.config_history_delivery_info,
                config_stream_delivery_info: self.config_stream_delivery_info,
            }
        }
    }
}
impl DeliveryChannelStatus {
    /// Creates a new builder-style object to manufacture [`DeliveryChannelStatus`](crate::model::DeliveryChannelStatus)
    pub fn builder() -> crate::model::delivery_channel_status::Builder {
        crate::model::delivery_channel_status::Builder::default()
    }
}

/// <p>A list that contains the status of the delivery of the
/// configuration stream notification to the Amazon SNS topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigStreamDeliveryInfo {
    /// <p>Status of the last attempted delivery.</p>
    /// <p>
    /// <b>Note</b> Providing an SNS topic on a
    /// <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a> for Config is optional. If the SNS
    /// delivery is turned off, the last status will be <b>Not_Applicable</b>.</p>
    pub last_status: std::option::Option<crate::model::DeliveryStatus>,
    /// <p>The error code from the last attempted delivery.</p>
    pub last_error_code: std::option::Option<std::string::String>,
    /// <p>The error message from the last attempted delivery.</p>
    pub last_error_message: std::option::Option<std::string::String>,
    /// <p>The time from the last status change.</p>
    pub last_status_change_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ConfigStreamDeliveryInfo {
    /// <p>Status of the last attempted delivery.</p>
    /// <p>
    /// <b>Note</b> Providing an SNS topic on a
    /// <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a> for Config is optional. If the SNS
    /// delivery is turned off, the last status will be <b>Not_Applicable</b>.</p>
    pub fn last_status(&self) -> std::option::Option<&crate::model::DeliveryStatus> {
        self.last_status.as_ref()
    }
    /// <p>The error code from the last attempted delivery.</p>
    pub fn last_error_code(&self) -> std::option::Option<&str> {
        self.last_error_code.as_deref()
    }
    /// <p>The error message from the last attempted delivery.</p>
    pub fn last_error_message(&self) -> std::option::Option<&str> {
        self.last_error_message.as_deref()
    }
    /// <p>The time from the last status change.</p>
    pub fn last_status_change_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_status_change_time.as_ref()
    }
}
impl std::fmt::Debug for ConfigStreamDeliveryInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigStreamDeliveryInfo");
        formatter.field("last_status", &self.last_status);
        formatter.field("last_error_code", &self.last_error_code);
        formatter.field("last_error_message", &self.last_error_message);
        formatter.field("last_status_change_time", &self.last_status_change_time);
        formatter.finish()
    }
}
/// See [`ConfigStreamDeliveryInfo`](crate::model::ConfigStreamDeliveryInfo)
pub mod config_stream_delivery_info {
    /// A builder for [`ConfigStreamDeliveryInfo`](crate::model::ConfigStreamDeliveryInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_status: std::option::Option<crate::model::DeliveryStatus>,
        pub(crate) last_error_code: std::option::Option<std::string::String>,
        pub(crate) last_error_message: std::option::Option<std::string::String>,
        pub(crate) last_status_change_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Status of the last attempted delivery.</p>
        /// <p>
        /// <b>Note</b> Providing an SNS topic on a
        /// <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a> for Config is optional. If the SNS
        /// delivery is turned off, the last status will be <b>Not_Applicable</b>.</p>
        pub fn last_status(mut self, input: crate::model::DeliveryStatus) -> Self {
            self.last_status = Some(input);
            self
        }
        /// <p>Status of the last attempted delivery.</p>
        /// <p>
        /// <b>Note</b> Providing an SNS topic on a
        /// <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a> for Config is optional. If the SNS
        /// delivery is turned off, the last status will be <b>Not_Applicable</b>.</p>
        pub fn set_last_status(
            mut self,
            input: std::option::Option<crate::model::DeliveryStatus>,
        ) -> Self {
            self.last_status = input;
            self
        }
        /// <p>The error code from the last attempted delivery.</p>
        pub fn last_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_error_code = Some(input.into());
            self
        }
        /// <p>The error code from the last attempted delivery.</p>
        pub fn set_last_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_error_code = input;
            self
        }
        /// <p>The error message from the last attempted delivery.</p>
        pub fn last_error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_error_message = Some(input.into());
            self
        }
        /// <p>The error message from the last attempted delivery.</p>
        pub fn set_last_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_error_message = input;
            self
        }
        /// <p>The time from the last status change.</p>
        pub fn last_status_change_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_status_change_time = Some(input);
            self
        }
        /// <p>The time from the last status change.</p>
        pub fn set_last_status_change_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_status_change_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigStreamDeliveryInfo`](crate::model::ConfigStreamDeliveryInfo)
        pub fn build(self) -> crate::model::ConfigStreamDeliveryInfo {
            crate::model::ConfigStreamDeliveryInfo {
                last_status: self.last_status,
                last_error_code: self.last_error_code,
                last_error_message: self.last_error_message,
                last_status_change_time: self.last_status_change_time,
            }
        }
    }
}
impl ConfigStreamDeliveryInfo {
    /// Creates a new builder-style object to manufacture [`ConfigStreamDeliveryInfo`](crate::model::ConfigStreamDeliveryInfo)
    pub fn builder() -> crate::model::config_stream_delivery_info::Builder {
        crate::model::config_stream_delivery_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeliveryStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failure,
    #[allow(missing_docs)] // documentation missing in model
    NotApplicable,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeliveryStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failure" => DeliveryStatus::Failure,
            "Not_Applicable" => DeliveryStatus::NotApplicable,
            "Success" => DeliveryStatus::Success,
            other => DeliveryStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeliveryStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeliveryStatus::from(s))
    }
}
impl DeliveryStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeliveryStatus::Failure => "Failure",
            DeliveryStatus::NotApplicable => "Not_Applicable",
            DeliveryStatus::Success => "Success",
            DeliveryStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failure", "Not_Applicable", "Success"]
    }
}
impl AsRef<str> for DeliveryStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides status of the delivery of the snapshot or the
/// configuration history to the specified Amazon S3 bucket. Also
/// provides the status of notifications about the Amazon S3 delivery to
/// the specified Amazon SNS topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigExportDeliveryInfo {
    /// <p>Status of the last attempted delivery.</p>
    pub last_status: std::option::Option<crate::model::DeliveryStatus>,
    /// <p>The error code from the last attempted delivery.</p>
    pub last_error_code: std::option::Option<std::string::String>,
    /// <p>The error message from the last attempted delivery.</p>
    pub last_error_message: std::option::Option<std::string::String>,
    /// <p>The time of the last attempted delivery.</p>
    pub last_attempt_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time of the last successful delivery.</p>
    pub last_successful_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the next delivery occurs.</p>
    pub next_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ConfigExportDeliveryInfo {
    /// <p>Status of the last attempted delivery.</p>
    pub fn last_status(&self) -> std::option::Option<&crate::model::DeliveryStatus> {
        self.last_status.as_ref()
    }
    /// <p>The error code from the last attempted delivery.</p>
    pub fn last_error_code(&self) -> std::option::Option<&str> {
        self.last_error_code.as_deref()
    }
    /// <p>The error message from the last attempted delivery.</p>
    pub fn last_error_message(&self) -> std::option::Option<&str> {
        self.last_error_message.as_deref()
    }
    /// <p>The time of the last attempted delivery.</p>
    pub fn last_attempt_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_attempt_time.as_ref()
    }
    /// <p>The time of the last successful delivery.</p>
    pub fn last_successful_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_successful_time.as_ref()
    }
    /// <p>The time that the next delivery occurs.</p>
    pub fn next_delivery_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.next_delivery_time.as_ref()
    }
}
impl std::fmt::Debug for ConfigExportDeliveryInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigExportDeliveryInfo");
        formatter.field("last_status", &self.last_status);
        formatter.field("last_error_code", &self.last_error_code);
        formatter.field("last_error_message", &self.last_error_message);
        formatter.field("last_attempt_time", &self.last_attempt_time);
        formatter.field("last_successful_time", &self.last_successful_time);
        formatter.field("next_delivery_time", &self.next_delivery_time);
        formatter.finish()
    }
}
/// See [`ConfigExportDeliveryInfo`](crate::model::ConfigExportDeliveryInfo)
pub mod config_export_delivery_info {
    /// A builder for [`ConfigExportDeliveryInfo`](crate::model::ConfigExportDeliveryInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_status: std::option::Option<crate::model::DeliveryStatus>,
        pub(crate) last_error_code: std::option::Option<std::string::String>,
        pub(crate) last_error_message: std::option::Option<std::string::String>,
        pub(crate) last_attempt_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_successful_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) next_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Status of the last attempted delivery.</p>
        pub fn last_status(mut self, input: crate::model::DeliveryStatus) -> Self {
            self.last_status = Some(input);
            self
        }
        /// <p>Status of the last attempted delivery.</p>
        pub fn set_last_status(
            mut self,
            input: std::option::Option<crate::model::DeliveryStatus>,
        ) -> Self {
            self.last_status = input;
            self
        }
        /// <p>The error code from the last attempted delivery.</p>
        pub fn last_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_error_code = Some(input.into());
            self
        }
        /// <p>The error code from the last attempted delivery.</p>
        pub fn set_last_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_error_code = input;
            self
        }
        /// <p>The error message from the last attempted delivery.</p>
        pub fn last_error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_error_message = Some(input.into());
            self
        }
        /// <p>The error message from the last attempted delivery.</p>
        pub fn set_last_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_error_message = input;
            self
        }
        /// <p>The time of the last attempted delivery.</p>
        pub fn last_attempt_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_attempt_time = Some(input);
            self
        }
        /// <p>The time of the last attempted delivery.</p>
        pub fn set_last_attempt_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_attempt_time = input;
            self
        }
        /// <p>The time of the last successful delivery.</p>
        pub fn last_successful_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_successful_time = Some(input);
            self
        }
        /// <p>The time of the last successful delivery.</p>
        pub fn set_last_successful_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_successful_time = input;
            self
        }
        /// <p>The time that the next delivery occurs.</p>
        pub fn next_delivery_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.next_delivery_time = Some(input);
            self
        }
        /// <p>The time that the next delivery occurs.</p>
        pub fn set_next_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.next_delivery_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigExportDeliveryInfo`](crate::model::ConfigExportDeliveryInfo)
        pub fn build(self) -> crate::model::ConfigExportDeliveryInfo {
            crate::model::ConfigExportDeliveryInfo {
                last_status: self.last_status,
                last_error_code: self.last_error_code,
                last_error_message: self.last_error_message,
                last_attempt_time: self.last_attempt_time,
                last_successful_time: self.last_successful_time,
                next_delivery_time: self.next_delivery_time,
            }
        }
    }
}
impl ConfigExportDeliveryInfo {
    /// Creates a new builder-style object to manufacture [`ConfigExportDeliveryInfo`](crate::model::ConfigExportDeliveryInfo)
    pub fn builder() -> crate::model::config_export_delivery_info::Builder {
        crate::model::config_export_delivery_info::Builder::default()
    }
}

/// <p>Status details of a conformance pack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConformancePackStatusDetail {
    /// <p>Name of the conformance pack.</p>
    pub conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>ID of the conformance pack.</p>
    pub conformance_pack_id: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of comformance pack.</p>
    pub conformance_pack_arn: std::option::Option<std::string::String>,
    /// <p>Indicates deployment status of conformance pack.</p>
    /// <p>Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.</p>
    /// </li>
    /// <li>
    /// <p>CREATE_COMPLETE when a conformance pack has been successfully created in your account.</p>
    /// </li>
    /// <li>
    /// <p>CREATE_FAILED when a conformance pack creation failed in your account.</p>
    /// </li>
    /// <li>
    /// <p>DELETE_IN_PROGRESS when a conformance pack deletion is in progress. </p>
    /// </li>
    /// <li>
    /// <p>DELETE_FAILED when a conformance pack deletion failed in your account.</p>
    /// </li>
    /// </ul>
    pub conformance_pack_state: std::option::Option<crate::model::ConformancePackState>,
    /// <p>Amazon Resource Name (ARN) of CloudFormation stack. </p>
    pub stack_arn: std::option::Option<std::string::String>,
    /// <p>The reason of conformance pack creation failure.</p>
    pub conformance_pack_status_reason: std::option::Option<std::string::String>,
    /// <p>Last time when conformation pack creation and update was requested.</p>
    pub last_update_requested_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Last time when conformation pack creation and update was successful.</p>
    pub last_update_completed_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ConformancePackStatusDetail {
    /// <p>Name of the conformance pack.</p>
    pub fn conformance_pack_name(&self) -> std::option::Option<&str> {
        self.conformance_pack_name.as_deref()
    }
    /// <p>ID of the conformance pack.</p>
    pub fn conformance_pack_id(&self) -> std::option::Option<&str> {
        self.conformance_pack_id.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of comformance pack.</p>
    pub fn conformance_pack_arn(&self) -> std::option::Option<&str> {
        self.conformance_pack_arn.as_deref()
    }
    /// <p>Indicates deployment status of conformance pack.</p>
    /// <p>Config sets the state of the conformance pack to:</p>
    /// <ul>
    /// <li>
    /// <p>CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.</p>
    /// </li>
    /// <li>
    /// <p>CREATE_COMPLETE when a conformance pack has been successfully created in your account.</p>
    /// </li>
    /// <li>
    /// <p>CREATE_FAILED when a conformance pack creation failed in your account.</p>
    /// </li>
    /// <li>
    /// <p>DELETE_IN_PROGRESS when a conformance pack deletion is in progress. </p>
    /// </li>
    /// <li>
    /// <p>DELETE_FAILED when a conformance pack deletion failed in your account.</p>
    /// </li>
    /// </ul>
    pub fn conformance_pack_state(
        &self,
    ) -> std::option::Option<&crate::model::ConformancePackState> {
        self.conformance_pack_state.as_ref()
    }
    /// <p>Amazon Resource Name (ARN) of CloudFormation stack. </p>
    pub fn stack_arn(&self) -> std::option::Option<&str> {
        self.stack_arn.as_deref()
    }
    /// <p>The reason of conformance pack creation failure.</p>
    pub fn conformance_pack_status_reason(&self) -> std::option::Option<&str> {
        self.conformance_pack_status_reason.as_deref()
    }
    /// <p>Last time when conformation pack creation and update was requested.</p>
    pub fn last_update_requested_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_requested_time.as_ref()
    }
    /// <p>Last time when conformation pack creation and update was successful.</p>
    pub fn last_update_completed_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_completed_time.as_ref()
    }
}
impl std::fmt::Debug for ConformancePackStatusDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConformancePackStatusDetail");
        formatter.field("conformance_pack_name", &self.conformance_pack_name);
        formatter.field("conformance_pack_id", &self.conformance_pack_id);
        formatter.field("conformance_pack_arn", &self.conformance_pack_arn);
        formatter.field("conformance_pack_state", &self.conformance_pack_state);
        formatter.field("stack_arn", &self.stack_arn);
        formatter.field(
            "conformance_pack_status_reason",
            &self.conformance_pack_status_reason,
        );
        formatter.field(
            "last_update_requested_time",
            &self.last_update_requested_time,
        );
        formatter.field(
            "last_update_completed_time",
            &self.last_update_completed_time,
        );
        formatter.finish()
    }
}
/// See [`ConformancePackStatusDetail`](crate::model::ConformancePackStatusDetail)
pub mod conformance_pack_status_detail {
    /// A builder for [`ConformancePackStatusDetail`](crate::model::ConformancePackStatusDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_id: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_arn: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_state: std::option::Option<crate::model::ConformancePackState>,
        pub(crate) stack_arn: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_status_reason: std::option::Option<std::string::String>,
        pub(crate) last_update_requested_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_completed_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Name of the conformance pack.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_name = Some(input.into());
            self
        }
        /// <p>Name of the conformance pack.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_name = input;
            self
        }
        /// <p>ID of the conformance pack.</p>
        pub fn conformance_pack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_id = Some(input.into());
            self
        }
        /// <p>ID of the conformance pack.</p>
        pub fn set_conformance_pack_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_id = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of comformance pack.</p>
        pub fn conformance_pack_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of comformance pack.</p>
        pub fn set_conformance_pack_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_arn = input;
            self
        }
        /// <p>Indicates deployment status of conformance pack.</p>
        /// <p>Config sets the state of the conformance pack to:</p>
        /// <ul>
        /// <li>
        /// <p>CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.</p>
        /// </li>
        /// <li>
        /// <p>CREATE_COMPLETE when a conformance pack has been successfully created in your account.</p>
        /// </li>
        /// <li>
        /// <p>CREATE_FAILED when a conformance pack creation failed in your account.</p>
        /// </li>
        /// <li>
        /// <p>DELETE_IN_PROGRESS when a conformance pack deletion is in progress. </p>
        /// </li>
        /// <li>
        /// <p>DELETE_FAILED when a conformance pack deletion failed in your account.</p>
        /// </li>
        /// </ul>
        pub fn conformance_pack_state(mut self, input: crate::model::ConformancePackState) -> Self {
            self.conformance_pack_state = Some(input);
            self
        }
        /// <p>Indicates deployment status of conformance pack.</p>
        /// <p>Config sets the state of the conformance pack to:</p>
        /// <ul>
        /// <li>
        /// <p>CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.</p>
        /// </li>
        /// <li>
        /// <p>CREATE_COMPLETE when a conformance pack has been successfully created in your account.</p>
        /// </li>
        /// <li>
        /// <p>CREATE_FAILED when a conformance pack creation failed in your account.</p>
        /// </li>
        /// <li>
        /// <p>DELETE_IN_PROGRESS when a conformance pack deletion is in progress. </p>
        /// </li>
        /// <li>
        /// <p>DELETE_FAILED when a conformance pack deletion failed in your account.</p>
        /// </li>
        /// </ul>
        pub fn set_conformance_pack_state(
            mut self,
            input: std::option::Option<crate::model::ConformancePackState>,
        ) -> Self {
            self.conformance_pack_state = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of CloudFormation stack. </p>
        pub fn stack_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of CloudFormation stack. </p>
        pub fn set_stack_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_arn = input;
            self
        }
        /// <p>The reason of conformance pack creation failure.</p>
        pub fn conformance_pack_status_reason(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.conformance_pack_status_reason = Some(input.into());
            self
        }
        /// <p>The reason of conformance pack creation failure.</p>
        pub fn set_conformance_pack_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_status_reason = input;
            self
        }
        /// <p>Last time when conformation pack creation and update was requested.</p>
        pub fn last_update_requested_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_requested_time = Some(input);
            self
        }
        /// <p>Last time when conformation pack creation and update was requested.</p>
        pub fn set_last_update_requested_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_requested_time = input;
            self
        }
        /// <p>Last time when conformation pack creation and update was successful.</p>
        pub fn last_update_completed_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_completed_time = Some(input);
            self
        }
        /// <p>Last time when conformation pack creation and update was successful.</p>
        pub fn set_last_update_completed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_completed_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ConformancePackStatusDetail`](crate::model::ConformancePackStatusDetail)
        pub fn build(self) -> crate::model::ConformancePackStatusDetail {
            crate::model::ConformancePackStatusDetail {
                conformance_pack_name: self.conformance_pack_name,
                conformance_pack_id: self.conformance_pack_id,
                conformance_pack_arn: self.conformance_pack_arn,
                conformance_pack_state: self.conformance_pack_state,
                stack_arn: self.stack_arn,
                conformance_pack_status_reason: self.conformance_pack_status_reason,
                last_update_requested_time: self.last_update_requested_time,
                last_update_completed_time: self.last_update_completed_time,
            }
        }
    }
}
impl ConformancePackStatusDetail {
    /// Creates a new builder-style object to manufacture [`ConformancePackStatusDetail`](crate::model::ConformancePackStatusDetail)
    pub fn builder() -> crate::model::conformance_pack_status_detail::Builder {
        crate::model::conformance_pack_status_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConformancePackState {
    #[allow(missing_docs)] // documentation missing in model
    CreateComplete,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConformancePackState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_COMPLETE" => ConformancePackState::CreateComplete,
            "CREATE_FAILED" => ConformancePackState::CreateFailed,
            "CREATE_IN_PROGRESS" => ConformancePackState::CreateInProgress,
            "DELETE_FAILED" => ConformancePackState::DeleteFailed,
            "DELETE_IN_PROGRESS" => ConformancePackState::DeleteInProgress,
            other => ConformancePackState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConformancePackState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConformancePackState::from(s))
    }
}
impl ConformancePackState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConformancePackState::CreateComplete => "CREATE_COMPLETE",
            ConformancePackState::CreateFailed => "CREATE_FAILED",
            ConformancePackState::CreateInProgress => "CREATE_IN_PROGRESS",
            ConformancePackState::DeleteFailed => "DELETE_FAILED",
            ConformancePackState::DeleteInProgress => "DELETE_IN_PROGRESS",
            ConformancePackState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_COMPLETE",
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for ConformancePackState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns details of a conformance pack. A conformance pack is a collection of Config rules and remediation actions that can be easily deployed in an account and a region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConformancePackDetail {
    /// <p>Name of the conformance pack.</p>
    pub conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the conformance pack.</p>
    pub conformance_pack_arn: std::option::Option<std::string::String>,
    /// <p>ID of the conformance pack.</p>
    pub conformance_pack_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates. </p>
    /// <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub delivery_s3_bucket: std::option::Option<std::string::String>,
    /// <p>The prefix for the Amazon S3 bucket.</p>
    /// <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub delivery_s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub conformance_pack_input_parameters:
        std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
    /// <p>Last time when conformation pack update was requested. </p>
    pub last_update_requested_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Amazon Web Services service that created the conformance pack.</p>
    pub created_by: std::option::Option<std::string::String>,
}
impl ConformancePackDetail {
    /// <p>Name of the conformance pack.</p>
    pub fn conformance_pack_name(&self) -> std::option::Option<&str> {
        self.conformance_pack_name.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the conformance pack.</p>
    pub fn conformance_pack_arn(&self) -> std::option::Option<&str> {
        self.conformance_pack_arn.as_deref()
    }
    /// <p>ID of the conformance pack.</p>
    pub fn conformance_pack_id(&self) -> std::option::Option<&str> {
        self.conformance_pack_id.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates. </p>
    /// <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_bucket(&self) -> std::option::Option<&str> {
        self.delivery_s3_bucket.as_deref()
    }
    /// <p>The prefix for the Amazon S3 bucket.</p>
    /// <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_key_prefix(&self) -> std::option::Option<&str> {
        self.delivery_s3_key_prefix.as_deref()
    }
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub fn conformance_pack_input_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::ConformancePackInputParameter]> {
        self.conformance_pack_input_parameters.as_deref()
    }
    /// <p>Last time when conformation pack update was requested. </p>
    pub fn last_update_requested_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_requested_time.as_ref()
    }
    /// <p>Amazon Web Services service that created the conformance pack.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
}
impl std::fmt::Debug for ConformancePackDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConformancePackDetail");
        formatter.field("conformance_pack_name", &self.conformance_pack_name);
        formatter.field("conformance_pack_arn", &self.conformance_pack_arn);
        formatter.field("conformance_pack_id", &self.conformance_pack_id);
        formatter.field("delivery_s3_bucket", &self.delivery_s3_bucket);
        formatter.field("delivery_s3_key_prefix", &self.delivery_s3_key_prefix);
        formatter.field(
            "conformance_pack_input_parameters",
            &self.conformance_pack_input_parameters,
        );
        formatter.field(
            "last_update_requested_time",
            &self.last_update_requested_time,
        );
        formatter.field("created_by", &self.created_by);
        formatter.finish()
    }
}
/// See [`ConformancePackDetail`](crate::model::ConformancePackDetail)
pub mod conformance_pack_detail {
    /// A builder for [`ConformancePackDetail`](crate::model::ConformancePackDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_arn: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_id: std::option::Option<std::string::String>,
        pub(crate) delivery_s3_bucket: std::option::Option<std::string::String>,
        pub(crate) delivery_s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_input_parameters:
            std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
        pub(crate) last_update_requested_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the conformance pack.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_name = Some(input.into());
            self
        }
        /// <p>Name of the conformance pack.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_name = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the conformance pack.</p>
        pub fn conformance_pack_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the conformance pack.</p>
        pub fn set_conformance_pack_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_arn = input;
            self
        }
        /// <p>ID of the conformance pack.</p>
        pub fn conformance_pack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_id = Some(input.into());
            self
        }
        /// <p>ID of the conformance pack.</p>
        pub fn set_conformance_pack_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_id = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates. </p>
        /// <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn delivery_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates. </p>
        /// <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn set_delivery_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_s3_bucket = input;
            self
        }
        /// <p>The prefix for the Amazon S3 bucket.</p>
        /// <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn delivery_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The prefix for the Amazon S3 bucket.</p>
        /// <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn set_delivery_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_s3_key_prefix = input;
            self
        }
        /// Appends an item to `conformance_pack_input_parameters`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_input_parameters`](Self::set_conformance_pack_input_parameters).
        ///
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn conformance_pack_input_parameters(
            mut self,
            input: impl Into<crate::model::ConformancePackInputParameter>,
        ) -> Self {
            let mut v = self.conformance_pack_input_parameters.unwrap_or_default();
            v.push(input.into());
            self.conformance_pack_input_parameters = Some(v);
            self
        }
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn set_conformance_pack_input_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
        ) -> Self {
            self.conformance_pack_input_parameters = input;
            self
        }
        /// <p>Last time when conformation pack update was requested. </p>
        pub fn last_update_requested_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_requested_time = Some(input);
            self
        }
        /// <p>Last time when conformation pack update was requested. </p>
        pub fn set_last_update_requested_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_requested_time = input;
            self
        }
        /// <p>Amazon Web Services service that created the conformance pack.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>Amazon Web Services service that created the conformance pack.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ConformancePackDetail`](crate::model::ConformancePackDetail)
        pub fn build(self) -> crate::model::ConformancePackDetail {
            crate::model::ConformancePackDetail {
                conformance_pack_name: self.conformance_pack_name,
                conformance_pack_arn: self.conformance_pack_arn,
                conformance_pack_id: self.conformance_pack_id,
                delivery_s3_bucket: self.delivery_s3_bucket,
                delivery_s3_key_prefix: self.delivery_s3_key_prefix,
                conformance_pack_input_parameters: self.conformance_pack_input_parameters,
                last_update_requested_time: self.last_update_requested_time,
                created_by: self.created_by,
            }
        }
    }
}
impl ConformancePackDetail {
    /// Creates a new builder-style object to manufacture [`ConformancePackDetail`](crate::model::ConformancePackDetail)
    pub fn builder() -> crate::model::conformance_pack_detail::Builder {
        crate::model::conformance_pack_detail::Builder::default()
    }
}

/// <p>Compliance information of one or more Config rules within a conformance pack. You can filter using Config rule names and compliance types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConformancePackRuleCompliance {
    /// <p>Name of the config rule.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>Compliance of the Config rule.</p>
    /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>
    pub compliance_type: std::option::Option<crate::model::ConformancePackComplianceType>,
    /// <p>Controls for the conformance pack. A control is a process to prevent or detect problems while meeting objectives.
    /// A control can align with a specific compliance regime or map to internal controls defined by an organization.</p>
    pub controls: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ConformancePackRuleCompliance {
    /// <p>Name of the config rule.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>Compliance of the Config rule.</p>
    /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>
    pub fn compliance_type(
        &self,
    ) -> std::option::Option<&crate::model::ConformancePackComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>Controls for the conformance pack. A control is a process to prevent or detect problems while meeting objectives.
    /// A control can align with a specific compliance regime or map to internal controls defined by an organization.</p>
    pub fn controls(&self) -> std::option::Option<&[std::string::String]> {
        self.controls.as_deref()
    }
}
impl std::fmt::Debug for ConformancePackRuleCompliance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConformancePackRuleCompliance");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("controls", &self.controls);
        formatter.finish()
    }
}
/// See [`ConformancePackRuleCompliance`](crate::model::ConformancePackRuleCompliance)
pub mod conformance_pack_rule_compliance {
    /// A builder for [`ConformancePackRuleCompliance`](crate::model::ConformancePackRuleCompliance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) compliance_type:
            std::option::Option<crate::model::ConformancePackComplianceType>,
        pub(crate) controls: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Name of the config rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>Name of the config rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>Compliance of the Config rule.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>
        pub fn compliance_type(
            mut self,
            input: crate::model::ConformancePackComplianceType,
        ) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>Compliance of the Config rule.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ConformancePackComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// Appends an item to `controls`.
        ///
        /// To override the contents of this collection use [`set_controls`](Self::set_controls).
        ///
        /// <p>Controls for the conformance pack. A control is a process to prevent or detect problems while meeting objectives.
        /// A control can align with a specific compliance regime or map to internal controls defined by an organization.</p>
        pub fn controls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.controls.unwrap_or_default();
            v.push(input.into());
            self.controls = Some(v);
            self
        }
        /// <p>Controls for the conformance pack. A control is a process to prevent or detect problems while meeting objectives.
        /// A control can align with a specific compliance regime or map to internal controls defined by an organization.</p>
        pub fn set_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.controls = input;
            self
        }
        /// Consumes the builder and constructs a [`ConformancePackRuleCompliance`](crate::model::ConformancePackRuleCompliance)
        pub fn build(self) -> crate::model::ConformancePackRuleCompliance {
            crate::model::ConformancePackRuleCompliance {
                config_rule_name: self.config_rule_name,
                compliance_type: self.compliance_type,
                controls: self.controls,
            }
        }
    }
}
impl ConformancePackRuleCompliance {
    /// Creates a new builder-style object to manufacture [`ConformancePackRuleCompliance`](crate::model::ConformancePackRuleCompliance)
    pub fn builder() -> crate::model::conformance_pack_rule_compliance::Builder {
        crate::model::conformance_pack_rule_compliance::Builder::default()
    }
}

/// <p>Filters the conformance pack by compliance types and Config rule names.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConformancePackComplianceFilters {
    /// <p>Filters the results by Config rule names.</p>
    pub config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
    pub compliance_type: std::option::Option<crate::model::ConformancePackComplianceType>,
}
impl ConformancePackComplianceFilters {
    /// <p>Filters the results by Config rule names.</p>
    pub fn config_rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.config_rule_names.as_deref()
    }
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
    pub fn compliance_type(
        &self,
    ) -> std::option::Option<&crate::model::ConformancePackComplianceType> {
        self.compliance_type.as_ref()
    }
}
impl std::fmt::Debug for ConformancePackComplianceFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConformancePackComplianceFilters");
        formatter.field("config_rule_names", &self.config_rule_names);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.finish()
    }
}
/// See [`ConformancePackComplianceFilters`](crate::model::ConformancePackComplianceFilters)
pub mod conformance_pack_compliance_filters {
    /// A builder for [`ConformancePackComplianceFilters`](crate::model::ConformancePackComplianceFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) compliance_type:
            std::option::Option<crate::model::ConformancePackComplianceType>,
    }
    impl Builder {
        /// Appends an item to `config_rule_names`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>Filters the results by Config rule names.</p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.config_rule_names.unwrap_or_default();
            v.push(input.into());
            self.config_rule_names = Some(v);
            self
        }
        /// <p>Filters the results by Config rule names.</p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.config_rule_names = input;
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
        pub fn compliance_type(
            mut self,
            input: crate::model::ConformancePackComplianceType,
        ) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ConformancePackComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConformancePackComplianceFilters`](crate::model::ConformancePackComplianceFilters)
        pub fn build(self) -> crate::model::ConformancePackComplianceFilters {
            crate::model::ConformancePackComplianceFilters {
                config_rule_names: self.config_rule_names,
                compliance_type: self.compliance_type,
            }
        }
    }
}
impl ConformancePackComplianceFilters {
    /// Creates a new builder-style object to manufacture [`ConformancePackComplianceFilters`](crate::model::ConformancePackComplianceFilters)
    pub fn builder() -> crate::model::conformance_pack_compliance_filters::Builder {
        crate::model::conformance_pack_compliance_filters::Builder::default()
    }
}

/// <p>The current status of the configuration recorder.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationRecorderStatus {
    /// <p>The name of the configuration recorder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time the recorder was last started.</p>
    pub last_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the recorder was last stopped.</p>
    pub last_stop_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies whether or not the recorder is currently
    /// recording.</p>
    pub recording: bool,
    /// <p>The last (previous) status of the recorder.</p>
    pub last_status: std::option::Option<crate::model::RecorderStatus>,
    /// <p>The error code indicating that the recording failed.</p>
    pub last_error_code: std::option::Option<std::string::String>,
    /// <p>The message indicating that the recording failed due to an
    /// error.</p>
    pub last_error_message: std::option::Option<std::string::String>,
    /// <p>The time when the status was last changed.</p>
    pub last_status_change_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ConfigurationRecorderStatus {
    /// <p>The name of the configuration recorder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time the recorder was last started.</p>
    pub fn last_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_start_time.as_ref()
    }
    /// <p>The time the recorder was last stopped.</p>
    pub fn last_stop_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_stop_time.as_ref()
    }
    /// <p>Specifies whether or not the recorder is currently
    /// recording.</p>
    pub fn recording(&self) -> bool {
        self.recording
    }
    /// <p>The last (previous) status of the recorder.</p>
    pub fn last_status(&self) -> std::option::Option<&crate::model::RecorderStatus> {
        self.last_status.as_ref()
    }
    /// <p>The error code indicating that the recording failed.</p>
    pub fn last_error_code(&self) -> std::option::Option<&str> {
        self.last_error_code.as_deref()
    }
    /// <p>The message indicating that the recording failed due to an
    /// error.</p>
    pub fn last_error_message(&self) -> std::option::Option<&str> {
        self.last_error_message.as_deref()
    }
    /// <p>The time when the status was last changed.</p>
    pub fn last_status_change_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_status_change_time.as_ref()
    }
}
impl std::fmt::Debug for ConfigurationRecorderStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationRecorderStatus");
        formatter.field("name", &self.name);
        formatter.field("last_start_time", &self.last_start_time);
        formatter.field("last_stop_time", &self.last_stop_time);
        formatter.field("recording", &self.recording);
        formatter.field("last_status", &self.last_status);
        formatter.field("last_error_code", &self.last_error_code);
        formatter.field("last_error_message", &self.last_error_message);
        formatter.field("last_status_change_time", &self.last_status_change_time);
        formatter.finish()
    }
}
/// See [`ConfigurationRecorderStatus`](crate::model::ConfigurationRecorderStatus)
pub mod configuration_recorder_status {
    /// A builder for [`ConfigurationRecorderStatus`](crate::model::ConfigurationRecorderStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) last_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_stop_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) recording: std::option::Option<bool>,
        pub(crate) last_status: std::option::Option<crate::model::RecorderStatus>,
        pub(crate) last_error_code: std::option::Option<std::string::String>,
        pub(crate) last_error_message: std::option::Option<std::string::String>,
        pub(crate) last_status_change_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the configuration recorder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration recorder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time the recorder was last started.</p>
        pub fn last_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_start_time = Some(input);
            self
        }
        /// <p>The time the recorder was last started.</p>
        pub fn set_last_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_start_time = input;
            self
        }
        /// <p>The time the recorder was last stopped.</p>
        pub fn last_stop_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_stop_time = Some(input);
            self
        }
        /// <p>The time the recorder was last stopped.</p>
        pub fn set_last_stop_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_stop_time = input;
            self
        }
        /// <p>Specifies whether or not the recorder is currently
        /// recording.</p>
        pub fn recording(mut self, input: bool) -> Self {
            self.recording = Some(input);
            self
        }
        /// <p>Specifies whether or not the recorder is currently
        /// recording.</p>
        pub fn set_recording(mut self, input: std::option::Option<bool>) -> Self {
            self.recording = input;
            self
        }
        /// <p>The last (previous) status of the recorder.</p>
        pub fn last_status(mut self, input: crate::model::RecorderStatus) -> Self {
            self.last_status = Some(input);
            self
        }
        /// <p>The last (previous) status of the recorder.</p>
        pub fn set_last_status(
            mut self,
            input: std::option::Option<crate::model::RecorderStatus>,
        ) -> Self {
            self.last_status = input;
            self
        }
        /// <p>The error code indicating that the recording failed.</p>
        pub fn last_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_error_code = Some(input.into());
            self
        }
        /// <p>The error code indicating that the recording failed.</p>
        pub fn set_last_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_error_code = input;
            self
        }
        /// <p>The message indicating that the recording failed due to an
        /// error.</p>
        pub fn last_error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_error_message = Some(input.into());
            self
        }
        /// <p>The message indicating that the recording failed due to an
        /// error.</p>
        pub fn set_last_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_error_message = input;
            self
        }
        /// <p>The time when the status was last changed.</p>
        pub fn last_status_change_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_status_change_time = Some(input);
            self
        }
        /// <p>The time when the status was last changed.</p>
        pub fn set_last_status_change_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_status_change_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationRecorderStatus`](crate::model::ConfigurationRecorderStatus)
        pub fn build(self) -> crate::model::ConfigurationRecorderStatus {
            crate::model::ConfigurationRecorderStatus {
                name: self.name,
                last_start_time: self.last_start_time,
                last_stop_time: self.last_stop_time,
                recording: self.recording.unwrap_or_default(),
                last_status: self.last_status,
                last_error_code: self.last_error_code,
                last_error_message: self.last_error_message,
                last_status_change_time: self.last_status_change_time,
            }
        }
    }
}
impl ConfigurationRecorderStatus {
    /// Creates a new builder-style object to manufacture [`ConfigurationRecorderStatus`](crate::model::ConfigurationRecorderStatus)
    pub fn builder() -> crate::model::configuration_recorder_status::Builder {
        crate::model::configuration_recorder_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecorderStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failure,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecorderStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failure" => RecorderStatus::Failure,
            "Pending" => RecorderStatus::Pending,
            "Success" => RecorderStatus::Success,
            other => RecorderStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecorderStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecorderStatus::from(s))
    }
}
impl RecorderStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecorderStatus::Failure => "Failure",
            RecorderStatus::Pending => "Pending",
            RecorderStatus::Success => "Success",
            RecorderStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failure", "Pending", "Success"]
    }
}
impl AsRef<str> for RecorderStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The current sync status between the source and the aggregator
/// account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregatedSourceStatus {
    /// <p>The source account ID or an organization.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The source account or an organization.</p>
    pub source_type: std::option::Option<crate::model::AggregatedSourceType>,
    /// <p>The region authorized to collect aggregated data.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>Filters the last updated status type.</p>
    /// <ul>
    /// <li>
    /// <p>Valid value FAILED indicates errors while moving
    /// data.</p>
    /// </li>
    /// <li>
    /// <p>Valid value SUCCEEDED indicates the data was
    /// successfully moved.</p>
    /// </li>
    /// <li>
    /// <p>Valid value OUTDATED indicates the data is not the most
    /// recent.</p>
    /// </li>
    /// </ul>
    pub last_update_status: std::option::Option<crate::model::AggregatedSourceStatusType>,
    /// <p>The time of the last update.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The error code that Config returned when the source account
    /// aggregation last failed.</p>
    pub last_error_code: std::option::Option<std::string::String>,
    /// <p>The message indicating that the source account aggregation
    /// failed due to an error.</p>
    pub last_error_message: std::option::Option<std::string::String>,
}
impl AggregatedSourceStatus {
    /// <p>The source account ID or an organization.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The source account or an organization.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::AggregatedSourceType> {
        self.source_type.as_ref()
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>Filters the last updated status type.</p>
    /// <ul>
    /// <li>
    /// <p>Valid value FAILED indicates errors while moving
    /// data.</p>
    /// </li>
    /// <li>
    /// <p>Valid value SUCCEEDED indicates the data was
    /// successfully moved.</p>
    /// </li>
    /// <li>
    /// <p>Valid value OUTDATED indicates the data is not the most
    /// recent.</p>
    /// </li>
    /// </ul>
    pub fn last_update_status(
        &self,
    ) -> std::option::Option<&crate::model::AggregatedSourceStatusType> {
        self.last_update_status.as_ref()
    }
    /// <p>The time of the last update.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The error code that Config returned when the source account
    /// aggregation last failed.</p>
    pub fn last_error_code(&self) -> std::option::Option<&str> {
        self.last_error_code.as_deref()
    }
    /// <p>The message indicating that the source account aggregation
    /// failed due to an error.</p>
    pub fn last_error_message(&self) -> std::option::Option<&str> {
        self.last_error_message.as_deref()
    }
}
impl std::fmt::Debug for AggregatedSourceStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregatedSourceStatus");
        formatter.field("source_id", &self.source_id);
        formatter.field("source_type", &self.source_type);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("last_update_status", &self.last_update_status);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("last_error_code", &self.last_error_code);
        formatter.field("last_error_message", &self.last_error_message);
        formatter.finish()
    }
}
/// See [`AggregatedSourceStatus`](crate::model::AggregatedSourceStatus)
pub mod aggregated_source_status {
    /// A builder for [`AggregatedSourceStatus`](crate::model::AggregatedSourceStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::AggregatedSourceType>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) last_update_status:
            std::option::Option<crate::model::AggregatedSourceStatusType>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_error_code: std::option::Option<std::string::String>,
        pub(crate) last_error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The source account ID or an organization.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The source account ID or an organization.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The source account or an organization.</p>
        pub fn source_type(mut self, input: crate::model::AggregatedSourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The source account or an organization.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::AggregatedSourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>Filters the last updated status type.</p>
        /// <ul>
        /// <li>
        /// <p>Valid value FAILED indicates errors while moving
        /// data.</p>
        /// </li>
        /// <li>
        /// <p>Valid value SUCCEEDED indicates the data was
        /// successfully moved.</p>
        /// </li>
        /// <li>
        /// <p>Valid value OUTDATED indicates the data is not the most
        /// recent.</p>
        /// </li>
        /// </ul>
        pub fn last_update_status(
            mut self,
            input: crate::model::AggregatedSourceStatusType,
        ) -> Self {
            self.last_update_status = Some(input);
            self
        }
        /// <p>Filters the last updated status type.</p>
        /// <ul>
        /// <li>
        /// <p>Valid value FAILED indicates errors while moving
        /// data.</p>
        /// </li>
        /// <li>
        /// <p>Valid value SUCCEEDED indicates the data was
        /// successfully moved.</p>
        /// </li>
        /// <li>
        /// <p>Valid value OUTDATED indicates the data is not the most
        /// recent.</p>
        /// </li>
        /// </ul>
        pub fn set_last_update_status(
            mut self,
            input: std::option::Option<crate::model::AggregatedSourceStatusType>,
        ) -> Self {
            self.last_update_status = input;
            self
        }
        /// <p>The time of the last update.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time of the last update.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The error code that Config returned when the source account
        /// aggregation last failed.</p>
        pub fn last_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_error_code = Some(input.into());
            self
        }
        /// <p>The error code that Config returned when the source account
        /// aggregation last failed.</p>
        pub fn set_last_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_error_code = input;
            self
        }
        /// <p>The message indicating that the source account aggregation
        /// failed due to an error.</p>
        pub fn last_error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_error_message = Some(input.into());
            self
        }
        /// <p>The message indicating that the source account aggregation
        /// failed due to an error.</p>
        pub fn set_last_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregatedSourceStatus`](crate::model::AggregatedSourceStatus)
        pub fn build(self) -> crate::model::AggregatedSourceStatus {
            crate::model::AggregatedSourceStatus {
                source_id: self.source_id,
                source_type: self.source_type,
                aws_region: self.aws_region,
                last_update_status: self.last_update_status,
                last_update_time: self.last_update_time,
                last_error_code: self.last_error_code,
                last_error_message: self.last_error_message,
            }
        }
    }
}
impl AggregatedSourceStatus {
    /// Creates a new builder-style object to manufacture [`AggregatedSourceStatus`](crate::model::AggregatedSourceStatus)
    pub fn builder() -> crate::model::aggregated_source_status::Builder {
        crate::model::aggregated_source_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregatedSourceStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Outdated,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregatedSourceStatusType {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => AggregatedSourceStatusType::Failed,
            "OUTDATED" => AggregatedSourceStatusType::Outdated,
            "SUCCEEDED" => AggregatedSourceStatusType::Succeeded,
            other => AggregatedSourceStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregatedSourceStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregatedSourceStatusType::from(s))
    }
}
impl AggregatedSourceStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregatedSourceStatusType::Failed => "FAILED",
            AggregatedSourceStatusType::Outdated => "OUTDATED",
            AggregatedSourceStatusType::Succeeded => "SUCCEEDED",
            AggregatedSourceStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "OUTDATED", "SUCCEEDED"]
    }
}
impl AsRef<str> for AggregatedSourceStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregatedSourceType {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    Organization,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregatedSourceType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => AggregatedSourceType::Account,
            "ORGANIZATION" => AggregatedSourceType::Organization,
            other => AggregatedSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregatedSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregatedSourceType::from(s))
    }
}
impl AggregatedSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregatedSourceType::Account => "ACCOUNT",
            AggregatedSourceType::Organization => "ORGANIZATION",
            AggregatedSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT", "ORGANIZATION"]
    }
}
impl AsRef<str> for AggregatedSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Status information for your Config managed rules. The
/// status includes information such as the last time the rule ran, the
/// last time it failed, and the related error for the last
/// failure.</p>
/// <p>This action does not return status information about custom Config rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigRuleEvaluationStatus {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Config
    /// rule.</p>
    pub config_rule_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the Config rule.</p>
    pub config_rule_id: std::option::Option<std::string::String>,
    /// <p>The time that Config last successfully invoked the Config rule to evaluate your Amazon Web Services resources.</p>
    pub last_successful_invocation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that Config last failed to invoke the Config
    /// rule to evaluate your Amazon Web Services resources.</p>
    pub last_failed_invocation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that Config last successfully evaluated your Amazon Web Services
    /// resources against the rule.</p>
    pub last_successful_evaluation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that Config last failed to evaluate your Amazon Web Services
    /// resources against the rule.</p>
    pub last_failed_evaluation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that you first activated the Config
    /// rule.</p>
    pub first_activated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that you last turned off the Config rule.</p>
    pub last_deactivated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The error code that Config returned when the rule last
    /// failed.</p>
    pub last_error_code: std::option::Option<std::string::String>,
    /// <p>The error message that Config returned when the rule last
    /// failed.</p>
    pub last_error_message: std::option::Option<std::string::String>,
    /// <p>Indicates whether Config has evaluated your resources
    /// against the rule at least once.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>true</code> - Config has evaluated your Amazon Web Services
    /// resources against the rule at least once.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>false</code> - Config has not once finished
    /// evaluating your Amazon Web Services resources against the rule.</p>
    /// </li>
    /// </ul>
    pub first_evaluation_started: bool,
}
impl ConfigRuleEvaluationStatus {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Config
    /// rule.</p>
    pub fn config_rule_arn(&self) -> std::option::Option<&str> {
        self.config_rule_arn.as_deref()
    }
    /// <p>The ID of the Config rule.</p>
    pub fn config_rule_id(&self) -> std::option::Option<&str> {
        self.config_rule_id.as_deref()
    }
    /// <p>The time that Config last successfully invoked the Config rule to evaluate your Amazon Web Services resources.</p>
    pub fn last_successful_invocation_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_successful_invocation_time.as_ref()
    }
    /// <p>The time that Config last failed to invoke the Config
    /// rule to evaluate your Amazon Web Services resources.</p>
    pub fn last_failed_invocation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_failed_invocation_time.as_ref()
    }
    /// <p>The time that Config last successfully evaluated your Amazon Web Services
    /// resources against the rule.</p>
    pub fn last_successful_evaluation_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_successful_evaluation_time.as_ref()
    }
    /// <p>The time that Config last failed to evaluate your Amazon Web Services
    /// resources against the rule.</p>
    pub fn last_failed_evaluation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_failed_evaluation_time.as_ref()
    }
    /// <p>The time that you first activated the Config
    /// rule.</p>
    pub fn first_activated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.first_activated_time.as_ref()
    }
    /// <p>The time that you last turned off the Config rule.</p>
    pub fn last_deactivated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deactivated_time.as_ref()
    }
    /// <p>The error code that Config returned when the rule last
    /// failed.</p>
    pub fn last_error_code(&self) -> std::option::Option<&str> {
        self.last_error_code.as_deref()
    }
    /// <p>The error message that Config returned when the rule last
    /// failed.</p>
    pub fn last_error_message(&self) -> std::option::Option<&str> {
        self.last_error_message.as_deref()
    }
    /// <p>Indicates whether Config has evaluated your resources
    /// against the rule at least once.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>true</code> - Config has evaluated your Amazon Web Services
    /// resources against the rule at least once.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>false</code> - Config has not once finished
    /// evaluating your Amazon Web Services resources against the rule.</p>
    /// </li>
    /// </ul>
    pub fn first_evaluation_started(&self) -> bool {
        self.first_evaluation_started
    }
}
impl std::fmt::Debug for ConfigRuleEvaluationStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigRuleEvaluationStatus");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("config_rule_arn", &self.config_rule_arn);
        formatter.field("config_rule_id", &self.config_rule_id);
        formatter.field(
            "last_successful_invocation_time",
            &self.last_successful_invocation_time,
        );
        formatter.field(
            "last_failed_invocation_time",
            &self.last_failed_invocation_time,
        );
        formatter.field(
            "last_successful_evaluation_time",
            &self.last_successful_evaluation_time,
        );
        formatter.field(
            "last_failed_evaluation_time",
            &self.last_failed_evaluation_time,
        );
        formatter.field("first_activated_time", &self.first_activated_time);
        formatter.field("last_deactivated_time", &self.last_deactivated_time);
        formatter.field("last_error_code", &self.last_error_code);
        formatter.field("last_error_message", &self.last_error_message);
        formatter.field("first_evaluation_started", &self.first_evaluation_started);
        formatter.finish()
    }
}
/// See [`ConfigRuleEvaluationStatus`](crate::model::ConfigRuleEvaluationStatus)
pub mod config_rule_evaluation_status {
    /// A builder for [`ConfigRuleEvaluationStatus`](crate::model::ConfigRuleEvaluationStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) config_rule_arn: std::option::Option<std::string::String>,
        pub(crate) config_rule_id: std::option::Option<std::string::String>,
        pub(crate) last_successful_invocation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_failed_invocation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_successful_evaluation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_failed_evaluation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) first_activated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deactivated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_error_code: std::option::Option<std::string::String>,
        pub(crate) last_error_message: std::option::Option<std::string::String>,
        pub(crate) first_evaluation_started: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Config rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Config
        /// rule.</p>
        pub fn config_rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Config
        /// rule.</p>
        pub fn set_config_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_arn = input;
            self
        }
        /// <p>The ID of the Config rule.</p>
        pub fn config_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_id = Some(input.into());
            self
        }
        /// <p>The ID of the Config rule.</p>
        pub fn set_config_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_id = input;
            self
        }
        /// <p>The time that Config last successfully invoked the Config rule to evaluate your Amazon Web Services resources.</p>
        pub fn last_successful_invocation_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.last_successful_invocation_time = Some(input);
            self
        }
        /// <p>The time that Config last successfully invoked the Config rule to evaluate your Amazon Web Services resources.</p>
        pub fn set_last_successful_invocation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_successful_invocation_time = input;
            self
        }
        /// <p>The time that Config last failed to invoke the Config
        /// rule to evaluate your Amazon Web Services resources.</p>
        pub fn last_failed_invocation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_failed_invocation_time = Some(input);
            self
        }
        /// <p>The time that Config last failed to invoke the Config
        /// rule to evaluate your Amazon Web Services resources.</p>
        pub fn set_last_failed_invocation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_failed_invocation_time = input;
            self
        }
        /// <p>The time that Config last successfully evaluated your Amazon Web Services
        /// resources against the rule.</p>
        pub fn last_successful_evaluation_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.last_successful_evaluation_time = Some(input);
            self
        }
        /// <p>The time that Config last successfully evaluated your Amazon Web Services
        /// resources against the rule.</p>
        pub fn set_last_successful_evaluation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_successful_evaluation_time = input;
            self
        }
        /// <p>The time that Config last failed to evaluate your Amazon Web Services
        /// resources against the rule.</p>
        pub fn last_failed_evaluation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_failed_evaluation_time = Some(input);
            self
        }
        /// <p>The time that Config last failed to evaluate your Amazon Web Services
        /// resources against the rule.</p>
        pub fn set_last_failed_evaluation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_failed_evaluation_time = input;
            self
        }
        /// <p>The time that you first activated the Config
        /// rule.</p>
        pub fn first_activated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.first_activated_time = Some(input);
            self
        }
        /// <p>The time that you first activated the Config
        /// rule.</p>
        pub fn set_first_activated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.first_activated_time = input;
            self
        }
        /// <p>The time that you last turned off the Config rule.</p>
        pub fn last_deactivated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deactivated_time = Some(input);
            self
        }
        /// <p>The time that you last turned off the Config rule.</p>
        pub fn set_last_deactivated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deactivated_time = input;
            self
        }
        /// <p>The error code that Config returned when the rule last
        /// failed.</p>
        pub fn last_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_error_code = Some(input.into());
            self
        }
        /// <p>The error code that Config returned when the rule last
        /// failed.</p>
        pub fn set_last_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_error_code = input;
            self
        }
        /// <p>The error message that Config returned when the rule last
        /// failed.</p>
        pub fn last_error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_error_message = Some(input.into());
            self
        }
        /// <p>The error message that Config returned when the rule last
        /// failed.</p>
        pub fn set_last_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_error_message = input;
            self
        }
        /// <p>Indicates whether Config has evaluated your resources
        /// against the rule at least once.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>true</code> - Config has evaluated your Amazon Web Services
        /// resources against the rule at least once.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>false</code> - Config has not once finished
        /// evaluating your Amazon Web Services resources against the rule.</p>
        /// </li>
        /// </ul>
        pub fn first_evaluation_started(mut self, input: bool) -> Self {
            self.first_evaluation_started = Some(input);
            self
        }
        /// <p>Indicates whether Config has evaluated your resources
        /// against the rule at least once.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>true</code> - Config has evaluated your Amazon Web Services
        /// resources against the rule at least once.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>false</code> - Config has not once finished
        /// evaluating your Amazon Web Services resources against the rule.</p>
        /// </li>
        /// </ul>
        pub fn set_first_evaluation_started(mut self, input: std::option::Option<bool>) -> Self {
            self.first_evaluation_started = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigRuleEvaluationStatus`](crate::model::ConfigRuleEvaluationStatus)
        pub fn build(self) -> crate::model::ConfigRuleEvaluationStatus {
            crate::model::ConfigRuleEvaluationStatus {
                config_rule_name: self.config_rule_name,
                config_rule_arn: self.config_rule_arn,
                config_rule_id: self.config_rule_id,
                last_successful_invocation_time: self.last_successful_invocation_time,
                last_failed_invocation_time: self.last_failed_invocation_time,
                last_successful_evaluation_time: self.last_successful_evaluation_time,
                last_failed_evaluation_time: self.last_failed_evaluation_time,
                first_activated_time: self.first_activated_time,
                last_deactivated_time: self.last_deactivated_time,
                last_error_code: self.last_error_code,
                last_error_message: self.last_error_message,
                first_evaluation_started: self.first_evaluation_started.unwrap_or_default(),
            }
        }
    }
}
impl ConfigRuleEvaluationStatus {
    /// Creates a new builder-style object to manufacture [`ConfigRuleEvaluationStatus`](crate::model::ConfigRuleEvaluationStatus)
    pub fn builder() -> crate::model::config_rule_evaluation_status::Builder {
        crate::model::config_rule_evaluation_status::Builder::default()
    }
}

/// <p>Indicates whether an Amazon Web Services resource that is evaluated according
/// to one or more Config rules is compliant. A resource is
/// compliant if it complies with all of the rules that evaluate it. A
/// resource is noncompliant if it does not comply with one or more of
/// these rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceByResource {
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the Amazon Web Services resource complies with all of the Config rules that evaluated it.</p>
    pub compliance: std::option::Option<crate::model::Compliance>,
}
impl ComplianceByResource {
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Indicates whether the Amazon Web Services resource complies with all of the Config rules that evaluated it.</p>
    pub fn compliance(&self) -> std::option::Option<&crate::model::Compliance> {
        self.compliance.as_ref()
    }
}
impl std::fmt::Debug for ComplianceByResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceByResource");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("compliance", &self.compliance);
        formatter.finish()
    }
}
/// See [`ComplianceByResource`](crate::model::ComplianceByResource)
pub mod compliance_by_resource {
    /// A builder for [`ComplianceByResource`](crate::model::ComplianceByResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) compliance: std::option::Option<crate::model::Compliance>,
    }
    impl Builder {
        /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Indicates whether the Amazon Web Services resource complies with all of the Config rules that evaluated it.</p>
        pub fn compliance(mut self, input: crate::model::Compliance) -> Self {
            self.compliance = Some(input);
            self
        }
        /// <p>Indicates whether the Amazon Web Services resource complies with all of the Config rules that evaluated it.</p>
        pub fn set_compliance(
            mut self,
            input: std::option::Option<crate::model::Compliance>,
        ) -> Self {
            self.compliance = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceByResource`](crate::model::ComplianceByResource)
        pub fn build(self) -> crate::model::ComplianceByResource {
            crate::model::ComplianceByResource {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                compliance: self.compliance,
            }
        }
    }
}
impl ComplianceByResource {
    /// Creates a new builder-style object to manufacture [`ComplianceByResource`](crate::model::ComplianceByResource)
    pub fn builder() -> crate::model::compliance_by_resource::Builder {
        crate::model::compliance_by_resource::Builder::default()
    }
}

/// <p>Indicates whether an Amazon Web Services resource or Config rule is
/// compliant and provides the number of contributors that affect the
/// compliance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Compliance {
    /// <p>Indicates whether an Amazon Web Services resource or Config rule is
    /// compliant.</p>
    /// <p>A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is noncompliant if it does
    /// not comply with one or more of these rules.</p>
    /// <p>A rule is compliant if all of the resources that the rule
    /// evaluates comply with it. A rule is noncompliant if any of these
    /// resources do not comply.</p>
    /// <p>Config returns the <code>INSUFFICIENT_DATA</code> value
    /// when no evaluation results are available for the Amazon Web Services resource or Config rule.</p>
    /// <p>For the <code>Compliance</code> data type, Config supports
    /// only <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
    /// <code>INSUFFICIENT_DATA</code> values. Config does not
    /// support the <code>NOT_APPLICABLE</code> value for the
    /// <code>Compliance</code> data type.</p>
    pub compliance_type: std::option::Option<crate::model::ComplianceType>,
    /// <p>The number of Amazon Web Services resources or Config rules that cause a
    /// result of <code>NON_COMPLIANT</code>, up to a maximum
    /// number.</p>
    pub compliance_contributor_count: std::option::Option<crate::model::ComplianceContributorCount>,
}
impl Compliance {
    /// <p>Indicates whether an Amazon Web Services resource or Config rule is
    /// compliant.</p>
    /// <p>A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is noncompliant if it does
    /// not comply with one or more of these rules.</p>
    /// <p>A rule is compliant if all of the resources that the rule
    /// evaluates comply with it. A rule is noncompliant if any of these
    /// resources do not comply.</p>
    /// <p>Config returns the <code>INSUFFICIENT_DATA</code> value
    /// when no evaluation results are available for the Amazon Web Services resource or Config rule.</p>
    /// <p>For the <code>Compliance</code> data type, Config supports
    /// only <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
    /// <code>INSUFFICIENT_DATA</code> values. Config does not
    /// support the <code>NOT_APPLICABLE</code> value for the
    /// <code>Compliance</code> data type.</p>
    pub fn compliance_type(&self) -> std::option::Option<&crate::model::ComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>The number of Amazon Web Services resources or Config rules that cause a
    /// result of <code>NON_COMPLIANT</code>, up to a maximum
    /// number.</p>
    pub fn compliance_contributor_count(
        &self,
    ) -> std::option::Option<&crate::model::ComplianceContributorCount> {
        self.compliance_contributor_count.as_ref()
    }
}
impl std::fmt::Debug for Compliance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Compliance");
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field(
            "compliance_contributor_count",
            &self.compliance_contributor_count,
        );
        formatter.finish()
    }
}
/// See [`Compliance`](crate::model::Compliance)
pub mod compliance {
    /// A builder for [`Compliance`](crate::model::Compliance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_type: std::option::Option<crate::model::ComplianceType>,
        pub(crate) compliance_contributor_count:
            std::option::Option<crate::model::ComplianceContributorCount>,
    }
    impl Builder {
        /// <p>Indicates whether an Amazon Web Services resource or Config rule is
        /// compliant.</p>
        /// <p>A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is noncompliant if it does
        /// not comply with one or more of these rules.</p>
        /// <p>A rule is compliant if all of the resources that the rule
        /// evaluates comply with it. A rule is noncompliant if any of these
        /// resources do not comply.</p>
        /// <p>Config returns the <code>INSUFFICIENT_DATA</code> value
        /// when no evaluation results are available for the Amazon Web Services resource or Config rule.</p>
        /// <p>For the <code>Compliance</code> data type, Config supports
        /// only <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
        /// <code>INSUFFICIENT_DATA</code> values. Config does not
        /// support the <code>NOT_APPLICABLE</code> value for the
        /// <code>Compliance</code> data type.</p>
        pub fn compliance_type(mut self, input: crate::model::ComplianceType) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>Indicates whether an Amazon Web Services resource or Config rule is
        /// compliant.</p>
        /// <p>A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is noncompliant if it does
        /// not comply with one or more of these rules.</p>
        /// <p>A rule is compliant if all of the resources that the rule
        /// evaluates comply with it. A rule is noncompliant if any of these
        /// resources do not comply.</p>
        /// <p>Config returns the <code>INSUFFICIENT_DATA</code> value
        /// when no evaluation results are available for the Amazon Web Services resource or Config rule.</p>
        /// <p>For the <code>Compliance</code> data type, Config supports
        /// only <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
        /// <code>INSUFFICIENT_DATA</code> values. Config does not
        /// support the <code>NOT_APPLICABLE</code> value for the
        /// <code>Compliance</code> data type.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>The number of Amazon Web Services resources or Config rules that cause a
        /// result of <code>NON_COMPLIANT</code>, up to a maximum
        /// number.</p>
        pub fn compliance_contributor_count(
            mut self,
            input: crate::model::ComplianceContributorCount,
        ) -> Self {
            self.compliance_contributor_count = Some(input);
            self
        }
        /// <p>The number of Amazon Web Services resources or Config rules that cause a
        /// result of <code>NON_COMPLIANT</code>, up to a maximum
        /// number.</p>
        pub fn set_compliance_contributor_count(
            mut self,
            input: std::option::Option<crate::model::ComplianceContributorCount>,
        ) -> Self {
            self.compliance_contributor_count = input;
            self
        }
        /// Consumes the builder and constructs a [`Compliance`](crate::model::Compliance)
        pub fn build(self) -> crate::model::Compliance {
            crate::model::Compliance {
                compliance_type: self.compliance_type,
                compliance_contributor_count: self.compliance_contributor_count,
            }
        }
    }
}
impl Compliance {
    /// Creates a new builder-style object to manufacture [`Compliance`](crate::model::Compliance)
    pub fn builder() -> crate::model::compliance::Builder {
        crate::model::compliance::Builder::default()
    }
}

/// <p>Indicates whether an Config rule is compliant. A rule is
/// compliant if all of the resources that the rule evaluated comply
/// with it. A rule is noncompliant if any of these resources do not
/// comply.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceByConfigRule {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the Config rule is compliant.</p>
    pub compliance: std::option::Option<crate::model::Compliance>,
}
impl ComplianceByConfigRule {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>Indicates whether the Config rule is compliant.</p>
    pub fn compliance(&self) -> std::option::Option<&crate::model::Compliance> {
        self.compliance.as_ref()
    }
}
impl std::fmt::Debug for ComplianceByConfigRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceByConfigRule");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("compliance", &self.compliance);
        formatter.finish()
    }
}
/// See [`ComplianceByConfigRule`](crate::model::ComplianceByConfigRule)
pub mod compliance_by_config_rule {
    /// A builder for [`ComplianceByConfigRule`](crate::model::ComplianceByConfigRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) compliance: std::option::Option<crate::model::Compliance>,
    }
    impl Builder {
        /// <p>The name of the Config rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>Indicates whether the Config rule is compliant.</p>
        pub fn compliance(mut self, input: crate::model::Compliance) -> Self {
            self.compliance = Some(input);
            self
        }
        /// <p>Indicates whether the Config rule is compliant.</p>
        pub fn set_compliance(
            mut self,
            input: std::option::Option<crate::model::Compliance>,
        ) -> Self {
            self.compliance = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceByConfigRule`](crate::model::ComplianceByConfigRule)
        pub fn build(self) -> crate::model::ComplianceByConfigRule {
            crate::model::ComplianceByConfigRule {
                config_rule_name: self.config_rule_name,
                compliance: self.compliance,
            }
        }
    }
}
impl ComplianceByConfigRule {
    /// Creates a new builder-style object to manufacture [`ComplianceByConfigRule`](crate::model::ComplianceByConfigRule)
    pub fn builder() -> crate::model::compliance_by_config_rule::Builder {
        crate::model::compliance_by_config_rule::Builder::default()
    }
}

/// <p>Provides aggregate compliance of the conformance pack. Indicates whether a conformance pack is compliant based on the name of the conformance pack, account ID, and region.</p>
/// <p>A conformance pack is compliant if all of the rules in a conformance packs are compliant. It is noncompliant if any of the rules are not compliant.
/// The compliance status of a conformance pack is INSUFFICIENT_DATA only if all rules within a conformance pack cannot be evaluated due to insufficient data.
/// If some of the rules in a conformance pack are compliant but the compliance status of other rules in that same conformance pack is INSUFFICIENT_DATA, the conformance pack shows compliant.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregateComplianceByConformancePack {
    /// <p>The name of the conformance pack.</p>
    pub conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>The compliance status of the conformance pack.</p>
    pub compliance: std::option::Option<crate::model::AggregateConformancePackCompliance>,
    /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
    pub aws_region: std::option::Option<std::string::String>,
}
impl AggregateComplianceByConformancePack {
    /// <p>The name of the conformance pack.</p>
    pub fn conformance_pack_name(&self) -> std::option::Option<&str> {
        self.conformance_pack_name.as_deref()
    }
    /// <p>The compliance status of the conformance pack.</p>
    pub fn compliance(
        &self,
    ) -> std::option::Option<&crate::model::AggregateConformancePackCompliance> {
        self.compliance.as_ref()
    }
    /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl std::fmt::Debug for AggregateComplianceByConformancePack {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregateComplianceByConformancePack");
        formatter.field("conformance_pack_name", &self.conformance_pack_name);
        formatter.field("compliance", &self.compliance);
        formatter.field("account_id", &self.account_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.finish()
    }
}
/// See [`AggregateComplianceByConformancePack`](crate::model::AggregateComplianceByConformancePack)
pub mod aggregate_compliance_by_conformance_pack {
    /// A builder for [`AggregateComplianceByConformancePack`](crate::model::AggregateComplianceByConformancePack)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) compliance:
            std::option::Option<crate::model::AggregateConformancePackCompliance>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the conformance pack.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_name = Some(input.into());
            self
        }
        /// <p>The name of the conformance pack.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_name = input;
            self
        }
        /// <p>The compliance status of the conformance pack.</p>
        pub fn compliance(
            mut self,
            input: crate::model::AggregateConformancePackCompliance,
        ) -> Self {
            self.compliance = Some(input);
            self
        }
        /// <p>The compliance status of the conformance pack.</p>
        pub fn set_compliance(
            mut self,
            input: std::option::Option<crate::model::AggregateConformancePackCompliance>,
        ) -> Self {
            self.compliance = input;
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregateComplianceByConformancePack`](crate::model::AggregateComplianceByConformancePack)
        pub fn build(self) -> crate::model::AggregateComplianceByConformancePack {
            crate::model::AggregateComplianceByConformancePack {
                conformance_pack_name: self.conformance_pack_name,
                compliance: self.compliance,
                account_id: self.account_id,
                aws_region: self.aws_region,
            }
        }
    }
}
impl AggregateComplianceByConformancePack {
    /// Creates a new builder-style object to manufacture [`AggregateComplianceByConformancePack`](crate::model::AggregateComplianceByConformancePack)
    pub fn builder() -> crate::model::aggregate_compliance_by_conformance_pack::Builder {
        crate::model::aggregate_compliance_by_conformance_pack::Builder::default()
    }
}

/// <p>Provides the number of compliant and noncompliant rules within a conformance pack.
/// Also provides the compliance status of the conformance pack and the total rule count which includes compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.</p>
///
/// <p>A conformance pack is compliant if all of the rules in a conformance packs are compliant. It is noncompliant if any of the rules are not compliant.
/// The compliance status of a conformance pack is INSUFFICIENT_DATA only if all rules within a conformance pack cannot be evaluated due to insufficient data.
/// If some of the rules in a conformance pack are compliant but the compliance status of other rules in that same conformance pack is INSUFFICIENT_DATA, the conformance pack shows compliant.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregateConformancePackCompliance {
    /// <p>The compliance status of the conformance pack.</p>
    pub compliance_type: std::option::Option<crate::model::ConformancePackComplianceType>,
    /// <p>The number of compliant Config Rules.</p>
    pub compliant_rule_count: i32,
    /// <p>The number of noncompliant Config Rules.</p>
    pub non_compliant_rule_count: i32,
    /// <p>Total number of compliant rules, noncompliant rules, and the rules that do not have any applicable resources to evaluate upon resulting in insufficient data.</p>
    pub total_rule_count: i32,
}
impl AggregateConformancePackCompliance {
    /// <p>The compliance status of the conformance pack.</p>
    pub fn compliance_type(
        &self,
    ) -> std::option::Option<&crate::model::ConformancePackComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>The number of compliant Config Rules.</p>
    pub fn compliant_rule_count(&self) -> i32 {
        self.compliant_rule_count
    }
    /// <p>The number of noncompliant Config Rules.</p>
    pub fn non_compliant_rule_count(&self) -> i32 {
        self.non_compliant_rule_count
    }
    /// <p>Total number of compliant rules, noncompliant rules, and the rules that do not have any applicable resources to evaluate upon resulting in insufficient data.</p>
    pub fn total_rule_count(&self) -> i32 {
        self.total_rule_count
    }
}
impl std::fmt::Debug for AggregateConformancePackCompliance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregateConformancePackCompliance");
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("compliant_rule_count", &self.compliant_rule_count);
        formatter.field("non_compliant_rule_count", &self.non_compliant_rule_count);
        formatter.field("total_rule_count", &self.total_rule_count);
        formatter.finish()
    }
}
/// See [`AggregateConformancePackCompliance`](crate::model::AggregateConformancePackCompliance)
pub mod aggregate_conformance_pack_compliance {
    /// A builder for [`AggregateConformancePackCompliance`](crate::model::AggregateConformancePackCompliance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_type:
            std::option::Option<crate::model::ConformancePackComplianceType>,
        pub(crate) compliant_rule_count: std::option::Option<i32>,
        pub(crate) non_compliant_rule_count: std::option::Option<i32>,
        pub(crate) total_rule_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The compliance status of the conformance pack.</p>
        pub fn compliance_type(
            mut self,
            input: crate::model::ConformancePackComplianceType,
        ) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>The compliance status of the conformance pack.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ConformancePackComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>The number of compliant Config Rules.</p>
        pub fn compliant_rule_count(mut self, input: i32) -> Self {
            self.compliant_rule_count = Some(input);
            self
        }
        /// <p>The number of compliant Config Rules.</p>
        pub fn set_compliant_rule_count(mut self, input: std::option::Option<i32>) -> Self {
            self.compliant_rule_count = input;
            self
        }
        /// <p>The number of noncompliant Config Rules.</p>
        pub fn non_compliant_rule_count(mut self, input: i32) -> Self {
            self.non_compliant_rule_count = Some(input);
            self
        }
        /// <p>The number of noncompliant Config Rules.</p>
        pub fn set_non_compliant_rule_count(mut self, input: std::option::Option<i32>) -> Self {
            self.non_compliant_rule_count = input;
            self
        }
        /// <p>Total number of compliant rules, noncompliant rules, and the rules that do not have any applicable resources to evaluate upon resulting in insufficient data.</p>
        pub fn total_rule_count(mut self, input: i32) -> Self {
            self.total_rule_count = Some(input);
            self
        }
        /// <p>Total number of compliant rules, noncompliant rules, and the rules that do not have any applicable resources to evaluate upon resulting in insufficient data.</p>
        pub fn set_total_rule_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_rule_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregateConformancePackCompliance`](crate::model::AggregateConformancePackCompliance)
        pub fn build(self) -> crate::model::AggregateConformancePackCompliance {
            crate::model::AggregateConformancePackCompliance {
                compliance_type: self.compliance_type,
                compliant_rule_count: self.compliant_rule_count.unwrap_or_default(),
                non_compliant_rule_count: self.non_compliant_rule_count.unwrap_or_default(),
                total_rule_count: self.total_rule_count.unwrap_or_default(),
            }
        }
    }
}
impl AggregateConformancePackCompliance {
    /// Creates a new builder-style object to manufacture [`AggregateConformancePackCompliance`](crate::model::AggregateConformancePackCompliance)
    pub fn builder() -> crate::model::aggregate_conformance_pack_compliance::Builder {
        crate::model::aggregate_conformance_pack_compliance::Builder::default()
    }
}

/// <p>Filters the conformance packs based on an account ID, region, compliance type, and the name of the conformance pack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregateConformancePackComplianceFilters {
    /// <p>The name of the conformance pack.</p>
    pub conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>The compliance status of the conformance pack.</p>
    pub compliance_type: std::option::Option<crate::model::ConformancePackComplianceType>,
    /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
    pub aws_region: std::option::Option<std::string::String>,
}
impl AggregateConformancePackComplianceFilters {
    /// <p>The name of the conformance pack.</p>
    pub fn conformance_pack_name(&self) -> std::option::Option<&str> {
        self.conformance_pack_name.as_deref()
    }
    /// <p>The compliance status of the conformance pack.</p>
    pub fn compliance_type(
        &self,
    ) -> std::option::Option<&crate::model::ConformancePackComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl std::fmt::Debug for AggregateConformancePackComplianceFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregateConformancePackComplianceFilters");
        formatter.field("conformance_pack_name", &self.conformance_pack_name);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("account_id", &self.account_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.finish()
    }
}
/// See [`AggregateConformancePackComplianceFilters`](crate::model::AggregateConformancePackComplianceFilters)
pub mod aggregate_conformance_pack_compliance_filters {
    /// A builder for [`AggregateConformancePackComplianceFilters`](crate::model::AggregateConformancePackComplianceFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) compliance_type:
            std::option::Option<crate::model::ConformancePackComplianceType>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the conformance pack.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_name = Some(input.into());
            self
        }
        /// <p>The name of the conformance pack.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_name = input;
            self
        }
        /// <p>The compliance status of the conformance pack.</p>
        pub fn compliance_type(
            mut self,
            input: crate::model::ConformancePackComplianceType,
        ) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>The compliance status of the conformance pack.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ConformancePackComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID of the source account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The source Amazon Web Services Region from where the data is aggregated.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregateConformancePackComplianceFilters`](crate::model::AggregateConformancePackComplianceFilters)
        pub fn build(self) -> crate::model::AggregateConformancePackComplianceFilters {
            crate::model::AggregateConformancePackComplianceFilters {
                conformance_pack_name: self.conformance_pack_name,
                compliance_type: self.compliance_type,
                account_id: self.account_id,
                aws_region: self.aws_region,
            }
        }
    }
}
impl AggregateConformancePackComplianceFilters {
    /// Creates a new builder-style object to manufacture [`AggregateConformancePackComplianceFilters`](crate::model::AggregateConformancePackComplianceFilters)
    pub fn builder() -> crate::model::aggregate_conformance_pack_compliance_filters::Builder {
        crate::model::aggregate_conformance_pack_compliance_filters::Builder::default()
    }
}

/// <p>Indicates whether an Config rule is compliant based on
/// account ID, region, compliance, and rule name.</p>
/// <p>A rule is compliant if all of the resources that the rule
/// evaluated comply with it. It is noncompliant if any of these
/// resources do not comply.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregateComplianceByConfigRule {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether an Amazon Web Services resource or Config rule is
    /// compliant and provides the number of contributors that affect the
    /// compliance.</p>
    pub compliance: std::option::Option<crate::model::Compliance>,
    /// <p>The 12-digit account ID of the source account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The source region from where the data is aggregated.</p>
    pub aws_region: std::option::Option<std::string::String>,
}
impl AggregateComplianceByConfigRule {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>Indicates whether an Amazon Web Services resource or Config rule is
    /// compliant and provides the number of contributors that affect the
    /// compliance.</p>
    pub fn compliance(&self) -> std::option::Option<&crate::model::Compliance> {
        self.compliance.as_ref()
    }
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The source region from where the data is aggregated.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl std::fmt::Debug for AggregateComplianceByConfigRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregateComplianceByConfigRule");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("compliance", &self.compliance);
        formatter.field("account_id", &self.account_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.finish()
    }
}
/// See [`AggregateComplianceByConfigRule`](crate::model::AggregateComplianceByConfigRule)
pub mod aggregate_compliance_by_config_rule {
    /// A builder for [`AggregateComplianceByConfigRule`](crate::model::AggregateComplianceByConfigRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) compliance: std::option::Option<crate::model::Compliance>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Config rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>Indicates whether an Amazon Web Services resource or Config rule is
        /// compliant and provides the number of contributors that affect the
        /// compliance.</p>
        pub fn compliance(mut self, input: crate::model::Compliance) -> Self {
            self.compliance = Some(input);
            self
        }
        /// <p>Indicates whether an Amazon Web Services resource or Config rule is
        /// compliant and provides the number of contributors that affect the
        /// compliance.</p>
        pub fn set_compliance(
            mut self,
            input: std::option::Option<crate::model::Compliance>,
        ) -> Self {
            self.compliance = input;
            self
        }
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The source region from where the data is aggregated.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The source region from where the data is aggregated.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregateComplianceByConfigRule`](crate::model::AggregateComplianceByConfigRule)
        pub fn build(self) -> crate::model::AggregateComplianceByConfigRule {
            crate::model::AggregateComplianceByConfigRule {
                config_rule_name: self.config_rule_name,
                compliance: self.compliance,
                account_id: self.account_id,
                aws_region: self.aws_region,
            }
        }
    }
}
impl AggregateComplianceByConfigRule {
    /// Creates a new builder-style object to manufacture [`AggregateComplianceByConfigRule`](crate::model::AggregateComplianceByConfigRule)
    pub fn builder() -> crate::model::aggregate_compliance_by_config_rule::Builder {
        crate::model::aggregate_compliance_by_config_rule::Builder::default()
    }
}

/// <p>Filters the compliance results based on account ID, region,
/// compliance type, and rule name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigRuleComplianceFilters {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>The rule compliance status.</p>
    /// <p>For the <code>ConfigRuleComplianceFilters</code> data type, Config supports only <code>COMPLIANT</code> and
    /// <code>NON_COMPLIANT</code>. Config does not support the
    /// <code>NOT_APPLICABLE</code> and the
    /// <code>INSUFFICIENT_DATA</code> values.</p>
    pub compliance_type: std::option::Option<crate::model::ComplianceType>,
    /// <p>The 12-digit account ID of the source account.
    /// </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The source region where the data is aggregated.
    /// </p>
    pub aws_region: std::option::Option<std::string::String>,
}
impl ConfigRuleComplianceFilters {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>The rule compliance status.</p>
    /// <p>For the <code>ConfigRuleComplianceFilters</code> data type, Config supports only <code>COMPLIANT</code> and
    /// <code>NON_COMPLIANT</code>. Config does not support the
    /// <code>NOT_APPLICABLE</code> and the
    /// <code>INSUFFICIENT_DATA</code> values.</p>
    pub fn compliance_type(&self) -> std::option::Option<&crate::model::ComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>The 12-digit account ID of the source account.
    /// </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The source region where the data is aggregated.
    /// </p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl std::fmt::Debug for ConfigRuleComplianceFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigRuleComplianceFilters");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("account_id", &self.account_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.finish()
    }
}
/// See [`ConfigRuleComplianceFilters`](crate::model::ConfigRuleComplianceFilters)
pub mod config_rule_compliance_filters {
    /// A builder for [`ConfigRuleComplianceFilters`](crate::model::ConfigRuleComplianceFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) compliance_type: std::option::Option<crate::model::ComplianceType>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Config rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>The rule compliance status.</p>
        /// <p>For the <code>ConfigRuleComplianceFilters</code> data type, Config supports only <code>COMPLIANT</code> and
        /// <code>NON_COMPLIANT</code>. Config does not support the
        /// <code>NOT_APPLICABLE</code> and the
        /// <code>INSUFFICIENT_DATA</code> values.</p>
        pub fn compliance_type(mut self, input: crate::model::ComplianceType) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>The rule compliance status.</p>
        /// <p>For the <code>ConfigRuleComplianceFilters</code> data type, Config supports only <code>COMPLIANT</code> and
        /// <code>NON_COMPLIANT</code>. Config does not support the
        /// <code>NOT_APPLICABLE</code> and the
        /// <code>INSUFFICIENT_DATA</code> values.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>The 12-digit account ID of the source account.
        /// </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the source account.
        /// </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The source region where the data is aggregated.
        /// </p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The source region where the data is aggregated.
        /// </p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigRuleComplianceFilters`](crate::model::ConfigRuleComplianceFilters)
        pub fn build(self) -> crate::model::ConfigRuleComplianceFilters {
            crate::model::ConfigRuleComplianceFilters {
                config_rule_name: self.config_rule_name,
                compliance_type: self.compliance_type,
                account_id: self.account_id,
                aws_region: self.aws_region,
            }
        }
    }
}
impl ConfigRuleComplianceFilters {
    /// Creates a new builder-style object to manufacture [`ConfigRuleComplianceFilters`](crate::model::ConfigRuleComplianceFilters)
    pub fn builder() -> crate::model::config_rule_compliance_filters::Builder {
        crate::model::config_rule_compliance_filters::Builder::default()
    }
}

/// <p>List of each of the failed delete remediation exceptions with specific reasons.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedDeleteRemediationExceptionsBatch {
    /// <p>Returns a failure message for delete remediation exception. For example, Config creates an exception due to an internal error.</p>
    pub failure_message: std::option::Option<std::string::String>,
    /// <p>Returns remediation exception resource key object of the failed items.</p>
    pub failed_items:
        std::option::Option<std::vec::Vec<crate::model::RemediationExceptionResourceKey>>,
}
impl FailedDeleteRemediationExceptionsBatch {
    /// <p>Returns a failure message for delete remediation exception. For example, Config creates an exception due to an internal error.</p>
    pub fn failure_message(&self) -> std::option::Option<&str> {
        self.failure_message.as_deref()
    }
    /// <p>Returns remediation exception resource key object of the failed items.</p>
    pub fn failed_items(
        &self,
    ) -> std::option::Option<&[crate::model::RemediationExceptionResourceKey]> {
        self.failed_items.as_deref()
    }
}
impl std::fmt::Debug for FailedDeleteRemediationExceptionsBatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedDeleteRemediationExceptionsBatch");
        formatter.field("failure_message", &self.failure_message);
        formatter.field("failed_items", &self.failed_items);
        formatter.finish()
    }
}
/// See [`FailedDeleteRemediationExceptionsBatch`](crate::model::FailedDeleteRemediationExceptionsBatch)
pub mod failed_delete_remediation_exceptions_batch {
    /// A builder for [`FailedDeleteRemediationExceptionsBatch`](crate::model::FailedDeleteRemediationExceptionsBatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_message: std::option::Option<std::string::String>,
        pub(crate) failed_items:
            std::option::Option<std::vec::Vec<crate::model::RemediationExceptionResourceKey>>,
    }
    impl Builder {
        /// <p>Returns a failure message for delete remediation exception. For example, Config creates an exception due to an internal error.</p>
        pub fn failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_message = Some(input.into());
            self
        }
        /// <p>Returns a failure message for delete remediation exception. For example, Config creates an exception due to an internal error.</p>
        pub fn set_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_message = input;
            self
        }
        /// Appends an item to `failed_items`.
        ///
        /// To override the contents of this collection use [`set_failed_items`](Self::set_failed_items).
        ///
        /// <p>Returns remediation exception resource key object of the failed items.</p>
        pub fn failed_items(
            mut self,
            input: impl Into<crate::model::RemediationExceptionResourceKey>,
        ) -> Self {
            let mut v = self.failed_items.unwrap_or_default();
            v.push(input.into());
            self.failed_items = Some(v);
            self
        }
        /// <p>Returns remediation exception resource key object of the failed items.</p>
        pub fn set_failed_items(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RemediationExceptionResourceKey>,
            >,
        ) -> Self {
            self.failed_items = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedDeleteRemediationExceptionsBatch`](crate::model::FailedDeleteRemediationExceptionsBatch)
        pub fn build(self) -> crate::model::FailedDeleteRemediationExceptionsBatch {
            crate::model::FailedDeleteRemediationExceptionsBatch {
                failure_message: self.failure_message,
                failed_items: self.failed_items,
            }
        }
    }
}
impl FailedDeleteRemediationExceptionsBatch {
    /// Creates a new builder-style object to manufacture [`FailedDeleteRemediationExceptionsBatch`](crate::model::FailedDeleteRemediationExceptionsBatch)
    pub fn builder() -> crate::model::failed_delete_remediation_exceptions_batch::Builder {
        crate::model::failed_delete_remediation_exceptions_batch::Builder::default()
    }
}

/// <p>The detailed configuration of a specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BaseConfigurationItem {
    /// <p>The version number of the resource configuration.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The time when the configuration recording was initiated.</p>
    pub configuration_item_capture_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The configuration item status. The valid values are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated</p>
    /// </li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered</p>
    /// </li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
    /// </li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p>
    /// </li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The CIs do not incur any cost.</p>
    /// </note>
    pub configuration_item_status: std::option::Option<crate::model::ConfigurationItemStatus>,
    /// <p>An identifier that indicates the ordering of the configuration
    /// items of a resource.</p>
    pub configuration_state_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of Amazon Web Services resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The custom name of the resource, if available.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The region where the resource resides.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>The Availability Zone associated with the resource.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The time stamp when the resource was created.</p>
    pub resource_creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the resource configuration.</p>
    pub configuration: std::option::Option<std::string::String>,
    /// <p>Configuration attributes that Config returns for certain
    /// resource types to supplement the information returned for the
    /// configuration parameter.</p>
    pub supplementary_configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl BaseConfigurationItem {
    /// <p>The version number of the resource configuration.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The time when the configuration recording was initiated.</p>
    pub fn configuration_item_capture_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.configuration_item_capture_time.as_ref()
    }
    /// <p>The configuration item status. The valid values are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated</p>
    /// </li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered</p>
    /// </li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
    /// </li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p>
    /// </li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The CIs do not incur any cost.</p>
    /// </note>
    pub fn configuration_item_status(
        &self,
    ) -> std::option::Option<&crate::model::ConfigurationItemStatus> {
        self.configuration_item_status.as_ref()
    }
    /// <p>An identifier that indicates the ordering of the configuration
    /// items of a resource.</p>
    pub fn configuration_state_id(&self) -> std::option::Option<&str> {
        self.configuration_state_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of Amazon Web Services resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The custom name of the resource, if available.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The region where the resource resides.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>The Availability Zone associated with the resource.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The time stamp when the resource was created.</p>
    pub fn resource_creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.resource_creation_time.as_ref()
    }
    /// <p>The description of the resource configuration.</p>
    pub fn configuration(&self) -> std::option::Option<&str> {
        self.configuration.as_deref()
    }
    /// <p>Configuration attributes that Config returns for certain
    /// resource types to supplement the information returned for the
    /// configuration parameter.</p>
    pub fn supplementary_configuration(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.supplementary_configuration.as_ref()
    }
}
impl std::fmt::Debug for BaseConfigurationItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BaseConfigurationItem");
        formatter.field("version", &self.version);
        formatter.field("account_id", &self.account_id);
        formatter.field(
            "configuration_item_capture_time",
            &self.configuration_item_capture_time,
        );
        formatter.field("configuration_item_status", &self.configuration_item_status);
        formatter.field("configuration_state_id", &self.configuration_state_id);
        formatter.field("arn", &self.arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_name", &self.resource_name);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("resource_creation_time", &self.resource_creation_time);
        formatter.field("configuration", &self.configuration);
        formatter.field(
            "supplementary_configuration",
            &self.supplementary_configuration,
        );
        formatter.finish()
    }
}
/// See [`BaseConfigurationItem`](crate::model::BaseConfigurationItem)
pub mod base_configuration_item {
    /// A builder for [`BaseConfigurationItem`](crate::model::BaseConfigurationItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) configuration_item_capture_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) configuration_item_status:
            std::option::Option<crate::model::ConfigurationItemStatus>,
        pub(crate) configuration_state_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) resource_creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) configuration: std::option::Option<std::string::String>,
        pub(crate) supplementary_configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The version number of the resource configuration.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version number of the resource configuration.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The time when the configuration recording was initiated.</p>
        pub fn configuration_item_capture_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.configuration_item_capture_time = Some(input);
            self
        }
        /// <p>The time when the configuration recording was initiated.</p>
        pub fn set_configuration_item_capture_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.configuration_item_capture_time = input;
            self
        }
        /// <p>The configuration item status. The valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>OK – The resource configuration has been updated</p>
        /// </li>
        /// <li>
        /// <p>ResourceDiscovered – The resource was newly discovered</p>
        /// </li>
        /// <li>
        /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
        /// </li>
        /// <li>
        /// <p>ResourceDeleted – The resource was deleted</p>
        /// </li>
        /// <li>
        /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The CIs do not incur any cost.</p>
        /// </note>
        pub fn configuration_item_status(
            mut self,
            input: crate::model::ConfigurationItemStatus,
        ) -> Self {
            self.configuration_item_status = Some(input);
            self
        }
        /// <p>The configuration item status. The valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>OK – The resource configuration has been updated</p>
        /// </li>
        /// <li>
        /// <p>ResourceDiscovered – The resource was newly discovered</p>
        /// </li>
        /// <li>
        /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
        /// </li>
        /// <li>
        /// <p>ResourceDeleted – The resource was deleted</p>
        /// </li>
        /// <li>
        /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder excludes the recording of resources of this type</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The CIs do not incur any cost.</p>
        /// </note>
        pub fn set_configuration_item_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationItemStatus>,
        ) -> Self {
            self.configuration_item_status = input;
            self
        }
        /// <p>An identifier that indicates the ordering of the configuration
        /// items of a resource.</p>
        pub fn configuration_state_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_state_id = Some(input.into());
            self
        }
        /// <p>An identifier that indicates the ordering of the configuration
        /// items of a resource.</p>
        pub fn set_configuration_state_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_state_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of Amazon Web Services resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of Amazon Web Services resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource (for example., sg-xxxxxx).</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The custom name of the resource, if available.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The custom name of the resource, if available.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The region where the resource resides.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The region where the resource resides.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>The Availability Zone associated with the resource.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone associated with the resource.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The time stamp when the resource was created.</p>
        pub fn resource_creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.resource_creation_time = Some(input);
            self
        }
        /// <p>The time stamp when the resource was created.</p>
        pub fn set_resource_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.resource_creation_time = input;
            self
        }
        /// <p>The description of the resource configuration.</p>
        pub fn configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration = Some(input.into());
            self
        }
        /// <p>The description of the resource configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Adds a key-value pair to `supplementary_configuration`.
        ///
        /// To override the contents of this collection use [`set_supplementary_configuration`](Self::set_supplementary_configuration).
        ///
        /// <p>Configuration attributes that Config returns for certain
        /// resource types to supplement the information returned for the
        /// configuration parameter.</p>
        pub fn supplementary_configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.supplementary_configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.supplementary_configuration = Some(hash_map);
            self
        }
        /// <p>Configuration attributes that Config returns for certain
        /// resource types to supplement the information returned for the
        /// configuration parameter.</p>
        pub fn set_supplementary_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.supplementary_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`BaseConfigurationItem`](crate::model::BaseConfigurationItem)
        pub fn build(self) -> crate::model::BaseConfigurationItem {
            crate::model::BaseConfigurationItem {
                version: self.version,
                account_id: self.account_id,
                configuration_item_capture_time: self.configuration_item_capture_time,
                configuration_item_status: self.configuration_item_status,
                configuration_state_id: self.configuration_state_id,
                arn: self.arn,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                resource_name: self.resource_name,
                aws_region: self.aws_region,
                availability_zone: self.availability_zone,
                resource_creation_time: self.resource_creation_time,
                configuration: self.configuration,
                supplementary_configuration: self.supplementary_configuration,
            }
        }
    }
}
impl BaseConfigurationItem {
    /// Creates a new builder-style object to manufacture [`BaseConfigurationItem`](crate::model::BaseConfigurationItem)
    pub fn builder() -> crate::model::base_configuration_item::Builder {
        crate::model::base_configuration_item::Builder::default()
    }
}
