// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchGetAggregateResourceConfigInput`](crate::input::BatchGetAggregateResourceConfigInput)
pub mod batch_get_aggregate_resource_config_input {
    /// A builder for [`BatchGetAggregateResourceConfigInput`](crate::input::BatchGetAggregateResourceConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) resource_identifiers:
            std::option::Option<std::vec::Vec<crate::model::AggregateResourceIdentifier>>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// Appends an item to `resource_identifiers`.
        ///
        /// To override the contents of this collection use [`set_resource_identifiers`](Self::set_resource_identifiers).
        ///
        /// <p>A list of aggregate ResourceIdentifiers objects. </p>
        pub fn resource_identifiers(
            mut self,
            input: crate::model::AggregateResourceIdentifier,
        ) -> Self {
            let mut v = self.resource_identifiers.unwrap_or_default();
            v.push(input);
            self.resource_identifiers = Some(v);
            self
        }
        /// <p>A list of aggregate ResourceIdentifiers objects. </p>
        pub fn set_resource_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregateResourceIdentifier>>,
        ) -> Self {
            self.resource_identifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetAggregateResourceConfigInput`](crate::input::BatchGetAggregateResourceConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetAggregateResourceConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetAggregateResourceConfigInput {
                configuration_aggregator_name: self.configuration_aggregator_name,
                resource_identifiers: self.resource_identifiers,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetAggregateResourceConfigInputOperationOutputAlias =
    crate::operation::BatchGetAggregateResourceConfig;
#[doc(hidden)]
pub type BatchGetAggregateResourceConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetAggregateResourceConfigInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetAggregateResourceConfig`](crate::operation::BatchGetAggregateResourceConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetAggregateResourceConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchGetAggregateResourceConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchGetAggregateResourceConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.BatchGetAggregateResourceConfig",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_aggregate_resource_config(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetAggregateResourceConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetAggregateResourceConfig",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchGetAggregateResourceConfigInput`](crate::input::BatchGetAggregateResourceConfigInput)
    pub fn builder() -> crate::input::batch_get_aggregate_resource_config_input::Builder {
        crate::input::batch_get_aggregate_resource_config_input::Builder::default()
    }
}

/// See [`BatchGetResourceConfigInput`](crate::input::BatchGetResourceConfigInput)
pub mod batch_get_resource_config_input {
    /// A builder for [`BatchGetResourceConfigInput`](crate::input::BatchGetResourceConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_keys: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
    }
    impl Builder {
        /// Appends an item to `resource_keys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID.</p>
        pub fn resource_keys(mut self, input: crate::model::ResourceKey) -> Self {
            let mut v = self.resource_keys.unwrap_or_default();
            v.push(input);
            self.resource_keys = Some(v);
            self
        }
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID.</p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
        ) -> Self {
            self.resource_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetResourceConfigInput`](crate::input::BatchGetResourceConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetResourceConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetResourceConfigInput {
                resource_keys: self.resource_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetResourceConfigInputOperationOutputAlias = crate::operation::BatchGetResourceConfig;
#[doc(hidden)]
pub type BatchGetResourceConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetResourceConfigInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetResourceConfig`](crate::operation::BatchGetResourceConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetResourceConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchGetResourceConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchGetResourceConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.BatchGetResourceConfig",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_resource_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetResourceConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetResourceConfig",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchGetResourceConfigInput`](crate::input::BatchGetResourceConfigInput)
    pub fn builder() -> crate::input::batch_get_resource_config_input::Builder {
        crate::input::batch_get_resource_config_input::Builder::default()
    }
}

/// See [`DeleteAggregationAuthorizationInput`](crate::input::DeleteAggregationAuthorizationInput)
pub mod delete_aggregation_authorization_input {
    /// A builder for [`DeleteAggregationAuthorizationInput`](crate::input::DeleteAggregationAuthorizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorized_account_id: std::option::Option<std::string::String>,
        pub(crate) authorized_aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
        pub fn authorized_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorized_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
        pub fn set_authorized_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorized_account_id = input;
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn authorized_aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorized_aws_region = Some(input.into());
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn set_authorized_aws_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorized_aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAggregationAuthorizationInput`](crate::input::DeleteAggregationAuthorizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAggregationAuthorizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAggregationAuthorizationInput {
                authorized_account_id: self.authorized_account_id,
                authorized_aws_region: self.authorized_aws_region,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAggregationAuthorizationInputOperationOutputAlias =
    crate::operation::DeleteAggregationAuthorization;
#[doc(hidden)]
pub type DeleteAggregationAuthorizationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAggregationAuthorizationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAggregationAuthorization`](crate::operation::DeleteAggregationAuthorization)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAggregationAuthorization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAggregationAuthorizationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAggregationAuthorizationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteAggregationAuthorization",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_aggregation_authorization(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAggregationAuthorization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAggregationAuthorization",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAggregationAuthorizationInput`](crate::input::DeleteAggregationAuthorizationInput)
    pub fn builder() -> crate::input::delete_aggregation_authorization_input::Builder {
        crate::input::delete_aggregation_authorization_input::Builder::default()
    }
}

/// See [`DeleteConfigRuleInput`](crate::input::DeleteConfigRuleInput)
pub mod delete_config_rule_input {
    /// A builder for [`DeleteConfigRuleInput`](crate::input::DeleteConfigRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Config rule that you want to delete.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule that you want to delete.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigRuleInput`](crate::input::DeleteConfigRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigRuleInput {
                config_rule_name: self.config_rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigRuleInputOperationOutputAlias = crate::operation::DeleteConfigRule;
#[doc(hidden)]
pub type DeleteConfigRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteConfigRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigRule`](crate::operation::DeleteConfigRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteConfigRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteConfigRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteConfigRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_config_rule(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigRule",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigRuleInput`](crate::input::DeleteConfigRuleInput)
    pub fn builder() -> crate::input::delete_config_rule_input::Builder {
        crate::input::delete_config_rule_input::Builder::default()
    }
}

/// See [`DeleteConfigurationAggregatorInput`](crate::input::DeleteConfigurationAggregatorInput)
pub mod delete_configuration_aggregator_input {
    /// A builder for [`DeleteConfigurationAggregatorInput`](crate::input::DeleteConfigurationAggregatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationAggregatorInput`](crate::input::DeleteConfigurationAggregatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationAggregatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationAggregatorInput {
                configuration_aggregator_name: self.configuration_aggregator_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationAggregatorInputOperationOutputAlias =
    crate::operation::DeleteConfigurationAggregator;
#[doc(hidden)]
pub type DeleteConfigurationAggregatorInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteConfigurationAggregatorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationAggregator`](crate::operation::DeleteConfigurationAggregator)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationAggregator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteConfigurationAggregatorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteConfigurationAggregatorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteConfigurationAggregator",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_configuration_aggregator(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationAggregator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationAggregator",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationAggregatorInput`](crate::input::DeleteConfigurationAggregatorInput)
    pub fn builder() -> crate::input::delete_configuration_aggregator_input::Builder {
        crate::input::delete_configuration_aggregator_input::Builder::default()
    }
}

/// See [`DeleteConfigurationRecorderInput`](crate::input::DeleteConfigurationRecorderInput)
pub mod delete_configuration_recorder_input {
    /// A builder for [`DeleteConfigurationRecorderInput`](crate::input::DeleteConfigurationRecorderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_recorder_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration recorder to be deleted. You can retrieve the name of your configuration recorder by using the <code>DescribeConfigurationRecorders</code> action.</p>
        pub fn configuration_recorder_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_recorder_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration recorder to be deleted. You can retrieve the name of your configuration recorder by using the <code>DescribeConfigurationRecorders</code> action.</p>
        pub fn set_configuration_recorder_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_recorder_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationRecorderInput`](crate::input::DeleteConfigurationRecorderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationRecorderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationRecorderInput {
                configuration_recorder_name: self.configuration_recorder_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationRecorderInputOperationOutputAlias =
    crate::operation::DeleteConfigurationRecorder;
#[doc(hidden)]
pub type DeleteConfigurationRecorderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteConfigurationRecorderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationRecorder`](crate::operation::DeleteConfigurationRecorder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationRecorder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteConfigurationRecorderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteConfigurationRecorderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteConfigurationRecorder",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_configuration_recorder(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationRecorder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationRecorder",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationRecorderInput`](crate::input::DeleteConfigurationRecorderInput)
    pub fn builder() -> crate::input::delete_configuration_recorder_input::Builder {
        crate::input::delete_configuration_recorder_input::Builder::default()
    }
}

/// See [`DeleteConformancePackInput`](crate::input::DeleteConformancePackInput)
pub mod delete_conformance_pack_input {
    /// A builder for [`DeleteConformancePackInput`](crate::input::DeleteConformancePackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the conformance pack you want to delete.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_name = Some(input.into());
            self
        }
        /// <p>Name of the conformance pack you want to delete.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConformancePackInput`](crate::input::DeleteConformancePackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConformancePackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConformancePackInput {
                conformance_pack_name: self.conformance_pack_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConformancePackInputOperationOutputAlias = crate::operation::DeleteConformancePack;
#[doc(hidden)]
pub type DeleteConformancePackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteConformancePackInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConformancePack`](crate::operation::DeleteConformancePack)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConformancePack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteConformancePackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteConformancePackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteConformancePack",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_conformance_pack(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConformancePack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConformancePack",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteConformancePackInput`](crate::input::DeleteConformancePackInput)
    pub fn builder() -> crate::input::delete_conformance_pack_input::Builder {
        crate::input::delete_conformance_pack_input::Builder::default()
    }
}

/// See [`DeleteDeliveryChannelInput`](crate::input::DeleteDeliveryChannelInput)
pub mod delete_delivery_channel_input {
    /// A builder for [`DeleteDeliveryChannelInput`](crate::input::DeleteDeliveryChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_channel_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the delivery channel to delete.</p>
        pub fn delivery_channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_channel_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery channel to delete.</p>
        pub fn set_delivery_channel_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_channel_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeliveryChannelInput`](crate::input::DeleteDeliveryChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeliveryChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeliveryChannelInput {
                delivery_channel_name: self.delivery_channel_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeliveryChannelInputOperationOutputAlias = crate::operation::DeleteDeliveryChannel;
#[doc(hidden)]
pub type DeleteDeliveryChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDeliveryChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDeliveryChannel`](crate::operation::DeleteDeliveryChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDeliveryChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDeliveryChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDeliveryChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteDeliveryChannel",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_delivery_channel(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDeliveryChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDeliveryChannel",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeliveryChannelInput`](crate::input::DeleteDeliveryChannelInput)
    pub fn builder() -> crate::input::delete_delivery_channel_input::Builder {
        crate::input::delete_delivery_channel_input::Builder::default()
    }
}

/// See [`DeleteEvaluationResultsInput`](crate::input::DeleteEvaluationResultsInput)
pub mod delete_evaluation_results_input {
    /// A builder for [`DeleteEvaluationResultsInput`](crate::input::DeleteEvaluationResultsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Config rule for which you want to delete the evaluation results.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want to delete the evaluation results.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEvaluationResultsInput`](crate::input::DeleteEvaluationResultsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEvaluationResultsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEvaluationResultsInput {
                config_rule_name: self.config_rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEvaluationResultsInputOperationOutputAlias =
    crate::operation::DeleteEvaluationResults;
#[doc(hidden)]
pub type DeleteEvaluationResultsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEvaluationResultsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEvaluationResults`](crate::operation::DeleteEvaluationResults)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEvaluationResults,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEvaluationResultsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEvaluationResultsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteEvaluationResults",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_evaluation_results(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEvaluationResults::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEvaluationResults",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEvaluationResultsInput`](crate::input::DeleteEvaluationResultsInput)
    pub fn builder() -> crate::input::delete_evaluation_results_input::Builder {
        crate::input::delete_evaluation_results_input::Builder::default()
    }
}

/// See [`DeleteOrganizationConfigRuleInput`](crate::input::DeleteOrganizationConfigRuleInput)
pub mod delete_organization_config_rule_input {
    /// A builder for [`DeleteOrganizationConfigRuleInput`](crate::input::DeleteOrganizationConfigRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_config_rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of organization Config rule that you want to delete.</p>
        pub fn organization_config_rule_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of organization Config rule that you want to delete.</p>
        pub fn set_organization_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOrganizationConfigRuleInput`](crate::input::DeleteOrganizationConfigRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOrganizationConfigRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOrganizationConfigRuleInput {
                organization_config_rule_name: self.organization_config_rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOrganizationConfigRuleInputOperationOutputAlias =
    crate::operation::DeleteOrganizationConfigRule;
#[doc(hidden)]
pub type DeleteOrganizationConfigRuleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteOrganizationConfigRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOrganizationConfigRule`](crate::operation::DeleteOrganizationConfigRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOrganizationConfigRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteOrganizationConfigRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteOrganizationConfigRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteOrganizationConfigRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_organization_config_rule(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOrganizationConfigRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOrganizationConfigRule",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationConfigRuleInput`](crate::input::DeleteOrganizationConfigRuleInput)
    pub fn builder() -> crate::input::delete_organization_config_rule_input::Builder {
        crate::input::delete_organization_config_rule_input::Builder::default()
    }
}

/// See [`DeleteOrganizationConformancePackInput`](crate::input::DeleteOrganizationConformancePackInput)
pub mod delete_organization_conformance_pack_input {
    /// A builder for [`DeleteOrganizationConformancePackInput`](crate::input::DeleteOrganizationConformancePackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_conformance_pack_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of organization conformance pack that you want to delete.</p>
        pub fn organization_conformance_pack_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_name = Some(input.into());
            self
        }
        /// <p>The name of organization conformance pack that you want to delete.</p>
        pub fn set_organization_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOrganizationConformancePackInput`](crate::input::DeleteOrganizationConformancePackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOrganizationConformancePackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOrganizationConformancePackInput {
                organization_conformance_pack_name: self.organization_conformance_pack_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOrganizationConformancePackInputOperationOutputAlias =
    crate::operation::DeleteOrganizationConformancePack;
#[doc(hidden)]
pub type DeleteOrganizationConformancePackInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteOrganizationConformancePackInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOrganizationConformancePack`](crate::operation::DeleteOrganizationConformancePack)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOrganizationConformancePack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteOrganizationConformancePackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteOrganizationConformancePackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteOrganizationConformancePack",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_organization_conformance_pack(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOrganizationConformancePack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOrganizationConformancePack",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteOrganizationConformancePackInput`](crate::input::DeleteOrganizationConformancePackInput)
    pub fn builder() -> crate::input::delete_organization_conformance_pack_input::Builder {
        crate::input::delete_organization_conformance_pack_input::Builder::default()
    }
}

/// See [`DeletePendingAggregationRequestInput`](crate::input::DeletePendingAggregationRequestInput)
pub mod delete_pending_aggregation_request_input {
    /// A builder for [`DeletePendingAggregationRequestInput`](crate::input::DeletePendingAggregationRequestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) requester_account_id: std::option::Option<std::string::String>,
        pub(crate) requester_aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
        pub fn requester_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
        pub fn set_requester_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requester_account_id = input;
            self
        }
        /// <p>The region requesting to aggregate data.</p>
        pub fn requester_aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester_aws_region = Some(input.into());
            self
        }
        /// <p>The region requesting to aggregate data.</p>
        pub fn set_requester_aws_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.requester_aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePendingAggregationRequestInput`](crate::input::DeletePendingAggregationRequestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePendingAggregationRequestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePendingAggregationRequestInput {
                requester_account_id: self.requester_account_id,
                requester_aws_region: self.requester_aws_region,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePendingAggregationRequestInputOperationOutputAlias =
    crate::operation::DeletePendingAggregationRequest;
#[doc(hidden)]
pub type DeletePendingAggregationRequestInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeletePendingAggregationRequestInput {
    /// Consumes the builder and constructs an Operation<[`DeletePendingAggregationRequest`](crate::operation::DeletePendingAggregationRequest)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePendingAggregationRequest,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePendingAggregationRequestInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePendingAggregationRequestInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeletePendingAggregationRequest",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_pending_aggregation_request(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePendingAggregationRequest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePendingAggregationRequest",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePendingAggregationRequestInput`](crate::input::DeletePendingAggregationRequestInput)
    pub fn builder() -> crate::input::delete_pending_aggregation_request_input::Builder {
        crate::input::delete_pending_aggregation_request_input::Builder::default()
    }
}

/// See [`DeleteRemediationConfigurationInput`](crate::input::DeleteRemediationConfigurationInput)
pub mod delete_remediation_configuration_input {
    /// A builder for [`DeleteRemediationConfigurationInput`](crate::input::DeleteRemediationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Config rule for which you want to delete remediation configuration.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want to delete remediation configuration.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>The type of a resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of a resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRemediationConfigurationInput`](crate::input::DeleteRemediationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRemediationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRemediationConfigurationInput {
                config_rule_name: self.config_rule_name,
                resource_type: self.resource_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRemediationConfigurationInputOperationOutputAlias =
    crate::operation::DeleteRemediationConfiguration;
#[doc(hidden)]
pub type DeleteRemediationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRemediationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRemediationConfiguration`](crate::operation::DeleteRemediationConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRemediationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRemediationConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRemediationConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteRemediationConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_remediation_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRemediationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRemediationConfiguration",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRemediationConfigurationInput`](crate::input::DeleteRemediationConfigurationInput)
    pub fn builder() -> crate::input::delete_remediation_configuration_input::Builder {
        crate::input::delete_remediation_configuration_input::Builder::default()
    }
}

/// See [`DeleteRemediationExceptionsInput`](crate::input::DeleteRemediationExceptionsInput)
pub mod delete_remediation_exceptions_input {
    /// A builder for [`DeleteRemediationExceptionsInput`](crate::input::DeleteRemediationExceptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) resource_keys:
            std::option::Option<std::vec::Vec<crate::model::RemediationExceptionResourceKey>>,
    }
    impl Builder {
        /// <p>The name of the Config rule for which you want to delete remediation exception configuration.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want to delete remediation exception configuration.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// Appends an item to `resource_keys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn resource_keys(
            mut self,
            input: crate::model::RemediationExceptionResourceKey,
        ) -> Self {
            let mut v = self.resource_keys.unwrap_or_default();
            v.push(input);
            self.resource_keys = Some(v);
            self
        }
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RemediationExceptionResourceKey>,
            >,
        ) -> Self {
            self.resource_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRemediationExceptionsInput`](crate::input::DeleteRemediationExceptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRemediationExceptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRemediationExceptionsInput {
                config_rule_name: self.config_rule_name,
                resource_keys: self.resource_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRemediationExceptionsInputOperationOutputAlias =
    crate::operation::DeleteRemediationExceptions;
#[doc(hidden)]
pub type DeleteRemediationExceptionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRemediationExceptionsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRemediationExceptions`](crate::operation::DeleteRemediationExceptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRemediationExceptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRemediationExceptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRemediationExceptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteRemediationExceptions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_remediation_exceptions(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRemediationExceptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRemediationExceptions",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRemediationExceptionsInput`](crate::input::DeleteRemediationExceptionsInput)
    pub fn builder() -> crate::input::delete_remediation_exceptions_input::Builder {
        crate::input::delete_remediation_exceptions_input::Builder::default()
    }
}

/// See [`DeleteResourceConfigInput`](crate::input::DeleteResourceConfigInput)
pub mod delete_resource_config_input {
    /// A builder for [`DeleteResourceConfigInput`](crate::input::DeleteResourceConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Unique identifier of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Unique identifier of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourceConfigInput`](crate::input::DeleteResourceConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourceConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourceConfigInput {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourceConfigInputOperationOutputAlias = crate::operation::DeleteResourceConfig;
#[doc(hidden)]
pub type DeleteResourceConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteResourceConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourceConfig`](crate::operation::DeleteResourceConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourceConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteResourceConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteResourceConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteResourceConfig",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_resource_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourceConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourceConfig",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourceConfigInput`](crate::input::DeleteResourceConfigInput)
    pub fn builder() -> crate::input::delete_resource_config_input::Builder {
        crate::input::delete_resource_config_input::Builder::default()
    }
}

/// See [`DeleteRetentionConfigurationInput`](crate::input::DeleteRetentionConfigurationInput)
pub mod delete_retention_configuration_input {
    /// A builder for [`DeleteRetentionConfigurationInput`](crate::input::DeleteRetentionConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retention_configuration_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the retention configuration to delete.</p>
        pub fn retention_configuration_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.retention_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the retention configuration to delete.</p>
        pub fn set_retention_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retention_configuration_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRetentionConfigurationInput`](crate::input::DeleteRetentionConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRetentionConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRetentionConfigurationInput {
                retention_configuration_name: self.retention_configuration_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRetentionConfigurationInputOperationOutputAlias =
    crate::operation::DeleteRetentionConfiguration;
#[doc(hidden)]
pub type DeleteRetentionConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRetentionConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRetentionConfiguration`](crate::operation::DeleteRetentionConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRetentionConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRetentionConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRetentionConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteRetentionConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_retention_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRetentionConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRetentionConfiguration",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRetentionConfigurationInput`](crate::input::DeleteRetentionConfigurationInput)
    pub fn builder() -> crate::input::delete_retention_configuration_input::Builder {
        crate::input::delete_retention_configuration_input::Builder::default()
    }
}

/// See [`DeleteStoredQueryInput`](crate::input::DeleteStoredQueryInput)
pub mod delete_stored_query_input {
    /// A builder for [`DeleteStoredQueryInput`](crate::input::DeleteStoredQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the query that you want to delete.</p>
        pub fn query_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_name = Some(input.into());
            self
        }
        /// <p>The name of the query that you want to delete.</p>
        pub fn set_query_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStoredQueryInput`](crate::input::DeleteStoredQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStoredQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStoredQueryInput {
                query_name: self.query_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStoredQueryInputOperationOutputAlias = crate::operation::DeleteStoredQuery;
#[doc(hidden)]
pub type DeleteStoredQueryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStoredQueryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStoredQuery`](crate::operation::DeleteStoredQuery)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStoredQuery,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteStoredQueryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteStoredQueryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeleteStoredQuery",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_stored_query(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStoredQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStoredQuery",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteStoredQueryInput`](crate::input::DeleteStoredQueryInput)
    pub fn builder() -> crate::input::delete_stored_query_input::Builder {
        crate::input::delete_stored_query_input::Builder::default()
    }
}

/// See [`DeliverConfigSnapshotInput`](crate::input::DeliverConfigSnapshotInput)
pub mod deliver_config_snapshot_input {
    /// A builder for [`DeliverConfigSnapshotInput`](crate::input::DeliverConfigSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_channel_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the delivery channel through which the snapshot is delivered.</p>
        pub fn delivery_channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_channel_name = Some(input.into());
            self
        }
        /// <p>The name of the delivery channel through which the snapshot is delivered.</p>
        pub fn set_delivery_channel_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_channel_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeliverConfigSnapshotInput`](crate::input::DeliverConfigSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeliverConfigSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeliverConfigSnapshotInput {
                delivery_channel_name: self.delivery_channel_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeliverConfigSnapshotInputOperationOutputAlias = crate::operation::DeliverConfigSnapshot;
#[doc(hidden)]
pub type DeliverConfigSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeliverConfigSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeliverConfigSnapshot`](crate::operation::DeliverConfigSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeliverConfigSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeliverConfigSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeliverConfigSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DeliverConfigSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_deliver_config_snapshot(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeliverConfigSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeliverConfigSnapshot",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeliverConfigSnapshotInput`](crate::input::DeliverConfigSnapshotInput)
    pub fn builder() -> crate::input::deliver_config_snapshot_input::Builder {
        crate::input::deliver_config_snapshot_input::Builder::default()
    }
}

/// See [`DescribeAggregateComplianceByConfigRulesInput`](crate::input::DescribeAggregateComplianceByConfigRulesInput)
pub mod describe_aggregate_compliance_by_config_rules_input {
    /// A builder for [`DescribeAggregateComplianceByConfigRulesInput`](crate::input::DescribeAggregateComplianceByConfigRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::ConfigRuleComplianceFilters>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// <p>Filters the results by ConfigRuleComplianceFilters object. </p>
        pub fn filters(mut self, input: crate::model::ConfigRuleComplianceFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>Filters the results by ConfigRuleComplianceFilters object. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ConfigRuleComplianceFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAggregateComplianceByConfigRulesInput`](crate::input::DescribeAggregateComplianceByConfigRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAggregateComplianceByConfigRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeAggregateComplianceByConfigRulesInput {
                    configuration_aggregator_name: self.configuration_aggregator_name,
                    filters: self.filters,
                    limit: self.limit.unwrap_or_default(),
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeAggregateComplianceByConfigRulesInputOperationOutputAlias =
    crate::operation::DescribeAggregateComplianceByConfigRules;
#[doc(hidden)]
pub type DescribeAggregateComplianceByConfigRulesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAggregateComplianceByConfigRulesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAggregateComplianceByConfigRules`](crate::operation::DescribeAggregateComplianceByConfigRules)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAggregateComplianceByConfigRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAggregateComplianceByConfigRulesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAggregateComplianceByConfigRulesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeAggregateComplianceByConfigRules",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_aggregate_compliance_by_config_rules(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAggregateComplianceByConfigRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAggregateComplianceByConfigRules",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAggregateComplianceByConfigRulesInput`](crate::input::DescribeAggregateComplianceByConfigRulesInput)
    pub fn builder() -> crate::input::describe_aggregate_compliance_by_config_rules_input::Builder {
        crate::input::describe_aggregate_compliance_by_config_rules_input::Builder::default()
    }
}

/// See [`DescribeAggregateComplianceByConformancePacksInput`](crate::input::DescribeAggregateComplianceByConformancePacksInput)
pub mod describe_aggregate_compliance_by_conformance_packs_input {
    /// A builder for [`DescribeAggregateComplianceByConformancePacksInput`](crate::input::DescribeAggregateComplianceByConformancePacksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<crate::model::AggregateConformancePackComplianceFilters>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// <p>Filters the result by <code>AggregateConformancePackComplianceFilters</code> object.</p>
        pub fn filters(
            mut self,
            input: crate::model::AggregateConformancePackComplianceFilters,
        ) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>Filters the result by <code>AggregateConformancePackComplianceFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::AggregateConformancePackComplianceFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of conformance packs compliance details returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of conformance packs compliance details returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAggregateComplianceByConformancePacksInput`](crate::input::DescribeAggregateComplianceByConformancePacksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAggregateComplianceByConformancePacksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeAggregateComplianceByConformancePacksInput {
                    configuration_aggregator_name: self.configuration_aggregator_name,
                    filters: self.filters,
                    limit: self.limit.unwrap_or_default(),
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeAggregateComplianceByConformancePacksInputOperationOutputAlias =
    crate::operation::DescribeAggregateComplianceByConformancePacks;
#[doc(hidden)]
pub type DescribeAggregateComplianceByConformancePacksInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAggregateComplianceByConformancePacksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAggregateComplianceByConformancePacks`](crate::operation::DescribeAggregateComplianceByConformancePacks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAggregateComplianceByConformancePacks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAggregateComplianceByConformancePacksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAggregateComplianceByConformancePacksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeAggregateComplianceByConformancePacks",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_aggregate_compliance_by_conformance_packs(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAggregateComplianceByConformancePacks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAggregateComplianceByConformancePacks",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAggregateComplianceByConformancePacksInput`](crate::input::DescribeAggregateComplianceByConformancePacksInput)
    pub fn builder(
    ) -> crate::input::describe_aggregate_compliance_by_conformance_packs_input::Builder {
        crate::input::describe_aggregate_compliance_by_conformance_packs_input::Builder::default()
    }
}

/// See [`DescribeAggregationAuthorizationsInput`](crate::input::DescribeAggregationAuthorizationsInput)
pub mod describe_aggregation_authorizations_input {
    /// A builder for [`DescribeAggregationAuthorizationsInput`](crate::input::DescribeAggregationAuthorizationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of AggregationAuthorizations returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of AggregationAuthorizations returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAggregationAuthorizationsInput`](crate::input::DescribeAggregationAuthorizationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAggregationAuthorizationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAggregationAuthorizationsInput {
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAggregationAuthorizationsInputOperationOutputAlias =
    crate::operation::DescribeAggregationAuthorizations;
#[doc(hidden)]
pub type DescribeAggregationAuthorizationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAggregationAuthorizationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAggregationAuthorizations`](crate::operation::DescribeAggregationAuthorizations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAggregationAuthorizations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAggregationAuthorizationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAggregationAuthorizationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeAggregationAuthorizations",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_aggregation_authorizations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAggregationAuthorizations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAggregationAuthorizations",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAggregationAuthorizationsInput`](crate::input::DescribeAggregationAuthorizationsInput)
    pub fn builder() -> crate::input::describe_aggregation_authorizations_input::Builder {
        crate::input::describe_aggregation_authorizations_input::Builder::default()
    }
}

/// See [`DescribeComplianceByConfigRuleInput`](crate::input::DescribeComplianceByConfigRuleInput)
pub mod describe_compliance_by_config_rule_input {
    /// A builder for [`DescribeComplianceByConfigRuleInput`](crate::input::DescribeComplianceByConfigRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) compliance_types:
            std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `config_rule_names`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>Specify one or more Config rule names to filter the results by rule.</p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.config_rule_names.unwrap_or_default();
            v.push(input.into());
            self.config_rule_names = Some(v);
            self
        }
        /// <p>Specify one or more Config rule names to filter the results by rule.</p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.config_rule_names = input;
            self
        }
        /// Appends an item to `compliance_types`.
        ///
        /// To override the contents of this collection use [`set_compliance_types`](Self::set_compliance_types).
        ///
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.</p>
        pub fn compliance_types(mut self, input: crate::model::ComplianceType) -> Self {
            let mut v = self.compliance_types.unwrap_or_default();
            v.push(input);
            self.compliance_types = Some(v);
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.</p>
        pub fn set_compliance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        ) -> Self {
            self.compliance_types = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeComplianceByConfigRuleInput`](crate::input::DescribeComplianceByConfigRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeComplianceByConfigRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeComplianceByConfigRuleInput {
                config_rule_names: self.config_rule_names,
                compliance_types: self.compliance_types,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeComplianceByConfigRuleInputOperationOutputAlias =
    crate::operation::DescribeComplianceByConfigRule;
#[doc(hidden)]
pub type DescribeComplianceByConfigRuleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeComplianceByConfigRuleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeComplianceByConfigRule`](crate::operation::DescribeComplianceByConfigRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeComplianceByConfigRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeComplianceByConfigRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeComplianceByConfigRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeComplianceByConfigRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_compliance_by_config_rule(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeComplianceByConfigRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeComplianceByConfigRule",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeComplianceByConfigRuleInput`](crate::input::DescribeComplianceByConfigRuleInput)
    pub fn builder() -> crate::input::describe_compliance_by_config_rule_input::Builder {
        crate::input::describe_compliance_by_config_rule_input::Builder::default()
    }
}

/// See [`DescribeComplianceByResourceInput`](crate::input::DescribeComplianceByResourceInput)
pub mod describe_compliance_by_resource_input {
    /// A builder for [`DescribeComplianceByResourceInput`](crate::input::DescribeComplianceByResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) compliance_types:
            std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The types of Amazon Web Services resources for which you want compliance information (for example, <code>AWS::EC2::Instance</code>). For this action, you can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The types of Amazon Web Services resources for which you want compliance information (for example, <code>AWS::EC2::Instance</code>). For this action, you can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the Amazon Web Services resource for which you want compliance information. You can specify only one resource ID. If you specify a resource ID, you must also specify a type for <code>ResourceType</code>.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services resource for which you want compliance information. You can specify only one resource ID. If you specify a resource ID, you must also specify a type for <code>ResourceType</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `compliance_types`.
        ///
        /// To override the contents of this collection use [`set_compliance_types`](Self::set_compliance_types).
        ///
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>
        pub fn compliance_types(mut self, input: crate::model::ComplianceType) -> Self {
            let mut v = self.compliance_types.unwrap_or_default();
            v.push(input);
            self.compliance_types = Some(v);
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>
        pub fn set_compliance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        ) -> Self {
            self.compliance_types = input;
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeComplianceByResourceInput`](crate::input::DescribeComplianceByResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeComplianceByResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeComplianceByResourceInput {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                compliance_types: self.compliance_types,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeComplianceByResourceInputOperationOutputAlias =
    crate::operation::DescribeComplianceByResource;
#[doc(hidden)]
pub type DescribeComplianceByResourceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeComplianceByResourceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeComplianceByResource`](crate::operation::DescribeComplianceByResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeComplianceByResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeComplianceByResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeComplianceByResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeComplianceByResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_compliance_by_resource(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeComplianceByResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeComplianceByResource",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeComplianceByResourceInput`](crate::input::DescribeComplianceByResourceInput)
    pub fn builder() -> crate::input::describe_compliance_by_resource_input::Builder {
        crate::input::describe_compliance_by_resource_input::Builder::default()
    }
}

/// See [`DescribeConfigRuleEvaluationStatusInput`](crate::input::DescribeConfigRuleEvaluationStatusInput)
pub mod describe_config_rule_evaluation_status_input {
    /// A builder for [`DescribeConfigRuleEvaluationStatusInput`](crate::input::DescribeConfigRuleEvaluationStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `config_rule_names`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>The name of the Config managed rules for which you want status information. If you do not specify any names, Config returns status information for all Config managed rules that you use.</p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.config_rule_names.unwrap_or_default();
            v.push(input.into());
            self.config_rule_names = Some(v);
            self
        }
        /// <p>The name of the Config managed rules for which you want status information. If you do not specify any names, Config returns status information for all Config managed rules that you use.</p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.config_rule_names = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of rule evaluation results that you want returned.</p>
        /// <p>This parameter is required if the rule limit for your account is more than the default of 150 rules.</p>
        /// <p>For information about requesting a rule limit increase, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">Config Limits</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The number of rule evaluation results that you want returned.</p>
        /// <p>This parameter is required if the rule limit for your account is more than the default of 150 rules.</p>
        /// <p>For information about requesting a rule limit increase, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">Config Limits</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigRuleEvaluationStatusInput`](crate::input::DescribeConfigRuleEvaluationStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigRuleEvaluationStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConfigRuleEvaluationStatusInput {
                config_rule_names: self.config_rule_names,
                next_token: self.next_token,
                limit: self.limit.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigRuleEvaluationStatusInputOperationOutputAlias =
    crate::operation::DescribeConfigRuleEvaluationStatus;
#[doc(hidden)]
pub type DescribeConfigRuleEvaluationStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConfigRuleEvaluationStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfigRuleEvaluationStatus`](crate::operation::DescribeConfigRuleEvaluationStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfigRuleEvaluationStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConfigRuleEvaluationStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConfigRuleEvaluationStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeConfigRuleEvaluationStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_config_rule_evaluation_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfigRuleEvaluationStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfigRuleEvaluationStatus",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigRuleEvaluationStatusInput`](crate::input::DescribeConfigRuleEvaluationStatusInput)
    pub fn builder() -> crate::input::describe_config_rule_evaluation_status_input::Builder {
        crate::input::describe_config_rule_evaluation_status_input::Builder::default()
    }
}

/// See [`DescribeConfigRulesInput`](crate::input::DescribeConfigRulesInput)
pub mod describe_config_rules_input {
    /// A builder for [`DescribeConfigRulesInput`](crate::input::DescribeConfigRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `config_rule_names`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>The names of the Config rules for which you want details. If you do not specify any names, Config returns details for all your rules.</p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.config_rule_names.unwrap_or_default();
            v.push(input.into());
            self.config_rule_names = Some(v);
            self
        }
        /// <p>The names of the Config rules for which you want details. If you do not specify any names, Config returns details for all your rules.</p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.config_rule_names = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigRulesInput`](crate::input::DescribeConfigRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConfigRulesInput {
                config_rule_names: self.config_rule_names,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigRulesInputOperationOutputAlias = crate::operation::DescribeConfigRules;
#[doc(hidden)]
pub type DescribeConfigRulesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConfigRulesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfigRules`](crate::operation::DescribeConfigRules)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfigRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConfigRulesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConfigRulesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeConfigRules",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_config_rules(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfigRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfigRules",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigRulesInput`](crate::input::DescribeConfigRulesInput)
    pub fn builder() -> crate::input::describe_config_rules_input::Builder {
        crate::input::describe_config_rules_input::Builder::default()
    }
}

/// See [`DescribeConfigurationAggregatorsInput`](crate::input::DescribeConfigurationAggregatorsInput)
pub mod describe_configuration_aggregators_input {
    /// A builder for [`DescribeConfigurationAggregatorsInput`](crate::input::DescribeConfigurationAggregatorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `configuration_aggregator_names`.
        ///
        /// To override the contents of this collection use [`set_configuration_aggregator_names`](Self::set_configuration_aggregator_names).
        ///
        /// <p>The name of the configuration aggregators.</p>
        pub fn configuration_aggregator_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.configuration_aggregator_names.unwrap_or_default();
            v.push(input.into());
            self.configuration_aggregator_names = Some(v);
            self
        }
        /// <p>The name of the configuration aggregators.</p>
        pub fn set_configuration_aggregator_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.configuration_aggregator_names = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of configuration aggregators returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of configuration aggregators returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationAggregatorsInput`](crate::input::DescribeConfigurationAggregatorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigurationAggregatorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConfigurationAggregatorsInput {
                configuration_aggregator_names: self.configuration_aggregator_names,
                next_token: self.next_token,
                limit: self.limit.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigurationAggregatorsInputOperationOutputAlias =
    crate::operation::DescribeConfigurationAggregators;
#[doc(hidden)]
pub type DescribeConfigurationAggregatorsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConfigurationAggregatorsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfigurationAggregators`](crate::operation::DescribeConfigurationAggregators)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfigurationAggregators,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConfigurationAggregatorsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConfigurationAggregatorsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeConfigurationAggregators",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_configuration_aggregators(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfigurationAggregators::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfigurationAggregators",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationAggregatorsInput`](crate::input::DescribeConfigurationAggregatorsInput)
    pub fn builder() -> crate::input::describe_configuration_aggregators_input::Builder {
        crate::input::describe_configuration_aggregators_input::Builder::default()
    }
}

/// See [`DescribeConfigurationAggregatorSourcesStatusInput`](crate::input::DescribeConfigurationAggregatorSourcesStatusInput)
pub mod describe_configuration_aggregator_sources_status_input {
    /// A builder for [`DescribeConfigurationAggregatorSourcesStatusInput`](crate::input::DescribeConfigurationAggregatorSourcesStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) update_status:
            std::option::Option<std::vec::Vec<crate::model::AggregatedSourceStatusType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// Appends an item to `update_status`.
        ///
        /// To override the contents of this collection use [`set_update_status`](Self::set_update_status).
        ///
        /// <p>Filters the status type.</p>
        /// <ul>
        /// <li> <p>Valid value FAILED indicates errors while moving data.</p> </li>
        /// <li> <p>Valid value SUCCEEDED indicates the data was successfully moved.</p> </li>
        /// <li> <p>Valid value OUTDATED indicates the data is not the most recent.</p> </li>
        /// </ul>
        pub fn update_status(mut self, input: crate::model::AggregatedSourceStatusType) -> Self {
            let mut v = self.update_status.unwrap_or_default();
            v.push(input);
            self.update_status = Some(v);
            self
        }
        /// <p>Filters the status type.</p>
        /// <ul>
        /// <li> <p>Valid value FAILED indicates errors while moving data.</p> </li>
        /// <li> <p>Valid value SUCCEEDED indicates the data was successfully moved.</p> </li>
        /// <li> <p>Valid value OUTDATED indicates the data is not the most recent.</p> </li>
        /// </ul>
        pub fn set_update_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregatedSourceStatusType>>,
        ) -> Self {
            self.update_status = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationAggregatorSourcesStatusInput`](crate::input::DescribeConfigurationAggregatorSourcesStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigurationAggregatorSourcesStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeConfigurationAggregatorSourcesStatusInput {
                    configuration_aggregator_name: self.configuration_aggregator_name,
                    update_status: self.update_status,
                    next_token: self.next_token,
                    limit: self.limit.unwrap_or_default(),
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigurationAggregatorSourcesStatusInputOperationOutputAlias =
    crate::operation::DescribeConfigurationAggregatorSourcesStatus;
#[doc(hidden)]
pub type DescribeConfigurationAggregatorSourcesStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConfigurationAggregatorSourcesStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfigurationAggregatorSourcesStatus`](crate::operation::DescribeConfigurationAggregatorSourcesStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfigurationAggregatorSourcesStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConfigurationAggregatorSourcesStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConfigurationAggregatorSourcesStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeConfigurationAggregatorSourcesStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_configuration_aggregator_sources_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfigurationAggregatorSourcesStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfigurationAggregatorSourcesStatus",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationAggregatorSourcesStatusInput`](crate::input::DescribeConfigurationAggregatorSourcesStatusInput)
    pub fn builder() -> crate::input::describe_configuration_aggregator_sources_status_input::Builder
    {
        crate::input::describe_configuration_aggregator_sources_status_input::Builder::default()
    }
}

/// See [`DescribeConfigurationRecordersInput`](crate::input::DescribeConfigurationRecordersInput)
pub mod describe_configuration_recorders_input {
    /// A builder for [`DescribeConfigurationRecordersInput`](crate::input::DescribeConfigurationRecordersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_recorder_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `configuration_recorder_names`.
        ///
        /// To override the contents of this collection use [`set_configuration_recorder_names`](Self::set_configuration_recorder_names).
        ///
        /// <p>A list of configuration recorder names.</p>
        pub fn configuration_recorder_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.configuration_recorder_names.unwrap_or_default();
            v.push(input.into());
            self.configuration_recorder_names = Some(v);
            self
        }
        /// <p>A list of configuration recorder names.</p>
        pub fn set_configuration_recorder_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.configuration_recorder_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationRecordersInput`](crate::input::DescribeConfigurationRecordersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigurationRecordersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConfigurationRecordersInput {
                configuration_recorder_names: self.configuration_recorder_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigurationRecordersInputOperationOutputAlias =
    crate::operation::DescribeConfigurationRecorders;
#[doc(hidden)]
pub type DescribeConfigurationRecordersInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConfigurationRecordersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfigurationRecorders`](crate::operation::DescribeConfigurationRecorders)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfigurationRecorders,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConfigurationRecordersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConfigurationRecordersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeConfigurationRecorders",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_configuration_recorders(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfigurationRecorders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfigurationRecorders",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationRecordersInput`](crate::input::DescribeConfigurationRecordersInput)
    pub fn builder() -> crate::input::describe_configuration_recorders_input::Builder {
        crate::input::describe_configuration_recorders_input::Builder::default()
    }
}

/// See [`DescribeConfigurationRecorderStatusInput`](crate::input::DescribeConfigurationRecorderStatusInput)
pub mod describe_configuration_recorder_status_input {
    /// A builder for [`DescribeConfigurationRecorderStatusInput`](crate::input::DescribeConfigurationRecorderStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_recorder_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `configuration_recorder_names`.
        ///
        /// To override the contents of this collection use [`set_configuration_recorder_names`](Self::set_configuration_recorder_names).
        ///
        /// <p>The name(s) of the configuration recorder. If the name is not specified, the action returns the current status of all the configuration recorders associated with the account.</p>
        pub fn configuration_recorder_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.configuration_recorder_names.unwrap_or_default();
            v.push(input.into());
            self.configuration_recorder_names = Some(v);
            self
        }
        /// <p>The name(s) of the configuration recorder. If the name is not specified, the action returns the current status of all the configuration recorders associated with the account.</p>
        pub fn set_configuration_recorder_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.configuration_recorder_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationRecorderStatusInput`](crate::input::DescribeConfigurationRecorderStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigurationRecorderStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConfigurationRecorderStatusInput {
                configuration_recorder_names: self.configuration_recorder_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigurationRecorderStatusInputOperationOutputAlias =
    crate::operation::DescribeConfigurationRecorderStatus;
#[doc(hidden)]
pub type DescribeConfigurationRecorderStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConfigurationRecorderStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfigurationRecorderStatus`](crate::operation::DescribeConfigurationRecorderStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfigurationRecorderStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConfigurationRecorderStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConfigurationRecorderStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeConfigurationRecorderStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_configuration_recorder_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfigurationRecorderStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfigurationRecorderStatus",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationRecorderStatusInput`](crate::input::DescribeConfigurationRecorderStatusInput)
    pub fn builder() -> crate::input::describe_configuration_recorder_status_input::Builder {
        crate::input::describe_configuration_recorder_status_input::Builder::default()
    }
}

/// See [`DescribeConformancePackComplianceInput`](crate::input::DescribeConformancePackComplianceInput)
pub mod describe_conformance_pack_compliance_input {
    /// A builder for [`DescribeConformancePackComplianceInput`](crate::input::DescribeConformancePackComplianceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::ConformancePackComplianceFilters>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the conformance pack.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_name = Some(input.into());
            self
        }
        /// <p>Name of the conformance pack.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_name = input;
            self
        }
        /// <p>A <code>ConformancePackComplianceFilters</code> object.</p>
        pub fn filters(mut self, input: crate::model::ConformancePackComplianceFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A <code>ConformancePackComplianceFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ConformancePackComplianceFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of Config rules within a conformance pack are returned on each page.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of Config rules within a conformance pack are returned on each page.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConformancePackComplianceInput`](crate::input::DescribeConformancePackComplianceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConformancePackComplianceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConformancePackComplianceInput {
                conformance_pack_name: self.conformance_pack_name,
                filters: self.filters,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConformancePackComplianceInputOperationOutputAlias =
    crate::operation::DescribeConformancePackCompliance;
#[doc(hidden)]
pub type DescribeConformancePackComplianceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConformancePackComplianceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConformancePackCompliance`](crate::operation::DescribeConformancePackCompliance)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConformancePackCompliance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConformancePackComplianceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConformancePackComplianceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeConformancePackCompliance",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_conformance_pack_compliance(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConformancePackCompliance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConformancePackCompliance",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConformancePackComplianceInput`](crate::input::DescribeConformancePackComplianceInput)
    pub fn builder() -> crate::input::describe_conformance_pack_compliance_input::Builder {
        crate::input::describe_conformance_pack_compliance_input::Builder::default()
    }
}

/// See [`DescribeConformancePacksInput`](crate::input::DescribeConformancePacksInput)
pub mod describe_conformance_packs_input {
    /// A builder for [`DescribeConformancePacksInput`](crate::input::DescribeConformancePacksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `conformance_pack_names`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_names`](Self::set_conformance_pack_names).
        ///
        /// <p>Comma-separated list of conformance pack names for which you want details. If you do not specify any names, Config returns details for all your conformance packs. </p>
        pub fn conformance_pack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.conformance_pack_names.unwrap_or_default();
            v.push(input.into());
            self.conformance_pack_names = Some(v);
            self
        }
        /// <p>Comma-separated list of conformance pack names for which you want details. If you do not specify any names, Config returns details for all your conformance packs. </p>
        pub fn set_conformance_pack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.conformance_pack_names = input;
            self
        }
        /// <p>The maximum number of conformance packs returned on each page.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of conformance packs returned on each page.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConformancePacksInput`](crate::input::DescribeConformancePacksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConformancePacksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConformancePacksInput {
                conformance_pack_names: self.conformance_pack_names,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConformancePacksInputOperationOutputAlias =
    crate::operation::DescribeConformancePacks;
#[doc(hidden)]
pub type DescribeConformancePacksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConformancePacksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConformancePacks`](crate::operation::DescribeConformancePacks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConformancePacks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConformancePacksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConformancePacksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeConformancePacks",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_conformance_packs(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConformancePacks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConformancePacks",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConformancePacksInput`](crate::input::DescribeConformancePacksInput)
    pub fn builder() -> crate::input::describe_conformance_packs_input::Builder {
        crate::input::describe_conformance_packs_input::Builder::default()
    }
}

/// See [`DescribeConformancePackStatusInput`](crate::input::DescribeConformancePackStatusInput)
pub mod describe_conformance_pack_status_input {
    /// A builder for [`DescribeConformancePackStatusInput`](crate::input::DescribeConformancePackStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `conformance_pack_names`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_names`](Self::set_conformance_pack_names).
        ///
        /// <p>Comma-separated list of conformance pack names.</p>
        pub fn conformance_pack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.conformance_pack_names.unwrap_or_default();
            v.push(input.into());
            self.conformance_pack_names = Some(v);
            self
        }
        /// <p>Comma-separated list of conformance pack names.</p>
        pub fn set_conformance_pack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.conformance_pack_names = input;
            self
        }
        /// <p>The maximum number of conformance packs status returned on each page.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of conformance packs status returned on each page.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConformancePackStatusInput`](crate::input::DescribeConformancePackStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConformancePackStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConformancePackStatusInput {
                conformance_pack_names: self.conformance_pack_names,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConformancePackStatusInputOperationOutputAlias =
    crate::operation::DescribeConformancePackStatus;
#[doc(hidden)]
pub type DescribeConformancePackStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConformancePackStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConformancePackStatus`](crate::operation::DescribeConformancePackStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConformancePackStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeConformancePackStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeConformancePackStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeConformancePackStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_conformance_pack_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConformancePackStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConformancePackStatus",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeConformancePackStatusInput`](crate::input::DescribeConformancePackStatusInput)
    pub fn builder() -> crate::input::describe_conformance_pack_status_input::Builder {
        crate::input::describe_conformance_pack_status_input::Builder::default()
    }
}

/// See [`DescribeDeliveryChannelsInput`](crate::input::DescribeDeliveryChannelsInput)
pub mod describe_delivery_channels_input {
    /// A builder for [`DescribeDeliveryChannelsInput`](crate::input::DescribeDeliveryChannelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_channel_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `delivery_channel_names`.
        ///
        /// To override the contents of this collection use [`set_delivery_channel_names`](Self::set_delivery_channel_names).
        ///
        /// <p>A list of delivery channel names.</p>
        pub fn delivery_channel_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.delivery_channel_names.unwrap_or_default();
            v.push(input.into());
            self.delivery_channel_names = Some(v);
            self
        }
        /// <p>A list of delivery channel names.</p>
        pub fn set_delivery_channel_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.delivery_channel_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeliveryChannelsInput`](crate::input::DescribeDeliveryChannelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDeliveryChannelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDeliveryChannelsInput {
                delivery_channel_names: self.delivery_channel_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDeliveryChannelsInputOperationOutputAlias =
    crate::operation::DescribeDeliveryChannels;
#[doc(hidden)]
pub type DescribeDeliveryChannelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDeliveryChannelsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDeliveryChannels`](crate::operation::DescribeDeliveryChannels)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDeliveryChannels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDeliveryChannelsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDeliveryChannelsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeDeliveryChannels",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_delivery_channels(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDeliveryChannels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDeliveryChannels",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDeliveryChannelsInput`](crate::input::DescribeDeliveryChannelsInput)
    pub fn builder() -> crate::input::describe_delivery_channels_input::Builder {
        crate::input::describe_delivery_channels_input::Builder::default()
    }
}

/// See [`DescribeDeliveryChannelStatusInput`](crate::input::DescribeDeliveryChannelStatusInput)
pub mod describe_delivery_channel_status_input {
    /// A builder for [`DescribeDeliveryChannelStatusInput`](crate::input::DescribeDeliveryChannelStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_channel_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `delivery_channel_names`.
        ///
        /// To override the contents of this collection use [`set_delivery_channel_names`](Self::set_delivery_channel_names).
        ///
        /// <p>A list of delivery channel names.</p>
        pub fn delivery_channel_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.delivery_channel_names.unwrap_or_default();
            v.push(input.into());
            self.delivery_channel_names = Some(v);
            self
        }
        /// <p>A list of delivery channel names.</p>
        pub fn set_delivery_channel_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.delivery_channel_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeliveryChannelStatusInput`](crate::input::DescribeDeliveryChannelStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDeliveryChannelStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDeliveryChannelStatusInput {
                delivery_channel_names: self.delivery_channel_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDeliveryChannelStatusInputOperationOutputAlias =
    crate::operation::DescribeDeliveryChannelStatus;
#[doc(hidden)]
pub type DescribeDeliveryChannelStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDeliveryChannelStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDeliveryChannelStatus`](crate::operation::DescribeDeliveryChannelStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDeliveryChannelStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDeliveryChannelStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDeliveryChannelStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeDeliveryChannelStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_delivery_channel_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDeliveryChannelStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDeliveryChannelStatus",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDeliveryChannelStatusInput`](crate::input::DescribeDeliveryChannelStatusInput)
    pub fn builder() -> crate::input::describe_delivery_channel_status_input::Builder {
        crate::input::describe_delivery_channel_status_input::Builder::default()
    }
}

/// See [`DescribeOrganizationConfigRulesInput`](crate::input::DescribeOrganizationConfigRulesInput)
pub mod describe_organization_config_rules_input {
    /// A builder for [`DescribeOrganizationConfigRulesInput`](crate::input::DescribeOrganizationConfigRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_config_rule_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `organization_config_rule_names`.
        ///
        /// To override the contents of this collection use [`set_organization_config_rule_names`](Self::set_organization_config_rule_names).
        ///
        /// <p>The names of organization Config rules for which you want details. If you do not specify any names, Config returns details for all your organization Config rules.</p>
        pub fn organization_config_rule_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.organization_config_rule_names.unwrap_or_default();
            v.push(input.into());
            self.organization_config_rule_names = Some(v);
            self
        }
        /// <p>The names of organization Config rules for which you want details. If you do not specify any names, Config returns details for all your organization Config rules.</p>
        pub fn set_organization_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organization_config_rule_names = input;
            self
        }
        /// <p>The maximum number of organization Config rules returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of organization Config rules returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationConfigRulesInput`](crate::input::DescribeOrganizationConfigRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationConfigRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrganizationConfigRulesInput {
                organization_config_rule_names: self.organization_config_rule_names,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationConfigRulesInputOperationOutputAlias =
    crate::operation::DescribeOrganizationConfigRules;
#[doc(hidden)]
pub type DescribeOrganizationConfigRulesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOrganizationConfigRulesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganizationConfigRules`](crate::operation::DescribeOrganizationConfigRules)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganizationConfigRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOrganizationConfigRulesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOrganizationConfigRulesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeOrganizationConfigRules",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_organization_config_rules(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganizationConfigRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganizationConfigRules",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigRulesInput`](crate::input::DescribeOrganizationConfigRulesInput)
    pub fn builder() -> crate::input::describe_organization_config_rules_input::Builder {
        crate::input::describe_organization_config_rules_input::Builder::default()
    }
}

/// See [`DescribeOrganizationConfigRuleStatusesInput`](crate::input::DescribeOrganizationConfigRuleStatusesInput)
pub mod describe_organization_config_rule_statuses_input {
    /// A builder for [`DescribeOrganizationConfigRuleStatusesInput`](crate::input::DescribeOrganizationConfigRuleStatusesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_config_rule_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `organization_config_rule_names`.
        ///
        /// To override the contents of this collection use [`set_organization_config_rule_names`](Self::set_organization_config_rule_names).
        ///
        /// <p>The names of organization Config rules for which you want status details. If you do not specify any names, Config returns details for all your organization Config rules.</p>
        pub fn organization_config_rule_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.organization_config_rule_names.unwrap_or_default();
            v.push(input.into());
            self.organization_config_rule_names = Some(v);
            self
        }
        /// <p>The names of organization Config rules for which you want status details. If you do not specify any names, Config returns details for all your organization Config rules.</p>
        pub fn set_organization_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organization_config_rule_names = input;
            self
        }
        /// <p>The maximum number of <code>OrganizationConfigRuleStatuses</code> returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of <code>OrganizationConfigRuleStatuses</code> returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationConfigRuleStatusesInput`](crate::input::DescribeOrganizationConfigRuleStatusesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationConfigRuleStatusesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrganizationConfigRuleStatusesInput {
                organization_config_rule_names: self.organization_config_rule_names,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationConfigRuleStatusesInputOperationOutputAlias =
    crate::operation::DescribeOrganizationConfigRuleStatuses;
#[doc(hidden)]
pub type DescribeOrganizationConfigRuleStatusesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOrganizationConfigRuleStatusesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganizationConfigRuleStatuses`](crate::operation::DescribeOrganizationConfigRuleStatuses)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganizationConfigRuleStatuses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOrganizationConfigRuleStatusesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOrganizationConfigRuleStatusesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeOrganizationConfigRuleStatuses",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_organization_config_rule_statuses(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganizationConfigRuleStatuses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganizationConfigRuleStatuses",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigRuleStatusesInput`](crate::input::DescribeOrganizationConfigRuleStatusesInput)
    pub fn builder() -> crate::input::describe_organization_config_rule_statuses_input::Builder {
        crate::input::describe_organization_config_rule_statuses_input::Builder::default()
    }
}

/// See [`DescribeOrganizationConformancePacksInput`](crate::input::DescribeOrganizationConformancePacksInput)
pub mod describe_organization_conformance_packs_input {
    /// A builder for [`DescribeOrganizationConformancePacksInput`](crate::input::DescribeOrganizationConformancePacksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_conformance_pack_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `organization_conformance_pack_names`.
        ///
        /// To override the contents of this collection use [`set_organization_conformance_pack_names`](Self::set_organization_conformance_pack_names).
        ///
        /// <p>The name that you assign to an organization conformance pack.</p>
        pub fn organization_conformance_pack_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.organization_conformance_pack_names.unwrap_or_default();
            v.push(input.into());
            self.organization_conformance_pack_names = Some(v);
            self
        }
        /// <p>The name that you assign to an organization conformance pack.</p>
        pub fn set_organization_conformance_pack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organization_conformance_pack_names = input;
            self
        }
        /// <p>The maximum number of organization config packs returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of organization config packs returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationConformancePacksInput`](crate::input::DescribeOrganizationConformancePacksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationConformancePacksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrganizationConformancePacksInput {
                organization_conformance_pack_names: self.organization_conformance_pack_names,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationConformancePacksInputOperationOutputAlias =
    crate::operation::DescribeOrganizationConformancePacks;
#[doc(hidden)]
pub type DescribeOrganizationConformancePacksInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOrganizationConformancePacksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganizationConformancePacks`](crate::operation::DescribeOrganizationConformancePacks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganizationConformancePacks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOrganizationConformancePacksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOrganizationConformancePacksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeOrganizationConformancePacks",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_organization_conformance_packs(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganizationConformancePacks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganizationConformancePacks",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConformancePacksInput`](crate::input::DescribeOrganizationConformancePacksInput)
    pub fn builder() -> crate::input::describe_organization_conformance_packs_input::Builder {
        crate::input::describe_organization_conformance_packs_input::Builder::default()
    }
}

/// See [`DescribeOrganizationConformancePackStatusesInput`](crate::input::DescribeOrganizationConformancePackStatusesInput)
pub mod describe_organization_conformance_pack_statuses_input {
    /// A builder for [`DescribeOrganizationConformancePackStatusesInput`](crate::input::DescribeOrganizationConformancePackStatusesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_conformance_pack_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `organization_conformance_pack_names`.
        ///
        /// To override the contents of this collection use [`set_organization_conformance_pack_names`](Self::set_organization_conformance_pack_names).
        ///
        /// <p>The names of organization conformance packs for which you want status details. If you do not specify any names, Config returns details for all your organization conformance packs. </p>
        pub fn organization_conformance_pack_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.organization_conformance_pack_names.unwrap_or_default();
            v.push(input.into());
            self.organization_conformance_pack_names = Some(v);
            self
        }
        /// <p>The names of organization conformance packs for which you want status details. If you do not specify any names, Config returns details for all your organization conformance packs. </p>
        pub fn set_organization_conformance_pack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organization_conformance_pack_names = input;
            self
        }
        /// <p>The maximum number of OrganizationConformancePackStatuses returned on each page. If you do no specify a number, Config uses the default. The default is 100. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of OrganizationConformancePackStatuses returned on each page. If you do no specify a number, Config uses the default. The default is 100. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationConformancePackStatusesInput`](crate::input::DescribeOrganizationConformancePackStatusesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationConformancePackStatusesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeOrganizationConformancePackStatusesInput {
                    organization_conformance_pack_names: self.organization_conformance_pack_names,
                    limit: self.limit.unwrap_or_default(),
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationConformancePackStatusesInputOperationOutputAlias =
    crate::operation::DescribeOrganizationConformancePackStatuses;
#[doc(hidden)]
pub type DescribeOrganizationConformancePackStatusesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOrganizationConformancePackStatusesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganizationConformancePackStatuses`](crate::operation::DescribeOrganizationConformancePackStatuses)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganizationConformancePackStatuses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOrganizationConformancePackStatusesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOrganizationConformancePackStatusesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeOrganizationConformancePackStatuses",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_organization_conformance_pack_statuses(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganizationConformancePackStatuses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganizationConformancePackStatuses",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConformancePackStatusesInput`](crate::input::DescribeOrganizationConformancePackStatusesInput)
    pub fn builder() -> crate::input::describe_organization_conformance_pack_statuses_input::Builder
    {
        crate::input::describe_organization_conformance_pack_statuses_input::Builder::default()
    }
}

/// See [`DescribePendingAggregationRequestsInput`](crate::input::DescribePendingAggregationRequestsInput)
pub mod describe_pending_aggregation_requests_input {
    /// A builder for [`DescribePendingAggregationRequestsInput`](crate::input::DescribePendingAggregationRequestsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePendingAggregationRequestsInput`](crate::input::DescribePendingAggregationRequestsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePendingAggregationRequestsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePendingAggregationRequestsInput {
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePendingAggregationRequestsInputOperationOutputAlias =
    crate::operation::DescribePendingAggregationRequests;
#[doc(hidden)]
pub type DescribePendingAggregationRequestsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribePendingAggregationRequestsInput {
    /// Consumes the builder and constructs an Operation<[`DescribePendingAggregationRequests`](crate::operation::DescribePendingAggregationRequests)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePendingAggregationRequests,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePendingAggregationRequestsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePendingAggregationRequestsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribePendingAggregationRequests",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_pending_aggregation_requests(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePendingAggregationRequests::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePendingAggregationRequests",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePendingAggregationRequestsInput`](crate::input::DescribePendingAggregationRequestsInput)
    pub fn builder() -> crate::input::describe_pending_aggregation_requests_input::Builder {
        crate::input::describe_pending_aggregation_requests_input::Builder::default()
    }
}

/// See [`DescribeRemediationConfigurationsInput`](crate::input::DescribeRemediationConfigurationsInput)
pub mod describe_remediation_configurations_input {
    /// A builder for [`DescribeRemediationConfigurationsInput`](crate::input::DescribeRemediationConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `config_rule_names`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>A list of Config rule names of remediation configurations for which you want details. </p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.config_rule_names.unwrap_or_default();
            v.push(input.into());
            self.config_rule_names = Some(v);
            self
        }
        /// <p>A list of Config rule names of remediation configurations for which you want details. </p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.config_rule_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRemediationConfigurationsInput`](crate::input::DescribeRemediationConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRemediationConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRemediationConfigurationsInput {
                config_rule_names: self.config_rule_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRemediationConfigurationsInputOperationOutputAlias =
    crate::operation::DescribeRemediationConfigurations;
#[doc(hidden)]
pub type DescribeRemediationConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRemediationConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRemediationConfigurations`](crate::operation::DescribeRemediationConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRemediationConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeRemediationConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeRemediationConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeRemediationConfigurations",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_remediation_configurations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRemediationConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRemediationConfigurations",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeRemediationConfigurationsInput`](crate::input::DescribeRemediationConfigurationsInput)
    pub fn builder() -> crate::input::describe_remediation_configurations_input::Builder {
        crate::input::describe_remediation_configurations_input::Builder::default()
    }
}

/// See [`DescribeRemediationExceptionsInput`](crate::input::DescribeRemediationExceptionsInput)
pub mod describe_remediation_exceptions_input {
    /// A builder for [`DescribeRemediationExceptionsInput`](crate::input::DescribeRemediationExceptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) resource_keys:
            std::option::Option<std::vec::Vec<crate::model::RemediationExceptionResourceKey>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Config rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// Appends an item to `resource_keys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn resource_keys(
            mut self,
            input: crate::model::RemediationExceptionResourceKey,
        ) -> Self {
            let mut v = self.resource_keys.unwrap_or_default();
            v.push(input);
            self.resource_keys = Some(v);
            self
        }
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RemediationExceptionResourceKey>,
            >,
        ) -> Self {
            self.resource_keys = input;
            self
        }
        /// <p>The maximum number of RemediationExceptionResourceKey returned on each page. The default is 25. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of RemediationExceptionResourceKey returned on each page. The default is 25. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRemediationExceptionsInput`](crate::input::DescribeRemediationExceptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRemediationExceptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRemediationExceptionsInput {
                config_rule_name: self.config_rule_name,
                resource_keys: self.resource_keys,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRemediationExceptionsInputOperationOutputAlias =
    crate::operation::DescribeRemediationExceptions;
#[doc(hidden)]
pub type DescribeRemediationExceptionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRemediationExceptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRemediationExceptions`](crate::operation::DescribeRemediationExceptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRemediationExceptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeRemediationExceptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeRemediationExceptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeRemediationExceptions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_remediation_exceptions(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRemediationExceptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRemediationExceptions",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeRemediationExceptionsInput`](crate::input::DescribeRemediationExceptionsInput)
    pub fn builder() -> crate::input::describe_remediation_exceptions_input::Builder {
        crate::input::describe_remediation_exceptions_input::Builder::default()
    }
}

/// See [`DescribeRemediationExecutionStatusInput`](crate::input::DescribeRemediationExecutionStatusInput)
pub mod describe_remediation_execution_status_input {
    /// A builder for [`DescribeRemediationExecutionStatusInput`](crate::input::DescribeRemediationExecutionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) resource_keys: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A list of Config rule names.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>A list of Config rule names.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// Appends an item to `resource_keys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
        pub fn resource_keys(mut self, input: crate::model::ResourceKey) -> Self {
            let mut v = self.resource_keys.unwrap_or_default();
            v.push(input);
            self.resource_keys = Some(v);
            self
        }
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
        ) -> Self {
            self.resource_keys = input;
            self
        }
        /// <p>The maximum number of RemediationExecutionStatuses returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of RemediationExecutionStatuses returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRemediationExecutionStatusInput`](crate::input::DescribeRemediationExecutionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRemediationExecutionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRemediationExecutionStatusInput {
                config_rule_name: self.config_rule_name,
                resource_keys: self.resource_keys,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRemediationExecutionStatusInputOperationOutputAlias =
    crate::operation::DescribeRemediationExecutionStatus;
#[doc(hidden)]
pub type DescribeRemediationExecutionStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRemediationExecutionStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRemediationExecutionStatus`](crate::operation::DescribeRemediationExecutionStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRemediationExecutionStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeRemediationExecutionStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeRemediationExecutionStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeRemediationExecutionStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_remediation_execution_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRemediationExecutionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRemediationExecutionStatus",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeRemediationExecutionStatusInput`](crate::input::DescribeRemediationExecutionStatusInput)
    pub fn builder() -> crate::input::describe_remediation_execution_status_input::Builder {
        crate::input::describe_remediation_execution_status_input::Builder::default()
    }
}

/// See [`DescribeRetentionConfigurationsInput`](crate::input::DescribeRetentionConfigurationsInput)
pub mod describe_retention_configurations_input {
    /// A builder for [`DescribeRetentionConfigurationsInput`](crate::input::DescribeRetentionConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retention_configuration_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `retention_configuration_names`.
        ///
        /// To override the contents of this collection use [`set_retention_configuration_names`](Self::set_retention_configuration_names).
        ///
        /// <p>A list of names of retention configurations for which you want details. If you do not specify a name, Config returns details for all the retention configurations for that account.</p> <note>
        /// <p>Currently, Config supports only one retention configuration per region in your account.</p>
        /// </note>
        pub fn retention_configuration_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.retention_configuration_names.unwrap_or_default();
            v.push(input.into());
            self.retention_configuration_names = Some(v);
            self
        }
        /// <p>A list of names of retention configurations for which you want details. If you do not specify a name, Config returns details for all the retention configurations for that account.</p> <note>
        /// <p>Currently, Config supports only one retention configuration per region in your account.</p>
        /// </note>
        pub fn set_retention_configuration_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.retention_configuration_names = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRetentionConfigurationsInput`](crate::input::DescribeRetentionConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRetentionConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRetentionConfigurationsInput {
                retention_configuration_names: self.retention_configuration_names,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRetentionConfigurationsInputOperationOutputAlias =
    crate::operation::DescribeRetentionConfigurations;
#[doc(hidden)]
pub type DescribeRetentionConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRetentionConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRetentionConfigurations`](crate::operation::DescribeRetentionConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRetentionConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeRetentionConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeRetentionConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.DescribeRetentionConfigurations",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_retention_configurations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRetentionConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRetentionConfigurations",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeRetentionConfigurationsInput`](crate::input::DescribeRetentionConfigurationsInput)
    pub fn builder() -> crate::input::describe_retention_configurations_input::Builder {
        crate::input::describe_retention_configurations_input::Builder::default()
    }
}

/// See [`GetAggregateComplianceDetailsByConfigRuleInput`](crate::input::GetAggregateComplianceDetailsByConfigRuleInput)
pub mod get_aggregate_compliance_details_by_config_rule_input {
    /// A builder for [`GetAggregateComplianceDetailsByConfigRuleInput`](crate::input::GetAggregateComplianceDetailsByConfigRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) compliance_type: std::option::Option<crate::model::ComplianceType>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// <p>The name of the Config rule for which you want compliance information.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want compliance information.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the source account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The source region from where the data is aggregated.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The source region from where the data is aggregated.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>The resource compliance status.</p> <note>
        /// <p>For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, Config supports only the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.</p>
        /// </note>
        pub fn compliance_type(mut self, input: crate::model::ComplianceType) -> Self {
            self.compliance_type = Some(input);
            self
        }
        /// <p>The resource compliance status.</p> <note>
        /// <p>For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, Config supports only the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.</p>
        /// </note>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceType>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 50. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 50. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAggregateComplianceDetailsByConfigRuleInput`](crate::input::GetAggregateComplianceDetailsByConfigRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAggregateComplianceDetailsByConfigRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetAggregateComplianceDetailsByConfigRuleInput {
                    configuration_aggregator_name: self.configuration_aggregator_name,
                    config_rule_name: self.config_rule_name,
                    account_id: self.account_id,
                    aws_region: self.aws_region,
                    compliance_type: self.compliance_type,
                    limit: self.limit.unwrap_or_default(),
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetAggregateComplianceDetailsByConfigRuleInputOperationOutputAlias =
    crate::operation::GetAggregateComplianceDetailsByConfigRule;
#[doc(hidden)]
pub type GetAggregateComplianceDetailsByConfigRuleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAggregateComplianceDetailsByConfigRuleInput {
    /// Consumes the builder and constructs an Operation<[`GetAggregateComplianceDetailsByConfigRule`](crate::operation::GetAggregateComplianceDetailsByConfigRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAggregateComplianceDetailsByConfigRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAggregateComplianceDetailsByConfigRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAggregateComplianceDetailsByConfigRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetAggregateComplianceDetailsByConfigRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_aggregate_compliance_details_by_config_rule(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAggregateComplianceDetailsByConfigRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAggregateComplianceDetailsByConfigRule",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAggregateComplianceDetailsByConfigRuleInput`](crate::input::GetAggregateComplianceDetailsByConfigRuleInput)
    pub fn builder() -> crate::input::get_aggregate_compliance_details_by_config_rule_input::Builder
    {
        crate::input::get_aggregate_compliance_details_by_config_rule_input::Builder::default()
    }
}

/// See [`GetAggregateConfigRuleComplianceSummaryInput`](crate::input::GetAggregateConfigRuleComplianceSummaryInput)
pub mod get_aggregate_config_rule_compliance_summary_input {
    /// A builder for [`GetAggregateConfigRuleComplianceSummaryInput`](crate::input::GetAggregateConfigRuleComplianceSummaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::ConfigRuleComplianceSummaryFilters>,
        pub(crate) group_by_key:
            std::option::Option<crate::model::ConfigRuleComplianceSummaryGroupKey>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// <p>Filters the results based on the ConfigRuleComplianceSummaryFilters object.</p>
        pub fn filters(mut self, input: crate::model::ConfigRuleComplianceSummaryFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>Filters the results based on the ConfigRuleComplianceSummaryFilters object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ConfigRuleComplianceSummaryFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Groups the result based on ACCOUNT_ID or AWS_REGION.</p>
        pub fn group_by_key(
            mut self,
            input: crate::model::ConfigRuleComplianceSummaryGroupKey,
        ) -> Self {
            self.group_by_key = Some(input);
            self
        }
        /// <p>Groups the result based on ACCOUNT_ID or AWS_REGION.</p>
        pub fn set_group_by_key(
            mut self,
            input: std::option::Option<crate::model::ConfigRuleComplianceSummaryGroupKey>,
        ) -> Self {
            self.group_by_key = input;
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAggregateConfigRuleComplianceSummaryInput`](crate::input::GetAggregateConfigRuleComplianceSummaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAggregateConfigRuleComplianceSummaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAggregateConfigRuleComplianceSummaryInput {
                configuration_aggregator_name: self.configuration_aggregator_name,
                filters: self.filters,
                group_by_key: self.group_by_key,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAggregateConfigRuleComplianceSummaryInputOperationOutputAlias =
    crate::operation::GetAggregateConfigRuleComplianceSummary;
#[doc(hidden)]
pub type GetAggregateConfigRuleComplianceSummaryInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAggregateConfigRuleComplianceSummaryInput {
    /// Consumes the builder and constructs an Operation<[`GetAggregateConfigRuleComplianceSummary`](crate::operation::GetAggregateConfigRuleComplianceSummary)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAggregateConfigRuleComplianceSummary,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAggregateConfigRuleComplianceSummaryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAggregateConfigRuleComplianceSummaryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetAggregateConfigRuleComplianceSummary",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_aggregate_config_rule_compliance_summary(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAggregateConfigRuleComplianceSummary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAggregateConfigRuleComplianceSummary",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAggregateConfigRuleComplianceSummaryInput`](crate::input::GetAggregateConfigRuleComplianceSummaryInput)
    pub fn builder() -> crate::input::get_aggregate_config_rule_compliance_summary_input::Builder {
        crate::input::get_aggregate_config_rule_compliance_summary_input::Builder::default()
    }
}

/// See [`GetAggregateConformancePackComplianceSummaryInput`](crate::input::GetAggregateConformancePackComplianceSummaryInput)
pub mod get_aggregate_conformance_pack_compliance_summary_input {
    /// A builder for [`GetAggregateConformancePackComplianceSummaryInput`](crate::input::GetAggregateConformancePackComplianceSummaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<crate::model::AggregateConformancePackComplianceSummaryFilters>,
        pub(crate) group_by_key:
            std::option::Option<crate::model::AggregateConformancePackComplianceSummaryGroupKey>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// <p>Filters the results based on the <code>AggregateConformancePackComplianceSummaryFilters</code> object.</p>
        pub fn filters(
            mut self,
            input: crate::model::AggregateConformancePackComplianceSummaryFilters,
        ) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>Filters the results based on the <code>AggregateConformancePackComplianceSummaryFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                crate::model::AggregateConformancePackComplianceSummaryFilters,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>
        pub fn group_by_key(
            mut self,
            input: crate::model::AggregateConformancePackComplianceSummaryGroupKey,
        ) -> Self {
            self.group_by_key = Some(input);
            self
        }
        /// <p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>
        pub fn set_group_by_key(
            mut self,
            input: std::option::Option<
                crate::model::AggregateConformancePackComplianceSummaryGroupKey,
            >,
        ) -> Self {
            self.group_by_key = input;
            self
        }
        /// <p>The maximum number of results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAggregateConformancePackComplianceSummaryInput`](crate::input::GetAggregateConformancePackComplianceSummaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAggregateConformancePackComplianceSummaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetAggregateConformancePackComplianceSummaryInput {
                    configuration_aggregator_name: self.configuration_aggregator_name,
                    filters: self.filters,
                    group_by_key: self.group_by_key,
                    limit: self.limit.unwrap_or_default(),
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetAggregateConformancePackComplianceSummaryInputOperationOutputAlias =
    crate::operation::GetAggregateConformancePackComplianceSummary;
#[doc(hidden)]
pub type GetAggregateConformancePackComplianceSummaryInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAggregateConformancePackComplianceSummaryInput {
    /// Consumes the builder and constructs an Operation<[`GetAggregateConformancePackComplianceSummary`](crate::operation::GetAggregateConformancePackComplianceSummary)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAggregateConformancePackComplianceSummary,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAggregateConformancePackComplianceSummaryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAggregateConformancePackComplianceSummaryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetAggregateConformancePackComplianceSummary",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_aggregate_conformance_pack_compliance_summary(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAggregateConformancePackComplianceSummary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAggregateConformancePackComplianceSummary",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAggregateConformancePackComplianceSummaryInput`](crate::input::GetAggregateConformancePackComplianceSummaryInput)
    pub fn builder(
    ) -> crate::input::get_aggregate_conformance_pack_compliance_summary_input::Builder {
        crate::input::get_aggregate_conformance_pack_compliance_summary_input::Builder::default()
    }
}

/// See [`GetAggregateDiscoveredResourceCountsInput`](crate::input::GetAggregateDiscoveredResourceCountsInput)
pub mod get_aggregate_discovered_resource_counts_input {
    /// A builder for [`GetAggregateDiscoveredResourceCountsInput`](crate::input::GetAggregateDiscoveredResourceCountsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::ResourceCountFilters>,
        pub(crate) group_by_key: std::option::Option<crate::model::ResourceCountGroupKey>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// <p>Filters the results based on the <code>ResourceCountFilters</code> object.</p>
        pub fn filters(mut self, input: crate::model::ResourceCountFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>Filters the results based on the <code>ResourceCountFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ResourceCountFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The key to group the resource counts.</p>
        pub fn group_by_key(mut self, input: crate::model::ResourceCountGroupKey) -> Self {
            self.group_by_key = Some(input);
            self
        }
        /// <p>The key to group the resource counts.</p>
        pub fn set_group_by_key(
            mut self,
            input: std::option::Option<crate::model::ResourceCountGroupKey>,
        ) -> Self {
            self.group_by_key = input;
            self
        }
        /// <p>The maximum number of <code>GroupedResourceCount</code> objects returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of <code>GroupedResourceCount</code> objects returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAggregateDiscoveredResourceCountsInput`](crate::input::GetAggregateDiscoveredResourceCountsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAggregateDiscoveredResourceCountsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAggregateDiscoveredResourceCountsInput {
                configuration_aggregator_name: self.configuration_aggregator_name,
                filters: self.filters,
                group_by_key: self.group_by_key,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAggregateDiscoveredResourceCountsInputOperationOutputAlias =
    crate::operation::GetAggregateDiscoveredResourceCounts;
#[doc(hidden)]
pub type GetAggregateDiscoveredResourceCountsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAggregateDiscoveredResourceCountsInput {
    /// Consumes the builder and constructs an Operation<[`GetAggregateDiscoveredResourceCounts`](crate::operation::GetAggregateDiscoveredResourceCounts)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAggregateDiscoveredResourceCounts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAggregateDiscoveredResourceCountsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAggregateDiscoveredResourceCountsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetAggregateDiscoveredResourceCounts",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_aggregate_discovered_resource_counts(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAggregateDiscoveredResourceCounts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAggregateDiscoveredResourceCounts",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAggregateDiscoveredResourceCountsInput`](crate::input::GetAggregateDiscoveredResourceCountsInput)
    pub fn builder() -> crate::input::get_aggregate_discovered_resource_counts_input::Builder {
        crate::input::get_aggregate_discovered_resource_counts_input::Builder::default()
    }
}

/// See [`GetAggregateResourceConfigInput`](crate::input::GetAggregateResourceConfigInput)
pub mod get_aggregate_resource_config_input {
    /// A builder for [`GetAggregateResourceConfigInput`](crate::input::GetAggregateResourceConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) resource_identifier:
            std::option::Option<crate::model::AggregateResourceIdentifier>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// <p>An object that identifies aggregate resource.</p>
        pub fn resource_identifier(
            mut self,
            input: crate::model::AggregateResourceIdentifier,
        ) -> Self {
            self.resource_identifier = Some(input);
            self
        }
        /// <p>An object that identifies aggregate resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::AggregateResourceIdentifier>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAggregateResourceConfigInput`](crate::input::GetAggregateResourceConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAggregateResourceConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAggregateResourceConfigInput {
                configuration_aggregator_name: self.configuration_aggregator_name,
                resource_identifier: self.resource_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAggregateResourceConfigInputOperationOutputAlias =
    crate::operation::GetAggregateResourceConfig;
#[doc(hidden)]
pub type GetAggregateResourceConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAggregateResourceConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetAggregateResourceConfig`](crate::operation::GetAggregateResourceConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAggregateResourceConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAggregateResourceConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAggregateResourceConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetAggregateResourceConfig",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_aggregate_resource_config(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAggregateResourceConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAggregateResourceConfig",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAggregateResourceConfigInput`](crate::input::GetAggregateResourceConfigInput)
    pub fn builder() -> crate::input::get_aggregate_resource_config_input::Builder {
        crate::input::get_aggregate_resource_config_input::Builder::default()
    }
}

/// See [`GetComplianceDetailsByConfigRuleInput`](crate::input::GetComplianceDetailsByConfigRuleInput)
pub mod get_compliance_details_by_config_rule_input {
    /// A builder for [`GetComplianceDetailsByConfigRuleInput`](crate::input::GetComplianceDetailsByConfigRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) compliance_types:
            std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Config rule for which you want compliance information.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want compliance information.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// Appends an item to `compliance_types`.
        ///
        /// To override the contents of this collection use [`set_compliance_types`](Self::set_compliance_types).
        ///
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
        pub fn compliance_types(mut self, input: crate::model::ComplianceType) -> Self {
            let mut v = self.compliance_types.unwrap_or_default();
            v.push(input);
            self.compliance_types = Some(v);
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
        pub fn set_compliance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        ) -> Self {
            self.compliance_types = input;
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComplianceDetailsByConfigRuleInput`](crate::input::GetComplianceDetailsByConfigRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetComplianceDetailsByConfigRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetComplianceDetailsByConfigRuleInput {
                config_rule_name: self.config_rule_name,
                compliance_types: self.compliance_types,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetComplianceDetailsByConfigRuleInputOperationOutputAlias =
    crate::operation::GetComplianceDetailsByConfigRule;
#[doc(hidden)]
pub type GetComplianceDetailsByConfigRuleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetComplianceDetailsByConfigRuleInput {
    /// Consumes the builder and constructs an Operation<[`GetComplianceDetailsByConfigRule`](crate::operation::GetComplianceDetailsByConfigRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetComplianceDetailsByConfigRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetComplianceDetailsByConfigRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetComplianceDetailsByConfigRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetComplianceDetailsByConfigRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_compliance_details_by_config_rule(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetComplianceDetailsByConfigRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetComplianceDetailsByConfigRule",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetComplianceDetailsByConfigRuleInput`](crate::input::GetComplianceDetailsByConfigRuleInput)
    pub fn builder() -> crate::input::get_compliance_details_by_config_rule_input::Builder {
        crate::input::get_compliance_details_by_config_rule_input::Builder::default()
    }
}

/// See [`GetComplianceDetailsByResourceInput`](crate::input::GetComplianceDetailsByResourceInput)
pub mod get_compliance_details_by_resource_input {
    /// A builder for [`GetComplianceDetailsByResourceInput`](crate::input::GetComplianceDetailsByResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) compliance_types:
            std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the Amazon Web Services resource for which you want compliance information.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the Amazon Web Services resource for which you want compliance information.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the Amazon Web Services resource for which you want compliance information.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services resource for which you want compliance information.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `compliance_types`.
        ///
        /// To override the contents of this collection use [`set_compliance_types`](Self::set_compliance_types).
        ///
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
        pub fn compliance_types(mut self, input: crate::model::ComplianceType) -> Self {
            let mut v = self.compliance_types.unwrap_or_default();
            v.push(input);
            self.compliance_types = Some(v);
            self
        }
        /// <p>Filters the results by compliance.</p>
        /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
        pub fn set_compliance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
        ) -> Self {
            self.compliance_types = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComplianceDetailsByResourceInput`](crate::input::GetComplianceDetailsByResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetComplianceDetailsByResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetComplianceDetailsByResourceInput {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                compliance_types: self.compliance_types,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetComplianceDetailsByResourceInputOperationOutputAlias =
    crate::operation::GetComplianceDetailsByResource;
#[doc(hidden)]
pub type GetComplianceDetailsByResourceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetComplianceDetailsByResourceInput {
    /// Consumes the builder and constructs an Operation<[`GetComplianceDetailsByResource`](crate::operation::GetComplianceDetailsByResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetComplianceDetailsByResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetComplianceDetailsByResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetComplianceDetailsByResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetComplianceDetailsByResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_compliance_details_by_resource(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetComplianceDetailsByResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetComplianceDetailsByResource",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetComplianceDetailsByResourceInput`](crate::input::GetComplianceDetailsByResourceInput)
    pub fn builder() -> crate::input::get_compliance_details_by_resource_input::Builder {
        crate::input::get_compliance_details_by_resource_input::Builder::default()
    }
}

/// See [`GetComplianceSummaryByConfigRuleInput`](crate::input::GetComplianceSummaryByConfigRuleInput)
pub mod get_compliance_summary_by_config_rule_input {
    /// A builder for [`GetComplianceSummaryByConfigRuleInput`](crate::input::GetComplianceSummaryByConfigRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetComplianceSummaryByConfigRuleInput`](crate::input::GetComplianceSummaryByConfigRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetComplianceSummaryByConfigRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetComplianceSummaryByConfigRuleInput {})
        }
    }
}
#[doc(hidden)]
pub type GetComplianceSummaryByConfigRuleInputOperationOutputAlias =
    crate::operation::GetComplianceSummaryByConfigRule;
#[doc(hidden)]
pub type GetComplianceSummaryByConfigRuleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetComplianceSummaryByConfigRuleInput {
    /// Consumes the builder and constructs an Operation<[`GetComplianceSummaryByConfigRule`](crate::operation::GetComplianceSummaryByConfigRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetComplianceSummaryByConfigRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetComplianceSummaryByConfigRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetComplianceSummaryByConfigRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetComplianceSummaryByConfigRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_compliance_summary_by_config_rule(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetComplianceSummaryByConfigRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetComplianceSummaryByConfigRule",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetComplianceSummaryByConfigRuleInput`](crate::input::GetComplianceSummaryByConfigRuleInput)
    pub fn builder() -> crate::input::get_compliance_summary_by_config_rule_input::Builder {
        crate::input::get_compliance_summary_by_config_rule_input::Builder::default()
    }
}

/// See [`GetComplianceSummaryByResourceTypeInput`](crate::input::GetComplianceSummaryByResourceTypeInput)
pub mod get_compliance_summary_by_resource_type_input {
    /// A builder for [`GetComplianceSummaryByResourceTypeInput`](crate::input::GetComplianceSummaryByResourceTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `resource_types`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>Specify one or more resource types to get the number of resources that are compliant and the number that are noncompliant for each resource type.</p>
        /// <p>For this request, you can specify an Amazon Web Services resource type such as <code>AWS::EC2::Instance</code>. You can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_types.unwrap_or_default();
            v.push(input.into());
            self.resource_types = Some(v);
            self
        }
        /// <p>Specify one or more resource types to get the number of resources that are compliant and the number that are noncompliant for each resource type.</p>
        /// <p>For this request, you can specify an Amazon Web Services resource type such as <code>AWS::EC2::Instance</code>. You can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_types = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComplianceSummaryByResourceTypeInput`](crate::input::GetComplianceSummaryByResourceTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetComplianceSummaryByResourceTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetComplianceSummaryByResourceTypeInput {
                resource_types: self.resource_types,
            })
        }
    }
}
#[doc(hidden)]
pub type GetComplianceSummaryByResourceTypeInputOperationOutputAlias =
    crate::operation::GetComplianceSummaryByResourceType;
#[doc(hidden)]
pub type GetComplianceSummaryByResourceTypeInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetComplianceSummaryByResourceTypeInput {
    /// Consumes the builder and constructs an Operation<[`GetComplianceSummaryByResourceType`](crate::operation::GetComplianceSummaryByResourceType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetComplianceSummaryByResourceType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetComplianceSummaryByResourceTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetComplianceSummaryByResourceTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetComplianceSummaryByResourceType",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_compliance_summary_by_resource_type(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetComplianceSummaryByResourceType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetComplianceSummaryByResourceType",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetComplianceSummaryByResourceTypeInput`](crate::input::GetComplianceSummaryByResourceTypeInput)
    pub fn builder() -> crate::input::get_compliance_summary_by_resource_type_input::Builder {
        crate::input::get_compliance_summary_by_resource_type_input::Builder::default()
    }
}

/// See [`GetConformancePackComplianceDetailsInput`](crate::input::GetConformancePackComplianceDetailsInput)
pub mod get_conformance_pack_compliance_details_input {
    /// A builder for [`GetConformancePackComplianceDetailsInput`](crate::input::GetConformancePackComplianceDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::ConformancePackEvaluationFilters>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the conformance pack.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_name = Some(input.into());
            self
        }
        /// <p>Name of the conformance pack.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_name = input;
            self
        }
        /// <p>A <code>ConformancePackEvaluationFilters</code> object.</p>
        pub fn filters(mut self, input: crate::model::ConformancePackEvaluationFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A <code>ConformancePackEvaluationFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ConformancePackEvaluationFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of evaluation results returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConformancePackComplianceDetailsInput`](crate::input::GetConformancePackComplianceDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConformancePackComplianceDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConformancePackComplianceDetailsInput {
                conformance_pack_name: self.conformance_pack_name,
                filters: self.filters,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConformancePackComplianceDetailsInputOperationOutputAlias =
    crate::operation::GetConformancePackComplianceDetails;
#[doc(hidden)]
pub type GetConformancePackComplianceDetailsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetConformancePackComplianceDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GetConformancePackComplianceDetails`](crate::operation::GetConformancePackComplianceDetails)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConformancePackComplianceDetails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetConformancePackComplianceDetailsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetConformancePackComplianceDetailsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetConformancePackComplianceDetails",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_conformance_pack_compliance_details(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConformancePackComplianceDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConformancePackComplianceDetails",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetConformancePackComplianceDetailsInput`](crate::input::GetConformancePackComplianceDetailsInput)
    pub fn builder() -> crate::input::get_conformance_pack_compliance_details_input::Builder {
        crate::input::get_conformance_pack_compliance_details_input::Builder::default()
    }
}

/// See [`GetConformancePackComplianceSummaryInput`](crate::input::GetConformancePackComplianceSummaryInput)
pub mod get_conformance_pack_compliance_summary_input {
    /// A builder for [`GetConformancePackComplianceSummaryInput`](crate::input::GetConformancePackComplianceSummaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `conformance_pack_names`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_names`](Self::set_conformance_pack_names).
        ///
        /// <p>Names of conformance packs.</p>
        pub fn conformance_pack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.conformance_pack_names.unwrap_or_default();
            v.push(input.into());
            self.conformance_pack_names = Some(v);
            self
        }
        /// <p>Names of conformance packs.</p>
        pub fn set_conformance_pack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.conformance_pack_names = input;
            self
        }
        /// <p>The maximum number of conformance packs returned on each page.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of conformance packs returned on each page.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConformancePackComplianceSummaryInput`](crate::input::GetConformancePackComplianceSummaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConformancePackComplianceSummaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConformancePackComplianceSummaryInput {
                conformance_pack_names: self.conformance_pack_names,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConformancePackComplianceSummaryInputOperationOutputAlias =
    crate::operation::GetConformancePackComplianceSummary;
#[doc(hidden)]
pub type GetConformancePackComplianceSummaryInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetConformancePackComplianceSummaryInput {
    /// Consumes the builder and constructs an Operation<[`GetConformancePackComplianceSummary`](crate::operation::GetConformancePackComplianceSummary)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConformancePackComplianceSummary,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetConformancePackComplianceSummaryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetConformancePackComplianceSummaryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetConformancePackComplianceSummary",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_conformance_pack_compliance_summary(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConformancePackComplianceSummary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConformancePackComplianceSummary",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetConformancePackComplianceSummaryInput`](crate::input::GetConformancePackComplianceSummaryInput)
    pub fn builder() -> crate::input::get_conformance_pack_compliance_summary_input::Builder {
        crate::input::get_conformance_pack_compliance_summary_input::Builder::default()
    }
}

/// See [`GetCustomRulePolicyInput`](crate::input::GetCustomRulePolicyInput)
pub mod get_custom_rule_policy_input {
    /// A builder for [`GetCustomRulePolicyInput`](crate::input::GetCustomRulePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of your Config Custom Policy rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of your Config Custom Policy rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCustomRulePolicyInput`](crate::input::GetCustomRulePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCustomRulePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCustomRulePolicyInput {
                config_rule_name: self.config_rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCustomRulePolicyInputOperationOutputAlias = crate::operation::GetCustomRulePolicy;
#[doc(hidden)]
pub type GetCustomRulePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCustomRulePolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetCustomRulePolicy`](crate::operation::GetCustomRulePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCustomRulePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCustomRulePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCustomRulePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetCustomRulePolicy",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_custom_rule_policy(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCustomRulePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCustomRulePolicy",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCustomRulePolicyInput`](crate::input::GetCustomRulePolicyInput)
    pub fn builder() -> crate::input::get_custom_rule_policy_input::Builder {
        crate::input::get_custom_rule_policy_input::Builder::default()
    }
}

/// See [`GetDiscoveredResourceCountsInput`](crate::input::GetDiscoveredResourceCountsInput)
pub mod get_discovered_resource_counts_input {
    /// A builder for [`GetDiscoveredResourceCountsInput`](crate::input::GetDiscoveredResourceCountsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_types`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The comma-separated list that specifies the resource types that you want Config to return (for example, <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).</p>
        /// <p>If a value for <code>resourceTypes</code> is not specified, Config returns all resource types that Config is recording in the region for your account.</p> <note>
        /// <p>If the configuration recorder is turned off, Config returns an empty list of <code>ResourceCount</code> objects. If the configuration recorder is not recording a specific resource type (for example, S3 buckets), that resource type is not returned in the list of <code>ResourceCount</code> objects.</p>
        /// </note>
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_types.unwrap_or_default();
            v.push(input.into());
            self.resource_types = Some(v);
            self
        }
        /// <p>The comma-separated list that specifies the resource types that you want Config to return (for example, <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).</p>
        /// <p>If a value for <code>resourceTypes</code> is not specified, Config returns all resource types that Config is recording in the region for your account.</p> <note>
        /// <p>If the configuration recorder is turned off, Config returns an empty list of <code>ResourceCount</code> objects. If the configuration recorder is not recording a specific resource type (for example, S3 buckets), that resource type is not returned in the list of <code>ResourceCount</code> objects.</p>
        /// </note>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_types = input;
            self
        }
        /// <p>The maximum number of <code>ResourceCount</code> objects returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of <code>ResourceCount</code> objects returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDiscoveredResourceCountsInput`](crate::input::GetDiscoveredResourceCountsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDiscoveredResourceCountsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDiscoveredResourceCountsInput {
                resource_types: self.resource_types,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDiscoveredResourceCountsInputOperationOutputAlias =
    crate::operation::GetDiscoveredResourceCounts;
#[doc(hidden)]
pub type GetDiscoveredResourceCountsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDiscoveredResourceCountsInput {
    /// Consumes the builder and constructs an Operation<[`GetDiscoveredResourceCounts`](crate::operation::GetDiscoveredResourceCounts)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDiscoveredResourceCounts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDiscoveredResourceCountsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDiscoveredResourceCountsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetDiscoveredResourceCounts",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_discovered_resource_counts(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDiscoveredResourceCounts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDiscoveredResourceCounts",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDiscoveredResourceCountsInput`](crate::input::GetDiscoveredResourceCountsInput)
    pub fn builder() -> crate::input::get_discovered_resource_counts_input::Builder {
        crate::input::get_discovered_resource_counts_input::Builder::default()
    }
}

/// See [`GetOrganizationConfigRuleDetailedStatusInput`](crate::input::GetOrganizationConfigRuleDetailedStatusInput)
pub mod get_organization_config_rule_detailed_status_input {
    /// A builder for [`GetOrganizationConfigRuleDetailedStatusInput`](crate::input::GetOrganizationConfigRuleDetailedStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_config_rule_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::StatusDetailFilters>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of your organization Config rule for which you want status details for member accounts.</p>
        pub fn organization_config_rule_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of your organization Config rule for which you want status details for member accounts.</p>
        pub fn set_organization_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = input;
            self
        }
        /// <p>A <code>StatusDetailFilters</code> object.</p>
        pub fn filters(mut self, input: crate::model::StatusDetailFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A <code>StatusDetailFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::StatusDetailFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of <code>OrganizationConfigRuleDetailedStatus</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of <code>OrganizationConfigRuleDetailedStatus</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOrganizationConfigRuleDetailedStatusInput`](crate::input::GetOrganizationConfigRuleDetailedStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOrganizationConfigRuleDetailedStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOrganizationConfigRuleDetailedStatusInput {
                organization_config_rule_name: self.organization_config_rule_name,
                filters: self.filters,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOrganizationConfigRuleDetailedStatusInputOperationOutputAlias =
    crate::operation::GetOrganizationConfigRuleDetailedStatus;
#[doc(hidden)]
pub type GetOrganizationConfigRuleDetailedStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetOrganizationConfigRuleDetailedStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetOrganizationConfigRuleDetailedStatus`](crate::operation::GetOrganizationConfigRuleDetailedStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOrganizationConfigRuleDetailedStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOrganizationConfigRuleDetailedStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOrganizationConfigRuleDetailedStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetOrganizationConfigRuleDetailedStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_organization_config_rule_detailed_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOrganizationConfigRuleDetailedStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOrganizationConfigRuleDetailedStatus",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOrganizationConfigRuleDetailedStatusInput`](crate::input::GetOrganizationConfigRuleDetailedStatusInput)
    pub fn builder() -> crate::input::get_organization_config_rule_detailed_status_input::Builder {
        crate::input::get_organization_config_rule_detailed_status_input::Builder::default()
    }
}

/// See [`GetOrganizationConformancePackDetailedStatusInput`](crate::input::GetOrganizationConformancePackDetailedStatusInput)
pub mod get_organization_conformance_pack_detailed_status_input {
    /// A builder for [`GetOrganizationConformancePackDetailedStatusInput`](crate::input::GetOrganizationConformancePackDetailedStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<crate::model::OrganizationResourceDetailedStatusFilters>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of organization conformance pack for which you want status details for member accounts.</p>
        pub fn organization_conformance_pack_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_name = Some(input.into());
            self
        }
        /// <p>The name of organization conformance pack for which you want status details for member accounts.</p>
        pub fn set_organization_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_name = input;
            self
        }
        /// <p>An <code>OrganizationResourceDetailedStatusFilters</code> object.</p>
        pub fn filters(
            mut self,
            input: crate::model::OrganizationResourceDetailedStatusFilters,
        ) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>An <code>OrganizationResourceDetailedStatusFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::OrganizationResourceDetailedStatusFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of <code>OrganizationConformancePackDetailedStatuses</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of <code>OrganizationConformancePackDetailedStatuses</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOrganizationConformancePackDetailedStatusInput`](crate::input::GetOrganizationConformancePackDetailedStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOrganizationConformancePackDetailedStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetOrganizationConformancePackDetailedStatusInput {
                    organization_conformance_pack_name: self.organization_conformance_pack_name,
                    filters: self.filters,
                    limit: self.limit.unwrap_or_default(),
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetOrganizationConformancePackDetailedStatusInputOperationOutputAlias =
    crate::operation::GetOrganizationConformancePackDetailedStatus;
#[doc(hidden)]
pub type GetOrganizationConformancePackDetailedStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetOrganizationConformancePackDetailedStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetOrganizationConformancePackDetailedStatus`](crate::operation::GetOrganizationConformancePackDetailedStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOrganizationConformancePackDetailedStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOrganizationConformancePackDetailedStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOrganizationConformancePackDetailedStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetOrganizationConformancePackDetailedStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_organization_conformance_pack_detailed_status(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOrganizationConformancePackDetailedStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOrganizationConformancePackDetailedStatus",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOrganizationConformancePackDetailedStatusInput`](crate::input::GetOrganizationConformancePackDetailedStatusInput)
    pub fn builder(
    ) -> crate::input::get_organization_conformance_pack_detailed_status_input::Builder {
        crate::input::get_organization_conformance_pack_detailed_status_input::Builder::default()
    }
}

/// See [`GetOrganizationCustomRulePolicyInput`](crate::input::GetOrganizationCustomRulePolicyInput)
pub mod get_organization_custom_rule_policy_input {
    /// A builder for [`GetOrganizationCustomRulePolicyInput`](crate::input::GetOrganizationCustomRulePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_config_rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of your organization Config Custom Policy rule. </p>
        pub fn organization_config_rule_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of your organization Config Custom Policy rule. </p>
        pub fn set_organization_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOrganizationCustomRulePolicyInput`](crate::input::GetOrganizationCustomRulePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOrganizationCustomRulePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOrganizationCustomRulePolicyInput {
                organization_config_rule_name: self.organization_config_rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOrganizationCustomRulePolicyInputOperationOutputAlias =
    crate::operation::GetOrganizationCustomRulePolicy;
#[doc(hidden)]
pub type GetOrganizationCustomRulePolicyInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetOrganizationCustomRulePolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetOrganizationCustomRulePolicy`](crate::operation::GetOrganizationCustomRulePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOrganizationCustomRulePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOrganizationCustomRulePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOrganizationCustomRulePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetOrganizationCustomRulePolicy",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_organization_custom_rule_policy(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOrganizationCustomRulePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOrganizationCustomRulePolicy",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOrganizationCustomRulePolicyInput`](crate::input::GetOrganizationCustomRulePolicyInput)
    pub fn builder() -> crate::input::get_organization_custom_rule_policy_input::Builder {
        crate::input::get_organization_custom_rule_policy_input::Builder::default()
    }
}

/// See [`GetResourceConfigHistoryInput`](crate::input::GetResourceConfigHistoryInput)
pub mod get_resource_config_history_input {
    /// A builder for [`GetResourceConfigHistoryInput`](crate::input::GetResourceConfigHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) later_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) earlier_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) chronological_order: std::option::Option<crate::model::ChronologicalOrder>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The time stamp that indicates a later time. If not specified, current time is taken.</p>
        pub fn later_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.later_time = Some(input);
            self
        }
        /// <p>The time stamp that indicates a later time. If not specified, current time is taken.</p>
        pub fn set_later_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.later_time = input;
            self
        }
        /// <p>The time stamp that indicates an earlier time. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
        pub fn earlier_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.earlier_time = Some(input);
            self
        }
        /// <p>The time stamp that indicates an earlier time. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
        pub fn set_earlier_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.earlier_time = input;
            self
        }
        /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
        pub fn chronological_order(mut self, input: crate::model::ChronologicalOrder) -> Self {
            self.chronological_order = Some(input);
            self
        }
        /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
        pub fn set_chronological_order(
            mut self,
            input: std::option::Option<crate::model::ChronologicalOrder>,
        ) -> Self {
            self.chronological_order = input;
            self
        }
        /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceConfigHistoryInput`](crate::input::GetResourceConfigHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceConfigHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceConfigHistoryInput {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                later_time: self.later_time,
                earlier_time: self.earlier_time,
                chronological_order: self.chronological_order,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceConfigHistoryInputOperationOutputAlias =
    crate::operation::GetResourceConfigHistory;
#[doc(hidden)]
pub type GetResourceConfigHistoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetResourceConfigHistoryInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceConfigHistory`](crate::operation::GetResourceConfigHistory)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceConfigHistory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetResourceConfigHistoryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetResourceConfigHistoryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetResourceConfigHistory",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_resource_config_history(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceConfigHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceConfigHistory",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetResourceConfigHistoryInput`](crate::input::GetResourceConfigHistoryInput)
    pub fn builder() -> crate::input::get_resource_config_history_input::Builder {
        crate::input::get_resource_config_history_input::Builder::default()
    }
}

/// See [`GetStoredQueryInput`](crate::input::GetStoredQueryInput)
pub mod get_stored_query_input {
    /// A builder for [`GetStoredQueryInput`](crate::input::GetStoredQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the query.</p>
        pub fn query_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_name = Some(input.into());
            self
        }
        /// <p>The name of the query.</p>
        pub fn set_query_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStoredQueryInput`](crate::input::GetStoredQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStoredQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStoredQueryInput {
                query_name: self.query_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStoredQueryInputOperationOutputAlias = crate::operation::GetStoredQuery;
#[doc(hidden)]
pub type GetStoredQueryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStoredQueryInput {
    /// Consumes the builder and constructs an Operation<[`GetStoredQuery`](crate::operation::GetStoredQuery)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStoredQuery,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStoredQueryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStoredQueryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.GetStoredQuery",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_stored_query(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStoredQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStoredQuery",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStoredQueryInput`](crate::input::GetStoredQueryInput)
    pub fn builder() -> crate::input::get_stored_query_input::Builder {
        crate::input::get_stored_query_input::Builder::default()
    }
}

/// See [`ListAggregateDiscoveredResourcesInput`](crate::input::ListAggregateDiscoveredResourcesInput)
pub mod list_aggregate_discovered_resources_input {
    /// A builder for [`ListAggregateDiscoveredResourcesInput`](crate::input::ListAggregateDiscoveredResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) filters: std::option::Option<crate::model::ResourceFilters>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator. </p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator. </p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// <p>The type of resources that you want Config to list in the response.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resources that you want Config to list in the response.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Filters the results based on the <code>ResourceFilters</code> object.</p>
        pub fn filters(mut self, input: crate::model::ResourceFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>Filters the results based on the <code>ResourceFilters</code> object.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ResourceFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAggregateDiscoveredResourcesInput`](crate::input::ListAggregateDiscoveredResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAggregateDiscoveredResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAggregateDiscoveredResourcesInput {
                configuration_aggregator_name: self.configuration_aggregator_name,
                resource_type: self.resource_type,
                filters: self.filters,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAggregateDiscoveredResourcesInputOperationOutputAlias =
    crate::operation::ListAggregateDiscoveredResources;
#[doc(hidden)]
pub type ListAggregateDiscoveredResourcesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListAggregateDiscoveredResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListAggregateDiscoveredResources`](crate::operation::ListAggregateDiscoveredResources)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAggregateDiscoveredResources,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAggregateDiscoveredResourcesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAggregateDiscoveredResourcesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.ListAggregateDiscoveredResources",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_aggregate_discovered_resources(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAggregateDiscoveredResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAggregateDiscoveredResources",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAggregateDiscoveredResourcesInput`](crate::input::ListAggregateDiscoveredResourcesInput)
    pub fn builder() -> crate::input::list_aggregate_discovered_resources_input::Builder {
        crate::input::list_aggregate_discovered_resources_input::Builder::default()
    }
}

/// See [`ListDiscoveredResourcesInput`](crate::input::ListDiscoveredResourcesInput)
pub mod list_discovered_resources_input {
    /// A builder for [`ListDiscoveredResourcesInput`](crate::input::ListDiscoveredResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) include_deleted_resources: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of resources that you want Config to list in the response.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resources that you want Config to list in the response.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_ids`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The IDs of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_ids.unwrap_or_default();
            v.push(input.into());
            self.resource_ids = Some(v);
            self
        }
        /// <p>The IDs of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_ids = input;
            self
        }
        /// <p>The custom name of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The custom name of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>Specifies whether Config includes deleted resources in the results. By default, deleted resources are not included.</p>
        pub fn include_deleted_resources(mut self, input: bool) -> Self {
            self.include_deleted_resources = Some(input);
            self
        }
        /// <p>Specifies whether Config includes deleted resources in the results. By default, deleted resources are not included.</p>
        pub fn set_include_deleted_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.include_deleted_resources = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDiscoveredResourcesInput`](crate::input::ListDiscoveredResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDiscoveredResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDiscoveredResourcesInput {
                resource_type: self.resource_type,
                resource_ids: self.resource_ids,
                resource_name: self.resource_name,
                limit: self.limit.unwrap_or_default(),
                include_deleted_resources: self.include_deleted_resources.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDiscoveredResourcesInputOperationOutputAlias =
    crate::operation::ListDiscoveredResources;
#[doc(hidden)]
pub type ListDiscoveredResourcesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDiscoveredResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListDiscoveredResources`](crate::operation::ListDiscoveredResources)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDiscoveredResources,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDiscoveredResourcesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDiscoveredResourcesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.ListDiscoveredResources",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_discovered_resources(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDiscoveredResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDiscoveredResources",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDiscoveredResourcesInput`](crate::input::ListDiscoveredResourcesInput)
    pub fn builder() -> crate::input::list_discovered_resources_input::Builder {
        crate::input::list_discovered_resources_input::Builder::default()
    }
}

/// See [`ListStoredQueriesInput`](crate::input::ListStoredQueriesInput)
pub mod list_stored_queries_input {
    /// A builder for [`ListStoredQueriesInput`](crate::input::ListStoredQueriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned with a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned with a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStoredQueriesInput`](crate::input::ListStoredQueriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStoredQueriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStoredQueriesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStoredQueriesInputOperationOutputAlias = crate::operation::ListStoredQueries;
#[doc(hidden)]
pub type ListStoredQueriesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListStoredQueriesInput {
    /// Consumes the builder and constructs an Operation<[`ListStoredQueries`](crate::operation::ListStoredQueries)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStoredQueries,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListStoredQueriesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListStoredQueriesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.ListStoredQueries",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_stored_queries(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStoredQueries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStoredQueries",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListStoredQueriesInput`](crate::input::ListStoredQueriesInput)
    pub fn builder() -> crate::input::list_stored_queries_input::Builder {
        crate::input::list_stored_queries_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.ListTagsForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutAggregationAuthorizationInput`](crate::input::PutAggregationAuthorizationInput)
pub mod put_aggregation_authorization_input {
    /// A builder for [`PutAggregationAuthorizationInput`](crate::input::PutAggregationAuthorizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorized_account_id: std::option::Option<std::string::String>,
        pub(crate) authorized_aws_region: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
        pub fn authorized_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorized_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
        pub fn set_authorized_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorized_account_id = input;
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn authorized_aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorized_aws_region = Some(input.into());
            self
        }
        /// <p>The region authorized to collect aggregated data.</p>
        pub fn set_authorized_aws_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorized_aws_region = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tag object.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of tag object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAggregationAuthorizationInput`](crate::input::PutAggregationAuthorizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAggregationAuthorizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAggregationAuthorizationInput {
                authorized_account_id: self.authorized_account_id,
                authorized_aws_region: self.authorized_aws_region,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAggregationAuthorizationInputOperationOutputAlias =
    crate::operation::PutAggregationAuthorization;
#[doc(hidden)]
pub type PutAggregationAuthorizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutAggregationAuthorizationInput {
    /// Consumes the builder and constructs an Operation<[`PutAggregationAuthorization`](crate::operation::PutAggregationAuthorization)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAggregationAuthorization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutAggregationAuthorizationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutAggregationAuthorizationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutAggregationAuthorization",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_aggregation_authorization(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAggregationAuthorization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAggregationAuthorization",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutAggregationAuthorizationInput`](crate::input::PutAggregationAuthorizationInput)
    pub fn builder() -> crate::input::put_aggregation_authorization_input::Builder {
        crate::input::put_aggregation_authorization_input::Builder::default()
    }
}

/// See [`PutConfigRuleInput`](crate::input::PutConfigRuleInput)
pub mod put_config_rule_input {
    /// A builder for [`PutConfigRuleInput`](crate::input::PutConfigRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule: std::option::Option<crate::model::ConfigRule>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The rule that you want to add to your account.</p>
        pub fn config_rule(mut self, input: crate::model::ConfigRule) -> Self {
            self.config_rule = Some(input);
            self
        }
        /// <p>The rule that you want to add to your account.</p>
        pub fn set_config_rule(
            mut self,
            input: std::option::Option<crate::model::ConfigRule>,
        ) -> Self {
            self.config_rule = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tag object.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of tag object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutConfigRuleInput`](crate::input::PutConfigRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutConfigRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutConfigRuleInput {
                config_rule: self.config_rule,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutConfigRuleInputOperationOutputAlias = crate::operation::PutConfigRule;
#[doc(hidden)]
pub type PutConfigRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutConfigRuleInput {
    /// Consumes the builder and constructs an Operation<[`PutConfigRule`](crate::operation::PutConfigRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutConfigRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutConfigRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutConfigRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutConfigRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_config_rule(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutConfigRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutConfigRule",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutConfigRuleInput`](crate::input::PutConfigRuleInput)
    pub fn builder() -> crate::input::put_config_rule_input::Builder {
        crate::input::put_config_rule_input::Builder::default()
    }
}

/// See [`PutConfigurationAggregatorInput`](crate::input::PutConfigurationAggregatorInput)
pub mod put_configuration_aggregator_input {
    /// A builder for [`PutConfigurationAggregatorInput`](crate::input::PutConfigurationAggregatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) account_aggregation_sources:
            std::option::Option<std::vec::Vec<crate::model::AccountAggregationSource>>,
        pub(crate) organization_aggregation_source:
            std::option::Option<crate::model::OrganizationAggregationSource>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// Appends an item to `account_aggregation_sources`.
        ///
        /// To override the contents of this collection use [`set_account_aggregation_sources`](Self::set_account_aggregation_sources).
        ///
        /// <p>A list of AccountAggregationSource object. </p>
        pub fn account_aggregation_sources(
            mut self,
            input: crate::model::AccountAggregationSource,
        ) -> Self {
            let mut v = self.account_aggregation_sources.unwrap_or_default();
            v.push(input);
            self.account_aggregation_sources = Some(v);
            self
        }
        /// <p>A list of AccountAggregationSource object. </p>
        pub fn set_account_aggregation_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountAggregationSource>>,
        ) -> Self {
            self.account_aggregation_sources = input;
            self
        }
        /// <p>An OrganizationAggregationSource object.</p>
        pub fn organization_aggregation_source(
            mut self,
            input: crate::model::OrganizationAggregationSource,
        ) -> Self {
            self.organization_aggregation_source = Some(input);
            self
        }
        /// <p>An OrganizationAggregationSource object.</p>
        pub fn set_organization_aggregation_source(
            mut self,
            input: std::option::Option<crate::model::OrganizationAggregationSource>,
        ) -> Self {
            self.organization_aggregation_source = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tag object.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of tag object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutConfigurationAggregatorInput`](crate::input::PutConfigurationAggregatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutConfigurationAggregatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutConfigurationAggregatorInput {
                configuration_aggregator_name: self.configuration_aggregator_name,
                account_aggregation_sources: self.account_aggregation_sources,
                organization_aggregation_source: self.organization_aggregation_source,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutConfigurationAggregatorInputOperationOutputAlias =
    crate::operation::PutConfigurationAggregator;
#[doc(hidden)]
pub type PutConfigurationAggregatorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutConfigurationAggregatorInput {
    /// Consumes the builder and constructs an Operation<[`PutConfigurationAggregator`](crate::operation::PutConfigurationAggregator)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutConfigurationAggregator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutConfigurationAggregatorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutConfigurationAggregatorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutConfigurationAggregator",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_configuration_aggregator(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutConfigurationAggregator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutConfigurationAggregator",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutConfigurationAggregatorInput`](crate::input::PutConfigurationAggregatorInput)
    pub fn builder() -> crate::input::put_configuration_aggregator_input::Builder {
        crate::input::put_configuration_aggregator_input::Builder::default()
    }
}

/// See [`PutConfigurationRecorderInput`](crate::input::PutConfigurationRecorderInput)
pub mod put_configuration_recorder_input {
    /// A builder for [`PutConfigurationRecorderInput`](crate::input::PutConfigurationRecorderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_recorder: std::option::Option<crate::model::ConfigurationRecorder>,
    }
    impl Builder {
        /// <p>The configuration recorder object that records each configuration change made to the resources.</p>
        pub fn configuration_recorder(
            mut self,
            input: crate::model::ConfigurationRecorder,
        ) -> Self {
            self.configuration_recorder = Some(input);
            self
        }
        /// <p>The configuration recorder object that records each configuration change made to the resources.</p>
        pub fn set_configuration_recorder(
            mut self,
            input: std::option::Option<crate::model::ConfigurationRecorder>,
        ) -> Self {
            self.configuration_recorder = input;
            self
        }
        /// Consumes the builder and constructs a [`PutConfigurationRecorderInput`](crate::input::PutConfigurationRecorderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutConfigurationRecorderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutConfigurationRecorderInput {
                configuration_recorder: self.configuration_recorder,
            })
        }
    }
}
#[doc(hidden)]
pub type PutConfigurationRecorderInputOperationOutputAlias =
    crate::operation::PutConfigurationRecorder;
#[doc(hidden)]
pub type PutConfigurationRecorderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutConfigurationRecorderInput {
    /// Consumes the builder and constructs an Operation<[`PutConfigurationRecorder`](crate::operation::PutConfigurationRecorder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutConfigurationRecorder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutConfigurationRecorderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutConfigurationRecorderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutConfigurationRecorder",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_configuration_recorder(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutConfigurationRecorder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutConfigurationRecorder",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutConfigurationRecorderInput`](crate::input::PutConfigurationRecorderInput)
    pub fn builder() -> crate::input::put_configuration_recorder_input::Builder {
        crate::input::put_configuration_recorder_input::Builder::default()
    }
}

/// See [`PutConformancePackInput`](crate::input::PutConformancePackInput)
pub mod put_conformance_pack_input {
    /// A builder for [`PutConformancePackInput`](crate::input::PutConformancePackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) template_s3_uri: std::option::Option<std::string::String>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) delivery_s3_bucket: std::option::Option<std::string::String>,
        pub(crate) delivery_s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_input_parameters:
            std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
    }
    impl Builder {
        /// <p>Name of the conformance pack you want to create.</p>
        pub fn conformance_pack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.conformance_pack_name = Some(input.into());
            self
        }
        /// <p>Name of the conformance pack you want to create.</p>
        pub fn set_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conformance_pack_name = input;
            self
        }
        /// <p>Location of file containing the template body (<code>s3://bucketname/prefix</code>). The uri must point to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same region as the conformance pack. </p> <note>
        /// <p>You must have access to read Amazon S3 bucket.</p>
        /// </note>
        pub fn template_s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_s3_uri = Some(input.into());
            self
        }
        /// <p>Location of file containing the template body (<code>s3://bucketname/prefix</code>). The uri must point to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same region as the conformance pack. </p> <note>
        /// <p>You must have access to read Amazon S3 bucket.</p>
        /// </note>
        pub fn set_template_s3_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_s3_uri = input;
            self
        }
        /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p> <note>
        /// <p>You can only use a YAML template with two resource types: Config rule (<code>AWS::Config::ConfigRule</code>) and a remediation action (<code>AWS::Config::RemediationConfiguration</code>).</p>
        /// </note>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p> <note>
        /// <p>You can only use a YAML template with two resource types: Config rule (<code>AWS::Config::ConfigRule</code>) and a remediation action (<code>AWS::Config::RemediationConfiguration</code>).</p>
        /// </note>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn delivery_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn set_delivery_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_s3_bucket = input;
            self
        }
        /// <p>The prefix for the Amazon S3 bucket. </p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn delivery_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The prefix for the Amazon S3 bucket. </p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn set_delivery_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_s3_key_prefix = input;
            self
        }
        /// Appends an item to `conformance_pack_input_parameters`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_input_parameters`](Self::set_conformance_pack_input_parameters).
        ///
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn conformance_pack_input_parameters(
            mut self,
            input: crate::model::ConformancePackInputParameter,
        ) -> Self {
            let mut v = self.conformance_pack_input_parameters.unwrap_or_default();
            v.push(input);
            self.conformance_pack_input_parameters = Some(v);
            self
        }
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn set_conformance_pack_input_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
        ) -> Self {
            self.conformance_pack_input_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`PutConformancePackInput`](crate::input::PutConformancePackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutConformancePackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutConformancePackInput {
                conformance_pack_name: self.conformance_pack_name,
                template_s3_uri: self.template_s3_uri,
                template_body: self.template_body,
                delivery_s3_bucket: self.delivery_s3_bucket,
                delivery_s3_key_prefix: self.delivery_s3_key_prefix,
                conformance_pack_input_parameters: self.conformance_pack_input_parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type PutConformancePackInputOperationOutputAlias = crate::operation::PutConformancePack;
#[doc(hidden)]
pub type PutConformancePackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutConformancePackInput {
    /// Consumes the builder and constructs an Operation<[`PutConformancePack`](crate::operation::PutConformancePack)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutConformancePack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutConformancePackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutConformancePackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutConformancePack",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_conformance_pack(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutConformancePack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutConformancePack",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutConformancePackInput`](crate::input::PutConformancePackInput)
    pub fn builder() -> crate::input::put_conformance_pack_input::Builder {
        crate::input::put_conformance_pack_input::Builder::default()
    }
}

/// See [`PutDeliveryChannelInput`](crate::input::PutDeliveryChannelInput)
pub mod put_delivery_channel_input {
    /// A builder for [`PutDeliveryChannelInput`](crate::input::PutDeliveryChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_channel: std::option::Option<crate::model::DeliveryChannel>,
    }
    impl Builder {
        /// <p>The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket and to an Amazon SNS topic.</p>
        pub fn delivery_channel(mut self, input: crate::model::DeliveryChannel) -> Self {
            self.delivery_channel = Some(input);
            self
        }
        /// <p>The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket and to an Amazon SNS topic.</p>
        pub fn set_delivery_channel(
            mut self,
            input: std::option::Option<crate::model::DeliveryChannel>,
        ) -> Self {
            self.delivery_channel = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDeliveryChannelInput`](crate::input::PutDeliveryChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutDeliveryChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutDeliveryChannelInput {
                delivery_channel: self.delivery_channel,
            })
        }
    }
}
#[doc(hidden)]
pub type PutDeliveryChannelInputOperationOutputAlias = crate::operation::PutDeliveryChannel;
#[doc(hidden)]
pub type PutDeliveryChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutDeliveryChannelInput {
    /// Consumes the builder and constructs an Operation<[`PutDeliveryChannel`](crate::operation::PutDeliveryChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutDeliveryChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutDeliveryChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutDeliveryChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutDeliveryChannel",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_delivery_channel(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutDeliveryChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutDeliveryChannel",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutDeliveryChannelInput`](crate::input::PutDeliveryChannelInput)
    pub fn builder() -> crate::input::put_delivery_channel_input::Builder {
        crate::input::put_delivery_channel_input::Builder::default()
    }
}

/// See [`PutEvaluationsInput`](crate::input::PutEvaluationsInput)
pub mod put_evaluations_input {
    /// A builder for [`PutEvaluationsInput`](crate::input::PutEvaluationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluations: std::option::Option<std::vec::Vec<crate::model::Evaluation>>,
        pub(crate) result_token: std::option::Option<std::string::String>,
        pub(crate) test_mode: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `evaluations`.
        ///
        /// To override the contents of this collection use [`set_evaluations`](Self::set_evaluations).
        ///
        /// <p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>
        pub fn evaluations(mut self, input: crate::model::Evaluation) -> Self {
            let mut v = self.evaluations.unwrap_or_default();
            v.push(input);
            self.evaluations = Some(v);
            self
        }
        /// <p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>
        pub fn set_evaluations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Evaluation>>,
        ) -> Self {
            self.evaluations = input;
            self
        }
        /// <p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>
        pub fn result_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_token = Some(input.into());
            self
        }
        /// <p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>
        pub fn set_result_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result_token = input;
            self
        }
        /// <p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p> <note>
        /// <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p>
        /// </note>
        pub fn test_mode(mut self, input: bool) -> Self {
            self.test_mode = Some(input);
            self
        }
        /// <p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p> <note>
        /// <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p>
        /// </note>
        pub fn set_test_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.test_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEvaluationsInput`](crate::input::PutEvaluationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEvaluationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEvaluationsInput {
                evaluations: self.evaluations,
                result_token: self.result_token,
                test_mode: self.test_mode.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PutEvaluationsInputOperationOutputAlias = crate::operation::PutEvaluations;
#[doc(hidden)]
pub type PutEvaluationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutEvaluationsInput {
    /// Consumes the builder and constructs an Operation<[`PutEvaluations`](crate::operation::PutEvaluations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEvaluations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutEvaluationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutEvaluationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutEvaluations",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_evaluations(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEvaluations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEvaluations",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutEvaluationsInput`](crate::input::PutEvaluationsInput)
    pub fn builder() -> crate::input::put_evaluations_input::Builder {
        crate::input::put_evaluations_input::Builder::default()
    }
}

/// See [`PutExternalEvaluationInput`](crate::input::PutExternalEvaluationInput)
pub mod put_external_evaluation_input {
    /// A builder for [`PutExternalEvaluationInput`](crate::input::PutExternalEvaluationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) external_evaluation: std::option::Option<crate::model::ExternalEvaluation>,
    }
    impl Builder {
        /// <p>The name of the Config rule.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// <p>An <code>ExternalEvaluation</code> object that provides details about compliance.</p>
        pub fn external_evaluation(mut self, input: crate::model::ExternalEvaluation) -> Self {
            self.external_evaluation = Some(input);
            self
        }
        /// <p>An <code>ExternalEvaluation</code> object that provides details about compliance.</p>
        pub fn set_external_evaluation(
            mut self,
            input: std::option::Option<crate::model::ExternalEvaluation>,
        ) -> Self {
            self.external_evaluation = input;
            self
        }
        /// Consumes the builder and constructs a [`PutExternalEvaluationInput`](crate::input::PutExternalEvaluationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutExternalEvaluationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutExternalEvaluationInput {
                config_rule_name: self.config_rule_name,
                external_evaluation: self.external_evaluation,
            })
        }
    }
}
#[doc(hidden)]
pub type PutExternalEvaluationInputOperationOutputAlias = crate::operation::PutExternalEvaluation;
#[doc(hidden)]
pub type PutExternalEvaluationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutExternalEvaluationInput {
    /// Consumes the builder and constructs an Operation<[`PutExternalEvaluation`](crate::operation::PutExternalEvaluation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutExternalEvaluation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutExternalEvaluationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutExternalEvaluationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutExternalEvaluation",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_external_evaluation(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutExternalEvaluation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutExternalEvaluation",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutExternalEvaluationInput`](crate::input::PutExternalEvaluationInput)
    pub fn builder() -> crate::input::put_external_evaluation_input::Builder {
        crate::input::put_external_evaluation_input::Builder::default()
    }
}

/// See [`PutOrganizationConfigRuleInput`](crate::input::PutOrganizationConfigRuleInput)
pub mod put_organization_config_rule_input {
    /// A builder for [`PutOrganizationConfigRuleInput`](crate::input::PutOrganizationConfigRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_config_rule_name: std::option::Option<std::string::String>,
        pub(crate) organization_managed_rule_metadata:
            std::option::Option<crate::model::OrganizationManagedRuleMetadata>,
        pub(crate) organization_custom_rule_metadata:
            std::option::Option<crate::model::OrganizationCustomRuleMetadata>,
        pub(crate) excluded_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) organization_custom_policy_rule_metadata:
            std::option::Option<crate::model::OrganizationCustomPolicyRuleMetadata>,
    }
    impl Builder {
        /// <p>The name that you assign to an organization Config rule.</p>
        pub fn organization_config_rule_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = Some(input.into());
            self
        }
        /// <p>The name that you assign to an organization Config rule.</p>
        pub fn set_organization_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_config_rule_name = input;
            self
        }
        /// <p>An <code>OrganizationManagedRuleMetadata</code> object. </p>
        pub fn organization_managed_rule_metadata(
            mut self,
            input: crate::model::OrganizationManagedRuleMetadata,
        ) -> Self {
            self.organization_managed_rule_metadata = Some(input);
            self
        }
        /// <p>An <code>OrganizationManagedRuleMetadata</code> object. </p>
        pub fn set_organization_managed_rule_metadata(
            mut self,
            input: std::option::Option<crate::model::OrganizationManagedRuleMetadata>,
        ) -> Self {
            self.organization_managed_rule_metadata = input;
            self
        }
        /// <p>An <code>OrganizationCustomRuleMetadata</code> object.</p>
        pub fn organization_custom_rule_metadata(
            mut self,
            input: crate::model::OrganizationCustomRuleMetadata,
        ) -> Self {
            self.organization_custom_rule_metadata = Some(input);
            self
        }
        /// <p>An <code>OrganizationCustomRuleMetadata</code> object.</p>
        pub fn set_organization_custom_rule_metadata(
            mut self,
            input: std::option::Option<crate::model::OrganizationCustomRuleMetadata>,
        ) -> Self {
            self.organization_custom_rule_metadata = input;
            self
        }
        /// Appends an item to `excluded_accounts`.
        ///
        /// To override the contents of this collection use [`set_excluded_accounts`](Self::set_excluded_accounts).
        ///
        /// <p>A comma-separated list of accounts that you want to exclude from an organization Config rule.</p>
        pub fn excluded_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_accounts.unwrap_or_default();
            v.push(input.into());
            self.excluded_accounts = Some(v);
            self
        }
        /// <p>A comma-separated list of accounts that you want to exclude from an organization Config rule.</p>
        pub fn set_excluded_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_accounts = input;
            self
        }
        /// <p>An object that specifies metadata for your organization's Config Custom Policy rule. The metadata includes the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as resource type, resource ID of Amazon Web Services resource, and organization trigger types that initiate Config to evaluate Amazon Web Services resources against a rule.</p>
        pub fn organization_custom_policy_rule_metadata(
            mut self,
            input: crate::model::OrganizationCustomPolicyRuleMetadata,
        ) -> Self {
            self.organization_custom_policy_rule_metadata = Some(input);
            self
        }
        /// <p>An object that specifies metadata for your organization's Config Custom Policy rule. The metadata includes the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as resource type, resource ID of Amazon Web Services resource, and organization trigger types that initiate Config to evaluate Amazon Web Services resources against a rule.</p>
        pub fn set_organization_custom_policy_rule_metadata(
            mut self,
            input: std::option::Option<crate::model::OrganizationCustomPolicyRuleMetadata>,
        ) -> Self {
            self.organization_custom_policy_rule_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`PutOrganizationConfigRuleInput`](crate::input::PutOrganizationConfigRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutOrganizationConfigRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutOrganizationConfigRuleInput {
                organization_config_rule_name: self.organization_config_rule_name,
                organization_managed_rule_metadata: self.organization_managed_rule_metadata,
                organization_custom_rule_metadata: self.organization_custom_rule_metadata,
                excluded_accounts: self.excluded_accounts,
                organization_custom_policy_rule_metadata: self
                    .organization_custom_policy_rule_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type PutOrganizationConfigRuleInputOperationOutputAlias =
    crate::operation::PutOrganizationConfigRule;
#[doc(hidden)]
pub type PutOrganizationConfigRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutOrganizationConfigRuleInput {
    /// Consumes the builder and constructs an Operation<[`PutOrganizationConfigRule`](crate::operation::PutOrganizationConfigRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutOrganizationConfigRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutOrganizationConfigRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutOrganizationConfigRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutOrganizationConfigRule",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_organization_config_rule(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutOrganizationConfigRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutOrganizationConfigRule",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutOrganizationConfigRuleInput`](crate::input::PutOrganizationConfigRuleInput)
    pub fn builder() -> crate::input::put_organization_config_rule_input::Builder {
        crate::input::put_organization_config_rule_input::Builder::default()
    }
}

/// See [`PutOrganizationConformancePackInput`](crate::input::PutOrganizationConformancePackInput)
pub mod put_organization_conformance_pack_input {
    /// A builder for [`PutOrganizationConformancePackInput`](crate::input::PutOrganizationConformancePackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_conformance_pack_name: std::option::Option<std::string::String>,
        pub(crate) template_s3_uri: std::option::Option<std::string::String>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) delivery_s3_bucket: std::option::Option<std::string::String>,
        pub(crate) delivery_s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) conformance_pack_input_parameters:
            std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
        pub(crate) excluded_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Name of the organization conformance pack you want to create.</p>
        pub fn organization_conformance_pack_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_name = Some(input.into());
            self
        }
        /// <p>Name of the organization conformance pack you want to create.</p>
        pub fn set_organization_conformance_pack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_conformance_pack_name = input;
            self
        }
        /// <p>Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).</p> <note>
        /// <p>You must have access to read Amazon S3 bucket.</p>
        /// </note>
        pub fn template_s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_s3_uri = Some(input.into());
            self
        }
        /// <p>Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).</p> <note>
        /// <p>You must have access to read Amazon S3 bucket.</p>
        /// </note>
        pub fn set_template_s3_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_s3_uri = input;
            self
        }
        /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
        /// <p>This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.</p>
        /// </note>
        pub fn delivery_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
        /// <p>This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.</p>
        /// </note>
        pub fn set_delivery_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_s3_bucket = input;
            self
        }
        /// <p>The prefix for the Amazon S3 bucket.</p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn delivery_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The prefix for the Amazon S3 bucket.</p> <note>
        /// <p>This field is optional.</p>
        /// </note>
        pub fn set_delivery_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_s3_key_prefix = input;
            self
        }
        /// Appends an item to `conformance_pack_input_parameters`.
        ///
        /// To override the contents of this collection use [`set_conformance_pack_input_parameters`](Self::set_conformance_pack_input_parameters).
        ///
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn conformance_pack_input_parameters(
            mut self,
            input: crate::model::ConformancePackInputParameter,
        ) -> Self {
            let mut v = self.conformance_pack_input_parameters.unwrap_or_default();
            v.push(input);
            self.conformance_pack_input_parameters = Some(v);
            self
        }
        /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
        pub fn set_conformance_pack_input_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
        ) -> Self {
            self.conformance_pack_input_parameters = input;
            self
        }
        /// Appends an item to `excluded_accounts`.
        ///
        /// To override the contents of this collection use [`set_excluded_accounts`](Self::set_excluded_accounts).
        ///
        /// <p>A list of Amazon Web Services accounts to be excluded from an organization conformance pack while deploying a conformance pack.</p>
        pub fn excluded_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_accounts.unwrap_or_default();
            v.push(input.into());
            self.excluded_accounts = Some(v);
            self
        }
        /// <p>A list of Amazon Web Services accounts to be excluded from an organization conformance pack while deploying a conformance pack.</p>
        pub fn set_excluded_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_accounts = input;
            self
        }
        /// Consumes the builder and constructs a [`PutOrganizationConformancePackInput`](crate::input::PutOrganizationConformancePackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutOrganizationConformancePackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutOrganizationConformancePackInput {
                organization_conformance_pack_name: self.organization_conformance_pack_name,
                template_s3_uri: self.template_s3_uri,
                template_body: self.template_body,
                delivery_s3_bucket: self.delivery_s3_bucket,
                delivery_s3_key_prefix: self.delivery_s3_key_prefix,
                conformance_pack_input_parameters: self.conformance_pack_input_parameters,
                excluded_accounts: self.excluded_accounts,
            })
        }
    }
}
#[doc(hidden)]
pub type PutOrganizationConformancePackInputOperationOutputAlias =
    crate::operation::PutOrganizationConformancePack;
#[doc(hidden)]
pub type PutOrganizationConformancePackInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutOrganizationConformancePackInput {
    /// Consumes the builder and constructs an Operation<[`PutOrganizationConformancePack`](crate::operation::PutOrganizationConformancePack)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutOrganizationConformancePack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutOrganizationConformancePackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutOrganizationConformancePackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutOrganizationConformancePack",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_organization_conformance_pack(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutOrganizationConformancePack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutOrganizationConformancePack",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutOrganizationConformancePackInput`](crate::input::PutOrganizationConformancePackInput)
    pub fn builder() -> crate::input::put_organization_conformance_pack_input::Builder {
        crate::input::put_organization_conformance_pack_input::Builder::default()
    }
}

/// See [`PutRemediationConfigurationsInput`](crate::input::PutRemediationConfigurationsInput)
pub mod put_remediation_configurations_input {
    /// A builder for [`PutRemediationConfigurationsInput`](crate::input::PutRemediationConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) remediation_configurations:
            std::option::Option<std::vec::Vec<crate::model::RemediationConfiguration>>,
    }
    impl Builder {
        /// Appends an item to `remediation_configurations`.
        ///
        /// To override the contents of this collection use [`set_remediation_configurations`](Self::set_remediation_configurations).
        ///
        /// <p>A list of remediation configuration objects.</p>
        pub fn remediation_configurations(
            mut self,
            input: crate::model::RemediationConfiguration,
        ) -> Self {
            let mut v = self.remediation_configurations.unwrap_or_default();
            v.push(input);
            self.remediation_configurations = Some(v);
            self
        }
        /// <p>A list of remediation configuration objects.</p>
        pub fn set_remediation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RemediationConfiguration>>,
        ) -> Self {
            self.remediation_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRemediationConfigurationsInput`](crate::input::PutRemediationConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRemediationConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRemediationConfigurationsInput {
                remediation_configurations: self.remediation_configurations,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRemediationConfigurationsInputOperationOutputAlias =
    crate::operation::PutRemediationConfigurations;
#[doc(hidden)]
pub type PutRemediationConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutRemediationConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`PutRemediationConfigurations`](crate::operation::PutRemediationConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRemediationConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutRemediationConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutRemediationConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutRemediationConfigurations",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_remediation_configurations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRemediationConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRemediationConfigurations",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutRemediationConfigurationsInput`](crate::input::PutRemediationConfigurationsInput)
    pub fn builder() -> crate::input::put_remediation_configurations_input::Builder {
        crate::input::put_remediation_configurations_input::Builder::default()
    }
}

/// See [`PutRemediationExceptionsInput`](crate::input::PutRemediationExceptionsInput)
pub mod put_remediation_exceptions_input {
    /// A builder for [`PutRemediationExceptionsInput`](crate::input::PutRemediationExceptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) resource_keys:
            std::option::Option<std::vec::Vec<crate::model::RemediationExceptionResourceKey>>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) expiration_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the Config rule for which you want to create remediation exception.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the Config rule for which you want to create remediation exception.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// Appends an item to `resource_keys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn resource_keys(
            mut self,
            input: crate::model::RemediationExceptionResourceKey,
        ) -> Self {
            let mut v = self.resource_keys.unwrap_or_default();
            v.push(input);
            self.resource_keys = Some(v);
            self
        }
        /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RemediationExceptionResourceKey>,
            >,
        ) -> Self {
            self.resource_keys = input;
            self
        }
        /// <p>The message contains an explanation of the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message contains an explanation of the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The exception is automatically deleted after the expiration date.</p>
        pub fn expiration_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration_time = Some(input);
            self
        }
        /// <p>The exception is automatically deleted after the expiration date.</p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRemediationExceptionsInput`](crate::input::PutRemediationExceptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRemediationExceptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRemediationExceptionsInput {
                config_rule_name: self.config_rule_name,
                resource_keys: self.resource_keys,
                message: self.message,
                expiration_time: self.expiration_time,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRemediationExceptionsInputOperationOutputAlias =
    crate::operation::PutRemediationExceptions;
#[doc(hidden)]
pub type PutRemediationExceptionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutRemediationExceptionsInput {
    /// Consumes the builder and constructs an Operation<[`PutRemediationExceptions`](crate::operation::PutRemediationExceptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRemediationExceptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutRemediationExceptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutRemediationExceptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutRemediationExceptions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_remediation_exceptions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRemediationExceptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRemediationExceptions",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutRemediationExceptionsInput`](crate::input::PutRemediationExceptionsInput)
    pub fn builder() -> crate::input::put_remediation_exceptions_input::Builder {
        crate::input::put_remediation_exceptions_input::Builder::default()
    }
}

/// See [`PutResourceConfigInput`](crate::input::PutResourceConfigInput)
pub mod put_resource_config_input {
    /// A builder for [`PutResourceConfigInput`](crate::input::PutResourceConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) schema_version_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The type of the resource. The custom resource type must be registered with CloudFormation. </p> <note>
        /// <p>You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the first part of the ResourceType up to the first ::.</p>
        /// </note>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource. The custom resource type must be registered with CloudFormation. </p> <note>
        /// <p>You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the first part of the ResourceType up to the first ::.</p>
        /// </note>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Version of the schema registered for the ResourceType in CloudFormation.</p>
        pub fn schema_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version_id = Some(input.into());
            self
        }
        /// <p>Version of the schema registered for the ResourceType in CloudFormation.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version_id = input;
            self
        }
        /// <p>Unique identifier of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Unique identifier of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Name of the resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>Name of the resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The configuration object of the resource in valid JSON format. It must match the schema registered with CloudFormation.</p> <note>
        /// <p>The configuration JSON must not exceed 64 KB.</p>
        /// </note>
        pub fn configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration = Some(input.into());
            self
        }
        /// <p>The configuration object of the resource in valid JSON format. It must match the schema registered with CloudFormation.</p> <note>
        /// <p>The configuration JSON must not exceed 64 KB.</p>
        /// </note>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResourceConfigInput`](crate::input::PutResourceConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutResourceConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutResourceConfigInput {
                resource_type: self.resource_type,
                schema_version_id: self.schema_version_id,
                resource_id: self.resource_id,
                resource_name: self.resource_name,
                configuration: self.configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutResourceConfigInputOperationOutputAlias = crate::operation::PutResourceConfig;
#[doc(hidden)]
pub type PutResourceConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutResourceConfigInput {
    /// Consumes the builder and constructs an Operation<[`PutResourceConfig`](crate::operation::PutResourceConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutResourceConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutResourceConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutResourceConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutResourceConfig",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_resource_config(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutResourceConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutResourceConfig",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutResourceConfigInput`](crate::input::PutResourceConfigInput)
    pub fn builder() -> crate::input::put_resource_config_input::Builder {
        crate::input::put_resource_config_input::Builder::default()
    }
}

/// See [`PutRetentionConfigurationInput`](crate::input::PutRetentionConfigurationInput)
pub mod put_retention_configuration_input {
    /// A builder for [`PutRetentionConfigurationInput`](crate::input::PutRetentionConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retention_period_in_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Number of days Config stores your historical information.</p> <note>
        /// <p>Currently, only applicable to the configuration item history.</p>
        /// </note>
        pub fn retention_period_in_days(mut self, input: i32) -> Self {
            self.retention_period_in_days = Some(input);
            self
        }
        /// <p>Number of days Config stores your historical information.</p> <note>
        /// <p>Currently, only applicable to the configuration item history.</p>
        /// </note>
        pub fn set_retention_period_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period_in_days = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRetentionConfigurationInput`](crate::input::PutRetentionConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRetentionConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRetentionConfigurationInput {
                retention_period_in_days: self.retention_period_in_days.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PutRetentionConfigurationInputOperationOutputAlias =
    crate::operation::PutRetentionConfiguration;
#[doc(hidden)]
pub type PutRetentionConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutRetentionConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutRetentionConfiguration`](crate::operation::PutRetentionConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRetentionConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutRetentionConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutRetentionConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutRetentionConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_retention_configuration(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRetentionConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRetentionConfiguration",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutRetentionConfigurationInput`](crate::input::PutRetentionConfigurationInput)
    pub fn builder() -> crate::input::put_retention_configuration_input::Builder {
        crate::input::put_retention_configuration_input::Builder::default()
    }
}

/// See [`PutStoredQueryInput`](crate::input::PutStoredQueryInput)
pub mod put_stored_query_input {
    /// A builder for [`PutStoredQueryInput`](crate::input::PutStoredQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stored_query: std::option::Option<crate::model::StoredQuery>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and <code>Expression</code>.</p> <note>
        /// <p>When you are creating a query, you must provide a query name and an expression. When you are updating a query, you must provide a query name but updating the description is optional.</p>
        /// </note>
        pub fn stored_query(mut self, input: crate::model::StoredQuery) -> Self {
            self.stored_query = Some(input);
            self
        }
        /// <p>A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and <code>Expression</code>.</p> <note>
        /// <p>When you are creating a query, you must provide a query name and an expression. When you are updating a query, you must provide a query name but updating the description is optional.</p>
        /// </note>
        pub fn set_stored_query(
            mut self,
            input: std::option::Option<crate::model::StoredQuery>,
        ) -> Self {
            self.stored_query = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tags</code> object.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of <code>Tags</code> object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutStoredQueryInput`](crate::input::PutStoredQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutStoredQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutStoredQueryInput {
                stored_query: self.stored_query,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutStoredQueryInputOperationOutputAlias = crate::operation::PutStoredQuery;
#[doc(hidden)]
pub type PutStoredQueryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutStoredQueryInput {
    /// Consumes the builder and constructs an Operation<[`PutStoredQuery`](crate::operation::PutStoredQuery)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutStoredQuery,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutStoredQueryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutStoredQueryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.PutStoredQuery",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_stored_query(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutStoredQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutStoredQuery",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutStoredQueryInput`](crate::input::PutStoredQueryInput)
    pub fn builder() -> crate::input::put_stored_query_input::Builder {
        crate::input::put_stored_query_input::Builder::default()
    }
}

/// See [`SelectAggregateResourceConfigInput`](crate::input::SelectAggregateResourceConfigInput)
pub mod select_aggregate_resource_config_input {
    /// A builder for [`SelectAggregateResourceConfigInput`](crate::input::SelectAggregateResourceConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) configuration_aggregator_name: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SQL query SELECT command. </p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The SQL query SELECT command. </p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn configuration_aggregator_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration aggregator.</p>
        pub fn set_configuration_aggregator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_aggregator_name = input;
            self
        }
        /// <p>The maximum number of query results returned on each page. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of query results returned on each page. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The maximum number of query results returned on each page. Config also allows the Limit request parameter.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of query results returned on each page. Config also allows the Limit request parameter.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SelectAggregateResourceConfigInput`](crate::input::SelectAggregateResourceConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SelectAggregateResourceConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SelectAggregateResourceConfigInput {
                expression: self.expression,
                configuration_aggregator_name: self.configuration_aggregator_name,
                limit: self.limit.unwrap_or_default(),
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type SelectAggregateResourceConfigInputOperationOutputAlias =
    crate::operation::SelectAggregateResourceConfig;
#[doc(hidden)]
pub type SelectAggregateResourceConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl SelectAggregateResourceConfigInput {
    /// Consumes the builder and constructs an Operation<[`SelectAggregateResourceConfig`](crate::operation::SelectAggregateResourceConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SelectAggregateResourceConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SelectAggregateResourceConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SelectAggregateResourceConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.SelectAggregateResourceConfig",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_select_aggregate_resource_config(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SelectAggregateResourceConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SelectAggregateResourceConfig",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SelectAggregateResourceConfigInput`](crate::input::SelectAggregateResourceConfigInput)
    pub fn builder() -> crate::input::select_aggregate_resource_config_input::Builder {
        crate::input::select_aggregate_resource_config_input::Builder::default()
    }
}

/// See [`SelectResourceConfigInput`](crate::input::SelectResourceConfigInput)
pub mod select_resource_config_input {
    /// A builder for [`SelectResourceConfigInput`](crate::input::SelectResourceConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SQL query <code>SELECT</code> command.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The SQL query <code>SELECT</code> command.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>The maximum number of query results returned on each page. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of query results returned on each page. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SelectResourceConfigInput`](crate::input::SelectResourceConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SelectResourceConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SelectResourceConfigInput {
                expression: self.expression,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type SelectResourceConfigInputOperationOutputAlias = crate::operation::SelectResourceConfig;
#[doc(hidden)]
pub type SelectResourceConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SelectResourceConfigInput {
    /// Consumes the builder and constructs an Operation<[`SelectResourceConfig`](crate::operation::SelectResourceConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SelectResourceConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SelectResourceConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SelectResourceConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.SelectResourceConfig",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_select_resource_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SelectResourceConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SelectResourceConfig",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SelectResourceConfigInput`](crate::input::SelectResourceConfigInput)
    pub fn builder() -> crate::input::select_resource_config_input::Builder {
        crate::input::select_resource_config_input::Builder::default()
    }
}

/// See [`StartConfigRulesEvaluationInput`](crate::input::StartConfigRulesEvaluationInput)
pub mod start_config_rules_evaluation_input {
    /// A builder for [`StartConfigRulesEvaluationInput`](crate::input::StartConfigRulesEvaluationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `config_rule_names`.
        ///
        /// To override the contents of this collection use [`set_config_rule_names`](Self::set_config_rule_names).
        ///
        /// <p>The list of names of Config rules that you want to run evaluations for.</p>
        pub fn config_rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.config_rule_names.unwrap_or_default();
            v.push(input.into());
            self.config_rule_names = Some(v);
            self
        }
        /// <p>The list of names of Config rules that you want to run evaluations for.</p>
        pub fn set_config_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.config_rule_names = input;
            self
        }
        /// Consumes the builder and constructs a [`StartConfigRulesEvaluationInput`](crate::input::StartConfigRulesEvaluationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartConfigRulesEvaluationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartConfigRulesEvaluationInput {
                config_rule_names: self.config_rule_names,
            })
        }
    }
}
#[doc(hidden)]
pub type StartConfigRulesEvaluationInputOperationOutputAlias =
    crate::operation::StartConfigRulesEvaluation;
#[doc(hidden)]
pub type StartConfigRulesEvaluationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartConfigRulesEvaluationInput {
    /// Consumes the builder and constructs an Operation<[`StartConfigRulesEvaluation`](crate::operation::StartConfigRulesEvaluation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartConfigRulesEvaluation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartConfigRulesEvaluationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartConfigRulesEvaluationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.StartConfigRulesEvaluation",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_config_rules_evaluation(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartConfigRulesEvaluation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartConfigRulesEvaluation",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartConfigRulesEvaluationInput`](crate::input::StartConfigRulesEvaluationInput)
    pub fn builder() -> crate::input::start_config_rules_evaluation_input::Builder {
        crate::input::start_config_rules_evaluation_input::Builder::default()
    }
}

/// See [`StartConfigurationRecorderInput`](crate::input::StartConfigurationRecorderInput)
pub mod start_configuration_recorder_input {
    /// A builder for [`StartConfigurationRecorderInput`](crate::input::StartConfigurationRecorderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_recorder_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
        pub fn configuration_recorder_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_recorder_name = Some(input.into());
            self
        }
        /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
        pub fn set_configuration_recorder_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_recorder_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartConfigurationRecorderInput`](crate::input::StartConfigurationRecorderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartConfigurationRecorderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartConfigurationRecorderInput {
                configuration_recorder_name: self.configuration_recorder_name,
            })
        }
    }
}
#[doc(hidden)]
pub type StartConfigurationRecorderInputOperationOutputAlias =
    crate::operation::StartConfigurationRecorder;
#[doc(hidden)]
pub type StartConfigurationRecorderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartConfigurationRecorderInput {
    /// Consumes the builder and constructs an Operation<[`StartConfigurationRecorder`](crate::operation::StartConfigurationRecorder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartConfigurationRecorder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartConfigurationRecorderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartConfigurationRecorderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.StartConfigurationRecorder",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_configuration_recorder(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartConfigurationRecorder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartConfigurationRecorder",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartConfigurationRecorderInput`](crate::input::StartConfigurationRecorderInput)
    pub fn builder() -> crate::input::start_configuration_recorder_input::Builder {
        crate::input::start_configuration_recorder_input::Builder::default()
    }
}

/// See [`StartRemediationExecutionInput`](crate::input::StartRemediationExecutionInput)
pub mod start_remediation_execution_input {
    /// A builder for [`StartRemediationExecutionInput`](crate::input::StartRemediationExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_rule_name: std::option::Option<std::string::String>,
        pub(crate) resource_keys: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
    }
    impl Builder {
        /// <p>The list of names of Config rules that you want to run remediation execution for.</p>
        pub fn config_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_rule_name = Some(input.into());
            self
        }
        /// <p>The list of names of Config rules that you want to run remediation execution for.</p>
        pub fn set_config_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.config_rule_name = input;
            self
        }
        /// Appends an item to `resource_keys`.
        ///
        /// To override the contents of this collection use [`set_resource_keys`](Self::set_resource_keys).
        ///
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
        pub fn resource_keys(mut self, input: crate::model::ResourceKey) -> Self {
            let mut v = self.resource_keys.unwrap_or_default();
            v.push(input);
            self.resource_keys = Some(v);
            self
        }
        /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
        pub fn set_resource_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
        ) -> Self {
            self.resource_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`StartRemediationExecutionInput`](crate::input::StartRemediationExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartRemediationExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartRemediationExecutionInput {
                config_rule_name: self.config_rule_name,
                resource_keys: self.resource_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type StartRemediationExecutionInputOperationOutputAlias =
    crate::operation::StartRemediationExecution;
#[doc(hidden)]
pub type StartRemediationExecutionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartRemediationExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StartRemediationExecution`](crate::operation::StartRemediationExecution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartRemediationExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartRemediationExecutionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartRemediationExecutionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.StartRemediationExecution",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_remediation_execution(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartRemediationExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartRemediationExecution",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartRemediationExecutionInput`](crate::input::StartRemediationExecutionInput)
    pub fn builder() -> crate::input::start_remediation_execution_input::Builder {
        crate::input::start_remediation_execution_input::Builder::default()
    }
}

/// See [`StopConfigurationRecorderInput`](crate::input::StopConfigurationRecorderInput)
pub mod stop_configuration_recorder_input {
    /// A builder for [`StopConfigurationRecorderInput`](crate::input::StopConfigurationRecorderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_recorder_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
        pub fn configuration_recorder_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.configuration_recorder_name = Some(input.into());
            self
        }
        /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
        pub fn set_configuration_recorder_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_recorder_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StopConfigurationRecorderInput`](crate::input::StopConfigurationRecorderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopConfigurationRecorderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopConfigurationRecorderInput {
                configuration_recorder_name: self.configuration_recorder_name,
            })
        }
    }
}
#[doc(hidden)]
pub type StopConfigurationRecorderInputOperationOutputAlias =
    crate::operation::StopConfigurationRecorder;
#[doc(hidden)]
pub type StopConfigurationRecorderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopConfigurationRecorderInput {
    /// Consumes the builder and constructs an Operation<[`StopConfigurationRecorder`](crate::operation::StopConfigurationRecorder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopConfigurationRecorder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StopConfigurationRecorderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StopConfigurationRecorderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.StopConfigurationRecorder",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_configuration_recorder(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopConfigurationRecorder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopConfigurationRecorder",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StopConfigurationRecorderInput`](crate::input::StopConfigurationRecorderInput)
    pub fn builder() -> crate::input::stop_configuration_recorder_input::Builder {
        crate::input::stop_configuration_recorder_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tag object.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of tag object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.TagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "StarlingDoveService.UntagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "configservice",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The keys of the tags to be removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An array of tag object.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An array of tag object.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>The input for the <code>StopConfigurationRecorder</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopConfigurationRecorderInput {
    /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
    pub configuration_recorder_name: std::option::Option<std::string::String>,
}
impl StopConfigurationRecorderInput {
    /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
    pub fn configuration_recorder_name(&self) -> std::option::Option<&str> {
        self.configuration_recorder_name.as_deref()
    }
}
impl std::fmt::Debug for StopConfigurationRecorderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopConfigurationRecorderInput");
        formatter.field(
            "configuration_recorder_name",
            &self.configuration_recorder_name,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartRemediationExecutionInput {
    /// <p>The list of names of Config rules that you want to run remediation execution for.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
    pub resource_keys: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
}
impl StartRemediationExecutionInput {
    /// <p>The list of names of Config rules that you want to run remediation execution for.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
    pub fn resource_keys(&self) -> std::option::Option<&[crate::model::ResourceKey]> {
        self.resource_keys.as_deref()
    }
}
impl std::fmt::Debug for StartRemediationExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartRemediationExecutionInput");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("resource_keys", &self.resource_keys);
        formatter.finish()
    }
}

/// <p>The input for the <code>StartConfigurationRecorder</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartConfigurationRecorderInput {
    /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
    pub configuration_recorder_name: std::option::Option<std::string::String>,
}
impl StartConfigurationRecorderInput {
    /// <p>The name of the recorder object that records each configuration change made to the resources.</p>
    pub fn configuration_recorder_name(&self) -> std::option::Option<&str> {
        self.configuration_recorder_name.as_deref()
    }
}
impl std::fmt::Debug for StartConfigurationRecorderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartConfigurationRecorderInput");
        formatter.field(
            "configuration_recorder_name",
            &self.configuration_recorder_name,
        );
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartConfigRulesEvaluationInput {
    /// <p>The list of names of Config rules that you want to run evaluations for.</p>
    pub config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl StartConfigRulesEvaluationInput {
    /// <p>The list of names of Config rules that you want to run evaluations for.</p>
    pub fn config_rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.config_rule_names.as_deref()
    }
}
impl std::fmt::Debug for StartConfigRulesEvaluationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartConfigRulesEvaluationInput");
        formatter.field("config_rule_names", &self.config_rule_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelectResourceConfigInput {
    /// <p>The SQL query <code>SELECT</code> command.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The maximum number of query results returned on each page. </p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SelectResourceConfigInput {
    /// <p>The SQL query <code>SELECT</code> command.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>The maximum number of query results returned on each page. </p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SelectResourceConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelectResourceConfigInput");
        formatter.field("expression", &self.expression);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelectAggregateResourceConfigInput {
    /// <p>The SQL query SELECT command. </p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of query results returned on each page. </p>
    pub limit: i32,
    /// <p>The maximum number of query results returned on each page. Config also allows the Limit request parameter.</p>
    pub max_results: i32,
    /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SelectAggregateResourceConfigInput {
    /// <p>The SQL query SELECT command. </p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>The maximum number of query results returned on each page. </p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The maximum number of query results returned on each page. Config also allows the Limit request parameter.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SelectAggregateResourceConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelectAggregateResourceConfigInput");
        formatter.field("expression", &self.expression);
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field("limit", &self.limit);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutStoredQueryInput {
    /// <p>A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and <code>Expression</code>.</p> <note>
    /// <p>When you are creating a query, you must provide a query name and an expression. When you are updating a query, you must provide a query name but updating the description is optional.</p>
    /// </note>
    pub stored_query: std::option::Option<crate::model::StoredQuery>,
    /// <p>A list of <code>Tags</code> object.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl PutStoredQueryInput {
    /// <p>A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and <code>Expression</code>.</p> <note>
    /// <p>When you are creating a query, you must provide a query name and an expression. When you are updating a query, you must provide a query name but updating the description is optional.</p>
    /// </note>
    pub fn stored_query(&self) -> std::option::Option<&crate::model::StoredQuery> {
        self.stored_query.as_ref()
    }
    /// <p>A list of <code>Tags</code> object.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutStoredQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutStoredQueryInput");
        formatter.field("stored_query", &self.stored_query);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRetentionConfigurationInput {
    /// <p>Number of days Config stores your historical information.</p> <note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    pub retention_period_in_days: i32,
}
impl PutRetentionConfigurationInput {
    /// <p>Number of days Config stores your historical information.</p> <note>
    /// <p>Currently, only applicable to the configuration item history.</p>
    /// </note>
    pub fn retention_period_in_days(&self) -> i32 {
        self.retention_period_in_days
    }
}
impl std::fmt::Debug for PutRetentionConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRetentionConfigurationInput");
        formatter.field("retention_period_in_days", &self.retention_period_in_days);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourceConfigInput {
    /// <p>The type of the resource. The custom resource type must be registered with CloudFormation. </p> <note>
    /// <p>You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the first part of the ResourceType up to the first ::.</p>
    /// </note>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Version of the schema registered for the ResourceType in CloudFormation.</p>
    pub schema_version_id: std::option::Option<std::string::String>,
    /// <p>Unique identifier of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Name of the resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The configuration object of the resource in valid JSON format. It must match the schema registered with CloudFormation.</p> <note>
    /// <p>The configuration JSON must not exceed 64 KB.</p>
    /// </note>
    pub configuration: std::option::Option<std::string::String>,
    /// <p>Tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PutResourceConfigInput {
    /// <p>The type of the resource. The custom resource type must be registered with CloudFormation. </p> <note>
    /// <p>You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the first part of the ResourceType up to the first ::.</p>
    /// </note>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Version of the schema registered for the ResourceType in CloudFormation.</p>
    pub fn schema_version_id(&self) -> std::option::Option<&str> {
        self.schema_version_id.as_deref()
    }
    /// <p>Unique identifier of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Name of the resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The configuration object of the resource in valid JSON format. It must match the schema registered with CloudFormation.</p> <note>
    /// <p>The configuration JSON must not exceed 64 KB.</p>
    /// </note>
    pub fn configuration(&self) -> std::option::Option<&str> {
        self.configuration.as_deref()
    }
    /// <p>Tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for PutResourceConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourceConfigInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("schema_version_id", &self.schema_version_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_name", &self.resource_name);
        formatter.field("configuration", &self.configuration);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRemediationExceptionsInput {
    /// <p>The name of the Config rule for which you want to create remediation exception.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
    pub resource_keys:
        std::option::Option<std::vec::Vec<crate::model::RemediationExceptionResourceKey>>,
    /// <p>The message contains an explanation of the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The exception is automatically deleted after the expiration date.</p>
    pub expiration_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl PutRemediationExceptionsInput {
    /// <p>The name of the Config rule for which you want to create remediation exception.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
    pub fn resource_keys(
        &self,
    ) -> std::option::Option<&[crate::model::RemediationExceptionResourceKey]> {
        self.resource_keys.as_deref()
    }
    /// <p>The message contains an explanation of the exception.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The exception is automatically deleted after the expiration date.</p>
    pub fn expiration_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration_time.as_ref()
    }
}
impl std::fmt::Debug for PutRemediationExceptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRemediationExceptionsInput");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("resource_keys", &self.resource_keys);
        formatter.field("message", &self.message);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRemediationConfigurationsInput {
    /// <p>A list of remediation configuration objects.</p>
    pub remediation_configurations:
        std::option::Option<std::vec::Vec<crate::model::RemediationConfiguration>>,
}
impl PutRemediationConfigurationsInput {
    /// <p>A list of remediation configuration objects.</p>
    pub fn remediation_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::RemediationConfiguration]> {
        self.remediation_configurations.as_deref()
    }
}
impl std::fmt::Debug for PutRemediationConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRemediationConfigurationsInput");
        formatter.field(
            "remediation_configurations",
            &self.remediation_configurations,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutOrganizationConformancePackInput {
    /// <p>Name of the organization conformance pack you want to create.</p>
    pub organization_conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).</p> <note>
    /// <p>You must have access to read Amazon S3 bucket.</p>
    /// </note>
    pub template_s3_uri: std::option::Option<std::string::String>,
    /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
    /// <p>This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.</p>
    /// </note>
    pub delivery_s3_bucket: std::option::Option<std::string::String>,
    /// <p>The prefix for the Amazon S3 bucket.</p> <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub delivery_s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub conformance_pack_input_parameters:
        std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
    /// <p>A list of Amazon Web Services accounts to be excluded from an organization conformance pack while deploying a conformance pack.</p>
    pub excluded_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PutOrganizationConformancePackInput {
    /// <p>Name of the organization conformance pack you want to create.</p>
    pub fn organization_conformance_pack_name(&self) -> std::option::Option<&str> {
        self.organization_conformance_pack_name.as_deref()
    }
    /// <p>Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).</p> <note>
    /// <p>You must have access to read Amazon S3 bucket.</p>
    /// </note>
    pub fn template_s3_uri(&self) -> std::option::Option<&str> {
        self.template_s3_uri.as_deref()
    }
    /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
    /// <p>This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.</p>
    /// </note>
    pub fn delivery_s3_bucket(&self) -> std::option::Option<&str> {
        self.delivery_s3_bucket.as_deref()
    }
    /// <p>The prefix for the Amazon S3 bucket.</p> <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_key_prefix(&self) -> std::option::Option<&str> {
        self.delivery_s3_key_prefix.as_deref()
    }
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub fn conformance_pack_input_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::ConformancePackInputParameter]> {
        self.conformance_pack_input_parameters.as_deref()
    }
    /// <p>A list of Amazon Web Services accounts to be excluded from an organization conformance pack while deploying a conformance pack.</p>
    pub fn excluded_accounts(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_accounts.as_deref()
    }
}
impl std::fmt::Debug for PutOrganizationConformancePackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutOrganizationConformancePackInput");
        formatter.field(
            "organization_conformance_pack_name",
            &self.organization_conformance_pack_name,
        );
        formatter.field("template_s3_uri", &self.template_s3_uri);
        formatter.field("template_body", &self.template_body);
        formatter.field("delivery_s3_bucket", &self.delivery_s3_bucket);
        formatter.field("delivery_s3_key_prefix", &self.delivery_s3_key_prefix);
        formatter.field(
            "conformance_pack_input_parameters",
            &self.conformance_pack_input_parameters,
        );
        formatter.field("excluded_accounts", &self.excluded_accounts);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutOrganizationConfigRuleInput {
    /// <p>The name that you assign to an organization Config rule.</p>
    pub organization_config_rule_name: std::option::Option<std::string::String>,
    /// <p>An <code>OrganizationManagedRuleMetadata</code> object. </p>
    pub organization_managed_rule_metadata:
        std::option::Option<crate::model::OrganizationManagedRuleMetadata>,
    /// <p>An <code>OrganizationCustomRuleMetadata</code> object.</p>
    pub organization_custom_rule_metadata:
        std::option::Option<crate::model::OrganizationCustomRuleMetadata>,
    /// <p>A comma-separated list of accounts that you want to exclude from an organization Config rule.</p>
    pub excluded_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An object that specifies metadata for your organization's Config Custom Policy rule. The metadata includes the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as resource type, resource ID of Amazon Web Services resource, and organization trigger types that initiate Config to evaluate Amazon Web Services resources against a rule.</p>
    pub organization_custom_policy_rule_metadata:
        std::option::Option<crate::model::OrganizationCustomPolicyRuleMetadata>,
}
impl PutOrganizationConfigRuleInput {
    /// <p>The name that you assign to an organization Config rule.</p>
    pub fn organization_config_rule_name(&self) -> std::option::Option<&str> {
        self.organization_config_rule_name.as_deref()
    }
    /// <p>An <code>OrganizationManagedRuleMetadata</code> object. </p>
    pub fn organization_managed_rule_metadata(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationManagedRuleMetadata> {
        self.organization_managed_rule_metadata.as_ref()
    }
    /// <p>An <code>OrganizationCustomRuleMetadata</code> object.</p>
    pub fn organization_custom_rule_metadata(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationCustomRuleMetadata> {
        self.organization_custom_rule_metadata.as_ref()
    }
    /// <p>A comma-separated list of accounts that you want to exclude from an organization Config rule.</p>
    pub fn excluded_accounts(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_accounts.as_deref()
    }
    /// <p>An object that specifies metadata for your organization's Config Custom Policy rule. The metadata includes the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as resource type, resource ID of Amazon Web Services resource, and organization trigger types that initiate Config to evaluate Amazon Web Services resources against a rule.</p>
    pub fn organization_custom_policy_rule_metadata(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationCustomPolicyRuleMetadata> {
        self.organization_custom_policy_rule_metadata.as_ref()
    }
}
impl std::fmt::Debug for PutOrganizationConfigRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutOrganizationConfigRuleInput");
        formatter.field(
            "organization_config_rule_name",
            &self.organization_config_rule_name,
        );
        formatter.field(
            "organization_managed_rule_metadata",
            &self.organization_managed_rule_metadata,
        );
        formatter.field(
            "organization_custom_rule_metadata",
            &self.organization_custom_rule_metadata,
        );
        formatter.field("excluded_accounts", &self.excluded_accounts);
        formatter.field(
            "organization_custom_policy_rule_metadata",
            &self.organization_custom_policy_rule_metadata,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutExternalEvaluationInput {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>An <code>ExternalEvaluation</code> object that provides details about compliance.</p>
    pub external_evaluation: std::option::Option<crate::model::ExternalEvaluation>,
}
impl PutExternalEvaluationInput {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>An <code>ExternalEvaluation</code> object that provides details about compliance.</p>
    pub fn external_evaluation(&self) -> std::option::Option<&crate::model::ExternalEvaluation> {
        self.external_evaluation.as_ref()
    }
}
impl std::fmt::Debug for PutExternalEvaluationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutExternalEvaluationInput");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("external_evaluation", &self.external_evaluation);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEvaluationsInput {
    /// <p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>
    pub evaluations: std::option::Option<std::vec::Vec<crate::model::Evaluation>>,
    /// <p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>
    pub result_token: std::option::Option<std::string::String>,
    /// <p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p> <note>
    /// <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p>
    /// </note>
    pub test_mode: bool,
}
impl PutEvaluationsInput {
    /// <p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>
    pub fn evaluations(&self) -> std::option::Option<&[crate::model::Evaluation]> {
        self.evaluations.as_deref()
    }
    /// <p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>
    pub fn result_token(&self) -> std::option::Option<&str> {
        self.result_token.as_deref()
    }
    /// <p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p> <note>
    /// <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p>
    /// </note>
    pub fn test_mode(&self) -> bool {
        self.test_mode
    }
}
impl std::fmt::Debug for PutEvaluationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEvaluationsInput");
        formatter.field("evaluations", &self.evaluations);
        formatter.field("result_token", &self.result_token);
        formatter.field("test_mode", &self.test_mode);
        formatter.finish()
    }
}

/// <p>The input for the <code>PutDeliveryChannel</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDeliveryChannelInput {
    /// <p>The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket and to an Amazon SNS topic.</p>
    pub delivery_channel: std::option::Option<crate::model::DeliveryChannel>,
}
impl PutDeliveryChannelInput {
    /// <p>The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket and to an Amazon SNS topic.</p>
    pub fn delivery_channel(&self) -> std::option::Option<&crate::model::DeliveryChannel> {
        self.delivery_channel.as_ref()
    }
}
impl std::fmt::Debug for PutDeliveryChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDeliveryChannelInput");
        formatter.field("delivery_channel", &self.delivery_channel);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConformancePackInput {
    /// <p>Name of the conformance pack you want to create.</p>
    pub conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>Location of file containing the template body (<code>s3://bucketname/prefix</code>). The uri must point to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same region as the conformance pack. </p> <note>
    /// <p>You must have access to read Amazon S3 bucket.</p>
    /// </note>
    pub template_s3_uri: std::option::Option<std::string::String>,
    /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p> <note>
    /// <p>You can only use a YAML template with two resource types: Config rule (<code>AWS::Config::ConfigRule</code>) and a remediation action (<code>AWS::Config::RemediationConfiguration</code>).</p>
    /// </note>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub delivery_s3_bucket: std::option::Option<std::string::String>,
    /// <p>The prefix for the Amazon S3 bucket. </p> <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub delivery_s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub conformance_pack_input_parameters:
        std::option::Option<std::vec::Vec<crate::model::ConformancePackInputParameter>>,
}
impl PutConformancePackInput {
    /// <p>Name of the conformance pack you want to create.</p>
    pub fn conformance_pack_name(&self) -> std::option::Option<&str> {
        self.conformance_pack_name.as_deref()
    }
    /// <p>Location of file containing the template body (<code>s3://bucketname/prefix</code>). The uri must point to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same region as the conformance pack. </p> <note>
    /// <p>You must have access to read Amazon S3 bucket.</p>
    /// </note>
    pub fn template_s3_uri(&self) -> std::option::Option<&str> {
        self.template_s3_uri.as_deref()
    }
    /// <p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p> <note>
    /// <p>You can only use a YAML template with two resource types: Config rule (<code>AWS::Config::ConfigRule</code>) and a remediation action (<code>AWS::Config::RemediationConfiguration</code>).</p>
    /// </note>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_bucket(&self) -> std::option::Option<&str> {
        self.delivery_s3_bucket.as_deref()
    }
    /// <p>The prefix for the Amazon S3 bucket. </p> <note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_key_prefix(&self) -> std::option::Option<&str> {
        self.delivery_s3_key_prefix.as_deref()
    }
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub fn conformance_pack_input_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::ConformancePackInputParameter]> {
        self.conformance_pack_input_parameters.as_deref()
    }
}
impl std::fmt::Debug for PutConformancePackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConformancePackInput");
        formatter.field("conformance_pack_name", &self.conformance_pack_name);
        formatter.field("template_s3_uri", &self.template_s3_uri);
        formatter.field("template_body", &self.template_body);
        formatter.field("delivery_s3_bucket", &self.delivery_s3_bucket);
        formatter.field("delivery_s3_key_prefix", &self.delivery_s3_key_prefix);
        formatter.field(
            "conformance_pack_input_parameters",
            &self.conformance_pack_input_parameters,
        );
        formatter.finish()
    }
}

/// <p>The input for the <code>PutConfigurationRecorder</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConfigurationRecorderInput {
    /// <p>The configuration recorder object that records each configuration change made to the resources.</p>
    pub configuration_recorder: std::option::Option<crate::model::ConfigurationRecorder>,
}
impl PutConfigurationRecorderInput {
    /// <p>The configuration recorder object that records each configuration change made to the resources.</p>
    pub fn configuration_recorder(
        &self,
    ) -> std::option::Option<&crate::model::ConfigurationRecorder> {
        self.configuration_recorder.as_ref()
    }
}
impl std::fmt::Debug for PutConfigurationRecorderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConfigurationRecorderInput");
        formatter.field("configuration_recorder", &self.configuration_recorder);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConfigurationAggregatorInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>A list of AccountAggregationSource object. </p>
    pub account_aggregation_sources:
        std::option::Option<std::vec::Vec<crate::model::AccountAggregationSource>>,
    /// <p>An OrganizationAggregationSource object.</p>
    pub organization_aggregation_source:
        std::option::Option<crate::model::OrganizationAggregationSource>,
    /// <p>An array of tag object.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl PutConfigurationAggregatorInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>A list of AccountAggregationSource object. </p>
    pub fn account_aggregation_sources(
        &self,
    ) -> std::option::Option<&[crate::model::AccountAggregationSource]> {
        self.account_aggregation_sources.as_deref()
    }
    /// <p>An OrganizationAggregationSource object.</p>
    pub fn organization_aggregation_source(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationAggregationSource> {
        self.organization_aggregation_source.as_ref()
    }
    /// <p>An array of tag object.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutConfigurationAggregatorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConfigurationAggregatorInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field(
            "account_aggregation_sources",
            &self.account_aggregation_sources,
        );
        formatter.field(
            "organization_aggregation_source",
            &self.organization_aggregation_source,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConfigRuleInput {
    /// <p>The rule that you want to add to your account.</p>
    pub config_rule: std::option::Option<crate::model::ConfigRule>,
    /// <p>An array of tag object.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl PutConfigRuleInput {
    /// <p>The rule that you want to add to your account.</p>
    pub fn config_rule(&self) -> std::option::Option<&crate::model::ConfigRule> {
        self.config_rule.as_ref()
    }
    /// <p>An array of tag object.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutConfigRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConfigRuleInput");
        formatter.field("config_rule", &self.config_rule);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAggregationAuthorizationInput {
    /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
    pub authorized_account_id: std::option::Option<std::string::String>,
    /// <p>The region authorized to collect aggregated data.</p>
    pub authorized_aws_region: std::option::Option<std::string::String>,
    /// <p>An array of tag object.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl PutAggregationAuthorizationInput {
    /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
    pub fn authorized_account_id(&self) -> std::option::Option<&str> {
        self.authorized_account_id.as_deref()
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn authorized_aws_region(&self) -> std::option::Option<&str> {
        self.authorized_aws_region.as_deref()
    }
    /// <p>An array of tag object.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutAggregationAuthorizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAggregationAuthorizationInput");
        formatter.field("authorized_account_id", &self.authorized_account_id);
        formatter.field("authorized_aws_region", &self.authorized_aws_region);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default. </p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default. </p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStoredQueriesInput {
    /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned with a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListStoredQueriesInput {
    /// <p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned with a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListStoredQueriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStoredQueriesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDiscoveredResourcesInput {
    /// <p>The type of resources that you want Config to list in the response.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The IDs of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
    pub resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The custom name of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>Specifies whether Config includes deleted resources in the results. By default, deleted resources are not included.</p>
    pub include_deleted_resources: bool,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDiscoveredResourcesInput {
    /// <p>The type of resources that you want Config to list in the response.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The IDs of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
    pub fn resource_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_ids.as_deref()
    }
    /// <p>The custom name of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>Specifies whether Config includes deleted resources in the results. By default, deleted resources are not included.</p>
    pub fn include_deleted_resources(&self) -> bool {
        self.include_deleted_resources
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDiscoveredResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDiscoveredResourcesInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_ids", &self.resource_ids);
        formatter.field("resource_name", &self.resource_name);
        formatter.field("limit", &self.limit);
        formatter.field("include_deleted_resources", &self.include_deleted_resources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAggregateDiscoveredResourcesInput {
    /// <p>The name of the configuration aggregator. </p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>The type of resources that you want Config to list in the response.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Filters the results based on the <code>ResourceFilters</code> object.</p>
    pub filters: std::option::Option<crate::model::ResourceFilters>,
    /// <p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAggregateDiscoveredResourcesInput {
    /// <p>The name of the configuration aggregator. </p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>The type of resources that you want Config to list in the response.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Filters the results based on the <code>ResourceFilters</code> object.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ResourceFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAggregateDiscoveredResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAggregateDiscoveredResourcesInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field("resource_type", &self.resource_type);
        formatter.field("filters", &self.filters);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStoredQueryInput {
    /// <p>The name of the query.</p>
    pub query_name: std::option::Option<std::string::String>,
}
impl GetStoredQueryInput {
    /// <p>The name of the query.</p>
    pub fn query_name(&self) -> std::option::Option<&str> {
        self.query_name.as_deref()
    }
}
impl std::fmt::Debug for GetStoredQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStoredQueryInput");
        formatter.field("query_name", &self.query_name);
        formatter.finish()
    }
}

/// <p>The input for the <code>GetResourceConfigHistory</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceConfigHistoryInput {
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The time stamp that indicates a later time. If not specified, current time is taken.</p>
    pub later_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time stamp that indicates an earlier time. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
    pub earlier_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
    pub chronological_order: std::option::Option<crate::model::ChronologicalOrder>,
    /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetResourceConfigHistoryInput {
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The time stamp that indicates a later time. If not specified, current time is taken.</p>
    pub fn later_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.later_time.as_ref()
    }
    /// <p>The time stamp that indicates an earlier time. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
    pub fn earlier_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.earlier_time.as_ref()
    }
    /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
    pub fn chronological_order(&self) -> std::option::Option<&crate::model::ChronologicalOrder> {
        self.chronological_order.as_ref()
    }
    /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetResourceConfigHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceConfigHistoryInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("later_time", &self.later_time);
        formatter.field("earlier_time", &self.earlier_time);
        formatter.field("chronological_order", &self.chronological_order);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOrganizationCustomRulePolicyInput {
    /// <p>The name of your organization Config Custom Policy rule. </p>
    pub organization_config_rule_name: std::option::Option<std::string::String>,
}
impl GetOrganizationCustomRulePolicyInput {
    /// <p>The name of your organization Config Custom Policy rule. </p>
    pub fn organization_config_rule_name(&self) -> std::option::Option<&str> {
        self.organization_config_rule_name.as_deref()
    }
}
impl std::fmt::Debug for GetOrganizationCustomRulePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOrganizationCustomRulePolicyInput");
        formatter.field(
            "organization_config_rule_name",
            &self.organization_config_rule_name,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOrganizationConformancePackDetailedStatusInput {
    /// <p>The name of organization conformance pack for which you want status details for member accounts.</p>
    pub organization_conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>An <code>OrganizationResourceDetailedStatusFilters</code> object.</p>
    pub filters: std::option::Option<crate::model::OrganizationResourceDetailedStatusFilters>,
    /// <p>The maximum number of <code>OrganizationConformancePackDetailedStatuses</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100. </p>
    pub limit: i32,
    /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetOrganizationConformancePackDetailedStatusInput {
    /// <p>The name of organization conformance pack for which you want status details for member accounts.</p>
    pub fn organization_conformance_pack_name(&self) -> std::option::Option<&str> {
        self.organization_conformance_pack_name.as_deref()
    }
    /// <p>An <code>OrganizationResourceDetailedStatusFilters</code> object.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationResourceDetailedStatusFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of <code>OrganizationConformancePackDetailedStatuses</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100. </p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetOrganizationConformancePackDetailedStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOrganizationConformancePackDetailedStatusInput");
        formatter.field(
            "organization_conformance_pack_name",
            &self.organization_conformance_pack_name,
        );
        formatter.field("filters", &self.filters);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOrganizationConfigRuleDetailedStatusInput {
    /// <p>The name of your organization Config rule for which you want status details for member accounts.</p>
    pub organization_config_rule_name: std::option::Option<std::string::String>,
    /// <p>A <code>StatusDetailFilters</code> object.</p>
    pub filters: std::option::Option<crate::model::StatusDetailFilters>,
    /// <p>The maximum number of <code>OrganizationConfigRuleDetailedStatus</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetOrganizationConfigRuleDetailedStatusInput {
    /// <p>The name of your organization Config rule for which you want status details for member accounts.</p>
    pub fn organization_config_rule_name(&self) -> std::option::Option<&str> {
        self.organization_config_rule_name.as_deref()
    }
    /// <p>A <code>StatusDetailFilters</code> object.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::StatusDetailFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of <code>OrganizationConfigRuleDetailedStatus</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetOrganizationConfigRuleDetailedStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOrganizationConfigRuleDetailedStatusInput");
        formatter.field(
            "organization_config_rule_name",
            &self.organization_config_rule_name,
        );
        formatter.field("filters", &self.filters);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDiscoveredResourceCountsInput {
    /// <p>The comma-separated list that specifies the resource types that you want Config to return (for example, <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).</p>
    /// <p>If a value for <code>resourceTypes</code> is not specified, Config returns all resource types that Config is recording in the region for your account.</p> <note>
    /// <p>If the configuration recorder is turned off, Config returns an empty list of <code>ResourceCount</code> objects. If the configuration recorder is not recording a specific resource type (for example, S3 buckets), that resource type is not returned in the list of <code>ResourceCount</code> objects.</p>
    /// </note>
    pub resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of <code>ResourceCount</code> objects returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDiscoveredResourceCountsInput {
    /// <p>The comma-separated list that specifies the resource types that you want Config to return (for example, <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).</p>
    /// <p>If a value for <code>resourceTypes</code> is not specified, Config returns all resource types that Config is recording in the region for your account.</p> <note>
    /// <p>If the configuration recorder is turned off, Config returns an empty list of <code>ResourceCount</code> objects. If the configuration recorder is not recording a specific resource type (for example, S3 buckets), that resource type is not returned in the list of <code>ResourceCount</code> objects.</p>
    /// </note>
    pub fn resource_types(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_types.as_deref()
    }
    /// <p>The maximum number of <code>ResourceCount</code> objects returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDiscoveredResourceCountsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDiscoveredResourceCountsInput");
        formatter.field("resource_types", &self.resource_types);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCustomRulePolicyInput {
    /// <p>The name of your Config Custom Policy rule.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
}
impl GetCustomRulePolicyInput {
    /// <p>The name of your Config Custom Policy rule.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
}
impl std::fmt::Debug for GetCustomRulePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCustomRulePolicyInput");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConformancePackComplianceSummaryInput {
    /// <p>Names of conformance packs.</p>
    pub conformance_pack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of conformance packs returned on each page.</p>
    pub limit: i32,
    /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetConformancePackComplianceSummaryInput {
    /// <p>Names of conformance packs.</p>
    pub fn conformance_pack_names(&self) -> std::option::Option<&[std::string::String]> {
        self.conformance_pack_names.as_deref()
    }
    /// <p>The maximum number of conformance packs returned on each page.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetConformancePackComplianceSummaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConformancePackComplianceSummaryInput");
        formatter.field("conformance_pack_names", &self.conformance_pack_names);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConformancePackComplianceDetailsInput {
    /// <p>Name of the conformance pack.</p>
    pub conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>A <code>ConformancePackEvaluationFilters</code> object.</p>
    pub filters: std::option::Option<crate::model::ConformancePackEvaluationFilters>,
    /// <p>The maximum number of evaluation results returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetConformancePackComplianceDetailsInput {
    /// <p>Name of the conformance pack.</p>
    pub fn conformance_pack_name(&self) -> std::option::Option<&str> {
        self.conformance_pack_name.as_deref()
    }
    /// <p>A <code>ConformancePackEvaluationFilters</code> object.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ConformancePackEvaluationFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of evaluation results returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetConformancePackComplianceDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConformancePackComplianceDetailsInput");
        formatter.field("conformance_pack_name", &self.conformance_pack_name);
        formatter.field("filters", &self.filters);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComplianceSummaryByResourceTypeInput {
    /// <p>Specify one or more resource types to get the number of resources that are compliant and the number that are noncompliant for each resource type.</p>
    /// <p>For this request, you can specify an Amazon Web Services resource type such as <code>AWS::EC2::Instance</code>. You can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
    pub resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetComplianceSummaryByResourceTypeInput {
    /// <p>Specify one or more resource types to get the number of resources that are compliant and the number that are noncompliant for each resource type.</p>
    /// <p>For this request, you can specify an Amazon Web Services resource type such as <code>AWS::EC2::Instance</code>. You can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
    pub fn resource_types(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_types.as_deref()
    }
}
impl std::fmt::Debug for GetComplianceSummaryByResourceTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComplianceSummaryByResourceTypeInput");
        formatter.field("resource_types", &self.resource_types);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComplianceSummaryByConfigRuleInput {}
impl std::fmt::Debug for GetComplianceSummaryByConfigRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComplianceSummaryByConfigRuleInput");
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComplianceDetailsByResourceInput {
    /// <p>The type of the Amazon Web Services resource for which you want compliance information.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services resource for which you want compliance information.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
    pub compliance_types: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetComplianceDetailsByResourceInput {
    /// <p>The type of the Amazon Web Services resource for which you want compliance information.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The ID of the Amazon Web Services resource for which you want compliance information.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
    pub fn compliance_types(&self) -> std::option::Option<&[crate::model::ComplianceType]> {
        self.compliance_types.as_deref()
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetComplianceDetailsByResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComplianceDetailsByResourceInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("compliance_types", &self.compliance_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComplianceDetailsByConfigRuleInput {
    /// <p>The name of the Config rule for which you want compliance information.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
    pub compliance_types: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
    /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetComplianceDetailsByConfigRuleInput {
    /// <p>The name of the Config rule for which you want compliance information.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>
    pub fn compliance_types(&self) -> std::option::Option<&[crate::model::ComplianceType]> {
        self.compliance_types.as_deref()
    }
    /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetComplianceDetailsByConfigRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComplianceDetailsByConfigRuleInput");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("compliance_types", &self.compliance_types);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAggregateResourceConfigInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>An object that identifies aggregate resource.</p>
    pub resource_identifier: std::option::Option<crate::model::AggregateResourceIdentifier>,
}
impl GetAggregateResourceConfigInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>An object that identifies aggregate resource.</p>
    pub fn resource_identifier(
        &self,
    ) -> std::option::Option<&crate::model::AggregateResourceIdentifier> {
        self.resource_identifier.as_ref()
    }
}
impl std::fmt::Debug for GetAggregateResourceConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAggregateResourceConfigInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAggregateDiscoveredResourceCountsInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>Filters the results based on the <code>ResourceCountFilters</code> object.</p>
    pub filters: std::option::Option<crate::model::ResourceCountFilters>,
    /// <p>The key to group the resource counts.</p>
    pub group_by_key: std::option::Option<crate::model::ResourceCountGroupKey>,
    /// <p>The maximum number of <code>GroupedResourceCount</code> objects returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetAggregateDiscoveredResourceCountsInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>Filters the results based on the <code>ResourceCountFilters</code> object.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ResourceCountFilters> {
        self.filters.as_ref()
    }
    /// <p>The key to group the resource counts.</p>
    pub fn group_by_key(&self) -> std::option::Option<&crate::model::ResourceCountGroupKey> {
        self.group_by_key.as_ref()
    }
    /// <p>The maximum number of <code>GroupedResourceCount</code> objects returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetAggregateDiscoveredResourceCountsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAggregateDiscoveredResourceCountsInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field("filters", &self.filters);
        formatter.field("group_by_key", &self.group_by_key);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAggregateConformancePackComplianceSummaryInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>Filters the results based on the <code>AggregateConformancePackComplianceSummaryFilters</code> object.</p>
    pub filters:
        std::option::Option<crate::model::AggregateConformancePackComplianceSummaryFilters>,
    /// <p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>
    pub group_by_key:
        std::option::Option<crate::model::AggregateConformancePackComplianceSummaryGroupKey>,
    /// <p>The maximum number of results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetAggregateConformancePackComplianceSummaryInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>Filters the results based on the <code>AggregateConformancePackComplianceSummaryFilters</code> object.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&crate::model::AggregateConformancePackComplianceSummaryFilters> {
        self.filters.as_ref()
    }
    /// <p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>
    pub fn group_by_key(
        &self,
    ) -> std::option::Option<&crate::model::AggregateConformancePackComplianceSummaryGroupKey> {
        self.group_by_key.as_ref()
    }
    /// <p>The maximum number of results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetAggregateConformancePackComplianceSummaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAggregateConformancePackComplianceSummaryInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field("filters", &self.filters);
        formatter.field("group_by_key", &self.group_by_key);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAggregateConfigRuleComplianceSummaryInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>Filters the results based on the ConfigRuleComplianceSummaryFilters object.</p>
    pub filters: std::option::Option<crate::model::ConfigRuleComplianceSummaryFilters>,
    /// <p>Groups the result based on ACCOUNT_ID or AWS_REGION.</p>
    pub group_by_key: std::option::Option<crate::model::ConfigRuleComplianceSummaryGroupKey>,
    /// <p>The maximum number of evaluation results returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetAggregateConfigRuleComplianceSummaryInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>Filters the results based on the ConfigRuleComplianceSummaryFilters object.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&crate::model::ConfigRuleComplianceSummaryFilters> {
        self.filters.as_ref()
    }
    /// <p>Groups the result based on ACCOUNT_ID or AWS_REGION.</p>
    pub fn group_by_key(
        &self,
    ) -> std::option::Option<&crate::model::ConfigRuleComplianceSummaryGroupKey> {
        self.group_by_key.as_ref()
    }
    /// <p>The maximum number of evaluation results returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetAggregateConfigRuleComplianceSummaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAggregateConfigRuleComplianceSummaryInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field("filters", &self.filters);
        formatter.field("group_by_key", &self.group_by_key);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAggregateComplianceDetailsByConfigRuleInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>The name of the Config rule for which you want compliance information.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>The 12-digit account ID of the source account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The source region from where the data is aggregated.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>The resource compliance status.</p> <note>
    /// <p>For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, Config supports only the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.</p>
    /// </note>
    pub compliance_type: std::option::Option<crate::model::ComplianceType>,
    /// <p>The maximum number of evaluation results returned on each page. The default is 50. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetAggregateComplianceDetailsByConfigRuleInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>The name of the Config rule for which you want compliance information.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>The 12-digit account ID of the source account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The source region from where the data is aggregated.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>The resource compliance status.</p> <note>
    /// <p>For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, Config supports only the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.</p>
    /// </note>
    pub fn compliance_type(&self) -> std::option::Option<&crate::model::ComplianceType> {
        self.compliance_type.as_ref()
    }
    /// <p>The maximum number of evaluation results returned on each page. The default is 50. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetAggregateComplianceDetailsByConfigRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAggregateComplianceDetailsByConfigRuleInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("account_id", &self.account_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRetentionConfigurationsInput {
    /// <p>A list of names of retention configurations for which you want details. If you do not specify a name, Config returns details for all the retention configurations for that account.</p> <note>
    /// <p>Currently, Config supports only one retention configuration per region in your account.</p>
    /// </note>
    pub retention_configuration_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeRetentionConfigurationsInput {
    /// <p>A list of names of retention configurations for which you want details. If you do not specify a name, Config returns details for all the retention configurations for that account.</p> <note>
    /// <p>Currently, Config supports only one retention configuration per region in your account.</p>
    /// </note>
    pub fn retention_configuration_names(&self) -> std::option::Option<&[std::string::String]> {
        self.retention_configuration_names.as_deref()
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeRetentionConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRetentionConfigurationsInput");
        formatter.field(
            "retention_configuration_names",
            &self.retention_configuration_names,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRemediationExecutionStatusInput {
    /// <p>A list of Config rule names.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
    pub resource_keys: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
    /// <p>The maximum number of RemediationExecutionStatuses returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeRemediationExecutionStatusInput {
    /// <p>A list of Config rule names.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>
    pub fn resource_keys(&self) -> std::option::Option<&[crate::model::ResourceKey]> {
        self.resource_keys.as_deref()
    }
    /// <p>The maximum number of RemediationExecutionStatuses returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeRemediationExecutionStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRemediationExecutionStatusInput");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("resource_keys", &self.resource_keys);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRemediationExceptionsInput {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
    pub resource_keys:
        std::option::Option<std::vec::Vec<crate::model::RemediationExceptionResourceKey>>,
    /// <p>The maximum number of RemediationExceptionResourceKey returned on each page. The default is 25. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeRemediationExceptionsInput {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
    pub fn resource_keys(
        &self,
    ) -> std::option::Option<&[crate::model::RemediationExceptionResourceKey]> {
        self.resource_keys.as_deref()
    }
    /// <p>The maximum number of RemediationExceptionResourceKey returned on each page. The default is 25. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeRemediationExceptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRemediationExceptionsInput");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("resource_keys", &self.resource_keys);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRemediationConfigurationsInput {
    /// <p>A list of Config rule names of remediation configurations for which you want details. </p>
    pub config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeRemediationConfigurationsInput {
    /// <p>A list of Config rule names of remediation configurations for which you want details. </p>
    pub fn config_rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.config_rule_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeRemediationConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRemediationConfigurationsInput");
        formatter.field("config_rule_names", &self.config_rule_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePendingAggregationRequestsInput {
    /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribePendingAggregationRequestsInput {
    /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePendingAggregationRequestsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePendingAggregationRequestsInput");
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationConformancePackStatusesInput {
    /// <p>The names of organization conformance packs for which you want status details. If you do not specify any names, Config returns details for all your organization conformance packs. </p>
    pub organization_conformance_pack_names:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of OrganizationConformancePackStatuses returned on each page. If you do no specify a number, Config uses the default. The default is 100. </p>
    pub limit: i32,
    /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeOrganizationConformancePackStatusesInput {
    /// <p>The names of organization conformance packs for which you want status details. If you do not specify any names, Config returns details for all your organization conformance packs. </p>
    pub fn organization_conformance_pack_names(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.organization_conformance_pack_names.as_deref()
    }
    /// <p>The maximum number of OrganizationConformancePackStatuses returned on each page. If you do no specify a number, Config uses the default. The default is 100. </p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrganizationConformancePackStatusesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationConformancePackStatusesInput");
        formatter.field(
            "organization_conformance_pack_names",
            &self.organization_conformance_pack_names,
        );
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationConformancePacksInput {
    /// <p>The name that you assign to an organization conformance pack.</p>
    pub organization_conformance_pack_names:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of organization config packs returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub limit: i32,
    /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeOrganizationConformancePacksInput {
    /// <p>The name that you assign to an organization conformance pack.</p>
    pub fn organization_conformance_pack_names(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.organization_conformance_pack_names.as_deref()
    }
    /// <p>The maximum number of organization config packs returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrganizationConformancePacksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationConformancePacksInput");
        formatter.field(
            "organization_conformance_pack_names",
            &self.organization_conformance_pack_names,
        );
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationConfigRuleStatusesInput {
    /// <p>The names of organization Config rules for which you want status details. If you do not specify any names, Config returns details for all your organization Config rules.</p>
    pub organization_config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of <code>OrganizationConfigRuleStatuses</code> returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeOrganizationConfigRuleStatusesInput {
    /// <p>The names of organization Config rules for which you want status details. If you do not specify any names, Config returns details for all your organization Config rules.</p>
    pub fn organization_config_rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.organization_config_rule_names.as_deref()
    }
    /// <p>The maximum number of <code>OrganizationConfigRuleStatuses</code> returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrganizationConfigRuleStatusesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationConfigRuleStatusesInput");
        formatter.field(
            "organization_config_rule_names",
            &self.organization_config_rule_names,
        );
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationConfigRulesInput {
    /// <p>The names of organization Config rules for which you want details. If you do not specify any names, Config returns details for all your organization Config rules.</p>
    pub organization_config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of organization Config rules returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeOrganizationConfigRulesInput {
    /// <p>The names of organization Config rules for which you want details. If you do not specify any names, Config returns details for all your organization Config rules.</p>
    pub fn organization_config_rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.organization_config_rule_names.as_deref()
    }
    /// <p>The maximum number of organization Config rules returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrganizationConfigRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationConfigRulesInput");
        formatter.field(
            "organization_config_rule_names",
            &self.organization_config_rule_names,
        );
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The input for the <code>DeliveryChannelStatus</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeliveryChannelStatusInput {
    /// <p>A list of delivery channel names.</p>
    pub delivery_channel_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeDeliveryChannelStatusInput {
    /// <p>A list of delivery channel names.</p>
    pub fn delivery_channel_names(&self) -> std::option::Option<&[std::string::String]> {
        self.delivery_channel_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeDeliveryChannelStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeliveryChannelStatusInput");
        formatter.field("delivery_channel_names", &self.delivery_channel_names);
        formatter.finish()
    }
}

/// <p>The input for the <code>DescribeDeliveryChannels</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeliveryChannelsInput {
    /// <p>A list of delivery channel names.</p>
    pub delivery_channel_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeDeliveryChannelsInput {
    /// <p>A list of delivery channel names.</p>
    pub fn delivery_channel_names(&self) -> std::option::Option<&[std::string::String]> {
        self.delivery_channel_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeDeliveryChannelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeliveryChannelsInput");
        formatter.field("delivery_channel_names", &self.delivery_channel_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConformancePackStatusInput {
    /// <p>Comma-separated list of conformance pack names.</p>
    pub conformance_pack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of conformance packs status returned on each page.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeConformancePackStatusInput {
    /// <p>Comma-separated list of conformance pack names.</p>
    pub fn conformance_pack_names(&self) -> std::option::Option<&[std::string::String]> {
        self.conformance_pack_names.as_deref()
    }
    /// <p>The maximum number of conformance packs status returned on each page.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeConformancePackStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConformancePackStatusInput");
        formatter.field("conformance_pack_names", &self.conformance_pack_names);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConformancePacksInput {
    /// <p>Comma-separated list of conformance pack names for which you want details. If you do not specify any names, Config returns details for all your conformance packs. </p>
    pub conformance_pack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of conformance packs returned on each page.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeConformancePacksInput {
    /// <p>Comma-separated list of conformance pack names for which you want details. If you do not specify any names, Config returns details for all your conformance packs. </p>
    pub fn conformance_pack_names(&self) -> std::option::Option<&[std::string::String]> {
        self.conformance_pack_names.as_deref()
    }
    /// <p>The maximum number of conformance packs returned on each page.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeConformancePacksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConformancePacksInput");
        formatter.field("conformance_pack_names", &self.conformance_pack_names);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConformancePackComplianceInput {
    /// <p>Name of the conformance pack.</p>
    pub conformance_pack_name: std::option::Option<std::string::String>,
    /// <p>A <code>ConformancePackComplianceFilters</code> object.</p>
    pub filters: std::option::Option<crate::model::ConformancePackComplianceFilters>,
    /// <p>The maximum number of Config rules within a conformance pack are returned on each page.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeConformancePackComplianceInput {
    /// <p>Name of the conformance pack.</p>
    pub fn conformance_pack_name(&self) -> std::option::Option<&str> {
        self.conformance_pack_name.as_deref()
    }
    /// <p>A <code>ConformancePackComplianceFilters</code> object.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ConformancePackComplianceFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of Config rules within a conformance pack are returned on each page.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeConformancePackComplianceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConformancePackComplianceInput");
        formatter.field("conformance_pack_name", &self.conformance_pack_name);
        formatter.field("filters", &self.filters);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The input for the <code>DescribeConfigurationRecorderStatus</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationRecorderStatusInput {
    /// <p>The name(s) of the configuration recorder. If the name is not specified, the action returns the current status of all the configuration recorders associated with the account.</p>
    pub configuration_recorder_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeConfigurationRecorderStatusInput {
    /// <p>The name(s) of the configuration recorder. If the name is not specified, the action returns the current status of all the configuration recorders associated with the account.</p>
    pub fn configuration_recorder_names(&self) -> std::option::Option<&[std::string::String]> {
        self.configuration_recorder_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigurationRecorderStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationRecorderStatusInput");
        formatter.field(
            "configuration_recorder_names",
            &self.configuration_recorder_names,
        );
        formatter.finish()
    }
}

/// <p>The input for the <code>DescribeConfigurationRecorders</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationRecordersInput {
    /// <p>A list of configuration recorder names.</p>
    pub configuration_recorder_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeConfigurationRecordersInput {
    /// <p>A list of configuration recorder names.</p>
    pub fn configuration_recorder_names(&self) -> std::option::Option<&[std::string::String]> {
        self.configuration_recorder_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigurationRecordersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationRecordersInput");
        formatter.field(
            "configuration_recorder_names",
            &self.configuration_recorder_names,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationAggregatorSourcesStatusInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>Filters the status type.</p>
    /// <ul>
    /// <li> <p>Valid value FAILED indicates errors while moving data.</p> </li>
    /// <li> <p>Valid value SUCCEEDED indicates the data was successfully moved.</p> </li>
    /// <li> <p>Valid value OUTDATED indicates the data is not the most recent.</p> </li>
    /// </ul>
    pub update_status: std::option::Option<std::vec::Vec<crate::model::AggregatedSourceStatusType>>,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub limit: i32,
}
impl DescribeConfigurationAggregatorSourcesStatusInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>Filters the status type.</p>
    /// <ul>
    /// <li> <p>Valid value FAILED indicates errors while moving data.</p> </li>
    /// <li> <p>Valid value SUCCEEDED indicates the data was successfully moved.</p> </li>
    /// <li> <p>Valid value OUTDATED indicates the data is not the most recent.</p> </li>
    /// </ul>
    pub fn update_status(
        &self,
    ) -> std::option::Option<&[crate::model::AggregatedSourceStatusType]> {
        self.update_status.as_deref()
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
}
impl std::fmt::Debug for DescribeConfigurationAggregatorSourcesStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationAggregatorSourcesStatusInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field("update_status", &self.update_status);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationAggregatorsInput {
    /// <p>The name of the configuration aggregators.</p>
    pub configuration_aggregator_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of configuration aggregators returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub limit: i32,
}
impl DescribeConfigurationAggregatorsInput {
    /// <p>The name of the configuration aggregators.</p>
    pub fn configuration_aggregator_names(&self) -> std::option::Option<&[std::string::String]> {
        self.configuration_aggregator_names.as_deref()
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of configuration aggregators returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
}
impl std::fmt::Debug for DescribeConfigurationAggregatorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationAggregatorsInput");
        formatter.field(
            "configuration_aggregator_names",
            &self.configuration_aggregator_names,
        );
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigRulesInput {
    /// <p>The names of the Config rules for which you want details. If you do not specify any names, Config returns details for all your rules.</p>
    pub config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeConfigRulesInput {
    /// <p>The names of the Config rules for which you want details. If you do not specify any names, Config returns details for all your rules.</p>
    pub fn config_rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.config_rule_names.as_deref()
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigRulesInput");
        formatter.field("config_rule_names", &self.config_rule_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigRuleEvaluationStatusInput {
    /// <p>The name of the Config managed rules for which you want status information. If you do not specify any names, Config returns status information for all Config managed rules that you use.</p>
    pub config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of rule evaluation results that you want returned.</p>
    /// <p>This parameter is required if the rule limit for your account is more than the default of 150 rules.</p>
    /// <p>For information about requesting a rule limit increase, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">Config Limits</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub limit: i32,
}
impl DescribeConfigRuleEvaluationStatusInput {
    /// <p>The name of the Config managed rules for which you want status information. If you do not specify any names, Config returns status information for all Config managed rules that you use.</p>
    pub fn config_rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.config_rule_names.as_deref()
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of rule evaluation results that you want returned.</p>
    /// <p>This parameter is required if the rule limit for your account is more than the default of 150 rules.</p>
    /// <p>For information about requesting a rule limit increase, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">Config Limits</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
}
impl std::fmt::Debug for DescribeConfigRuleEvaluationStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigRuleEvaluationStatusInput");
        formatter.field("config_rule_names", &self.config_rule_names);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeComplianceByResourceInput {
    /// <p>The types of Amazon Web Services resources for which you want compliance information (for example, <code>AWS::EC2::Instance</code>). For this action, you can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services resource for which you want compliance information. You can specify only one resource ID. If you specify a resource ID, you must also specify a type for <code>ResourceType</code>.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>
    pub compliance_types: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
    /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeComplianceByResourceInput {
    /// <p>The types of Amazon Web Services resources for which you want compliance information (for example, <code>AWS::EC2::Instance</code>). For this action, you can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The ID of the Amazon Web Services resource for which you want compliance information. You can specify only one resource ID. If you specify a resource ID, you must also specify a type for <code>ResourceType</code>.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>
    pub fn compliance_types(&self) -> std::option::Option<&[crate::model::ComplianceType]> {
        self.compliance_types.as_deref()
    }
    /// <p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeComplianceByResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeComplianceByResourceInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("compliance_types", &self.compliance_types);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeComplianceByConfigRuleInput {
    /// <p>Specify one or more Config rule names to filter the results by rule.</p>
    pub config_rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.</p>
    pub compliance_types: std::option::Option<std::vec::Vec<crate::model::ComplianceType>>,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeComplianceByConfigRuleInput {
    /// <p>Specify one or more Config rule names to filter the results by rule.</p>
    pub fn config_rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.config_rule_names.as_deref()
    }
    /// <p>Filters the results by compliance.</p>
    /// <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.</p>
    pub fn compliance_types(&self) -> std::option::Option<&[crate::model::ComplianceType]> {
        self.compliance_types.as_deref()
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeComplianceByConfigRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeComplianceByConfigRuleInput");
        formatter.field("config_rule_names", &self.config_rule_names);
        formatter.field("compliance_types", &self.compliance_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAggregationAuthorizationsInput {
    /// <p>The maximum number of AggregationAuthorizations returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAggregationAuthorizationsInput {
    /// <p>The maximum number of AggregationAuthorizations returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAggregationAuthorizationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAggregationAuthorizationsInput");
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAggregateComplianceByConformancePacksInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>Filters the result by <code>AggregateConformancePackComplianceFilters</code> object.</p>
    pub filters: std::option::Option<crate::model::AggregateConformancePackComplianceFilters>,
    /// <p>The maximum number of conformance packs compliance details returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAggregateComplianceByConformancePacksInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>Filters the result by <code>AggregateConformancePackComplianceFilters</code> object.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&crate::model::AggregateConformancePackComplianceFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of conformance packs compliance details returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAggregateComplianceByConformancePacksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAggregateComplianceByConformancePacksInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field("filters", &self.filters);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAggregateComplianceByConfigRulesInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>Filters the results by ConfigRuleComplianceFilters object. </p>
    pub filters: std::option::Option<crate::model::ConfigRuleComplianceFilters>,
    /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub limit: i32,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAggregateComplianceByConfigRulesInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>Filters the results by ConfigRuleComplianceFilters object. </p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ConfigRuleComplianceFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAggregateComplianceByConfigRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAggregateComplianceByConfigRulesInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field("filters", &self.filters);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The input for the <code>DeliverConfigSnapshot</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeliverConfigSnapshotInput {
    /// <p>The name of the delivery channel through which the snapshot is delivered.</p>
    pub delivery_channel_name: std::option::Option<std::string::String>,
}
impl DeliverConfigSnapshotInput {
    /// <p>The name of the delivery channel through which the snapshot is delivered.</p>
    pub fn delivery_channel_name(&self) -> std::option::Option<&str> {
        self.delivery_channel_name.as_deref()
    }
}
impl std::fmt::Debug for DeliverConfigSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeliverConfigSnapshotInput");
        formatter.field("delivery_channel_name", &self.delivery_channel_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStoredQueryInput {
    /// <p>The name of the query that you want to delete.</p>
    pub query_name: std::option::Option<std::string::String>,
}
impl DeleteStoredQueryInput {
    /// <p>The name of the query that you want to delete.</p>
    pub fn query_name(&self) -> std::option::Option<&str> {
        self.query_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteStoredQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStoredQueryInput");
        formatter.field("query_name", &self.query_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRetentionConfigurationInput {
    /// <p>The name of the retention configuration to delete.</p>
    pub retention_configuration_name: std::option::Option<std::string::String>,
}
impl DeleteRetentionConfigurationInput {
    /// <p>The name of the retention configuration to delete.</p>
    pub fn retention_configuration_name(&self) -> std::option::Option<&str> {
        self.retention_configuration_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteRetentionConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRetentionConfigurationInput");
        formatter.field(
            "retention_configuration_name",
            &self.retention_configuration_name,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourceConfigInput {
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Unique identifier of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl DeleteResourceConfigInput {
    /// <p>The type of the resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Unique identifier of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteResourceConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourceConfigInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRemediationExceptionsInput {
    /// <p>The name of the Config rule for which you want to delete remediation exception configuration.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
    pub resource_keys:
        std::option::Option<std::vec::Vec<crate::model::RemediationExceptionResourceKey>>,
}
impl DeleteRemediationExceptionsInput {
    /// <p>The name of the Config rule for which you want to delete remediation exception configuration.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>
    pub fn resource_keys(
        &self,
    ) -> std::option::Option<&[crate::model::RemediationExceptionResourceKey]> {
        self.resource_keys.as_deref()
    }
}
impl std::fmt::Debug for DeleteRemediationExceptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRemediationExceptionsInput");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("resource_keys", &self.resource_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRemediationConfigurationInput {
    /// <p>The name of the Config rule for which you want to delete remediation configuration.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
    /// <p>The type of a resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl DeleteRemediationConfigurationInput {
    /// <p>The name of the Config rule for which you want to delete remediation configuration.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>The type of a resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for DeleteRemediationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRemediationConfigurationInput");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePendingAggregationRequestInput {
    /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
    pub requester_account_id: std::option::Option<std::string::String>,
    /// <p>The region requesting to aggregate data.</p>
    pub requester_aws_region: std::option::Option<std::string::String>,
}
impl DeletePendingAggregationRequestInput {
    /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
    pub fn requester_account_id(&self) -> std::option::Option<&str> {
        self.requester_account_id.as_deref()
    }
    /// <p>The region requesting to aggregate data.</p>
    pub fn requester_aws_region(&self) -> std::option::Option<&str> {
        self.requester_aws_region.as_deref()
    }
}
impl std::fmt::Debug for DeletePendingAggregationRequestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePendingAggregationRequestInput");
        formatter.field("requester_account_id", &self.requester_account_id);
        formatter.field("requester_aws_region", &self.requester_aws_region);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOrganizationConformancePackInput {
    /// <p>The name of organization conformance pack that you want to delete.</p>
    pub organization_conformance_pack_name: std::option::Option<std::string::String>,
}
impl DeleteOrganizationConformancePackInput {
    /// <p>The name of organization conformance pack that you want to delete.</p>
    pub fn organization_conformance_pack_name(&self) -> std::option::Option<&str> {
        self.organization_conformance_pack_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteOrganizationConformancePackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOrganizationConformancePackInput");
        formatter.field(
            "organization_conformance_pack_name",
            &self.organization_conformance_pack_name,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOrganizationConfigRuleInput {
    /// <p>The name of organization Config rule that you want to delete.</p>
    pub organization_config_rule_name: std::option::Option<std::string::String>,
}
impl DeleteOrganizationConfigRuleInput {
    /// <p>The name of organization Config rule that you want to delete.</p>
    pub fn organization_config_rule_name(&self) -> std::option::Option<&str> {
        self.organization_config_rule_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteOrganizationConfigRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOrganizationConfigRuleInput");
        formatter.field(
            "organization_config_rule_name",
            &self.organization_config_rule_name,
        );
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEvaluationResultsInput {
    /// <p>The name of the Config rule for which you want to delete the evaluation results.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
}
impl DeleteEvaluationResultsInput {
    /// <p>The name of the Config rule for which you want to delete the evaluation results.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteEvaluationResultsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEvaluationResultsInput");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.finish()
    }
}

/// <p>The input for the <code>DeleteDeliveryChannel</code> action. The action accepts the following data, in JSON format. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeliveryChannelInput {
    /// <p>The name of the delivery channel to delete.</p>
    pub delivery_channel_name: std::option::Option<std::string::String>,
}
impl DeleteDeliveryChannelInput {
    /// <p>The name of the delivery channel to delete.</p>
    pub fn delivery_channel_name(&self) -> std::option::Option<&str> {
        self.delivery_channel_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDeliveryChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeliveryChannelInput");
        formatter.field("delivery_channel_name", &self.delivery_channel_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConformancePackInput {
    /// <p>Name of the conformance pack you want to delete.</p>
    pub conformance_pack_name: std::option::Option<std::string::String>,
}
impl DeleteConformancePackInput {
    /// <p>Name of the conformance pack you want to delete.</p>
    pub fn conformance_pack_name(&self) -> std::option::Option<&str> {
        self.conformance_pack_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConformancePackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConformancePackInput");
        formatter.field("conformance_pack_name", &self.conformance_pack_name);
        formatter.finish()
    }
}

/// <p>The request object for the <code>DeleteConfigurationRecorder</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationRecorderInput {
    /// <p>The name of the configuration recorder to be deleted. You can retrieve the name of your configuration recorder by using the <code>DescribeConfigurationRecorders</code> action.</p>
    pub configuration_recorder_name: std::option::Option<std::string::String>,
}
impl DeleteConfigurationRecorderInput {
    /// <p>The name of the configuration recorder to be deleted. You can retrieve the name of your configuration recorder by using the <code>DescribeConfigurationRecorders</code> action.</p>
    pub fn configuration_recorder_name(&self) -> std::option::Option<&str> {
        self.configuration_recorder_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationRecorderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationRecorderInput");
        formatter.field(
            "configuration_recorder_name",
            &self.configuration_recorder_name,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationAggregatorInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
}
impl DeleteConfigurationAggregatorInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationAggregatorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationAggregatorInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigRuleInput {
    /// <p>The name of the Config rule that you want to delete.</p>
    pub config_rule_name: std::option::Option<std::string::String>,
}
impl DeleteConfigRuleInput {
    /// <p>The name of the Config rule that you want to delete.</p>
    pub fn config_rule_name(&self) -> std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigRuleInput");
        formatter.field("config_rule_name", &self.config_rule_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAggregationAuthorizationInput {
    /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
    pub authorized_account_id: std::option::Option<std::string::String>,
    /// <p>The region authorized to collect aggregated data.</p>
    pub authorized_aws_region: std::option::Option<std::string::String>,
}
impl DeleteAggregationAuthorizationInput {
    /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
    pub fn authorized_account_id(&self) -> std::option::Option<&str> {
        self.authorized_account_id.as_deref()
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn authorized_aws_region(&self) -> std::option::Option<&str> {
        self.authorized_aws_region.as_deref()
    }
}
impl std::fmt::Debug for DeleteAggregationAuthorizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAggregationAuthorizationInput");
        formatter.field("authorized_account_id", &self.authorized_account_id);
        formatter.field("authorized_aws_region", &self.authorized_aws_region);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetResourceConfigInput {
    /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID.</p>
    pub resource_keys: std::option::Option<std::vec::Vec<crate::model::ResourceKey>>,
}
impl BatchGetResourceConfigInput {
    /// <p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID.</p>
    pub fn resource_keys(&self) -> std::option::Option<&[crate::model::ResourceKey]> {
        self.resource_keys.as_deref()
    }
}
impl std::fmt::Debug for BatchGetResourceConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetResourceConfigInput");
        formatter.field("resource_keys", &self.resource_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetAggregateResourceConfigInput {
    /// <p>The name of the configuration aggregator.</p>
    pub configuration_aggregator_name: std::option::Option<std::string::String>,
    /// <p>A list of aggregate ResourceIdentifiers objects. </p>
    pub resource_identifiers:
        std::option::Option<std::vec::Vec<crate::model::AggregateResourceIdentifier>>,
}
impl BatchGetAggregateResourceConfigInput {
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>A list of aggregate ResourceIdentifiers objects. </p>
    pub fn resource_identifiers(
        &self,
    ) -> std::option::Option<&[crate::model::AggregateResourceIdentifier]> {
        self.resource_identifiers.as_deref()
    }
}
impl std::fmt::Debug for BatchGetAggregateResourceConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetAggregateResourceConfigInput");
        formatter.field(
            "configuration_aggregator_name",
            &self.configuration_aggregator_name,
        );
        formatter.field("resource_identifiers", &self.resource_identifiers);
        formatter.finish()
    }
}
