// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "Active" => Status::Active,
            "Failed" => Status::Failed,
            "Inactive" => Status::Inactive,
            "Pending" => Status::Pending,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Active => "Active",
            Status::Failed => "Failed",
            Status::Inactive => "Inactive",
            Status::Pending => "Pending",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Failed", "Inactive", "Pending"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of a recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationSummary {
    /// <p>An array of objects that describe a recommendation summary.</p>
    pub summaries: std::option::Option<std::vec::Vec<crate::model::Summary>>,
    /// <p>The resource type of the recommendation.</p>
    pub recommendation_resource_type: std::option::Option<crate::model::RecommendationSourceType>,
    /// <p>The Amazon Web Services account ID of the recommendation summary.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl RecommendationSummary {
    /// <p>An array of objects that describe a recommendation summary.</p>
    pub fn summaries(&self) -> std::option::Option<&[crate::model::Summary]> {
        self.summaries.as_deref()
    }
    /// <p>The resource type of the recommendation.</p>
    pub fn recommendation_resource_type(
        &self,
    ) -> std::option::Option<&crate::model::RecommendationSourceType> {
        self.recommendation_resource_type.as_ref()
    }
    /// <p>The Amazon Web Services account ID of the recommendation summary.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for RecommendationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationSummary");
        formatter.field("summaries", &self.summaries);
        formatter.field(
            "recommendation_resource_type",
            &self.recommendation_resource_type,
        );
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
/// See [`RecommendationSummary`](crate::model::RecommendationSummary)
pub mod recommendation_summary {
    /// A builder for [`RecommendationSummary`](crate::model::RecommendationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summaries: std::option::Option<std::vec::Vec<crate::model::Summary>>,
        pub(crate) recommendation_resource_type:
            std::option::Option<crate::model::RecommendationSourceType>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `summaries`.
        ///
        /// To override the contents of this collection use [`set_summaries`](Self::set_summaries).
        ///
        /// <p>An array of objects that describe a recommendation summary.</p>
        pub fn summaries(mut self, input: impl Into<crate::model::Summary>) -> Self {
            let mut v = self.summaries.unwrap_or_default();
            v.push(input.into());
            self.summaries = Some(v);
            self
        }
        /// <p>An array of objects that describe a recommendation summary.</p>
        pub fn set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Summary>>,
        ) -> Self {
            self.summaries = input;
            self
        }
        /// <p>The resource type of the recommendation.</p>
        pub fn recommendation_resource_type(
            mut self,
            input: crate::model::RecommendationSourceType,
        ) -> Self {
            self.recommendation_resource_type = Some(input);
            self
        }
        /// <p>The resource type of the recommendation.</p>
        pub fn set_recommendation_resource_type(
            mut self,
            input: std::option::Option<crate::model::RecommendationSourceType>,
        ) -> Self {
            self.recommendation_resource_type = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the recommendation summary.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the recommendation summary.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationSummary`](crate::model::RecommendationSummary)
        pub fn build(self) -> crate::model::RecommendationSummary {
            crate::model::RecommendationSummary {
                summaries: self.summaries,
                recommendation_resource_type: self.recommendation_resource_type,
                account_id: self.account_id,
            }
        }
    }
}
impl RecommendationSummary {
    /// Creates a new builder-style object to manufacture [`RecommendationSummary`](crate::model::RecommendationSummary)
    pub fn builder() -> crate::model::recommendation_summary::Builder {
        crate::model::recommendation_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecommendationSourceType {
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingGroup,
    #[allow(missing_docs)] // documentation missing in model
    EbsVolume,
    #[allow(missing_docs)] // documentation missing in model
    Ec2Instance,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunction,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecommendationSourceType {
    fn from(s: &str) -> Self {
        match s {
            "AutoScalingGroup" => RecommendationSourceType::AutoScalingGroup,
            "EbsVolume" => RecommendationSourceType::EbsVolume,
            "Ec2Instance" => RecommendationSourceType::Ec2Instance,
            "LambdaFunction" => RecommendationSourceType::LambdaFunction,
            other => RecommendationSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecommendationSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecommendationSourceType::from(s))
    }
}
impl RecommendationSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecommendationSourceType::AutoScalingGroup => "AutoScalingGroup",
            RecommendationSourceType::EbsVolume => "EbsVolume",
            RecommendationSourceType::Ec2Instance => "Ec2Instance",
            RecommendationSourceType::LambdaFunction => "LambdaFunction",
            RecommendationSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AutoScalingGroup",
            "EbsVolume",
            "Ec2Instance",
            "LambdaFunction",
        ]
    }
}
impl AsRef<str> for RecommendationSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The summary of a recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Summary {
    /// <p>The finding classification of the recommendation.</p>
    pub name: std::option::Option<crate::model::Finding>,
    /// <p>The value of the recommendation summary.</p>
    pub value: f64,
    /// <p>An array of objects that summarize a finding reason code.</p>
    pub reason_code_summaries: std::option::Option<std::vec::Vec<crate::model::ReasonCodeSummary>>,
}
impl Summary {
    /// <p>The finding classification of the recommendation.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::Finding> {
        self.name.as_ref()
    }
    /// <p>The value of the recommendation summary.</p>
    pub fn value(&self) -> f64 {
        self.value
    }
    /// <p>An array of objects that summarize a finding reason code.</p>
    pub fn reason_code_summaries(&self) -> std::option::Option<&[crate::model::ReasonCodeSummary]> {
        self.reason_code_summaries.as_deref()
    }
}
impl std::fmt::Debug for Summary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Summary");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.field("reason_code_summaries", &self.reason_code_summaries);
        formatter.finish()
    }
}
/// See [`Summary`](crate::model::Summary)
pub mod summary {
    /// A builder for [`Summary`](crate::model::Summary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::Finding>,
        pub(crate) value: std::option::Option<f64>,
        pub(crate) reason_code_summaries:
            std::option::Option<std::vec::Vec<crate::model::ReasonCodeSummary>>,
    }
    impl Builder {
        /// <p>The finding classification of the recommendation.</p>
        pub fn name(mut self, input: crate::model::Finding) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The finding classification of the recommendation.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::Finding>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the recommendation summary.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the recommendation summary.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Appends an item to `reason_code_summaries`.
        ///
        /// To override the contents of this collection use [`set_reason_code_summaries`](Self::set_reason_code_summaries).
        ///
        /// <p>An array of objects that summarize a finding reason code.</p>
        pub fn reason_code_summaries(
            mut self,
            input: impl Into<crate::model::ReasonCodeSummary>,
        ) -> Self {
            let mut v = self.reason_code_summaries.unwrap_or_default();
            v.push(input.into());
            self.reason_code_summaries = Some(v);
            self
        }
        /// <p>An array of objects that summarize a finding reason code.</p>
        pub fn set_reason_code_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReasonCodeSummary>>,
        ) -> Self {
            self.reason_code_summaries = input;
            self
        }
        /// Consumes the builder and constructs a [`Summary`](crate::model::Summary)
        pub fn build(self) -> crate::model::Summary {
            crate::model::Summary {
                name: self.name,
                value: self.value.unwrap_or_default(),
                reason_code_summaries: self.reason_code_summaries,
            }
        }
    }
}
impl Summary {
    /// Creates a new builder-style object to manufacture [`Summary`](crate::model::Summary)
    pub fn builder() -> crate::model::summary::Builder {
        crate::model::summary::Builder::default()
    }
}

/// <p>A summary of a finding reason code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReasonCodeSummary {
    /// <p>The name of the finding reason code.</p>
    pub name: std::option::Option<crate::model::FindingReasonCode>,
    /// <p>The value of the finding reason code summary.</p>
    pub value: f64,
}
impl ReasonCodeSummary {
    /// <p>The name of the finding reason code.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::FindingReasonCode> {
        self.name.as_ref()
    }
    /// <p>The value of the finding reason code summary.</p>
    pub fn value(&self) -> f64 {
        self.value
    }
}
impl std::fmt::Debug for ReasonCodeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReasonCodeSummary");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ReasonCodeSummary`](crate::model::ReasonCodeSummary)
pub mod reason_code_summary {
    /// A builder for [`ReasonCodeSummary`](crate::model::ReasonCodeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::FindingReasonCode>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of the finding reason code.</p>
        pub fn name(mut self, input: crate::model::FindingReasonCode) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the finding reason code.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::FindingReasonCode>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the finding reason code summary.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the finding reason code summary.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ReasonCodeSummary`](crate::model::ReasonCodeSummary)
        pub fn build(self) -> crate::model::ReasonCodeSummary {
            crate::model::ReasonCodeSummary {
                name: self.name,
                value: self.value.unwrap_or_default(),
            }
        }
    }
}
impl ReasonCodeSummary {
    /// Creates a new builder-style object to manufacture [`ReasonCodeSummary`](crate::model::ReasonCodeSummary)
    pub fn builder() -> crate::model::reason_code_summary::Builder {
        crate::model::reason_code_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    MemoryOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    MemoryUnderProvisioned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "MemoryOverprovisioned" => FindingReasonCode::MemoryOverProvisioned,
            "MemoryUnderprovisioned" => FindingReasonCode::MemoryUnderProvisioned,
            other => FindingReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingReasonCode::from(s))
    }
}
impl FindingReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingReasonCode::MemoryOverProvisioned => "MemoryOverprovisioned",
            FindingReasonCode::MemoryUnderProvisioned => "MemoryUnderprovisioned",
            FindingReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MemoryOverprovisioned", "MemoryUnderprovisioned"]
    }
}
impl AsRef<str> for FindingReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Finding {
    #[allow(missing_docs)] // documentation missing in model
    NotOptimized,
    #[allow(missing_docs)] // documentation missing in model
    Optimized,
    #[allow(missing_docs)] // documentation missing in model
    OverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    UnderProvisioned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Finding {
    fn from(s: &str) -> Self {
        match s {
            "NotOptimized" => Finding::NotOptimized,
            "Optimized" => Finding::Optimized,
            "Overprovisioned" => Finding::OverProvisioned,
            "Underprovisioned" => Finding::UnderProvisioned,
            other => Finding::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Finding {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Finding::from(s))
    }
}
impl Finding {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Finding::NotOptimized => "NotOptimized",
            Finding::Optimized => "Optimized",
            Finding::OverProvisioned => "Overprovisioned",
            Finding::UnderProvisioned => "Underprovisioned",
            Finding::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "NotOptimized",
            "Optimized",
            "Overprovisioned",
            "Underprovisioned",
        ]
    }
}
impl AsRef<str> for Finding {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an Lambda function recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionRecommendation {
    /// <p>The Amazon Resource Name (ARN) of the current function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The version number of the current function.</p>
    pub function_version: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the function.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The amount of memory, in MB, that's allocated to the current function.</p>
    pub current_memory_size: i32,
    /// <p>The number of times your function code was applied during the look-back period.</p>
    pub number_of_invocations: i64,
    /// <p>An array of objects that describe the utilization metrics of the function.</p>
    pub utilization_metrics:
        std::option::Option<std::vec::Vec<crate::model::LambdaFunctionUtilizationMetric>>,
    /// <p>The number of days for which utilization metrics were analyzed for the
    /// function.</p>
    pub lookback_period_in_days: f64,
    /// <p>The timestamp of when the function recommendation was last refreshed.</p>
    pub last_refresh_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The finding classification of the function.</p>
    ///
    /// <p>Findings for functions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Optimized</code>
    /// </b> — The function is
    /// correctly provisioned to run your workload based on its current configuration
    /// and its utilization history. This finding classification does not include
    /// finding reason codes.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NotOptimized</code>
    /// </b> — The function is
    /// performing at a higher level (over-provisioned) or at a lower level
    /// (under-provisioned) than required for your workload because its current
    /// configuration is not optimal. Over-provisioned resources might lead to
    /// unnecessary infrastructure cost, and under-provisioned resources might lead to
    /// poor application performance. This finding classification can include the
    /// <code>MemoryUnderprovisioned</code> and <code>MemoryUnderprovisioned</code>
    /// finding reason codes.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Unavailable</code>
    /// </b> — Compute Optimizer
    /// was unable to generate a recommendation for the function. This could be because
    /// the function has not accumulated sufficient metric data, or the function does
    /// not qualify for a recommendation. This finding classification can include the
    /// <code>InsufficientData</code> and <code>Inconclusive</code> finding reason
    /// codes.</p>
    /// <note>
    /// <p>Functions with a finding of unavailable are not returned unless you
    /// specify the <code>filter</code> parameter with a value of
    /// <code>Unavailable</code> in your
    /// <code>GetLambdaFunctionRecommendations</code> request.</p>
    /// </note>
    /// </li>
    /// </ul>
    pub finding: std::option::Option<crate::model::LambdaFunctionRecommendationFinding>,
    /// <p>The reason for the finding classification of the function.</p>
    /// <note>
    /// <p>Functions that have a finding classification of <code>Optimized</code> don't have
    /// a finding reason code.</p>
    /// </note>
    /// <p>Finding reason codes for functions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryOverprovisioned</code>
    /// </b> — The
    /// function is over-provisioned when its memory configuration can be sized down
    /// while still meeting the performance requirements of your workload. An
    /// over-provisioned function might lead to unnecessary infrastructure cost. This
    /// finding reason code is part of the <code>NotOptimized</code> finding
    /// classification.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryUnderprovisioned</code>
    /// </b> — The
    /// function is under-provisioned when its memory configuration doesn't meet the
    /// performance requirements of the workload. An under-provisioned function might
    /// lead to poor application performance. This finding reason code is part of the
    /// <code>NotOptimized</code> finding classification.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>InsufficientData</code>
    /// </b> — The function
    /// does not have sufficient metric data for Compute Optimizer to generate a
    /// recommendation. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
    /// requirements</a> in the <i>Compute Optimizer User
    /// Guide</i>. This finding reason code is part of the
    /// <code>Unavailable</code> finding classification.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Inconclusive</code>
    /// </b> — The function does
    /// not qualify for a recommendation because Compute Optimizer cannot generate a
    /// recommendation with a high degree of confidence. This finding reason code is
    /// part of the <code>Unavailable</code> finding classification.</p>
    /// </li>
    /// </ul>
    pub finding_reason_codes: std::option::Option<
        std::vec::Vec<crate::model::LambdaFunctionRecommendationFindingReasonCode>,
    >,
    /// <p>An array of objects that describe the memory configuration recommendation options for
    /// the function.</p>
    pub memory_size_recommendation_options:
        std::option::Option<std::vec::Vec<crate::model::LambdaFunctionMemoryRecommendationOption>>,
}
impl LambdaFunctionRecommendation {
    /// <p>The Amazon Resource Name (ARN) of the current function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The version number of the current function.</p>
    pub fn function_version(&self) -> std::option::Option<&str> {
        self.function_version.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the function.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The amount of memory, in MB, that's allocated to the current function.</p>
    pub fn current_memory_size(&self) -> i32 {
        self.current_memory_size
    }
    /// <p>The number of times your function code was applied during the look-back period.</p>
    pub fn number_of_invocations(&self) -> i64 {
        self.number_of_invocations
    }
    /// <p>An array of objects that describe the utilization metrics of the function.</p>
    pub fn utilization_metrics(
        &self,
    ) -> std::option::Option<&[crate::model::LambdaFunctionUtilizationMetric]> {
        self.utilization_metrics.as_deref()
    }
    /// <p>The number of days for which utilization metrics were analyzed for the
    /// function.</p>
    pub fn lookback_period_in_days(&self) -> f64 {
        self.lookback_period_in_days
    }
    /// <p>The timestamp of when the function recommendation was last refreshed.</p>
    pub fn last_refresh_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_refresh_timestamp.as_ref()
    }
    /// <p>The finding classification of the function.</p>
    ///
    /// <p>Findings for functions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Optimized</code>
    /// </b> — The function is
    /// correctly provisioned to run your workload based on its current configuration
    /// and its utilization history. This finding classification does not include
    /// finding reason codes.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NotOptimized</code>
    /// </b> — The function is
    /// performing at a higher level (over-provisioned) or at a lower level
    /// (under-provisioned) than required for your workload because its current
    /// configuration is not optimal. Over-provisioned resources might lead to
    /// unnecessary infrastructure cost, and under-provisioned resources might lead to
    /// poor application performance. This finding classification can include the
    /// <code>MemoryUnderprovisioned</code> and <code>MemoryUnderprovisioned</code>
    /// finding reason codes.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Unavailable</code>
    /// </b> — Compute Optimizer
    /// was unable to generate a recommendation for the function. This could be because
    /// the function has not accumulated sufficient metric data, or the function does
    /// not qualify for a recommendation. This finding classification can include the
    /// <code>InsufficientData</code> and <code>Inconclusive</code> finding reason
    /// codes.</p>
    /// <note>
    /// <p>Functions with a finding of unavailable are not returned unless you
    /// specify the <code>filter</code> parameter with a value of
    /// <code>Unavailable</code> in your
    /// <code>GetLambdaFunctionRecommendations</code> request.</p>
    /// </note>
    /// </li>
    /// </ul>
    pub fn finding(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionRecommendationFinding> {
        self.finding.as_ref()
    }
    /// <p>The reason for the finding classification of the function.</p>
    /// <note>
    /// <p>Functions that have a finding classification of <code>Optimized</code> don't have
    /// a finding reason code.</p>
    /// </note>
    /// <p>Finding reason codes for functions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryOverprovisioned</code>
    /// </b> — The
    /// function is over-provisioned when its memory configuration can be sized down
    /// while still meeting the performance requirements of your workload. An
    /// over-provisioned function might lead to unnecessary infrastructure cost. This
    /// finding reason code is part of the <code>NotOptimized</code> finding
    /// classification.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryUnderprovisioned</code>
    /// </b> — The
    /// function is under-provisioned when its memory configuration doesn't meet the
    /// performance requirements of the workload. An under-provisioned function might
    /// lead to poor application performance. This finding reason code is part of the
    /// <code>NotOptimized</code> finding classification.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>InsufficientData</code>
    /// </b> — The function
    /// does not have sufficient metric data for Compute Optimizer to generate a
    /// recommendation. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
    /// requirements</a> in the <i>Compute Optimizer User
    /// Guide</i>. This finding reason code is part of the
    /// <code>Unavailable</code> finding classification.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Inconclusive</code>
    /// </b> — The function does
    /// not qualify for a recommendation because Compute Optimizer cannot generate a
    /// recommendation with a high degree of confidence. This finding reason code is
    /// part of the <code>Unavailable</code> finding classification.</p>
    /// </li>
    /// </ul>
    pub fn finding_reason_codes(
        &self,
    ) -> std::option::Option<&[crate::model::LambdaFunctionRecommendationFindingReasonCode]> {
        self.finding_reason_codes.as_deref()
    }
    /// <p>An array of objects that describe the memory configuration recommendation options for
    /// the function.</p>
    pub fn memory_size_recommendation_options(
        &self,
    ) -> std::option::Option<&[crate::model::LambdaFunctionMemoryRecommendationOption]> {
        self.memory_size_recommendation_options.as_deref()
    }
}
impl std::fmt::Debug for LambdaFunctionRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionRecommendation");
        formatter.field("function_arn", &self.function_arn);
        formatter.field("function_version", &self.function_version);
        formatter.field("account_id", &self.account_id);
        formatter.field("current_memory_size", &self.current_memory_size);
        formatter.field("number_of_invocations", &self.number_of_invocations);
        formatter.field("utilization_metrics", &self.utilization_metrics);
        formatter.field("lookback_period_in_days", &self.lookback_period_in_days);
        formatter.field("last_refresh_timestamp", &self.last_refresh_timestamp);
        formatter.field("finding", &self.finding);
        formatter.field("finding_reason_codes", &self.finding_reason_codes);
        formatter.field(
            "memory_size_recommendation_options",
            &self.memory_size_recommendation_options,
        );
        formatter.finish()
    }
}
/// See [`LambdaFunctionRecommendation`](crate::model::LambdaFunctionRecommendation)
pub mod lambda_function_recommendation {
    /// A builder for [`LambdaFunctionRecommendation`](crate::model::LambdaFunctionRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) current_memory_size: std::option::Option<i32>,
        pub(crate) number_of_invocations: std::option::Option<i64>,
        pub(crate) utilization_metrics:
            std::option::Option<std::vec::Vec<crate::model::LambdaFunctionUtilizationMetric>>,
        pub(crate) lookback_period_in_days: std::option::Option<f64>,
        pub(crate) last_refresh_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) finding: std::option::Option<crate::model::LambdaFunctionRecommendationFinding>,
        pub(crate) finding_reason_codes: std::option::Option<
            std::vec::Vec<crate::model::LambdaFunctionRecommendationFindingReasonCode>,
        >,
        pub(crate) memory_size_recommendation_options: std::option::Option<
            std::vec::Vec<crate::model::LambdaFunctionMemoryRecommendationOption>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the current function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the current function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The version number of the current function.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_version = Some(input.into());
            self
        }
        /// <p>The version number of the current function.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the function.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the function.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The amount of memory, in MB, that's allocated to the current function.</p>
        pub fn current_memory_size(mut self, input: i32) -> Self {
            self.current_memory_size = Some(input);
            self
        }
        /// <p>The amount of memory, in MB, that's allocated to the current function.</p>
        pub fn set_current_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.current_memory_size = input;
            self
        }
        /// <p>The number of times your function code was applied during the look-back period.</p>
        pub fn number_of_invocations(mut self, input: i64) -> Self {
            self.number_of_invocations = Some(input);
            self
        }
        /// <p>The number of times your function code was applied during the look-back period.</p>
        pub fn set_number_of_invocations(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_invocations = input;
            self
        }
        /// Appends an item to `utilization_metrics`.
        ///
        /// To override the contents of this collection use [`set_utilization_metrics`](Self::set_utilization_metrics).
        ///
        /// <p>An array of objects that describe the utilization metrics of the function.</p>
        pub fn utilization_metrics(
            mut self,
            input: impl Into<crate::model::LambdaFunctionUtilizationMetric>,
        ) -> Self {
            let mut v = self.utilization_metrics.unwrap_or_default();
            v.push(input.into());
            self.utilization_metrics = Some(v);
            self
        }
        /// <p>An array of objects that describe the utilization metrics of the function.</p>
        pub fn set_utilization_metrics(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LambdaFunctionUtilizationMetric>,
            >,
        ) -> Self {
            self.utilization_metrics = input;
            self
        }
        /// <p>The number of days for which utilization metrics were analyzed for the
        /// function.</p>
        pub fn lookback_period_in_days(mut self, input: f64) -> Self {
            self.lookback_period_in_days = Some(input);
            self
        }
        /// <p>The number of days for which utilization metrics were analyzed for the
        /// function.</p>
        pub fn set_lookback_period_in_days(mut self, input: std::option::Option<f64>) -> Self {
            self.lookback_period_in_days = input;
            self
        }
        /// <p>The timestamp of when the function recommendation was last refreshed.</p>
        pub fn last_refresh_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_refresh_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of when the function recommendation was last refreshed.</p>
        pub fn set_last_refresh_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_refresh_timestamp = input;
            self
        }
        /// <p>The finding classification of the function.</p>
        ///
        /// <p>Findings for functions include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Optimized</code>
        /// </b> — The function is
        /// correctly provisioned to run your workload based on its current configuration
        /// and its utilization history. This finding classification does not include
        /// finding reason codes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NotOptimized</code>
        /// </b> — The function is
        /// performing at a higher level (over-provisioned) or at a lower level
        /// (under-provisioned) than required for your workload because its current
        /// configuration is not optimal. Over-provisioned resources might lead to
        /// unnecessary infrastructure cost, and under-provisioned resources might lead to
        /// poor application performance. This finding classification can include the
        /// <code>MemoryUnderprovisioned</code> and <code>MemoryUnderprovisioned</code>
        /// finding reason codes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Unavailable</code>
        /// </b> — Compute Optimizer
        /// was unable to generate a recommendation for the function. This could be because
        /// the function has not accumulated sufficient metric data, or the function does
        /// not qualify for a recommendation. This finding classification can include the
        /// <code>InsufficientData</code> and <code>Inconclusive</code> finding reason
        /// codes.</p>
        /// <note>
        /// <p>Functions with a finding of unavailable are not returned unless you
        /// specify the <code>filter</code> parameter with a value of
        /// <code>Unavailable</code> in your
        /// <code>GetLambdaFunctionRecommendations</code> request.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn finding(mut self, input: crate::model::LambdaFunctionRecommendationFinding) -> Self {
            self.finding = Some(input);
            self
        }
        /// <p>The finding classification of the function.</p>
        ///
        /// <p>Findings for functions include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Optimized</code>
        /// </b> — The function is
        /// correctly provisioned to run your workload based on its current configuration
        /// and its utilization history. This finding classification does not include
        /// finding reason codes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NotOptimized</code>
        /// </b> — The function is
        /// performing at a higher level (over-provisioned) or at a lower level
        /// (under-provisioned) than required for your workload because its current
        /// configuration is not optimal. Over-provisioned resources might lead to
        /// unnecessary infrastructure cost, and under-provisioned resources might lead to
        /// poor application performance. This finding classification can include the
        /// <code>MemoryUnderprovisioned</code> and <code>MemoryUnderprovisioned</code>
        /// finding reason codes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Unavailable</code>
        /// </b> — Compute Optimizer
        /// was unable to generate a recommendation for the function. This could be because
        /// the function has not accumulated sufficient metric data, or the function does
        /// not qualify for a recommendation. This finding classification can include the
        /// <code>InsufficientData</code> and <code>Inconclusive</code> finding reason
        /// codes.</p>
        /// <note>
        /// <p>Functions with a finding of unavailable are not returned unless you
        /// specify the <code>filter</code> parameter with a value of
        /// <code>Unavailable</code> in your
        /// <code>GetLambdaFunctionRecommendations</code> request.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn set_finding(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionRecommendationFinding>,
        ) -> Self {
            self.finding = input;
            self
        }
        /// Appends an item to `finding_reason_codes`.
        ///
        /// To override the contents of this collection use [`set_finding_reason_codes`](Self::set_finding_reason_codes).
        ///
        /// <p>The reason for the finding classification of the function.</p>
        /// <note>
        /// <p>Functions that have a finding classification of <code>Optimized</code> don't have
        /// a finding reason code.</p>
        /// </note>
        /// <p>Finding reason codes for functions include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryOverprovisioned</code>
        /// </b> — The
        /// function is over-provisioned when its memory configuration can be sized down
        /// while still meeting the performance requirements of your workload. An
        /// over-provisioned function might lead to unnecessary infrastructure cost. This
        /// finding reason code is part of the <code>NotOptimized</code> finding
        /// classification.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryUnderprovisioned</code>
        /// </b> — The
        /// function is under-provisioned when its memory configuration doesn't meet the
        /// performance requirements of the workload. An under-provisioned function might
        /// lead to poor application performance. This finding reason code is part of the
        /// <code>NotOptimized</code> finding classification.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>InsufficientData</code>
        /// </b> — The function
        /// does not have sufficient metric data for Compute Optimizer to generate a
        /// recommendation. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
        /// requirements</a> in the <i>Compute Optimizer User
        /// Guide</i>. This finding reason code is part of the
        /// <code>Unavailable</code> finding classification.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Inconclusive</code>
        /// </b> — The function does
        /// not qualify for a recommendation because Compute Optimizer cannot generate a
        /// recommendation with a high degree of confidence. This finding reason code is
        /// part of the <code>Unavailable</code> finding classification.</p>
        /// </li>
        /// </ul>
        pub fn finding_reason_codes(
            mut self,
            input: impl Into<crate::model::LambdaFunctionRecommendationFindingReasonCode>,
        ) -> Self {
            let mut v = self.finding_reason_codes.unwrap_or_default();
            v.push(input.into());
            self.finding_reason_codes = Some(v);
            self
        }
        /// <p>The reason for the finding classification of the function.</p>
        /// <note>
        /// <p>Functions that have a finding classification of <code>Optimized</code> don't have
        /// a finding reason code.</p>
        /// </note>
        /// <p>Finding reason codes for functions include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryOverprovisioned</code>
        /// </b> — The
        /// function is over-provisioned when its memory configuration can be sized down
        /// while still meeting the performance requirements of your workload. An
        /// over-provisioned function might lead to unnecessary infrastructure cost. This
        /// finding reason code is part of the <code>NotOptimized</code> finding
        /// classification.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryUnderprovisioned</code>
        /// </b> — The
        /// function is under-provisioned when its memory configuration doesn't meet the
        /// performance requirements of the workload. An under-provisioned function might
        /// lead to poor application performance. This finding reason code is part of the
        /// <code>NotOptimized</code> finding classification.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>InsufficientData</code>
        /// </b> — The function
        /// does not have sufficient metric data for Compute Optimizer to generate a
        /// recommendation. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
        /// requirements</a> in the <i>Compute Optimizer User
        /// Guide</i>. This finding reason code is part of the
        /// <code>Unavailable</code> finding classification.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Inconclusive</code>
        /// </b> — The function does
        /// not qualify for a recommendation because Compute Optimizer cannot generate a
        /// recommendation with a high degree of confidence. This finding reason code is
        /// part of the <code>Unavailable</code> finding classification.</p>
        /// </li>
        /// </ul>
        pub fn set_finding_reason_codes(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LambdaFunctionRecommendationFindingReasonCode>,
            >,
        ) -> Self {
            self.finding_reason_codes = input;
            self
        }
        /// Appends an item to `memory_size_recommendation_options`.
        ///
        /// To override the contents of this collection use [`set_memory_size_recommendation_options`](Self::set_memory_size_recommendation_options).
        ///
        /// <p>An array of objects that describe the memory configuration recommendation options for
        /// the function.</p>
        pub fn memory_size_recommendation_options(
            mut self,
            input: impl Into<crate::model::LambdaFunctionMemoryRecommendationOption>,
        ) -> Self {
            let mut v = self.memory_size_recommendation_options.unwrap_or_default();
            v.push(input.into());
            self.memory_size_recommendation_options = Some(v);
            self
        }
        /// <p>An array of objects that describe the memory configuration recommendation options for
        /// the function.</p>
        pub fn set_memory_size_recommendation_options(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LambdaFunctionMemoryRecommendationOption>,
            >,
        ) -> Self {
            self.memory_size_recommendation_options = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionRecommendation`](crate::model::LambdaFunctionRecommendation)
        pub fn build(self) -> crate::model::LambdaFunctionRecommendation {
            crate::model::LambdaFunctionRecommendation {
                function_arn: self.function_arn,
                function_version: self.function_version,
                account_id: self.account_id,
                current_memory_size: self.current_memory_size.unwrap_or_default(),
                number_of_invocations: self.number_of_invocations.unwrap_or_default(),
                utilization_metrics: self.utilization_metrics,
                lookback_period_in_days: self.lookback_period_in_days.unwrap_or_default(),
                last_refresh_timestamp: self.last_refresh_timestamp,
                finding: self.finding,
                finding_reason_codes: self.finding_reason_codes,
                memory_size_recommendation_options: self.memory_size_recommendation_options,
            }
        }
    }
}
impl LambdaFunctionRecommendation {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionRecommendation`](crate::model::LambdaFunctionRecommendation)
    pub fn builder() -> crate::model::lambda_function_recommendation::Builder {
        crate::model::lambda_function_recommendation::Builder::default()
    }
}

/// <p>Describes a recommendation option for an Lambda function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionMemoryRecommendationOption {
    /// <p>The rank of the function recommendation option.</p>
    ///
    /// <p>The top recommendation option is ranked as <code>1</code>.</p>
    pub rank: i32,
    /// <p>The memory size, in MB, of the function recommendation option.</p>
    pub memory_size: i32,
    /// <p>An array of objects that describe the projected utilization metrics of the function
    /// recommendation option.</p>
    pub projected_utilization_metrics:
        std::option::Option<std::vec::Vec<crate::model::LambdaFunctionMemoryProjectedMetric>>,
}
impl LambdaFunctionMemoryRecommendationOption {
    /// <p>The rank of the function recommendation option.</p>
    ///
    /// <p>The top recommendation option is ranked as <code>1</code>.</p>
    pub fn rank(&self) -> i32 {
        self.rank
    }
    /// <p>The memory size, in MB, of the function recommendation option.</p>
    pub fn memory_size(&self) -> i32 {
        self.memory_size
    }
    /// <p>An array of objects that describe the projected utilization metrics of the function
    /// recommendation option.</p>
    pub fn projected_utilization_metrics(
        &self,
    ) -> std::option::Option<&[crate::model::LambdaFunctionMemoryProjectedMetric]> {
        self.projected_utilization_metrics.as_deref()
    }
}
impl std::fmt::Debug for LambdaFunctionMemoryRecommendationOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionMemoryRecommendationOption");
        formatter.field("rank", &self.rank);
        formatter.field("memory_size", &self.memory_size);
        formatter.field(
            "projected_utilization_metrics",
            &self.projected_utilization_metrics,
        );
        formatter.finish()
    }
}
/// See [`LambdaFunctionMemoryRecommendationOption`](crate::model::LambdaFunctionMemoryRecommendationOption)
pub mod lambda_function_memory_recommendation_option {
    /// A builder for [`LambdaFunctionMemoryRecommendationOption`](crate::model::LambdaFunctionMemoryRecommendationOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rank: std::option::Option<i32>,
        pub(crate) memory_size: std::option::Option<i32>,
        pub(crate) projected_utilization_metrics:
            std::option::Option<std::vec::Vec<crate::model::LambdaFunctionMemoryProjectedMetric>>,
    }
    impl Builder {
        /// <p>The rank of the function recommendation option.</p>
        ///
        /// <p>The top recommendation option is ranked as <code>1</code>.</p>
        pub fn rank(mut self, input: i32) -> Self {
            self.rank = Some(input);
            self
        }
        /// <p>The rank of the function recommendation option.</p>
        ///
        /// <p>The top recommendation option is ranked as <code>1</code>.</p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.rank = input;
            self
        }
        /// <p>The memory size, in MB, of the function recommendation option.</p>
        pub fn memory_size(mut self, input: i32) -> Self {
            self.memory_size = Some(input);
            self
        }
        /// <p>The memory size, in MB, of the function recommendation option.</p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size = input;
            self
        }
        /// Appends an item to `projected_utilization_metrics`.
        ///
        /// To override the contents of this collection use [`set_projected_utilization_metrics`](Self::set_projected_utilization_metrics).
        ///
        /// <p>An array of objects that describe the projected utilization metrics of the function
        /// recommendation option.</p>
        pub fn projected_utilization_metrics(
            mut self,
            input: impl Into<crate::model::LambdaFunctionMemoryProjectedMetric>,
        ) -> Self {
            let mut v = self.projected_utilization_metrics.unwrap_or_default();
            v.push(input.into());
            self.projected_utilization_metrics = Some(v);
            self
        }
        /// <p>An array of objects that describe the projected utilization metrics of the function
        /// recommendation option.</p>
        pub fn set_projected_utilization_metrics(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LambdaFunctionMemoryProjectedMetric>,
            >,
        ) -> Self {
            self.projected_utilization_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionMemoryRecommendationOption`](crate::model::LambdaFunctionMemoryRecommendationOption)
        pub fn build(self) -> crate::model::LambdaFunctionMemoryRecommendationOption {
            crate::model::LambdaFunctionMemoryRecommendationOption {
                rank: self.rank.unwrap_or_default(),
                memory_size: self.memory_size.unwrap_or_default(),
                projected_utilization_metrics: self.projected_utilization_metrics,
            }
        }
    }
}
impl LambdaFunctionMemoryRecommendationOption {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionMemoryRecommendationOption`](crate::model::LambdaFunctionMemoryRecommendationOption)
    pub fn builder() -> crate::model::lambda_function_memory_recommendation_option::Builder {
        crate::model::lambda_function_memory_recommendation_option::Builder::default()
    }
}

/// <p>Describes a projected utilization metric of an Lambda function
/// recommendation option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionMemoryProjectedMetric {
    /// <p>The name of the projected utilization metric.</p>
    pub name: std::option::Option<crate::model::LambdaFunctionMemoryMetricName>,
    /// <p>The statistic of the projected utilization metric.</p>
    pub statistic: std::option::Option<crate::model::LambdaFunctionMemoryMetricStatistic>,
    /// <p>The values of the projected utilization metrics.</p>
    pub value: f64,
}
impl LambdaFunctionMemoryProjectedMetric {
    /// <p>The name of the projected utilization metric.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::LambdaFunctionMemoryMetricName> {
        self.name.as_ref()
    }
    /// <p>The statistic of the projected utilization metric.</p>
    pub fn statistic(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionMemoryMetricStatistic> {
        self.statistic.as_ref()
    }
    /// <p>The values of the projected utilization metrics.</p>
    pub fn value(&self) -> f64 {
        self.value
    }
}
impl std::fmt::Debug for LambdaFunctionMemoryProjectedMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionMemoryProjectedMetric");
        formatter.field("name", &self.name);
        formatter.field("statistic", &self.statistic);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`LambdaFunctionMemoryProjectedMetric`](crate::model::LambdaFunctionMemoryProjectedMetric)
pub mod lambda_function_memory_projected_metric {
    /// A builder for [`LambdaFunctionMemoryProjectedMetric`](crate::model::LambdaFunctionMemoryProjectedMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::LambdaFunctionMemoryMetricName>,
        pub(crate) statistic:
            std::option::Option<crate::model::LambdaFunctionMemoryMetricStatistic>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of the projected utilization metric.</p>
        pub fn name(mut self, input: crate::model::LambdaFunctionMemoryMetricName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the projected utilization metric.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionMemoryMetricName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The statistic of the projected utilization metric.</p>
        pub fn statistic(
            mut self,
            input: crate::model::LambdaFunctionMemoryMetricStatistic,
        ) -> Self {
            self.statistic = Some(input);
            self
        }
        /// <p>The statistic of the projected utilization metric.</p>
        pub fn set_statistic(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionMemoryMetricStatistic>,
        ) -> Self {
            self.statistic = input;
            self
        }
        /// <p>The values of the projected utilization metrics.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The values of the projected utilization metrics.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionMemoryProjectedMetric`](crate::model::LambdaFunctionMemoryProjectedMetric)
        pub fn build(self) -> crate::model::LambdaFunctionMemoryProjectedMetric {
            crate::model::LambdaFunctionMemoryProjectedMetric {
                name: self.name,
                statistic: self.statistic,
                value: self.value.unwrap_or_default(),
            }
        }
    }
}
impl LambdaFunctionMemoryProjectedMetric {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionMemoryProjectedMetric`](crate::model::LambdaFunctionMemoryProjectedMetric)
    pub fn builder() -> crate::model::lambda_function_memory_projected_metric::Builder {
        crate::model::lambda_function_memory_projected_metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaFunctionMemoryMetricStatistic {
    #[allow(missing_docs)] // documentation missing in model
    Expected,
    #[allow(missing_docs)] // documentation missing in model
    LowerBound,
    #[allow(missing_docs)] // documentation missing in model
    UpperBound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaFunctionMemoryMetricStatistic {
    fn from(s: &str) -> Self {
        match s {
            "Expected" => LambdaFunctionMemoryMetricStatistic::Expected,
            "LowerBound" => LambdaFunctionMemoryMetricStatistic::LowerBound,
            "UpperBound" => LambdaFunctionMemoryMetricStatistic::UpperBound,
            other => LambdaFunctionMemoryMetricStatistic::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaFunctionMemoryMetricStatistic {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaFunctionMemoryMetricStatistic::from(s))
    }
}
impl LambdaFunctionMemoryMetricStatistic {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaFunctionMemoryMetricStatistic::Expected => "Expected",
            LambdaFunctionMemoryMetricStatistic::LowerBound => "LowerBound",
            LambdaFunctionMemoryMetricStatistic::UpperBound => "UpperBound",
            LambdaFunctionMemoryMetricStatistic::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Expected", "LowerBound", "UpperBound"]
    }
}
impl AsRef<str> for LambdaFunctionMemoryMetricStatistic {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaFunctionMemoryMetricName {
    #[allow(missing_docs)] // documentation missing in model
    Duration,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaFunctionMemoryMetricName {
    fn from(s: &str) -> Self {
        match s {
            "Duration" => LambdaFunctionMemoryMetricName::Duration,
            other => LambdaFunctionMemoryMetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaFunctionMemoryMetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaFunctionMemoryMetricName::from(s))
    }
}
impl LambdaFunctionMemoryMetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaFunctionMemoryMetricName::Duration => "Duration",
            LambdaFunctionMemoryMetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Duration"]
    }
}
impl AsRef<str> for LambdaFunctionMemoryMetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaFunctionRecommendationFindingReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    Inconclusive,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientData,
    #[allow(missing_docs)] // documentation missing in model
    MemoryOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    MemoryUnderProvisioned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaFunctionRecommendationFindingReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "Inconclusive" => LambdaFunctionRecommendationFindingReasonCode::Inconclusive,
            "InsufficientData" => LambdaFunctionRecommendationFindingReasonCode::InsufficientData,
            "MemoryOverprovisioned" => {
                LambdaFunctionRecommendationFindingReasonCode::MemoryOverProvisioned
            }
            "MemoryUnderprovisioned" => {
                LambdaFunctionRecommendationFindingReasonCode::MemoryUnderProvisioned
            }
            other => LambdaFunctionRecommendationFindingReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaFunctionRecommendationFindingReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaFunctionRecommendationFindingReasonCode::from(s))
    }
}
impl LambdaFunctionRecommendationFindingReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaFunctionRecommendationFindingReasonCode::Inconclusive => "Inconclusive",
            LambdaFunctionRecommendationFindingReasonCode::InsufficientData => "InsufficientData",
            LambdaFunctionRecommendationFindingReasonCode::MemoryOverProvisioned => {
                "MemoryOverprovisioned"
            }
            LambdaFunctionRecommendationFindingReasonCode::MemoryUnderProvisioned => {
                "MemoryUnderprovisioned"
            }
            LambdaFunctionRecommendationFindingReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Inconclusive",
            "InsufficientData",
            "MemoryOverprovisioned",
            "MemoryUnderprovisioned",
        ]
    }
}
impl AsRef<str> for LambdaFunctionRecommendationFindingReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaFunctionRecommendationFinding {
    #[allow(missing_docs)] // documentation missing in model
    NotOptimized,
    #[allow(missing_docs)] // documentation missing in model
    Optimized,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaFunctionRecommendationFinding {
    fn from(s: &str) -> Self {
        match s {
            "NotOptimized" => LambdaFunctionRecommendationFinding::NotOptimized,
            "Optimized" => LambdaFunctionRecommendationFinding::Optimized,
            "Unavailable" => LambdaFunctionRecommendationFinding::Unavailable,
            other => LambdaFunctionRecommendationFinding::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaFunctionRecommendationFinding {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaFunctionRecommendationFinding::from(s))
    }
}
impl LambdaFunctionRecommendationFinding {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaFunctionRecommendationFinding::NotOptimized => "NotOptimized",
            LambdaFunctionRecommendationFinding::Optimized => "Optimized",
            LambdaFunctionRecommendationFinding::Unavailable => "Unavailable",
            LambdaFunctionRecommendationFinding::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NotOptimized", "Optimized", "Unavailable"]
    }
}
impl AsRef<str> for LambdaFunctionRecommendationFinding {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a utilization metric of an Lambda function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionUtilizationMetric {
    /// <p>The name of the utilization metric.</p>
    ///
    /// <p>The following utilization metrics are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Duration</code> - The amount of time that your function code spends
    /// processing an event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Memory</code> - The amount of memory used per invocation.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<crate::model::LambdaFunctionMetricName>,
    /// <p>The statistic of the utilization metric.</p>
    ///
    /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
    /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
    /// highest value observed during the specified period.</p>
    ///
    /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
    /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
    /// <code>SampleCount</code> during the specified period. For more information, see
    /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
    /// recommendations</a> in the <i>Compute Optimizer User
    /// Guide</i>. You can also get averaged utilization metric data for your resources
    /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
    /// User Guide</a>.</p>
    pub statistic: std::option::Option<crate::model::LambdaFunctionMetricStatistic>,
    /// <p>The value of the utilization metric.</p>
    pub value: f64,
}
impl LambdaFunctionUtilizationMetric {
    /// <p>The name of the utilization metric.</p>
    ///
    /// <p>The following utilization metrics are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Duration</code> - The amount of time that your function code spends
    /// processing an event.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Memory</code> - The amount of memory used per invocation.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&crate::model::LambdaFunctionMetricName> {
        self.name.as_ref()
    }
    /// <p>The statistic of the utilization metric.</p>
    ///
    /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
    /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
    /// highest value observed during the specified period.</p>
    ///
    /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
    /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
    /// <code>SampleCount</code> during the specified period. For more information, see
    /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
    /// recommendations</a> in the <i>Compute Optimizer User
    /// Guide</i>. You can also get averaged utilization metric data for your resources
    /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
    /// User Guide</a>.</p>
    pub fn statistic(&self) -> std::option::Option<&crate::model::LambdaFunctionMetricStatistic> {
        self.statistic.as_ref()
    }
    /// <p>The value of the utilization metric.</p>
    pub fn value(&self) -> f64 {
        self.value
    }
}
impl std::fmt::Debug for LambdaFunctionUtilizationMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionUtilizationMetric");
        formatter.field("name", &self.name);
        formatter.field("statistic", &self.statistic);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`LambdaFunctionUtilizationMetric`](crate::model::LambdaFunctionUtilizationMetric)
pub mod lambda_function_utilization_metric {
    /// A builder for [`LambdaFunctionUtilizationMetric`](crate::model::LambdaFunctionUtilizationMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::LambdaFunctionMetricName>,
        pub(crate) statistic: std::option::Option<crate::model::LambdaFunctionMetricStatistic>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of the utilization metric.</p>
        ///
        /// <p>The following utilization metrics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Duration</code> - The amount of time that your function code spends
        /// processing an event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Memory</code> - The amount of memory used per invocation.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: crate::model::LambdaFunctionMetricName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the utilization metric.</p>
        ///
        /// <p>The following utilization metrics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Duration</code> - The amount of time that your function code spends
        /// processing an event.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Memory</code> - The amount of memory used per invocation.</p>
        /// </li>
        /// </ul>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionMetricName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The statistic of the utilization metric.</p>
        ///
        /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
        /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
        /// highest value observed during the specified period.</p>
        ///
        /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
        /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
        /// <code>SampleCount</code> during the specified period. For more information, see
        /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
        /// recommendations</a> in the <i>Compute Optimizer User
        /// Guide</i>. You can also get averaged utilization metric data for your resources
        /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
        /// User Guide</a>.</p>
        pub fn statistic(mut self, input: crate::model::LambdaFunctionMetricStatistic) -> Self {
            self.statistic = Some(input);
            self
        }
        /// <p>The statistic of the utilization metric.</p>
        ///
        /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
        /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
        /// highest value observed during the specified period.</p>
        ///
        /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
        /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
        /// <code>SampleCount</code> during the specified period. For more information, see
        /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
        /// recommendations</a> in the <i>Compute Optimizer User
        /// Guide</i>. You can also get averaged utilization metric data for your resources
        /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
        /// User Guide</a>.</p>
        pub fn set_statistic(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionMetricStatistic>,
        ) -> Self {
            self.statistic = input;
            self
        }
        /// <p>The value of the utilization metric.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the utilization metric.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionUtilizationMetric`](crate::model::LambdaFunctionUtilizationMetric)
        pub fn build(self) -> crate::model::LambdaFunctionUtilizationMetric {
            crate::model::LambdaFunctionUtilizationMetric {
                name: self.name,
                statistic: self.statistic,
                value: self.value.unwrap_or_default(),
            }
        }
    }
}
impl LambdaFunctionUtilizationMetric {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionUtilizationMetric`](crate::model::LambdaFunctionUtilizationMetric)
    pub fn builder() -> crate::model::lambda_function_utilization_metric::Builder {
        crate::model::lambda_function_utilization_metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaFunctionMetricStatistic {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaFunctionMetricStatistic {
    fn from(s: &str) -> Self {
        match s {
            "Average" => LambdaFunctionMetricStatistic::Average,
            "Maximum" => LambdaFunctionMetricStatistic::Maximum,
            other => LambdaFunctionMetricStatistic::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaFunctionMetricStatistic {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaFunctionMetricStatistic::from(s))
    }
}
impl LambdaFunctionMetricStatistic {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaFunctionMetricStatistic::Average => "Average",
            LambdaFunctionMetricStatistic::Maximum => "Maximum",
            LambdaFunctionMetricStatistic::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Average", "Maximum"]
    }
}
impl AsRef<str> for LambdaFunctionMetricStatistic {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaFunctionMetricName {
    #[allow(missing_docs)] // documentation missing in model
    Duration,
    #[allow(missing_docs)] // documentation missing in model
    Memory,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaFunctionMetricName {
    fn from(s: &str) -> Self {
        match s {
            "Duration" => LambdaFunctionMetricName::Duration,
            "Memory" => LambdaFunctionMetricName::Memory,
            other => LambdaFunctionMetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaFunctionMetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaFunctionMetricName::from(s))
    }
}
impl LambdaFunctionMetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaFunctionMetricName::Duration => "Duration",
            LambdaFunctionMetricName::Memory => "Memory",
            LambdaFunctionMetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Duration", "Memory"]
    }
}
impl AsRef<str> for LambdaFunctionMetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a filter that returns a more specific list of Lambda
/// function recommendations. Use this filter with the <a>GetLambdaFunctionRecommendations</a> action.</p>
///
/// <p>You can use <code>EBSFilter</code> with the <a>GetEBSVolumeRecommendations</a> action, <code>JobFilter</code> with the
/// <a>DescribeRecommendationExportJobs</a> action, and <code>Filter</code>
/// with the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionRecommendationFilter {
    /// <p>The name of the filter.</p>
    ///
    /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
    /// classification (for example, <code>NotOptimized</code>).</p>
    ///
    /// <p>Specify <code>FindingReasonCode</code> to return recommendations with a specific
    /// finding reason code (for example, <code>MemoryUnderprovisioned</code>).</p>
    pub name: std::option::Option<crate::model::LambdaFunctionRecommendationFilterName>,
    /// <p>The value of the filter.</p>
    ///
    /// <p>The valid values for this parameter are as follows, depending on what you specify for
    /// the <code>name</code> parameter:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Specify <code>Optimized</code>, <code>NotOptimized</code>, or
    /// <code>Unavailable</code> if you specify the <code>name</code> parameter as
    /// <code>Finding</code>.</p>
    /// </li>
    /// <li>
    /// <p>Specify <code>MemoryOverprovisioned</code>,
    /// <code>MemoryUnderprovisioned</code>, <code>InsufficientData</code>, or
    /// <code>Inconclusive</code> if you specify the <code>name</code> parameter as
    /// <code>FindingReasonCode</code>.</p>
    /// </li>
    /// </ul>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl LambdaFunctionRecommendationFilter {
    /// <p>The name of the filter.</p>
    ///
    /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
    /// classification (for example, <code>NotOptimized</code>).</p>
    ///
    /// <p>Specify <code>FindingReasonCode</code> to return recommendations with a specific
    /// finding reason code (for example, <code>MemoryUnderprovisioned</code>).</p>
    pub fn name(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionRecommendationFilterName> {
        self.name.as_ref()
    }
    /// <p>The value of the filter.</p>
    ///
    /// <p>The valid values for this parameter are as follows, depending on what you specify for
    /// the <code>name</code> parameter:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Specify <code>Optimized</code>, <code>NotOptimized</code>, or
    /// <code>Unavailable</code> if you specify the <code>name</code> parameter as
    /// <code>Finding</code>.</p>
    /// </li>
    /// <li>
    /// <p>Specify <code>MemoryOverprovisioned</code>,
    /// <code>MemoryUnderprovisioned</code>, <code>InsufficientData</code>, or
    /// <code>Inconclusive</code> if you specify the <code>name</code> parameter as
    /// <code>FindingReasonCode</code>.</p>
    /// </li>
    /// </ul>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for LambdaFunctionRecommendationFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionRecommendationFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`LambdaFunctionRecommendationFilter`](crate::model::LambdaFunctionRecommendationFilter)
pub mod lambda_function_recommendation_filter {
    /// A builder for [`LambdaFunctionRecommendationFilter`](crate::model::LambdaFunctionRecommendationFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::LambdaFunctionRecommendationFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        ///
        /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
        /// classification (for example, <code>NotOptimized</code>).</p>
        ///
        /// <p>Specify <code>FindingReasonCode</code> to return recommendations with a specific
        /// finding reason code (for example, <code>MemoryUnderprovisioned</code>).</p>
        pub fn name(mut self, input: crate::model::LambdaFunctionRecommendationFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the filter.</p>
        ///
        /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
        /// classification (for example, <code>NotOptimized</code>).</p>
        ///
        /// <p>Specify <code>FindingReasonCode</code> to return recommendations with a specific
        /// finding reason code (for example, <code>MemoryUnderprovisioned</code>).</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionRecommendationFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value of the filter.</p>
        ///
        /// <p>The valid values for this parameter are as follows, depending on what you specify for
        /// the <code>name</code> parameter:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Specify <code>Optimized</code>, <code>NotOptimized</code>, or
        /// <code>Unavailable</code> if you specify the <code>name</code> parameter as
        /// <code>Finding</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>MemoryOverprovisioned</code>,
        /// <code>MemoryUnderprovisioned</code>, <code>InsufficientData</code>, or
        /// <code>Inconclusive</code> if you specify the <code>name</code> parameter as
        /// <code>FindingReasonCode</code>.</p>
        /// </li>
        /// </ul>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value of the filter.</p>
        ///
        /// <p>The valid values for this parameter are as follows, depending on what you specify for
        /// the <code>name</code> parameter:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Specify <code>Optimized</code>, <code>NotOptimized</code>, or
        /// <code>Unavailable</code> if you specify the <code>name</code> parameter as
        /// <code>Finding</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>MemoryOverprovisioned</code>,
        /// <code>MemoryUnderprovisioned</code>, <code>InsufficientData</code>, or
        /// <code>Inconclusive</code> if you specify the <code>name</code> parameter as
        /// <code>FindingReasonCode</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionRecommendationFilter`](crate::model::LambdaFunctionRecommendationFilter)
        pub fn build(self) -> crate::model::LambdaFunctionRecommendationFilter {
            crate::model::LambdaFunctionRecommendationFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl LambdaFunctionRecommendationFilter {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionRecommendationFilter`](crate::model::LambdaFunctionRecommendationFilter)
    pub fn builder() -> crate::model::lambda_function_recommendation_filter::Builder {
        crate::model::lambda_function_recommendation_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaFunctionRecommendationFilterName {
    #[allow(missing_docs)] // documentation missing in model
    Finding,
    #[allow(missing_docs)] // documentation missing in model
    FindingReasonCode,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaFunctionRecommendationFilterName {
    fn from(s: &str) -> Self {
        match s {
            "Finding" => LambdaFunctionRecommendationFilterName::Finding,
            "FindingReasonCode" => LambdaFunctionRecommendationFilterName::FindingReasonCode,
            other => LambdaFunctionRecommendationFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaFunctionRecommendationFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaFunctionRecommendationFilterName::from(s))
    }
}
impl LambdaFunctionRecommendationFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaFunctionRecommendationFilterName::Finding => "Finding",
            LambdaFunctionRecommendationFilterName::FindingReasonCode => "FindingReasonCode",
            LambdaFunctionRecommendationFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Finding", "FindingReasonCode"]
    }
}
impl AsRef<str> for LambdaFunctionRecommendationFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the enrollment status of an organization's member accounts in Compute Optimizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountEnrollmentStatus {
    /// <p>The Amazon Web Services account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The account enrollment status.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The reason for the account enrollment status.</p>
    ///
    /// <p>For example, an account might show a status of <code>Pending</code> because member
    /// accounts of an organization require more time to be enrolled in the service.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>The Unix epoch timestamp, in seconds, of when the account enrollment status was last
    /// updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl AccountEnrollmentStatus {
    /// <p>The Amazon Web Services account ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The account enrollment status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>The reason for the account enrollment status.</p>
    ///
    /// <p>For example, an account might show a status of <code>Pending</code> because member
    /// accounts of an organization require more time to be enrolled in the service.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>The Unix epoch timestamp, in seconds, of when the account enrollment status was last
    /// updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for AccountEnrollmentStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountEnrollmentStatus");
        formatter.field("account_id", &self.account_id);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.finish()
    }
}
/// See [`AccountEnrollmentStatus`](crate::model::AccountEnrollmentStatus)
pub mod account_enrollment_status {
    /// A builder for [`AccountEnrollmentStatus`](crate::model::AccountEnrollmentStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The account enrollment status.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The account enrollment status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the account enrollment status.</p>
        ///
        /// <p>For example, an account might show a status of <code>Pending</code> because member
        /// accounts of an organization require more time to be enrolled in the service.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the account enrollment status.</p>
        ///
        /// <p>For example, an account might show a status of <code>Pending</code> because member
        /// accounts of an organization require more time to be enrolled in the service.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>The Unix epoch timestamp, in seconds, of when the account enrollment status was last
        /// updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp, in seconds, of when the account enrollment status was last
        /// updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountEnrollmentStatus`](crate::model::AccountEnrollmentStatus)
        pub fn build(self) -> crate::model::AccountEnrollmentStatus {
            crate::model::AccountEnrollmentStatus {
                account_id: self.account_id,
                status: self.status,
                status_reason: self.status_reason,
                last_updated_timestamp: self.last_updated_timestamp,
            }
        }
    }
}
impl AccountEnrollmentStatus {
    /// Creates a new builder-style object to manufacture [`AccountEnrollmentStatus`](crate::model::AccountEnrollmentStatus)
    pub fn builder() -> crate::model::account_enrollment_status::Builder {
        crate::model::account_enrollment_status::Builder::default()
    }
}

/// <p>Describes a filter that returns a more specific list of account enrollment statuses.
/// Use this filter with the <a>GetEnrollmentStatusesForOrganization</a>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnrollmentFilter {
    /// <p>The name of the filter.</p>
    ///
    /// <p>Specify <code>Status</code> to return accounts with a specific enrollment status (for
    /// example, <code>Active</code>).</p>
    pub name: std::option::Option<crate::model::EnrollmentFilterName>,
    /// <p>The value of the filter.</p>
    ///
    /// <p>The valid values are <code>Active</code>, <code>Inactive</code>, <code>Pending</code>,
    /// and <code>Failed</code>.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EnrollmentFilter {
    /// <p>The name of the filter.</p>
    ///
    /// <p>Specify <code>Status</code> to return accounts with a specific enrollment status (for
    /// example, <code>Active</code>).</p>
    pub fn name(&self) -> std::option::Option<&crate::model::EnrollmentFilterName> {
        self.name.as_ref()
    }
    /// <p>The value of the filter.</p>
    ///
    /// <p>The valid values are <code>Active</code>, <code>Inactive</code>, <code>Pending</code>,
    /// and <code>Failed</code>.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for EnrollmentFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnrollmentFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`EnrollmentFilter`](crate::model::EnrollmentFilter)
pub mod enrollment_filter {
    /// A builder for [`EnrollmentFilter`](crate::model::EnrollmentFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::EnrollmentFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        ///
        /// <p>Specify <code>Status</code> to return accounts with a specific enrollment status (for
        /// example, <code>Active</code>).</p>
        pub fn name(mut self, input: crate::model::EnrollmentFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the filter.</p>
        ///
        /// <p>Specify <code>Status</code> to return accounts with a specific enrollment status (for
        /// example, <code>Active</code>).</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::EnrollmentFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value of the filter.</p>
        ///
        /// <p>The valid values are <code>Active</code>, <code>Inactive</code>, <code>Pending</code>,
        /// and <code>Failed</code>.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value of the filter.</p>
        ///
        /// <p>The valid values are <code>Active</code>, <code>Inactive</code>, <code>Pending</code>,
        /// and <code>Failed</code>.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`EnrollmentFilter`](crate::model::EnrollmentFilter)
        pub fn build(self) -> crate::model::EnrollmentFilter {
            crate::model::EnrollmentFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl EnrollmentFilter {
    /// Creates a new builder-style object to manufacture [`EnrollmentFilter`](crate::model::EnrollmentFilter)
    pub fn builder() -> crate::model::enrollment_filter::Builder {
        crate::model::enrollment_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnrollmentFilterName {
    #[allow(missing_docs)] // documentation missing in model
    Status,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnrollmentFilterName {
    fn from(s: &str) -> Self {
        match s {
            "Status" => EnrollmentFilterName::Status,
            other => EnrollmentFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnrollmentFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnrollmentFilterName::from(s))
    }
}
impl EnrollmentFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnrollmentFilterName::Status => "Status",
            EnrollmentFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Status"]
    }
}
impl AsRef<str> for EnrollmentFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a projected utilization metric of a recommendation option.</p>
///
/// <note>
/// <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected
/// utilization metrics returned when you run the <a>GetEC2RecommendationProjectedMetrics</a> action. Additionally, the
/// <code>Memory</code> metric is returned only for resources that have the unified
/// CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendedOptionProjectedMetric {
    /// <p>The recommended instance type.</p>
    pub recommended_instance_type: std::option::Option<std::string::String>,
    /// <p>The rank of the recommendation option projected metric.</p>
    ///
    /// <p>The top recommendation option is ranked as <code>1</code>.</p>
    ///
    /// <p>The projected metric rank correlates to the recommendation option rank. For example,
    /// the projected metric ranked as <code>1</code> is related to the recommendation option
    /// that is also ranked as <code>1</code> in the same response.</p>
    pub rank: i32,
    /// <p>An array of objects that describe a projected utilization metric.</p>
    pub projected_metrics: std::option::Option<std::vec::Vec<crate::model::ProjectedMetric>>,
}
impl RecommendedOptionProjectedMetric {
    /// <p>The recommended instance type.</p>
    pub fn recommended_instance_type(&self) -> std::option::Option<&str> {
        self.recommended_instance_type.as_deref()
    }
    /// <p>The rank of the recommendation option projected metric.</p>
    ///
    /// <p>The top recommendation option is ranked as <code>1</code>.</p>
    ///
    /// <p>The projected metric rank correlates to the recommendation option rank. For example,
    /// the projected metric ranked as <code>1</code> is related to the recommendation option
    /// that is also ranked as <code>1</code> in the same response.</p>
    pub fn rank(&self) -> i32 {
        self.rank
    }
    /// <p>An array of objects that describe a projected utilization metric.</p>
    pub fn projected_metrics(&self) -> std::option::Option<&[crate::model::ProjectedMetric]> {
        self.projected_metrics.as_deref()
    }
}
impl std::fmt::Debug for RecommendedOptionProjectedMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendedOptionProjectedMetric");
        formatter.field("recommended_instance_type", &self.recommended_instance_type);
        formatter.field("rank", &self.rank);
        formatter.field("projected_metrics", &self.projected_metrics);
        formatter.finish()
    }
}
/// See [`RecommendedOptionProjectedMetric`](crate::model::RecommendedOptionProjectedMetric)
pub mod recommended_option_projected_metric {
    /// A builder for [`RecommendedOptionProjectedMetric`](crate::model::RecommendedOptionProjectedMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommended_instance_type: std::option::Option<std::string::String>,
        pub(crate) rank: std::option::Option<i32>,
        pub(crate) projected_metrics:
            std::option::Option<std::vec::Vec<crate::model::ProjectedMetric>>,
    }
    impl Builder {
        /// <p>The recommended instance type.</p>
        pub fn recommended_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommended_instance_type = Some(input.into());
            self
        }
        /// <p>The recommended instance type.</p>
        pub fn set_recommended_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_instance_type = input;
            self
        }
        /// <p>The rank of the recommendation option projected metric.</p>
        ///
        /// <p>The top recommendation option is ranked as <code>1</code>.</p>
        ///
        /// <p>The projected metric rank correlates to the recommendation option rank. For example,
        /// the projected metric ranked as <code>1</code> is related to the recommendation option
        /// that is also ranked as <code>1</code> in the same response.</p>
        pub fn rank(mut self, input: i32) -> Self {
            self.rank = Some(input);
            self
        }
        /// <p>The rank of the recommendation option projected metric.</p>
        ///
        /// <p>The top recommendation option is ranked as <code>1</code>.</p>
        ///
        /// <p>The projected metric rank correlates to the recommendation option rank. For example,
        /// the projected metric ranked as <code>1</code> is related to the recommendation option
        /// that is also ranked as <code>1</code> in the same response.</p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.rank = input;
            self
        }
        /// Appends an item to `projected_metrics`.
        ///
        /// To override the contents of this collection use [`set_projected_metrics`](Self::set_projected_metrics).
        ///
        /// <p>An array of objects that describe a projected utilization metric.</p>
        pub fn projected_metrics(
            mut self,
            input: impl Into<crate::model::ProjectedMetric>,
        ) -> Self {
            let mut v = self.projected_metrics.unwrap_or_default();
            v.push(input.into());
            self.projected_metrics = Some(v);
            self
        }
        /// <p>An array of objects that describe a projected utilization metric.</p>
        pub fn set_projected_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectedMetric>>,
        ) -> Self {
            self.projected_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendedOptionProjectedMetric`](crate::model::RecommendedOptionProjectedMetric)
        pub fn build(self) -> crate::model::RecommendedOptionProjectedMetric {
            crate::model::RecommendedOptionProjectedMetric {
                recommended_instance_type: self.recommended_instance_type,
                rank: self.rank.unwrap_or_default(),
                projected_metrics: self.projected_metrics,
            }
        }
    }
}
impl RecommendedOptionProjectedMetric {
    /// Creates a new builder-style object to manufacture [`RecommendedOptionProjectedMetric`](crate::model::RecommendedOptionProjectedMetric)
    pub fn builder() -> crate::model::recommended_option_projected_metric::Builder {
        crate::model::recommended_option_projected_metric::Builder::default()
    }
}

/// <p>Describes a projected utilization metric of a recommendation option, such as an
/// Amazon EC2 instance. This represents the projected utilization of a
/// recommendation option had you used that resource during the analyzed period.</p>
///
/// <p>Compare the utilization metric data of your resource against its projected utilization
/// metric data to determine the performance difference between your current resource and
/// the recommended option.</p>
///
/// <note>
/// <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected
/// utilization metrics returned when you run the <a>GetEC2RecommendationProjectedMetrics</a> action. Additionally, the
/// <code>Memory</code> metric is returned only for resources that have the unified
/// CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectedMetric {
    /// <p>The name of the projected utilization metric.</p>
    ///
    /// <p>The following projected utilization metrics are returned:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Cpu</code> - The projected percentage of allocated EC2 compute units
    /// that would be in use on the recommendation option had you used that resource
    /// during the analyzed period. This metric identifies the processing power required
    /// to run an application on the recommendation option.</p>
    /// <p>Depending on the instance type, tools in your operating system can show a
    /// lower percentage than CloudWatch when the instance is not allocated a full
    /// processor core.</p>
    /// <p>Units: Percent</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Memory</code> - The percentage of memory that would be in use on the
    /// recommendation option had you used that resource during the analyzed period.
    /// This metric identifies the amount of memory required to run an application on
    /// the recommendation option.</p>
    /// <p>Units: Percent</p>
    /// <note>
    /// <p>The <code>Memory</code> metric is returned only for resources that have
    /// the unified CloudWatch agent installed on them. For more information,
    /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
    /// Utilization with the CloudWatch Agent</a>.</p>
    /// </note>
    /// </li>
    /// </ul>
    pub name: std::option::Option<crate::model::MetricName>,
    /// <p>The timestamps of the projected utilization metric.</p>
    pub timestamps: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
    /// <p>The values of the projected utilization metrics.</p>
    pub values: std::option::Option<std::vec::Vec<f64>>,
}
impl ProjectedMetric {
    /// <p>The name of the projected utilization metric.</p>
    ///
    /// <p>The following projected utilization metrics are returned:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Cpu</code> - The projected percentage of allocated EC2 compute units
    /// that would be in use on the recommendation option had you used that resource
    /// during the analyzed period. This metric identifies the processing power required
    /// to run an application on the recommendation option.</p>
    /// <p>Depending on the instance type, tools in your operating system can show a
    /// lower percentage than CloudWatch when the instance is not allocated a full
    /// processor core.</p>
    /// <p>Units: Percent</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Memory</code> - The percentage of memory that would be in use on the
    /// recommendation option had you used that resource during the analyzed period.
    /// This metric identifies the amount of memory required to run an application on
    /// the recommendation option.</p>
    /// <p>Units: Percent</p>
    /// <note>
    /// <p>The <code>Memory</code> metric is returned only for resources that have
    /// the unified CloudWatch agent installed on them. For more information,
    /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
    /// Utilization with the CloudWatch Agent</a>.</p>
    /// </note>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&crate::model::MetricName> {
        self.name.as_ref()
    }
    /// <p>The timestamps of the projected utilization metric.</p>
    pub fn timestamps(&self) -> std::option::Option<&[aws_smithy_types::Instant]> {
        self.timestamps.as_deref()
    }
    /// <p>The values of the projected utilization metrics.</p>
    pub fn values(&self) -> std::option::Option<&[f64]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for ProjectedMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectedMetric");
        formatter.field("name", &self.name);
        formatter.field("timestamps", &self.timestamps);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ProjectedMetric`](crate::model::ProjectedMetric)
pub mod projected_metric {
    /// A builder for [`ProjectedMetric`](crate::model::ProjectedMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::MetricName>,
        pub(crate) timestamps: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
        pub(crate) values: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// <p>The name of the projected utilization metric.</p>
        ///
        /// <p>The following projected utilization metrics are returned:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Cpu</code> - The projected percentage of allocated EC2 compute units
        /// that would be in use on the recommendation option had you used that resource
        /// during the analyzed period. This metric identifies the processing power required
        /// to run an application on the recommendation option.</p>
        /// <p>Depending on the instance type, tools in your operating system can show a
        /// lower percentage than CloudWatch when the instance is not allocated a full
        /// processor core.</p>
        /// <p>Units: Percent</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Memory</code> - The percentage of memory that would be in use on the
        /// recommendation option had you used that resource during the analyzed period.
        /// This metric identifies the amount of memory required to run an application on
        /// the recommendation option.</p>
        /// <p>Units: Percent</p>
        /// <note>
        /// <p>The <code>Memory</code> metric is returned only for resources that have
        /// the unified CloudWatch agent installed on them. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
        /// Utilization with the CloudWatch Agent</a>.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: crate::model::MetricName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the projected utilization metric.</p>
        ///
        /// <p>The following projected utilization metrics are returned:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Cpu</code> - The projected percentage of allocated EC2 compute units
        /// that would be in use on the recommendation option had you used that resource
        /// during the analyzed period. This metric identifies the processing power required
        /// to run an application on the recommendation option.</p>
        /// <p>Depending on the instance type, tools in your operating system can show a
        /// lower percentage than CloudWatch when the instance is not allocated a full
        /// processor core.</p>
        /// <p>Units: Percent</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Memory</code> - The percentage of memory that would be in use on the
        /// recommendation option had you used that resource during the analyzed period.
        /// This metric identifies the amount of memory required to run an application on
        /// the recommendation option.</p>
        /// <p>Units: Percent</p>
        /// <note>
        /// <p>The <code>Memory</code> metric is returned only for resources that have
        /// the unified CloudWatch agent installed on them. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
        /// Utilization with the CloudWatch Agent</a>.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<crate::model::MetricName>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `timestamps`.
        ///
        /// To override the contents of this collection use [`set_timestamps`](Self::set_timestamps).
        ///
        /// <p>The timestamps of the projected utilization metric.</p>
        pub fn timestamps(mut self, input: impl Into<aws_smithy_types::Instant>) -> Self {
            let mut v = self.timestamps.unwrap_or_default();
            v.push(input.into());
            self.timestamps = Some(v);
            self
        }
        /// <p>The timestamps of the projected utilization metric.</p>
        pub fn set_timestamps(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
        ) -> Self {
            self.timestamps = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values of the projected utilization metrics.</p>
        pub fn values(mut self, input: impl Into<f64>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values of the projected utilization metrics.</p>
        pub fn set_values(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectedMetric`](crate::model::ProjectedMetric)
        pub fn build(self) -> crate::model::ProjectedMetric {
            crate::model::ProjectedMetric {
                name: self.name,
                timestamps: self.timestamps,
                values: self.values,
            }
        }
    }
}
impl ProjectedMetric {
    /// Creates a new builder-style object to manufacture [`ProjectedMetric`](crate::model::ProjectedMetric)
    pub fn builder() -> crate::model::projected_metric::Builder {
        crate::model::projected_metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricName {
    #[allow(missing_docs)] // documentation missing in model
    Cpu,
    #[allow(missing_docs)] // documentation missing in model
    DiskReadBytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    DiskReadOpsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    DiskWriteBytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    DiskWriteOpsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    EbsReadBytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    EbsReadOpsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    EbsWriteBytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    EbsWriteOpsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Memory,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInBytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    NetworkOutBytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    NetworkPacketsInPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    NetworkPacketsOutPerSecond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricName {
    fn from(s: &str) -> Self {
        match s {
            "Cpu" => MetricName::Cpu,
            "DISK_READ_BYTES_PER_SECOND" => MetricName::DiskReadBytesPerSecond,
            "DISK_READ_OPS_PER_SECOND" => MetricName::DiskReadOpsPerSecond,
            "DISK_WRITE_BYTES_PER_SECOND" => MetricName::DiskWriteBytesPerSecond,
            "DISK_WRITE_OPS_PER_SECOND" => MetricName::DiskWriteOpsPerSecond,
            "EBS_READ_BYTES_PER_SECOND" => MetricName::EbsReadBytesPerSecond,
            "EBS_READ_OPS_PER_SECOND" => MetricName::EbsReadOpsPerSecond,
            "EBS_WRITE_BYTES_PER_SECOND" => MetricName::EbsWriteBytesPerSecond,
            "EBS_WRITE_OPS_PER_SECOND" => MetricName::EbsWriteOpsPerSecond,
            "Memory" => MetricName::Memory,
            "NETWORK_IN_BYTES_PER_SECOND" => MetricName::NetworkInBytesPerSecond,
            "NETWORK_OUT_BYTES_PER_SECOND" => MetricName::NetworkOutBytesPerSecond,
            "NETWORK_PACKETS_IN_PER_SECOND" => MetricName::NetworkPacketsInPerSecond,
            "NETWORK_PACKETS_OUT_PER_SECOND" => MetricName::NetworkPacketsOutPerSecond,
            other => MetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricName::from(s))
    }
}
impl MetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricName::Cpu => "Cpu",
            MetricName::DiskReadBytesPerSecond => "DISK_READ_BYTES_PER_SECOND",
            MetricName::DiskReadOpsPerSecond => "DISK_READ_OPS_PER_SECOND",
            MetricName::DiskWriteBytesPerSecond => "DISK_WRITE_BYTES_PER_SECOND",
            MetricName::DiskWriteOpsPerSecond => "DISK_WRITE_OPS_PER_SECOND",
            MetricName::EbsReadBytesPerSecond => "EBS_READ_BYTES_PER_SECOND",
            MetricName::EbsReadOpsPerSecond => "EBS_READ_OPS_PER_SECOND",
            MetricName::EbsWriteBytesPerSecond => "EBS_WRITE_BYTES_PER_SECOND",
            MetricName::EbsWriteOpsPerSecond => "EBS_WRITE_OPS_PER_SECOND",
            MetricName::Memory => "Memory",
            MetricName::NetworkInBytesPerSecond => "NETWORK_IN_BYTES_PER_SECOND",
            MetricName::NetworkOutBytesPerSecond => "NETWORK_OUT_BYTES_PER_SECOND",
            MetricName::NetworkPacketsInPerSecond => "NETWORK_PACKETS_IN_PER_SECOND",
            MetricName::NetworkPacketsOutPerSecond => "NETWORK_PACKETS_OUT_PER_SECOND",
            MetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Cpu",
            "DISK_READ_BYTES_PER_SECOND",
            "DISK_READ_OPS_PER_SECOND",
            "DISK_WRITE_BYTES_PER_SECOND",
            "DISK_WRITE_OPS_PER_SECOND",
            "EBS_READ_BYTES_PER_SECOND",
            "EBS_READ_OPS_PER_SECOND",
            "EBS_WRITE_BYTES_PER_SECOND",
            "EBS_WRITE_OPS_PER_SECOND",
            "Memory",
            "NETWORK_IN_BYTES_PER_SECOND",
            "NETWORK_OUT_BYTES_PER_SECOND",
            "NETWORK_PACKETS_IN_PER_SECOND",
            "NETWORK_PACKETS_OUT_PER_SECOND",
        ]
    }
}
impl AsRef<str> for MetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes preferences for recommendations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationPreferences {
    /// <p>Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.</p>
    ///
    /// <p>For example, when you specify <code>AWS_ARM64</code> with:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute Optimizer
    /// returns recommendations that consist of Graviton2 instance types only.</p>
    /// </li>
    /// <li>
    /// <p>A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization metrics for Graviton2 instance type
    /// recommendations only.</p>
    /// </li>
    /// <li>
    /// <p>A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute Optimizer
    /// exports recommendations that consist of Graviton2 instance types only.</p>
    /// </li>
    /// </ul>
    pub cpu_vendor_architectures:
        std::option::Option<std::vec::Vec<crate::model::CpuVendorArchitecture>>,
}
impl RecommendationPreferences {
    /// <p>Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.</p>
    ///
    /// <p>For example, when you specify <code>AWS_ARM64</code> with:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute Optimizer
    /// returns recommendations that consist of Graviton2 instance types only.</p>
    /// </li>
    /// <li>
    /// <p>A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization metrics for Graviton2 instance type
    /// recommendations only.</p>
    /// </li>
    /// <li>
    /// <p>A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute Optimizer
    /// exports recommendations that consist of Graviton2 instance types only.</p>
    /// </li>
    /// </ul>
    pub fn cpu_vendor_architectures(
        &self,
    ) -> std::option::Option<&[crate::model::CpuVendorArchitecture]> {
        self.cpu_vendor_architectures.as_deref()
    }
}
impl std::fmt::Debug for RecommendationPreferences {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationPreferences");
        formatter.field("cpu_vendor_architectures", &self.cpu_vendor_architectures);
        formatter.finish()
    }
}
/// See [`RecommendationPreferences`](crate::model::RecommendationPreferences)
pub mod recommendation_preferences {
    /// A builder for [`RecommendationPreferences`](crate::model::RecommendationPreferences)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_vendor_architectures:
            std::option::Option<std::vec::Vec<crate::model::CpuVendorArchitecture>>,
    }
    impl Builder {
        /// Appends an item to `cpu_vendor_architectures`.
        ///
        /// To override the contents of this collection use [`set_cpu_vendor_architectures`](Self::set_cpu_vendor_architectures).
        ///
        /// <p>Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.</p>
        ///
        /// <p>For example, when you specify <code>AWS_ARM64</code> with:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute Optimizer
        /// returns recommendations that consist of Graviton2 instance types only.</p>
        /// </li>
        /// <li>
        /// <p>A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization metrics for Graviton2 instance type
        /// recommendations only.</p>
        /// </li>
        /// <li>
        /// <p>A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute Optimizer
        /// exports recommendations that consist of Graviton2 instance types only.</p>
        /// </li>
        /// </ul>
        pub fn cpu_vendor_architectures(
            mut self,
            input: impl Into<crate::model::CpuVendorArchitecture>,
        ) -> Self {
            let mut v = self.cpu_vendor_architectures.unwrap_or_default();
            v.push(input.into());
            self.cpu_vendor_architectures = Some(v);
            self
        }
        /// <p>Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.</p>
        ///
        /// <p>For example, when you specify <code>AWS_ARM64</code> with:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute Optimizer
        /// returns recommendations that consist of Graviton2 instance types only.</p>
        /// </li>
        /// <li>
        /// <p>A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization metrics for Graviton2 instance type
        /// recommendations only.</p>
        /// </li>
        /// <li>
        /// <p>A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute Optimizer
        /// exports recommendations that consist of Graviton2 instance types only.</p>
        /// </li>
        /// </ul>
        pub fn set_cpu_vendor_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CpuVendorArchitecture>>,
        ) -> Self {
            self.cpu_vendor_architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationPreferences`](crate::model::RecommendationPreferences)
        pub fn build(self) -> crate::model::RecommendationPreferences {
            crate::model::RecommendationPreferences {
                cpu_vendor_architectures: self.cpu_vendor_architectures,
            }
        }
    }
}
impl RecommendationPreferences {
    /// Creates a new builder-style object to manufacture [`RecommendationPreferences`](crate::model::RecommendationPreferences)
    pub fn builder() -> crate::model::recommendation_preferences::Builder {
        crate::model::recommendation_preferences::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CpuVendorArchitecture {
    #[allow(missing_docs)] // documentation missing in model
    AwsArm64,
    #[allow(missing_docs)] // documentation missing in model
    Current,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CpuVendorArchitecture {
    fn from(s: &str) -> Self {
        match s {
            "AWS_ARM64" => CpuVendorArchitecture::AwsArm64,
            "CURRENT" => CpuVendorArchitecture::Current,
            other => CpuVendorArchitecture::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CpuVendorArchitecture {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CpuVendorArchitecture::from(s))
    }
}
impl CpuVendorArchitecture {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CpuVendorArchitecture::AwsArm64 => "AWS_ARM64",
            CpuVendorArchitecture::Current => "CURRENT",
            CpuVendorArchitecture::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_ARM64", "CURRENT"]
    }
}
impl AsRef<str> for CpuVendorArchitecture {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricStatistic {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricStatistic {
    fn from(s: &str) -> Self {
        match s {
            "Average" => MetricStatistic::Average,
            "Maximum" => MetricStatistic::Maximum,
            other => MetricStatistic::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricStatistic {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricStatistic::from(s))
    }
}
impl MetricStatistic {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricStatistic::Average => "Average",
            MetricStatistic::Maximum => "Maximum",
            MetricStatistic::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Average", "Maximum"]
    }
}
impl AsRef<str> for MetricStatistic {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an error experienced when getting recommendations.</p>
///
/// <p>For example, an error is returned if you request recommendations for an unsupported
/// Auto Scaling group, or if you request recommendations for an instance of an
/// unsupported instance family.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecommendationError {
    /// <p>The ID of the error.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message, or reason, for the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl GetRecommendationError {
    /// <p>The ID of the error.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The error code.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The message, or reason, for the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for GetRecommendationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecommendationError");
        formatter.field("identifier", &self.identifier);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`GetRecommendationError`](crate::model::GetRecommendationError)
pub mod get_recommendation_error {
    /// A builder for [`GetRecommendationError`](crate::model::GetRecommendationError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the error.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The ID of the error.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message, or reason, for the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message, or reason, for the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecommendationError`](crate::model::GetRecommendationError)
        pub fn build(self) -> crate::model::GetRecommendationError {
            crate::model::GetRecommendationError {
                identifier: self.identifier,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl GetRecommendationError {
    /// Creates a new builder-style object to manufacture [`GetRecommendationError`](crate::model::GetRecommendationError)
    pub fn builder() -> crate::model::get_recommendation_error::Builder {
        crate::model::get_recommendation_error::Builder::default()
    }
}

/// <p>Describes an Amazon EC2 instance recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceRecommendation {
    /// <p>The Amazon Resource Name (ARN) of the current instance.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the instance.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the current instance.</p>
    pub instance_name: std::option::Option<std::string::String>,
    /// <p>The instance type of the current instance.</p>
    pub current_instance_type: std::option::Option<std::string::String>,
    /// <p>The finding classification of the instance.</p>
    ///
    /// <p>Findings for instances include:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Underprovisioned</code>
    /// </b>—An instance is
    /// considered under-provisioned when at least one specification of your instance,
    /// such as CPU, memory, or network, does not meet the performance requirements of
    /// your workload. Under-provisioned instances may lead to poor application
    /// performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Overprovisioned</code>
    /// </b>—An instance is
    /// considered over-provisioned when at least one specification of your instance,
    /// such as CPU, memory, or network, can be sized down while still meeting the
    /// performance requirements of your workload, and no specification is
    /// under-provisioned. Over-provisioned instances may lead to unnecessary
    /// infrastructure cost.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Optimized</code>
    /// </b>—An instance is
    /// considered optimized when all specifications of your instance, such as CPU,
    /// memory, and network, meet the performance requirements of your workload and is
    /// not over provisioned. For optimized resources, Compute Optimizer might
    /// recommend a new generation instance type.</p>
    /// </li>
    /// </ul>
    pub finding: std::option::Option<crate::model::Finding>,
    /// <p>The reason for the finding classification of the instance.</p>
    ///
    /// <p>Finding reason codes for instances include:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>CPUOverprovisioned</code>
    /// </b> — The
    /// instance’s CPU configuration can be sized down while still meeting the
    /// performance requirements of your workload. This is identified by analyzing the
    /// <code>CPUUtilization</code> metric of the current instance during the
    /// look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>CPUUnderprovisioned</code>
    /// </b> — The
    /// instance’s CPU configuration doesn't meet the performance requirements of your
    /// workload and there is an alternative instance type that provides better CPU
    /// performance. This is identified by analyzing the <code>CPUUtilization</code>
    /// metric of the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryOverprovisioned</code>
    /// </b> — The
    /// instance’s memory configuration can be sized down while still meeting the
    /// performance requirements of your workload. This is identified by analyzing the
    /// memory utilization metric of the current instance during the look-back
    /// period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryUnderprovisioned</code>
    /// </b> — The
    /// instance’s memory configuration doesn't meet the performance requirements of
    /// your workload and there is an alternative instance type that provides better
    /// memory performance. This is identified by analyzing the memory utilization
    /// metric of the current instance during the look-back period.</p>
    ///
    /// <note>
    /// <p>Memory utilization is analyzed only for resources that have the unified
    /// CloudWatch agent installed on them. For more information, see
    /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory
    /// utilization with the Amazon CloudWatch Agent</a> in the
    /// <i>Compute Optimizer User Guide</i>. On Linux
    /// instances, Compute Optimizer analyses the <code>mem_used_percent</code>
    /// metric in the <code>CWAgent</code> namespace, or the legacy
    /// <code>MemoryUtilization</code> metric in the <code>System/Linux</code>
    /// namespace. On Windows instances, Compute Optimizer analyses the <code>Memory
    /// % Committed Bytes In Use</code> metric in the <code>CWAgent</code>
    /// namespace.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSThroughputOverprovisioned</code>
    /// </b> —
    /// The instance’s EBS throughput configuration can be sized down while still
    /// meeting the performance requirements of your workload. This is identified by
    /// analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metrics
    /// of EBS volumes attached to the current instance during the look-back
    /// period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSThroughputUnderprovisioned</code>
    /// </b> —
    /// The instance’s EBS throughput configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type that
    /// provides better EBS throughput performance. This is identified by analyzing the
    /// <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metrics of EBS
    /// volumes attached to the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSIOPSOverprovisioned</code>
    /// </b> — The
    /// instance’s EBS IOPS configuration can be sized down while still meeting the
    /// performance requirements of your workload. This is identified by analyzing the
    /// <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metric of EBS
    /// volumes attached to the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSIOPSUnderprovisioned</code>
    /// </b> — The
    /// instance’s EBS IOPS configuration doesn't meet the performance requirements of
    /// your workload and there is an alternative instance type that provides better EBS
    /// IOPS performance. This is identified by analyzing the
    /// <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metric of EBS
    /// volumes attached to the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkBandwidthOverprovisioned</code>
    /// </b>
    /// — The instance’s network bandwidth configuration can be sized down while still
    /// meeting the performance requirements of your workload. This is identified by
    /// analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the
    /// current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkBandwidthUnderprovisioned</code>
    /// </b>
    /// — The instance’s network bandwidth configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type that
    /// provides better network bandwidth performance. This is identified by analyzing
    /// the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current
    /// instance during the look-back period. This finding reason happens when the
    /// <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance
    /// is impacted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkPPSOverprovisioned</code>
    /// </b> — The
    /// instance’s network PPS (packets per second) configuration can be sized down
    /// while still meeting the performance requirements of your workload. This is
    /// identified by analyzing the <code>NetworkPacketsIn</code> and
    /// <code>NetworkPacketsIn</code> metrics of the current instance during the
    /// look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkPPSUnderprovisioned</code>
    /// </b> — The
    /// instance’s network PPS (packets per second) configuration doesn't meet the
    /// performance requirements of your workload and there is an alternative instance
    /// type that provides better network PPS performance. This is identified by
    /// analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code>
    /// metrics of the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskIOPSOverprovisioned</code>
    /// </b> — The
    /// instance’s disk IOPS configuration can be sized down while still meeting the
    /// performance requirements of your workload. This is identified by analyzing the
    /// <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the
    /// current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskIOPSUnderprovisioned</code>
    /// </b> — The
    /// instance’s disk IOPS configuration doesn't meet the performance requirements of
    /// your workload and there is an alternative instance type that provides better
    /// disk IOPS performance. This is identified by analyzing the
    /// <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the
    /// current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskThroughputOverprovisioned</code>
    /// </b> —
    /// The instance’s disk throughput configuration can be sized down while still
    /// meeting the performance requirements of your workload. This is identified by
    /// analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics
    /// of the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskThroughputUnderprovisioned</code>
    /// </b> —
    /// The instance’s disk throughput configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type that
    /// provides better disk throughput performance. This is identified by analyzing the
    /// <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the
    /// current instance during the look-back period.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>For more information about instance metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
    /// available CloudWatch metrics for your instances</a> in the
    /// <i>Amazon Elastic Compute Cloud User Guide</i>. For more information
    /// about EBS volume metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch
    /// metrics for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud
    /// User Guide</i>.</p>
    /// </note>
    pub finding_reason_codes:
        std::option::Option<std::vec::Vec<crate::model::InstanceRecommendationFindingReasonCode>>,
    /// <p>An array of objects that describe the utilization metrics of the instance.</p>
    pub utilization_metrics: std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
    /// <p>The number of days for which utilization metrics were analyzed for the
    /// instance.</p>
    pub look_back_period_in_days: f64,
    /// <p>An array of objects that describe the recommendation options for the instance.</p>
    pub recommendation_options:
        std::option::Option<std::vec::Vec<crate::model::InstanceRecommendationOption>>,
    /// <p>An array of objects that describe the source resource of the recommendation.</p>
    pub recommendation_sources:
        std::option::Option<std::vec::Vec<crate::model::RecommendationSource>>,
    /// <p>The timestamp of when the instance recommendation was last refreshed.</p>
    pub last_refresh_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl InstanceRecommendation {
    /// <p>The Amazon Resource Name (ARN) of the current instance.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the instance.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the current instance.</p>
    pub fn instance_name(&self) -> std::option::Option<&str> {
        self.instance_name.as_deref()
    }
    /// <p>The instance type of the current instance.</p>
    pub fn current_instance_type(&self) -> std::option::Option<&str> {
        self.current_instance_type.as_deref()
    }
    /// <p>The finding classification of the instance.</p>
    ///
    /// <p>Findings for instances include:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Underprovisioned</code>
    /// </b>—An instance is
    /// considered under-provisioned when at least one specification of your instance,
    /// such as CPU, memory, or network, does not meet the performance requirements of
    /// your workload. Under-provisioned instances may lead to poor application
    /// performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Overprovisioned</code>
    /// </b>—An instance is
    /// considered over-provisioned when at least one specification of your instance,
    /// such as CPU, memory, or network, can be sized down while still meeting the
    /// performance requirements of your workload, and no specification is
    /// under-provisioned. Over-provisioned instances may lead to unnecessary
    /// infrastructure cost.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Optimized</code>
    /// </b>—An instance is
    /// considered optimized when all specifications of your instance, such as CPU,
    /// memory, and network, meet the performance requirements of your workload and is
    /// not over provisioned. For optimized resources, Compute Optimizer might
    /// recommend a new generation instance type.</p>
    /// </li>
    /// </ul>
    pub fn finding(&self) -> std::option::Option<&crate::model::Finding> {
        self.finding.as_ref()
    }
    /// <p>The reason for the finding classification of the instance.</p>
    ///
    /// <p>Finding reason codes for instances include:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>CPUOverprovisioned</code>
    /// </b> — The
    /// instance’s CPU configuration can be sized down while still meeting the
    /// performance requirements of your workload. This is identified by analyzing the
    /// <code>CPUUtilization</code> metric of the current instance during the
    /// look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>CPUUnderprovisioned</code>
    /// </b> — The
    /// instance’s CPU configuration doesn't meet the performance requirements of your
    /// workload and there is an alternative instance type that provides better CPU
    /// performance. This is identified by analyzing the <code>CPUUtilization</code>
    /// metric of the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryOverprovisioned</code>
    /// </b> — The
    /// instance’s memory configuration can be sized down while still meeting the
    /// performance requirements of your workload. This is identified by analyzing the
    /// memory utilization metric of the current instance during the look-back
    /// period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryUnderprovisioned</code>
    /// </b> — The
    /// instance’s memory configuration doesn't meet the performance requirements of
    /// your workload and there is an alternative instance type that provides better
    /// memory performance. This is identified by analyzing the memory utilization
    /// metric of the current instance during the look-back period.</p>
    ///
    /// <note>
    /// <p>Memory utilization is analyzed only for resources that have the unified
    /// CloudWatch agent installed on them. For more information, see
    /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory
    /// utilization with the Amazon CloudWatch Agent</a> in the
    /// <i>Compute Optimizer User Guide</i>. On Linux
    /// instances, Compute Optimizer analyses the <code>mem_used_percent</code>
    /// metric in the <code>CWAgent</code> namespace, or the legacy
    /// <code>MemoryUtilization</code> metric in the <code>System/Linux</code>
    /// namespace. On Windows instances, Compute Optimizer analyses the <code>Memory
    /// % Committed Bytes In Use</code> metric in the <code>CWAgent</code>
    /// namespace.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSThroughputOverprovisioned</code>
    /// </b> —
    /// The instance’s EBS throughput configuration can be sized down while still
    /// meeting the performance requirements of your workload. This is identified by
    /// analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metrics
    /// of EBS volumes attached to the current instance during the look-back
    /// period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSThroughputUnderprovisioned</code>
    /// </b> —
    /// The instance’s EBS throughput configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type that
    /// provides better EBS throughput performance. This is identified by analyzing the
    /// <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metrics of EBS
    /// volumes attached to the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSIOPSOverprovisioned</code>
    /// </b> — The
    /// instance’s EBS IOPS configuration can be sized down while still meeting the
    /// performance requirements of your workload. This is identified by analyzing the
    /// <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metric of EBS
    /// volumes attached to the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSIOPSUnderprovisioned</code>
    /// </b> — The
    /// instance’s EBS IOPS configuration doesn't meet the performance requirements of
    /// your workload and there is an alternative instance type that provides better EBS
    /// IOPS performance. This is identified by analyzing the
    /// <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metric of EBS
    /// volumes attached to the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkBandwidthOverprovisioned</code>
    /// </b>
    /// — The instance’s network bandwidth configuration can be sized down while still
    /// meeting the performance requirements of your workload. This is identified by
    /// analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the
    /// current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkBandwidthUnderprovisioned</code>
    /// </b>
    /// — The instance’s network bandwidth configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type that
    /// provides better network bandwidth performance. This is identified by analyzing
    /// the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current
    /// instance during the look-back period. This finding reason happens when the
    /// <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance
    /// is impacted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkPPSOverprovisioned</code>
    /// </b> — The
    /// instance’s network PPS (packets per second) configuration can be sized down
    /// while still meeting the performance requirements of your workload. This is
    /// identified by analyzing the <code>NetworkPacketsIn</code> and
    /// <code>NetworkPacketsIn</code> metrics of the current instance during the
    /// look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkPPSUnderprovisioned</code>
    /// </b> — The
    /// instance’s network PPS (packets per second) configuration doesn't meet the
    /// performance requirements of your workload and there is an alternative instance
    /// type that provides better network PPS performance. This is identified by
    /// analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code>
    /// metrics of the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskIOPSOverprovisioned</code>
    /// </b> — The
    /// instance’s disk IOPS configuration can be sized down while still meeting the
    /// performance requirements of your workload. This is identified by analyzing the
    /// <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the
    /// current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskIOPSUnderprovisioned</code>
    /// </b> — The
    /// instance’s disk IOPS configuration doesn't meet the performance requirements of
    /// your workload and there is an alternative instance type that provides better
    /// disk IOPS performance. This is identified by analyzing the
    /// <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the
    /// current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskThroughputOverprovisioned</code>
    /// </b> —
    /// The instance’s disk throughput configuration can be sized down while still
    /// meeting the performance requirements of your workload. This is identified by
    /// analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics
    /// of the current instance during the look-back period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskThroughputUnderprovisioned</code>
    /// </b> —
    /// The instance’s disk throughput configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type that
    /// provides better disk throughput performance. This is identified by analyzing the
    /// <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the
    /// current instance during the look-back period.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>For more information about instance metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
    /// available CloudWatch metrics for your instances</a> in the
    /// <i>Amazon Elastic Compute Cloud User Guide</i>. For more information
    /// about EBS volume metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch
    /// metrics for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud
    /// User Guide</i>.</p>
    /// </note>
    pub fn finding_reason_codes(
        &self,
    ) -> std::option::Option<&[crate::model::InstanceRecommendationFindingReasonCode]> {
        self.finding_reason_codes.as_deref()
    }
    /// <p>An array of objects that describe the utilization metrics of the instance.</p>
    pub fn utilization_metrics(&self) -> std::option::Option<&[crate::model::UtilizationMetric]> {
        self.utilization_metrics.as_deref()
    }
    /// <p>The number of days for which utilization metrics were analyzed for the
    /// instance.</p>
    pub fn look_back_period_in_days(&self) -> f64 {
        self.look_back_period_in_days
    }
    /// <p>An array of objects that describe the recommendation options for the instance.</p>
    pub fn recommendation_options(
        &self,
    ) -> std::option::Option<&[crate::model::InstanceRecommendationOption]> {
        self.recommendation_options.as_deref()
    }
    /// <p>An array of objects that describe the source resource of the recommendation.</p>
    pub fn recommendation_sources(
        &self,
    ) -> std::option::Option<&[crate::model::RecommendationSource]> {
        self.recommendation_sources.as_deref()
    }
    /// <p>The timestamp of when the instance recommendation was last refreshed.</p>
    pub fn last_refresh_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_refresh_timestamp.as_ref()
    }
}
impl std::fmt::Debug for InstanceRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceRecommendation");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("account_id", &self.account_id);
        formatter.field("instance_name", &self.instance_name);
        formatter.field("current_instance_type", &self.current_instance_type);
        formatter.field("finding", &self.finding);
        formatter.field("finding_reason_codes", &self.finding_reason_codes);
        formatter.field("utilization_metrics", &self.utilization_metrics);
        formatter.field("look_back_period_in_days", &self.look_back_period_in_days);
        formatter.field("recommendation_options", &self.recommendation_options);
        formatter.field("recommendation_sources", &self.recommendation_sources);
        formatter.field("last_refresh_timestamp", &self.last_refresh_timestamp);
        formatter.finish()
    }
}
/// See [`InstanceRecommendation`](crate::model::InstanceRecommendation)
pub mod instance_recommendation {
    /// A builder for [`InstanceRecommendation`](crate::model::InstanceRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) current_instance_type: std::option::Option<std::string::String>,
        pub(crate) finding: std::option::Option<crate::model::Finding>,
        pub(crate) finding_reason_codes: std::option::Option<
            std::vec::Vec<crate::model::InstanceRecommendationFindingReasonCode>,
        >,
        pub(crate) utilization_metrics:
            std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
        pub(crate) look_back_period_in_days: std::option::Option<f64>,
        pub(crate) recommendation_options:
            std::option::Option<std::vec::Vec<crate::model::InstanceRecommendationOption>>,
        pub(crate) recommendation_sources:
            std::option::Option<std::vec::Vec<crate::model::RecommendationSource>>,
        pub(crate) last_refresh_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the current instance.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the current instance.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the instance.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the instance.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the current instance.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the current instance.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// <p>The instance type of the current instance.</p>
        pub fn current_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_instance_type = Some(input.into());
            self
        }
        /// <p>The instance type of the current instance.</p>
        pub fn set_current_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_instance_type = input;
            self
        }
        /// <p>The finding classification of the instance.</p>
        ///
        /// <p>Findings for instances include:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Underprovisioned</code>
        /// </b>—An instance is
        /// considered under-provisioned when at least one specification of your instance,
        /// such as CPU, memory, or network, does not meet the performance requirements of
        /// your workload. Under-provisioned instances may lead to poor application
        /// performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Overprovisioned</code>
        /// </b>—An instance is
        /// considered over-provisioned when at least one specification of your instance,
        /// such as CPU, memory, or network, can be sized down while still meeting the
        /// performance requirements of your workload, and no specification is
        /// under-provisioned. Over-provisioned instances may lead to unnecessary
        /// infrastructure cost.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Optimized</code>
        /// </b>—An instance is
        /// considered optimized when all specifications of your instance, such as CPU,
        /// memory, and network, meet the performance requirements of your workload and is
        /// not over provisioned. For optimized resources, Compute Optimizer might
        /// recommend a new generation instance type.</p>
        /// </li>
        /// </ul>
        pub fn finding(mut self, input: crate::model::Finding) -> Self {
            self.finding = Some(input);
            self
        }
        /// <p>The finding classification of the instance.</p>
        ///
        /// <p>Findings for instances include:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Underprovisioned</code>
        /// </b>—An instance is
        /// considered under-provisioned when at least one specification of your instance,
        /// such as CPU, memory, or network, does not meet the performance requirements of
        /// your workload. Under-provisioned instances may lead to poor application
        /// performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Overprovisioned</code>
        /// </b>—An instance is
        /// considered over-provisioned when at least one specification of your instance,
        /// such as CPU, memory, or network, can be sized down while still meeting the
        /// performance requirements of your workload, and no specification is
        /// under-provisioned. Over-provisioned instances may lead to unnecessary
        /// infrastructure cost.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Optimized</code>
        /// </b>—An instance is
        /// considered optimized when all specifications of your instance, such as CPU,
        /// memory, and network, meet the performance requirements of your workload and is
        /// not over provisioned. For optimized resources, Compute Optimizer might
        /// recommend a new generation instance type.</p>
        /// </li>
        /// </ul>
        pub fn set_finding(mut self, input: std::option::Option<crate::model::Finding>) -> Self {
            self.finding = input;
            self
        }
        /// Appends an item to `finding_reason_codes`.
        ///
        /// To override the contents of this collection use [`set_finding_reason_codes`](Self::set_finding_reason_codes).
        ///
        /// <p>The reason for the finding classification of the instance.</p>
        ///
        /// <p>Finding reason codes for instances include:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUOverprovisioned</code>
        /// </b> — The
        /// instance’s CPU configuration can be sized down while still meeting the
        /// performance requirements of your workload. This is identified by analyzing the
        /// <code>CPUUtilization</code> metric of the current instance during the
        /// look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUUnderprovisioned</code>
        /// </b> — The
        /// instance’s CPU configuration doesn't meet the performance requirements of your
        /// workload and there is an alternative instance type that provides better CPU
        /// performance. This is identified by analyzing the <code>CPUUtilization</code>
        /// metric of the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryOverprovisioned</code>
        /// </b> — The
        /// instance’s memory configuration can be sized down while still meeting the
        /// performance requirements of your workload. This is identified by analyzing the
        /// memory utilization metric of the current instance during the look-back
        /// period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryUnderprovisioned</code>
        /// </b> — The
        /// instance’s memory configuration doesn't meet the performance requirements of
        /// your workload and there is an alternative instance type that provides better
        /// memory performance. This is identified by analyzing the memory utilization
        /// metric of the current instance during the look-back period.</p>
        ///
        /// <note>
        /// <p>Memory utilization is analyzed only for resources that have the unified
        /// CloudWatch agent installed on them. For more information, see
        /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory
        /// utilization with the Amazon CloudWatch Agent</a> in the
        /// <i>Compute Optimizer User Guide</i>. On Linux
        /// instances, Compute Optimizer analyses the <code>mem_used_percent</code>
        /// metric in the <code>CWAgent</code> namespace, or the legacy
        /// <code>MemoryUtilization</code> metric in the <code>System/Linux</code>
        /// namespace. On Windows instances, Compute Optimizer analyses the <code>Memory
        /// % Committed Bytes In Use</code> metric in the <code>CWAgent</code>
        /// namespace.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSThroughputOverprovisioned</code>
        /// </b> —
        /// The instance’s EBS throughput configuration can be sized down while still
        /// meeting the performance requirements of your workload. This is identified by
        /// analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metrics
        /// of EBS volumes attached to the current instance during the look-back
        /// period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSThroughputUnderprovisioned</code>
        /// </b> —
        /// The instance’s EBS throughput configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type that
        /// provides better EBS throughput performance. This is identified by analyzing the
        /// <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metrics of EBS
        /// volumes attached to the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSIOPSOverprovisioned</code>
        /// </b> — The
        /// instance’s EBS IOPS configuration can be sized down while still meeting the
        /// performance requirements of your workload. This is identified by analyzing the
        /// <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metric of EBS
        /// volumes attached to the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSIOPSUnderprovisioned</code>
        /// </b> — The
        /// instance’s EBS IOPS configuration doesn't meet the performance requirements of
        /// your workload and there is an alternative instance type that provides better EBS
        /// IOPS performance. This is identified by analyzing the
        /// <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metric of EBS
        /// volumes attached to the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkBandwidthOverprovisioned</code>
        /// </b>
        /// — The instance’s network bandwidth configuration can be sized down while still
        /// meeting the performance requirements of your workload. This is identified by
        /// analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the
        /// current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkBandwidthUnderprovisioned</code>
        /// </b>
        /// — The instance’s network bandwidth configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type that
        /// provides better network bandwidth performance. This is identified by analyzing
        /// the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current
        /// instance during the look-back period. This finding reason happens when the
        /// <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance
        /// is impacted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkPPSOverprovisioned</code>
        /// </b> — The
        /// instance’s network PPS (packets per second) configuration can be sized down
        /// while still meeting the performance requirements of your workload. This is
        /// identified by analyzing the <code>NetworkPacketsIn</code> and
        /// <code>NetworkPacketsIn</code> metrics of the current instance during the
        /// look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkPPSUnderprovisioned</code>
        /// </b> — The
        /// instance’s network PPS (packets per second) configuration doesn't meet the
        /// performance requirements of your workload and there is an alternative instance
        /// type that provides better network PPS performance. This is identified by
        /// analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code>
        /// metrics of the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskIOPSOverprovisioned</code>
        /// </b> — The
        /// instance’s disk IOPS configuration can be sized down while still meeting the
        /// performance requirements of your workload. This is identified by analyzing the
        /// <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the
        /// current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskIOPSUnderprovisioned</code>
        /// </b> — The
        /// instance’s disk IOPS configuration doesn't meet the performance requirements of
        /// your workload and there is an alternative instance type that provides better
        /// disk IOPS performance. This is identified by analyzing the
        /// <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the
        /// current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskThroughputOverprovisioned</code>
        /// </b> —
        /// The instance’s disk throughput configuration can be sized down while still
        /// meeting the performance requirements of your workload. This is identified by
        /// analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics
        /// of the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskThroughputUnderprovisioned</code>
        /// </b> —
        /// The instance’s disk throughput configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type that
        /// provides better disk throughput performance. This is identified by analyzing the
        /// <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the
        /// current instance during the look-back period.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>For more information about instance metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
        /// available CloudWatch metrics for your instances</a> in the
        /// <i>Amazon Elastic Compute Cloud User Guide</i>. For more information
        /// about EBS volume metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch
        /// metrics for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud
        /// User Guide</i>.</p>
        /// </note>
        pub fn finding_reason_codes(
            mut self,
            input: impl Into<crate::model::InstanceRecommendationFindingReasonCode>,
        ) -> Self {
            let mut v = self.finding_reason_codes.unwrap_or_default();
            v.push(input.into());
            self.finding_reason_codes = Some(v);
            self
        }
        /// <p>The reason for the finding classification of the instance.</p>
        ///
        /// <p>Finding reason codes for instances include:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUOverprovisioned</code>
        /// </b> — The
        /// instance’s CPU configuration can be sized down while still meeting the
        /// performance requirements of your workload. This is identified by analyzing the
        /// <code>CPUUtilization</code> metric of the current instance during the
        /// look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUUnderprovisioned</code>
        /// </b> — The
        /// instance’s CPU configuration doesn't meet the performance requirements of your
        /// workload and there is an alternative instance type that provides better CPU
        /// performance. This is identified by analyzing the <code>CPUUtilization</code>
        /// metric of the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryOverprovisioned</code>
        /// </b> — The
        /// instance’s memory configuration can be sized down while still meeting the
        /// performance requirements of your workload. This is identified by analyzing the
        /// memory utilization metric of the current instance during the look-back
        /// period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryUnderprovisioned</code>
        /// </b> — The
        /// instance’s memory configuration doesn't meet the performance requirements of
        /// your workload and there is an alternative instance type that provides better
        /// memory performance. This is identified by analyzing the memory utilization
        /// metric of the current instance during the look-back period.</p>
        ///
        /// <note>
        /// <p>Memory utilization is analyzed only for resources that have the unified
        /// CloudWatch agent installed on them. For more information, see
        /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory
        /// utilization with the Amazon CloudWatch Agent</a> in the
        /// <i>Compute Optimizer User Guide</i>. On Linux
        /// instances, Compute Optimizer analyses the <code>mem_used_percent</code>
        /// metric in the <code>CWAgent</code> namespace, or the legacy
        /// <code>MemoryUtilization</code> metric in the <code>System/Linux</code>
        /// namespace. On Windows instances, Compute Optimizer analyses the <code>Memory
        /// % Committed Bytes In Use</code> metric in the <code>CWAgent</code>
        /// namespace.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSThroughputOverprovisioned</code>
        /// </b> —
        /// The instance’s EBS throughput configuration can be sized down while still
        /// meeting the performance requirements of your workload. This is identified by
        /// analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metrics
        /// of EBS volumes attached to the current instance during the look-back
        /// period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSThroughputUnderprovisioned</code>
        /// </b> —
        /// The instance’s EBS throughput configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type that
        /// provides better EBS throughput performance. This is identified by analyzing the
        /// <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metrics of EBS
        /// volumes attached to the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSIOPSOverprovisioned</code>
        /// </b> — The
        /// instance’s EBS IOPS configuration can be sized down while still meeting the
        /// performance requirements of your workload. This is identified by analyzing the
        /// <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metric of EBS
        /// volumes attached to the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSIOPSUnderprovisioned</code>
        /// </b> — The
        /// instance’s EBS IOPS configuration doesn't meet the performance requirements of
        /// your workload and there is an alternative instance type that provides better EBS
        /// IOPS performance. This is identified by analyzing the
        /// <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metric of EBS
        /// volumes attached to the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkBandwidthOverprovisioned</code>
        /// </b>
        /// — The instance’s network bandwidth configuration can be sized down while still
        /// meeting the performance requirements of your workload. This is identified by
        /// analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the
        /// current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkBandwidthUnderprovisioned</code>
        /// </b>
        /// — The instance’s network bandwidth configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type that
        /// provides better network bandwidth performance. This is identified by analyzing
        /// the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current
        /// instance during the look-back period. This finding reason happens when the
        /// <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance
        /// is impacted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkPPSOverprovisioned</code>
        /// </b> — The
        /// instance’s network PPS (packets per second) configuration can be sized down
        /// while still meeting the performance requirements of your workload. This is
        /// identified by analyzing the <code>NetworkPacketsIn</code> and
        /// <code>NetworkPacketsIn</code> metrics of the current instance during the
        /// look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkPPSUnderprovisioned</code>
        /// </b> — The
        /// instance’s network PPS (packets per second) configuration doesn't meet the
        /// performance requirements of your workload and there is an alternative instance
        /// type that provides better network PPS performance. This is identified by
        /// analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code>
        /// metrics of the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskIOPSOverprovisioned</code>
        /// </b> — The
        /// instance’s disk IOPS configuration can be sized down while still meeting the
        /// performance requirements of your workload. This is identified by analyzing the
        /// <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the
        /// current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskIOPSUnderprovisioned</code>
        /// </b> — The
        /// instance’s disk IOPS configuration doesn't meet the performance requirements of
        /// your workload and there is an alternative instance type that provides better
        /// disk IOPS performance. This is identified by analyzing the
        /// <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the
        /// current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskThroughputOverprovisioned</code>
        /// </b> —
        /// The instance’s disk throughput configuration can be sized down while still
        /// meeting the performance requirements of your workload. This is identified by
        /// analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics
        /// of the current instance during the look-back period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskThroughputUnderprovisioned</code>
        /// </b> —
        /// The instance’s disk throughput configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type that
        /// provides better disk throughput performance. This is identified by analyzing the
        /// <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the
        /// current instance during the look-back period.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>For more information about instance metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
        /// available CloudWatch metrics for your instances</a> in the
        /// <i>Amazon Elastic Compute Cloud User Guide</i>. For more information
        /// about EBS volume metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch
        /// metrics for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud
        /// User Guide</i>.</p>
        /// </note>
        pub fn set_finding_reason_codes(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::InstanceRecommendationFindingReasonCode>,
            >,
        ) -> Self {
            self.finding_reason_codes = input;
            self
        }
        /// Appends an item to `utilization_metrics`.
        ///
        /// To override the contents of this collection use [`set_utilization_metrics`](Self::set_utilization_metrics).
        ///
        /// <p>An array of objects that describe the utilization metrics of the instance.</p>
        pub fn utilization_metrics(
            mut self,
            input: impl Into<crate::model::UtilizationMetric>,
        ) -> Self {
            let mut v = self.utilization_metrics.unwrap_or_default();
            v.push(input.into());
            self.utilization_metrics = Some(v);
            self
        }
        /// <p>An array of objects that describe the utilization metrics of the instance.</p>
        pub fn set_utilization_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
        ) -> Self {
            self.utilization_metrics = input;
            self
        }
        /// <p>The number of days for which utilization metrics were analyzed for the
        /// instance.</p>
        pub fn look_back_period_in_days(mut self, input: f64) -> Self {
            self.look_back_period_in_days = Some(input);
            self
        }
        /// <p>The number of days for which utilization metrics were analyzed for the
        /// instance.</p>
        pub fn set_look_back_period_in_days(mut self, input: std::option::Option<f64>) -> Self {
            self.look_back_period_in_days = input;
            self
        }
        /// Appends an item to `recommendation_options`.
        ///
        /// To override the contents of this collection use [`set_recommendation_options`](Self::set_recommendation_options).
        ///
        /// <p>An array of objects that describe the recommendation options for the instance.</p>
        pub fn recommendation_options(
            mut self,
            input: impl Into<crate::model::InstanceRecommendationOption>,
        ) -> Self {
            let mut v = self.recommendation_options.unwrap_or_default();
            v.push(input.into());
            self.recommendation_options = Some(v);
            self
        }
        /// <p>An array of objects that describe the recommendation options for the instance.</p>
        pub fn set_recommendation_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceRecommendationOption>>,
        ) -> Self {
            self.recommendation_options = input;
            self
        }
        /// Appends an item to `recommendation_sources`.
        ///
        /// To override the contents of this collection use [`set_recommendation_sources`](Self::set_recommendation_sources).
        ///
        /// <p>An array of objects that describe the source resource of the recommendation.</p>
        pub fn recommendation_sources(
            mut self,
            input: impl Into<crate::model::RecommendationSource>,
        ) -> Self {
            let mut v = self.recommendation_sources.unwrap_or_default();
            v.push(input.into());
            self.recommendation_sources = Some(v);
            self
        }
        /// <p>An array of objects that describe the source resource of the recommendation.</p>
        pub fn set_recommendation_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationSource>>,
        ) -> Self {
            self.recommendation_sources = input;
            self
        }
        /// <p>The timestamp of when the instance recommendation was last refreshed.</p>
        pub fn last_refresh_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_refresh_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of when the instance recommendation was last refreshed.</p>
        pub fn set_last_refresh_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_refresh_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceRecommendation`](crate::model::InstanceRecommendation)
        pub fn build(self) -> crate::model::InstanceRecommendation {
            crate::model::InstanceRecommendation {
                instance_arn: self.instance_arn,
                account_id: self.account_id,
                instance_name: self.instance_name,
                current_instance_type: self.current_instance_type,
                finding: self.finding,
                finding_reason_codes: self.finding_reason_codes,
                utilization_metrics: self.utilization_metrics,
                look_back_period_in_days: self.look_back_period_in_days.unwrap_or_default(),
                recommendation_options: self.recommendation_options,
                recommendation_sources: self.recommendation_sources,
                last_refresh_timestamp: self.last_refresh_timestamp,
            }
        }
    }
}
impl InstanceRecommendation {
    /// Creates a new builder-style object to manufacture [`InstanceRecommendation`](crate::model::InstanceRecommendation)
    pub fn builder() -> crate::model::instance_recommendation::Builder {
        crate::model::instance_recommendation::Builder::default()
    }
}

/// <p>Describes the source of a recommendation, such as an Amazon EC2 instance or
/// Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationSource {
    /// <p>The Amazon Resource Name (ARN) of the recommendation source.</p>
    pub recommendation_source_arn: std::option::Option<std::string::String>,
    /// <p>The resource type of the recommendation source.</p>
    pub recommendation_source_type: std::option::Option<crate::model::RecommendationSourceType>,
}
impl RecommendationSource {
    /// <p>The Amazon Resource Name (ARN) of the recommendation source.</p>
    pub fn recommendation_source_arn(&self) -> std::option::Option<&str> {
        self.recommendation_source_arn.as_deref()
    }
    /// <p>The resource type of the recommendation source.</p>
    pub fn recommendation_source_type(
        &self,
    ) -> std::option::Option<&crate::model::RecommendationSourceType> {
        self.recommendation_source_type.as_ref()
    }
}
impl std::fmt::Debug for RecommendationSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationSource");
        formatter.field("recommendation_source_arn", &self.recommendation_source_arn);
        formatter.field(
            "recommendation_source_type",
            &self.recommendation_source_type,
        );
        formatter.finish()
    }
}
/// See [`RecommendationSource`](crate::model::RecommendationSource)
pub mod recommendation_source {
    /// A builder for [`RecommendationSource`](crate::model::RecommendationSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_source_arn: std::option::Option<std::string::String>,
        pub(crate) recommendation_source_type:
            std::option::Option<crate::model::RecommendationSourceType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the recommendation source.</p>
        pub fn recommendation_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recommendation source.</p>
        pub fn set_recommendation_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_source_arn = input;
            self
        }
        /// <p>The resource type of the recommendation source.</p>
        pub fn recommendation_source_type(
            mut self,
            input: crate::model::RecommendationSourceType,
        ) -> Self {
            self.recommendation_source_type = Some(input);
            self
        }
        /// <p>The resource type of the recommendation source.</p>
        pub fn set_recommendation_source_type(
            mut self,
            input: std::option::Option<crate::model::RecommendationSourceType>,
        ) -> Self {
            self.recommendation_source_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationSource`](crate::model::RecommendationSource)
        pub fn build(self) -> crate::model::RecommendationSource {
            crate::model::RecommendationSource {
                recommendation_source_arn: self.recommendation_source_arn,
                recommendation_source_type: self.recommendation_source_type,
            }
        }
    }
}
impl RecommendationSource {
    /// Creates a new builder-style object to manufacture [`RecommendationSource`](crate::model::RecommendationSource)
    pub fn builder() -> crate::model::recommendation_source::Builder {
        crate::model::recommendation_source::Builder::default()
    }
}

/// <p>Describes a recommendation option for an Amazon EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceRecommendationOption {
    /// <p>The instance type of the instance recommendation.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>An array of objects that describe the projected utilization metrics of the instance
    /// recommendation option.</p>
    ///
    /// <note>
    /// <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected
    /// utilization metrics returned. Additionally, the <code>Memory</code> metric is
    /// returned only for resources that have the unified CloudWatch agent installed
    /// on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
    /// Utilization with the CloudWatch Agent</a>.</p>
    /// </note>
    pub projected_utilization_metrics:
        std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
    /// <p>Describes the configuration differences between the current instance and the
    /// recommended instance type. You should consider the configuration differences before
    /// migrating your workloads from the current instance to the recommended instance type. The
    /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html">Change the instance type guide for Linux</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html">Change the instance type
    /// guide for Windows</a> provide general guidance for getting started with an
    /// instance migration.</p>
    ///
    /// <p>Platform differences include:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Hypervisor</code>
    /// </b> — The hypervisor of
    /// the recommended instance type is different than that of the current instance.
    /// For example, the recommended instance type uses a Nitro hypervisor and the
    /// current instance uses a Xen hypervisor. The differences that you should consider
    /// between these hypervisors are covered in the <a href="http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor">Nitro Hypervisor</a> section of the
    /// Amazon EC2 frequently asked questions. For more information, see
    /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2
    /// User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2
    /// User Guide for Windows</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkInterface</code>
    /// </b> — The network
    /// interface of the recommended instance type is different than that of the current
    /// instance. For example, the recommended instance type supports enhanced
    /// networking and the current instance might not. To enable enhanced networking for
    /// the recommended instance type, you must install the Elastic Network Adapter
    /// (ENA) driver or the Intel 82599 Virtual Function driver. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html">Enhanced networking
    /// on Linux</a> in the <i>Amazon EC2 User Guide for
    /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html">Enhanced
    /// networking on Windows</a> in the <i>Amazon EC2 User Guide for
    /// Windows</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>StorageInterface</code>
    /// </b> — The storage
    /// interface of the recommended instance type is different than that of the current
    /// instance. For example, the recommended instance type uses an NVMe storage
    /// interface and the current instance does not. To access NVMe volumes for the
    /// recommended instance type, you will need to install or upgrade the NVMe driver.
    /// For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe on
    /// Linux instances</a> in the <i>Amazon EC2 User Guide for
    /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe
    /// on Windows instances</a> in the <i>Amazon EC2 User Guide for
    /// Windows</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>InstanceStoreAvailability</code>
    /// </b> — The
    /// recommended instance type does not support instance store volumes and the
    /// current instance does. Before migrating, you might need to back up the data on
    /// your instance store volumes if you want to preserve them. For more information,
    /// see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/">How do I back up an instance store volume on my Amazon EC2 instance
    /// to Amazon EBS?</a> in the <i>Amazon Web Services Premium
    /// Support Knowledge Base</i>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2
    /// instance store</a> in the <i>Amazon EC2 User Guide for
    /// Linux</i>, or see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html">Amazon EC2
    /// instance store</a> in the <i>Amazon EC2 User Guide for
    /// Windows</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>VirtualizationType</code>
    /// </b> — The
    /// recommended instance type uses the hardware virtual machine (HVM) virtualization
    /// type and the current instance uses the paravirtual (PV) virtualization type. For
    /// more information about the differences between these virtualization types, see
    /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html">Linux AMI
    /// virtualization types</a> in the <i>Amazon EC2 User Guide for
    /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types">Windows AMI virtualization types</a> in the <i>Amazon EC2 User
    /// Guide for Windows</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Architecture</code>
    /// </b> — The CPU
    /// architecture between the recommended instance type and the current instance is
    /// different. For example, the recommended instance type might use an Arm CPU
    /// architecture and the current instance type might use a different one, such as
    /// x86. Before migrating, you should consider recompiling the software on your
    /// instance for the new architecture. Alternatively, you might switch to an Amazon
    /// Machine Image (AMI) that supports the new architecture. For more information
    /// about the CPU architecture for each instance type, see <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>.</p>
    /// </li>
    /// </ul>
    pub platform_differences: std::option::Option<std::vec::Vec<crate::model::PlatformDifference>>,
    /// <p>The performance risk of the instance recommendation option.</p>
    ///
    /// <p>Performance risk indicates the likelihood of the recommended instance type not meeting
    /// the resource needs of your workload. Compute Optimizer calculates an individual
    /// performance risk score for each specification of the recommended instance, including
    /// CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput,
    /// and network PPS.
    /// The performance
    /// risk of the recommended instance is calculated as the maximum performance risk score
    /// across the analyzed resource specifications.</p>
    ///
    /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
    /// that the recommended resource is predicted to always provide enough hardware capability.
    /// The higher the performance risk is, the more likely you should validate whether the
    /// recommendation will meet the performance requirements of your workload before migrating
    /// your resource.</p>
    pub performance_risk: f64,
    /// <p>The rank of the instance recommendation option.</p>
    ///
    /// <p>The top recommendation option is ranked as <code>1</code>.</p>
    pub rank: i32,
}
impl InstanceRecommendationOption {
    /// <p>The instance type of the instance recommendation.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>An array of objects that describe the projected utilization metrics of the instance
    /// recommendation option.</p>
    ///
    /// <note>
    /// <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected
    /// utilization metrics returned. Additionally, the <code>Memory</code> metric is
    /// returned only for resources that have the unified CloudWatch agent installed
    /// on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
    /// Utilization with the CloudWatch Agent</a>.</p>
    /// </note>
    pub fn projected_utilization_metrics(
        &self,
    ) -> std::option::Option<&[crate::model::UtilizationMetric]> {
        self.projected_utilization_metrics.as_deref()
    }
    /// <p>Describes the configuration differences between the current instance and the
    /// recommended instance type. You should consider the configuration differences before
    /// migrating your workloads from the current instance to the recommended instance type. The
    /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html">Change the instance type guide for Linux</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html">Change the instance type
    /// guide for Windows</a> provide general guidance for getting started with an
    /// instance migration.</p>
    ///
    /// <p>Platform differences include:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Hypervisor</code>
    /// </b> — The hypervisor of
    /// the recommended instance type is different than that of the current instance.
    /// For example, the recommended instance type uses a Nitro hypervisor and the
    /// current instance uses a Xen hypervisor. The differences that you should consider
    /// between these hypervisors are covered in the <a href="http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor">Nitro Hypervisor</a> section of the
    /// Amazon EC2 frequently asked questions. For more information, see
    /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2
    /// User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2
    /// User Guide for Windows</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkInterface</code>
    /// </b> — The network
    /// interface of the recommended instance type is different than that of the current
    /// instance. For example, the recommended instance type supports enhanced
    /// networking and the current instance might not. To enable enhanced networking for
    /// the recommended instance type, you must install the Elastic Network Adapter
    /// (ENA) driver or the Intel 82599 Virtual Function driver. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html">Enhanced networking
    /// on Linux</a> in the <i>Amazon EC2 User Guide for
    /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html">Enhanced
    /// networking on Windows</a> in the <i>Amazon EC2 User Guide for
    /// Windows</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>StorageInterface</code>
    /// </b> — The storage
    /// interface of the recommended instance type is different than that of the current
    /// instance. For example, the recommended instance type uses an NVMe storage
    /// interface and the current instance does not. To access NVMe volumes for the
    /// recommended instance type, you will need to install or upgrade the NVMe driver.
    /// For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe on
    /// Linux instances</a> in the <i>Amazon EC2 User Guide for
    /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe
    /// on Windows instances</a> in the <i>Amazon EC2 User Guide for
    /// Windows</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>InstanceStoreAvailability</code>
    /// </b> — The
    /// recommended instance type does not support instance store volumes and the
    /// current instance does. Before migrating, you might need to back up the data on
    /// your instance store volumes if you want to preserve them. For more information,
    /// see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/">How do I back up an instance store volume on my Amazon EC2 instance
    /// to Amazon EBS?</a> in the <i>Amazon Web Services Premium
    /// Support Knowledge Base</i>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2
    /// instance store</a> in the <i>Amazon EC2 User Guide for
    /// Linux</i>, or see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html">Amazon EC2
    /// instance store</a> in the <i>Amazon EC2 User Guide for
    /// Windows</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>VirtualizationType</code>
    /// </b> — The
    /// recommended instance type uses the hardware virtual machine (HVM) virtualization
    /// type and the current instance uses the paravirtual (PV) virtualization type. For
    /// more information about the differences between these virtualization types, see
    /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html">Linux AMI
    /// virtualization types</a> in the <i>Amazon EC2 User Guide for
    /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types">Windows AMI virtualization types</a> in the <i>Amazon EC2 User
    /// Guide for Windows</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Architecture</code>
    /// </b> — The CPU
    /// architecture between the recommended instance type and the current instance is
    /// different. For example, the recommended instance type might use an Arm CPU
    /// architecture and the current instance type might use a different one, such as
    /// x86. Before migrating, you should consider recompiling the software on your
    /// instance for the new architecture. Alternatively, you might switch to an Amazon
    /// Machine Image (AMI) that supports the new architecture. For more information
    /// about the CPU architecture for each instance type, see <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>.</p>
    /// </li>
    /// </ul>
    pub fn platform_differences(&self) -> std::option::Option<&[crate::model::PlatformDifference]> {
        self.platform_differences.as_deref()
    }
    /// <p>The performance risk of the instance recommendation option.</p>
    ///
    /// <p>Performance risk indicates the likelihood of the recommended instance type not meeting
    /// the resource needs of your workload. Compute Optimizer calculates an individual
    /// performance risk score for each specification of the recommended instance, including
    /// CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput,
    /// and network PPS.
    /// The performance
    /// risk of the recommended instance is calculated as the maximum performance risk score
    /// across the analyzed resource specifications.</p>
    ///
    /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
    /// that the recommended resource is predicted to always provide enough hardware capability.
    /// The higher the performance risk is, the more likely you should validate whether the
    /// recommendation will meet the performance requirements of your workload before migrating
    /// your resource.</p>
    pub fn performance_risk(&self) -> f64 {
        self.performance_risk
    }
    /// <p>The rank of the instance recommendation option.</p>
    ///
    /// <p>The top recommendation option is ranked as <code>1</code>.</p>
    pub fn rank(&self) -> i32 {
        self.rank
    }
}
impl std::fmt::Debug for InstanceRecommendationOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceRecommendationOption");
        formatter.field("instance_type", &self.instance_type);
        formatter.field(
            "projected_utilization_metrics",
            &self.projected_utilization_metrics,
        );
        formatter.field("platform_differences", &self.platform_differences);
        formatter.field("performance_risk", &self.performance_risk);
        formatter.field("rank", &self.rank);
        formatter.finish()
    }
}
/// See [`InstanceRecommendationOption`](crate::model::InstanceRecommendationOption)
pub mod instance_recommendation_option {
    /// A builder for [`InstanceRecommendationOption`](crate::model::InstanceRecommendationOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) projected_utilization_metrics:
            std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
        pub(crate) platform_differences:
            std::option::Option<std::vec::Vec<crate::model::PlatformDifference>>,
        pub(crate) performance_risk: std::option::Option<f64>,
        pub(crate) rank: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The instance type of the instance recommendation.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type of the instance recommendation.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// Appends an item to `projected_utilization_metrics`.
        ///
        /// To override the contents of this collection use [`set_projected_utilization_metrics`](Self::set_projected_utilization_metrics).
        ///
        /// <p>An array of objects that describe the projected utilization metrics of the instance
        /// recommendation option.</p>
        ///
        /// <note>
        /// <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected
        /// utilization metrics returned. Additionally, the <code>Memory</code> metric is
        /// returned only for resources that have the unified CloudWatch agent installed
        /// on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
        /// Utilization with the CloudWatch Agent</a>.</p>
        /// </note>
        pub fn projected_utilization_metrics(
            mut self,
            input: impl Into<crate::model::UtilizationMetric>,
        ) -> Self {
            let mut v = self.projected_utilization_metrics.unwrap_or_default();
            v.push(input.into());
            self.projected_utilization_metrics = Some(v);
            self
        }
        /// <p>An array of objects that describe the projected utilization metrics of the instance
        /// recommendation option.</p>
        ///
        /// <note>
        /// <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected
        /// utilization metrics returned. Additionally, the <code>Memory</code> metric is
        /// returned only for resources that have the unified CloudWatch agent installed
        /// on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
        /// Utilization with the CloudWatch Agent</a>.</p>
        /// </note>
        pub fn set_projected_utilization_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
        ) -> Self {
            self.projected_utilization_metrics = input;
            self
        }
        /// Appends an item to `platform_differences`.
        ///
        /// To override the contents of this collection use [`set_platform_differences`](Self::set_platform_differences).
        ///
        /// <p>Describes the configuration differences between the current instance and the
        /// recommended instance type. You should consider the configuration differences before
        /// migrating your workloads from the current instance to the recommended instance type. The
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html">Change the instance type guide for Linux</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html">Change the instance type
        /// guide for Windows</a> provide general guidance for getting started with an
        /// instance migration.</p>
        ///
        /// <p>Platform differences include:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Hypervisor</code>
        /// </b> — The hypervisor of
        /// the recommended instance type is different than that of the current instance.
        /// For example, the recommended instance type uses a Nitro hypervisor and the
        /// current instance uses a Xen hypervisor. The differences that you should consider
        /// between these hypervisors are covered in the <a href="http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor">Nitro Hypervisor</a> section of the
        /// Amazon EC2 frequently asked questions. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2
        /// User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2
        /// User Guide for Windows</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkInterface</code>
        /// </b> — The network
        /// interface of the recommended instance type is different than that of the current
        /// instance. For example, the recommended instance type supports enhanced
        /// networking and the current instance might not. To enable enhanced networking for
        /// the recommended instance type, you must install the Elastic Network Adapter
        /// (ENA) driver or the Intel 82599 Virtual Function driver. For more information,
        /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html">Enhanced networking
        /// on Linux</a> in the <i>Amazon EC2 User Guide for
        /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html">Enhanced
        /// networking on Windows</a> in the <i>Amazon EC2 User Guide for
        /// Windows</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>StorageInterface</code>
        /// </b> — The storage
        /// interface of the recommended instance type is different than that of the current
        /// instance. For example, the recommended instance type uses an NVMe storage
        /// interface and the current instance does not. To access NVMe volumes for the
        /// recommended instance type, you will need to install or upgrade the NVMe driver.
        /// For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe on
        /// Linux instances</a> in the <i>Amazon EC2 User Guide for
        /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe
        /// on Windows instances</a> in the <i>Amazon EC2 User Guide for
        /// Windows</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>InstanceStoreAvailability</code>
        /// </b> — The
        /// recommended instance type does not support instance store volumes and the
        /// current instance does. Before migrating, you might need to back up the data on
        /// your instance store volumes if you want to preserve them. For more information,
        /// see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/">How do I back up an instance store volume on my Amazon EC2 instance
        /// to Amazon EBS?</a> in the <i>Amazon Web Services Premium
        /// Support Knowledge Base</i>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2
        /// instance store</a> in the <i>Amazon EC2 User Guide for
        /// Linux</i>, or see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html">Amazon EC2
        /// instance store</a> in the <i>Amazon EC2 User Guide for
        /// Windows</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>VirtualizationType</code>
        /// </b> — The
        /// recommended instance type uses the hardware virtual machine (HVM) virtualization
        /// type and the current instance uses the paravirtual (PV) virtualization type. For
        /// more information about the differences between these virtualization types, see
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html">Linux AMI
        /// virtualization types</a> in the <i>Amazon EC2 User Guide for
        /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types">Windows AMI virtualization types</a> in the <i>Amazon EC2 User
        /// Guide for Windows</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Architecture</code>
        /// </b> — The CPU
        /// architecture between the recommended instance type and the current instance is
        /// different. For example, the recommended instance type might use an Arm CPU
        /// architecture and the current instance type might use a different one, such as
        /// x86. Before migrating, you should consider recompiling the software on your
        /// instance for the new architecture. Alternatively, you might switch to an Amazon
        /// Machine Image (AMI) that supports the new architecture. For more information
        /// about the CPU architecture for each instance type, see <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>.</p>
        /// </li>
        /// </ul>
        pub fn platform_differences(
            mut self,
            input: impl Into<crate::model::PlatformDifference>,
        ) -> Self {
            let mut v = self.platform_differences.unwrap_or_default();
            v.push(input.into());
            self.platform_differences = Some(v);
            self
        }
        /// <p>Describes the configuration differences between the current instance and the
        /// recommended instance type. You should consider the configuration differences before
        /// migrating your workloads from the current instance to the recommended instance type. The
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html">Change the instance type guide for Linux</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html">Change the instance type
        /// guide for Windows</a> provide general guidance for getting started with an
        /// instance migration.</p>
        ///
        /// <p>Platform differences include:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Hypervisor</code>
        /// </b> — The hypervisor of
        /// the recommended instance type is different than that of the current instance.
        /// For example, the recommended instance type uses a Nitro hypervisor and the
        /// current instance uses a Xen hypervisor. The differences that you should consider
        /// between these hypervisors are covered in the <a href="http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor">Nitro Hypervisor</a> section of the
        /// Amazon EC2 frequently asked questions. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2
        /// User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2
        /// User Guide for Windows</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkInterface</code>
        /// </b> — The network
        /// interface of the recommended instance type is different than that of the current
        /// instance. For example, the recommended instance type supports enhanced
        /// networking and the current instance might not. To enable enhanced networking for
        /// the recommended instance type, you must install the Elastic Network Adapter
        /// (ENA) driver or the Intel 82599 Virtual Function driver. For more information,
        /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html">Enhanced networking
        /// on Linux</a> in the <i>Amazon EC2 User Guide for
        /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html">Enhanced
        /// networking on Windows</a> in the <i>Amazon EC2 User Guide for
        /// Windows</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>StorageInterface</code>
        /// </b> — The storage
        /// interface of the recommended instance type is different than that of the current
        /// instance. For example, the recommended instance type uses an NVMe storage
        /// interface and the current instance does not. To access NVMe volumes for the
        /// recommended instance type, you will need to install or upgrade the NVMe driver.
        /// For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe on
        /// Linux instances</a> in the <i>Amazon EC2 User Guide for
        /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe
        /// on Windows instances</a> in the <i>Amazon EC2 User Guide for
        /// Windows</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>InstanceStoreAvailability</code>
        /// </b> — The
        /// recommended instance type does not support instance store volumes and the
        /// current instance does. Before migrating, you might need to back up the data on
        /// your instance store volumes if you want to preserve them. For more information,
        /// see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/">How do I back up an instance store volume on my Amazon EC2 instance
        /// to Amazon EBS?</a> in the <i>Amazon Web Services Premium
        /// Support Knowledge Base</i>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2
        /// instance store</a> in the <i>Amazon EC2 User Guide for
        /// Linux</i>, or see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html">Amazon EC2
        /// instance store</a> in the <i>Amazon EC2 User Guide for
        /// Windows</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>VirtualizationType</code>
        /// </b> — The
        /// recommended instance type uses the hardware virtual machine (HVM) virtualization
        /// type and the current instance uses the paravirtual (PV) virtualization type. For
        /// more information about the differences between these virtualization types, see
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html">Linux AMI
        /// virtualization types</a> in the <i>Amazon EC2 User Guide for
        /// Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types">Windows AMI virtualization types</a> in the <i>Amazon EC2 User
        /// Guide for Windows</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Architecture</code>
        /// </b> — The CPU
        /// architecture between the recommended instance type and the current instance is
        /// different. For example, the recommended instance type might use an Arm CPU
        /// architecture and the current instance type might use a different one, such as
        /// x86. Before migrating, you should consider recompiling the software on your
        /// instance for the new architecture. Alternatively, you might switch to an Amazon
        /// Machine Image (AMI) that supports the new architecture. For more information
        /// about the CPU architecture for each instance type, see <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_platform_differences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformDifference>>,
        ) -> Self {
            self.platform_differences = input;
            self
        }
        /// <p>The performance risk of the instance recommendation option.</p>
        ///
        /// <p>Performance risk indicates the likelihood of the recommended instance type not meeting
        /// the resource needs of your workload. Compute Optimizer calculates an individual
        /// performance risk score for each specification of the recommended instance, including
        /// CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput,
        /// and network PPS.
        /// The performance
        /// risk of the recommended instance is calculated as the maximum performance risk score
        /// across the analyzed resource specifications.</p>
        ///
        /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
        /// that the recommended resource is predicted to always provide enough hardware capability.
        /// The higher the performance risk is, the more likely you should validate whether the
        /// recommendation will meet the performance requirements of your workload before migrating
        /// your resource.</p>
        pub fn performance_risk(mut self, input: f64) -> Self {
            self.performance_risk = Some(input);
            self
        }
        /// <p>The performance risk of the instance recommendation option.</p>
        ///
        /// <p>Performance risk indicates the likelihood of the recommended instance type not meeting
        /// the resource needs of your workload. Compute Optimizer calculates an individual
        /// performance risk score for each specification of the recommended instance, including
        /// CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput,
        /// and network PPS.
        /// The performance
        /// risk of the recommended instance is calculated as the maximum performance risk score
        /// across the analyzed resource specifications.</p>
        ///
        /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
        /// that the recommended resource is predicted to always provide enough hardware capability.
        /// The higher the performance risk is, the more likely you should validate whether the
        /// recommendation will meet the performance requirements of your workload before migrating
        /// your resource.</p>
        pub fn set_performance_risk(mut self, input: std::option::Option<f64>) -> Self {
            self.performance_risk = input;
            self
        }
        /// <p>The rank of the instance recommendation option.</p>
        ///
        /// <p>The top recommendation option is ranked as <code>1</code>.</p>
        pub fn rank(mut self, input: i32) -> Self {
            self.rank = Some(input);
            self
        }
        /// <p>The rank of the instance recommendation option.</p>
        ///
        /// <p>The top recommendation option is ranked as <code>1</code>.</p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.rank = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceRecommendationOption`](crate::model::InstanceRecommendationOption)
        pub fn build(self) -> crate::model::InstanceRecommendationOption {
            crate::model::InstanceRecommendationOption {
                instance_type: self.instance_type,
                projected_utilization_metrics: self.projected_utilization_metrics,
                platform_differences: self.platform_differences,
                performance_risk: self.performance_risk.unwrap_or_default(),
                rank: self.rank.unwrap_or_default(),
            }
        }
    }
}
impl InstanceRecommendationOption {
    /// Creates a new builder-style object to manufacture [`InstanceRecommendationOption`](crate::model::InstanceRecommendationOption)
    pub fn builder() -> crate::model::instance_recommendation_option::Builder {
        crate::model::instance_recommendation_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlatformDifference {
    #[allow(missing_docs)] // documentation missing in model
    Architecture,
    #[allow(missing_docs)] // documentation missing in model
    Hypervisor,
    #[allow(missing_docs)] // documentation missing in model
    InstanceStoreAvailability,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInterface,
    #[allow(missing_docs)] // documentation missing in model
    StorageInterface,
    #[allow(missing_docs)] // documentation missing in model
    VirtualizationType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlatformDifference {
    fn from(s: &str) -> Self {
        match s {
            "Architecture" => PlatformDifference::Architecture,
            "Hypervisor" => PlatformDifference::Hypervisor,
            "InstanceStoreAvailability" => PlatformDifference::InstanceStoreAvailability,
            "NetworkInterface" => PlatformDifference::NetworkInterface,
            "StorageInterface" => PlatformDifference::StorageInterface,
            "VirtualizationType" => PlatformDifference::VirtualizationType,
            other => PlatformDifference::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlatformDifference {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlatformDifference::from(s))
    }
}
impl PlatformDifference {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlatformDifference::Architecture => "Architecture",
            PlatformDifference::Hypervisor => "Hypervisor",
            PlatformDifference::InstanceStoreAvailability => "InstanceStoreAvailability",
            PlatformDifference::NetworkInterface => "NetworkInterface",
            PlatformDifference::StorageInterface => "StorageInterface",
            PlatformDifference::VirtualizationType => "VirtualizationType",
            PlatformDifference::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Architecture",
            "Hypervisor",
            "InstanceStoreAvailability",
            "NetworkInterface",
            "StorageInterface",
            "VirtualizationType",
        ]
    }
}
impl AsRef<str> for PlatformDifference {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a utilization metric of a resource, such as an Amazon EC2
/// instance.</p>
///
/// <p>Compare the utilization metric data of your resource against its projected utilization
/// metric data to determine the performance difference between your current resource and
/// the recommended option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UtilizationMetric {
    /// <p>The name of the utilization metric.</p>
    ///
    /// <p>The following utilization metrics are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Cpu</code> - The percentage of allocated EC2 compute units that are
    /// currently in use on the instance. This metric identifies the processing power
    /// required to run an application on the instance.</p>
    /// <p>Depending on the instance type, tools in your operating system can show a
    /// lower percentage than CloudWatch when the instance is not allocated a full
    /// processor core.</p>
    /// <p>Units: Percent</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Memory</code> - The percentage of memory that is currently in use on the
    /// instance. This metric identifies the amount of memory required to run an
    /// application on the instance.</p>
    /// <p>Units: Percent</p>
    /// <note>
    /// <p>The <code>Memory</code> metric is returned only for resources that have
    /// the unified CloudWatch agent installed on them. For more information,
    /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
    /// Utilization with the CloudWatch Agent</a>.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS_READ_OPS_PER_SECOND</code> - The completed read operations from all
    /// EBS volumes attached to the instance in a specified period of time.</p>
    /// <p>Unit: Count</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS_WRITE_OPS_PER_SECOND</code> - The completed write operations to all
    /// EBS volumes attached to the instance in a specified period of time.</p>
    /// <p>Unit: Count</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS_READ_BYTES_PER_SECOND</code> - The bytes read from all EBS volumes
    /// attached to the instance in a specified period of time.</p>
    /// <p>Unit: Bytes</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS_WRITE_BYTES_PER_SECOND</code> - The bytes written to all EBS volumes
    /// attached to the instance in a specified period of time.</p>
    /// <p>Unit: Bytes</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISK_READ_OPS_PER_SECOND</code> - The completed read operations from all
    /// instance store volumes available to the instance in a specified period of
    /// time.</p>
    /// <p>If there are no instance store volumes, either the value is <code>0</code> or
    /// the metric is not reported.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISK_WRITE_OPS_PER_SECOND</code> - The completed write operations from
    /// all instance store volumes available to the instance in a specified period of
    /// time.</p>
    /// <p>If there are no instance store volumes, either the value is <code>0</code> or
    /// the metric is not reported.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISK_READ_BYTES_PER_SECOND</code> - The bytes read from all instance
    /// store volumes available to the instance. This metric is used to determine the
    /// volume of the data the application reads from the disk of the instance. This can
    /// be used to determine the speed of the application.</p>
    /// <p>If there are no instance store volumes, either the value is <code>0</code> or
    /// the metric is not reported.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISK_WRITE_BYTES_PER_SECOND</code> - The bytes written to all instance
    /// store volumes available to the instance. This metric is used to determine the
    /// volume of the data the application writes onto the disk of the instance. This
    /// can be used to determine the speed of the application.</p>
    /// <p>If there are no instance store volumes, either the value is <code>0</code> or
    /// the metric is not reported.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NETWORK_IN_BYTES_PER_SECOND</code> - The number of bytes received by the
    /// instance on all network interfaces. This metric identifies the volume of
    /// incoming network traffic to a single instance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NETWORK_OUT_BYTES_PER_SECOND</code> - The number of bytes sent out by
    /// the instance on all network interfaces. This metric identifies the volume of
    /// outgoing network traffic from a single instance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NETWORK_PACKETS_IN_PER_SECOND</code> - The number of packets received by
    /// the instance on all network interfaces. This metric identifies the volume of
    /// incoming traffic in terms of the number of packets on a single instance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NETWORK_PACKETS_OUT_PER_SECOND</code> - The number of packets sent out
    /// by the instance on all network interfaces. This metric identifies the volume of
    /// outgoing traffic in terms of the number of packets on a single instance.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<crate::model::MetricName>,
    /// <p>The statistic of the utilization metric.</p>
    ///
    /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
    /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
    /// highest value observed during the specified period.</p>
    ///
    ///
    /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
    /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
    /// <code>SampleCount</code> during the specified period. For more information, see
    /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
    /// recommendations</a> in the <i>Compute Optimizer User
    /// Guide</i>. You can also get averaged utilization metric data for your resources
    /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
    /// User Guide</a>.</p>
    pub statistic: std::option::Option<crate::model::MetricStatistic>,
    /// <p>The value of the utilization metric.</p>
    pub value: f64,
}
impl UtilizationMetric {
    /// <p>The name of the utilization metric.</p>
    ///
    /// <p>The following utilization metrics are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Cpu</code> - The percentage of allocated EC2 compute units that are
    /// currently in use on the instance. This metric identifies the processing power
    /// required to run an application on the instance.</p>
    /// <p>Depending on the instance type, tools in your operating system can show a
    /// lower percentage than CloudWatch when the instance is not allocated a full
    /// processor core.</p>
    /// <p>Units: Percent</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Memory</code> - The percentage of memory that is currently in use on the
    /// instance. This metric identifies the amount of memory required to run an
    /// application on the instance.</p>
    /// <p>Units: Percent</p>
    /// <note>
    /// <p>The <code>Memory</code> metric is returned only for resources that have
    /// the unified CloudWatch agent installed on them. For more information,
    /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
    /// Utilization with the CloudWatch Agent</a>.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS_READ_OPS_PER_SECOND</code> - The completed read operations from all
    /// EBS volumes attached to the instance in a specified period of time.</p>
    /// <p>Unit: Count</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS_WRITE_OPS_PER_SECOND</code> - The completed write operations to all
    /// EBS volumes attached to the instance in a specified period of time.</p>
    /// <p>Unit: Count</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS_READ_BYTES_PER_SECOND</code> - The bytes read from all EBS volumes
    /// attached to the instance in a specified period of time.</p>
    /// <p>Unit: Bytes</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS_WRITE_BYTES_PER_SECOND</code> - The bytes written to all EBS volumes
    /// attached to the instance in a specified period of time.</p>
    /// <p>Unit: Bytes</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISK_READ_OPS_PER_SECOND</code> - The completed read operations from all
    /// instance store volumes available to the instance in a specified period of
    /// time.</p>
    /// <p>If there are no instance store volumes, either the value is <code>0</code> or
    /// the metric is not reported.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISK_WRITE_OPS_PER_SECOND</code> - The completed write operations from
    /// all instance store volumes available to the instance in a specified period of
    /// time.</p>
    /// <p>If there are no instance store volumes, either the value is <code>0</code> or
    /// the metric is not reported.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISK_READ_BYTES_PER_SECOND</code> - The bytes read from all instance
    /// store volumes available to the instance. This metric is used to determine the
    /// volume of the data the application reads from the disk of the instance. This can
    /// be used to determine the speed of the application.</p>
    /// <p>If there are no instance store volumes, either the value is <code>0</code> or
    /// the metric is not reported.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISK_WRITE_BYTES_PER_SECOND</code> - The bytes written to all instance
    /// store volumes available to the instance. This metric is used to determine the
    /// volume of the data the application writes onto the disk of the instance. This
    /// can be used to determine the speed of the application.</p>
    /// <p>If there are no instance store volumes, either the value is <code>0</code> or
    /// the metric is not reported.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NETWORK_IN_BYTES_PER_SECOND</code> - The number of bytes received by the
    /// instance on all network interfaces. This metric identifies the volume of
    /// incoming network traffic to a single instance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NETWORK_OUT_BYTES_PER_SECOND</code> - The number of bytes sent out by
    /// the instance on all network interfaces. This metric identifies the volume of
    /// outgoing network traffic from a single instance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NETWORK_PACKETS_IN_PER_SECOND</code> - The number of packets received by
    /// the instance on all network interfaces. This metric identifies the volume of
    /// incoming traffic in terms of the number of packets on a single instance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NETWORK_PACKETS_OUT_PER_SECOND</code> - The number of packets sent out
    /// by the instance on all network interfaces. This metric identifies the volume of
    /// outgoing traffic in terms of the number of packets on a single instance.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&crate::model::MetricName> {
        self.name.as_ref()
    }
    /// <p>The statistic of the utilization metric.</p>
    ///
    /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
    /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
    /// highest value observed during the specified period.</p>
    ///
    ///
    /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
    /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
    /// <code>SampleCount</code> during the specified period. For more information, see
    /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
    /// recommendations</a> in the <i>Compute Optimizer User
    /// Guide</i>. You can also get averaged utilization metric data for your resources
    /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
    /// User Guide</a>.</p>
    pub fn statistic(&self) -> std::option::Option<&crate::model::MetricStatistic> {
        self.statistic.as_ref()
    }
    /// <p>The value of the utilization metric.</p>
    pub fn value(&self) -> f64 {
        self.value
    }
}
impl std::fmt::Debug for UtilizationMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UtilizationMetric");
        formatter.field("name", &self.name);
        formatter.field("statistic", &self.statistic);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`UtilizationMetric`](crate::model::UtilizationMetric)
pub mod utilization_metric {
    /// A builder for [`UtilizationMetric`](crate::model::UtilizationMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::MetricName>,
        pub(crate) statistic: std::option::Option<crate::model::MetricStatistic>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of the utilization metric.</p>
        ///
        /// <p>The following utilization metrics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Cpu</code> - The percentage of allocated EC2 compute units that are
        /// currently in use on the instance. This metric identifies the processing power
        /// required to run an application on the instance.</p>
        /// <p>Depending on the instance type, tools in your operating system can show a
        /// lower percentage than CloudWatch when the instance is not allocated a full
        /// processor core.</p>
        /// <p>Units: Percent</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Memory</code> - The percentage of memory that is currently in use on the
        /// instance. This metric identifies the amount of memory required to run an
        /// application on the instance.</p>
        /// <p>Units: Percent</p>
        /// <note>
        /// <p>The <code>Memory</code> metric is returned only for resources that have
        /// the unified CloudWatch agent installed on them. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
        /// Utilization with the CloudWatch Agent</a>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS_READ_OPS_PER_SECOND</code> - The completed read operations from all
        /// EBS volumes attached to the instance in a specified period of time.</p>
        /// <p>Unit: Count</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS_WRITE_OPS_PER_SECOND</code> - The completed write operations to all
        /// EBS volumes attached to the instance in a specified period of time.</p>
        /// <p>Unit: Count</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS_READ_BYTES_PER_SECOND</code> - The bytes read from all EBS volumes
        /// attached to the instance in a specified period of time.</p>
        /// <p>Unit: Bytes</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS_WRITE_BYTES_PER_SECOND</code> - The bytes written to all EBS volumes
        /// attached to the instance in a specified period of time.</p>
        /// <p>Unit: Bytes</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISK_READ_OPS_PER_SECOND</code> - The completed read operations from all
        /// instance store volumes available to the instance in a specified period of
        /// time.</p>
        /// <p>If there are no instance store volumes, either the value is <code>0</code> or
        /// the metric is not reported.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISK_WRITE_OPS_PER_SECOND</code> - The completed write operations from
        /// all instance store volumes available to the instance in a specified period of
        /// time.</p>
        /// <p>If there are no instance store volumes, either the value is <code>0</code> or
        /// the metric is not reported.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISK_READ_BYTES_PER_SECOND</code> - The bytes read from all instance
        /// store volumes available to the instance. This metric is used to determine the
        /// volume of the data the application reads from the disk of the instance. This can
        /// be used to determine the speed of the application.</p>
        /// <p>If there are no instance store volumes, either the value is <code>0</code> or
        /// the metric is not reported.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISK_WRITE_BYTES_PER_SECOND</code> - The bytes written to all instance
        /// store volumes available to the instance. This metric is used to determine the
        /// volume of the data the application writes onto the disk of the instance. This
        /// can be used to determine the speed of the application.</p>
        /// <p>If there are no instance store volumes, either the value is <code>0</code> or
        /// the metric is not reported.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NETWORK_IN_BYTES_PER_SECOND</code> - The number of bytes received by the
        /// instance on all network interfaces. This metric identifies the volume of
        /// incoming network traffic to a single instance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NETWORK_OUT_BYTES_PER_SECOND</code> - The number of bytes sent out by
        /// the instance on all network interfaces. This metric identifies the volume of
        /// outgoing network traffic from a single instance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NETWORK_PACKETS_IN_PER_SECOND</code> - The number of packets received by
        /// the instance on all network interfaces. This metric identifies the volume of
        /// incoming traffic in terms of the number of packets on a single instance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NETWORK_PACKETS_OUT_PER_SECOND</code> - The number of packets sent out
        /// by the instance on all network interfaces. This metric identifies the volume of
        /// outgoing traffic in terms of the number of packets on a single instance.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: crate::model::MetricName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the utilization metric.</p>
        ///
        /// <p>The following utilization metrics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Cpu</code> - The percentage of allocated EC2 compute units that are
        /// currently in use on the instance. This metric identifies the processing power
        /// required to run an application on the instance.</p>
        /// <p>Depending on the instance type, tools in your operating system can show a
        /// lower percentage than CloudWatch when the instance is not allocated a full
        /// processor core.</p>
        /// <p>Units: Percent</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Memory</code> - The percentage of memory that is currently in use on the
        /// instance. This metric identifies the amount of memory required to run an
        /// application on the instance.</p>
        /// <p>Units: Percent</p>
        /// <note>
        /// <p>The <code>Memory</code> metric is returned only for resources that have
        /// the unified CloudWatch agent installed on them. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
        /// Utilization with the CloudWatch Agent</a>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS_READ_OPS_PER_SECOND</code> - The completed read operations from all
        /// EBS volumes attached to the instance in a specified period of time.</p>
        /// <p>Unit: Count</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS_WRITE_OPS_PER_SECOND</code> - The completed write operations to all
        /// EBS volumes attached to the instance in a specified period of time.</p>
        /// <p>Unit: Count</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS_READ_BYTES_PER_SECOND</code> - The bytes read from all EBS volumes
        /// attached to the instance in a specified period of time.</p>
        /// <p>Unit: Bytes</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS_WRITE_BYTES_PER_SECOND</code> - The bytes written to all EBS volumes
        /// attached to the instance in a specified period of time.</p>
        /// <p>Unit: Bytes</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISK_READ_OPS_PER_SECOND</code> - The completed read operations from all
        /// instance store volumes available to the instance in a specified period of
        /// time.</p>
        /// <p>If there are no instance store volumes, either the value is <code>0</code> or
        /// the metric is not reported.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISK_WRITE_OPS_PER_SECOND</code> - The completed write operations from
        /// all instance store volumes available to the instance in a specified period of
        /// time.</p>
        /// <p>If there are no instance store volumes, either the value is <code>0</code> or
        /// the metric is not reported.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISK_READ_BYTES_PER_SECOND</code> - The bytes read from all instance
        /// store volumes available to the instance. This metric is used to determine the
        /// volume of the data the application reads from the disk of the instance. This can
        /// be used to determine the speed of the application.</p>
        /// <p>If there are no instance store volumes, either the value is <code>0</code> or
        /// the metric is not reported.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISK_WRITE_BYTES_PER_SECOND</code> - The bytes written to all instance
        /// store volumes available to the instance. This metric is used to determine the
        /// volume of the data the application writes onto the disk of the instance. This
        /// can be used to determine the speed of the application.</p>
        /// <p>If there are no instance store volumes, either the value is <code>0</code> or
        /// the metric is not reported.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NETWORK_IN_BYTES_PER_SECOND</code> - The number of bytes received by the
        /// instance on all network interfaces. This metric identifies the volume of
        /// incoming network traffic to a single instance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NETWORK_OUT_BYTES_PER_SECOND</code> - The number of bytes sent out by
        /// the instance on all network interfaces. This metric identifies the volume of
        /// outgoing network traffic from a single instance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NETWORK_PACKETS_IN_PER_SECOND</code> - The number of packets received by
        /// the instance on all network interfaces. This metric identifies the volume of
        /// incoming traffic in terms of the number of packets on a single instance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NETWORK_PACKETS_OUT_PER_SECOND</code> - The number of packets sent out
        /// by the instance on all network interfaces. This metric identifies the volume of
        /// outgoing traffic in terms of the number of packets on a single instance.</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<crate::model::MetricName>) -> Self {
            self.name = input;
            self
        }
        /// <p>The statistic of the utilization metric.</p>
        ///
        /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
        /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
        /// highest value observed during the specified period.</p>
        ///
        ///
        /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
        /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
        /// <code>SampleCount</code> during the specified period. For more information, see
        /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
        /// recommendations</a> in the <i>Compute Optimizer User
        /// Guide</i>. You can also get averaged utilization metric data for your resources
        /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
        /// User Guide</a>.</p>
        pub fn statistic(mut self, input: crate::model::MetricStatistic) -> Self {
            self.statistic = Some(input);
            self
        }
        /// <p>The statistic of the utilization metric.</p>
        ///
        /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
        /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
        /// highest value observed during the specified period.</p>
        ///
        ///
        /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
        /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
        /// <code>SampleCount</code> during the specified period. For more information, see
        /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
        /// recommendations</a> in the <i>Compute Optimizer User
        /// Guide</i>. You can also get averaged utilization metric data for your resources
        /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
        /// User Guide</a>.</p>
        pub fn set_statistic(
            mut self,
            input: std::option::Option<crate::model::MetricStatistic>,
        ) -> Self {
            self.statistic = input;
            self
        }
        /// <p>The value of the utilization metric.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the utilization metric.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`UtilizationMetric`](crate::model::UtilizationMetric)
        pub fn build(self) -> crate::model::UtilizationMetric {
            crate::model::UtilizationMetric {
                name: self.name,
                statistic: self.statistic,
                value: self.value.unwrap_or_default(),
            }
        }
    }
}
impl UtilizationMetric {
    /// Creates a new builder-style object to manufacture [`UtilizationMetric`](crate::model::UtilizationMetric)
    pub fn builder() -> crate::model::utilization_metric::Builder {
        crate::model::utilization_metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceRecommendationFindingReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    CpuOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    CpuUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    DiskIopsOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    DiskIopsUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    DiskThroughputOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    DiskThroughputUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    EbsIopsOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    EbsIopsUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    EbsThroughputOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    EbsThroughputUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    MemoryOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    MemoryUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    NetworkBandwidthOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    NetworkBandwidthUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    NetworkPpsOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    NetworkPpsUnderProvisioned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceRecommendationFindingReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "CPUOverprovisioned" => InstanceRecommendationFindingReasonCode::CpuOverProvisioned,
            "CPUUnderprovisioned" => InstanceRecommendationFindingReasonCode::CpuUnderProvisioned,
            "DiskIOPSOverprovisioned" => {
                InstanceRecommendationFindingReasonCode::DiskIopsOverProvisioned
            }
            "DiskIOPSUnderprovisioned" => {
                InstanceRecommendationFindingReasonCode::DiskIopsUnderProvisioned
            }
            "DiskThroughputOverprovisioned" => {
                InstanceRecommendationFindingReasonCode::DiskThroughputOverProvisioned
            }
            "DiskThroughputUnderprovisioned" => {
                InstanceRecommendationFindingReasonCode::DiskThroughputUnderProvisioned
            }
            "EBSIOPSOverprovisioned" => {
                InstanceRecommendationFindingReasonCode::EbsIopsOverProvisioned
            }
            "EBSIOPSUnderprovisioned" => {
                InstanceRecommendationFindingReasonCode::EbsIopsUnderProvisioned
            }
            "EBSThroughputOverprovisioned" => {
                InstanceRecommendationFindingReasonCode::EbsThroughputOverProvisioned
            }
            "EBSThroughputUnderprovisioned" => {
                InstanceRecommendationFindingReasonCode::EbsThroughputUnderProvisioned
            }
            "MemoryOverprovisioned" => {
                InstanceRecommendationFindingReasonCode::MemoryOverProvisioned
            }
            "MemoryUnderprovisioned" => {
                InstanceRecommendationFindingReasonCode::MemoryUnderProvisioned
            }
            "NetworkBandwidthOverprovisioned" => {
                InstanceRecommendationFindingReasonCode::NetworkBandwidthOverProvisioned
            }
            "NetworkBandwidthUnderprovisioned" => {
                InstanceRecommendationFindingReasonCode::NetworkBandwidthUnderProvisioned
            }
            "NetworkPPSOverprovisioned" => {
                InstanceRecommendationFindingReasonCode::NetworkPpsOverProvisioned
            }
            "NetworkPPSUnderprovisioned" => {
                InstanceRecommendationFindingReasonCode::NetworkPpsUnderProvisioned
            }
            other => InstanceRecommendationFindingReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceRecommendationFindingReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceRecommendationFindingReasonCode::from(s))
    }
}
impl InstanceRecommendationFindingReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceRecommendationFindingReasonCode::CpuOverProvisioned => "CPUOverprovisioned",
            InstanceRecommendationFindingReasonCode::CpuUnderProvisioned => "CPUUnderprovisioned",
            InstanceRecommendationFindingReasonCode::DiskIopsOverProvisioned => {
                "DiskIOPSOverprovisioned"
            }
            InstanceRecommendationFindingReasonCode::DiskIopsUnderProvisioned => {
                "DiskIOPSUnderprovisioned"
            }
            InstanceRecommendationFindingReasonCode::DiskThroughputOverProvisioned => {
                "DiskThroughputOverprovisioned"
            }
            InstanceRecommendationFindingReasonCode::DiskThroughputUnderProvisioned => {
                "DiskThroughputUnderprovisioned"
            }
            InstanceRecommendationFindingReasonCode::EbsIopsOverProvisioned => {
                "EBSIOPSOverprovisioned"
            }
            InstanceRecommendationFindingReasonCode::EbsIopsUnderProvisioned => {
                "EBSIOPSUnderprovisioned"
            }
            InstanceRecommendationFindingReasonCode::EbsThroughputOverProvisioned => {
                "EBSThroughputOverprovisioned"
            }
            InstanceRecommendationFindingReasonCode::EbsThroughputUnderProvisioned => {
                "EBSThroughputUnderprovisioned"
            }
            InstanceRecommendationFindingReasonCode::MemoryOverProvisioned => {
                "MemoryOverprovisioned"
            }
            InstanceRecommendationFindingReasonCode::MemoryUnderProvisioned => {
                "MemoryUnderprovisioned"
            }
            InstanceRecommendationFindingReasonCode::NetworkBandwidthOverProvisioned => {
                "NetworkBandwidthOverprovisioned"
            }
            InstanceRecommendationFindingReasonCode::NetworkBandwidthUnderProvisioned => {
                "NetworkBandwidthUnderprovisioned"
            }
            InstanceRecommendationFindingReasonCode::NetworkPpsOverProvisioned => {
                "NetworkPPSOverprovisioned"
            }
            InstanceRecommendationFindingReasonCode::NetworkPpsUnderProvisioned => {
                "NetworkPPSUnderprovisioned"
            }
            InstanceRecommendationFindingReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CPUOverprovisioned",
            "CPUUnderprovisioned",
            "DiskIOPSOverprovisioned",
            "DiskIOPSUnderprovisioned",
            "DiskThroughputOverprovisioned",
            "DiskThroughputUnderprovisioned",
            "EBSIOPSOverprovisioned",
            "EBSIOPSUnderprovisioned",
            "EBSThroughputOverprovisioned",
            "EBSThroughputUnderprovisioned",
            "MemoryOverprovisioned",
            "MemoryUnderprovisioned",
            "NetworkBandwidthOverprovisioned",
            "NetworkBandwidthUnderprovisioned",
            "NetworkPPSOverprovisioned",
            "NetworkPPSUnderprovisioned",
        ]
    }
}
impl AsRef<str> for InstanceRecommendationFindingReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a filter that returns a more specific list of recommendations. Use this
/// filter with the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p>
///
/// <p>You can use <code>EBSFilter</code> with the <a>GetEBSVolumeRecommendations</a> action,
/// <code>LambdaFunctionRecommendationFilter</code> with the <a>GetLambdaFunctionRecommendations</a> action, and <code>JobFilter</code> with
/// the <a>DescribeRecommendationExportJobs</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the filter.</p>
    ///
    /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
    /// classification (for example, <code>Underprovisioned</code>).</p>
    ///
    /// <p>Specify <code>RecommendationSourceType</code> to return recommendations of a specific
    /// resource type (for example, <code>Ec2Instance</code>).</p>
    ///
    /// <p>Specify <code>FindingReasonCodes</code> to return recommendations with a specific
    /// finding reason code (for example, <code>CPUUnderprovisioned</code>).</p>
    pub name: std::option::Option<crate::model::FilterName>,
    /// <p>The value of the filter.</p>
    ///
    /// <p>The valid values for this parameter are as follows, depending on what you specify for
    /// the <code>name</code> parameter and the resource type that you wish to filter results
    /// for:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Specify <code>Optimized</code> or <code>NotOptimized</code> if you specify the
    /// <code>name</code> parameter as <code>Finding</code> and you want to filter
    /// results for Auto Scaling groups.</p>
    /// </li>
    /// <li>
    /// <p>Specify <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
    /// <code>Optimized</code> if you specify the <code>name</code> parameter as
    /// <code>Finding</code> and you want to filter results for EC2
    /// instances.</p>
    /// </li>
    /// <li>
    /// <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you
    /// specify the <code>name</code> parameter as
    /// <code>RecommendationSourceType</code>.</p>
    /// </li>
    /// <li>
    /// <p>Specify one of the following options if you specify the <code>name</code>
    /// parameter as <code>FindingReasonCodes</code>:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>CPUOverprovisioned</code>
    /// </b> — The
    /// instance’s CPU configuration can be sized down while still meeting the
    /// performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>CPUUnderprovisioned</code>
    /// </b> —
    /// The instance’s CPU configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better CPU performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryOverprovisioned</code>
    /// </b> —
    /// The instance’s memory configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryUnderprovisioned</code>
    /// </b> —
    /// The instance’s memory configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better memory performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSThroughputOverprovisioned</code>
    /// </b> — The
    /// instance’s EBS throughput configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSThroughputUnderprovisioned</code>
    /// </b> — The
    /// instance’s EBS throughput configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better EBS throughput performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSIOPSOverprovisioned</code>
    /// </b> —
    /// The instance’s EBS IOPS configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSIOPSUnderprovisioned</code>
    /// </b>
    /// — The instance’s EBS IOPS configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better EBS IOPS performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkBandwidthOverprovisioned</code>
    /// </b> — The
    /// instance’s network bandwidth configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkBandwidthUnderprovisioned</code>
    /// </b> — The
    /// instance’s network bandwidth configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better network bandwidth performance. This finding reason
    /// happens when the <code>NetworkIn</code> or <code>NetworkOut</code>
    /// performance of an instance is impacted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkPPSOverprovisioned</code>
    /// </b> — The instance’s
    /// network PPS (packets per second) configuration can be sized down while
    /// still meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkPPSUnderprovisioned</code>
    /// </b> — The instance’s
    /// network PPS (packets per second) configuration doesn't meet the
    /// performance requirements of your workload and there is an alternative
    /// instance type that provides better network PPS performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskIOPSOverprovisioned</code>
    /// </b>
    /// — The instance’s disk IOPS configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskIOPSUnderprovisioned</code>
    /// </b>
    /// — The instance’s disk IOPS configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better disk IOPS performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskThroughputOverprovisioned</code>
    /// </b> — The
    /// instance’s disk throughput configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskThroughputUnderprovisioned</code>
    /// </b> — The
    /// instance’s disk throughput configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better disk throughput performance.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>The name of the filter.</p>
    ///
    /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
    /// classification (for example, <code>Underprovisioned</code>).</p>
    ///
    /// <p>Specify <code>RecommendationSourceType</code> to return recommendations of a specific
    /// resource type (for example, <code>Ec2Instance</code>).</p>
    ///
    /// <p>Specify <code>FindingReasonCodes</code> to return recommendations with a specific
    /// finding reason code (for example, <code>CPUUnderprovisioned</code>).</p>
    pub fn name(&self) -> std::option::Option<&crate::model::FilterName> {
        self.name.as_ref()
    }
    /// <p>The value of the filter.</p>
    ///
    /// <p>The valid values for this parameter are as follows, depending on what you specify for
    /// the <code>name</code> parameter and the resource type that you wish to filter results
    /// for:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Specify <code>Optimized</code> or <code>NotOptimized</code> if you specify the
    /// <code>name</code> parameter as <code>Finding</code> and you want to filter
    /// results for Auto Scaling groups.</p>
    /// </li>
    /// <li>
    /// <p>Specify <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
    /// <code>Optimized</code> if you specify the <code>name</code> parameter as
    /// <code>Finding</code> and you want to filter results for EC2
    /// instances.</p>
    /// </li>
    /// <li>
    /// <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you
    /// specify the <code>name</code> parameter as
    /// <code>RecommendationSourceType</code>.</p>
    /// </li>
    /// <li>
    /// <p>Specify one of the following options if you specify the <code>name</code>
    /// parameter as <code>FindingReasonCodes</code>:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>CPUOverprovisioned</code>
    /// </b> — The
    /// instance’s CPU configuration can be sized down while still meeting the
    /// performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>CPUUnderprovisioned</code>
    /// </b> —
    /// The instance’s CPU configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better CPU performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryOverprovisioned</code>
    /// </b> —
    /// The instance’s memory configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>MemoryUnderprovisioned</code>
    /// </b> —
    /// The instance’s memory configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better memory performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSThroughputOverprovisioned</code>
    /// </b> — The
    /// instance’s EBS throughput configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSThroughputUnderprovisioned</code>
    /// </b> — The
    /// instance’s EBS throughput configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better EBS throughput performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSIOPSOverprovisioned</code>
    /// </b> —
    /// The instance’s EBS IOPS configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>EBSIOPSUnderprovisioned</code>
    /// </b>
    /// — The instance’s EBS IOPS configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better EBS IOPS performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkBandwidthOverprovisioned</code>
    /// </b> — The
    /// instance’s network bandwidth configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkBandwidthUnderprovisioned</code>
    /// </b> — The
    /// instance’s network bandwidth configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better network bandwidth performance. This finding reason
    /// happens when the <code>NetworkIn</code> or <code>NetworkOut</code>
    /// performance of an instance is impacted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkPPSOverprovisioned</code>
    /// </b> — The instance’s
    /// network PPS (packets per second) configuration can be sized down while
    /// still meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NetworkPPSUnderprovisioned</code>
    /// </b> — The instance’s
    /// network PPS (packets per second) configuration doesn't meet the
    /// performance requirements of your workload and there is an alternative
    /// instance type that provides better network PPS performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskIOPSOverprovisioned</code>
    /// </b>
    /// — The instance’s disk IOPS configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskIOPSUnderprovisioned</code>
    /// </b>
    /// — The instance’s disk IOPS configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better disk IOPS performance.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskThroughputOverprovisioned</code>
    /// </b> — The
    /// instance’s disk throughput configuration can be sized down while still
    /// meeting the performance requirements of your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskThroughputUnderprovisioned</code>
    /// </b> — The
    /// instance’s disk throughput configuration doesn't meet the performance
    /// requirements of your workload and there is an alternative instance type
    /// that provides better disk throughput performance.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::FilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        ///
        /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
        /// classification (for example, <code>Underprovisioned</code>).</p>
        ///
        /// <p>Specify <code>RecommendationSourceType</code> to return recommendations of a specific
        /// resource type (for example, <code>Ec2Instance</code>).</p>
        ///
        /// <p>Specify <code>FindingReasonCodes</code> to return recommendations with a specific
        /// finding reason code (for example, <code>CPUUnderprovisioned</code>).</p>
        pub fn name(mut self, input: crate::model::FilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the filter.</p>
        ///
        /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
        /// classification (for example, <code>Underprovisioned</code>).</p>
        ///
        /// <p>Specify <code>RecommendationSourceType</code> to return recommendations of a specific
        /// resource type (for example, <code>Ec2Instance</code>).</p>
        ///
        /// <p>Specify <code>FindingReasonCodes</code> to return recommendations with a specific
        /// finding reason code (for example, <code>CPUUnderprovisioned</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::FilterName>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value of the filter.</p>
        ///
        /// <p>The valid values for this parameter are as follows, depending on what you specify for
        /// the <code>name</code> parameter and the resource type that you wish to filter results
        /// for:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Specify <code>Optimized</code> or <code>NotOptimized</code> if you specify the
        /// <code>name</code> parameter as <code>Finding</code> and you want to filter
        /// results for Auto Scaling groups.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
        /// <code>Optimized</code> if you specify the <code>name</code> parameter as
        /// <code>Finding</code> and you want to filter results for EC2
        /// instances.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you
        /// specify the <code>name</code> parameter as
        /// <code>RecommendationSourceType</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify one of the following options if you specify the <code>name</code>
        /// parameter as <code>FindingReasonCodes</code>:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUOverprovisioned</code>
        /// </b> — The
        /// instance’s CPU configuration can be sized down while still meeting the
        /// performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUUnderprovisioned</code>
        /// </b> —
        /// The instance’s CPU configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better CPU performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryOverprovisioned</code>
        /// </b> —
        /// The instance’s memory configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryUnderprovisioned</code>
        /// </b> —
        /// The instance’s memory configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better memory performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSThroughputOverprovisioned</code>
        /// </b> — The
        /// instance’s EBS throughput configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSThroughputUnderprovisioned</code>
        /// </b> — The
        /// instance’s EBS throughput configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better EBS throughput performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSIOPSOverprovisioned</code>
        /// </b> —
        /// The instance’s EBS IOPS configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSIOPSUnderprovisioned</code>
        /// </b>
        /// — The instance’s EBS IOPS configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better EBS IOPS performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkBandwidthOverprovisioned</code>
        /// </b> — The
        /// instance’s network bandwidth configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkBandwidthUnderprovisioned</code>
        /// </b> — The
        /// instance’s network bandwidth configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better network bandwidth performance. This finding reason
        /// happens when the <code>NetworkIn</code> or <code>NetworkOut</code>
        /// performance of an instance is impacted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkPPSOverprovisioned</code>
        /// </b> — The instance’s
        /// network PPS (packets per second) configuration can be sized down while
        /// still meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkPPSUnderprovisioned</code>
        /// </b> — The instance’s
        /// network PPS (packets per second) configuration doesn't meet the
        /// performance requirements of your workload and there is an alternative
        /// instance type that provides better network PPS performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskIOPSOverprovisioned</code>
        /// </b>
        /// — The instance’s disk IOPS configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskIOPSUnderprovisioned</code>
        /// </b>
        /// — The instance’s disk IOPS configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better disk IOPS performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskThroughputOverprovisioned</code>
        /// </b> — The
        /// instance’s disk throughput configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskThroughputUnderprovisioned</code>
        /// </b> — The
        /// instance’s disk throughput configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better disk throughput performance.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value of the filter.</p>
        ///
        /// <p>The valid values for this parameter are as follows, depending on what you specify for
        /// the <code>name</code> parameter and the resource type that you wish to filter results
        /// for:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Specify <code>Optimized</code> or <code>NotOptimized</code> if you specify the
        /// <code>name</code> parameter as <code>Finding</code> and you want to filter
        /// results for Auto Scaling groups.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
        /// <code>Optimized</code> if you specify the <code>name</code> parameter as
        /// <code>Finding</code> and you want to filter results for EC2
        /// instances.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you
        /// specify the <code>name</code> parameter as
        /// <code>RecommendationSourceType</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify one of the following options if you specify the <code>name</code>
        /// parameter as <code>FindingReasonCodes</code>:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUOverprovisioned</code>
        /// </b> — The
        /// instance’s CPU configuration can be sized down while still meeting the
        /// performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUUnderprovisioned</code>
        /// </b> —
        /// The instance’s CPU configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better CPU performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryOverprovisioned</code>
        /// </b> —
        /// The instance’s memory configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MemoryUnderprovisioned</code>
        /// </b> —
        /// The instance’s memory configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better memory performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSThroughputOverprovisioned</code>
        /// </b> — The
        /// instance’s EBS throughput configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSThroughputUnderprovisioned</code>
        /// </b> — The
        /// instance’s EBS throughput configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better EBS throughput performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSIOPSOverprovisioned</code>
        /// </b> —
        /// The instance’s EBS IOPS configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EBSIOPSUnderprovisioned</code>
        /// </b>
        /// — The instance’s EBS IOPS configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better EBS IOPS performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkBandwidthOverprovisioned</code>
        /// </b> — The
        /// instance’s network bandwidth configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkBandwidthUnderprovisioned</code>
        /// </b> — The
        /// instance’s network bandwidth configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better network bandwidth performance. This finding reason
        /// happens when the <code>NetworkIn</code> or <code>NetworkOut</code>
        /// performance of an instance is impacted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkPPSOverprovisioned</code>
        /// </b> — The instance’s
        /// network PPS (packets per second) configuration can be sized down while
        /// still meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkPPSUnderprovisioned</code>
        /// </b> — The instance’s
        /// network PPS (packets per second) configuration doesn't meet the
        /// performance requirements of your workload and there is an alternative
        /// instance type that provides better network PPS performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskIOPSOverprovisioned</code>
        /// </b>
        /// — The instance’s disk IOPS configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskIOPSUnderprovisioned</code>
        /// </b>
        /// — The instance’s disk IOPS configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better disk IOPS performance.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskThroughputOverprovisioned</code>
        /// </b> — The
        /// instance’s disk throughput configuration can be sized down while still
        /// meeting the performance requirements of your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskThroughputUnderprovisioned</code>
        /// </b> — The
        /// instance’s disk throughput configuration doesn't meet the performance
        /// requirements of your workload and there is an alternative instance type
        /// that provides better disk throughput performance.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterName {
    #[allow(missing_docs)] // documentation missing in model
    Finding,
    #[allow(missing_docs)] // documentation missing in model
    FindingReasonCodes,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationSourceType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterName {
    fn from(s: &str) -> Self {
        match s {
            "Finding" => FilterName::Finding,
            "FindingReasonCodes" => FilterName::FindingReasonCodes,
            "RecommendationSourceType" => FilterName::RecommendationSourceType,
            other => FilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterName::from(s))
    }
}
impl FilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterName::Finding => "Finding",
            FilterName::FindingReasonCodes => "FindingReasonCodes",
            FilterName::RecommendationSourceType => "RecommendationSourceType",
            FilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Finding", "FindingReasonCodes", "RecommendationSourceType"]
    }
}
impl AsRef<str> for FilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an Amazon Elastic Block Store (Amazon EBS) volume recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeRecommendation {
    /// <p>The Amazon Resource Name (ARN) of the current volume.</p>
    pub volume_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the volume.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An array of objects that describe the current configuration of the volume.</p>
    pub current_configuration: std::option::Option<crate::model::VolumeConfiguration>,
    /// <p>The finding classification of the volume.</p>
    ///
    /// <p>Findings for volumes include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NotOptimized</code>
    /// </b>—A volume is
    /// considered not optimized when Compute Optimizer identifies a recommendation
    /// that can provide better performance for your workload.</p>
    ///
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Optimized</code>
    /// </b>—An volume is
    /// considered optimized when Compute Optimizer determines that the volume is
    /// correctly provisioned to run your workload based on the chosen volume type. For
    /// optimized resources, Compute Optimizer might recommend a new generation volume
    /// type.</p>
    ///
    /// </li>
    /// </ul>
    pub finding: std::option::Option<crate::model::EbsFinding>,
    /// <p>An array of objects that describe the utilization metrics of the volume.</p>
    pub utilization_metrics: std::option::Option<std::vec::Vec<crate::model::EbsUtilizationMetric>>,
    /// <p>The number of days for which utilization metrics were analyzed for the volume.</p>
    pub look_back_period_in_days: f64,
    /// <p>An array of objects that describe the recommendation options for the volume.</p>
    pub volume_recommendation_options:
        std::option::Option<std::vec::Vec<crate::model::VolumeRecommendationOption>>,
    /// <p>The timestamp of when the volume recommendation was last refreshed.</p>
    pub last_refresh_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl VolumeRecommendation {
    /// <p>The Amazon Resource Name (ARN) of the current volume.</p>
    pub fn volume_arn(&self) -> std::option::Option<&str> {
        self.volume_arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the volume.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An array of objects that describe the current configuration of the volume.</p>
    pub fn current_configuration(&self) -> std::option::Option<&crate::model::VolumeConfiguration> {
        self.current_configuration.as_ref()
    }
    /// <p>The finding classification of the volume.</p>
    ///
    /// <p>Findings for volumes include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NotOptimized</code>
    /// </b>—A volume is
    /// considered not optimized when Compute Optimizer identifies a recommendation
    /// that can provide better performance for your workload.</p>
    ///
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Optimized</code>
    /// </b>—An volume is
    /// considered optimized when Compute Optimizer determines that the volume is
    /// correctly provisioned to run your workload based on the chosen volume type. For
    /// optimized resources, Compute Optimizer might recommend a new generation volume
    /// type.</p>
    ///
    /// </li>
    /// </ul>
    pub fn finding(&self) -> std::option::Option<&crate::model::EbsFinding> {
        self.finding.as_ref()
    }
    /// <p>An array of objects that describe the utilization metrics of the volume.</p>
    pub fn utilization_metrics(
        &self,
    ) -> std::option::Option<&[crate::model::EbsUtilizationMetric]> {
        self.utilization_metrics.as_deref()
    }
    /// <p>The number of days for which utilization metrics were analyzed for the volume.</p>
    pub fn look_back_period_in_days(&self) -> f64 {
        self.look_back_period_in_days
    }
    /// <p>An array of objects that describe the recommendation options for the volume.</p>
    pub fn volume_recommendation_options(
        &self,
    ) -> std::option::Option<&[crate::model::VolumeRecommendationOption]> {
        self.volume_recommendation_options.as_deref()
    }
    /// <p>The timestamp of when the volume recommendation was last refreshed.</p>
    pub fn last_refresh_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_refresh_timestamp.as_ref()
    }
}
impl std::fmt::Debug for VolumeRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeRecommendation");
        formatter.field("volume_arn", &self.volume_arn);
        formatter.field("account_id", &self.account_id);
        formatter.field("current_configuration", &self.current_configuration);
        formatter.field("finding", &self.finding);
        formatter.field("utilization_metrics", &self.utilization_metrics);
        formatter.field("look_back_period_in_days", &self.look_back_period_in_days);
        formatter.field(
            "volume_recommendation_options",
            &self.volume_recommendation_options,
        );
        formatter.field("last_refresh_timestamp", &self.last_refresh_timestamp);
        formatter.finish()
    }
}
/// See [`VolumeRecommendation`](crate::model::VolumeRecommendation)
pub mod volume_recommendation {
    /// A builder for [`VolumeRecommendation`](crate::model::VolumeRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arn: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) current_configuration: std::option::Option<crate::model::VolumeConfiguration>,
        pub(crate) finding: std::option::Option<crate::model::EbsFinding>,
        pub(crate) utilization_metrics:
            std::option::Option<std::vec::Vec<crate::model::EbsUtilizationMetric>>,
        pub(crate) look_back_period_in_days: std::option::Option<f64>,
        pub(crate) volume_recommendation_options:
            std::option::Option<std::vec::Vec<crate::model::VolumeRecommendationOption>>,
        pub(crate) last_refresh_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the current volume.</p>
        pub fn volume_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the current volume.</p>
        pub fn set_volume_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the volume.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the volume.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An array of objects that describe the current configuration of the volume.</p>
        pub fn current_configuration(mut self, input: crate::model::VolumeConfiguration) -> Self {
            self.current_configuration = Some(input);
            self
        }
        /// <p>An array of objects that describe the current configuration of the volume.</p>
        pub fn set_current_configuration(
            mut self,
            input: std::option::Option<crate::model::VolumeConfiguration>,
        ) -> Self {
            self.current_configuration = input;
            self
        }
        /// <p>The finding classification of the volume.</p>
        ///
        /// <p>Findings for volumes include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NotOptimized</code>
        /// </b>—A volume is
        /// considered not optimized when Compute Optimizer identifies a recommendation
        /// that can provide better performance for your workload.</p>
        ///
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Optimized</code>
        /// </b>—An volume is
        /// considered optimized when Compute Optimizer determines that the volume is
        /// correctly provisioned to run your workload based on the chosen volume type. For
        /// optimized resources, Compute Optimizer might recommend a new generation volume
        /// type.</p>
        ///
        /// </li>
        /// </ul>
        pub fn finding(mut self, input: crate::model::EbsFinding) -> Self {
            self.finding = Some(input);
            self
        }
        /// <p>The finding classification of the volume.</p>
        ///
        /// <p>Findings for volumes include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NotOptimized</code>
        /// </b>—A volume is
        /// considered not optimized when Compute Optimizer identifies a recommendation
        /// that can provide better performance for your workload.</p>
        ///
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Optimized</code>
        /// </b>—An volume is
        /// considered optimized when Compute Optimizer determines that the volume is
        /// correctly provisioned to run your workload based on the chosen volume type. For
        /// optimized resources, Compute Optimizer might recommend a new generation volume
        /// type.</p>
        ///
        /// </li>
        /// </ul>
        pub fn set_finding(mut self, input: std::option::Option<crate::model::EbsFinding>) -> Self {
            self.finding = input;
            self
        }
        /// Appends an item to `utilization_metrics`.
        ///
        /// To override the contents of this collection use [`set_utilization_metrics`](Self::set_utilization_metrics).
        ///
        /// <p>An array of objects that describe the utilization metrics of the volume.</p>
        pub fn utilization_metrics(
            mut self,
            input: impl Into<crate::model::EbsUtilizationMetric>,
        ) -> Self {
            let mut v = self.utilization_metrics.unwrap_or_default();
            v.push(input.into());
            self.utilization_metrics = Some(v);
            self
        }
        /// <p>An array of objects that describe the utilization metrics of the volume.</p>
        pub fn set_utilization_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EbsUtilizationMetric>>,
        ) -> Self {
            self.utilization_metrics = input;
            self
        }
        /// <p>The number of days for which utilization metrics were analyzed for the volume.</p>
        pub fn look_back_period_in_days(mut self, input: f64) -> Self {
            self.look_back_period_in_days = Some(input);
            self
        }
        /// <p>The number of days for which utilization metrics were analyzed for the volume.</p>
        pub fn set_look_back_period_in_days(mut self, input: std::option::Option<f64>) -> Self {
            self.look_back_period_in_days = input;
            self
        }
        /// Appends an item to `volume_recommendation_options`.
        ///
        /// To override the contents of this collection use [`set_volume_recommendation_options`](Self::set_volume_recommendation_options).
        ///
        /// <p>An array of objects that describe the recommendation options for the volume.</p>
        pub fn volume_recommendation_options(
            mut self,
            input: impl Into<crate::model::VolumeRecommendationOption>,
        ) -> Self {
            let mut v = self.volume_recommendation_options.unwrap_or_default();
            v.push(input.into());
            self.volume_recommendation_options = Some(v);
            self
        }
        /// <p>An array of objects that describe the recommendation options for the volume.</p>
        pub fn set_volume_recommendation_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VolumeRecommendationOption>>,
        ) -> Self {
            self.volume_recommendation_options = input;
            self
        }
        /// <p>The timestamp of when the volume recommendation was last refreshed.</p>
        pub fn last_refresh_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_refresh_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of when the volume recommendation was last refreshed.</p>
        pub fn set_last_refresh_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_refresh_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeRecommendation`](crate::model::VolumeRecommendation)
        pub fn build(self) -> crate::model::VolumeRecommendation {
            crate::model::VolumeRecommendation {
                volume_arn: self.volume_arn,
                account_id: self.account_id,
                current_configuration: self.current_configuration,
                finding: self.finding,
                utilization_metrics: self.utilization_metrics,
                look_back_period_in_days: self.look_back_period_in_days.unwrap_or_default(),
                volume_recommendation_options: self.volume_recommendation_options,
                last_refresh_timestamp: self.last_refresh_timestamp,
            }
        }
    }
}
impl VolumeRecommendation {
    /// Creates a new builder-style object to manufacture [`VolumeRecommendation`](crate::model::VolumeRecommendation)
    pub fn builder() -> crate::model::volume_recommendation::Builder {
        crate::model::volume_recommendation::Builder::default()
    }
}

/// <p>Describes a recommendation option for an Amazon Elastic Block Store (Amazon EBS)
/// instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeRecommendationOption {
    /// <p>An array of objects that describe a volume configuration.</p>
    pub configuration: std::option::Option<crate::model::VolumeConfiguration>,
    /// <p>The performance risk of the volume recommendation option.</p>
    ///
    /// <p>Performance risk is the likelihood of the recommended volume type meeting the
    /// performance requirement of your workload.</p>
    ///
    /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
    /// that the recommended resource is predicted to always provide enough hardware capability.
    /// The higher the performance risk is, the more likely you should validate whether the
    /// recommendation will meet the performance requirements of your workload before migrating
    /// your resource.</p>
    pub performance_risk: f64,
    /// <p>The rank of the volume recommendation option.</p>
    ///
    /// <p>The top recommendation option is ranked as <code>1</code>.</p>
    pub rank: i32,
}
impl VolumeRecommendationOption {
    /// <p>An array of objects that describe a volume configuration.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::VolumeConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The performance risk of the volume recommendation option.</p>
    ///
    /// <p>Performance risk is the likelihood of the recommended volume type meeting the
    /// performance requirement of your workload.</p>
    ///
    /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
    /// that the recommended resource is predicted to always provide enough hardware capability.
    /// The higher the performance risk is, the more likely you should validate whether the
    /// recommendation will meet the performance requirements of your workload before migrating
    /// your resource.</p>
    pub fn performance_risk(&self) -> f64 {
        self.performance_risk
    }
    /// <p>The rank of the volume recommendation option.</p>
    ///
    /// <p>The top recommendation option is ranked as <code>1</code>.</p>
    pub fn rank(&self) -> i32 {
        self.rank
    }
}
impl std::fmt::Debug for VolumeRecommendationOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeRecommendationOption");
        formatter.field("configuration", &self.configuration);
        formatter.field("performance_risk", &self.performance_risk);
        formatter.field("rank", &self.rank);
        formatter.finish()
    }
}
/// See [`VolumeRecommendationOption`](crate::model::VolumeRecommendationOption)
pub mod volume_recommendation_option {
    /// A builder for [`VolumeRecommendationOption`](crate::model::VolumeRecommendationOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration: std::option::Option<crate::model::VolumeConfiguration>,
        pub(crate) performance_risk: std::option::Option<f64>,
        pub(crate) rank: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An array of objects that describe a volume configuration.</p>
        pub fn configuration(mut self, input: crate::model::VolumeConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>An array of objects that describe a volume configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::VolumeConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The performance risk of the volume recommendation option.</p>
        ///
        /// <p>Performance risk is the likelihood of the recommended volume type meeting the
        /// performance requirement of your workload.</p>
        ///
        /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
        /// that the recommended resource is predicted to always provide enough hardware capability.
        /// The higher the performance risk is, the more likely you should validate whether the
        /// recommendation will meet the performance requirements of your workload before migrating
        /// your resource.</p>
        pub fn performance_risk(mut self, input: f64) -> Self {
            self.performance_risk = Some(input);
            self
        }
        /// <p>The performance risk of the volume recommendation option.</p>
        ///
        /// <p>Performance risk is the likelihood of the recommended volume type meeting the
        /// performance requirement of your workload.</p>
        ///
        /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
        /// that the recommended resource is predicted to always provide enough hardware capability.
        /// The higher the performance risk is, the more likely you should validate whether the
        /// recommendation will meet the performance requirements of your workload before migrating
        /// your resource.</p>
        pub fn set_performance_risk(mut self, input: std::option::Option<f64>) -> Self {
            self.performance_risk = input;
            self
        }
        /// <p>The rank of the volume recommendation option.</p>
        ///
        /// <p>The top recommendation option is ranked as <code>1</code>.</p>
        pub fn rank(mut self, input: i32) -> Self {
            self.rank = Some(input);
            self
        }
        /// <p>The rank of the volume recommendation option.</p>
        ///
        /// <p>The top recommendation option is ranked as <code>1</code>.</p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.rank = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeRecommendationOption`](crate::model::VolumeRecommendationOption)
        pub fn build(self) -> crate::model::VolumeRecommendationOption {
            crate::model::VolumeRecommendationOption {
                configuration: self.configuration,
                performance_risk: self.performance_risk.unwrap_or_default(),
                rank: self.rank.unwrap_or_default(),
            }
        }
    }
}
impl VolumeRecommendationOption {
    /// Creates a new builder-style object to manufacture [`VolumeRecommendationOption`](crate::model::VolumeRecommendationOption)
    pub fn builder() -> crate::model::volume_recommendation_option::Builder {
        crate::model::volume_recommendation_option::Builder::default()
    }
}

/// <p>Describes the configuration of an Amazon Elastic Block Store (Amazon EBS)
/// volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeConfiguration {
    /// <p>The volume type.</p>
    ///
    /// <p>This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> or
    /// <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized
    /// HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic
    /// volumes.</p>
    pub volume_type: std::option::Option<std::string::String>,
    /// <p>The size of the volume, in GiB.</p>
    pub volume_size: i32,
    /// <p>The baseline IOPS of the volume.</p>
    pub volume_baseline_iops: i32,
    /// <p>The burst IOPS of the volume.</p>
    pub volume_burst_iops: i32,
    /// <p>The baseline throughput of the volume.</p>
    pub volume_baseline_throughput: i32,
    /// <p>The burst throughput of the volume.</p>
    pub volume_burst_throughput: i32,
}
impl VolumeConfiguration {
    /// <p>The volume type.</p>
    ///
    /// <p>This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> or
    /// <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized
    /// HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic
    /// volumes.</p>
    pub fn volume_type(&self) -> std::option::Option<&str> {
        self.volume_type.as_deref()
    }
    /// <p>The size of the volume, in GiB.</p>
    pub fn volume_size(&self) -> i32 {
        self.volume_size
    }
    /// <p>The baseline IOPS of the volume.</p>
    pub fn volume_baseline_iops(&self) -> i32 {
        self.volume_baseline_iops
    }
    /// <p>The burst IOPS of the volume.</p>
    pub fn volume_burst_iops(&self) -> i32 {
        self.volume_burst_iops
    }
    /// <p>The baseline throughput of the volume.</p>
    pub fn volume_baseline_throughput(&self) -> i32 {
        self.volume_baseline_throughput
    }
    /// <p>The burst throughput of the volume.</p>
    pub fn volume_burst_throughput(&self) -> i32 {
        self.volume_burst_throughput
    }
}
impl std::fmt::Debug for VolumeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeConfiguration");
        formatter.field("volume_type", &self.volume_type);
        formatter.field("volume_size", &self.volume_size);
        formatter.field("volume_baseline_iops", &self.volume_baseline_iops);
        formatter.field("volume_burst_iops", &self.volume_burst_iops);
        formatter.field(
            "volume_baseline_throughput",
            &self.volume_baseline_throughput,
        );
        formatter.field("volume_burst_throughput", &self.volume_burst_throughput);
        formatter.finish()
    }
}
/// See [`VolumeConfiguration`](crate::model::VolumeConfiguration)
pub mod volume_configuration {
    /// A builder for [`VolumeConfiguration`](crate::model::VolumeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_type: std::option::Option<std::string::String>,
        pub(crate) volume_size: std::option::Option<i32>,
        pub(crate) volume_baseline_iops: std::option::Option<i32>,
        pub(crate) volume_burst_iops: std::option::Option<i32>,
        pub(crate) volume_baseline_throughput: std::option::Option<i32>,
        pub(crate) volume_burst_throughput: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The volume type.</p>
        ///
        /// <p>This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> or
        /// <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized
        /// HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic
        /// volumes.</p>
        pub fn volume_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_type = Some(input.into());
            self
        }
        /// <p>The volume type.</p>
        ///
        /// <p>This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> or
        /// <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized
        /// HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic
        /// volumes.</p>
        pub fn set_volume_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>The size of the volume, in GiB.</p>
        pub fn volume_size(mut self, input: i32) -> Self {
            self.volume_size = Some(input);
            self
        }
        /// <p>The size of the volume, in GiB.</p>
        pub fn set_volume_size(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size = input;
            self
        }
        /// <p>The baseline IOPS of the volume.</p>
        pub fn volume_baseline_iops(mut self, input: i32) -> Self {
            self.volume_baseline_iops = Some(input);
            self
        }
        /// <p>The baseline IOPS of the volume.</p>
        pub fn set_volume_baseline_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_baseline_iops = input;
            self
        }
        /// <p>The burst IOPS of the volume.</p>
        pub fn volume_burst_iops(mut self, input: i32) -> Self {
            self.volume_burst_iops = Some(input);
            self
        }
        /// <p>The burst IOPS of the volume.</p>
        pub fn set_volume_burst_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_burst_iops = input;
            self
        }
        /// <p>The baseline throughput of the volume.</p>
        pub fn volume_baseline_throughput(mut self, input: i32) -> Self {
            self.volume_baseline_throughput = Some(input);
            self
        }
        /// <p>The baseline throughput of the volume.</p>
        pub fn set_volume_baseline_throughput(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_baseline_throughput = input;
            self
        }
        /// <p>The burst throughput of the volume.</p>
        pub fn volume_burst_throughput(mut self, input: i32) -> Self {
            self.volume_burst_throughput = Some(input);
            self
        }
        /// <p>The burst throughput of the volume.</p>
        pub fn set_volume_burst_throughput(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_burst_throughput = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeConfiguration`](crate::model::VolumeConfiguration)
        pub fn build(self) -> crate::model::VolumeConfiguration {
            crate::model::VolumeConfiguration {
                volume_type: self.volume_type,
                volume_size: self.volume_size.unwrap_or_default(),
                volume_baseline_iops: self.volume_baseline_iops.unwrap_or_default(),
                volume_burst_iops: self.volume_burst_iops.unwrap_or_default(),
                volume_baseline_throughput: self.volume_baseline_throughput.unwrap_or_default(),
                volume_burst_throughput: self.volume_burst_throughput.unwrap_or_default(),
            }
        }
    }
}
impl VolumeConfiguration {
    /// Creates a new builder-style object to manufacture [`VolumeConfiguration`](crate::model::VolumeConfiguration)
    pub fn builder() -> crate::model::volume_configuration::Builder {
        crate::model::volume_configuration::Builder::default()
    }
}

/// <p>Describes a utilization metric of an Amazon Elastic Block Store (Amazon EBS)
/// volume.</p>
///
/// <p>Compare the utilization metric data of your resource against its projected utilization
/// metric data to determine the performance difference between your current resource and
/// the recommended option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsUtilizationMetric {
    /// <p>The name of the utilization metric.</p>
    ///
    /// <p>The following utilization metrics are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>VolumeReadOpsPerSecond</code> - The completed read operations per second
    /// from the volume in a specified period of time.</p>
    /// <p>Unit: Count</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VolumeWriteOpsPerSecond</code> - The completed write operations per
    /// second to the volume in a specified period of time.</p>
    /// <p>Unit: Count</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VolumeReadBytesPerSecond</code> - The bytes read per second from the
    /// volume in a specified period of time.</p>
    /// <p>Unit: Bytes</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VolumeWriteBytesPerSecond</code> - The bytes written to the volume in a
    /// specified period of time.</p>
    /// <p>Unit: Bytes</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<crate::model::EbsMetricName>,
    /// <p>The statistic of the utilization metric.</p>
    ///
    /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
    /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
    /// highest value observed during the specified period.</p>
    ///
    /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
    /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
    /// <code>SampleCount</code> during the specified period. For more information, see
    /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
    /// recommendations</a> in the <i>Compute Optimizer User
    /// Guide</i>. You can also get averaged utilization metric data for your resources
    /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
    /// User Guide</a>.</p>
    pub statistic: std::option::Option<crate::model::MetricStatistic>,
    /// <p>The value of the utilization metric.</p>
    pub value: f64,
}
impl EbsUtilizationMetric {
    /// <p>The name of the utilization metric.</p>
    ///
    /// <p>The following utilization metrics are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>VolumeReadOpsPerSecond</code> - The completed read operations per second
    /// from the volume in a specified period of time.</p>
    /// <p>Unit: Count</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VolumeWriteOpsPerSecond</code> - The completed write operations per
    /// second to the volume in a specified period of time.</p>
    /// <p>Unit: Count</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VolumeReadBytesPerSecond</code> - The bytes read per second from the
    /// volume in a specified period of time.</p>
    /// <p>Unit: Bytes</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VolumeWriteBytesPerSecond</code> - The bytes written to the volume in a
    /// specified period of time.</p>
    /// <p>Unit: Bytes</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&crate::model::EbsMetricName> {
        self.name.as_ref()
    }
    /// <p>The statistic of the utilization metric.</p>
    ///
    /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
    /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
    /// highest value observed during the specified period.</p>
    ///
    /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
    /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
    /// <code>SampleCount</code> during the specified period. For more information, see
    /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
    /// recommendations</a> in the <i>Compute Optimizer User
    /// Guide</i>. You can also get averaged utilization metric data for your resources
    /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
    /// User Guide</a>.</p>
    pub fn statistic(&self) -> std::option::Option<&crate::model::MetricStatistic> {
        self.statistic.as_ref()
    }
    /// <p>The value of the utilization metric.</p>
    pub fn value(&self) -> f64 {
        self.value
    }
}
impl std::fmt::Debug for EbsUtilizationMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsUtilizationMetric");
        formatter.field("name", &self.name);
        formatter.field("statistic", &self.statistic);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`EbsUtilizationMetric`](crate::model::EbsUtilizationMetric)
pub mod ebs_utilization_metric {
    /// A builder for [`EbsUtilizationMetric`](crate::model::EbsUtilizationMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::EbsMetricName>,
        pub(crate) statistic: std::option::Option<crate::model::MetricStatistic>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of the utilization metric.</p>
        ///
        /// <p>The following utilization metrics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>VolumeReadOpsPerSecond</code> - The completed read operations per second
        /// from the volume in a specified period of time.</p>
        /// <p>Unit: Count</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VolumeWriteOpsPerSecond</code> - The completed write operations per
        /// second to the volume in a specified period of time.</p>
        /// <p>Unit: Count</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VolumeReadBytesPerSecond</code> - The bytes read per second from the
        /// volume in a specified period of time.</p>
        /// <p>Unit: Bytes</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VolumeWriteBytesPerSecond</code> - The bytes written to the volume in a
        /// specified period of time.</p>
        /// <p>Unit: Bytes</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: crate::model::EbsMetricName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the utilization metric.</p>
        ///
        /// <p>The following utilization metrics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>VolumeReadOpsPerSecond</code> - The completed read operations per second
        /// from the volume in a specified period of time.</p>
        /// <p>Unit: Count</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VolumeWriteOpsPerSecond</code> - The completed write operations per
        /// second to the volume in a specified period of time.</p>
        /// <p>Unit: Count</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VolumeReadBytesPerSecond</code> - The bytes read per second from the
        /// volume in a specified period of time.</p>
        /// <p>Unit: Bytes</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VolumeWriteBytesPerSecond</code> - The bytes written to the volume in a
        /// specified period of time.</p>
        /// <p>Unit: Bytes</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<crate::model::EbsMetricName>) -> Self {
            self.name = input;
            self
        }
        /// <p>The statistic of the utilization metric.</p>
        ///
        /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
        /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
        /// highest value observed during the specified period.</p>
        ///
        /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
        /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
        /// <code>SampleCount</code> during the specified period. For more information, see
        /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
        /// recommendations</a> in the <i>Compute Optimizer User
        /// Guide</i>. You can also get averaged utilization metric data for your resources
        /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
        /// User Guide</a>.</p>
        pub fn statistic(mut self, input: crate::model::MetricStatistic) -> Self {
            self.statistic = Some(input);
            self
        }
        /// <p>The statistic of the utilization metric.</p>
        ///
        /// <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs
        /// return utilization metrics using only the <code>Maximum</code> statistic, which is the
        /// highest value observed during the specified period.</p>
        ///
        /// <p>The Compute Optimizer console displays graphs for some utilization metrics using the
        /// <code>Average</code> statistic, which is the value of <code>Sum</code> /
        /// <code>SampleCount</code> during the specified period. For more information, see
        /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource
        /// recommendations</a> in the <i>Compute Optimizer User
        /// Guide</i>. You can also get averaged utilization metric data for your resources
        /// using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch
        /// User Guide</a>.</p>
        pub fn set_statistic(
            mut self,
            input: std::option::Option<crate::model::MetricStatistic>,
        ) -> Self {
            self.statistic = input;
            self
        }
        /// <p>The value of the utilization metric.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the utilization metric.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsUtilizationMetric`](crate::model::EbsUtilizationMetric)
        pub fn build(self) -> crate::model::EbsUtilizationMetric {
            crate::model::EbsUtilizationMetric {
                name: self.name,
                statistic: self.statistic,
                value: self.value.unwrap_or_default(),
            }
        }
    }
}
impl EbsUtilizationMetric {
    /// Creates a new builder-style object to manufacture [`EbsUtilizationMetric`](crate::model::EbsUtilizationMetric)
    pub fn builder() -> crate::model::ebs_utilization_metric::Builder {
        crate::model::ebs_utilization_metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EbsMetricName {
    #[allow(missing_docs)] // documentation missing in model
    VolumeReadBytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    VolumeReadOpsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    VolumeWriteBytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    VolumeWriteOpsPerSecond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EbsMetricName {
    fn from(s: &str) -> Self {
        match s {
            "VolumeReadBytesPerSecond" => EbsMetricName::VolumeReadBytesPerSecond,
            "VolumeReadOpsPerSecond" => EbsMetricName::VolumeReadOpsPerSecond,
            "VolumeWriteBytesPerSecond" => EbsMetricName::VolumeWriteBytesPerSecond,
            "VolumeWriteOpsPerSecond" => EbsMetricName::VolumeWriteOpsPerSecond,
            other => EbsMetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EbsMetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EbsMetricName::from(s))
    }
}
impl EbsMetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EbsMetricName::VolumeReadBytesPerSecond => "VolumeReadBytesPerSecond",
            EbsMetricName::VolumeReadOpsPerSecond => "VolumeReadOpsPerSecond",
            EbsMetricName::VolumeWriteBytesPerSecond => "VolumeWriteBytesPerSecond",
            EbsMetricName::VolumeWriteOpsPerSecond => "VolumeWriteOpsPerSecond",
            EbsMetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "VolumeReadBytesPerSecond",
            "VolumeReadOpsPerSecond",
            "VolumeWriteBytesPerSecond",
            "VolumeWriteOpsPerSecond",
        ]
    }
}
impl AsRef<str> for EbsMetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EbsFinding {
    #[allow(missing_docs)] // documentation missing in model
    NotOptimized,
    #[allow(missing_docs)] // documentation missing in model
    Optimized,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EbsFinding {
    fn from(s: &str) -> Self {
        match s {
            "NotOptimized" => EbsFinding::NotOptimized,
            "Optimized" => EbsFinding::Optimized,
            other => EbsFinding::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EbsFinding {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EbsFinding::from(s))
    }
}
impl EbsFinding {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EbsFinding::NotOptimized => "NotOptimized",
            EbsFinding::Optimized => "Optimized",
            EbsFinding::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NotOptimized", "Optimized"]
    }
}
impl AsRef<str> for EbsFinding {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a filter that returns a more specific list of Amazon Elastic Block Store
/// (Amazon EBS) volume recommendations. Use this filter with the <a>GetEBSVolumeRecommendations</a> action.</p>
///
/// <p>You can use <code>LambdaFunctionRecommendationFilter</code> with the <a>GetLambdaFunctionRecommendations</a> action, <code>JobFilter</code> with the
/// <a>DescribeRecommendationExportJobs</a> action, and <code>Filter</code>
/// with the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsFilter {
    /// <p>The name of the filter.</p>
    ///
    /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
    /// classification (for example, <code>NotOptimized</code>).</p>
    pub name: std::option::Option<crate::model::EbsFilterName>,
    /// <p>The value of the filter.</p>
    ///
    /// <p>The valid values are <code>Optimized</code>, or <code>NotOptimized</code>.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EbsFilter {
    /// <p>The name of the filter.</p>
    ///
    /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
    /// classification (for example, <code>NotOptimized</code>).</p>
    pub fn name(&self) -> std::option::Option<&crate::model::EbsFilterName> {
        self.name.as_ref()
    }
    /// <p>The value of the filter.</p>
    ///
    /// <p>The valid values are <code>Optimized</code>, or <code>NotOptimized</code>.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for EbsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`EbsFilter`](crate::model::EbsFilter)
pub mod ebs_filter {
    /// A builder for [`EbsFilter`](crate::model::EbsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::EbsFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        ///
        /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
        /// classification (for example, <code>NotOptimized</code>).</p>
        pub fn name(mut self, input: crate::model::EbsFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the filter.</p>
        ///
        /// <p>Specify <code>Finding</code> to return recommendations with a specific finding
        /// classification (for example, <code>NotOptimized</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::EbsFilterName>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value of the filter.</p>
        ///
        /// <p>The valid values are <code>Optimized</code>, or <code>NotOptimized</code>.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value of the filter.</p>
        ///
        /// <p>The valid values are <code>Optimized</code>, or <code>NotOptimized</code>.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsFilter`](crate::model::EbsFilter)
        pub fn build(self) -> crate::model::EbsFilter {
            crate::model::EbsFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl EbsFilter {
    /// Creates a new builder-style object to manufacture [`EbsFilter`](crate::model::EbsFilter)
    pub fn builder() -> crate::model::ebs_filter::Builder {
        crate::model::ebs_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EbsFilterName {
    #[allow(missing_docs)] // documentation missing in model
    Finding,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EbsFilterName {
    fn from(s: &str) -> Self {
        match s {
            "Finding" => EbsFilterName::Finding,
            other => EbsFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EbsFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EbsFilterName::from(s))
    }
}
impl EbsFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EbsFilterName::Finding => "Finding",
            EbsFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Finding"]
    }
}
impl AsRef<str> for EbsFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an Auto Scaling group recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingGroupRecommendation {
    /// <p>The Amazon Web Services account ID of the Auto Scaling group.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
    pub auto_scaling_group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The finding classification of the Auto Scaling group.</p>
    ///
    /// <p>Findings for Auto Scaling groups include:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NotOptimized</code>
    /// </b>—An Auto Scaling group is considered not optimized when Compute Optimizer identifies a
    /// recommendation that can provide better performance for your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Optimized</code>
    /// </b>—An Auto Scaling
    /// group is considered optimized when Compute Optimizer determines that the group
    /// is correctly provisioned to run your workload based on the chosen instance type.
    /// For optimized resources, Compute Optimizer might recommend a new generation
    /// instance type.</p>
    /// </li>
    /// </ul>
    pub finding: std::option::Option<crate::model::Finding>,
    /// <p>An array of objects that describe the utilization metrics of the Auto Scaling
    /// group.</p>
    pub utilization_metrics: std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
    /// <p>The number of days for which utilization metrics were analyzed for the Auto Scaling group.</p>
    pub look_back_period_in_days: f64,
    /// <p>An array of objects that describe the current configuration of the Auto Scaling
    /// group.</p>
    pub current_configuration: std::option::Option<crate::model::AutoScalingGroupConfiguration>,
    /// <p>An array of objects that describe the recommendation options for the Auto Scaling
    /// group.</p>
    pub recommendation_options:
        std::option::Option<std::vec::Vec<crate::model::AutoScalingGroupRecommendationOption>>,
    /// <p>The timestamp  of when the Auto Scaling group recommendation was last
    /// refreshed.</p>
    pub last_refresh_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl AutoScalingGroupRecommendation {
    /// <p>The Amazon Web Services account ID of the Auto Scaling group.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
    pub fn auto_scaling_group_arn(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_arn.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The finding classification of the Auto Scaling group.</p>
    ///
    /// <p>Findings for Auto Scaling groups include:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NotOptimized</code>
    /// </b>—An Auto Scaling group is considered not optimized when Compute Optimizer identifies a
    /// recommendation that can provide better performance for your workload.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Optimized</code>
    /// </b>—An Auto Scaling
    /// group is considered optimized when Compute Optimizer determines that the group
    /// is correctly provisioned to run your workload based on the chosen instance type.
    /// For optimized resources, Compute Optimizer might recommend a new generation
    /// instance type.</p>
    /// </li>
    /// </ul>
    pub fn finding(&self) -> std::option::Option<&crate::model::Finding> {
        self.finding.as_ref()
    }
    /// <p>An array of objects that describe the utilization metrics of the Auto Scaling
    /// group.</p>
    pub fn utilization_metrics(&self) -> std::option::Option<&[crate::model::UtilizationMetric]> {
        self.utilization_metrics.as_deref()
    }
    /// <p>The number of days for which utilization metrics were analyzed for the Auto Scaling group.</p>
    pub fn look_back_period_in_days(&self) -> f64 {
        self.look_back_period_in_days
    }
    /// <p>An array of objects that describe the current configuration of the Auto Scaling
    /// group.</p>
    pub fn current_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingGroupConfiguration> {
        self.current_configuration.as_ref()
    }
    /// <p>An array of objects that describe the recommendation options for the Auto Scaling
    /// group.</p>
    pub fn recommendation_options(
        &self,
    ) -> std::option::Option<&[crate::model::AutoScalingGroupRecommendationOption]> {
        self.recommendation_options.as_deref()
    }
    /// <p>The timestamp  of when the Auto Scaling group recommendation was last
    /// refreshed.</p>
    pub fn last_refresh_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_refresh_timestamp.as_ref()
    }
}
impl std::fmt::Debug for AutoScalingGroupRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingGroupRecommendation");
        formatter.field("account_id", &self.account_id);
        formatter.field("auto_scaling_group_arn", &self.auto_scaling_group_arn);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("finding", &self.finding);
        formatter.field("utilization_metrics", &self.utilization_metrics);
        formatter.field("look_back_period_in_days", &self.look_back_period_in_days);
        formatter.field("current_configuration", &self.current_configuration);
        formatter.field("recommendation_options", &self.recommendation_options);
        formatter.field("last_refresh_timestamp", &self.last_refresh_timestamp);
        formatter.finish()
    }
}
/// See [`AutoScalingGroupRecommendation`](crate::model::AutoScalingGroupRecommendation)
pub mod auto_scaling_group_recommendation {
    /// A builder for [`AutoScalingGroupRecommendation`](crate::model::AutoScalingGroupRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_arn: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) finding: std::option::Option<crate::model::Finding>,
        pub(crate) utilization_metrics:
            std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
        pub(crate) look_back_period_in_days: std::option::Option<f64>,
        pub(crate) current_configuration:
            std::option::Option<crate::model::AutoScalingGroupConfiguration>,
        pub(crate) recommendation_options:
            std::option::Option<std::vec::Vec<crate::model::AutoScalingGroupRecommendationOption>>,
        pub(crate) last_refresh_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Auto Scaling group.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Auto Scaling group.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
        pub fn auto_scaling_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_arn = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The finding classification of the Auto Scaling group.</p>
        ///
        /// <p>Findings for Auto Scaling groups include:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NotOptimized</code>
        /// </b>—An Auto Scaling group is considered not optimized when Compute Optimizer identifies a
        /// recommendation that can provide better performance for your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Optimized</code>
        /// </b>—An Auto Scaling
        /// group is considered optimized when Compute Optimizer determines that the group
        /// is correctly provisioned to run your workload based on the chosen instance type.
        /// For optimized resources, Compute Optimizer might recommend a new generation
        /// instance type.</p>
        /// </li>
        /// </ul>
        pub fn finding(mut self, input: crate::model::Finding) -> Self {
            self.finding = Some(input);
            self
        }
        /// <p>The finding classification of the Auto Scaling group.</p>
        ///
        /// <p>Findings for Auto Scaling groups include:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NotOptimized</code>
        /// </b>—An Auto Scaling group is considered not optimized when Compute Optimizer identifies a
        /// recommendation that can provide better performance for your workload.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Optimized</code>
        /// </b>—An Auto Scaling
        /// group is considered optimized when Compute Optimizer determines that the group
        /// is correctly provisioned to run your workload based on the chosen instance type.
        /// For optimized resources, Compute Optimizer might recommend a new generation
        /// instance type.</p>
        /// </li>
        /// </ul>
        pub fn set_finding(mut self, input: std::option::Option<crate::model::Finding>) -> Self {
            self.finding = input;
            self
        }
        /// Appends an item to `utilization_metrics`.
        ///
        /// To override the contents of this collection use [`set_utilization_metrics`](Self::set_utilization_metrics).
        ///
        /// <p>An array of objects that describe the utilization metrics of the Auto Scaling
        /// group.</p>
        pub fn utilization_metrics(
            mut self,
            input: impl Into<crate::model::UtilizationMetric>,
        ) -> Self {
            let mut v = self.utilization_metrics.unwrap_or_default();
            v.push(input.into());
            self.utilization_metrics = Some(v);
            self
        }
        /// <p>An array of objects that describe the utilization metrics of the Auto Scaling
        /// group.</p>
        pub fn set_utilization_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
        ) -> Self {
            self.utilization_metrics = input;
            self
        }
        /// <p>The number of days for which utilization metrics were analyzed for the Auto Scaling group.</p>
        pub fn look_back_period_in_days(mut self, input: f64) -> Self {
            self.look_back_period_in_days = Some(input);
            self
        }
        /// <p>The number of days for which utilization metrics were analyzed for the Auto Scaling group.</p>
        pub fn set_look_back_period_in_days(mut self, input: std::option::Option<f64>) -> Self {
            self.look_back_period_in_days = input;
            self
        }
        /// <p>An array of objects that describe the current configuration of the Auto Scaling
        /// group.</p>
        pub fn current_configuration(
            mut self,
            input: crate::model::AutoScalingGroupConfiguration,
        ) -> Self {
            self.current_configuration = Some(input);
            self
        }
        /// <p>An array of objects that describe the current configuration of the Auto Scaling
        /// group.</p>
        pub fn set_current_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoScalingGroupConfiguration>,
        ) -> Self {
            self.current_configuration = input;
            self
        }
        /// Appends an item to `recommendation_options`.
        ///
        /// To override the contents of this collection use [`set_recommendation_options`](Self::set_recommendation_options).
        ///
        /// <p>An array of objects that describe the recommendation options for the Auto Scaling
        /// group.</p>
        pub fn recommendation_options(
            mut self,
            input: impl Into<crate::model::AutoScalingGroupRecommendationOption>,
        ) -> Self {
            let mut v = self.recommendation_options.unwrap_or_default();
            v.push(input.into());
            self.recommendation_options = Some(v);
            self
        }
        /// <p>An array of objects that describe the recommendation options for the Auto Scaling
        /// group.</p>
        pub fn set_recommendation_options(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AutoScalingGroupRecommendationOption>,
            >,
        ) -> Self {
            self.recommendation_options = input;
            self
        }
        /// <p>The timestamp  of when the Auto Scaling group recommendation was last
        /// refreshed.</p>
        pub fn last_refresh_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_refresh_timestamp = Some(input);
            self
        }
        /// <p>The timestamp  of when the Auto Scaling group recommendation was last
        /// refreshed.</p>
        pub fn set_last_refresh_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_refresh_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingGroupRecommendation`](crate::model::AutoScalingGroupRecommendation)
        pub fn build(self) -> crate::model::AutoScalingGroupRecommendation {
            crate::model::AutoScalingGroupRecommendation {
                account_id: self.account_id,
                auto_scaling_group_arn: self.auto_scaling_group_arn,
                auto_scaling_group_name: self.auto_scaling_group_name,
                finding: self.finding,
                utilization_metrics: self.utilization_metrics,
                look_back_period_in_days: self.look_back_period_in_days.unwrap_or_default(),
                current_configuration: self.current_configuration,
                recommendation_options: self.recommendation_options,
                last_refresh_timestamp: self.last_refresh_timestamp,
            }
        }
    }
}
impl AutoScalingGroupRecommendation {
    /// Creates a new builder-style object to manufacture [`AutoScalingGroupRecommendation`](crate::model::AutoScalingGroupRecommendation)
    pub fn builder() -> crate::model::auto_scaling_group_recommendation::Builder {
        crate::model::auto_scaling_group_recommendation::Builder::default()
    }
}

/// <p>Describes a recommendation option for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingGroupRecommendationOption {
    /// <p>An array of objects that describe an Auto Scaling group configuration.</p>
    pub configuration: std::option::Option<crate::model::AutoScalingGroupConfiguration>,
    /// <p>An array of objects that describe the projected utilization metrics of the Auto Scaling group recommendation option.</p>
    ///
    /// <note>
    /// <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected
    /// utilization metrics returned. Additionally, the <code>Memory</code> metric is
    /// returned only for resources that have the unified CloudWatch agent installed
    /// on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
    /// Utilization with the CloudWatch Agent</a>.</p>
    /// </note>
    pub projected_utilization_metrics:
        std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
    /// <p>The performance risk of the Auto Scaling group configuration
    /// recommendation.</p>
    ///
    /// <p>Performance risk indicates the likelihood of the recommended instance type not meeting
    /// the resource needs of your workload. Compute Optimizer calculates an individual
    /// performance risk score for each specification of the recommended instance, including
    /// CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput,
    /// and network PPS.
    /// The performance
    /// risk of the recommended instance is calculated as the maximum performance risk score
    /// across the analyzed resource specifications.</p>
    ///
    /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
    /// that the recommended resource is predicted to always provide enough hardware capability.
    /// The higher the performance risk is, the more likely you should validate whether the
    /// recommendation will meet the performance requirements of your workload before migrating
    /// your resource.</p>
    pub performance_risk: f64,
    /// <p>The rank of the Auto Scaling group recommendation option.</p>
    ///
    /// <p>The top recommendation option is ranked as <code>1</code>.</p>
    pub rank: i32,
}
impl AutoScalingGroupRecommendationOption {
    /// <p>An array of objects that describe an Auto Scaling group configuration.</p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingGroupConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>An array of objects that describe the projected utilization metrics of the Auto Scaling group recommendation option.</p>
    ///
    /// <note>
    /// <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected
    /// utilization metrics returned. Additionally, the <code>Memory</code> metric is
    /// returned only for resources that have the unified CloudWatch agent installed
    /// on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
    /// Utilization with the CloudWatch Agent</a>.</p>
    /// </note>
    pub fn projected_utilization_metrics(
        &self,
    ) -> std::option::Option<&[crate::model::UtilizationMetric]> {
        self.projected_utilization_metrics.as_deref()
    }
    /// <p>The performance risk of the Auto Scaling group configuration
    /// recommendation.</p>
    ///
    /// <p>Performance risk indicates the likelihood of the recommended instance type not meeting
    /// the resource needs of your workload. Compute Optimizer calculates an individual
    /// performance risk score for each specification of the recommended instance, including
    /// CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput,
    /// and network PPS.
    /// The performance
    /// risk of the recommended instance is calculated as the maximum performance risk score
    /// across the analyzed resource specifications.</p>
    ///
    /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
    /// that the recommended resource is predicted to always provide enough hardware capability.
    /// The higher the performance risk is, the more likely you should validate whether the
    /// recommendation will meet the performance requirements of your workload before migrating
    /// your resource.</p>
    pub fn performance_risk(&self) -> f64 {
        self.performance_risk
    }
    /// <p>The rank of the Auto Scaling group recommendation option.</p>
    ///
    /// <p>The top recommendation option is ranked as <code>1</code>.</p>
    pub fn rank(&self) -> i32 {
        self.rank
    }
}
impl std::fmt::Debug for AutoScalingGroupRecommendationOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingGroupRecommendationOption");
        formatter.field("configuration", &self.configuration);
        formatter.field(
            "projected_utilization_metrics",
            &self.projected_utilization_metrics,
        );
        formatter.field("performance_risk", &self.performance_risk);
        formatter.field("rank", &self.rank);
        formatter.finish()
    }
}
/// See [`AutoScalingGroupRecommendationOption`](crate::model::AutoScalingGroupRecommendationOption)
pub mod auto_scaling_group_recommendation_option {
    /// A builder for [`AutoScalingGroupRecommendationOption`](crate::model::AutoScalingGroupRecommendationOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration: std::option::Option<crate::model::AutoScalingGroupConfiguration>,
        pub(crate) projected_utilization_metrics:
            std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
        pub(crate) performance_risk: std::option::Option<f64>,
        pub(crate) rank: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An array of objects that describe an Auto Scaling group configuration.</p>
        pub fn configuration(mut self, input: crate::model::AutoScalingGroupConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>An array of objects that describe an Auto Scaling group configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoScalingGroupConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Appends an item to `projected_utilization_metrics`.
        ///
        /// To override the contents of this collection use [`set_projected_utilization_metrics`](Self::set_projected_utilization_metrics).
        ///
        /// <p>An array of objects that describe the projected utilization metrics of the Auto Scaling group recommendation option.</p>
        ///
        /// <note>
        /// <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected
        /// utilization metrics returned. Additionally, the <code>Memory</code> metric is
        /// returned only for resources that have the unified CloudWatch agent installed
        /// on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
        /// Utilization with the CloudWatch Agent</a>.</p>
        /// </note>
        pub fn projected_utilization_metrics(
            mut self,
            input: impl Into<crate::model::UtilizationMetric>,
        ) -> Self {
            let mut v = self.projected_utilization_metrics.unwrap_or_default();
            v.push(input.into());
            self.projected_utilization_metrics = Some(v);
            self
        }
        /// <p>An array of objects that describe the projected utilization metrics of the Auto Scaling group recommendation option.</p>
        ///
        /// <note>
        /// <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected
        /// utilization metrics returned. Additionally, the <code>Memory</code> metric is
        /// returned only for resources that have the unified CloudWatch agent installed
        /// on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
        /// Utilization with the CloudWatch Agent</a>.</p>
        /// </note>
        pub fn set_projected_utilization_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UtilizationMetric>>,
        ) -> Self {
            self.projected_utilization_metrics = input;
            self
        }
        /// <p>The performance risk of the Auto Scaling group configuration
        /// recommendation.</p>
        ///
        /// <p>Performance risk indicates the likelihood of the recommended instance type not meeting
        /// the resource needs of your workload. Compute Optimizer calculates an individual
        /// performance risk score for each specification of the recommended instance, including
        /// CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput,
        /// and network PPS.
        /// The performance
        /// risk of the recommended instance is calculated as the maximum performance risk score
        /// across the analyzed resource specifications.</p>
        ///
        /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
        /// that the recommended resource is predicted to always provide enough hardware capability.
        /// The higher the performance risk is, the more likely you should validate whether the
        /// recommendation will meet the performance requirements of your workload before migrating
        /// your resource.</p>
        pub fn performance_risk(mut self, input: f64) -> Self {
            self.performance_risk = Some(input);
            self
        }
        /// <p>The performance risk of the Auto Scaling group configuration
        /// recommendation.</p>
        ///
        /// <p>Performance risk indicates the likelihood of the recommended instance type not meeting
        /// the resource needs of your workload. Compute Optimizer calculates an individual
        /// performance risk score for each specification of the recommended instance, including
        /// CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput,
        /// and network PPS.
        /// The performance
        /// risk of the recommended instance is calculated as the maximum performance risk score
        /// across the analyzed resource specifications.</p>
        ///
        /// <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning
        /// that the recommended resource is predicted to always provide enough hardware capability.
        /// The higher the performance risk is, the more likely you should validate whether the
        /// recommendation will meet the performance requirements of your workload before migrating
        /// your resource.</p>
        pub fn set_performance_risk(mut self, input: std::option::Option<f64>) -> Self {
            self.performance_risk = input;
            self
        }
        /// <p>The rank of the Auto Scaling group recommendation option.</p>
        ///
        /// <p>The top recommendation option is ranked as <code>1</code>.</p>
        pub fn rank(mut self, input: i32) -> Self {
            self.rank = Some(input);
            self
        }
        /// <p>The rank of the Auto Scaling group recommendation option.</p>
        ///
        /// <p>The top recommendation option is ranked as <code>1</code>.</p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.rank = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingGroupRecommendationOption`](crate::model::AutoScalingGroupRecommendationOption)
        pub fn build(self) -> crate::model::AutoScalingGroupRecommendationOption {
            crate::model::AutoScalingGroupRecommendationOption {
                configuration: self.configuration,
                projected_utilization_metrics: self.projected_utilization_metrics,
                performance_risk: self.performance_risk.unwrap_or_default(),
                rank: self.rank.unwrap_or_default(),
            }
        }
    }
}
impl AutoScalingGroupRecommendationOption {
    /// Creates a new builder-style object to manufacture [`AutoScalingGroupRecommendationOption`](crate::model::AutoScalingGroupRecommendationOption)
    pub fn builder() -> crate::model::auto_scaling_group_recommendation_option::Builder {
        crate::model::auto_scaling_group_recommendation_option::Builder::default()
    }
}

/// <p>Describes the configuration of an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingGroupConfiguration {
    /// <p>The desired capacity, or number of instances, for the Auto Scaling group.</p>
    pub desired_capacity: i32,
    /// <p>The minimum size, or minimum number of instances, for the Auto Scaling
    /// group.</p>
    pub min_size: i32,
    /// <p>The maximum size, or maximum number of instances, for the Auto Scaling
    /// group.</p>
    pub max_size: i32,
    /// <p>The instance type for the Auto Scaling group.</p>
    pub instance_type: std::option::Option<std::string::String>,
}
impl AutoScalingGroupConfiguration {
    /// <p>The desired capacity, or number of instances, for the Auto Scaling group.</p>
    pub fn desired_capacity(&self) -> i32 {
        self.desired_capacity
    }
    /// <p>The minimum size, or minimum number of instances, for the Auto Scaling
    /// group.</p>
    pub fn min_size(&self) -> i32 {
        self.min_size
    }
    /// <p>The maximum size, or maximum number of instances, for the Auto Scaling
    /// group.</p>
    pub fn max_size(&self) -> i32 {
        self.max_size
    }
    /// <p>The instance type for the Auto Scaling group.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
}
impl std::fmt::Debug for AutoScalingGroupConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingGroupConfiguration");
        formatter.field("desired_capacity", &self.desired_capacity);
        formatter.field("min_size", &self.min_size);
        formatter.field("max_size", &self.max_size);
        formatter.field("instance_type", &self.instance_type);
        formatter.finish()
    }
}
/// See [`AutoScalingGroupConfiguration`](crate::model::AutoScalingGroupConfiguration)
pub mod auto_scaling_group_configuration {
    /// A builder for [`AutoScalingGroupConfiguration`](crate::model::AutoScalingGroupConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) desired_capacity: std::option::Option<i32>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) max_size: std::option::Option<i32>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The desired capacity, or number of instances, for the Auto Scaling group.</p>
        pub fn desired_capacity(mut self, input: i32) -> Self {
            self.desired_capacity = Some(input);
            self
        }
        /// <p>The desired capacity, or number of instances, for the Auto Scaling group.</p>
        pub fn set_desired_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_capacity = input;
            self
        }
        /// <p>The minimum size, or minimum number of instances, for the Auto Scaling
        /// group.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum size, or minimum number of instances, for the Auto Scaling
        /// group.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The maximum size, or maximum number of instances, for the Auto Scaling
        /// group.</p>
        pub fn max_size(mut self, input: i32) -> Self {
            self.max_size = Some(input);
            self
        }
        /// <p>The maximum size, or maximum number of instances, for the Auto Scaling
        /// group.</p>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>The instance type for the Auto Scaling group.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type for the Auto Scaling group.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingGroupConfiguration`](crate::model::AutoScalingGroupConfiguration)
        pub fn build(self) -> crate::model::AutoScalingGroupConfiguration {
            crate::model::AutoScalingGroupConfiguration {
                desired_capacity: self.desired_capacity.unwrap_or_default(),
                min_size: self.min_size.unwrap_or_default(),
                max_size: self.max_size.unwrap_or_default(),
                instance_type: self.instance_type,
            }
        }
    }
}
impl AutoScalingGroupConfiguration {
    /// Creates a new builder-style object to manufacture [`AutoScalingGroupConfiguration`](crate::model::AutoScalingGroupConfiguration)
    pub fn builder() -> crate::model::auto_scaling_group_configuration::Builder {
        crate::model::auto_scaling_group_configuration::Builder::default()
    }
}

/// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
/// object keys of a recommendations export file, and its associated metadata file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Destination {
    /// <p>The name of the Amazon S3 bucket used as the destination of an export
    /// file.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket key of an export file.</p>
    ///
    /// <p>The key uniquely identifies the object, or export file, in the S3 bucket.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket key of a metadata file.</p>
    ///
    /// <p>The key uniquely identifies the object, or metadata file, in the S3 bucket.</p>
    pub metadata_key: std::option::Option<std::string::String>,
}
impl S3Destination {
    /// <p>The name of the Amazon S3 bucket used as the destination of an export
    /// file.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The Amazon S3 bucket key of an export file.</p>
    ///
    /// <p>The key uniquely identifies the object, or export file, in the S3 bucket.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The Amazon S3 bucket key of a metadata file.</p>
    ///
    /// <p>The key uniquely identifies the object, or metadata file, in the S3 bucket.</p>
    pub fn metadata_key(&self) -> std::option::Option<&str> {
        self.metadata_key.as_deref()
    }
}
impl std::fmt::Debug for S3Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Destination");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("metadata_key", &self.metadata_key);
        formatter.finish()
    }
}
/// See [`S3Destination`](crate::model::S3Destination)
pub mod s3_destination {
    /// A builder for [`S3Destination`](crate::model::S3Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) metadata_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket used as the destination of an export
        /// file.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket used as the destination of an export
        /// file.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The Amazon S3 bucket key of an export file.</p>
        ///
        /// <p>The key uniquely identifies the object, or export file, in the S3 bucket.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket key of an export file.</p>
        ///
        /// <p>The key uniquely identifies the object, or export file, in the S3 bucket.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The Amazon S3 bucket key of a metadata file.</p>
        ///
        /// <p>The key uniquely identifies the object, or metadata file, in the S3 bucket.</p>
        pub fn metadata_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata_key = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket key of a metadata file.</p>
        ///
        /// <p>The key uniquely identifies the object, or metadata file, in the S3 bucket.</p>
        pub fn set_metadata_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata_key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Destination`](crate::model::S3Destination)
        pub fn build(self) -> crate::model::S3Destination {
            crate::model::S3Destination {
                bucket: self.bucket,
                key: self.key,
                metadata_key: self.metadata_key,
            }
        }
    }
}
impl S3Destination {
    /// Creates a new builder-style object to manufacture [`S3Destination`](crate::model::S3Destination)
    pub fn builder() -> crate::model::s3_destination::Builder {
        crate::model::s3_destination::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileFormat {
    fn from(s: &str) -> Self {
        match s {
            "Csv" => FileFormat::Csv,
            other => FileFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileFormat::from(s))
    }
}
impl FileFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileFormat::Csv => "Csv",
            FileFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Csv"]
    }
}
impl AsRef<str> for FileFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
/// key prefix for a recommendations export job.</p>
///
/// <p>You must create the destination Amazon S3 bucket for your recommendations
/// export before you create the export job. Compute Optimizer does not create the S3 bucket
/// for you. After you create the S3 bucket, ensure that it has the required permission
/// policy to allow Compute Optimizer to write the export file to it. If you plan to specify
/// an object prefix when you create the export job, you must include the object prefix in
/// the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
/// <i>Compute Optimizer User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3DestinationConfig {
    /// <p>The name of the Amazon S3 bucket to use as the destination for an export
    /// job.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket prefix for an export job.</p>
    pub key_prefix: std::option::Option<std::string::String>,
}
impl S3DestinationConfig {
    /// <p>The name of the Amazon S3 bucket to use as the destination for an export
    /// job.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The Amazon S3 bucket prefix for an export job.</p>
    pub fn key_prefix(&self) -> std::option::Option<&str> {
        self.key_prefix.as_deref()
    }
}
impl std::fmt::Debug for S3DestinationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3DestinationConfig");
        formatter.field("bucket", &self.bucket);
        formatter.field("key_prefix", &self.key_prefix);
        formatter.finish()
    }
}
/// See [`S3DestinationConfig`](crate::model::S3DestinationConfig)
pub mod s3_destination_config {
    /// A builder for [`S3DestinationConfig`](crate::model::S3DestinationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket to use as the destination for an export
        /// job.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket to use as the destination for an export
        /// job.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The Amazon S3 bucket prefix for an export job.</p>
        pub fn key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket prefix for an export job.</p>
        pub fn set_key_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3DestinationConfig`](crate::model::S3DestinationConfig)
        pub fn build(self) -> crate::model::S3DestinationConfig {
            crate::model::S3DestinationConfig {
                bucket: self.bucket,
                key_prefix: self.key_prefix,
            }
        }
    }
}
impl S3DestinationConfig {
    /// Creates a new builder-style object to manufacture [`S3DestinationConfig`](crate::model::S3DestinationConfig)
    pub fn builder() -> crate::model::s3_destination_config::Builder {
        crate::model::s3_destination_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportableLambdaFunctionField {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationMemorySize,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationTimeout,
    #[allow(missing_docs)] // documentation missing in model
    CurrentCostAverage,
    #[allow(missing_docs)] // documentation missing in model
    CurrentCostTotal,
    #[allow(missing_docs)] // documentation missing in model
    Finding,
    #[allow(missing_docs)] // documentation missing in model
    FindingReasonCodes,
    #[allow(missing_docs)] // documentation missing in model
    FunctionArn,
    #[allow(missing_docs)] // documentation missing in model
    FunctionVersion,
    #[allow(missing_docs)] // documentation missing in model
    LastRefreshTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    LookbackPeriodInDays,
    #[allow(missing_docs)] // documentation missing in model
    NumberOfInvocations,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsConfigurationMemorySize,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsCostHigh,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsCostLow,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsProjectedUtilizationMetricsDurationExpected,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsProjectedUtilizationMetricsDurationLowerBound,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsProjectedUtilizationMetricsDurationUpperBound,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsDurationAverage,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsDurationMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsMemoryAverage,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsMemoryMaximum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportableLambdaFunctionField {
    fn from(s: &str) -> Self {
        match s {
            "AccountId" => ExportableLambdaFunctionField::AccountId,
            "CurrentConfigurationMemorySize" => ExportableLambdaFunctionField::CurrentConfigurationMemorySize,
            "CurrentConfigurationTimeout" => ExportableLambdaFunctionField::CurrentConfigurationTimeout,
            "CurrentCostAverage" => ExportableLambdaFunctionField::CurrentCostAverage,
            "CurrentCostTotal" => ExportableLambdaFunctionField::CurrentCostTotal,
            "Finding" => ExportableLambdaFunctionField::Finding,
            "FindingReasonCodes" => ExportableLambdaFunctionField::FindingReasonCodes,
            "FunctionArn" => ExportableLambdaFunctionField::FunctionArn,
            "FunctionVersion" => ExportableLambdaFunctionField::FunctionVersion,
            "LastRefreshTimestamp" => ExportableLambdaFunctionField::LastRefreshTimestamp,
            "LookbackPeriodInDays" => ExportableLambdaFunctionField::LookbackPeriodInDays,
            "NumberOfInvocations" => ExportableLambdaFunctionField::NumberOfInvocations,
            "RecommendationOptionsConfigurationMemorySize" => ExportableLambdaFunctionField::RecommendationOptionsConfigurationMemorySize,
            "RecommendationOptionsCostHigh" => ExportableLambdaFunctionField::RecommendationOptionsCostHigh,
            "RecommendationOptionsCostLow" => ExportableLambdaFunctionField::RecommendationOptionsCostLow,
            "RecommendationOptionsProjectedUtilizationMetricsDurationExpected" => ExportableLambdaFunctionField::RecommendationOptionsProjectedUtilizationMetricsDurationExpected,
            "RecommendationOptionsProjectedUtilizationMetricsDurationLowerBound" => ExportableLambdaFunctionField::RecommendationOptionsProjectedUtilizationMetricsDurationLowerBound,
            "RecommendationOptionsProjectedUtilizationMetricsDurationUpperBound" => ExportableLambdaFunctionField::RecommendationOptionsProjectedUtilizationMetricsDurationUpperBound,
            "UtilizationMetricsDurationAverage" => ExportableLambdaFunctionField::UtilizationMetricsDurationAverage,
            "UtilizationMetricsDurationMaximum" => ExportableLambdaFunctionField::UtilizationMetricsDurationMaximum,
            "UtilizationMetricsMemoryAverage" => ExportableLambdaFunctionField::UtilizationMetricsMemoryAverage,
            "UtilizationMetricsMemoryMaximum" => ExportableLambdaFunctionField::UtilizationMetricsMemoryMaximum,
            other => ExportableLambdaFunctionField::Unknown(other.to_owned())
        }
    }
}
impl std::str::FromStr for ExportableLambdaFunctionField {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportableLambdaFunctionField::from(s))
    }
}
impl ExportableLambdaFunctionField {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportableLambdaFunctionField::AccountId => "AccountId",
            ExportableLambdaFunctionField::CurrentConfigurationMemorySize => "CurrentConfigurationMemorySize",
            ExportableLambdaFunctionField::CurrentConfigurationTimeout => "CurrentConfigurationTimeout",
            ExportableLambdaFunctionField::CurrentCostAverage => "CurrentCostAverage",
            ExportableLambdaFunctionField::CurrentCostTotal => "CurrentCostTotal",
            ExportableLambdaFunctionField::Finding => "Finding",
            ExportableLambdaFunctionField::FindingReasonCodes => "FindingReasonCodes",
            ExportableLambdaFunctionField::FunctionArn => "FunctionArn",
            ExportableLambdaFunctionField::FunctionVersion => "FunctionVersion",
            ExportableLambdaFunctionField::LastRefreshTimestamp => "LastRefreshTimestamp",
            ExportableLambdaFunctionField::LookbackPeriodInDays => "LookbackPeriodInDays",
            ExportableLambdaFunctionField::NumberOfInvocations => "NumberOfInvocations",
            ExportableLambdaFunctionField::RecommendationOptionsConfigurationMemorySize => "RecommendationOptionsConfigurationMemorySize",
            ExportableLambdaFunctionField::RecommendationOptionsCostHigh => "RecommendationOptionsCostHigh",
            ExportableLambdaFunctionField::RecommendationOptionsCostLow => "RecommendationOptionsCostLow",
            ExportableLambdaFunctionField::RecommendationOptionsProjectedUtilizationMetricsDurationExpected => "RecommendationOptionsProjectedUtilizationMetricsDurationExpected",
            ExportableLambdaFunctionField::RecommendationOptionsProjectedUtilizationMetricsDurationLowerBound => "RecommendationOptionsProjectedUtilizationMetricsDurationLowerBound",
            ExportableLambdaFunctionField::RecommendationOptionsProjectedUtilizationMetricsDurationUpperBound => "RecommendationOptionsProjectedUtilizationMetricsDurationUpperBound",
            ExportableLambdaFunctionField::UtilizationMetricsDurationAverage => "UtilizationMetricsDurationAverage",
            ExportableLambdaFunctionField::UtilizationMetricsDurationMaximum => "UtilizationMetricsDurationMaximum",
            ExportableLambdaFunctionField::UtilizationMetricsMemoryAverage => "UtilizationMetricsMemoryAverage",
            ExportableLambdaFunctionField::UtilizationMetricsMemoryMaximum => "UtilizationMetricsMemoryMaximum",
            ExportableLambdaFunctionField::Unknown(s) => s.as_ref()
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccountId",
            "CurrentConfigurationMemorySize",
            "CurrentConfigurationTimeout",
            "CurrentCostAverage",
            "CurrentCostTotal",
            "Finding",
            "FindingReasonCodes",
            "FunctionArn",
            "FunctionVersion",
            "LastRefreshTimestamp",
            "LookbackPeriodInDays",
            "NumberOfInvocations",
            "RecommendationOptionsConfigurationMemorySize",
            "RecommendationOptionsCostHigh",
            "RecommendationOptionsCostLow",
            "RecommendationOptionsProjectedUtilizationMetricsDurationExpected",
            "RecommendationOptionsProjectedUtilizationMetricsDurationLowerBound",
            "RecommendationOptionsProjectedUtilizationMetricsDurationUpperBound",
            "UtilizationMetricsDurationAverage",
            "UtilizationMetricsDurationMaximum",
            "UtilizationMetricsMemoryAverage",
            "UtilizationMetricsMemoryMaximum",
        ]
    }
}
impl AsRef<str> for ExportableLambdaFunctionField {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportableInstanceField {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    CurrentInstanceType,
    #[allow(missing_docs)] // documentation missing in model
    CurrentMemory,
    #[allow(missing_docs)] // documentation missing in model
    CurrentNetwork,
    #[allow(missing_docs)] // documentation missing in model
    CurrentOnDemandPrice,
    #[allow(missing_docs)] // documentation missing in model
    CurrentStandardOneYearNoUpfrontReservedPrice,
    #[allow(missing_docs)] // documentation missing in model
    CurrentStandardThreeYearNoUpfrontReservedPrice,
    #[allow(missing_docs)] // documentation missing in model
    CurrentStorage,
    #[allow(missing_docs)] // documentation missing in model
    CurrentVcpus,
    #[allow(missing_docs)] // documentation missing in model
    Finding,
    #[allow(missing_docs)] // documentation missing in model
    FindingReasonCodes,
    #[allow(missing_docs)] // documentation missing in model
    InstanceArn,
    #[allow(missing_docs)] // documentation missing in model
    InstanceName,
    #[allow(missing_docs)] // documentation missing in model
    LastRefreshTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    LookbackPeriodInDays,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsInstanceType,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsMemory,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsNetwork,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsOnDemandPrice,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsPerformanceRisk,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsPlatformDifferences,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsProjectedUtilizationMetricsCpuMaximum,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsStandardOneYearNoUpfrontReservedPrice,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsStorage,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsVcpus,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationsSourcesRecommendationSourceArn,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationsSourcesRecommendationSourceType,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsCpuMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsDiskReadBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsDiskReadOpsPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsDiskWriteBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsDiskWriteOpsPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsEbsReadBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsEbsReadOpsPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsEbsWriteBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsEbsWriteOpsPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsMemoryMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsNetworkInBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsNetworkOutBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsNetworkPacketsInPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsNetworkPacketsOutPerSecondMaximum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportableInstanceField {
    fn from(s: &str) -> Self {
        match s {
            "AccountId" => ExportableInstanceField::AccountId,
            "CurrentInstanceType" => ExportableInstanceField::CurrentInstanceType,
            "CurrentMemory" => ExportableInstanceField::CurrentMemory,
            "CurrentNetwork" => ExportableInstanceField::CurrentNetwork,
            "CurrentOnDemandPrice" => ExportableInstanceField::CurrentOnDemandPrice,
            "CurrentStandardOneYearNoUpfrontReservedPrice" => ExportableInstanceField::CurrentStandardOneYearNoUpfrontReservedPrice,
            "CurrentStandardThreeYearNoUpfrontReservedPrice" => ExportableInstanceField::CurrentStandardThreeYearNoUpfrontReservedPrice,
            "CurrentStorage" => ExportableInstanceField::CurrentStorage,
            "CurrentVCpus" => ExportableInstanceField::CurrentVcpus,
            "Finding" => ExportableInstanceField::Finding,
            "FindingReasonCodes" => ExportableInstanceField::FindingReasonCodes,
            "InstanceArn" => ExportableInstanceField::InstanceArn,
            "InstanceName" => ExportableInstanceField::InstanceName,
            "LastRefreshTimestamp" => ExportableInstanceField::LastRefreshTimestamp,
            "LookbackPeriodInDays" => ExportableInstanceField::LookbackPeriodInDays,
            "RecommendationOptionsInstanceType" => ExportableInstanceField::RecommendationOptionsInstanceType,
            "RecommendationOptionsMemory" => ExportableInstanceField::RecommendationOptionsMemory,
            "RecommendationOptionsNetwork" => ExportableInstanceField::RecommendationOptionsNetwork,
            "RecommendationOptionsOnDemandPrice" => ExportableInstanceField::RecommendationOptionsOnDemandPrice,
            "RecommendationOptionsPerformanceRisk" => ExportableInstanceField::RecommendationOptionsPerformanceRisk,
            "RecommendationOptionsPlatformDifferences" => ExportableInstanceField::RecommendationOptionsPlatformDifferences,
            "RecommendationOptionsProjectedUtilizationMetricsCpuMaximum" => ExportableInstanceField::RecommendationOptionsProjectedUtilizationMetricsCpuMaximum,
            "RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum" => ExportableInstanceField::RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum,
            "RecommendationOptionsStandardOneYearNoUpfrontReservedPrice" => ExportableInstanceField::RecommendationOptionsStandardOneYearNoUpfrontReservedPrice,
            "RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice" => ExportableInstanceField::RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice,
            "RecommendationOptionsStorage" => ExportableInstanceField::RecommendationOptionsStorage,
            "RecommendationOptionsVcpus" => ExportableInstanceField::RecommendationOptionsVcpus,
            "RecommendationsSourcesRecommendationSourceArn" => ExportableInstanceField::RecommendationsSourcesRecommendationSourceArn,
            "RecommendationsSourcesRecommendationSourceType" => ExportableInstanceField::RecommendationsSourcesRecommendationSourceType,
            "UtilizationMetricsCpuMaximum" => ExportableInstanceField::UtilizationMetricsCpuMaximum,
            "UtilizationMetricsDiskReadBytesPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsDiskReadBytesPerSecondMaximum,
            "UtilizationMetricsDiskReadOpsPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsDiskReadOpsPerSecondMaximum,
            "UtilizationMetricsDiskWriteBytesPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsDiskWriteBytesPerSecondMaximum,
            "UtilizationMetricsDiskWriteOpsPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsDiskWriteOpsPerSecondMaximum,
            "UtilizationMetricsEbsReadBytesPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsEbsReadBytesPerSecondMaximum,
            "UtilizationMetricsEbsReadOpsPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsEbsReadOpsPerSecondMaximum,
            "UtilizationMetricsEbsWriteBytesPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsEbsWriteBytesPerSecondMaximum,
            "UtilizationMetricsEbsWriteOpsPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsEbsWriteOpsPerSecondMaximum,
            "UtilizationMetricsMemoryMaximum" => ExportableInstanceField::UtilizationMetricsMemoryMaximum,
            "UtilizationMetricsNetworkInBytesPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsNetworkInBytesPerSecondMaximum,
            "UtilizationMetricsNetworkOutBytesPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsNetworkOutBytesPerSecondMaximum,
            "UtilizationMetricsNetworkPacketsInPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsNetworkPacketsInPerSecondMaximum,
            "UtilizationMetricsNetworkPacketsOutPerSecondMaximum" => ExportableInstanceField::UtilizationMetricsNetworkPacketsOutPerSecondMaximum,
            other => ExportableInstanceField::Unknown(other.to_owned())
        }
    }
}
impl std::str::FromStr for ExportableInstanceField {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportableInstanceField::from(s))
    }
}
impl ExportableInstanceField {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportableInstanceField::AccountId => "AccountId",
            ExportableInstanceField::CurrentInstanceType => "CurrentInstanceType",
            ExportableInstanceField::CurrentMemory => "CurrentMemory",
            ExportableInstanceField::CurrentNetwork => "CurrentNetwork",
            ExportableInstanceField::CurrentOnDemandPrice => "CurrentOnDemandPrice",
            ExportableInstanceField::CurrentStandardOneYearNoUpfrontReservedPrice => "CurrentStandardOneYearNoUpfrontReservedPrice",
            ExportableInstanceField::CurrentStandardThreeYearNoUpfrontReservedPrice => "CurrentStandardThreeYearNoUpfrontReservedPrice",
            ExportableInstanceField::CurrentStorage => "CurrentStorage",
            ExportableInstanceField::CurrentVcpus => "CurrentVCpus",
            ExportableInstanceField::Finding => "Finding",
            ExportableInstanceField::FindingReasonCodes => "FindingReasonCodes",
            ExportableInstanceField::InstanceArn => "InstanceArn",
            ExportableInstanceField::InstanceName => "InstanceName",
            ExportableInstanceField::LastRefreshTimestamp => "LastRefreshTimestamp",
            ExportableInstanceField::LookbackPeriodInDays => "LookbackPeriodInDays",
            ExportableInstanceField::RecommendationOptionsInstanceType => "RecommendationOptionsInstanceType",
            ExportableInstanceField::RecommendationOptionsMemory => "RecommendationOptionsMemory",
            ExportableInstanceField::RecommendationOptionsNetwork => "RecommendationOptionsNetwork",
            ExportableInstanceField::RecommendationOptionsOnDemandPrice => "RecommendationOptionsOnDemandPrice",
            ExportableInstanceField::RecommendationOptionsPerformanceRisk => "RecommendationOptionsPerformanceRisk",
            ExportableInstanceField::RecommendationOptionsPlatformDifferences => "RecommendationOptionsPlatformDifferences",
            ExportableInstanceField::RecommendationOptionsProjectedUtilizationMetricsCpuMaximum => "RecommendationOptionsProjectedUtilizationMetricsCpuMaximum",
            ExportableInstanceField::RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum => "RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum",
            ExportableInstanceField::RecommendationOptionsStandardOneYearNoUpfrontReservedPrice => "RecommendationOptionsStandardOneYearNoUpfrontReservedPrice",
            ExportableInstanceField::RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice => "RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice",
            ExportableInstanceField::RecommendationOptionsStorage => "RecommendationOptionsStorage",
            ExportableInstanceField::RecommendationOptionsVcpus => "RecommendationOptionsVcpus",
            ExportableInstanceField::RecommendationsSourcesRecommendationSourceArn => "RecommendationsSourcesRecommendationSourceArn",
            ExportableInstanceField::RecommendationsSourcesRecommendationSourceType => "RecommendationsSourcesRecommendationSourceType",
            ExportableInstanceField::UtilizationMetricsCpuMaximum => "UtilizationMetricsCpuMaximum",
            ExportableInstanceField::UtilizationMetricsDiskReadBytesPerSecondMaximum => "UtilizationMetricsDiskReadBytesPerSecondMaximum",
            ExportableInstanceField::UtilizationMetricsDiskReadOpsPerSecondMaximum => "UtilizationMetricsDiskReadOpsPerSecondMaximum",
            ExportableInstanceField::UtilizationMetricsDiskWriteBytesPerSecondMaximum => "UtilizationMetricsDiskWriteBytesPerSecondMaximum",
            ExportableInstanceField::UtilizationMetricsDiskWriteOpsPerSecondMaximum => "UtilizationMetricsDiskWriteOpsPerSecondMaximum",
            ExportableInstanceField::UtilizationMetricsEbsReadBytesPerSecondMaximum => "UtilizationMetricsEbsReadBytesPerSecondMaximum",
            ExportableInstanceField::UtilizationMetricsEbsReadOpsPerSecondMaximum => "UtilizationMetricsEbsReadOpsPerSecondMaximum",
            ExportableInstanceField::UtilizationMetricsEbsWriteBytesPerSecondMaximum => "UtilizationMetricsEbsWriteBytesPerSecondMaximum",
            ExportableInstanceField::UtilizationMetricsEbsWriteOpsPerSecondMaximum => "UtilizationMetricsEbsWriteOpsPerSecondMaximum",
            ExportableInstanceField::UtilizationMetricsMemoryMaximum => "UtilizationMetricsMemoryMaximum",
            ExportableInstanceField::UtilizationMetricsNetworkInBytesPerSecondMaximum => "UtilizationMetricsNetworkInBytesPerSecondMaximum",
            ExportableInstanceField::UtilizationMetricsNetworkOutBytesPerSecondMaximum => "UtilizationMetricsNetworkOutBytesPerSecondMaximum",
            ExportableInstanceField::UtilizationMetricsNetworkPacketsInPerSecondMaximum => "UtilizationMetricsNetworkPacketsInPerSecondMaximum",
            ExportableInstanceField::UtilizationMetricsNetworkPacketsOutPerSecondMaximum => "UtilizationMetricsNetworkPacketsOutPerSecondMaximum",
            ExportableInstanceField::Unknown(s) => s.as_ref()
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccountId",
            "CurrentInstanceType",
            "CurrentMemory",
            "CurrentNetwork",
            "CurrentOnDemandPrice",
            "CurrentStandardOneYearNoUpfrontReservedPrice",
            "CurrentStandardThreeYearNoUpfrontReservedPrice",
            "CurrentStorage",
            "CurrentVCpus",
            "Finding",
            "FindingReasonCodes",
            "InstanceArn",
            "InstanceName",
            "LastRefreshTimestamp",
            "LookbackPeriodInDays",
            "RecommendationOptionsInstanceType",
            "RecommendationOptionsMemory",
            "RecommendationOptionsNetwork",
            "RecommendationOptionsOnDemandPrice",
            "RecommendationOptionsPerformanceRisk",
            "RecommendationOptionsPlatformDifferences",
            "RecommendationOptionsProjectedUtilizationMetricsCpuMaximum",
            "RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum",
            "RecommendationOptionsStandardOneYearNoUpfrontReservedPrice",
            "RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice",
            "RecommendationOptionsStorage",
            "RecommendationOptionsVcpus",
            "RecommendationsSourcesRecommendationSourceArn",
            "RecommendationsSourcesRecommendationSourceType",
            "UtilizationMetricsCpuMaximum",
            "UtilizationMetricsDiskReadBytesPerSecondMaximum",
            "UtilizationMetricsDiskReadOpsPerSecondMaximum",
            "UtilizationMetricsDiskWriteBytesPerSecondMaximum",
            "UtilizationMetricsDiskWriteOpsPerSecondMaximum",
            "UtilizationMetricsEbsReadBytesPerSecondMaximum",
            "UtilizationMetricsEbsReadOpsPerSecondMaximum",
            "UtilizationMetricsEbsWriteBytesPerSecondMaximum",
            "UtilizationMetricsEbsWriteOpsPerSecondMaximum",
            "UtilizationMetricsMemoryMaximum",
            "UtilizationMetricsNetworkInBytesPerSecondMaximum",
            "UtilizationMetricsNetworkOutBytesPerSecondMaximum",
            "UtilizationMetricsNetworkPacketsInPerSecondMaximum",
            "UtilizationMetricsNetworkPacketsOutPerSecondMaximum",
        ]
    }
}
impl AsRef<str> for ExportableInstanceField {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportableVolumeField {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationVolumeBaselineIops,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationVolumeBaselineThroughput,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationVolumeBurstIops,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationVolumeBurstThroughput,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationVolumeSize,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationVolumeType,
    #[allow(missing_docs)] // documentation missing in model
    CurrentMonthlyPrice,
    #[allow(missing_docs)] // documentation missing in model
    Finding,
    #[allow(missing_docs)] // documentation missing in model
    LastRefreshTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    LookbackPeriodInDays,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsConfigurationVolumeBaselineIops,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsConfigurationVolumeBaselineThroughput,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsConfigurationVolumeBurstIops,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsConfigurationVolumeBurstThroughput,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsConfigurationVolumeSize,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsConfigurationVolumeType,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsMonthlyPrice,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsPerformanceRisk,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsVolumeReadBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsVolumeReadOpsPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsVolumeWriteBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsVolumeWriteOpsPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    VolumeArn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportableVolumeField {
    fn from(s: &str) -> Self {
        match s {
            "AccountId" => ExportableVolumeField::AccountId,
            "CurrentConfigurationVolumeBaselineIOPS" => {
                ExportableVolumeField::CurrentConfigurationVolumeBaselineIops
            }
            "CurrentConfigurationVolumeBaselineThroughput" => {
                ExportableVolumeField::CurrentConfigurationVolumeBaselineThroughput
            }
            "CurrentConfigurationVolumeBurstIOPS" => {
                ExportableVolumeField::CurrentConfigurationVolumeBurstIops
            }
            "CurrentConfigurationVolumeBurstThroughput" => {
                ExportableVolumeField::CurrentConfigurationVolumeBurstThroughput
            }
            "CurrentConfigurationVolumeSize" => {
                ExportableVolumeField::CurrentConfigurationVolumeSize
            }
            "CurrentConfigurationVolumeType" => {
                ExportableVolumeField::CurrentConfigurationVolumeType
            }
            "CurrentMonthlyPrice" => ExportableVolumeField::CurrentMonthlyPrice,
            "Finding" => ExportableVolumeField::Finding,
            "LastRefreshTimestamp" => ExportableVolumeField::LastRefreshTimestamp,
            "LookbackPeriodInDays" => ExportableVolumeField::LookbackPeriodInDays,
            "RecommendationOptionsConfigurationVolumeBaselineIOPS" => {
                ExportableVolumeField::RecommendationOptionsConfigurationVolumeBaselineIops
            }
            "RecommendationOptionsConfigurationVolumeBaselineThroughput" => {
                ExportableVolumeField::RecommendationOptionsConfigurationVolumeBaselineThroughput
            }
            "RecommendationOptionsConfigurationVolumeBurstIOPS" => {
                ExportableVolumeField::RecommendationOptionsConfigurationVolumeBurstIops
            }
            "RecommendationOptionsConfigurationVolumeBurstThroughput" => {
                ExportableVolumeField::RecommendationOptionsConfigurationVolumeBurstThroughput
            }
            "RecommendationOptionsConfigurationVolumeSize" => {
                ExportableVolumeField::RecommendationOptionsConfigurationVolumeSize
            }
            "RecommendationOptionsConfigurationVolumeType" => {
                ExportableVolumeField::RecommendationOptionsConfigurationVolumeType
            }
            "RecommendationOptionsMonthlyPrice" => {
                ExportableVolumeField::RecommendationOptionsMonthlyPrice
            }
            "RecommendationOptionsPerformanceRisk" => {
                ExportableVolumeField::RecommendationOptionsPerformanceRisk
            }
            "UtilizationMetricsVolumeReadBytesPerSecondMaximum" => {
                ExportableVolumeField::UtilizationMetricsVolumeReadBytesPerSecondMaximum
            }
            "UtilizationMetricsVolumeReadOpsPerSecondMaximum" => {
                ExportableVolumeField::UtilizationMetricsVolumeReadOpsPerSecondMaximum
            }
            "UtilizationMetricsVolumeWriteBytesPerSecondMaximum" => {
                ExportableVolumeField::UtilizationMetricsVolumeWriteBytesPerSecondMaximum
            }
            "UtilizationMetricsVolumeWriteOpsPerSecondMaximum" => {
                ExportableVolumeField::UtilizationMetricsVolumeWriteOpsPerSecondMaximum
            }
            "VolumeArn" => ExportableVolumeField::VolumeArn,
            other => ExportableVolumeField::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportableVolumeField {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportableVolumeField::from(s))
    }
}
impl ExportableVolumeField {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportableVolumeField::AccountId => "AccountId",
            ExportableVolumeField::CurrentConfigurationVolumeBaselineIops => {
                "CurrentConfigurationVolumeBaselineIOPS"
            }
            ExportableVolumeField::CurrentConfigurationVolumeBaselineThroughput => {
                "CurrentConfigurationVolumeBaselineThroughput"
            }
            ExportableVolumeField::CurrentConfigurationVolumeBurstIops => {
                "CurrentConfigurationVolumeBurstIOPS"
            }
            ExportableVolumeField::CurrentConfigurationVolumeBurstThroughput => {
                "CurrentConfigurationVolumeBurstThroughput"
            }
            ExportableVolumeField::CurrentConfigurationVolumeSize => {
                "CurrentConfigurationVolumeSize"
            }
            ExportableVolumeField::CurrentConfigurationVolumeType => {
                "CurrentConfigurationVolumeType"
            }
            ExportableVolumeField::CurrentMonthlyPrice => "CurrentMonthlyPrice",
            ExportableVolumeField::Finding => "Finding",
            ExportableVolumeField::LastRefreshTimestamp => "LastRefreshTimestamp",
            ExportableVolumeField::LookbackPeriodInDays => "LookbackPeriodInDays",
            ExportableVolumeField::RecommendationOptionsConfigurationVolumeBaselineIops => {
                "RecommendationOptionsConfigurationVolumeBaselineIOPS"
            }
            ExportableVolumeField::RecommendationOptionsConfigurationVolumeBaselineThroughput => {
                "RecommendationOptionsConfigurationVolumeBaselineThroughput"
            }
            ExportableVolumeField::RecommendationOptionsConfigurationVolumeBurstIops => {
                "RecommendationOptionsConfigurationVolumeBurstIOPS"
            }
            ExportableVolumeField::RecommendationOptionsConfigurationVolumeBurstThroughput => {
                "RecommendationOptionsConfigurationVolumeBurstThroughput"
            }
            ExportableVolumeField::RecommendationOptionsConfigurationVolumeSize => {
                "RecommendationOptionsConfigurationVolumeSize"
            }
            ExportableVolumeField::RecommendationOptionsConfigurationVolumeType => {
                "RecommendationOptionsConfigurationVolumeType"
            }
            ExportableVolumeField::RecommendationOptionsMonthlyPrice => {
                "RecommendationOptionsMonthlyPrice"
            }
            ExportableVolumeField::RecommendationOptionsPerformanceRisk => {
                "RecommendationOptionsPerformanceRisk"
            }
            ExportableVolumeField::UtilizationMetricsVolumeReadBytesPerSecondMaximum => {
                "UtilizationMetricsVolumeReadBytesPerSecondMaximum"
            }
            ExportableVolumeField::UtilizationMetricsVolumeReadOpsPerSecondMaximum => {
                "UtilizationMetricsVolumeReadOpsPerSecondMaximum"
            }
            ExportableVolumeField::UtilizationMetricsVolumeWriteBytesPerSecondMaximum => {
                "UtilizationMetricsVolumeWriteBytesPerSecondMaximum"
            }
            ExportableVolumeField::UtilizationMetricsVolumeWriteOpsPerSecondMaximum => {
                "UtilizationMetricsVolumeWriteOpsPerSecondMaximum"
            }
            ExportableVolumeField::VolumeArn => "VolumeArn",
            ExportableVolumeField::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccountId",
            "CurrentConfigurationVolumeBaselineIOPS",
            "CurrentConfigurationVolumeBaselineThroughput",
            "CurrentConfigurationVolumeBurstIOPS",
            "CurrentConfigurationVolumeBurstThroughput",
            "CurrentConfigurationVolumeSize",
            "CurrentConfigurationVolumeType",
            "CurrentMonthlyPrice",
            "Finding",
            "LastRefreshTimestamp",
            "LookbackPeriodInDays",
            "RecommendationOptionsConfigurationVolumeBaselineIOPS",
            "RecommendationOptionsConfigurationVolumeBaselineThroughput",
            "RecommendationOptionsConfigurationVolumeBurstIOPS",
            "RecommendationOptionsConfigurationVolumeBurstThroughput",
            "RecommendationOptionsConfigurationVolumeSize",
            "RecommendationOptionsConfigurationVolumeType",
            "RecommendationOptionsMonthlyPrice",
            "RecommendationOptionsPerformanceRisk",
            "UtilizationMetricsVolumeReadBytesPerSecondMaximum",
            "UtilizationMetricsVolumeReadOpsPerSecondMaximum",
            "UtilizationMetricsVolumeWriteBytesPerSecondMaximum",
            "UtilizationMetricsVolumeWriteOpsPerSecondMaximum",
            "VolumeArn",
        ]
    }
}
impl AsRef<str> for ExportableVolumeField {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportableAutoScalingGroupField {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingGroupArn,
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingGroupName,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationDesiredCapacity,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationInstanceType,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationMaxSize,
    #[allow(missing_docs)] // documentation missing in model
    CurrentConfigurationMinSize,
    #[allow(missing_docs)] // documentation missing in model
    CurrentMemory,
    #[allow(missing_docs)] // documentation missing in model
    CurrentNetwork,
    #[allow(missing_docs)] // documentation missing in model
    CurrentOnDemandPrice,
    #[allow(missing_docs)] // documentation missing in model
    CurrentStandardOneYearNoUpfrontReservedPrice,
    #[allow(missing_docs)] // documentation missing in model
    CurrentStandardThreeYearNoUpfrontReservedPrice,
    #[allow(missing_docs)] // documentation missing in model
    CurrentStorage,
    #[allow(missing_docs)] // documentation missing in model
    CurrentVcpus,
    #[allow(missing_docs)] // documentation missing in model
    Finding,
    #[allow(missing_docs)] // documentation missing in model
    LastRefreshTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    LookbackPeriodInDays,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsConfigurationDesiredCapacity,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsConfigurationInstanceType,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsConfigurationMaxSize,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsConfigurationMinSize,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsMemory,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsNetwork,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsOnDemandPrice,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsPerformanceRisk,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsProjectedUtilizationMetricsCpuMaximum,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsStandardOneYearNoUpfrontReservedPrice,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsStorage,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationOptionsVcpus,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsCpuMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsDiskReadBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsDiskReadOpsPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsDiskWriteBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsDiskWriteOpsPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsEbsReadBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsEbsReadOpsPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsEbsWriteBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsEbsWriteOpsPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsMemoryMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsNetworkInBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsNetworkOutBytesPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsNetworkPacketsInPerSecondMaximum,
    #[allow(missing_docs)] // documentation missing in model
    UtilizationMetricsNetworkPacketsOutPerSecondMaximum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportableAutoScalingGroupField {
    fn from(s: &str) -> Self {
        match s {
            "AccountId" => ExportableAutoScalingGroupField::AccountId,
            "AutoScalingGroupArn" => ExportableAutoScalingGroupField::AutoScalingGroupArn,
            "AutoScalingGroupName" => ExportableAutoScalingGroupField::AutoScalingGroupName,
            "CurrentConfigurationDesiredCapacity" => ExportableAutoScalingGroupField::CurrentConfigurationDesiredCapacity,
            "CurrentConfigurationInstanceType" => ExportableAutoScalingGroupField::CurrentConfigurationInstanceType,
            "CurrentConfigurationMaxSize" => ExportableAutoScalingGroupField::CurrentConfigurationMaxSize,
            "CurrentConfigurationMinSize" => ExportableAutoScalingGroupField::CurrentConfigurationMinSize,
            "CurrentMemory" => ExportableAutoScalingGroupField::CurrentMemory,
            "CurrentNetwork" => ExportableAutoScalingGroupField::CurrentNetwork,
            "CurrentOnDemandPrice" => ExportableAutoScalingGroupField::CurrentOnDemandPrice,
            "CurrentStandardOneYearNoUpfrontReservedPrice" => ExportableAutoScalingGroupField::CurrentStandardOneYearNoUpfrontReservedPrice,
            "CurrentStandardThreeYearNoUpfrontReservedPrice" => ExportableAutoScalingGroupField::CurrentStandardThreeYearNoUpfrontReservedPrice,
            "CurrentStorage" => ExportableAutoScalingGroupField::CurrentStorage,
            "CurrentVCpus" => ExportableAutoScalingGroupField::CurrentVcpus,
            "Finding" => ExportableAutoScalingGroupField::Finding,
            "LastRefreshTimestamp" => ExportableAutoScalingGroupField::LastRefreshTimestamp,
            "LookbackPeriodInDays" => ExportableAutoScalingGroupField::LookbackPeriodInDays,
            "RecommendationOptionsConfigurationDesiredCapacity" => ExportableAutoScalingGroupField::RecommendationOptionsConfigurationDesiredCapacity,
            "RecommendationOptionsConfigurationInstanceType" => ExportableAutoScalingGroupField::RecommendationOptionsConfigurationInstanceType,
            "RecommendationOptionsConfigurationMaxSize" => ExportableAutoScalingGroupField::RecommendationOptionsConfigurationMaxSize,
            "RecommendationOptionsConfigurationMinSize" => ExportableAutoScalingGroupField::RecommendationOptionsConfigurationMinSize,
            "RecommendationOptionsMemory" => ExportableAutoScalingGroupField::RecommendationOptionsMemory,
            "RecommendationOptionsNetwork" => ExportableAutoScalingGroupField::RecommendationOptionsNetwork,
            "RecommendationOptionsOnDemandPrice" => ExportableAutoScalingGroupField::RecommendationOptionsOnDemandPrice,
            "RecommendationOptionsPerformanceRisk" => ExportableAutoScalingGroupField::RecommendationOptionsPerformanceRisk,
            "RecommendationOptionsProjectedUtilizationMetricsCpuMaximum" => ExportableAutoScalingGroupField::RecommendationOptionsProjectedUtilizationMetricsCpuMaximum,
            "RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum" => ExportableAutoScalingGroupField::RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum,
            "RecommendationOptionsStandardOneYearNoUpfrontReservedPrice" => ExportableAutoScalingGroupField::RecommendationOptionsStandardOneYearNoUpfrontReservedPrice,
            "RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice" => ExportableAutoScalingGroupField::RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice,
            "RecommendationOptionsStorage" => ExportableAutoScalingGroupField::RecommendationOptionsStorage,
            "RecommendationOptionsVcpus" => ExportableAutoScalingGroupField::RecommendationOptionsVcpus,
            "UtilizationMetricsCpuMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsCpuMaximum,
            "UtilizationMetricsDiskReadBytesPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsDiskReadBytesPerSecondMaximum,
            "UtilizationMetricsDiskReadOpsPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsDiskReadOpsPerSecondMaximum,
            "UtilizationMetricsDiskWriteBytesPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsDiskWriteBytesPerSecondMaximum,
            "UtilizationMetricsDiskWriteOpsPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsDiskWriteOpsPerSecondMaximum,
            "UtilizationMetricsEbsReadBytesPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsEbsReadBytesPerSecondMaximum,
            "UtilizationMetricsEbsReadOpsPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsEbsReadOpsPerSecondMaximum,
            "UtilizationMetricsEbsWriteBytesPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsEbsWriteBytesPerSecondMaximum,
            "UtilizationMetricsEbsWriteOpsPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsEbsWriteOpsPerSecondMaximum,
            "UtilizationMetricsMemoryMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsMemoryMaximum,
            "UtilizationMetricsNetworkInBytesPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsNetworkInBytesPerSecondMaximum,
            "UtilizationMetricsNetworkOutBytesPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsNetworkOutBytesPerSecondMaximum,
            "UtilizationMetricsNetworkPacketsInPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsNetworkPacketsInPerSecondMaximum,
            "UtilizationMetricsNetworkPacketsOutPerSecondMaximum" => ExportableAutoScalingGroupField::UtilizationMetricsNetworkPacketsOutPerSecondMaximum,
            other => ExportableAutoScalingGroupField::Unknown(other.to_owned())
        }
    }
}
impl std::str::FromStr for ExportableAutoScalingGroupField {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportableAutoScalingGroupField::from(s))
    }
}
impl ExportableAutoScalingGroupField {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportableAutoScalingGroupField::AccountId => "AccountId",
            ExportableAutoScalingGroupField::AutoScalingGroupArn => "AutoScalingGroupArn",
            ExportableAutoScalingGroupField::AutoScalingGroupName => "AutoScalingGroupName",
            ExportableAutoScalingGroupField::CurrentConfigurationDesiredCapacity => "CurrentConfigurationDesiredCapacity",
            ExportableAutoScalingGroupField::CurrentConfigurationInstanceType => "CurrentConfigurationInstanceType",
            ExportableAutoScalingGroupField::CurrentConfigurationMaxSize => "CurrentConfigurationMaxSize",
            ExportableAutoScalingGroupField::CurrentConfigurationMinSize => "CurrentConfigurationMinSize",
            ExportableAutoScalingGroupField::CurrentMemory => "CurrentMemory",
            ExportableAutoScalingGroupField::CurrentNetwork => "CurrentNetwork",
            ExportableAutoScalingGroupField::CurrentOnDemandPrice => "CurrentOnDemandPrice",
            ExportableAutoScalingGroupField::CurrentStandardOneYearNoUpfrontReservedPrice => "CurrentStandardOneYearNoUpfrontReservedPrice",
            ExportableAutoScalingGroupField::CurrentStandardThreeYearNoUpfrontReservedPrice => "CurrentStandardThreeYearNoUpfrontReservedPrice",
            ExportableAutoScalingGroupField::CurrentStorage => "CurrentStorage",
            ExportableAutoScalingGroupField::CurrentVcpus => "CurrentVCpus",
            ExportableAutoScalingGroupField::Finding => "Finding",
            ExportableAutoScalingGroupField::LastRefreshTimestamp => "LastRefreshTimestamp",
            ExportableAutoScalingGroupField::LookbackPeriodInDays => "LookbackPeriodInDays",
            ExportableAutoScalingGroupField::RecommendationOptionsConfigurationDesiredCapacity => "RecommendationOptionsConfigurationDesiredCapacity",
            ExportableAutoScalingGroupField::RecommendationOptionsConfigurationInstanceType => "RecommendationOptionsConfigurationInstanceType",
            ExportableAutoScalingGroupField::RecommendationOptionsConfigurationMaxSize => "RecommendationOptionsConfigurationMaxSize",
            ExportableAutoScalingGroupField::RecommendationOptionsConfigurationMinSize => "RecommendationOptionsConfigurationMinSize",
            ExportableAutoScalingGroupField::RecommendationOptionsMemory => "RecommendationOptionsMemory",
            ExportableAutoScalingGroupField::RecommendationOptionsNetwork => "RecommendationOptionsNetwork",
            ExportableAutoScalingGroupField::RecommendationOptionsOnDemandPrice => "RecommendationOptionsOnDemandPrice",
            ExportableAutoScalingGroupField::RecommendationOptionsPerformanceRisk => "RecommendationOptionsPerformanceRisk",
            ExportableAutoScalingGroupField::RecommendationOptionsProjectedUtilizationMetricsCpuMaximum => "RecommendationOptionsProjectedUtilizationMetricsCpuMaximum",
            ExportableAutoScalingGroupField::RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum => "RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum",
            ExportableAutoScalingGroupField::RecommendationOptionsStandardOneYearNoUpfrontReservedPrice => "RecommendationOptionsStandardOneYearNoUpfrontReservedPrice",
            ExportableAutoScalingGroupField::RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice => "RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice",
            ExportableAutoScalingGroupField::RecommendationOptionsStorage => "RecommendationOptionsStorage",
            ExportableAutoScalingGroupField::RecommendationOptionsVcpus => "RecommendationOptionsVcpus",
            ExportableAutoScalingGroupField::UtilizationMetricsCpuMaximum => "UtilizationMetricsCpuMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsDiskReadBytesPerSecondMaximum => "UtilizationMetricsDiskReadBytesPerSecondMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsDiskReadOpsPerSecondMaximum => "UtilizationMetricsDiskReadOpsPerSecondMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsDiskWriteBytesPerSecondMaximum => "UtilizationMetricsDiskWriteBytesPerSecondMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsDiskWriteOpsPerSecondMaximum => "UtilizationMetricsDiskWriteOpsPerSecondMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsEbsReadBytesPerSecondMaximum => "UtilizationMetricsEbsReadBytesPerSecondMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsEbsReadOpsPerSecondMaximum => "UtilizationMetricsEbsReadOpsPerSecondMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsEbsWriteBytesPerSecondMaximum => "UtilizationMetricsEbsWriteBytesPerSecondMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsEbsWriteOpsPerSecondMaximum => "UtilizationMetricsEbsWriteOpsPerSecondMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsMemoryMaximum => "UtilizationMetricsMemoryMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsNetworkInBytesPerSecondMaximum => "UtilizationMetricsNetworkInBytesPerSecondMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsNetworkOutBytesPerSecondMaximum => "UtilizationMetricsNetworkOutBytesPerSecondMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsNetworkPacketsInPerSecondMaximum => "UtilizationMetricsNetworkPacketsInPerSecondMaximum",
            ExportableAutoScalingGroupField::UtilizationMetricsNetworkPacketsOutPerSecondMaximum => "UtilizationMetricsNetworkPacketsOutPerSecondMaximum",
            ExportableAutoScalingGroupField::Unknown(s) => s.as_ref()
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccountId",
            "AutoScalingGroupArn",
            "AutoScalingGroupName",
            "CurrentConfigurationDesiredCapacity",
            "CurrentConfigurationInstanceType",
            "CurrentConfigurationMaxSize",
            "CurrentConfigurationMinSize",
            "CurrentMemory",
            "CurrentNetwork",
            "CurrentOnDemandPrice",
            "CurrentStandardOneYearNoUpfrontReservedPrice",
            "CurrentStandardThreeYearNoUpfrontReservedPrice",
            "CurrentStorage",
            "CurrentVCpus",
            "Finding",
            "LastRefreshTimestamp",
            "LookbackPeriodInDays",
            "RecommendationOptionsConfigurationDesiredCapacity",
            "RecommendationOptionsConfigurationInstanceType",
            "RecommendationOptionsConfigurationMaxSize",
            "RecommendationOptionsConfigurationMinSize",
            "RecommendationOptionsMemory",
            "RecommendationOptionsNetwork",
            "RecommendationOptionsOnDemandPrice",
            "RecommendationOptionsPerformanceRisk",
            "RecommendationOptionsProjectedUtilizationMetricsCpuMaximum",
            "RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum",
            "RecommendationOptionsStandardOneYearNoUpfrontReservedPrice",
            "RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice",
            "RecommendationOptionsStorage",
            "RecommendationOptionsVcpus",
            "UtilizationMetricsCpuMaximum",
            "UtilizationMetricsDiskReadBytesPerSecondMaximum",
            "UtilizationMetricsDiskReadOpsPerSecondMaximum",
            "UtilizationMetricsDiskWriteBytesPerSecondMaximum",
            "UtilizationMetricsDiskWriteOpsPerSecondMaximum",
            "UtilizationMetricsEbsReadBytesPerSecondMaximum",
            "UtilizationMetricsEbsReadOpsPerSecondMaximum",
            "UtilizationMetricsEbsWriteBytesPerSecondMaximum",
            "UtilizationMetricsEbsWriteOpsPerSecondMaximum",
            "UtilizationMetricsMemoryMaximum",
            "UtilizationMetricsNetworkInBytesPerSecondMaximum",
            "UtilizationMetricsNetworkOutBytesPerSecondMaximum",
            "UtilizationMetricsNetworkPacketsInPerSecondMaximum",
            "UtilizationMetricsNetworkPacketsOutPerSecondMaximum",
        ]
    }
}
impl AsRef<str> for ExportableAutoScalingGroupField {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a recommendation export job.</p>
///
///
/// <p>Use the <a>DescribeRecommendationExportJobs</a> action to view your
/// recommendation export jobs.</p>
///
///
/// <p>Use the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions to request an export of your
/// recommendations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationExportJob {
    /// <p>The identification number of the export job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>An object that describes the destination of the export file.</p>
    pub destination: std::option::Option<crate::model::ExportDestination>,
    /// <p>The resource type of the exported recommendations.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The status of the export job.</p>
    pub status: std::option::Option<crate::model::JobStatus>,
    /// <p>The timestamp of when the export job was created.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of when the export job was last updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The reason for an export job failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl RecommendationExportJob {
    /// <p>The identification number of the export job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>An object that describes the destination of the export file.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::ExportDestination> {
        self.destination.as_ref()
    }
    /// <p>The resource type of the exported recommendations.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The status of the export job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.status.as_ref()
    }
    /// <p>The timestamp of when the export job was created.</p>
    pub fn creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_timestamp.as_ref()
    }
    /// <p>The timestamp of when the export job was last updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_timestamp.as_ref()
    }
    /// <p>The reason for an export job failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for RecommendationExportJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationExportJob");
        formatter.field("job_id", &self.job_id);
        formatter.field("destination", &self.destination);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("status", &self.status);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`RecommendationExportJob`](crate::model::RecommendationExportJob)
pub mod recommendation_export_job {
    /// A builder for [`RecommendationExportJob`](crate::model::RecommendationExportJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::ExportDestination>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identification number of the export job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identification number of the export job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>An object that describes the destination of the export file.</p>
        pub fn destination(mut self, input: crate::model::ExportDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>An object that describes the destination of the export file.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::ExportDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The resource type of the exported recommendations.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type of the exported recommendations.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The status of the export job.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the export job.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The timestamp of when the export job was created.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of when the export job was created.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>The timestamp of when the export job was last updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of when the export job was last updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>The reason for an export job failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason for an export job failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationExportJob`](crate::model::RecommendationExportJob)
        pub fn build(self) -> crate::model::RecommendationExportJob {
            crate::model::RecommendationExportJob {
                job_id: self.job_id,
                destination: self.destination,
                resource_type: self.resource_type,
                status: self.status,
                creation_timestamp: self.creation_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl RecommendationExportJob {
    /// Creates a new builder-style object to manufacture [`RecommendationExportJob`](crate::model::RecommendationExportJob)
    pub fn builder() -> crate::model::recommendation_export_job::Builder {
        crate::model::recommendation_export_job::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "Complete" => JobStatus::Complete,
            "Failed" => JobStatus::Failed,
            "InProgress" => JobStatus::InProgress,
            "Queued" => JobStatus::Queued,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Complete => "Complete",
            JobStatus::Failed => "Failed",
            JobStatus::InProgress => "InProgress",
            JobStatus::Queued => "Queued",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Complete", "Failed", "InProgress", "Queued"]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingGroup,
    #[allow(missing_docs)] // documentation missing in model
    EbsVolume,
    #[allow(missing_docs)] // documentation missing in model
    Ec2Instance,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunction,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "AutoScalingGroup" => ResourceType::AutoScalingGroup,
            "EbsVolume" => ResourceType::EbsVolume,
            "Ec2Instance" => ResourceType::Ec2Instance,
            "LambdaFunction" => ResourceType::LambdaFunction,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::AutoScalingGroup => "AutoScalingGroup",
            ResourceType::EbsVolume => "EbsVolume",
            ResourceType::Ec2Instance => "Ec2Instance",
            ResourceType::LambdaFunction => "LambdaFunction",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AutoScalingGroup",
            "EbsVolume",
            "Ec2Instance",
            "LambdaFunction",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the destination of the recommendations export and metadata files.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportDestination {
    /// <p>An object that describes the destination Amazon Simple Storage Service (Amazon S3)
    /// bucket name and object keys of a recommendations export file, and its associated
    /// metadata file.</p>
    pub s3: std::option::Option<crate::model::S3Destination>,
}
impl ExportDestination {
    /// <p>An object that describes the destination Amazon Simple Storage Service (Amazon S3)
    /// bucket name and object keys of a recommendations export file, and its associated
    /// metadata file.</p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3Destination> {
        self.s3.as_ref()
    }
}
impl std::fmt::Debug for ExportDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportDestination");
        formatter.field("s3", &self.s3);
        formatter.finish()
    }
}
/// See [`ExportDestination`](crate::model::ExportDestination)
pub mod export_destination {
    /// A builder for [`ExportDestination`](crate::model::ExportDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3: std::option::Option<crate::model::S3Destination>,
    }
    impl Builder {
        /// <p>An object that describes the destination Amazon Simple Storage Service (Amazon S3)
        /// bucket name and object keys of a recommendations export file, and its associated
        /// metadata file.</p>
        pub fn s3(mut self, input: crate::model::S3Destination) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>An object that describes the destination Amazon Simple Storage Service (Amazon S3)
        /// bucket name and object keys of a recommendations export file, and its associated
        /// metadata file.</p>
        pub fn set_s3(mut self, input: std::option::Option<crate::model::S3Destination>) -> Self {
            self.s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportDestination`](crate::model::ExportDestination)
        pub fn build(self) -> crate::model::ExportDestination {
            crate::model::ExportDestination { s3: self.s3 }
        }
    }
}
impl ExportDestination {
    /// Creates a new builder-style object to manufacture [`ExportDestination`](crate::model::ExportDestination)
    pub fn builder() -> crate::model::export_destination::Builder {
        crate::model::export_destination::Builder::default()
    }
}

/// <p>Describes a filter that returns a more specific list of recommendation export jobs.
/// Use this filter with the <a>DescribeRecommendationExportJobs</a>
/// action.</p>
///
/// <p>You can use <code>EBSFilter</code> with the <a>GetEBSVolumeRecommendations</a> action,
/// <code>LambdaFunctionRecommendationFilter</code> with the <a>GetLambdaFunctionRecommendations</a> action, and <code>Filter</code> with
/// the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobFilter {
    /// <p>The name of the filter.</p>
    ///
    /// <p>Specify <code>ResourceType</code> to return export jobs of a specific resource type
    /// (for example, <code>Ec2Instance</code>).</p>
    ///
    /// <p>Specify <code>JobStatus</code> to return export jobs with a specific status (e.g,
    /// <code>Complete</code>).</p>
    pub name: std::option::Option<crate::model::JobFilterName>,
    /// <p>The value of the filter.</p>
    ///
    /// <p>The valid values for this parameter are as follows, depending on what you specify for
    /// the <code>name</code> parameter:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you
    /// specify the <code>name</code> parameter as <code>ResourceType</code>. There is
    /// no filter for EBS volumes because volume recommendations cannot be exported at
    /// this time.</p>
    /// </li>
    /// <li>
    /// <p>Specify <code>Queued</code>, <code>InProgress</code>, <code>Complete</code>,
    /// or <code>Failed</code> if you specify the <code>name</code> parameter as
    /// <code>JobStatus</code>.</p>
    /// </li>
    /// </ul>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl JobFilter {
    /// <p>The name of the filter.</p>
    ///
    /// <p>Specify <code>ResourceType</code> to return export jobs of a specific resource type
    /// (for example, <code>Ec2Instance</code>).</p>
    ///
    /// <p>Specify <code>JobStatus</code> to return export jobs with a specific status (e.g,
    /// <code>Complete</code>).</p>
    pub fn name(&self) -> std::option::Option<&crate::model::JobFilterName> {
        self.name.as_ref()
    }
    /// <p>The value of the filter.</p>
    ///
    /// <p>The valid values for this parameter are as follows, depending on what you specify for
    /// the <code>name</code> parameter:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you
    /// specify the <code>name</code> parameter as <code>ResourceType</code>. There is
    /// no filter for EBS volumes because volume recommendations cannot be exported at
    /// this time.</p>
    /// </li>
    /// <li>
    /// <p>Specify <code>Queued</code>, <code>InProgress</code>, <code>Complete</code>,
    /// or <code>Failed</code> if you specify the <code>name</code> parameter as
    /// <code>JobStatus</code>.</p>
    /// </li>
    /// </ul>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for JobFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`JobFilter`](crate::model::JobFilter)
pub mod job_filter {
    /// A builder for [`JobFilter`](crate::model::JobFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::JobFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        ///
        /// <p>Specify <code>ResourceType</code> to return export jobs of a specific resource type
        /// (for example, <code>Ec2Instance</code>).</p>
        ///
        /// <p>Specify <code>JobStatus</code> to return export jobs with a specific status (e.g,
        /// <code>Complete</code>).</p>
        pub fn name(mut self, input: crate::model::JobFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the filter.</p>
        ///
        /// <p>Specify <code>ResourceType</code> to return export jobs of a specific resource type
        /// (for example, <code>Ec2Instance</code>).</p>
        ///
        /// <p>Specify <code>JobStatus</code> to return export jobs with a specific status (e.g,
        /// <code>Complete</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::JobFilterName>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value of the filter.</p>
        ///
        /// <p>The valid values for this parameter are as follows, depending on what you specify for
        /// the <code>name</code> parameter:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you
        /// specify the <code>name</code> parameter as <code>ResourceType</code>. There is
        /// no filter for EBS volumes because volume recommendations cannot be exported at
        /// this time.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>Queued</code>, <code>InProgress</code>, <code>Complete</code>,
        /// or <code>Failed</code> if you specify the <code>name</code> parameter as
        /// <code>JobStatus</code>.</p>
        /// </li>
        /// </ul>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value of the filter.</p>
        ///
        /// <p>The valid values for this parameter are as follows, depending on what you specify for
        /// the <code>name</code> parameter:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you
        /// specify the <code>name</code> parameter as <code>ResourceType</code>. There is
        /// no filter for EBS volumes because volume recommendations cannot be exported at
        /// this time.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>Queued</code>, <code>InProgress</code>, <code>Complete</code>,
        /// or <code>Failed</code> if you specify the <code>name</code> parameter as
        /// <code>JobStatus</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`JobFilter`](crate::model::JobFilter)
        pub fn build(self) -> crate::model::JobFilter {
            crate::model::JobFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl JobFilter {
    /// Creates a new builder-style object to manufacture [`JobFilter`](crate::model::JobFilter)
    pub fn builder() -> crate::model::job_filter::Builder {
        crate::model::job_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobFilterName {
    #[allow(missing_docs)] // documentation missing in model
    JobStatus,
    #[allow(missing_docs)] // documentation missing in model
    ResourceType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobFilterName {
    fn from(s: &str) -> Self {
        match s {
            "JobStatus" => JobFilterName::JobStatus,
            "ResourceType" => JobFilterName::ResourceType,
            other => JobFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobFilterName::from(s))
    }
}
impl JobFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobFilterName::JobStatus => "JobStatus",
            JobFilterName::ResourceType => "ResourceType",
            JobFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JobStatus", "ResourceType"]
    }
}
impl AsRef<str> for JobFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
