// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`DescribeRecommendationExportJobsInput`](crate::input::DescribeRecommendationExportJobsInput)
pub mod describe_recommendation_export_jobs_input {
    /// A builder for [`DescribeRecommendationExportJobsInput`](crate::input::DescribeRecommendationExportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::JobFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `job_ids`.
        ///
        /// To override the contents of this collection use [`set_job_ids`](Self::set_job_ids).
        ///
        /// <p>The identification numbers of the export jobs to return.</p>
        ///
        /// <p>An export job ID is returned when you create an export using the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions.</p>
        ///
        /// <p>All export jobs created in the last seven days are returned if this parameter is
        /// omitted.</p>
        pub fn job_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_ids.unwrap_or_default();
            v.push(input.into());
            self.job_ids = Some(v);
            self
        }
        /// <p>The identification numbers of the export jobs to return.</p>
        ///
        /// <p>An export job ID is returned when you create an export using the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions.</p>
        ///
        /// <p>All export jobs created in the last seven days are returned if this parameter is
        /// omitted.</p>
        pub fn set_job_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects to specify a filter that returns a more specific list of export
        /// jobs.</p>
        pub fn filters(mut self, input: impl Into<crate::model::JobFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of objects to specify a filter that returns a more specific list of export
        /// jobs.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token to advance to the next page of export jobs.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of export jobs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of export jobs to return with a single request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of export jobs to return with a single request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecommendationExportJobsInput`](crate::input::DescribeRecommendationExportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRecommendationExportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRecommendationExportJobsInput {
                job_ids: self.job_ids,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRecommendationExportJobsInputOperationOutputAlias =
    crate::operation::DescribeRecommendationExportJobs;
#[doc(hidden)]
pub type DescribeRecommendationExportJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRecommendationExportJobsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRecommendationExportJobs`](crate::operation::DescribeRecommendationExportJobs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRecommendationExportJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRecommendationExportJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRecommendationExportJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRecommendationExportJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.DescribeRecommendationExportJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_recommendation_export_jobs(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRecommendationExportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRecommendationExportJobs",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRecommendationExportJobsInput`](crate::input::DescribeRecommendationExportJobsInput)
    pub fn builder() -> crate::input::describe_recommendation_export_jobs_input::Builder {
        crate::input::describe_recommendation_export_jobs_input::Builder::default()
    }
}

/// See [`ExportAutoScalingGroupRecommendationsInput`](crate::input::ExportAutoScalingGroupRecommendationsInput)
pub mod export_auto_scaling_group_recommendations_input {
    /// A builder for [`ExportAutoScalingGroupRecommendationsInput`](crate::input::ExportAutoScalingGroupRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) fields_to_export:
            std::option::Option<std::vec::Vec<crate::model::ExportableAutoScalingGroupField>>,
        pub(crate) s3_destination_config: std::option::Option<crate::model::S3DestinationConfig>,
        pub(crate) file_format: std::option::Option<crate::model::FileFormat>,
        pub(crate) include_member_accounts: std::option::Option<bool>,
        pub(crate) recommendation_preferences:
            std::option::Option<crate::model::RecommendationPreferences>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The IDs of the Amazon Web Services accounts for which to export Auto Scaling group
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to export recommendations.</p>
        ///
        /// <p>This parameter cannot be specified together with the include member accounts
        /// parameter. The parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the include member accounts parameter, is omitted.</p>
        ///
        /// <p>You can specify multiple account IDs per request.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The IDs of the Amazon Web Services accounts for which to export Auto Scaling group
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to export recommendations.</p>
        ///
        /// <p>This parameter cannot be specified together with the include member accounts
        /// parameter. The parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the include member accounts parameter, is omitted.</p>
        ///
        /// <p>You can specify multiple account IDs per request.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects to specify a filter that exports a more specific set of Auto Scaling group recommendations.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of objects to specify a filter that exports a more specific set of Auto Scaling group recommendations.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `fields_to_export`.
        ///
        /// To override the contents of this collection use [`set_fields_to_export`](Self::set_fields_to_export).
        ///
        /// <p>The recommendations data to include in the export file. For more information about the
        /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
        /// Guide</i>.</p>
        pub fn fields_to_export(
            mut self,
            input: impl Into<crate::model::ExportableAutoScalingGroupField>,
        ) -> Self {
            let mut v = self.fields_to_export.unwrap_or_default();
            v.push(input.into());
            self.fields_to_export = Some(v);
            self
        }
        /// <p>The recommendations data to include in the export file. For more information about the
        /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
        /// Guide</i>.</p>
        pub fn set_fields_to_export(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ExportableAutoScalingGroupField>,
            >,
        ) -> Self {
            self.fields_to_export = input;
            self
        }
        /// <p>An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket
        /// name and key prefix for the export job.</p>
        ///
        /// <p>You must create the destination Amazon S3 bucket for your recommendations
        /// export before you create the export job. Compute Optimizer does not create the S3 bucket
        /// for you. After you create the S3 bucket, ensure that it has the required permissions
        /// policy  to allow Compute Optimizer to write the export file to it. If you plan to
        /// specify an object prefix when you create the export job, you must include the object
        /// prefix in the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        pub fn s3_destination_config(mut self, input: crate::model::S3DestinationConfig) -> Self {
            self.s3_destination_config = Some(input);
            self
        }
        /// <p>An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket
        /// name and key prefix for the export job.</p>
        ///
        /// <p>You must create the destination Amazon S3 bucket for your recommendations
        /// export before you create the export job. Compute Optimizer does not create the S3 bucket
        /// for you. After you create the S3 bucket, ensure that it has the required permissions
        /// policy  to allow Compute Optimizer to write the export file to it. If you plan to
        /// specify an object prefix when you create the export job, you must include the object
        /// prefix in the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        pub fn set_s3_destination_config(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfig>,
        ) -> Self {
            self.s3_destination_config = input;
            self
        }
        /// <p>The format of the export file.</p>
        ///
        /// <p>The only export file format currently supported is <code>Csv</code>.</p>
        pub fn file_format(mut self, input: crate::model::FileFormat) -> Self {
            self.file_format = Some(input);
            self
        }
        /// <p>The format of the export file.</p>
        ///
        /// <p>The only export file format currently supported is <code>Csv</code>.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::FileFormat>,
        ) -> Self {
            self.file_format = input;
            self
        }
        /// <p>Indicates whether to include recommendations for resources in all member accounts of
        /// the organization if your account is the management account of an organization.</p>
        ///
        /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
        /// Compute Optimizer must be enabled in the organization account. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        ///
        /// <p>Recommendations for member accounts of the organization are not included in the export
        /// file if this parameter is omitted.</p>
        ///
        /// <p>This parameter cannot be specified together with the account IDs parameter. The
        /// parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the account IDs parameter, is omitted.</p>
        pub fn include_member_accounts(mut self, input: bool) -> Self {
            self.include_member_accounts = Some(input);
            self
        }
        /// <p>Indicates whether to include recommendations for resources in all member accounts of
        /// the organization if your account is the management account of an organization.</p>
        ///
        /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
        /// Compute Optimizer must be enabled in the organization account. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        ///
        /// <p>Recommendations for member accounts of the organization are not included in the export
        /// file if this parameter is omitted.</p>
        ///
        /// <p>This parameter cannot be specified together with the account IDs parameter. The
        /// parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the account IDs parameter, is omitted.</p>
        pub fn set_include_member_accounts(mut self, input: std::option::Option<bool>) -> Self {
            self.include_member_accounts = input;
            self
        }
        /// <p>An object to specify the preferences for the Auto Scaling group recommendations
        /// to export.</p>
        pub fn recommendation_preferences(
            mut self,
            input: crate::model::RecommendationPreferences,
        ) -> Self {
            self.recommendation_preferences = Some(input);
            self
        }
        /// <p>An object to specify the preferences for the Auto Scaling group recommendations
        /// to export.</p>
        pub fn set_recommendation_preferences(
            mut self,
            input: std::option::Option<crate::model::RecommendationPreferences>,
        ) -> Self {
            self.recommendation_preferences = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportAutoScalingGroupRecommendationsInput`](crate::input::ExportAutoScalingGroupRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportAutoScalingGroupRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportAutoScalingGroupRecommendationsInput {
                account_ids: self.account_ids,
                filters: self.filters,
                fields_to_export: self.fields_to_export,
                s3_destination_config: self.s3_destination_config,
                file_format: self.file_format,
                include_member_accounts: self.include_member_accounts.unwrap_or_default(),
                recommendation_preferences: self.recommendation_preferences,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportAutoScalingGroupRecommendationsInputOperationOutputAlias =
    crate::operation::ExportAutoScalingGroupRecommendations;
#[doc(hidden)]
pub type ExportAutoScalingGroupRecommendationsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ExportAutoScalingGroupRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`ExportAutoScalingGroupRecommendations`](crate::operation::ExportAutoScalingGroupRecommendations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportAutoScalingGroupRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExportAutoScalingGroupRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExportAutoScalingGroupRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExportAutoScalingGroupRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.ExportAutoScalingGroupRecommendations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_export_auto_scaling_group_recommendations(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportAutoScalingGroupRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportAutoScalingGroupRecommendations",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExportAutoScalingGroupRecommendationsInput`](crate::input::ExportAutoScalingGroupRecommendationsInput)
    pub fn builder() -> crate::input::export_auto_scaling_group_recommendations_input::Builder {
        crate::input::export_auto_scaling_group_recommendations_input::Builder::default()
    }
}

/// See [`ExportEbsVolumeRecommendationsInput`](crate::input::ExportEbsVolumeRecommendationsInput)
pub mod export_ebs_volume_recommendations_input {
    /// A builder for [`ExportEbsVolumeRecommendationsInput`](crate::input::ExportEbsVolumeRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::EbsFilter>>,
        pub(crate) fields_to_export:
            std::option::Option<std::vec::Vec<crate::model::ExportableVolumeField>>,
        pub(crate) s3_destination_config: std::option::Option<crate::model::S3DestinationConfig>,
        pub(crate) file_format: std::option::Option<crate::model::FileFormat>,
        pub(crate) include_member_accounts: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The IDs of the Amazon Web Services accounts for which to export Amazon EBS
        /// volume recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to export recommendations.</p>
        ///
        /// <p>This parameter cannot be specified together with the include member accounts
        /// parameter. The parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the include member accounts parameter, is omitted.</p>
        ///
        /// <p>You can specify multiple account IDs per request.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The IDs of the Amazon Web Services accounts for which to export Amazon EBS
        /// volume recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to export recommendations.</p>
        ///
        /// <p>This parameter cannot be specified together with the include member accounts
        /// parameter. The parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the include member accounts parameter, is omitted.</p>
        ///
        /// <p>You can specify multiple account IDs per request.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects to specify a filter that exports a more specific set of Amazon EBS volume recommendations.</p>
        pub fn filters(mut self, input: impl Into<crate::model::EbsFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of objects to specify a filter that exports a more specific set of Amazon EBS volume recommendations.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EbsFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `fields_to_export`.
        ///
        /// To override the contents of this collection use [`set_fields_to_export`](Self::set_fields_to_export).
        ///
        /// <p>The recommendations data to include in the export file. For more information about the
        /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
        /// Guide</i>.</p>
        pub fn fields_to_export(
            mut self,
            input: impl Into<crate::model::ExportableVolumeField>,
        ) -> Self {
            let mut v = self.fields_to_export.unwrap_or_default();
            v.push(input.into());
            self.fields_to_export = Some(v);
            self
        }
        /// <p>The recommendations data to include in the export file. For more information about the
        /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
        /// Guide</i>.</p>
        pub fn set_fields_to_export(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportableVolumeField>>,
        ) -> Self {
            self.fields_to_export = input;
            self
        }
        /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
        /// key prefix for a recommendations export job.</p>
        ///
        /// <p>You must create the destination Amazon S3 bucket for your recommendations
        /// export before you create the export job. Compute Optimizer does not create the S3 bucket
        /// for you. After you create the S3 bucket, ensure that it has the required permission
        /// policy to allow Compute Optimizer to write the export file to it. If you plan to specify
        /// an object prefix when you create the export job, you must include the object prefix in
        /// the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        pub fn s3_destination_config(mut self, input: crate::model::S3DestinationConfig) -> Self {
            self.s3_destination_config = Some(input);
            self
        }
        /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
        /// key prefix for a recommendations export job.</p>
        ///
        /// <p>You must create the destination Amazon S3 bucket for your recommendations
        /// export before you create the export job. Compute Optimizer does not create the S3 bucket
        /// for you. After you create the S3 bucket, ensure that it has the required permission
        /// policy to allow Compute Optimizer to write the export file to it. If you plan to specify
        /// an object prefix when you create the export job, you must include the object prefix in
        /// the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        pub fn set_s3_destination_config(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfig>,
        ) -> Self {
            self.s3_destination_config = input;
            self
        }
        /// <p>The format of the export file.</p>
        ///
        /// <p>The only export file format currently supported is <code>Csv</code>.</p>
        pub fn file_format(mut self, input: crate::model::FileFormat) -> Self {
            self.file_format = Some(input);
            self
        }
        /// <p>The format of the export file.</p>
        ///
        /// <p>The only export file format currently supported is <code>Csv</code>.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::FileFormat>,
        ) -> Self {
            self.file_format = input;
            self
        }
        /// <p>Indicates whether to include recommendations for resources in all member accounts of
        /// the organization if your account is the management account of an organization.</p>
        ///
        /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
        /// Compute Optimizer must be enabled in the organization account. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        ///
        /// <p>Recommendations for member accounts of the organization are not included in the export
        /// file if this parameter is omitted.</p>
        ///
        /// <p>This parameter cannot be specified together with the account IDs parameter. The
        /// parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the account IDs parameter, is omitted.</p>
        pub fn include_member_accounts(mut self, input: bool) -> Self {
            self.include_member_accounts = Some(input);
            self
        }
        /// <p>Indicates whether to include recommendations for resources in all member accounts of
        /// the organization if your account is the management account of an organization.</p>
        ///
        /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
        /// Compute Optimizer must be enabled in the organization account. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        ///
        /// <p>Recommendations for member accounts of the organization are not included in the export
        /// file if this parameter is omitted.</p>
        ///
        /// <p>This parameter cannot be specified together with the account IDs parameter. The
        /// parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the account IDs parameter, is omitted.</p>
        pub fn set_include_member_accounts(mut self, input: std::option::Option<bool>) -> Self {
            self.include_member_accounts = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportEbsVolumeRecommendationsInput`](crate::input::ExportEbsVolumeRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportEbsVolumeRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportEbsVolumeRecommendationsInput {
                account_ids: self.account_ids,
                filters: self.filters,
                fields_to_export: self.fields_to_export,
                s3_destination_config: self.s3_destination_config,
                file_format: self.file_format,
                include_member_accounts: self.include_member_accounts.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ExportEbsVolumeRecommendationsInputOperationOutputAlias =
    crate::operation::ExportEBSVolumeRecommendations;
#[doc(hidden)]
pub type ExportEbsVolumeRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExportEbsVolumeRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`ExportEBSVolumeRecommendations`](crate::operation::ExportEBSVolumeRecommendations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportEBSVolumeRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExportEbsVolumeRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExportEbsVolumeRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExportEbsVolumeRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.ExportEBSVolumeRecommendations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_export_ebs_volume_recommendations(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportEBSVolumeRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportEBSVolumeRecommendations",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExportEbsVolumeRecommendationsInput`](crate::input::ExportEbsVolumeRecommendationsInput)
    pub fn builder() -> crate::input::export_ebs_volume_recommendations_input::Builder {
        crate::input::export_ebs_volume_recommendations_input::Builder::default()
    }
}

/// See [`ExportEc2InstanceRecommendationsInput`](crate::input::ExportEc2InstanceRecommendationsInput)
pub mod export_ec2_instance_recommendations_input {
    /// A builder for [`ExportEc2InstanceRecommendationsInput`](crate::input::ExportEc2InstanceRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) fields_to_export:
            std::option::Option<std::vec::Vec<crate::model::ExportableInstanceField>>,
        pub(crate) s3_destination_config: std::option::Option<crate::model::S3DestinationConfig>,
        pub(crate) file_format: std::option::Option<crate::model::FileFormat>,
        pub(crate) include_member_accounts: std::option::Option<bool>,
        pub(crate) recommendation_preferences:
            std::option::Option<crate::model::RecommendationPreferences>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The IDs of the Amazon Web Services accounts for which to export instance
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to export recommendations.</p>
        ///
        /// <p>This parameter cannot be specified together with the include member accounts
        /// parameter. The parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the include member accounts parameter, is omitted.</p>
        ///
        /// <p>You can specify multiple account IDs per request.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The IDs of the Amazon Web Services accounts for which to export instance
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to export recommendations.</p>
        ///
        /// <p>This parameter cannot be specified together with the include member accounts
        /// parameter. The parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the include member accounts parameter, is omitted.</p>
        ///
        /// <p>You can specify multiple account IDs per request.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects to specify a filter that exports a more specific set of instance
        /// recommendations.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of objects to specify a filter that exports a more specific set of instance
        /// recommendations.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `fields_to_export`.
        ///
        /// To override the contents of this collection use [`set_fields_to_export`](Self::set_fields_to_export).
        ///
        /// <p>The recommendations data to include in the export file. For more information about the
        /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
        /// Guide</i>.</p>
        pub fn fields_to_export(
            mut self,
            input: impl Into<crate::model::ExportableInstanceField>,
        ) -> Self {
            let mut v = self.fields_to_export.unwrap_or_default();
            v.push(input.into());
            self.fields_to_export = Some(v);
            self
        }
        /// <p>The recommendations data to include in the export file. For more information about the
        /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
        /// Guide</i>.</p>
        pub fn set_fields_to_export(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportableInstanceField>>,
        ) -> Self {
            self.fields_to_export = input;
            self
        }
        /// <p>An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket
        /// name and key prefix for the export job.</p>
        ///
        /// <p>You must create the destination Amazon S3 bucket for your recommendations
        /// export before you create the export job. Compute Optimizer does not create the S3 bucket
        /// for you. After you create the S3 bucket, ensure that it has the required permissions
        /// policy policy to allow Compute Optimizer to write the export file to it. If you plan to
        /// specify an object prefix when you create the export job, you must include the object
        /// prefix in the  that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        pub fn s3_destination_config(mut self, input: crate::model::S3DestinationConfig) -> Self {
            self.s3_destination_config = Some(input);
            self
        }
        /// <p>An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket
        /// name and key prefix for the export job.</p>
        ///
        /// <p>You must create the destination Amazon S3 bucket for your recommendations
        /// export before you create the export job. Compute Optimizer does not create the S3 bucket
        /// for you. After you create the S3 bucket, ensure that it has the required permissions
        /// policy policy to allow Compute Optimizer to write the export file to it. If you plan to
        /// specify an object prefix when you create the export job, you must include the object
        /// prefix in the  that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        pub fn set_s3_destination_config(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfig>,
        ) -> Self {
            self.s3_destination_config = input;
            self
        }
        /// <p>The format of the export file.</p>
        ///
        /// <p>The only export file format currently supported is <code>Csv</code>.</p>
        pub fn file_format(mut self, input: crate::model::FileFormat) -> Self {
            self.file_format = Some(input);
            self
        }
        /// <p>The format of the export file.</p>
        ///
        /// <p>The only export file format currently supported is <code>Csv</code>.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::FileFormat>,
        ) -> Self {
            self.file_format = input;
            self
        }
        /// <p>Indicates whether to include recommendations for resources in all member accounts of
        /// the organization if your account is the management account of an organization.</p>
        ///
        /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
        /// Compute Optimizer must be enabled in the organization account. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        ///
        /// <p>Recommendations for member accounts of the organization are not included in the export
        /// file if this parameter is omitted.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the account IDs parameter, is omitted.</p>
        pub fn include_member_accounts(mut self, input: bool) -> Self {
            self.include_member_accounts = Some(input);
            self
        }
        /// <p>Indicates whether to include recommendations for resources in all member accounts of
        /// the organization if your account is the management account of an organization.</p>
        ///
        /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
        /// Compute Optimizer must be enabled in the organization account. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        ///
        /// <p>Recommendations for member accounts of the organization are not included in the export
        /// file if this parameter is omitted.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the account IDs parameter, is omitted.</p>
        pub fn set_include_member_accounts(mut self, input: std::option::Option<bool>) -> Self {
            self.include_member_accounts = input;
            self
        }
        /// <p>An object to specify the preferences for the Amazon EC2 instance
        /// recommendations to export.</p>
        pub fn recommendation_preferences(
            mut self,
            input: crate::model::RecommendationPreferences,
        ) -> Self {
            self.recommendation_preferences = Some(input);
            self
        }
        /// <p>An object to specify the preferences for the Amazon EC2 instance
        /// recommendations to export.</p>
        pub fn set_recommendation_preferences(
            mut self,
            input: std::option::Option<crate::model::RecommendationPreferences>,
        ) -> Self {
            self.recommendation_preferences = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportEc2InstanceRecommendationsInput`](crate::input::ExportEc2InstanceRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportEc2InstanceRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportEc2InstanceRecommendationsInput {
                account_ids: self.account_ids,
                filters: self.filters,
                fields_to_export: self.fields_to_export,
                s3_destination_config: self.s3_destination_config,
                file_format: self.file_format,
                include_member_accounts: self.include_member_accounts.unwrap_or_default(),
                recommendation_preferences: self.recommendation_preferences,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportEc2InstanceRecommendationsInputOperationOutputAlias =
    crate::operation::ExportEC2InstanceRecommendations;
#[doc(hidden)]
pub type ExportEc2InstanceRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExportEc2InstanceRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`ExportEC2InstanceRecommendations`](crate::operation::ExportEC2InstanceRecommendations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportEC2InstanceRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExportEc2InstanceRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExportEc2InstanceRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExportEc2InstanceRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.ExportEC2InstanceRecommendations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_export_ec2_instance_recommendations(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportEC2InstanceRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportEC2InstanceRecommendations",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExportEc2InstanceRecommendationsInput`](crate::input::ExportEc2InstanceRecommendationsInput)
    pub fn builder() -> crate::input::export_ec2_instance_recommendations_input::Builder {
        crate::input::export_ec2_instance_recommendations_input::Builder::default()
    }
}

/// See [`ExportLambdaFunctionRecommendationsInput`](crate::input::ExportLambdaFunctionRecommendationsInput)
pub mod export_lambda_function_recommendations_input {
    /// A builder for [`ExportLambdaFunctionRecommendationsInput`](crate::input::ExportLambdaFunctionRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::LambdaFunctionRecommendationFilter>>,
        pub(crate) fields_to_export:
            std::option::Option<std::vec::Vec<crate::model::ExportableLambdaFunctionField>>,
        pub(crate) s3_destination_config: std::option::Option<crate::model::S3DestinationConfig>,
        pub(crate) file_format: std::option::Option<crate::model::FileFormat>,
        pub(crate) include_member_accounts: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The IDs of the Amazon Web Services accounts for which to export Lambda
        /// function recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to export recommendations.</p>
        ///
        /// <p>This parameter cannot be specified together with the include member accounts
        /// parameter. The parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the include member accounts parameter, is omitted.</p>
        ///
        /// <p>You can specify multiple account IDs per request.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The IDs of the Amazon Web Services accounts for which to export Lambda
        /// function recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to export recommendations.</p>
        ///
        /// <p>This parameter cannot be specified together with the include member accounts
        /// parameter. The parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the include member accounts parameter, is omitted.</p>
        ///
        /// <p>You can specify multiple account IDs per request.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects to specify a filter that exports a more specific set of Lambda function recommendations.</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::LambdaFunctionRecommendationFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of objects to specify a filter that exports a more specific set of Lambda function recommendations.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LambdaFunctionRecommendationFilter>,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `fields_to_export`.
        ///
        /// To override the contents of this collection use [`set_fields_to_export`](Self::set_fields_to_export).
        ///
        /// <p>The recommendations data to include in the export file. For more information about the
        /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
        /// Guide</i>.</p>
        pub fn fields_to_export(
            mut self,
            input: impl Into<crate::model::ExportableLambdaFunctionField>,
        ) -> Self {
            let mut v = self.fields_to_export.unwrap_or_default();
            v.push(input.into());
            self.fields_to_export = Some(v);
            self
        }
        /// <p>The recommendations data to include in the export file. For more information about the
        /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
        /// Guide</i>.</p>
        pub fn set_fields_to_export(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportableLambdaFunctionField>>,
        ) -> Self {
            self.fields_to_export = input;
            self
        }
        /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
        /// key prefix for a recommendations export job.</p>
        ///
        /// <p>You must create the destination Amazon S3 bucket for your recommendations
        /// export before you create the export job. Compute Optimizer does not create the S3 bucket
        /// for you. After you create the S3 bucket, ensure that it has the required permission
        /// policy to allow Compute Optimizer to write the export file to it. If you plan to specify
        /// an object prefix when you create the export job, you must include the object prefix in
        /// the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        pub fn s3_destination_config(mut self, input: crate::model::S3DestinationConfig) -> Self {
            self.s3_destination_config = Some(input);
            self
        }
        /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
        /// key prefix for a recommendations export job.</p>
        ///
        /// <p>You must create the destination Amazon S3 bucket for your recommendations
        /// export before you create the export job. Compute Optimizer does not create the S3 bucket
        /// for you. After you create the S3 bucket, ensure that it has the required permission
        /// policy to allow Compute Optimizer to write the export file to it. If you plan to specify
        /// an object prefix when you create the export job, you must include the object prefix in
        /// the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        pub fn set_s3_destination_config(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfig>,
        ) -> Self {
            self.s3_destination_config = input;
            self
        }
        /// <p>The format of the export file.</p>
        ///
        /// <p>The only export file format currently supported is <code>Csv</code>.</p>
        pub fn file_format(mut self, input: crate::model::FileFormat) -> Self {
            self.file_format = Some(input);
            self
        }
        /// <p>The format of the export file.</p>
        ///
        /// <p>The only export file format currently supported is <code>Csv</code>.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::FileFormat>,
        ) -> Self {
            self.file_format = input;
            self
        }
        /// <p>Indicates whether to include recommendations for resources in all member accounts of
        /// the organization if your account is the management account of an organization.</p>
        ///
        /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
        /// Compute Optimizer must be enabled in the organization account. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        ///
        /// <p>Recommendations for member accounts of the organization are not included in the export
        /// file if this parameter is omitted.</p>
        ///
        /// <p>This parameter cannot be specified together with the account IDs parameter. The
        /// parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the account IDs parameter, is omitted.</p>
        pub fn include_member_accounts(mut self, input: bool) -> Self {
            self.include_member_accounts = Some(input);
            self
        }
        /// <p>Indicates whether to include recommendations for resources in all member accounts of
        /// the organization if your account is the management account of an organization.</p>
        ///
        /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
        /// Compute Optimizer must be enabled in the organization account. For more information,
        /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
        /// <i>Compute Optimizer User Guide</i>.</p>
        ///
        /// <p>Recommendations for member accounts of the organization are not included in the export
        /// file if this parameter is omitted.</p>
        ///
        /// <p>This parameter cannot be specified together with the account IDs parameter. The
        /// parameters are mutually exclusive.</p>
        ///
        /// <p>Recommendations for member accounts are not included in the export if this parameter,
        /// or the account IDs parameter, is omitted.</p>
        pub fn set_include_member_accounts(mut self, input: std::option::Option<bool>) -> Self {
            self.include_member_accounts = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportLambdaFunctionRecommendationsInput`](crate::input::ExportLambdaFunctionRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportLambdaFunctionRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportLambdaFunctionRecommendationsInput {
                account_ids: self.account_ids,
                filters: self.filters,
                fields_to_export: self.fields_to_export,
                s3_destination_config: self.s3_destination_config,
                file_format: self.file_format,
                include_member_accounts: self.include_member_accounts.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ExportLambdaFunctionRecommendationsInputOperationOutputAlias =
    crate::operation::ExportLambdaFunctionRecommendations;
#[doc(hidden)]
pub type ExportLambdaFunctionRecommendationsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ExportLambdaFunctionRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`ExportLambdaFunctionRecommendations`](crate::operation::ExportLambdaFunctionRecommendations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportLambdaFunctionRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExportLambdaFunctionRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExportLambdaFunctionRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExportLambdaFunctionRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.ExportLambdaFunctionRecommendations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_export_lambda_function_recommendations(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportLambdaFunctionRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportLambdaFunctionRecommendations",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExportLambdaFunctionRecommendationsInput`](crate::input::ExportLambdaFunctionRecommendationsInput)
    pub fn builder() -> crate::input::export_lambda_function_recommendations_input::Builder {
        crate::input::export_lambda_function_recommendations_input::Builder::default()
    }
}

/// See [`GetAutoScalingGroupRecommendationsInput`](crate::input::GetAutoScalingGroupRecommendationsInput)
pub mod get_auto_scaling_group_recommendations_input {
    /// A builder for [`GetAutoScalingGroupRecommendationsInput`](crate::input::GetAutoScalingGroupRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_scaling_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) recommendation_preferences:
            std::option::Option<crate::model::RecommendationPreferences>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account for which to return Auto Scaling group
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to return Auto Scaling group
        /// recommendations.</p>
        ///
        /// <p>Only one account ID can be specified per request.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The ID of the Amazon Web Services account for which to return Auto Scaling group
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to return Auto Scaling group
        /// recommendations.</p>
        ///
        /// <p>Only one account ID can be specified per request.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `auto_scaling_group_arns`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_group_arns`](Self::set_auto_scaling_group_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return
        /// recommendations.</p>
        pub fn auto_scaling_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.auto_scaling_group_arns.unwrap_or_default();
            v.push(input.into());
            self.auto_scaling_group_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return
        /// recommendations.</p>
        pub fn set_auto_scaling_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_scaling_group_arns = input;
            self
        }
        /// <p>The token to advance to the next page of Auto Scaling group
        /// recommendations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of Auto Scaling group
        /// recommendations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of Auto Scaling group recommendations to return with a single
        /// request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of Auto Scaling group recommendations to return with a single
        /// request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects to specify a filter that returns a more specific list of Auto Scaling group recommendations.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of objects to specify a filter that returns a more specific list of Auto Scaling group recommendations.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An object to specify the preferences for the Auto Scaling group recommendations
        /// to return in the response.</p>
        pub fn recommendation_preferences(
            mut self,
            input: crate::model::RecommendationPreferences,
        ) -> Self {
            self.recommendation_preferences = Some(input);
            self
        }
        /// <p>An object to specify the preferences for the Auto Scaling group recommendations
        /// to return in the response.</p>
        pub fn set_recommendation_preferences(
            mut self,
            input: std::option::Option<crate::model::RecommendationPreferences>,
        ) -> Self {
            self.recommendation_preferences = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAutoScalingGroupRecommendationsInput`](crate::input::GetAutoScalingGroupRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAutoScalingGroupRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAutoScalingGroupRecommendationsInput {
                account_ids: self.account_ids,
                auto_scaling_group_arns: self.auto_scaling_group_arns,
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
                recommendation_preferences: self.recommendation_preferences,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAutoScalingGroupRecommendationsInputOperationOutputAlias =
    crate::operation::GetAutoScalingGroupRecommendations;
#[doc(hidden)]
pub type GetAutoScalingGroupRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAutoScalingGroupRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`GetAutoScalingGroupRecommendations`](crate::operation::GetAutoScalingGroupRecommendations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAutoScalingGroupRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAutoScalingGroupRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAutoScalingGroupRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAutoScalingGroupRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.GetAutoScalingGroupRecommendations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_auto_scaling_group_recommendations(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAutoScalingGroupRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAutoScalingGroupRecommendations",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAutoScalingGroupRecommendationsInput`](crate::input::GetAutoScalingGroupRecommendationsInput)
    pub fn builder() -> crate::input::get_auto_scaling_group_recommendations_input::Builder {
        crate::input::get_auto_scaling_group_recommendations_input::Builder::default()
    }
}

/// See [`GetEbsVolumeRecommendationsInput`](crate::input::GetEbsVolumeRecommendationsInput)
pub mod get_ebs_volume_recommendations_input {
    /// A builder for [`GetEbsVolumeRecommendationsInput`](crate::input::GetEbsVolumeRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::EbsFilter>>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `volume_arns`.
        ///
        /// To override the contents of this collection use [`set_volume_arns`](Self::set_volume_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the volumes for which to return
        /// recommendations.</p>
        pub fn volume_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.volume_arns.unwrap_or_default();
            v.push(input.into());
            self.volume_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the volumes for which to return
        /// recommendations.</p>
        pub fn set_volume_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.volume_arns = input;
            self
        }
        /// <p>The token to advance to the next page of volume recommendations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of volume recommendations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of volume recommendations to return with a single request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of volume recommendations to return with a single request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects to specify a filter that returns a more specific list of volume
        /// recommendations.</p>
        pub fn filters(mut self, input: impl Into<crate::model::EbsFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of objects to specify a filter that returns a more specific list of volume
        /// recommendations.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EbsFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account for which to return volume
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to return volume recommendations.</p>
        ///
        /// <p>Only one account ID can be specified per request.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The ID of the Amazon Web Services account for which to return volume
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to return volume recommendations.</p>
        ///
        /// <p>Only one account ID can be specified per request.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEbsVolumeRecommendationsInput`](crate::input::GetEbsVolumeRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEbsVolumeRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEbsVolumeRecommendationsInput {
                volume_arns: self.volume_arns,
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEbsVolumeRecommendationsInputOperationOutputAlias =
    crate::operation::GetEBSVolumeRecommendations;
#[doc(hidden)]
pub type GetEbsVolumeRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEbsVolumeRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`GetEBSVolumeRecommendations`](crate::operation::GetEBSVolumeRecommendations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEBSVolumeRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEbsVolumeRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEbsVolumeRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEbsVolumeRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.GetEBSVolumeRecommendations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_ebs_volume_recommendations(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEBSVolumeRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEBSVolumeRecommendations",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEbsVolumeRecommendationsInput`](crate::input::GetEbsVolumeRecommendationsInput)
    pub fn builder() -> crate::input::get_ebs_volume_recommendations_input::Builder {
        crate::input::get_ebs_volume_recommendations_input::Builder::default()
    }
}

/// See [`GetEc2InstanceRecommendationsInput`](crate::input::GetEc2InstanceRecommendationsInput)
pub mod get_ec2_instance_recommendations_input {
    /// A builder for [`GetEc2InstanceRecommendationsInput`](crate::input::GetEc2InstanceRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) recommendation_preferences:
            std::option::Option<crate::model::RecommendationPreferences>,
    }
    impl Builder {
        /// Appends an item to `instance_arns`.
        ///
        /// To override the contents of this collection use [`set_instance_arns`](Self::set_instance_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the instances for which to return
        /// recommendations.</p>
        pub fn instance_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_arns.unwrap_or_default();
            v.push(input.into());
            self.instance_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instances for which to return
        /// recommendations.</p>
        pub fn set_instance_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_arns = input;
            self
        }
        /// <p>The token to advance to the next page of instance recommendations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of instance recommendations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of instance recommendations to return with a single request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of instance recommendations to return with a single request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects to specify a filter that returns a more specific list of instance
        /// recommendations.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of objects to specify a filter that returns a more specific list of instance
        /// recommendations.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account for which to return instance
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to return instance recommendations.</p>
        ///
        /// <p>Only one account ID can be specified per request.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The ID of the Amazon Web Services account for which to return instance
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to return instance recommendations.</p>
        ///
        /// <p>Only one account ID can be specified per request.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// <p>An object to specify the preferences for the Amazon EC2 instance
        /// recommendations to return in the response.</p>
        pub fn recommendation_preferences(
            mut self,
            input: crate::model::RecommendationPreferences,
        ) -> Self {
            self.recommendation_preferences = Some(input);
            self
        }
        /// <p>An object to specify the preferences for the Amazon EC2 instance
        /// recommendations to return in the response.</p>
        pub fn set_recommendation_preferences(
            mut self,
            input: std::option::Option<crate::model::RecommendationPreferences>,
        ) -> Self {
            self.recommendation_preferences = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEc2InstanceRecommendationsInput`](crate::input::GetEc2InstanceRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEc2InstanceRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEc2InstanceRecommendationsInput {
                instance_arns: self.instance_arns,
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
                account_ids: self.account_ids,
                recommendation_preferences: self.recommendation_preferences,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEc2InstanceRecommendationsInputOperationOutputAlias =
    crate::operation::GetEC2InstanceRecommendations;
#[doc(hidden)]
pub type GetEc2InstanceRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEc2InstanceRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`GetEC2InstanceRecommendations`](crate::operation::GetEC2InstanceRecommendations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEC2InstanceRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEc2InstanceRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEc2InstanceRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEc2InstanceRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.GetEC2InstanceRecommendations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_ec2_instance_recommendations(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEC2InstanceRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEC2InstanceRecommendations",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEc2InstanceRecommendationsInput`](crate::input::GetEc2InstanceRecommendationsInput)
    pub fn builder() -> crate::input::get_ec2_instance_recommendations_input::Builder {
        crate::input::get_ec2_instance_recommendations_input::Builder::default()
    }
}

/// See [`GetEc2RecommendationProjectedMetricsInput`](crate::input::GetEc2RecommendationProjectedMetricsInput)
pub mod get_ec2_recommendation_projected_metrics_input {
    /// A builder for [`GetEc2RecommendationProjectedMetricsInput`](crate::input::GetEc2RecommendationProjectedMetricsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) stat: std::option::Option<crate::model::MetricStatistic>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) recommendation_preferences:
            std::option::Option<crate::model::RecommendationPreferences>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the instances for which to return recommendation
        /// projected metrics.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instances for which to return recommendation
        /// projected metrics.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>The statistic of the projected metrics.</p>
        pub fn stat(mut self, input: crate::model::MetricStatistic) -> Self {
            self.stat = Some(input);
            self
        }
        /// <p>The statistic of the projected metrics.</p>
        pub fn set_stat(
            mut self,
            input: std::option::Option<crate::model::MetricStatistic>,
        ) -> Self {
            self.stat = input;
            self
        }
        /// <p>The granularity, in seconds, of the projected metrics data points.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The granularity, in seconds, of the projected metrics data points.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The timestamp of the first projected metrics data point to return.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The timestamp of the first projected metrics data point to return.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The timestamp of the last projected metrics data point to return.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The timestamp of the last projected metrics data point to return.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>An object to specify the preferences for the Amazon EC2 recommendation
        /// projected metrics to return in the response.</p>
        pub fn recommendation_preferences(
            mut self,
            input: crate::model::RecommendationPreferences,
        ) -> Self {
            self.recommendation_preferences = Some(input);
            self
        }
        /// <p>An object to specify the preferences for the Amazon EC2 recommendation
        /// projected metrics to return in the response.</p>
        pub fn set_recommendation_preferences(
            mut self,
            input: std::option::Option<crate::model::RecommendationPreferences>,
        ) -> Self {
            self.recommendation_preferences = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEc2RecommendationProjectedMetricsInput`](crate::input::GetEc2RecommendationProjectedMetricsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEc2RecommendationProjectedMetricsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEc2RecommendationProjectedMetricsInput {
                instance_arn: self.instance_arn,
                stat: self.stat,
                period: self.period.unwrap_or_default(),
                start_time: self.start_time,
                end_time: self.end_time,
                recommendation_preferences: self.recommendation_preferences,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEc2RecommendationProjectedMetricsInputOperationOutputAlias =
    crate::operation::GetEC2RecommendationProjectedMetrics;
#[doc(hidden)]
pub type GetEc2RecommendationProjectedMetricsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetEc2RecommendationProjectedMetricsInput {
    /// Consumes the builder and constructs an Operation<[`GetEC2RecommendationProjectedMetrics`](crate::operation::GetEC2RecommendationProjectedMetrics)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEC2RecommendationProjectedMetrics,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEc2RecommendationProjectedMetricsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEc2RecommendationProjectedMetricsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEc2RecommendationProjectedMetricsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.GetEC2RecommendationProjectedMetrics",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_ec2_recommendation_projected_metrics(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEC2RecommendationProjectedMetrics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEC2RecommendationProjectedMetrics",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEc2RecommendationProjectedMetricsInput`](crate::input::GetEc2RecommendationProjectedMetricsInput)
    pub fn builder() -> crate::input::get_ec2_recommendation_projected_metrics_input::Builder {
        crate::input::get_ec2_recommendation_projected_metrics_input::Builder::default()
    }
}

/// See [`GetEnrollmentStatusInput`](crate::input::GetEnrollmentStatusInput)
pub mod get_enrollment_status_input {
    /// A builder for [`GetEnrollmentStatusInput`](crate::input::GetEnrollmentStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetEnrollmentStatusInput`](crate::input::GetEnrollmentStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEnrollmentStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEnrollmentStatusInput {})
        }
    }
}
#[doc(hidden)]
pub type GetEnrollmentStatusInputOperationOutputAlias = crate::operation::GetEnrollmentStatus;
#[doc(hidden)]
pub type GetEnrollmentStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEnrollmentStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetEnrollmentStatus`](crate::operation::GetEnrollmentStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEnrollmentStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEnrollmentStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEnrollmentStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEnrollmentStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.GetEnrollmentStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_enrollment_status(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEnrollmentStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEnrollmentStatus",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEnrollmentStatusInput`](crate::input::GetEnrollmentStatusInput)
    pub fn builder() -> crate::input::get_enrollment_status_input::Builder {
        crate::input::get_enrollment_status_input::Builder::default()
    }
}

/// See [`GetEnrollmentStatusesForOrganizationInput`](crate::input::GetEnrollmentStatusesForOrganizationInput)
pub mod get_enrollment_statuses_for_organization_input {
    /// A builder for [`GetEnrollmentStatusesForOrganizationInput`](crate::input::GetEnrollmentStatusesForOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::EnrollmentFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects to specify a filter that returns a more specific list of account
        /// enrollment statuses.</p>
        pub fn filters(mut self, input: impl Into<crate::model::EnrollmentFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of objects to specify a filter that returns a more specific list of account
        /// enrollment statuses.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnrollmentFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token to advance to the next page of account enrollment statuses.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of account enrollment statuses.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of account enrollment statuses to return with a single request. You
        /// can specify up to 100 statuses to return with each request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of account enrollment statuses to return with a single request. You
        /// can specify up to 100 statuses to return with each request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnrollmentStatusesForOrganizationInput`](crate::input::GetEnrollmentStatusesForOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEnrollmentStatusesForOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEnrollmentStatusesForOrganizationInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEnrollmentStatusesForOrganizationInputOperationOutputAlias =
    crate::operation::GetEnrollmentStatusesForOrganization;
#[doc(hidden)]
pub type GetEnrollmentStatusesForOrganizationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetEnrollmentStatusesForOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`GetEnrollmentStatusesForOrganization`](crate::operation::GetEnrollmentStatusesForOrganization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEnrollmentStatusesForOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEnrollmentStatusesForOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEnrollmentStatusesForOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEnrollmentStatusesForOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.GetEnrollmentStatusesForOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_enrollment_statuses_for_organization(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEnrollmentStatusesForOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEnrollmentStatusesForOrganization",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEnrollmentStatusesForOrganizationInput`](crate::input::GetEnrollmentStatusesForOrganizationInput)
    pub fn builder() -> crate::input::get_enrollment_statuses_for_organization_input::Builder {
        crate::input::get_enrollment_statuses_for_organization_input::Builder::default()
    }
}

/// See [`GetLambdaFunctionRecommendationsInput`](crate::input::GetLambdaFunctionRecommendationsInput)
pub mod get_lambda_function_recommendations_input {
    /// A builder for [`GetLambdaFunctionRecommendationsInput`](crate::input::GetLambdaFunctionRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::LambdaFunctionRecommendationFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `function_arns`.
        ///
        /// To override the contents of this collection use [`set_function_arns`](Self::set_function_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the functions for which to return
        /// recommendations.</p>
        ///
        /// <p>You can specify a qualified or unqualified ARN. If you specify an unqualified ARN
        /// without a function version suffix, Compute Optimizer will return recommendations for the
        /// latest (<code>$LATEST</code>) version of the function. If you specify a qualified ARN
        /// with a version suffix, Compute Optimizer will return recommendations for the specified
        /// function version. For more information about using function versions, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using">Using
        /// versions</a> in the <i>Lambda Developer
        /// Guide</i>.</p>
        pub fn function_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.function_arns.unwrap_or_default();
            v.push(input.into());
            self.function_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the functions for which to return
        /// recommendations.</p>
        ///
        /// <p>You can specify a qualified or unqualified ARN. If you specify an unqualified ARN
        /// without a function version suffix, Compute Optimizer will return recommendations for the
        /// latest (<code>$LATEST</code>) version of the function. If you specify a qualified ARN
        /// with a version suffix, Compute Optimizer will return recommendations for the specified
        /// function version. For more information about using function versions, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using">Using
        /// versions</a> in the <i>Lambda Developer
        /// Guide</i>.</p>
        pub fn set_function_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.function_arns = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account for which to return function
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to return function recommendations.</p>
        ///
        /// <p>Only one account ID can be specified per request.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The ID of the Amazon Web Services account for which to return function
        /// recommendations.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to return function recommendations.</p>
        ///
        /// <p>Only one account ID can be specified per request.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects to specify a filter that returns a more specific list of function
        /// recommendations.</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::LambdaFunctionRecommendationFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of objects to specify a filter that returns a more specific list of function
        /// recommendations.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LambdaFunctionRecommendationFilter>,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token to advance to the next page of function recommendations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of function recommendations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of function recommendations to return with a single request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of function recommendations to return with a single request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLambdaFunctionRecommendationsInput`](crate::input::GetLambdaFunctionRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLambdaFunctionRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLambdaFunctionRecommendationsInput {
                function_arns: self.function_arns,
                account_ids: self.account_ids,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLambdaFunctionRecommendationsInputOperationOutputAlias =
    crate::operation::GetLambdaFunctionRecommendations;
#[doc(hidden)]
pub type GetLambdaFunctionRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLambdaFunctionRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`GetLambdaFunctionRecommendations`](crate::operation::GetLambdaFunctionRecommendations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLambdaFunctionRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLambdaFunctionRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLambdaFunctionRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLambdaFunctionRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.GetLambdaFunctionRecommendations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_lambda_function_recommendations(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLambdaFunctionRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLambdaFunctionRecommendations",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLambdaFunctionRecommendationsInput`](crate::input::GetLambdaFunctionRecommendationsInput)
    pub fn builder() -> crate::input::get_lambda_function_recommendations_input::Builder {
        crate::input::get_lambda_function_recommendations_input::Builder::default()
    }
}

/// See [`GetRecommendationSummariesInput`](crate::input::GetRecommendationSummariesInput)
pub mod get_recommendation_summaries_input {
    /// A builder for [`GetRecommendationSummariesInput`](crate::input::GetRecommendationSummariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account for which to return recommendation
        /// summaries.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to return recommendation summaries.</p>
        ///
        /// <p>Only one account ID can be specified per request.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The ID of the Amazon Web Services account for which to return recommendation
        /// summaries.</p>
        ///
        /// <p>If your account is the management account of an organization, use this parameter to
        /// specify the member account for which you want to return recommendation summaries.</p>
        ///
        /// <p>Only one account ID can be specified per request.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// <p>The token to advance to the next page of recommendation summaries.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of recommendation summaries.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of recommendation summaries to return with a single request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of recommendation summaries to return with a single request.</p>
        ///
        /// <p>To retrieve the remaining results, make another request with the returned
        /// <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecommendationSummariesInput`](crate::input::GetRecommendationSummariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRecommendationSummariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRecommendationSummariesInput {
                account_ids: self.account_ids,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRecommendationSummariesInputOperationOutputAlias =
    crate::operation::GetRecommendationSummaries;
#[doc(hidden)]
pub type GetRecommendationSummariesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRecommendationSummariesInput {
    /// Consumes the builder and constructs an Operation<[`GetRecommendationSummaries`](crate::operation::GetRecommendationSummaries)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRecommendationSummaries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRecommendationSummariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRecommendationSummariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRecommendationSummariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.GetRecommendationSummaries",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_recommendation_summaries(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRecommendationSummaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRecommendationSummaries",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRecommendationSummariesInput`](crate::input::GetRecommendationSummariesInput)
    pub fn builder() -> crate::input::get_recommendation_summaries_input::Builder {
        crate::input::get_recommendation_summaries_input::Builder::default()
    }
}

/// See [`UpdateEnrollmentStatusInput`](crate::input::UpdateEnrollmentStatusInput)
pub mod update_enrollment_status_input {
    /// A builder for [`UpdateEnrollmentStatusInput`](crate::input::UpdateEnrollmentStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) include_member_accounts: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The new enrollment status of the account.</p>
        ///
        /// <p>The following status options are available:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Active</code> - Opts in your account to the Compute Optimizer service.
        /// Compute Optimizer begins analyzing the configuration and utilization metrics
        /// of your Amazon Web Services resources after you opt in. For more information, see
        /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed by Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Inactive</code> - Opts out your account from the Compute Optimizer
        /// service. Your account's recommendations and related metrics data will be deleted
        /// from Compute Optimizer after you opt out.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The <code>Pending</code> and <code>Failed</code> options cannot be used to update
        /// the enrollment status of an account. They are returned in the response of a request
        /// to update the enrollment status of an account.</p>
        /// </note>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The new enrollment status of the account.</p>
        ///
        /// <p>The following status options are available:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Active</code> - Opts in your account to the Compute Optimizer service.
        /// Compute Optimizer begins analyzing the configuration and utilization metrics
        /// of your Amazon Web Services resources after you opt in. For more information, see
        /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed by Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Inactive</code> - Opts out your account from the Compute Optimizer
        /// service. Your account's recommendations and related metrics data will be deleted
        /// from Compute Optimizer after you opt out.</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The <code>Pending</code> and <code>Failed</code> options cannot be used to update
        /// the enrollment status of an account. They are returned in the response of a request
        /// to update the enrollment status of an account.</p>
        /// </note>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>Indicates whether to enroll member accounts of the organization if the account is the
        /// management account of an organization.</p>
        pub fn include_member_accounts(mut self, input: bool) -> Self {
            self.include_member_accounts = Some(input);
            self
        }
        /// <p>Indicates whether to enroll member accounts of the organization if the account is the
        /// management account of an organization.</p>
        pub fn set_include_member_accounts(mut self, input: std::option::Option<bool>) -> Self {
            self.include_member_accounts = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnrollmentStatusInput`](crate::input::UpdateEnrollmentStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEnrollmentStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEnrollmentStatusInput {
                status: self.status,
                include_member_accounts: self.include_member_accounts.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEnrollmentStatusInputOperationOutputAlias = crate::operation::UpdateEnrollmentStatus;
#[doc(hidden)]
pub type UpdateEnrollmentStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateEnrollmentStatusInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEnrollmentStatus`](crate::operation::UpdateEnrollmentStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEnrollmentStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEnrollmentStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEnrollmentStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEnrollmentStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ComputeOptimizerService.UpdateEnrollmentStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_enrollment_status(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEnrollmentStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEnrollmentStatus",
            "computeoptimizer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEnrollmentStatusInput`](crate::input::UpdateEnrollmentStatusInput)
    pub fn builder() -> crate::input::update_enrollment_status_input::Builder {
        crate::input::update_enrollment_status_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnrollmentStatusInput {
    /// <p>The new enrollment status of the account.</p>
    ///
    /// <p>The following status options are available:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Active</code> - Opts in your account to the Compute Optimizer service.
    /// Compute Optimizer begins analyzing the configuration and utilization metrics
    /// of your Amazon Web Services resources after you opt in. For more information, see
    /// <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed by Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Inactive</code> - Opts out your account from the Compute Optimizer
    /// service. Your account's recommendations and related metrics data will be deleted
    /// from Compute Optimizer after you opt out.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The <code>Pending</code> and <code>Failed</code> options cannot be used to update
    /// the enrollment status of an account. They are returned in the response of a request
    /// to update the enrollment status of an account.</p>
    /// </note>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>Indicates whether to enroll member accounts of the organization if the account is the
    /// management account of an organization.</p>
    pub include_member_accounts: bool,
}
impl std::fmt::Debug for UpdateEnrollmentStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnrollmentStatusInput");
        formatter.field("status", &self.status);
        formatter.field("include_member_accounts", &self.include_member_accounts);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecommendationSummariesInput {
    /// <p>The ID of the Amazon Web Services account for which to return recommendation
    /// summaries.</p>
    ///
    /// <p>If your account is the management account of an organization, use this parameter to
    /// specify the member account for which you want to return recommendation summaries.</p>
    ///
    /// <p>Only one account ID can be specified per request.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to advance to the next page of recommendation summaries.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of recommendation summaries to return with a single request.</p>
    ///
    /// <p>To retrieve the remaining results, make another request with the returned
    /// <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetRecommendationSummariesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecommendationSummariesInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLambdaFunctionRecommendationsInput {
    /// <p>The Amazon Resource Name (ARN) of the functions for which to return
    /// recommendations.</p>
    ///
    /// <p>You can specify a qualified or unqualified ARN. If you specify an unqualified ARN
    /// without a function version suffix, Compute Optimizer will return recommendations for the
    /// latest (<code>$LATEST</code>) version of the function. If you specify a qualified ARN
    /// with a version suffix, Compute Optimizer will return recommendations for the specified
    /// function version. For more information about using function versions, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using">Using
    /// versions</a> in the <i>Lambda Developer
    /// Guide</i>.</p>
    pub function_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the Amazon Web Services account for which to return function
    /// recommendations.</p>
    ///
    /// <p>If your account is the management account of an organization, use this parameter to
    /// specify the member account for which you want to return function recommendations.</p>
    ///
    /// <p>Only one account ID can be specified per request.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of objects to specify a filter that returns a more specific list of function
    /// recommendations.</p>
    pub filters:
        std::option::Option<std::vec::Vec<crate::model::LambdaFunctionRecommendationFilter>>,
    /// <p>The token to advance to the next page of function recommendations.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of function recommendations to return with a single request.</p>
    ///
    /// <p>To retrieve the remaining results, make another request with the returned
    /// <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetLambdaFunctionRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLambdaFunctionRecommendationsInput");
        formatter.field("function_arns", &self.function_arns);
        formatter.field("account_ids", &self.account_ids);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnrollmentStatusesForOrganizationInput {
    /// <p>An array of objects to specify a filter that returns a more specific list of account
    /// enrollment statuses.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::EnrollmentFilter>>,
    /// <p>The token to advance to the next page of account enrollment statuses.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of account enrollment statuses to return with a single request. You
    /// can specify up to 100 statuses to return with each request.</p>
    ///
    /// <p>To retrieve the remaining results, make another request with the returned
    /// <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetEnrollmentStatusesForOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnrollmentStatusesForOrganizationInput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnrollmentStatusInput {}
impl std::fmt::Debug for GetEnrollmentStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnrollmentStatusInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEc2RecommendationProjectedMetricsInput {
    /// <p>The Amazon Resource Name (ARN) of the instances for which to return recommendation
    /// projected metrics.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>The statistic of the projected metrics.</p>
    pub stat: std::option::Option<crate::model::MetricStatistic>,
    /// <p>The granularity, in seconds, of the projected metrics data points.</p>
    pub period: i32,
    /// <p>The timestamp of the first projected metrics data point to return.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of the last projected metrics data point to return.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An object to specify the preferences for the Amazon EC2 recommendation
    /// projected metrics to return in the response.</p>
    pub recommendation_preferences: std::option::Option<crate::model::RecommendationPreferences>,
}
impl std::fmt::Debug for GetEc2RecommendationProjectedMetricsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEc2RecommendationProjectedMetricsInput");
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("stat", &self.stat);
        formatter.field("period", &self.period);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field(
            "recommendation_preferences",
            &self.recommendation_preferences,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEc2InstanceRecommendationsInput {
    /// <p>The Amazon Resource Name (ARN) of the instances for which to return
    /// recommendations.</p>
    pub instance_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to advance to the next page of instance recommendations.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of instance recommendations to return with a single request.</p>
    ///
    /// <p>To retrieve the remaining results, make another request with the returned
    /// <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An array of objects to specify a filter that returns a more specific list of instance
    /// recommendations.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The ID of the Amazon Web Services account for which to return instance
    /// recommendations.</p>
    ///
    /// <p>If your account is the management account of an organization, use this parameter to
    /// specify the member account for which you want to return instance recommendations.</p>
    ///
    /// <p>Only one account ID can be specified per request.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An object to specify the preferences for the Amazon EC2 instance
    /// recommendations to return in the response.</p>
    pub recommendation_preferences: std::option::Option<crate::model::RecommendationPreferences>,
}
impl std::fmt::Debug for GetEc2InstanceRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEc2InstanceRecommendationsInput");
        formatter.field("instance_arns", &self.instance_arns);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.field("account_ids", &self.account_ids);
        formatter.field(
            "recommendation_preferences",
            &self.recommendation_preferences,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEbsVolumeRecommendationsInput {
    /// <p>The Amazon Resource Name (ARN) of the volumes for which to return
    /// recommendations.</p>
    pub volume_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to advance to the next page of volume recommendations.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of volume recommendations to return with a single request.</p>
    ///
    /// <p>To retrieve the remaining results, make another request with the returned
    /// <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An array of objects to specify a filter that returns a more specific list of volume
    /// recommendations.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::EbsFilter>>,
    /// <p>The ID of the Amazon Web Services account for which to return volume
    /// recommendations.</p>
    ///
    /// <p>If your account is the management account of an organization, use this parameter to
    /// specify the member account for which you want to return volume recommendations.</p>
    ///
    /// <p>Only one account ID can be specified per request.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for GetEbsVolumeRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEbsVolumeRecommendationsInput");
        formatter.field("volume_arns", &self.volume_arns);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAutoScalingGroupRecommendationsInput {
    /// <p>The ID of the Amazon Web Services account for which to return Auto Scaling group
    /// recommendations.</p>
    ///
    /// <p>If your account is the management account of an organization, use this parameter to
    /// specify the member account for which you want to return Auto Scaling group
    /// recommendations.</p>
    ///
    /// <p>Only one account ID can be specified per request.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return
    /// recommendations.</p>
    pub auto_scaling_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to advance to the next page of Auto Scaling group
    /// recommendations.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of Auto Scaling group recommendations to return with a single
    /// request.</p>
    ///
    /// <p>To retrieve the remaining results, make another request with the returned
    /// <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An array of objects to specify a filter that returns a more specific list of Auto Scaling group recommendations.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>An object to specify the preferences for the Auto Scaling group recommendations
    /// to return in the response.</p>
    pub recommendation_preferences: std::option::Option<crate::model::RecommendationPreferences>,
}
impl std::fmt::Debug for GetAutoScalingGroupRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAutoScalingGroupRecommendationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("auto_scaling_group_arns", &self.auto_scaling_group_arns);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.field(
            "recommendation_preferences",
            &self.recommendation_preferences,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportLambdaFunctionRecommendationsInput {
    /// <p>The IDs of the Amazon Web Services accounts for which to export Lambda
    /// function recommendations.</p>
    ///
    /// <p>If your account is the management account of an organization, use this parameter to
    /// specify the member account for which you want to export recommendations.</p>
    ///
    /// <p>This parameter cannot be specified together with the include member accounts
    /// parameter. The parameters are mutually exclusive.</p>
    ///
    /// <p>Recommendations for member accounts are not included in the export if this parameter,
    /// or the include member accounts parameter, is omitted.</p>
    ///
    /// <p>You can specify multiple account IDs per request.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of objects to specify a filter that exports a more specific set of Lambda function recommendations.</p>
    pub filters:
        std::option::Option<std::vec::Vec<crate::model::LambdaFunctionRecommendationFilter>>,
    /// <p>The recommendations data to include in the export file. For more information about the
    /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
    /// Guide</i>.</p>
    pub fields_to_export:
        std::option::Option<std::vec::Vec<crate::model::ExportableLambdaFunctionField>>,
    /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
    /// key prefix for a recommendations export job.</p>
    ///
    /// <p>You must create the destination Amazon S3 bucket for your recommendations
    /// export before you create the export job. Compute Optimizer does not create the S3 bucket
    /// for you. After you create the S3 bucket, ensure that it has the required permission
    /// policy to allow Compute Optimizer to write the export file to it. If you plan to specify
    /// an object prefix when you create the export job, you must include the object prefix in
    /// the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
    /// <i>Compute Optimizer User Guide</i>.</p>
    pub s3_destination_config: std::option::Option<crate::model::S3DestinationConfig>,
    /// <p>The format of the export file.</p>
    ///
    /// <p>The only export file format currently supported is <code>Csv</code>.</p>
    pub file_format: std::option::Option<crate::model::FileFormat>,
    /// <p>Indicates whether to include recommendations for resources in all member accounts of
    /// the organization if your account is the management account of an organization.</p>
    ///
    /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
    /// Compute Optimizer must be enabled in the organization account. For more information,
    /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
    /// <i>Compute Optimizer User Guide</i>.</p>
    ///
    /// <p>Recommendations for member accounts of the organization are not included in the export
    /// file if this parameter is omitted.</p>
    ///
    /// <p>This parameter cannot be specified together with the account IDs parameter. The
    /// parameters are mutually exclusive.</p>
    ///
    /// <p>Recommendations for member accounts are not included in the export if this parameter,
    /// or the account IDs parameter, is omitted.</p>
    pub include_member_accounts: bool,
}
impl std::fmt::Debug for ExportLambdaFunctionRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportLambdaFunctionRecommendationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("filters", &self.filters);
        formatter.field("fields_to_export", &self.fields_to_export);
        formatter.field("s3_destination_config", &self.s3_destination_config);
        formatter.field("file_format", &self.file_format);
        formatter.field("include_member_accounts", &self.include_member_accounts);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportEc2InstanceRecommendationsInput {
    /// <p>The IDs of the Amazon Web Services accounts for which to export instance
    /// recommendations.</p>
    ///
    /// <p>If your account is the management account of an organization, use this parameter to
    /// specify the member account for which you want to export recommendations.</p>
    ///
    /// <p>This parameter cannot be specified together with the include member accounts
    /// parameter. The parameters are mutually exclusive.</p>
    ///
    /// <p>Recommendations for member accounts are not included in the export if this parameter,
    /// or the include member accounts parameter, is omitted.</p>
    ///
    /// <p>You can specify multiple account IDs per request.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of objects to specify a filter that exports a more specific set of instance
    /// recommendations.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The recommendations data to include in the export file. For more information about the
    /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
    /// Guide</i>.</p>
    pub fields_to_export: std::option::Option<std::vec::Vec<crate::model::ExportableInstanceField>>,
    /// <p>An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket
    /// name and key prefix for the export job.</p>
    ///
    /// <p>You must create the destination Amazon S3 bucket for your recommendations
    /// export before you create the export job. Compute Optimizer does not create the S3 bucket
    /// for you. After you create the S3 bucket, ensure that it has the required permissions
    /// policy policy to allow Compute Optimizer to write the export file to it. If you plan to
    /// specify an object prefix when you create the export job, you must include the object
    /// prefix in the  that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
    /// <i>Compute Optimizer User Guide</i>.</p>
    pub s3_destination_config: std::option::Option<crate::model::S3DestinationConfig>,
    /// <p>The format of the export file.</p>
    ///
    /// <p>The only export file format currently supported is <code>Csv</code>.</p>
    pub file_format: std::option::Option<crate::model::FileFormat>,
    /// <p>Indicates whether to include recommendations for resources in all member accounts of
    /// the organization if your account is the management account of an organization.</p>
    ///
    /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
    /// Compute Optimizer must be enabled in the organization account. For more information,
    /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
    /// <i>Compute Optimizer User Guide</i>.</p>
    ///
    /// <p>Recommendations for member accounts of the organization are not included in the export
    /// file if this parameter is omitted.</p>
    ///
    /// <p>Recommendations for member accounts are not included in the export if this parameter,
    /// or the account IDs parameter, is omitted.</p>
    pub include_member_accounts: bool,
    /// <p>An object to specify the preferences for the Amazon EC2 instance
    /// recommendations to export.</p>
    pub recommendation_preferences: std::option::Option<crate::model::RecommendationPreferences>,
}
impl std::fmt::Debug for ExportEc2InstanceRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportEc2InstanceRecommendationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("filters", &self.filters);
        formatter.field("fields_to_export", &self.fields_to_export);
        formatter.field("s3_destination_config", &self.s3_destination_config);
        formatter.field("file_format", &self.file_format);
        formatter.field("include_member_accounts", &self.include_member_accounts);
        formatter.field(
            "recommendation_preferences",
            &self.recommendation_preferences,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportEbsVolumeRecommendationsInput {
    /// <p>The IDs of the Amazon Web Services accounts for which to export Amazon EBS
    /// volume recommendations.</p>
    ///
    /// <p>If your account is the management account of an organization, use this parameter to
    /// specify the member account for which you want to export recommendations.</p>
    ///
    /// <p>This parameter cannot be specified together with the include member accounts
    /// parameter. The parameters are mutually exclusive.</p>
    ///
    /// <p>Recommendations for member accounts are not included in the export if this parameter,
    /// or the include member accounts parameter, is omitted.</p>
    ///
    /// <p>You can specify multiple account IDs per request.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of objects to specify a filter that exports a more specific set of Amazon EBS volume recommendations.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::EbsFilter>>,
    /// <p>The recommendations data to include in the export file. For more information about the
    /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
    /// Guide</i>.</p>
    pub fields_to_export: std::option::Option<std::vec::Vec<crate::model::ExportableVolumeField>>,
    /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
    /// key prefix for a recommendations export job.</p>
    ///
    /// <p>You must create the destination Amazon S3 bucket for your recommendations
    /// export before you create the export job. Compute Optimizer does not create the S3 bucket
    /// for you. After you create the S3 bucket, ensure that it has the required permission
    /// policy to allow Compute Optimizer to write the export file to it. If you plan to specify
    /// an object prefix when you create the export job, you must include the object prefix in
    /// the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
    /// <i>Compute Optimizer User Guide</i>.</p>
    pub s3_destination_config: std::option::Option<crate::model::S3DestinationConfig>,
    /// <p>The format of the export file.</p>
    ///
    /// <p>The only export file format currently supported is <code>Csv</code>.</p>
    pub file_format: std::option::Option<crate::model::FileFormat>,
    /// <p>Indicates whether to include recommendations for resources in all member accounts of
    /// the organization if your account is the management account of an organization.</p>
    ///
    /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
    /// Compute Optimizer must be enabled in the organization account. For more information,
    /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
    /// <i>Compute Optimizer User Guide</i>.</p>
    ///
    /// <p>Recommendations for member accounts of the organization are not included in the export
    /// file if this parameter is omitted.</p>
    ///
    /// <p>This parameter cannot be specified together with the account IDs parameter. The
    /// parameters are mutually exclusive.</p>
    ///
    /// <p>Recommendations for member accounts are not included in the export if this parameter,
    /// or the account IDs parameter, is omitted.</p>
    pub include_member_accounts: bool,
}
impl std::fmt::Debug for ExportEbsVolumeRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportEbsVolumeRecommendationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("filters", &self.filters);
        formatter.field("fields_to_export", &self.fields_to_export);
        formatter.field("s3_destination_config", &self.s3_destination_config);
        formatter.field("file_format", &self.file_format);
        formatter.field("include_member_accounts", &self.include_member_accounts);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportAutoScalingGroupRecommendationsInput {
    /// <p>The IDs of the Amazon Web Services accounts for which to export Auto Scaling group
    /// recommendations.</p>
    ///
    /// <p>If your account is the management account of an organization, use this parameter to
    /// specify the member account for which you want to export recommendations.</p>
    ///
    /// <p>This parameter cannot be specified together with the include member accounts
    /// parameter. The parameters are mutually exclusive.</p>
    ///
    /// <p>Recommendations for member accounts are not included in the export if this parameter,
    /// or the include member accounts parameter, is omitted.</p>
    ///
    /// <p>You can specify multiple account IDs per request.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of objects to specify a filter that exports a more specific set of Auto Scaling group recommendations.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The recommendations data to include in the export file. For more information about the
    /// fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User
    /// Guide</i>.</p>
    pub fields_to_export:
        std::option::Option<std::vec::Vec<crate::model::ExportableAutoScalingGroupField>>,
    /// <p>An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket
    /// name and key prefix for the export job.</p>
    ///
    /// <p>You must create the destination Amazon S3 bucket for your recommendations
    /// export before you create the export job. Compute Optimizer does not create the S3 bucket
    /// for you. After you create the S3 bucket, ensure that it has the required permissions
    /// policy  to allow Compute Optimizer to write the export file to it. If you plan to
    /// specify an object prefix when you create the export job, you must include the object
    /// prefix in the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the
    /// <i>Compute Optimizer User Guide</i>.</p>
    pub s3_destination_config: std::option::Option<crate::model::S3DestinationConfig>,
    /// <p>The format of the export file.</p>
    ///
    /// <p>The only export file format currently supported is <code>Csv</code>.</p>
    pub file_format: std::option::Option<crate::model::FileFormat>,
    /// <p>Indicates whether to include recommendations for resources in all member accounts of
    /// the organization if your account is the management account of an organization.</p>
    ///
    /// <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for
    /// Compute Optimizer must be enabled in the organization account. For more information,
    /// see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the
    /// <i>Compute Optimizer User Guide</i>.</p>
    ///
    /// <p>Recommendations for member accounts of the organization are not included in the export
    /// file if this parameter is omitted.</p>
    ///
    /// <p>This parameter cannot be specified together with the account IDs parameter. The
    /// parameters are mutually exclusive.</p>
    ///
    /// <p>Recommendations for member accounts are not included in the export if this parameter,
    /// or the account IDs parameter, is omitted.</p>
    pub include_member_accounts: bool,
    /// <p>An object to specify the preferences for the Auto Scaling group recommendations
    /// to export.</p>
    pub recommendation_preferences: std::option::Option<crate::model::RecommendationPreferences>,
}
impl std::fmt::Debug for ExportAutoScalingGroupRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportAutoScalingGroupRecommendationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("filters", &self.filters);
        formatter.field("fields_to_export", &self.fields_to_export);
        formatter.field("s3_destination_config", &self.s3_destination_config);
        formatter.field("file_format", &self.file_format);
        formatter.field("include_member_accounts", &self.include_member_accounts);
        formatter.field(
            "recommendation_preferences",
            &self.recommendation_preferences,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecommendationExportJobsInput {
    /// <p>The identification numbers of the export jobs to return.</p>
    ///
    /// <p>An export job ID is returned when you create an export using the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions.</p>
    ///
    /// <p>All export jobs created in the last seven days are returned if this parameter is
    /// omitted.</p>
    pub job_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of objects to specify a filter that returns a more specific list of export
    /// jobs.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::JobFilter>>,
    /// <p>The token to advance to the next page of export jobs.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of export jobs to return with a single request.</p>
    ///
    /// <p>To retrieve the remaining results, make another request with the returned
    /// <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribeRecommendationExportJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecommendationExportJobsInput");
        formatter.field("job_ids", &self.job_ids);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
