// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnrollmentStatusOutput {
    /// <p>The enrollment status of the account.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The reason for the enrollment status of the account. For example, an account might
    /// show a status of <code>Pending</code> because member accounts of an organization require
    /// more time to be enrolled in the service.</p>
    pub status_reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateEnrollmentStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnrollmentStatusOutput");
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.finish()
    }
}
/// See [`UpdateEnrollmentStatusOutput`](crate::output::UpdateEnrollmentStatusOutput)
pub mod update_enrollment_status_output {
    /// A builder for [`UpdateEnrollmentStatusOutput`](crate::output::UpdateEnrollmentStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The enrollment status of the account.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The enrollment status of the account.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the enrollment status of the account. For example, an account might
        /// show a status of <code>Pending</code> because member accounts of an organization require
        /// more time to be enrolled in the service.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the enrollment status of the account. For example, an account might
        /// show a status of <code>Pending</code> because member accounts of an organization require
        /// more time to be enrolled in the service.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnrollmentStatusOutput`](crate::output::UpdateEnrollmentStatusOutput)
        pub fn build(self) -> crate::output::UpdateEnrollmentStatusOutput {
            crate::output::UpdateEnrollmentStatusOutput {
                status: self.status,
                status_reason: self.status_reason,
            }
        }
    }
}
impl UpdateEnrollmentStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEnrollmentStatusOutput`](crate::output::UpdateEnrollmentStatusOutput)
    pub fn builder() -> crate::output::update_enrollment_status_output::Builder {
        crate::output::update_enrollment_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecommendationSummariesOutput {
    /// <p>The token to use to advance to the next page of recommendation summaries.</p>
    ///
    /// <p>This value is null when there are no more pages of recommendation summaries to
    /// return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of objects that summarize a recommendation.</p>
    pub recommendation_summaries:
        std::option::Option<std::vec::Vec<crate::model::RecommendationSummary>>,
}
impl std::fmt::Debug for GetRecommendationSummariesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecommendationSummariesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("recommendation_summaries", &self.recommendation_summaries);
        formatter.finish()
    }
}
/// See [`GetRecommendationSummariesOutput`](crate::output::GetRecommendationSummariesOutput)
pub mod get_recommendation_summaries_output {
    /// A builder for [`GetRecommendationSummariesOutput`](crate::output::GetRecommendationSummariesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) recommendation_summaries:
            std::option::Option<std::vec::Vec<crate::model::RecommendationSummary>>,
    }
    impl Builder {
        /// <p>The token to use to advance to the next page of recommendation summaries.</p>
        ///
        /// <p>This value is null when there are no more pages of recommendation summaries to
        /// return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to advance to the next page of recommendation summaries.</p>
        ///
        /// <p>This value is null when there are no more pages of recommendation summaries to
        /// return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `recommendation_summaries`.
        ///
        /// To override the contents of this collection use [`set_recommendation_summaries`](Self::set_recommendation_summaries).
        ///
        /// <p>An array of objects that summarize a recommendation.</p>
        pub fn recommendation_summaries(
            mut self,
            input: impl Into<crate::model::RecommendationSummary>,
        ) -> Self {
            let mut v = self.recommendation_summaries.unwrap_or_default();
            v.push(input.into());
            self.recommendation_summaries = Some(v);
            self
        }
        /// <p>An array of objects that summarize a recommendation.</p>
        pub fn set_recommendation_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationSummary>>,
        ) -> Self {
            self.recommendation_summaries = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecommendationSummariesOutput`](crate::output::GetRecommendationSummariesOutput)
        pub fn build(self) -> crate::output::GetRecommendationSummariesOutput {
            crate::output::GetRecommendationSummariesOutput {
                next_token: self.next_token,
                recommendation_summaries: self.recommendation_summaries,
            }
        }
    }
}
impl GetRecommendationSummariesOutput {
    /// Creates a new builder-style object to manufacture [`GetRecommendationSummariesOutput`](crate::output::GetRecommendationSummariesOutput)
    pub fn builder() -> crate::output::get_recommendation_summaries_output::Builder {
        crate::output::get_recommendation_summaries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLambdaFunctionRecommendationsOutput {
    /// <p>The token to use to advance to the next page of function recommendations.</p>
    ///
    /// <p>This value is null when there are no more pages of function recommendations to
    /// return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of objects that describe function recommendations.</p>
    pub lambda_function_recommendations:
        std::option::Option<std::vec::Vec<crate::model::LambdaFunctionRecommendation>>,
}
impl std::fmt::Debug for GetLambdaFunctionRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLambdaFunctionRecommendationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "lambda_function_recommendations",
            &self.lambda_function_recommendations,
        );
        formatter.finish()
    }
}
/// See [`GetLambdaFunctionRecommendationsOutput`](crate::output::GetLambdaFunctionRecommendationsOutput)
pub mod get_lambda_function_recommendations_output {
    /// A builder for [`GetLambdaFunctionRecommendationsOutput`](crate::output::GetLambdaFunctionRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) lambda_function_recommendations:
            std::option::Option<std::vec::Vec<crate::model::LambdaFunctionRecommendation>>,
    }
    impl Builder {
        /// <p>The token to use to advance to the next page of function recommendations.</p>
        ///
        /// <p>This value is null when there are no more pages of function recommendations to
        /// return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to advance to the next page of function recommendations.</p>
        ///
        /// <p>This value is null when there are no more pages of function recommendations to
        /// return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `lambda_function_recommendations`.
        ///
        /// To override the contents of this collection use [`set_lambda_function_recommendations`](Self::set_lambda_function_recommendations).
        ///
        /// <p>An array of objects that describe function recommendations.</p>
        pub fn lambda_function_recommendations(
            mut self,
            input: impl Into<crate::model::LambdaFunctionRecommendation>,
        ) -> Self {
            let mut v = self.lambda_function_recommendations.unwrap_or_default();
            v.push(input.into());
            self.lambda_function_recommendations = Some(v);
            self
        }
        /// <p>An array of objects that describe function recommendations.</p>
        pub fn set_lambda_function_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LambdaFunctionRecommendation>>,
        ) -> Self {
            self.lambda_function_recommendations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLambdaFunctionRecommendationsOutput`](crate::output::GetLambdaFunctionRecommendationsOutput)
        pub fn build(self) -> crate::output::GetLambdaFunctionRecommendationsOutput {
            crate::output::GetLambdaFunctionRecommendationsOutput {
                next_token: self.next_token,
                lambda_function_recommendations: self.lambda_function_recommendations,
            }
        }
    }
}
impl GetLambdaFunctionRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`GetLambdaFunctionRecommendationsOutput`](crate::output::GetLambdaFunctionRecommendationsOutput)
    pub fn builder() -> crate::output::get_lambda_function_recommendations_output::Builder {
        crate::output::get_lambda_function_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnrollmentStatusesForOrganizationOutput {
    /// <p>An array of objects that describe the enrollment statuses of organization member
    /// accounts.</p>
    pub account_enrollment_statuses:
        std::option::Option<std::vec::Vec<crate::model::AccountEnrollmentStatus>>,
    /// <p>The token to use to advance to the next page of account enrollment statuses.</p>
    ///
    /// <p>This value is null when there are no more pages of account enrollment statuses to
    /// return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetEnrollmentStatusesForOrganizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnrollmentStatusesForOrganizationOutput");
        formatter.field(
            "account_enrollment_statuses",
            &self.account_enrollment_statuses,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetEnrollmentStatusesForOrganizationOutput`](crate::output::GetEnrollmentStatusesForOrganizationOutput)
pub mod get_enrollment_statuses_for_organization_output {
    /// A builder for [`GetEnrollmentStatusesForOrganizationOutput`](crate::output::GetEnrollmentStatusesForOrganizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_enrollment_statuses:
            std::option::Option<std::vec::Vec<crate::model::AccountEnrollmentStatus>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `account_enrollment_statuses`.
        ///
        /// To override the contents of this collection use [`set_account_enrollment_statuses`](Self::set_account_enrollment_statuses).
        ///
        /// <p>An array of objects that describe the enrollment statuses of organization member
        /// accounts.</p>
        pub fn account_enrollment_statuses(
            mut self,
            input: impl Into<crate::model::AccountEnrollmentStatus>,
        ) -> Self {
            let mut v = self.account_enrollment_statuses.unwrap_or_default();
            v.push(input.into());
            self.account_enrollment_statuses = Some(v);
            self
        }
        /// <p>An array of objects that describe the enrollment statuses of organization member
        /// accounts.</p>
        pub fn set_account_enrollment_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountEnrollmentStatus>>,
        ) -> Self {
            self.account_enrollment_statuses = input;
            self
        }
        /// <p>The token to use to advance to the next page of account enrollment statuses.</p>
        ///
        /// <p>This value is null when there are no more pages of account enrollment statuses to
        /// return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to advance to the next page of account enrollment statuses.</p>
        ///
        /// <p>This value is null when there are no more pages of account enrollment statuses to
        /// return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnrollmentStatusesForOrganizationOutput`](crate::output::GetEnrollmentStatusesForOrganizationOutput)
        pub fn build(self) -> crate::output::GetEnrollmentStatusesForOrganizationOutput {
            crate::output::GetEnrollmentStatusesForOrganizationOutput {
                account_enrollment_statuses: self.account_enrollment_statuses,
                next_token: self.next_token,
            }
        }
    }
}
impl GetEnrollmentStatusesForOrganizationOutput {
    /// Creates a new builder-style object to manufacture [`GetEnrollmentStatusesForOrganizationOutput`](crate::output::GetEnrollmentStatusesForOrganizationOutput)
    pub fn builder() -> crate::output::get_enrollment_statuses_for_organization_output::Builder {
        crate::output::get_enrollment_statuses_for_organization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnrollmentStatusOutput {
    /// <p>The enrollment status of the account.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The reason for the enrollment status of the account.</p>
    ///
    /// <p>For example, an account might show a status of <code>Pending</code> because member
    /// accounts of an organization require more time to be enrolled in the service.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>Confirms the enrollment status of member accounts of the organization, if the account
    /// is a management account of an organization.</p>
    pub member_accounts_enrolled: bool,
    /// <p>The Unix epoch timestamp, in seconds, of when the account enrollment status was last
    /// updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The count of organization member accounts that are opted in to the service, if your
    /// account is an organization management account.</p>
    pub number_of_member_accounts_opted_in: std::option::Option<i32>,
}
impl std::fmt::Debug for GetEnrollmentStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnrollmentStatusOutput");
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("member_accounts_enrolled", &self.member_accounts_enrolled);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field(
            "number_of_member_accounts_opted_in",
            &self.number_of_member_accounts_opted_in,
        );
        formatter.finish()
    }
}
/// See [`GetEnrollmentStatusOutput`](crate::output::GetEnrollmentStatusOutput)
pub mod get_enrollment_status_output {
    /// A builder for [`GetEnrollmentStatusOutput`](crate::output::GetEnrollmentStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) member_accounts_enrolled: std::option::Option<bool>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) number_of_member_accounts_opted_in: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The enrollment status of the account.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The enrollment status of the account.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the enrollment status of the account.</p>
        ///
        /// <p>For example, an account might show a status of <code>Pending</code> because member
        /// accounts of an organization require more time to be enrolled in the service.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the enrollment status of the account.</p>
        ///
        /// <p>For example, an account might show a status of <code>Pending</code> because member
        /// accounts of an organization require more time to be enrolled in the service.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>Confirms the enrollment status of member accounts of the organization, if the account
        /// is a management account of an organization.</p>
        pub fn member_accounts_enrolled(mut self, input: bool) -> Self {
            self.member_accounts_enrolled = Some(input);
            self
        }
        /// <p>Confirms the enrollment status of member accounts of the organization, if the account
        /// is a management account of an organization.</p>
        pub fn set_member_accounts_enrolled(mut self, input: std::option::Option<bool>) -> Self {
            self.member_accounts_enrolled = input;
            self
        }
        /// <p>The Unix epoch timestamp, in seconds, of when the account enrollment status was last
        /// updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp, in seconds, of when the account enrollment status was last
        /// updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>The count of organization member accounts that are opted in to the service, if your
        /// account is an organization management account.</p>
        pub fn number_of_member_accounts_opted_in(mut self, input: i32) -> Self {
            self.number_of_member_accounts_opted_in = Some(input);
            self
        }
        /// <p>The count of organization member accounts that are opted in to the service, if your
        /// account is an organization management account.</p>
        pub fn set_number_of_member_accounts_opted_in(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_member_accounts_opted_in = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnrollmentStatusOutput`](crate::output::GetEnrollmentStatusOutput)
        pub fn build(self) -> crate::output::GetEnrollmentStatusOutput {
            crate::output::GetEnrollmentStatusOutput {
                status: self.status,
                status_reason: self.status_reason,
                member_accounts_enrolled: self.member_accounts_enrolled.unwrap_or_default(),
                last_updated_timestamp: self.last_updated_timestamp,
                number_of_member_accounts_opted_in: self.number_of_member_accounts_opted_in,
            }
        }
    }
}
impl GetEnrollmentStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetEnrollmentStatusOutput`](crate::output::GetEnrollmentStatusOutput)
    pub fn builder() -> crate::output::get_enrollment_status_output::Builder {
        crate::output::get_enrollment_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEc2RecommendationProjectedMetricsOutput {
    /// <p>An array of objects that describes projected metrics.</p>
    pub recommended_option_projected_metrics:
        std::option::Option<std::vec::Vec<crate::model::RecommendedOptionProjectedMetric>>,
}
impl std::fmt::Debug for GetEc2RecommendationProjectedMetricsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEc2RecommendationProjectedMetricsOutput");
        formatter.field(
            "recommended_option_projected_metrics",
            &self.recommended_option_projected_metrics,
        );
        formatter.finish()
    }
}
/// See [`GetEc2RecommendationProjectedMetricsOutput`](crate::output::GetEc2RecommendationProjectedMetricsOutput)
pub mod get_ec2_recommendation_projected_metrics_output {
    /// A builder for [`GetEc2RecommendationProjectedMetricsOutput`](crate::output::GetEc2RecommendationProjectedMetricsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommended_option_projected_metrics:
            std::option::Option<std::vec::Vec<crate::model::RecommendedOptionProjectedMetric>>,
    }
    impl Builder {
        /// Appends an item to `recommended_option_projected_metrics`.
        ///
        /// To override the contents of this collection use [`set_recommended_option_projected_metrics`](Self::set_recommended_option_projected_metrics).
        ///
        /// <p>An array of objects that describes projected metrics.</p>
        pub fn recommended_option_projected_metrics(
            mut self,
            input: impl Into<crate::model::RecommendedOptionProjectedMetric>,
        ) -> Self {
            let mut v = self
                .recommended_option_projected_metrics
                .unwrap_or_default();
            v.push(input.into());
            self.recommended_option_projected_metrics = Some(v);
            self
        }
        /// <p>An array of objects that describes projected metrics.</p>
        pub fn set_recommended_option_projected_metrics(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RecommendedOptionProjectedMetric>,
            >,
        ) -> Self {
            self.recommended_option_projected_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEc2RecommendationProjectedMetricsOutput`](crate::output::GetEc2RecommendationProjectedMetricsOutput)
        pub fn build(self) -> crate::output::GetEc2RecommendationProjectedMetricsOutput {
            crate::output::GetEc2RecommendationProjectedMetricsOutput {
                recommended_option_projected_metrics: self.recommended_option_projected_metrics,
            }
        }
    }
}
impl GetEc2RecommendationProjectedMetricsOutput {
    /// Creates a new builder-style object to manufacture [`GetEc2RecommendationProjectedMetricsOutput`](crate::output::GetEc2RecommendationProjectedMetricsOutput)
    pub fn builder() -> crate::output::get_ec2_recommendation_projected_metrics_output::Builder {
        crate::output::get_ec2_recommendation_projected_metrics_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEc2InstanceRecommendationsOutput {
    /// <p>The token to use to advance to the next page of instance recommendations.</p>
    ///
    /// <p>This value is null when there are no more pages of instance recommendations to
    /// return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of objects that describe instance recommendations.</p>
    pub instance_recommendations:
        std::option::Option<std::vec::Vec<crate::model::InstanceRecommendation>>,
    /// <p>An array of objects that describe errors of the request.</p>
    ///
    /// <p>For example, an error is returned if you request recommendations for an instance of an
    /// unsupported instance family.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::GetRecommendationError>>,
}
impl std::fmt::Debug for GetEc2InstanceRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEc2InstanceRecommendationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("instance_recommendations", &self.instance_recommendations);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`GetEc2InstanceRecommendationsOutput`](crate::output::GetEc2InstanceRecommendationsOutput)
pub mod get_ec2_instance_recommendations_output {
    /// A builder for [`GetEc2InstanceRecommendationsOutput`](crate::output::GetEc2InstanceRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) instance_recommendations:
            std::option::Option<std::vec::Vec<crate::model::InstanceRecommendation>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::GetRecommendationError>>,
    }
    impl Builder {
        /// <p>The token to use to advance to the next page of instance recommendations.</p>
        ///
        /// <p>This value is null when there are no more pages of instance recommendations to
        /// return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to advance to the next page of instance recommendations.</p>
        ///
        /// <p>This value is null when there are no more pages of instance recommendations to
        /// return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `instance_recommendations`.
        ///
        /// To override the contents of this collection use [`set_instance_recommendations`](Self::set_instance_recommendations).
        ///
        /// <p>An array of objects that describe instance recommendations.</p>
        pub fn instance_recommendations(
            mut self,
            input: impl Into<crate::model::InstanceRecommendation>,
        ) -> Self {
            let mut v = self.instance_recommendations.unwrap_or_default();
            v.push(input.into());
            self.instance_recommendations = Some(v);
            self
        }
        /// <p>An array of objects that describe instance recommendations.</p>
        pub fn set_instance_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceRecommendation>>,
        ) -> Self {
            self.instance_recommendations = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>An array of objects that describe errors of the request.</p>
        ///
        /// <p>For example, an error is returned if you request recommendations for an instance of an
        /// unsupported instance family.</p>
        pub fn errors(mut self, input: impl Into<crate::model::GetRecommendationError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>An array of objects that describe errors of the request.</p>
        ///
        /// <p>For example, an error is returned if you request recommendations for an instance of an
        /// unsupported instance family.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GetRecommendationError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEc2InstanceRecommendationsOutput`](crate::output::GetEc2InstanceRecommendationsOutput)
        pub fn build(self) -> crate::output::GetEc2InstanceRecommendationsOutput {
            crate::output::GetEc2InstanceRecommendationsOutput {
                next_token: self.next_token,
                instance_recommendations: self.instance_recommendations,
                errors: self.errors,
            }
        }
    }
}
impl GetEc2InstanceRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`GetEc2InstanceRecommendationsOutput`](crate::output::GetEc2InstanceRecommendationsOutput)
    pub fn builder() -> crate::output::get_ec2_instance_recommendations_output::Builder {
        crate::output::get_ec2_instance_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEbsVolumeRecommendationsOutput {
    /// <p>The token to use to advance to the next page of volume recommendations.</p>
    ///
    /// <p>This value is null when there are no more pages of volume recommendations to
    /// return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of objects that describe volume recommendations.</p>
    pub volume_recommendations:
        std::option::Option<std::vec::Vec<crate::model::VolumeRecommendation>>,
    /// <p>An array of objects that describe errors of the request.</p>
    ///
    /// <p>For example, an error is returned if you request recommendations for an unsupported
    /// volume.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::GetRecommendationError>>,
}
impl std::fmt::Debug for GetEbsVolumeRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEbsVolumeRecommendationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("volume_recommendations", &self.volume_recommendations);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`GetEbsVolumeRecommendationsOutput`](crate::output::GetEbsVolumeRecommendationsOutput)
pub mod get_ebs_volume_recommendations_output {
    /// A builder for [`GetEbsVolumeRecommendationsOutput`](crate::output::GetEbsVolumeRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) volume_recommendations:
            std::option::Option<std::vec::Vec<crate::model::VolumeRecommendation>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::GetRecommendationError>>,
    }
    impl Builder {
        /// <p>The token to use to advance to the next page of volume recommendations.</p>
        ///
        /// <p>This value is null when there are no more pages of volume recommendations to
        /// return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to advance to the next page of volume recommendations.</p>
        ///
        /// <p>This value is null when there are no more pages of volume recommendations to
        /// return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `volume_recommendations`.
        ///
        /// To override the contents of this collection use [`set_volume_recommendations`](Self::set_volume_recommendations).
        ///
        /// <p>An array of objects that describe volume recommendations.</p>
        pub fn volume_recommendations(
            mut self,
            input: impl Into<crate::model::VolumeRecommendation>,
        ) -> Self {
            let mut v = self.volume_recommendations.unwrap_or_default();
            v.push(input.into());
            self.volume_recommendations = Some(v);
            self
        }
        /// <p>An array of objects that describe volume recommendations.</p>
        pub fn set_volume_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VolumeRecommendation>>,
        ) -> Self {
            self.volume_recommendations = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>An array of objects that describe errors of the request.</p>
        ///
        /// <p>For example, an error is returned if you request recommendations for an unsupported
        /// volume.</p>
        pub fn errors(mut self, input: impl Into<crate::model::GetRecommendationError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>An array of objects that describe errors of the request.</p>
        ///
        /// <p>For example, an error is returned if you request recommendations for an unsupported
        /// volume.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GetRecommendationError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEbsVolumeRecommendationsOutput`](crate::output::GetEbsVolumeRecommendationsOutput)
        pub fn build(self) -> crate::output::GetEbsVolumeRecommendationsOutput {
            crate::output::GetEbsVolumeRecommendationsOutput {
                next_token: self.next_token,
                volume_recommendations: self.volume_recommendations,
                errors: self.errors,
            }
        }
    }
}
impl GetEbsVolumeRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`GetEbsVolumeRecommendationsOutput`](crate::output::GetEbsVolumeRecommendationsOutput)
    pub fn builder() -> crate::output::get_ebs_volume_recommendations_output::Builder {
        crate::output::get_ebs_volume_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAutoScalingGroupRecommendationsOutput {
    /// <p>The token to use to advance to the next page of Auto Scaling group
    /// recommendations.</p>
    ///
    /// <p>This value is null when there are no more pages of Auto Scaling group
    /// recommendations to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of objects that describe Auto Scaling group recommendations.</p>
    pub auto_scaling_group_recommendations:
        std::option::Option<std::vec::Vec<crate::model::AutoScalingGroupRecommendation>>,
    /// <p>An array of objects that describe errors of the request.</p>
    ///
    /// <p>For example, an error is returned if you request recommendations for an unsupported
    /// Auto Scaling group.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::GetRecommendationError>>,
}
impl std::fmt::Debug for GetAutoScalingGroupRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAutoScalingGroupRecommendationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "auto_scaling_group_recommendations",
            &self.auto_scaling_group_recommendations,
        );
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`GetAutoScalingGroupRecommendationsOutput`](crate::output::GetAutoScalingGroupRecommendationsOutput)
pub mod get_auto_scaling_group_recommendations_output {
    /// A builder for [`GetAutoScalingGroupRecommendationsOutput`](crate::output::GetAutoScalingGroupRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_recommendations:
            std::option::Option<std::vec::Vec<crate::model::AutoScalingGroupRecommendation>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::GetRecommendationError>>,
    }
    impl Builder {
        /// <p>The token to use to advance to the next page of Auto Scaling group
        /// recommendations.</p>
        ///
        /// <p>This value is null when there are no more pages of Auto Scaling group
        /// recommendations to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to advance to the next page of Auto Scaling group
        /// recommendations.</p>
        ///
        /// <p>This value is null when there are no more pages of Auto Scaling group
        /// recommendations to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `auto_scaling_group_recommendations`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_group_recommendations`](Self::set_auto_scaling_group_recommendations).
        ///
        /// <p>An array of objects that describe Auto Scaling group recommendations.</p>
        pub fn auto_scaling_group_recommendations(
            mut self,
            input: impl Into<crate::model::AutoScalingGroupRecommendation>,
        ) -> Self {
            let mut v = self.auto_scaling_group_recommendations.unwrap_or_default();
            v.push(input.into());
            self.auto_scaling_group_recommendations = Some(v);
            self
        }
        /// <p>An array of objects that describe Auto Scaling group recommendations.</p>
        pub fn set_auto_scaling_group_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoScalingGroupRecommendation>>,
        ) -> Self {
            self.auto_scaling_group_recommendations = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>An array of objects that describe errors of the request.</p>
        ///
        /// <p>For example, an error is returned if you request recommendations for an unsupported
        /// Auto Scaling group.</p>
        pub fn errors(mut self, input: impl Into<crate::model::GetRecommendationError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>An array of objects that describe errors of the request.</p>
        ///
        /// <p>For example, an error is returned if you request recommendations for an unsupported
        /// Auto Scaling group.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GetRecommendationError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAutoScalingGroupRecommendationsOutput`](crate::output::GetAutoScalingGroupRecommendationsOutput)
        pub fn build(self) -> crate::output::GetAutoScalingGroupRecommendationsOutput {
            crate::output::GetAutoScalingGroupRecommendationsOutput {
                next_token: self.next_token,
                auto_scaling_group_recommendations: self.auto_scaling_group_recommendations,
                errors: self.errors,
            }
        }
    }
}
impl GetAutoScalingGroupRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`GetAutoScalingGroupRecommendationsOutput`](crate::output::GetAutoScalingGroupRecommendationsOutput)
    pub fn builder() -> crate::output::get_auto_scaling_group_recommendations_output::Builder {
        crate::output::get_auto_scaling_group_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportLambdaFunctionRecommendationsOutput {
    /// <p>The identification number of the export job.</p>
    ///
    /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
    /// ID to view the status of an export job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
    /// object keys of a recommendations export file, and its associated metadata file.</p>
    pub s3_destination: std::option::Option<crate::model::S3Destination>,
}
impl std::fmt::Debug for ExportLambdaFunctionRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportLambdaFunctionRecommendationsOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("s3_destination", &self.s3_destination);
        formatter.finish()
    }
}
/// See [`ExportLambdaFunctionRecommendationsOutput`](crate::output::ExportLambdaFunctionRecommendationsOutput)
pub mod export_lambda_function_recommendations_output {
    /// A builder for [`ExportLambdaFunctionRecommendationsOutput`](crate::output::ExportLambdaFunctionRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) s3_destination: std::option::Option<crate::model::S3Destination>,
    }
    impl Builder {
        /// <p>The identification number of the export job.</p>
        ///
        /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
        /// ID to view the status of an export job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identification number of the export job.</p>
        ///
        /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
        /// ID to view the status of an export job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
        /// object keys of a recommendations export file, and its associated metadata file.</p>
        pub fn s3_destination(mut self, input: crate::model::S3Destination) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
        /// object keys of a recommendations export file, and its associated metadata file.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportLambdaFunctionRecommendationsOutput`](crate::output::ExportLambdaFunctionRecommendationsOutput)
        pub fn build(self) -> crate::output::ExportLambdaFunctionRecommendationsOutput {
            crate::output::ExportLambdaFunctionRecommendationsOutput {
                job_id: self.job_id,
                s3_destination: self.s3_destination,
            }
        }
    }
}
impl ExportLambdaFunctionRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`ExportLambdaFunctionRecommendationsOutput`](crate::output::ExportLambdaFunctionRecommendationsOutput)
    pub fn builder() -> crate::output::export_lambda_function_recommendations_output::Builder {
        crate::output::export_lambda_function_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportEc2InstanceRecommendationsOutput {
    /// <p>The identification number of the export job.</p>
    ///
    /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
    /// ID to view the status of an export job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>An object that describes the destination Amazon S3 bucket of a recommendations
    /// export file.</p>
    pub s3_destination: std::option::Option<crate::model::S3Destination>,
}
impl std::fmt::Debug for ExportEc2InstanceRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportEc2InstanceRecommendationsOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("s3_destination", &self.s3_destination);
        formatter.finish()
    }
}
/// See [`ExportEc2InstanceRecommendationsOutput`](crate::output::ExportEc2InstanceRecommendationsOutput)
pub mod export_ec2_instance_recommendations_output {
    /// A builder for [`ExportEc2InstanceRecommendationsOutput`](crate::output::ExportEc2InstanceRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) s3_destination: std::option::Option<crate::model::S3Destination>,
    }
    impl Builder {
        /// <p>The identification number of the export job.</p>
        ///
        /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
        /// ID to view the status of an export job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identification number of the export job.</p>
        ///
        /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
        /// ID to view the status of an export job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>An object that describes the destination Amazon S3 bucket of a recommendations
        /// export file.</p>
        pub fn s3_destination(mut self, input: crate::model::S3Destination) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p>An object that describes the destination Amazon S3 bucket of a recommendations
        /// export file.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportEc2InstanceRecommendationsOutput`](crate::output::ExportEc2InstanceRecommendationsOutput)
        pub fn build(self) -> crate::output::ExportEc2InstanceRecommendationsOutput {
            crate::output::ExportEc2InstanceRecommendationsOutput {
                job_id: self.job_id,
                s3_destination: self.s3_destination,
            }
        }
    }
}
impl ExportEc2InstanceRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`ExportEc2InstanceRecommendationsOutput`](crate::output::ExportEc2InstanceRecommendationsOutput)
    pub fn builder() -> crate::output::export_ec2_instance_recommendations_output::Builder {
        crate::output::export_ec2_instance_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportEbsVolumeRecommendationsOutput {
    /// <p>The identification number of the export job.</p>
    ///
    /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
    /// ID to view the status of an export job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
    /// object keys of a recommendations export file, and its associated metadata file.</p>
    pub s3_destination: std::option::Option<crate::model::S3Destination>,
}
impl std::fmt::Debug for ExportEbsVolumeRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportEbsVolumeRecommendationsOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("s3_destination", &self.s3_destination);
        formatter.finish()
    }
}
/// See [`ExportEbsVolumeRecommendationsOutput`](crate::output::ExportEbsVolumeRecommendationsOutput)
pub mod export_ebs_volume_recommendations_output {
    /// A builder for [`ExportEbsVolumeRecommendationsOutput`](crate::output::ExportEbsVolumeRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) s3_destination: std::option::Option<crate::model::S3Destination>,
    }
    impl Builder {
        /// <p>The identification number of the export job.</p>
        ///
        /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
        /// ID to view the status of an export job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identification number of the export job.</p>
        ///
        /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
        /// ID to view the status of an export job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
        /// object keys of a recommendations export file, and its associated metadata file.</p>
        pub fn s3_destination(mut self, input: crate::model::S3Destination) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
        /// object keys of a recommendations export file, and its associated metadata file.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportEbsVolumeRecommendationsOutput`](crate::output::ExportEbsVolumeRecommendationsOutput)
        pub fn build(self) -> crate::output::ExportEbsVolumeRecommendationsOutput {
            crate::output::ExportEbsVolumeRecommendationsOutput {
                job_id: self.job_id,
                s3_destination: self.s3_destination,
            }
        }
    }
}
impl ExportEbsVolumeRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`ExportEbsVolumeRecommendationsOutput`](crate::output::ExportEbsVolumeRecommendationsOutput)
    pub fn builder() -> crate::output::export_ebs_volume_recommendations_output::Builder {
        crate::output::export_ebs_volume_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportAutoScalingGroupRecommendationsOutput {
    /// <p>The identification number of the export job.</p>
    ///
    /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
    /// ID to view the status of an export job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>An object that describes the destination Amazon S3 bucket of a recommendations
    /// export file.</p>
    pub s3_destination: std::option::Option<crate::model::S3Destination>,
}
impl std::fmt::Debug for ExportAutoScalingGroupRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportAutoScalingGroupRecommendationsOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("s3_destination", &self.s3_destination);
        formatter.finish()
    }
}
/// See [`ExportAutoScalingGroupRecommendationsOutput`](crate::output::ExportAutoScalingGroupRecommendationsOutput)
pub mod export_auto_scaling_group_recommendations_output {
    /// A builder for [`ExportAutoScalingGroupRecommendationsOutput`](crate::output::ExportAutoScalingGroupRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) s3_destination: std::option::Option<crate::model::S3Destination>,
    }
    impl Builder {
        /// <p>The identification number of the export job.</p>
        ///
        /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
        /// ID to view the status of an export job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identification number of the export job.</p>
        ///
        /// <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job
        /// ID to view the status of an export job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>An object that describes the destination Amazon S3 bucket of a recommendations
        /// export file.</p>
        pub fn s3_destination(mut self, input: crate::model::S3Destination) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p>An object that describes the destination Amazon S3 bucket of a recommendations
        /// export file.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportAutoScalingGroupRecommendationsOutput`](crate::output::ExportAutoScalingGroupRecommendationsOutput)
        pub fn build(self) -> crate::output::ExportAutoScalingGroupRecommendationsOutput {
            crate::output::ExportAutoScalingGroupRecommendationsOutput {
                job_id: self.job_id,
                s3_destination: self.s3_destination,
            }
        }
    }
}
impl ExportAutoScalingGroupRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`ExportAutoScalingGroupRecommendationsOutput`](crate::output::ExportAutoScalingGroupRecommendationsOutput)
    pub fn builder() -> crate::output::export_auto_scaling_group_recommendations_output::Builder {
        crate::output::export_auto_scaling_group_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecommendationExportJobsOutput {
    /// <p>An array of objects that describe recommendation export jobs.</p>
    pub recommendation_export_jobs:
        std::option::Option<std::vec::Vec<crate::model::RecommendationExportJob>>,
    /// <p>The token to use to advance to the next page of export jobs.</p>
    ///
    /// <p>This value is null when there are no more pages of export jobs to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeRecommendationExportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecommendationExportJobsOutput");
        formatter.field(
            "recommendation_export_jobs",
            &self.recommendation_export_jobs,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeRecommendationExportJobsOutput`](crate::output::DescribeRecommendationExportJobsOutput)
pub mod describe_recommendation_export_jobs_output {
    /// A builder for [`DescribeRecommendationExportJobsOutput`](crate::output::DescribeRecommendationExportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_export_jobs:
            std::option::Option<std::vec::Vec<crate::model::RecommendationExportJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `recommendation_export_jobs`.
        ///
        /// To override the contents of this collection use [`set_recommendation_export_jobs`](Self::set_recommendation_export_jobs).
        ///
        /// <p>An array of objects that describe recommendation export jobs.</p>
        pub fn recommendation_export_jobs(
            mut self,
            input: impl Into<crate::model::RecommendationExportJob>,
        ) -> Self {
            let mut v = self.recommendation_export_jobs.unwrap_or_default();
            v.push(input.into());
            self.recommendation_export_jobs = Some(v);
            self
        }
        /// <p>An array of objects that describe recommendation export jobs.</p>
        pub fn set_recommendation_export_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationExportJob>>,
        ) -> Self {
            self.recommendation_export_jobs = input;
            self
        }
        /// <p>The token to use to advance to the next page of export jobs.</p>
        ///
        /// <p>This value is null when there are no more pages of export jobs to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to advance to the next page of export jobs.</p>
        ///
        /// <p>This value is null when there are no more pages of export jobs to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecommendationExportJobsOutput`](crate::output::DescribeRecommendationExportJobsOutput)
        pub fn build(self) -> crate::output::DescribeRecommendationExportJobsOutput {
            crate::output::DescribeRecommendationExportJobsOutput {
                recommendation_export_jobs: self.recommendation_export_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeRecommendationExportJobsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRecommendationExportJobsOutput`](crate::output::DescribeRecommendationExportJobsOutput)
    pub fn builder() -> crate::output::describe_recommendation_export_jobs_output::Builder {
        crate::output::describe_recommendation_export_jobs_output::Builder::default()
    }
}
