// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_detect_dominant_language_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDetectDominantLanguageOutput,
    crate::error::BatchDetectDominantLanguageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDetectDominantLanguageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::BatchDetectDominantLanguageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BatchSizeLimitExceededException" => crate::error::BatchDetectDominantLanguageError {
            meta: generic,
            kind:
                crate::error::BatchDetectDominantLanguageErrorKind::BatchSizeLimitExceededException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::batch_size_limit_exceeded_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_batch_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectDominantLanguageError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalServerException" => crate::error::BatchDetectDominantLanguageError {
            meta: generic,
            kind: crate::error::BatchDetectDominantLanguageErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectDominantLanguageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::BatchDetectDominantLanguageError {
            meta: generic,
            kind: crate::error::BatchDetectDominantLanguageErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectDominantLanguageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::BatchDetectDominantLanguageError {
            meta: generic,
            kind:
                crate::error::BatchDetectDominantLanguageErrorKind::TextSizeLimitExceededException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::text_size_limit_exceeded_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectDominantLanguageError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::BatchDetectDominantLanguageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_detect_dominant_language_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDetectDominantLanguageOutput,
    crate::error::BatchDetectDominantLanguageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_detect_dominant_language_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_detect_dominant_language(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchDetectDominantLanguageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_detect_entities_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDetectEntitiesOutput,
    crate::error::BatchDetectEntitiesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDetectEntitiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchDetectEntitiesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BatchSizeLimitExceededException" => crate::error::BatchDetectEntitiesError {
            meta: generic,
            kind: crate::error::BatchDetectEntitiesErrorKind::BatchSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::batch_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_batch_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::BatchDetectEntitiesError {
            meta: generic,
            kind: crate::error::BatchDetectEntitiesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::BatchDetectEntitiesError {
            meta: generic,
            kind: crate::error::BatchDetectEntitiesErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::BatchDetectEntitiesError {
            meta: generic,
            kind: crate::error::BatchDetectEntitiesErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::BatchDetectEntitiesError {
            meta: generic,
            kind: crate::error::BatchDetectEntitiesErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BatchDetectEntitiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_detect_entities_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDetectEntitiesOutput,
    crate::error::BatchDetectEntitiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_detect_entities_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_detect_entities(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchDetectEntitiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_detect_key_phrases_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDetectKeyPhrasesOutput,
    crate::error::BatchDetectKeyPhrasesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDetectKeyPhrasesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchDetectKeyPhrasesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BatchSizeLimitExceededException" => crate::error::BatchDetectKeyPhrasesError {
            meta: generic,
            kind: crate::error::BatchDetectKeyPhrasesErrorKind::BatchSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::batch_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_batch_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectKeyPhrasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::BatchDetectKeyPhrasesError {
            meta: generic,
            kind: crate::error::BatchDetectKeyPhrasesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectKeyPhrasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::BatchDetectKeyPhrasesError {
            meta: generic,
            kind: crate::error::BatchDetectKeyPhrasesErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectKeyPhrasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::BatchDetectKeyPhrasesError {
            meta: generic,
            kind: crate::error::BatchDetectKeyPhrasesErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectKeyPhrasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::BatchDetectKeyPhrasesError {
            meta: generic,
            kind: crate::error::BatchDetectKeyPhrasesErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectKeyPhrasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BatchDetectKeyPhrasesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_detect_key_phrases_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDetectKeyPhrasesOutput,
    crate::error::BatchDetectKeyPhrasesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_detect_key_phrases_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_detect_key_phrases(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchDetectKeyPhrasesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_detect_sentiment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDetectSentimentOutput,
    crate::error::BatchDetectSentimentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDetectSentimentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchDetectSentimentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BatchSizeLimitExceededException" => crate::error::BatchDetectSentimentError {
            meta: generic,
            kind: crate::error::BatchDetectSentimentErrorKind::BatchSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::batch_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_batch_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectSentimentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::BatchDetectSentimentError {
            meta: generic,
            kind: crate::error::BatchDetectSentimentErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectSentimentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::BatchDetectSentimentError {
            meta: generic,
            kind: crate::error::BatchDetectSentimentErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectSentimentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::BatchDetectSentimentError {
            meta: generic,
            kind: crate::error::BatchDetectSentimentErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectSentimentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::BatchDetectSentimentError {
            meta: generic,
            kind: crate::error::BatchDetectSentimentErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectSentimentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BatchDetectSentimentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_detect_sentiment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDetectSentimentOutput,
    crate::error::BatchDetectSentimentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_detect_sentiment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_detect_sentiment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchDetectSentimentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_detect_syntax_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BatchDetectSyntaxOutput, crate::error::BatchDetectSyntaxError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDetectSyntaxError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchDetectSyntaxError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BatchSizeLimitExceededException" => crate::error::BatchDetectSyntaxError {
            meta: generic,
            kind: crate::error::BatchDetectSyntaxErrorKind::BatchSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::batch_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_batch_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectSyntaxError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::BatchDetectSyntaxError {
            meta: generic,
            kind: crate::error::BatchDetectSyntaxErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectSyntaxError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::BatchDetectSyntaxError {
            meta: generic,
            kind: crate::error::BatchDetectSyntaxErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectSyntaxError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::BatchDetectSyntaxError {
            meta: generic,
            kind: crate::error::BatchDetectSyntaxErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectSyntaxError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::BatchDetectSyntaxError {
            meta: generic,
            kind: crate::error::BatchDetectSyntaxErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDetectSyntaxError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BatchDetectSyntaxError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_detect_syntax_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BatchDetectSyntaxOutput, crate::error::BatchDetectSyntaxError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_detect_syntax_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_detect_syntax(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchDetectSyntaxError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_classify_document_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ClassifyDocumentOutput, crate::error::ClassifyDocumentError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ClassifyDocumentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ClassifyDocumentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ClassifyDocumentError {
            meta: generic,
            kind: crate::error::ClassifyDocumentErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ClassifyDocumentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ClassifyDocumentError {
            meta: generic,
            kind: crate::error::ClassifyDocumentErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ClassifyDocumentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::ClassifyDocumentError {
            meta: generic,
            kind: crate::error::ClassifyDocumentErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ClassifyDocumentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::ClassifyDocumentError {
            meta: generic,
            kind: crate::error::ClassifyDocumentErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ClassifyDocumentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ClassifyDocumentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_classify_document_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ClassifyDocumentOutput, crate::error::ClassifyDocumentError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::classify_document_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_classify_document(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ClassifyDocumentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_contains_pii_entities_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ContainsPiiEntitiesOutput,
    crate::error::ContainsPiiEntitiesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ContainsPiiEntitiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ContainsPiiEntitiesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ContainsPiiEntitiesError {
            meta: generic,
            kind: crate::error::ContainsPiiEntitiesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ContainsPiiEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ContainsPiiEntitiesError {
            meta: generic,
            kind: crate::error::ContainsPiiEntitiesErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ContainsPiiEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::ContainsPiiEntitiesError {
            meta: generic,
            kind: crate::error::ContainsPiiEntitiesErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ContainsPiiEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::ContainsPiiEntitiesError {
            meta: generic,
            kind: crate::error::ContainsPiiEntitiesErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ContainsPiiEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ContainsPiiEntitiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_contains_pii_entities_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ContainsPiiEntitiesOutput,
    crate::error::ContainsPiiEntitiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::contains_pii_entities_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_contains_pii_entities(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ContainsPiiEntitiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_document_classifier_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDocumentClassifierOutput,
    crate::error::CreateDocumentClassifierError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDocumentClassifierError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDocumentClassifierError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::CreateDocumentClassifierError {
            meta: generic,
            kind: crate::error::CreateDocumentClassifierErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::CreateDocumentClassifierError {
            meta: generic,
            kind: crate::error::CreateDocumentClassifierErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsKeyValidationException" => crate::error::CreateDocumentClassifierError {
            meta: generic,
            kind: crate::error::CreateDocumentClassifierErrorKind::KmsKeyValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::CreateDocumentClassifierError {
            meta: generic,
            kind: crate::error::CreateDocumentClassifierErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateDocumentClassifierError {
            meta: generic,
            kind: crate::error::CreateDocumentClassifierErrorKind::ResourceLimitExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_limit_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDocumentClassifierError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "TooManyRequestsException" => crate::error::CreateDocumentClassifierError {
            meta: generic,
            kind: crate::error::CreateDocumentClassifierErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::CreateDocumentClassifierError {
            meta: generic,
            kind: crate::error::CreateDocumentClassifierErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::CreateDocumentClassifierError {
            meta: generic,
            kind: crate::error::CreateDocumentClassifierErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDocumentClassifierError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_document_classifier_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDocumentClassifierOutput,
    crate::error::CreateDocumentClassifierError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_document_classifier_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_document_classifier(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDocumentClassifierError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateEndpointOutput, crate::error::CreateEndpointError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateEndpointOutput, crate::error::CreateEndpointError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_entity_recognizer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEntityRecognizerOutput,
    crate::error::CreateEntityRecognizerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEntityRecognizerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateEntityRecognizerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::CreateEntityRecognizerError {
            meta: generic,
            kind: crate::error::CreateEntityRecognizerErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::CreateEntityRecognizerError {
            meta: generic,
            kind: crate::error::CreateEntityRecognizerErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsKeyValidationException" => crate::error::CreateEntityRecognizerError {
            meta: generic,
            kind: crate::error::CreateEntityRecognizerErrorKind::KmsKeyValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::CreateEntityRecognizerError {
            meta: generic,
            kind: crate::error::CreateEntityRecognizerErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::CreateEntityRecognizerError {
            meta: generic,
            kind: crate::error::CreateEntityRecognizerErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateEntityRecognizerError {
            meta: generic,
            kind: crate::error::CreateEntityRecognizerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::CreateEntityRecognizerError {
            meta: generic,
            kind: crate::error::CreateEntityRecognizerErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::CreateEntityRecognizerError {
            meta: generic,
            kind: crate::error::CreateEntityRecognizerErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEntityRecognizerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_entity_recognizer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEntityRecognizerOutput,
    crate::error::CreateEntityRecognizerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_entity_recognizer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_entity_recognizer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEntityRecognizerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_document_classifier_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDocumentClassifierOutput,
    crate::error::DeleteDocumentClassifierError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDocumentClassifierError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteDocumentClassifierError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DeleteDocumentClassifierError {
            meta: generic,
            kind: crate::error::DeleteDocumentClassifierErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DeleteDocumentClassifierError {
            meta: generic,
            kind: crate::error::DeleteDocumentClassifierErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::DeleteDocumentClassifierError {
            meta: generic,
            kind: crate::error::DeleteDocumentClassifierErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteDocumentClassifierError {
            meta: generic,
            kind: crate::error::DeleteDocumentClassifierErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::DeleteDocumentClassifierError {
            meta: generic,
            kind: crate::error::DeleteDocumentClassifierErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteDocumentClassifierError {
            meta: generic,
            kind: crate::error::DeleteDocumentClassifierErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDocumentClassifierError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_document_classifier_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDocumentClassifierOutput,
    crate::error::DeleteDocumentClassifierError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_document_classifier_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DeleteEndpointError {
            meta: generic,
            kind: crate::error::DeleteEndpointErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DeleteEndpointError {
            meta: generic,
            kind: crate::error::DeleteEndpointErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::DeleteEndpointError {
            meta: generic,
            kind: crate::error::DeleteEndpointErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteEndpointError {
            meta: generic,
            kind: crate::error::DeleteEndpointErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteEndpointError {
            meta: generic,
            kind: crate::error::DeleteEndpointErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_endpoint_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_entity_recognizer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEntityRecognizerOutput,
    crate::error::DeleteEntityRecognizerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEntityRecognizerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteEntityRecognizerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DeleteEntityRecognizerError {
            meta: generic,
            kind: crate::error::DeleteEntityRecognizerErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DeleteEntityRecognizerError {
            meta: generic,
            kind: crate::error::DeleteEntityRecognizerErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::DeleteEntityRecognizerError {
            meta: generic,
            kind: crate::error::DeleteEntityRecognizerErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteEntityRecognizerError {
            meta: generic,
            kind: crate::error::DeleteEntityRecognizerErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::DeleteEntityRecognizerError {
            meta: generic,
            kind: crate::error::DeleteEntityRecognizerErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteEntityRecognizerError {
            meta: generic,
            kind: crate::error::DeleteEntityRecognizerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteEntityRecognizerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_entity_recognizer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEntityRecognizerOutput,
    crate::error::DeleteEntityRecognizerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_entity_recognizer_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_resource_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteResourcePolicyOutput,
    crate::error::DeleteResourcePolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteResourcePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteResourcePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DeleteResourcePolicyError {
            meta: generic,
            kind: crate::error::DeleteResourcePolicyErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DeleteResourcePolicyError {
            meta: generic,
            kind: crate::error::DeleteResourcePolicyErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteResourcePolicyError {
            meta: generic,
            kind: crate::error::DeleteResourcePolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteResourcePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_resource_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteResourcePolicyOutput,
    crate::error::DeleteResourcePolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_resource_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_document_classification_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDocumentClassificationJobOutput,
    crate::error::DescribeDocumentClassificationJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDocumentClassificationJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDocumentClassificationJobError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeDocumentClassificationJobError {
            meta: generic,
            kind: crate::error::DescribeDocumentClassificationJobErrorKind::InternalServerException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDocumentClassificationJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidRequestException" => crate::error::DescribeDocumentClassificationJobError {
            meta: generic,
            kind: crate::error::DescribeDocumentClassificationJobErrorKind::InvalidRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDocumentClassificationJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "JobNotFoundException" => crate::error::DescribeDocumentClassificationJobError {
            meta: generic,
            kind: crate::error::DescribeDocumentClassificationJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDocumentClassificationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeDocumentClassificationJobError {
            meta: generic,
            kind:
                crate::error::DescribeDocumentClassificationJobErrorKind::TooManyRequestsException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::too_many_requests_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDocumentClassificationJobError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeDocumentClassificationJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_document_classification_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDocumentClassificationJobOutput,
    crate::error::DescribeDocumentClassificationJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_document_classification_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_document_classification_job(response.body().as_ref(), output).map_err(crate::error::DescribeDocumentClassificationJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_document_classifier_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDocumentClassifierOutput,
    crate::error::DescribeDocumentClassifierError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDocumentClassifierError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDocumentClassifierError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeDocumentClassifierError {
            meta: generic,
            kind: crate::error::DescribeDocumentClassifierErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DescribeDocumentClassifierError {
            meta: generic,
            kind: crate::error::DescribeDocumentClassifierErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeDocumentClassifierError {
            meta: generic,
            kind: crate::error::DescribeDocumentClassifierErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeDocumentClassifierError {
            meta: generic,
            kind: crate::error::DescribeDocumentClassifierErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDocumentClassifierError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_document_classifier_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDocumentClassifierOutput,
    crate::error::DescribeDocumentClassifierError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_document_classifier_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_document_classifier(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDocumentClassifierError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_dominant_language_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDominantLanguageDetectionJobOutput,
    crate::error::DescribeDominantLanguageDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDominantLanguageDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDominantLanguageDetectionJobError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeDominantLanguageDetectionJobError { meta: generic, kind: crate::error::DescribeDominantLanguageDetectionJobErrorKind::InternalServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDominantLanguageDetectionJobError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRequestException" => crate::error::DescribeDominantLanguageDetectionJobError { meta: generic, kind: crate::error::DescribeDominantLanguageDetectionJobErrorKind::InvalidRequestException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDominantLanguageDetectionJobError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "JobNotFoundException" => crate::error::DescribeDominantLanguageDetectionJobError { meta: generic, kind: crate::error::DescribeDominantLanguageDetectionJobErrorKind::JobNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDominantLanguageDetectionJobError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::DescribeDominantLanguageDetectionJobError { meta: generic, kind: crate::error::DescribeDominantLanguageDetectionJobErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDominantLanguageDetectionJobError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeDominantLanguageDetectionJobError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_dominant_language_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDominantLanguageDetectionJobOutput,
    crate::error::DescribeDominantLanguageDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_dominant_language_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_dominant_language_detection_job(response.body().as_ref(), output).map_err(crate::error::DescribeDominantLanguageDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEndpointOutput, crate::error::DescribeEndpointError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeEndpointError {
            meta: generic,
            kind: crate::error::DescribeEndpointErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DescribeEndpointError {
            meta: generic,
            kind: crate::error::DescribeEndpointErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeEndpointError {
            meta: generic,
            kind: crate::error::DescribeEndpointErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeEndpointError {
            meta: generic,
            kind: crate::error::DescribeEndpointErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEndpointOutput, crate::error::DescribeEndpointError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_entities_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEntitiesDetectionJobOutput,
    crate::error::DescribeEntitiesDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEntitiesDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEntitiesDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeEntitiesDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DescribeEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeEntitiesDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::DescribeEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeEntitiesDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeEntitiesDetectionJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEntitiesDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_entities_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEntitiesDetectionJobOutput,
    crate::error::DescribeEntitiesDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_entities_detection_job_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_entities_detection_job(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeEntitiesDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_entity_recognizer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEntityRecognizerOutput,
    crate::error::DescribeEntityRecognizerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEntityRecognizerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEntityRecognizerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeEntityRecognizerError {
            meta: generic,
            kind: crate::error::DescribeEntityRecognizerErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DescribeEntityRecognizerError {
            meta: generic,
            kind: crate::error::DescribeEntityRecognizerErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeEntityRecognizerError {
            meta: generic,
            kind: crate::error::DescribeEntityRecognizerErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeEntityRecognizerError {
            meta: generic,
            kind: crate::error::DescribeEntityRecognizerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEntityRecognizerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_entity_recognizer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEntityRecognizerOutput,
    crate::error::DescribeEntityRecognizerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_entity_recognizer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_entity_recognizer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEntityRecognizerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventsDetectionJobOutput,
    crate::error::DescribeEventsDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventsDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEventsDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeEventsDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeEventsDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DescribeEventsDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeEventsDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::DescribeEventsDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeEventsDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeEventsDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeEventsDetectionJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEventsDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventsDetectionJobOutput,
    crate::error::DescribeEventsDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_events_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_events_detection_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventsDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_key_phrases_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeKeyPhrasesDetectionJobOutput,
    crate::error::DescribeKeyPhrasesDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeKeyPhrasesDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeKeyPhrasesDetectionJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeKeyPhrasesDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeKeyPhrasesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DescribeKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeKeyPhrasesDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeKeyPhrasesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::DescribeKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeKeyPhrasesDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeKeyPhrasesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeKeyPhrasesDetectionJobErrorKind::TooManyRequestsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::too_many_requests_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeKeyPhrasesDetectionJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeKeyPhrasesDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_key_phrases_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeKeyPhrasesDetectionJobOutput,
    crate::error::DescribeKeyPhrasesDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_key_phrases_detection_job_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_key_phrases_detection_job(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeKeyPhrasesDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pii_entities_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePiiEntitiesDetectionJobOutput,
    crate::error::DescribePiiEntitiesDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePiiEntitiesDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribePiiEntitiesDetectionJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribePiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribePiiEntitiesDetectionJobErrorKind::InternalServerException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePiiEntitiesDetectionJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidRequestException" => crate::error::DescribePiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribePiiEntitiesDetectionJobErrorKind::InvalidRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePiiEntitiesDetectionJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "JobNotFoundException" => crate::error::DescribePiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribePiiEntitiesDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePiiEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribePiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::DescribePiiEntitiesDetectionJobErrorKind::TooManyRequestsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::too_many_requests_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePiiEntitiesDetectionJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribePiiEntitiesDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pii_entities_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePiiEntitiesDetectionJobOutput,
    crate::error::DescribePiiEntitiesDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_pii_entities_detection_job_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_pii_entities_detection_job(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribePiiEntitiesDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_resource_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeResourcePolicyOutput,
    crate::error::DescribeResourcePolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeResourcePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeResourcePolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeResourcePolicyError {
            meta: generic,
            kind: crate::error::DescribeResourcePolicyErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DescribeResourcePolicyError {
            meta: generic,
            kind: crate::error::DescribeResourcePolicyErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeResourcePolicyError {
            meta: generic,
            kind: crate::error::DescribeResourcePolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeResourcePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_resource_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeResourcePolicyOutput,
    crate::error::DescribeResourcePolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_resource_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_resource_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeResourcePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_sentiment_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSentimentDetectionJobOutput,
    crate::error::DescribeSentimentDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSentimentDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeSentimentDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeSentimentDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DescribeSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeSentimentDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::DescribeSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeSentimentDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeSentimentDetectionJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeSentimentDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_sentiment_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSentimentDetectionJobOutput,
    crate::error::DescribeSentimentDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_sentiment_detection_job_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_sentiment_detection_job(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeSentimentDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_topics_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTopicsDetectionJobOutput,
    crate::error::DescribeTopicsDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTopicsDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeTopicsDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeTopicsDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeTopicsDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTopicsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DescribeTopicsDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeTopicsDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTopicsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::DescribeTopicsDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeTopicsDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTopicsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeTopicsDetectionJobError {
            meta: generic,
            kind: crate::error::DescribeTopicsDetectionJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTopicsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTopicsDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_topics_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTopicsDetectionJobOutput,
    crate::error::DescribeTopicsDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_topics_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_topics_detection_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTopicsDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_dominant_language_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetectDominantLanguageOutput,
    crate::error::DetectDominantLanguageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetectDominantLanguageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DetectDominantLanguageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DetectDominantLanguageError {
            meta: generic,
            kind: crate::error::DetectDominantLanguageErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectDominantLanguageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DetectDominantLanguageError {
            meta: generic,
            kind: crate::error::DetectDominantLanguageErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectDominantLanguageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::DetectDominantLanguageError {
            meta: generic,
            kind: crate::error::DetectDominantLanguageErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectDominantLanguageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetectDominantLanguageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_dominant_language_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetectDominantLanguageOutput,
    crate::error::DetectDominantLanguageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detect_dominant_language_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_detect_dominant_language(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetectDominantLanguageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_entities_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectEntitiesOutput, crate::error::DetectEntitiesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetectEntitiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetectEntitiesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DetectEntitiesError {
            meta: generic,
            kind: crate::error::DetectEntitiesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DetectEntitiesError {
            meta: generic,
            kind: crate::error::DetectEntitiesErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::DetectEntitiesError {
            meta: generic,
            kind: crate::error::DetectEntitiesErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::DetectEntitiesError {
            meta: generic,
            kind: crate::error::DetectEntitiesErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::DetectEntitiesError {
            meta: generic,
            kind: crate::error::DetectEntitiesErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetectEntitiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_entities_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectEntitiesOutput, crate::error::DetectEntitiesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detect_entities_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_detect_entities(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetectEntitiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_key_phrases_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectKeyPhrasesOutput, crate::error::DetectKeyPhrasesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetectKeyPhrasesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetectKeyPhrasesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DetectKeyPhrasesError {
            meta: generic,
            kind: crate::error::DetectKeyPhrasesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectKeyPhrasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DetectKeyPhrasesError {
            meta: generic,
            kind: crate::error::DetectKeyPhrasesErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectKeyPhrasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::DetectKeyPhrasesError {
            meta: generic,
            kind: crate::error::DetectKeyPhrasesErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectKeyPhrasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::DetectKeyPhrasesError {
            meta: generic,
            kind: crate::error::DetectKeyPhrasesErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectKeyPhrasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetectKeyPhrasesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_key_phrases_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectKeyPhrasesOutput, crate::error::DetectKeyPhrasesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detect_key_phrases_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_detect_key_phrases(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetectKeyPhrasesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_pii_entities_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectPiiEntitiesOutput, crate::error::DetectPiiEntitiesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetectPiiEntitiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetectPiiEntitiesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DetectPiiEntitiesError {
            meta: generic,
            kind: crate::error::DetectPiiEntitiesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectPiiEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DetectPiiEntitiesError {
            meta: generic,
            kind: crate::error::DetectPiiEntitiesErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectPiiEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::DetectPiiEntitiesError {
            meta: generic,
            kind: crate::error::DetectPiiEntitiesErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectPiiEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::DetectPiiEntitiesError {
            meta: generic,
            kind: crate::error::DetectPiiEntitiesErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectPiiEntitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetectPiiEntitiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_pii_entities_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectPiiEntitiesOutput, crate::error::DetectPiiEntitiesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detect_pii_entities_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_detect_pii_entities(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetectPiiEntitiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_sentiment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectSentimentOutput, crate::error::DetectSentimentError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetectSentimentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetectSentimentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DetectSentimentError {
            meta: generic,
            kind: crate::error::DetectSentimentErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectSentimentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DetectSentimentError {
            meta: generic,
            kind: crate::error::DetectSentimentErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectSentimentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::DetectSentimentError {
            meta: generic,
            kind: crate::error::DetectSentimentErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectSentimentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::DetectSentimentError {
            meta: generic,
            kind: crate::error::DetectSentimentErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectSentimentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetectSentimentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_sentiment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectSentimentOutput, crate::error::DetectSentimentError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detect_sentiment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_detect_sentiment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetectSentimentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_syntax_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectSyntaxOutput, crate::error::DetectSyntaxError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetectSyntaxError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetectSyntaxError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DetectSyntaxError {
            meta: generic,
            kind: crate::error::DetectSyntaxErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectSyntaxError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DetectSyntaxError {
            meta: generic,
            kind: crate::error::DetectSyntaxErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectSyntaxError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TextSizeLimitExceededException" => crate::error::DetectSyntaxError {
            meta: generic,
            kind: crate::error::DetectSyntaxErrorKind::TextSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::text_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_text_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectSyntaxError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedLanguageException" => crate::error::DetectSyntaxError {
            meta: generic,
            kind: crate::error::DetectSyntaxErrorKind::UnsupportedLanguageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_language_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_language_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetectSyntaxError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetectSyntaxError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detect_syntax_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetectSyntaxOutput, crate::error::DetectSyntaxError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detect_syntax_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_detect_syntax(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetectSyntaxError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportModelOutput, crate::error::ImportModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ImportModelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ImportModelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ImportModelError {
            meta: generic,
            kind: crate::error::ImportModelErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ImportModelError {
            meta: generic,
            kind: crate::error::ImportModelErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsKeyValidationException" => crate::error::ImportModelError {
            meta: generic,
            kind: crate::error::ImportModelErrorKind::KmsKeyValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::ImportModelError {
            meta: generic,
            kind: crate::error::ImportModelErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::ImportModelError {
            meta: generic,
            kind: crate::error::ImportModelErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ImportModelError {
            meta: generic,
            kind: crate::error::ImportModelErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::ImportModelError {
            meta: generic,
            kind: crate::error::ImportModelErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ImportModelError {
            meta: generic,
            kind: crate::error::ImportModelErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::ImportModelError {
            meta: generic,
            kind: crate::error::ImportModelErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ImportModelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportModelOutput, crate::error::ImportModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::import_model_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_import_model(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ImportModelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_document_classification_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDocumentClassificationJobsOutput,
    crate::error::ListDocumentClassificationJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDocumentClassificationJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListDocumentClassificationJobsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListDocumentClassificationJobsError {
            meta: generic,
            kind: crate::error::ListDocumentClassificationJobsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDocumentClassificationJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidFilterException" => crate::error::ListDocumentClassificationJobsError {
            meta: generic,
            kind: crate::error::ListDocumentClassificationJobsErrorKind::InvalidFilterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_filter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_filter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDocumentClassificationJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListDocumentClassificationJobsError {
            meta: generic,
            kind: crate::error::ListDocumentClassificationJobsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDocumentClassificationJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListDocumentClassificationJobsError {
            meta: generic,
            kind: crate::error::ListDocumentClassificationJobsErrorKind::TooManyRequestsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::too_many_requests_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDocumentClassificationJobsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListDocumentClassificationJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_document_classification_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDocumentClassificationJobsOutput,
    crate::error::ListDocumentClassificationJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_document_classification_jobs_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_document_classification_jobs(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListDocumentClassificationJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_document_classifiers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDocumentClassifiersOutput,
    crate::error::ListDocumentClassifiersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDocumentClassifiersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListDocumentClassifiersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListDocumentClassifiersError {
            meta: generic,
            kind: crate::error::ListDocumentClassifiersErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDocumentClassifiersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidFilterException" => crate::error::ListDocumentClassifiersError {
            meta: generic,
            kind: crate::error::ListDocumentClassifiersErrorKind::InvalidFilterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_filter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_filter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDocumentClassifiersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListDocumentClassifiersError {
            meta: generic,
            kind: crate::error::ListDocumentClassifiersErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDocumentClassifiersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListDocumentClassifiersError {
            meta: generic,
            kind: crate::error::ListDocumentClassifiersErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDocumentClassifiersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListDocumentClassifiersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_document_classifiers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDocumentClassifiersOutput,
    crate::error::ListDocumentClassifiersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_document_classifiers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_document_classifiers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDocumentClassifiersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_document_classifier_summaries_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDocumentClassifierSummariesOutput,
    crate::error::ListDocumentClassifierSummariesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDocumentClassifierSummariesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListDocumentClassifierSummariesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListDocumentClassifierSummariesError {
            meta: generic,
            kind: crate::error::ListDocumentClassifierSummariesErrorKind::InternalServerException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDocumentClassifierSummariesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidRequestException" => crate::error::ListDocumentClassifierSummariesError {
            meta: generic,
            kind: crate::error::ListDocumentClassifierSummariesErrorKind::InvalidRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDocumentClassifierSummariesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "TooManyRequestsException" => crate::error::ListDocumentClassifierSummariesError {
            meta: generic,
            kind: crate::error::ListDocumentClassifierSummariesErrorKind::TooManyRequestsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::too_many_requests_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDocumentClassifierSummariesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListDocumentClassifierSummariesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_document_classifier_summaries_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDocumentClassifierSummariesOutput,
    crate::error::ListDocumentClassifierSummariesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_document_classifier_summaries_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_document_classifier_summaries(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListDocumentClassifierSummariesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_dominant_language_detection_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDominantLanguageDetectionJobsOutput,
    crate::error::ListDominantLanguageDetectionJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDominantLanguageDetectionJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListDominantLanguageDetectionJobsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListDominantLanguageDetectionJobsError {
            meta: generic,
            kind: crate::error::ListDominantLanguageDetectionJobsErrorKind::InternalServerException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDominantLanguageDetectionJobsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidFilterException" => crate::error::ListDominantLanguageDetectionJobsError {
            meta: generic,
            kind: crate::error::ListDominantLanguageDetectionJobsErrorKind::InvalidFilterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_filter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_filter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDominantLanguageDetectionJobsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidRequestException" => crate::error::ListDominantLanguageDetectionJobsError {
            meta: generic,
            kind: crate::error::ListDominantLanguageDetectionJobsErrorKind::InvalidRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDominantLanguageDetectionJobsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "TooManyRequestsException" => crate::error::ListDominantLanguageDetectionJobsError {
            meta: generic,
            kind:
                crate::error::ListDominantLanguageDetectionJobsErrorKind::TooManyRequestsException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::too_many_requests_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDominantLanguageDetectionJobsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::ListDominantLanguageDetectionJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_dominant_language_detection_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDominantLanguageDetectionJobsOutput,
    crate::error::ListDominantLanguageDetectionJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_dominant_language_detection_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_dominant_language_detection_jobs(response.body().as_ref(), output).map_err(crate::error::ListDominantLanguageDetectionJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_endpoints_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListEndpointsOutput, crate::error::ListEndpointsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEndpointsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListEndpointsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListEndpointsError {
            meta: generic,
            kind: crate::error::ListEndpointsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListEndpointsError {
            meta: generic,
            kind: crate::error::ListEndpointsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListEndpointsError {
            meta: generic,
            kind: crate::error::ListEndpointsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListEndpointsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_endpoints_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListEndpointsOutput, crate::error::ListEndpointsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_endpoints_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_endpoints(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListEndpointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_entities_detection_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEntitiesDetectionJobsOutput,
    crate::error::ListEntitiesDetectionJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEntitiesDetectionJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListEntitiesDetectionJobsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListEntitiesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListEntitiesDetectionJobsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEntitiesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidFilterException" => crate::error::ListEntitiesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListEntitiesDetectionJobsErrorKind::InvalidFilterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_filter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_filter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEntitiesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListEntitiesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListEntitiesDetectionJobsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEntitiesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListEntitiesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListEntitiesDetectionJobsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEntitiesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListEntitiesDetectionJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_entities_detection_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEntitiesDetectionJobsOutput,
    crate::error::ListEntitiesDetectionJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_entities_detection_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_entities_detection_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListEntitiesDetectionJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_entity_recognizers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEntityRecognizersOutput,
    crate::error::ListEntityRecognizersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEntityRecognizersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListEntityRecognizersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListEntityRecognizersError {
            meta: generic,
            kind: crate::error::ListEntityRecognizersErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEntityRecognizersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidFilterException" => crate::error::ListEntityRecognizersError {
            meta: generic,
            kind: crate::error::ListEntityRecognizersErrorKind::InvalidFilterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_filter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_filter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEntityRecognizersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListEntityRecognizersError {
            meta: generic,
            kind: crate::error::ListEntityRecognizersErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEntityRecognizersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListEntityRecognizersError {
            meta: generic,
            kind: crate::error::ListEntityRecognizersErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEntityRecognizersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListEntityRecognizersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_entity_recognizers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEntityRecognizersOutput,
    crate::error::ListEntityRecognizersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_entity_recognizers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_entity_recognizers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListEntityRecognizersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_entity_recognizer_summaries_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEntityRecognizerSummariesOutput,
    crate::error::ListEntityRecognizerSummariesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEntityRecognizerSummariesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListEntityRecognizerSummariesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListEntityRecognizerSummariesError {
            meta: generic,
            kind: crate::error::ListEntityRecognizerSummariesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEntityRecognizerSummariesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListEntityRecognizerSummariesError {
            meta: generic,
            kind: crate::error::ListEntityRecognizerSummariesErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEntityRecognizerSummariesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListEntityRecognizerSummariesError {
            meta: generic,
            kind: crate::error::ListEntityRecognizerSummariesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEntityRecognizerSummariesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListEntityRecognizerSummariesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_entity_recognizer_summaries_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEntityRecognizerSummariesOutput,
    crate::error::ListEntityRecognizerSummariesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_entity_recognizer_summaries_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_entity_recognizer_summaries(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListEntityRecognizerSummariesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_events_detection_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEventsDetectionJobsOutput,
    crate::error::ListEventsDetectionJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEventsDetectionJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListEventsDetectionJobsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListEventsDetectionJobsError {
            meta: generic,
            kind: crate::error::ListEventsDetectionJobsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventsDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidFilterException" => crate::error::ListEventsDetectionJobsError {
            meta: generic,
            kind: crate::error::ListEventsDetectionJobsErrorKind::InvalidFilterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_filter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_filter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventsDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListEventsDetectionJobsError {
            meta: generic,
            kind: crate::error::ListEventsDetectionJobsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventsDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListEventsDetectionJobsError {
            meta: generic,
            kind: crate::error::ListEventsDetectionJobsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventsDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListEventsDetectionJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_events_detection_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEventsDetectionJobsOutput,
    crate::error::ListEventsDetectionJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_events_detection_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_events_detection_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListEventsDetectionJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_key_phrases_detection_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListKeyPhrasesDetectionJobsOutput,
    crate::error::ListKeyPhrasesDetectionJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListKeyPhrasesDetectionJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListKeyPhrasesDetectionJobsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListKeyPhrasesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListKeyPhrasesDetectionJobsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeyPhrasesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidFilterException" => crate::error::ListKeyPhrasesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListKeyPhrasesDetectionJobsErrorKind::InvalidFilterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_filter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_filter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeyPhrasesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListKeyPhrasesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListKeyPhrasesDetectionJobsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeyPhrasesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListKeyPhrasesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListKeyPhrasesDetectionJobsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeyPhrasesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListKeyPhrasesDetectionJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_key_phrases_detection_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListKeyPhrasesDetectionJobsOutput,
    crate::error::ListKeyPhrasesDetectionJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_key_phrases_detection_jobs_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_key_phrases_detection_jobs(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListKeyPhrasesDetectionJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pii_entities_detection_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPiiEntitiesDetectionJobsOutput,
    crate::error::ListPiiEntitiesDetectionJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPiiEntitiesDetectionJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListPiiEntitiesDetectionJobsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListPiiEntitiesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListPiiEntitiesDetectionJobsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPiiEntitiesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidFilterException" => crate::error::ListPiiEntitiesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListPiiEntitiesDetectionJobsErrorKind::InvalidFilterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_filter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_filter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPiiEntitiesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListPiiEntitiesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListPiiEntitiesDetectionJobsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPiiEntitiesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListPiiEntitiesDetectionJobsError {
            meta: generic,
            kind: crate::error::ListPiiEntitiesDetectionJobsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPiiEntitiesDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPiiEntitiesDetectionJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pii_entities_detection_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPiiEntitiesDetectionJobsOutput,
    crate::error::ListPiiEntitiesDetectionJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_pii_entities_detection_jobs_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_pii_entities_detection_jobs(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListPiiEntitiesDetectionJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_sentiment_detection_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSentimentDetectionJobsOutput,
    crate::error::ListSentimentDetectionJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSentimentDetectionJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListSentimentDetectionJobsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListSentimentDetectionJobsError {
            meta: generic,
            kind: crate::error::ListSentimentDetectionJobsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSentimentDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidFilterException" => crate::error::ListSentimentDetectionJobsError {
            meta: generic,
            kind: crate::error::ListSentimentDetectionJobsErrorKind::InvalidFilterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_filter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_filter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSentimentDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListSentimentDetectionJobsError {
            meta: generic,
            kind: crate::error::ListSentimentDetectionJobsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSentimentDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListSentimentDetectionJobsError {
            meta: generic,
            kind: crate::error::ListSentimentDetectionJobsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSentimentDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSentimentDetectionJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_sentiment_detection_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSentimentDetectionJobsOutput,
    crate::error::ListSentimentDetectionJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_sentiment_detection_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_sentiment_detection_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSentimentDetectionJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_topics_detection_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTopicsDetectionJobsOutput,
    crate::error::ListTopicsDetectionJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTopicsDetectionJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListTopicsDetectionJobsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::ListTopicsDetectionJobsError {
            meta: generic,
            kind: crate::error::ListTopicsDetectionJobsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTopicsDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidFilterException" => crate::error::ListTopicsDetectionJobsError {
            meta: generic,
            kind: crate::error::ListTopicsDetectionJobsErrorKind::InvalidFilterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_filter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_filter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTopicsDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListTopicsDetectionJobsError {
            meta: generic,
            kind: crate::error::ListTopicsDetectionJobsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTopicsDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListTopicsDetectionJobsError {
            meta: generic,
            kind: crate::error::ListTopicsDetectionJobsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTopicsDetectionJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTopicsDetectionJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_topics_detection_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTopicsDetectionJobsOutput,
    crate::error::ListTopicsDetectionJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_topics_detection_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_topics_detection_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTopicsDetectionJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_resource_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutResourcePolicyOutput, crate::error::PutResourcePolicyError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutResourcePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutResourcePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::PutResourcePolicyError {
            meta: generic,
            kind: crate::error::PutResourcePolicyErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::PutResourcePolicyError {
            meta: generic,
            kind: crate::error::PutResourcePolicyErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::PutResourcePolicyError {
            meta: generic,
            kind: crate::error::PutResourcePolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutResourcePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_resource_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutResourcePolicyOutput, crate::error::PutResourcePolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_resource_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_resource_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutResourcePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_document_classification_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartDocumentClassificationJobOutput,
    crate::error::StartDocumentClassificationJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartDocumentClassificationJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartDocumentClassificationJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StartDocumentClassificationJobError {
            meta: generic,
            kind: crate::error::StartDocumentClassificationJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDocumentClassificationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StartDocumentClassificationJobError {
            meta: generic,
            kind: crate::error::StartDocumentClassificationJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDocumentClassificationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsKeyValidationException" => crate::error::StartDocumentClassificationJobError {
            meta: generic,
            kind: crate::error::StartDocumentClassificationJobErrorKind::KmsKeyValidationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::kms_key_validation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_kms_key_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDocumentClassificationJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::StartDocumentClassificationJobError {
            meta: generic,
            kind: crate::error::StartDocumentClassificationJobErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDocumentClassificationJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceUnavailableException" => crate::error::StartDocumentClassificationJobError {
            meta: generic,
            kind:
                crate::error::StartDocumentClassificationJobErrorKind::ResourceUnavailableException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_unavailable_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDocumentClassificationJobError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "TooManyRequestsException" => crate::error::StartDocumentClassificationJobError {
            meta: generic,
            kind: crate::error::StartDocumentClassificationJobErrorKind::TooManyRequestsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::too_many_requests_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDocumentClassificationJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "TooManyTagsException" => crate::error::StartDocumentClassificationJobError {
            meta: generic,
            kind: crate::error::StartDocumentClassificationJobErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDocumentClassificationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartDocumentClassificationJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_document_classification_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartDocumentClassificationJobOutput,
    crate::error::StartDocumentClassificationJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::start_document_classification_job_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_start_document_classification_job(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::StartDocumentClassificationJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_dominant_language_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartDominantLanguageDetectionJobOutput,
    crate::error::StartDominantLanguageDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartDominantLanguageDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartDominantLanguageDetectionJobError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StartDominantLanguageDetectionJobError {
            meta: generic,
            kind: crate::error::StartDominantLanguageDetectionJobErrorKind::InternalServerException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDominantLanguageDetectionJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidRequestException" => crate::error::StartDominantLanguageDetectionJobError {
            meta: generic,
            kind: crate::error::StartDominantLanguageDetectionJobErrorKind::InvalidRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDominantLanguageDetectionJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "KmsKeyValidationException" => crate::error::StartDominantLanguageDetectionJobError {
            meta: generic,
            kind:
                crate::error::StartDominantLanguageDetectionJobErrorKind::KmsKeyValidationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::kms_key_validation_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_kms_key_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDominantLanguageDetectionJobError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "TooManyRequestsException" => crate::error::StartDominantLanguageDetectionJobError {
            meta: generic,
            kind:
                crate::error::StartDominantLanguageDetectionJobErrorKind::TooManyRequestsException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::too_many_requests_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDominantLanguageDetectionJobError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "TooManyTagsException" => crate::error::StartDominantLanguageDetectionJobError {
            meta: generic,
            kind: crate::error::StartDominantLanguageDetectionJobErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartDominantLanguageDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartDominantLanguageDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_dominant_language_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartDominantLanguageDetectionJobOutput,
    crate::error::StartDominantLanguageDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::start_dominant_language_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_dominant_language_detection_job(response.body().as_ref(), output).map_err(crate::error::StartDominantLanguageDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_entities_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartEntitiesDetectionJobOutput,
    crate::error::StartEntitiesDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartEntitiesDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartEntitiesDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StartEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartEntitiesDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StartEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartEntitiesDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsKeyValidationException" => crate::error::StartEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartEntitiesDetectionJobErrorKind::KmsKeyValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::StartEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartEntitiesDetectionJobErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::StartEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartEntitiesDetectionJobErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::StartEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartEntitiesDetectionJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::StartEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartEntitiesDetectionJobErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartEntitiesDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_entities_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartEntitiesDetectionJobOutput,
    crate::error::StartEntitiesDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_entities_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_entities_detection_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartEntitiesDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_events_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartEventsDetectionJobOutput,
    crate::error::StartEventsDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartEventsDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartEventsDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StartEventsDetectionJobError {
            meta: generic,
            kind: crate::error::StartEventsDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StartEventsDetectionJobError {
            meta: generic,
            kind: crate::error::StartEventsDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsKeyValidationException" => crate::error::StartEventsDetectionJobError {
            meta: generic,
            kind: crate::error::StartEventsDetectionJobErrorKind::KmsKeyValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::StartEventsDetectionJobError {
            meta: generic,
            kind: crate::error::StartEventsDetectionJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::StartEventsDetectionJobError {
            meta: generic,
            kind: crate::error::StartEventsDetectionJobErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartEventsDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_events_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartEventsDetectionJobOutput,
    crate::error::StartEventsDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_events_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_events_detection_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartEventsDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_key_phrases_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartKeyPhrasesDetectionJobOutput,
    crate::error::StartKeyPhrasesDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartKeyPhrasesDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartKeyPhrasesDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StartKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::StartKeyPhrasesDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartKeyPhrasesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StartKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::StartKeyPhrasesDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartKeyPhrasesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsKeyValidationException" => crate::error::StartKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::StartKeyPhrasesDetectionJobErrorKind::KmsKeyValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartKeyPhrasesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::StartKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::StartKeyPhrasesDetectionJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartKeyPhrasesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::StartKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::StartKeyPhrasesDetectionJobErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartKeyPhrasesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartKeyPhrasesDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_key_phrases_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartKeyPhrasesDetectionJobOutput,
    crate::error::StartKeyPhrasesDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_key_phrases_detection_job_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_start_key_phrases_detection_job(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::StartKeyPhrasesDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_pii_entities_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartPiiEntitiesDetectionJobOutput,
    crate::error::StartPiiEntitiesDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartPiiEntitiesDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartPiiEntitiesDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StartPiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartPiiEntitiesDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartPiiEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StartPiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartPiiEntitiesDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartPiiEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsKeyValidationException" => crate::error::StartPiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartPiiEntitiesDetectionJobErrorKind::KmsKeyValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartPiiEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::StartPiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartPiiEntitiesDetectionJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartPiiEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::StartPiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StartPiiEntitiesDetectionJobErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartPiiEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartPiiEntitiesDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_pii_entities_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartPiiEntitiesDetectionJobOutput,
    crate::error::StartPiiEntitiesDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_pii_entities_detection_job_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_start_pii_entities_detection_job(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::StartPiiEntitiesDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_sentiment_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartSentimentDetectionJobOutput,
    crate::error::StartSentimentDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartSentimentDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartSentimentDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StartSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::StartSentimentDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StartSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::StartSentimentDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsKeyValidationException" => crate::error::StartSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::StartSentimentDetectionJobErrorKind::KmsKeyValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::StartSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::StartSentimentDetectionJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::StartSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::StartSentimentDetectionJobErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartSentimentDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_sentiment_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartSentimentDetectionJobOutput,
    crate::error::StartSentimentDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_sentiment_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_sentiment_detection_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartSentimentDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_topics_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartTopicsDetectionJobOutput,
    crate::error::StartTopicsDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartTopicsDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartTopicsDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StartTopicsDetectionJobError {
            meta: generic,
            kind: crate::error::StartTopicsDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartTopicsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StartTopicsDetectionJobError {
            meta: generic,
            kind: crate::error::StartTopicsDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartTopicsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsKeyValidationException" => crate::error::StartTopicsDetectionJobError {
            meta: generic,
            kind: crate::error::StartTopicsDetectionJobErrorKind::KmsKeyValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartTopicsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::StartTopicsDetectionJobError {
            meta: generic,
            kind: crate::error::StartTopicsDetectionJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartTopicsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::StartTopicsDetectionJobError {
            meta: generic,
            kind: crate::error::StartTopicsDetectionJobErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartTopicsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartTopicsDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_topics_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartTopicsDetectionJobOutput,
    crate::error::StartTopicsDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_topics_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_topics_detection_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartTopicsDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_dominant_language_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopDominantLanguageDetectionJobOutput,
    crate::error::StopDominantLanguageDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopDominantLanguageDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopDominantLanguageDetectionJobError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StopDominantLanguageDetectionJobError {
            meta: generic,
            kind: crate::error::StopDominantLanguageDetectionJobErrorKind::InternalServerException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopDominantLanguageDetectionJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidRequestException" => crate::error::StopDominantLanguageDetectionJobError {
            meta: generic,
            kind: crate::error::StopDominantLanguageDetectionJobErrorKind::InvalidRequestException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_request_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopDominantLanguageDetectionJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "JobNotFoundException" => crate::error::StopDominantLanguageDetectionJobError {
            meta: generic,
            kind: crate::error::StopDominantLanguageDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopDominantLanguageDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopDominantLanguageDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_dominant_language_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopDominantLanguageDetectionJobOutput,
    crate::error::StopDominantLanguageDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::stop_dominant_language_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_dominant_language_detection_job(response.body().as_ref(), output).map_err(crate::error::StopDominantLanguageDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_entities_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopEntitiesDetectionJobOutput,
    crate::error::StopEntitiesDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopEntitiesDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopEntitiesDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StopEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StopEntitiesDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StopEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StopEntitiesDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::StopEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StopEntitiesDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopEntitiesDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_entities_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopEntitiesDetectionJobOutput,
    crate::error::StopEntitiesDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_entities_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_entities_detection_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopEntitiesDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_events_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopEventsDetectionJobOutput,
    crate::error::StopEventsDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopEventsDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopEventsDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StopEventsDetectionJobError {
            meta: generic,
            kind: crate::error::StopEventsDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StopEventsDetectionJobError {
            meta: generic,
            kind: crate::error::StopEventsDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::StopEventsDetectionJobError {
            meta: generic,
            kind: crate::error::StopEventsDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopEventsDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopEventsDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_events_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopEventsDetectionJobOutput,
    crate::error::StopEventsDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_events_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_events_detection_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopEventsDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_key_phrases_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopKeyPhrasesDetectionJobOutput,
    crate::error::StopKeyPhrasesDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopKeyPhrasesDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopKeyPhrasesDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StopKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::StopKeyPhrasesDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopKeyPhrasesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StopKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::StopKeyPhrasesDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopKeyPhrasesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::StopKeyPhrasesDetectionJobError {
            meta: generic,
            kind: crate::error::StopKeyPhrasesDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopKeyPhrasesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopKeyPhrasesDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_key_phrases_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopKeyPhrasesDetectionJobOutput,
    crate::error::StopKeyPhrasesDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_key_phrases_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_key_phrases_detection_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopKeyPhrasesDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_pii_entities_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopPiiEntitiesDetectionJobOutput,
    crate::error::StopPiiEntitiesDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopPiiEntitiesDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopPiiEntitiesDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StopPiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StopPiiEntitiesDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopPiiEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StopPiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StopPiiEntitiesDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopPiiEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::StopPiiEntitiesDetectionJobError {
            meta: generic,
            kind: crate::error::StopPiiEntitiesDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopPiiEntitiesDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopPiiEntitiesDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_pii_entities_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopPiiEntitiesDetectionJobOutput,
    crate::error::StopPiiEntitiesDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_pii_entities_detection_job_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_stop_pii_entities_detection_job(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::StopPiiEntitiesDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_sentiment_detection_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopSentimentDetectionJobOutput,
    crate::error::StopSentimentDetectionJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopSentimentDetectionJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopSentimentDetectionJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StopSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::StopSentimentDetectionJobErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StopSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::StopSentimentDetectionJobErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobNotFoundException" => crate::error::StopSentimentDetectionJobError {
            meta: generic,
            kind: crate::error::StopSentimentDetectionJobErrorKind::JobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopSentimentDetectionJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopSentimentDetectionJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_sentiment_detection_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopSentimentDetectionJobOutput,
    crate::error::StopSentimentDetectionJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_sentiment_detection_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_sentiment_detection_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopSentimentDetectionJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_training_document_classifier_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopTrainingDocumentClassifierOutput,
    crate::error::StopTrainingDocumentClassifierError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopTrainingDocumentClassifierError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopTrainingDocumentClassifierError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StopTrainingDocumentClassifierError {
            meta: generic,
            kind: crate::error::StopTrainingDocumentClassifierErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTrainingDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StopTrainingDocumentClassifierError {
            meta: generic,
            kind: crate::error::StopTrainingDocumentClassifierErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTrainingDocumentClassifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::StopTrainingDocumentClassifierError {
            meta: generic,
            kind: crate::error::StopTrainingDocumentClassifierErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTrainingDocumentClassifierError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "TooManyRequestsException" => crate::error::StopTrainingDocumentClassifierError {
            meta: generic,
            kind: crate::error::StopTrainingDocumentClassifierErrorKind::TooManyRequestsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::too_many_requests_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTrainingDocumentClassifierError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::StopTrainingDocumentClassifierError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_training_document_classifier_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopTrainingDocumentClassifierOutput,
    crate::error::StopTrainingDocumentClassifierError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::stop_training_document_classifier_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_training_entity_recognizer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopTrainingEntityRecognizerOutput,
    crate::error::StopTrainingEntityRecognizerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopTrainingEntityRecognizerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopTrainingEntityRecognizerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::StopTrainingEntityRecognizerError {
            meta: generic,
            kind: crate::error::StopTrainingEntityRecognizerErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTrainingEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StopTrainingEntityRecognizerError {
            meta: generic,
            kind: crate::error::StopTrainingEntityRecognizerErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTrainingEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::StopTrainingEntityRecognizerError {
            meta: generic,
            kind: crate::error::StopTrainingEntityRecognizerErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTrainingEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::StopTrainingEntityRecognizerError {
            meta: generic,
            kind: crate::error::StopTrainingEntityRecognizerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTrainingEntityRecognizerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopTrainingEntityRecognizerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_training_entity_recognizer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopTrainingEntityRecognizerOutput,
    crate::error::StopTrainingEntityRecognizerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_training_entity_recognizer_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagKeysException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::TooManyTagKeysException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tag_keys_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tag_keys_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateEndpointOutput, crate::error::UpdateEndpointError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::UpdateEndpointError {
            meta: generic,
            kind: crate::error::UpdateEndpointErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::UpdateEndpointError {
            meta: generic,
            kind: crate::error::UpdateEndpointErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::UpdateEndpointError {
            meta: generic,
            kind: crate::error::UpdateEndpointErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceededException" => crate::error::UpdateEndpointError {
            meta: generic,
            kind: crate::error::UpdateEndpointErrorKind::ResourceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateEndpointError {
            meta: generic,
            kind: crate::error::UpdateEndpointErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceUnavailableException" => crate::error::UpdateEndpointError {
            meta: generic,
            kind: crate::error::UpdateEndpointErrorKind::ResourceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateEndpointError {
            meta: generic,
            kind: crate::error::UpdateEndpointErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateEndpointOutput, crate::error::UpdateEndpointError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_endpoint_output::Builder::default();
        let _ = response;
        output.build()
    })
}
