// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Comprehend
///
/// Client for invoking operations on Amazon Comprehend. Each operation on Amazon Comprehend is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_comprehend::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_comprehend::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_comprehend::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchDetectDominantLanguage`](crate::client::fluent_builders::BatchDetectDominantLanguage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text_list(Vec<String>)`](crate::client::fluent_builders::BatchDetectDominantLanguage::text_list) / [`set_text_list(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDetectDominantLanguage::set_text_list): <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document should contain at least 20 characters and must contain fewer than 5,000 bytes of UTF-8 encoded characters.</p>
    /// - On success, responds with [`BatchDetectDominantLanguageOutput`](crate::output::BatchDetectDominantLanguageOutput) with field(s):
    ///   - [`result_list(Option<Vec<BatchDetectDominantLanguageItemResult>>)`](crate::output::BatchDetectDominantLanguageOutput::result_list): <p>A list of objects containing the results of the operation. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain an error, the <code>ResultList</code> is empty.</p>
    ///   - [`error_list(Option<Vec<BatchItemError>>)`](crate::output::BatchDetectDominantLanguageOutput::error_list): <p>A list containing one object for each document that contained an error. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in the batch, the <code>ErrorList</code> is empty.</p>
    /// - On failure, responds with [`SdkError<BatchDetectDominantLanguageError>`](crate::error::BatchDetectDominantLanguageError)
    pub fn batch_detect_dominant_language(&self) -> fluent_builders::BatchDetectDominantLanguage {
        fluent_builders::BatchDetectDominantLanguage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDetectEntities`](crate::client::fluent_builders::BatchDetectEntities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text_list(Vec<String>)`](crate::client::fluent_builders::BatchDetectEntities::text_list) / [`set_text_list(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDetectEntities::set_text_list): <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer than 5,000 bytes of UTF-8 encoded characters.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::BatchDetectEntities::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::BatchDetectEntities::set_language_code): <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
    /// - On success, responds with [`BatchDetectEntitiesOutput`](crate::output::BatchDetectEntitiesOutput) with field(s):
    ///   - [`result_list(Option<Vec<BatchDetectEntitiesItemResult>>)`](crate::output::BatchDetectEntitiesOutput::result_list): <p>A list of objects containing the results of the operation. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain an error, the <code>ResultList</code> is empty.</p>
    ///   - [`error_list(Option<Vec<BatchItemError>>)`](crate::output::BatchDetectEntitiesOutput::error_list): <p>A list containing one object for each document that contained an error. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in the batch, the <code>ErrorList</code> is empty.</p>
    /// - On failure, responds with [`SdkError<BatchDetectEntitiesError>`](crate::error::BatchDetectEntitiesError)
    pub fn batch_detect_entities(&self) -> fluent_builders::BatchDetectEntities {
        fluent_builders::BatchDetectEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDetectKeyPhrases`](crate::client::fluent_builders::BatchDetectKeyPhrases) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text_list(Vec<String>)`](crate::client::fluent_builders::BatchDetectKeyPhrases::text_list) / [`set_text_list(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDetectKeyPhrases::set_text_list): <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::BatchDetectKeyPhrases::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::BatchDetectKeyPhrases::set_language_code): <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
    /// - On success, responds with [`BatchDetectKeyPhrasesOutput`](crate::output::BatchDetectKeyPhrasesOutput) with field(s):
    ///   - [`result_list(Option<Vec<BatchDetectKeyPhrasesItemResult>>)`](crate::output::BatchDetectKeyPhrasesOutput::result_list): <p>A list of objects containing the results of the operation. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain an error, the <code>ResultList</code> is empty.</p>
    ///   - [`error_list(Option<Vec<BatchItemError>>)`](crate::output::BatchDetectKeyPhrasesOutput::error_list): <p>A list containing one object for each document that contained an error. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in the batch, the <code>ErrorList</code> is empty.</p>
    /// - On failure, responds with [`SdkError<BatchDetectKeyPhrasesError>`](crate::error::BatchDetectKeyPhrasesError)
    pub fn batch_detect_key_phrases(&self) -> fluent_builders::BatchDetectKeyPhrases {
        fluent_builders::BatchDetectKeyPhrases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDetectSentiment`](crate::client::fluent_builders::BatchDetectSentiment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text_list(Vec<String>)`](crate::client::fluent_builders::BatchDetectSentiment::text_list) / [`set_text_list(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDetectSentiment::set_text_list): <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::BatchDetectSentiment::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::BatchDetectSentiment::set_language_code): <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
    /// - On success, responds with [`BatchDetectSentimentOutput`](crate::output::BatchDetectSentimentOutput) with field(s):
    ///   - [`result_list(Option<Vec<BatchDetectSentimentItemResult>>)`](crate::output::BatchDetectSentimentOutput::result_list): <p>A list of objects containing the results of the operation. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain an error, the <code>ResultList</code> is empty.</p>
    ///   - [`error_list(Option<Vec<BatchItemError>>)`](crate::output::BatchDetectSentimentOutput::error_list): <p>A list containing one object for each document that contained an error. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in the batch, the <code>ErrorList</code> is empty.</p>
    /// - On failure, responds with [`SdkError<BatchDetectSentimentError>`](crate::error::BatchDetectSentimentError)
    pub fn batch_detect_sentiment(&self) -> fluent_builders::BatchDetectSentiment {
        fluent_builders::BatchDetectSentiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDetectSyntax`](crate::client::fluent_builders::BatchDetectSyntax) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text_list(Vec<String>)`](crate::client::fluent_builders::BatchDetectSyntax::text_list) / [`set_text_list(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDetectSyntax::set_text_list): <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
    ///   - [`language_code(SyntaxLanguageCode)`](crate::client::fluent_builders::BatchDetectSyntax::language_code) / [`set_language_code(Option<SyntaxLanguageCode>)`](crate::client::fluent_builders::BatchDetectSyntax::set_language_code): <p>The language of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
    /// - On success, responds with [`BatchDetectSyntaxOutput`](crate::output::BatchDetectSyntaxOutput) with field(s):
    ///   - [`result_list(Option<Vec<BatchDetectSyntaxItemResult>>)`](crate::output::BatchDetectSyntaxOutput::result_list): <p>A list of objects containing the results of the operation. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain an error, the <code>ResultList</code> is empty.</p>
    ///   - [`error_list(Option<Vec<BatchItemError>>)`](crate::output::BatchDetectSyntaxOutput::error_list): <p>A list containing one object for each document that contained an error. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in the batch, the <code>ErrorList</code> is empty.</p>
    /// - On failure, responds with [`SdkError<BatchDetectSyntaxError>`](crate::error::BatchDetectSyntaxError)
    pub fn batch_detect_syntax(&self) -> fluent_builders::BatchDetectSyntax {
        fluent_builders::BatchDetectSyntax::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ClassifyDocument`](crate::client::fluent_builders::ClassifyDocument) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::ClassifyDocument::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::ClassifyDocument::set_text): <p>The document text to be analyzed.</p>
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::ClassifyDocument::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::ClassifyDocument::set_endpoint_arn): <p>The Amazon Resource Number (ARN) of the endpoint.</p>
    /// - On success, responds with [`ClassifyDocumentOutput`](crate::output::ClassifyDocumentOutput) with field(s):
    ///   - [`classes(Option<Vec<DocumentClass>>)`](crate::output::ClassifyDocumentOutput::classes): <p>The classes used by the document being analyzed. These are used for multi-class trained models. Individual classes are mutually exclusive and each document is expected to have only a single class assigned to it. For example, an animal can be a dog or a cat, but not both at the same time. </p>
    ///   - [`labels(Option<Vec<DocumentLabel>>)`](crate::output::ClassifyDocumentOutput::labels): <p>The labels used the document being analyzed. These are used for multi-label trained models. Individual labels represent different categories that are related in some manner and are not mutually exclusive. For example, a movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all at the same time. </p>
    /// - On failure, responds with [`SdkError<ClassifyDocumentError>`](crate::error::ClassifyDocumentError)
    pub fn classify_document(&self) -> fluent_builders::ClassifyDocument {
        fluent_builders::ClassifyDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ContainsPiiEntities`](crate::client::fluent_builders::ContainsPiiEntities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::ContainsPiiEntities::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::ContainsPiiEntities::set_text): <p>Creates a new document classification request to analyze a single document in real-time, returning personally identifiable information (PII) entity labels.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::ContainsPiiEntities::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::ContainsPiiEntities::set_language_code): <p>The language of the input documents.</p>
    /// - On success, responds with [`ContainsPiiEntitiesOutput`](crate::output::ContainsPiiEntitiesOutput) with field(s):
    ///   - [`labels(Option<Vec<EntityLabel>>)`](crate::output::ContainsPiiEntitiesOutput::labels): <p>The labels used in the document being analyzed. Individual labels represent personally identifiable information (PII) entity types.</p>
    /// - On failure, responds with [`SdkError<ContainsPiiEntitiesError>`](crate::error::ContainsPiiEntitiesError)
    pub fn contains_pii_entities(&self) -> fluent_builders::ContainsPiiEntities {
        fluent_builders::ContainsPiiEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDocumentClassifier`](crate::client::fluent_builders::CreateDocumentClassifier) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document_classifier_name(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::document_classifier_name) / [`set_document_classifier_name(Option<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_document_classifier_name): <p>The name of the document classifier.</p>
    ///   - [`version_name(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::version_name) / [`set_version_name(Option<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_version_name): <p>The version name given to the newly created classifier. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the account/AWS Region.</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDocumentClassifier::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_tags): <p>Tags to be associated with the document classifier being created. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>
    ///   - [`input_data_config(DocumentClassifierInputDataConfig)`](crate::client::fluent_builders::CreateDocumentClassifier::input_data_config) / [`set_input_data_config(Option<DocumentClassifierInputDataConfig>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_input_data_config): <p>Specifies the format and location of the input data for the job.</p>
    ///   - [`output_data_config(DocumentClassifierOutputDataConfig)`](crate::client::fluent_builders::CreateDocumentClassifier::output_data_config) / [`set_output_data_config(Option<DocumentClassifierOutputDataConfig>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_output_data_config): <p>Enables the addition of output results configuration parameters for custom classifier jobs.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_client_request_token): <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::CreateDocumentClassifier::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_language_code): <p>The language of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
    ///   - [`volume_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::volume_kms_key_id) / [`set_volume_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_volume_kms_key_id): <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>  <ul>   <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>   <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>  </ul>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::CreateDocumentClassifier::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_vpc_config): <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
    ///   - [`mode(DocumentClassifierMode)`](crate::client::fluent_builders::CreateDocumentClassifier::mode) / [`set_mode(Option<DocumentClassifierMode>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_mode): <p>Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class mode, which identifies one and only one class for each document, or multi-label mode, which identifies one or more labels for each document. In multi-label mode, multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).</p>
    ///   - [`model_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::model_kms_key_id) / [`set_model_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_model_kms_key_id): <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p>  <ul>   <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>   <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>  </ul>
    ///   - [`model_policy(impl Into<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::model_policy) / [`set_model_policy(Option<String>)`](crate::client::fluent_builders::CreateDocumentClassifier::set_model_policy): <p>The resource-based policy to attach to your custom document classifier model. You can use this policy to allow another AWS account to import your custom model.</p>  <p>Provide your policy as a JSON body that you enter as a UTF-8 encoded string without line breaks. To provide valid JSON, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p>  <p> <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code> </p>  <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p>  <p> <code>'{"attribute": "value", "attribute": ["value"]}'</code> </p>
    /// - On success, responds with [`CreateDocumentClassifierOutput`](crate::output::CreateDocumentClassifierOutput) with field(s):
    ///   - [`document_classifier_arn(Option<String>)`](crate::output::CreateDocumentClassifierOutput::document_classifier_arn): <p>The Amazon Resource Name (ARN) that identifies the document classifier.</p>
    /// - On failure, responds with [`SdkError<CreateDocumentClassifierError>`](crate::error::CreateDocumentClassifierError)
    pub fn create_document_classifier(&self) -> fluent_builders::CreateDocumentClassifier {
        fluent_builders::CreateDocumentClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEndpoint`](crate::client::fluent_builders::CreateEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_name(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::endpoint_name) / [`set_endpoint_name(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_endpoint_name): <p>This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for all subsequent requests to this resource. </p>
    ///   - [`model_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::model_arn) / [`set_model_arn(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_model_arn): <p>The Amazon Resource Number (ARN) of the model to which the endpoint will be attached.</p>
    ///   - [`desired_inference_units(i32)`](crate::client::fluent_builders::CreateEndpoint::desired_inference_units) / [`set_desired_inference_units(Option<i32>)`](crate::client::fluent_builders::CreateEndpoint::set_desired_inference_units): <p> The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_client_request_token): <p>An idempotency token provided by the customer. If this token matches a previous endpoint creation request, Amazon Comprehend will not return a <code>ResourceInUseException</code>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEndpoint::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEndpoint::set_tags): <p>Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the sales department. </p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).</p>
    /// - On success, responds with [`CreateEndpointOutput`](crate::output::CreateEndpointOutput) with field(s):
    ///   - [`endpoint_arn(Option<String>)`](crate::output::CreateEndpointOutput::endpoint_arn): <p>The Amazon Resource Number (ARN) of the endpoint being created.</p>
    /// - On failure, responds with [`SdkError<CreateEndpointError>`](crate::error::CreateEndpointError)
    pub fn create_endpoint(&self) -> fluent_builders::CreateEndpoint {
        fluent_builders::CreateEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEntityRecognizer`](crate::client::fluent_builders::CreateEntityRecognizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recognizer_name(impl Into<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::recognizer_name) / [`set_recognizer_name(Option<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::set_recognizer_name): <p>The name given to the newly created recognizer. Recognizer names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name must be unique in the account/region.</p>
    ///   - [`version_name(impl Into<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::version_name) / [`set_version_name(Option<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::set_version_name): <p>The version name given to the newly created recognizer. Version names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same recognizer name in the account/ AWS Region.</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEntityRecognizer::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEntityRecognizer::set_tags): <p>Tags to be associated with the entity recognizer being created. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>
    ///   - [`input_data_config(EntityRecognizerInputDataConfig)`](crate::client::fluent_builders::CreateEntityRecognizer::input_data_config) / [`set_input_data_config(Option<EntityRecognizerInputDataConfig>)`](crate::client::fluent_builders::CreateEntityRecognizer::set_input_data_config): <p>Specifies the format and location of the input data. The S3 bucket containing the input data must be located in the same region as the entity recognizer being created. </p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::set_client_request_token): <p> A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::CreateEntityRecognizer::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::CreateEntityRecognizer::set_language_code): <p> You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in the same language.</p>
    ///   - [`volume_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::volume_kms_key_id) / [`set_volume_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::set_volume_kms_key_id): <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>  <ul>   <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>   <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>  </ul>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::CreateEntityRecognizer::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::CreateEntityRecognizer::set_vpc_config): <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your custom entity recognizer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
    ///   - [`model_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::model_kms_key_id) / [`set_model_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::set_model_kms_key_id): <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats</p>  <ul>   <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>   <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>  </ul>
    ///   - [`model_policy(impl Into<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::model_policy) / [`set_model_policy(Option<String>)`](crate::client::fluent_builders::CreateEntityRecognizer::set_model_policy): <p>The JSON resource-based policy to attach to your custom entity recognizer model. You can use this policy to allow another AWS account to import your custom model.</p>  <p>Provide your JSON as a UTF-8 encoded string without line breaks. To provide valid JSON for your policy, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p>  <p> <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code> </p>  <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p>  <p> <code>'{"attribute": "value", "attribute": ["value"]}'</code> </p>
    /// - On success, responds with [`CreateEntityRecognizerOutput`](crate::output::CreateEntityRecognizerOutput) with field(s):
    ///   - [`entity_recognizer_arn(Option<String>)`](crate::output::CreateEntityRecognizerOutput::entity_recognizer_arn): <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
    /// - On failure, responds with [`SdkError<CreateEntityRecognizerError>`](crate::error::CreateEntityRecognizerError)
    pub fn create_entity_recognizer(&self) -> fluent_builders::CreateEntityRecognizer {
        fluent_builders::CreateEntityRecognizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDocumentClassifier`](crate::client::fluent_builders::DeleteDocumentClassifier) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document_classifier_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteDocumentClassifier::document_classifier_arn) / [`set_document_classifier_arn(Option<String>)`](crate::client::fluent_builders::DeleteDocumentClassifier::set_document_classifier_arn): <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
    /// - On success, responds with [`DeleteDocumentClassifierOutput`](crate::output::DeleteDocumentClassifierOutput)

    /// - On failure, responds with [`SdkError<DeleteDocumentClassifierError>`](crate::error::DeleteDocumentClassifierError)
    pub fn delete_document_classifier(&self) -> fluent_builders::DeleteDocumentClassifier {
        fluent_builders::DeleteDocumentClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEndpoint`](crate::client::fluent_builders::DeleteEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteEndpoint::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::DeleteEndpoint::set_endpoint_arn): <p>The Amazon Resource Number (ARN) of the endpoint being deleted.</p>
    /// - On success, responds with [`DeleteEndpointOutput`](crate::output::DeleteEndpointOutput)

    /// - On failure, responds with [`SdkError<DeleteEndpointError>`](crate::error::DeleteEndpointError)
    pub fn delete_endpoint(&self) -> fluent_builders::DeleteEndpoint {
        fluent_builders::DeleteEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEntityRecognizer`](crate::client::fluent_builders::DeleteEntityRecognizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`entity_recognizer_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteEntityRecognizer::entity_recognizer_arn) / [`set_entity_recognizer_arn(Option<String>)`](crate::client::fluent_builders::DeleteEntityRecognizer::set_entity_recognizer_arn): <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
    /// - On success, responds with [`DeleteEntityRecognizerOutput`](crate::output::DeleteEntityRecognizerOutput)

    /// - On failure, responds with [`SdkError<DeleteEntityRecognizerError>`](crate::error::DeleteEntityRecognizerError)
    pub fn delete_entity_recognizer(&self) -> fluent_builders::DeleteEntityRecognizer {
        fluent_builders::DeleteEntityRecognizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the custom model version that has the policy to delete.</p>
    ///   - [`policy_revision_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::policy_revision_id) / [`set_policy_revision_id(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::set_policy_revision_id): <p>The revision ID of the policy to delete.</p>
    /// - On success, responds with [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteResourcePolicyError>`](crate::error::DeleteResourcePolicyError)
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDocumentClassificationJob`](crate::client::fluent_builders::DescribeDocumentClassificationJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDocumentClassificationJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeDocumentClassificationJob::set_job_id): <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
    /// - On success, responds with [`DescribeDocumentClassificationJobOutput`](crate::output::DescribeDocumentClassificationJobOutput) with field(s):
    ///   - [`document_classification_job_properties(Option<DocumentClassificationJobProperties>)`](crate::output::DescribeDocumentClassificationJobOutput::document_classification_job_properties): <p>An object that describes the properties associated with the document classification job.</p>
    /// - On failure, responds with [`SdkError<DescribeDocumentClassificationJobError>`](crate::error::DescribeDocumentClassificationJobError)
    pub fn describe_document_classification_job(
        &self,
    ) -> fluent_builders::DescribeDocumentClassificationJob {
        fluent_builders::DescribeDocumentClassificationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDocumentClassifier`](crate::client::fluent_builders::DescribeDocumentClassifier) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document_classifier_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeDocumentClassifier::document_classifier_arn) / [`set_document_classifier_arn(Option<String>)`](crate::client::fluent_builders::DescribeDocumentClassifier::set_document_classifier_arn): <p>The Amazon Resource Name (ARN) that identifies the document classifier. The operation returns this identifier in its response.</p>
    /// - On success, responds with [`DescribeDocumentClassifierOutput`](crate::output::DescribeDocumentClassifierOutput) with field(s):
    ///   - [`document_classifier_properties(Option<DocumentClassifierProperties>)`](crate::output::DescribeDocumentClassifierOutput::document_classifier_properties): <p>An object that contains the properties associated with a document classifier.</p>
    /// - On failure, responds with [`SdkError<DescribeDocumentClassifierError>`](crate::error::DescribeDocumentClassifierError)
    pub fn describe_document_classifier(&self) -> fluent_builders::DescribeDocumentClassifier {
        fluent_builders::DescribeDocumentClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDominantLanguageDetectionJob`](crate::client::fluent_builders::DescribeDominantLanguageDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDominantLanguageDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeDominantLanguageDetectionJob::set_job_id): <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
    /// - On success, responds with [`DescribeDominantLanguageDetectionJobOutput`](crate::output::DescribeDominantLanguageDetectionJobOutput) with field(s):
    ///   - [`dominant_language_detection_job_properties(Option<DominantLanguageDetectionJobProperties>)`](crate::output::DescribeDominantLanguageDetectionJobOutput::dominant_language_detection_job_properties): <p>An object that contains the properties associated with a dominant language detection job.</p>
    /// - On failure, responds with [`SdkError<DescribeDominantLanguageDetectionJobError>`](crate::error::DescribeDominantLanguageDetectionJobError)
    pub fn describe_dominant_language_detection_job(
        &self,
    ) -> fluent_builders::DescribeDominantLanguageDetectionJob {
        fluent_builders::DescribeDominantLanguageDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEndpoint`](crate::client::fluent_builders::DescribeEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpoint::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::DescribeEndpoint::set_endpoint_arn): <p>The Amazon Resource Number (ARN) of the endpoint being described.</p>
    /// - On success, responds with [`DescribeEndpointOutput`](crate::output::DescribeEndpointOutput) with field(s):
    ///   - [`endpoint_properties(Option<EndpointProperties>)`](crate::output::DescribeEndpointOutput::endpoint_properties): <p>Describes information associated with the specific endpoint.</p>
    /// - On failure, responds with [`SdkError<DescribeEndpointError>`](crate::error::DescribeEndpointError)
    pub fn describe_endpoint(&self) -> fluent_builders::DescribeEndpoint {
        fluent_builders::DescribeEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEntitiesDetectionJob`](crate::client::fluent_builders::DescribeEntitiesDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEntitiesDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeEntitiesDetectionJob::set_job_id): <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
    /// - On success, responds with [`DescribeEntitiesDetectionJobOutput`](crate::output::DescribeEntitiesDetectionJobOutput) with field(s):
    ///   - [`entities_detection_job_properties(Option<EntitiesDetectionJobProperties>)`](crate::output::DescribeEntitiesDetectionJobOutput::entities_detection_job_properties): <p>An object that contains the properties associated with an entities detection job.</p>
    /// - On failure, responds with [`SdkError<DescribeEntitiesDetectionJobError>`](crate::error::DescribeEntitiesDetectionJobError)
    pub fn describe_entities_detection_job(&self) -> fluent_builders::DescribeEntitiesDetectionJob {
        fluent_builders::DescribeEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEntityRecognizer`](crate::client::fluent_builders::DescribeEntityRecognizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`entity_recognizer_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeEntityRecognizer::entity_recognizer_arn) / [`set_entity_recognizer_arn(Option<String>)`](crate::client::fluent_builders::DescribeEntityRecognizer::set_entity_recognizer_arn): <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
    /// - On success, responds with [`DescribeEntityRecognizerOutput`](crate::output::DescribeEntityRecognizerOutput) with field(s):
    ///   - [`entity_recognizer_properties(Option<EntityRecognizerProperties>)`](crate::output::DescribeEntityRecognizerOutput::entity_recognizer_properties): <p>Describes information associated with an entity recognizer.</p>
    /// - On failure, responds with [`SdkError<DescribeEntityRecognizerError>`](crate::error::DescribeEntityRecognizerError)
    pub fn describe_entity_recognizer(&self) -> fluent_builders::DescribeEntityRecognizer {
        fluent_builders::DescribeEntityRecognizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventsDetectionJob`](crate::client::fluent_builders::DescribeEventsDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEventsDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeEventsDetectionJob::set_job_id): <p>The identifier of the events detection job.</p>
    /// - On success, responds with [`DescribeEventsDetectionJobOutput`](crate::output::DescribeEventsDetectionJobOutput) with field(s):
    ///   - [`events_detection_job_properties(Option<EventsDetectionJobProperties>)`](crate::output::DescribeEventsDetectionJobOutput::events_detection_job_properties): <p>An object that contains the properties associated with an event detection job.</p>
    /// - On failure, responds with [`SdkError<DescribeEventsDetectionJobError>`](crate::error::DescribeEventsDetectionJobError)
    pub fn describe_events_detection_job(&self) -> fluent_builders::DescribeEventsDetectionJob {
        fluent_builders::DescribeEventsDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeKeyPhrasesDetectionJob`](crate::client::fluent_builders::DescribeKeyPhrasesDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeKeyPhrasesDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeKeyPhrasesDetectionJob::set_job_id): <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
    /// - On success, responds with [`DescribeKeyPhrasesDetectionJobOutput`](crate::output::DescribeKeyPhrasesDetectionJobOutput) with field(s):
    ///   - [`key_phrases_detection_job_properties(Option<KeyPhrasesDetectionJobProperties>)`](crate::output::DescribeKeyPhrasesDetectionJobOutput::key_phrases_detection_job_properties): <p>An object that contains the properties associated with a key phrases detection job. </p>
    /// - On failure, responds with [`SdkError<DescribeKeyPhrasesDetectionJobError>`](crate::error::DescribeKeyPhrasesDetectionJobError)
    pub fn describe_key_phrases_detection_job(
        &self,
    ) -> fluent_builders::DescribeKeyPhrasesDetectionJob {
        fluent_builders::DescribeKeyPhrasesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePiiEntitiesDetectionJob`](crate::client::fluent_builders::DescribePiiEntitiesDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribePiiEntitiesDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribePiiEntitiesDetectionJob::set_job_id): <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
    /// - On success, responds with [`DescribePiiEntitiesDetectionJobOutput`](crate::output::DescribePiiEntitiesDetectionJobOutput) with field(s):
    ///   - [`pii_entities_detection_job_properties(Option<PiiEntitiesDetectionJobProperties>)`](crate::output::DescribePiiEntitiesDetectionJobOutput::pii_entities_detection_job_properties): <p>Provides information about a PII entities detection job.</p>
    /// - On failure, responds with [`SdkError<DescribePiiEntitiesDetectionJobError>`](crate::error::DescribePiiEntitiesDetectionJobError)
    pub fn describe_pii_entities_detection_job(
        &self,
    ) -> fluent_builders::DescribePiiEntitiesDetectionJob {
        fluent_builders::DescribePiiEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResourcePolicy`](crate::client::fluent_builders::DescribeResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DescribeResourcePolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the policy to describe.</p>
    /// - On success, responds with [`DescribeResourcePolicyOutput`](crate::output::DescribeResourcePolicyOutput) with field(s):
    ///   - [`resource_policy(Option<String>)`](crate::output::DescribeResourcePolicyOutput::resource_policy): <p>The JSON body of the resource-based policy.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeResourcePolicyOutput::creation_time): <p>The time at which the policy was created.</p>
    ///   - [`last_modified_time(Option<DateTime>)`](crate::output::DescribeResourcePolicyOutput::last_modified_time): <p>The time at which the policy was last modified.</p>
    ///   - [`policy_revision_id(Option<String>)`](crate::output::DescribeResourcePolicyOutput::policy_revision_id): <p>The revision ID of the policy. Each time you modify a policy, Amazon Comprehend assigns a new revision ID, and it deletes the prior version of the policy.</p>
    /// - On failure, responds with [`SdkError<DescribeResourcePolicyError>`](crate::error::DescribeResourcePolicyError)
    pub fn describe_resource_policy(&self) -> fluent_builders::DescribeResourcePolicy {
        fluent_builders::DescribeResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSentimentDetectionJob`](crate::client::fluent_builders::DescribeSentimentDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSentimentDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeSentimentDetectionJob::set_job_id): <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
    /// - On success, responds with [`DescribeSentimentDetectionJobOutput`](crate::output::DescribeSentimentDetectionJobOutput) with field(s):
    ///   - [`sentiment_detection_job_properties(Option<SentimentDetectionJobProperties>)`](crate::output::DescribeSentimentDetectionJobOutput::sentiment_detection_job_properties): <p>An object that contains the properties associated with a sentiment detection job.</p>
    /// - On failure, responds with [`SdkError<DescribeSentimentDetectionJobError>`](crate::error::DescribeSentimentDetectionJobError)
    pub fn describe_sentiment_detection_job(
        &self,
    ) -> fluent_builders::DescribeSentimentDetectionJob {
        fluent_builders::DescribeSentimentDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTopicsDetectionJob`](crate::client::fluent_builders::DescribeTopicsDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTopicsDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeTopicsDetectionJob::set_job_id): <p>The identifier assigned by the user to the detection job.</p>
    /// - On success, responds with [`DescribeTopicsDetectionJobOutput`](crate::output::DescribeTopicsDetectionJobOutput) with field(s):
    ///   - [`topics_detection_job_properties(Option<TopicsDetectionJobProperties>)`](crate::output::DescribeTopicsDetectionJobOutput::topics_detection_job_properties): <p>The list of properties for the requested job.</p>
    /// - On failure, responds with [`SdkError<DescribeTopicsDetectionJobError>`](crate::error::DescribeTopicsDetectionJobError)
    pub fn describe_topics_detection_job(&self) -> fluent_builders::DescribeTopicsDetectionJob {
        fluent_builders::DescribeTopicsDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectDominantLanguage`](crate::client::fluent_builders::DetectDominantLanguage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::DetectDominantLanguage::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::DetectDominantLanguage::set_text): <p>A UTF-8 text string. Each string should contain at least 20 characters and must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
    /// - On success, responds with [`DetectDominantLanguageOutput`](crate::output::DetectDominantLanguageOutput) with field(s):
    ///   - [`languages(Option<Vec<DominantLanguage>>)`](crate::output::DetectDominantLanguageOutput::languages): <p>The languages that Amazon Comprehend detected in the input text. For each language, the response returns the RFC 5646 language code and the level of confidence that Amazon Comprehend has in the accuracy of its inference. For more information about RFC 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i> web site.</p>
    /// - On failure, responds with [`SdkError<DetectDominantLanguageError>`](crate::error::DetectDominantLanguageError)
    pub fn detect_dominant_language(&self) -> fluent_builders::DetectDominantLanguage {
        fluent_builders::DetectDominantLanguage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectEntities`](crate::client::fluent_builders::DetectEntities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::DetectEntities::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::DetectEntities::set_text): <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::DetectEntities::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::DetectEntities::set_language_code): <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>  <p>If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you specify here.</p>
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::DetectEntities::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::DetectEntities::set_endpoint_arn): <p>The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an endpoint if you want to detect entities by using your own custom model instead of the default model that is used by Amazon Comprehend.</p>  <p>If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you provide in your request.</p>
    /// - On success, responds with [`DetectEntitiesOutput`](crate::output::DetectEntitiesOutput) with field(s):
    ///   - [`entities(Option<Vec<Entity>>)`](crate::output::DetectEntitiesOutput::entities): <p>A collection of entities identified in the input text. For each entity, the response provides the entity text, entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend has in the detection. </p>  <p>If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model is trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types, see <code>how-entities</code>.</p>
    /// - On failure, responds with [`SdkError<DetectEntitiesError>`](crate::error::DetectEntitiesError)
    pub fn detect_entities(&self) -> fluent_builders::DetectEntities {
        fluent_builders::DetectEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectKeyPhrases`](crate::client::fluent_builders::DetectKeyPhrases) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::DetectKeyPhrases::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::DetectKeyPhrases::set_text): <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::DetectKeyPhrases::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::DetectKeyPhrases::set_language_code): <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
    /// - On success, responds with [`DetectKeyPhrasesOutput`](crate::output::DetectKeyPhrasesOutput) with field(s):
    ///   - [`key_phrases(Option<Vec<KeyPhrase>>)`](crate::output::DetectKeyPhrasesOutput::key_phrases): <p>A collection of key phrases that Amazon Comprehend identified in the input text. For each key phrase, the response provides the text of the key phrase, where the key phrase begins and ends, and the level of confidence that Amazon Comprehend has in the accuracy of the detection. </p>
    /// - On failure, responds with [`SdkError<DetectKeyPhrasesError>`](crate::error::DetectKeyPhrasesError)
    pub fn detect_key_phrases(&self) -> fluent_builders::DetectKeyPhrases {
        fluent_builders::DetectKeyPhrases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectPiiEntities`](crate::client::fluent_builders::DetectPiiEntities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::DetectPiiEntities::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::DetectPiiEntities::set_text): <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::DetectPiiEntities::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::DetectPiiEntities::set_language_code): <p>The language of the input documents.</p>
    /// - On success, responds with [`DetectPiiEntitiesOutput`](crate::output::DetectPiiEntitiesOutput) with field(s):
    ///   - [`entities(Option<Vec<PiiEntity>>)`](crate::output::DetectPiiEntitiesOutput::entities): <p>A collection of PII entities identified in the input text. For each entity, the response provides the entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend has in the detection.</p>
    /// - On failure, responds with [`SdkError<DetectPiiEntitiesError>`](crate::error::DetectPiiEntitiesError)
    pub fn detect_pii_entities(&self) -> fluent_builders::DetectPiiEntities {
        fluent_builders::DetectPiiEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectSentiment`](crate::client::fluent_builders::DetectSentiment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::DetectSentiment::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::DetectSentiment::set_text): <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::DetectSentiment::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::DetectSentiment::set_language_code): <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
    /// - On success, responds with [`DetectSentimentOutput`](crate::output::DetectSentimentOutput) with field(s):
    ///   - [`sentiment(Option<SentimentType>)`](crate::output::DetectSentimentOutput::sentiment): <p>The inferred sentiment that Amazon Comprehend has the highest level of confidence in.</p>
    ///   - [`sentiment_score(Option<SentimentScore>)`](crate::output::DetectSentimentOutput::sentiment_score): <p>An object that lists the sentiments, and their corresponding confidence levels.</p>
    /// - On failure, responds with [`SdkError<DetectSentimentError>`](crate::error::DetectSentimentError)
    pub fn detect_sentiment(&self) -> fluent_builders::DetectSentiment {
        fluent_builders::DetectSentiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectSyntax`](crate::client::fluent_builders::DetectSyntax) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::DetectSyntax::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::DetectSyntax::set_text): <p>A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF encoded characters.</p>
    ///   - [`language_code(SyntaxLanguageCode)`](crate::client::fluent_builders::DetectSyntax::language_code) / [`set_language_code(Option<SyntaxLanguageCode>)`](crate::client::fluent_builders::DetectSyntax::set_language_code): <p>The language code of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt").</p>
    /// - On success, responds with [`DetectSyntaxOutput`](crate::output::DetectSyntaxOutput) with field(s):
    ///   - [`syntax_tokens(Option<Vec<SyntaxToken>>)`](crate::output::DetectSyntaxOutput::syntax_tokens): <p>A collection of syntax tokens describing the text. For each token, the response provides the text, the token type, where the text begins and ends, and the level of confidence that Amazon Comprehend has that the token is correct. For a list of token types, see <code>how-syntax</code>.</p>
    /// - On failure, responds with [`SdkError<DetectSyntaxError>`](crate::error::DetectSyntaxError)
    pub fn detect_syntax(&self) -> fluent_builders::DetectSyntax {
        fluent_builders::DetectSyntax::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportModel`](crate::client::fluent_builders::ImportModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_model_arn(impl Into<String>)`](crate::client::fluent_builders::ImportModel::source_model_arn) / [`set_source_model_arn(Option<String>)`](crate::client::fluent_builders::ImportModel::set_source_model_arn): <p>The Amazon Resource Name (ARN) of the custom model to import.</p>
    ///   - [`model_name(impl Into<String>)`](crate::client::fluent_builders::ImportModel::model_name) / [`set_model_name(Option<String>)`](crate::client::fluent_builders::ImportModel::set_model_name): <p>The name to assign to the custom model that is created in Amazon Comprehend by this import.</p>
    ///   - [`version_name(impl Into<String>)`](crate::client::fluent_builders::ImportModel::version_name) / [`set_version_name(Option<String>)`](crate::client::fluent_builders::ImportModel::set_version_name): <p>The version name given to the custom model that is created by this import. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the account/AWS Region.</p>
    ///   - [`model_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::ImportModel::model_kms_key_id) / [`set_model_kms_key_id(Option<String>)`](crate::client::fluent_builders::ImportModel::set_model_kms_key_id): <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p>  <ul>   <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>   <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>  </ul>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::ImportModel::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::ImportModel::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that allows Amazon Comprehend to use Amazon Key Management Service (KMS) to encrypt or decrypt the custom model.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::ImportModel::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::ImportModel::set_tags): <p>Tags to be associated with the custom model that is created by this import. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
    /// - On success, responds with [`ImportModelOutput`](crate::output::ImportModelOutput) with field(s):
    ///   - [`model_arn(Option<String>)`](crate::output::ImportModelOutput::model_arn): <p>The Amazon Resource Name (ARN) of the custom model being imported.</p>
    /// - On failure, responds with [`SdkError<ImportModelError>`](crate::error::ImportModelError)
    pub fn import_model(&self) -> fluent_builders::ImportModel {
        fluent_builders::ImportModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDocumentClassificationJobs`](crate::client::fluent_builders::ListDocumentClassificationJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDocumentClassificationJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(DocumentClassificationJobFilter)`](crate::client::fluent_builders::ListDocumentClassificationJobs::filter) / [`set_filter(Option<DocumentClassificationJobFilter>)`](crate::client::fluent_builders::ListDocumentClassificationJobs::set_filter): <p>Filters the jobs that are returned. You can filter jobs on their names, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDocumentClassificationJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDocumentClassificationJobs::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDocumentClassificationJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDocumentClassificationJobs::set_max_results): <p>The maximum number of results to return in each page. The default is 100.</p>
    /// - On success, responds with [`ListDocumentClassificationJobsOutput`](crate::output::ListDocumentClassificationJobsOutput) with field(s):
    ///   - [`document_classification_job_properties_list(Option<Vec<DocumentClassificationJobProperties>>)`](crate::output::ListDocumentClassificationJobsOutput::document_classification_job_properties_list): <p>A list containing the properties of each job returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDocumentClassificationJobsOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListDocumentClassificationJobsError>`](crate::error::ListDocumentClassificationJobsError)
    pub fn list_document_classification_jobs(
        &self,
    ) -> fluent_builders::ListDocumentClassificationJobs {
        fluent_builders::ListDocumentClassificationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDocumentClassifiers`](crate::client::fluent_builders::ListDocumentClassifiers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDocumentClassifiers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(DocumentClassifierFilter)`](crate::client::fluent_builders::ListDocumentClassifiers::filter) / [`set_filter(Option<DocumentClassifierFilter>)`](crate::client::fluent_builders::ListDocumentClassifiers::set_filter): <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDocumentClassifiers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDocumentClassifiers::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDocumentClassifiers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDocumentClassifiers::set_max_results): <p>The maximum number of results to return in each page. The default is 100.</p>
    /// - On success, responds with [`ListDocumentClassifiersOutput`](crate::output::ListDocumentClassifiersOutput) with field(s):
    ///   - [`document_classifier_properties_list(Option<Vec<DocumentClassifierProperties>>)`](crate::output::ListDocumentClassifiersOutput::document_classifier_properties_list): <p>A list containing the properties of each job returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDocumentClassifiersOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListDocumentClassifiersError>`](crate::error::ListDocumentClassifiersError)
    pub fn list_document_classifiers(&self) -> fluent_builders::ListDocumentClassifiers {
        fluent_builders::ListDocumentClassifiers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDocumentClassifierSummaries`](crate::client::fluent_builders::ListDocumentClassifierSummaries) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDocumentClassifierSummaries::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDocumentClassifierSummaries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDocumentClassifierSummaries::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDocumentClassifierSummaries::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDocumentClassifierSummaries::set_max_results): <p>The maximum number of results to return on each page. The default is 100.</p>
    /// - On success, responds with [`ListDocumentClassifierSummariesOutput`](crate::output::ListDocumentClassifierSummariesOutput) with field(s):
    ///   - [`document_classifier_summaries_list(Option<Vec<DocumentClassifierSummary>>)`](crate::output::ListDocumentClassifierSummariesOutput::document_classifier_summaries_list): <p>The list of summaries of document classifiers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDocumentClassifierSummariesOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListDocumentClassifierSummariesError>`](crate::error::ListDocumentClassifierSummariesError)
    pub fn list_document_classifier_summaries(
        &self,
    ) -> fluent_builders::ListDocumentClassifierSummaries {
        fluent_builders::ListDocumentClassifierSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDominantLanguageDetectionJobs`](crate::client::fluent_builders::ListDominantLanguageDetectionJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDominantLanguageDetectionJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(DominantLanguageDetectionJobFilter)`](crate::client::fluent_builders::ListDominantLanguageDetectionJobs::filter) / [`set_filter(Option<DominantLanguageDetectionJobFilter>)`](crate::client::fluent_builders::ListDominantLanguageDetectionJobs::set_filter): <p>Filters that jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDominantLanguageDetectionJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDominantLanguageDetectionJobs::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDominantLanguageDetectionJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDominantLanguageDetectionJobs::set_max_results): <p>The maximum number of results to return in each page. The default is 100.</p>
    /// - On success, responds with [`ListDominantLanguageDetectionJobsOutput`](crate::output::ListDominantLanguageDetectionJobsOutput) with field(s):
    ///   - [`dominant_language_detection_job_properties_list(Option<Vec<DominantLanguageDetectionJobProperties>>)`](crate::output::ListDominantLanguageDetectionJobsOutput::dominant_language_detection_job_properties_list): <p>A list containing the properties of each job that is returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDominantLanguageDetectionJobsOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListDominantLanguageDetectionJobsError>`](crate::error::ListDominantLanguageDetectionJobsError)
    pub fn list_dominant_language_detection_jobs(
        &self,
    ) -> fluent_builders::ListDominantLanguageDetectionJobs {
        fluent_builders::ListDominantLanguageDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEndpoints`](crate::client::fluent_builders::ListEndpoints) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(EndpointFilter)`](crate::client::fluent_builders::ListEndpoints::filter) / [`set_filter(Option<EndpointFilter>)`](crate::client::fluent_builders::ListEndpoints::set_filter): <p>Filters the endpoints that are returned. You can filter endpoints on their name, model, status, or the date and time that they were created. You can only set one filter at a time. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEndpoints::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEndpoints::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEndpoints::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEndpoints::set_max_results): <p>The maximum number of results to return in each page. The default is 100.</p>
    /// - On success, responds with [`ListEndpointsOutput`](crate::output::ListEndpointsOutput) with field(s):
    ///   - [`endpoint_properties_list(Option<Vec<EndpointProperties>>)`](crate::output::ListEndpointsOutput::endpoint_properties_list): <p>Displays a list of endpoint properties being retrieved by the service in response to the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEndpointsOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListEndpointsError>`](crate::error::ListEndpointsError)
    pub fn list_endpoints(&self) -> fluent_builders::ListEndpoints {
        fluent_builders::ListEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEntitiesDetectionJobs`](crate::client::fluent_builders::ListEntitiesDetectionJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEntitiesDetectionJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(EntitiesDetectionJobFilter)`](crate::client::fluent_builders::ListEntitiesDetectionJobs::filter) / [`set_filter(Option<EntitiesDetectionJobFilter>)`](crate::client::fluent_builders::ListEntitiesDetectionJobs::set_filter): <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEntitiesDetectionJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEntitiesDetectionJobs::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEntitiesDetectionJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEntitiesDetectionJobs::set_max_results): <p>The maximum number of results to return in each page. The default is 100.</p>
    /// - On success, responds with [`ListEntitiesDetectionJobsOutput`](crate::output::ListEntitiesDetectionJobsOutput) with field(s):
    ///   - [`entities_detection_job_properties_list(Option<Vec<EntitiesDetectionJobProperties>>)`](crate::output::ListEntitiesDetectionJobsOutput::entities_detection_job_properties_list): <p>A list containing the properties of each job that is returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEntitiesDetectionJobsOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListEntitiesDetectionJobsError>`](crate::error::ListEntitiesDetectionJobsError)
    pub fn list_entities_detection_jobs(&self) -> fluent_builders::ListEntitiesDetectionJobs {
        fluent_builders::ListEntitiesDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEntityRecognizers`](crate::client::fluent_builders::ListEntityRecognizers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEntityRecognizers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(EntityRecognizerFilter)`](crate::client::fluent_builders::ListEntityRecognizers::filter) / [`set_filter(Option<EntityRecognizerFilter>)`](crate::client::fluent_builders::ListEntityRecognizers::set_filter): <p>Filters the list of entities returned. You can filter on <code>Status</code>, <code>SubmitTimeBefore</code>, or <code>SubmitTimeAfter</code>. You can only set one filter at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEntityRecognizers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEntityRecognizers::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEntityRecognizers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEntityRecognizers::set_max_results): <p> The maximum number of results to return on each page. The default is 100.</p>
    /// - On success, responds with [`ListEntityRecognizersOutput`](crate::output::ListEntityRecognizersOutput) with field(s):
    ///   - [`entity_recognizer_properties_list(Option<Vec<EntityRecognizerProperties>>)`](crate::output::ListEntityRecognizersOutput::entity_recognizer_properties_list): <p>The list of properties of an entity recognizer.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEntityRecognizersOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListEntityRecognizersError>`](crate::error::ListEntityRecognizersError)
    pub fn list_entity_recognizers(&self) -> fluent_builders::ListEntityRecognizers {
        fluent_builders::ListEntityRecognizers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEntityRecognizerSummaries`](crate::client::fluent_builders::ListEntityRecognizerSummaries) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEntityRecognizerSummaries::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEntityRecognizerSummaries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEntityRecognizerSummaries::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEntityRecognizerSummaries::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEntityRecognizerSummaries::set_max_results): <p>The maximum number of results to return on each page. The default is 100.</p>
    /// - On success, responds with [`ListEntityRecognizerSummariesOutput`](crate::output::ListEntityRecognizerSummariesOutput) with field(s):
    ///   - [`entity_recognizer_summaries_list(Option<Vec<EntityRecognizerSummary>>)`](crate::output::ListEntityRecognizerSummariesOutput::entity_recognizer_summaries_list): <p>The list entity recognizer summaries.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEntityRecognizerSummariesOutput::next_token): <p>The list entity recognizer summaries.</p>
    /// - On failure, responds with [`SdkError<ListEntityRecognizerSummariesError>`](crate::error::ListEntityRecognizerSummariesError)
    pub fn list_entity_recognizer_summaries(
        &self,
    ) -> fluent_builders::ListEntityRecognizerSummaries {
        fluent_builders::ListEntityRecognizerSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEventsDetectionJobs`](crate::client::fluent_builders::ListEventsDetectionJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEventsDetectionJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(EventsDetectionJobFilter)`](crate::client::fluent_builders::ListEventsDetectionJobs::filter) / [`set_filter(Option<EventsDetectionJobFilter>)`](crate::client::fluent_builders::ListEventsDetectionJobs::set_filter): <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEventsDetectionJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEventsDetectionJobs::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEventsDetectionJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEventsDetectionJobs::set_max_results): <p>The maximum number of results to return in each page.</p>
    /// - On success, responds with [`ListEventsDetectionJobsOutput`](crate::output::ListEventsDetectionJobsOutput) with field(s):
    ///   - [`events_detection_job_properties_list(Option<Vec<EventsDetectionJobProperties>>)`](crate::output::ListEventsDetectionJobsOutput::events_detection_job_properties_list): <p>A list containing the properties of each job that is returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEventsDetectionJobsOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListEventsDetectionJobsError>`](crate::error::ListEventsDetectionJobsError)
    pub fn list_events_detection_jobs(&self) -> fluent_builders::ListEventsDetectionJobs {
        fluent_builders::ListEventsDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListKeyPhrasesDetectionJobs`](crate::client::fluent_builders::ListKeyPhrasesDetectionJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListKeyPhrasesDetectionJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(KeyPhrasesDetectionJobFilter)`](crate::client::fluent_builders::ListKeyPhrasesDetectionJobs::filter) / [`set_filter(Option<KeyPhrasesDetectionJobFilter>)`](crate::client::fluent_builders::ListKeyPhrasesDetectionJobs::set_filter): <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListKeyPhrasesDetectionJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListKeyPhrasesDetectionJobs::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListKeyPhrasesDetectionJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListKeyPhrasesDetectionJobs::set_max_results): <p>The maximum number of results to return in each page. The default is 100.</p>
    /// - On success, responds with [`ListKeyPhrasesDetectionJobsOutput`](crate::output::ListKeyPhrasesDetectionJobsOutput) with field(s):
    ///   - [`key_phrases_detection_job_properties_list(Option<Vec<KeyPhrasesDetectionJobProperties>>)`](crate::output::ListKeyPhrasesDetectionJobsOutput::key_phrases_detection_job_properties_list): <p>A list containing the properties of each job that is returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListKeyPhrasesDetectionJobsOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListKeyPhrasesDetectionJobsError>`](crate::error::ListKeyPhrasesDetectionJobsError)
    pub fn list_key_phrases_detection_jobs(&self) -> fluent_builders::ListKeyPhrasesDetectionJobs {
        fluent_builders::ListKeyPhrasesDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPiiEntitiesDetectionJobs`](crate::client::fluent_builders::ListPiiEntitiesDetectionJobs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(PiiEntitiesDetectionJobFilter)`](crate::client::fluent_builders::ListPiiEntitiesDetectionJobs::filter) / [`set_filter(Option<PiiEntitiesDetectionJobFilter>)`](crate::client::fluent_builders::ListPiiEntitiesDetectionJobs::set_filter): <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPiiEntitiesDetectionJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPiiEntitiesDetectionJobs::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPiiEntitiesDetectionJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPiiEntitiesDetectionJobs::set_max_results): <p>The maximum number of results to return in each page.</p>
    /// - On success, responds with [`ListPiiEntitiesDetectionJobsOutput`](crate::output::ListPiiEntitiesDetectionJobsOutput) with field(s):
    ///   - [`pii_entities_detection_job_properties_list(Option<Vec<PiiEntitiesDetectionJobProperties>>)`](crate::output::ListPiiEntitiesDetectionJobsOutput::pii_entities_detection_job_properties_list): <p>A list containing the properties of each job that is returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPiiEntitiesDetectionJobsOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListPiiEntitiesDetectionJobsError>`](crate::error::ListPiiEntitiesDetectionJobsError)
    pub fn list_pii_entities_detection_jobs(
        &self,
    ) -> fluent_builders::ListPiiEntitiesDetectionJobs {
        fluent_builders::ListPiiEntitiesDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSentimentDetectionJobs`](crate::client::fluent_builders::ListSentimentDetectionJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSentimentDetectionJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(SentimentDetectionJobFilter)`](crate::client::fluent_builders::ListSentimentDetectionJobs::filter) / [`set_filter(Option<SentimentDetectionJobFilter>)`](crate::client::fluent_builders::ListSentimentDetectionJobs::set_filter): <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSentimentDetectionJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSentimentDetectionJobs::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSentimentDetectionJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSentimentDetectionJobs::set_max_results): <p>The maximum number of results to return in each page. The default is 100.</p>
    /// - On success, responds with [`ListSentimentDetectionJobsOutput`](crate::output::ListSentimentDetectionJobsOutput) with field(s):
    ///   - [`sentiment_detection_job_properties_list(Option<Vec<SentimentDetectionJobProperties>>)`](crate::output::ListSentimentDetectionJobsOutput::sentiment_detection_job_properties_list): <p>A list containing the properties of each job that is returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSentimentDetectionJobsOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListSentimentDetectionJobsError>`](crate::error::ListSentimentDetectionJobsError)
    pub fn list_sentiment_detection_jobs(&self) -> fluent_builders::ListSentimentDetectionJobs {
        fluent_builders::ListSentimentDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you are querying. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::ListTagsForResourceOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you are querying.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Tags associated with the Amazon Comprehend resource being queried. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTopicsDetectionJobs`](crate::client::fluent_builders::ListTopicsDetectionJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTopicsDetectionJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(TopicsDetectionJobFilter)`](crate::client::fluent_builders::ListTopicsDetectionJobs::filter) / [`set_filter(Option<TopicsDetectionJobFilter>)`](crate::client::fluent_builders::ListTopicsDetectionJobs::set_filter): <p>Filters the jobs that are returned. Jobs can be filtered on their name, status, or the date and time that they were submitted. You can set only one filter at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTopicsDetectionJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTopicsDetectionJobs::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTopicsDetectionJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTopicsDetectionJobs::set_max_results): <p>The maximum number of results to return in each page. The default is 100.</p>
    /// - On success, responds with [`ListTopicsDetectionJobsOutput`](crate::output::ListTopicsDetectionJobsOutput) with field(s):
    ///   - [`topics_detection_job_properties_list(Option<Vec<TopicsDetectionJobProperties>>)`](crate::output::ListTopicsDetectionJobsOutput::topics_detection_job_properties_list): <p>A list containing the properties of each job that is returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTopicsDetectionJobsOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListTopicsDetectionJobsError>`](crate::error::ListTopicsDetectionJobsError)
    pub fn list_topics_detection_jobs(&self) -> fluent_builders::ListTopicsDetectionJobs {
        fluent_builders::ListTopicsDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the custom model to attach the policy to.</p>
    ///   - [`resource_policy(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::resource_policy) / [`set_resource_policy(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_resource_policy): <p>The JSON resource-based policy to attach to your custom model. Provide your JSON as a UTF-8 encoded string without line breaks. To provide valid JSON for your policy, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p>  <p> <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code> </p>  <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p>  <p> <code>'{"attribute": "value", "attribute": ["value"]}'</code> </p>
    ///   - [`policy_revision_id(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::policy_revision_id) / [`set_policy_revision_id(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_policy_revision_id): <p>The revision ID that Amazon Comprehend assigned to the policy that you are updating. If you are creating a new policy that has no prior version, don't use this parameter. Amazon Comprehend creates the revision ID for you.</p>
    /// - On success, responds with [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput) with field(s):
    ///   - [`policy_revision_id(Option<String>)`](crate::output::PutResourcePolicyOutput::policy_revision_id): <p>The revision ID of the policy. Each time you modify a policy, Amazon Comprehend assigns a new revision ID, and it deletes the prior version of the policy.</p>
    /// - On failure, responds with [`SdkError<PutResourcePolicyError>`](crate::error::PutResourcePolicyError)
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDocumentClassificationJob`](crate::client::fluent_builders::StartDocumentClassificationJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartDocumentClassificationJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartDocumentClassificationJob::set_job_name): <p>The identifier of the job.</p>
    ///   - [`document_classifier_arn(impl Into<String>)`](crate::client::fluent_builders::StartDocumentClassificationJob::document_classifier_arn) / [`set_document_classifier_arn(Option<String>)`](crate::client::fluent_builders::StartDocumentClassificationJob::set_document_classifier_arn): <p>The Amazon Resource Name (ARN) of the document classifier to use to process the job.</p>
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartDocumentClassificationJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartDocumentClassificationJob::set_input_data_config): <p>Specifies the format and location of the input data for the job.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartDocumentClassificationJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartDocumentClassificationJob::set_output_data_config): <p>Specifies where to send the output files.</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartDocumentClassificationJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartDocumentClassificationJob::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartDocumentClassificationJob::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartDocumentClassificationJob::set_client_request_token): <p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>
    ///   - [`volume_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartDocumentClassificationJob::volume_kms_key_id) / [`set_volume_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartDocumentClassificationJob::set_volume_kms_key_id): <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>  <ul>   <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>   <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>  </ul>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::StartDocumentClassificationJob::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::StartDocumentClassificationJob::set_vpc_config): <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your document classification job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartDocumentClassificationJob::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartDocumentClassificationJob::set_tags): <p>Tags to be associated with the document classification job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
    /// - On success, responds with [`StartDocumentClassificationJobOutput`](crate::output::StartDocumentClassificationJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartDocumentClassificationJobOutput::job_id): <p>The identifier generated for the job. To get the status of the job, use this identifier with the operation.</p>
    ///   - [`job_arn(Option<String>)`](crate::output::StartDocumentClassificationJobOutput::job_arn): <p>The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:</p>  <p> <code>arn:   <partition>    :comprehend:    <region>     :     <account-id>      :document-classification-job/      <job-id></job-id>     </account-id>    </region>   </partition></code> </p>  <p>The following is an example job ARN:</p>  <p> <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code> </p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StartDocumentClassificationJobOutput::job_status): <p>The status of the job:</p>  <ul>   <li> <p>SUBMITTED - The job has been received and queued for processing.</p> </li>   <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li>   <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li>   <li> <p>FAILED - The job did not complete. For details, use the operation.</p> </li>   <li> <p>STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.</p> </li>   <li> <p>STOPPED - The job was successfully stopped without completing.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<StartDocumentClassificationJobError>`](crate::error::StartDocumentClassificationJobError)
    pub fn start_document_classification_job(
        &self,
    ) -> fluent_builders::StartDocumentClassificationJob {
        fluent_builders::StartDocumentClassificationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDominantLanguageDetectionJob`](crate::client::fluent_builders::StartDominantLanguageDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::set_input_data_config): <p>Specifies the format and location of the input data for the job.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::set_output_data_config): <p>Specifies where to send the output files.</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::set_job_name): <p>An identifier for the job.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::set_client_request_token): <p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>
    ///   - [`volume_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::volume_kms_key_id) / [`set_volume_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::set_volume_kms_key_id): <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>  <ul>   <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>   <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>  </ul>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::set_vpc_config): <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your dominant language detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartDominantLanguageDetectionJob::set_tags): <p>Tags to be associated with the dominant language detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
    /// - On success, responds with [`StartDominantLanguageDetectionJobOutput`](crate::output::StartDominantLanguageDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartDominantLanguageDetectionJobOutput::job_id): <p>The identifier generated for the job. To get the status of a job, use this identifier with the operation.</p>
    ///   - [`job_arn(Option<String>)`](crate::output::StartDominantLanguageDetectionJobOutput::job_arn): <p>The Amazon Resource Name (ARN) of the dominant language detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:</p>  <p> <code>arn:   <partition>    :comprehend:    <region>     :     <account-id>      :dominant-language-detection-job/      <job-id></job-id>     </account-id>    </region>   </partition></code> </p>  <p>The following is an example job ARN:</p>  <p> <code>arn:aws:comprehend:us-west-2:111122223333:dominant-language-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StartDominantLanguageDetectionJobOutput::job_status): <p>The status of the job. </p>  <ul>   <li> <p>SUBMITTED - The job has been received and is queued for processing.</p> </li>   <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li>   <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li>   <li> <p>FAILED - The job did not complete. To get details, use the operation.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<StartDominantLanguageDetectionJobError>`](crate::error::StartDominantLanguageDetectionJobError)
    pub fn start_dominant_language_detection_job(
        &self,
    ) -> fluent_builders::StartDominantLanguageDetectionJob {
        fluent_builders::StartDominantLanguageDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartEntitiesDetectionJob`](crate::client::fluent_builders::StartEntitiesDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartEntitiesDetectionJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::set_input_data_config): <p>Specifies the format and location of the input data for the job.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartEntitiesDetectionJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::set_output_data_config): <p>Specifies where to send the output files.</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::set_job_name): <p>The identifier of the job.</p>
    ///   - [`entity_recognizer_arn(impl Into<String>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::entity_recognizer_arn) / [`set_entity_recognizer_arn(Option<String>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::set_entity_recognizer_arn): <p>The Amazon Resource Name (ARN) that identifies the specific entity recognizer to be used by the <code>StartEntitiesDetectionJob</code>. This ARN is optional and is only used for a custom entity recognition job.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::StartEntitiesDetectionJob::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::set_language_code): <p>The language of the input documents. All documents must be in the same language. You can specify any of the languages supported by Amazon Comprehend. If custom entities recognition is used, this parameter is ignored and the language used for training the model is used instead.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::set_client_request_token): <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
    ///   - [`volume_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::volume_kms_key_id) / [`set_volume_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::set_volume_kms_key_id): <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>  <ul>   <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>   <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>  </ul>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::StartEntitiesDetectionJob::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::set_vpc_config): <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartEntitiesDetectionJob::set_tags): <p>Tags to be associated with the entities detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
    /// - On success, responds with [`StartEntitiesDetectionJobOutput`](crate::output::StartEntitiesDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartEntitiesDetectionJobOutput::job_id): <p>The identifier generated for the job. To get the status of job, use this identifier with the operation.</p>
    ///   - [`job_arn(Option<String>)`](crate::output::StartEntitiesDetectionJobOutput::job_arn): <p>The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:</p>  <p> <code>arn:   <partition>    :comprehend:    <region>     :     <account-id>      :entities-detection-job/      <job-id></job-id>     </account-id>    </region>   </partition></code> </p>  <p>The following is an example job ARN:</p>  <p> <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StartEntitiesDetectionJobOutput::job_status): <p>The status of the job. </p>  <ul>   <li> <p>SUBMITTED - The job has been received and is queued for processing.</p> </li>   <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li>   <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li>   <li> <p>FAILED - The job did not complete. To get details, use the operation.</p> </li>   <li> <p>STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.</p> </li>   <li> <p>STOPPED - The job was successfully stopped without completing.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<StartEntitiesDetectionJobError>`](crate::error::StartEntitiesDetectionJobError)
    pub fn start_entities_detection_job(&self) -> fluent_builders::StartEntitiesDetectionJob {
        fluent_builders::StartEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartEventsDetectionJob`](crate::client::fluent_builders::StartEventsDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartEventsDetectionJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartEventsDetectionJob::set_input_data_config): <p>Specifies the format and location of the input data for the job.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartEventsDetectionJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartEventsDetectionJob::set_output_data_config): <p>Specifies where to send the output files.</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartEventsDetectionJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartEventsDetectionJob::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartEventsDetectionJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartEventsDetectionJob::set_job_name): <p>The identifier of the events detection job.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::StartEventsDetectionJob::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::StartEventsDetectionJob::set_language_code): <p>The language code of the input documents.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartEventsDetectionJob::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartEventsDetectionJob::set_client_request_token): <p>An unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
    ///   - [`target_event_types(Vec<String>)`](crate::client::fluent_builders::StartEventsDetectionJob::target_event_types) / [`set_target_event_types(Option<Vec<String>>)`](crate::client::fluent_builders::StartEventsDetectionJob::set_target_event_types): <p>The types of events to detect in the input documents.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartEventsDetectionJob::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartEventsDetectionJob::set_tags): <p>Tags to be associated with the events detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
    /// - On success, responds with [`StartEventsDetectionJobOutput`](crate::output::StartEventsDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartEventsDetectionJobOutput::job_id): <p>An unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
    ///   - [`job_arn(Option<String>)`](crate::output::StartEventsDetectionJobOutput::job_arn): <p>The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:</p>  <p> <code>arn:   <partition>    :comprehend:    <region>     :     <account-id>      :events-detection-job/      <job-id></job-id>     </account-id>    </region>   </partition></code> </p>  <p>The following is an example job ARN:</p>  <p> <code>arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StartEventsDetectionJobOutput::job_status): <p>The status of the events detection job.</p>
    /// - On failure, responds with [`SdkError<StartEventsDetectionJobError>`](crate::error::StartEventsDetectionJobError)
    pub fn start_events_detection_job(&self) -> fluent_builders::StartEventsDetectionJob {
        fluent_builders::StartEventsDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartKeyPhrasesDetectionJob`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::set_input_data_config): <p>Specifies the format and location of the input data for the job.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::set_output_data_config): <p>Specifies where to send the output files.</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::set_job_name): <p>The identifier of the job.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::set_language_code): <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::set_client_request_token): <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
    ///   - [`volume_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::volume_kms_key_id) / [`set_volume_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::set_volume_kms_key_id): <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>  <ul>   <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>   <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>  </ul>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::set_vpc_config): <p> Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your key phrases detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob::set_tags): <p>Tags to be associated with the key phrases detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
    /// - On success, responds with [`StartKeyPhrasesDetectionJobOutput`](crate::output::StartKeyPhrasesDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartKeyPhrasesDetectionJobOutput::job_id): <p>The identifier generated for the job. To get the status of a job, use this identifier with the operation.</p>
    ///   - [`job_arn(Option<String>)`](crate::output::StartKeyPhrasesDetectionJobOutput::job_arn): <p>The Amazon Resource Name (ARN) of the key phrase detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:</p>  <p> <code>arn:   <partition>    :comprehend:    <region>     :     <account-id>      :key-phrases-detection-job/      <job-id></job-id>     </account-id>    </region>   </partition></code> </p>  <p>The following is an example job ARN:</p>  <p> <code>arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StartKeyPhrasesDetectionJobOutput::job_status): <p>The status of the job. </p>  <ul>   <li> <p>SUBMITTED - The job has been received and is queued for processing.</p> </li>   <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li>   <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li>   <li> <p>FAILED - The job did not complete. To get details, use the operation.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<StartKeyPhrasesDetectionJobError>`](crate::error::StartKeyPhrasesDetectionJobError)
    pub fn start_key_phrases_detection_job(&self) -> fluent_builders::StartKeyPhrasesDetectionJob {
        fluent_builders::StartKeyPhrasesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartPiiEntitiesDetectionJob`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::set_input_data_config): <p>The input properties for a PII entities detection job.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::set_output_data_config): <p>Provides conﬁguration parameters for the output of PII entity detection jobs.</p>
    ///   - [`mode(PiiEntitiesDetectionMode)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::mode) / [`set_mode(Option<PiiEntitiesDetectionMode>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::set_mode): <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in which PII entities are redacted.</p>
    ///   - [`redaction_config(RedactionConfig)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::redaction_config) / [`set_redaction_config(Option<RedactionConfig>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::set_redaction_config): <p>Provides configuration parameters for PII entity redaction.</p>  <p>This parameter is required if you set the <code>Mode</code> parameter to <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code> definition that includes the <code>PiiEntityTypes</code> parameter.</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::set_job_name): <p>The identifier of the job.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::set_language_code): <p>The language of the input documents.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::set_client_request_token): <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob::set_tags): <p>Tags to be associated with the PII entities detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
    /// - On success, responds with [`StartPiiEntitiesDetectionJobOutput`](crate::output::StartPiiEntitiesDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartPiiEntitiesDetectionJobOutput::job_id): <p>The identifier generated for the job.</p>
    ///   - [`job_arn(Option<String>)`](crate::output::StartPiiEntitiesDetectionJobOutput::job_arn): <p>The Amazon Resource Name (ARN) of the PII entity detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:</p>  <p> <code>arn:   <partition>    :comprehend:    <region>     :     <account-id>      :pii-entities-detection-job/      <job-id></job-id>     </account-id>    </region>   </partition></code> </p>  <p>The following is an example job ARN:</p>  <p> <code>arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StartPiiEntitiesDetectionJobOutput::job_status): <p>The status of the job.</p>
    /// - On failure, responds with [`SdkError<StartPiiEntitiesDetectionJobError>`](crate::error::StartPiiEntitiesDetectionJobError)
    pub fn start_pii_entities_detection_job(
        &self,
    ) -> fluent_builders::StartPiiEntitiesDetectionJob {
        fluent_builders::StartPiiEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartSentimentDetectionJob`](crate::client::fluent_builders::StartSentimentDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartSentimentDetectionJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartSentimentDetectionJob::set_input_data_config): <p>Specifies the format and location of the input data for the job.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartSentimentDetectionJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartSentimentDetectionJob::set_output_data_config): <p>Specifies where to send the output files. </p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartSentimentDetectionJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartSentimentDetectionJob::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartSentimentDetectionJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartSentimentDetectionJob::set_job_name): <p>The identifier of the job.</p>
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::StartSentimentDetectionJob::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::StartSentimentDetectionJob::set_language_code): <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartSentimentDetectionJob::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartSentimentDetectionJob::set_client_request_token): <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
    ///   - [`volume_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartSentimentDetectionJob::volume_kms_key_id) / [`set_volume_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartSentimentDetectionJob::set_volume_kms_key_id): <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>  <ul>   <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>   <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>  </ul>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::StartSentimentDetectionJob::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::StartSentimentDetectionJob::set_vpc_config): <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartSentimentDetectionJob::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartSentimentDetectionJob::set_tags): <p>Tags to be associated with the sentiment detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
    /// - On success, responds with [`StartSentimentDetectionJobOutput`](crate::output::StartSentimentDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartSentimentDetectionJobOutput::job_id): <p>The identifier generated for the job. To get the status of a job, use this identifier with the operation.</p>
    ///   - [`job_arn(Option<String>)`](crate::output::StartSentimentDetectionJobOutput::job_arn): <p>The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:</p>  <p> <code>arn:   <partition>    :comprehend:    <region>     :     <account-id>      :sentiment-detection-job/      <job-id></job-id>     </account-id>    </region>   </partition></code> </p>  <p>The following is an example job ARN:</p>  <p> <code>arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StartSentimentDetectionJobOutput::job_status): <p>The status of the job. </p>  <ul>   <li> <p>SUBMITTED - The job has been received and is queued for processing.</p> </li>   <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li>   <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li>   <li> <p>FAILED - The job did not complete. To get details, use the operation.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<StartSentimentDetectionJobError>`](crate::error::StartSentimentDetectionJobError)
    pub fn start_sentiment_detection_job(&self) -> fluent_builders::StartSentimentDetectionJob {
        fluent_builders::StartSentimentDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartTopicsDetectionJob`](crate::client::fluent_builders::StartTopicsDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartTopicsDetectionJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartTopicsDetectionJob::set_input_data_config): <p>Specifies the format and location of the input data for the job.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartTopicsDetectionJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartTopicsDetectionJob::set_output_data_config): <p>Specifies where to send the output files. The output is a compressed archive with two files, <code>topic-terms.csv</code> that lists the terms associated with each topic, and <code>doc-topics.csv</code> that lists the documents associated with each topic</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartTopicsDetectionJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartTopicsDetectionJob::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartTopicsDetectionJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartTopicsDetectionJob::set_job_name): <p>The identifier of the job.</p>
    ///   - [`number_of_topics(i32)`](crate::client::fluent_builders::StartTopicsDetectionJob::number_of_topics) / [`set_number_of_topics(Option<i32>)`](crate::client::fluent_builders::StartTopicsDetectionJob::set_number_of_topics): <p>The number of topics to detect.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartTopicsDetectionJob::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartTopicsDetectionJob::set_client_request_token): <p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>
    ///   - [`volume_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartTopicsDetectionJob::volume_kms_key_id) / [`set_volume_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartTopicsDetectionJob::set_volume_kms_key_id): <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>  <ul>   <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>   <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>  </ul>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::StartTopicsDetectionJob::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::StartTopicsDetectionJob::set_vpc_config): <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartTopicsDetectionJob::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartTopicsDetectionJob::set_tags): <p>Tags to be associated with the topics detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
    /// - On success, responds with [`StartTopicsDetectionJobOutput`](crate::output::StartTopicsDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartTopicsDetectionJobOutput::job_id): <p>The identifier generated for the job. To get the status of the job, use this identifier with the <code>DescribeTopicDetectionJob</code> operation.</p>
    ///   - [`job_arn(Option<String>)`](crate::output::StartTopicsDetectionJobOutput::job_arn): <p>The Amazon Resource Name (ARN) of the topics detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:</p>  <p> <code>arn:   <partition>    :comprehend:    <region>     :     <account-id>      :topics-detection-job/      <job-id></job-id>     </account-id>    </region>   </partition></code> </p>  <p>The following is an example job ARN:</p>  <p> <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code> </p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StartTopicsDetectionJobOutput::job_status): <p>The status of the job: </p>  <ul>   <li> <p>SUBMITTED - The job has been received and is queued for processing.</p> </li>   <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li>   <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li>   <li> <p>FAILED - The job did not complete. To get details, use the <code>DescribeTopicDetectionJob</code> operation.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<StartTopicsDetectionJobError>`](crate::error::StartTopicsDetectionJobError)
    pub fn start_topics_detection_job(&self) -> fluent_builders::StartTopicsDetectionJob {
        fluent_builders::StartTopicsDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopDominantLanguageDetectionJob`](crate::client::fluent_builders::StopDominantLanguageDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StopDominantLanguageDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StopDominantLanguageDetectionJob::set_job_id): <p>The identifier of the dominant language detection job to stop.</p>
    /// - On success, responds with [`StopDominantLanguageDetectionJobOutput`](crate::output::StopDominantLanguageDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StopDominantLanguageDetectionJobOutput::job_id): <p>The identifier of the dominant language detection job to stop.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StopDominantLanguageDetectionJobOutput::job_status): <p>Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was previously stopped with the <code>StopDominantLanguageDetectionJob</code> operation.</p>
    /// - On failure, responds with [`SdkError<StopDominantLanguageDetectionJobError>`](crate::error::StopDominantLanguageDetectionJobError)
    pub fn stop_dominant_language_detection_job(
        &self,
    ) -> fluent_builders::StopDominantLanguageDetectionJob {
        fluent_builders::StopDominantLanguageDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopEntitiesDetectionJob`](crate::client::fluent_builders::StopEntitiesDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StopEntitiesDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StopEntitiesDetectionJob::set_job_id): <p>The identifier of the entities detection job to stop.</p>
    /// - On success, responds with [`StopEntitiesDetectionJobOutput`](crate::output::StopEntitiesDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StopEntitiesDetectionJobOutput::job_id): <p>The identifier of the entities detection job to stop.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StopEntitiesDetectionJobOutput::job_status): <p>Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was previously stopped with the <code>StopEntitiesDetectionJob</code> operation.</p>
    /// - On failure, responds with [`SdkError<StopEntitiesDetectionJobError>`](crate::error::StopEntitiesDetectionJobError)
    pub fn stop_entities_detection_job(&self) -> fluent_builders::StopEntitiesDetectionJob {
        fluent_builders::StopEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopEventsDetectionJob`](crate::client::fluent_builders::StopEventsDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StopEventsDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StopEventsDetectionJob::set_job_id): <p>The identifier of the events detection job to stop.</p>
    /// - On success, responds with [`StopEventsDetectionJobOutput`](crate::output::StopEventsDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StopEventsDetectionJobOutput::job_id): <p>The identifier of the events detection job to stop.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StopEventsDetectionJobOutput::job_status): <p>The status of the events detection job.</p>
    /// - On failure, responds with [`SdkError<StopEventsDetectionJobError>`](crate::error::StopEventsDetectionJobError)
    pub fn stop_events_detection_job(&self) -> fluent_builders::StopEventsDetectionJob {
        fluent_builders::StopEventsDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopKeyPhrasesDetectionJob`](crate::client::fluent_builders::StopKeyPhrasesDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StopKeyPhrasesDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StopKeyPhrasesDetectionJob::set_job_id): <p>The identifier of the key phrases detection job to stop.</p>
    /// - On success, responds with [`StopKeyPhrasesDetectionJobOutput`](crate::output::StopKeyPhrasesDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StopKeyPhrasesDetectionJobOutput::job_id): <p>The identifier of the key phrases detection job to stop.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StopKeyPhrasesDetectionJobOutput::job_status): <p>Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was previously stopped with the <code>StopKeyPhrasesDetectionJob</code> operation.</p>
    /// - On failure, responds with [`SdkError<StopKeyPhrasesDetectionJobError>`](crate::error::StopKeyPhrasesDetectionJobError)
    pub fn stop_key_phrases_detection_job(&self) -> fluent_builders::StopKeyPhrasesDetectionJob {
        fluent_builders::StopKeyPhrasesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopPiiEntitiesDetectionJob`](crate::client::fluent_builders::StopPiiEntitiesDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StopPiiEntitiesDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StopPiiEntitiesDetectionJob::set_job_id): <p>The identifier of the PII entities detection job to stop.</p>
    /// - On success, responds with [`StopPiiEntitiesDetectionJobOutput`](crate::output::StopPiiEntitiesDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StopPiiEntitiesDetectionJobOutput::job_id): <p>The identifier of the PII entities detection job to stop.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StopPiiEntitiesDetectionJobOutput::job_status): <p>The status of the PII entities detection job.</p>
    /// - On failure, responds with [`SdkError<StopPiiEntitiesDetectionJobError>`](crate::error::StopPiiEntitiesDetectionJobError)
    pub fn stop_pii_entities_detection_job(&self) -> fluent_builders::StopPiiEntitiesDetectionJob {
        fluent_builders::StopPiiEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopSentimentDetectionJob`](crate::client::fluent_builders::StopSentimentDetectionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StopSentimentDetectionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StopSentimentDetectionJob::set_job_id): <p>The identifier of the sentiment detection job to stop.</p>
    /// - On success, responds with [`StopSentimentDetectionJobOutput`](crate::output::StopSentimentDetectionJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StopSentimentDetectionJobOutput::job_id): <p>The identifier of the sentiment detection job to stop.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StopSentimentDetectionJobOutput::job_status): <p>Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was previously stopped with the <code>StopSentimentDetectionJob</code> operation.</p>
    /// - On failure, responds with [`SdkError<StopSentimentDetectionJobError>`](crate::error::StopSentimentDetectionJobError)
    pub fn stop_sentiment_detection_job(&self) -> fluent_builders::StopSentimentDetectionJob {
        fluent_builders::StopSentimentDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopTrainingDocumentClassifier`](crate::client::fluent_builders::StopTrainingDocumentClassifier) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document_classifier_arn(impl Into<String>)`](crate::client::fluent_builders::StopTrainingDocumentClassifier::document_classifier_arn) / [`set_document_classifier_arn(Option<String>)`](crate::client::fluent_builders::StopTrainingDocumentClassifier::set_document_classifier_arn): <p>The Amazon Resource Name (ARN) that identifies the document classifier currently being trained.</p>
    /// - On success, responds with [`StopTrainingDocumentClassifierOutput`](crate::output::StopTrainingDocumentClassifierOutput)

    /// - On failure, responds with [`SdkError<StopTrainingDocumentClassifierError>`](crate::error::StopTrainingDocumentClassifierError)
    pub fn stop_training_document_classifier(
        &self,
    ) -> fluent_builders::StopTrainingDocumentClassifier {
        fluent_builders::StopTrainingDocumentClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopTrainingEntityRecognizer`](crate::client::fluent_builders::StopTrainingEntityRecognizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`entity_recognizer_arn(impl Into<String>)`](crate::client::fluent_builders::StopTrainingEntityRecognizer::entity_recognizer_arn) / [`set_entity_recognizer_arn(Option<String>)`](crate::client::fluent_builders::StopTrainingEntityRecognizer::set_entity_recognizer_arn): <p>The Amazon Resource Name (ARN) that identifies the entity recognizer currently being trained.</p>
    /// - On success, responds with [`StopTrainingEntityRecognizerOutput`](crate::output::StopTrainingEntityRecognizerOutput)

    /// - On failure, responds with [`SdkError<StopTrainingEntityRecognizerError>`](crate::error::StopTrainingEntityRecognizerError)
    pub fn stop_training_entity_recognizer(&self) -> fluent_builders::StopTrainingEntityRecognizer {
        fluent_builders::StopTrainingEntityRecognizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource to which you want to associate the tags. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Tags being associated with a specific Amazon Comprehend resource. There can be a maximum of 50 tags (both existing and pending) associated with a specific resource. </p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p> The Amazon Resource Name (ARN) of the given Amazon Comprehend resource from which you want to remove the tags. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The initial part of a key-value pair that forms a tag being removed from a given resource. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. Keys must be unique and cannot be duplicated for a particular resource. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEndpoint`](crate::client::fluent_builders::UpdateEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateEndpoint::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::UpdateEndpoint::set_endpoint_arn): <p>The Amazon Resource Number (ARN) of the endpoint being updated.</p>
    ///   - [`desired_model_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateEndpoint::desired_model_arn) / [`set_desired_model_arn(Option<String>)`](crate::client::fluent_builders::UpdateEndpoint::set_desired_model_arn): <p>The ARN of the new model to use when updating an existing endpoint.</p>
    ///   - [`desired_inference_units(i32)`](crate::client::fluent_builders::UpdateEndpoint::desired_inference_units) / [`set_desired_inference_units(Option<i32>)`](crate::client::fluent_builders::UpdateEndpoint::set_desired_inference_units): <p> The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.</p>
    ///   - [`desired_data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateEndpoint::desired_data_access_role_arn) / [`set_desired_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateEndpoint::set_desired_data_access_role_arn): <p>Data access role ARN to use in case the new model is encrypted with a customer CMK.</p>
    /// - On success, responds with [`UpdateEndpointOutput`](crate::output::UpdateEndpointOutput)

    /// - On failure, responds with [`SdkError<UpdateEndpointError>`](crate::error::UpdateEndpointError)
    pub fn update_endpoint(&self) -> fluent_builders::UpdateEndpoint {
        fluent_builders::UpdateEndpoint::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchDetectDominantLanguage`.
    ///
    /// <p>Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported Languages</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDetectDominantLanguage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_detect_dominant_language_input::Builder,
    }
    impl BatchDetectDominantLanguage {
        /// Creates a new `BatchDetectDominantLanguage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDetectDominantLanguageOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDetectDominantLanguageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TextList`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document should contain at least 20 characters and must contain fewer than 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text_list(input.into());
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document should contain at least 20 characters and must contain fewer than 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_text_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDetectEntities`.
    ///
    /// <p>Inspects the text of a batch of documents for named entities and returns information about them. For more information about named entities, see <code>how-entities</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDetectEntities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_detect_entities_input::Builder,
    }
    impl BatchDetectEntities {
        /// Creates a new `BatchDetectEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDetectEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDetectEntitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TextList`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer than 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text_list(input.into());
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer than 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_text_list(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDetectKeyPhrases`.
    ///
    /// <p>Detects the key noun phrases found in a batch of documents.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDetectKeyPhrases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_detect_key_phrases_input::Builder,
    }
    impl BatchDetectKeyPhrases {
        /// Creates a new `BatchDetectKeyPhrases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDetectKeyPhrasesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDetectKeyPhrasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TextList`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text_list(input.into());
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_text_list(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDetectSentiment`.
    ///
    /// <p>Inspects a batch of documents and returns an inference of the prevailing sentiment, <code>POSITIVE</code>, <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>, in each one.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDetectSentiment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_detect_sentiment_input::Builder,
    }
    impl BatchDetectSentiment {
        /// Creates a new `BatchDetectSentiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDetectSentimentOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDetectSentimentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TextList`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text_list(input.into());
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_text_list(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDetectSyntax`.
    ///
    /// <p>Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and returns information about them. For more information, see <code>how-syntax</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDetectSyntax {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_detect_syntax_input::Builder,
    }
    impl BatchDetectSyntax {
        /// Creates a new `BatchDetectSyntax`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDetectSyntaxOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDetectSyntaxError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TextList`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text_list(input.into());
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_text_list(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::SyntaxLanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::SyntaxLanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ClassifyDocument`.
    ///
    /// <p>Creates a new document classification request to analyze a single document in real-time, using a previously created and trained custom model and an endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ClassifyDocument {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::classify_document_input::Builder,
    }
    impl ClassifyDocument {
        /// Creates a new `ClassifyDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ClassifyDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::ClassifyDocumentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The document text to be analyzed.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>The document text to be analyzed.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ContainsPiiEntities`.
    ///
    /// <p>Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of identified PII entity types such as name, address, bank account number, or phone number.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ContainsPiiEntities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::contains_pii_entities_input::Builder,
    }
    impl ContainsPiiEntities {
        /// Creates a new `ContainsPiiEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ContainsPiiEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ContainsPiiEntitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Creates a new document classification request to analyze a single document in real-time, returning personally identifiable information (PII) entity labels.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>Creates a new document classification request to analyze a single document in real-time, returning personally identifiable information (PII) entity labels.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDocumentClassifier`.
    ///
    /// <p>Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a set of training documents that labeled with the categories that you want to use. After the classifier is trained you can use it to categorize a set of labeled documents into the categories. For more information, see <code>how-document-classification</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDocumentClassifier {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_document_classifier_input::Builder,
    }
    impl CreateDocumentClassifier {
        /// Creates a new `CreateDocumentClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDocumentClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDocumentClassifierError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the document classifier.</p>
        pub fn document_classifier_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_classifier_name(input.into());
            self
        }
        /// <p>The name of the document classifier.</p>
        pub fn set_document_classifier_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_classifier_name(input);
            self
        }
        /// <p>The version name given to the newly created classifier. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the account/AWS Region.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(input.into());
            self
        }
        /// <p>The version name given to the newly created classifier. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the account/AWS Region.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the document classifier being created. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the document classifier being created. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(
            mut self,
            input: crate::model::DocumentClassifierInputDataConfig,
        ) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierInputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Enables the addition of output results configuration parameters for custom classifier jobs.</p>
        pub fn output_data_config(
            mut self,
            input: crate::model::DocumentClassifierOutputDataConfig,
        ) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Enables the addition of output results configuration parameters for custom classifier jobs.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierOutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class mode, which identifies one and only one class for each document, or multi-label mode, which identifies one or more labels for each document. In multi-label mode, multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).</p>
        pub fn mode(mut self, input: crate::model::DocumentClassifierMode) -> Self {
            self.inner = self.inner.mode(input);
            self
        }
        /// <p>Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class mode, which identifies one and only one class for each document, or multi-label mode, which identifies one or more labels for each document. In multi-label mode, multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierMode>,
        ) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn model_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_kms_key_id(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn set_model_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_kms_key_id(input);
            self
        }
        /// <p>The resource-based policy to attach to your custom document classifier model. You can use this policy to allow another AWS account to import your custom model.</p>
        /// <p>Provide your policy as a JSON body that you enter as a UTF-8 encoded string without line breaks. To provide valid JSON, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p>
        /// <p> <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code> </p>
        /// <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p>
        /// <p> <code>'{"attribute": "value", "attribute": ["value"]}'</code> </p>
        pub fn model_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_policy(input.into());
            self
        }
        /// <p>The resource-based policy to attach to your custom document classifier model. You can use this policy to allow another AWS account to import your custom model.</p>
        /// <p>Provide your policy as a JSON body that you enter as a UTF-8 encoded string without line breaks. To provide valid JSON, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p>
        /// <p> <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code> </p>
        /// <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p>
        /// <p> <code>'{"attribute": "value", "attribute": ["value"]}'</code> </p>
        pub fn set_model_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEndpoint`.
    ///
    /// <p>Creates a model-specific endpoint for synchronous inference for a previously trained custom model </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_endpoint_input::Builder,
    }
    impl CreateEndpoint {
        /// Creates a new `CreateEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for all subsequent requests to this resource. </p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(input.into());
            self
        }
        /// <p>This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for all subsequent requests to this resource. </p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint will be attached.</p>
        pub fn model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint will be attached.</p>
        pub fn set_model_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_arn(input);
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn desired_inference_units(mut self, input: i32) -> Self {
            self.inner = self.inner.desired_inference_units(input);
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn set_desired_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_desired_inference_units(input);
            self
        }
        /// <p>An idempotency token provided by the customer. If this token matches a previous endpoint creation request, Amazon Comprehend will not return a <code>ResourceInUseException</code>. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>An idempotency token provided by the customer. If this token matches a previous endpoint creation request, Amazon Comprehend will not return a <code>ResourceInUseException</code>. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the sales department. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the sales department. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEntityRecognizer`.
    ///
    /// <p>Creates an entity recognizer using submitted files. After your <code>CreateEntityRecognizer</code> request is submitted, you can check job status using the API. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEntityRecognizer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_entity_recognizer_input::Builder,
    }
    impl CreateEntityRecognizer {
        /// Creates a new `CreateEntityRecognizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEntityRecognizerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEntityRecognizerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name given to the newly created recognizer. Recognizer names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name must be unique in the account/region.</p>
        pub fn recognizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recognizer_name(input.into());
            self
        }
        /// <p>The name given to the newly created recognizer. Recognizer names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name must be unique in the account/region.</p>
        pub fn set_recognizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recognizer_name(input);
            self
        }
        /// <p>The version name given to the newly created recognizer. Version names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same recognizer name in the account/ AWS Region.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(input.into());
            self
        }
        /// <p>The version name given to the newly created recognizer. Version names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same recognizer name in the account/ AWS Region.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the entity recognizer being created. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the entity recognizer being created. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies the format and location of the input data. The S3 bucket containing the input data must be located in the same region as the entity recognizer being created. </p>
        pub fn input_data_config(
            mut self,
            input: crate::model::EntityRecognizerInputDataConfig,
        ) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>Specifies the format and location of the input data. The S3 bucket containing the input data must be located in the same region as the entity recognizer being created. </p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerInputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p> A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p> A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p> You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p> You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your custom entity recognizer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your custom entity recognizer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn model_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_kms_key_id(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn set_model_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_kms_key_id(input);
            self
        }
        /// <p>The JSON resource-based policy to attach to your custom entity recognizer model. You can use this policy to allow another AWS account to import your custom model.</p>
        /// <p>Provide your JSON as a UTF-8 encoded string without line breaks. To provide valid JSON for your policy, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p>
        /// <p> <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code> </p>
        /// <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p>
        /// <p> <code>'{"attribute": "value", "attribute": ["value"]}'</code> </p>
        pub fn model_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_policy(input.into());
            self
        }
        /// <p>The JSON resource-based policy to attach to your custom entity recognizer model. You can use this policy to allow another AWS account to import your custom model.</p>
        /// <p>Provide your JSON as a UTF-8 encoded string without line breaks. To provide valid JSON for your policy, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p>
        /// <p> <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code> </p>
        /// <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p>
        /// <p> <code>'{"attribute": "value", "attribute": ["value"]}'</code> </p>
        pub fn set_model_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDocumentClassifier`.
    ///
    /// <p>Deletes a previously created document classifier</p>
    /// <p>Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a <code>ResourceInUseException</code> will be returned.</p>
    /// <p>This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a background job. Once removed, the classifier disappears from your account and is no longer available for use. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDocumentClassifier {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_document_classifier_input::Builder,
    }
    impl DeleteDocumentClassifier {
        /// Creates a new `DeleteDocumentClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDocumentClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDocumentClassifierError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
        pub fn document_classifier_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_classifier_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_classifier_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpoint`.
    ///
    /// <p>Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order for the model to be deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_endpoint_input::Builder,
    }
    impl DeleteEndpoint {
        /// Creates a new `DeleteEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being deleted.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being deleted.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEntityRecognizer`.
    ///
    /// <p>Deletes an entity recognizer.</p>
    /// <p>Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a <code>ResourceInUseException</code> will be returned.</p>
    /// <p>This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a background job. Once removed, the recognizer disappears from your account and is no longer available for use. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEntityRecognizer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_entity_recognizer_input::Builder,
    }
    impl DeleteEntityRecognizer {
        /// Creates a new `DeleteEntityRecognizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEntityRecognizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEntityRecognizerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn entity_recognizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_recognizer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entity_recognizer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Deletes a resource-based policy that is attached to a custom model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl DeleteResourcePolicy {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the custom model version that has the policy to delete.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom model version that has the policy to delete.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The revision ID of the policy to delete.</p>
        pub fn policy_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_revision_id(input.into());
            self
        }
        /// <p>The revision ID of the policy to delete.</p>
        pub fn set_policy_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDocumentClassificationJob`.
    ///
    /// <p>Gets the properties associated with a document classification job. Use this operation to get the status of a classification job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDocumentClassificationJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_document_classification_job_input::Builder,
    }
    impl DescribeDocumentClassificationJob {
        /// Creates a new `DescribeDocumentClassificationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDocumentClassificationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDocumentClassificationJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDocumentClassifier`.
    ///
    /// <p>Gets the properties associated with a document classifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDocumentClassifier {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_document_classifier_input::Builder,
    }
    impl DescribeDocumentClassifier {
        /// Creates a new `DescribeDocumentClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDocumentClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDocumentClassifierError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. The operation returns this identifier in its response.</p>
        pub fn document_classifier_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_classifier_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. The operation returns this identifier in its response.</p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_classifier_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDominantLanguageDetectionJob`.
    ///
    /// <p>Gets the properties associated with a dominant language detection job. Use this operation to get the status of a detection job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDominantLanguageDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_dominant_language_detection_job_input::Builder,
    }
    impl DescribeDominantLanguageDetectionJob {
        /// Creates a new `DescribeDominantLanguageDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDominantLanguageDetectionJobOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDominantLanguageDetectionJobError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpoint`.
    ///
    /// <p>Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_endpoint_input::Builder,
    }
    impl DescribeEndpoint {
        /// Creates a new `DescribeEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being described.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being described.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEntitiesDetectionJob`.
    ///
    /// <p>Gets the properties associated with an entities detection job. Use this operation to get the status of a detection job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEntitiesDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_entities_detection_job_input::Builder,
    }
    impl DescribeEntitiesDetectionJob {
        /// Creates a new `DescribeEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEntitiesDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEntityRecognizer`.
    ///
    /// <p>Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEntityRecognizer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_entity_recognizer_input::Builder,
    }
    impl DescribeEntityRecognizer {
        /// Creates a new `DescribeEntityRecognizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEntityRecognizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEntityRecognizerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn entity_recognizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_recognizer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entity_recognizer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventsDetectionJob`.
    ///
    /// <p>Gets the status and details of an events detection job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventsDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_events_detection_job_input::Builder,
    }
    impl DescribeEventsDetectionJob {
        /// Creates a new `DescribeEventsDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the events detection job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier of the events detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeKeyPhrasesDetectionJob`.
    ///
    /// <p>Gets the properties associated with a key phrases detection job. Use this operation to get the status of a detection job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeKeyPhrasesDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_key_phrases_detection_job_input::Builder,
    }
    impl DescribeKeyPhrasesDetectionJob {
        /// Creates a new `DescribeKeyPhrasesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeKeyPhrasesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeKeyPhrasesDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePiiEntitiesDetectionJob`.
    ///
    /// <p>Gets the properties associated with a PII entities detection job. For example, you can use this operation to get the job status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePiiEntitiesDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_pii_entities_detection_job_input::Builder,
    }
    impl DescribePiiEntitiesDetectionJob {
        /// Creates a new `DescribePiiEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePiiEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePiiEntitiesDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourcePolicy`.
    ///
    /// <p>Gets the details of a resource-based policy that is attached to a custom model, including the JSON body of the policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_resource_policy_input::Builder,
    }
    impl DescribeResourcePolicy {
        /// Creates a new `DescribeResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the policy to describe.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the policy to describe.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSentimentDetectionJob`.
    ///
    /// <p>Gets the properties associated with a sentiment detection job. Use this operation to get the status of a detection job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSentimentDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_sentiment_detection_job_input::Builder,
    }
    impl DescribeSentimentDetectionJob {
        /// Creates a new `DescribeSentimentDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSentimentDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSentimentDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTopicsDetectionJob`.
    ///
    /// <p>Gets the properties associated with a topic detection job. Use this operation to get the status of a detection job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTopicsDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_topics_detection_job_input::Builder,
    }
    impl DescribeTopicsDetectionJob {
        /// Creates a new `DescribeTopicsDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTopicsDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTopicsDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier assigned by the user to the detection job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier assigned by the user to the detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectDominantLanguage`.
    ///
    /// <p>Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported Languages</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectDominantLanguage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_dominant_language_input::Builder,
    }
    impl DetectDominantLanguage {
        /// Creates a new `DetectDominantLanguage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectDominantLanguageOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectDominantLanguageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 text string. Each string should contain at least 20 characters and must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>A UTF-8 text string. Each string should contain at least 20 characters and must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectEntities`.
    ///
    /// <p>Inspects text for named entities, and returns information about them. For more information, about named entities, see <code>how-entities</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectEntities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_entities_input::Builder,
    }
    impl DetectEntities {
        /// Creates a new `DetectEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectEntitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        /// <p>If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you specify here.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        /// <p>If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you specify here.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an endpoint if you want to detect entities by using your own custom model instead of the default model that is used by Amazon Comprehend.</p>
        /// <p>If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you provide in your request.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an endpoint if you want to detect entities by using your own custom model instead of the default model that is used by Amazon Comprehend.</p>
        /// <p>If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you provide in your request.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectKeyPhrases`.
    ///
    /// <p>Detects the key noun phrases found in the text. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectKeyPhrases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_key_phrases_input::Builder,
    }
    impl DetectKeyPhrases {
        /// Creates a new `DetectKeyPhrases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectKeyPhrasesOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectKeyPhrasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectPiiEntities`.
    ///
    /// <p>Inspects the input text for entities that contain personally identifiable information (PII) and returns information about them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectPiiEntities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_pii_entities_input::Builder,
    }
    impl DetectPiiEntities {
        /// Creates a new `DetectPiiEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectPiiEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectPiiEntitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectSentiment`.
    ///
    /// <p>Inspects text and returns an inference of the prevailing sentiment (<code>POSITIVE</code>, <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectSentiment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_sentiment_input::Builder,
    }
    impl DetectSentiment {
        /// Creates a new `DetectSentiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectSentimentOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectSentimentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectSyntax`.
    ///
    /// <p>Inspects text for syntax and the part of speech of words in the document. For more information, <code>how-syntax</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectSyntax {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_syntax_input::Builder,
    }
    impl DetectSyntax {
        /// Creates a new `DetectSyntax`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectSyntaxOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectSyntaxError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF encoded characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF encoded characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language code of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt").</p>
        pub fn language_code(mut self, input: crate::model::SyntaxLanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language code of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt").</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::SyntaxLanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportModel`.
    ///
    /// <p>Creates a new custom model that replicates a source custom model that you import. The source model can be in your AWS account or another one.</p>
    /// <p>If the source model is in another AWS account, then it must have a resource-based policy that authorizes you to import it.</p>
    /// <p>The source model must be in the same AWS region that you're using when you import. You can't import a model that's in a different region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_model_input::Builder,
    }
    impl ImportModel {
        /// Creates a new `ImportModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportModelOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the custom model to import.</p>
        pub fn source_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_model_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom model to import.</p>
        pub fn set_source_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_model_arn(input);
            self
        }
        /// <p>The name to assign to the custom model that is created in Amazon Comprehend by this import.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(input.into());
            self
        }
        /// <p>The name to assign to the custom model that is created in Amazon Comprehend by this import.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
        /// <p>The version name given to the custom model that is created by this import. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the account/AWS Region.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(input.into());
            self
        }
        /// <p>The version name given to the custom model that is created by this import. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the account/AWS Region.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn model_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_kms_key_id(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn set_model_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_kms_key_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that allows Amazon Comprehend to use Amazon Key Management Service (KMS) to encrypt or decrypt the custom model.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that allows Amazon Comprehend to use Amazon Key Management Service (KMS) to encrypt or decrypt the custom model.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the custom model that is created by this import. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the custom model that is created by this import. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocumentClassificationJobs`.
    ///
    /// <p>Gets a list of the documentation classification jobs that you have submitted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDocumentClassificationJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_document_classification_jobs_input::Builder,
    }
    impl ListDocumentClassificationJobs {
        /// Creates a new `ListDocumentClassificationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentClassificationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentClassificationJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDocumentClassificationJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDocumentClassificationJobsPaginator {
            crate::paginator::ListDocumentClassificationJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their names, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::DocumentClassificationJobFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their names, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DocumentClassificationJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocumentClassifiers`.
    ///
    /// <p>Gets a list of the document classifiers that you have created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDocumentClassifiers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_document_classifiers_input::Builder,
    }
    impl ListDocumentClassifiers {
        /// Creates a new `ListDocumentClassifiers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentClassifiersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentClassifiersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDocumentClassifiersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDocumentClassifiersPaginator {
            crate::paginator::ListDocumentClassifiersPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::DocumentClassifierFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocumentClassifierSummaries`.
    ///
    /// <p>Gets a list of summaries of the document classifiers that you have created</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDocumentClassifierSummaries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_document_classifier_summaries_input::Builder,
    }
    impl ListDocumentClassifierSummaries {
        /// Creates a new `ListDocumentClassifierSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentClassifierSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentClassifierSummariesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDocumentClassifierSummariesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDocumentClassifierSummariesPaginator {
            crate::paginator::ListDocumentClassifierSummariesPaginator::new(self.handle, self.inner)
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDominantLanguageDetectionJobs`.
    ///
    /// <p>Gets a list of the dominant language detection jobs that you have submitted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDominantLanguageDetectionJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_dominant_language_detection_jobs_input::Builder,
    }
    impl ListDominantLanguageDetectionJobs {
        /// Creates a new `ListDominantLanguageDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDominantLanguageDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDominantLanguageDetectionJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDominantLanguageDetectionJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListDominantLanguageDetectionJobsPaginator {
            crate::paginator::ListDominantLanguageDetectionJobsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>Filters that jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::DominantLanguageDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters that jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DominantLanguageDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEndpoints`.
    ///
    /// <p>Gets a list of all existing endpoints that you've created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEndpoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_endpoints_input::Builder,
    }
    impl ListEndpoints {
        /// Creates a new `ListEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEndpointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the endpoints that are returned. You can filter endpoints on their name, model, status, or the date and time that they were created. You can only set one filter at a time. </p>
        pub fn filter(mut self, input: crate::model::EndpointFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters the endpoints that are returned. You can filter endpoints on their name, model, status, or the date and time that they were created. You can only set one filter at a time. </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EndpointFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntitiesDetectionJobs`.
    ///
    /// <p>Gets a list of the entity detection jobs that you have submitted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEntitiesDetectionJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_entities_detection_jobs_input::Builder,
    }
    impl ListEntitiesDetectionJobs {
        /// Creates a new `ListEntitiesDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntitiesDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntitiesDetectionJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEntitiesDetectionJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEntitiesDetectionJobsPaginator {
            crate::paginator::ListEntitiesDetectionJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::EntitiesDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EntitiesDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntityRecognizers`.
    ///
    /// <p>Gets a list of the properties of all entity recognizers that you created, including recognizers currently in training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.</p>
    /// <p>The results of this list are not in any particular order. Please get the list and sort locally if needed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEntityRecognizers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_entity_recognizers_input::Builder,
    }
    impl ListEntityRecognizers {
        /// Creates a new `ListEntityRecognizers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntityRecognizersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntityRecognizersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEntityRecognizersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEntityRecognizersPaginator {
            crate::paginator::ListEntityRecognizersPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the list of entities returned. You can filter on <code>Status</code>, <code>SubmitTimeBefore</code>, or <code>SubmitTimeAfter</code>. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::EntityRecognizerFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters the list of entities returned. You can filter on <code>Status</code>, <code>SubmitTimeBefore</code>, or <code>SubmitTimeAfter</code>. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of results to return on each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return on each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntityRecognizerSummaries`.
    ///
    /// <p>Gets a list of summaries for the entity recognizers that you have created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEntityRecognizerSummaries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_entity_recognizer_summaries_input::Builder,
    }
    impl ListEntityRecognizerSummaries {
        /// Creates a new `ListEntityRecognizerSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntityRecognizerSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntityRecognizerSummariesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEntityRecognizerSummariesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEntityRecognizerSummariesPaginator {
            crate::paginator::ListEntityRecognizerSummariesPaginator::new(self.handle, self.inner)
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventsDetectionJobs`.
    ///
    /// <p>Gets a list of the events detection jobs that you have submitted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventsDetectionJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_events_detection_jobs_input::Builder,
    }
    impl ListEventsDetectionJobs {
        /// Creates a new `ListEventsDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventsDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventsDetectionJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEventsDetectionJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEventsDetectionJobsPaginator {
            crate::paginator::ListEventsDetectionJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::EventsDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EventsDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListKeyPhrasesDetectionJobs`.
    ///
    /// <p>Get a list of key phrase detection jobs that you have submitted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListKeyPhrasesDetectionJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_key_phrases_detection_jobs_input::Builder,
    }
    impl ListKeyPhrasesDetectionJobs {
        /// Creates a new `ListKeyPhrasesDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListKeyPhrasesDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListKeyPhrasesDetectionJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListKeyPhrasesDetectionJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListKeyPhrasesDetectionJobsPaginator {
            crate::paginator::ListKeyPhrasesDetectionJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::KeyPhrasesDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::KeyPhrasesDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPiiEntitiesDetectionJobs`.
    ///
    /// <p>Gets a list of the PII entity detection jobs that you have submitted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPiiEntitiesDetectionJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_pii_entities_detection_jobs_input::Builder,
    }
    impl ListPiiEntitiesDetectionJobs {
        /// Creates a new `ListPiiEntitiesDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPiiEntitiesDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPiiEntitiesDetectionJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::PiiEntitiesDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::PiiEntitiesDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSentimentDetectionJobs`.
    ///
    /// <p>Gets a list of sentiment detection jobs that you have submitted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSentimentDetectionJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_sentiment_detection_jobs_input::Builder,
    }
    impl ListSentimentDetectionJobs {
        /// Creates a new `ListSentimentDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSentimentDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSentimentDetectionJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSentimentDetectionJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSentimentDetectionJobsPaginator {
            crate::paginator::ListSentimentDetectionJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::SentimentDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::SentimentDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags associated with a given Amazon Comprehend resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you are querying. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you are querying. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTopicsDetectionJobs`.
    ///
    /// <p>Gets a list of the topic detection jobs that you have submitted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTopicsDetectionJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_topics_detection_jobs_input::Builder,
    }
    impl ListTopicsDetectionJobs {
        /// Creates a new `ListTopicsDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTopicsDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTopicsDetectionJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTopicsDetectionJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTopicsDetectionJobsPaginator {
            crate::paginator::ListTopicsDetectionJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the jobs that are returned. Jobs can be filtered on their name, status, or the date and time that they were submitted. You can set only one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::TopicsDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters the jobs that are returned. Jobs can be filtered on their name, status, or the date and time that they were submitted. You can set only one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::TopicsDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p>Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another AWS account to import the custom model, which replicates it in Amazon Comprehend in their account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl PutResourcePolicy {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the custom model to attach the policy to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom model to attach the policy to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The JSON resource-based policy to attach to your custom model. Provide your JSON as a UTF-8 encoded string without line breaks. To provide valid JSON for your policy, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p>
        /// <p> <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code> </p>
        /// <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p>
        /// <p> <code>'{"attribute": "value", "attribute": ["value"]}'</code> </p>
        pub fn resource_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_policy(input.into());
            self
        }
        /// <p>The JSON resource-based policy to attach to your custom model. Provide your JSON as a UTF-8 encoded string without line breaks. To provide valid JSON for your policy, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p>
        /// <p> <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code> </p>
        /// <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p>
        /// <p> <code>'{"attribute": "value", "attribute": ["value"]}'</code> </p>
        pub fn set_resource_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_policy(input);
            self
        }
        /// <p>The revision ID that Amazon Comprehend assigned to the policy that you are updating. If you are creating a new policy that has no prior version, don't use this parameter. Amazon Comprehend creates the revision ID for you.</p>
        pub fn policy_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_revision_id(input.into());
            self
        }
        /// <p>The revision ID that Amazon Comprehend assigned to the policy that you are updating. If you are creating a new policy that has no prior version, don't use this parameter. Amazon Comprehend creates the revision ID for you.</p>
        pub fn set_policy_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDocumentClassificationJob`.
    ///
    /// <p>Starts an asynchronous document classification job. Use the operation to track the progress of the job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartDocumentClassificationJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_document_classification_job_input::Builder,
    }
    impl StartDocumentClassificationJob {
        /// Creates a new `StartDocumentClassificationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDocumentClassificationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDocumentClassificationJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the document classifier to use to process the job.</p>
        pub fn document_classifier_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_classifier_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the document classifier to use to process the job.</p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_classifier_arn(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your document classification job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your document classification job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the document classification job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the document classification job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDominantLanguageDetectionJob`.
    ///
    /// <p>Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track the status of a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartDominantLanguageDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_dominant_language_detection_job_input::Builder,
    }
    impl StartDominantLanguageDetectionJob {
        /// Creates a new `StartDominantLanguageDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDominantLanguageDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDominantLanguageDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>An identifier for the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>An identifier for the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your dominant language detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your dominant language detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the dominant language detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the dominant language detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartEntitiesDetectionJob`.
    ///
    /// <p>Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status of a job.</p>
    /// <p>This API can be used for either standard entity detection or custom entity recognition. In order to be used for custom entity recognition, the optional <code>EntityRecognizerArn</code> must be used in order to provide access to the recognizer being used to detect the custom entity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartEntitiesDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_entities_detection_job_input::Builder,
    }
    impl StartEntitiesDetectionJob {
        /// Creates a new `StartEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartEntitiesDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the specific entity recognizer to be used by the <code>StartEntitiesDetectionJob</code>. This ARN is optional and is only used for a custom entity recognition job.</p>
        pub fn entity_recognizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_recognizer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the specific entity recognizer to be used by the <code>StartEntitiesDetectionJob</code>. This ARN is optional and is only used for a custom entity recognition job.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entity_recognizer_arn(input);
            self
        }
        /// <p>The language of the input documents. All documents must be in the same language. You can specify any of the languages supported by Amazon Comprehend. If custom entities recognition is used, this parameter is ignored and the language used for training the model is used instead.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents. All documents must be in the same language. You can specify any of the languages supported by Amazon Comprehend. If custom entities recognition is used, this parameter is ignored and the language used for training the model is used instead.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the entities detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the entities detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartEventsDetectionJob`.
    ///
    /// <p>Starts an asynchronous event detection job for a collection of documents.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartEventsDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_events_detection_job_input::Builder,
    }
    impl StartEventsDetectionJob {
        /// Creates a new `StartEventsDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartEventsDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartEventsDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the events detection job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The identifier of the events detection job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>An unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>An unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `TargetEventTypes`.
        ///
        /// To override the contents of this collection use [`set_target_event_types`](Self::set_target_event_types).
        ///
        /// <p>The types of events to detect in the input documents.</p>
        pub fn target_event_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_event_types(input.into());
            self
        }
        /// <p>The types of events to detect in the input documents.</p>
        pub fn set_target_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_event_types(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the events detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the events detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartKeyPhrasesDetectionJob`.
    ///
    /// <p>Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the status of a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartKeyPhrasesDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_key_phrases_detection_job_input::Builder,
    }
    impl StartKeyPhrasesDetectionJob {
        /// Creates a new `StartKeyPhrasesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartKeyPhrasesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartKeyPhrasesDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p> Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your key phrases detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p> Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your key phrases detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the key phrases detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the key phrases detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartPiiEntitiesDetectionJob`.
    ///
    /// <p>Starts an asynchronous PII entity detection job for a collection of documents.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartPiiEntitiesDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_pii_entities_detection_job_input::Builder,
    }
    impl StartPiiEntitiesDetectionJob {
        /// Creates a new `StartPiiEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartPiiEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartPiiEntitiesDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input properties for a PII entities detection job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>The input properties for a PII entities detection job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Provides conﬁguration parameters for the output of PII entity detection jobs.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Provides conﬁguration parameters for the output of PII entity detection jobs.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in which PII entities are redacted.</p>
        pub fn mode(mut self, input: crate::model::PiiEntitiesDetectionMode) -> Self {
            self.inner = self.inner.mode(input);
            self
        }
        /// <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in which PII entities are redacted.</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::PiiEntitiesDetectionMode>,
        ) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>Provides configuration parameters for PII entity redaction.</p>
        /// <p>This parameter is required if you set the <code>Mode</code> parameter to <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code> definition that includes the <code>PiiEntityTypes</code> parameter.</p>
        pub fn redaction_config(mut self, input: crate::model::RedactionConfig) -> Self {
            self.inner = self.inner.redaction_config(input);
            self
        }
        /// <p>Provides configuration parameters for PII entity redaction.</p>
        /// <p>This parameter is required if you set the <code>Mode</code> parameter to <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code> definition that includes the <code>PiiEntityTypes</code> parameter.</p>
        pub fn set_redaction_config(
            mut self,
            input: std::option::Option<crate::model::RedactionConfig>,
        ) -> Self {
            self.inner = self.inner.set_redaction_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the PII entities detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the PII entities detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSentimentDetectionJob`.
    ///
    /// <p>Starts an asynchronous sentiment detection job for a collection of documents. use the operation to track the status of a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartSentimentDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_sentiment_detection_job_input::Builder,
    }
    impl StartSentimentDetectionJob {
        /// Creates a new `StartSentimentDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSentimentDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSentimentDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files. </p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files. </p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the sentiment detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the sentiment detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTopicsDetectionJob`.
    ///
    /// <p>Starts an asynchronous topic detection job. Use the <code>DescribeTopicDetectionJob</code> operation to track the status of a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartTopicsDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_topics_detection_job_input::Builder,
    }
    impl StartTopicsDetectionJob {
        /// Creates a new `StartTopicsDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTopicsDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTopicsDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files. The output is a compressed archive with two files, <code>topic-terms.csv</code> that lists the terms associated with each topic, and <code>doc-topics.csv</code> that lists the documents associated with each topic</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files. The output is a compressed archive with two files, <code>topic-terms.csv</code> that lists the terms associated with each topic, and <code>doc-topics.csv</code> that lists the documents associated with each topic</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The number of topics to detect.</p>
        pub fn number_of_topics(mut self, input: i32) -> Self {
            self.inner = self.inner.number_of_topics(input);
            self
        }
        /// <p>The number of topics to detect.</p>
        pub fn set_number_of_topics(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_topics(input);
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the topics detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the topics detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDominantLanguageDetectionJob`.
    ///
    /// <p>Stops a dominant language detection job in progress.</p>
    /// <p>If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.</p>
    /// <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception. </p>
    /// <p>When a job is stopped, any documents already processed are written to the output location.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopDominantLanguageDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_dominant_language_detection_job_input::Builder,
    }
    impl StopDominantLanguageDetectionJob {
        /// Creates a new `StopDominantLanguageDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDominantLanguageDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDominantLanguageDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the dominant language detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier of the dominant language detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopEntitiesDetectionJob`.
    ///
    /// <p>Stops an entities detection job in progress.</p>
    /// <p>If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.</p>
    /// <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception. </p>
    /// <p>When a job is stopped, any documents already processed are written to the output location.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopEntitiesDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_entities_detection_job_input::Builder,
    }
    impl StopEntitiesDetectionJob {
        /// Creates a new `StopEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopEntitiesDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the entities detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier of the entities detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopEventsDetectionJob`.
    ///
    /// <p>Stops an events detection job in progress.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopEventsDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_events_detection_job_input::Builder,
    }
    impl StopEventsDetectionJob {
        /// Creates a new `StopEventsDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopEventsDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopEventsDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the events detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier of the events detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopKeyPhrasesDetectionJob`.
    ///
    /// <p>Stops a key phrases detection job in progress.</p>
    /// <p>If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.</p>
    /// <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception. </p>
    /// <p>When a job is stopped, any documents already processed are written to the output location.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopKeyPhrasesDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_key_phrases_detection_job_input::Builder,
    }
    impl StopKeyPhrasesDetectionJob {
        /// Creates a new `StopKeyPhrasesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopKeyPhrasesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopKeyPhrasesDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the key phrases detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier of the key phrases detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopPiiEntitiesDetectionJob`.
    ///
    /// <p>Stops a PII entities detection job in progress.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopPiiEntitiesDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_pii_entities_detection_job_input::Builder,
    }
    impl StopPiiEntitiesDetectionJob {
        /// Creates a new `StopPiiEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopPiiEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopPiiEntitiesDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the PII entities detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier of the PII entities detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopSentimentDetectionJob`.
    ///
    /// <p>Stops a sentiment detection job in progress.</p>
    /// <p>If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.</p>
    /// <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception. </p>
    /// <p>When a job is stopped, any documents already processed are written to the output location.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopSentimentDetectionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_sentiment_detection_job_input::Builder,
    }
    impl StopSentimentDetectionJob {
        /// Creates a new `StopSentimentDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopSentimentDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopSentimentDetectionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the sentiment detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier of the sentiment detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopTrainingDocumentClassifier`.
    ///
    /// <p>Stops a document classifier training job while in progress.</p>
    /// <p>If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the <code>TRAINED</code>; otherwise the training job is stopped and put into the <code>STOPPED</code> state and the service sends back an HTTP 200 response with an empty HTTP body. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopTrainingDocumentClassifier {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_training_document_classifier_input::Builder,
    }
    impl StopTrainingDocumentClassifier {
        /// Creates a new `StopTrainingDocumentClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopTrainingDocumentClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::StopTrainingDocumentClassifierError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier currently being trained.</p>
        pub fn document_classifier_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_classifier_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier currently being trained.</p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_classifier_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopTrainingEntityRecognizer`.
    ///
    /// <p>Stops an entity recognizer training job while in progress.</p>
    /// <p>If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the <code>TRAINED</code>; otherwise the training job is stopped and putted into the <code>STOPPED</code> state and the service sends back an HTTP 200 response with an empty HTTP body.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopTrainingEntityRecognizer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_training_entity_recognizer_input::Builder,
    }
    impl StopTrainingEntityRecognizer {
        /// Creates a new `StopTrainingEntityRecognizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopTrainingEntityRecognizerOutput,
            aws_smithy_http::result::SdkError<crate::error::StopTrainingEntityRecognizerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer currently being trained.</p>
        pub fn entity_recognizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_recognizer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer currently being trained.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entity_recognizer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource to which you want to associate the tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource to which you want to associate the tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags being associated with a specific Amazon Comprehend resource. There can be a maximum of 50 tags (both existing and pending) associated with a specific resource. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags being associated with a specific Amazon Comprehend resource. There can be a maximum of 50 tags (both existing and pending) associated with a specific resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a specific tag associated with an Amazon Comprehend resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the given Amazon Comprehend resource from which you want to remove the tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the given Amazon Comprehend resource from which you want to remove the tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The initial part of a key-value pair that forms a tag being removed from a given resource. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. Keys must be unique and cannot be duplicated for a particular resource. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The initial part of a key-value pair that forms a tag being removed from a given resource. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. Keys must be unique and cannot be duplicated for a particular resource. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEndpoint`.
    ///
    /// <p>Updates information about the specified endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_endpoint_input::Builder,
    }
    impl UpdateEndpoint {
        /// Creates a new `UpdateEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being updated.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being updated.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
        /// <p>The ARN of the new model to use when updating an existing endpoint.</p>
        pub fn desired_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.desired_model_arn(input.into());
            self
        }
        /// <p>The ARN of the new model to use when updating an existing endpoint.</p>
        pub fn set_desired_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_desired_model_arn(input);
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn desired_inference_units(mut self, input: i32) -> Self {
            self.inner = self.inner.desired_inference_units(input);
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn set_desired_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_desired_inference_units(input);
            self
        }
        /// <p>Data access role ARN to use in case the new model is encrypted with a customer CMK.</p>
        pub fn desired_data_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.desired_data_access_role_arn(input.into());
            self
        }
        /// <p>Data access role ARN to use in case the new model is encrypted with a customer CMK.</p>
        pub fn set_desired_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_desired_data_access_role_arn(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
