// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Comprehend
///
/// Client for invoking operations on Amazon Comprehend. Each operation on Amazon Comprehend is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_comprehend::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_comprehend::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_comprehend::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchDetectDominantLanguage` operation.
    ///
    /// See [`BatchDetectDominantLanguage`](crate::client::fluent_builders::BatchDetectDominantLanguage) for more information about the
    /// operation and its arguments.
    pub fn batch_detect_dominant_language(
        &self,
    ) -> fluent_builders::BatchDetectDominantLanguage<C, M, R> {
        fluent_builders::BatchDetectDominantLanguage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDetectEntities` operation.
    ///
    /// See [`BatchDetectEntities`](crate::client::fluent_builders::BatchDetectEntities) for more information about the
    /// operation and its arguments.
    pub fn batch_detect_entities(&self) -> fluent_builders::BatchDetectEntities<C, M, R> {
        fluent_builders::BatchDetectEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDetectKeyPhrases` operation.
    ///
    /// See [`BatchDetectKeyPhrases`](crate::client::fluent_builders::BatchDetectKeyPhrases) for more information about the
    /// operation and its arguments.
    pub fn batch_detect_key_phrases(&self) -> fluent_builders::BatchDetectKeyPhrases<C, M, R> {
        fluent_builders::BatchDetectKeyPhrases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDetectSentiment` operation.
    ///
    /// See [`BatchDetectSentiment`](crate::client::fluent_builders::BatchDetectSentiment) for more information about the
    /// operation and its arguments.
    pub fn batch_detect_sentiment(&self) -> fluent_builders::BatchDetectSentiment<C, M, R> {
        fluent_builders::BatchDetectSentiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDetectSyntax` operation.
    ///
    /// See [`BatchDetectSyntax`](crate::client::fluent_builders::BatchDetectSyntax) for more information about the
    /// operation and its arguments.
    pub fn batch_detect_syntax(&self) -> fluent_builders::BatchDetectSyntax<C, M, R> {
        fluent_builders::BatchDetectSyntax::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ClassifyDocument` operation.
    ///
    /// See [`ClassifyDocument`](crate::client::fluent_builders::ClassifyDocument) for more information about the
    /// operation and its arguments.
    pub fn classify_document(&self) -> fluent_builders::ClassifyDocument<C, M, R> {
        fluent_builders::ClassifyDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ContainsPiiEntities` operation.
    ///
    /// See [`ContainsPiiEntities`](crate::client::fluent_builders::ContainsPiiEntities) for more information about the
    /// operation and its arguments.
    pub fn contains_pii_entities(&self) -> fluent_builders::ContainsPiiEntities<C, M, R> {
        fluent_builders::ContainsPiiEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDocumentClassifier` operation.
    ///
    /// See [`CreateDocumentClassifier`](crate::client::fluent_builders::CreateDocumentClassifier) for more information about the
    /// operation and its arguments.
    pub fn create_document_classifier(&self) -> fluent_builders::CreateDocumentClassifier<C, M, R> {
        fluent_builders::CreateDocumentClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEndpoint` operation.
    ///
    /// See [`CreateEndpoint`](crate::client::fluent_builders::CreateEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_endpoint(&self) -> fluent_builders::CreateEndpoint<C, M, R> {
        fluent_builders::CreateEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEntityRecognizer` operation.
    ///
    /// See [`CreateEntityRecognizer`](crate::client::fluent_builders::CreateEntityRecognizer) for more information about the
    /// operation and its arguments.
    pub fn create_entity_recognizer(&self) -> fluent_builders::CreateEntityRecognizer<C, M, R> {
        fluent_builders::CreateEntityRecognizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDocumentClassifier` operation.
    ///
    /// See [`DeleteDocumentClassifier`](crate::client::fluent_builders::DeleteDocumentClassifier) for more information about the
    /// operation and its arguments.
    pub fn delete_document_classifier(&self) -> fluent_builders::DeleteDocumentClassifier<C, M, R> {
        fluent_builders::DeleteDocumentClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEndpoint` operation.
    ///
    /// See [`DeleteEndpoint`](crate::client::fluent_builders::DeleteEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_endpoint(&self) -> fluent_builders::DeleteEndpoint<C, M, R> {
        fluent_builders::DeleteEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEntityRecognizer` operation.
    ///
    /// See [`DeleteEntityRecognizer`](crate::client::fluent_builders::DeleteEntityRecognizer) for more information about the
    /// operation and its arguments.
    pub fn delete_entity_recognizer(&self) -> fluent_builders::DeleteEntityRecognizer<C, M, R> {
        fluent_builders::DeleteEntityRecognizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDocumentClassificationJob` operation.
    ///
    /// See [`DescribeDocumentClassificationJob`](crate::client::fluent_builders::DescribeDocumentClassificationJob) for more information about the
    /// operation and its arguments.
    pub fn describe_document_classification_job(
        &self,
    ) -> fluent_builders::DescribeDocumentClassificationJob<C, M, R> {
        fluent_builders::DescribeDocumentClassificationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDocumentClassifier` operation.
    ///
    /// See [`DescribeDocumentClassifier`](crate::client::fluent_builders::DescribeDocumentClassifier) for more information about the
    /// operation and its arguments.
    pub fn describe_document_classifier(
        &self,
    ) -> fluent_builders::DescribeDocumentClassifier<C, M, R> {
        fluent_builders::DescribeDocumentClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDominantLanguageDetectionJob` operation.
    ///
    /// See [`DescribeDominantLanguageDetectionJob`](crate::client::fluent_builders::DescribeDominantLanguageDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn describe_dominant_language_detection_job(
        &self,
    ) -> fluent_builders::DescribeDominantLanguageDetectionJob<C, M, R> {
        fluent_builders::DescribeDominantLanguageDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpoint` operation.
    ///
    /// See [`DescribeEndpoint`](crate::client::fluent_builders::DescribeEndpoint) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoint(&self) -> fluent_builders::DescribeEndpoint<C, M, R> {
        fluent_builders::DescribeEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEntitiesDetectionJob` operation.
    ///
    /// See [`DescribeEntitiesDetectionJob`](crate::client::fluent_builders::DescribeEntitiesDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn describe_entities_detection_job(
        &self,
    ) -> fluent_builders::DescribeEntitiesDetectionJob<C, M, R> {
        fluent_builders::DescribeEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEntityRecognizer` operation.
    ///
    /// See [`DescribeEntityRecognizer`](crate::client::fluent_builders::DescribeEntityRecognizer) for more information about the
    /// operation and its arguments.
    pub fn describe_entity_recognizer(&self) -> fluent_builders::DescribeEntityRecognizer<C, M, R> {
        fluent_builders::DescribeEntityRecognizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventsDetectionJob` operation.
    ///
    /// See [`DescribeEventsDetectionJob`](crate::client::fluent_builders::DescribeEventsDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn describe_events_detection_job(
        &self,
    ) -> fluent_builders::DescribeEventsDetectionJob<C, M, R> {
        fluent_builders::DescribeEventsDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeKeyPhrasesDetectionJob` operation.
    ///
    /// See [`DescribeKeyPhrasesDetectionJob`](crate::client::fluent_builders::DescribeKeyPhrasesDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn describe_key_phrases_detection_job(
        &self,
    ) -> fluent_builders::DescribeKeyPhrasesDetectionJob<C, M, R> {
        fluent_builders::DescribeKeyPhrasesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePiiEntitiesDetectionJob` operation.
    ///
    /// See [`DescribePiiEntitiesDetectionJob`](crate::client::fluent_builders::DescribePiiEntitiesDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn describe_pii_entities_detection_job(
        &self,
    ) -> fluent_builders::DescribePiiEntitiesDetectionJob<C, M, R> {
        fluent_builders::DescribePiiEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSentimentDetectionJob` operation.
    ///
    /// See [`DescribeSentimentDetectionJob`](crate::client::fluent_builders::DescribeSentimentDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn describe_sentiment_detection_job(
        &self,
    ) -> fluent_builders::DescribeSentimentDetectionJob<C, M, R> {
        fluent_builders::DescribeSentimentDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTopicsDetectionJob` operation.
    ///
    /// See [`DescribeTopicsDetectionJob`](crate::client::fluent_builders::DescribeTopicsDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn describe_topics_detection_job(
        &self,
    ) -> fluent_builders::DescribeTopicsDetectionJob<C, M, R> {
        fluent_builders::DescribeTopicsDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectDominantLanguage` operation.
    ///
    /// See [`DetectDominantLanguage`](crate::client::fluent_builders::DetectDominantLanguage) for more information about the
    /// operation and its arguments.
    pub fn detect_dominant_language(&self) -> fluent_builders::DetectDominantLanguage<C, M, R> {
        fluent_builders::DetectDominantLanguage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectEntities` operation.
    ///
    /// See [`DetectEntities`](crate::client::fluent_builders::DetectEntities) for more information about the
    /// operation and its arguments.
    pub fn detect_entities(&self) -> fluent_builders::DetectEntities<C, M, R> {
        fluent_builders::DetectEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectKeyPhrases` operation.
    ///
    /// See [`DetectKeyPhrases`](crate::client::fluent_builders::DetectKeyPhrases) for more information about the
    /// operation and its arguments.
    pub fn detect_key_phrases(&self) -> fluent_builders::DetectKeyPhrases<C, M, R> {
        fluent_builders::DetectKeyPhrases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectPiiEntities` operation.
    ///
    /// See [`DetectPiiEntities`](crate::client::fluent_builders::DetectPiiEntities) for more information about the
    /// operation and its arguments.
    pub fn detect_pii_entities(&self) -> fluent_builders::DetectPiiEntities<C, M, R> {
        fluent_builders::DetectPiiEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectSentiment` operation.
    ///
    /// See [`DetectSentiment`](crate::client::fluent_builders::DetectSentiment) for more information about the
    /// operation and its arguments.
    pub fn detect_sentiment(&self) -> fluent_builders::DetectSentiment<C, M, R> {
        fluent_builders::DetectSentiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectSyntax` operation.
    ///
    /// See [`DetectSyntax`](crate::client::fluent_builders::DetectSyntax) for more information about the
    /// operation and its arguments.
    pub fn detect_syntax(&self) -> fluent_builders::DetectSyntax<C, M, R> {
        fluent_builders::DetectSyntax::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDocumentClassificationJobs` operation.
    ///
    /// See [`ListDocumentClassificationJobs`](crate::client::fluent_builders::ListDocumentClassificationJobs) for more information about the
    /// operation and its arguments.
    pub fn list_document_classification_jobs(
        &self,
    ) -> fluent_builders::ListDocumentClassificationJobs<C, M, R> {
        fluent_builders::ListDocumentClassificationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDocumentClassifiers` operation.
    ///
    /// See [`ListDocumentClassifiers`](crate::client::fluent_builders::ListDocumentClassifiers) for more information about the
    /// operation and its arguments.
    pub fn list_document_classifiers(&self) -> fluent_builders::ListDocumentClassifiers<C, M, R> {
        fluent_builders::ListDocumentClassifiers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDocumentClassifierSummaries` operation.
    ///
    /// See [`ListDocumentClassifierSummaries`](crate::client::fluent_builders::ListDocumentClassifierSummaries) for more information about the
    /// operation and its arguments.
    pub fn list_document_classifier_summaries(
        &self,
    ) -> fluent_builders::ListDocumentClassifierSummaries<C, M, R> {
        fluent_builders::ListDocumentClassifierSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDominantLanguageDetectionJobs` operation.
    ///
    /// See [`ListDominantLanguageDetectionJobs`](crate::client::fluent_builders::ListDominantLanguageDetectionJobs) for more information about the
    /// operation and its arguments.
    pub fn list_dominant_language_detection_jobs(
        &self,
    ) -> fluent_builders::ListDominantLanguageDetectionJobs<C, M, R> {
        fluent_builders::ListDominantLanguageDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEndpoints` operation.
    ///
    /// See [`ListEndpoints`](crate::client::fluent_builders::ListEndpoints) for more information about the
    /// operation and its arguments.
    pub fn list_endpoints(&self) -> fluent_builders::ListEndpoints<C, M, R> {
        fluent_builders::ListEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEntitiesDetectionJobs` operation.
    ///
    /// See [`ListEntitiesDetectionJobs`](crate::client::fluent_builders::ListEntitiesDetectionJobs) for more information about the
    /// operation and its arguments.
    pub fn list_entities_detection_jobs(
        &self,
    ) -> fluent_builders::ListEntitiesDetectionJobs<C, M, R> {
        fluent_builders::ListEntitiesDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEntityRecognizers` operation.
    ///
    /// See [`ListEntityRecognizers`](crate::client::fluent_builders::ListEntityRecognizers) for more information about the
    /// operation and its arguments.
    pub fn list_entity_recognizers(&self) -> fluent_builders::ListEntityRecognizers<C, M, R> {
        fluent_builders::ListEntityRecognizers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEntityRecognizerSummaries` operation.
    ///
    /// See [`ListEntityRecognizerSummaries`](crate::client::fluent_builders::ListEntityRecognizerSummaries) for more information about the
    /// operation and its arguments.
    pub fn list_entity_recognizer_summaries(
        &self,
    ) -> fluent_builders::ListEntityRecognizerSummaries<C, M, R> {
        fluent_builders::ListEntityRecognizerSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEventsDetectionJobs` operation.
    ///
    /// See [`ListEventsDetectionJobs`](crate::client::fluent_builders::ListEventsDetectionJobs) for more information about the
    /// operation and its arguments.
    pub fn list_events_detection_jobs(&self) -> fluent_builders::ListEventsDetectionJobs<C, M, R> {
        fluent_builders::ListEventsDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListKeyPhrasesDetectionJobs` operation.
    ///
    /// See [`ListKeyPhrasesDetectionJobs`](crate::client::fluent_builders::ListKeyPhrasesDetectionJobs) for more information about the
    /// operation and its arguments.
    pub fn list_key_phrases_detection_jobs(
        &self,
    ) -> fluent_builders::ListKeyPhrasesDetectionJobs<C, M, R> {
        fluent_builders::ListKeyPhrasesDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPiiEntitiesDetectionJobs` operation.
    ///
    /// See [`ListPiiEntitiesDetectionJobs`](crate::client::fluent_builders::ListPiiEntitiesDetectionJobs) for more information about the
    /// operation and its arguments.
    pub fn list_pii_entities_detection_jobs(
        &self,
    ) -> fluent_builders::ListPiiEntitiesDetectionJobs<C, M, R> {
        fluent_builders::ListPiiEntitiesDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSentimentDetectionJobs` operation.
    ///
    /// See [`ListSentimentDetectionJobs`](crate::client::fluent_builders::ListSentimentDetectionJobs) for more information about the
    /// operation and its arguments.
    pub fn list_sentiment_detection_jobs(
        &self,
    ) -> fluent_builders::ListSentimentDetectionJobs<C, M, R> {
        fluent_builders::ListSentimentDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTopicsDetectionJobs` operation.
    ///
    /// See [`ListTopicsDetectionJobs`](crate::client::fluent_builders::ListTopicsDetectionJobs) for more information about the
    /// operation and its arguments.
    pub fn list_topics_detection_jobs(&self) -> fluent_builders::ListTopicsDetectionJobs<C, M, R> {
        fluent_builders::ListTopicsDetectionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDocumentClassificationJob` operation.
    ///
    /// See [`StartDocumentClassificationJob`](crate::client::fluent_builders::StartDocumentClassificationJob) for more information about the
    /// operation and its arguments.
    pub fn start_document_classification_job(
        &self,
    ) -> fluent_builders::StartDocumentClassificationJob<C, M, R> {
        fluent_builders::StartDocumentClassificationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDominantLanguageDetectionJob` operation.
    ///
    /// See [`StartDominantLanguageDetectionJob`](crate::client::fluent_builders::StartDominantLanguageDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn start_dominant_language_detection_job(
        &self,
    ) -> fluent_builders::StartDominantLanguageDetectionJob<C, M, R> {
        fluent_builders::StartDominantLanguageDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartEntitiesDetectionJob` operation.
    ///
    /// See [`StartEntitiesDetectionJob`](crate::client::fluent_builders::StartEntitiesDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn start_entities_detection_job(
        &self,
    ) -> fluent_builders::StartEntitiesDetectionJob<C, M, R> {
        fluent_builders::StartEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartEventsDetectionJob` operation.
    ///
    /// See [`StartEventsDetectionJob`](crate::client::fluent_builders::StartEventsDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn start_events_detection_job(&self) -> fluent_builders::StartEventsDetectionJob<C, M, R> {
        fluent_builders::StartEventsDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartKeyPhrasesDetectionJob` operation.
    ///
    /// See [`StartKeyPhrasesDetectionJob`](crate::client::fluent_builders::StartKeyPhrasesDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn start_key_phrases_detection_job(
        &self,
    ) -> fluent_builders::StartKeyPhrasesDetectionJob<C, M, R> {
        fluent_builders::StartKeyPhrasesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartPiiEntitiesDetectionJob` operation.
    ///
    /// See [`StartPiiEntitiesDetectionJob`](crate::client::fluent_builders::StartPiiEntitiesDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn start_pii_entities_detection_job(
        &self,
    ) -> fluent_builders::StartPiiEntitiesDetectionJob<C, M, R> {
        fluent_builders::StartPiiEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSentimentDetectionJob` operation.
    ///
    /// See [`StartSentimentDetectionJob`](crate::client::fluent_builders::StartSentimentDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn start_sentiment_detection_job(
        &self,
    ) -> fluent_builders::StartSentimentDetectionJob<C, M, R> {
        fluent_builders::StartSentimentDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartTopicsDetectionJob` operation.
    ///
    /// See [`StartTopicsDetectionJob`](crate::client::fluent_builders::StartTopicsDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn start_topics_detection_job(&self) -> fluent_builders::StartTopicsDetectionJob<C, M, R> {
        fluent_builders::StartTopicsDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopDominantLanguageDetectionJob` operation.
    ///
    /// See [`StopDominantLanguageDetectionJob`](crate::client::fluent_builders::StopDominantLanguageDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn stop_dominant_language_detection_job(
        &self,
    ) -> fluent_builders::StopDominantLanguageDetectionJob<C, M, R> {
        fluent_builders::StopDominantLanguageDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopEntitiesDetectionJob` operation.
    ///
    /// See [`StopEntitiesDetectionJob`](crate::client::fluent_builders::StopEntitiesDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn stop_entities_detection_job(
        &self,
    ) -> fluent_builders::StopEntitiesDetectionJob<C, M, R> {
        fluent_builders::StopEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopEventsDetectionJob` operation.
    ///
    /// See [`StopEventsDetectionJob`](crate::client::fluent_builders::StopEventsDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn stop_events_detection_job(&self) -> fluent_builders::StopEventsDetectionJob<C, M, R> {
        fluent_builders::StopEventsDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopKeyPhrasesDetectionJob` operation.
    ///
    /// See [`StopKeyPhrasesDetectionJob`](crate::client::fluent_builders::StopKeyPhrasesDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn stop_key_phrases_detection_job(
        &self,
    ) -> fluent_builders::StopKeyPhrasesDetectionJob<C, M, R> {
        fluent_builders::StopKeyPhrasesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopPiiEntitiesDetectionJob` operation.
    ///
    /// See [`StopPiiEntitiesDetectionJob`](crate::client::fluent_builders::StopPiiEntitiesDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn stop_pii_entities_detection_job(
        &self,
    ) -> fluent_builders::StopPiiEntitiesDetectionJob<C, M, R> {
        fluent_builders::StopPiiEntitiesDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopSentimentDetectionJob` operation.
    ///
    /// See [`StopSentimentDetectionJob`](crate::client::fluent_builders::StopSentimentDetectionJob) for more information about the
    /// operation and its arguments.
    pub fn stop_sentiment_detection_job(
        &self,
    ) -> fluent_builders::StopSentimentDetectionJob<C, M, R> {
        fluent_builders::StopSentimentDetectionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopTrainingDocumentClassifier` operation.
    ///
    /// See [`StopTrainingDocumentClassifier`](crate::client::fluent_builders::StopTrainingDocumentClassifier) for more information about the
    /// operation and its arguments.
    pub fn stop_training_document_classifier(
        &self,
    ) -> fluent_builders::StopTrainingDocumentClassifier<C, M, R> {
        fluent_builders::StopTrainingDocumentClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopTrainingEntityRecognizer` operation.
    ///
    /// See [`StopTrainingEntityRecognizer`](crate::client::fluent_builders::StopTrainingEntityRecognizer) for more information about the
    /// operation and its arguments.
    pub fn stop_training_entity_recognizer(
        &self,
    ) -> fluent_builders::StopTrainingEntityRecognizer<C, M, R> {
        fluent_builders::StopTrainingEntityRecognizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEndpoint` operation.
    ///
    /// See [`UpdateEndpoint`](crate::client::fluent_builders::UpdateEndpoint) for more information about the
    /// operation and its arguments.
    pub fn update_endpoint(&self) -> fluent_builders::UpdateEndpoint<C, M, R> {
        fluent_builders::UpdateEndpoint::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchDetectDominantLanguage`.
    ///
    /// <p>Determines the dominant language of the input text for a batch of documents. For a list
    /// of languages that Amazon Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported Languages</a>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDetectDominantLanguage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_detect_dominant_language_input::Builder,
    }
    impl<C, M, R> BatchDetectDominantLanguage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDetectDominantLanguage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDetectDominantLanguageOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDetectDominantLanguageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDetectDominantLanguageInputOperationOutputAlias,
                crate::output::BatchDetectDominantLanguageOutput,
                crate::error::BatchDetectDominantLanguageError,
                crate::input::BatchDetectDominantLanguageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TextList`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document should contain at least 20 characters and must contain fewer than
        /// 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text_list(inp);
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document should contain at least 20 characters and must contain fewer than
        /// 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_text_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDetectEntities`.
    ///
    /// <p>Inspects the text of a batch of documents for named entities and returns information
    /// about them. For more information about named entities, see <a>how-entities</a>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDetectEntities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_detect_entities_input::Builder,
    }
    impl<C, M, R> BatchDetectEntities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDetectEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDetectEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDetectEntitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDetectEntitiesInputOperationOutputAlias,
                crate::output::BatchDetectEntitiesOutput,
                crate::error::BatchDetectEntitiesError,
                crate::input::BatchDetectEntitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TextList`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer than 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text_list(inp);
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer than 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_text_list(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDetectKeyPhrases`.
    ///
    /// <p>Detects the key noun phrases found in a batch of documents.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDetectKeyPhrases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_detect_key_phrases_input::Builder,
    }
    impl<C, M, R> BatchDetectKeyPhrases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDetectKeyPhrases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDetectKeyPhrasesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDetectKeyPhrasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDetectKeyPhrasesInputOperationOutputAlias,
                crate::output::BatchDetectKeyPhrasesOutput,
                crate::error::BatchDetectKeyPhrasesError,
                crate::input::BatchDetectKeyPhrasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TextList`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text_list(inp);
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_text_list(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDetectSentiment`.
    ///
    /// <p>Inspects a batch of documents and returns an inference of the prevailing sentiment,
    /// <code>POSITIVE</code>, <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>,
    /// in each one.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDetectSentiment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_detect_sentiment_input::Builder,
    }
    impl<C, M, R> BatchDetectSentiment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDetectSentiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDetectSentimentOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDetectSentimentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDetectSentimentInputOperationOutputAlias,
                crate::output::BatchDetectSentimentOutput,
                crate::error::BatchDetectSentimentError,
                crate::input::BatchDetectSentimentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TextList`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text_list(inp);
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_text_list(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDetectSyntax`.
    ///
    /// <p>Inspects the text of a batch of documents for the syntax and part of speech of the words
    /// in the document and returns information about them. For more information, see <a>how-syntax</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDetectSyntax<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_detect_syntax_input::Builder,
    }
    impl<C, M, R> BatchDetectSyntax<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDetectSyntax`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDetectSyntaxOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDetectSyntaxError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDetectSyntaxInputOperationOutputAlias,
                crate::output::BatchDetectSyntaxOutput,
                crate::error::BatchDetectSyntaxError,
                crate::input::BatchDetectSyntaxInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TextList`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text_list(inp);
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_text_list(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn language_code(mut self, inp: crate::model::SyntaxLanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::SyntaxLanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ClassifyDocument`.
    ///
    /// <p>Creates a new document classification request to analyze a single document in real-time,
    /// using a previously created and trained custom model and an endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct ClassifyDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::classify_document_input::Builder,
    }
    impl<C, M, R> ClassifyDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ClassifyDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ClassifyDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::ClassifyDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ClassifyDocumentInputOperationOutputAlias,
                crate::output::ClassifyDocumentOutput,
                crate::error::ClassifyDocumentError,
                crate::input::ClassifyDocumentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The document text to be analyzed.</p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>The document text to be analyzed.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ContainsPiiEntities`.
    ///
    /// <p>Analyzes input text for the presence of personally identifiable information (PII) and
    /// returns the labels of identified PII entity types such as name, address, bank account number,
    /// or phone number.</p>
    #[derive(std::fmt::Debug)]
    pub struct ContainsPiiEntities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::contains_pii_entities_input::Builder,
    }
    impl<C, M, R> ContainsPiiEntities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ContainsPiiEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ContainsPiiEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ContainsPiiEntitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ContainsPiiEntitiesInputOperationOutputAlias,
                crate::output::ContainsPiiEntitiesOutput,
                crate::error::ContainsPiiEntitiesError,
                crate::input::ContainsPiiEntitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Creates a new document classification request to analyze a single document in real-time,
        /// returning personally identifiable information (PII) entity labels.</p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>Creates a new document classification request to analyze a single document in real-time,
        /// returning personally identifiable information (PII) entity labels.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDocumentClassifier`.
    ///
    /// <p>Creates a new document classifier that you can use to categorize documents. To create a
    /// classifier, you provide a set of training documents that labeled with the categories that you
    /// want to use. After the classifier is trained you can use it to categorize a set of labeled
    /// documents into the categories. For more information, see <a>how-document-classification</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDocumentClassifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_document_classifier_input::Builder,
    }
    impl<C, M, R> CreateDocumentClassifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDocumentClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDocumentClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDocumentClassifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDocumentClassifierInputOperationOutputAlias,
                crate::output::CreateDocumentClassifierOutput,
                crate::error::CreateDocumentClassifierError,
                crate::input::CreateDocumentClassifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the document classifier.</p>
        pub fn document_classifier_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_classifier_name(inp);
            self
        }
        /// <p>The name of the document classifier.</p>
        pub fn set_document_classifier_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_classifier_name(input);
            self
        }
        /// <p>The version name given to the newly created classifier.
        /// Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed.
        /// The version name must be unique among all models with the same classifier name in the account/AWS Region.</p>
        pub fn version_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(inp);
            self
        }
        /// <p>The version name given to the newly created classifier.
        /// Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed.
        /// The version name must be unique among all models with the same classifier name in the account/AWS Region.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the document classifier being created. A tag is a key-value
        /// pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with
        /// "Sales" as the key might be added to a resource to indicate its use by the sales department.
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be associated with the document classifier being created. A tag is a key-value
        /// pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with
        /// "Sales" as the key might be added to a resource to indicate its use by the sales department.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(
            mut self,
            inp: crate::model::DocumentClassifierInputDataConfig,
        ) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierInputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Enables the addition of output results configuration parameters for custom classifier
        /// jobs.</p>
        pub fn output_data_config(
            mut self,
            inp: crate::model::DocumentClassifierOutputDataConfig,
        ) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>Enables the addition of output results configuration parameters for custom classifier
        /// jobs.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierOutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(inp);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Indicates the mode in which the classifier will be trained. The classifier can be trained
        /// in multi-class mode, which identifies one and only one class for each document, or multi-label
        /// mode, which identifies one or more labels for each document. In multi-label mode, multiple
        /// labels for an individual document are separated by a delimiter. The default delimiter between
        /// labels is a pipe (|).</p>
        pub fn mode(mut self, inp: crate::model::DocumentClassifierMode) -> Self {
            self.inner = self.inner.mode(inp);
            self
        }
        /// <p>Indicates the mode in which the classifier will be trained. The classifier can be trained
        /// in multi-class mode, which identifies one and only one class for each document, or multi-label
        /// mode, which identifies one or more labels for each document. In multi-label mode, multiple
        /// labels for an individual document are separated by a delimiter. The default delimiter between
        /// labels is a pipe (|).</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierMode>,
        ) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn model_kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_kms_key_id(inp);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_model_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEndpoint`.
    ///
    /// <p>Creates a model-specific endpoint for synchronous inference for a previously trained
    /// custom model
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_endpoint_input::Builder,
    }
    impl<C, M, R> CreateEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEndpointInputOperationOutputAlias,
                crate::output::CreateEndpointOutput,
                crate::error::CreateEndpointError,
                crate::input::CreateEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for
        /// all subsequent requests to this resource. </p>
        pub fn endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(inp);
            self
        }
        /// <p>This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for
        /// all subsequent requests to this resource. </p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint will be
        /// attached.</p>
        pub fn model_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint will be
        /// attached.</p>
        pub fn set_model_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_arn(input);
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint.
        ///
        /// Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn desired_inference_units(mut self, inp: i32) -> Self {
            self.inner = self.inner.desired_inference_units(inp);
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint.
        ///
        /// Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn set_desired_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_desired_inference_units(input);
            self
        }
        /// <p>An idempotency token provided by the customer. If this token matches a previous endpoint
        /// creation request, Amazon Comprehend will not return a <code>ResourceInUseException</code>.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>An idempotency token provided by the customer. If this token matches a previous endpoint
        /// creation request, Amazon Comprehend will not return a <code>ResourceInUseException</code>.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the endpoint being created. A tag is a key-value pair that adds
        /// metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an
        /// endpoint to indicate its use by the sales department. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags associated with the endpoint being created. A tag is a key-value pair that adds
        /// metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an
        /// endpoint to indicate its use by the sales department. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to trained custom models encrypted with a customer
        /// managed key (ModelKmsKeyId).</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to trained custom models encrypted with a customer
        /// managed key (ModelKmsKeyId).</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEntityRecognizer`.
    ///
    /// <p>Creates an entity recognizer using submitted files. After your
    /// <code>CreateEntityRecognizer</code> request is submitted, you can check job status using the
    /// API. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEntityRecognizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_entity_recognizer_input::Builder,
    }
    impl<C, M, R> CreateEntityRecognizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEntityRecognizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEntityRecognizerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEntityRecognizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEntityRecognizerInputOperationOutputAlias,
                crate::output::CreateEntityRecognizerOutput,
                crate::error::CreateEntityRecognizerError,
                crate::input::CreateEntityRecognizerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name given to the newly created recognizer. Recognizer names can be a maximum of 256
        /// characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name
        /// must be unique in the account/region.</p>
        pub fn recognizer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recognizer_name(inp);
            self
        }
        /// <p>The name given to the newly created recognizer. Recognizer names can be a maximum of 256
        /// characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name
        /// must be unique in the account/region.</p>
        pub fn set_recognizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recognizer_name(input);
            self
        }
        /// <p>The version name given to the newly created recognizer.
        /// Version names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed.
        /// The version name must be unique among all models with the same recognizer name in the account/ AWS Region.</p>
        pub fn version_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(inp);
            self
        }
        /// <p>The version name given to the newly created recognizer.
        /// Version names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed.
        /// The version name must be unique among all models with the same recognizer name in the account/ AWS Region.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the entity recognizer being created. A tag is a key-value pair
        /// that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with
        /// "Sales" as the key might be added to a resource to indicate its use by the sales department.
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be associated with the entity recognizer being created. A tag is a key-value pair
        /// that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with
        /// "Sales" as the key might be added to a resource to indicate its use by the sales department.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies the format and location of the input data. The S3 bucket containing the input
        /// data must be located in the same region as the entity recognizer being created. </p>
        pub fn input_data_config(
            mut self,
            inp: crate::model::EntityRecognizerInputDataConfig,
        ) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>Specifies the format and location of the input data. The S3 bucket containing the input
        /// data must be located in the same region as the entity recognizer being created. </p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerInputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p> A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p> A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p> You can specify any of the following languages supported by Amazon Comprehend: English
        /// ("en"), Spanish ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt").
        /// All documents must be in the same language.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p> You can specify any of the following languages supported by Amazon Comprehend: English
        /// ("en"), Spanish ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt").
        /// All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(inp);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your custom entity recognizer. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your custom entity recognizer. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn model_kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_kms_key_id(inp);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_model_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDocumentClassifier`.
    ///
    /// <p>Deletes a previously created document classifier</p>
    /// <p>Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted.
    /// If an active inference job is using the model, a <code>ResourceInUseException</code> will be
    /// returned.</p>
    /// <p>This is an asynchronous action that puts the classifier into a DELETING state, and it is
    /// then removed by a background job. Once removed, the classifier disappears from your account
    /// and is no longer available for use. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDocumentClassifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_document_classifier_input::Builder,
    }
    impl<C, M, R> DeleteDocumentClassifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDocumentClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDocumentClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDocumentClassifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDocumentClassifierInputOperationOutputAlias,
                crate::output::DeleteDocumentClassifierOutput,
                crate::error::DeleteDocumentClassifierError,
                crate::input::DeleteDocumentClassifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
        pub fn document_classifier_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_classifier_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_classifier_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpoint`.
    ///
    /// <p>Deletes a model-specific endpoint for a previously-trained custom model. All endpoints
    /// must be deleted in order for the model to be deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEndpointInputOperationOutputAlias,
                crate::output::DeleteEndpointOutput,
                crate::error::DeleteEndpointError,
                crate::input::DeleteEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being deleted.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being deleted.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEntityRecognizer`.
    ///
    /// <p>Deletes an entity recognizer.</p>
    /// <p>Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted.
    /// If an active inference job is using the model, a <code>ResourceInUseException</code> will be
    /// returned.</p>
    /// <p>This is an asynchronous action that puts the recognizer into a DELETING state, and it is
    /// then removed by a background job. Once removed, the recognizer disappears from your account
    /// and is no longer available for use. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEntityRecognizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_entity_recognizer_input::Builder,
    }
    impl<C, M, R> DeleteEntityRecognizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEntityRecognizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEntityRecognizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEntityRecognizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEntityRecognizerInputOperationOutputAlias,
                crate::output::DeleteEntityRecognizerOutput,
                crate::error::DeleteEntityRecognizerError,
                crate::input::DeleteEntityRecognizerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn entity_recognizer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_recognizer_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entity_recognizer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDocumentClassificationJob`.
    ///
    /// <p>Gets the properties associated with a document classification job. Use this operation to
    /// get the status of a classification job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDocumentClassificationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_document_classification_job_input::Builder,
    }
    impl<C, M, R> DescribeDocumentClassificationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDocumentClassificationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDocumentClassificationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDocumentClassificationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDocumentClassificationJobInputOperationOutputAlias,
                crate::output::DescribeDocumentClassificationJobOutput,
                crate::error::DescribeDocumentClassificationJobError,
                crate::input::DescribeDocumentClassificationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDocumentClassifier`.
    ///
    /// <p>Gets the properties associated with a document classifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDocumentClassifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_document_classifier_input::Builder,
    }
    impl<C, M, R> DescribeDocumentClassifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDocumentClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDocumentClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDocumentClassifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDocumentClassifierInputOperationOutputAlias,
                crate::output::DescribeDocumentClassifierOutput,
                crate::error::DescribeDocumentClassifierError,
                crate::input::DescribeDocumentClassifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. The  operation returns this identifier in its
        /// response.</p>
        pub fn document_classifier_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_classifier_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_classifier_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDominantLanguageDetectionJob`.
    ///
    /// <p>Gets the properties associated with a dominant language detection job. Use this operation
    /// to get the status of a detection job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDominantLanguageDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dominant_language_detection_job_input::Builder,
    }
    impl<C, M, R> DescribeDominantLanguageDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDominantLanguageDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDominantLanguageDetectionJobOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDominantLanguageDetectionJobError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDominantLanguageDetectionJobInputOperationOutputAlias,
                crate::output::DescribeDominantLanguageDetectionJobOutput,
                crate::error::DescribeDominantLanguageDetectionJobError,
                crate::input::DescribeDominantLanguageDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpoint`.
    ///
    /// <p>Gets the properties associated with a specific endpoint. Use this operation to get the
    /// status of an endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoint_input::Builder,
    }
    impl<C, M, R> DescribeEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointInputOperationOutputAlias,
                crate::output::DescribeEndpointOutput,
                crate::error::DescribeEndpointError,
                crate::input::DescribeEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being described.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being described.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEntitiesDetectionJob`.
    ///
    /// <p>Gets the properties associated with an entities detection job. Use this operation to get
    /// the status of a detection job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEntitiesDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_entities_detection_job_input::Builder,
    }
    impl<C, M, R> DescribeEntitiesDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEntitiesDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEntitiesDetectionJobInputOperationOutputAlias,
                crate::output::DescribeEntitiesDetectionJobOutput,
                crate::error::DescribeEntitiesDetectionJobError,
                crate::input::DescribeEntitiesDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEntityRecognizer`.
    ///
    /// <p>Provides details about an entity recognizer including status, S3 buckets containing
    /// training data, recognizer metadata, metrics, and so on.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEntityRecognizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_entity_recognizer_input::Builder,
    }
    impl<C, M, R> DescribeEntityRecognizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEntityRecognizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEntityRecognizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEntityRecognizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEntityRecognizerInputOperationOutputAlias,
                crate::output::DescribeEntityRecognizerOutput,
                crate::error::DescribeEntityRecognizerError,
                crate::input::DescribeEntityRecognizerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn entity_recognizer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_recognizer_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entity_recognizer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventsDetectionJob`.
    ///
    /// <p>Gets the status and details of an events detection job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventsDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_events_detection_job_input::Builder,
    }
    impl<C, M, R> DescribeEventsDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventsDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventsDetectionJobInputOperationOutputAlias,
                crate::output::DescribeEventsDetectionJobOutput,
                crate::error::DescribeEventsDetectionJobError,
                crate::input::DescribeEventsDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the events detection job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier of the events detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeKeyPhrasesDetectionJob`.
    ///
    /// <p>Gets the properties associated with a key phrases detection job. Use this operation to get
    /// the status of a detection job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeKeyPhrasesDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_key_phrases_detection_job_input::Builder,
    }
    impl<C, M, R> DescribeKeyPhrasesDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeKeyPhrasesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeKeyPhrasesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeKeyPhrasesDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeKeyPhrasesDetectionJobInputOperationOutputAlias,
                crate::output::DescribeKeyPhrasesDetectionJobOutput,
                crate::error::DescribeKeyPhrasesDetectionJobError,
                crate::input::DescribeKeyPhrasesDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePiiEntitiesDetectionJob`.
    ///
    /// <p>Gets the properties associated with a PII entities detection job. For example, you can use
    /// this operation to get the job status.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePiiEntitiesDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pii_entities_detection_job_input::Builder,
    }
    impl<C, M, R> DescribePiiEntitiesDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePiiEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePiiEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePiiEntitiesDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePiiEntitiesDetectionJobInputOperationOutputAlias,
                crate::output::DescribePiiEntitiesDetectionJobOutput,
                crate::error::DescribePiiEntitiesDetectionJobError,
                crate::input::DescribePiiEntitiesDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSentimentDetectionJob`.
    ///
    /// <p>Gets the properties associated with a sentiment detection job. Use this operation to get
    /// the status of a detection job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSentimentDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_sentiment_detection_job_input::Builder,
    }
    impl<C, M, R> DescribeSentimentDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSentimentDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSentimentDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSentimentDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSentimentDetectionJobInputOperationOutputAlias,
                crate::output::DescribeSentimentDetectionJobOutput,
                crate::error::DescribeSentimentDetectionJobError,
                crate::input::DescribeSentimentDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTopicsDetectionJob`.
    ///
    /// <p>Gets the properties associated with a topic detection job. Use this operation to get
    /// the status of a detection job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTopicsDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_topics_detection_job_input::Builder,
    }
    impl<C, M, R> DescribeTopicsDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTopicsDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTopicsDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTopicsDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTopicsDetectionJobInputOperationOutputAlias,
                crate::output::DescribeTopicsDetectionJobOutput,
                crate::error::DescribeTopicsDetectionJobError,
                crate::input::DescribeTopicsDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier assigned by the user to the detection job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier assigned by the user to the detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectDominantLanguage`.
    ///
    /// <p>Determines the dominant language of the input text. For a list of languages that Amazon
    /// Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported Languages</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct DetectDominantLanguage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_dominant_language_input::Builder,
    }
    impl<C, M, R> DetectDominantLanguage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectDominantLanguage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectDominantLanguageOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectDominantLanguageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectDominantLanguageInputOperationOutputAlias,
                crate::output::DetectDominantLanguageOutput,
                crate::error::DetectDominantLanguageError,
                crate::input::DetectDominantLanguageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 text string. Each string should contain at least 20 characters and must contain
        /// fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>A UTF-8 text string. Each string should contain at least 20 characters and must contain
        /// fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectEntities`.
    ///
    /// <p>Inspects text for named entities, and returns information about them. For more
    /// information, about named entities, see <a>how-entities</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct DetectEntities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_entities_input::Builder,
    }
    impl<C, M, R> DetectEntities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectEntitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectEntitiesInputOperationOutputAlias,
                crate::output::DetectEntitiesOutput,
                crate::error::DetectEntitiesError,
                crate::input::DetectEntitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        /// <p>If your request includes the endpoint for a custom entity recognition model, Amazon
        /// Comprehend uses the language of your custom model, and it ignores any language code that you
        /// specify here.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        /// <p>If your request includes the endpoint for a custom entity recognition model, Amazon
        /// Comprehend uses the language of your custom model, and it ignores any language code that you
        /// specify here.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>The Amazon Resource Name of an endpoint that is associated with a custom entity
        /// recognition model. Provide an endpoint if you want to detect entities by using your own custom
        /// model instead of the default model that is used by Amazon Comprehend.</p>
        /// <p>If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and
        /// it ignores any language code that you provide in your request.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name of an endpoint that is associated with a custom entity
        /// recognition model. Provide an endpoint if you want to detect entities by using your own custom
        /// model instead of the default model that is used by Amazon Comprehend.</p>
        /// <p>If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and
        /// it ignores any language code that you provide in your request.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectKeyPhrases`.
    ///
    /// <p>Detects the key noun phrases found in the text. </p>
    #[derive(std::fmt::Debug)]
    pub struct DetectKeyPhrases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_key_phrases_input::Builder,
    }
    impl<C, M, R> DetectKeyPhrases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectKeyPhrases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectKeyPhrasesOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectKeyPhrasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectKeyPhrasesInputOperationOutputAlias,
                crate::output::DetectKeyPhrasesOutput,
                crate::error::DetectKeyPhrasesError,
                crate::input::DetectKeyPhrasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectPiiEntities`.
    ///
    /// <p>Inspects the input text for entities that contain personally identifiable information
    /// (PII) and returns information about them.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetectPiiEntities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_pii_entities_input::Builder,
    }
    impl<C, M, R> DetectPiiEntities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectPiiEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectPiiEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectPiiEntitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectPiiEntitiesInputOperationOutputAlias,
                crate::output::DetectPiiEntitiesOutput,
                crate::error::DetectPiiEntitiesError,
                crate::input::DetectPiiEntitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectSentiment`.
    ///
    /// <p>Inspects text and returns an inference of the prevailing sentiment
    /// (<code>POSITIVE</code>, <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>). </p>
    #[derive(std::fmt::Debug)]
    pub struct DetectSentiment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_sentiment_input::Builder,
    }
    impl<C, M, R> DetectSentiment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectSentiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectSentimentOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectSentimentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectSentimentInputOperationOutputAlias,
                crate::output::DetectSentimentOutput,
                crate::error::DetectSentimentError,
                crate::input::DetectSentimentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectSyntax`.
    ///
    /// <p>Inspects text for syntax and the part of speech of words in the document. For more
    /// information, <a>how-syntax</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetectSyntax<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_syntax_input::Builder,
    }
    impl<C, M, R> DetectSyntax<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectSyntax`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectSyntaxOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectSyntaxError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectSyntaxInputOperationOutputAlias,
                crate::output::DetectSyntaxOutput,
                crate::error::DetectSyntaxError,
                crate::input::DetectSyntaxInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF encoded
        /// characters.</p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF encoded
        /// characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The language code of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt").</p>
        pub fn language_code(mut self, inp: crate::model::SyntaxLanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language code of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt").</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::SyntaxLanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocumentClassificationJobs`.
    ///
    /// <p>Gets a list of the documentation classification jobs that you have submitted.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDocumentClassificationJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_document_classification_jobs_input::Builder,
    }
    impl<C, M, R> ListDocumentClassificationJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDocumentClassificationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentClassificationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentClassificationJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDocumentClassificationJobsInputOperationOutputAlias,
                crate::output::ListDocumentClassificationJobsOutput,
                crate::error::ListDocumentClassificationJobsError,
                crate::input::ListDocumentClassificationJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their names, status, or the
        /// date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, inp: crate::model::DocumentClassificationJobFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their names, status, or the
        /// date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DocumentClassificationJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocumentClassifiers`.
    ///
    /// <p>Gets a list of the document classifiers that you have created.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDocumentClassifiers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_document_classifiers_input::Builder,
    }
    impl<C, M, R> ListDocumentClassifiers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDocumentClassifiers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentClassifiersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentClassifiersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDocumentClassifiersInputOperationOutputAlias,
                crate::output::ListDocumentClassifiersOutput,
                crate::error::ListDocumentClassifiersError,
                crate::input::ListDocumentClassifiersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, inp: crate::model::DocumentClassifierFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocumentClassifierSummaries`.
    ///
    /// <p>Gets a list of summaries of the document classifiers that you have created</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDocumentClassifierSummaries<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_document_classifier_summaries_input::Builder,
    }
    impl<C, M, R> ListDocumentClassifierSummaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDocumentClassifierSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentClassifierSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentClassifierSummariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDocumentClassifierSummariesInputOperationOutputAlias,
                crate::output::ListDocumentClassifierSummariesOutput,
                crate::error::ListDocumentClassifierSummariesError,
                crate::input::ListDocumentClassifierSummariesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDominantLanguageDetectionJobs`.
    ///
    /// <p>Gets a list of the dominant language detection jobs that you have submitted.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDominantLanguageDetectionJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dominant_language_detection_jobs_input::Builder,
    }
    impl<C, M, R> ListDominantLanguageDetectionJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDominantLanguageDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDominantLanguageDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDominantLanguageDetectionJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDominantLanguageDetectionJobsInputOperationOutputAlias,
                crate::output::ListDominantLanguageDetectionJobsOutput,
                crate::error::ListDominantLanguageDetectionJobsError,
                crate::input::ListDominantLanguageDetectionJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters that jobs that are returned. You can filter jobs on their name, status, or the
        /// date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, inp: crate::model::DominantLanguageDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters that jobs that are returned. You can filter jobs on their name, status, or the
        /// date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DominantLanguageDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEndpoints`.
    ///
    /// <p>Gets a list of all existing endpoints that you've created.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_endpoints_input::Builder,
    }
    impl<C, M, R> ListEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEndpointsInputOperationOutputAlias,
                crate::output::ListEndpointsOutput,
                crate::error::ListEndpointsError,
                crate::input::ListEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the endpoints that are returned. You can filter endpoints on their name, model,
        /// status, or the date and time that they were created. You can only set one filter at a time.
        /// </p>
        pub fn filter(mut self, inp: crate::model::EndpointFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters the endpoints that are returned. You can filter endpoints on their name, model,
        /// status, or the date and time that they were created. You can only set one filter at a time.
        /// </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EndpointFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntitiesDetectionJobs`.
    ///
    /// <p>Gets a list of the entity detection jobs that you have submitted.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEntitiesDetectionJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_entities_detection_jobs_input::Builder,
    }
    impl<C, M, R> ListEntitiesDetectionJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEntitiesDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntitiesDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntitiesDetectionJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEntitiesDetectionJobsInputOperationOutputAlias,
                crate::output::ListEntitiesDetectionJobsOutput,
                crate::error::ListEntitiesDetectionJobsError,
                crate::input::ListEntitiesDetectionJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, inp: crate::model::EntitiesDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EntitiesDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntityRecognizers`.
    ///
    /// <p>Gets a list of the properties of all entity recognizers that you created, including
    /// recognizers currently in training. Allows you to filter the list of recognizers based on
    /// criteria such as status and submission time. This call returns up to 500 entity recognizers in
    /// the list, with a default number of 100 recognizers in the list.</p>
    /// <p>The results of this list are not in any particular order. Please get the list and sort
    /// locally if needed.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEntityRecognizers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_entity_recognizers_input::Builder,
    }
    impl<C, M, R> ListEntityRecognizers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEntityRecognizers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntityRecognizersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntityRecognizersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEntityRecognizersInputOperationOutputAlias,
                crate::output::ListEntityRecognizersOutput,
                crate::error::ListEntityRecognizersError,
                crate::input::ListEntityRecognizersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the list of entities returned. You can filter on <code>Status</code>,
        /// <code>SubmitTimeBefore</code>, or <code>SubmitTimeAfter</code>. You can only set one filter
        /// at a time.</p>
        pub fn filter(mut self, inp: crate::model::EntityRecognizerFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters the list of entities returned. You can filter on <code>Status</code>,
        /// <code>SubmitTimeBefore</code>, or <code>SubmitTimeAfter</code>. You can only set one filter
        /// at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of results to return on each page. The default is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of results to return on each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntityRecognizerSummaries`.
    ///
    /// <p>Gets a list of summaries for the entity recognizers that you have created.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEntityRecognizerSummaries<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_entity_recognizer_summaries_input::Builder,
    }
    impl<C, M, R> ListEntityRecognizerSummaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEntityRecognizerSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntityRecognizerSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntityRecognizerSummariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEntityRecognizerSummariesInputOperationOutputAlias,
                crate::output::ListEntityRecognizerSummariesOutput,
                crate::error::ListEntityRecognizerSummariesError,
                crate::input::ListEntityRecognizerSummariesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventsDetectionJobs`.
    ///
    /// <p>Gets a list of the events detection jobs that you have submitted.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEventsDetectionJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_events_detection_jobs_input::Builder,
    }
    impl<C, M, R> ListEventsDetectionJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEventsDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventsDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventsDetectionJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEventsDetectionJobsInputOperationOutputAlias,
                crate::output::ListEventsDetectionJobsOutput,
                crate::error::ListEventsDetectionJobsError,
                crate::input::ListEventsDetectionJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, inp: crate::model::EventsDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EventsDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListKeyPhrasesDetectionJobs`.
    ///
    /// <p>Get a list of key phrase detection jobs that you have submitted.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListKeyPhrasesDetectionJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_key_phrases_detection_jobs_input::Builder,
    }
    impl<C, M, R> ListKeyPhrasesDetectionJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListKeyPhrasesDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListKeyPhrasesDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListKeyPhrasesDetectionJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListKeyPhrasesDetectionJobsInputOperationOutputAlias,
                crate::output::ListKeyPhrasesDetectionJobsOutput,
                crate::error::ListKeyPhrasesDetectionJobsError,
                crate::input::ListKeyPhrasesDetectionJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, inp: crate::model::KeyPhrasesDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::KeyPhrasesDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPiiEntitiesDetectionJobs`.
    ///
    /// <p>Gets a list of the PII entity detection jobs that you have submitted.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPiiEntitiesDetectionJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_pii_entities_detection_jobs_input::Builder,
    }
    impl<C, M, R> ListPiiEntitiesDetectionJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPiiEntitiesDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPiiEntitiesDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPiiEntitiesDetectionJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPiiEntitiesDetectionJobsInputOperationOutputAlias,
                crate::output::ListPiiEntitiesDetectionJobsOutput,
                crate::error::ListPiiEntitiesDetectionJobsError,
                crate::input::ListPiiEntitiesDetectionJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, inp: crate::model::PiiEntitiesDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::PiiEntitiesDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSentimentDetectionJobs`.
    ///
    /// <p>Gets a list of sentiment detection jobs that you have submitted.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSentimentDetectionJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_sentiment_detection_jobs_input::Builder,
    }
    impl<C, M, R> ListSentimentDetectionJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSentimentDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSentimentDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSentimentDetectionJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSentimentDetectionJobsInputOperationOutputAlias,
                crate::output::ListSentimentDetectionJobsOutput,
                crate::error::ListSentimentDetectionJobsError,
                crate::input::ListSentimentDetectionJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, inp: crate::model::SentimentDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::SentimentDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags associated with a given Amazon Comprehend resource. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you are querying.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you are querying.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTopicsDetectionJobs`.
    ///
    /// <p>Gets a list of the topic detection jobs that you have submitted.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTopicsDetectionJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_topics_detection_jobs_input::Builder,
    }
    impl<C, M, R> ListTopicsDetectionJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTopicsDetectionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTopicsDetectionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTopicsDetectionJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTopicsDetectionJobsInputOperationOutputAlias,
                crate::output::ListTopicsDetectionJobsOutput,
                crate::error::ListTopicsDetectionJobsError,
                crate::input::ListTopicsDetectionJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the jobs that are returned. Jobs can be filtered on their name, status, or the
        /// date and time that they were submitted. You can set only one filter at a time.</p>
        pub fn filter(mut self, inp: crate::model::TopicsDetectionJobFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Filters the jobs that are returned. Jobs can be filtered on their name, status, or the
        /// date and time that they were submitted. You can set only one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::TopicsDetectionJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDocumentClassificationJob`.
    ///
    /// <p>Starts an asynchronous document classification job. Use the  operation to track the progress of the
    /// job.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartDocumentClassificationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_document_classification_job_input::Builder,
    }
    impl<C, M, R> StartDocumentClassificationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDocumentClassificationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDocumentClassificationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDocumentClassificationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDocumentClassificationJobInputOperationOutputAlias,
                crate::output::StartDocumentClassificationJobOutput,
                crate::error::StartDocumentClassificationJobError,
                crate::input::StartDocumentClassificationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the document classifier to use to process the
        /// job.</p>
        pub fn document_classifier_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_classifier_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the document classifier to use to process the
        /// job.</p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_classifier_arn(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(inp);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your document classification job. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your document classification job. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the document classification job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be associated with the document classification job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDominantLanguageDetectionJob`.
    ///
    /// <p>Starts an asynchronous dominant language detection job for a collection of documents. Use
    /// the  operation to track the status
    /// of a job.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartDominantLanguageDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_dominant_language_detection_job_input::Builder,
    }
    impl<C, M, R> StartDominantLanguageDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDominantLanguageDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDominantLanguageDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDominantLanguageDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDominantLanguageDetectionJobInputOperationOutputAlias,
                crate::output::StartDominantLanguageDetectionJobOutput,
                crate::error::StartDominantLanguageDetectionJobError,
                crate::input::StartDominantLanguageDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>An identifier for the job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>An identifier for the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(inp);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your dominant language detection job. For more information,
        /// see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your dominant language detection job. For more information,
        /// see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the dominant language detection job. A tag is a key-value pair
        /// that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as
        /// the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be associated with the dominant language detection job. A tag is a key-value pair
        /// that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as
        /// the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartEntitiesDetectionJob`.
    ///
    /// <p>Starts an asynchronous entity detection job for a collection of documents. Use the  operation to track the status of a job.</p>
    /// <p>This API can be used for either standard entity detection or custom entity recognition. In
    /// order to be used for custom entity recognition, the optional <code>EntityRecognizerArn</code>
    /// must be used in order to provide access to the recognizer being used to detect the custom
    /// entity.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartEntitiesDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_entities_detection_job_input::Builder,
    }
    impl<C, M, R> StartEntitiesDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartEntitiesDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartEntitiesDetectionJobInputOperationOutputAlias,
                crate::output::StartEntitiesDetectionJobOutput,
                crate::error::StartEntitiesDetectionJobError,
                crate::input::StartEntitiesDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the specific entity recognizer to be used
        /// by the <code>StartEntitiesDetectionJob</code>. This ARN is optional and is only used for a
        /// custom entity recognition job.</p>
        pub fn entity_recognizer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_recognizer_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the specific entity recognizer to be used
        /// by the <code>StartEntitiesDetectionJob</code>. This ARN is optional and is only used for a
        /// custom entity recognition job.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entity_recognizer_arn(input);
            self
        }
        /// <p>The language of the input documents. All documents must be in the same language. You can
        /// specify any of the languages supported by Amazon Comprehend. If custom entities recognition is
        /// used, this parameter is ignored and the language used for training the model is used
        /// instead.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents. All documents must be in the same language. You can
        /// specify any of the languages supported by Amazon Comprehend. If custom entities recognition is
        /// used, this parameter is ignored and the language used for training the model is used
        /// instead.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(inp);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the entities detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be associated with the entities detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartEventsDetectionJob`.
    ///
    /// <p>Starts an asynchronous event detection job for a collection of documents.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartEventsDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_events_detection_job_input::Builder,
    }
    impl<C, M, R> StartEventsDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartEventsDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartEventsDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartEventsDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartEventsDetectionJobInputOperationOutputAlias,
                crate::output::StartEventsDetectionJobOutput,
                crate::error::StartEventsDetectionJobError,
                crate::input::StartEventsDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the events detection job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The identifier of the events detection job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>An unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>An unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `TargetEventTypes`.
        ///
        /// To override the contents of this collection use [`set_target_event_types`](Self::set_target_event_types).
        ///
        /// <p>The types of events to detect in the input documents.</p>
        pub fn target_event_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_event_types(inp);
            self
        }
        /// <p>The types of events to detect in the input documents.</p>
        pub fn set_target_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_event_types(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the events detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be associated with the events detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartKeyPhrasesDetectionJob`.
    ///
    /// <p>Starts an asynchronous key phrase detection job for a collection of documents. Use the
    /// operation to track the status of a
    /// job.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartKeyPhrasesDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_key_phrases_detection_job_input::Builder,
    }
    impl<C, M, R> StartKeyPhrasesDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartKeyPhrasesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartKeyPhrasesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartKeyPhrasesDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartKeyPhrasesDetectionJobInputOperationOutputAlias,
                crate::output::StartKeyPhrasesDetectionJobOutput,
                crate::error::StartKeyPhrasesDetectionJobError,
                crate::input::StartKeyPhrasesDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(inp);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p> Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your key phrases detection job. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p> Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your key phrases detection job. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the key phrases detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be associated with the key phrases detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartPiiEntitiesDetectionJob`.
    ///
    /// <p>Starts an asynchronous PII entity detection job for a collection of documents.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartPiiEntitiesDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_pii_entities_detection_job_input::Builder,
    }
    impl<C, M, R> StartPiiEntitiesDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartPiiEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartPiiEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartPiiEntitiesDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartPiiEntitiesDetectionJobInputOperationOutputAlias,
                crate::output::StartPiiEntitiesDetectionJobOutput,
                crate::error::StartPiiEntitiesDetectionJobError,
                crate::input::StartPiiEntitiesDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input properties for a PII entities detection job.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>The input properties for a PII entities detection job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Provides conﬁguration parameters for the output of PII entity detection jobs.</p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>Provides conﬁguration parameters for the output of PII entity detection jobs.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in
        /// which PII entities are redacted.</p>
        pub fn mode(mut self, inp: crate::model::PiiEntitiesDetectionMode) -> Self {
            self.inner = self.inner.mode(inp);
            self
        }
        /// <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in
        /// which PII entities are redacted.</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::PiiEntitiesDetectionMode>,
        ) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>Provides configuration parameters for PII entity redaction.</p>
        /// <p>This parameter is required if you set the <code>Mode</code> parameter to
        /// <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code>
        /// definition that includes the <code>PiiEntityTypes</code> parameter.</p>
        pub fn redaction_config(mut self, inp: crate::model::RedactionConfig) -> Self {
            self.inner = self.inner.redaction_config(inp);
            self
        }
        /// <p>Provides configuration parameters for PII entity redaction.</p>
        /// <p>This parameter is required if you set the <code>Mode</code> parameter to
        /// <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code>
        /// definition that includes the <code>PiiEntityTypes</code> parameter.</p>
        pub fn set_redaction_config(
            mut self,
            input: std::option::Option<crate::model::RedactionConfig>,
        ) -> Self {
            self.inner = self.inner.set_redaction_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the PII entities detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be associated with the PII entities detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSentimentDetectionJob`.
    ///
    /// <p>Starts an asynchronous sentiment detection job for a collection of documents. use the
    /// operation to track the status of a
    /// job.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartSentimentDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_sentiment_detection_job_input::Builder,
    }
    impl<C, M, R> StartSentimentDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSentimentDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSentimentDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSentimentDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSentimentDetectionJobInputOperationOutputAlias,
                crate::output::StartSentimentDetectionJobOutput,
                crate::error::StartSentimentDetectionJobError,
                crate::input::StartSentimentDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files. </p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>Specifies where to send the output files. </p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, inp: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(inp);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the sentiment detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be associated with the sentiment detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTopicsDetectionJob`.
    ///
    /// <p>Starts an asynchronous topic detection job. Use the
    /// <code>DescribeTopicDetectionJob</code> operation to track the status of a job.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartTopicsDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_topics_detection_job_input::Builder,
    }
    impl<C, M, R> StartTopicsDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartTopicsDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTopicsDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTopicsDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartTopicsDetectionJobInputOperationOutputAlias,
                crate::output::StartTopicsDetectionJobOutput,
                crate::error::StartTopicsDetectionJobError,
                crate::input::StartTopicsDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies where to send the output files. The output is a compressed archive with two
        /// files, <code>topic-terms.csv</code> that lists the terms associated with each topic, and
        /// <code>doc-topics.csv</code> that lists the documents associated with each topic</p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>Specifies where to send the output files. The output is a compressed archive with two
        /// files, <code>topic-terms.csv</code> that lists the terms associated with each topic, and
        /// <code>doc-topics.csv</code> that lists the documents associated with each topic</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role
        /// that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role
        /// that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The number of topics to detect.</p>
        pub fn number_of_topics(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_topics(inp);
            self
        }
        /// <p>The number of topics to detect.</p>
        pub fn set_number_of_topics(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_topics(input);
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_kms_key_id(inp);
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_volume_kms_key_id(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the topics detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be associated with the topics detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDominantLanguageDetectionJob`.
    ///
    /// <p>Stops a dominant language detection job in progress.</p>
    /// <p>If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put
    /// into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it
    /// is put into the <code>COMPLETED</code> state; otherwise the job is stopped and put into the
    /// <code>STOPPED</code> state.</p>
    /// <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
    /// <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400
    /// Internal Request Exception. </p>
    /// <p>When a job is stopped, any documents already processed are written to the output
    /// location.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopDominantLanguageDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_dominant_language_detection_job_input::Builder,
    }
    impl<C, M, R> StopDominantLanguageDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopDominantLanguageDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDominantLanguageDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDominantLanguageDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopDominantLanguageDetectionJobInputOperationOutputAlias,
                crate::output::StopDominantLanguageDetectionJobOutput,
                crate::error::StopDominantLanguageDetectionJobError,
                crate::input::StopDominantLanguageDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the dominant language detection job to stop.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier of the dominant language detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopEntitiesDetectionJob`.
    ///
    /// <p>Stops an entities detection job in progress.</p>
    /// <p>If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put
    /// into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it
    /// is put into the <code>COMPLETED</code> state; otherwise the job is stopped and put into the
    /// <code>STOPPED</code> state.</p>
    /// <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
    /// <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400
    /// Internal Request Exception. </p>
    /// <p>When a job is stopped, any documents already processed are written to the output
    /// location.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopEntitiesDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_entities_detection_job_input::Builder,
    }
    impl<C, M, R> StopEntitiesDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopEntitiesDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopEntitiesDetectionJobInputOperationOutputAlias,
                crate::output::StopEntitiesDetectionJobOutput,
                crate::error::StopEntitiesDetectionJobError,
                crate::input::StopEntitiesDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the entities detection job to stop.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier of the entities detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopEventsDetectionJob`.
    ///
    /// <p>Stops an events detection job in progress.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopEventsDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_events_detection_job_input::Builder,
    }
    impl<C, M, R> StopEventsDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopEventsDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopEventsDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopEventsDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopEventsDetectionJobInputOperationOutputAlias,
                crate::output::StopEventsDetectionJobOutput,
                crate::error::StopEventsDetectionJobError,
                crate::input::StopEventsDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the events detection job to stop.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier of the events detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopKeyPhrasesDetectionJob`.
    ///
    /// <p>Stops a key phrases detection job in progress.</p>
    /// <p>If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put
    /// into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it
    /// is put into the <code>COMPLETED</code> state; otherwise the job is stopped and put into the
    /// <code>STOPPED</code> state.</p>
    /// <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
    /// <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400
    /// Internal Request Exception. </p>
    /// <p>When a job is stopped, any documents already processed are written to the output
    /// location.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopKeyPhrasesDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_key_phrases_detection_job_input::Builder,
    }
    impl<C, M, R> StopKeyPhrasesDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopKeyPhrasesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopKeyPhrasesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopKeyPhrasesDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopKeyPhrasesDetectionJobInputOperationOutputAlias,
                crate::output::StopKeyPhrasesDetectionJobOutput,
                crate::error::StopKeyPhrasesDetectionJobError,
                crate::input::StopKeyPhrasesDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the key phrases detection job to stop.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier of the key phrases detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopPiiEntitiesDetectionJob`.
    ///
    /// <p>Stops a PII entities detection job in progress.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopPiiEntitiesDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_pii_entities_detection_job_input::Builder,
    }
    impl<C, M, R> StopPiiEntitiesDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopPiiEntitiesDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopPiiEntitiesDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopPiiEntitiesDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopPiiEntitiesDetectionJobInputOperationOutputAlias,
                crate::output::StopPiiEntitiesDetectionJobOutput,
                crate::error::StopPiiEntitiesDetectionJobError,
                crate::input::StopPiiEntitiesDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the PII entities detection job to stop.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier of the PII entities detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopSentimentDetectionJob`.
    ///
    /// <p>Stops a sentiment detection job in progress.</p>
    /// <p>If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put
    /// into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it
    /// is put into the <code>COMPLETED</code> state; otherwise the job is be stopped and put into the
    /// <code>STOPPED</code> state.</p>
    /// <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
    /// <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400
    /// Internal Request Exception. </p>
    /// <p>When a job is stopped, any documents already processed are written to the output
    /// location.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopSentimentDetectionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_sentiment_detection_job_input::Builder,
    }
    impl<C, M, R> StopSentimentDetectionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopSentimentDetectionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopSentimentDetectionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopSentimentDetectionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopSentimentDetectionJobInputOperationOutputAlias,
                crate::output::StopSentimentDetectionJobOutput,
                crate::error::StopSentimentDetectionJobError,
                crate::input::StopSentimentDetectionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the sentiment detection job to stop.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier of the sentiment detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopTrainingDocumentClassifier`.
    ///
    /// <p>Stops a document classifier training job while in progress.</p>
    /// <p>If the training job state is <code>TRAINING</code>, the job is marked for termination and
    /// put into the <code>STOP_REQUESTED</code> state. If the training job completes before it can be
    /// stopped, it is put into the <code>TRAINED</code>; otherwise the training job is stopped and
    /// put into the <code>STOPPED</code> state and the service sends back an HTTP 200 response with
    /// an empty HTTP body. </p>
    #[derive(std::fmt::Debug)]
    pub struct StopTrainingDocumentClassifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_training_document_classifier_input::Builder,
    }
    impl<C, M, R> StopTrainingDocumentClassifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopTrainingDocumentClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopTrainingDocumentClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::StopTrainingDocumentClassifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopTrainingDocumentClassifierInputOperationOutputAlias,
                crate::output::StopTrainingDocumentClassifierOutput,
                crate::error::StopTrainingDocumentClassifierError,
                crate::input::StopTrainingDocumentClassifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier currently being
        /// trained.</p>
        pub fn document_classifier_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_classifier_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier currently being
        /// trained.</p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_classifier_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopTrainingEntityRecognizer`.
    ///
    /// <p>Stops an entity recognizer training job while in progress.</p>
    /// <p>If the training job state is <code>TRAINING</code>, the job is marked for termination and
    /// put into the <code>STOP_REQUESTED</code> state. If the training job completes before it can be
    /// stopped, it is put into the <code>TRAINED</code>; otherwise the training job is stopped and
    /// putted into the <code>STOPPED</code> state and the service sends back an HTTP 200 response
    /// with an empty HTTP body.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopTrainingEntityRecognizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_training_entity_recognizer_input::Builder,
    }
    impl<C, M, R> StopTrainingEntityRecognizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopTrainingEntityRecognizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopTrainingEntityRecognizerOutput,
            aws_smithy_http::result::SdkError<crate::error::StopTrainingEntityRecognizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopTrainingEntityRecognizerInputOperationOutputAlias,
                crate::output::StopTrainingEntityRecognizerOutput,
                crate::error::StopTrainingEntityRecognizerError,
                crate::input::StopTrainingEntityRecognizerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer currently being
        /// trained.</p>
        pub fn entity_recognizer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_recognizer_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer currently being
        /// trained.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entity_recognizer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair
    /// that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with
    /// "Sales" as the key might be added to a resource to indicate its use by the sales department.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource to which you want
        /// to associate the tags. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource to which you want
        /// to associate the tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags being associated with a specific Amazon Comprehend resource. There can be a maximum
        /// of 50 tags (both existing and pending) associated with a specific resource. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags being associated with a specific Amazon Comprehend resource. There can be a maximum
        /// of 50 tags (both existing and pending) associated with a specific resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a specific tag associated with an Amazon Comprehend resource. </p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the given Amazon Comprehend resource from which you
        /// want to remove the tags. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the given Amazon Comprehend resource from which you
        /// want to remove the tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The initial part of a key-value pair that forms a tag being removed from a given resource.
        /// For example, a tag with "Sales" as the key might be added to a resource to indicate its use by
        /// the sales department. Keys must be unique and cannot be duplicated for a particular resource.
        /// </p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The initial part of a key-value pair that forms a tag being removed from a given resource.
        /// For example, a tag with "Sales" as the key might be added to a resource to indicate its use by
        /// the sales department. Keys must be unique and cannot be duplicated for a particular resource.
        /// </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEndpoint`.
    ///
    /// <p>Updates information about the specified endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_endpoint_input::Builder,
    }
    impl<C, M, R> UpdateEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEndpointInputOperationOutputAlias,
                crate::output::UpdateEndpointOutput,
                crate::error::UpdateEndpointError,
                crate::input::UpdateEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being updated.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being updated.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
        /// <p>The ARN of the new model to use when updating an existing endpoint.</p>
        pub fn desired_model_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.desired_model_arn(inp);
            self
        }
        /// <p>The ARN of the new model to use when updating an existing endpoint.</p>
        pub fn set_desired_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_desired_model_arn(input);
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint.
        ///
        /// Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn desired_inference_units(mut self, inp: i32) -> Self {
            self.inner = self.inner.desired_inference_units(inp);
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint.
        ///
        /// Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn set_desired_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_desired_inference_units(input);
            self
        }
        /// <p>Data access role ARN to use in case the new model is encrypted with a customer CMK.</p>
        pub fn desired_data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.desired_data_access_role_arn(inp);
            self
        }
        /// <p>Data access role ARN to use in case the new model is encrypted with a customer CMK.</p>
        pub fn set_desired_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_desired_data_access_role_arn(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
