// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The number of documents in the request exceeds the limit of 25. Try your request again with fewer documents.</p>
    BatchSizeLimitExceededException(crate::error::BatchSizeLimitExceededException),
    /// <p>Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The specified resource name is already in use. Use a different name and try your request again.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The maximum number of resources per account has been exceeded. Review the resources, and then try your request again.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available. Check the resource and try your request again.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tag keys than can be associated with a resource (50 tag keys per resource).</p>
    TooManyTagKeysException(crate::error::TooManyTagKeysException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::BatchSizeLimitExceededException(inner) => inner.fmt(f),
            Error::ConcurrentModificationException(inner) => inner.fmt(f),
            Error::InternalServerException(inner) => inner.fmt(f),
            Error::InvalidFilterException(inner) => inner.fmt(f),
            Error::InvalidRequestException(inner) => inner.fmt(f),
            Error::JobNotFoundException(inner) => inner.fmt(f),
            Error::KmsKeyValidationException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::ResourceLimitExceededException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ResourceUnavailableException(inner) => inner.fmt(f),
            Error::TextSizeLimitExceededException(inner) => inner.fmt(f),
            Error::TooManyRequestsException(inner) => inner.fmt(f),
            Error::TooManyTagKeysException(inner) => inner.fmt(f),
            Error::TooManyTagsException(inner) => inner.fmt(f),
            Error::UnsupportedLanguageException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDetectDominantLanguageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDetectDominantLanguageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchDetectDominantLanguageErrorKind::BatchSizeLimitExceededException(inner) => Error::BatchSizeLimitExceededException(inner),
                crate::error::BatchDetectDominantLanguageErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::BatchDetectDominantLanguageErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::BatchDetectDominantLanguageErrorKind::TextSizeLimitExceededException(inner) => Error::TextSizeLimitExceededException(inner),
                crate::error::BatchDetectDominantLanguageErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDetectEntitiesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDetectEntitiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchDetectEntitiesErrorKind::BatchSizeLimitExceededException(
                    inner,
                ) => Error::BatchSizeLimitExceededException(inner),
                crate::error::BatchDetectEntitiesErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::BatchDetectEntitiesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::BatchDetectEntitiesErrorKind::TextSizeLimitExceededException(
                    inner,
                ) => Error::TextSizeLimitExceededException(inner),
                crate::error::BatchDetectEntitiesErrorKind::UnsupportedLanguageException(inner) => {
                    Error::UnsupportedLanguageException(inner)
                }
                crate::error::BatchDetectEntitiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDetectKeyPhrasesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDetectKeyPhrasesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchDetectKeyPhrasesErrorKind::BatchSizeLimitExceededException(
                    inner,
                ) => Error::BatchSizeLimitExceededException(inner),
                crate::error::BatchDetectKeyPhrasesErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::BatchDetectKeyPhrasesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::BatchDetectKeyPhrasesErrorKind::TextSizeLimitExceededException(
                    inner,
                ) => Error::TextSizeLimitExceededException(inner),
                crate::error::BatchDetectKeyPhrasesErrorKind::UnsupportedLanguageException(
                    inner,
                ) => Error::UnsupportedLanguageException(inner),
                crate::error::BatchDetectKeyPhrasesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDetectSentimentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDetectSentimentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchDetectSentimentErrorKind::BatchSizeLimitExceededException(
                    inner,
                ) => Error::BatchSizeLimitExceededException(inner),
                crate::error::BatchDetectSentimentErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::BatchDetectSentimentErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::BatchDetectSentimentErrorKind::TextSizeLimitExceededException(
                    inner,
                ) => Error::TextSizeLimitExceededException(inner),
                crate::error::BatchDetectSentimentErrorKind::UnsupportedLanguageException(
                    inner,
                ) => Error::UnsupportedLanguageException(inner),
                crate::error::BatchDetectSentimentErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDetectSyntaxError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDetectSyntaxError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchDetectSyntaxErrorKind::BatchSizeLimitExceededException(
                    inner,
                ) => Error::BatchSizeLimitExceededException(inner),
                crate::error::BatchDetectSyntaxErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::BatchDetectSyntaxErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::BatchDetectSyntaxErrorKind::TextSizeLimitExceededException(inner) => {
                    Error::TextSizeLimitExceededException(inner)
                }
                crate::error::BatchDetectSyntaxErrorKind::UnsupportedLanguageException(inner) => {
                    Error::UnsupportedLanguageException(inner)
                }
                crate::error::BatchDetectSyntaxErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ClassifyDocumentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ClassifyDocumentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ClassifyDocumentErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::ClassifyDocumentErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ClassifyDocumentErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::ClassifyDocumentErrorKind::TextSizeLimitExceededException(inner) => {
                    Error::TextSizeLimitExceededException(inner)
                }
                crate::error::ClassifyDocumentErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ContainsPiiEntitiesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ContainsPiiEntitiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ContainsPiiEntitiesErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::ContainsPiiEntitiesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ContainsPiiEntitiesErrorKind::TextSizeLimitExceededException(
                    inner,
                ) => Error::TextSizeLimitExceededException(inner),
                crate::error::ContainsPiiEntitiesErrorKind::UnsupportedLanguageException(inner) => {
                    Error::UnsupportedLanguageException(inner)
                }
                crate::error::ContainsPiiEntitiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDocumentClassifierError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDocumentClassifierError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDocumentClassifierErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::CreateDocumentClassifierErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::CreateDocumentClassifierErrorKind::KmsKeyValidationException(
                    inner,
                ) => Error::KmsKeyValidationException(inner),
                crate::error::CreateDocumentClassifierErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::CreateDocumentClassifierErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::CreateDocumentClassifierErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::CreateDocumentClassifierErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::CreateDocumentClassifierErrorKind::UnsupportedLanguageException(
                    inner,
                ) => Error::UnsupportedLanguageException(inner),
                crate::error::CreateDocumentClassifierErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateEndpointError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateEndpointErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::CreateEndpointErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::CreateEndpointErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::CreateEndpointErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::CreateEndpointErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateEndpointErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::CreateEndpointErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::CreateEndpointErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::CreateEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateEntityRecognizerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateEntityRecognizerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateEntityRecognizerErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::CreateEntityRecognizerErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::CreateEntityRecognizerErrorKind::KmsKeyValidationException(inner) => {
                    Error::KmsKeyValidationException(inner)
                }
                crate::error::CreateEntityRecognizerErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::CreateEntityRecognizerErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::CreateEntityRecognizerErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::CreateEntityRecognizerErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::CreateEntityRecognizerErrorKind::UnsupportedLanguageException(
                    inner,
                ) => Error::UnsupportedLanguageException(inner),
                crate::error::CreateEntityRecognizerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDocumentClassifierError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDocumentClassifierError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDocumentClassifierErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DeleteDocumentClassifierErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DeleteDocumentClassifierErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeleteDocumentClassifierErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteDocumentClassifierErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::DeleteDocumentClassifierErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::DeleteDocumentClassifierErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteEndpointErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DeleteEndpointErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DeleteEndpointErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeleteEndpointErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteEndpointErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::DeleteEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEntityRecognizerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteEntityRecognizerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteEntityRecognizerErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DeleteEntityRecognizerErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DeleteEntityRecognizerErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeleteEntityRecognizerErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteEntityRecognizerErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::DeleteEntityRecognizerErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::DeleteEntityRecognizerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteResourcePolicyErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DeleteResourcePolicyErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DeleteResourcePolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteResourcePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeDocumentClassificationJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDocumentClassificationJobError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDocumentClassificationJobErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::DescribeDocumentClassificationJobErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::DescribeDocumentClassificationJobErrorKind::JobNotFoundException(inner) => Error::JobNotFoundException(inner),
                crate::error::DescribeDocumentClassificationJobErrorKind::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
                crate::error::DescribeDocumentClassificationJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDocumentClassifierError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDocumentClassifierError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDocumentClassifierErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::DescribeDocumentClassifierErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::DescribeDocumentClassifierErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeDocumentClassifierErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::DescribeDocumentClassifierErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeDominantLanguageDetectionJobError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDominantLanguageDetectionJobError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDominantLanguageDetectionJobErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::DescribeDominantLanguageDetectionJobErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::DescribeDominantLanguageDetectionJobErrorKind::JobNotFoundException(inner) => Error::JobNotFoundException(inner),
                crate::error::DescribeDominantLanguageDetectionJobErrorKind::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
                crate::error::DescribeDominantLanguageDetectionJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEndpointErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DescribeEndpointErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DescribeEndpointErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeEndpointErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::DescribeEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEntitiesDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEntitiesDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEntitiesDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::DescribeEntitiesDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::DescribeEntitiesDetectionJobErrorKind::JobNotFoundException(
                    inner,
                ) => Error::JobNotFoundException(inner),
                crate::error::DescribeEntitiesDetectionJobErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::DescribeEntitiesDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEntityRecognizerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEntityRecognizerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEntityRecognizerErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DescribeEntityRecognizerErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DescribeEntityRecognizerErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeEntityRecognizerErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::DescribeEntityRecognizerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventsDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventsDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventsDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::DescribeEventsDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::DescribeEventsDetectionJobErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::DescribeEventsDetectionJobErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::DescribeEventsDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeKeyPhrasesDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeKeyPhrasesDetectionJobError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeKeyPhrasesDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::DescribeKeyPhrasesDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::DescribeKeyPhrasesDetectionJobErrorKind::JobNotFoundException(
                    inner,
                ) => Error::JobNotFoundException(inner),
                crate::error::DescribeKeyPhrasesDetectionJobErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::DescribeKeyPhrasesDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribePiiEntitiesDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribePiiEntitiesDetectionJobError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribePiiEntitiesDetectionJobErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::DescribePiiEntitiesDetectionJobErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::DescribePiiEntitiesDetectionJobErrorKind::JobNotFoundException(inner) => Error::JobNotFoundException(inner),
                crate::error::DescribePiiEntitiesDetectionJobErrorKind::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
                crate::error::DescribePiiEntitiesDetectionJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeResourcePolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeResourcePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeResourcePolicyErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DescribeResourcePolicyErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DescribeResourcePolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeResourcePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSentimentDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSentimentDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSentimentDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::DescribeSentimentDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::DescribeSentimentDetectionJobErrorKind::JobNotFoundException(
                    inner,
                ) => Error::JobNotFoundException(inner),
                crate::error::DescribeSentimentDetectionJobErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::DescribeSentimentDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeTargetedSentimentDetectionJobError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeTargetedSentimentDetectionJobError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeTargetedSentimentDetectionJobErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::DescribeTargetedSentimentDetectionJobErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::DescribeTargetedSentimentDetectionJobErrorKind::JobNotFoundException(inner) => Error::JobNotFoundException(inner),
                crate::error::DescribeTargetedSentimentDetectionJobErrorKind::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
                crate::error::DescribeTargetedSentimentDetectionJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTopicsDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTopicsDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTopicsDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::DescribeTopicsDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::DescribeTopicsDetectionJobErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::DescribeTopicsDetectionJobErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::DescribeTopicsDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectDominantLanguageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DetectDominantLanguageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectDominantLanguageErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DetectDominantLanguageErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DetectDominantLanguageErrorKind::TextSizeLimitExceededException(
                    inner,
                ) => Error::TextSizeLimitExceededException(inner),
                crate::error::DetectDominantLanguageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectEntitiesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DetectEntitiesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectEntitiesErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DetectEntitiesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DetectEntitiesErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::DetectEntitiesErrorKind::TextSizeLimitExceededException(inner) => {
                    Error::TextSizeLimitExceededException(inner)
                }
                crate::error::DetectEntitiesErrorKind::UnsupportedLanguageException(inner) => {
                    Error::UnsupportedLanguageException(inner)
                }
                crate::error::DetectEntitiesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectKeyPhrasesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DetectKeyPhrasesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectKeyPhrasesErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DetectKeyPhrasesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DetectKeyPhrasesErrorKind::TextSizeLimitExceededException(inner) => {
                    Error::TextSizeLimitExceededException(inner)
                }
                crate::error::DetectKeyPhrasesErrorKind::UnsupportedLanguageException(inner) => {
                    Error::UnsupportedLanguageException(inner)
                }
                crate::error::DetectKeyPhrasesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectPiiEntitiesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DetectPiiEntitiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectPiiEntitiesErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DetectPiiEntitiesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DetectPiiEntitiesErrorKind::TextSizeLimitExceededException(inner) => {
                    Error::TextSizeLimitExceededException(inner)
                }
                crate::error::DetectPiiEntitiesErrorKind::UnsupportedLanguageException(inner) => {
                    Error::UnsupportedLanguageException(inner)
                }
                crate::error::DetectPiiEntitiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectSentimentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DetectSentimentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectSentimentErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DetectSentimentErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DetectSentimentErrorKind::TextSizeLimitExceededException(inner) => {
                    Error::TextSizeLimitExceededException(inner)
                }
                crate::error::DetectSentimentErrorKind::UnsupportedLanguageException(inner) => {
                    Error::UnsupportedLanguageException(inner)
                }
                crate::error::DetectSentimentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectSyntaxError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DetectSyntaxError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectSyntaxErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::DetectSyntaxErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DetectSyntaxErrorKind::TextSizeLimitExceededException(inner) => {
                    Error::TextSizeLimitExceededException(inner)
                }
                crate::error::DetectSyntaxErrorKind::UnsupportedLanguageException(inner) => {
                    Error::UnsupportedLanguageException(inner)
                }
                crate::error::DetectSyntaxErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportModelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ImportModelError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ImportModelErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::ImportModelErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ImportModelErrorKind::KmsKeyValidationException(inner) => {
                    Error::KmsKeyValidationException(inner)
                }
                crate::error::ImportModelErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::ImportModelErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::ImportModelErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ImportModelErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::ImportModelErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::ImportModelErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::ImportModelErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListDocumentClassificationJobsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListDocumentClassificationJobsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDocumentClassificationJobsErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::ListDocumentClassificationJobsErrorKind::InvalidFilterException(
                    inner,
                ) => Error::InvalidFilterException(inner),
                crate::error::ListDocumentClassificationJobsErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::ListDocumentClassificationJobsErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::ListDocumentClassificationJobsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDocumentClassifiersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDocumentClassifiersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDocumentClassifiersErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::ListDocumentClassifiersErrorKind::InvalidFilterException(inner) => {
                    Error::InvalidFilterException(inner)
                }
                crate::error::ListDocumentClassifiersErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListDocumentClassifiersErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::ListDocumentClassifiersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListDocumentClassifierSummariesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListDocumentClassifierSummariesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListDocumentClassifierSummariesErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::ListDocumentClassifierSummariesErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::ListDocumentClassifierSummariesErrorKind::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
                crate::error::ListDocumentClassifierSummariesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListDominantLanguageDetectionJobsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListDominantLanguageDetectionJobsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListDominantLanguageDetectionJobsErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::ListDominantLanguageDetectionJobsErrorKind::InvalidFilterException(inner) => Error::InvalidFilterException(inner),
                crate::error::ListDominantLanguageDetectionJobsErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::ListDominantLanguageDetectionJobsErrorKind::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
                crate::error::ListDominantLanguageDetectionJobsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListEndpointsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListEndpointsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListEndpointsErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::ListEndpointsErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListEndpointsErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::ListEndpointsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListEntitiesDetectionJobsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListEntitiesDetectionJobsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListEntitiesDetectionJobsErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::ListEntitiesDetectionJobsErrorKind::InvalidFilterException(inner) => {
                    Error::InvalidFilterException(inner)
                }
                crate::error::ListEntitiesDetectionJobsErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::ListEntitiesDetectionJobsErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::ListEntitiesDetectionJobsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListEntityRecognizersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListEntityRecognizersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListEntityRecognizersErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::ListEntityRecognizersErrorKind::InvalidFilterException(inner) => {
                    Error::InvalidFilterException(inner)
                }
                crate::error::ListEntityRecognizersErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListEntityRecognizersErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::ListEntityRecognizersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListEntityRecognizerSummariesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListEntityRecognizerSummariesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListEntityRecognizerSummariesErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::ListEntityRecognizerSummariesErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::ListEntityRecognizerSummariesErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::ListEntityRecognizerSummariesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListEventsDetectionJobsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListEventsDetectionJobsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListEventsDetectionJobsErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::ListEventsDetectionJobsErrorKind::InvalidFilterException(inner) => {
                    Error::InvalidFilterException(inner)
                }
                crate::error::ListEventsDetectionJobsErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListEventsDetectionJobsErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::ListEventsDetectionJobsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListKeyPhrasesDetectionJobsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListKeyPhrasesDetectionJobsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListKeyPhrasesDetectionJobsErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::ListKeyPhrasesDetectionJobsErrorKind::InvalidFilterException(
                    inner,
                ) => Error::InvalidFilterException(inner),
                crate::error::ListKeyPhrasesDetectionJobsErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::ListKeyPhrasesDetectionJobsErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::ListKeyPhrasesDetectionJobsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPiiEntitiesDetectionJobsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListPiiEntitiesDetectionJobsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListPiiEntitiesDetectionJobsErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::ListPiiEntitiesDetectionJobsErrorKind::InvalidFilterException(
                    inner,
                ) => Error::InvalidFilterException(inner),
                crate::error::ListPiiEntitiesDetectionJobsErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::ListPiiEntitiesDetectionJobsErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::ListPiiEntitiesDetectionJobsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListSentimentDetectionJobsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListSentimentDetectionJobsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListSentimentDetectionJobsErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::ListSentimentDetectionJobsErrorKind::InvalidFilterException(
                    inner,
                ) => Error::InvalidFilterException(inner),
                crate::error::ListSentimentDetectionJobsErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::ListSentimentDetectionJobsErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::ListSentimentDetectionJobsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::ListTargetedSentimentDetectionJobsError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListTargetedSentimentDetectionJobsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListTargetedSentimentDetectionJobsErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::ListTargetedSentimentDetectionJobsErrorKind::InvalidFilterException(inner) => Error::InvalidFilterException(inner),
                crate::error::ListTargetedSentimentDetectionJobsErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::ListTargetedSentimentDetectionJobsErrorKind::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
                crate::error::ListTargetedSentimentDetectionJobsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTopicsDetectionJobsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTopicsDetectionJobsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTopicsDetectionJobsErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::ListTopicsDetectionJobsErrorKind::InvalidFilterException(inner) => {
                    Error::InvalidFilterException(inner)
                }
                crate::error::ListTopicsDetectionJobsErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListTopicsDetectionJobsErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::ListTopicsDetectionJobsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutResourcePolicyErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::PutResourcePolicyErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::PutResourcePolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::PutResourcePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::StartDocumentClassificationJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StartDocumentClassificationJobError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartDocumentClassificationJobErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::StartDocumentClassificationJobErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::StartDocumentClassificationJobErrorKind::KmsKeyValidationException(inner) => Error::KmsKeyValidationException(inner),
                crate::error::StartDocumentClassificationJobErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::StartDocumentClassificationJobErrorKind::ResourceUnavailableException(inner) => Error::ResourceUnavailableException(inner),
                crate::error::StartDocumentClassificationJobErrorKind::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
                crate::error::StartDocumentClassificationJobErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::StartDocumentClassificationJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::StartDominantLanguageDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StartDominantLanguageDetectionJobError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartDominantLanguageDetectionJobErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::StartDominantLanguageDetectionJobErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::StartDominantLanguageDetectionJobErrorKind::KmsKeyValidationException(inner) => Error::KmsKeyValidationException(inner),
                crate::error::StartDominantLanguageDetectionJobErrorKind::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
                crate::error::StartDominantLanguageDetectionJobErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::StartDominantLanguageDetectionJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartEntitiesDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartEntitiesDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartEntitiesDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::StartEntitiesDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::StartEntitiesDetectionJobErrorKind::KmsKeyValidationException(
                    inner,
                ) => Error::KmsKeyValidationException(inner),
                crate::error::StartEntitiesDetectionJobErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::StartEntitiesDetectionJobErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::StartEntitiesDetectionJobErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::StartEntitiesDetectionJobErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::StartEntitiesDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartEventsDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartEventsDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartEventsDetectionJobErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::StartEventsDetectionJobErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::StartEventsDetectionJobErrorKind::KmsKeyValidationException(
                    inner,
                ) => Error::KmsKeyValidationException(inner),
                crate::error::StartEventsDetectionJobErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::StartEventsDetectionJobErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::StartEventsDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartKeyPhrasesDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartKeyPhrasesDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartKeyPhrasesDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::StartKeyPhrasesDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::StartKeyPhrasesDetectionJobErrorKind::KmsKeyValidationException(
                    inner,
                ) => Error::KmsKeyValidationException(inner),
                crate::error::StartKeyPhrasesDetectionJobErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::StartKeyPhrasesDetectionJobErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::StartKeyPhrasesDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartPiiEntitiesDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartPiiEntitiesDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartPiiEntitiesDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::StartPiiEntitiesDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::StartPiiEntitiesDetectionJobErrorKind::KmsKeyValidationException(
                    inner,
                ) => Error::KmsKeyValidationException(inner),
                crate::error::StartPiiEntitiesDetectionJobErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::StartPiiEntitiesDetectionJobErrorKind::TooManyTagsException(
                    inner,
                ) => Error::TooManyTagsException(inner),
                crate::error::StartPiiEntitiesDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartSentimentDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartSentimentDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartSentimentDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::StartSentimentDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::StartSentimentDetectionJobErrorKind::KmsKeyValidationException(
                    inner,
                ) => Error::KmsKeyValidationException(inner),
                crate::error::StartSentimentDetectionJobErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::StartSentimentDetectionJobErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::StartSentimentDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::StartTargetedSentimentDetectionJobError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StartTargetedSentimentDetectionJobError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartTargetedSentimentDetectionJobErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::StartTargetedSentimentDetectionJobErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::StartTargetedSentimentDetectionJobErrorKind::KmsKeyValidationException(inner) => Error::KmsKeyValidationException(inner),
                crate::error::StartTargetedSentimentDetectionJobErrorKind::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
                crate::error::StartTargetedSentimentDetectionJobErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::StartTargetedSentimentDetectionJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartTopicsDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartTopicsDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartTopicsDetectionJobErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::StartTopicsDetectionJobErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::StartTopicsDetectionJobErrorKind::KmsKeyValidationException(
                    inner,
                ) => Error::KmsKeyValidationException(inner),
                crate::error::StartTopicsDetectionJobErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::StartTopicsDetectionJobErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::StartTopicsDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::StopDominantLanguageDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StopDominantLanguageDetectionJobError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopDominantLanguageDetectionJobErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::StopDominantLanguageDetectionJobErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::StopDominantLanguageDetectionJobErrorKind::JobNotFoundException(inner) => Error::JobNotFoundException(inner),
                crate::error::StopDominantLanguageDetectionJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopEntitiesDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopEntitiesDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopEntitiesDetectionJobErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::StopEntitiesDetectionJobErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::StopEntitiesDetectionJobErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::StopEntitiesDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopEventsDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopEventsDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopEventsDetectionJobErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::StopEventsDetectionJobErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::StopEventsDetectionJobErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::StopEventsDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopKeyPhrasesDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopKeyPhrasesDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopKeyPhrasesDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::StopKeyPhrasesDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::StopKeyPhrasesDetectionJobErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::StopKeyPhrasesDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopPiiEntitiesDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopPiiEntitiesDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopPiiEntitiesDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::StopPiiEntitiesDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::StopPiiEntitiesDetectionJobErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::StopPiiEntitiesDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopSentimentDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopSentimentDetectionJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopSentimentDetectionJobErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::StopSentimentDetectionJobErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::StopSentimentDetectionJobErrorKind::JobNotFoundException(inner) => {
                    Error::JobNotFoundException(inner)
                }
                crate::error::StopSentimentDetectionJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::StopTargetedSentimentDetectionJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StopTargetedSentimentDetectionJobError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopTargetedSentimentDetectionJobErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::StopTargetedSentimentDetectionJobErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::StopTargetedSentimentDetectionJobErrorKind::JobNotFoundException(inner) => Error::JobNotFoundException(inner),
                crate::error::StopTargetedSentimentDetectionJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::StopTrainingDocumentClassifierError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StopTrainingDocumentClassifierError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopTrainingDocumentClassifierErrorKind::InternalServerException(inner) => Error::InternalServerException(inner),
                crate::error::StopTrainingDocumentClassifierErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::StopTrainingDocumentClassifierErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::StopTrainingDocumentClassifierErrorKind::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
                crate::error::StopTrainingDocumentClassifierErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopTrainingEntityRecognizerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopTrainingEntityRecognizerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopTrainingEntityRecognizerErrorKind::InternalServerException(
                    inner,
                ) => Error::InternalServerException(inner),
                crate::error::StopTrainingEntityRecognizerErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::StopTrainingEntityRecognizerErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::StopTrainingEntityRecognizerErrorKind::TooManyRequestsException(
                    inner,
                ) => Error::TooManyRequestsException(inner),
                crate::error::StopTrainingEntityRecognizerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::TagResourceErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UntagResourceErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::UntagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::TooManyTagKeysException(inner) => {
                    Error::TooManyTagKeysException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateEndpointError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateEndpointErrorKind::InternalServerException(inner) => {
                    Error::InternalServerException(inner)
                }
                crate::error::UpdateEndpointErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::UpdateEndpointErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::UpdateEndpointErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::UpdateEndpointErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateEndpointErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::UpdateEndpointErrorKind::TooManyRequestsException(inner) => {
                    Error::TooManyRequestsException(inner)
                }
                crate::error::UpdateEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
