// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchDetectDominantLanguage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDetectDominantLanguageError {
    /// Kind of error that occurred.
    pub kind: BatchDetectDominantLanguageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDetectDominantLanguage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDetectDominantLanguageErrorKind {
    /// <p>The number of documents in the request exceeds the limit of 25. Try your request again with fewer documents.</p>
    BatchSizeLimitExceededException(crate::error::BatchSizeLimitExceededException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDetectDominantLanguageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDetectDominantLanguageErrorKind::BatchSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            BatchDetectDominantLanguageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchDetectDominantLanguageErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchDetectDominantLanguageErrorKind::TextSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            BatchDetectDominantLanguageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDetectDominantLanguageError {
    fn code(&self) -> Option<&str> {
        BatchDetectDominantLanguageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDetectDominantLanguageError {
    /// Creates a new `BatchDetectDominantLanguageError`.
    pub fn new(kind: BatchDetectDominantLanguageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDetectDominantLanguageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDetectDominantLanguageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDetectDominantLanguageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDetectDominantLanguageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDetectDominantLanguageErrorKind::BatchSizeLimitExceededException`.
    pub fn is_batch_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectDominantLanguageErrorKind::BatchSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectDominantLanguageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectDominantLanguageErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectDominantLanguageErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectDominantLanguageErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectDominantLanguageErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectDominantLanguageErrorKind::TextSizeLimitExceededException(_)
        )
    }
}
impl std::error::Error for BatchDetectDominantLanguageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDetectDominantLanguageErrorKind::BatchSizeLimitExceededException(_inner) => {
                Some(_inner)
            }
            BatchDetectDominantLanguageErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchDetectDominantLanguageErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchDetectDominantLanguageErrorKind::TextSizeLimitExceededException(_inner) => {
                Some(_inner)
            }
            BatchDetectDominantLanguageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDetectEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDetectEntitiesError {
    /// Kind of error that occurred.
    pub kind: BatchDetectEntitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDetectEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDetectEntitiesErrorKind {
    /// <p>The number of documents in the request exceeds the limit of 25. Try your request again with fewer documents.</p>
    BatchSizeLimitExceededException(crate::error::BatchSizeLimitExceededException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDetectEntitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDetectEntitiesErrorKind::BatchSizeLimitExceededException(_inner) => _inner.fmt(f),
            BatchDetectEntitiesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchDetectEntitiesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchDetectEntitiesErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            BatchDetectEntitiesErrorKind::UnsupportedLanguageException(_inner) => _inner.fmt(f),
            BatchDetectEntitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDetectEntitiesError {
    fn code(&self) -> Option<&str> {
        BatchDetectEntitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDetectEntitiesError {
    /// Creates a new `BatchDetectEntitiesError`.
    pub fn new(kind: BatchDetectEntitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDetectEntitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDetectEntitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDetectEntitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDetectEntitiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDetectEntitiesErrorKind::BatchSizeLimitExceededException`.
    pub fn is_batch_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectEntitiesErrorKind::BatchSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectEntitiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectEntitiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectEntitiesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectEntitiesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectEntitiesErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectEntitiesErrorKind::TextSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectEntitiesErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectEntitiesErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for BatchDetectEntitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDetectEntitiesErrorKind::BatchSizeLimitExceededException(_inner) => Some(_inner),
            BatchDetectEntitiesErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchDetectEntitiesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchDetectEntitiesErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            BatchDetectEntitiesErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            BatchDetectEntitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDetectKeyPhrases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDetectKeyPhrasesError {
    /// Kind of error that occurred.
    pub kind: BatchDetectKeyPhrasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDetectKeyPhrases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDetectKeyPhrasesErrorKind {
    /// <p>The number of documents in the request exceeds the limit of 25. Try your request again with fewer documents.</p>
    BatchSizeLimitExceededException(crate::error::BatchSizeLimitExceededException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDetectKeyPhrasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDetectKeyPhrasesErrorKind::BatchSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            BatchDetectKeyPhrasesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchDetectKeyPhrasesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchDetectKeyPhrasesErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            BatchDetectKeyPhrasesErrorKind::UnsupportedLanguageException(_inner) => _inner.fmt(f),
            BatchDetectKeyPhrasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDetectKeyPhrasesError {
    fn code(&self) -> Option<&str> {
        BatchDetectKeyPhrasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDetectKeyPhrasesError {
    /// Creates a new `BatchDetectKeyPhrasesError`.
    pub fn new(kind: BatchDetectKeyPhrasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDetectKeyPhrasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDetectKeyPhrasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDetectKeyPhrasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDetectKeyPhrasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDetectKeyPhrasesErrorKind::BatchSizeLimitExceededException`.
    pub fn is_batch_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectKeyPhrasesErrorKind::BatchSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectKeyPhrasesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectKeyPhrasesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectKeyPhrasesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectKeyPhrasesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectKeyPhrasesErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectKeyPhrasesErrorKind::TextSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectKeyPhrasesErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectKeyPhrasesErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for BatchDetectKeyPhrasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDetectKeyPhrasesErrorKind::BatchSizeLimitExceededException(_inner) => Some(_inner),
            BatchDetectKeyPhrasesErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchDetectKeyPhrasesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchDetectKeyPhrasesErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            BatchDetectKeyPhrasesErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            BatchDetectKeyPhrasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDetectSentiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDetectSentimentError {
    /// Kind of error that occurred.
    pub kind: BatchDetectSentimentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDetectSentiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDetectSentimentErrorKind {
    /// <p>The number of documents in the request exceeds the limit of 25. Try your request again with fewer documents.</p>
    BatchSizeLimitExceededException(crate::error::BatchSizeLimitExceededException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDetectSentimentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDetectSentimentErrorKind::BatchSizeLimitExceededException(_inner) => _inner.fmt(f),
            BatchDetectSentimentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchDetectSentimentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchDetectSentimentErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            BatchDetectSentimentErrorKind::UnsupportedLanguageException(_inner) => _inner.fmt(f),
            BatchDetectSentimentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDetectSentimentError {
    fn code(&self) -> Option<&str> {
        BatchDetectSentimentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDetectSentimentError {
    /// Creates a new `BatchDetectSentimentError`.
    pub fn new(kind: BatchDetectSentimentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDetectSentimentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDetectSentimentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDetectSentimentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDetectSentimentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDetectSentimentErrorKind::BatchSizeLimitExceededException`.
    pub fn is_batch_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectSentimentErrorKind::BatchSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectSentimentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectSentimentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectSentimentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectSentimentErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectSentimentErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectSentimentErrorKind::TextSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectSentimentErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectSentimentErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for BatchDetectSentimentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDetectSentimentErrorKind::BatchSizeLimitExceededException(_inner) => Some(_inner),
            BatchDetectSentimentErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchDetectSentimentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchDetectSentimentErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            BatchDetectSentimentErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            BatchDetectSentimentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDetectSyntax` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDetectSyntaxError {
    /// Kind of error that occurred.
    pub kind: BatchDetectSyntaxErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDetectSyntax` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDetectSyntaxErrorKind {
    /// <p>The number of documents in the request exceeds the limit of 25. Try your request again with fewer documents.</p>
    BatchSizeLimitExceededException(crate::error::BatchSizeLimitExceededException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDetectSyntaxError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDetectSyntaxErrorKind::BatchSizeLimitExceededException(_inner) => _inner.fmt(f),
            BatchDetectSyntaxErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchDetectSyntaxErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchDetectSyntaxErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            BatchDetectSyntaxErrorKind::UnsupportedLanguageException(_inner) => _inner.fmt(f),
            BatchDetectSyntaxErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDetectSyntaxError {
    fn code(&self) -> Option<&str> {
        BatchDetectSyntaxError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDetectSyntaxError {
    /// Creates a new `BatchDetectSyntaxError`.
    pub fn new(kind: BatchDetectSyntaxErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDetectSyntaxError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDetectSyntaxErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDetectSyntaxError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDetectSyntaxErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDetectSyntaxErrorKind::BatchSizeLimitExceededException`.
    pub fn is_batch_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectSyntaxErrorKind::BatchSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectSyntaxErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectSyntaxErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectSyntaxErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectSyntaxErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectSyntaxErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectSyntaxErrorKind::TextSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDetectSyntaxErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDetectSyntaxErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for BatchDetectSyntaxError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDetectSyntaxErrorKind::BatchSizeLimitExceededException(_inner) => Some(_inner),
            BatchDetectSyntaxErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchDetectSyntaxErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchDetectSyntaxErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            BatchDetectSyntaxErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            BatchDetectSyntaxErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ClassifyDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ClassifyDocumentError {
    /// Kind of error that occurred.
    pub kind: ClassifyDocumentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ClassifyDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ClassifyDocumentErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is not available. Check the resource and try your request again.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ClassifyDocumentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ClassifyDocumentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ClassifyDocumentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ClassifyDocumentErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            ClassifyDocumentErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            ClassifyDocumentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ClassifyDocumentError {
    fn code(&self) -> Option<&str> {
        ClassifyDocumentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ClassifyDocumentError {
    /// Creates a new `ClassifyDocumentError`.
    pub fn new(kind: ClassifyDocumentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ClassifyDocumentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ClassifyDocumentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ClassifyDocumentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ClassifyDocumentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ClassifyDocumentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClassifyDocumentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ClassifyDocumentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClassifyDocumentErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ClassifyDocumentErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClassifyDocumentErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ClassifyDocumentErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClassifyDocumentErrorKind::TextSizeLimitExceededException(_)
        )
    }
}
impl std::error::Error for ClassifyDocumentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ClassifyDocumentErrorKind::InternalServerException(_inner) => Some(_inner),
            ClassifyDocumentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ClassifyDocumentErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            ClassifyDocumentErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            ClassifyDocumentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ContainsPiiEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ContainsPiiEntitiesError {
    /// Kind of error that occurred.
    pub kind: ContainsPiiEntitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ContainsPiiEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ContainsPiiEntitiesErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ContainsPiiEntitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ContainsPiiEntitiesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ContainsPiiEntitiesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ContainsPiiEntitiesErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            ContainsPiiEntitiesErrorKind::UnsupportedLanguageException(_inner) => _inner.fmt(f),
            ContainsPiiEntitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ContainsPiiEntitiesError {
    fn code(&self) -> Option<&str> {
        ContainsPiiEntitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ContainsPiiEntitiesError {
    /// Creates a new `ContainsPiiEntitiesError`.
    pub fn new(kind: ContainsPiiEntitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ContainsPiiEntitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ContainsPiiEntitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ContainsPiiEntitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ContainsPiiEntitiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ContainsPiiEntitiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ContainsPiiEntitiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ContainsPiiEntitiesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ContainsPiiEntitiesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ContainsPiiEntitiesErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ContainsPiiEntitiesErrorKind::TextSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ContainsPiiEntitiesErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            ContainsPiiEntitiesErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for ContainsPiiEntitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ContainsPiiEntitiesErrorKind::InternalServerException(_inner) => Some(_inner),
            ContainsPiiEntitiesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ContainsPiiEntitiesErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            ContainsPiiEntitiesErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            ContainsPiiEntitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDocumentClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDocumentClassifierError {
    /// Kind of error that occurred.
    pub kind: CreateDocumentClassifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDocumentClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDocumentClassifierErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The specified resource name is already in use. Use a different name and try your request again.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The maximum number of resources per account has been exceeded. Review the resources, and then try your request again.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDocumentClassifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDocumentClassifierErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDocumentClassifierErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateDocumentClassifierErrorKind::KmsKeyValidationException(_inner) => _inner.fmt(f),
            CreateDocumentClassifierErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateDocumentClassifierErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateDocumentClassifierErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateDocumentClassifierErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateDocumentClassifierErrorKind::UnsupportedLanguageException(_inner) => {
                _inner.fmt(f)
            }
            CreateDocumentClassifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDocumentClassifierError {
    fn code(&self) -> Option<&str> {
        CreateDocumentClassifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDocumentClassifierError {
    /// Creates a new `CreateDocumentClassifierError`.
    pub fn new(kind: CreateDocumentClassifierErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDocumentClassifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDocumentClassifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDocumentClassifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDocumentClassifierErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDocumentClassifierErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentClassifierErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDocumentClassifierErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentClassifierErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDocumentClassifierErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentClassifierErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDocumentClassifierErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentClassifierErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDocumentClassifierErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentClassifierErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDocumentClassifierErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentClassifierErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDocumentClassifierErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentClassifierErrorKind::TooManyTagsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDocumentClassifierErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentClassifierErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for CreateDocumentClassifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDocumentClassifierErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDocumentClassifierErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateDocumentClassifierErrorKind::KmsKeyValidationException(_inner) => Some(_inner),
            CreateDocumentClassifierErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateDocumentClassifierErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateDocumentClassifierErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateDocumentClassifierErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateDocumentClassifierErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            CreateDocumentClassifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEndpointError {
    /// Kind of error that occurred.
    pub kind: CreateEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEndpointErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource name is already in use. Use a different name and try your request again.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The maximum number of resources per account has been exceeded. Review the resources, and then try your request again.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available. Check the resource and try your request again.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEndpointErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEndpointError {
    fn code(&self) -> Option<&str> {
        CreateEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEndpointError {
    /// Creates a new `CreateEndpointError`.
    pub fn new(kind: CreateEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateEndpointErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for CreateEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEndpointErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateEndpointErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateEndpointErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateEndpointErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateEndpointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateEndpointErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            CreateEndpointErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateEndpointErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEntityRecognizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEntityRecognizerError {
    /// Kind of error that occurred.
    pub kind: CreateEntityRecognizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEntityRecognizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEntityRecognizerErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The specified resource name is already in use. Use a different name and try your request again.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The maximum number of resources per account has been exceeded. Review the resources, and then try your request again.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEntityRecognizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEntityRecognizerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateEntityRecognizerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateEntityRecognizerErrorKind::KmsKeyValidationException(_inner) => _inner.fmt(f),
            CreateEntityRecognizerErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateEntityRecognizerErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateEntityRecognizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateEntityRecognizerErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateEntityRecognizerErrorKind::UnsupportedLanguageException(_inner) => _inner.fmt(f),
            CreateEntityRecognizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEntityRecognizerError {
    fn code(&self) -> Option<&str> {
        CreateEntityRecognizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEntityRecognizerError {
    /// Creates a new `CreateEntityRecognizerError`.
    pub fn new(kind: CreateEntityRecognizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEntityRecognizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEntityRecognizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEntityRecognizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEntityRecognizerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEntityRecognizerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEntityRecognizerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEntityRecognizerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEntityRecognizerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEntityRecognizerErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEntityRecognizerErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEntityRecognizerErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEntityRecognizerErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEntityRecognizerErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEntityRecognizerErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEntityRecognizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEntityRecognizerErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEntityRecognizerErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEntityRecognizerErrorKind::TooManyTagsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEntityRecognizerErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEntityRecognizerErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for CreateEntityRecognizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEntityRecognizerErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateEntityRecognizerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateEntityRecognizerErrorKind::KmsKeyValidationException(_inner) => Some(_inner),
            CreateEntityRecognizerErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateEntityRecognizerErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateEntityRecognizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateEntityRecognizerErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateEntityRecognizerErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            CreateEntityRecognizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDocumentClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDocumentClassifierError {
    /// Kind of error that occurred.
    pub kind: DeleteDocumentClassifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDocumentClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDocumentClassifierErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource name is already in use. Use a different name and try your request again.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available. Check the resource and try your request again.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDocumentClassifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDocumentClassifierErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDocumentClassifierErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteDocumentClassifierErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteDocumentClassifierErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDocumentClassifierErrorKind::ResourceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteDocumentClassifierErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteDocumentClassifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDocumentClassifierError {
    fn code(&self) -> Option<&str> {
        DeleteDocumentClassifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDocumentClassifierError {
    /// Creates a new `DeleteDocumentClassifierError`.
    pub fn new(kind: DeleteDocumentClassifierErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDocumentClassifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDocumentClassifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDocumentClassifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDocumentClassifierErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDocumentClassifierErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentClassifierErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDocumentClassifierErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentClassifierErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDocumentClassifierErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentClassifierErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDocumentClassifierErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentClassifierErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDocumentClassifierErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentClassifierErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDocumentClassifierErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentClassifierErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteDocumentClassifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDocumentClassifierErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDocumentClassifierErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteDocumentClassifierErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteDocumentClassifierErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDocumentClassifierErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DeleteDocumentClassifierErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteDocumentClassifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEndpointError {
    /// Kind of error that occurred.
    pub kind: DeleteEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEndpointErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource name is already in use. Use a different name and try your request again.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEndpointErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEndpointError {
    fn code(&self) -> Option<&str> {
        DeleteEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEndpointError {
    /// Creates a new `DeleteEndpointError`.
    pub fn new(kind: DeleteEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEndpointErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEntityRecognizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEntityRecognizerError {
    /// Kind of error that occurred.
    pub kind: DeleteEntityRecognizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEntityRecognizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEntityRecognizerErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource name is already in use. Use a different name and try your request again.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available. Check the resource and try your request again.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEntityRecognizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEntityRecognizerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEntityRecognizerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteEntityRecognizerErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteEntityRecognizerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEntityRecognizerErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DeleteEntityRecognizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteEntityRecognizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEntityRecognizerError {
    fn code(&self) -> Option<&str> {
        DeleteEntityRecognizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEntityRecognizerError {
    /// Creates a new `DeleteEntityRecognizerError`.
    pub fn new(kind: DeleteEntityRecognizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEntityRecognizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEntityRecognizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEntityRecognizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEntityRecognizerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEntityRecognizerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityRecognizerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEntityRecognizerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityRecognizerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEntityRecognizerErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityRecognizerErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEntityRecognizerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityRecognizerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEntityRecognizerErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityRecognizerErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEntityRecognizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityRecognizerErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteEntityRecognizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEntityRecognizerErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEntityRecognizerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteEntityRecognizerErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteEntityRecognizerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEntityRecognizerErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DeleteEntityRecognizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteEntityRecognizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourcePolicyErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourcePolicyError {
    /// Creates a new `DeleteResourcePolicyError`.
    pub fn new(kind: DeleteResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDocumentClassificationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDocumentClassificationJobError {
    /// Kind of error that occurred.
    pub kind: DescribeDocumentClassificationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDocumentClassificationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDocumentClassificationJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDocumentClassificationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDocumentClassificationJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDocumentClassificationJobErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDocumentClassificationJobErrorKind::JobNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDocumentClassificationJobErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDocumentClassificationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDocumentClassificationJobError {
    fn code(&self) -> Option<&str> {
        DescribeDocumentClassificationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDocumentClassificationJobError {
    /// Creates a new `DescribeDocumentClassificationJobError`.
    pub fn new(
        kind: DescribeDocumentClassificationJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDocumentClassificationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDocumentClassificationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDocumentClassificationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDocumentClassificationJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDocumentClassificationJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentClassificationJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDocumentClassificationJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentClassificationJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDocumentClassificationJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentClassificationJobErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDocumentClassificationJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentClassificationJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeDocumentClassificationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDocumentClassificationJobErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeDocumentClassificationJobErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeDocumentClassificationJobErrorKind::JobNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeDocumentClassificationJobErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeDocumentClassificationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDocumentClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDocumentClassifierError {
    /// Kind of error that occurred.
    pub kind: DescribeDocumentClassifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDocumentClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDocumentClassifierErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDocumentClassifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDocumentClassifierErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeDocumentClassifierErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeDocumentClassifierErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDocumentClassifierErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeDocumentClassifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDocumentClassifierError {
    fn code(&self) -> Option<&str> {
        DescribeDocumentClassifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDocumentClassifierError {
    /// Creates a new `DescribeDocumentClassifierError`.
    pub fn new(kind: DescribeDocumentClassifierErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDocumentClassifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDocumentClassifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDocumentClassifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDocumentClassifierErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDocumentClassifierErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentClassifierErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDocumentClassifierErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentClassifierErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDocumentClassifierErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentClassifierErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDocumentClassifierErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentClassifierErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeDocumentClassifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDocumentClassifierErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeDocumentClassifierErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeDocumentClassifierErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDocumentClassifierErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeDocumentClassifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDominantLanguageDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDominantLanguageDetectionJobError {
    /// Kind of error that occurred.
    pub kind: DescribeDominantLanguageDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDominantLanguageDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDominantLanguageDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDominantLanguageDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDominantLanguageDetectionJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDominantLanguageDetectionJobErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDominantLanguageDetectionJobErrorKind::JobNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDominantLanguageDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDominantLanguageDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDominantLanguageDetectionJobError {
    fn code(&self) -> Option<&str> {
        DescribeDominantLanguageDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDominantLanguageDetectionJobError {
    /// Creates a new `DescribeDominantLanguageDetectionJobError`.
    pub fn new(
        kind: DescribeDominantLanguageDetectionJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDominantLanguageDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDominantLanguageDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDominantLanguageDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDominantLanguageDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDominantLanguageDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDominantLanguageDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDominantLanguageDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDominantLanguageDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDominantLanguageDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDominantLanguageDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDominantLanguageDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDominantLanguageDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeDominantLanguageDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDominantLanguageDetectionJobErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeDominantLanguageDetectionJobErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeDominantLanguageDetectionJobErrorKind::JobNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeDominantLanguageDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeDominantLanguageDetectionJobErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEndpointError {
    /// Kind of error that occurred.
    pub kind: DescribeEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEndpointErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEndpointErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeEndpointErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeEndpointErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeEndpointErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEndpointError {
    fn code(&self) -> Option<&str> {
        DescribeEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEndpointError {
    /// Creates a new `DescribeEndpointError`.
    pub fn new(kind: DescribeEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEndpointErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEndpointErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeEndpointErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeEndpointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeEndpointErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEntitiesDetectionJobError {
    /// Kind of error that occurred.
    pub kind: DescribeEntitiesDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEntitiesDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEntitiesDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEntitiesDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeEntitiesDetectionJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            DescribeEntitiesDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEntitiesDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEntitiesDetectionJobError {
    fn code(&self) -> Option<&str> {
        DescribeEntitiesDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEntitiesDetectionJobError {
    /// Creates a new `DescribeEntitiesDetectionJobError`.
    pub fn new(kind: DescribeEntitiesDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEntitiesDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEntitiesDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEntitiesDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEntitiesDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEntitiesDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEntitiesDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEntitiesDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEntitiesDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEntitiesDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEntitiesDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEntitiesDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEntitiesDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeEntitiesDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEntitiesDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeEntitiesDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            DescribeEntitiesDetectionJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeEntitiesDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEntityRecognizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEntityRecognizerError {
    /// Kind of error that occurred.
    pub kind: DescribeEntityRecognizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEntityRecognizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEntityRecognizerErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEntityRecognizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEntityRecognizerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeEntityRecognizerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeEntityRecognizerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeEntityRecognizerErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeEntityRecognizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEntityRecognizerError {
    fn code(&self) -> Option<&str> {
        DescribeEntityRecognizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEntityRecognizerError {
    /// Creates a new `DescribeEntityRecognizerError`.
    pub fn new(kind: DescribeEntityRecognizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEntityRecognizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEntityRecognizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEntityRecognizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEntityRecognizerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEntityRecognizerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEntityRecognizerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEntityRecognizerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEntityRecognizerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEntityRecognizerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEntityRecognizerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEntityRecognizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEntityRecognizerErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeEntityRecognizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEntityRecognizerErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeEntityRecognizerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeEntityRecognizerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeEntityRecognizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeEntityRecognizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventsDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventsDetectionJobError {
    /// Kind of error that occurred.
    pub kind: DescribeEventsDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventsDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventsDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventsDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventsDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeEventsDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeEventsDetectionJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            DescribeEventsDetectionJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeEventsDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventsDetectionJobError {
    fn code(&self) -> Option<&str> {
        DescribeEventsDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventsDetectionJobError {
    /// Creates a new `DescribeEventsDetectionJobError`.
    pub fn new(kind: DescribeEventsDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventsDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventsDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventsDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventsDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventsDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventsDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventsDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventsDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeEventsDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventsDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeEventsDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeEventsDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            DescribeEventsDetectionJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeEventsDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeKeyPhrasesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeKeyPhrasesDetectionJobError {
    /// Kind of error that occurred.
    pub kind: DescribeKeyPhrasesDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeKeyPhrasesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeKeyPhrasesDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeKeyPhrasesDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeKeyPhrasesDetectionJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeKeyPhrasesDetectionJobErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeKeyPhrasesDetectionJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            DescribeKeyPhrasesDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeKeyPhrasesDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeKeyPhrasesDetectionJobError {
    fn code(&self) -> Option<&str> {
        DescribeKeyPhrasesDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeKeyPhrasesDetectionJobError {
    /// Creates a new `DescribeKeyPhrasesDetectionJobError`.
    pub fn new(
        kind: DescribeKeyPhrasesDetectionJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeKeyPhrasesDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeKeyPhrasesDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeKeyPhrasesDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeKeyPhrasesDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeKeyPhrasesDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKeyPhrasesDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeKeyPhrasesDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKeyPhrasesDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeKeyPhrasesDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKeyPhrasesDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeKeyPhrasesDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKeyPhrasesDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeKeyPhrasesDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeKeyPhrasesDetectionJobErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeKeyPhrasesDetectionJobErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeKeyPhrasesDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            DescribeKeyPhrasesDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeKeyPhrasesDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePiiEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePiiEntitiesDetectionJobError {
    /// Kind of error that occurred.
    pub kind: DescribePiiEntitiesDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePiiEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePiiEntitiesDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePiiEntitiesDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePiiEntitiesDetectionJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribePiiEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribePiiEntitiesDetectionJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            DescribePiiEntitiesDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribePiiEntitiesDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePiiEntitiesDetectionJobError {
    fn code(&self) -> Option<&str> {
        DescribePiiEntitiesDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePiiEntitiesDetectionJobError {
    /// Creates a new `DescribePiiEntitiesDetectionJobError`.
    pub fn new(
        kind: DescribePiiEntitiesDetectionJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePiiEntitiesDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePiiEntitiesDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePiiEntitiesDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePiiEntitiesDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePiiEntitiesDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePiiEntitiesDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePiiEntitiesDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePiiEntitiesDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePiiEntitiesDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePiiEntitiesDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePiiEntitiesDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePiiEntitiesDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribePiiEntitiesDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePiiEntitiesDetectionJobErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribePiiEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribePiiEntitiesDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            DescribePiiEntitiesDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribePiiEntitiesDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DescribeResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeResourcePolicyErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeResourcePolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DescribeResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeResourcePolicyError {
    /// Creates a new `DescribeResourcePolicyError`.
    pub fn new(kind: DescribeResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourcePolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeResourcePolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSentimentDetectionJobError {
    /// Kind of error that occurred.
    pub kind: DescribeSentimentDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSentimentDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSentimentDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSentimentDetectionJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSentimentDetectionJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            DescribeSentimentDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSentimentDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSentimentDetectionJobError {
    fn code(&self) -> Option<&str> {
        DescribeSentimentDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSentimentDetectionJobError {
    /// Creates a new `DescribeSentimentDetectionJobError`.
    pub fn new(
        kind: DescribeSentimentDetectionJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSentimentDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSentimentDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSentimentDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSentimentDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSentimentDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSentimentDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSentimentDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSentimentDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSentimentDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSentimentDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSentimentDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSentimentDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeSentimentDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSentimentDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeSentimentDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            DescribeSentimentDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeSentimentDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTargetedSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTargetedSentimentDetectionJobError {
    /// Kind of error that occurred.
    pub kind: DescribeTargetedSentimentDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTargetedSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTargetedSentimentDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTargetedSentimentDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTargetedSentimentDetectionJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeTargetedSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeTargetedSentimentDetectionJobErrorKind::JobNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeTargetedSentimentDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeTargetedSentimentDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTargetedSentimentDetectionJobError {
    fn code(&self) -> Option<&str> {
        DescribeTargetedSentimentDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTargetedSentimentDetectionJobError {
    /// Creates a new `DescribeTargetedSentimentDetectionJobError`.
    pub fn new(
        kind: DescribeTargetedSentimentDetectionJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTargetedSentimentDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTargetedSentimentDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTargetedSentimentDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTargetedSentimentDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTargetedSentimentDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTargetedSentimentDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTargetedSentimentDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTargetedSentimentDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTargetedSentimentDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTargetedSentimentDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTargetedSentimentDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTargetedSentimentDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeTargetedSentimentDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTargetedSentimentDetectionJobErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeTargetedSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeTargetedSentimentDetectionJobErrorKind::JobNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeTargetedSentimentDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeTargetedSentimentDetectionJobErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeTopicsDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTopicsDetectionJobError {
    /// Kind of error that occurred.
    pub kind: DescribeTopicsDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTopicsDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTopicsDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTopicsDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTopicsDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeTopicsDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeTopicsDetectionJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            DescribeTopicsDetectionJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeTopicsDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTopicsDetectionJobError {
    fn code(&self) -> Option<&str> {
        DescribeTopicsDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTopicsDetectionJobError {
    /// Creates a new `DescribeTopicsDetectionJobError`.
    pub fn new(kind: DescribeTopicsDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTopicsDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTopicsDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTopicsDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTopicsDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTopicsDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTopicsDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTopicsDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTopicsDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTopicsDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTopicsDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTopicsDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTopicsDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeTopicsDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTopicsDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeTopicsDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeTopicsDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            DescribeTopicsDetectionJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeTopicsDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetectDominantLanguage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetectDominantLanguageError {
    /// Kind of error that occurred.
    pub kind: DetectDominantLanguageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetectDominantLanguage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetectDominantLanguageErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetectDominantLanguageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetectDominantLanguageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DetectDominantLanguageErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DetectDominantLanguageErrorKind::TextSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            DetectDominantLanguageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetectDominantLanguageError {
    fn code(&self) -> Option<&str> {
        DetectDominantLanguageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetectDominantLanguageError {
    /// Creates a new `DetectDominantLanguageError`.
    pub fn new(kind: DetectDominantLanguageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetectDominantLanguageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetectDominantLanguageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetectDominantLanguageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetectDominantLanguageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetectDominantLanguageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectDominantLanguageErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectDominantLanguageErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectDominantLanguageErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectDominantLanguageErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectDominantLanguageErrorKind::TextSizeLimitExceededException(_)
        )
    }
}
impl std::error::Error for DetectDominantLanguageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetectDominantLanguageErrorKind::InternalServerException(_inner) => Some(_inner),
            DetectDominantLanguageErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DetectDominantLanguageErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            DetectDominantLanguageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetectEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetectEntitiesError {
    /// Kind of error that occurred.
    pub kind: DetectEntitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetectEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetectEntitiesErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is not available. Check the resource and try your request again.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetectEntitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetectEntitiesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DetectEntitiesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DetectEntitiesErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DetectEntitiesErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            DetectEntitiesErrorKind::UnsupportedLanguageException(_inner) => _inner.fmt(f),
            DetectEntitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetectEntitiesError {
    fn code(&self) -> Option<&str> {
        DetectEntitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetectEntitiesError {
    /// Creates a new `DetectEntitiesError`.
    pub fn new(kind: DetectEntitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetectEntitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetectEntitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetectEntitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetectEntitiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetectEntitiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectEntitiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectEntitiesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectEntitiesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectEntitiesErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectEntitiesErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectEntitiesErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectEntitiesErrorKind::TextSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectEntitiesErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectEntitiesErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for DetectEntitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetectEntitiesErrorKind::InternalServerException(_inner) => Some(_inner),
            DetectEntitiesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DetectEntitiesErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DetectEntitiesErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            DetectEntitiesErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            DetectEntitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetectKeyPhrases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetectKeyPhrasesError {
    /// Kind of error that occurred.
    pub kind: DetectKeyPhrasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetectKeyPhrases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetectKeyPhrasesErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetectKeyPhrasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetectKeyPhrasesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DetectKeyPhrasesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DetectKeyPhrasesErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            DetectKeyPhrasesErrorKind::UnsupportedLanguageException(_inner) => _inner.fmt(f),
            DetectKeyPhrasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetectKeyPhrasesError {
    fn code(&self) -> Option<&str> {
        DetectKeyPhrasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetectKeyPhrasesError {
    /// Creates a new `DetectKeyPhrasesError`.
    pub fn new(kind: DetectKeyPhrasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetectKeyPhrasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetectKeyPhrasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetectKeyPhrasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetectKeyPhrasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetectKeyPhrasesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectKeyPhrasesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectKeyPhrasesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectKeyPhrasesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectKeyPhrasesErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectKeyPhrasesErrorKind::TextSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectKeyPhrasesErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectKeyPhrasesErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for DetectKeyPhrasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetectKeyPhrasesErrorKind::InternalServerException(_inner) => Some(_inner),
            DetectKeyPhrasesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DetectKeyPhrasesErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            DetectKeyPhrasesErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            DetectKeyPhrasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetectPiiEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetectPiiEntitiesError {
    /// Kind of error that occurred.
    pub kind: DetectPiiEntitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetectPiiEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetectPiiEntitiesErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetectPiiEntitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetectPiiEntitiesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DetectPiiEntitiesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DetectPiiEntitiesErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            DetectPiiEntitiesErrorKind::UnsupportedLanguageException(_inner) => _inner.fmt(f),
            DetectPiiEntitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetectPiiEntitiesError {
    fn code(&self) -> Option<&str> {
        DetectPiiEntitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetectPiiEntitiesError {
    /// Creates a new `DetectPiiEntitiesError`.
    pub fn new(kind: DetectPiiEntitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetectPiiEntitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetectPiiEntitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetectPiiEntitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetectPiiEntitiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetectPiiEntitiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectPiiEntitiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectPiiEntitiesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectPiiEntitiesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectPiiEntitiesErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectPiiEntitiesErrorKind::TextSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectPiiEntitiesErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectPiiEntitiesErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for DetectPiiEntitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetectPiiEntitiesErrorKind::InternalServerException(_inner) => Some(_inner),
            DetectPiiEntitiesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DetectPiiEntitiesErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            DetectPiiEntitiesErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            DetectPiiEntitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetectSentiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetectSentimentError {
    /// Kind of error that occurred.
    pub kind: DetectSentimentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetectSentiment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetectSentimentErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetectSentimentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetectSentimentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DetectSentimentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DetectSentimentErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            DetectSentimentErrorKind::UnsupportedLanguageException(_inner) => _inner.fmt(f),
            DetectSentimentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetectSentimentError {
    fn code(&self) -> Option<&str> {
        DetectSentimentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetectSentimentError {
    /// Creates a new `DetectSentimentError`.
    pub fn new(kind: DetectSentimentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetectSentimentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetectSentimentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetectSentimentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetectSentimentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetectSentimentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectSentimentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectSentimentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectSentimentErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectSentimentErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectSentimentErrorKind::TextSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectSentimentErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectSentimentErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for DetectSentimentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetectSentimentErrorKind::InternalServerException(_inner) => Some(_inner),
            DetectSentimentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DetectSentimentErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            DetectSentimentErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            DetectSentimentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetectSyntax` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetectSyntaxError {
    /// Kind of error that occurred.
    pub kind: DetectSyntaxErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetectSyntax` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetectSyntaxErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
    UnsupportedLanguageException(crate::error::UnsupportedLanguageException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetectSyntaxError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetectSyntaxErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DetectSyntaxErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DetectSyntaxErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            DetectSyntaxErrorKind::UnsupportedLanguageException(_inner) => _inner.fmt(f),
            DetectSyntaxErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetectSyntaxError {
    fn code(&self) -> Option<&str> {
        DetectSyntaxError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetectSyntaxError {
    /// Creates a new `DetectSyntaxError`.
    pub fn new(kind: DetectSyntaxErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetectSyntaxError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetectSyntaxErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetectSyntaxError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetectSyntaxErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetectSyntaxErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectSyntaxErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectSyntaxErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectSyntaxErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectSyntaxErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectSyntaxErrorKind::TextSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectSyntaxErrorKind::UnsupportedLanguageException`.
    pub fn is_unsupported_language_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectSyntaxErrorKind::UnsupportedLanguageException(_)
        )
    }
}
impl std::error::Error for DetectSyntaxError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetectSyntaxErrorKind::InternalServerException(_inner) => Some(_inner),
            DetectSyntaxErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DetectSyntaxErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            DetectSyntaxErrorKind::UnsupportedLanguageException(_inner) => Some(_inner),
            DetectSyntaxErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportModelError {
    /// Kind of error that occurred.
    pub kind: ImportModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportModelErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The specified resource name is already in use. Use a different name and try your request again.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The maximum number of resources per account has been exceeded. Review the resources, and then try your request again.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available. Check the resource and try your request again.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ImportModelErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ImportModelErrorKind::KmsKeyValidationException(_inner) => _inner.fmt(f),
            ImportModelErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            ImportModelErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            ImportModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ImportModelErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            ImportModelErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ImportModelErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            ImportModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportModelError {
    fn code(&self) -> Option<&str> {
        ImportModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportModelError {
    /// Creates a new `ImportModelError`.
    pub fn new(kind: ImportModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportModelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ImportModelErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ImportModelErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ImportModelErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ImportModelErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportModelErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportModelErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, ImportModelErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `ImportModelErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportModelErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportModelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportModelErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportModelErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportModelErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportModelErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportModelErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, ImportModelErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for ImportModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportModelErrorKind::InternalServerException(_inner) => Some(_inner),
            ImportModelErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ImportModelErrorKind::KmsKeyValidationException(_inner) => Some(_inner),
            ImportModelErrorKind::ResourceInUseException(_inner) => Some(_inner),
            ImportModelErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            ImportModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ImportModelErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            ImportModelErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ImportModelErrorKind::TooManyTagsException(_inner) => Some(_inner),
            ImportModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDocumentClassificationJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDocumentClassificationJobsError {
    /// Kind of error that occurred.
    pub kind: ListDocumentClassificationJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDocumentClassificationJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDocumentClassificationJobsErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDocumentClassificationJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDocumentClassificationJobsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListDocumentClassificationJobsErrorKind::InvalidFilterException(_inner) => {
                _inner.fmt(f)
            }
            ListDocumentClassificationJobsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListDocumentClassificationJobsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListDocumentClassificationJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDocumentClassificationJobsError {
    fn code(&self) -> Option<&str> {
        ListDocumentClassificationJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDocumentClassificationJobsError {
    /// Creates a new `ListDocumentClassificationJobsError`.
    pub fn new(
        kind: ListDocumentClassificationJobsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDocumentClassificationJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDocumentClassificationJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDocumentClassificationJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDocumentClassificationJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDocumentClassificationJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentClassificationJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentClassificationJobsErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentClassificationJobsErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentClassificationJobsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentClassificationJobsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentClassificationJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentClassificationJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListDocumentClassificationJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDocumentClassificationJobsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListDocumentClassificationJobsErrorKind::InvalidFilterException(_inner) => Some(_inner),
            ListDocumentClassificationJobsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListDocumentClassificationJobsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListDocumentClassificationJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDocumentClassifiers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDocumentClassifiersError {
    /// Kind of error that occurred.
    pub kind: ListDocumentClassifiersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDocumentClassifiers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDocumentClassifiersErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDocumentClassifiersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDocumentClassifiersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDocumentClassifiersErrorKind::InvalidFilterException(_inner) => _inner.fmt(f),
            ListDocumentClassifiersErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDocumentClassifiersErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListDocumentClassifiersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDocumentClassifiersError {
    fn code(&self) -> Option<&str> {
        ListDocumentClassifiersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDocumentClassifiersError {
    /// Creates a new `ListDocumentClassifiersError`.
    pub fn new(kind: ListDocumentClassifiersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDocumentClassifiersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDocumentClassifiersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDocumentClassifiersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDocumentClassifiersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDocumentClassifiersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentClassifiersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentClassifiersErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentClassifiersErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentClassifiersErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentClassifiersErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentClassifiersErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentClassifiersErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListDocumentClassifiersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDocumentClassifiersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDocumentClassifiersErrorKind::InvalidFilterException(_inner) => Some(_inner),
            ListDocumentClassifiersErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDocumentClassifiersErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListDocumentClassifiersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDocumentClassifierSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDocumentClassifierSummariesError {
    /// Kind of error that occurred.
    pub kind: ListDocumentClassifierSummariesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDocumentClassifierSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDocumentClassifierSummariesErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDocumentClassifierSummariesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDocumentClassifierSummariesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListDocumentClassifierSummariesErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListDocumentClassifierSummariesErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListDocumentClassifierSummariesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDocumentClassifierSummariesError {
    fn code(&self) -> Option<&str> {
        ListDocumentClassifierSummariesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDocumentClassifierSummariesError {
    /// Creates a new `ListDocumentClassifierSummariesError`.
    pub fn new(
        kind: ListDocumentClassifierSummariesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDocumentClassifierSummariesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDocumentClassifierSummariesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDocumentClassifierSummariesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDocumentClassifierSummariesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDocumentClassifierSummariesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentClassifierSummariesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentClassifierSummariesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentClassifierSummariesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentClassifierSummariesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentClassifierSummariesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListDocumentClassifierSummariesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDocumentClassifierSummariesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListDocumentClassifierSummariesErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListDocumentClassifierSummariesErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListDocumentClassifierSummariesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDominantLanguageDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDominantLanguageDetectionJobsError {
    /// Kind of error that occurred.
    pub kind: ListDominantLanguageDetectionJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDominantLanguageDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDominantLanguageDetectionJobsErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDominantLanguageDetectionJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDominantLanguageDetectionJobsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListDominantLanguageDetectionJobsErrorKind::InvalidFilterException(_inner) => {
                _inner.fmt(f)
            }
            ListDominantLanguageDetectionJobsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListDominantLanguageDetectionJobsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListDominantLanguageDetectionJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDominantLanguageDetectionJobsError {
    fn code(&self) -> Option<&str> {
        ListDominantLanguageDetectionJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDominantLanguageDetectionJobsError {
    /// Creates a new `ListDominantLanguageDetectionJobsError`.
    pub fn new(
        kind: ListDominantLanguageDetectionJobsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDominantLanguageDetectionJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDominantLanguageDetectionJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDominantLanguageDetectionJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDominantLanguageDetectionJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDominantLanguageDetectionJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDominantLanguageDetectionJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDominantLanguageDetectionJobsErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDominantLanguageDetectionJobsErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDominantLanguageDetectionJobsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDominantLanguageDetectionJobsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDominantLanguageDetectionJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDominantLanguageDetectionJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListDominantLanguageDetectionJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDominantLanguageDetectionJobsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListDominantLanguageDetectionJobsErrorKind::InvalidFilterException(_inner) => {
                Some(_inner)
            }
            ListDominantLanguageDetectionJobsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListDominantLanguageDetectionJobsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListDominantLanguageDetectionJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEndpointsError {
    /// Kind of error that occurred.
    pub kind: ListEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEndpointsErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEndpointsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEndpointsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListEndpointsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEndpointsError {
    fn code(&self) -> Option<&str> {
        ListEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEndpointsError {
    /// Creates a new `ListEndpointsError`.
    pub fn new(kind: ListEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEndpointsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEndpointsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEndpointsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEndpointsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEndpointsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEndpointsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEndpointsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEndpointsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListEndpointsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEntitiesDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEntitiesDetectionJobsError {
    /// Kind of error that occurred.
    pub kind: ListEntitiesDetectionJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEntitiesDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEntitiesDetectionJobsErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEntitiesDetectionJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEntitiesDetectionJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEntitiesDetectionJobsErrorKind::InvalidFilterException(_inner) => _inner.fmt(f),
            ListEntitiesDetectionJobsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListEntitiesDetectionJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListEntitiesDetectionJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEntitiesDetectionJobsError {
    fn code(&self) -> Option<&str> {
        ListEntitiesDetectionJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEntitiesDetectionJobsError {
    /// Creates a new `ListEntitiesDetectionJobsError`.
    pub fn new(kind: ListEntitiesDetectionJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEntitiesDetectionJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEntitiesDetectionJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEntitiesDetectionJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEntitiesDetectionJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEntitiesDetectionJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitiesDetectionJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntitiesDetectionJobsErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitiesDetectionJobsErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntitiesDetectionJobsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitiesDetectionJobsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntitiesDetectionJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitiesDetectionJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListEntitiesDetectionJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEntitiesDetectionJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEntitiesDetectionJobsErrorKind::InvalidFilterException(_inner) => Some(_inner),
            ListEntitiesDetectionJobsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListEntitiesDetectionJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListEntitiesDetectionJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEntityRecognizers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEntityRecognizersError {
    /// Kind of error that occurred.
    pub kind: ListEntityRecognizersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEntityRecognizers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEntityRecognizersErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEntityRecognizersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEntityRecognizersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEntityRecognizersErrorKind::InvalidFilterException(_inner) => _inner.fmt(f),
            ListEntityRecognizersErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListEntityRecognizersErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListEntityRecognizersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEntityRecognizersError {
    fn code(&self) -> Option<&str> {
        ListEntityRecognizersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEntityRecognizersError {
    /// Creates a new `ListEntityRecognizersError`.
    pub fn new(kind: ListEntityRecognizersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEntityRecognizersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEntityRecognizersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEntityRecognizersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEntityRecognizersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEntityRecognizersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityRecognizersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntityRecognizersErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityRecognizersErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntityRecognizersErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityRecognizersErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntityRecognizersErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityRecognizersErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListEntityRecognizersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEntityRecognizersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEntityRecognizersErrorKind::InvalidFilterException(_inner) => Some(_inner),
            ListEntityRecognizersErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListEntityRecognizersErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListEntityRecognizersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEntityRecognizerSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEntityRecognizerSummariesError {
    /// Kind of error that occurred.
    pub kind: ListEntityRecognizerSummariesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEntityRecognizerSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEntityRecognizerSummariesErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEntityRecognizerSummariesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEntityRecognizerSummariesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListEntityRecognizerSummariesErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListEntityRecognizerSummariesErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListEntityRecognizerSummariesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEntityRecognizerSummariesError {
    fn code(&self) -> Option<&str> {
        ListEntityRecognizerSummariesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEntityRecognizerSummariesError {
    /// Creates a new `ListEntityRecognizerSummariesError`.
    pub fn new(
        kind: ListEntityRecognizerSummariesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEntityRecognizerSummariesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEntityRecognizerSummariesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEntityRecognizerSummariesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEntityRecognizerSummariesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEntityRecognizerSummariesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityRecognizerSummariesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntityRecognizerSummariesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityRecognizerSummariesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntityRecognizerSummariesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityRecognizerSummariesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListEntityRecognizerSummariesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEntityRecognizerSummariesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEntityRecognizerSummariesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListEntityRecognizerSummariesErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListEntityRecognizerSummariesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEventsDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventsDetectionJobsError {
    /// Kind of error that occurred.
    pub kind: ListEventsDetectionJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEventsDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventsDetectionJobsErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventsDetectionJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventsDetectionJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEventsDetectionJobsErrorKind::InvalidFilterException(_inner) => _inner.fmt(f),
            ListEventsDetectionJobsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListEventsDetectionJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListEventsDetectionJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventsDetectionJobsError {
    fn code(&self) -> Option<&str> {
        ListEventsDetectionJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventsDetectionJobsError {
    /// Creates a new `ListEventsDetectionJobsError`.
    pub fn new(kind: ListEventsDetectionJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventsDetectionJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventsDetectionJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventsDetectionJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventsDetectionJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventsDetectionJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventsDetectionJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventsDetectionJobsErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventsDetectionJobsErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventsDetectionJobsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventsDetectionJobsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventsDetectionJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventsDetectionJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListEventsDetectionJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventsDetectionJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEventsDetectionJobsErrorKind::InvalidFilterException(_inner) => Some(_inner),
            ListEventsDetectionJobsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListEventsDetectionJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListEventsDetectionJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListKeyPhrasesDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListKeyPhrasesDetectionJobsError {
    /// Kind of error that occurred.
    pub kind: ListKeyPhrasesDetectionJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListKeyPhrasesDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListKeyPhrasesDetectionJobsErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListKeyPhrasesDetectionJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListKeyPhrasesDetectionJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListKeyPhrasesDetectionJobsErrorKind::InvalidFilterException(_inner) => _inner.fmt(f),
            ListKeyPhrasesDetectionJobsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListKeyPhrasesDetectionJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListKeyPhrasesDetectionJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListKeyPhrasesDetectionJobsError {
    fn code(&self) -> Option<&str> {
        ListKeyPhrasesDetectionJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListKeyPhrasesDetectionJobsError {
    /// Creates a new `ListKeyPhrasesDetectionJobsError`.
    pub fn new(kind: ListKeyPhrasesDetectionJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListKeyPhrasesDetectionJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListKeyPhrasesDetectionJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListKeyPhrasesDetectionJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListKeyPhrasesDetectionJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListKeyPhrasesDetectionJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListKeyPhrasesDetectionJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListKeyPhrasesDetectionJobsErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListKeyPhrasesDetectionJobsErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListKeyPhrasesDetectionJobsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListKeyPhrasesDetectionJobsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListKeyPhrasesDetectionJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListKeyPhrasesDetectionJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListKeyPhrasesDetectionJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListKeyPhrasesDetectionJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListKeyPhrasesDetectionJobsErrorKind::InvalidFilterException(_inner) => Some(_inner),
            ListKeyPhrasesDetectionJobsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListKeyPhrasesDetectionJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListKeyPhrasesDetectionJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPiiEntitiesDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPiiEntitiesDetectionJobsError {
    /// Kind of error that occurred.
    pub kind: ListPiiEntitiesDetectionJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPiiEntitiesDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPiiEntitiesDetectionJobsErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPiiEntitiesDetectionJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPiiEntitiesDetectionJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPiiEntitiesDetectionJobsErrorKind::InvalidFilterException(_inner) => _inner.fmt(f),
            ListPiiEntitiesDetectionJobsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListPiiEntitiesDetectionJobsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListPiiEntitiesDetectionJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPiiEntitiesDetectionJobsError {
    fn code(&self) -> Option<&str> {
        ListPiiEntitiesDetectionJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPiiEntitiesDetectionJobsError {
    /// Creates a new `ListPiiEntitiesDetectionJobsError`.
    pub fn new(kind: ListPiiEntitiesDetectionJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPiiEntitiesDetectionJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPiiEntitiesDetectionJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPiiEntitiesDetectionJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPiiEntitiesDetectionJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPiiEntitiesDetectionJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPiiEntitiesDetectionJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPiiEntitiesDetectionJobsErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPiiEntitiesDetectionJobsErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPiiEntitiesDetectionJobsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPiiEntitiesDetectionJobsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPiiEntitiesDetectionJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPiiEntitiesDetectionJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListPiiEntitiesDetectionJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPiiEntitiesDetectionJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPiiEntitiesDetectionJobsErrorKind::InvalidFilterException(_inner) => Some(_inner),
            ListPiiEntitiesDetectionJobsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListPiiEntitiesDetectionJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListPiiEntitiesDetectionJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSentimentDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSentimentDetectionJobsError {
    /// Kind of error that occurred.
    pub kind: ListSentimentDetectionJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSentimentDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSentimentDetectionJobsErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSentimentDetectionJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSentimentDetectionJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListSentimentDetectionJobsErrorKind::InvalidFilterException(_inner) => _inner.fmt(f),
            ListSentimentDetectionJobsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListSentimentDetectionJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListSentimentDetectionJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSentimentDetectionJobsError {
    fn code(&self) -> Option<&str> {
        ListSentimentDetectionJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSentimentDetectionJobsError {
    /// Creates a new `ListSentimentDetectionJobsError`.
    pub fn new(kind: ListSentimentDetectionJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSentimentDetectionJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSentimentDetectionJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSentimentDetectionJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSentimentDetectionJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSentimentDetectionJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSentimentDetectionJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSentimentDetectionJobsErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSentimentDetectionJobsErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSentimentDetectionJobsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSentimentDetectionJobsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSentimentDetectionJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSentimentDetectionJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListSentimentDetectionJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSentimentDetectionJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListSentimentDetectionJobsErrorKind::InvalidFilterException(_inner) => Some(_inner),
            ListSentimentDetectionJobsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListSentimentDetectionJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListSentimentDetectionJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTargetedSentimentDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTargetedSentimentDetectionJobsError {
    /// Kind of error that occurred.
    pub kind: ListTargetedSentimentDetectionJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTargetedSentimentDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTargetedSentimentDetectionJobsErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTargetedSentimentDetectionJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTargetedSentimentDetectionJobsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListTargetedSentimentDetectionJobsErrorKind::InvalidFilterException(_inner) => {
                _inner.fmt(f)
            }
            ListTargetedSentimentDetectionJobsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListTargetedSentimentDetectionJobsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListTargetedSentimentDetectionJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTargetedSentimentDetectionJobsError {
    fn code(&self) -> Option<&str> {
        ListTargetedSentimentDetectionJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTargetedSentimentDetectionJobsError {
    /// Creates a new `ListTargetedSentimentDetectionJobsError`.
    pub fn new(
        kind: ListTargetedSentimentDetectionJobsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTargetedSentimentDetectionJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTargetedSentimentDetectionJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTargetedSentimentDetectionJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTargetedSentimentDetectionJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTargetedSentimentDetectionJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetedSentimentDetectionJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTargetedSentimentDetectionJobsErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetedSentimentDetectionJobsErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTargetedSentimentDetectionJobsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetedSentimentDetectionJobsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTargetedSentimentDetectionJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetedSentimentDetectionJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTargetedSentimentDetectionJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTargetedSentimentDetectionJobsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListTargetedSentimentDetectionJobsErrorKind::InvalidFilterException(_inner) => {
                Some(_inner)
            }
            ListTargetedSentimentDetectionJobsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListTargetedSentimentDetectionJobsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListTargetedSentimentDetectionJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTopicsDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTopicsDetectionJobsError {
    /// Kind of error that occurred.
    pub kind: ListTopicsDetectionJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTopicsDetectionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTopicsDetectionJobsErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTopicsDetectionJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTopicsDetectionJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTopicsDetectionJobsErrorKind::InvalidFilterException(_inner) => _inner.fmt(f),
            ListTopicsDetectionJobsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTopicsDetectionJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTopicsDetectionJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTopicsDetectionJobsError {
    fn code(&self) -> Option<&str> {
        ListTopicsDetectionJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTopicsDetectionJobsError {
    /// Creates a new `ListTopicsDetectionJobsError`.
    pub fn new(kind: ListTopicsDetectionJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTopicsDetectionJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTopicsDetectionJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTopicsDetectionJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTopicsDetectionJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTopicsDetectionJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTopicsDetectionJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTopicsDetectionJobsErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTopicsDetectionJobsErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTopicsDetectionJobsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTopicsDetectionJobsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTopicsDetectionJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTopicsDetectionJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTopicsDetectionJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTopicsDetectionJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTopicsDetectionJobsErrorKind::InvalidFilterException(_inner) => Some(_inner),
            ListTopicsDetectionJobsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTopicsDetectionJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTopicsDetectionJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: PutResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourcePolicyErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourcePolicyError {
    fn code(&self) -> Option<&str> {
        PutResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourcePolicyError {
    /// Creates a new `PutResourcePolicyError`.
    pub fn new(kind: PutResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for PutResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDocumentClassificationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDocumentClassificationJobError {
    /// Kind of error that occurred.
    pub kind: StartDocumentClassificationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDocumentClassificationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDocumentClassificationJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available. Check the resource and try your request again.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDocumentClassificationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDocumentClassificationJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            StartDocumentClassificationJobErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            StartDocumentClassificationJobErrorKind::KmsKeyValidationException(_inner) => {
                _inner.fmt(f)
            }
            StartDocumentClassificationJobErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartDocumentClassificationJobErrorKind::ResourceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            StartDocumentClassificationJobErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            StartDocumentClassificationJobErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            StartDocumentClassificationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDocumentClassificationJobError {
    fn code(&self) -> Option<&str> {
        StartDocumentClassificationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDocumentClassificationJobError {
    /// Creates a new `StartDocumentClassificationJobError`.
    pub fn new(
        kind: StartDocumentClassificationJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDocumentClassificationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDocumentClassificationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDocumentClassificationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDocumentClassificationJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartDocumentClassificationJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentClassificationJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentClassificationJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentClassificationJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentClassificationJobErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentClassificationJobErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentClassificationJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentClassificationJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentClassificationJobErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentClassificationJobErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentClassificationJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentClassificationJobErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDocumentClassificationJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDocumentClassificationJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for StartDocumentClassificationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDocumentClassificationJobErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            StartDocumentClassificationJobErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            StartDocumentClassificationJobErrorKind::KmsKeyValidationException(_inner) => {
                Some(_inner)
            }
            StartDocumentClassificationJobErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            StartDocumentClassificationJobErrorKind::ResourceUnavailableException(_inner) => {
                Some(_inner)
            }
            StartDocumentClassificationJobErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            StartDocumentClassificationJobErrorKind::TooManyTagsException(_inner) => Some(_inner),
            StartDocumentClassificationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDominantLanguageDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDominantLanguageDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StartDominantLanguageDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDominantLanguageDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDominantLanguageDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDominantLanguageDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDominantLanguageDetectionJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            StartDominantLanguageDetectionJobErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            StartDominantLanguageDetectionJobErrorKind::KmsKeyValidationException(_inner) => {
                _inner.fmt(f)
            }
            StartDominantLanguageDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            StartDominantLanguageDetectionJobErrorKind::TooManyTagsException(_inner) => {
                _inner.fmt(f)
            }
            StartDominantLanguageDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDominantLanguageDetectionJobError {
    fn code(&self) -> Option<&str> {
        StartDominantLanguageDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDominantLanguageDetectionJobError {
    /// Creates a new `StartDominantLanguageDetectionJobError`.
    pub fn new(
        kind: StartDominantLanguageDetectionJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDominantLanguageDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDominantLanguageDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDominantLanguageDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDominantLanguageDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartDominantLanguageDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDominantLanguageDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDominantLanguageDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDominantLanguageDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDominantLanguageDetectionJobErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDominantLanguageDetectionJobErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDominantLanguageDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDominantLanguageDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDominantLanguageDetectionJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDominantLanguageDetectionJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for StartDominantLanguageDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDominantLanguageDetectionJobErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            StartDominantLanguageDetectionJobErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            StartDominantLanguageDetectionJobErrorKind::KmsKeyValidationException(_inner) => {
                Some(_inner)
            }
            StartDominantLanguageDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            StartDominantLanguageDetectionJobErrorKind::TooManyTagsException(_inner) => {
                Some(_inner)
            }
            StartDominantLanguageDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartEntitiesDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StartEntitiesDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartEntitiesDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available. Check the resource and try your request again.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartEntitiesDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartEntitiesDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartEntitiesDetectionJobErrorKind::KmsKeyValidationException(_inner) => _inner.fmt(f),
            StartEntitiesDetectionJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartEntitiesDetectionJobErrorKind::ResourceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            StartEntitiesDetectionJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StartEntitiesDetectionJobErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            StartEntitiesDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartEntitiesDetectionJobError {
    fn code(&self) -> Option<&str> {
        StartEntitiesDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartEntitiesDetectionJobError {
    /// Creates a new `StartEntitiesDetectionJobError`.
    pub fn new(kind: StartEntitiesDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartEntitiesDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartEntitiesDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartEntitiesDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartEntitiesDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartEntitiesDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEntitiesDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEntitiesDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEntitiesDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEntitiesDetectionJobErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEntitiesDetectionJobErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEntitiesDetectionJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEntitiesDetectionJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEntitiesDetectionJobErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEntitiesDetectionJobErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEntitiesDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEntitiesDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEntitiesDetectionJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEntitiesDetectionJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for StartEntitiesDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartEntitiesDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartEntitiesDetectionJobErrorKind::KmsKeyValidationException(_inner) => Some(_inner),
            StartEntitiesDetectionJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartEntitiesDetectionJobErrorKind::ResourceUnavailableException(_inner) => {
                Some(_inner)
            }
            StartEntitiesDetectionJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartEntitiesDetectionJobErrorKind::TooManyTagsException(_inner) => Some(_inner),
            StartEntitiesDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartEventsDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartEventsDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StartEventsDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartEventsDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartEventsDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartEventsDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartEventsDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartEventsDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartEventsDetectionJobErrorKind::KmsKeyValidationException(_inner) => _inner.fmt(f),
            StartEventsDetectionJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StartEventsDetectionJobErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            StartEventsDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartEventsDetectionJobError {
    fn code(&self) -> Option<&str> {
        StartEventsDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartEventsDetectionJobError {
    /// Creates a new `StartEventsDetectionJobError`.
    pub fn new(kind: StartEventsDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartEventsDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartEventsDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartEventsDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartEventsDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartEventsDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEventsDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEventsDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEventsDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEventsDetectionJobErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEventsDetectionJobErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEventsDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEventsDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEventsDetectionJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEventsDetectionJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for StartEventsDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartEventsDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartEventsDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartEventsDetectionJobErrorKind::KmsKeyValidationException(_inner) => Some(_inner),
            StartEventsDetectionJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartEventsDetectionJobErrorKind::TooManyTagsException(_inner) => Some(_inner),
            StartEventsDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartKeyPhrasesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartKeyPhrasesDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StartKeyPhrasesDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartKeyPhrasesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartKeyPhrasesDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartKeyPhrasesDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartKeyPhrasesDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartKeyPhrasesDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartKeyPhrasesDetectionJobErrorKind::KmsKeyValidationException(_inner) => {
                _inner.fmt(f)
            }
            StartKeyPhrasesDetectionJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StartKeyPhrasesDetectionJobErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            StartKeyPhrasesDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartKeyPhrasesDetectionJobError {
    fn code(&self) -> Option<&str> {
        StartKeyPhrasesDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartKeyPhrasesDetectionJobError {
    /// Creates a new `StartKeyPhrasesDetectionJobError`.
    pub fn new(kind: StartKeyPhrasesDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartKeyPhrasesDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartKeyPhrasesDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartKeyPhrasesDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartKeyPhrasesDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartKeyPhrasesDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartKeyPhrasesDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartKeyPhrasesDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartKeyPhrasesDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartKeyPhrasesDetectionJobErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartKeyPhrasesDetectionJobErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartKeyPhrasesDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartKeyPhrasesDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartKeyPhrasesDetectionJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartKeyPhrasesDetectionJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for StartKeyPhrasesDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartKeyPhrasesDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartKeyPhrasesDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartKeyPhrasesDetectionJobErrorKind::KmsKeyValidationException(_inner) => Some(_inner),
            StartKeyPhrasesDetectionJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartKeyPhrasesDetectionJobErrorKind::TooManyTagsException(_inner) => Some(_inner),
            StartKeyPhrasesDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartPiiEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartPiiEntitiesDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StartPiiEntitiesDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartPiiEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartPiiEntitiesDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartPiiEntitiesDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartPiiEntitiesDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartPiiEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartPiiEntitiesDetectionJobErrorKind::KmsKeyValidationException(_inner) => {
                _inner.fmt(f)
            }
            StartPiiEntitiesDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            StartPiiEntitiesDetectionJobErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            StartPiiEntitiesDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartPiiEntitiesDetectionJobError {
    fn code(&self) -> Option<&str> {
        StartPiiEntitiesDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartPiiEntitiesDetectionJobError {
    /// Creates a new `StartPiiEntitiesDetectionJobError`.
    pub fn new(kind: StartPiiEntitiesDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartPiiEntitiesDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartPiiEntitiesDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartPiiEntitiesDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartPiiEntitiesDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartPiiEntitiesDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPiiEntitiesDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartPiiEntitiesDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPiiEntitiesDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartPiiEntitiesDetectionJobErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPiiEntitiesDetectionJobErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartPiiEntitiesDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPiiEntitiesDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartPiiEntitiesDetectionJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPiiEntitiesDetectionJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for StartPiiEntitiesDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartPiiEntitiesDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartPiiEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartPiiEntitiesDetectionJobErrorKind::KmsKeyValidationException(_inner) => {
                Some(_inner)
            }
            StartPiiEntitiesDetectionJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartPiiEntitiesDetectionJobErrorKind::TooManyTagsException(_inner) => Some(_inner),
            StartPiiEntitiesDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartSentimentDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StartSentimentDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartSentimentDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartSentimentDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartSentimentDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartSentimentDetectionJobErrorKind::KmsKeyValidationException(_inner) => _inner.fmt(f),
            StartSentimentDetectionJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StartSentimentDetectionJobErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            StartSentimentDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartSentimentDetectionJobError {
    fn code(&self) -> Option<&str> {
        StartSentimentDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartSentimentDetectionJobError {
    /// Creates a new `StartSentimentDetectionJobError`.
    pub fn new(kind: StartSentimentDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartSentimentDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartSentimentDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartSentimentDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartSentimentDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartSentimentDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSentimentDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSentimentDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSentimentDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSentimentDetectionJobErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSentimentDetectionJobErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSentimentDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSentimentDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSentimentDetectionJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSentimentDetectionJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for StartSentimentDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartSentimentDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartSentimentDetectionJobErrorKind::KmsKeyValidationException(_inner) => Some(_inner),
            StartSentimentDetectionJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartSentimentDetectionJobErrorKind::TooManyTagsException(_inner) => Some(_inner),
            StartSentimentDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartTargetedSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartTargetedSentimentDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StartTargetedSentimentDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartTargetedSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartTargetedSentimentDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartTargetedSentimentDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartTargetedSentimentDetectionJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            StartTargetedSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            StartTargetedSentimentDetectionJobErrorKind::KmsKeyValidationException(_inner) => {
                _inner.fmt(f)
            }
            StartTargetedSentimentDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            StartTargetedSentimentDetectionJobErrorKind::TooManyTagsException(_inner) => {
                _inner.fmt(f)
            }
            StartTargetedSentimentDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartTargetedSentimentDetectionJobError {
    fn code(&self) -> Option<&str> {
        StartTargetedSentimentDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartTargetedSentimentDetectionJobError {
    /// Creates a new `StartTargetedSentimentDetectionJobError`.
    pub fn new(
        kind: StartTargetedSentimentDetectionJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartTargetedSentimentDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartTargetedSentimentDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartTargetedSentimentDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartTargetedSentimentDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartTargetedSentimentDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTargetedSentimentDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTargetedSentimentDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTargetedSentimentDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTargetedSentimentDetectionJobErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTargetedSentimentDetectionJobErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTargetedSentimentDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTargetedSentimentDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTargetedSentimentDetectionJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTargetedSentimentDetectionJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for StartTargetedSentimentDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartTargetedSentimentDetectionJobErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            StartTargetedSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            StartTargetedSentimentDetectionJobErrorKind::KmsKeyValidationException(_inner) => {
                Some(_inner)
            }
            StartTargetedSentimentDetectionJobErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            StartTargetedSentimentDetectionJobErrorKind::TooManyTagsException(_inner) => {
                Some(_inner)
            }
            StartTargetedSentimentDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartTopicsDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartTopicsDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StartTopicsDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartTopicsDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartTopicsDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
    KmsKeyValidationException(crate::error::KmsKeyValidationException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartTopicsDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartTopicsDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartTopicsDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartTopicsDetectionJobErrorKind::KmsKeyValidationException(_inner) => _inner.fmt(f),
            StartTopicsDetectionJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StartTopicsDetectionJobErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            StartTopicsDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartTopicsDetectionJobError {
    fn code(&self) -> Option<&str> {
        StartTopicsDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartTopicsDetectionJobError {
    /// Creates a new `StartTopicsDetectionJobError`.
    pub fn new(kind: StartTopicsDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartTopicsDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartTopicsDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartTopicsDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartTopicsDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartTopicsDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTopicsDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTopicsDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTopicsDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTopicsDetectionJobErrorKind::KmsKeyValidationException`.
    pub fn is_kms_key_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTopicsDetectionJobErrorKind::KmsKeyValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTopicsDetectionJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTopicsDetectionJobErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTopicsDetectionJobErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTopicsDetectionJobErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for StartTopicsDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartTopicsDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartTopicsDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartTopicsDetectionJobErrorKind::KmsKeyValidationException(_inner) => Some(_inner),
            StartTopicsDetectionJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartTopicsDetectionJobErrorKind::TooManyTagsException(_inner) => Some(_inner),
            StartTopicsDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopDominantLanguageDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopDominantLanguageDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StopDominantLanguageDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopDominantLanguageDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopDominantLanguageDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopDominantLanguageDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopDominantLanguageDetectionJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            StopDominantLanguageDetectionJobErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            StopDominantLanguageDetectionJobErrorKind::JobNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StopDominantLanguageDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopDominantLanguageDetectionJobError {
    fn code(&self) -> Option<&str> {
        StopDominantLanguageDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopDominantLanguageDetectionJobError {
    /// Creates a new `StopDominantLanguageDetectionJobError`.
    pub fn new(
        kind: StopDominantLanguageDetectionJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopDominantLanguageDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopDominantLanguageDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopDominantLanguageDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopDominantLanguageDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopDominantLanguageDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDominantLanguageDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopDominantLanguageDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDominantLanguageDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopDominantLanguageDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDominantLanguageDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
}
impl std::error::Error for StopDominantLanguageDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopDominantLanguageDetectionJobErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            StopDominantLanguageDetectionJobErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            StopDominantLanguageDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            StopDominantLanguageDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopEntitiesDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StopEntitiesDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopEntitiesDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopEntitiesDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopEntitiesDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopEntitiesDetectionJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            StopEntitiesDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopEntitiesDetectionJobError {
    fn code(&self) -> Option<&str> {
        StopEntitiesDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopEntitiesDetectionJobError {
    /// Creates a new `StopEntitiesDetectionJobError`.
    pub fn new(kind: StopEntitiesDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopEntitiesDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopEntitiesDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopEntitiesDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopEntitiesDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopEntitiesDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopEntitiesDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopEntitiesDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopEntitiesDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopEntitiesDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopEntitiesDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
}
impl std::error::Error for StopEntitiesDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopEntitiesDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StopEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopEntitiesDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            StopEntitiesDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopEventsDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopEventsDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StopEventsDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopEventsDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopEventsDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopEventsDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopEventsDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopEventsDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopEventsDetectionJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            StopEventsDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopEventsDetectionJobError {
    fn code(&self) -> Option<&str> {
        StopEventsDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopEventsDetectionJobError {
    /// Creates a new `StopEventsDetectionJobError`.
    pub fn new(kind: StopEventsDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopEventsDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopEventsDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopEventsDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopEventsDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopEventsDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopEventsDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopEventsDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopEventsDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopEventsDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopEventsDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
}
impl std::error::Error for StopEventsDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopEventsDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StopEventsDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopEventsDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            StopEventsDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopKeyPhrasesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopKeyPhrasesDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StopKeyPhrasesDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopKeyPhrasesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopKeyPhrasesDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopKeyPhrasesDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopKeyPhrasesDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopKeyPhrasesDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopKeyPhrasesDetectionJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            StopKeyPhrasesDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopKeyPhrasesDetectionJobError {
    fn code(&self) -> Option<&str> {
        StopKeyPhrasesDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopKeyPhrasesDetectionJobError {
    /// Creates a new `StopKeyPhrasesDetectionJobError`.
    pub fn new(kind: StopKeyPhrasesDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopKeyPhrasesDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopKeyPhrasesDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopKeyPhrasesDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopKeyPhrasesDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopKeyPhrasesDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopKeyPhrasesDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopKeyPhrasesDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopKeyPhrasesDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopKeyPhrasesDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopKeyPhrasesDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
}
impl std::error::Error for StopKeyPhrasesDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopKeyPhrasesDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StopKeyPhrasesDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopKeyPhrasesDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            StopKeyPhrasesDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopPiiEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopPiiEntitiesDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StopPiiEntitiesDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopPiiEntitiesDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopPiiEntitiesDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopPiiEntitiesDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopPiiEntitiesDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopPiiEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopPiiEntitiesDetectionJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            StopPiiEntitiesDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopPiiEntitiesDetectionJobError {
    fn code(&self) -> Option<&str> {
        StopPiiEntitiesDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopPiiEntitiesDetectionJobError {
    /// Creates a new `StopPiiEntitiesDetectionJobError`.
    pub fn new(kind: StopPiiEntitiesDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopPiiEntitiesDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopPiiEntitiesDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopPiiEntitiesDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopPiiEntitiesDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopPiiEntitiesDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopPiiEntitiesDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopPiiEntitiesDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopPiiEntitiesDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopPiiEntitiesDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopPiiEntitiesDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
}
impl std::error::Error for StopPiiEntitiesDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopPiiEntitiesDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StopPiiEntitiesDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopPiiEntitiesDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            StopPiiEntitiesDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopSentimentDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StopSentimentDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopSentimentDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopSentimentDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopSentimentDetectionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopSentimentDetectionJobErrorKind::JobNotFoundException(_inner) => _inner.fmt(f),
            StopSentimentDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopSentimentDetectionJobError {
    fn code(&self) -> Option<&str> {
        StopSentimentDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopSentimentDetectionJobError {
    /// Creates a new `StopSentimentDetectionJobError`.
    pub fn new(kind: StopSentimentDetectionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopSentimentDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopSentimentDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopSentimentDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopSentimentDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopSentimentDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopSentimentDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopSentimentDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopSentimentDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopSentimentDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopSentimentDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
}
impl std::error::Error for StopSentimentDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopSentimentDetectionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StopSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopSentimentDetectionJobErrorKind::JobNotFoundException(_inner) => Some(_inner),
            StopSentimentDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopTargetedSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopTargetedSentimentDetectionJobError {
    /// Kind of error that occurred.
    pub kind: StopTargetedSentimentDetectionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopTargetedSentimentDetectionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopTargetedSentimentDetectionJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified job was not found. Check the job ID and try again.</p>
    JobNotFoundException(crate::error::JobNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopTargetedSentimentDetectionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopTargetedSentimentDetectionJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            StopTargetedSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            StopTargetedSentimentDetectionJobErrorKind::JobNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StopTargetedSentimentDetectionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopTargetedSentimentDetectionJobError {
    fn code(&self) -> Option<&str> {
        StopTargetedSentimentDetectionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopTargetedSentimentDetectionJobError {
    /// Creates a new `StopTargetedSentimentDetectionJobError`.
    pub fn new(
        kind: StopTargetedSentimentDetectionJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopTargetedSentimentDetectionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopTargetedSentimentDetectionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopTargetedSentimentDetectionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopTargetedSentimentDetectionJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopTargetedSentimentDetectionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTargetedSentimentDetectionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTargetedSentimentDetectionJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTargetedSentimentDetectionJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTargetedSentimentDetectionJobErrorKind::JobNotFoundException`.
    pub fn is_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTargetedSentimentDetectionJobErrorKind::JobNotFoundException(_)
        )
    }
}
impl std::error::Error for StopTargetedSentimentDetectionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopTargetedSentimentDetectionJobErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            StopTargetedSentimentDetectionJobErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            StopTargetedSentimentDetectionJobErrorKind::JobNotFoundException(_inner) => {
                Some(_inner)
            }
            StopTargetedSentimentDetectionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopTrainingDocumentClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopTrainingDocumentClassifierError {
    /// Kind of error that occurred.
    pub kind: StopTrainingDocumentClassifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopTrainingDocumentClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopTrainingDocumentClassifierErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopTrainingDocumentClassifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopTrainingDocumentClassifierErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            StopTrainingDocumentClassifierErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            StopTrainingDocumentClassifierErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StopTrainingDocumentClassifierErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            StopTrainingDocumentClassifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopTrainingDocumentClassifierError {
    fn code(&self) -> Option<&str> {
        StopTrainingDocumentClassifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopTrainingDocumentClassifierError {
    /// Creates a new `StopTrainingDocumentClassifierError`.
    pub fn new(
        kind: StopTrainingDocumentClassifierErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopTrainingDocumentClassifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopTrainingDocumentClassifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopTrainingDocumentClassifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopTrainingDocumentClassifierErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopTrainingDocumentClassifierErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTrainingDocumentClassifierErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTrainingDocumentClassifierErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTrainingDocumentClassifierErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTrainingDocumentClassifierErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTrainingDocumentClassifierErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTrainingDocumentClassifierErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTrainingDocumentClassifierErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for StopTrainingDocumentClassifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopTrainingDocumentClassifierErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            StopTrainingDocumentClassifierErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            StopTrainingDocumentClassifierErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            StopTrainingDocumentClassifierErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            StopTrainingDocumentClassifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopTrainingEntityRecognizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopTrainingEntityRecognizerError {
    /// Kind of error that occurred.
    pub kind: StopTrainingEntityRecognizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopTrainingEntityRecognizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopTrainingEntityRecognizerErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopTrainingEntityRecognizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopTrainingEntityRecognizerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopTrainingEntityRecognizerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopTrainingEntityRecognizerErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StopTrainingEntityRecognizerErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            StopTrainingEntityRecognizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopTrainingEntityRecognizerError {
    fn code(&self) -> Option<&str> {
        StopTrainingEntityRecognizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopTrainingEntityRecognizerError {
    /// Creates a new `StopTrainingEntityRecognizerError`.
    pub fn new(kind: StopTrainingEntityRecognizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopTrainingEntityRecognizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopTrainingEntityRecognizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopTrainingEntityRecognizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopTrainingEntityRecognizerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopTrainingEntityRecognizerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTrainingEntityRecognizerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTrainingEntityRecognizerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTrainingEntityRecognizerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTrainingEntityRecognizerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTrainingEntityRecognizerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTrainingEntityRecognizerErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTrainingEntityRecognizerErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for StopTrainingEntityRecognizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopTrainingEntityRecognizerErrorKind::InternalServerException(_inner) => Some(_inner),
            StopTrainingEntityRecognizerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopTrainingEntityRecognizerErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            StopTrainingEntityRecognizerErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StopTrainingEntityRecognizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains more tag keys than can be associated with a resource (50 tag keys per resource).</p>
    TooManyTagKeysException(crate::error::TooManyTagKeysException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyTagKeysException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyTagKeysException`.
    pub fn is_too_many_tag_keys_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TooManyTagKeysException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyTagKeysException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEndpointError {
    /// Kind of error that occurred.
    pub kind: UpdateEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEndpointErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource name is already in use. Use a different name and try your request again.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The maximum number of resources per account has been exceeded. Review the resources, and then try your request again.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource is not available. Check the resource and try your request again.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEndpointErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEndpointError {
    fn code(&self) -> Option<&str> {
        UpdateEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEndpointError {
    /// Creates a new `UpdateEndpointError`.
    pub fn new(kind: UpdateEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEndpointErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEndpointErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The number of requests exceeds the limit. Resubmit your request later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>The specified resource is not available. Check the resource and try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceUnavailableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceUnavailableException {}
/// See [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
pub mod resource_unavailable_exception {
    /// A builder for [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
        pub fn build(self) -> crate::error::ResourceUnavailableException {
            crate::error::ResourceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ResourceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
    pub fn builder() -> crate::error::resource_unavailable_exception::Builder {
        crate::error::resource_unavailable_exception::Builder::default()
    }
}

/// <p>The specified resource ARN was not found. Check the ARN and try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The maximum number of resources per account has been exceeded. Review the resources, and then try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceLimitExceededException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceLimitExceededException {}
/// See [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
pub mod resource_limit_exceeded_exception {
    /// A builder for [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
        pub fn build(self) -> crate::error::ResourceLimitExceededException {
            crate::error::ResourceLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ResourceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    pub fn builder() -> crate::error::resource_limit_exceeded_exception::Builder {
        crate::error::resource_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The specified resource name is already in use. Use a different name and try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>The request is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>An internal server error occurred. Retry your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The request contains more tag keys than can be associated with a resource (50 tag keys per resource).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagKeysException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagKeysException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagKeysException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagKeysException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagKeysException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagKeysException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagKeysException {}
/// See [`TooManyTagKeysException`](crate::error::TooManyTagKeysException)
pub mod too_many_tag_keys_exception {
    /// A builder for [`TooManyTagKeysException`](crate::error::TooManyTagKeysException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagKeysException`](crate::error::TooManyTagKeysException)
        pub fn build(self) -> crate::error::TooManyTagKeysException {
            crate::error::TooManyTagKeysException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagKeysException {
    /// Creates a new builder-style object to manufacture [`TooManyTagKeysException`](crate::error::TooManyTagKeysException)
    pub fn builder() -> crate::error::too_many_tag_keys_exception::Builder {
        crate::error::too_many_tag_keys_exception::Builder::default()
    }
}

/// <p>Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The specified job was not found. Check the job ID and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JobNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl JobNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for JobNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "JobNotFoundException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for JobNotFoundException {}
/// See [`JobNotFoundException`](crate::error::JobNotFoundException)
pub mod job_not_found_exception {
    /// A builder for [`JobNotFoundException`](crate::error::JobNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`JobNotFoundException`](crate::error::JobNotFoundException)
        pub fn build(self) -> crate::error::JobNotFoundException {
            crate::error::JobNotFoundException {
                message: self.message,
            }
        }
    }
}
impl JobNotFoundException {
    /// Creates a new builder-style object to manufacture [`JobNotFoundException`](crate::error::JobNotFoundException)
    pub fn builder() -> crate::error::job_not_found_exception::Builder {
        crate::error::job_not_found_exception::Builder::default()
    }
}

/// <p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsKeyValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsKeyValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsKeyValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsKeyValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsKeyValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsKeyValidationException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsKeyValidationException {}
/// See [`KmsKeyValidationException`](crate::error::KmsKeyValidationException)
pub mod kms_key_validation_exception {
    /// A builder for [`KmsKeyValidationException`](crate::error::KmsKeyValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsKeyValidationException`](crate::error::KmsKeyValidationException)
        pub fn build(self) -> crate::error::KmsKeyValidationException {
            crate::error::KmsKeyValidationException {
                message: self.message,
            }
        }
    }
}
impl KmsKeyValidationException {
    /// Creates a new builder-style object to manufacture [`KmsKeyValidationException`](crate::error::KmsKeyValidationException)
    pub fn builder() -> crate::error::kms_key_validation_exception::Builder {
        crate::error::kms_key_validation_exception::Builder::default()
    }
}

/// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidFilterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidFilterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidFilterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidFilterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidFilterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidFilterException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidFilterException {}
/// See [`InvalidFilterException`](crate::error::InvalidFilterException)
pub mod invalid_filter_exception {
    /// A builder for [`InvalidFilterException`](crate::error::InvalidFilterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidFilterException`](crate::error::InvalidFilterException)
        pub fn build(self) -> crate::error::InvalidFilterException {
            crate::error::InvalidFilterException {
                message: self.message,
            }
        }
    }
}
impl InvalidFilterException {
    /// Creates a new builder-style object to manufacture [`InvalidFilterException`](crate::error::InvalidFilterException)
    pub fn builder() -> crate::error::invalid_filter_exception::Builder {
        crate::error::invalid_filter_exception::Builder::default()
    }
}

/// <p>Amazon Comprehend can't process the language of the input text. For custom entity recognition APIs, only English, Spanish, French, Italian, German, or Portuguese are accepted. For a list of supported languages, see <code>supported-languages</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedLanguageException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedLanguageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedLanguageException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedLanguageException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedLanguageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedLanguageException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedLanguageException {}
/// See [`UnsupportedLanguageException`](crate::error::UnsupportedLanguageException)
pub mod unsupported_language_exception {
    /// A builder for [`UnsupportedLanguageException`](crate::error::UnsupportedLanguageException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedLanguageException`](crate::error::UnsupportedLanguageException)
        pub fn build(self) -> crate::error::UnsupportedLanguageException {
            crate::error::UnsupportedLanguageException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedLanguageException {
    /// Creates a new builder-style object to manufacture [`UnsupportedLanguageException`](crate::error::UnsupportedLanguageException)
    pub fn builder() -> crate::error::unsupported_language_exception::Builder {
        crate::error::unsupported_language_exception::Builder::default()
    }
}

/// <p>The size of the input text exceeds the limit. Use a smaller document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextSizeLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TextSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextSizeLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TextSizeLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TextSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TextSizeLimitExceededException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for TextSizeLimitExceededException {}
/// See [`TextSizeLimitExceededException`](crate::error::TextSizeLimitExceededException)
pub mod text_size_limit_exceeded_exception {
    /// A builder for [`TextSizeLimitExceededException`](crate::error::TextSizeLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TextSizeLimitExceededException`](crate::error::TextSizeLimitExceededException)
        pub fn build(self) -> crate::error::TextSizeLimitExceededException {
            crate::error::TextSizeLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl TextSizeLimitExceededException {
    /// Creates a new builder-style object to manufacture [`TextSizeLimitExceededException`](crate::error::TextSizeLimitExceededException)
    pub fn builder() -> crate::error::text_size_limit_exceeded_exception::Builder {
        crate::error::text_size_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The number of documents in the request exceeds the limit of 25. Try your request again with fewer documents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchSizeLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchSizeLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BatchSizeLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BatchSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BatchSizeLimitExceededException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for BatchSizeLimitExceededException {}
/// See [`BatchSizeLimitExceededException`](crate::error::BatchSizeLimitExceededException)
pub mod batch_size_limit_exceeded_exception {
    /// A builder for [`BatchSizeLimitExceededException`](crate::error::BatchSizeLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchSizeLimitExceededException`](crate::error::BatchSizeLimitExceededException)
        pub fn build(self) -> crate::error::BatchSizeLimitExceededException {
            crate::error::BatchSizeLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl BatchSizeLimitExceededException {
    /// Creates a new builder-style object to manufacture [`BatchSizeLimitExceededException`](crate::error::BatchSizeLimitExceededException)
    pub fn builder() -> crate::error::batch_size_limit_exceeded_exception::Builder {
        crate::error::batch_size_limit_exceeded_exception::Builder::default()
    }
}
