// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchDetectDominantLanguage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_detect_dominant_language`](crate::client::Client::batch_detect_dominant_language).
///
/// See [`crate::client::fluent_builders::BatchDetectDominantLanguage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDetectDominantLanguage {
    _private: (),
}
impl BatchDetectDominantLanguage {
    /// Creates a new builder-style object to manufacture [`BatchDetectDominantLanguageInput`](crate::input::BatchDetectDominantLanguageInput)
    pub fn builder() -> crate::input::batch_detect_dominant_language_input::Builder {
        crate::input::batch_detect_dominant_language_input::Builder::default()
    }
    /// Creates a new `BatchDetectDominantLanguage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDetectDominantLanguage {
    type Output = std::result::Result<
        crate::output::BatchDetectDominantLanguageOutput,
        crate::error::BatchDetectDominantLanguageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_detect_dominant_language_error(response)
        } else {
            crate::operation_deser::parse_batch_detect_dominant_language_response(response)
        }
    }
}

/// Operation shape for `BatchDetectEntities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_detect_entities`](crate::client::Client::batch_detect_entities).
///
/// See [`crate::client::fluent_builders::BatchDetectEntities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDetectEntities {
    _private: (),
}
impl BatchDetectEntities {
    /// Creates a new builder-style object to manufacture [`BatchDetectEntitiesInput`](crate::input::BatchDetectEntitiesInput)
    pub fn builder() -> crate::input::batch_detect_entities_input::Builder {
        crate::input::batch_detect_entities_input::Builder::default()
    }
    /// Creates a new `BatchDetectEntities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDetectEntities {
    type Output = std::result::Result<
        crate::output::BatchDetectEntitiesOutput,
        crate::error::BatchDetectEntitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_detect_entities_error(response)
        } else {
            crate::operation_deser::parse_batch_detect_entities_response(response)
        }
    }
}

/// Operation shape for `BatchDetectKeyPhrases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_detect_key_phrases`](crate::client::Client::batch_detect_key_phrases).
///
/// See [`crate::client::fluent_builders::BatchDetectKeyPhrases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDetectKeyPhrases {
    _private: (),
}
impl BatchDetectKeyPhrases {
    /// Creates a new builder-style object to manufacture [`BatchDetectKeyPhrasesInput`](crate::input::BatchDetectKeyPhrasesInput)
    pub fn builder() -> crate::input::batch_detect_key_phrases_input::Builder {
        crate::input::batch_detect_key_phrases_input::Builder::default()
    }
    /// Creates a new `BatchDetectKeyPhrases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDetectKeyPhrases {
    type Output = std::result::Result<
        crate::output::BatchDetectKeyPhrasesOutput,
        crate::error::BatchDetectKeyPhrasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_detect_key_phrases_error(response)
        } else {
            crate::operation_deser::parse_batch_detect_key_phrases_response(response)
        }
    }
}

/// Operation shape for `BatchDetectSentiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_detect_sentiment`](crate::client::Client::batch_detect_sentiment).
///
/// See [`crate::client::fluent_builders::BatchDetectSentiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDetectSentiment {
    _private: (),
}
impl BatchDetectSentiment {
    /// Creates a new builder-style object to manufacture [`BatchDetectSentimentInput`](crate::input::BatchDetectSentimentInput)
    pub fn builder() -> crate::input::batch_detect_sentiment_input::Builder {
        crate::input::batch_detect_sentiment_input::Builder::default()
    }
    /// Creates a new `BatchDetectSentiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDetectSentiment {
    type Output = std::result::Result<
        crate::output::BatchDetectSentimentOutput,
        crate::error::BatchDetectSentimentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_detect_sentiment_error(response)
        } else {
            crate::operation_deser::parse_batch_detect_sentiment_response(response)
        }
    }
}

/// Operation shape for `BatchDetectSyntax`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_detect_syntax`](crate::client::Client::batch_detect_syntax).
///
/// See [`crate::client::fluent_builders::BatchDetectSyntax`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDetectSyntax {
    _private: (),
}
impl BatchDetectSyntax {
    /// Creates a new builder-style object to manufacture [`BatchDetectSyntaxInput`](crate::input::BatchDetectSyntaxInput)
    pub fn builder() -> crate::input::batch_detect_syntax_input::Builder {
        crate::input::batch_detect_syntax_input::Builder::default()
    }
    /// Creates a new `BatchDetectSyntax` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDetectSyntax {
    type Output = std::result::Result<
        crate::output::BatchDetectSyntaxOutput,
        crate::error::BatchDetectSyntaxError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_detect_syntax_error(response)
        } else {
            crate::operation_deser::parse_batch_detect_syntax_response(response)
        }
    }
}

/// Operation shape for `ClassifyDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`classify_document`](crate::client::Client::classify_document).
///
/// See [`crate::client::fluent_builders::ClassifyDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ClassifyDocument {
    _private: (),
}
impl ClassifyDocument {
    /// Creates a new builder-style object to manufacture [`ClassifyDocumentInput`](crate::input::ClassifyDocumentInput)
    pub fn builder() -> crate::input::classify_document_input::Builder {
        crate::input::classify_document_input::Builder::default()
    }
    /// Creates a new `ClassifyDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ClassifyDocument {
    type Output = std::result::Result<
        crate::output::ClassifyDocumentOutput,
        crate::error::ClassifyDocumentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_classify_document_error(response)
        } else {
            crate::operation_deser::parse_classify_document_response(response)
        }
    }
}

/// Operation shape for `ContainsPiiEntities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`contains_pii_entities`](crate::client::Client::contains_pii_entities).
///
/// See [`crate::client::fluent_builders::ContainsPiiEntities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ContainsPiiEntities {
    _private: (),
}
impl ContainsPiiEntities {
    /// Creates a new builder-style object to manufacture [`ContainsPiiEntitiesInput`](crate::input::ContainsPiiEntitiesInput)
    pub fn builder() -> crate::input::contains_pii_entities_input::Builder {
        crate::input::contains_pii_entities_input::Builder::default()
    }
    /// Creates a new `ContainsPiiEntities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ContainsPiiEntities {
    type Output = std::result::Result<
        crate::output::ContainsPiiEntitiesOutput,
        crate::error::ContainsPiiEntitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_contains_pii_entities_error(response)
        } else {
            crate::operation_deser::parse_contains_pii_entities_response(response)
        }
    }
}

/// Operation shape for `CreateDocumentClassifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_document_classifier`](crate::client::Client::create_document_classifier).
///
/// See [`crate::client::fluent_builders::CreateDocumentClassifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDocumentClassifier {
    _private: (),
}
impl CreateDocumentClassifier {
    /// Creates a new builder-style object to manufacture [`CreateDocumentClassifierInput`](crate::input::CreateDocumentClassifierInput)
    pub fn builder() -> crate::input::create_document_classifier_input::Builder {
        crate::input::create_document_classifier_input::Builder::default()
    }
    /// Creates a new `CreateDocumentClassifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDocumentClassifier {
    type Output = std::result::Result<
        crate::output::CreateDocumentClassifierOutput,
        crate::error::CreateDocumentClassifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_document_classifier_error(response)
        } else {
            crate::operation_deser::parse_create_document_classifier_response(response)
        }
    }
}

/// Operation shape for `CreateEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_endpoint`](crate::client::Client::create_endpoint).
///
/// See [`crate::client::fluent_builders::CreateEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEndpoint {
    _private: (),
}
impl CreateEndpoint {
    /// Creates a new builder-style object to manufacture [`CreateEndpointInput`](crate::input::CreateEndpointInput)
    pub fn builder() -> crate::input::create_endpoint_input::Builder {
        crate::input::create_endpoint_input::Builder::default()
    }
    /// Creates a new `CreateEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEndpoint {
    type Output =
        std::result::Result<crate::output::CreateEndpointOutput, crate::error::CreateEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_endpoint_error(response)
        } else {
            crate::operation_deser::parse_create_endpoint_response(response)
        }
    }
}

/// Operation shape for `CreateEntityRecognizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_entity_recognizer`](crate::client::Client::create_entity_recognizer).
///
/// See [`crate::client::fluent_builders::CreateEntityRecognizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEntityRecognizer {
    _private: (),
}
impl CreateEntityRecognizer {
    /// Creates a new builder-style object to manufacture [`CreateEntityRecognizerInput`](crate::input::CreateEntityRecognizerInput)
    pub fn builder() -> crate::input::create_entity_recognizer_input::Builder {
        crate::input::create_entity_recognizer_input::Builder::default()
    }
    /// Creates a new `CreateEntityRecognizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEntityRecognizer {
    type Output = std::result::Result<
        crate::output::CreateEntityRecognizerOutput,
        crate::error::CreateEntityRecognizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_entity_recognizer_error(response)
        } else {
            crate::operation_deser::parse_create_entity_recognizer_response(response)
        }
    }
}

/// Operation shape for `DeleteDocumentClassifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_document_classifier`](crate::client::Client::delete_document_classifier).
///
/// See [`crate::client::fluent_builders::DeleteDocumentClassifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDocumentClassifier {
    _private: (),
}
impl DeleteDocumentClassifier {
    /// Creates a new builder-style object to manufacture [`DeleteDocumentClassifierInput`](crate::input::DeleteDocumentClassifierInput)
    pub fn builder() -> crate::input::delete_document_classifier_input::Builder {
        crate::input::delete_document_classifier_input::Builder::default()
    }
    /// Creates a new `DeleteDocumentClassifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDocumentClassifier {
    type Output = std::result::Result<
        crate::output::DeleteDocumentClassifierOutput,
        crate::error::DeleteDocumentClassifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_document_classifier_error(response)
        } else {
            crate::operation_deser::parse_delete_document_classifier_response(response)
        }
    }
}

/// Operation shape for `DeleteEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_endpoint`](crate::client::Client::delete_endpoint).
///
/// See [`crate::client::fluent_builders::DeleteEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEndpoint {
    _private: (),
}
impl DeleteEndpoint {
    /// Creates a new builder-style object to manufacture [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    pub fn builder() -> crate::input::delete_endpoint_input::Builder {
        crate::input::delete_endpoint_input::Builder::default()
    }
    /// Creates a new `DeleteEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEndpoint {
    type Output =
        std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_endpoint_error(response)
        } else {
            crate::operation_deser::parse_delete_endpoint_response(response)
        }
    }
}

/// Operation shape for `DeleteEntityRecognizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_entity_recognizer`](crate::client::Client::delete_entity_recognizer).
///
/// See [`crate::client::fluent_builders::DeleteEntityRecognizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEntityRecognizer {
    _private: (),
}
impl DeleteEntityRecognizer {
    /// Creates a new builder-style object to manufacture [`DeleteEntityRecognizerInput`](crate::input::DeleteEntityRecognizerInput)
    pub fn builder() -> crate::input::delete_entity_recognizer_input::Builder {
        crate::input::delete_entity_recognizer_input::Builder::default()
    }
    /// Creates a new `DeleteEntityRecognizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEntityRecognizer {
    type Output = std::result::Result<
        crate::output::DeleteEntityRecognizerOutput,
        crate::error::DeleteEntityRecognizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_entity_recognizer_error(response)
        } else {
            crate::operation_deser::parse_delete_entity_recognizer_response(response)
        }
    }
}

/// Operation shape for `DescribeDocumentClassificationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_document_classification_job`](crate::client::Client::describe_document_classification_job).
///
/// See [`crate::client::fluent_builders::DescribeDocumentClassificationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDocumentClassificationJob {
    _private: (),
}
impl DescribeDocumentClassificationJob {
    /// Creates a new builder-style object to manufacture [`DescribeDocumentClassificationJobInput`](crate::input::DescribeDocumentClassificationJobInput)
    pub fn builder() -> crate::input::describe_document_classification_job_input::Builder {
        crate::input::describe_document_classification_job_input::Builder::default()
    }
    /// Creates a new `DescribeDocumentClassificationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDocumentClassificationJob {
    type Output = std::result::Result<
        crate::output::DescribeDocumentClassificationJobOutput,
        crate::error::DescribeDocumentClassificationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_document_classification_job_error(response)
        } else {
            crate::operation_deser::parse_describe_document_classification_job_response(response)
        }
    }
}

/// Operation shape for `DescribeDocumentClassifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_document_classifier`](crate::client::Client::describe_document_classifier).
///
/// See [`crate::client::fluent_builders::DescribeDocumentClassifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDocumentClassifier {
    _private: (),
}
impl DescribeDocumentClassifier {
    /// Creates a new builder-style object to manufacture [`DescribeDocumentClassifierInput`](crate::input::DescribeDocumentClassifierInput)
    pub fn builder() -> crate::input::describe_document_classifier_input::Builder {
        crate::input::describe_document_classifier_input::Builder::default()
    }
    /// Creates a new `DescribeDocumentClassifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDocumentClassifier {
    type Output = std::result::Result<
        crate::output::DescribeDocumentClassifierOutput,
        crate::error::DescribeDocumentClassifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_document_classifier_error(response)
        } else {
            crate::operation_deser::parse_describe_document_classifier_response(response)
        }
    }
}

/// Operation shape for `DescribeDominantLanguageDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dominant_language_detection_job`](crate::client::Client::describe_dominant_language_detection_job).
///
/// See [`crate::client::fluent_builders::DescribeDominantLanguageDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDominantLanguageDetectionJob {
    _private: (),
}
impl DescribeDominantLanguageDetectionJob {
    /// Creates a new builder-style object to manufacture [`DescribeDominantLanguageDetectionJobInput`](crate::input::DescribeDominantLanguageDetectionJobInput)
    pub fn builder() -> crate::input::describe_dominant_language_detection_job_input::Builder {
        crate::input::describe_dominant_language_detection_job_input::Builder::default()
    }
    /// Creates a new `DescribeDominantLanguageDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDominantLanguageDetectionJob {
    type Output = std::result::Result<
        crate::output::DescribeDominantLanguageDetectionJobOutput,
        crate::error::DescribeDominantLanguageDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dominant_language_detection_job_error(response)
        } else {
            crate::operation_deser::parse_describe_dominant_language_detection_job_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoint`](crate::client::Client::describe_endpoint).
///
/// See [`crate::client::fluent_builders::DescribeEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpoint {
    _private: (),
}
impl DescribeEndpoint {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
    pub fn builder() -> crate::input::describe_endpoint_input::Builder {
        crate::input::describe_endpoint_input::Builder::default()
    }
    /// Creates a new `DescribeEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpoint {
    type Output = std::result::Result<
        crate::output::DescribeEndpointOutput,
        crate::error::DescribeEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoint_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoint_response(response)
        }
    }
}

/// Operation shape for `DescribeEntitiesDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_entities_detection_job`](crate::client::Client::describe_entities_detection_job).
///
/// See [`crate::client::fluent_builders::DescribeEntitiesDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEntitiesDetectionJob {
    _private: (),
}
impl DescribeEntitiesDetectionJob {
    /// Creates a new builder-style object to manufacture [`DescribeEntitiesDetectionJobInput`](crate::input::DescribeEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::describe_entities_detection_job_input::Builder {
        crate::input::describe_entities_detection_job_input::Builder::default()
    }
    /// Creates a new `DescribeEntitiesDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEntitiesDetectionJob {
    type Output = std::result::Result<
        crate::output::DescribeEntitiesDetectionJobOutput,
        crate::error::DescribeEntitiesDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_entities_detection_job_error(response)
        } else {
            crate::operation_deser::parse_describe_entities_detection_job_response(response)
        }
    }
}

/// Operation shape for `DescribeEntityRecognizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_entity_recognizer`](crate::client::Client::describe_entity_recognizer).
///
/// See [`crate::client::fluent_builders::DescribeEntityRecognizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEntityRecognizer {
    _private: (),
}
impl DescribeEntityRecognizer {
    /// Creates a new builder-style object to manufacture [`DescribeEntityRecognizerInput`](crate::input::DescribeEntityRecognizerInput)
    pub fn builder() -> crate::input::describe_entity_recognizer_input::Builder {
        crate::input::describe_entity_recognizer_input::Builder::default()
    }
    /// Creates a new `DescribeEntityRecognizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEntityRecognizer {
    type Output = std::result::Result<
        crate::output::DescribeEntityRecognizerOutput,
        crate::error::DescribeEntityRecognizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_entity_recognizer_error(response)
        } else {
            crate::operation_deser::parse_describe_entity_recognizer_response(response)
        }
    }
}

/// Operation shape for `DescribeEventsDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_events_detection_job`](crate::client::Client::describe_events_detection_job).
///
/// See [`crate::client::fluent_builders::DescribeEventsDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventsDetectionJob {
    _private: (),
}
impl DescribeEventsDetectionJob {
    /// Creates a new builder-style object to manufacture [`DescribeEventsDetectionJobInput`](crate::input::DescribeEventsDetectionJobInput)
    pub fn builder() -> crate::input::describe_events_detection_job_input::Builder {
        crate::input::describe_events_detection_job_input::Builder::default()
    }
    /// Creates a new `DescribeEventsDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventsDetectionJob {
    type Output = std::result::Result<
        crate::output::DescribeEventsDetectionJobOutput,
        crate::error::DescribeEventsDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_events_detection_job_error(response)
        } else {
            crate::operation_deser::parse_describe_events_detection_job_response(response)
        }
    }
}

/// Operation shape for `DescribeKeyPhrasesDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_key_phrases_detection_job`](crate::client::Client::describe_key_phrases_detection_job).
///
/// See [`crate::client::fluent_builders::DescribeKeyPhrasesDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeKeyPhrasesDetectionJob {
    _private: (),
}
impl DescribeKeyPhrasesDetectionJob {
    /// Creates a new builder-style object to manufacture [`DescribeKeyPhrasesDetectionJobInput`](crate::input::DescribeKeyPhrasesDetectionJobInput)
    pub fn builder() -> crate::input::describe_key_phrases_detection_job_input::Builder {
        crate::input::describe_key_phrases_detection_job_input::Builder::default()
    }
    /// Creates a new `DescribeKeyPhrasesDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeKeyPhrasesDetectionJob {
    type Output = std::result::Result<
        crate::output::DescribeKeyPhrasesDetectionJobOutput,
        crate::error::DescribeKeyPhrasesDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_key_phrases_detection_job_error(response)
        } else {
            crate::operation_deser::parse_describe_key_phrases_detection_job_response(response)
        }
    }
}

/// Operation shape for `DescribePiiEntitiesDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_pii_entities_detection_job`](crate::client::Client::describe_pii_entities_detection_job).
///
/// See [`crate::client::fluent_builders::DescribePiiEntitiesDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePiiEntitiesDetectionJob {
    _private: (),
}
impl DescribePiiEntitiesDetectionJob {
    /// Creates a new builder-style object to manufacture [`DescribePiiEntitiesDetectionJobInput`](crate::input::DescribePiiEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::describe_pii_entities_detection_job_input::Builder {
        crate::input::describe_pii_entities_detection_job_input::Builder::default()
    }
    /// Creates a new `DescribePiiEntitiesDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePiiEntitiesDetectionJob {
    type Output = std::result::Result<
        crate::output::DescribePiiEntitiesDetectionJobOutput,
        crate::error::DescribePiiEntitiesDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_pii_entities_detection_job_error(response)
        } else {
            crate::operation_deser::parse_describe_pii_entities_detection_job_response(response)
        }
    }
}

/// Operation shape for `DescribeSentimentDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_sentiment_detection_job`](crate::client::Client::describe_sentiment_detection_job).
///
/// See [`crate::client::fluent_builders::DescribeSentimentDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSentimentDetectionJob {
    _private: (),
}
impl DescribeSentimentDetectionJob {
    /// Creates a new builder-style object to manufacture [`DescribeSentimentDetectionJobInput`](crate::input::DescribeSentimentDetectionJobInput)
    pub fn builder() -> crate::input::describe_sentiment_detection_job_input::Builder {
        crate::input::describe_sentiment_detection_job_input::Builder::default()
    }
    /// Creates a new `DescribeSentimentDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSentimentDetectionJob {
    type Output = std::result::Result<
        crate::output::DescribeSentimentDetectionJobOutput,
        crate::error::DescribeSentimentDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_sentiment_detection_job_error(response)
        } else {
            crate::operation_deser::parse_describe_sentiment_detection_job_response(response)
        }
    }
}

/// Operation shape for `DescribeTopicsDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_topics_detection_job`](crate::client::Client::describe_topics_detection_job).
///
/// See [`crate::client::fluent_builders::DescribeTopicsDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTopicsDetectionJob {
    _private: (),
}
impl DescribeTopicsDetectionJob {
    /// Creates a new builder-style object to manufacture [`DescribeTopicsDetectionJobInput`](crate::input::DescribeTopicsDetectionJobInput)
    pub fn builder() -> crate::input::describe_topics_detection_job_input::Builder {
        crate::input::describe_topics_detection_job_input::Builder::default()
    }
    /// Creates a new `DescribeTopicsDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTopicsDetectionJob {
    type Output = std::result::Result<
        crate::output::DescribeTopicsDetectionJobOutput,
        crate::error::DescribeTopicsDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_topics_detection_job_error(response)
        } else {
            crate::operation_deser::parse_describe_topics_detection_job_response(response)
        }
    }
}

/// Operation shape for `DetectDominantLanguage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_dominant_language`](crate::client::Client::detect_dominant_language).
///
/// See [`crate::client::fluent_builders::DetectDominantLanguage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectDominantLanguage {
    _private: (),
}
impl DetectDominantLanguage {
    /// Creates a new builder-style object to manufacture [`DetectDominantLanguageInput`](crate::input::DetectDominantLanguageInput)
    pub fn builder() -> crate::input::detect_dominant_language_input::Builder {
        crate::input::detect_dominant_language_input::Builder::default()
    }
    /// Creates a new `DetectDominantLanguage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectDominantLanguage {
    type Output = std::result::Result<
        crate::output::DetectDominantLanguageOutput,
        crate::error::DetectDominantLanguageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_dominant_language_error(response)
        } else {
            crate::operation_deser::parse_detect_dominant_language_response(response)
        }
    }
}

/// Operation shape for `DetectEntities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_entities`](crate::client::Client::detect_entities).
///
/// See [`crate::client::fluent_builders::DetectEntities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectEntities {
    _private: (),
}
impl DetectEntities {
    /// Creates a new builder-style object to manufacture [`DetectEntitiesInput`](crate::input::DetectEntitiesInput)
    pub fn builder() -> crate::input::detect_entities_input::Builder {
        crate::input::detect_entities_input::Builder::default()
    }
    /// Creates a new `DetectEntities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectEntities {
    type Output =
        std::result::Result<crate::output::DetectEntitiesOutput, crate::error::DetectEntitiesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_entities_error(response)
        } else {
            crate::operation_deser::parse_detect_entities_response(response)
        }
    }
}

/// Operation shape for `DetectKeyPhrases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_key_phrases`](crate::client::Client::detect_key_phrases).
///
/// See [`crate::client::fluent_builders::DetectKeyPhrases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectKeyPhrases {
    _private: (),
}
impl DetectKeyPhrases {
    /// Creates a new builder-style object to manufacture [`DetectKeyPhrasesInput`](crate::input::DetectKeyPhrasesInput)
    pub fn builder() -> crate::input::detect_key_phrases_input::Builder {
        crate::input::detect_key_phrases_input::Builder::default()
    }
    /// Creates a new `DetectKeyPhrases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectKeyPhrases {
    type Output = std::result::Result<
        crate::output::DetectKeyPhrasesOutput,
        crate::error::DetectKeyPhrasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_key_phrases_error(response)
        } else {
            crate::operation_deser::parse_detect_key_phrases_response(response)
        }
    }
}

/// Operation shape for `DetectPiiEntities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_pii_entities`](crate::client::Client::detect_pii_entities).
///
/// See [`crate::client::fluent_builders::DetectPiiEntities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectPiiEntities {
    _private: (),
}
impl DetectPiiEntities {
    /// Creates a new builder-style object to manufacture [`DetectPiiEntitiesInput`](crate::input::DetectPiiEntitiesInput)
    pub fn builder() -> crate::input::detect_pii_entities_input::Builder {
        crate::input::detect_pii_entities_input::Builder::default()
    }
    /// Creates a new `DetectPiiEntities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectPiiEntities {
    type Output = std::result::Result<
        crate::output::DetectPiiEntitiesOutput,
        crate::error::DetectPiiEntitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_pii_entities_error(response)
        } else {
            crate::operation_deser::parse_detect_pii_entities_response(response)
        }
    }
}

/// Operation shape for `DetectSentiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_sentiment`](crate::client::Client::detect_sentiment).
///
/// See [`crate::client::fluent_builders::DetectSentiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectSentiment {
    _private: (),
}
impl DetectSentiment {
    /// Creates a new builder-style object to manufacture [`DetectSentimentInput`](crate::input::DetectSentimentInput)
    pub fn builder() -> crate::input::detect_sentiment_input::Builder {
        crate::input::detect_sentiment_input::Builder::default()
    }
    /// Creates a new `DetectSentiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectSentiment {
    type Output = std::result::Result<
        crate::output::DetectSentimentOutput,
        crate::error::DetectSentimentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_sentiment_error(response)
        } else {
            crate::operation_deser::parse_detect_sentiment_response(response)
        }
    }
}

/// Operation shape for `DetectSyntax`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_syntax`](crate::client::Client::detect_syntax).
///
/// See [`crate::client::fluent_builders::DetectSyntax`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectSyntax {
    _private: (),
}
impl DetectSyntax {
    /// Creates a new builder-style object to manufacture [`DetectSyntaxInput`](crate::input::DetectSyntaxInput)
    pub fn builder() -> crate::input::detect_syntax_input::Builder {
        crate::input::detect_syntax_input::Builder::default()
    }
    /// Creates a new `DetectSyntax` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectSyntax {
    type Output =
        std::result::Result<crate::output::DetectSyntaxOutput, crate::error::DetectSyntaxError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_syntax_error(response)
        } else {
            crate::operation_deser::parse_detect_syntax_response(response)
        }
    }
}

/// Operation shape for `ListDocumentClassificationJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_document_classification_jobs`](crate::client::Client::list_document_classification_jobs).
///
/// See [`crate::client::fluent_builders::ListDocumentClassificationJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDocumentClassificationJobs {
    _private: (),
}
impl ListDocumentClassificationJobs {
    /// Creates a new builder-style object to manufacture [`ListDocumentClassificationJobsInput`](crate::input::ListDocumentClassificationJobsInput)
    pub fn builder() -> crate::input::list_document_classification_jobs_input::Builder {
        crate::input::list_document_classification_jobs_input::Builder::default()
    }
    /// Creates a new `ListDocumentClassificationJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDocumentClassificationJobs {
    type Output = std::result::Result<
        crate::output::ListDocumentClassificationJobsOutput,
        crate::error::ListDocumentClassificationJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_document_classification_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_document_classification_jobs_response(response)
        }
    }
}

/// Operation shape for `ListDocumentClassifiers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_document_classifiers`](crate::client::Client::list_document_classifiers).
///
/// See [`crate::client::fluent_builders::ListDocumentClassifiers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDocumentClassifiers {
    _private: (),
}
impl ListDocumentClassifiers {
    /// Creates a new builder-style object to manufacture [`ListDocumentClassifiersInput`](crate::input::ListDocumentClassifiersInput)
    pub fn builder() -> crate::input::list_document_classifiers_input::Builder {
        crate::input::list_document_classifiers_input::Builder::default()
    }
    /// Creates a new `ListDocumentClassifiers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDocumentClassifiers {
    type Output = std::result::Result<
        crate::output::ListDocumentClassifiersOutput,
        crate::error::ListDocumentClassifiersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_document_classifiers_error(response)
        } else {
            crate::operation_deser::parse_list_document_classifiers_response(response)
        }
    }
}

/// Operation shape for `ListDocumentClassifierSummaries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_document_classifier_summaries`](crate::client::Client::list_document_classifier_summaries).
///
/// See [`crate::client::fluent_builders::ListDocumentClassifierSummaries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDocumentClassifierSummaries {
    _private: (),
}
impl ListDocumentClassifierSummaries {
    /// Creates a new builder-style object to manufacture [`ListDocumentClassifierSummariesInput`](crate::input::ListDocumentClassifierSummariesInput)
    pub fn builder() -> crate::input::list_document_classifier_summaries_input::Builder {
        crate::input::list_document_classifier_summaries_input::Builder::default()
    }
    /// Creates a new `ListDocumentClassifierSummaries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDocumentClassifierSummaries {
    type Output = std::result::Result<
        crate::output::ListDocumentClassifierSummariesOutput,
        crate::error::ListDocumentClassifierSummariesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_document_classifier_summaries_error(response)
        } else {
            crate::operation_deser::parse_list_document_classifier_summaries_response(response)
        }
    }
}

/// Operation shape for `ListDominantLanguageDetectionJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dominant_language_detection_jobs`](crate::client::Client::list_dominant_language_detection_jobs).
///
/// See [`crate::client::fluent_builders::ListDominantLanguageDetectionJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDominantLanguageDetectionJobs {
    _private: (),
}
impl ListDominantLanguageDetectionJobs {
    /// Creates a new builder-style object to manufacture [`ListDominantLanguageDetectionJobsInput`](crate::input::ListDominantLanguageDetectionJobsInput)
    pub fn builder() -> crate::input::list_dominant_language_detection_jobs_input::Builder {
        crate::input::list_dominant_language_detection_jobs_input::Builder::default()
    }
    /// Creates a new `ListDominantLanguageDetectionJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDominantLanguageDetectionJobs {
    type Output = std::result::Result<
        crate::output::ListDominantLanguageDetectionJobsOutput,
        crate::error::ListDominantLanguageDetectionJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dominant_language_detection_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_dominant_language_detection_jobs_response(response)
        }
    }
}

/// Operation shape for `ListEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_endpoints`](crate::client::Client::list_endpoints).
///
/// See [`crate::client::fluent_builders::ListEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEndpoints {
    _private: (),
}
impl ListEndpoints {
    /// Creates a new builder-style object to manufacture [`ListEndpointsInput`](crate::input::ListEndpointsInput)
    pub fn builder() -> crate::input::list_endpoints_input::Builder {
        crate::input::list_endpoints_input::Builder::default()
    }
    /// Creates a new `ListEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEndpoints {
    type Output =
        std::result::Result<crate::output::ListEndpointsOutput, crate::error::ListEndpointsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_endpoints_error(response)
        } else {
            crate::operation_deser::parse_list_endpoints_response(response)
        }
    }
}

/// Operation shape for `ListEntitiesDetectionJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_entities_detection_jobs`](crate::client::Client::list_entities_detection_jobs).
///
/// See [`crate::client::fluent_builders::ListEntitiesDetectionJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEntitiesDetectionJobs {
    _private: (),
}
impl ListEntitiesDetectionJobs {
    /// Creates a new builder-style object to manufacture [`ListEntitiesDetectionJobsInput`](crate::input::ListEntitiesDetectionJobsInput)
    pub fn builder() -> crate::input::list_entities_detection_jobs_input::Builder {
        crate::input::list_entities_detection_jobs_input::Builder::default()
    }
    /// Creates a new `ListEntitiesDetectionJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEntitiesDetectionJobs {
    type Output = std::result::Result<
        crate::output::ListEntitiesDetectionJobsOutput,
        crate::error::ListEntitiesDetectionJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_entities_detection_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_entities_detection_jobs_response(response)
        }
    }
}

/// Operation shape for `ListEntityRecognizers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_entity_recognizers`](crate::client::Client::list_entity_recognizers).
///
/// See [`crate::client::fluent_builders::ListEntityRecognizers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEntityRecognizers {
    _private: (),
}
impl ListEntityRecognizers {
    /// Creates a new builder-style object to manufacture [`ListEntityRecognizersInput`](crate::input::ListEntityRecognizersInput)
    pub fn builder() -> crate::input::list_entity_recognizers_input::Builder {
        crate::input::list_entity_recognizers_input::Builder::default()
    }
    /// Creates a new `ListEntityRecognizers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEntityRecognizers {
    type Output = std::result::Result<
        crate::output::ListEntityRecognizersOutput,
        crate::error::ListEntityRecognizersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_entity_recognizers_error(response)
        } else {
            crate::operation_deser::parse_list_entity_recognizers_response(response)
        }
    }
}

/// Operation shape for `ListEntityRecognizerSummaries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_entity_recognizer_summaries`](crate::client::Client::list_entity_recognizer_summaries).
///
/// See [`crate::client::fluent_builders::ListEntityRecognizerSummaries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEntityRecognizerSummaries {
    _private: (),
}
impl ListEntityRecognizerSummaries {
    /// Creates a new builder-style object to manufacture [`ListEntityRecognizerSummariesInput`](crate::input::ListEntityRecognizerSummariesInput)
    pub fn builder() -> crate::input::list_entity_recognizer_summaries_input::Builder {
        crate::input::list_entity_recognizer_summaries_input::Builder::default()
    }
    /// Creates a new `ListEntityRecognizerSummaries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEntityRecognizerSummaries {
    type Output = std::result::Result<
        crate::output::ListEntityRecognizerSummariesOutput,
        crate::error::ListEntityRecognizerSummariesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_entity_recognizer_summaries_error(response)
        } else {
            crate::operation_deser::parse_list_entity_recognizer_summaries_response(response)
        }
    }
}

/// Operation shape for `ListEventsDetectionJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_events_detection_jobs`](crate::client::Client::list_events_detection_jobs).
///
/// See [`crate::client::fluent_builders::ListEventsDetectionJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEventsDetectionJobs {
    _private: (),
}
impl ListEventsDetectionJobs {
    /// Creates a new builder-style object to manufacture [`ListEventsDetectionJobsInput`](crate::input::ListEventsDetectionJobsInput)
    pub fn builder() -> crate::input::list_events_detection_jobs_input::Builder {
        crate::input::list_events_detection_jobs_input::Builder::default()
    }
    /// Creates a new `ListEventsDetectionJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEventsDetectionJobs {
    type Output = std::result::Result<
        crate::output::ListEventsDetectionJobsOutput,
        crate::error::ListEventsDetectionJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_events_detection_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_events_detection_jobs_response(response)
        }
    }
}

/// Operation shape for `ListKeyPhrasesDetectionJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_key_phrases_detection_jobs`](crate::client::Client::list_key_phrases_detection_jobs).
///
/// See [`crate::client::fluent_builders::ListKeyPhrasesDetectionJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListKeyPhrasesDetectionJobs {
    _private: (),
}
impl ListKeyPhrasesDetectionJobs {
    /// Creates a new builder-style object to manufacture [`ListKeyPhrasesDetectionJobsInput`](crate::input::ListKeyPhrasesDetectionJobsInput)
    pub fn builder() -> crate::input::list_key_phrases_detection_jobs_input::Builder {
        crate::input::list_key_phrases_detection_jobs_input::Builder::default()
    }
    /// Creates a new `ListKeyPhrasesDetectionJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListKeyPhrasesDetectionJobs {
    type Output = std::result::Result<
        crate::output::ListKeyPhrasesDetectionJobsOutput,
        crate::error::ListKeyPhrasesDetectionJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_key_phrases_detection_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_key_phrases_detection_jobs_response(response)
        }
    }
}

/// Operation shape for `ListPiiEntitiesDetectionJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pii_entities_detection_jobs`](crate::client::Client::list_pii_entities_detection_jobs).
///
/// See [`crate::client::fluent_builders::ListPiiEntitiesDetectionJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPiiEntitiesDetectionJobs {
    _private: (),
}
impl ListPiiEntitiesDetectionJobs {
    /// Creates a new builder-style object to manufacture [`ListPiiEntitiesDetectionJobsInput`](crate::input::ListPiiEntitiesDetectionJobsInput)
    pub fn builder() -> crate::input::list_pii_entities_detection_jobs_input::Builder {
        crate::input::list_pii_entities_detection_jobs_input::Builder::default()
    }
    /// Creates a new `ListPiiEntitiesDetectionJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPiiEntitiesDetectionJobs {
    type Output = std::result::Result<
        crate::output::ListPiiEntitiesDetectionJobsOutput,
        crate::error::ListPiiEntitiesDetectionJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pii_entities_detection_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_pii_entities_detection_jobs_response(response)
        }
    }
}

/// Operation shape for `ListSentimentDetectionJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_sentiment_detection_jobs`](crate::client::Client::list_sentiment_detection_jobs).
///
/// See [`crate::client::fluent_builders::ListSentimentDetectionJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSentimentDetectionJobs {
    _private: (),
}
impl ListSentimentDetectionJobs {
    /// Creates a new builder-style object to manufacture [`ListSentimentDetectionJobsInput`](crate::input::ListSentimentDetectionJobsInput)
    pub fn builder() -> crate::input::list_sentiment_detection_jobs_input::Builder {
        crate::input::list_sentiment_detection_jobs_input::Builder::default()
    }
    /// Creates a new `ListSentimentDetectionJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSentimentDetectionJobs {
    type Output = std::result::Result<
        crate::output::ListSentimentDetectionJobsOutput,
        crate::error::ListSentimentDetectionJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_sentiment_detection_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_sentiment_detection_jobs_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTopicsDetectionJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_topics_detection_jobs`](crate::client::Client::list_topics_detection_jobs).
///
/// See [`crate::client::fluent_builders::ListTopicsDetectionJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTopicsDetectionJobs {
    _private: (),
}
impl ListTopicsDetectionJobs {
    /// Creates a new builder-style object to manufacture [`ListTopicsDetectionJobsInput`](crate::input::ListTopicsDetectionJobsInput)
    pub fn builder() -> crate::input::list_topics_detection_jobs_input::Builder {
        crate::input::list_topics_detection_jobs_input::Builder::default()
    }
    /// Creates a new `ListTopicsDetectionJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTopicsDetectionJobs {
    type Output = std::result::Result<
        crate::output::ListTopicsDetectionJobsOutput,
        crate::error::ListTopicsDetectionJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_topics_detection_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_topics_detection_jobs_response(response)
        }
    }
}

/// Operation shape for `StartDocumentClassificationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_document_classification_job`](crate::client::Client::start_document_classification_job).
///
/// See [`crate::client::fluent_builders::StartDocumentClassificationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDocumentClassificationJob {
    _private: (),
}
impl StartDocumentClassificationJob {
    /// Creates a new builder-style object to manufacture [`StartDocumentClassificationJobInput`](crate::input::StartDocumentClassificationJobInput)
    pub fn builder() -> crate::input::start_document_classification_job_input::Builder {
        crate::input::start_document_classification_job_input::Builder::default()
    }
    /// Creates a new `StartDocumentClassificationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDocumentClassificationJob {
    type Output = std::result::Result<
        crate::output::StartDocumentClassificationJobOutput,
        crate::error::StartDocumentClassificationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_document_classification_job_error(response)
        } else {
            crate::operation_deser::parse_start_document_classification_job_response(response)
        }
    }
}

/// Operation shape for `StartDominantLanguageDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_dominant_language_detection_job`](crate::client::Client::start_dominant_language_detection_job).
///
/// See [`crate::client::fluent_builders::StartDominantLanguageDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDominantLanguageDetectionJob {
    _private: (),
}
impl StartDominantLanguageDetectionJob {
    /// Creates a new builder-style object to manufacture [`StartDominantLanguageDetectionJobInput`](crate::input::StartDominantLanguageDetectionJobInput)
    pub fn builder() -> crate::input::start_dominant_language_detection_job_input::Builder {
        crate::input::start_dominant_language_detection_job_input::Builder::default()
    }
    /// Creates a new `StartDominantLanguageDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDominantLanguageDetectionJob {
    type Output = std::result::Result<
        crate::output::StartDominantLanguageDetectionJobOutput,
        crate::error::StartDominantLanguageDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_dominant_language_detection_job_error(response)
        } else {
            crate::operation_deser::parse_start_dominant_language_detection_job_response(response)
        }
    }
}

/// Operation shape for `StartEntitiesDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_entities_detection_job`](crate::client::Client::start_entities_detection_job).
///
/// See [`crate::client::fluent_builders::StartEntitiesDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartEntitiesDetectionJob {
    _private: (),
}
impl StartEntitiesDetectionJob {
    /// Creates a new builder-style object to manufacture [`StartEntitiesDetectionJobInput`](crate::input::StartEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::start_entities_detection_job_input::Builder {
        crate::input::start_entities_detection_job_input::Builder::default()
    }
    /// Creates a new `StartEntitiesDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartEntitiesDetectionJob {
    type Output = std::result::Result<
        crate::output::StartEntitiesDetectionJobOutput,
        crate::error::StartEntitiesDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_entities_detection_job_error(response)
        } else {
            crate::operation_deser::parse_start_entities_detection_job_response(response)
        }
    }
}

/// Operation shape for `StartEventsDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_events_detection_job`](crate::client::Client::start_events_detection_job).
///
/// See [`crate::client::fluent_builders::StartEventsDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartEventsDetectionJob {
    _private: (),
}
impl StartEventsDetectionJob {
    /// Creates a new builder-style object to manufacture [`StartEventsDetectionJobInput`](crate::input::StartEventsDetectionJobInput)
    pub fn builder() -> crate::input::start_events_detection_job_input::Builder {
        crate::input::start_events_detection_job_input::Builder::default()
    }
    /// Creates a new `StartEventsDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartEventsDetectionJob {
    type Output = std::result::Result<
        crate::output::StartEventsDetectionJobOutput,
        crate::error::StartEventsDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_events_detection_job_error(response)
        } else {
            crate::operation_deser::parse_start_events_detection_job_response(response)
        }
    }
}

/// Operation shape for `StartKeyPhrasesDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_key_phrases_detection_job`](crate::client::Client::start_key_phrases_detection_job).
///
/// See [`crate::client::fluent_builders::StartKeyPhrasesDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartKeyPhrasesDetectionJob {
    _private: (),
}
impl StartKeyPhrasesDetectionJob {
    /// Creates a new builder-style object to manufacture [`StartKeyPhrasesDetectionJobInput`](crate::input::StartKeyPhrasesDetectionJobInput)
    pub fn builder() -> crate::input::start_key_phrases_detection_job_input::Builder {
        crate::input::start_key_phrases_detection_job_input::Builder::default()
    }
    /// Creates a new `StartKeyPhrasesDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartKeyPhrasesDetectionJob {
    type Output = std::result::Result<
        crate::output::StartKeyPhrasesDetectionJobOutput,
        crate::error::StartKeyPhrasesDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_key_phrases_detection_job_error(response)
        } else {
            crate::operation_deser::parse_start_key_phrases_detection_job_response(response)
        }
    }
}

/// Operation shape for `StartPiiEntitiesDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_pii_entities_detection_job`](crate::client::Client::start_pii_entities_detection_job).
///
/// See [`crate::client::fluent_builders::StartPiiEntitiesDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartPiiEntitiesDetectionJob {
    _private: (),
}
impl StartPiiEntitiesDetectionJob {
    /// Creates a new builder-style object to manufacture [`StartPiiEntitiesDetectionJobInput`](crate::input::StartPiiEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::start_pii_entities_detection_job_input::Builder {
        crate::input::start_pii_entities_detection_job_input::Builder::default()
    }
    /// Creates a new `StartPiiEntitiesDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartPiiEntitiesDetectionJob {
    type Output = std::result::Result<
        crate::output::StartPiiEntitiesDetectionJobOutput,
        crate::error::StartPiiEntitiesDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_pii_entities_detection_job_error(response)
        } else {
            crate::operation_deser::parse_start_pii_entities_detection_job_response(response)
        }
    }
}

/// Operation shape for `StartSentimentDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_sentiment_detection_job`](crate::client::Client::start_sentiment_detection_job).
///
/// See [`crate::client::fluent_builders::StartSentimentDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartSentimentDetectionJob {
    _private: (),
}
impl StartSentimentDetectionJob {
    /// Creates a new builder-style object to manufacture [`StartSentimentDetectionJobInput`](crate::input::StartSentimentDetectionJobInput)
    pub fn builder() -> crate::input::start_sentiment_detection_job_input::Builder {
        crate::input::start_sentiment_detection_job_input::Builder::default()
    }
    /// Creates a new `StartSentimentDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartSentimentDetectionJob {
    type Output = std::result::Result<
        crate::output::StartSentimentDetectionJobOutput,
        crate::error::StartSentimentDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_sentiment_detection_job_error(response)
        } else {
            crate::operation_deser::parse_start_sentiment_detection_job_response(response)
        }
    }
}

/// Operation shape for `StartTopicsDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_topics_detection_job`](crate::client::Client::start_topics_detection_job).
///
/// See [`crate::client::fluent_builders::StartTopicsDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartTopicsDetectionJob {
    _private: (),
}
impl StartTopicsDetectionJob {
    /// Creates a new builder-style object to manufacture [`StartTopicsDetectionJobInput`](crate::input::StartTopicsDetectionJobInput)
    pub fn builder() -> crate::input::start_topics_detection_job_input::Builder {
        crate::input::start_topics_detection_job_input::Builder::default()
    }
    /// Creates a new `StartTopicsDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartTopicsDetectionJob {
    type Output = std::result::Result<
        crate::output::StartTopicsDetectionJobOutput,
        crate::error::StartTopicsDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_topics_detection_job_error(response)
        } else {
            crate::operation_deser::parse_start_topics_detection_job_response(response)
        }
    }
}

/// Operation shape for `StopDominantLanguageDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_dominant_language_detection_job`](crate::client::Client::stop_dominant_language_detection_job).
///
/// See [`crate::client::fluent_builders::StopDominantLanguageDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopDominantLanguageDetectionJob {
    _private: (),
}
impl StopDominantLanguageDetectionJob {
    /// Creates a new builder-style object to manufacture [`StopDominantLanguageDetectionJobInput`](crate::input::StopDominantLanguageDetectionJobInput)
    pub fn builder() -> crate::input::stop_dominant_language_detection_job_input::Builder {
        crate::input::stop_dominant_language_detection_job_input::Builder::default()
    }
    /// Creates a new `StopDominantLanguageDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopDominantLanguageDetectionJob {
    type Output = std::result::Result<
        crate::output::StopDominantLanguageDetectionJobOutput,
        crate::error::StopDominantLanguageDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_dominant_language_detection_job_error(response)
        } else {
            crate::operation_deser::parse_stop_dominant_language_detection_job_response(response)
        }
    }
}

/// Operation shape for `StopEntitiesDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_entities_detection_job`](crate::client::Client::stop_entities_detection_job).
///
/// See [`crate::client::fluent_builders::StopEntitiesDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopEntitiesDetectionJob {
    _private: (),
}
impl StopEntitiesDetectionJob {
    /// Creates a new builder-style object to manufacture [`StopEntitiesDetectionJobInput`](crate::input::StopEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::stop_entities_detection_job_input::Builder {
        crate::input::stop_entities_detection_job_input::Builder::default()
    }
    /// Creates a new `StopEntitiesDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopEntitiesDetectionJob {
    type Output = std::result::Result<
        crate::output::StopEntitiesDetectionJobOutput,
        crate::error::StopEntitiesDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_entities_detection_job_error(response)
        } else {
            crate::operation_deser::parse_stop_entities_detection_job_response(response)
        }
    }
}

/// Operation shape for `StopEventsDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_events_detection_job`](crate::client::Client::stop_events_detection_job).
///
/// See [`crate::client::fluent_builders::StopEventsDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopEventsDetectionJob {
    _private: (),
}
impl StopEventsDetectionJob {
    /// Creates a new builder-style object to manufacture [`StopEventsDetectionJobInput`](crate::input::StopEventsDetectionJobInput)
    pub fn builder() -> crate::input::stop_events_detection_job_input::Builder {
        crate::input::stop_events_detection_job_input::Builder::default()
    }
    /// Creates a new `StopEventsDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopEventsDetectionJob {
    type Output = std::result::Result<
        crate::output::StopEventsDetectionJobOutput,
        crate::error::StopEventsDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_events_detection_job_error(response)
        } else {
            crate::operation_deser::parse_stop_events_detection_job_response(response)
        }
    }
}

/// Operation shape for `StopKeyPhrasesDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_key_phrases_detection_job`](crate::client::Client::stop_key_phrases_detection_job).
///
/// See [`crate::client::fluent_builders::StopKeyPhrasesDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopKeyPhrasesDetectionJob {
    _private: (),
}
impl StopKeyPhrasesDetectionJob {
    /// Creates a new builder-style object to manufacture [`StopKeyPhrasesDetectionJobInput`](crate::input::StopKeyPhrasesDetectionJobInput)
    pub fn builder() -> crate::input::stop_key_phrases_detection_job_input::Builder {
        crate::input::stop_key_phrases_detection_job_input::Builder::default()
    }
    /// Creates a new `StopKeyPhrasesDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopKeyPhrasesDetectionJob {
    type Output = std::result::Result<
        crate::output::StopKeyPhrasesDetectionJobOutput,
        crate::error::StopKeyPhrasesDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_key_phrases_detection_job_error(response)
        } else {
            crate::operation_deser::parse_stop_key_phrases_detection_job_response(response)
        }
    }
}

/// Operation shape for `StopPiiEntitiesDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_pii_entities_detection_job`](crate::client::Client::stop_pii_entities_detection_job).
///
/// See [`crate::client::fluent_builders::StopPiiEntitiesDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopPiiEntitiesDetectionJob {
    _private: (),
}
impl StopPiiEntitiesDetectionJob {
    /// Creates a new builder-style object to manufacture [`StopPiiEntitiesDetectionJobInput`](crate::input::StopPiiEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::stop_pii_entities_detection_job_input::Builder {
        crate::input::stop_pii_entities_detection_job_input::Builder::default()
    }
    /// Creates a new `StopPiiEntitiesDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopPiiEntitiesDetectionJob {
    type Output = std::result::Result<
        crate::output::StopPiiEntitiesDetectionJobOutput,
        crate::error::StopPiiEntitiesDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_pii_entities_detection_job_error(response)
        } else {
            crate::operation_deser::parse_stop_pii_entities_detection_job_response(response)
        }
    }
}

/// Operation shape for `StopSentimentDetectionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_sentiment_detection_job`](crate::client::Client::stop_sentiment_detection_job).
///
/// See [`crate::client::fluent_builders::StopSentimentDetectionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopSentimentDetectionJob {
    _private: (),
}
impl StopSentimentDetectionJob {
    /// Creates a new builder-style object to manufacture [`StopSentimentDetectionJobInput`](crate::input::StopSentimentDetectionJobInput)
    pub fn builder() -> crate::input::stop_sentiment_detection_job_input::Builder {
        crate::input::stop_sentiment_detection_job_input::Builder::default()
    }
    /// Creates a new `StopSentimentDetectionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopSentimentDetectionJob {
    type Output = std::result::Result<
        crate::output::StopSentimentDetectionJobOutput,
        crate::error::StopSentimentDetectionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_sentiment_detection_job_error(response)
        } else {
            crate::operation_deser::parse_stop_sentiment_detection_job_response(response)
        }
    }
}

/// Operation shape for `StopTrainingDocumentClassifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_training_document_classifier`](crate::client::Client::stop_training_document_classifier).
///
/// See [`crate::client::fluent_builders::StopTrainingDocumentClassifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopTrainingDocumentClassifier {
    _private: (),
}
impl StopTrainingDocumentClassifier {
    /// Creates a new builder-style object to manufacture [`StopTrainingDocumentClassifierInput`](crate::input::StopTrainingDocumentClassifierInput)
    pub fn builder() -> crate::input::stop_training_document_classifier_input::Builder {
        crate::input::stop_training_document_classifier_input::Builder::default()
    }
    /// Creates a new `StopTrainingDocumentClassifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopTrainingDocumentClassifier {
    type Output = std::result::Result<
        crate::output::StopTrainingDocumentClassifierOutput,
        crate::error::StopTrainingDocumentClassifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_training_document_classifier_error(response)
        } else {
            crate::operation_deser::parse_stop_training_document_classifier_response(response)
        }
    }
}

/// Operation shape for `StopTrainingEntityRecognizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_training_entity_recognizer`](crate::client::Client::stop_training_entity_recognizer).
///
/// See [`crate::client::fluent_builders::StopTrainingEntityRecognizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopTrainingEntityRecognizer {
    _private: (),
}
impl StopTrainingEntityRecognizer {
    /// Creates a new builder-style object to manufacture [`StopTrainingEntityRecognizerInput`](crate::input::StopTrainingEntityRecognizerInput)
    pub fn builder() -> crate::input::stop_training_entity_recognizer_input::Builder {
        crate::input::stop_training_entity_recognizer_input::Builder::default()
    }
    /// Creates a new `StopTrainingEntityRecognizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopTrainingEntityRecognizer {
    type Output = std::result::Result<
        crate::output::StopTrainingEntityRecognizerOutput,
        crate::error::StopTrainingEntityRecognizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_training_entity_recognizer_error(response)
        } else {
            crate::operation_deser::parse_stop_training_entity_recognizer_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_endpoint`](crate::client::Client::update_endpoint).
///
/// See [`crate::client::fluent_builders::UpdateEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEndpoint {
    _private: (),
}
impl UpdateEndpoint {
    /// Creates a new builder-style object to manufacture [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
    pub fn builder() -> crate::input::update_endpoint_input::Builder {
        crate::input::update_endpoint_input::Builder::default()
    }
    /// Creates a new `UpdateEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEndpoint {
    type Output =
        std::result::Result<crate::output::UpdateEndpointOutput, crate::error::UpdateEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_endpoint_error(response)
        } else {
            crate::operation_deser::parse_update_endpoint_response(response)
        }
    }
}
