// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For
/// example, a tag with the key-value pair ‘Department’:’Sales’ might be added to a resource to
/// indicate its use by a particular department. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The initial part of a key-value pair that forms a tag associated with a given resource.
    /// For instance, if you want to show which resources are used by which departments, you might use
    /// “Department” as the key portion of the pair, with multiple possible values such as “sales,”
    /// “legal,” and “administration.” </p>
    pub key: std::option::Option<std::string::String>,
    /// <p> The second part of a key-value pair that forms a tag associated with a given resource.
    /// For instance, if you want to show which resources are used by which departments, you might use
    /// “Department” as the initial (key) portion of the pair, with a value of “sales” to indicate the
    /// sales department. </p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The initial part of a key-value pair that forms a tag associated with a given resource.
    /// For instance, if you want to show which resources are used by which departments, you might use
    /// “Department” as the key portion of the pair, with multiple possible values such as “sales,”
    /// “legal,” and “administration.” </p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p> The second part of a key-value pair that forms a tag associated with a given resource.
    /// For instance, if you want to show which resources are used by which departments, you might use
    /// “Department” as the initial (key) portion of the pair, with a value of “sales” to indicate the
    /// sales department. </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The initial part of a key-value pair that forms a tag associated with a given resource.
        /// For instance, if you want to show which resources are used by which departments, you might use
        /// “Department” as the key portion of the pair, with multiple possible values such as “sales,”
        /// “legal,” and “administration.” </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The initial part of a key-value pair that forms a tag associated with a given resource.
        /// For instance, if you want to show which resources are used by which departments, you might use
        /// “Department” as the key portion of the pair, with multiple possible values such as “sales,”
        /// “legal,” and “administration.” </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p> The second part of a key-value pair that forms a tag associated with a given resource.
        /// For instance, if you want to show which resources are used by which departments, you might use
        /// “Department” as the initial (key) portion of the pair, with a value of “sales” to indicate the
        /// sales department. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p> The second part of a key-value pair that forms a tag associated with a given resource.
        /// For instance, if you want to show which resources are used by which departments, you might use
        /// “Department” as the initial (key) portion of the pair, with a value of “sales” to indicate the
        /// sales department. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    StopRequested,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => JobStatus::Completed,
            "FAILED" => JobStatus::Failed,
            "IN_PROGRESS" => JobStatus::InProgress,
            "STOPPED" => JobStatus::Stopped,
            "STOP_REQUESTED" => JobStatus::StopRequested,
            "SUBMITTED" => JobStatus::Submitted,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Completed => "COMPLETED",
            JobStatus::Failed => "FAILED",
            JobStatus::InProgress => "IN_PROGRESS",
            JobStatus::Stopped => "STOPPED",
            JobStatus::StopRequested => "STOP_REQUESTED",
            JobStatus::Submitted => "SUBMITTED",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "FAILED",
            "IN_PROGRESS",
            "STOPPED",
            "STOP_REQUESTED",
            "SUBMITTED",
        ]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
/// the resources you are using for the job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
/// VPC</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfig {
    /// <p>The ID number for a security group on an instance of your private VPC. Security groups on
    /// your VPC function serve as a virtual firewall to control inbound and outbound traffic and
    /// provides security for the resources that you’ll be accessing on the VPC. This ID number is
    /// preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security
    /// Groups for your VPC</a>. </p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID for each subnet being used in your private VPC. This subnet is a subset of the a
    /// range of IPv4 addresses used by the VPC and is specific to a given availability zone in the
    /// VPC’s region. This ID number is preceded by "subnet-", for instance:
    /// "subnet-04ccf456919e69055". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and
    /// Subnets</a>. </p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcConfig {
    /// <p>The ID number for a security group on an instance of your private VPC. Security groups on
    /// your VPC function serve as a virtual firewall to control inbound and outbound traffic and
    /// provides security for the resources that you’ll be accessing on the VPC. This ID number is
    /// preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security
    /// Groups for your VPC</a>. </p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>The ID for each subnet being used in your private VPC. This subnet is a subset of the a
    /// range of IPv4 addresses used by the VPC and is specific to a given availability zone in the
    /// VPC’s region. This ID number is preceded by "subnet-", for instance:
    /// "subnet-04ccf456919e69055". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and
    /// Subnets</a>. </p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
}
impl std::fmt::Debug for VpcConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfig");
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnets", &self.subnets);
        formatter.finish()
    }
}
/// See [`VpcConfig`](crate::model::VpcConfig)
pub mod vpc_config {
    /// A builder for [`VpcConfig`](crate::model::VpcConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The ID number for a security group on an instance of your private VPC. Security groups on
        /// your VPC function serve as a virtual firewall to control inbound and outbound traffic and
        /// provides security for the resources that you’ll be accessing on the VPC. This ID number is
        /// preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security
        /// Groups for your VPC</a>. </p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The ID number for a security group on an instance of your private VPC. Security groups on
        /// your VPC function serve as a virtual firewall to control inbound and outbound traffic and
        /// provides security for the resources that you’ll be accessing on the VPC. This ID number is
        /// preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security
        /// Groups for your VPC</a>. </p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The ID for each subnet being used in your private VPC. This subnet is a subset of the a
        /// range of IPv4 addresses used by the VPC and is specific to a given availability zone in the
        /// VPC’s region. This ID number is preceded by "subnet-", for instance:
        /// "subnet-04ccf456919e69055". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and
        /// Subnets</a>. </p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The ID for each subnet being used in your private VPC. This subnet is a subset of the a
        /// range of IPv4 addresses used by the VPC and is specific to a given availability zone in the
        /// VPC’s region. This ID number is preceded by "subnet-", for instance:
        /// "subnet-04ccf456919e69055". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and
        /// Subnets</a>. </p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfig`](crate::model::VpcConfig)
        pub fn build(self) -> crate::model::VpcConfig {
            crate::model::VpcConfig {
                security_group_ids: self.security_group_ids,
                subnets: self.subnets,
            }
        }
    }
}
impl VpcConfig {
    /// Creates a new builder-style object to manufacture [`VpcConfig`](crate::model::VpcConfig)
    pub fn builder() -> crate::model::vpc_config::Builder {
        crate::model::vpc_config::Builder::default()
    }
}

/// <p>Provides configuration parameters for the output of topic detection jobs.</p>
/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputDataConfig {
    /// <p>When you use the <code>OutputDataConfig</code> object with asynchronous operations, you
    /// specify the Amazon S3 location where you want to write the output data. The URI must be in the
    /// same region as the API endpoint that you are calling. The location is used as the prefix for
    /// the actual location of the output file.</p>
    /// <p>When the topic detection job is finished, the service creates an output file in a
    /// directory specific to the job. The <code>S3Uri</code> field contains the location of the
    /// output file, called <code>output.tar.gz</code>. It is a compressed archive that contains the
    /// ouput of the operation.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
    /// output results from an analysis job. The KmsKeyId can be one of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>KMS Key Alias: <code>"alias/ExampleAlias"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>ARN of a KMS Key Alias:
    /// <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl OutputDataConfig {
    /// <p>When you use the <code>OutputDataConfig</code> object with asynchronous operations, you
    /// specify the Amazon S3 location where you want to write the output data. The URI must be in the
    /// same region as the API endpoint that you are calling. The location is used as the prefix for
    /// the actual location of the output file.</p>
    /// <p>When the topic detection job is finished, the service creates an output file in a
    /// directory specific to the job. The <code>S3Uri</code> field contains the location of the
    /// output file, called <code>output.tar.gz</code>. It is a compressed archive that contains the
    /// ouput of the operation.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
    /// output results from an analysis job. The KmsKeyId can be one of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>KMS Key Alias: <code>"alias/ExampleAlias"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>ARN of a KMS Key Alias:
    /// <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for OutputDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputDataConfig");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`OutputDataConfig`](crate::model::OutputDataConfig)
pub mod output_data_config {
    /// A builder for [`OutputDataConfig`](crate::model::OutputDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>When you use the <code>OutputDataConfig</code> object with asynchronous operations, you
        /// specify the Amazon S3 location where you want to write the output data. The URI must be in the
        /// same region as the API endpoint that you are calling. The location is used as the prefix for
        /// the actual location of the output file.</p>
        /// <p>When the topic detection job is finished, the service creates an output file in a
        /// directory specific to the job. The <code>S3Uri</code> field contains the location of the
        /// output file, called <code>output.tar.gz</code>. It is a compressed archive that contains the
        /// ouput of the operation.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>When you use the <code>OutputDataConfig</code> object with asynchronous operations, you
        /// specify the Amazon S3 location where you want to write the output data. The URI must be in the
        /// same region as the API endpoint that you are calling. The location is used as the prefix for
        /// the actual location of the output file.</p>
        /// <p>When the topic detection job is finished, the service creates an output file in a
        /// directory specific to the job. The <code>S3Uri</code> field contains the location of the
        /// output file, called <code>output.tar.gz</code>. It is a compressed archive that contains the
        /// ouput of the operation.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
        /// output results from an analysis job. The KmsKeyId can be one of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>KMS Key Alias: <code>"alias/ExampleAlias"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ARN of a KMS Key Alias:
        /// <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
        /// output results from an analysis job. The KmsKeyId can be one of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>KMS Key Alias: <code>"alias/ExampleAlias"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ARN of a KMS Key Alias:
        /// <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputDataConfig`](crate::model::OutputDataConfig)
        pub fn build(self) -> crate::model::OutputDataConfig {
            crate::model::OutputDataConfig {
                s3_uri: self.s3_uri,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl OutputDataConfig {
    /// Creates a new builder-style object to manufacture [`OutputDataConfig`](crate::model::OutputDataConfig)
    pub fn builder() -> crate::model::output_data_config::Builder {
        crate::model::output_data_config::Builder::default()
    }
}

/// <p>The input properties for an inference job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDataConfig {
    /// <p>The Amazon S3 URI for the input data. The URI must be in same region as the API
    /// endpoint that you are calling. The URI can point to a single input file or it can provide the
    /// prefix for a collection of data files. </p>
    /// <p>For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a
    /// single file, Amazon Comprehend uses that file as input. If more than one file begins with the
    /// prefix, Amazon Comprehend uses all of them as input.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>Specifies how the text in an input file should be processed:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use
    /// this option when you are processing large documents, such as newspaper articles or
    /// scientific papers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate
    /// document. Use this option when you are processing many short documents, such as text
    /// messages.</p>
    /// </li>
    /// </ul>
    pub input_format: std::option::Option<crate::model::InputFormat>,
    /// <p>The document reader config field applies only for InputDataConfig of StartEntitiesDetectionJob. </p>
    /// <p>Use DocumentReaderConfig to provide specifications about how you want your inference documents read.
    /// Currently it applies for PDF documents in StartEntitiesDetectionJob custom inference.</p>
    pub document_reader_config: std::option::Option<crate::model::DocumentReaderConfig>,
}
impl InputDataConfig {
    /// <p>The Amazon S3 URI for the input data. The URI must be in same region as the API
    /// endpoint that you are calling. The URI can point to a single input file or it can provide the
    /// prefix for a collection of data files. </p>
    /// <p>For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a
    /// single file, Amazon Comprehend uses that file as input. If more than one file begins with the
    /// prefix, Amazon Comprehend uses all of them as input.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>Specifies how the text in an input file should be processed:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use
    /// this option when you are processing large documents, such as newspaper articles or
    /// scientific papers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate
    /// document. Use this option when you are processing many short documents, such as text
    /// messages.</p>
    /// </li>
    /// </ul>
    pub fn input_format(&self) -> std::option::Option<&crate::model::InputFormat> {
        self.input_format.as_ref()
    }
    /// <p>The document reader config field applies only for InputDataConfig of StartEntitiesDetectionJob. </p>
    /// <p>Use DocumentReaderConfig to provide specifications about how you want your inference documents read.
    /// Currently it applies for PDF documents in StartEntitiesDetectionJob custom inference.</p>
    pub fn document_reader_config(
        &self,
    ) -> std::option::Option<&crate::model::DocumentReaderConfig> {
        self.document_reader_config.as_ref()
    }
}
impl std::fmt::Debug for InputDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDataConfig");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("input_format", &self.input_format);
        formatter.field("document_reader_config", &self.document_reader_config);
        formatter.finish()
    }
}
/// See [`InputDataConfig`](crate::model::InputDataConfig)
pub mod input_data_config {
    /// A builder for [`InputDataConfig`](crate::model::InputDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) input_format: std::option::Option<crate::model::InputFormat>,
        pub(crate) document_reader_config: std::option::Option<crate::model::DocumentReaderConfig>,
    }
    impl Builder {
        /// <p>The Amazon S3 URI for the input data. The URI must be in same region as the API
        /// endpoint that you are calling. The URI can point to a single input file or it can provide the
        /// prefix for a collection of data files. </p>
        /// <p>For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a
        /// single file, Amazon Comprehend uses that file as input. If more than one file begins with the
        /// prefix, Amazon Comprehend uses all of them as input.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The Amazon S3 URI for the input data. The URI must be in same region as the API
        /// endpoint that you are calling. The URI can point to a single input file or it can provide the
        /// prefix for a collection of data files. </p>
        /// <p>For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a
        /// single file, Amazon Comprehend uses that file as input. If more than one file begins with the
        /// prefix, Amazon Comprehend uses all of them as input.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>Specifies how the text in an input file should be processed:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use
        /// this option when you are processing large documents, such as newspaper articles or
        /// scientific papers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate
        /// document. Use this option when you are processing many short documents, such as text
        /// messages.</p>
        /// </li>
        /// </ul>
        pub fn input_format(mut self, input: crate::model::InputFormat) -> Self {
            self.input_format = Some(input);
            self
        }
        /// <p>Specifies how the text in an input file should be processed:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use
        /// this option when you are processing large documents, such as newspaper articles or
        /// scientific papers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate
        /// document. Use this option when you are processing many short documents, such as text
        /// messages.</p>
        /// </li>
        /// </ul>
        pub fn set_input_format(
            mut self,
            input: std::option::Option<crate::model::InputFormat>,
        ) -> Self {
            self.input_format = input;
            self
        }
        /// <p>The document reader config field applies only for InputDataConfig of StartEntitiesDetectionJob. </p>
        /// <p>Use DocumentReaderConfig to provide specifications about how you want your inference documents read.
        /// Currently it applies for PDF documents in StartEntitiesDetectionJob custom inference.</p>
        pub fn document_reader_config(mut self, input: crate::model::DocumentReaderConfig) -> Self {
            self.document_reader_config = Some(input);
            self
        }
        /// <p>The document reader config field applies only for InputDataConfig of StartEntitiesDetectionJob. </p>
        /// <p>Use DocumentReaderConfig to provide specifications about how you want your inference documents read.
        /// Currently it applies for PDF documents in StartEntitiesDetectionJob custom inference.</p>
        pub fn set_document_reader_config(
            mut self,
            input: std::option::Option<crate::model::DocumentReaderConfig>,
        ) -> Self {
            self.document_reader_config = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDataConfig`](crate::model::InputDataConfig)
        pub fn build(self) -> crate::model::InputDataConfig {
            crate::model::InputDataConfig {
                s3_uri: self.s3_uri,
                input_format: self.input_format,
                document_reader_config: self.document_reader_config,
            }
        }
    }
}
impl InputDataConfig {
    /// Creates a new builder-style object to manufacture [`InputDataConfig`](crate::model::InputDataConfig)
    pub fn builder() -> crate::model::input_data_config::Builder {
        crate::model::input_data_config::Builder::default()
    }
}

/// <p>The input properties for a topic detection job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentReaderConfig {
    /// <p>This enum field will start with two values which will apply to PDFs:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents per page.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.</p>
    /// </li>
    /// </ul>
    pub document_read_action: std::option::Option<crate::model::DocumentReadAction>,
    /// <p>This enum field provides two values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would mean using an internal parser instead of Textract APIs</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction, including Digital PDF.
    /// </p>
    /// </li>
    /// </ul>
    pub document_read_mode: std::option::Option<crate::model::DocumentReadMode>,
    /// <p>Specifies how the text in an input file should be processed:</p>
    pub feature_types: std::option::Option<std::vec::Vec<crate::model::DocumentReadFeatureTypes>>,
}
impl DocumentReaderConfig {
    /// <p>This enum field will start with two values which will apply to PDFs:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents per page.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.</p>
    /// </li>
    /// </ul>
    pub fn document_read_action(&self) -> std::option::Option<&crate::model::DocumentReadAction> {
        self.document_read_action.as_ref()
    }
    /// <p>This enum field provides two values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would mean using an internal parser instead of Textract APIs</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction, including Digital PDF.
    /// </p>
    /// </li>
    /// </ul>
    pub fn document_read_mode(&self) -> std::option::Option<&crate::model::DocumentReadMode> {
        self.document_read_mode.as_ref()
    }
    /// <p>Specifies how the text in an input file should be processed:</p>
    pub fn feature_types(&self) -> std::option::Option<&[crate::model::DocumentReadFeatureTypes]> {
        self.feature_types.as_deref()
    }
}
impl std::fmt::Debug for DocumentReaderConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentReaderConfig");
        formatter.field("document_read_action", &self.document_read_action);
        formatter.field("document_read_mode", &self.document_read_mode);
        formatter.field("feature_types", &self.feature_types);
        formatter.finish()
    }
}
/// See [`DocumentReaderConfig`](crate::model::DocumentReaderConfig)
pub mod document_reader_config {
    /// A builder for [`DocumentReaderConfig`](crate::model::DocumentReaderConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_read_action: std::option::Option<crate::model::DocumentReadAction>,
        pub(crate) document_read_mode: std::option::Option<crate::model::DocumentReadMode>,
        pub(crate) feature_types:
            std::option::Option<std::vec::Vec<crate::model::DocumentReadFeatureTypes>>,
    }
    impl Builder {
        /// <p>This enum field will start with two values which will apply to PDFs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents per page.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.</p>
        /// </li>
        /// </ul>
        pub fn document_read_action(mut self, input: crate::model::DocumentReadAction) -> Self {
            self.document_read_action = Some(input);
            self
        }
        /// <p>This enum field will start with two values which will apply to PDFs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents per page.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.</p>
        /// </li>
        /// </ul>
        pub fn set_document_read_action(
            mut self,
            input: std::option::Option<crate::model::DocumentReadAction>,
        ) -> Self {
            self.document_read_action = input;
            self
        }
        /// <p>This enum field provides two values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would mean using an internal parser instead of Textract APIs</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction, including Digital PDF.
        /// </p>
        /// </li>
        /// </ul>
        pub fn document_read_mode(mut self, input: crate::model::DocumentReadMode) -> Self {
            self.document_read_mode = Some(input);
            self
        }
        /// <p>This enum field provides two values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would mean using an internal parser instead of Textract APIs</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction, including Digital PDF.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_document_read_mode(
            mut self,
            input: std::option::Option<crate::model::DocumentReadMode>,
        ) -> Self {
            self.document_read_mode = input;
            self
        }
        /// Appends an item to `feature_types`.
        ///
        /// To override the contents of this collection use [`set_feature_types`](Self::set_feature_types).
        ///
        /// <p>Specifies how the text in an input file should be processed:</p>
        pub fn feature_types(
            mut self,
            input: impl Into<crate::model::DocumentReadFeatureTypes>,
        ) -> Self {
            let mut v = self.feature_types.unwrap_or_default();
            v.push(input.into());
            self.feature_types = Some(v);
            self
        }
        /// <p>Specifies how the text in an input file should be processed:</p>
        pub fn set_feature_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentReadFeatureTypes>>,
        ) -> Self {
            self.feature_types = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentReaderConfig`](crate::model::DocumentReaderConfig)
        pub fn build(self) -> crate::model::DocumentReaderConfig {
            crate::model::DocumentReaderConfig {
                document_read_action: self.document_read_action,
                document_read_mode: self.document_read_mode,
                feature_types: self.feature_types,
            }
        }
    }
}
impl DocumentReaderConfig {
    /// Creates a new builder-style object to manufacture [`DocumentReaderConfig`](crate::model::DocumentReaderConfig)
    pub fn builder() -> crate::model::document_reader_config::Builder {
        crate::model::document_reader_config::Builder::default()
    }
}

/// <p>A list of the types of analyses to perform. This field specifies what feature types need to be extracted from the document where entity recognition is
/// expected.</p>
///
/// <ul>
/// <li>
/// <p>
/// <code>TABLES</code> - Add TABLES to the list to return information about the tables
/// that are detected in the input document. </p>
/// </li>
/// <li>
/// <p>
/// <code>FORMS</code> - Add FORMS to return detected form data. </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentReadFeatureTypes {
    #[allow(missing_docs)] // documentation missing in model
    Forms,
    #[allow(missing_docs)] // documentation missing in model
    Tables,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentReadFeatureTypes {
    fn from(s: &str) -> Self {
        match s {
            "FORMS" => DocumentReadFeatureTypes::Forms,
            "TABLES" => DocumentReadFeatureTypes::Tables,
            other => DocumentReadFeatureTypes::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentReadFeatureTypes {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentReadFeatureTypes::from(s))
    }
}
impl DocumentReadFeatureTypes {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentReadFeatureTypes::Forms => "FORMS",
            DocumentReadFeatureTypes::Tables => "TABLES",
            DocumentReadFeatureTypes::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FORMS", "TABLES"]
    }
}
impl AsRef<str> for DocumentReadFeatureTypes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentReadMode {
    #[allow(missing_docs)] // documentation missing in model
    ForceDocumentReadAction,
    #[allow(missing_docs)] // documentation missing in model
    ServiceDefault,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentReadMode {
    fn from(s: &str) -> Self {
        match s {
            "FORCE_DOCUMENT_READ_ACTION" => DocumentReadMode::ForceDocumentReadAction,
            "SERVICE_DEFAULT" => DocumentReadMode::ServiceDefault,
            other => DocumentReadMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentReadMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentReadMode::from(s))
    }
}
impl DocumentReadMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentReadMode::ForceDocumentReadAction => "FORCE_DOCUMENT_READ_ACTION",
            DocumentReadMode::ServiceDefault => "SERVICE_DEFAULT",
            DocumentReadMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FORCE_DOCUMENT_READ_ACTION", "SERVICE_DEFAULT"]
    }
}
impl AsRef<str> for DocumentReadMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentReadAction {
    #[allow(missing_docs)] // documentation missing in model
    TextractAnalyzeDocument,
    #[allow(missing_docs)] // documentation missing in model
    TextractDetectDocumentText,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentReadAction {
    fn from(s: &str) -> Self {
        match s {
            "TEXTRACT_ANALYZE_DOCUMENT" => DocumentReadAction::TextractAnalyzeDocument,
            "TEXTRACT_DETECT_DOCUMENT_TEXT" => DocumentReadAction::TextractDetectDocumentText,
            other => DocumentReadAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentReadAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentReadAction::from(s))
    }
}
impl DocumentReadAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentReadAction::TextractAnalyzeDocument => "TEXTRACT_ANALYZE_DOCUMENT",
            DocumentReadAction::TextractDetectDocumentText => "TEXTRACT_DETECT_DOCUMENT_TEXT",
            DocumentReadAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TEXTRACT_ANALYZE_DOCUMENT", "TEXTRACT_DETECT_DOCUMENT_TEXT"]
    }
}
impl AsRef<str> for DocumentReadAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputFormat {
    #[allow(missing_docs)] // documentation missing in model
    OneDocPerFile,
    #[allow(missing_docs)] // documentation missing in model
    OneDocPerLine,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputFormat {
    fn from(s: &str) -> Self {
        match s {
            "ONE_DOC_PER_FILE" => InputFormat::OneDocPerFile,
            "ONE_DOC_PER_LINE" => InputFormat::OneDocPerLine,
            other => InputFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputFormat::from(s))
    }
}
impl InputFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputFormat::OneDocPerFile => "ONE_DOC_PER_FILE",
            InputFormat::OneDocPerLine => "ONE_DOC_PER_LINE",
            InputFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ONE_DOC_PER_FILE", "ONE_DOC_PER_LINE"]
    }
}
impl AsRef<str> for InputFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LanguageCode {
    #[allow(missing_docs)] // documentation missing in model
    Ar,
    #[allow(missing_docs)] // documentation missing in model
    De,
    #[allow(missing_docs)] // documentation missing in model
    En,
    #[allow(missing_docs)] // documentation missing in model
    Es,
    #[allow(missing_docs)] // documentation missing in model
    Fr,
    #[allow(missing_docs)] // documentation missing in model
    Hi,
    #[allow(missing_docs)] // documentation missing in model
    It,
    #[allow(missing_docs)] // documentation missing in model
    Ja,
    #[allow(missing_docs)] // documentation missing in model
    Ko,
    #[allow(missing_docs)] // documentation missing in model
    Pt,
    #[allow(missing_docs)] // documentation missing in model
    Zh,
    #[allow(missing_docs)] // documentation missing in model
    ZhTw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LanguageCode {
    fn from(s: &str) -> Self {
        match s {
            "ar" => LanguageCode::Ar,
            "de" => LanguageCode::De,
            "en" => LanguageCode::En,
            "es" => LanguageCode::Es,
            "fr" => LanguageCode::Fr,
            "hi" => LanguageCode::Hi,
            "it" => LanguageCode::It,
            "ja" => LanguageCode::Ja,
            "ko" => LanguageCode::Ko,
            "pt" => LanguageCode::Pt,
            "zh" => LanguageCode::Zh,
            "zh-TW" => LanguageCode::ZhTw,
            other => LanguageCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LanguageCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LanguageCode::from(s))
    }
}
impl LanguageCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LanguageCode::Ar => "ar",
            LanguageCode::De => "de",
            LanguageCode::En => "en",
            LanguageCode::Es => "es",
            LanguageCode::Fr => "fr",
            LanguageCode::Hi => "hi",
            LanguageCode::It => "it",
            LanguageCode::Ja => "ja",
            LanguageCode::Ko => "ko",
            LanguageCode::Pt => "pt",
            LanguageCode::Zh => "zh",
            LanguageCode::ZhTw => "zh-TW",
            LanguageCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ar", "de", "en", "es", "fr", "hi", "it", "ja", "ko", "pt", "zh", "zh-TW",
        ]
    }
}
impl AsRef<str> for LanguageCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides configuration parameters for PII entity redaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedactionConfig {
    /// <p>An array of the types of PII entities that Amazon Comprehend detects in the input text for
    /// your request.</p>
    pub pii_entity_types: std::option::Option<std::vec::Vec<crate::model::PiiEntityType>>,
    /// <p>Specifies whether the PII entity is redacted with the mask character or the entity
    /// type.</p>
    pub mask_mode: std::option::Option<crate::model::PiiEntitiesDetectionMaskMode>,
    /// <p>A character that replaces each character in the redacted PII entity.</p>
    pub mask_character: std::option::Option<std::string::String>,
}
impl RedactionConfig {
    /// <p>An array of the types of PII entities that Amazon Comprehend detects in the input text for
    /// your request.</p>
    pub fn pii_entity_types(&self) -> std::option::Option<&[crate::model::PiiEntityType]> {
        self.pii_entity_types.as_deref()
    }
    /// <p>Specifies whether the PII entity is redacted with the mask character or the entity
    /// type.</p>
    pub fn mask_mode(&self) -> std::option::Option<&crate::model::PiiEntitiesDetectionMaskMode> {
        self.mask_mode.as_ref()
    }
    /// <p>A character that replaces each character in the redacted PII entity.</p>
    pub fn mask_character(&self) -> std::option::Option<&str> {
        self.mask_character.as_deref()
    }
}
impl std::fmt::Debug for RedactionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedactionConfig");
        formatter.field("pii_entity_types", &self.pii_entity_types);
        formatter.field("mask_mode", &self.mask_mode);
        formatter.field("mask_character", &self.mask_character);
        formatter.finish()
    }
}
/// See [`RedactionConfig`](crate::model::RedactionConfig)
pub mod redaction_config {
    /// A builder for [`RedactionConfig`](crate::model::RedactionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pii_entity_types:
            std::option::Option<std::vec::Vec<crate::model::PiiEntityType>>,
        pub(crate) mask_mode: std::option::Option<crate::model::PiiEntitiesDetectionMaskMode>,
        pub(crate) mask_character: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pii_entity_types`.
        ///
        /// To override the contents of this collection use [`set_pii_entity_types`](Self::set_pii_entity_types).
        ///
        /// <p>An array of the types of PII entities that Amazon Comprehend detects in the input text for
        /// your request.</p>
        pub fn pii_entity_types(mut self, input: impl Into<crate::model::PiiEntityType>) -> Self {
            let mut v = self.pii_entity_types.unwrap_or_default();
            v.push(input.into());
            self.pii_entity_types = Some(v);
            self
        }
        /// <p>An array of the types of PII entities that Amazon Comprehend detects in the input text for
        /// your request.</p>
        pub fn set_pii_entity_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PiiEntityType>>,
        ) -> Self {
            self.pii_entity_types = input;
            self
        }
        /// <p>Specifies whether the PII entity is redacted with the mask character or the entity
        /// type.</p>
        pub fn mask_mode(mut self, input: crate::model::PiiEntitiesDetectionMaskMode) -> Self {
            self.mask_mode = Some(input);
            self
        }
        /// <p>Specifies whether the PII entity is redacted with the mask character or the entity
        /// type.</p>
        pub fn set_mask_mode(
            mut self,
            input: std::option::Option<crate::model::PiiEntitiesDetectionMaskMode>,
        ) -> Self {
            self.mask_mode = input;
            self
        }
        /// <p>A character that replaces each character in the redacted PII entity.</p>
        pub fn mask_character(mut self, input: impl Into<std::string::String>) -> Self {
            self.mask_character = Some(input.into());
            self
        }
        /// <p>A character that replaces each character in the redacted PII entity.</p>
        pub fn set_mask_character(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mask_character = input;
            self
        }
        /// Consumes the builder and constructs a [`RedactionConfig`](crate::model::RedactionConfig)
        pub fn build(self) -> crate::model::RedactionConfig {
            crate::model::RedactionConfig {
                pii_entity_types: self.pii_entity_types,
                mask_mode: self.mask_mode,
                mask_character: self.mask_character,
            }
        }
    }
}
impl RedactionConfig {
    /// Creates a new builder-style object to manufacture [`RedactionConfig`](crate::model::RedactionConfig)
    pub fn builder() -> crate::model::redaction_config::Builder {
        crate::model::redaction_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PiiEntitiesDetectionMaskMode {
    #[allow(missing_docs)] // documentation missing in model
    Mask,
    #[allow(missing_docs)] // documentation missing in model
    ReplaceWithPiiEntityType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PiiEntitiesDetectionMaskMode {
    fn from(s: &str) -> Self {
        match s {
            "MASK" => PiiEntitiesDetectionMaskMode::Mask,
            "REPLACE_WITH_PII_ENTITY_TYPE" => {
                PiiEntitiesDetectionMaskMode::ReplaceWithPiiEntityType
            }
            other => PiiEntitiesDetectionMaskMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PiiEntitiesDetectionMaskMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PiiEntitiesDetectionMaskMode::from(s))
    }
}
impl PiiEntitiesDetectionMaskMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PiiEntitiesDetectionMaskMode::Mask => "MASK",
            PiiEntitiesDetectionMaskMode::ReplaceWithPiiEntityType => {
                "REPLACE_WITH_PII_ENTITY_TYPE"
            }
            PiiEntitiesDetectionMaskMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MASK", "REPLACE_WITH_PII_ENTITY_TYPE"]
    }
}
impl AsRef<str> for PiiEntitiesDetectionMaskMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PiiEntityType {
    #[allow(missing_docs)] // documentation missing in model
    Address,
    #[allow(missing_docs)] // documentation missing in model
    Age,
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    AwsAccessKey,
    #[allow(missing_docs)] // documentation missing in model
    AwsSecretKey,
    #[allow(missing_docs)] // documentation missing in model
    BankAccountNumber,
    #[allow(missing_docs)] // documentation missing in model
    BankRouting,
    #[allow(missing_docs)] // documentation missing in model
    CreditDebitCvv,
    #[allow(missing_docs)] // documentation missing in model
    CreditDebitExpiry,
    #[allow(missing_docs)] // documentation missing in model
    CreditDebitNumber,
    #[allow(missing_docs)] // documentation missing in model
    DateTime,
    #[allow(missing_docs)] // documentation missing in model
    DriverId,
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    IpAddress,
    #[allow(missing_docs)] // documentation missing in model
    MacAddress,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    PassportNumber,
    #[allow(missing_docs)] // documentation missing in model
    Password,
    #[allow(missing_docs)] // documentation missing in model
    Phone,
    #[allow(missing_docs)] // documentation missing in model
    Pin,
    #[allow(missing_docs)] // documentation missing in model
    Ssn,
    #[allow(missing_docs)] // documentation missing in model
    Url,
    #[allow(missing_docs)] // documentation missing in model
    Username,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PiiEntityType {
    fn from(s: &str) -> Self {
        match s {
            "ADDRESS" => PiiEntityType::Address,
            "AGE" => PiiEntityType::Age,
            "ALL" => PiiEntityType::All,
            "AWS_ACCESS_KEY" => PiiEntityType::AwsAccessKey,
            "AWS_SECRET_KEY" => PiiEntityType::AwsSecretKey,
            "BANK_ACCOUNT_NUMBER" => PiiEntityType::BankAccountNumber,
            "BANK_ROUTING" => PiiEntityType::BankRouting,
            "CREDIT_DEBIT_CVV" => PiiEntityType::CreditDebitCvv,
            "CREDIT_DEBIT_EXPIRY" => PiiEntityType::CreditDebitExpiry,
            "CREDIT_DEBIT_NUMBER" => PiiEntityType::CreditDebitNumber,
            "DATE_TIME" => PiiEntityType::DateTime,
            "DRIVER_ID" => PiiEntityType::DriverId,
            "EMAIL" => PiiEntityType::Email,
            "IP_ADDRESS" => PiiEntityType::IpAddress,
            "MAC_ADDRESS" => PiiEntityType::MacAddress,
            "NAME" => PiiEntityType::Name,
            "PASSPORT_NUMBER" => PiiEntityType::PassportNumber,
            "PASSWORD" => PiiEntityType::Password,
            "PHONE" => PiiEntityType::Phone,
            "PIN" => PiiEntityType::Pin,
            "SSN" => PiiEntityType::Ssn,
            "URL" => PiiEntityType::Url,
            "USERNAME" => PiiEntityType::Username,
            other => PiiEntityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PiiEntityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PiiEntityType::from(s))
    }
}
impl PiiEntityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PiiEntityType::Address => "ADDRESS",
            PiiEntityType::Age => "AGE",
            PiiEntityType::All => "ALL",
            PiiEntityType::AwsAccessKey => "AWS_ACCESS_KEY",
            PiiEntityType::AwsSecretKey => "AWS_SECRET_KEY",
            PiiEntityType::BankAccountNumber => "BANK_ACCOUNT_NUMBER",
            PiiEntityType::BankRouting => "BANK_ROUTING",
            PiiEntityType::CreditDebitCvv => "CREDIT_DEBIT_CVV",
            PiiEntityType::CreditDebitExpiry => "CREDIT_DEBIT_EXPIRY",
            PiiEntityType::CreditDebitNumber => "CREDIT_DEBIT_NUMBER",
            PiiEntityType::DateTime => "DATE_TIME",
            PiiEntityType::DriverId => "DRIVER_ID",
            PiiEntityType::Email => "EMAIL",
            PiiEntityType::IpAddress => "IP_ADDRESS",
            PiiEntityType::MacAddress => "MAC_ADDRESS",
            PiiEntityType::Name => "NAME",
            PiiEntityType::PassportNumber => "PASSPORT_NUMBER",
            PiiEntityType::Password => "PASSWORD",
            PiiEntityType::Phone => "PHONE",
            PiiEntityType::Pin => "PIN",
            PiiEntityType::Ssn => "SSN",
            PiiEntityType::Url => "URL",
            PiiEntityType::Username => "USERNAME",
            PiiEntityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDRESS",
            "AGE",
            "ALL",
            "AWS_ACCESS_KEY",
            "AWS_SECRET_KEY",
            "BANK_ACCOUNT_NUMBER",
            "BANK_ROUTING",
            "CREDIT_DEBIT_CVV",
            "CREDIT_DEBIT_EXPIRY",
            "CREDIT_DEBIT_NUMBER",
            "DATE_TIME",
            "DRIVER_ID",
            "EMAIL",
            "IP_ADDRESS",
            "MAC_ADDRESS",
            "NAME",
            "PASSPORT_NUMBER",
            "PASSWORD",
            "PHONE",
            "PIN",
            "SSN",
            "URL",
            "USERNAME",
        ]
    }
}
impl AsRef<str> for PiiEntityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PiiEntitiesDetectionMode {
    #[allow(missing_docs)] // documentation missing in model
    OnlyOffsets,
    #[allow(missing_docs)] // documentation missing in model
    OnlyRedaction,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PiiEntitiesDetectionMode {
    fn from(s: &str) -> Self {
        match s {
            "ONLY_OFFSETS" => PiiEntitiesDetectionMode::OnlyOffsets,
            "ONLY_REDACTION" => PiiEntitiesDetectionMode::OnlyRedaction,
            other => PiiEntitiesDetectionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PiiEntitiesDetectionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PiiEntitiesDetectionMode::from(s))
    }
}
impl PiiEntitiesDetectionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PiiEntitiesDetectionMode::OnlyOffsets => "ONLY_OFFSETS",
            PiiEntitiesDetectionMode::OnlyRedaction => "ONLY_REDACTION",
            PiiEntitiesDetectionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ONLY_OFFSETS", "ONLY_REDACTION"]
    }
}
impl AsRef<str> for PiiEntitiesDetectionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about a topic detection job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TopicsDetectionJobProperties {
    /// <p>The identifier assigned to the topic detection job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the topics detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:topics-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:topics-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the topic detection job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The current status of the topic detection job. If the status is <code>Failed</code>,
    /// the reason for the failure is shown in the <code>Message</code> field.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>A description for the status of a job.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time that the topic detection job was submitted for processing.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the topic detection job was completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The input data configuration supplied when you created the topic detection
    /// job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data configuration supplied when you created the topic detection
    /// job.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The number of topics to detect supplied when you created the topic detection job. The
    /// default is 10. </p>
    pub number_of_topics: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
    /// Amazon Comprehend read access to your job data. </p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p>Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
}
impl TopicsDetectionJobProperties {
    /// <p>The identifier assigned to the topic detection job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the topics detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:topics-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:topics-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The name of the topic detection job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The current status of the topic detection job. If the status is <code>Failed</code>,
    /// the reason for the failure is shown in the <code>Message</code> field.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>A description for the status of a job.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time that the topic detection job was submitted for processing.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time.as_ref()
    }
    /// <p>The time that the topic detection job was completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The input data configuration supplied when you created the topic detection
    /// job.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>The output data configuration supplied when you created the topic detection
    /// job.</p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>The number of topics to detect supplied when you created the topic detection job. The
    /// default is 10. </p>
    pub fn number_of_topics(&self) -> std::option::Option<i32> {
        self.number_of_topics
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
    /// Amazon Comprehend read access to your job data. </p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn volume_kms_key_id(&self) -> std::option::Option<&str> {
        self.volume_kms_key_id.as_deref()
    }
    /// <p>Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
}
impl std::fmt::Debug for TopicsDetectionJobProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TopicsDetectionJobProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("message", &self.message);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("number_of_topics", &self.number_of_topics);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.finish()
    }
}
/// See [`TopicsDetectionJobProperties`](crate::model::TopicsDetectionJobProperties)
pub mod topics_detection_job_properties {
    /// A builder for [`TopicsDetectionJobProperties`](crate::model::TopicsDetectionJobProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) number_of_topics: std::option::Option<i32>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
    }
    impl Builder {
        /// <p>The identifier assigned to the topic detection job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier assigned to the topic detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the topics detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:topics-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:topics-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the topics detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:topics-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:topics-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The name of the topic detection job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the topic detection job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The current status of the topic detection job. If the status is <code>Failed</code>,
        /// the reason for the failure is shown in the <code>Message</code> field.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the topic detection job. If the status is <code>Failed</code>,
        /// the reason for the failure is shown in the <code>Message</code> field.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>A description for the status of a job.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description for the status of a job.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time that the topic detection job was submitted for processing.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time that the topic detection job was submitted for processing.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time that the topic detection job was completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the topic detection job was completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The input data configuration supplied when you created the topic detection
        /// job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data configuration supplied when you created the topic detection
        /// job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data configuration supplied when you created the topic detection
        /// job.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration supplied when you created the topic detection
        /// job.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The number of topics to detect supplied when you created the topic detection job. The
        /// default is 10. </p>
        pub fn number_of_topics(mut self, input: i32) -> Self {
            self.number_of_topics = Some(input);
            self
        }
        /// <p>The number of topics to detect supplied when you created the topic detection job. The
        /// default is 10. </p>
        pub fn set_number_of_topics(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_topics = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your job data. </p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your job data. </p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p>Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Consumes the builder and constructs a [`TopicsDetectionJobProperties`](crate::model::TopicsDetectionJobProperties)
        pub fn build(self) -> crate::model::TopicsDetectionJobProperties {
            crate::model::TopicsDetectionJobProperties {
                job_id: self.job_id,
                job_arn: self.job_arn,
                job_name: self.job_name,
                job_status: self.job_status,
                message: self.message,
                submit_time: self.submit_time,
                end_time: self.end_time,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                number_of_topics: self.number_of_topics,
                data_access_role_arn: self.data_access_role_arn,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
            }
        }
    }
}
impl TopicsDetectionJobProperties {
    /// Creates a new builder-style object to manufacture [`TopicsDetectionJobProperties`](crate::model::TopicsDetectionJobProperties)
    pub fn builder() -> crate::model::topics_detection_job_properties::Builder {
        crate::model::topics_detection_job_properties::Builder::default()
    }
}

/// <p>Provides information for filtering topic detection jobs. For more information, see
/// .</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TopicsDetectionJobFilter {
    /// <p></p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>Filters the list of topic detection jobs based on job status. Returns only jobs with
    /// the specified status.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Only returns jobs submitted before the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub submit_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Only returns jobs submitted after the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub submit_time_after: std::option::Option<aws_smithy_types::Instant>,
}
impl TopicsDetectionJobFilter {
    /// <p></p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>Filters the list of topic detection jobs based on job status. Returns only jobs with
    /// the specified status.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Only returns jobs submitted before the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub fn submit_time_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_before.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Only returns jobs submitted after the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub fn submit_time_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_after.as_ref()
    }
}
impl std::fmt::Debug for TopicsDetectionJobFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TopicsDetectionJobFilter");
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submit_time_before", &self.submit_time_before);
        formatter.field("submit_time_after", &self.submit_time_after);
        formatter.finish()
    }
}
/// See [`TopicsDetectionJobFilter`](crate::model::TopicsDetectionJobFilter)
pub mod topics_detection_job_filter {
    /// A builder for [`TopicsDetectionJobFilter`](crate::model::TopicsDetectionJobFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submit_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) submit_time_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p></p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>Filters the list of topic detection jobs based on job status. Returns only jobs with
        /// the specified status.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>Filters the list of topic detection jobs based on job status. Returns only jobs with
        /// the specified status.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Only returns jobs submitted before the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn submit_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_before = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Only returns jobs submitted before the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn set_submit_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_before = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Only returns jobs submitted after the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn submit_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_after = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Only returns jobs submitted after the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn set_submit_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_after = input;
            self
        }
        /// Consumes the builder and constructs a [`TopicsDetectionJobFilter`](crate::model::TopicsDetectionJobFilter)
        pub fn build(self) -> crate::model::TopicsDetectionJobFilter {
            crate::model::TopicsDetectionJobFilter {
                job_name: self.job_name,
                job_status: self.job_status,
                submit_time_before: self.submit_time_before,
                submit_time_after: self.submit_time_after,
            }
        }
    }
}
impl TopicsDetectionJobFilter {
    /// Creates a new builder-style object to manufacture [`TopicsDetectionJobFilter`](crate::model::TopicsDetectionJobFilter)
    pub fn builder() -> crate::model::topics_detection_job_filter::Builder {
        crate::model::topics_detection_job_filter::Builder::default()
    }
}

/// <p>Provides information about a sentiment detection job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SentimentDetectionJobProperties {
    /// <p>The identifier assigned to the sentiment detection job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:sentiment-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The name that you assigned to the sentiment detection job</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The current status of the sentiment detection job. If the status is <code>FAILED</code>,
    /// the <code>Messages</code> field shows the reason for the failure.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>A description of the status of a job.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time that the sentiment detection job was submitted for processing.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the sentiment detection job ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The input data configuration that you supplied when you created the sentiment detection
    /// job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data configuration that you supplied when you created the sentiment detection
    /// job.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The language code of the input documents.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
    /// data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
}
impl SentimentDetectionJobProperties {
    /// <p>The identifier assigned to the sentiment detection job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:sentiment-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The name that you assigned to the sentiment detection job</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The current status of the sentiment detection job. If the status is <code>FAILED</code>,
    /// the <code>Messages</code> field shows the reason for the failure.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>A description of the status of a job.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time that the sentiment detection job was submitted for processing.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time.as_ref()
    }
    /// <p>The time that the sentiment detection job ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The input data configuration that you supplied when you created the sentiment detection
    /// job.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>The output data configuration that you supplied when you created the sentiment detection
    /// job.</p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>The language code of the input documents.</p>
    pub fn language_code(&self) -> std::option::Option<&crate::model::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
    /// data.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn volume_kms_key_id(&self) -> std::option::Option<&str> {
        self.volume_kms_key_id.as_deref()
    }
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
}
impl std::fmt::Debug for SentimentDetectionJobProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SentimentDetectionJobProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("message", &self.message);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("language_code", &self.language_code);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.finish()
    }
}
/// See [`SentimentDetectionJobProperties`](crate::model::SentimentDetectionJobProperties)
pub mod sentiment_detection_job_properties {
    /// A builder for [`SentimentDetectionJobProperties`](crate::model::SentimentDetectionJobProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
    }
    impl Builder {
        /// <p>The identifier assigned to the sentiment detection job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier assigned to the sentiment detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:sentiment-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:sentiment-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The name that you assigned to the sentiment detection job</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name that you assigned to the sentiment detection job</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The current status of the sentiment detection job. If the status is <code>FAILED</code>,
        /// the <code>Messages</code> field shows the reason for the failure.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the sentiment detection job. If the status is <code>FAILED</code>,
        /// the <code>Messages</code> field shows the reason for the failure.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>A description of the status of a job.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the status of a job.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time that the sentiment detection job was submitted for processing.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time that the sentiment detection job was submitted for processing.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time that the sentiment detection job ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the sentiment detection job ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The input data configuration that you supplied when you created the sentiment detection
        /// job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data configuration that you supplied when you created the sentiment detection
        /// job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data configuration that you supplied when you created the sentiment detection
        /// job.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration that you supplied when you created the sentiment detection
        /// job.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
        /// data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
        /// data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Consumes the builder and constructs a [`SentimentDetectionJobProperties`](crate::model::SentimentDetectionJobProperties)
        pub fn build(self) -> crate::model::SentimentDetectionJobProperties {
            crate::model::SentimentDetectionJobProperties {
                job_id: self.job_id,
                job_arn: self.job_arn,
                job_name: self.job_name,
                job_status: self.job_status,
                message: self.message,
                submit_time: self.submit_time,
                end_time: self.end_time,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                language_code: self.language_code,
                data_access_role_arn: self.data_access_role_arn,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
            }
        }
    }
}
impl SentimentDetectionJobProperties {
    /// Creates a new builder-style object to manufacture [`SentimentDetectionJobProperties`](crate::model::SentimentDetectionJobProperties)
    pub fn builder() -> crate::model::sentiment_detection_job_properties::Builder {
        crate::model::sentiment_detection_job_properties::Builder::default()
    }
}

/// <p>Provides information for filtering a list of dominant language detection jobs. For more
/// information, see the  operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SentimentDetectionJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub submit_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub submit_time_after: std::option::Option<aws_smithy_types::Instant>,
}
impl SentimentDetectionJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub fn submit_time_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_before.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub fn submit_time_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_after.as_ref()
    }
}
impl std::fmt::Debug for SentimentDetectionJobFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SentimentDetectionJobFilter");
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submit_time_before", &self.submit_time_before);
        formatter.field("submit_time_after", &self.submit_time_after);
        formatter.finish()
    }
}
/// See [`SentimentDetectionJobFilter`](crate::model::SentimentDetectionJobFilter)
pub mod sentiment_detection_job_filter {
    /// A builder for [`SentimentDetectionJobFilter`](crate::model::SentimentDetectionJobFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submit_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) submit_time_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Filters on the name of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>Filters on the name of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn submit_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_before = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn set_submit_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_before = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn submit_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_after = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn set_submit_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_after = input;
            self
        }
        /// Consumes the builder and constructs a [`SentimentDetectionJobFilter`](crate::model::SentimentDetectionJobFilter)
        pub fn build(self) -> crate::model::SentimentDetectionJobFilter {
            crate::model::SentimentDetectionJobFilter {
                job_name: self.job_name,
                job_status: self.job_status,
                submit_time_before: self.submit_time_before,
                submit_time_after: self.submit_time_after,
            }
        }
    }
}
impl SentimentDetectionJobFilter {
    /// Creates a new builder-style object to manufacture [`SentimentDetectionJobFilter`](crate::model::SentimentDetectionJobFilter)
    pub fn builder() -> crate::model::sentiment_detection_job_filter::Builder {
        crate::model::sentiment_detection_job_filter::Builder::default()
    }
}

/// <p>Provides information about a PII entities detection job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PiiEntitiesDetectionJobProperties {
    /// <p>The identifier assigned to the PII entities detection job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the PII entities detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:pii-entities-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The name that you assigned the PII entities detection job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The current status of the PII entities detection job. If the status is
    /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>A description of the status of a job.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time that the PII entities detection job was submitted for processing.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the PII entities detection job completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The input properties for a PII entities detection job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data configuration that you supplied when you created the PII entities
    /// detection job.</p>
    pub output_data_config: std::option::Option<crate::model::PiiOutputDataConfig>,
    /// <p>Provides configuration parameters for PII entity redaction.</p>
    /// <p>This parameter is required if you set the <code>Mode</code> parameter to
    /// <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code>
    /// definition that includes the <code>PiiEntityTypes</code> parameter.</p>
    pub redaction_config: std::option::Option<crate::model::RedactionConfig>,
    /// <p>The language code of the input documents</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
    /// data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in
    /// which PII entities are redacted.</p>
    pub mode: std::option::Option<crate::model::PiiEntitiesDetectionMode>,
}
impl PiiEntitiesDetectionJobProperties {
    /// <p>The identifier assigned to the PII entities detection job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the PII entities detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:pii-entities-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The name that you assigned the PII entities detection job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The current status of the PII entities detection job. If the status is
    /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>A description of the status of a job.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time that the PII entities detection job was submitted for processing.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time.as_ref()
    }
    /// <p>The time that the PII entities detection job completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The input properties for a PII entities detection job.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>The output data configuration that you supplied when you created the PII entities
    /// detection job.</p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::PiiOutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>Provides configuration parameters for PII entity redaction.</p>
    /// <p>This parameter is required if you set the <code>Mode</code> parameter to
    /// <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code>
    /// definition that includes the <code>PiiEntityTypes</code> parameter.</p>
    pub fn redaction_config(&self) -> std::option::Option<&crate::model::RedactionConfig> {
        self.redaction_config.as_ref()
    }
    /// <p>The language code of the input documents</p>
    pub fn language_code(&self) -> std::option::Option<&crate::model::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
    /// data.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in
    /// which PII entities are redacted.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::PiiEntitiesDetectionMode> {
        self.mode.as_ref()
    }
}
impl std::fmt::Debug for PiiEntitiesDetectionJobProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PiiEntitiesDetectionJobProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("message", &self.message);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("redaction_config", &self.redaction_config);
        formatter.field("language_code", &self.language_code);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("mode", &self.mode);
        formatter.finish()
    }
}
/// See [`PiiEntitiesDetectionJobProperties`](crate::model::PiiEntitiesDetectionJobProperties)
pub mod pii_entities_detection_job_properties {
    /// A builder for [`PiiEntitiesDetectionJobProperties`](crate::model::PiiEntitiesDetectionJobProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::PiiOutputDataConfig>,
        pub(crate) redaction_config: std::option::Option<crate::model::RedactionConfig>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::PiiEntitiesDetectionMode>,
    }
    impl Builder {
        /// <p>The identifier assigned to the PII entities detection job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier assigned to the PII entities detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the PII entities detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:pii-entities-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the PII entities detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:pii-entities-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The name that you assigned the PII entities detection job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name that you assigned the PII entities detection job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The current status of the PII entities detection job. If the status is
        /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the PII entities detection job. If the status is
        /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>A description of the status of a job.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the status of a job.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time that the PII entities detection job was submitted for processing.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time that the PII entities detection job was submitted for processing.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time that the PII entities detection job completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the PII entities detection job completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The input properties for a PII entities detection job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input properties for a PII entities detection job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data configuration that you supplied when you created the PII entities
        /// detection job.</p>
        pub fn output_data_config(mut self, input: crate::model::PiiOutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration that you supplied when you created the PII entities
        /// detection job.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::PiiOutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>Provides configuration parameters for PII entity redaction.</p>
        /// <p>This parameter is required if you set the <code>Mode</code> parameter to
        /// <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code>
        /// definition that includes the <code>PiiEntityTypes</code> parameter.</p>
        pub fn redaction_config(mut self, input: crate::model::RedactionConfig) -> Self {
            self.redaction_config = Some(input);
            self
        }
        /// <p>Provides configuration parameters for PII entity redaction.</p>
        /// <p>This parameter is required if you set the <code>Mode</code> parameter to
        /// <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code>
        /// definition that includes the <code>PiiEntityTypes</code> parameter.</p>
        pub fn set_redaction_config(
            mut self,
            input: std::option::Option<crate::model::RedactionConfig>,
        ) -> Self {
            self.redaction_config = input;
            self
        }
        /// <p>The language code of the input documents</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the input documents</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
        /// data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
        /// data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in
        /// which PII entities are redacted.</p>
        pub fn mode(mut self, input: crate::model::PiiEntitiesDetectionMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in
        /// which PII entities are redacted.</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::PiiEntitiesDetectionMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// Consumes the builder and constructs a [`PiiEntitiesDetectionJobProperties`](crate::model::PiiEntitiesDetectionJobProperties)
        pub fn build(self) -> crate::model::PiiEntitiesDetectionJobProperties {
            crate::model::PiiEntitiesDetectionJobProperties {
                job_id: self.job_id,
                job_arn: self.job_arn,
                job_name: self.job_name,
                job_status: self.job_status,
                message: self.message,
                submit_time: self.submit_time,
                end_time: self.end_time,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                redaction_config: self.redaction_config,
                language_code: self.language_code,
                data_access_role_arn: self.data_access_role_arn,
                mode: self.mode,
            }
        }
    }
}
impl PiiEntitiesDetectionJobProperties {
    /// Creates a new builder-style object to manufacture [`PiiEntitiesDetectionJobProperties`](crate::model::PiiEntitiesDetectionJobProperties)
    pub fn builder() -> crate::model::pii_entities_detection_job_properties::Builder {
        crate::model::pii_entities_detection_job_properties::Builder::default()
    }
}

/// <p>Provides configuration parameters for the output of PII entity detection jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PiiOutputDataConfig {
    /// <p>When you use the <code>PiiOutputDataConfig</code> object with asynchronous operations,
    /// you specify the Amazon S3 location where you want to write the output data. </p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
    /// output results from an analysis job.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl PiiOutputDataConfig {
    /// <p>When you use the <code>PiiOutputDataConfig</code> object with asynchronous operations,
    /// you specify the Amazon S3 location where you want to write the output data. </p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
    /// output results from an analysis job.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for PiiOutputDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PiiOutputDataConfig");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`PiiOutputDataConfig`](crate::model::PiiOutputDataConfig)
pub mod pii_output_data_config {
    /// A builder for [`PiiOutputDataConfig`](crate::model::PiiOutputDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>When you use the <code>PiiOutputDataConfig</code> object with asynchronous operations,
        /// you specify the Amazon S3 location where you want to write the output data. </p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>When you use the <code>PiiOutputDataConfig</code> object with asynchronous operations,
        /// you specify the Amazon S3 location where you want to write the output data. </p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
        /// output results from an analysis job.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
        /// output results from an analysis job.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PiiOutputDataConfig`](crate::model::PiiOutputDataConfig)
        pub fn build(self) -> crate::model::PiiOutputDataConfig {
            crate::model::PiiOutputDataConfig {
                s3_uri: self.s3_uri,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl PiiOutputDataConfig {
    /// Creates a new builder-style object to manufacture [`PiiOutputDataConfig`](crate::model::PiiOutputDataConfig)
    pub fn builder() -> crate::model::pii_output_data_config::Builder {
        crate::model::pii_output_data_config::Builder::default()
    }
}

/// <p>Provides information for filtering a list of PII entity detection jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PiiEntitiesDetectionJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub submit_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub submit_time_after: std::option::Option<aws_smithy_types::Instant>,
}
impl PiiEntitiesDetectionJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub fn submit_time_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_before.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub fn submit_time_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_after.as_ref()
    }
}
impl std::fmt::Debug for PiiEntitiesDetectionJobFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PiiEntitiesDetectionJobFilter");
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submit_time_before", &self.submit_time_before);
        formatter.field("submit_time_after", &self.submit_time_after);
        formatter.finish()
    }
}
/// See [`PiiEntitiesDetectionJobFilter`](crate::model::PiiEntitiesDetectionJobFilter)
pub mod pii_entities_detection_job_filter {
    /// A builder for [`PiiEntitiesDetectionJobFilter`](crate::model::PiiEntitiesDetectionJobFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submit_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) submit_time_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Filters on the name of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>Filters on the name of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn submit_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_before = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn set_submit_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_before = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn submit_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_after = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn set_submit_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_after = input;
            self
        }
        /// Consumes the builder and constructs a [`PiiEntitiesDetectionJobFilter`](crate::model::PiiEntitiesDetectionJobFilter)
        pub fn build(self) -> crate::model::PiiEntitiesDetectionJobFilter {
            crate::model::PiiEntitiesDetectionJobFilter {
                job_name: self.job_name,
                job_status: self.job_status,
                submit_time_before: self.submit_time_before,
                submit_time_after: self.submit_time_after,
            }
        }
    }
}
impl PiiEntitiesDetectionJobFilter {
    /// Creates a new builder-style object to manufacture [`PiiEntitiesDetectionJobFilter`](crate::model::PiiEntitiesDetectionJobFilter)
    pub fn builder() -> crate::model::pii_entities_detection_job_filter::Builder {
        crate::model::pii_entities_detection_job_filter::Builder::default()
    }
}

/// <p>Provides information about a key phrases detection job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyPhrasesDetectionJobProperties {
    /// <p>The identifier assigned to the key phrases detection job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the key phrases detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:key-phrases-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The name that you assigned the key phrases detection job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The current status of the key phrases detection job. If the status is <code>FAILED</code>,
    /// the <code>Message</code> field shows the reason for the failure.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>A description of the status of a job.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time that the key phrases detection job was submitted for processing.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the key phrases detection job completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The input data configuration that you supplied when you created the key phrases detection
    /// job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data configuration that you supplied when you created the key phrases detection
    /// job.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The language code of the input documents.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
    /// data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your key phrases detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
}
impl KeyPhrasesDetectionJobProperties {
    /// <p>The identifier assigned to the key phrases detection job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the key phrases detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:key-phrases-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The name that you assigned the key phrases detection job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The current status of the key phrases detection job. If the status is <code>FAILED</code>,
    /// the <code>Message</code> field shows the reason for the failure.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>A description of the status of a job.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time that the key phrases detection job was submitted for processing.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time.as_ref()
    }
    /// <p>The time that the key phrases detection job completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The input data configuration that you supplied when you created the key phrases detection
    /// job.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>The output data configuration that you supplied when you created the key phrases detection
    /// job.</p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>The language code of the input documents.</p>
    pub fn language_code(&self) -> std::option::Option<&crate::model::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
    /// data.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn volume_kms_key_id(&self) -> std::option::Option<&str> {
        self.volume_kms_key_id.as_deref()
    }
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your key phrases detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
}
impl std::fmt::Debug for KeyPhrasesDetectionJobProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyPhrasesDetectionJobProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("message", &self.message);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("language_code", &self.language_code);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.finish()
    }
}
/// See [`KeyPhrasesDetectionJobProperties`](crate::model::KeyPhrasesDetectionJobProperties)
pub mod key_phrases_detection_job_properties {
    /// A builder for [`KeyPhrasesDetectionJobProperties`](crate::model::KeyPhrasesDetectionJobProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
    }
    impl Builder {
        /// <p>The identifier assigned to the key phrases detection job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier assigned to the key phrases detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the key phrases detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:key-phrases-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the key phrases detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:key-phrases-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The name that you assigned the key phrases detection job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name that you assigned the key phrases detection job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The current status of the key phrases detection job. If the status is <code>FAILED</code>,
        /// the <code>Message</code> field shows the reason for the failure.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the key phrases detection job. If the status is <code>FAILED</code>,
        /// the <code>Message</code> field shows the reason for the failure.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>A description of the status of a job.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the status of a job.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time that the key phrases detection job was submitted for processing.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time that the key phrases detection job was submitted for processing.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time that the key phrases detection job completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the key phrases detection job completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The input data configuration that you supplied when you created the key phrases detection
        /// job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data configuration that you supplied when you created the key phrases detection
        /// job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data configuration that you supplied when you created the key phrases detection
        /// job.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration that you supplied when you created the key phrases detection
        /// job.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
        /// data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
        /// data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your key phrases detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your key phrases detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyPhrasesDetectionJobProperties`](crate::model::KeyPhrasesDetectionJobProperties)
        pub fn build(self) -> crate::model::KeyPhrasesDetectionJobProperties {
            crate::model::KeyPhrasesDetectionJobProperties {
                job_id: self.job_id,
                job_arn: self.job_arn,
                job_name: self.job_name,
                job_status: self.job_status,
                message: self.message,
                submit_time: self.submit_time,
                end_time: self.end_time,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                language_code: self.language_code,
                data_access_role_arn: self.data_access_role_arn,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
            }
        }
    }
}
impl KeyPhrasesDetectionJobProperties {
    /// Creates a new builder-style object to manufacture [`KeyPhrasesDetectionJobProperties`](crate::model::KeyPhrasesDetectionJobProperties)
    pub fn builder() -> crate::model::key_phrases_detection_job_properties::Builder {
        crate::model::key_phrases_detection_job_properties::Builder::default()
    }
}

/// <p>Provides information for filtering a list of dominant language detection jobs. For more
/// information, see the  operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyPhrasesDetectionJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub submit_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub submit_time_after: std::option::Option<aws_smithy_types::Instant>,
}
impl KeyPhrasesDetectionJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub fn submit_time_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_before.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub fn submit_time_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_after.as_ref()
    }
}
impl std::fmt::Debug for KeyPhrasesDetectionJobFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyPhrasesDetectionJobFilter");
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submit_time_before", &self.submit_time_before);
        formatter.field("submit_time_after", &self.submit_time_after);
        formatter.finish()
    }
}
/// See [`KeyPhrasesDetectionJobFilter`](crate::model::KeyPhrasesDetectionJobFilter)
pub mod key_phrases_detection_job_filter {
    /// A builder for [`KeyPhrasesDetectionJobFilter`](crate::model::KeyPhrasesDetectionJobFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submit_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) submit_time_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Filters on the name of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>Filters on the name of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn submit_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_before = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn set_submit_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_before = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn submit_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_after = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn set_submit_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_after = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyPhrasesDetectionJobFilter`](crate::model::KeyPhrasesDetectionJobFilter)
        pub fn build(self) -> crate::model::KeyPhrasesDetectionJobFilter {
            crate::model::KeyPhrasesDetectionJobFilter {
                job_name: self.job_name,
                job_status: self.job_status,
                submit_time_before: self.submit_time_before,
                submit_time_after: self.submit_time_after,
            }
        }
    }
}
impl KeyPhrasesDetectionJobFilter {
    /// Creates a new builder-style object to manufacture [`KeyPhrasesDetectionJobFilter`](crate::model::KeyPhrasesDetectionJobFilter)
    pub fn builder() -> crate::model::key_phrases_detection_job_filter::Builder {
        crate::model::key_phrases_detection_job_filter::Builder::default()
    }
}

/// <p>Provides information about an events detection job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventsDetectionJobProperties {
    /// <p>The identifier assigned to the events detection job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:events-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The name you assigned the events detection job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The current status of the events detection job.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>A description of the status of the events detection job.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time that the events detection job was submitted for processing.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the events detection job completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The input data configuration that you supplied when you created the events detection
    /// job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data configuration that you supplied when you created the events detection
    /// job.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The language code of the input documents.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identify and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to your input data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The types of events that are detected by the job.</p>
    pub target_event_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EventsDetectionJobProperties {
    /// <p>The identifier assigned to the events detection job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:events-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The name you assigned the events detection job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The current status of the events detection job.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>A description of the status of the events detection job.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time that the events detection job was submitted for processing.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time.as_ref()
    }
    /// <p>The time that the events detection job completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The input data configuration that you supplied when you created the events detection
    /// job.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>The output data configuration that you supplied when you created the events detection
    /// job.</p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>The language code of the input documents.</p>
    pub fn language_code(&self) -> std::option::Option<&crate::model::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS Identify and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to your input data.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>The types of events that are detected by the job.</p>
    pub fn target_event_types(&self) -> std::option::Option<&[std::string::String]> {
        self.target_event_types.as_deref()
    }
}
impl std::fmt::Debug for EventsDetectionJobProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventsDetectionJobProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("message", &self.message);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("language_code", &self.language_code);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("target_event_types", &self.target_event_types);
        formatter.finish()
    }
}
/// See [`EventsDetectionJobProperties`](crate::model::EventsDetectionJobProperties)
pub mod events_detection_job_properties {
    /// A builder for [`EventsDetectionJobProperties`](crate::model::EventsDetectionJobProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) target_event_types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier assigned to the events detection job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier assigned to the events detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:events-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:events-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The name you assigned the events detection job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name you assigned the events detection job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The current status of the events detection job.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the events detection job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>A description of the status of the events detection job.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the status of the events detection job.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time that the events detection job was submitted for processing.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time that the events detection job was submitted for processing.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time that the events detection job completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the events detection job completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The input data configuration that you supplied when you created the events detection
        /// job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data configuration that you supplied when you created the events detection
        /// job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data configuration that you supplied when you created the events detection
        /// job.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration that you supplied when you created the events detection
        /// job.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identify and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identify and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// Appends an item to `target_event_types`.
        ///
        /// To override the contents of this collection use [`set_target_event_types`](Self::set_target_event_types).
        ///
        /// <p>The types of events that are detected by the job.</p>
        pub fn target_event_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_event_types.unwrap_or_default();
            v.push(input.into());
            self.target_event_types = Some(v);
            self
        }
        /// <p>The types of events that are detected by the job.</p>
        pub fn set_target_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_event_types = input;
            self
        }
        /// Consumes the builder and constructs a [`EventsDetectionJobProperties`](crate::model::EventsDetectionJobProperties)
        pub fn build(self) -> crate::model::EventsDetectionJobProperties {
            crate::model::EventsDetectionJobProperties {
                job_id: self.job_id,
                job_arn: self.job_arn,
                job_name: self.job_name,
                job_status: self.job_status,
                message: self.message,
                submit_time: self.submit_time,
                end_time: self.end_time,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                language_code: self.language_code,
                data_access_role_arn: self.data_access_role_arn,
                target_event_types: self.target_event_types,
            }
        }
    }
}
impl EventsDetectionJobProperties {
    /// Creates a new builder-style object to manufacture [`EventsDetectionJobProperties`](crate::model::EventsDetectionJobProperties)
    pub fn builder() -> crate::model::events_detection_job_properties::Builder {
        crate::model::events_detection_job_properties::Builder::default()
    }
}

/// <p>Provides information for filtering a list of event detection jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventsDetectionJobFilter {
    /// <p>Filters on the name of the events detection job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub submit_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub submit_time_after: std::option::Option<aws_smithy_types::Instant>,
}
impl EventsDetectionJobFilter {
    /// <p>Filters on the name of the events detection job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub fn submit_time_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_before.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub fn submit_time_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_after.as_ref()
    }
}
impl std::fmt::Debug for EventsDetectionJobFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventsDetectionJobFilter");
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submit_time_before", &self.submit_time_before);
        formatter.field("submit_time_after", &self.submit_time_after);
        formatter.finish()
    }
}
/// See [`EventsDetectionJobFilter`](crate::model::EventsDetectionJobFilter)
pub mod events_detection_job_filter {
    /// A builder for [`EventsDetectionJobFilter`](crate::model::EventsDetectionJobFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submit_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) submit_time_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Filters on the name of the events detection job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>Filters on the name of the events detection job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn submit_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_before = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn set_submit_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_before = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn submit_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_after = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn set_submit_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_after = input;
            self
        }
        /// Consumes the builder and constructs a [`EventsDetectionJobFilter`](crate::model::EventsDetectionJobFilter)
        pub fn build(self) -> crate::model::EventsDetectionJobFilter {
            crate::model::EventsDetectionJobFilter {
                job_name: self.job_name,
                job_status: self.job_status,
                submit_time_before: self.submit_time_before,
                submit_time_after: self.submit_time_after,
            }
        }
    }
}
impl EventsDetectionJobFilter {
    /// Creates a new builder-style object to manufacture [`EventsDetectionJobFilter`](crate::model::EventsDetectionJobFilter)
    pub fn builder() -> crate::model::events_detection_job_filter::Builder {
        crate::model::events_detection_job_filter::Builder::default()
    }
}

/// <p> Describes the information about an entity recognizer and its versions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityRecognizerSummary {
    /// <p> The name that you assigned the entity recognizer.</p>
    pub recognizer_name: std::option::Option<std::string::String>,
    /// <p> The number of versions you created.</p>
    pub number_of_versions: std::option::Option<i32>,
    /// <p> The time that the latest entity recognizer version was submitted for processing.</p>
    pub latest_version_created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The version name you assigned to the latest entity recognizer version.</p>
    pub latest_version_name: std::option::Option<std::string::String>,
    /// <p> Provides the status of the latest entity recognizer version.</p>
    pub latest_version_status: std::option::Option<crate::model::ModelStatus>,
}
impl EntityRecognizerSummary {
    /// <p> The name that you assigned the entity recognizer.</p>
    pub fn recognizer_name(&self) -> std::option::Option<&str> {
        self.recognizer_name.as_deref()
    }
    /// <p> The number of versions you created.</p>
    pub fn number_of_versions(&self) -> std::option::Option<i32> {
        self.number_of_versions
    }
    /// <p> The time that the latest entity recognizer version was submitted for processing.</p>
    pub fn latest_version_created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.latest_version_created_at.as_ref()
    }
    /// <p> The version name you assigned to the latest entity recognizer version.</p>
    pub fn latest_version_name(&self) -> std::option::Option<&str> {
        self.latest_version_name.as_deref()
    }
    /// <p> Provides the status of the latest entity recognizer version.</p>
    pub fn latest_version_status(&self) -> std::option::Option<&crate::model::ModelStatus> {
        self.latest_version_status.as_ref()
    }
}
impl std::fmt::Debug for EntityRecognizerSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityRecognizerSummary");
        formatter.field("recognizer_name", &self.recognizer_name);
        formatter.field("number_of_versions", &self.number_of_versions);
        formatter.field("latest_version_created_at", &self.latest_version_created_at);
        formatter.field("latest_version_name", &self.latest_version_name);
        formatter.field("latest_version_status", &self.latest_version_status);
        formatter.finish()
    }
}
/// See [`EntityRecognizerSummary`](crate::model::EntityRecognizerSummary)
pub mod entity_recognizer_summary {
    /// A builder for [`EntityRecognizerSummary`](crate::model::EntityRecognizerSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recognizer_name: std::option::Option<std::string::String>,
        pub(crate) number_of_versions: std::option::Option<i32>,
        pub(crate) latest_version_created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) latest_version_name: std::option::Option<std::string::String>,
        pub(crate) latest_version_status: std::option::Option<crate::model::ModelStatus>,
    }
    impl Builder {
        /// <p> The name that you assigned the entity recognizer.</p>
        pub fn recognizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recognizer_name = Some(input.into());
            self
        }
        /// <p> The name that you assigned the entity recognizer.</p>
        pub fn set_recognizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recognizer_name = input;
            self
        }
        /// <p> The number of versions you created.</p>
        pub fn number_of_versions(mut self, input: i32) -> Self {
            self.number_of_versions = Some(input);
            self
        }
        /// <p> The number of versions you created.</p>
        pub fn set_number_of_versions(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_versions = input;
            self
        }
        /// <p> The time that the latest entity recognizer version was submitted for processing.</p>
        pub fn latest_version_created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.latest_version_created_at = Some(input);
            self
        }
        /// <p> The time that the latest entity recognizer version was submitted for processing.</p>
        pub fn set_latest_version_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.latest_version_created_at = input;
            self
        }
        /// <p> The version name you assigned to the latest entity recognizer version.</p>
        pub fn latest_version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_version_name = Some(input.into());
            self
        }
        /// <p> The version name you assigned to the latest entity recognizer version.</p>
        pub fn set_latest_version_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_version_name = input;
            self
        }
        /// <p> Provides the status of the latest entity recognizer version.</p>
        pub fn latest_version_status(mut self, input: crate::model::ModelStatus) -> Self {
            self.latest_version_status = Some(input);
            self
        }
        /// <p> Provides the status of the latest entity recognizer version.</p>
        pub fn set_latest_version_status(
            mut self,
            input: std::option::Option<crate::model::ModelStatus>,
        ) -> Self {
            self.latest_version_status = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityRecognizerSummary`](crate::model::EntityRecognizerSummary)
        pub fn build(self) -> crate::model::EntityRecognizerSummary {
            crate::model::EntityRecognizerSummary {
                recognizer_name: self.recognizer_name,
                number_of_versions: self.number_of_versions,
                latest_version_created_at: self.latest_version_created_at,
                latest_version_name: self.latest_version_name,
                latest_version_status: self.latest_version_status,
            }
        }
    }
}
impl EntityRecognizerSummary {
    /// Creates a new builder-style object to manufacture [`EntityRecognizerSummary`](crate::model::EntityRecognizerSummary)
    pub fn builder() -> crate::model::entity_recognizer_summary::Builder {
        crate::model::entity_recognizer_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModelStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    InError,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    StopRequested,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    #[allow(missing_docs)] // documentation missing in model
    Trained,
    #[allow(missing_docs)] // documentation missing in model
    Training,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModelStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETING" => ModelStatus::Deleting,
            "IN_ERROR" => ModelStatus::InError,
            "STOPPED" => ModelStatus::Stopped,
            "STOP_REQUESTED" => ModelStatus::StopRequested,
            "SUBMITTED" => ModelStatus::Submitted,
            "TRAINED" => ModelStatus::Trained,
            "TRAINING" => ModelStatus::Training,
            other => ModelStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModelStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModelStatus::from(s))
    }
}
impl ModelStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModelStatus::Deleting => "DELETING",
            ModelStatus::InError => "IN_ERROR",
            ModelStatus::Stopped => "STOPPED",
            ModelStatus::StopRequested => "STOP_REQUESTED",
            ModelStatus::Submitted => "SUBMITTED",
            ModelStatus::Trained => "TRAINED",
            ModelStatus::Training => "TRAINING",
            ModelStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DELETING",
            "IN_ERROR",
            "STOPPED",
            "STOP_REQUESTED",
            "SUBMITTED",
            "TRAINED",
            "TRAINING",
        ]
    }
}
impl AsRef<str> for ModelStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes information about an entity recognizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityRecognizerProperties {
    /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
    pub entity_recognizer_arn: std::option::Option<std::string::String>,
    /// <p> The language of the input documents. All documents must be in the same language. Only
    /// English ("en") is currently supported.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>Provides the status of the entity recognizer.</p>
    pub status: std::option::Option<crate::model::ModelStatus>,
    /// <p> A description of the status of the recognizer.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time that the recognizer was submitted for processing.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the recognizer creation completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that training of the entity recognizer started.</p>
    pub training_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that training of the entity recognizer was completed.</p>
    pub training_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The input data properties of an entity recognizer.</p>
    pub input_data_config: std::option::Option<crate::model::EntityRecognizerInputDataConfig>,
    /// <p> Provides information about an entity recognizer.</p>
    pub recognizer_metadata: std::option::Option<crate::model::EntityRecognizerMetadata>,
    /// <p> The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
    /// Amazon Comprehend read access to your input data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your custom entity recognizer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// trained custom models. The ModelKmsKeyId can be either of the following formats: </p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub model_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The version name you assigned to the entity recognizer.</p>
    pub version_name: std::option::Option<std::string::String>,
}
impl EntityRecognizerProperties {
    /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
    pub fn entity_recognizer_arn(&self) -> std::option::Option<&str> {
        self.entity_recognizer_arn.as_deref()
    }
    /// <p> The language of the input documents. All documents must be in the same language. Only
    /// English ("en") is currently supported.</p>
    pub fn language_code(&self) -> std::option::Option<&crate::model::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>Provides the status of the entity recognizer.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ModelStatus> {
        self.status.as_ref()
    }
    /// <p> A description of the status of the recognizer.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time that the recognizer was submitted for processing.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time.as_ref()
    }
    /// <p>The time that the recognizer creation completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The time that training of the entity recognizer started.</p>
    pub fn training_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.training_start_time.as_ref()
    }
    /// <p>The time that training of the entity recognizer was completed.</p>
    pub fn training_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.training_end_time.as_ref()
    }
    /// <p>The input data properties of an entity recognizer.</p>
    pub fn input_data_config(
        &self,
    ) -> std::option::Option<&crate::model::EntityRecognizerInputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p> Provides information about an entity recognizer.</p>
    pub fn recognizer_metadata(
        &self,
    ) -> std::option::Option<&crate::model::EntityRecognizerMetadata> {
        self.recognizer_metadata.as_ref()
    }
    /// <p> The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
    /// Amazon Comprehend read access to your input data.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn volume_kms_key_id(&self) -> std::option::Option<&str> {
        self.volume_kms_key_id.as_deref()
    }
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your custom entity recognizer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// trained custom models. The ModelKmsKeyId can be either of the following formats: </p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn model_kms_key_id(&self) -> std::option::Option<&str> {
        self.model_kms_key_id.as_deref()
    }
    /// <p>The version name you assigned to the entity recognizer.</p>
    pub fn version_name(&self) -> std::option::Option<&str> {
        self.version_name.as_deref()
    }
}
impl std::fmt::Debug for EntityRecognizerProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityRecognizerProperties");
        formatter.field("entity_recognizer_arn", &self.entity_recognizer_arn);
        formatter.field("language_code", &self.language_code);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("training_start_time", &self.training_start_time);
        formatter.field("training_end_time", &self.training_end_time);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("recognizer_metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("model_kms_key_id", &self.model_kms_key_id);
        formatter.field("version_name", &self.version_name);
        formatter.finish()
    }
}
/// See [`EntityRecognizerProperties`](crate::model::EntityRecognizerProperties)
pub mod entity_recognizer_properties {
    /// A builder for [`EntityRecognizerProperties`](crate::model::EntityRecognizerProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_recognizer_arn: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) status: std::option::Option<crate::model::ModelStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) training_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) training_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input_data_config:
            std::option::Option<crate::model::EntityRecognizerInputDataConfig>,
        pub(crate) recognizer_metadata: std::option::Option<crate::model::EntityRecognizerMetadata>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) model_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn entity_recognizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_recognizer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entity_recognizer_arn = input;
            self
        }
        /// <p> The language of the input documents. All documents must be in the same language. Only
        /// English ("en") is currently supported.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p> The language of the input documents. All documents must be in the same language. Only
        /// English ("en") is currently supported.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>Provides the status of the entity recognizer.</p>
        pub fn status(mut self, input: crate::model::ModelStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Provides the status of the entity recognizer.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::ModelStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p> A description of the status of the recognizer.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p> A description of the status of the recognizer.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time that the recognizer was submitted for processing.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time that the recognizer was submitted for processing.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time that the recognizer creation completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the recognizer creation completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The time that training of the entity recognizer started.</p>
        pub fn training_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.training_start_time = Some(input);
            self
        }
        /// <p>The time that training of the entity recognizer started.</p>
        pub fn set_training_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.training_start_time = input;
            self
        }
        /// <p>The time that training of the entity recognizer was completed.</p>
        pub fn training_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.training_end_time = Some(input);
            self
        }
        /// <p>The time that training of the entity recognizer was completed.</p>
        pub fn set_training_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.training_end_time = input;
            self
        }
        /// <p>The input data properties of an entity recognizer.</p>
        pub fn input_data_config(
            mut self,
            input: crate::model::EntityRecognizerInputDataConfig,
        ) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data properties of an entity recognizer.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerInputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p> Provides information about an entity recognizer.</p>
        pub fn recognizer_metadata(
            mut self,
            input: crate::model::EntityRecognizerMetadata,
        ) -> Self {
            self.recognizer_metadata = Some(input);
            self
        }
        /// <p> Provides information about an entity recognizer.</p>
        pub fn set_recognizer_metadata(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerMetadata>,
        ) -> Self {
            self.recognizer_metadata = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your custom entity recognizer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your custom entity recognizer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats: </p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn model_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats: </p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_model_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_kms_key_id = input;
            self
        }
        /// <p>The version name you assigned to the entity recognizer.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>The version name you assigned to the entity recognizer.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityRecognizerProperties`](crate::model::EntityRecognizerProperties)
        pub fn build(self) -> crate::model::EntityRecognizerProperties {
            crate::model::EntityRecognizerProperties {
                entity_recognizer_arn: self.entity_recognizer_arn,
                language_code: self.language_code,
                status: self.status,
                message: self.message,
                submit_time: self.submit_time,
                end_time: self.end_time,
                training_start_time: self.training_start_time,
                training_end_time: self.training_end_time,
                input_data_config: self.input_data_config,
                recognizer_metadata: self.recognizer_metadata,
                data_access_role_arn: self.data_access_role_arn,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
                model_kms_key_id: self.model_kms_key_id,
                version_name: self.version_name,
            }
        }
    }
}
impl EntityRecognizerProperties {
    /// Creates a new builder-style object to manufacture [`EntityRecognizerProperties`](crate::model::EntityRecognizerProperties)
    pub fn builder() -> crate::model::entity_recognizer_properties::Builder {
        crate::model::entity_recognizer_properties::Builder::default()
    }
}

/// <p>Detailed information about an entity recognizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityRecognizerMetadata {
    /// <p> The number of documents in the input data that were used to train the entity recognizer.
    /// Typically this is 80 to 90 percent of the input documents.</p>
    pub number_of_trained_documents: std::option::Option<i32>,
    /// <p> The number of documents in the input data that were used to test the entity recognizer.
    /// Typically this is 10 to 20 percent of the input documents.</p>
    pub number_of_test_documents: std::option::Option<i32>,
    /// <p>Detailed information about the accuracy of an entity recognizer.</p>
    pub evaluation_metrics: std::option::Option<crate::model::EntityRecognizerEvaluationMetrics>,
    /// <p>Entity types from the metadata of an entity recognizer.</p>
    pub entity_types: std::option::Option<
        std::vec::Vec<crate::model::EntityRecognizerMetadataEntityTypesListItem>,
    >,
}
impl EntityRecognizerMetadata {
    /// <p> The number of documents in the input data that were used to train the entity recognizer.
    /// Typically this is 80 to 90 percent of the input documents.</p>
    pub fn number_of_trained_documents(&self) -> std::option::Option<i32> {
        self.number_of_trained_documents
    }
    /// <p> The number of documents in the input data that were used to test the entity recognizer.
    /// Typically this is 10 to 20 percent of the input documents.</p>
    pub fn number_of_test_documents(&self) -> std::option::Option<i32> {
        self.number_of_test_documents
    }
    /// <p>Detailed information about the accuracy of an entity recognizer.</p>
    pub fn evaluation_metrics(
        &self,
    ) -> std::option::Option<&crate::model::EntityRecognizerEvaluationMetrics> {
        self.evaluation_metrics.as_ref()
    }
    /// <p>Entity types from the metadata of an entity recognizer.</p>
    pub fn entity_types(
        &self,
    ) -> std::option::Option<&[crate::model::EntityRecognizerMetadataEntityTypesListItem]> {
        self.entity_types.as_deref()
    }
}
impl std::fmt::Debug for EntityRecognizerMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityRecognizerMetadata");
        formatter.field(
            "number_of_trained_documents",
            &self.number_of_trained_documents,
        );
        formatter.field("number_of_test_documents", &self.number_of_test_documents);
        formatter.field("evaluation_metrics", &self.evaluation_metrics);
        formatter.field("entity_types", &self.entity_types);
        formatter.finish()
    }
}
/// See [`EntityRecognizerMetadata`](crate::model::EntityRecognizerMetadata)
pub mod entity_recognizer_metadata {
    /// A builder for [`EntityRecognizerMetadata`](crate::model::EntityRecognizerMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number_of_trained_documents: std::option::Option<i32>,
        pub(crate) number_of_test_documents: std::option::Option<i32>,
        pub(crate) evaluation_metrics:
            std::option::Option<crate::model::EntityRecognizerEvaluationMetrics>,
        pub(crate) entity_types: std::option::Option<
            std::vec::Vec<crate::model::EntityRecognizerMetadataEntityTypesListItem>,
        >,
    }
    impl Builder {
        /// <p> The number of documents in the input data that were used to train the entity recognizer.
        /// Typically this is 80 to 90 percent of the input documents.</p>
        pub fn number_of_trained_documents(mut self, input: i32) -> Self {
            self.number_of_trained_documents = Some(input);
            self
        }
        /// <p> The number of documents in the input data that were used to train the entity recognizer.
        /// Typically this is 80 to 90 percent of the input documents.</p>
        pub fn set_number_of_trained_documents(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_trained_documents = input;
            self
        }
        /// <p> The number of documents in the input data that were used to test the entity recognizer.
        /// Typically this is 10 to 20 percent of the input documents.</p>
        pub fn number_of_test_documents(mut self, input: i32) -> Self {
            self.number_of_test_documents = Some(input);
            self
        }
        /// <p> The number of documents in the input data that were used to test the entity recognizer.
        /// Typically this is 10 to 20 percent of the input documents.</p>
        pub fn set_number_of_test_documents(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_test_documents = input;
            self
        }
        /// <p>Detailed information about the accuracy of an entity recognizer.</p>
        pub fn evaluation_metrics(
            mut self,
            input: crate::model::EntityRecognizerEvaluationMetrics,
        ) -> Self {
            self.evaluation_metrics = Some(input);
            self
        }
        /// <p>Detailed information about the accuracy of an entity recognizer.</p>
        pub fn set_evaluation_metrics(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerEvaluationMetrics>,
        ) -> Self {
            self.evaluation_metrics = input;
            self
        }
        /// Appends an item to `entity_types`.
        ///
        /// To override the contents of this collection use [`set_entity_types`](Self::set_entity_types).
        ///
        /// <p>Entity types from the metadata of an entity recognizer.</p>
        pub fn entity_types(
            mut self,
            input: impl Into<crate::model::EntityRecognizerMetadataEntityTypesListItem>,
        ) -> Self {
            let mut v = self.entity_types.unwrap_or_default();
            v.push(input.into());
            self.entity_types = Some(v);
            self
        }
        /// <p>Entity types from the metadata of an entity recognizer.</p>
        pub fn set_entity_types(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::EntityRecognizerMetadataEntityTypesListItem>,
            >,
        ) -> Self {
            self.entity_types = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityRecognizerMetadata`](crate::model::EntityRecognizerMetadata)
        pub fn build(self) -> crate::model::EntityRecognizerMetadata {
            crate::model::EntityRecognizerMetadata {
                number_of_trained_documents: self.number_of_trained_documents,
                number_of_test_documents: self.number_of_test_documents,
                evaluation_metrics: self.evaluation_metrics,
                entity_types: self.entity_types,
            }
        }
    }
}
impl EntityRecognizerMetadata {
    /// Creates a new builder-style object to manufacture [`EntityRecognizerMetadata`](crate::model::EntityRecognizerMetadata)
    pub fn builder() -> crate::model::entity_recognizer_metadata::Builder {
        crate::model::entity_recognizer_metadata::Builder::default()
    }
}

/// <p>Individual item from the list of entity types in the metadata of an entity
/// recognizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityRecognizerMetadataEntityTypesListItem {
    /// <p>Type of entity from the list of entity types in the metadata of an entity recognizer.
    /// </p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>Detailed information about the accuracy of the entity recognizer for a specific item on
    /// the list of entity types. </p>
    pub evaluation_metrics: std::option::Option<crate::model::EntityTypesEvaluationMetrics>,
    /// <p>Indicates the number of times the given entity type was seen in the training data. </p>
    pub number_of_train_mentions: std::option::Option<i32>,
}
impl EntityRecognizerMetadataEntityTypesListItem {
    /// <p>Type of entity from the list of entity types in the metadata of an entity recognizer.
    /// </p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>Detailed information about the accuracy of the entity recognizer for a specific item on
    /// the list of entity types. </p>
    pub fn evaluation_metrics(
        &self,
    ) -> std::option::Option<&crate::model::EntityTypesEvaluationMetrics> {
        self.evaluation_metrics.as_ref()
    }
    /// <p>Indicates the number of times the given entity type was seen in the training data. </p>
    pub fn number_of_train_mentions(&self) -> std::option::Option<i32> {
        self.number_of_train_mentions
    }
}
impl std::fmt::Debug for EntityRecognizerMetadataEntityTypesListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityRecognizerMetadataEntityTypesListItem");
        formatter.field("r#type", &self.r#type);
        formatter.field("evaluation_metrics", &self.evaluation_metrics);
        formatter.field("number_of_train_mentions", &self.number_of_train_mentions);
        formatter.finish()
    }
}
/// See [`EntityRecognizerMetadataEntityTypesListItem`](crate::model::EntityRecognizerMetadataEntityTypesListItem)
pub mod entity_recognizer_metadata_entity_types_list_item {
    /// A builder for [`EntityRecognizerMetadataEntityTypesListItem`](crate::model::EntityRecognizerMetadataEntityTypesListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) evaluation_metrics:
            std::option::Option<crate::model::EntityTypesEvaluationMetrics>,
        pub(crate) number_of_train_mentions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Type of entity from the list of entity types in the metadata of an entity recognizer.
        /// </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Type of entity from the list of entity types in the metadata of an entity recognizer.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Detailed information about the accuracy of the entity recognizer for a specific item on
        /// the list of entity types. </p>
        pub fn evaluation_metrics(
            mut self,
            input: crate::model::EntityTypesEvaluationMetrics,
        ) -> Self {
            self.evaluation_metrics = Some(input);
            self
        }
        /// <p>Detailed information about the accuracy of the entity recognizer for a specific item on
        /// the list of entity types. </p>
        pub fn set_evaluation_metrics(
            mut self,
            input: std::option::Option<crate::model::EntityTypesEvaluationMetrics>,
        ) -> Self {
            self.evaluation_metrics = input;
            self
        }
        /// <p>Indicates the number of times the given entity type was seen in the training data. </p>
        pub fn number_of_train_mentions(mut self, input: i32) -> Self {
            self.number_of_train_mentions = Some(input);
            self
        }
        /// <p>Indicates the number of times the given entity type was seen in the training data. </p>
        pub fn set_number_of_train_mentions(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_train_mentions = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityRecognizerMetadataEntityTypesListItem`](crate::model::EntityRecognizerMetadataEntityTypesListItem)
        pub fn build(self) -> crate::model::EntityRecognizerMetadataEntityTypesListItem {
            crate::model::EntityRecognizerMetadataEntityTypesListItem {
                r#type: self.r#type,
                evaluation_metrics: self.evaluation_metrics,
                number_of_train_mentions: self.number_of_train_mentions,
            }
        }
    }
}
impl EntityRecognizerMetadataEntityTypesListItem {
    /// Creates a new builder-style object to manufacture [`EntityRecognizerMetadataEntityTypesListItem`](crate::model::EntityRecognizerMetadataEntityTypesListItem)
    pub fn builder() -> crate::model::entity_recognizer_metadata_entity_types_list_item::Builder {
        crate::model::entity_recognizer_metadata_entity_types_list_item::Builder::default()
    }
}

/// <p>Detailed information about the accuracy of an entity recognizer for a specific entity
/// type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityTypesEvaluationMetrics {
    /// <p>A measure of the usefulness of the recognizer results for a specific entity type in the
    /// test data. High precision means that the recognizer returned substantially more relevant
    /// results than irrelevant ones. </p>
    pub precision: std::option::Option<f64>,
    /// <p>A measure of how complete the recognizer results are for a specific entity type in the
    /// test data. High recall means that the recognizer returned most of the relevant results.</p>
    pub recall: std::option::Option<f64>,
    /// <p>A measure of how accurate the recognizer results are for a specific entity type in the
    /// test data. It is derived from the <code>Precision</code> and <code>Recall</code> values. The
    /// <code>F1Score</code> is the harmonic average of the two scores. The highest score is 1, and
    /// the worst score is 0. </p>
    pub f1_score: std::option::Option<f64>,
}
impl EntityTypesEvaluationMetrics {
    /// <p>A measure of the usefulness of the recognizer results for a specific entity type in the
    /// test data. High precision means that the recognizer returned substantially more relevant
    /// results than irrelevant ones. </p>
    pub fn precision(&self) -> std::option::Option<f64> {
        self.precision
    }
    /// <p>A measure of how complete the recognizer results are for a specific entity type in the
    /// test data. High recall means that the recognizer returned most of the relevant results.</p>
    pub fn recall(&self) -> std::option::Option<f64> {
        self.recall
    }
    /// <p>A measure of how accurate the recognizer results are for a specific entity type in the
    /// test data. It is derived from the <code>Precision</code> and <code>Recall</code> values. The
    /// <code>F1Score</code> is the harmonic average of the two scores. The highest score is 1, and
    /// the worst score is 0. </p>
    pub fn f1_score(&self) -> std::option::Option<f64> {
        self.f1_score
    }
}
impl std::fmt::Debug for EntityTypesEvaluationMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityTypesEvaluationMetrics");
        formatter.field("precision", &self.precision);
        formatter.field("recall", &self.recall);
        formatter.field("f1_score", &self.f1_score);
        formatter.finish()
    }
}
/// See [`EntityTypesEvaluationMetrics`](crate::model::EntityTypesEvaluationMetrics)
pub mod entity_types_evaluation_metrics {
    /// A builder for [`EntityTypesEvaluationMetrics`](crate::model::EntityTypesEvaluationMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) precision: std::option::Option<f64>,
        pub(crate) recall: std::option::Option<f64>,
        pub(crate) f1_score: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>A measure of the usefulness of the recognizer results for a specific entity type in the
        /// test data. High precision means that the recognizer returned substantially more relevant
        /// results than irrelevant ones. </p>
        pub fn precision(mut self, input: f64) -> Self {
            self.precision = Some(input);
            self
        }
        /// <p>A measure of the usefulness of the recognizer results for a specific entity type in the
        /// test data. High precision means that the recognizer returned substantially more relevant
        /// results than irrelevant ones. </p>
        pub fn set_precision(mut self, input: std::option::Option<f64>) -> Self {
            self.precision = input;
            self
        }
        /// <p>A measure of how complete the recognizer results are for a specific entity type in the
        /// test data. High recall means that the recognizer returned most of the relevant results.</p>
        pub fn recall(mut self, input: f64) -> Self {
            self.recall = Some(input);
            self
        }
        /// <p>A measure of how complete the recognizer results are for a specific entity type in the
        /// test data. High recall means that the recognizer returned most of the relevant results.</p>
        pub fn set_recall(mut self, input: std::option::Option<f64>) -> Self {
            self.recall = input;
            self
        }
        /// <p>A measure of how accurate the recognizer results are for a specific entity type in the
        /// test data. It is derived from the <code>Precision</code> and <code>Recall</code> values. The
        /// <code>F1Score</code> is the harmonic average of the two scores. The highest score is 1, and
        /// the worst score is 0. </p>
        pub fn f1_score(mut self, input: f64) -> Self {
            self.f1_score = Some(input);
            self
        }
        /// <p>A measure of how accurate the recognizer results are for a specific entity type in the
        /// test data. It is derived from the <code>Precision</code> and <code>Recall</code> values. The
        /// <code>F1Score</code> is the harmonic average of the two scores. The highest score is 1, and
        /// the worst score is 0. </p>
        pub fn set_f1_score(mut self, input: std::option::Option<f64>) -> Self {
            self.f1_score = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityTypesEvaluationMetrics`](crate::model::EntityTypesEvaluationMetrics)
        pub fn build(self) -> crate::model::EntityTypesEvaluationMetrics {
            crate::model::EntityTypesEvaluationMetrics {
                precision: self.precision,
                recall: self.recall,
                f1_score: self.f1_score,
            }
        }
    }
}
impl EntityTypesEvaluationMetrics {
    /// Creates a new builder-style object to manufacture [`EntityTypesEvaluationMetrics`](crate::model::EntityTypesEvaluationMetrics)
    pub fn builder() -> crate::model::entity_types_evaluation_metrics::Builder {
        crate::model::entity_types_evaluation_metrics::Builder::default()
    }
}

/// <p>Detailed information about the accuracy of an entity recognizer. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityRecognizerEvaluationMetrics {
    /// <p>A measure of the usefulness of the recognizer results in the test data. High precision
    /// means that the recognizer returned substantially more relevant results than irrelevant ones.
    /// </p>
    pub precision: std::option::Option<f64>,
    /// <p>A measure of how complete the recognizer results are for the test data. High recall means
    /// that the recognizer returned most of the relevant results.</p>
    pub recall: std::option::Option<f64>,
    /// <p>A measure of how accurate the recognizer results are for the test data. It is derived from
    /// the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the
    /// harmonic average of the two scores. The highest score is 1, and the worst score is 0. </p>
    pub f1_score: std::option::Option<f64>,
}
impl EntityRecognizerEvaluationMetrics {
    /// <p>A measure of the usefulness of the recognizer results in the test data. High precision
    /// means that the recognizer returned substantially more relevant results than irrelevant ones.
    /// </p>
    pub fn precision(&self) -> std::option::Option<f64> {
        self.precision
    }
    /// <p>A measure of how complete the recognizer results are for the test data. High recall means
    /// that the recognizer returned most of the relevant results.</p>
    pub fn recall(&self) -> std::option::Option<f64> {
        self.recall
    }
    /// <p>A measure of how accurate the recognizer results are for the test data. It is derived from
    /// the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the
    /// harmonic average of the two scores. The highest score is 1, and the worst score is 0. </p>
    pub fn f1_score(&self) -> std::option::Option<f64> {
        self.f1_score
    }
}
impl std::fmt::Debug for EntityRecognizerEvaluationMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityRecognizerEvaluationMetrics");
        formatter.field("precision", &self.precision);
        formatter.field("recall", &self.recall);
        formatter.field("f1_score", &self.f1_score);
        formatter.finish()
    }
}
/// See [`EntityRecognizerEvaluationMetrics`](crate::model::EntityRecognizerEvaluationMetrics)
pub mod entity_recognizer_evaluation_metrics {
    /// A builder for [`EntityRecognizerEvaluationMetrics`](crate::model::EntityRecognizerEvaluationMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) precision: std::option::Option<f64>,
        pub(crate) recall: std::option::Option<f64>,
        pub(crate) f1_score: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>A measure of the usefulness of the recognizer results in the test data. High precision
        /// means that the recognizer returned substantially more relevant results than irrelevant ones.
        /// </p>
        pub fn precision(mut self, input: f64) -> Self {
            self.precision = Some(input);
            self
        }
        /// <p>A measure of the usefulness of the recognizer results in the test data. High precision
        /// means that the recognizer returned substantially more relevant results than irrelevant ones.
        /// </p>
        pub fn set_precision(mut self, input: std::option::Option<f64>) -> Self {
            self.precision = input;
            self
        }
        /// <p>A measure of how complete the recognizer results are for the test data. High recall means
        /// that the recognizer returned most of the relevant results.</p>
        pub fn recall(mut self, input: f64) -> Self {
            self.recall = Some(input);
            self
        }
        /// <p>A measure of how complete the recognizer results are for the test data. High recall means
        /// that the recognizer returned most of the relevant results.</p>
        pub fn set_recall(mut self, input: std::option::Option<f64>) -> Self {
            self.recall = input;
            self
        }
        /// <p>A measure of how accurate the recognizer results are for the test data. It is derived from
        /// the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the
        /// harmonic average of the two scores. The highest score is 1, and the worst score is 0. </p>
        pub fn f1_score(mut self, input: f64) -> Self {
            self.f1_score = Some(input);
            self
        }
        /// <p>A measure of how accurate the recognizer results are for the test data. It is derived from
        /// the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the
        /// harmonic average of the two scores. The highest score is 1, and the worst score is 0. </p>
        pub fn set_f1_score(mut self, input: std::option::Option<f64>) -> Self {
            self.f1_score = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityRecognizerEvaluationMetrics`](crate::model::EntityRecognizerEvaluationMetrics)
        pub fn build(self) -> crate::model::EntityRecognizerEvaluationMetrics {
            crate::model::EntityRecognizerEvaluationMetrics {
                precision: self.precision,
                recall: self.recall,
                f1_score: self.f1_score,
            }
        }
    }
}
impl EntityRecognizerEvaluationMetrics {
    /// Creates a new builder-style object to manufacture [`EntityRecognizerEvaluationMetrics`](crate::model::EntityRecognizerEvaluationMetrics)
    pub fn builder() -> crate::model::entity_recognizer_evaluation_metrics::Builder {
        crate::model::entity_recognizer_evaluation_metrics::Builder::default()
    }
}

/// <p>Specifies the format and location of the input data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityRecognizerInputDataConfig {
    /// <p>The format of your training data:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPREHEND_CSV</code>: A CSV file that supplements your training documents. The
    /// CSV file contains information about the custom entities that your trained model will
    /// detect. The required format of the file depends on whether you are providing annotations
    /// or an entity list.</p>
    /// <p>If you use this value, you must provide your CSV file by using either the
    /// <code>Annotations</code> or <code>EntityList</code> parameters. You must provide your
    /// training documents by using the <code>Documents</code> parameter.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AUGMENTED_MANIFEST</code>: A labeled dataset that is produced by Amazon
    /// SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON
    /// object that contains a training document and its labels. Each label annotates a named
    /// entity in the training document. </p>
    /// <p>If you use this value, you must provide the <code>AugmentedManifests</code> parameter
    /// in your request.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the
    /// default.</p>
    pub data_format: std::option::Option<crate::model::EntityRecognizerDataFormat>,
    /// <p>The entity types in the labeled training data that Amazon Comprehend uses to train the
    /// custom entity recognizer. Any entity types that you don't specify are ignored.</p>
    /// <p>A maximum of 25 entity types can be used at one time to train an entity recognizer. Entity
    /// types must not contain the following invalid characters: \n (line break), \\n (escaped line
    /// break), \r (carriage return), \\r (escaped carriage return), \t (tab), \\t (escaped tab),
    /// space, and , (comma). </p>
    pub entity_types: std::option::Option<std::vec::Vec<crate::model::EntityTypesListItem>>,
    /// <p>The S3 location of the folder that contains the training documents for your custom entity
    /// recognizer.</p>
    /// <p>This parameter is required if you set <code>DataFormat</code> to
    /// <code>COMPREHEND_CSV</code>.</p>
    pub documents: std::option::Option<crate::model::EntityRecognizerDocuments>,
    /// <p>The S3 location of the CSV file that annotates your training documents.</p>
    pub annotations: std::option::Option<crate::model::EntityRecognizerAnnotations>,
    /// <p>The S3 location of the CSV file that has the entity list for your custom entity
    /// recognizer.</p>
    pub entity_list: std::option::Option<crate::model::EntityRecognizerEntityList>,
    /// <p>A list of augmented manifest files that provide training data for your custom model. An
    /// augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground
    /// Truth.</p>
    /// <p>This parameter is required if you set <code>DataFormat</code> to
    /// <code>AUGMENTED_MANIFEST</code>.</p>
    pub augmented_manifests:
        std::option::Option<std::vec::Vec<crate::model::AugmentedManifestsListItem>>,
}
impl EntityRecognizerInputDataConfig {
    /// <p>The format of your training data:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPREHEND_CSV</code>: A CSV file that supplements your training documents. The
    /// CSV file contains information about the custom entities that your trained model will
    /// detect. The required format of the file depends on whether you are providing annotations
    /// or an entity list.</p>
    /// <p>If you use this value, you must provide your CSV file by using either the
    /// <code>Annotations</code> or <code>EntityList</code> parameters. You must provide your
    /// training documents by using the <code>Documents</code> parameter.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AUGMENTED_MANIFEST</code>: A labeled dataset that is produced by Amazon
    /// SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON
    /// object that contains a training document and its labels. Each label annotates a named
    /// entity in the training document. </p>
    /// <p>If you use this value, you must provide the <code>AugmentedManifests</code> parameter
    /// in your request.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the
    /// default.</p>
    pub fn data_format(&self) -> std::option::Option<&crate::model::EntityRecognizerDataFormat> {
        self.data_format.as_ref()
    }
    /// <p>The entity types in the labeled training data that Amazon Comprehend uses to train the
    /// custom entity recognizer. Any entity types that you don't specify are ignored.</p>
    /// <p>A maximum of 25 entity types can be used at one time to train an entity recognizer. Entity
    /// types must not contain the following invalid characters: \n (line break), \\n (escaped line
    /// break), \r (carriage return), \\r (escaped carriage return), \t (tab), \\t (escaped tab),
    /// space, and , (comma). </p>
    pub fn entity_types(&self) -> std::option::Option<&[crate::model::EntityTypesListItem]> {
        self.entity_types.as_deref()
    }
    /// <p>The S3 location of the folder that contains the training documents for your custom entity
    /// recognizer.</p>
    /// <p>This parameter is required if you set <code>DataFormat</code> to
    /// <code>COMPREHEND_CSV</code>.</p>
    pub fn documents(&self) -> std::option::Option<&crate::model::EntityRecognizerDocuments> {
        self.documents.as_ref()
    }
    /// <p>The S3 location of the CSV file that annotates your training documents.</p>
    pub fn annotations(&self) -> std::option::Option<&crate::model::EntityRecognizerAnnotations> {
        self.annotations.as_ref()
    }
    /// <p>The S3 location of the CSV file that has the entity list for your custom entity
    /// recognizer.</p>
    pub fn entity_list(&self) -> std::option::Option<&crate::model::EntityRecognizerEntityList> {
        self.entity_list.as_ref()
    }
    /// <p>A list of augmented manifest files that provide training data for your custom model. An
    /// augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground
    /// Truth.</p>
    /// <p>This parameter is required if you set <code>DataFormat</code> to
    /// <code>AUGMENTED_MANIFEST</code>.</p>
    pub fn augmented_manifests(
        &self,
    ) -> std::option::Option<&[crate::model::AugmentedManifestsListItem]> {
        self.augmented_manifests.as_deref()
    }
}
impl std::fmt::Debug for EntityRecognizerInputDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityRecognizerInputDataConfig");
        formatter.field("data_format", &self.data_format);
        formatter.field("entity_types", &self.entity_types);
        formatter.field("documents", &self.documents);
        formatter.field("annotations", &self.annotations);
        formatter.field("entity_list", &self.entity_list);
        formatter.field("augmented_manifests", &self.augmented_manifests);
        formatter.finish()
    }
}
/// See [`EntityRecognizerInputDataConfig`](crate::model::EntityRecognizerInputDataConfig)
pub mod entity_recognizer_input_data_config {
    /// A builder for [`EntityRecognizerInputDataConfig`](crate::model::EntityRecognizerInputDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_format: std::option::Option<crate::model::EntityRecognizerDataFormat>,
        pub(crate) entity_types:
            std::option::Option<std::vec::Vec<crate::model::EntityTypesListItem>>,
        pub(crate) documents: std::option::Option<crate::model::EntityRecognizerDocuments>,
        pub(crate) annotations: std::option::Option<crate::model::EntityRecognizerAnnotations>,
        pub(crate) entity_list: std::option::Option<crate::model::EntityRecognizerEntityList>,
        pub(crate) augmented_manifests:
            std::option::Option<std::vec::Vec<crate::model::AugmentedManifestsListItem>>,
    }
    impl Builder {
        /// <p>The format of your training data:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPREHEND_CSV</code>: A CSV file that supplements your training documents. The
        /// CSV file contains information about the custom entities that your trained model will
        /// detect. The required format of the file depends on whether you are providing annotations
        /// or an entity list.</p>
        /// <p>If you use this value, you must provide your CSV file by using either the
        /// <code>Annotations</code> or <code>EntityList</code> parameters. You must provide your
        /// training documents by using the <code>Documents</code> parameter.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUGMENTED_MANIFEST</code>: A labeled dataset that is produced by Amazon
        /// SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON
        /// object that contains a training document and its labels. Each label annotates a named
        /// entity in the training document. </p>
        /// <p>If you use this value, you must provide the <code>AugmentedManifests</code> parameter
        /// in your request.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the
        /// default.</p>
        pub fn data_format(mut self, input: crate::model::EntityRecognizerDataFormat) -> Self {
            self.data_format = Some(input);
            self
        }
        /// <p>The format of your training data:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPREHEND_CSV</code>: A CSV file that supplements your training documents. The
        /// CSV file contains information about the custom entities that your trained model will
        /// detect. The required format of the file depends on whether you are providing annotations
        /// or an entity list.</p>
        /// <p>If you use this value, you must provide your CSV file by using either the
        /// <code>Annotations</code> or <code>EntityList</code> parameters. You must provide your
        /// training documents by using the <code>Documents</code> parameter.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUGMENTED_MANIFEST</code>: A labeled dataset that is produced by Amazon
        /// SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON
        /// object that contains a training document and its labels. Each label annotates a named
        /// entity in the training document. </p>
        /// <p>If you use this value, you must provide the <code>AugmentedManifests</code> parameter
        /// in your request.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the
        /// default.</p>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerDataFormat>,
        ) -> Self {
            self.data_format = input;
            self
        }
        /// Appends an item to `entity_types`.
        ///
        /// To override the contents of this collection use [`set_entity_types`](Self::set_entity_types).
        ///
        /// <p>The entity types in the labeled training data that Amazon Comprehend uses to train the
        /// custom entity recognizer. Any entity types that you don't specify are ignored.</p>
        /// <p>A maximum of 25 entity types can be used at one time to train an entity recognizer. Entity
        /// types must not contain the following invalid characters: \n (line break), \\n (escaped line
        /// break), \r (carriage return), \\r (escaped carriage return), \t (tab), \\t (escaped tab),
        /// space, and , (comma). </p>
        pub fn entity_types(mut self, input: impl Into<crate::model::EntityTypesListItem>) -> Self {
            let mut v = self.entity_types.unwrap_or_default();
            v.push(input.into());
            self.entity_types = Some(v);
            self
        }
        /// <p>The entity types in the labeled training data that Amazon Comprehend uses to train the
        /// custom entity recognizer. Any entity types that you don't specify are ignored.</p>
        /// <p>A maximum of 25 entity types can be used at one time to train an entity recognizer. Entity
        /// types must not contain the following invalid characters: \n (line break), \\n (escaped line
        /// break), \r (carriage return), \\r (escaped carriage return), \t (tab), \\t (escaped tab),
        /// space, and , (comma). </p>
        pub fn set_entity_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityTypesListItem>>,
        ) -> Self {
            self.entity_types = input;
            self
        }
        /// <p>The S3 location of the folder that contains the training documents for your custom entity
        /// recognizer.</p>
        /// <p>This parameter is required if you set <code>DataFormat</code> to
        /// <code>COMPREHEND_CSV</code>.</p>
        pub fn documents(mut self, input: crate::model::EntityRecognizerDocuments) -> Self {
            self.documents = Some(input);
            self
        }
        /// <p>The S3 location of the folder that contains the training documents for your custom entity
        /// recognizer.</p>
        /// <p>This parameter is required if you set <code>DataFormat</code> to
        /// <code>COMPREHEND_CSV</code>.</p>
        pub fn set_documents(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerDocuments>,
        ) -> Self {
            self.documents = input;
            self
        }
        /// <p>The S3 location of the CSV file that annotates your training documents.</p>
        pub fn annotations(mut self, input: crate::model::EntityRecognizerAnnotations) -> Self {
            self.annotations = Some(input);
            self
        }
        /// <p>The S3 location of the CSV file that annotates your training documents.</p>
        pub fn set_annotations(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerAnnotations>,
        ) -> Self {
            self.annotations = input;
            self
        }
        /// <p>The S3 location of the CSV file that has the entity list for your custom entity
        /// recognizer.</p>
        pub fn entity_list(mut self, input: crate::model::EntityRecognizerEntityList) -> Self {
            self.entity_list = Some(input);
            self
        }
        /// <p>The S3 location of the CSV file that has the entity list for your custom entity
        /// recognizer.</p>
        pub fn set_entity_list(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerEntityList>,
        ) -> Self {
            self.entity_list = input;
            self
        }
        /// Appends an item to `augmented_manifests`.
        ///
        /// To override the contents of this collection use [`set_augmented_manifests`](Self::set_augmented_manifests).
        ///
        /// <p>A list of augmented manifest files that provide training data for your custom model. An
        /// augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground
        /// Truth.</p>
        /// <p>This parameter is required if you set <code>DataFormat</code> to
        /// <code>AUGMENTED_MANIFEST</code>.</p>
        pub fn augmented_manifests(
            mut self,
            input: impl Into<crate::model::AugmentedManifestsListItem>,
        ) -> Self {
            let mut v = self.augmented_manifests.unwrap_or_default();
            v.push(input.into());
            self.augmented_manifests = Some(v);
            self
        }
        /// <p>A list of augmented manifest files that provide training data for your custom model. An
        /// augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground
        /// Truth.</p>
        /// <p>This parameter is required if you set <code>DataFormat</code> to
        /// <code>AUGMENTED_MANIFEST</code>.</p>
        pub fn set_augmented_manifests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AugmentedManifestsListItem>>,
        ) -> Self {
            self.augmented_manifests = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityRecognizerInputDataConfig`](crate::model::EntityRecognizerInputDataConfig)
        pub fn build(self) -> crate::model::EntityRecognizerInputDataConfig {
            crate::model::EntityRecognizerInputDataConfig {
                data_format: self.data_format,
                entity_types: self.entity_types,
                documents: self.documents,
                annotations: self.annotations,
                entity_list: self.entity_list,
                augmented_manifests: self.augmented_manifests,
            }
        }
    }
}
impl EntityRecognizerInputDataConfig {
    /// Creates a new builder-style object to manufacture [`EntityRecognizerInputDataConfig`](crate::model::EntityRecognizerInputDataConfig)
    pub fn builder() -> crate::model::entity_recognizer_input_data_config::Builder {
        crate::model::entity_recognizer_input_data_config::Builder::default()
    }
}

/// <p>An augmented manifest file that provides training data for your custom model. An augmented
/// manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AugmentedManifestsListItem {
    /// <p>The Amazon S3 location of the augmented manifest file.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you don't specify, the default is train.</p>
    /// <p>TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.</p>
    /// <p> TEST - all of the documents in the manifest will be used for testing.</p>
    pub split: std::option::Option<crate::model::Split>,
    /// <p>The JSON attribute that contains the annotations for your training documents. The number
    /// of attribute names that you specify depends on whether your augmented manifest file is the
    /// output of a single labeling job or a chained labeling job.</p>
    /// <p>If your file is the output of a single labeling job, specify the LabelAttributeName key
    /// that was used when the job was created in Ground Truth.</p>
    /// <p>If your file is the output of a chained labeling job, specify the LabelAttributeName key
    /// for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from
    /// an individual job.</p>
    pub attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The S3 prefix to the annotation files that are referred in the augmented manifest file.</p>
    pub annotation_data_s3_uri: std::option::Option<std::string::String>,
    /// <p>The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.</p>
    pub source_documents_s3_uri: std::option::Option<std::string::String>,
    /// <p>The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the default is PlainTextDocument. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in UTF-8.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a PDF. For training with Amazon Comprehend, only PDFs are supported.
    /// For inference, Amazon Comprehend support PDFs, DOCX and TXT.</p>
    /// </li>
    /// </ul>
    pub document_type: std::option::Option<crate::model::AugmentedManifestsDocumentTypeFormat>,
}
impl AugmentedManifestsListItem {
    /// <p>The Amazon S3 location of the augmented manifest file.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you don't specify, the default is train.</p>
    /// <p>TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.</p>
    /// <p> TEST - all of the documents in the manifest will be used for testing.</p>
    pub fn split(&self) -> std::option::Option<&crate::model::Split> {
        self.split.as_ref()
    }
    /// <p>The JSON attribute that contains the annotations for your training documents. The number
    /// of attribute names that you specify depends on whether your augmented manifest file is the
    /// output of a single labeling job or a chained labeling job.</p>
    /// <p>If your file is the output of a single labeling job, specify the LabelAttributeName key
    /// that was used when the job was created in Ground Truth.</p>
    /// <p>If your file is the output of a chained labeling job, specify the LabelAttributeName key
    /// for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from
    /// an individual job.</p>
    pub fn attribute_names(&self) -> std::option::Option<&[std::string::String]> {
        self.attribute_names.as_deref()
    }
    /// <p>The S3 prefix to the annotation files that are referred in the augmented manifest file.</p>
    pub fn annotation_data_s3_uri(&self) -> std::option::Option<&str> {
        self.annotation_data_s3_uri.as_deref()
    }
    /// <p>The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.</p>
    pub fn source_documents_s3_uri(&self) -> std::option::Option<&str> {
        self.source_documents_s3_uri.as_deref()
    }
    /// <p>The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the default is PlainTextDocument. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in UTF-8.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a PDF. For training with Amazon Comprehend, only PDFs are supported.
    /// For inference, Amazon Comprehend support PDFs, DOCX and TXT.</p>
    /// </li>
    /// </ul>
    pub fn document_type(
        &self,
    ) -> std::option::Option<&crate::model::AugmentedManifestsDocumentTypeFormat> {
        self.document_type.as_ref()
    }
}
impl std::fmt::Debug for AugmentedManifestsListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AugmentedManifestsListItem");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("split", &self.split);
        formatter.field("attribute_names", &self.attribute_names);
        formatter.field("annotation_data_s3_uri", &self.annotation_data_s3_uri);
        formatter.field("source_documents_s3_uri", &self.source_documents_s3_uri);
        formatter.field("document_type", &self.document_type);
        formatter.finish()
    }
}
/// See [`AugmentedManifestsListItem`](crate::model::AugmentedManifestsListItem)
pub mod augmented_manifests_list_item {
    /// A builder for [`AugmentedManifestsListItem`](crate::model::AugmentedManifestsListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) split: std::option::Option<crate::model::Split>,
        pub(crate) attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) annotation_data_s3_uri: std::option::Option<std::string::String>,
        pub(crate) source_documents_s3_uri: std::option::Option<std::string::String>,
        pub(crate) document_type:
            std::option::Option<crate::model::AugmentedManifestsDocumentTypeFormat>,
    }
    impl Builder {
        /// <p>The Amazon S3 location of the augmented manifest file.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of the augmented manifest file.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you don't specify, the default is train.</p>
        /// <p>TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.</p>
        /// <p> TEST - all of the documents in the manifest will be used for testing.</p>
        pub fn split(mut self, input: crate::model::Split) -> Self {
            self.split = Some(input);
            self
        }
        /// <p>The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you don't specify, the default is train.</p>
        /// <p>TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.</p>
        /// <p> TEST - all of the documents in the manifest will be used for testing.</p>
        pub fn set_split(mut self, input: std::option::Option<crate::model::Split>) -> Self {
            self.split = input;
            self
        }
        /// Appends an item to `attribute_names`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>The JSON attribute that contains the annotations for your training documents. The number
        /// of attribute names that you specify depends on whether your augmented manifest file is the
        /// output of a single labeling job or a chained labeling job.</p>
        /// <p>If your file is the output of a single labeling job, specify the LabelAttributeName key
        /// that was used when the job was created in Ground Truth.</p>
        /// <p>If your file is the output of a chained labeling job, specify the LabelAttributeName key
        /// for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from
        /// an individual job.</p>
        pub fn attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_names.unwrap_or_default();
            v.push(input.into());
            self.attribute_names = Some(v);
            self
        }
        /// <p>The JSON attribute that contains the annotations for your training documents. The number
        /// of attribute names that you specify depends on whether your augmented manifest file is the
        /// output of a single labeling job or a chained labeling job.</p>
        /// <p>If your file is the output of a single labeling job, specify the LabelAttributeName key
        /// that was used when the job was created in Ground Truth.</p>
        /// <p>If your file is the output of a chained labeling job, specify the LabelAttributeName key
        /// for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from
        /// an individual job.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_names = input;
            self
        }
        /// <p>The S3 prefix to the annotation files that are referred in the augmented manifest file.</p>
        pub fn annotation_data_s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.annotation_data_s3_uri = Some(input.into());
            self
        }
        /// <p>The S3 prefix to the annotation files that are referred in the augmented manifest file.</p>
        pub fn set_annotation_data_s3_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.annotation_data_s3_uri = input;
            self
        }
        /// <p>The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.</p>
        pub fn source_documents_s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_documents_s3_uri = Some(input.into());
            self
        }
        /// <p>The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.</p>
        pub fn set_source_documents_s3_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_documents_s3_uri = input;
            self
        }
        /// <p>The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the default is PlainTextDocument. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a PDF. For training with Amazon Comprehend, only PDFs are supported.
        /// For inference, Amazon Comprehend support PDFs, DOCX and TXT.</p>
        /// </li>
        /// </ul>
        pub fn document_type(
            mut self,
            input: crate::model::AugmentedManifestsDocumentTypeFormat,
        ) -> Self {
            self.document_type = Some(input);
            self
        }
        /// <p>The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the default is PlainTextDocument. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in UTF-8.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a PDF. For training with Amazon Comprehend, only PDFs are supported.
        /// For inference, Amazon Comprehend support PDFs, DOCX and TXT.</p>
        /// </li>
        /// </ul>
        pub fn set_document_type(
            mut self,
            input: std::option::Option<crate::model::AugmentedManifestsDocumentTypeFormat>,
        ) -> Self {
            self.document_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AugmentedManifestsListItem`](crate::model::AugmentedManifestsListItem)
        pub fn build(self) -> crate::model::AugmentedManifestsListItem {
            crate::model::AugmentedManifestsListItem {
                s3_uri: self.s3_uri,
                split: self.split,
                attribute_names: self.attribute_names,
                annotation_data_s3_uri: self.annotation_data_s3_uri,
                source_documents_s3_uri: self.source_documents_s3_uri,
                document_type: self.document_type,
            }
        }
    }
}
impl AugmentedManifestsListItem {
    /// Creates a new builder-style object to manufacture [`AugmentedManifestsListItem`](crate::model::AugmentedManifestsListItem)
    pub fn builder() -> crate::model::augmented_manifests_list_item::Builder {
        crate::model::augmented_manifests_list_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AugmentedManifestsDocumentTypeFormat {
    #[allow(missing_docs)] // documentation missing in model
    PlainTextDocument,
    #[allow(missing_docs)] // documentation missing in model
    SemiStructuredDocument,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AugmentedManifestsDocumentTypeFormat {
    fn from(s: &str) -> Self {
        match s {
            "PLAIN_TEXT_DOCUMENT" => AugmentedManifestsDocumentTypeFormat::PlainTextDocument,
            "SEMI_STRUCTURED_DOCUMENT" => {
                AugmentedManifestsDocumentTypeFormat::SemiStructuredDocument
            }
            other => AugmentedManifestsDocumentTypeFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AugmentedManifestsDocumentTypeFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AugmentedManifestsDocumentTypeFormat::from(s))
    }
}
impl AugmentedManifestsDocumentTypeFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AugmentedManifestsDocumentTypeFormat::PlainTextDocument => "PLAIN_TEXT_DOCUMENT",
            AugmentedManifestsDocumentTypeFormat::SemiStructuredDocument => {
                "SEMI_STRUCTURED_DOCUMENT"
            }
            AugmentedManifestsDocumentTypeFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PLAIN_TEXT_DOCUMENT", "SEMI_STRUCTURED_DOCUMENT"]
    }
}
impl AsRef<str> for AugmentedManifestsDocumentTypeFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Split {
    #[allow(missing_docs)] // documentation missing in model
    Test,
    #[allow(missing_docs)] // documentation missing in model
    Train,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Split {
    fn from(s: &str) -> Self {
        match s {
            "TEST" => Split::Test,
            "TRAIN" => Split::Train,
            other => Split::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Split {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Split::from(s))
    }
}
impl Split {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Split::Test => "TEST",
            Split::Train => "TRAIN",
            Split::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TEST", "TRAIN"]
    }
}
impl AsRef<str> for Split {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the entity recognizer submitted with an entity recognizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityRecognizerEntityList {
    /// <p>Specifies the Amazon S3 location where the entity list is located. The URI must be in the
    /// same region as the API endpoint that you are calling.</p>
    pub s3_uri: std::option::Option<std::string::String>,
}
impl EntityRecognizerEntityList {
    /// <p>Specifies the Amazon S3 location where the entity list is located. The URI must be in the
    /// same region as the API endpoint that you are calling.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
}
impl std::fmt::Debug for EntityRecognizerEntityList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityRecognizerEntityList");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.finish()
    }
}
/// See [`EntityRecognizerEntityList`](crate::model::EntityRecognizerEntityList)
pub mod entity_recognizer_entity_list {
    /// A builder for [`EntityRecognizerEntityList`](crate::model::EntityRecognizerEntityList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the Amazon S3 location where the entity list is located. The URI must be in the
        /// same region as the API endpoint that you are calling.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon S3 location where the entity list is located. The URI must be in the
        /// same region as the API endpoint that you are calling.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityRecognizerEntityList`](crate::model::EntityRecognizerEntityList)
        pub fn build(self) -> crate::model::EntityRecognizerEntityList {
            crate::model::EntityRecognizerEntityList {
                s3_uri: self.s3_uri,
            }
        }
    }
}
impl EntityRecognizerEntityList {
    /// Creates a new builder-style object to manufacture [`EntityRecognizerEntityList`](crate::model::EntityRecognizerEntityList)
    pub fn builder() -> crate::model::entity_recognizer_entity_list::Builder {
        crate::model::entity_recognizer_entity_list::Builder::default()
    }
}

/// <p>Describes the annotations associated with a entity recognizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityRecognizerAnnotations {
    /// <p> Specifies the Amazon S3 location where the annotations for an entity recognizer are
    /// located. The URI must be in the same region as the API endpoint that you are calling.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>This specifies the Amazon S3 location where the test annotations for an entity recognizer are located.
    /// The URI must be in the same AWS Region as the API endpoint that you are calling.</p>
    pub test_s3_uri: std::option::Option<std::string::String>,
}
impl EntityRecognizerAnnotations {
    /// <p> Specifies the Amazon S3 location where the annotations for an entity recognizer are
    /// located. The URI must be in the same region as the API endpoint that you are calling.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>This specifies the Amazon S3 location where the test annotations for an entity recognizer are located.
    /// The URI must be in the same AWS Region as the API endpoint that you are calling.</p>
    pub fn test_s3_uri(&self) -> std::option::Option<&str> {
        self.test_s3_uri.as_deref()
    }
}
impl std::fmt::Debug for EntityRecognizerAnnotations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityRecognizerAnnotations");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("test_s3_uri", &self.test_s3_uri);
        formatter.finish()
    }
}
/// See [`EntityRecognizerAnnotations`](crate::model::EntityRecognizerAnnotations)
pub mod entity_recognizer_annotations {
    /// A builder for [`EntityRecognizerAnnotations`](crate::model::EntityRecognizerAnnotations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) test_s3_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Specifies the Amazon S3 location where the annotations for an entity recognizer are
        /// located. The URI must be in the same region as the API endpoint that you are calling.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p> Specifies the Amazon S3 location where the annotations for an entity recognizer are
        /// located. The URI must be in the same region as the API endpoint that you are calling.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>This specifies the Amazon S3 location where the test annotations for an entity recognizer are located.
        /// The URI must be in the same AWS Region as the API endpoint that you are calling.</p>
        pub fn test_s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_s3_uri = Some(input.into());
            self
        }
        /// <p>This specifies the Amazon S3 location where the test annotations for an entity recognizer are located.
        /// The URI must be in the same AWS Region as the API endpoint that you are calling.</p>
        pub fn set_test_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.test_s3_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityRecognizerAnnotations`](crate::model::EntityRecognizerAnnotations)
        pub fn build(self) -> crate::model::EntityRecognizerAnnotations {
            crate::model::EntityRecognizerAnnotations {
                s3_uri: self.s3_uri,
                test_s3_uri: self.test_s3_uri,
            }
        }
    }
}
impl EntityRecognizerAnnotations {
    /// Creates a new builder-style object to manufacture [`EntityRecognizerAnnotations`](crate::model::EntityRecognizerAnnotations)
    pub fn builder() -> crate::model::entity_recognizer_annotations::Builder {
        crate::model::entity_recognizer_annotations::Builder::default()
    }
}

/// <p>Describes the training documents submitted with an entity recognizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityRecognizerDocuments {
    /// <p> Specifies the Amazon S3 location where the training documents for an entity recognizer
    /// are located. The URI must be in the same region as the API endpoint that you are
    /// calling.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p> Specifies the Amazon S3 location where the test documents for an entity recognizer are located.
    /// The URI must be in the same AWS Region as the API endpoint that you are calling.</p>
    pub test_s3_uri: std::option::Option<std::string::String>,
    /// <p> Specifies how the text in an input file should be processed. This is optional, and the default is ONE_DOC_PER_LINE.
    ///
    /// ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when you are processing large documents, such as newspaper articles or scientific papers.
    ///
    /// ONE_DOC_PER_LINE - Each line in a file is considered a separate document. Use this option when you are processing many short documents, such as text messages.</p>
    pub input_format: std::option::Option<crate::model::InputFormat>,
}
impl EntityRecognizerDocuments {
    /// <p> Specifies the Amazon S3 location where the training documents for an entity recognizer
    /// are located. The URI must be in the same region as the API endpoint that you are
    /// calling.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p> Specifies the Amazon S3 location where the test documents for an entity recognizer are located.
    /// The URI must be in the same AWS Region as the API endpoint that you are calling.</p>
    pub fn test_s3_uri(&self) -> std::option::Option<&str> {
        self.test_s3_uri.as_deref()
    }
    /// <p> Specifies how the text in an input file should be processed. This is optional, and the default is ONE_DOC_PER_LINE.
    ///
    /// ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when you are processing large documents, such as newspaper articles or scientific papers.
    ///
    /// ONE_DOC_PER_LINE - Each line in a file is considered a separate document. Use this option when you are processing many short documents, such as text messages.</p>
    pub fn input_format(&self) -> std::option::Option<&crate::model::InputFormat> {
        self.input_format.as_ref()
    }
}
impl std::fmt::Debug for EntityRecognizerDocuments {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityRecognizerDocuments");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("test_s3_uri", &self.test_s3_uri);
        formatter.field("input_format", &self.input_format);
        formatter.finish()
    }
}
/// See [`EntityRecognizerDocuments`](crate::model::EntityRecognizerDocuments)
pub mod entity_recognizer_documents {
    /// A builder for [`EntityRecognizerDocuments`](crate::model::EntityRecognizerDocuments)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) test_s3_uri: std::option::Option<std::string::String>,
        pub(crate) input_format: std::option::Option<crate::model::InputFormat>,
    }
    impl Builder {
        /// <p> Specifies the Amazon S3 location where the training documents for an entity recognizer
        /// are located. The URI must be in the same region as the API endpoint that you are
        /// calling.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p> Specifies the Amazon S3 location where the training documents for an entity recognizer
        /// are located. The URI must be in the same region as the API endpoint that you are
        /// calling.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p> Specifies the Amazon S3 location where the test documents for an entity recognizer are located.
        /// The URI must be in the same AWS Region as the API endpoint that you are calling.</p>
        pub fn test_s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_s3_uri = Some(input.into());
            self
        }
        /// <p> Specifies the Amazon S3 location where the test documents for an entity recognizer are located.
        /// The URI must be in the same AWS Region as the API endpoint that you are calling.</p>
        pub fn set_test_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.test_s3_uri = input;
            self
        }
        /// <p> Specifies how the text in an input file should be processed. This is optional, and the default is ONE_DOC_PER_LINE.
        ///
        /// ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when you are processing large documents, such as newspaper articles or scientific papers.
        ///
        /// ONE_DOC_PER_LINE - Each line in a file is considered a separate document. Use this option when you are processing many short documents, such as text messages.</p>
        pub fn input_format(mut self, input: crate::model::InputFormat) -> Self {
            self.input_format = Some(input);
            self
        }
        /// <p> Specifies how the text in an input file should be processed. This is optional, and the default is ONE_DOC_PER_LINE.
        ///
        /// ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when you are processing large documents, such as newspaper articles or scientific papers.
        ///
        /// ONE_DOC_PER_LINE - Each line in a file is considered a separate document. Use this option when you are processing many short documents, such as text messages.</p>
        pub fn set_input_format(
            mut self,
            input: std::option::Option<crate::model::InputFormat>,
        ) -> Self {
            self.input_format = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityRecognizerDocuments`](crate::model::EntityRecognizerDocuments)
        pub fn build(self) -> crate::model::EntityRecognizerDocuments {
            crate::model::EntityRecognizerDocuments {
                s3_uri: self.s3_uri,
                test_s3_uri: self.test_s3_uri,
                input_format: self.input_format,
            }
        }
    }
}
impl EntityRecognizerDocuments {
    /// Creates a new builder-style object to manufacture [`EntityRecognizerDocuments`](crate::model::EntityRecognizerDocuments)
    pub fn builder() -> crate::model::entity_recognizer_documents::Builder {
        crate::model::entity_recognizer_documents::Builder::default()
    }
}

/// <p>An entity type within a labeled training dataset that Amazon Comprehend uses to train a
/// custom entity recognizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityTypesListItem {
    /// <p>An entity type within a labeled training dataset that Amazon Comprehend uses to train a
    /// custom entity recognizer.</p>
    /// <p>Entity types must not contain the following invalid characters: \n (line break), \\n
    /// (escaped line break, \r (carriage return), \\r (escaped carriage return), \t (tab), \\t
    /// (escaped tab), space, and , (comma).</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl EntityTypesListItem {
    /// <p>An entity type within a labeled training dataset that Amazon Comprehend uses to train a
    /// custom entity recognizer.</p>
    /// <p>Entity types must not contain the following invalid characters: \n (line break), \\n
    /// (escaped line break, \r (carriage return), \\r (escaped carriage return), \t (tab), \\t
    /// (escaped tab), space, and , (comma).</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for EntityTypesListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityTypesListItem");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`EntityTypesListItem`](crate::model::EntityTypesListItem)
pub mod entity_types_list_item {
    /// A builder for [`EntityTypesListItem`](crate::model::EntityTypesListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An entity type within a labeled training dataset that Amazon Comprehend uses to train a
        /// custom entity recognizer.</p>
        /// <p>Entity types must not contain the following invalid characters: \n (line break), \\n
        /// (escaped line break, \r (carriage return), \\r (escaped carriage return), \t (tab), \\t
        /// (escaped tab), space, and , (comma).</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>An entity type within a labeled training dataset that Amazon Comprehend uses to train a
        /// custom entity recognizer.</p>
        /// <p>Entity types must not contain the following invalid characters: \n (line break), \\n
        /// (escaped line break, \r (carriage return), \\r (escaped carriage return), \t (tab), \\t
        /// (escaped tab), space, and , (comma).</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityTypesListItem`](crate::model::EntityTypesListItem)
        pub fn build(self) -> crate::model::EntityTypesListItem {
            crate::model::EntityTypesListItem {
                r#type: self.r#type,
            }
        }
    }
}
impl EntityTypesListItem {
    /// Creates a new builder-style object to manufacture [`EntityTypesListItem`](crate::model::EntityTypesListItem)
    pub fn builder() -> crate::model::entity_types_list_item::Builder {
        crate::model::entity_types_list_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EntityRecognizerDataFormat {
    #[allow(missing_docs)] // documentation missing in model
    AugmentedManifest,
    #[allow(missing_docs)] // documentation missing in model
    ComprehendCsv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EntityRecognizerDataFormat {
    fn from(s: &str) -> Self {
        match s {
            "AUGMENTED_MANIFEST" => EntityRecognizerDataFormat::AugmentedManifest,
            "COMPREHEND_CSV" => EntityRecognizerDataFormat::ComprehendCsv,
            other => EntityRecognizerDataFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EntityRecognizerDataFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EntityRecognizerDataFormat::from(s))
    }
}
impl EntityRecognizerDataFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EntityRecognizerDataFormat::AugmentedManifest => "AUGMENTED_MANIFEST",
            EntityRecognizerDataFormat::ComprehendCsv => "COMPREHEND_CSV",
            EntityRecognizerDataFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUGMENTED_MANIFEST", "COMPREHEND_CSV"]
    }
}
impl AsRef<str> for EntityRecognizerDataFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information for filtering a list of entity recognizers. You can only specify one
/// filtering parameter in a request. For more information, see the  operation./></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityRecognizerFilter {
    /// <p>The status of an entity recognizer.</p>
    pub status: std::option::Option<crate::model::ModelStatus>,
    /// <p>The name that you assigned the entity recognizer.</p>
    pub recognizer_name: std::option::Option<std::string::String>,
    /// <p>Filters the list of entities based on the time that the list was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub submit_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters the list of entities based on the time that the list was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub submit_time_after: std::option::Option<aws_smithy_types::Instant>,
}
impl EntityRecognizerFilter {
    /// <p>The status of an entity recognizer.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ModelStatus> {
        self.status.as_ref()
    }
    /// <p>The name that you assigned the entity recognizer.</p>
    pub fn recognizer_name(&self) -> std::option::Option<&str> {
        self.recognizer_name.as_deref()
    }
    /// <p>Filters the list of entities based on the time that the list was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub fn submit_time_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_before.as_ref()
    }
    /// <p>Filters the list of entities based on the time that the list was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub fn submit_time_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_after.as_ref()
    }
}
impl std::fmt::Debug for EntityRecognizerFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityRecognizerFilter");
        formatter.field("status", &self.status);
        formatter.field("recognizer_name", &self.recognizer_name);
        formatter.field("submit_time_before", &self.submit_time_before);
        formatter.field("submit_time_after", &self.submit_time_after);
        formatter.finish()
    }
}
/// See [`EntityRecognizerFilter`](crate::model::EntityRecognizerFilter)
pub mod entity_recognizer_filter {
    /// A builder for [`EntityRecognizerFilter`](crate::model::EntityRecognizerFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ModelStatus>,
        pub(crate) recognizer_name: std::option::Option<std::string::String>,
        pub(crate) submit_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) submit_time_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The status of an entity recognizer.</p>
        pub fn status(mut self, input: crate::model::ModelStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of an entity recognizer.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::ModelStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The name that you assigned the entity recognizer.</p>
        pub fn recognizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recognizer_name = Some(input.into());
            self
        }
        /// <p>The name that you assigned the entity recognizer.</p>
        pub fn set_recognizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recognizer_name = input;
            self
        }
        /// <p>Filters the list of entities based on the time that the list was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn submit_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_before = Some(input);
            self
        }
        /// <p>Filters the list of entities based on the time that the list was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn set_submit_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_before = input;
            self
        }
        /// <p>Filters the list of entities based on the time that the list was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn submit_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_after = Some(input);
            self
        }
        /// <p>Filters the list of entities based on the time that the list was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn set_submit_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_after = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityRecognizerFilter`](crate::model::EntityRecognizerFilter)
        pub fn build(self) -> crate::model::EntityRecognizerFilter {
            crate::model::EntityRecognizerFilter {
                status: self.status,
                recognizer_name: self.recognizer_name,
                submit_time_before: self.submit_time_before,
                submit_time_after: self.submit_time_after,
            }
        }
    }
}
impl EntityRecognizerFilter {
    /// Creates a new builder-style object to manufacture [`EntityRecognizerFilter`](crate::model::EntityRecognizerFilter)
    pub fn builder() -> crate::model::entity_recognizer_filter::Builder {
        crate::model::entity_recognizer_filter::Builder::default()
    }
}

/// <p>Provides information about an entities detection job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntitiesDetectionJobProperties {
    /// <p>The identifier assigned to the entities detection job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:entities-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The name that you assigned the entities detection job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The current status of the entities detection job. If the status is <code>FAILED</code>,
    /// the <code>Message</code> field shows the reason for the failure.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>A description of the status of a job.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time that the entities detection job was submitted for processing.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the entities detection job completed</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
    pub entity_recognizer_arn: std::option::Option<std::string::String>,
    /// <p>The input data configuration that you supplied when you created the entities detection
    /// job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data configuration that you supplied when you created the entities detection
    /// job. </p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The language code of the input documents.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
    /// data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
}
impl EntitiesDetectionJobProperties {
    /// <p>The identifier assigned to the entities detection job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:entities-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The name that you assigned the entities detection job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The current status of the entities detection job. If the status is <code>FAILED</code>,
    /// the <code>Message</code> field shows the reason for the failure.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>A description of the status of a job.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time that the entities detection job was submitted for processing.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time.as_ref()
    }
    /// <p>The time that the entities detection job completed</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
    pub fn entity_recognizer_arn(&self) -> std::option::Option<&str> {
        self.entity_recognizer_arn.as_deref()
    }
    /// <p>The input data configuration that you supplied when you created the entities detection
    /// job.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>The output data configuration that you supplied when you created the entities detection
    /// job. </p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>The language code of the input documents.</p>
    pub fn language_code(&self) -> std::option::Option<&crate::model::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
    /// data.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn volume_kms_key_id(&self) -> std::option::Option<&str> {
        self.volume_kms_key_id.as_deref()
    }
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
}
impl std::fmt::Debug for EntitiesDetectionJobProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntitiesDetectionJobProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("message", &self.message);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("entity_recognizer_arn", &self.entity_recognizer_arn);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("language_code", &self.language_code);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.finish()
    }
}
/// See [`EntitiesDetectionJobProperties`](crate::model::EntitiesDetectionJobProperties)
pub mod entities_detection_job_properties {
    /// A builder for [`EntitiesDetectionJobProperties`](crate::model::EntitiesDetectionJobProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) entity_recognizer_arn: std::option::Option<std::string::String>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
    }
    impl Builder {
        /// <p>The identifier assigned to the entities detection job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier assigned to the entities detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:entities-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:entities-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The name that you assigned the entities detection job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name that you assigned the entities detection job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The current status of the entities detection job. If the status is <code>FAILED</code>,
        /// the <code>Message</code> field shows the reason for the failure.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the entities detection job. If the status is <code>FAILED</code>,
        /// the <code>Message</code> field shows the reason for the failure.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>A description of the status of a job.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the status of a job.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time that the entities detection job was submitted for processing.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time that the entities detection job was submitted for processing.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time that the entities detection job completed</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the entities detection job completed</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn entity_recognizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_recognizer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entity_recognizer_arn = input;
            self
        }
        /// <p>The input data configuration that you supplied when you created the entities detection
        /// job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data configuration that you supplied when you created the entities detection
        /// job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data configuration that you supplied when you created the entities detection
        /// job. </p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration that you supplied when you created the entities detection
        /// job. </p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
        /// data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
        /// data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Consumes the builder and constructs a [`EntitiesDetectionJobProperties`](crate::model::EntitiesDetectionJobProperties)
        pub fn build(self) -> crate::model::EntitiesDetectionJobProperties {
            crate::model::EntitiesDetectionJobProperties {
                job_id: self.job_id,
                job_arn: self.job_arn,
                job_name: self.job_name,
                job_status: self.job_status,
                message: self.message,
                submit_time: self.submit_time,
                end_time: self.end_time,
                entity_recognizer_arn: self.entity_recognizer_arn,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                language_code: self.language_code,
                data_access_role_arn: self.data_access_role_arn,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
            }
        }
    }
}
impl EntitiesDetectionJobProperties {
    /// Creates a new builder-style object to manufacture [`EntitiesDetectionJobProperties`](crate::model::EntitiesDetectionJobProperties)
    pub fn builder() -> crate::model::entities_detection_job_properties::Builder {
        crate::model::entities_detection_job_properties::Builder::default()
    }
}

/// <p>Provides information for filtering a list of dominant language detection jobs. For more
/// information, see the  operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntitiesDetectionJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub submit_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub submit_time_after: std::option::Option<aws_smithy_types::Instant>,
}
impl EntitiesDetectionJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub fn submit_time_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_before.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub fn submit_time_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_after.as_ref()
    }
}
impl std::fmt::Debug for EntitiesDetectionJobFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntitiesDetectionJobFilter");
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submit_time_before", &self.submit_time_before);
        formatter.field("submit_time_after", &self.submit_time_after);
        formatter.finish()
    }
}
/// See [`EntitiesDetectionJobFilter`](crate::model::EntitiesDetectionJobFilter)
pub mod entities_detection_job_filter {
    /// A builder for [`EntitiesDetectionJobFilter`](crate::model::EntitiesDetectionJobFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submit_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) submit_time_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Filters on the name of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>Filters on the name of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn submit_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_before = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn set_submit_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_before = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn submit_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_after = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn set_submit_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_after = input;
            self
        }
        /// Consumes the builder and constructs a [`EntitiesDetectionJobFilter`](crate::model::EntitiesDetectionJobFilter)
        pub fn build(self) -> crate::model::EntitiesDetectionJobFilter {
            crate::model::EntitiesDetectionJobFilter {
                job_name: self.job_name,
                job_status: self.job_status,
                submit_time_before: self.submit_time_before,
                submit_time_after: self.submit_time_after,
            }
        }
    }
}
impl EntitiesDetectionJobFilter {
    /// Creates a new builder-style object to manufacture [`EntitiesDetectionJobFilter`](crate::model::EntitiesDetectionJobFilter)
    pub fn builder() -> crate::model::entities_detection_job_filter::Builder {
        crate::model::entities_detection_job_filter::Builder::default()
    }
}

/// <p>Specifies information about the specified endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointProperties {
    /// <p>The Amazon Resource Number (ARN) of the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the status of the endpoint. Because the endpoint updates and creation are
    /// asynchronous, so customers will need to wait for the endpoint to be <code>Ready</code> status
    /// before making inference requests.</p>
    pub status: std::option::Option<crate::model::EndpointStatus>,
    /// <p>Specifies a reason for failure in cases of <code>Failed</code> status.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint is attached.</p>
    pub model_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the new model to use for updating an existing endpoint. This ARN is going to be different from the model ARN when the update is in progress</p>
    pub desired_model_arn: std::option::Option<std::string::String>,
    /// <p>The desired number of inference units to be used by the model using this endpoint.
    ///
    /// Each inference unit represents of a throughput of 100 characters per second.</p>
    pub desired_inference_units: std::option::Option<i32>,
    /// <p>The number of inference units currently used by the model using this endpoint.</p>
    pub current_inference_units: std::option::Option<i32>,
    /// <p>The creation date and time of the endpoint.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the endpoint was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to trained custom models encrypted with a customer
    /// managed key (ModelKmsKeyId).</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>Data access role ARN to use in case the new model is encrypted with a customer KMS key.</p>
    pub desired_data_access_role_arn: std::option::Option<std::string::String>,
}
impl EndpointProperties {
    /// <p>The Amazon Resource Number (ARN) of the endpoint.</p>
    pub fn endpoint_arn(&self) -> std::option::Option<&str> {
        self.endpoint_arn.as_deref()
    }
    /// <p>Specifies the status of the endpoint. Because the endpoint updates and creation are
    /// asynchronous, so customers will need to wait for the endpoint to be <code>Ready</code> status
    /// before making inference requests.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EndpointStatus> {
        self.status.as_ref()
    }
    /// <p>Specifies a reason for failure in cases of <code>Failed</code> status.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint is attached.</p>
    pub fn model_arn(&self) -> std::option::Option<&str> {
        self.model_arn.as_deref()
    }
    /// <p>ARN of the new model to use for updating an existing endpoint. This ARN is going to be different from the model ARN when the update is in progress</p>
    pub fn desired_model_arn(&self) -> std::option::Option<&str> {
        self.desired_model_arn.as_deref()
    }
    /// <p>The desired number of inference units to be used by the model using this endpoint.
    ///
    /// Each inference unit represents of a throughput of 100 characters per second.</p>
    pub fn desired_inference_units(&self) -> std::option::Option<i32> {
        self.desired_inference_units
    }
    /// <p>The number of inference units currently used by the model using this endpoint.</p>
    pub fn current_inference_units(&self) -> std::option::Option<i32> {
        self.current_inference_units
    }
    /// <p>The creation date and time of the endpoint.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The date and time that the endpoint was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to trained custom models encrypted with a customer
    /// managed key (ModelKmsKeyId).</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>Data access role ARN to use in case the new model is encrypted with a customer KMS key.</p>
    pub fn desired_data_access_role_arn(&self) -> std::option::Option<&str> {
        self.desired_data_access_role_arn.as_deref()
    }
}
impl std::fmt::Debug for EndpointProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointProperties");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("model_arn", &self.model_arn);
        formatter.field("desired_model_arn", &self.desired_model_arn);
        formatter.field("desired_inference_units", &self.desired_inference_units);
        formatter.field("current_inference_units", &self.current_inference_units);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field(
            "desired_data_access_role_arn",
            &self.desired_data_access_role_arn,
        );
        formatter.finish()
    }
}
/// See [`EndpointProperties`](crate::model::EndpointProperties)
pub mod endpoint_properties {
    /// A builder for [`EndpointProperties`](crate::model::EndpointProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EndpointStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) model_arn: std::option::Option<std::string::String>,
        pub(crate) desired_model_arn: std::option::Option<std::string::String>,
        pub(crate) desired_inference_units: std::option::Option<i32>,
        pub(crate) current_inference_units: std::option::Option<i32>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) desired_data_access_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// <p>Specifies the status of the endpoint. Because the endpoint updates and creation are
        /// asynchronous, so customers will need to wait for the endpoint to be <code>Ready</code> status
        /// before making inference requests.</p>
        pub fn status(mut self, input: crate::model::EndpointStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies the status of the endpoint. Because the endpoint updates and creation are
        /// asynchronous, so customers will need to wait for the endpoint to be <code>Ready</code> status
        /// before making inference requests.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EndpointStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies a reason for failure in cases of <code>Failed</code> status.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Specifies a reason for failure in cases of <code>Failed</code> status.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint is attached.</p>
        pub fn model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint is attached.</p>
        pub fn set_model_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_arn = input;
            self
        }
        /// <p>ARN of the new model to use for updating an existing endpoint. This ARN is going to be different from the model ARN when the update is in progress</p>
        pub fn desired_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.desired_model_arn = Some(input.into());
            self
        }
        /// <p>ARN of the new model to use for updating an existing endpoint. This ARN is going to be different from the model ARN when the update is in progress</p>
        pub fn set_desired_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.desired_model_arn = input;
            self
        }
        /// <p>The desired number of inference units to be used by the model using this endpoint.
        ///
        /// Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn desired_inference_units(mut self, input: i32) -> Self {
            self.desired_inference_units = Some(input);
            self
        }
        /// <p>The desired number of inference units to be used by the model using this endpoint.
        ///
        /// Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn set_desired_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_inference_units = input;
            self
        }
        /// <p>The number of inference units currently used by the model using this endpoint.</p>
        pub fn current_inference_units(mut self, input: i32) -> Self {
            self.current_inference_units = Some(input);
            self
        }
        /// <p>The number of inference units currently used by the model using this endpoint.</p>
        pub fn set_current_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.current_inference_units = input;
            self
        }
        /// <p>The creation date and time of the endpoint.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation date and time of the endpoint.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the endpoint was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time that the endpoint was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to trained custom models encrypted with a customer
        /// managed key (ModelKmsKeyId).</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to trained custom models encrypted with a customer
        /// managed key (ModelKmsKeyId).</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>Data access role ARN to use in case the new model is encrypted with a customer KMS key.</p>
        pub fn desired_data_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.desired_data_access_role_arn = Some(input.into());
            self
        }
        /// <p>Data access role ARN to use in case the new model is encrypted with a customer KMS key.</p>
        pub fn set_desired_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.desired_data_access_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointProperties`](crate::model::EndpointProperties)
        pub fn build(self) -> crate::model::EndpointProperties {
            crate::model::EndpointProperties {
                endpoint_arn: self.endpoint_arn,
                status: self.status,
                message: self.message,
                model_arn: self.model_arn,
                desired_model_arn: self.desired_model_arn,
                desired_inference_units: self.desired_inference_units,
                current_inference_units: self.current_inference_units,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                data_access_role_arn: self.data_access_role_arn,
                desired_data_access_role_arn: self.desired_data_access_role_arn,
            }
        }
    }
}
impl EndpointProperties {
    /// Creates a new builder-style object to manufacture [`EndpointProperties`](crate::model::EndpointProperties)
    pub fn builder() -> crate::model::endpoint_properties::Builder {
        crate::model::endpoint_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndpointStatus {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InService,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndpointStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATING" => EndpointStatus::Creating,
            "DELETING" => EndpointStatus::Deleting,
            "FAILED" => EndpointStatus::Failed,
            "IN_SERVICE" => EndpointStatus::InService,
            "UPDATING" => EndpointStatus::Updating,
            other => EndpointStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndpointStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndpointStatus::from(s))
    }
}
impl EndpointStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndpointStatus::Creating => "CREATING",
            EndpointStatus::Deleting => "DELETING",
            EndpointStatus::Failed => "FAILED",
            EndpointStatus::InService => "IN_SERVICE",
            EndpointStatus::Updating => "UPDATING",
            EndpointStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATING", "DELETING", "FAILED", "IN_SERVICE", "UPDATING"]
    }
}
impl AsRef<str> for EndpointStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The filter used to determine which endpoints are returned. You can filter jobs on their
/// name, model, status, or the date and time that they were created. You can only set one filter
/// at a time. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointFilter {
    /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint is attached.</p>
    pub model_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the status of the endpoint being returned. Possible values are: Creating, Ready,
    /// Updating, Deleting, Failed.</p>
    pub status: std::option::Option<crate::model::EndpointStatus>,
    /// <p>Specifies a date before which the returned endpoint or endpoints were created.</p>
    pub creation_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies a date after which the returned endpoint or endpoints were created.</p>
    pub creation_time_after: std::option::Option<aws_smithy_types::Instant>,
}
impl EndpointFilter {
    /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint is attached.</p>
    pub fn model_arn(&self) -> std::option::Option<&str> {
        self.model_arn.as_deref()
    }
    /// <p>Specifies the status of the endpoint being returned. Possible values are: Creating, Ready,
    /// Updating, Deleting, Failed.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EndpointStatus> {
        self.status.as_ref()
    }
    /// <p>Specifies a date before which the returned endpoint or endpoints were created.</p>
    pub fn creation_time_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time_before.as_ref()
    }
    /// <p>Specifies a date after which the returned endpoint or endpoints were created.</p>
    pub fn creation_time_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time_after.as_ref()
    }
}
impl std::fmt::Debug for EndpointFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointFilter");
        formatter.field("model_arn", &self.model_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_time_before", &self.creation_time_before);
        formatter.field("creation_time_after", &self.creation_time_after);
        formatter.finish()
    }
}
/// See [`EndpointFilter`](crate::model::EndpointFilter)
pub mod endpoint_filter {
    /// A builder for [`EndpointFilter`](crate::model::EndpointFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EndpointStatus>,
        pub(crate) creation_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) creation_time_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint is attached.</p>
        pub fn model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint is attached.</p>
        pub fn set_model_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_arn = input;
            self
        }
        /// <p>Specifies the status of the endpoint being returned. Possible values are: Creating, Ready,
        /// Updating, Deleting, Failed.</p>
        pub fn status(mut self, input: crate::model::EndpointStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies the status of the endpoint being returned. Possible values are: Creating, Ready,
        /// Updating, Deleting, Failed.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EndpointStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies a date before which the returned endpoint or endpoints were created.</p>
        pub fn creation_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time_before = Some(input);
            self
        }
        /// <p>Specifies a date before which the returned endpoint or endpoints were created.</p>
        pub fn set_creation_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time_before = input;
            self
        }
        /// <p>Specifies a date after which the returned endpoint or endpoints were created.</p>
        pub fn creation_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time_after = Some(input);
            self
        }
        /// <p>Specifies a date after which the returned endpoint or endpoints were created.</p>
        pub fn set_creation_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time_after = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointFilter`](crate::model::EndpointFilter)
        pub fn build(self) -> crate::model::EndpointFilter {
            crate::model::EndpointFilter {
                model_arn: self.model_arn,
                status: self.status,
                creation_time_before: self.creation_time_before,
                creation_time_after: self.creation_time_after,
            }
        }
    }
}
impl EndpointFilter {
    /// Creates a new builder-style object to manufacture [`EndpointFilter`](crate::model::EndpointFilter)
    pub fn builder() -> crate::model::endpoint_filter::Builder {
        crate::model::endpoint_filter::Builder::default()
    }
}

/// <p>Provides information about a dominant language detection job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DominantLanguageDetectionJobProperties {
    /// <p>The identifier assigned to the dominant language detection job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dominant language detection job. It is a unique,
    /// fully qualified identifier for the job. It includes the AWS account, Region, and the job ID.
    /// The format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:dominant-language-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:dominant-language-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The name that you assigned to the dominant language detection job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The current status of the dominant language detection job. If the status is
    /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>A description for the status of a job.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time that the dominant language detection job was submitted for processing.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the dominant language detection job completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The input data configuration that you supplied when you created the dominant language
    /// detection job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data configuration that you supplied when you created the dominant language
    /// detection job.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
    /// data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your dominant language detection job. For more information, see
    /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
}
impl DominantLanguageDetectionJobProperties {
    /// <p>The identifier assigned to the dominant language detection job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dominant language detection job. It is a unique,
    /// fully qualified identifier for the job. It includes the AWS account, Region, and the job ID.
    /// The format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:dominant-language-detection-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:dominant-language-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The name that you assigned to the dominant language detection job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The current status of the dominant language detection job. If the status is
    /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>A description for the status of a job.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time that the dominant language detection job was submitted for processing.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time.as_ref()
    }
    /// <p>The time that the dominant language detection job completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The input data configuration that you supplied when you created the dominant language
    /// detection job.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>The output data configuration that you supplied when you created the dominant language
    /// detection job.</p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
    /// data.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn volume_kms_key_id(&self) -> std::option::Option<&str> {
        self.volume_kms_key_id.as_deref()
    }
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your dominant language detection job. For more information, see
    /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
}
impl std::fmt::Debug for DominantLanguageDetectionJobProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DominantLanguageDetectionJobProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("message", &self.message);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.finish()
    }
}
/// See [`DominantLanguageDetectionJobProperties`](crate::model::DominantLanguageDetectionJobProperties)
pub mod dominant_language_detection_job_properties {
    /// A builder for [`DominantLanguageDetectionJobProperties`](crate::model::DominantLanguageDetectionJobProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
    }
    impl Builder {
        /// <p>The identifier assigned to the dominant language detection job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier assigned to the dominant language detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dominant language detection job. It is a unique,
        /// fully qualified identifier for the job. It includes the AWS account, Region, and the job ID.
        /// The format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:dominant-language-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:dominant-language-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dominant language detection job. It is a unique,
        /// fully qualified identifier for the job. It includes the AWS account, Region, and the job ID.
        /// The format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:dominant-language-detection-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:dominant-language-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The name that you assigned to the dominant language detection job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name that you assigned to the dominant language detection job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The current status of the dominant language detection job. If the status is
        /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the dominant language detection job. If the status is
        /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>A description for the status of a job.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description for the status of a job.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time that the dominant language detection job was submitted for processing.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time that the dominant language detection job was submitted for processing.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time that the dominant language detection job completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the dominant language detection job completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The input data configuration that you supplied when you created the dominant language
        /// detection job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data configuration that you supplied when you created the dominant language
        /// detection job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data configuration that you supplied when you created the dominant language
        /// detection job.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration that you supplied when you created the dominant language
        /// detection job.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
        /// data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input
        /// data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your dominant language detection job. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your dominant language detection job. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DominantLanguageDetectionJobProperties`](crate::model::DominantLanguageDetectionJobProperties)
        pub fn build(self) -> crate::model::DominantLanguageDetectionJobProperties {
            crate::model::DominantLanguageDetectionJobProperties {
                job_id: self.job_id,
                job_arn: self.job_arn,
                job_name: self.job_name,
                job_status: self.job_status,
                message: self.message,
                submit_time: self.submit_time,
                end_time: self.end_time,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
            }
        }
    }
}
impl DominantLanguageDetectionJobProperties {
    /// Creates a new builder-style object to manufacture [`DominantLanguageDetectionJobProperties`](crate::model::DominantLanguageDetectionJobProperties)
    pub fn builder() -> crate::model::dominant_language_detection_job_properties::Builder {
        crate::model::dominant_language_detection_job_properties::Builder::default()
    }
}

/// <p>Provides information for filtering a list of dominant language detection jobs. For more
/// information, see the  operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DominantLanguageDetectionJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub submit_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub submit_time_after: std::option::Option<aws_smithy_types::Instant>,
}
impl DominantLanguageDetectionJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
    /// status.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub fn submit_time_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_before.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub fn submit_time_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_after.as_ref()
    }
}
impl std::fmt::Debug for DominantLanguageDetectionJobFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DominantLanguageDetectionJobFilter");
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submit_time_before", &self.submit_time_before);
        formatter.field("submit_time_after", &self.submit_time_after);
        formatter.finish()
    }
}
/// See [`DominantLanguageDetectionJobFilter`](crate::model::DominantLanguageDetectionJobFilter)
pub mod dominant_language_detection_job_filter {
    /// A builder for [`DominantLanguageDetectionJobFilter`](crate::model::DominantLanguageDetectionJobFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submit_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) submit_time_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Filters on the name of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>Filters on the name of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on job status. Returns only jobs with the specified
        /// status.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn submit_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_before = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn set_submit_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_before = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn submit_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_after = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn set_submit_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_after = input;
            self
        }
        /// Consumes the builder and constructs a [`DominantLanguageDetectionJobFilter`](crate::model::DominantLanguageDetectionJobFilter)
        pub fn build(self) -> crate::model::DominantLanguageDetectionJobFilter {
            crate::model::DominantLanguageDetectionJobFilter {
                job_name: self.job_name,
                job_status: self.job_status,
                submit_time_before: self.submit_time_before,
                submit_time_after: self.submit_time_after,
            }
        }
    }
}
impl DominantLanguageDetectionJobFilter {
    /// Creates a new builder-style object to manufacture [`DominantLanguageDetectionJobFilter`](crate::model::DominantLanguageDetectionJobFilter)
    pub fn builder() -> crate::model::dominant_language_detection_job_filter::Builder {
        crate::model::dominant_language_detection_job_filter::Builder::default()
    }
}

/// <p>Describes information about a document classifier and its versions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentClassifierSummary {
    /// <p>The name that you assigned the document classifier.</p>
    pub document_classifier_name: std::option::Option<std::string::String>,
    /// <p>The number of versions you created.</p>
    pub number_of_versions: std::option::Option<i32>,
    /// <p>The time that the latest document classifier version was submitted for processing.</p>
    pub latest_version_created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version name you assigned to the latest document classifier version.</p>
    pub latest_version_name: std::option::Option<std::string::String>,
    /// <p>Provides the status of the latest document classifier version.</p>
    pub latest_version_status: std::option::Option<crate::model::ModelStatus>,
}
impl DocumentClassifierSummary {
    /// <p>The name that you assigned the document classifier.</p>
    pub fn document_classifier_name(&self) -> std::option::Option<&str> {
        self.document_classifier_name.as_deref()
    }
    /// <p>The number of versions you created.</p>
    pub fn number_of_versions(&self) -> std::option::Option<i32> {
        self.number_of_versions
    }
    /// <p>The time that the latest document classifier version was submitted for processing.</p>
    pub fn latest_version_created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.latest_version_created_at.as_ref()
    }
    /// <p>The version name you assigned to the latest document classifier version.</p>
    pub fn latest_version_name(&self) -> std::option::Option<&str> {
        self.latest_version_name.as_deref()
    }
    /// <p>Provides the status of the latest document classifier version.</p>
    pub fn latest_version_status(&self) -> std::option::Option<&crate::model::ModelStatus> {
        self.latest_version_status.as_ref()
    }
}
impl std::fmt::Debug for DocumentClassifierSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentClassifierSummary");
        formatter.field("document_classifier_name", &self.document_classifier_name);
        formatter.field("number_of_versions", &self.number_of_versions);
        formatter.field("latest_version_created_at", &self.latest_version_created_at);
        formatter.field("latest_version_name", &self.latest_version_name);
        formatter.field("latest_version_status", &self.latest_version_status);
        formatter.finish()
    }
}
/// See [`DocumentClassifierSummary`](crate::model::DocumentClassifierSummary)
pub mod document_classifier_summary {
    /// A builder for [`DocumentClassifierSummary`](crate::model::DocumentClassifierSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_classifier_name: std::option::Option<std::string::String>,
        pub(crate) number_of_versions: std::option::Option<i32>,
        pub(crate) latest_version_created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) latest_version_name: std::option::Option<std::string::String>,
        pub(crate) latest_version_status: std::option::Option<crate::model::ModelStatus>,
    }
    impl Builder {
        /// <p>The name that you assigned the document classifier.</p>
        pub fn document_classifier_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_classifier_name = Some(input.into());
            self
        }
        /// <p>The name that you assigned the document classifier.</p>
        pub fn set_document_classifier_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_classifier_name = input;
            self
        }
        /// <p>The number of versions you created.</p>
        pub fn number_of_versions(mut self, input: i32) -> Self {
            self.number_of_versions = Some(input);
            self
        }
        /// <p>The number of versions you created.</p>
        pub fn set_number_of_versions(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_versions = input;
            self
        }
        /// <p>The time that the latest document classifier version was submitted for processing.</p>
        pub fn latest_version_created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.latest_version_created_at = Some(input);
            self
        }
        /// <p>The time that the latest document classifier version was submitted for processing.</p>
        pub fn set_latest_version_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.latest_version_created_at = input;
            self
        }
        /// <p>The version name you assigned to the latest document classifier version.</p>
        pub fn latest_version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_version_name = Some(input.into());
            self
        }
        /// <p>The version name you assigned to the latest document classifier version.</p>
        pub fn set_latest_version_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_version_name = input;
            self
        }
        /// <p>Provides the status of the latest document classifier version.</p>
        pub fn latest_version_status(mut self, input: crate::model::ModelStatus) -> Self {
            self.latest_version_status = Some(input);
            self
        }
        /// <p>Provides the status of the latest document classifier version.</p>
        pub fn set_latest_version_status(
            mut self,
            input: std::option::Option<crate::model::ModelStatus>,
        ) -> Self {
            self.latest_version_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentClassifierSummary`](crate::model::DocumentClassifierSummary)
        pub fn build(self) -> crate::model::DocumentClassifierSummary {
            crate::model::DocumentClassifierSummary {
                document_classifier_name: self.document_classifier_name,
                number_of_versions: self.number_of_versions,
                latest_version_created_at: self.latest_version_created_at,
                latest_version_name: self.latest_version_name,
                latest_version_status: self.latest_version_status,
            }
        }
    }
}
impl DocumentClassifierSummary {
    /// Creates a new builder-style object to manufacture [`DocumentClassifierSummary`](crate::model::DocumentClassifierSummary)
    pub fn builder() -> crate::model::document_classifier_summary::Builder {
        crate::model::document_classifier_summary::Builder::default()
    }
}

/// <p>Provides information about a document classifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentClassifierProperties {
    /// <p>The Amazon Resource Name (ARN) that identifies the document classifier.</p>
    pub document_classifier_arn: std::option::Option<std::string::String>,
    /// <p>The language code for the language of the documents that the classifier was trained
    /// on.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>The status of the document classifier. If the status is <code>TRAINED</code> the
    /// classifier is ready to use. If the status is <code>FAILED</code> you can see additional
    /// information about why the classifier wasn't trained in the <code>Message</code> field.</p>
    pub status: std::option::Option<crate::model::ModelStatus>,
    /// <p>Additional information about the status of the classifier.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time that the document classifier was submitted for training.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that training the document classifier completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Indicates the time when the training starts on documentation classifiers. You are billed
    /// for the time interval between this time and the value of TrainingEndTime. </p>
    pub training_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that training of the document classifier was completed. Indicates the time when
    /// the training completes on documentation classifiers. You are billed for the time interval
    /// between this time and the value of TrainingStartTime.</p>
    pub training_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The input data configuration that you supplied when you created the document classifier
    /// for training.</p>
    pub input_data_config: std::option::Option<crate::model::DocumentClassifierInputDataConfig>,
    /// <p> Provides output results configuration parameters for custom classifier jobs.</p>
    pub output_data_config: std::option::Option<crate::model::DocumentClassifierOutputDataConfig>,
    /// <p>Information about the document classifier, including the number of documents used for
    /// training the classifier, the number of documents used for test the classifier, and an accuracy
    /// rating.</p>
    pub classifier_metadata: std::option::Option<crate::model::ClassifierMetadata>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
    /// Amazon Comprehend read access to your input data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Indicates the mode in which the specific classifier was trained. This also indicates the
    /// format of input documents and the format of the confusion matrix. Each classifier can only be
    /// trained in one mode and this cannot be changed once the classifier is trained.</p>
    pub mode: std::option::Option<crate::model::DocumentClassifierMode>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub model_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The version name that you assigned to the document classifier.</p>
    pub version_name: std::option::Option<std::string::String>,
}
impl DocumentClassifierProperties {
    /// <p>The Amazon Resource Name (ARN) that identifies the document classifier.</p>
    pub fn document_classifier_arn(&self) -> std::option::Option<&str> {
        self.document_classifier_arn.as_deref()
    }
    /// <p>The language code for the language of the documents that the classifier was trained
    /// on.</p>
    pub fn language_code(&self) -> std::option::Option<&crate::model::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The status of the document classifier. If the status is <code>TRAINED</code> the
    /// classifier is ready to use. If the status is <code>FAILED</code> you can see additional
    /// information about why the classifier wasn't trained in the <code>Message</code> field.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ModelStatus> {
        self.status.as_ref()
    }
    /// <p>Additional information about the status of the classifier.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time that the document classifier was submitted for training.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time.as_ref()
    }
    /// <p>The time that training the document classifier completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>Indicates the time when the training starts on documentation classifiers. You are billed
    /// for the time interval between this time and the value of TrainingEndTime. </p>
    pub fn training_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.training_start_time.as_ref()
    }
    /// <p>The time that training of the document classifier was completed. Indicates the time when
    /// the training completes on documentation classifiers. You are billed for the time interval
    /// between this time and the value of TrainingStartTime.</p>
    pub fn training_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.training_end_time.as_ref()
    }
    /// <p>The input data configuration that you supplied when you created the document classifier
    /// for training.</p>
    pub fn input_data_config(
        &self,
    ) -> std::option::Option<&crate::model::DocumentClassifierInputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p> Provides output results configuration parameters for custom classifier jobs.</p>
    pub fn output_data_config(
        &self,
    ) -> std::option::Option<&crate::model::DocumentClassifierOutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>Information about the document classifier, including the number of documents used for
    /// training the classifier, the number of documents used for test the classifier, and an accuracy
    /// rating.</p>
    pub fn classifier_metadata(&self) -> std::option::Option<&crate::model::ClassifierMetadata> {
        self.classifier_metadata.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
    /// Amazon Comprehend read access to your input data.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn volume_kms_key_id(&self) -> std::option::Option<&str> {
        self.volume_kms_key_id.as_deref()
    }
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>Indicates the mode in which the specific classifier was trained. This also indicates the
    /// format of input documents and the format of the confusion matrix. Each classifier can only be
    /// trained in one mode and this cannot be changed once the classifier is trained.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::DocumentClassifierMode> {
        self.mode.as_ref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn model_kms_key_id(&self) -> std::option::Option<&str> {
        self.model_kms_key_id.as_deref()
    }
    /// <p>The version name that you assigned to the document classifier.</p>
    pub fn version_name(&self) -> std::option::Option<&str> {
        self.version_name.as_deref()
    }
}
impl std::fmt::Debug for DocumentClassifierProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentClassifierProperties");
        formatter.field("document_classifier_arn", &self.document_classifier_arn);
        formatter.field("language_code", &self.language_code);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("training_start_time", &self.training_start_time);
        formatter.field("training_end_time", &self.training_end_time);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("classifier_metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("mode", &self.mode);
        formatter.field("model_kms_key_id", &self.model_kms_key_id);
        formatter.field("version_name", &self.version_name);
        formatter.finish()
    }
}
/// See [`DocumentClassifierProperties`](crate::model::DocumentClassifierProperties)
pub mod document_classifier_properties {
    /// A builder for [`DocumentClassifierProperties`](crate::model::DocumentClassifierProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_classifier_arn: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) status: std::option::Option<crate::model::ModelStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) training_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) training_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input_data_config:
            std::option::Option<crate::model::DocumentClassifierInputDataConfig>,
        pub(crate) output_data_config:
            std::option::Option<crate::model::DocumentClassifierOutputDataConfig>,
        pub(crate) classifier_metadata: std::option::Option<crate::model::ClassifierMetadata>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) mode: std::option::Option<crate::model::DocumentClassifierMode>,
        pub(crate) model_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier.</p>
        pub fn document_classifier_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_classifier_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier.</p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_classifier_arn = input;
            self
        }
        /// <p>The language code for the language of the documents that the classifier was trained
        /// on.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code for the language of the documents that the classifier was trained
        /// on.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The status of the document classifier. If the status is <code>TRAINED</code> the
        /// classifier is ready to use. If the status is <code>FAILED</code> you can see additional
        /// information about why the classifier wasn't trained in the <code>Message</code> field.</p>
        pub fn status(mut self, input: crate::model::ModelStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the document classifier. If the status is <code>TRAINED</code> the
        /// classifier is ready to use. If the status is <code>FAILED</code> you can see additional
        /// information about why the classifier wasn't trained in the <code>Message</code> field.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::ModelStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>Additional information about the status of the classifier.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Additional information about the status of the classifier.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time that the document classifier was submitted for training.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time that the document classifier was submitted for training.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time that training the document classifier completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that training the document classifier completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Indicates the time when the training starts on documentation classifiers. You are billed
        /// for the time interval between this time and the value of TrainingEndTime. </p>
        pub fn training_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.training_start_time = Some(input);
            self
        }
        /// <p>Indicates the time when the training starts on documentation classifiers. You are billed
        /// for the time interval between this time and the value of TrainingEndTime. </p>
        pub fn set_training_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.training_start_time = input;
            self
        }
        /// <p>The time that training of the document classifier was completed. Indicates the time when
        /// the training completes on documentation classifiers. You are billed for the time interval
        /// between this time and the value of TrainingStartTime.</p>
        pub fn training_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.training_end_time = Some(input);
            self
        }
        /// <p>The time that training of the document classifier was completed. Indicates the time when
        /// the training completes on documentation classifiers. You are billed for the time interval
        /// between this time and the value of TrainingStartTime.</p>
        pub fn set_training_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.training_end_time = input;
            self
        }
        /// <p>The input data configuration that you supplied when you created the document classifier
        /// for training.</p>
        pub fn input_data_config(
            mut self,
            input: crate::model::DocumentClassifierInputDataConfig,
        ) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data configuration that you supplied when you created the document classifier
        /// for training.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierInputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p> Provides output results configuration parameters for custom classifier jobs.</p>
        pub fn output_data_config(
            mut self,
            input: crate::model::DocumentClassifierOutputDataConfig,
        ) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p> Provides output results configuration parameters for custom classifier jobs.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierOutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>Information about the document classifier, including the number of documents used for
        /// training the classifier, the number of documents used for test the classifier, and an accuracy
        /// rating.</p>
        pub fn classifier_metadata(mut self, input: crate::model::ClassifierMetadata) -> Self {
            self.classifier_metadata = Some(input);
            self
        }
        /// <p>Information about the document classifier, including the number of documents used for
        /// training the classifier, the number of documents used for test the classifier, and an accuracy
        /// rating.</p>
        pub fn set_classifier_metadata(
            mut self,
            input: std::option::Option<crate::model::ClassifierMetadata>,
        ) -> Self {
            self.classifier_metadata = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Indicates the mode in which the specific classifier was trained. This also indicates the
        /// format of input documents and the format of the confusion matrix. Each classifier can only be
        /// trained in one mode and this cannot be changed once the classifier is trained.</p>
        pub fn mode(mut self, input: crate::model::DocumentClassifierMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>Indicates the mode in which the specific classifier was trained. This also indicates the
        /// format of input documents and the format of the confusion matrix. Each classifier can only be
        /// trained in one mode and this cannot be changed once the classifier is trained.</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn model_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_model_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_kms_key_id = input;
            self
        }
        /// <p>The version name that you assigned to the document classifier.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>The version name that you assigned to the document classifier.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentClassifierProperties`](crate::model::DocumentClassifierProperties)
        pub fn build(self) -> crate::model::DocumentClassifierProperties {
            crate::model::DocumentClassifierProperties {
                document_classifier_arn: self.document_classifier_arn,
                language_code: self.language_code,
                status: self.status,
                message: self.message,
                submit_time: self.submit_time,
                end_time: self.end_time,
                training_start_time: self.training_start_time,
                training_end_time: self.training_end_time,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                classifier_metadata: self.classifier_metadata,
                data_access_role_arn: self.data_access_role_arn,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
                mode: self.mode,
                model_kms_key_id: self.model_kms_key_id,
                version_name: self.version_name,
            }
        }
    }
}
impl DocumentClassifierProperties {
    /// Creates a new builder-style object to manufacture [`DocumentClassifierProperties`](crate::model::DocumentClassifierProperties)
    pub fn builder() -> crate::model::document_classifier_properties::Builder {
        crate::model::document_classifier_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentClassifierMode {
    #[allow(missing_docs)] // documentation missing in model
    MultiClass,
    #[allow(missing_docs)] // documentation missing in model
    MultiLabel,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentClassifierMode {
    fn from(s: &str) -> Self {
        match s {
            "MULTI_CLASS" => DocumentClassifierMode::MultiClass,
            "MULTI_LABEL" => DocumentClassifierMode::MultiLabel,
            other => DocumentClassifierMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentClassifierMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentClassifierMode::from(s))
    }
}
impl DocumentClassifierMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentClassifierMode::MultiClass => "MULTI_CLASS",
            DocumentClassifierMode::MultiLabel => "MULTI_LABEL",
            DocumentClassifierMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI_CLASS", "MULTI_LABEL"]
    }
}
impl AsRef<str> for DocumentClassifierMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about a document classifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClassifierMetadata {
    /// <p>The number of labels in the input data. </p>
    pub number_of_labels: std::option::Option<i32>,
    /// <p>The number of documents in the input data that were used to train the classifier.
    /// Typically this is 80 to 90 percent of the input documents.</p>
    pub number_of_trained_documents: std::option::Option<i32>,
    /// <p>The number of documents in the input data that were used to test the classifier. Typically
    /// this is 10 to 20 percent of the input documents, up to 10,000 documents.</p>
    pub number_of_test_documents: std::option::Option<i32>,
    /// <p> Describes the result metrics for the test data associated with an documentation
    /// classifier.</p>
    pub evaluation_metrics: std::option::Option<crate::model::ClassifierEvaluationMetrics>,
}
impl ClassifierMetadata {
    /// <p>The number of labels in the input data. </p>
    pub fn number_of_labels(&self) -> std::option::Option<i32> {
        self.number_of_labels
    }
    /// <p>The number of documents in the input data that were used to train the classifier.
    /// Typically this is 80 to 90 percent of the input documents.</p>
    pub fn number_of_trained_documents(&self) -> std::option::Option<i32> {
        self.number_of_trained_documents
    }
    /// <p>The number of documents in the input data that were used to test the classifier. Typically
    /// this is 10 to 20 percent of the input documents, up to 10,000 documents.</p>
    pub fn number_of_test_documents(&self) -> std::option::Option<i32> {
        self.number_of_test_documents
    }
    /// <p> Describes the result metrics for the test data associated with an documentation
    /// classifier.</p>
    pub fn evaluation_metrics(
        &self,
    ) -> std::option::Option<&crate::model::ClassifierEvaluationMetrics> {
        self.evaluation_metrics.as_ref()
    }
}
impl std::fmt::Debug for ClassifierMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClassifierMetadata");
        formatter.field("number_of_labels", &self.number_of_labels);
        formatter.field(
            "number_of_trained_documents",
            &self.number_of_trained_documents,
        );
        formatter.field("number_of_test_documents", &self.number_of_test_documents);
        formatter.field("evaluation_metrics", &self.evaluation_metrics);
        formatter.finish()
    }
}
/// See [`ClassifierMetadata`](crate::model::ClassifierMetadata)
pub mod classifier_metadata {
    /// A builder for [`ClassifierMetadata`](crate::model::ClassifierMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number_of_labels: std::option::Option<i32>,
        pub(crate) number_of_trained_documents: std::option::Option<i32>,
        pub(crate) number_of_test_documents: std::option::Option<i32>,
        pub(crate) evaluation_metrics:
            std::option::Option<crate::model::ClassifierEvaluationMetrics>,
    }
    impl Builder {
        /// <p>The number of labels in the input data. </p>
        pub fn number_of_labels(mut self, input: i32) -> Self {
            self.number_of_labels = Some(input);
            self
        }
        /// <p>The number of labels in the input data. </p>
        pub fn set_number_of_labels(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_labels = input;
            self
        }
        /// <p>The number of documents in the input data that were used to train the classifier.
        /// Typically this is 80 to 90 percent of the input documents.</p>
        pub fn number_of_trained_documents(mut self, input: i32) -> Self {
            self.number_of_trained_documents = Some(input);
            self
        }
        /// <p>The number of documents in the input data that were used to train the classifier.
        /// Typically this is 80 to 90 percent of the input documents.</p>
        pub fn set_number_of_trained_documents(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_trained_documents = input;
            self
        }
        /// <p>The number of documents in the input data that were used to test the classifier. Typically
        /// this is 10 to 20 percent of the input documents, up to 10,000 documents.</p>
        pub fn number_of_test_documents(mut self, input: i32) -> Self {
            self.number_of_test_documents = Some(input);
            self
        }
        /// <p>The number of documents in the input data that were used to test the classifier. Typically
        /// this is 10 to 20 percent of the input documents, up to 10,000 documents.</p>
        pub fn set_number_of_test_documents(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_test_documents = input;
            self
        }
        /// <p> Describes the result metrics for the test data associated with an documentation
        /// classifier.</p>
        pub fn evaluation_metrics(
            mut self,
            input: crate::model::ClassifierEvaluationMetrics,
        ) -> Self {
            self.evaluation_metrics = Some(input);
            self
        }
        /// <p> Describes the result metrics for the test data associated with an documentation
        /// classifier.</p>
        pub fn set_evaluation_metrics(
            mut self,
            input: std::option::Option<crate::model::ClassifierEvaluationMetrics>,
        ) -> Self {
            self.evaluation_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`ClassifierMetadata`](crate::model::ClassifierMetadata)
        pub fn build(self) -> crate::model::ClassifierMetadata {
            crate::model::ClassifierMetadata {
                number_of_labels: self.number_of_labels,
                number_of_trained_documents: self.number_of_trained_documents,
                number_of_test_documents: self.number_of_test_documents,
                evaluation_metrics: self.evaluation_metrics,
            }
        }
    }
}
impl ClassifierMetadata {
    /// Creates a new builder-style object to manufacture [`ClassifierMetadata`](crate::model::ClassifierMetadata)
    pub fn builder() -> crate::model::classifier_metadata::Builder {
        crate::model::classifier_metadata::Builder::default()
    }
}

/// <p>Describes the result metrics for the test data associated with an documentation
/// classifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClassifierEvaluationMetrics {
    /// <p>The fraction of the labels that were correct recognized. It is computed by dividing the
    /// number of labels in the test documents that were correctly recognized by the total number of
    /// labels in the test documents.</p>
    pub accuracy: std::option::Option<f64>,
    /// <p>A measure of the usefulness of the classifier results in the test data. High precision
    /// means that the classifier returned substantially more relevant results than irrelevant
    /// ones.</p>
    pub precision: std::option::Option<f64>,
    /// <p>A measure of how complete the classifier results are for the test data. High recall means
    /// that the classifier returned most of the relevant results. </p>
    pub recall: std::option::Option<f64>,
    /// <p>A measure of how accurate the classifier results are for the test data. It is derived from
    /// the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the
    /// harmonic average of the two scores. The highest score is 1, and the worst score is 0. </p>
    pub f1_score: std::option::Option<f64>,
    /// <p>A measure of the usefulness of the recognizer results in the test data. High precision
    /// means that the recognizer returned substantially more relevant results than irrelevant ones.
    /// Unlike the Precision metric which comes from averaging the precision of all available labels,
    /// this is based on the overall score of all precision scores added together.</p>
    pub micro_precision: std::option::Option<f64>,
    /// <p>A measure of how complete the classifier results are for the test data. High recall means
    /// that the classifier returned most of the relevant results. Specifically, this indicates how
    /// many of the correct categories in the text that the model can predict. It is a percentage of
    /// correct categories in the text that can found. Instead of averaging the recall scores of all
    /// labels (as with Recall), micro Recall is based on the overall score of all recall scores added
    /// together.</p>
    pub micro_recall: std::option::Option<f64>,
    /// <p>A measure of how accurate the classifier results are for the test data. It is a
    /// combination of the <code>Micro Precision</code> and <code>Micro Recall</code> values. The
    /// <code>Micro F1Score</code> is the harmonic mean of the two scores. The highest score is 1,
    /// and the worst score is 0.</p>
    pub micro_f1_score: std::option::Option<f64>,
    /// <p>Indicates the fraction of labels that are incorrectly predicted. Also seen as the fraction
    /// of wrong labels compared to the total number of labels. Scores closer to zero are
    /// better.</p>
    pub hamming_loss: std::option::Option<f64>,
}
impl ClassifierEvaluationMetrics {
    /// <p>The fraction of the labels that were correct recognized. It is computed by dividing the
    /// number of labels in the test documents that were correctly recognized by the total number of
    /// labels in the test documents.</p>
    pub fn accuracy(&self) -> std::option::Option<f64> {
        self.accuracy
    }
    /// <p>A measure of the usefulness of the classifier results in the test data. High precision
    /// means that the classifier returned substantially more relevant results than irrelevant
    /// ones.</p>
    pub fn precision(&self) -> std::option::Option<f64> {
        self.precision
    }
    /// <p>A measure of how complete the classifier results are for the test data. High recall means
    /// that the classifier returned most of the relevant results. </p>
    pub fn recall(&self) -> std::option::Option<f64> {
        self.recall
    }
    /// <p>A measure of how accurate the classifier results are for the test data. It is derived from
    /// the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the
    /// harmonic average of the two scores. The highest score is 1, and the worst score is 0. </p>
    pub fn f1_score(&self) -> std::option::Option<f64> {
        self.f1_score
    }
    /// <p>A measure of the usefulness of the recognizer results in the test data. High precision
    /// means that the recognizer returned substantially more relevant results than irrelevant ones.
    /// Unlike the Precision metric which comes from averaging the precision of all available labels,
    /// this is based on the overall score of all precision scores added together.</p>
    pub fn micro_precision(&self) -> std::option::Option<f64> {
        self.micro_precision
    }
    /// <p>A measure of how complete the classifier results are for the test data. High recall means
    /// that the classifier returned most of the relevant results. Specifically, this indicates how
    /// many of the correct categories in the text that the model can predict. It is a percentage of
    /// correct categories in the text that can found. Instead of averaging the recall scores of all
    /// labels (as with Recall), micro Recall is based on the overall score of all recall scores added
    /// together.</p>
    pub fn micro_recall(&self) -> std::option::Option<f64> {
        self.micro_recall
    }
    /// <p>A measure of how accurate the classifier results are for the test data. It is a
    /// combination of the <code>Micro Precision</code> and <code>Micro Recall</code> values. The
    /// <code>Micro F1Score</code> is the harmonic mean of the two scores. The highest score is 1,
    /// and the worst score is 0.</p>
    pub fn micro_f1_score(&self) -> std::option::Option<f64> {
        self.micro_f1_score
    }
    /// <p>Indicates the fraction of labels that are incorrectly predicted. Also seen as the fraction
    /// of wrong labels compared to the total number of labels. Scores closer to zero are
    /// better.</p>
    pub fn hamming_loss(&self) -> std::option::Option<f64> {
        self.hamming_loss
    }
}
impl std::fmt::Debug for ClassifierEvaluationMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClassifierEvaluationMetrics");
        formatter.field("accuracy", &self.accuracy);
        formatter.field("precision", &self.precision);
        formatter.field("recall", &self.recall);
        formatter.field("f1_score", &self.f1_score);
        formatter.field("micro_precision", &self.micro_precision);
        formatter.field("micro_recall", &self.micro_recall);
        formatter.field("micro_f1_score", &self.micro_f1_score);
        formatter.field("hamming_loss", &self.hamming_loss);
        formatter.finish()
    }
}
/// See [`ClassifierEvaluationMetrics`](crate::model::ClassifierEvaluationMetrics)
pub mod classifier_evaluation_metrics {
    /// A builder for [`ClassifierEvaluationMetrics`](crate::model::ClassifierEvaluationMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accuracy: std::option::Option<f64>,
        pub(crate) precision: std::option::Option<f64>,
        pub(crate) recall: std::option::Option<f64>,
        pub(crate) f1_score: std::option::Option<f64>,
        pub(crate) micro_precision: std::option::Option<f64>,
        pub(crate) micro_recall: std::option::Option<f64>,
        pub(crate) micro_f1_score: std::option::Option<f64>,
        pub(crate) hamming_loss: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The fraction of the labels that were correct recognized. It is computed by dividing the
        /// number of labels in the test documents that were correctly recognized by the total number of
        /// labels in the test documents.</p>
        pub fn accuracy(mut self, input: f64) -> Self {
            self.accuracy = Some(input);
            self
        }
        /// <p>The fraction of the labels that were correct recognized. It is computed by dividing the
        /// number of labels in the test documents that were correctly recognized by the total number of
        /// labels in the test documents.</p>
        pub fn set_accuracy(mut self, input: std::option::Option<f64>) -> Self {
            self.accuracy = input;
            self
        }
        /// <p>A measure of the usefulness of the classifier results in the test data. High precision
        /// means that the classifier returned substantially more relevant results than irrelevant
        /// ones.</p>
        pub fn precision(mut self, input: f64) -> Self {
            self.precision = Some(input);
            self
        }
        /// <p>A measure of the usefulness of the classifier results in the test data. High precision
        /// means that the classifier returned substantially more relevant results than irrelevant
        /// ones.</p>
        pub fn set_precision(mut self, input: std::option::Option<f64>) -> Self {
            self.precision = input;
            self
        }
        /// <p>A measure of how complete the classifier results are for the test data. High recall means
        /// that the classifier returned most of the relevant results. </p>
        pub fn recall(mut self, input: f64) -> Self {
            self.recall = Some(input);
            self
        }
        /// <p>A measure of how complete the classifier results are for the test data. High recall means
        /// that the classifier returned most of the relevant results. </p>
        pub fn set_recall(mut self, input: std::option::Option<f64>) -> Self {
            self.recall = input;
            self
        }
        /// <p>A measure of how accurate the classifier results are for the test data. It is derived from
        /// the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the
        /// harmonic average of the two scores. The highest score is 1, and the worst score is 0. </p>
        pub fn f1_score(mut self, input: f64) -> Self {
            self.f1_score = Some(input);
            self
        }
        /// <p>A measure of how accurate the classifier results are for the test data. It is derived from
        /// the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the
        /// harmonic average of the two scores. The highest score is 1, and the worst score is 0. </p>
        pub fn set_f1_score(mut self, input: std::option::Option<f64>) -> Self {
            self.f1_score = input;
            self
        }
        /// <p>A measure of the usefulness of the recognizer results in the test data. High precision
        /// means that the recognizer returned substantially more relevant results than irrelevant ones.
        /// Unlike the Precision metric which comes from averaging the precision of all available labels,
        /// this is based on the overall score of all precision scores added together.</p>
        pub fn micro_precision(mut self, input: f64) -> Self {
            self.micro_precision = Some(input);
            self
        }
        /// <p>A measure of the usefulness of the recognizer results in the test data. High precision
        /// means that the recognizer returned substantially more relevant results than irrelevant ones.
        /// Unlike the Precision metric which comes from averaging the precision of all available labels,
        /// this is based on the overall score of all precision scores added together.</p>
        pub fn set_micro_precision(mut self, input: std::option::Option<f64>) -> Self {
            self.micro_precision = input;
            self
        }
        /// <p>A measure of how complete the classifier results are for the test data. High recall means
        /// that the classifier returned most of the relevant results. Specifically, this indicates how
        /// many of the correct categories in the text that the model can predict. It is a percentage of
        /// correct categories in the text that can found. Instead of averaging the recall scores of all
        /// labels (as with Recall), micro Recall is based on the overall score of all recall scores added
        /// together.</p>
        pub fn micro_recall(mut self, input: f64) -> Self {
            self.micro_recall = Some(input);
            self
        }
        /// <p>A measure of how complete the classifier results are for the test data. High recall means
        /// that the classifier returned most of the relevant results. Specifically, this indicates how
        /// many of the correct categories in the text that the model can predict. It is a percentage of
        /// correct categories in the text that can found. Instead of averaging the recall scores of all
        /// labels (as with Recall), micro Recall is based on the overall score of all recall scores added
        /// together.</p>
        pub fn set_micro_recall(mut self, input: std::option::Option<f64>) -> Self {
            self.micro_recall = input;
            self
        }
        /// <p>A measure of how accurate the classifier results are for the test data. It is a
        /// combination of the <code>Micro Precision</code> and <code>Micro Recall</code> values. The
        /// <code>Micro F1Score</code> is the harmonic mean of the two scores. The highest score is 1,
        /// and the worst score is 0.</p>
        pub fn micro_f1_score(mut self, input: f64) -> Self {
            self.micro_f1_score = Some(input);
            self
        }
        /// <p>A measure of how accurate the classifier results are for the test data. It is a
        /// combination of the <code>Micro Precision</code> and <code>Micro Recall</code> values. The
        /// <code>Micro F1Score</code> is the harmonic mean of the two scores. The highest score is 1,
        /// and the worst score is 0.</p>
        pub fn set_micro_f1_score(mut self, input: std::option::Option<f64>) -> Self {
            self.micro_f1_score = input;
            self
        }
        /// <p>Indicates the fraction of labels that are incorrectly predicted. Also seen as the fraction
        /// of wrong labels compared to the total number of labels. Scores closer to zero are
        /// better.</p>
        pub fn hamming_loss(mut self, input: f64) -> Self {
            self.hamming_loss = Some(input);
            self
        }
        /// <p>Indicates the fraction of labels that are incorrectly predicted. Also seen as the fraction
        /// of wrong labels compared to the total number of labels. Scores closer to zero are
        /// better.</p>
        pub fn set_hamming_loss(mut self, input: std::option::Option<f64>) -> Self {
            self.hamming_loss = input;
            self
        }
        /// Consumes the builder and constructs a [`ClassifierEvaluationMetrics`](crate::model::ClassifierEvaluationMetrics)
        pub fn build(self) -> crate::model::ClassifierEvaluationMetrics {
            crate::model::ClassifierEvaluationMetrics {
                accuracy: self.accuracy,
                precision: self.precision,
                recall: self.recall,
                f1_score: self.f1_score,
                micro_precision: self.micro_precision,
                micro_recall: self.micro_recall,
                micro_f1_score: self.micro_f1_score,
                hamming_loss: self.hamming_loss,
            }
        }
    }
}
impl ClassifierEvaluationMetrics {
    /// Creates a new builder-style object to manufacture [`ClassifierEvaluationMetrics`](crate::model::ClassifierEvaluationMetrics)
    pub fn builder() -> crate::model::classifier_evaluation_metrics::Builder {
        crate::model::classifier_evaluation_metrics::Builder::default()
    }
}

/// <p>Provides output results configuration parameters for custom classifier jobs. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentClassifierOutputDataConfig {
    /// <p>When you use the <code>OutputDataConfig</code> object while creating a custom
    /// classifier, you specify the Amazon S3 location where you want to write the confusion matrix.
    /// The URI must be in the same region as the API endpoint that you are calling. The location is
    /// used as the prefix for the actual location of this output file.</p>
    /// <p>When the custom classifier job is finished, the service creates the output file in a
    /// directory specific to the job. The <code>S3Uri</code> field contains the location of the
    /// output file, called <code>output.tar.gz</code>. It is a compressed archive that contains the
    /// confusion matrix.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
    /// output results from an analysis job. The KmsKeyId can be one of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>KMS Key Alias: <code>"alias/ExampleAlias"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>ARN of a KMS Key Alias:
    /// <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl DocumentClassifierOutputDataConfig {
    /// <p>When you use the <code>OutputDataConfig</code> object while creating a custom
    /// classifier, you specify the Amazon S3 location where you want to write the confusion matrix.
    /// The URI must be in the same region as the API endpoint that you are calling. The location is
    /// used as the prefix for the actual location of this output file.</p>
    /// <p>When the custom classifier job is finished, the service creates the output file in a
    /// directory specific to the job. The <code>S3Uri</code> field contains the location of the
    /// output file, called <code>output.tar.gz</code>. It is a compressed archive that contains the
    /// confusion matrix.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
    /// output results from an analysis job. The KmsKeyId can be one of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>KMS Key Alias: <code>"alias/ExampleAlias"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>ARN of a KMS Key Alias:
    /// <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for DocumentClassifierOutputDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentClassifierOutputDataConfig");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`DocumentClassifierOutputDataConfig`](crate::model::DocumentClassifierOutputDataConfig)
pub mod document_classifier_output_data_config {
    /// A builder for [`DocumentClassifierOutputDataConfig`](crate::model::DocumentClassifierOutputDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>When you use the <code>OutputDataConfig</code> object while creating a custom
        /// classifier, you specify the Amazon S3 location where you want to write the confusion matrix.
        /// The URI must be in the same region as the API endpoint that you are calling. The location is
        /// used as the prefix for the actual location of this output file.</p>
        /// <p>When the custom classifier job is finished, the service creates the output file in a
        /// directory specific to the job. The <code>S3Uri</code> field contains the location of the
        /// output file, called <code>output.tar.gz</code>. It is a compressed archive that contains the
        /// confusion matrix.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>When you use the <code>OutputDataConfig</code> object while creating a custom
        /// classifier, you specify the Amazon S3 location where you want to write the confusion matrix.
        /// The URI must be in the same region as the API endpoint that you are calling. The location is
        /// used as the prefix for the actual location of this output file.</p>
        /// <p>When the custom classifier job is finished, the service creates the output file in a
        /// directory specific to the job. The <code>S3Uri</code> field contains the location of the
        /// output file, called <code>output.tar.gz</code>. It is a compressed archive that contains the
        /// confusion matrix.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
        /// output results from an analysis job. The KmsKeyId can be one of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>KMS Key Alias: <code>"alias/ExampleAlias"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ARN of a KMS Key Alias:
        /// <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
        /// output results from an analysis job. The KmsKeyId can be one of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>KMS Key Alias: <code>"alias/ExampleAlias"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ARN of a KMS Key Alias:
        /// <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentClassifierOutputDataConfig`](crate::model::DocumentClassifierOutputDataConfig)
        pub fn build(self) -> crate::model::DocumentClassifierOutputDataConfig {
            crate::model::DocumentClassifierOutputDataConfig {
                s3_uri: self.s3_uri,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl DocumentClassifierOutputDataConfig {
    /// Creates a new builder-style object to manufacture [`DocumentClassifierOutputDataConfig`](crate::model::DocumentClassifierOutputDataConfig)
    pub fn builder() -> crate::model::document_classifier_output_data_config::Builder {
        crate::model::document_classifier_output_data_config::Builder::default()
    }
}

/// <p>The input properties for training a document classifier. </p>
/// <p>For more information on how the input file is formatted, see <a>how-document-classification-training-data</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentClassifierInputDataConfig {
    /// <p>The format of your training data:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPREHEND_CSV</code>: A two-column CSV file, where labels are provided in the
    /// first column, and documents are provided in the second. If you use this value, you must
    /// provide the <code>S3Uri</code> parameter in your request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AUGMENTED_MANIFEST</code>: A labeled dataset that is produced by Amazon
    /// SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON
    /// object that contains a training document and its associated labels. </p>
    /// <p>If you use this value, you must provide the <code>AugmentedManifests</code> parameter
    /// in your request.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the
    /// default.</p>
    pub data_format: std::option::Option<crate::model::DocumentClassifierDataFormat>,
    /// <p>The Amazon S3 URI for the input data. The S3 bucket must be in the same region as the API
    /// endpoint that you are calling. The URI can point to a single input file or it can provide the
    /// prefix for a collection of input files.</p>
    /// <p>For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a
    /// single file, Amazon Comprehend uses that file as input. If more than one file begins with the
    /// prefix, Amazon Comprehend uses all of them as input.</p>
    /// <p>This parameter is required if you set <code>DataFormat</code> to
    /// <code>COMPREHEND_CSV</code>.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 URI for the input data.
    /// The Amazon S3 bucket must be in the same AWS Region as the API endpoint that you are calling.
    /// The URI can point to a single input file or it can provide the prefix for a collection of input files. </p>
    pub test_s3_uri: std::option::Option<std::string::String>,
    /// <p>Indicates the delimiter used to separate each label for training a multi-label classifier.
    /// The default delimiter between labels is a pipe (|). You can use a different character as a
    /// delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the
    /// training documents use a delimiter other than the default or the delimiter you specify, the
    /// labels on that line will be combined to make a single unique label, such as
    /// LABELLABELLABEL.</p>
    pub label_delimiter: std::option::Option<std::string::String>,
    /// <p>A list of augmented manifest files that provide training data for your custom model. An
    /// augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground
    /// Truth.</p>
    /// <p>This parameter is required if you set <code>DataFormat</code> to
    /// <code>AUGMENTED_MANIFEST</code>.</p>
    pub augmented_manifests:
        std::option::Option<std::vec::Vec<crate::model::AugmentedManifestsListItem>>,
}
impl DocumentClassifierInputDataConfig {
    /// <p>The format of your training data:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPREHEND_CSV</code>: A two-column CSV file, where labels are provided in the
    /// first column, and documents are provided in the second. If you use this value, you must
    /// provide the <code>S3Uri</code> parameter in your request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AUGMENTED_MANIFEST</code>: A labeled dataset that is produced by Amazon
    /// SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON
    /// object that contains a training document and its associated labels. </p>
    /// <p>If you use this value, you must provide the <code>AugmentedManifests</code> parameter
    /// in your request.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the
    /// default.</p>
    pub fn data_format(&self) -> std::option::Option<&crate::model::DocumentClassifierDataFormat> {
        self.data_format.as_ref()
    }
    /// <p>The Amazon S3 URI for the input data. The S3 bucket must be in the same region as the API
    /// endpoint that you are calling. The URI can point to a single input file or it can provide the
    /// prefix for a collection of input files.</p>
    /// <p>For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a
    /// single file, Amazon Comprehend uses that file as input. If more than one file begins with the
    /// prefix, Amazon Comprehend uses all of them as input.</p>
    /// <p>This parameter is required if you set <code>DataFormat</code> to
    /// <code>COMPREHEND_CSV</code>.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>The Amazon S3 URI for the input data.
    /// The Amazon S3 bucket must be in the same AWS Region as the API endpoint that you are calling.
    /// The URI can point to a single input file or it can provide the prefix for a collection of input files. </p>
    pub fn test_s3_uri(&self) -> std::option::Option<&str> {
        self.test_s3_uri.as_deref()
    }
    /// <p>Indicates the delimiter used to separate each label for training a multi-label classifier.
    /// The default delimiter between labels is a pipe (|). You can use a different character as a
    /// delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the
    /// training documents use a delimiter other than the default or the delimiter you specify, the
    /// labels on that line will be combined to make a single unique label, such as
    /// LABELLABELLABEL.</p>
    pub fn label_delimiter(&self) -> std::option::Option<&str> {
        self.label_delimiter.as_deref()
    }
    /// <p>A list of augmented manifest files that provide training data for your custom model. An
    /// augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground
    /// Truth.</p>
    /// <p>This parameter is required if you set <code>DataFormat</code> to
    /// <code>AUGMENTED_MANIFEST</code>.</p>
    pub fn augmented_manifests(
        &self,
    ) -> std::option::Option<&[crate::model::AugmentedManifestsListItem]> {
        self.augmented_manifests.as_deref()
    }
}
impl std::fmt::Debug for DocumentClassifierInputDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentClassifierInputDataConfig");
        formatter.field("data_format", &self.data_format);
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("test_s3_uri", &self.test_s3_uri);
        formatter.field("label_delimiter", &self.label_delimiter);
        formatter.field("augmented_manifests", &self.augmented_manifests);
        formatter.finish()
    }
}
/// See [`DocumentClassifierInputDataConfig`](crate::model::DocumentClassifierInputDataConfig)
pub mod document_classifier_input_data_config {
    /// A builder for [`DocumentClassifierInputDataConfig`](crate::model::DocumentClassifierInputDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_format: std::option::Option<crate::model::DocumentClassifierDataFormat>,
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) test_s3_uri: std::option::Option<std::string::String>,
        pub(crate) label_delimiter: std::option::Option<std::string::String>,
        pub(crate) augmented_manifests:
            std::option::Option<std::vec::Vec<crate::model::AugmentedManifestsListItem>>,
    }
    impl Builder {
        /// <p>The format of your training data:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPREHEND_CSV</code>: A two-column CSV file, where labels are provided in the
        /// first column, and documents are provided in the second. If you use this value, you must
        /// provide the <code>S3Uri</code> parameter in your request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUGMENTED_MANIFEST</code>: A labeled dataset that is produced by Amazon
        /// SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON
        /// object that contains a training document and its associated labels. </p>
        /// <p>If you use this value, you must provide the <code>AugmentedManifests</code> parameter
        /// in your request.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the
        /// default.</p>
        pub fn data_format(mut self, input: crate::model::DocumentClassifierDataFormat) -> Self {
            self.data_format = Some(input);
            self
        }
        /// <p>The format of your training data:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPREHEND_CSV</code>: A two-column CSV file, where labels are provided in the
        /// first column, and documents are provided in the second. If you use this value, you must
        /// provide the <code>S3Uri</code> parameter in your request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUGMENTED_MANIFEST</code>: A labeled dataset that is produced by Amazon
        /// SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON
        /// object that contains a training document and its associated labels. </p>
        /// <p>If you use this value, you must provide the <code>AugmentedManifests</code> parameter
        /// in your request.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the
        /// default.</p>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierDataFormat>,
        ) -> Self {
            self.data_format = input;
            self
        }
        /// <p>The Amazon S3 URI for the input data. The S3 bucket must be in the same region as the API
        /// endpoint that you are calling. The URI can point to a single input file or it can provide the
        /// prefix for a collection of input files.</p>
        /// <p>For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a
        /// single file, Amazon Comprehend uses that file as input. If more than one file begins with the
        /// prefix, Amazon Comprehend uses all of them as input.</p>
        /// <p>This parameter is required if you set <code>DataFormat</code> to
        /// <code>COMPREHEND_CSV</code>.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The Amazon S3 URI for the input data. The S3 bucket must be in the same region as the API
        /// endpoint that you are calling. The URI can point to a single input file or it can provide the
        /// prefix for a collection of input files.</p>
        /// <p>For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a
        /// single file, Amazon Comprehend uses that file as input. If more than one file begins with the
        /// prefix, Amazon Comprehend uses all of them as input.</p>
        /// <p>This parameter is required if you set <code>DataFormat</code> to
        /// <code>COMPREHEND_CSV</code>.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>The Amazon S3 URI for the input data.
        /// The Amazon S3 bucket must be in the same AWS Region as the API endpoint that you are calling.
        /// The URI can point to a single input file or it can provide the prefix for a collection of input files. </p>
        pub fn test_s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_s3_uri = Some(input.into());
            self
        }
        /// <p>The Amazon S3 URI for the input data.
        /// The Amazon S3 bucket must be in the same AWS Region as the API endpoint that you are calling.
        /// The URI can point to a single input file or it can provide the prefix for a collection of input files. </p>
        pub fn set_test_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.test_s3_uri = input;
            self
        }
        /// <p>Indicates the delimiter used to separate each label for training a multi-label classifier.
        /// The default delimiter between labels is a pipe (|). You can use a different character as a
        /// delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the
        /// training documents use a delimiter other than the default or the delimiter you specify, the
        /// labels on that line will be combined to make a single unique label, such as
        /// LABELLABELLABEL.</p>
        pub fn label_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.label_delimiter = Some(input.into());
            self
        }
        /// <p>Indicates the delimiter used to separate each label for training a multi-label classifier.
        /// The default delimiter between labels is a pipe (|). You can use a different character as a
        /// delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the
        /// training documents use a delimiter other than the default or the delimiter you specify, the
        /// labels on that line will be combined to make a single unique label, such as
        /// LABELLABELLABEL.</p>
        pub fn set_label_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.label_delimiter = input;
            self
        }
        /// Appends an item to `augmented_manifests`.
        ///
        /// To override the contents of this collection use [`set_augmented_manifests`](Self::set_augmented_manifests).
        ///
        /// <p>A list of augmented manifest files that provide training data for your custom model. An
        /// augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground
        /// Truth.</p>
        /// <p>This parameter is required if you set <code>DataFormat</code> to
        /// <code>AUGMENTED_MANIFEST</code>.</p>
        pub fn augmented_manifests(
            mut self,
            input: impl Into<crate::model::AugmentedManifestsListItem>,
        ) -> Self {
            let mut v = self.augmented_manifests.unwrap_or_default();
            v.push(input.into());
            self.augmented_manifests = Some(v);
            self
        }
        /// <p>A list of augmented manifest files that provide training data for your custom model. An
        /// augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground
        /// Truth.</p>
        /// <p>This parameter is required if you set <code>DataFormat</code> to
        /// <code>AUGMENTED_MANIFEST</code>.</p>
        pub fn set_augmented_manifests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AugmentedManifestsListItem>>,
        ) -> Self {
            self.augmented_manifests = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentClassifierInputDataConfig`](crate::model::DocumentClassifierInputDataConfig)
        pub fn build(self) -> crate::model::DocumentClassifierInputDataConfig {
            crate::model::DocumentClassifierInputDataConfig {
                data_format: self.data_format,
                s3_uri: self.s3_uri,
                test_s3_uri: self.test_s3_uri,
                label_delimiter: self.label_delimiter,
                augmented_manifests: self.augmented_manifests,
            }
        }
    }
}
impl DocumentClassifierInputDataConfig {
    /// Creates a new builder-style object to manufacture [`DocumentClassifierInputDataConfig`](crate::model::DocumentClassifierInputDataConfig)
    pub fn builder() -> crate::model::document_classifier_input_data_config::Builder {
        crate::model::document_classifier_input_data_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentClassifierDataFormat {
    #[allow(missing_docs)] // documentation missing in model
    AugmentedManifest,
    #[allow(missing_docs)] // documentation missing in model
    ComprehendCsv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentClassifierDataFormat {
    fn from(s: &str) -> Self {
        match s {
            "AUGMENTED_MANIFEST" => DocumentClassifierDataFormat::AugmentedManifest,
            "COMPREHEND_CSV" => DocumentClassifierDataFormat::ComprehendCsv,
            other => DocumentClassifierDataFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentClassifierDataFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentClassifierDataFormat::from(s))
    }
}
impl DocumentClassifierDataFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentClassifierDataFormat::AugmentedManifest => "AUGMENTED_MANIFEST",
            DocumentClassifierDataFormat::ComprehendCsv => "COMPREHEND_CSV",
            DocumentClassifierDataFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUGMENTED_MANIFEST", "COMPREHEND_CSV"]
    }
}
impl AsRef<str> for DocumentClassifierDataFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information for filtering a list of document classifiers. You can only specify
/// one filtering parameter in a request. For more information, see the  operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentClassifierFilter {
    /// <p>Filters the list of classifiers based on status.</p>
    pub status: std::option::Option<crate::model::ModelStatus>,
    /// <p>The name that you assigned to the document classifier</p>
    pub document_classifier_name: std::option::Option<std::string::String>,
    /// <p>Filters the list of classifiers based on the time that the classifier was submitted for
    /// processing. Returns only classifiers submitted before the specified time. Classifiers are
    /// returned in ascending order, oldest to newest.</p>
    pub submit_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters the list of classifiers based on the time that the classifier was submitted for
    /// processing. Returns only classifiers submitted after the specified time. Classifiers are
    /// returned in descending order, newest to oldest.</p>
    pub submit_time_after: std::option::Option<aws_smithy_types::Instant>,
}
impl DocumentClassifierFilter {
    /// <p>Filters the list of classifiers based on status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ModelStatus> {
        self.status.as_ref()
    }
    /// <p>The name that you assigned to the document classifier</p>
    pub fn document_classifier_name(&self) -> std::option::Option<&str> {
        self.document_classifier_name.as_deref()
    }
    /// <p>Filters the list of classifiers based on the time that the classifier was submitted for
    /// processing. Returns only classifiers submitted before the specified time. Classifiers are
    /// returned in ascending order, oldest to newest.</p>
    pub fn submit_time_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_before.as_ref()
    }
    /// <p>Filters the list of classifiers based on the time that the classifier was submitted for
    /// processing. Returns only classifiers submitted after the specified time. Classifiers are
    /// returned in descending order, newest to oldest.</p>
    pub fn submit_time_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_after.as_ref()
    }
}
impl std::fmt::Debug for DocumentClassifierFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentClassifierFilter");
        formatter.field("status", &self.status);
        formatter.field("document_classifier_name", &self.document_classifier_name);
        formatter.field("submit_time_before", &self.submit_time_before);
        formatter.field("submit_time_after", &self.submit_time_after);
        formatter.finish()
    }
}
/// See [`DocumentClassifierFilter`](crate::model::DocumentClassifierFilter)
pub mod document_classifier_filter {
    /// A builder for [`DocumentClassifierFilter`](crate::model::DocumentClassifierFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ModelStatus>,
        pub(crate) document_classifier_name: std::option::Option<std::string::String>,
        pub(crate) submit_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) submit_time_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Filters the list of classifiers based on status.</p>
        pub fn status(mut self, input: crate::model::ModelStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Filters the list of classifiers based on status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::ModelStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The name that you assigned to the document classifier</p>
        pub fn document_classifier_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_classifier_name = Some(input.into());
            self
        }
        /// <p>The name that you assigned to the document classifier</p>
        pub fn set_document_classifier_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_classifier_name = input;
            self
        }
        /// <p>Filters the list of classifiers based on the time that the classifier was submitted for
        /// processing. Returns only classifiers submitted before the specified time. Classifiers are
        /// returned in ascending order, oldest to newest.</p>
        pub fn submit_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_before = Some(input);
            self
        }
        /// <p>Filters the list of classifiers based on the time that the classifier was submitted for
        /// processing. Returns only classifiers submitted before the specified time. Classifiers are
        /// returned in ascending order, oldest to newest.</p>
        pub fn set_submit_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_before = input;
            self
        }
        /// <p>Filters the list of classifiers based on the time that the classifier was submitted for
        /// processing. Returns only classifiers submitted after the specified time. Classifiers are
        /// returned in descending order, newest to oldest.</p>
        pub fn submit_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_after = Some(input);
            self
        }
        /// <p>Filters the list of classifiers based on the time that the classifier was submitted for
        /// processing. Returns only classifiers submitted after the specified time. Classifiers are
        /// returned in descending order, newest to oldest.</p>
        pub fn set_submit_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_after = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentClassifierFilter`](crate::model::DocumentClassifierFilter)
        pub fn build(self) -> crate::model::DocumentClassifierFilter {
            crate::model::DocumentClassifierFilter {
                status: self.status,
                document_classifier_name: self.document_classifier_name,
                submit_time_before: self.submit_time_before,
                submit_time_after: self.submit_time_after,
            }
        }
    }
}
impl DocumentClassifierFilter {
    /// Creates a new builder-style object to manufacture [`DocumentClassifierFilter`](crate::model::DocumentClassifierFilter)
    pub fn builder() -> crate::model::document_classifier_filter::Builder {
        crate::model::document_classifier_filter::Builder::default()
    }
}

/// <p>Provides information about a document classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentClassificationJobProperties {
    /// <p>The identifier assigned to the document classification job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:document-classification-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The name that you assigned to the document classification job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The current status of the document classification job. If the status is
    /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>A description of the status of the job.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time that the document classification job was submitted for processing.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the document classification job completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
    pub document_classifier_arn: std::option::Option<std::string::String>,
    /// <p>The input data configuration that you supplied when you created the document
    /// classification job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data configuration that you supplied when you created the document
    /// classification job.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to your input data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your document classification job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
}
impl DocumentClassificationJobProperties {
    /// <p>The identifier assigned to the document classification job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully
    /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
    /// format of the ARN is as follows:</p>
    /// <p>
    /// <code>arn:<partition>:comprehend:<region>:<account-id>:document-classification-job/<job-id></code>
    /// </p>
    /// <p>The following is an example job ARN:</p>
    /// <p>
    /// <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code>
    /// </p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The name that you assigned to the document classification job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The current status of the document classification job. If the status is
    /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>A description of the status of the job.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time that the document classification job was submitted for processing.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time.as_ref()
    }
    /// <p>The time that the document classification job completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
    pub fn document_classifier_arn(&self) -> std::option::Option<&str> {
        self.document_classifier_arn.as_deref()
    }
    /// <p>The input data configuration that you supplied when you created the document
    /// classification job.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>The output data configuration that you supplied when you created the document
    /// classification job.</p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to your input data.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn volume_kms_key_id(&self) -> std::option::Option<&str> {
        self.volume_kms_key_id.as_deref()
    }
    /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
    /// resources you are using for your document classification job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
}
impl std::fmt::Debug for DocumentClassificationJobProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentClassificationJobProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("message", &self.message);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("document_classifier_arn", &self.document_classifier_arn);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.finish()
    }
}
/// See [`DocumentClassificationJobProperties`](crate::model::DocumentClassificationJobProperties)
pub mod document_classification_job_properties {
    /// A builder for [`DocumentClassificationJobProperties`](crate::model::DocumentClassificationJobProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) document_classifier_arn: std::option::Option<std::string::String>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
    }
    impl Builder {
        /// <p>The identifier assigned to the document classification job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier assigned to the document classification job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:document-classification-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully
        /// qualified identifier for the job. It includes the AWS account, Region, and the job ID. The
        /// format of the ARN is as follows:</p>
        /// <p>
        /// <code>arn:<partition>:comprehend:<region>:<account-id>:document-classification-job/<job-id></code>
        /// </p>
        /// <p>The following is an example job ARN:</p>
        /// <p>
        /// <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code>
        /// </p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The name that you assigned to the document classification job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name that you assigned to the document classification job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The current status of the document classification job. If the status is
        /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the document classification job. If the status is
        /// <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>A description of the status of the job.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the status of the job.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time that the document classification job was submitted for processing.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time that the document classification job was submitted for processing.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time that the document classification job completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the document classification job completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
        pub fn document_classifier_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_classifier_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_classifier_arn = input;
            self
        }
        /// <p>The input data configuration that you supplied when you created the document
        /// classification job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data configuration that you supplied when you created the document
        /// classification job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data configuration that you supplied when you created the document
        /// classification job.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration that you supplied when you created the document
        /// classification job.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your document classification job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the
        /// resources you are using for your document classification job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentClassificationJobProperties`](crate::model::DocumentClassificationJobProperties)
        pub fn build(self) -> crate::model::DocumentClassificationJobProperties {
            crate::model::DocumentClassificationJobProperties {
                job_id: self.job_id,
                job_arn: self.job_arn,
                job_name: self.job_name,
                job_status: self.job_status,
                message: self.message,
                submit_time: self.submit_time,
                end_time: self.end_time,
                document_classifier_arn: self.document_classifier_arn,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
            }
        }
    }
}
impl DocumentClassificationJobProperties {
    /// Creates a new builder-style object to manufacture [`DocumentClassificationJobProperties`](crate::model::DocumentClassificationJobProperties)
    pub fn builder() -> crate::model::document_classification_job_properties::Builder {
        crate::model::document_classification_job_properties::Builder::default()
    }
}

/// <p>Provides information for filtering a list of document classification jobs. For more
/// information, see the  operation. You can
/// provide only one filter parameter in each request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentClassificationJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>Filters the list based on job status. Returns only jobs with the specified status.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub submit_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub submit_time_after: std::option::Option<aws_smithy_types::Instant>,
}
impl DocumentClassificationJobFilter {
    /// <p>Filters on the name of the job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>Filters the list based on job status. Returns only jobs with the specified status.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
    /// oldest to newest.</p>
    pub fn submit_time_before(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_before.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
    /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
    /// newest to oldest.</p>
    pub fn submit_time_after(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submit_time_after.as_ref()
    }
}
impl std::fmt::Debug for DocumentClassificationJobFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentClassificationJobFilter");
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submit_time_before", &self.submit_time_before);
        formatter.field("submit_time_after", &self.submit_time_after);
        formatter.finish()
    }
}
/// See [`DocumentClassificationJobFilter`](crate::model::DocumentClassificationJobFilter)
pub mod document_classification_job_filter {
    /// A builder for [`DocumentClassificationJobFilter`](crate::model::DocumentClassificationJobFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submit_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) submit_time_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Filters on the name of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>Filters on the name of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>Filters the list based on job status. Returns only jobs with the specified status.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>Filters the list based on job status. Returns only jobs with the specified status.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn submit_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_before = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted before the specified time. Jobs are returned in ascending order,
        /// oldest to newest.</p>
        pub fn set_submit_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_before = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn submit_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time_after = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing.
        /// Returns only jobs submitted after the specified time. Jobs are returned in descending order,
        /// newest to oldest.</p>
        pub fn set_submit_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time_after = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentClassificationJobFilter`](crate::model::DocumentClassificationJobFilter)
        pub fn build(self) -> crate::model::DocumentClassificationJobFilter {
            crate::model::DocumentClassificationJobFilter {
                job_name: self.job_name,
                job_status: self.job_status,
                submit_time_before: self.submit_time_before,
                submit_time_after: self.submit_time_after,
            }
        }
    }
}
impl DocumentClassificationJobFilter {
    /// Creates a new builder-style object to manufacture [`DocumentClassificationJobFilter`](crate::model::DocumentClassificationJobFilter)
    pub fn builder() -> crate::model::document_classification_job_filter::Builder {
        crate::model::document_classification_job_filter::Builder::default()
    }
}

/// <p>Represents a work in the input text that was recognized and assigned a part of speech.
/// There is one syntax token record for each word in the source text.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SyntaxToken {
    /// <p>A unique identifier for a token.</p>
    pub token_id: std::option::Option<i32>,
    /// <p>The word that was recognized in the source text.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The zero-based offset from the beginning of the source text to the first character in the
    /// word.</p>
    pub begin_offset: std::option::Option<i32>,
    /// <p>The zero-based offset from the beginning of the source text to the last character in the
    /// word.</p>
    pub end_offset: std::option::Option<i32>,
    /// <p>Provides the part of speech label and the confidence level that Amazon Comprehend has that
    /// the part of speech was correctly identified. For more information, see <a>how-syntax</a>.</p>
    pub part_of_speech: std::option::Option<crate::model::PartOfSpeechTag>,
}
impl SyntaxToken {
    /// <p>A unique identifier for a token.</p>
    pub fn token_id(&self) -> std::option::Option<i32> {
        self.token_id
    }
    /// <p>The word that was recognized in the source text.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The zero-based offset from the beginning of the source text to the first character in the
    /// word.</p>
    pub fn begin_offset(&self) -> std::option::Option<i32> {
        self.begin_offset
    }
    /// <p>The zero-based offset from the beginning of the source text to the last character in the
    /// word.</p>
    pub fn end_offset(&self) -> std::option::Option<i32> {
        self.end_offset
    }
    /// <p>Provides the part of speech label and the confidence level that Amazon Comprehend has that
    /// the part of speech was correctly identified. For more information, see <a>how-syntax</a>.</p>
    pub fn part_of_speech(&self) -> std::option::Option<&crate::model::PartOfSpeechTag> {
        self.part_of_speech.as_ref()
    }
}
impl std::fmt::Debug for SyntaxToken {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SyntaxToken");
        formatter.field("token_id", &self.token_id);
        formatter.field("text", &self.text);
        formatter.field("begin_offset", &self.begin_offset);
        formatter.field("end_offset", &self.end_offset);
        formatter.field("part_of_speech", &self.part_of_speech);
        formatter.finish()
    }
}
/// See [`SyntaxToken`](crate::model::SyntaxToken)
pub mod syntax_token {
    /// A builder for [`SyntaxToken`](crate::model::SyntaxToken)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token_id: std::option::Option<i32>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) begin_offset: std::option::Option<i32>,
        pub(crate) end_offset: std::option::Option<i32>,
        pub(crate) part_of_speech: std::option::Option<crate::model::PartOfSpeechTag>,
    }
    impl Builder {
        /// <p>A unique identifier for a token.</p>
        pub fn token_id(mut self, input: i32) -> Self {
            self.token_id = Some(input);
            self
        }
        /// <p>A unique identifier for a token.</p>
        pub fn set_token_id(mut self, input: std::option::Option<i32>) -> Self {
            self.token_id = input;
            self
        }
        /// <p>The word that was recognized in the source text.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The word that was recognized in the source text.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The zero-based offset from the beginning of the source text to the first character in the
        /// word.</p>
        pub fn begin_offset(mut self, input: i32) -> Self {
            self.begin_offset = Some(input);
            self
        }
        /// <p>The zero-based offset from the beginning of the source text to the first character in the
        /// word.</p>
        pub fn set_begin_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.begin_offset = input;
            self
        }
        /// <p>The zero-based offset from the beginning of the source text to the last character in the
        /// word.</p>
        pub fn end_offset(mut self, input: i32) -> Self {
            self.end_offset = Some(input);
            self
        }
        /// <p>The zero-based offset from the beginning of the source text to the last character in the
        /// word.</p>
        pub fn set_end_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.end_offset = input;
            self
        }
        /// <p>Provides the part of speech label and the confidence level that Amazon Comprehend has that
        /// the part of speech was correctly identified. For more information, see <a>how-syntax</a>.</p>
        pub fn part_of_speech(mut self, input: crate::model::PartOfSpeechTag) -> Self {
            self.part_of_speech = Some(input);
            self
        }
        /// <p>Provides the part of speech label and the confidence level that Amazon Comprehend has that
        /// the part of speech was correctly identified. For more information, see <a>how-syntax</a>.</p>
        pub fn set_part_of_speech(
            mut self,
            input: std::option::Option<crate::model::PartOfSpeechTag>,
        ) -> Self {
            self.part_of_speech = input;
            self
        }
        /// Consumes the builder and constructs a [`SyntaxToken`](crate::model::SyntaxToken)
        pub fn build(self) -> crate::model::SyntaxToken {
            crate::model::SyntaxToken {
                token_id: self.token_id,
                text: self.text,
                begin_offset: self.begin_offset,
                end_offset: self.end_offset,
                part_of_speech: self.part_of_speech,
            }
        }
    }
}
impl SyntaxToken {
    /// Creates a new builder-style object to manufacture [`SyntaxToken`](crate::model::SyntaxToken)
    pub fn builder() -> crate::model::syntax_token::Builder {
        crate::model::syntax_token::Builder::default()
    }
}

/// <p>Identifies the part of speech represented by the token and gives the confidence that
/// Amazon Comprehend has that the part of speech was correctly identified. For more information
/// about the parts of speech that Amazon Comprehend can identify, see <a>how-syntax</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartOfSpeechTag {
    /// <p>Identifies the part of speech that the token represents.</p>
    pub tag: std::option::Option<crate::model::PartOfSpeechTagType>,
    /// <p>The confidence that Amazon Comprehend has that the part of speech was correctly
    /// identified.</p>
    pub score: std::option::Option<f32>,
}
impl PartOfSpeechTag {
    /// <p>Identifies the part of speech that the token represents.</p>
    pub fn tag(&self) -> std::option::Option<&crate::model::PartOfSpeechTagType> {
        self.tag.as_ref()
    }
    /// <p>The confidence that Amazon Comprehend has that the part of speech was correctly
    /// identified.</p>
    pub fn score(&self) -> std::option::Option<f32> {
        self.score
    }
}
impl std::fmt::Debug for PartOfSpeechTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartOfSpeechTag");
        formatter.field("tag", &self.tag);
        formatter.field("score", &self.score);
        formatter.finish()
    }
}
/// See [`PartOfSpeechTag`](crate::model::PartOfSpeechTag)
pub mod part_of_speech_tag {
    /// A builder for [`PartOfSpeechTag`](crate::model::PartOfSpeechTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag: std::option::Option<crate::model::PartOfSpeechTagType>,
        pub(crate) score: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Identifies the part of speech that the token represents.</p>
        pub fn tag(mut self, input: crate::model::PartOfSpeechTagType) -> Self {
            self.tag = Some(input);
            self
        }
        /// <p>Identifies the part of speech that the token represents.</p>
        pub fn set_tag(
            mut self,
            input: std::option::Option<crate::model::PartOfSpeechTagType>,
        ) -> Self {
            self.tag = input;
            self
        }
        /// <p>The confidence that Amazon Comprehend has that the part of speech was correctly
        /// identified.</p>
        pub fn score(mut self, input: f32) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The confidence that Amazon Comprehend has that the part of speech was correctly
        /// identified.</p>
        pub fn set_score(mut self, input: std::option::Option<f32>) -> Self {
            self.score = input;
            self
        }
        /// Consumes the builder and constructs a [`PartOfSpeechTag`](crate::model::PartOfSpeechTag)
        pub fn build(self) -> crate::model::PartOfSpeechTag {
            crate::model::PartOfSpeechTag {
                tag: self.tag,
                score: self.score,
            }
        }
    }
}
impl PartOfSpeechTag {
    /// Creates a new builder-style object to manufacture [`PartOfSpeechTag`](crate::model::PartOfSpeechTag)
    pub fn builder() -> crate::model::part_of_speech_tag::Builder {
        crate::model::part_of_speech_tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PartOfSpeechTagType {
    #[allow(missing_docs)] // documentation missing in model
    Adj,
    #[allow(missing_docs)] // documentation missing in model
    Adp,
    #[allow(missing_docs)] // documentation missing in model
    Adv,
    #[allow(missing_docs)] // documentation missing in model
    Aux,
    #[allow(missing_docs)] // documentation missing in model
    Cconj,
    #[allow(missing_docs)] // documentation missing in model
    Conj,
    #[allow(missing_docs)] // documentation missing in model
    Det,
    #[allow(missing_docs)] // documentation missing in model
    Intj,
    #[allow(missing_docs)] // documentation missing in model
    Noun,
    #[allow(missing_docs)] // documentation missing in model
    Num,
    #[allow(missing_docs)] // documentation missing in model
    O,
    #[allow(missing_docs)] // documentation missing in model
    Part,
    #[allow(missing_docs)] // documentation missing in model
    Pron,
    #[allow(missing_docs)] // documentation missing in model
    Propn,
    #[allow(missing_docs)] // documentation missing in model
    Punct,
    #[allow(missing_docs)] // documentation missing in model
    Sconj,
    #[allow(missing_docs)] // documentation missing in model
    Sym,
    #[allow(missing_docs)] // documentation missing in model
    Verb,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PartOfSpeechTagType {
    fn from(s: &str) -> Self {
        match s {
            "ADJ" => PartOfSpeechTagType::Adj,
            "ADP" => PartOfSpeechTagType::Adp,
            "ADV" => PartOfSpeechTagType::Adv,
            "AUX" => PartOfSpeechTagType::Aux,
            "CCONJ" => PartOfSpeechTagType::Cconj,
            "CONJ" => PartOfSpeechTagType::Conj,
            "DET" => PartOfSpeechTagType::Det,
            "INTJ" => PartOfSpeechTagType::Intj,
            "NOUN" => PartOfSpeechTagType::Noun,
            "NUM" => PartOfSpeechTagType::Num,
            "O" => PartOfSpeechTagType::O,
            "PART" => PartOfSpeechTagType::Part,
            "PRON" => PartOfSpeechTagType::Pron,
            "PROPN" => PartOfSpeechTagType::Propn,
            "PUNCT" => PartOfSpeechTagType::Punct,
            "SCONJ" => PartOfSpeechTagType::Sconj,
            "SYM" => PartOfSpeechTagType::Sym,
            "VERB" => PartOfSpeechTagType::Verb,
            other => PartOfSpeechTagType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PartOfSpeechTagType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PartOfSpeechTagType::from(s))
    }
}
impl PartOfSpeechTagType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PartOfSpeechTagType::Adj => "ADJ",
            PartOfSpeechTagType::Adp => "ADP",
            PartOfSpeechTagType::Adv => "ADV",
            PartOfSpeechTagType::Aux => "AUX",
            PartOfSpeechTagType::Cconj => "CCONJ",
            PartOfSpeechTagType::Conj => "CONJ",
            PartOfSpeechTagType::Det => "DET",
            PartOfSpeechTagType::Intj => "INTJ",
            PartOfSpeechTagType::Noun => "NOUN",
            PartOfSpeechTagType::Num => "NUM",
            PartOfSpeechTagType::O => "O",
            PartOfSpeechTagType::Part => "PART",
            PartOfSpeechTagType::Pron => "PRON",
            PartOfSpeechTagType::Propn => "PROPN",
            PartOfSpeechTagType::Punct => "PUNCT",
            PartOfSpeechTagType::Sconj => "SCONJ",
            PartOfSpeechTagType::Sym => "SYM",
            PartOfSpeechTagType::Verb => "VERB",
            PartOfSpeechTagType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADJ", "ADP", "ADV", "AUX", "CCONJ", "CONJ", "DET", "INTJ", "NOUN", "NUM", "O", "PART",
            "PRON", "PROPN", "PUNCT", "SCONJ", "SYM", "VERB",
        ]
    }
}
impl AsRef<str> for PartOfSpeechTagType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SyntaxLanguageCode {
    #[allow(missing_docs)] // documentation missing in model
    De,
    #[allow(missing_docs)] // documentation missing in model
    En,
    #[allow(missing_docs)] // documentation missing in model
    Es,
    #[allow(missing_docs)] // documentation missing in model
    Fr,
    #[allow(missing_docs)] // documentation missing in model
    It,
    #[allow(missing_docs)] // documentation missing in model
    Pt,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SyntaxLanguageCode {
    fn from(s: &str) -> Self {
        match s {
            "de" => SyntaxLanguageCode::De,
            "en" => SyntaxLanguageCode::En,
            "es" => SyntaxLanguageCode::Es,
            "fr" => SyntaxLanguageCode::Fr,
            "it" => SyntaxLanguageCode::It,
            "pt" => SyntaxLanguageCode::Pt,
            other => SyntaxLanguageCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SyntaxLanguageCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SyntaxLanguageCode::from(s))
    }
}
impl SyntaxLanguageCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SyntaxLanguageCode::De => "de",
            SyntaxLanguageCode::En => "en",
            SyntaxLanguageCode::Es => "es",
            SyntaxLanguageCode::Fr => "fr",
            SyntaxLanguageCode::It => "it",
            SyntaxLanguageCode::Pt => "pt",
            SyntaxLanguageCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["de", "en", "es", "fr", "it", "pt"]
    }
}
impl AsRef<str> for SyntaxLanguageCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the level of confidence that Amazon Comprehend has in the accuracy of its
/// detection of sentiments.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SentimentScore {
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
    /// the <code>POSITIVE</code> sentiment.</p>
    pub positive: std::option::Option<f32>,
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
    /// the <code>NEGATIVE</code> sentiment.</p>
    pub negative: std::option::Option<f32>,
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
    /// the <code>NEUTRAL</code> sentiment.</p>
    pub neutral: std::option::Option<f32>,
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
    /// the <code>MIXED</code> sentiment.</p>
    pub mixed: std::option::Option<f32>,
}
impl SentimentScore {
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
    /// the <code>POSITIVE</code> sentiment.</p>
    pub fn positive(&self) -> std::option::Option<f32> {
        self.positive
    }
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
    /// the <code>NEGATIVE</code> sentiment.</p>
    pub fn negative(&self) -> std::option::Option<f32> {
        self.negative
    }
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
    /// the <code>NEUTRAL</code> sentiment.</p>
    pub fn neutral(&self) -> std::option::Option<f32> {
        self.neutral
    }
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
    /// the <code>MIXED</code> sentiment.</p>
    pub fn mixed(&self) -> std::option::Option<f32> {
        self.mixed
    }
}
impl std::fmt::Debug for SentimentScore {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SentimentScore");
        formatter.field("positive", &self.positive);
        formatter.field("negative", &self.negative);
        formatter.field("neutral", &self.neutral);
        formatter.field("mixed", &self.mixed);
        formatter.finish()
    }
}
/// See [`SentimentScore`](crate::model::SentimentScore)
pub mod sentiment_score {
    /// A builder for [`SentimentScore`](crate::model::SentimentScore)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) positive: std::option::Option<f32>,
        pub(crate) negative: std::option::Option<f32>,
        pub(crate) neutral: std::option::Option<f32>,
        pub(crate) mixed: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
        /// the <code>POSITIVE</code> sentiment.</p>
        pub fn positive(mut self, input: f32) -> Self {
            self.positive = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
        /// the <code>POSITIVE</code> sentiment.</p>
        pub fn set_positive(mut self, input: std::option::Option<f32>) -> Self {
            self.positive = input;
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
        /// the <code>NEGATIVE</code> sentiment.</p>
        pub fn negative(mut self, input: f32) -> Self {
            self.negative = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
        /// the <code>NEGATIVE</code> sentiment.</p>
        pub fn set_negative(mut self, input: std::option::Option<f32>) -> Self {
            self.negative = input;
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
        /// the <code>NEUTRAL</code> sentiment.</p>
        pub fn neutral(mut self, input: f32) -> Self {
            self.neutral = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
        /// the <code>NEUTRAL</code> sentiment.</p>
        pub fn set_neutral(mut self, input: std::option::Option<f32>) -> Self {
            self.neutral = input;
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
        /// the <code>MIXED</code> sentiment.</p>
        pub fn mixed(mut self, input: f32) -> Self {
            self.mixed = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of
        /// the <code>MIXED</code> sentiment.</p>
        pub fn set_mixed(mut self, input: std::option::Option<f32>) -> Self {
            self.mixed = input;
            self
        }
        /// Consumes the builder and constructs a [`SentimentScore`](crate::model::SentimentScore)
        pub fn build(self) -> crate::model::SentimentScore {
            crate::model::SentimentScore {
                positive: self.positive,
                negative: self.negative,
                neutral: self.neutral,
                mixed: self.mixed,
            }
        }
    }
}
impl SentimentScore {
    /// Creates a new builder-style object to manufacture [`SentimentScore`](crate::model::SentimentScore)
    pub fn builder() -> crate::model::sentiment_score::Builder {
        crate::model::sentiment_score::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SentimentType {
    #[allow(missing_docs)] // documentation missing in model
    Mixed,
    #[allow(missing_docs)] // documentation missing in model
    Negative,
    #[allow(missing_docs)] // documentation missing in model
    Neutral,
    #[allow(missing_docs)] // documentation missing in model
    Positive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SentimentType {
    fn from(s: &str) -> Self {
        match s {
            "MIXED" => SentimentType::Mixed,
            "NEGATIVE" => SentimentType::Negative,
            "NEUTRAL" => SentimentType::Neutral,
            "POSITIVE" => SentimentType::Positive,
            other => SentimentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SentimentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SentimentType::from(s))
    }
}
impl SentimentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SentimentType::Mixed => "MIXED",
            SentimentType::Negative => "NEGATIVE",
            SentimentType::Neutral => "NEUTRAL",
            SentimentType::Positive => "POSITIVE",
            SentimentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MIXED", "NEGATIVE", "NEUTRAL", "POSITIVE"]
    }
}
impl AsRef<str> for SentimentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about a PII entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PiiEntity {
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
    /// detection.</p>
    pub score: std::option::Option<f32>,
    /// <p>The entity's type.</p>
    pub r#type: std::option::Option<crate::model::PiiEntityType>,
    /// <p>A character offset in the input text that shows where the PII entity begins (the first
    /// character is at position 0). The offset returns the position of each UTF-8 code point in the
    /// string. A <i>code point</i> is the abstract character from a particular
    /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
    /// point.</p>
    pub begin_offset: std::option::Option<i32>,
    /// <p>A character offset in the input text that shows where the PII entity ends. The offset
    /// returns the position of each UTF-8 code point in the string. A <i>code point</i>
    /// is the abstract character from a particular graphical representation. For example, a
    /// multi-byte UTF-8 character maps to a single code point.</p>
    pub end_offset: std::option::Option<i32>,
}
impl PiiEntity {
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
    /// detection.</p>
    pub fn score(&self) -> std::option::Option<f32> {
        self.score
    }
    /// <p>The entity's type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PiiEntityType> {
        self.r#type.as_ref()
    }
    /// <p>A character offset in the input text that shows where the PII entity begins (the first
    /// character is at position 0). The offset returns the position of each UTF-8 code point in the
    /// string. A <i>code point</i> is the abstract character from a particular
    /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
    /// point.</p>
    pub fn begin_offset(&self) -> std::option::Option<i32> {
        self.begin_offset
    }
    /// <p>A character offset in the input text that shows where the PII entity ends. The offset
    /// returns the position of each UTF-8 code point in the string. A <i>code point</i>
    /// is the abstract character from a particular graphical representation. For example, a
    /// multi-byte UTF-8 character maps to a single code point.</p>
    pub fn end_offset(&self) -> std::option::Option<i32> {
        self.end_offset
    }
}
impl std::fmt::Debug for PiiEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PiiEntity");
        formatter.field("score", &self.score);
        formatter.field("r#type", &self.r#type);
        formatter.field("begin_offset", &self.begin_offset);
        formatter.field("end_offset", &self.end_offset);
        formatter.finish()
    }
}
/// See [`PiiEntity`](crate::model::PiiEntity)
pub mod pii_entity {
    /// A builder for [`PiiEntity`](crate::model::PiiEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) score: std::option::Option<f32>,
        pub(crate) r#type: std::option::Option<crate::model::PiiEntityType>,
        pub(crate) begin_offset: std::option::Option<i32>,
        pub(crate) end_offset: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
        /// detection.</p>
        pub fn score(mut self, input: f32) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
        /// detection.</p>
        pub fn set_score(mut self, input: std::option::Option<f32>) -> Self {
            self.score = input;
            self
        }
        /// <p>The entity's type.</p>
        pub fn r#type(mut self, input: crate::model::PiiEntityType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The entity's type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PiiEntityType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A character offset in the input text that shows where the PII entity begins (the first
        /// character is at position 0). The offset returns the position of each UTF-8 code point in the
        /// string. A <i>code point</i> is the abstract character from a particular
        /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
        /// point.</p>
        pub fn begin_offset(mut self, input: i32) -> Self {
            self.begin_offset = Some(input);
            self
        }
        /// <p>A character offset in the input text that shows where the PII entity begins (the first
        /// character is at position 0). The offset returns the position of each UTF-8 code point in the
        /// string. A <i>code point</i> is the abstract character from a particular
        /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
        /// point.</p>
        pub fn set_begin_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.begin_offset = input;
            self
        }
        /// <p>A character offset in the input text that shows where the PII entity ends. The offset
        /// returns the position of each UTF-8 code point in the string. A <i>code point</i>
        /// is the abstract character from a particular graphical representation. For example, a
        /// multi-byte UTF-8 character maps to a single code point.</p>
        pub fn end_offset(mut self, input: i32) -> Self {
            self.end_offset = Some(input);
            self
        }
        /// <p>A character offset in the input text that shows where the PII entity ends. The offset
        /// returns the position of each UTF-8 code point in the string. A <i>code point</i>
        /// is the abstract character from a particular graphical representation. For example, a
        /// multi-byte UTF-8 character maps to a single code point.</p>
        pub fn set_end_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.end_offset = input;
            self
        }
        /// Consumes the builder and constructs a [`PiiEntity`](crate::model::PiiEntity)
        pub fn build(self) -> crate::model::PiiEntity {
            crate::model::PiiEntity {
                score: self.score,
                r#type: self.r#type,
                begin_offset: self.begin_offset,
                end_offset: self.end_offset,
            }
        }
    }
}
impl PiiEntity {
    /// Creates a new builder-style object to manufacture [`PiiEntity`](crate::model::PiiEntity)
    pub fn builder() -> crate::model::pii_entity::Builder {
        crate::model::pii_entity::Builder::default()
    }
}

/// <p>Describes a key noun phrase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyPhrase {
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
    /// detection.</p>
    pub score: std::option::Option<f32>,
    /// <p>The text of a key noun phrase.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>A character offset in the input text that shows where the key phrase begins (the first
    /// character is at position 0). The offset returns the position of each UTF-8 code point in the
    /// string. A <i>code point</i> is the abstract character from a particular
    /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
    /// point.</p>
    pub begin_offset: std::option::Option<i32>,
    /// <p>A character offset in the input text where the key phrase ends. The offset returns the
    /// position of each UTF-8 code point in the string. A <code>code point</code> is the abstract
    /// character from a particular graphical representation. For example, a multi-byte UTF-8
    /// character maps to a single code point.</p>
    pub end_offset: std::option::Option<i32>,
}
impl KeyPhrase {
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
    /// detection.</p>
    pub fn score(&self) -> std::option::Option<f32> {
        self.score
    }
    /// <p>The text of a key noun phrase.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>A character offset in the input text that shows where the key phrase begins (the first
    /// character is at position 0). The offset returns the position of each UTF-8 code point in the
    /// string. A <i>code point</i> is the abstract character from a particular
    /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
    /// point.</p>
    pub fn begin_offset(&self) -> std::option::Option<i32> {
        self.begin_offset
    }
    /// <p>A character offset in the input text where the key phrase ends. The offset returns the
    /// position of each UTF-8 code point in the string. A <code>code point</code> is the abstract
    /// character from a particular graphical representation. For example, a multi-byte UTF-8
    /// character maps to a single code point.</p>
    pub fn end_offset(&self) -> std::option::Option<i32> {
        self.end_offset
    }
}
impl std::fmt::Debug for KeyPhrase {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyPhrase");
        formatter.field("score", &self.score);
        formatter.field("text", &self.text);
        formatter.field("begin_offset", &self.begin_offset);
        formatter.field("end_offset", &self.end_offset);
        formatter.finish()
    }
}
/// See [`KeyPhrase`](crate::model::KeyPhrase)
pub mod key_phrase {
    /// A builder for [`KeyPhrase`](crate::model::KeyPhrase)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) score: std::option::Option<f32>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) begin_offset: std::option::Option<i32>,
        pub(crate) end_offset: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
        /// detection.</p>
        pub fn score(mut self, input: f32) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
        /// detection.</p>
        pub fn set_score(mut self, input: std::option::Option<f32>) -> Self {
            self.score = input;
            self
        }
        /// <p>The text of a key noun phrase.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text of a key noun phrase.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>A character offset in the input text that shows where the key phrase begins (the first
        /// character is at position 0). The offset returns the position of each UTF-8 code point in the
        /// string. A <i>code point</i> is the abstract character from a particular
        /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
        /// point.</p>
        pub fn begin_offset(mut self, input: i32) -> Self {
            self.begin_offset = Some(input);
            self
        }
        /// <p>A character offset in the input text that shows where the key phrase begins (the first
        /// character is at position 0). The offset returns the position of each UTF-8 code point in the
        /// string. A <i>code point</i> is the abstract character from a particular
        /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
        /// point.</p>
        pub fn set_begin_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.begin_offset = input;
            self
        }
        /// <p>A character offset in the input text where the key phrase ends. The offset returns the
        /// position of each UTF-8 code point in the string. A <code>code point</code> is the abstract
        /// character from a particular graphical representation. For example, a multi-byte UTF-8
        /// character maps to a single code point.</p>
        pub fn end_offset(mut self, input: i32) -> Self {
            self.end_offset = Some(input);
            self
        }
        /// <p>A character offset in the input text where the key phrase ends. The offset returns the
        /// position of each UTF-8 code point in the string. A <code>code point</code> is the abstract
        /// character from a particular graphical representation. For example, a multi-byte UTF-8
        /// character maps to a single code point.</p>
        pub fn set_end_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.end_offset = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyPhrase`](crate::model::KeyPhrase)
        pub fn build(self) -> crate::model::KeyPhrase {
            crate::model::KeyPhrase {
                score: self.score,
                text: self.text,
                begin_offset: self.begin_offset,
                end_offset: self.end_offset,
            }
        }
    }
}
impl KeyPhrase {
    /// Creates a new builder-style object to manufacture [`KeyPhrase`](crate::model::KeyPhrase)
    pub fn builder() -> crate::model::key_phrase::Builder {
        crate::model::key_phrase::Builder::default()
    }
}

/// <p>Provides information about an entity. </p>
/// <p> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Entity {
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
    /// detection.</p>
    pub score: std::option::Option<f32>,
    /// <p>The entity's type.</p>
    pub r#type: std::option::Option<crate::model::EntityType>,
    /// <p>The text of the entity.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>A character offset in the input text that shows where the entity begins (the first
    /// character is at position 0). The offset returns the position of each UTF-8 code point in the
    /// string. A <i>code point</i> is the abstract character from a particular
    /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
    /// point.</p>
    pub begin_offset: std::option::Option<i32>,
    /// <p>A character offset in the input text that shows where the entity ends. The offset
    /// returns the position of each UTF-8 code point in the string. A <i>code point</i>
    /// is the abstract character from a particular graphical representation. For example, a
    /// multi-byte UTF-8 character maps to a single code point. </p>
    pub end_offset: std::option::Option<i32>,
}
impl Entity {
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
    /// detection.</p>
    pub fn score(&self) -> std::option::Option<f32> {
        self.score
    }
    /// <p>The entity's type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EntityType> {
        self.r#type.as_ref()
    }
    /// <p>The text of the entity.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>A character offset in the input text that shows where the entity begins (the first
    /// character is at position 0). The offset returns the position of each UTF-8 code point in the
    /// string. A <i>code point</i> is the abstract character from a particular
    /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
    /// point.</p>
    pub fn begin_offset(&self) -> std::option::Option<i32> {
        self.begin_offset
    }
    /// <p>A character offset in the input text that shows where the entity ends. The offset
    /// returns the position of each UTF-8 code point in the string. A <i>code point</i>
    /// is the abstract character from a particular graphical representation. For example, a
    /// multi-byte UTF-8 character maps to a single code point. </p>
    pub fn end_offset(&self) -> std::option::Option<i32> {
        self.end_offset
    }
}
impl std::fmt::Debug for Entity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Entity");
        formatter.field("score", &self.score);
        formatter.field("r#type", &self.r#type);
        formatter.field("text", &self.text);
        formatter.field("begin_offset", &self.begin_offset);
        formatter.field("end_offset", &self.end_offset);
        formatter.finish()
    }
}
/// See [`Entity`](crate::model::Entity)
pub mod entity {
    /// A builder for [`Entity`](crate::model::Entity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) score: std::option::Option<f32>,
        pub(crate) r#type: std::option::Option<crate::model::EntityType>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) begin_offset: std::option::Option<i32>,
        pub(crate) end_offset: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
        /// detection.</p>
        pub fn score(mut self, input: f32) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
        /// detection.</p>
        pub fn set_score(mut self, input: std::option::Option<f32>) -> Self {
            self.score = input;
            self
        }
        /// <p>The entity's type.</p>
        pub fn r#type(mut self, input: crate::model::EntityType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The entity's type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::EntityType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The text of the entity.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text of the entity.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>A character offset in the input text that shows where the entity begins (the first
        /// character is at position 0). The offset returns the position of each UTF-8 code point in the
        /// string. A <i>code point</i> is the abstract character from a particular
        /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
        /// point.</p>
        pub fn begin_offset(mut self, input: i32) -> Self {
            self.begin_offset = Some(input);
            self
        }
        /// <p>A character offset in the input text that shows where the entity begins (the first
        /// character is at position 0). The offset returns the position of each UTF-8 code point in the
        /// string. A <i>code point</i> is the abstract character from a particular
        /// graphical representation. For example, a multi-byte UTF-8 character maps to a single code
        /// point.</p>
        pub fn set_begin_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.begin_offset = input;
            self
        }
        /// <p>A character offset in the input text that shows where the entity ends. The offset
        /// returns the position of each UTF-8 code point in the string. A <i>code point</i>
        /// is the abstract character from a particular graphical representation. For example, a
        /// multi-byte UTF-8 character maps to a single code point. </p>
        pub fn end_offset(mut self, input: i32) -> Self {
            self.end_offset = Some(input);
            self
        }
        /// <p>A character offset in the input text that shows where the entity ends. The offset
        /// returns the position of each UTF-8 code point in the string. A <i>code point</i>
        /// is the abstract character from a particular graphical representation. For example, a
        /// multi-byte UTF-8 character maps to a single code point. </p>
        pub fn set_end_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.end_offset = input;
            self
        }
        /// Consumes the builder and constructs a [`Entity`](crate::model::Entity)
        pub fn build(self) -> crate::model::Entity {
            crate::model::Entity {
                score: self.score,
                r#type: self.r#type,
                text: self.text,
                begin_offset: self.begin_offset,
                end_offset: self.end_offset,
            }
        }
    }
}
impl Entity {
    /// Creates a new builder-style object to manufacture [`Entity`](crate::model::Entity)
    pub fn builder() -> crate::model::entity::Builder {
        crate::model::entity::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EntityType {
    #[allow(missing_docs)] // documentation missing in model
    CommercialItem,
    #[allow(missing_docs)] // documentation missing in model
    Date,
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    Location,
    #[allow(missing_docs)] // documentation missing in model
    Organization,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    Person,
    #[allow(missing_docs)] // documentation missing in model
    Quantity,
    #[allow(missing_docs)] // documentation missing in model
    Title,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EntityType {
    fn from(s: &str) -> Self {
        match s {
            "COMMERCIAL_ITEM" => EntityType::CommercialItem,
            "DATE" => EntityType::Date,
            "EVENT" => EntityType::Event,
            "LOCATION" => EntityType::Location,
            "ORGANIZATION" => EntityType::Organization,
            "OTHER" => EntityType::Other,
            "PERSON" => EntityType::Person,
            "QUANTITY" => EntityType::Quantity,
            "TITLE" => EntityType::Title,
            other => EntityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EntityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EntityType::from(s))
    }
}
impl EntityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EntityType::CommercialItem => "COMMERCIAL_ITEM",
            EntityType::Date => "DATE",
            EntityType::Event => "EVENT",
            EntityType::Location => "LOCATION",
            EntityType::Organization => "ORGANIZATION",
            EntityType::Other => "OTHER",
            EntityType::Person => "PERSON",
            EntityType::Quantity => "QUANTITY",
            EntityType::Title => "TITLE",
            EntityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMMERCIAL_ITEM",
            "DATE",
            "EVENT",
            "LOCATION",
            "ORGANIZATION",
            "OTHER",
            "PERSON",
            "QUANTITY",
            "TITLE",
        ]
    }
}
impl AsRef<str> for EntityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns the code for the dominant language in the input text and the level of
/// confidence that Amazon Comprehend has in the accuracy of the detection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DominantLanguage {
    /// <p>The RFC 5646 language code for the dominant language. For more information about RFC
    /// 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags for Identifying
    /// Languages</a> on the <i>IETF Tools</i> web site.</p>
    pub language_code: std::option::Option<std::string::String>,
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
    /// detection.</p>
    pub score: std::option::Option<f32>,
}
impl DominantLanguage {
    /// <p>The RFC 5646 language code for the dominant language. For more information about RFC
    /// 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags for Identifying
    /// Languages</a> on the <i>IETF Tools</i> web site.</p>
    pub fn language_code(&self) -> std::option::Option<&str> {
        self.language_code.as_deref()
    }
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
    /// detection.</p>
    pub fn score(&self) -> std::option::Option<f32> {
        self.score
    }
}
impl std::fmt::Debug for DominantLanguage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DominantLanguage");
        formatter.field("language_code", &self.language_code);
        formatter.field("score", &self.score);
        formatter.finish()
    }
}
/// See [`DominantLanguage`](crate::model::DominantLanguage)
pub mod dominant_language {
    /// A builder for [`DominantLanguage`](crate::model::DominantLanguage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language_code: std::option::Option<std::string::String>,
        pub(crate) score: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The RFC 5646 language code for the dominant language. For more information about RFC
        /// 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags for Identifying
        /// Languages</a> on the <i>IETF Tools</i> web site.</p>
        pub fn language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_code = Some(input.into());
            self
        }
        /// <p>The RFC 5646 language code for the dominant language. For more information about RFC
        /// 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags for Identifying
        /// Languages</a> on the <i>IETF Tools</i> web site.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
        /// detection.</p>
        pub fn score(mut self, input: f32) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
        /// detection.</p>
        pub fn set_score(mut self, input: std::option::Option<f32>) -> Self {
            self.score = input;
            self
        }
        /// Consumes the builder and constructs a [`DominantLanguage`](crate::model::DominantLanguage)
        pub fn build(self) -> crate::model::DominantLanguage {
            crate::model::DominantLanguage {
                language_code: self.language_code,
                score: self.score,
            }
        }
    }
}
impl DominantLanguage {
    /// Creates a new builder-style object to manufacture [`DominantLanguage`](crate::model::DominantLanguage)
    pub fn builder() -> crate::model::dominant_language::Builder {
        crate::model::dominant_language::Builder::default()
    }
}

/// <p>Specifies one of the label or labels that categorize the personally identifiable
/// information (PII) entity being analyzed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityLabel {
    /// <p>The name of the label.</p>
    pub name: std::option::Option<crate::model::PiiEntityType>,
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
    /// detection.</p>
    pub score: std::option::Option<f32>,
}
impl EntityLabel {
    /// <p>The name of the label.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::PiiEntityType> {
        self.name.as_ref()
    }
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
    /// detection.</p>
    pub fn score(&self) -> std::option::Option<f32> {
        self.score
    }
}
impl std::fmt::Debug for EntityLabel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityLabel");
        formatter.field("name", &self.name);
        formatter.field("score", &self.score);
        formatter.finish()
    }
}
/// See [`EntityLabel`](crate::model::EntityLabel)
pub mod entity_label {
    /// A builder for [`EntityLabel`](crate::model::EntityLabel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::PiiEntityType>,
        pub(crate) score: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The name of the label.</p>
        pub fn name(mut self, input: crate::model::PiiEntityType) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the label.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::PiiEntityType>) -> Self {
            self.name = input;
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
        /// detection.</p>
        pub fn score(mut self, input: f32) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of the
        /// detection.</p>
        pub fn set_score(mut self, input: std::option::Option<f32>) -> Self {
            self.score = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityLabel`](crate::model::EntityLabel)
        pub fn build(self) -> crate::model::EntityLabel {
            crate::model::EntityLabel {
                name: self.name,
                score: self.score,
            }
        }
    }
}
impl EntityLabel {
    /// Creates a new builder-style object to manufacture [`EntityLabel`](crate::model::EntityLabel)
    pub fn builder() -> crate::model::entity_label::Builder {
        crate::model::entity_label::Builder::default()
    }
}

/// <p>Specifies one of the label or labels that categorize the document being analyzed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentLabel {
    /// <p>The name of the label.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The confidence score that Amazon Comprehend has this label correctly attributed.</p>
    pub score: std::option::Option<f32>,
}
impl DocumentLabel {
    /// <p>The name of the label.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The confidence score that Amazon Comprehend has this label correctly attributed.</p>
    pub fn score(&self) -> std::option::Option<f32> {
        self.score
    }
}
impl std::fmt::Debug for DocumentLabel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentLabel");
        formatter.field("name", &self.name);
        formatter.field("score", &self.score);
        formatter.finish()
    }
}
/// See [`DocumentLabel`](crate::model::DocumentLabel)
pub mod document_label {
    /// A builder for [`DocumentLabel`](crate::model::DocumentLabel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) score: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The name of the label.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the label.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The confidence score that Amazon Comprehend has this label correctly attributed.</p>
        pub fn score(mut self, input: f32) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The confidence score that Amazon Comprehend has this label correctly attributed.</p>
        pub fn set_score(mut self, input: std::option::Option<f32>) -> Self {
            self.score = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentLabel`](crate::model::DocumentLabel)
        pub fn build(self) -> crate::model::DocumentLabel {
            crate::model::DocumentLabel {
                name: self.name,
                score: self.score,
            }
        }
    }
}
impl DocumentLabel {
    /// Creates a new builder-style object to manufacture [`DocumentLabel`](crate::model::DocumentLabel)
    pub fn builder() -> crate::model::document_label::Builder {
        crate::model::document_label::Builder::default()
    }
}

/// <p>Specifies the class that categorizes the document being analyzed</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentClass {
    /// <p>The name of the class.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The confidence score that Amazon Comprehend has this class correctly attributed.</p>
    pub score: std::option::Option<f32>,
}
impl DocumentClass {
    /// <p>The name of the class.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The confidence score that Amazon Comprehend has this class correctly attributed.</p>
    pub fn score(&self) -> std::option::Option<f32> {
        self.score
    }
}
impl std::fmt::Debug for DocumentClass {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentClass");
        formatter.field("name", &self.name);
        formatter.field("score", &self.score);
        formatter.finish()
    }
}
/// See [`DocumentClass`](crate::model::DocumentClass)
pub mod document_class {
    /// A builder for [`DocumentClass`](crate::model::DocumentClass)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) score: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The name of the class.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the class.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The confidence score that Amazon Comprehend has this class correctly attributed.</p>
        pub fn score(mut self, input: f32) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The confidence score that Amazon Comprehend has this class correctly attributed.</p>
        pub fn set_score(mut self, input: std::option::Option<f32>) -> Self {
            self.score = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentClass`](crate::model::DocumentClass)
        pub fn build(self) -> crate::model::DocumentClass {
            crate::model::DocumentClass {
                name: self.name,
                score: self.score,
            }
        }
    }
}
impl DocumentClass {
    /// Creates a new builder-style object to manufacture [`DocumentClass`](crate::model::DocumentClass)
    pub fn builder() -> crate::model::document_class::Builder {
        crate::model::document_class::Builder::default()
    }
}

/// <p>Describes an error that occurred while processing a document in a batch. The operation
/// returns on <code>BatchItemError</code> object for each document that contained an
/// error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchItemError {
    /// <p>The zero-based index of the document in the input list.</p>
    pub index: std::option::Option<i32>,
    /// <p>The numeric error code of the error.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>A text description of the error.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchItemError {
    /// <p>The zero-based index of the document in the input list.</p>
    pub fn index(&self) -> std::option::Option<i32> {
        self.index
    }
    /// <p>The numeric error code of the error.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>A text description of the error.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchItemError");
        formatter.field("index", &self.index);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchItemError`](crate::model::BatchItemError)
pub mod batch_item_error {
    /// A builder for [`BatchItemError`](crate::model::BatchItemError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index: std::option::Option<i32>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn index(mut self, input: i32) -> Self {
            self.index = Some(input);
            self
        }
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn set_index(mut self, input: std::option::Option<i32>) -> Self {
            self.index = input;
            self
        }
        /// <p>The numeric error code of the error.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The numeric error code of the error.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>A text description of the error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A text description of the error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchItemError`](crate::model::BatchItemError)
        pub fn build(self) -> crate::model::BatchItemError {
            crate::model::BatchItemError {
                index: self.index,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchItemError {
    /// Creates a new builder-style object to manufacture [`BatchItemError`](crate::model::BatchItemError)
    pub fn builder() -> crate::model::batch_item_error::Builder {
        crate::model::batch_item_error::Builder::default()
    }
}

/// <p>The result of calling the  operation. The operation
/// returns one object that is successfully processed by the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetectSyntaxItemResult {
    /// <p>The zero-based index of the document in the input list.</p>
    pub index: std::option::Option<i32>,
    /// <p>The syntax tokens for the words in the document, one token for each word.</p>
    pub syntax_tokens: std::option::Option<std::vec::Vec<crate::model::SyntaxToken>>,
}
impl BatchDetectSyntaxItemResult {
    /// <p>The zero-based index of the document in the input list.</p>
    pub fn index(&self) -> std::option::Option<i32> {
        self.index
    }
    /// <p>The syntax tokens for the words in the document, one token for each word.</p>
    pub fn syntax_tokens(&self) -> std::option::Option<&[crate::model::SyntaxToken]> {
        self.syntax_tokens.as_deref()
    }
}
impl std::fmt::Debug for BatchDetectSyntaxItemResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetectSyntaxItemResult");
        formatter.field("index", &self.index);
        formatter.field("syntax_tokens", &self.syntax_tokens);
        formatter.finish()
    }
}
/// See [`BatchDetectSyntaxItemResult`](crate::model::BatchDetectSyntaxItemResult)
pub mod batch_detect_syntax_item_result {
    /// A builder for [`BatchDetectSyntaxItemResult`](crate::model::BatchDetectSyntaxItemResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index: std::option::Option<i32>,
        pub(crate) syntax_tokens: std::option::Option<std::vec::Vec<crate::model::SyntaxToken>>,
    }
    impl Builder {
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn index(mut self, input: i32) -> Self {
            self.index = Some(input);
            self
        }
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn set_index(mut self, input: std::option::Option<i32>) -> Self {
            self.index = input;
            self
        }
        /// Appends an item to `syntax_tokens`.
        ///
        /// To override the contents of this collection use [`set_syntax_tokens`](Self::set_syntax_tokens).
        ///
        /// <p>The syntax tokens for the words in the document, one token for each word.</p>
        pub fn syntax_tokens(mut self, input: impl Into<crate::model::SyntaxToken>) -> Self {
            let mut v = self.syntax_tokens.unwrap_or_default();
            v.push(input.into());
            self.syntax_tokens = Some(v);
            self
        }
        /// <p>The syntax tokens for the words in the document, one token for each word.</p>
        pub fn set_syntax_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SyntaxToken>>,
        ) -> Self {
            self.syntax_tokens = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetectSyntaxItemResult`](crate::model::BatchDetectSyntaxItemResult)
        pub fn build(self) -> crate::model::BatchDetectSyntaxItemResult {
            crate::model::BatchDetectSyntaxItemResult {
                index: self.index,
                syntax_tokens: self.syntax_tokens,
            }
        }
    }
}
impl BatchDetectSyntaxItemResult {
    /// Creates a new builder-style object to manufacture [`BatchDetectSyntaxItemResult`](crate::model::BatchDetectSyntaxItemResult)
    pub fn builder() -> crate::model::batch_detect_syntax_item_result::Builder {
        crate::model::batch_detect_syntax_item_result::Builder::default()
    }
}

/// <p>The result of calling the  operation. The
/// operation returns one object for each document that is successfully processed by the
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetectSentimentItemResult {
    /// <p>The zero-based index of the document in the input list.</p>
    pub index: std::option::Option<i32>,
    /// <p>The sentiment detected in the document.</p>
    pub sentiment: std::option::Option<crate::model::SentimentType>,
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its sentiment
    /// detection.</p>
    pub sentiment_score: std::option::Option<crate::model::SentimentScore>,
}
impl BatchDetectSentimentItemResult {
    /// <p>The zero-based index of the document in the input list.</p>
    pub fn index(&self) -> std::option::Option<i32> {
        self.index
    }
    /// <p>The sentiment detected in the document.</p>
    pub fn sentiment(&self) -> std::option::Option<&crate::model::SentimentType> {
        self.sentiment.as_ref()
    }
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its sentiment
    /// detection.</p>
    pub fn sentiment_score(&self) -> std::option::Option<&crate::model::SentimentScore> {
        self.sentiment_score.as_ref()
    }
}
impl std::fmt::Debug for BatchDetectSentimentItemResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetectSentimentItemResult");
        formatter.field("index", &self.index);
        formatter.field("sentiment", &self.sentiment);
        formatter.field("sentiment_score", &self.sentiment_score);
        formatter.finish()
    }
}
/// See [`BatchDetectSentimentItemResult`](crate::model::BatchDetectSentimentItemResult)
pub mod batch_detect_sentiment_item_result {
    /// A builder for [`BatchDetectSentimentItemResult`](crate::model::BatchDetectSentimentItemResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index: std::option::Option<i32>,
        pub(crate) sentiment: std::option::Option<crate::model::SentimentType>,
        pub(crate) sentiment_score: std::option::Option<crate::model::SentimentScore>,
    }
    impl Builder {
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn index(mut self, input: i32) -> Self {
            self.index = Some(input);
            self
        }
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn set_index(mut self, input: std::option::Option<i32>) -> Self {
            self.index = input;
            self
        }
        /// <p>The sentiment detected in the document.</p>
        pub fn sentiment(mut self, input: crate::model::SentimentType) -> Self {
            self.sentiment = Some(input);
            self
        }
        /// <p>The sentiment detected in the document.</p>
        pub fn set_sentiment(
            mut self,
            input: std::option::Option<crate::model::SentimentType>,
        ) -> Self {
            self.sentiment = input;
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its sentiment
        /// detection.</p>
        pub fn sentiment_score(mut self, input: crate::model::SentimentScore) -> Self {
            self.sentiment_score = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy of its sentiment
        /// detection.</p>
        pub fn set_sentiment_score(
            mut self,
            input: std::option::Option<crate::model::SentimentScore>,
        ) -> Self {
            self.sentiment_score = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetectSentimentItemResult`](crate::model::BatchDetectSentimentItemResult)
        pub fn build(self) -> crate::model::BatchDetectSentimentItemResult {
            crate::model::BatchDetectSentimentItemResult {
                index: self.index,
                sentiment: self.sentiment,
                sentiment_score: self.sentiment_score,
            }
        }
    }
}
impl BatchDetectSentimentItemResult {
    /// Creates a new builder-style object to manufacture [`BatchDetectSentimentItemResult`](crate::model::BatchDetectSentimentItemResult)
    pub fn builder() -> crate::model::batch_detect_sentiment_item_result::Builder {
        crate::model::batch_detect_sentiment_item_result::Builder::default()
    }
}

/// <p>The result of calling the  operation. The
/// operation returns one object for each document that is successfully processed by the
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetectKeyPhrasesItemResult {
    /// <p>The zero-based index of the document in the input list.</p>
    pub index: std::option::Option<i32>,
    /// <p>One or more <a>KeyPhrase</a> objects, one for each key phrase detected in
    /// the document.</p>
    pub key_phrases: std::option::Option<std::vec::Vec<crate::model::KeyPhrase>>,
}
impl BatchDetectKeyPhrasesItemResult {
    /// <p>The zero-based index of the document in the input list.</p>
    pub fn index(&self) -> std::option::Option<i32> {
        self.index
    }
    /// <p>One or more <a>KeyPhrase</a> objects, one for each key phrase detected in
    /// the document.</p>
    pub fn key_phrases(&self) -> std::option::Option<&[crate::model::KeyPhrase]> {
        self.key_phrases.as_deref()
    }
}
impl std::fmt::Debug for BatchDetectKeyPhrasesItemResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetectKeyPhrasesItemResult");
        formatter.field("index", &self.index);
        formatter.field("key_phrases", &self.key_phrases);
        formatter.finish()
    }
}
/// See [`BatchDetectKeyPhrasesItemResult`](crate::model::BatchDetectKeyPhrasesItemResult)
pub mod batch_detect_key_phrases_item_result {
    /// A builder for [`BatchDetectKeyPhrasesItemResult`](crate::model::BatchDetectKeyPhrasesItemResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index: std::option::Option<i32>,
        pub(crate) key_phrases: std::option::Option<std::vec::Vec<crate::model::KeyPhrase>>,
    }
    impl Builder {
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn index(mut self, input: i32) -> Self {
            self.index = Some(input);
            self
        }
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn set_index(mut self, input: std::option::Option<i32>) -> Self {
            self.index = input;
            self
        }
        /// Appends an item to `key_phrases`.
        ///
        /// To override the contents of this collection use [`set_key_phrases`](Self::set_key_phrases).
        ///
        /// <p>One or more <a>KeyPhrase</a> objects, one for each key phrase detected in
        /// the document.</p>
        pub fn key_phrases(mut self, input: impl Into<crate::model::KeyPhrase>) -> Self {
            let mut v = self.key_phrases.unwrap_or_default();
            v.push(input.into());
            self.key_phrases = Some(v);
            self
        }
        /// <p>One or more <a>KeyPhrase</a> objects, one for each key phrase detected in
        /// the document.</p>
        pub fn set_key_phrases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyPhrase>>,
        ) -> Self {
            self.key_phrases = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetectKeyPhrasesItemResult`](crate::model::BatchDetectKeyPhrasesItemResult)
        pub fn build(self) -> crate::model::BatchDetectKeyPhrasesItemResult {
            crate::model::BatchDetectKeyPhrasesItemResult {
                index: self.index,
                key_phrases: self.key_phrases,
            }
        }
    }
}
impl BatchDetectKeyPhrasesItemResult {
    /// Creates a new builder-style object to manufacture [`BatchDetectKeyPhrasesItemResult`](crate::model::BatchDetectKeyPhrasesItemResult)
    pub fn builder() -> crate::model::batch_detect_key_phrases_item_result::Builder {
        crate::model::batch_detect_key_phrases_item_result::Builder::default()
    }
}

/// <p>The result of calling the  operation. The
/// operation returns one object for each document that is successfully processed by the
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetectEntitiesItemResult {
    /// <p>The zero-based index of the document in the input list.</p>
    pub index: std::option::Option<i32>,
    /// <p>One or more <a>Entity</a> objects, one for each entity detected in the
    /// document.</p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::Entity>>,
}
impl BatchDetectEntitiesItemResult {
    /// <p>The zero-based index of the document in the input list.</p>
    pub fn index(&self) -> std::option::Option<i32> {
        self.index
    }
    /// <p>One or more <a>Entity</a> objects, one for each entity detected in the
    /// document.</p>
    pub fn entities(&self) -> std::option::Option<&[crate::model::Entity]> {
        self.entities.as_deref()
    }
}
impl std::fmt::Debug for BatchDetectEntitiesItemResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetectEntitiesItemResult");
        formatter.field("index", &self.index);
        formatter.field("entities", &self.entities);
        formatter.finish()
    }
}
/// See [`BatchDetectEntitiesItemResult`](crate::model::BatchDetectEntitiesItemResult)
pub mod batch_detect_entities_item_result {
    /// A builder for [`BatchDetectEntitiesItemResult`](crate::model::BatchDetectEntitiesItemResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index: std::option::Option<i32>,
        pub(crate) entities: std::option::Option<std::vec::Vec<crate::model::Entity>>,
    }
    impl Builder {
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn index(mut self, input: i32) -> Self {
            self.index = Some(input);
            self
        }
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn set_index(mut self, input: std::option::Option<i32>) -> Self {
            self.index = input;
            self
        }
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>One or more <a>Entity</a> objects, one for each entity detected in the
        /// document.</p>
        pub fn entities(mut self, input: impl Into<crate::model::Entity>) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input.into());
            self.entities = Some(v);
            self
        }
        /// <p>One or more <a>Entity</a> objects, one for each entity detected in the
        /// document.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entity>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetectEntitiesItemResult`](crate::model::BatchDetectEntitiesItemResult)
        pub fn build(self) -> crate::model::BatchDetectEntitiesItemResult {
            crate::model::BatchDetectEntitiesItemResult {
                index: self.index,
                entities: self.entities,
            }
        }
    }
}
impl BatchDetectEntitiesItemResult {
    /// Creates a new builder-style object to manufacture [`BatchDetectEntitiesItemResult`](crate::model::BatchDetectEntitiesItemResult)
    pub fn builder() -> crate::model::batch_detect_entities_item_result::Builder {
        crate::model::batch_detect_entities_item_result::Builder::default()
    }
}

/// <p>The result of calling the  operation.
/// The operation returns one object for each document that is successfully processed by the
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetectDominantLanguageItemResult {
    /// <p>The zero-based index of the document in the input list.</p>
    pub index: std::option::Option<i32>,
    /// <p>One or more <a>DominantLanguage</a> objects describing the dominant
    /// languages in the document.</p>
    pub languages: std::option::Option<std::vec::Vec<crate::model::DominantLanguage>>,
}
impl BatchDetectDominantLanguageItemResult {
    /// <p>The zero-based index of the document in the input list.</p>
    pub fn index(&self) -> std::option::Option<i32> {
        self.index
    }
    /// <p>One or more <a>DominantLanguage</a> objects describing the dominant
    /// languages in the document.</p>
    pub fn languages(&self) -> std::option::Option<&[crate::model::DominantLanguage]> {
        self.languages.as_deref()
    }
}
impl std::fmt::Debug for BatchDetectDominantLanguageItemResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetectDominantLanguageItemResult");
        formatter.field("index", &self.index);
        formatter.field("languages", &self.languages);
        formatter.finish()
    }
}
/// See [`BatchDetectDominantLanguageItemResult`](crate::model::BatchDetectDominantLanguageItemResult)
pub mod batch_detect_dominant_language_item_result {
    /// A builder for [`BatchDetectDominantLanguageItemResult`](crate::model::BatchDetectDominantLanguageItemResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index: std::option::Option<i32>,
        pub(crate) languages: std::option::Option<std::vec::Vec<crate::model::DominantLanguage>>,
    }
    impl Builder {
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn index(mut self, input: i32) -> Self {
            self.index = Some(input);
            self
        }
        /// <p>The zero-based index of the document in the input list.</p>
        pub fn set_index(mut self, input: std::option::Option<i32>) -> Self {
            self.index = input;
            self
        }
        /// Appends an item to `languages`.
        ///
        /// To override the contents of this collection use [`set_languages`](Self::set_languages).
        ///
        /// <p>One or more <a>DominantLanguage</a> objects describing the dominant
        /// languages in the document.</p>
        pub fn languages(mut self, input: impl Into<crate::model::DominantLanguage>) -> Self {
            let mut v = self.languages.unwrap_or_default();
            v.push(input.into());
            self.languages = Some(v);
            self
        }
        /// <p>One or more <a>DominantLanguage</a> objects describing the dominant
        /// languages in the document.</p>
        pub fn set_languages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DominantLanguage>>,
        ) -> Self {
            self.languages = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetectDominantLanguageItemResult`](crate::model::BatchDetectDominantLanguageItemResult)
        pub fn build(self) -> crate::model::BatchDetectDominantLanguageItemResult {
            crate::model::BatchDetectDominantLanguageItemResult {
                index: self.index,
                languages: self.languages,
            }
        }
    }
}
impl BatchDetectDominantLanguageItemResult {
    /// Creates a new builder-style object to manufacture [`BatchDetectDominantLanguageItemResult`](crate::model::BatchDetectDominantLanguageItemResult)
    pub fn builder() -> crate::model::batch_detect_dominant_language_item_result::Builder {
        crate::model::batch_detect_dominant_language_item_result::Builder::default()
    }
}
