// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchDetectDominantLanguageInput`](crate::input::BatchDetectDominantLanguageInput)
pub mod batch_detect_dominant_language_input {
    /// A builder for [`BatchDetectDominantLanguageInput`](crate::input::BatchDetectDominantLanguageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `text_list`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document should contain at least 20 characters and must contain fewer than
        /// 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.text_list.unwrap_or_default();
            v.push(input.into());
            self.text_list = Some(v);
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document should contain at least 20 characters and must contain fewer than
        /// 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.text_list = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetectDominantLanguageInput`](crate::input::BatchDetectDominantLanguageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDetectDominantLanguageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDetectDominantLanguageInput {
                text_list: self.text_list,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDetectDominantLanguageInputOperationOutputAlias =
    crate::operation::BatchDetectDominantLanguage;
#[doc(hidden)]
pub type BatchDetectDominantLanguageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDetectDominantLanguageInput {
    /// Consumes the builder and constructs an Operation<[`BatchDetectDominantLanguage`](crate::operation::BatchDetectDominantLanguage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDetectDominantLanguage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDetectDominantLanguageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDetectDominantLanguageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDetectDominantLanguageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.BatchDetectDominantLanguage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_detect_dominant_language(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDetectDominantLanguage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDetectDominantLanguage",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDetectDominantLanguageInput`](crate::input::BatchDetectDominantLanguageInput)
    pub fn builder() -> crate::input::batch_detect_dominant_language_input::Builder {
        crate::input::batch_detect_dominant_language_input::Builder::default()
    }
}

/// See [`BatchDetectEntitiesInput`](crate::input::BatchDetectEntitiesInput)
pub mod batch_detect_entities_input {
    /// A builder for [`BatchDetectEntitiesInput`](crate::input::BatchDetectEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
    }
    impl Builder {
        /// Appends an item to `text_list`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer than 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.text_list.unwrap_or_default();
            v.push(input.into());
            self.text_list = Some(v);
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer than 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.text_list = input;
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetectEntitiesInput`](crate::input::BatchDetectEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDetectEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDetectEntitiesInput {
                text_list: self.text_list,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDetectEntitiesInputOperationOutputAlias = crate::operation::BatchDetectEntities;
#[doc(hidden)]
pub type BatchDetectEntitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDetectEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`BatchDetectEntities`](crate::operation::BatchDetectEntities)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDetectEntities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDetectEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDetectEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDetectEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.BatchDetectEntities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_detect_entities(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDetectEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDetectEntities",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDetectEntitiesInput`](crate::input::BatchDetectEntitiesInput)
    pub fn builder() -> crate::input::batch_detect_entities_input::Builder {
        crate::input::batch_detect_entities_input::Builder::default()
    }
}

/// See [`BatchDetectKeyPhrasesInput`](crate::input::BatchDetectKeyPhrasesInput)
pub mod batch_detect_key_phrases_input {
    /// A builder for [`BatchDetectKeyPhrasesInput`](crate::input::BatchDetectKeyPhrasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
    }
    impl Builder {
        /// Appends an item to `text_list`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.text_list.unwrap_or_default();
            v.push(input.into());
            self.text_list = Some(v);
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.text_list = input;
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetectKeyPhrasesInput`](crate::input::BatchDetectKeyPhrasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDetectKeyPhrasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDetectKeyPhrasesInput {
                text_list: self.text_list,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDetectKeyPhrasesInputOperationOutputAlias = crate::operation::BatchDetectKeyPhrases;
#[doc(hidden)]
pub type BatchDetectKeyPhrasesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDetectKeyPhrasesInput {
    /// Consumes the builder and constructs an Operation<[`BatchDetectKeyPhrases`](crate::operation::BatchDetectKeyPhrases)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDetectKeyPhrases,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDetectKeyPhrasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDetectKeyPhrasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDetectKeyPhrasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.BatchDetectKeyPhrases",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_detect_key_phrases(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDetectKeyPhrases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDetectKeyPhrases",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDetectKeyPhrasesInput`](crate::input::BatchDetectKeyPhrasesInput)
    pub fn builder() -> crate::input::batch_detect_key_phrases_input::Builder {
        crate::input::batch_detect_key_phrases_input::Builder::default()
    }
}

/// See [`BatchDetectSentimentInput`](crate::input::BatchDetectSentimentInput)
pub mod batch_detect_sentiment_input {
    /// A builder for [`BatchDetectSentimentInput`](crate::input::BatchDetectSentimentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
    }
    impl Builder {
        /// Appends an item to `text_list`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.text_list.unwrap_or_default();
            v.push(input.into());
            self.text_list = Some(v);
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.text_list = input;
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetectSentimentInput`](crate::input::BatchDetectSentimentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDetectSentimentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDetectSentimentInput {
                text_list: self.text_list,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDetectSentimentInputOperationOutputAlias = crate::operation::BatchDetectSentiment;
#[doc(hidden)]
pub type BatchDetectSentimentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDetectSentimentInput {
    /// Consumes the builder and constructs an Operation<[`BatchDetectSentiment`](crate::operation::BatchDetectSentiment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDetectSentiment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDetectSentimentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDetectSentimentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDetectSentimentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.BatchDetectSentiment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_detect_sentiment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDetectSentiment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDetectSentiment",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDetectSentimentInput`](crate::input::BatchDetectSentimentInput)
    pub fn builder() -> crate::input::batch_detect_sentiment_input::Builder {
        crate::input::batch_detect_sentiment_input::Builder::default()
    }
}

/// See [`BatchDetectSyntaxInput`](crate::input::BatchDetectSyntaxInput)
pub mod batch_detect_syntax_input {
    /// A builder for [`BatchDetectSyntaxInput`](crate::input::BatchDetectSyntaxInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) language_code: std::option::Option<crate::model::SyntaxLanguageCode>,
    }
    impl Builder {
        /// Appends an item to `text_list`.
        ///
        /// To override the contents of this collection use [`set_text_list`](Self::set_text_list).
        ///
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.text_list.unwrap_or_default();
            v.push(input.into());
            self.text_list = Some(v);
            self
        }
        /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
        /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.text_list = input;
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::SyntaxLanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::SyntaxLanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDetectSyntaxInput`](crate::input::BatchDetectSyntaxInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDetectSyntaxInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDetectSyntaxInput {
                text_list: self.text_list,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDetectSyntaxInputOperationOutputAlias = crate::operation::BatchDetectSyntax;
#[doc(hidden)]
pub type BatchDetectSyntaxInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDetectSyntaxInput {
    /// Consumes the builder and constructs an Operation<[`BatchDetectSyntax`](crate::operation::BatchDetectSyntax)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDetectSyntax,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDetectSyntaxInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDetectSyntaxInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDetectSyntaxInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.BatchDetectSyntax",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_detect_syntax(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDetectSyntax::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDetectSyntax",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDetectSyntaxInput`](crate::input::BatchDetectSyntaxInput)
    pub fn builder() -> crate::input::batch_detect_syntax_input::Builder {
        crate::input::batch_detect_syntax_input::Builder::default()
    }
}

/// See [`ClassifyDocumentInput`](crate::input::ClassifyDocumentInput)
pub mod classify_document_input {
    /// A builder for [`ClassifyDocumentInput`](crate::input::ClassifyDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The document text to be analyzed.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The document text to be analyzed.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ClassifyDocumentInput`](crate::input::ClassifyDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ClassifyDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ClassifyDocumentInput {
                text: self.text,
                endpoint_arn: self.endpoint_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ClassifyDocumentInputOperationOutputAlias = crate::operation::ClassifyDocument;
#[doc(hidden)]
pub type ClassifyDocumentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ClassifyDocumentInput {
    /// Consumes the builder and constructs an Operation<[`ClassifyDocument`](crate::operation::ClassifyDocument)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ClassifyDocument,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ClassifyDocumentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ClassifyDocumentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ClassifyDocumentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ClassifyDocument",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_classify_document(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ClassifyDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ClassifyDocument",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ClassifyDocumentInput`](crate::input::ClassifyDocumentInput)
    pub fn builder() -> crate::input::classify_document_input::Builder {
        crate::input::classify_document_input::Builder::default()
    }
}

/// See [`ContainsPiiEntitiesInput`](crate::input::ContainsPiiEntitiesInput)
pub mod contains_pii_entities_input {
    /// A builder for [`ContainsPiiEntitiesInput`](crate::input::ContainsPiiEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
    }
    impl Builder {
        /// <p>Creates a new document classification request to analyze a single document in real-time,
        /// returning personally identifiable information (PII) entity labels.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>Creates a new document classification request to analyze a single document in real-time,
        /// returning personally identifiable information (PII) entity labels.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainsPiiEntitiesInput`](crate::input::ContainsPiiEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ContainsPiiEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ContainsPiiEntitiesInput {
                text: self.text,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type ContainsPiiEntitiesInputOperationOutputAlias = crate::operation::ContainsPiiEntities;
#[doc(hidden)]
pub type ContainsPiiEntitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ContainsPiiEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`ContainsPiiEntities`](crate::operation::ContainsPiiEntities)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ContainsPiiEntities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ContainsPiiEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ContainsPiiEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ContainsPiiEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ContainsPiiEntities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_contains_pii_entities(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ContainsPiiEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ContainsPiiEntities",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ContainsPiiEntitiesInput`](crate::input::ContainsPiiEntitiesInput)
    pub fn builder() -> crate::input::contains_pii_entities_input::Builder {
        crate::input::contains_pii_entities_input::Builder::default()
    }
}

/// See [`CreateDocumentClassifierInput`](crate::input::CreateDocumentClassifierInput)
pub mod create_document_classifier_input {
    /// A builder for [`CreateDocumentClassifierInput`](crate::input::CreateDocumentClassifierInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_classifier_name: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) input_data_config:
            std::option::Option<crate::model::DocumentClassifierInputDataConfig>,
        pub(crate) output_data_config:
            std::option::Option<crate::model::DocumentClassifierOutputDataConfig>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) mode: std::option::Option<crate::model::DocumentClassifierMode>,
        pub(crate) model_kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the document classifier.</p>
        pub fn document_classifier_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_classifier_name = Some(input.into());
            self
        }
        /// <p>The name of the document classifier.</p>
        pub fn set_document_classifier_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_classifier_name = input;
            self
        }
        /// <p>The version name given to the newly created classifier.
        /// Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed.
        /// The version name must be unique among all models with the same classifier name in the account/AWS Region.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>The version name given to the newly created classifier.
        /// Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed.
        /// The version name must be unique among all models with the same classifier name in the account/AWS Region.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the document classifier being created. A tag is a key-value
        /// pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with
        /// "Sales" as the key might be added to a resource to indicate its use by the sales department.
        /// </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be associated with the document classifier being created. A tag is a key-value
        /// pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with
        /// "Sales" as the key might be added to a resource to indicate its use by the sales department.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(
            mut self,
            input: crate::model::DocumentClassifierInputDataConfig,
        ) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierInputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Enables the addition of output results configuration parameters for custom classifier
        /// jobs.</p>
        pub fn output_data_config(
            mut self,
            input: crate::model::DocumentClassifierOutputDataConfig,
        ) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Enables the addition of output results configuration parameters for custom classifier
        /// jobs.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierOutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Indicates the mode in which the classifier will be trained. The classifier can be trained
        /// in multi-class mode, which identifies one and only one class for each document, or multi-label
        /// mode, which identifies one or more labels for each document. In multi-label mode, multiple
        /// labels for an individual document are separated by a delimiter. The default delimiter between
        /// labels is a pipe (|).</p>
        pub fn mode(mut self, input: crate::model::DocumentClassifierMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>Indicates the mode in which the classifier will be trained. The classifier can be trained
        /// in multi-class mode, which identifies one and only one class for each document, or multi-label
        /// mode, which identifies one or more labels for each document. In multi-label mode, multiple
        /// labels for an individual document are separated by a delimiter. The default delimiter between
        /// labels is a pipe (|).</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn model_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_model_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDocumentClassifierInput`](crate::input::CreateDocumentClassifierInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDocumentClassifierInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDocumentClassifierInput {
                document_classifier_name: self.document_classifier_name,
                version_name: self.version_name,
                data_access_role_arn: self.data_access_role_arn,
                tags: self.tags,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                client_request_token: self.client_request_token,
                language_code: self.language_code,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
                mode: self.mode,
                model_kms_key_id: self.model_kms_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDocumentClassifierInputOperationOutputAlias =
    crate::operation::CreateDocumentClassifier;
#[doc(hidden)]
pub type CreateDocumentClassifierInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDocumentClassifierInput {
    /// Consumes the builder and constructs an Operation<[`CreateDocumentClassifier`](crate::operation::CreateDocumentClassifier)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDocumentClassifier,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDocumentClassifierInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDocumentClassifierInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDocumentClassifierInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.CreateDocumentClassifier",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_document_classifier(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDocumentClassifier::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDocumentClassifier",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDocumentClassifierInput`](crate::input::CreateDocumentClassifierInput)
    pub fn builder() -> crate::input::create_document_classifier_input::Builder {
        crate::input::create_document_classifier_input::Builder::default()
    }
}

/// See [`CreateEndpointInput`](crate::input::CreateEndpointInput)
pub mod create_endpoint_input {
    /// A builder for [`CreateEndpointInput`](crate::input::CreateEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) model_arn: std::option::Option<std::string::String>,
        pub(crate) desired_inference_units: std::option::Option<i32>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for
        /// all subsequent requests to this resource. </p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for
        /// all subsequent requests to this resource. </p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint will be
        /// attached.</p>
        pub fn model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint will be
        /// attached.</p>
        pub fn set_model_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_arn = input;
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint.
        ///
        /// Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn desired_inference_units(mut self, input: i32) -> Self {
            self.desired_inference_units = Some(input);
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint.
        ///
        /// Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn set_desired_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_inference_units = input;
            self
        }
        /// <p>An idempotency token provided by the customer. If this token matches a previous endpoint
        /// creation request, Amazon Comprehend will not return a <code>ResourceInUseException</code>.
        /// </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>An idempotency token provided by the customer. If this token matches a previous endpoint
        /// creation request, Amazon Comprehend will not return a <code>ResourceInUseException</code>.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the endpoint being created. A tag is a key-value pair that adds
        /// metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an
        /// endpoint to indicate its use by the sales department. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags associated with the endpoint being created. A tag is a key-value pair that adds
        /// metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an
        /// endpoint to indicate its use by the sales department. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to trained custom models encrypted with a customer
        /// managed key (ModelKmsKeyId).</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to trained custom models encrypted with a customer
        /// managed key (ModelKmsKeyId).</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEndpointInput`](crate::input::CreateEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEndpointInput {
                endpoint_name: self.endpoint_name,
                model_arn: self.model_arn,
                desired_inference_units: self.desired_inference_units,
                client_request_token: self.client_request_token,
                tags: self.tags,
                data_access_role_arn: self.data_access_role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEndpointInputOperationOutputAlias = crate::operation::CreateEndpoint;
#[doc(hidden)]
pub type CreateEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEndpointInput {
    /// Consumes the builder and constructs an Operation<[`CreateEndpoint`](crate::operation::CreateEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.CreateEndpoint",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_endpoint(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEndpoint",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEndpointInput`](crate::input::CreateEndpointInput)
    pub fn builder() -> crate::input::create_endpoint_input::Builder {
        crate::input::create_endpoint_input::Builder::default()
    }
}

/// See [`CreateEntityRecognizerInput`](crate::input::CreateEntityRecognizerInput)
pub mod create_entity_recognizer_input {
    /// A builder for [`CreateEntityRecognizerInput`](crate::input::CreateEntityRecognizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recognizer_name: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) input_data_config:
            std::option::Option<crate::model::EntityRecognizerInputDataConfig>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) model_kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name given to the newly created recognizer. Recognizer names can be a maximum of 256
        /// characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name
        /// must be unique in the account/region.</p>
        pub fn recognizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recognizer_name = Some(input.into());
            self
        }
        /// <p>The name given to the newly created recognizer. Recognizer names can be a maximum of 256
        /// characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name
        /// must be unique in the account/region.</p>
        pub fn set_recognizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recognizer_name = input;
            self
        }
        /// <p>The version name given to the newly created recognizer.
        /// Version names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed.
        /// The version name must be unique among all models with the same recognizer name in the account/ AWS Region.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>The version name given to the newly created recognizer.
        /// Version names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed.
        /// The version name must be unique among all models with the same recognizer name in the account/ AWS Region.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
        /// Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the entity recognizer being created. A tag is a key-value pair
        /// that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with
        /// "Sales" as the key might be added to a resource to indicate its use by the sales department.
        /// </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be associated with the entity recognizer being created. A tag is a key-value pair
        /// that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with
        /// "Sales" as the key might be added to a resource to indicate its use by the sales department.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies the format and location of the input data. The S3 bucket containing the input
        /// data must be located in the same region as the entity recognizer being created. </p>
        pub fn input_data_config(
            mut self,
            input: crate::model::EntityRecognizerInputDataConfig,
        ) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and location of the input data. The S3 bucket containing the input
        /// data must be located in the same region as the entity recognizer being created. </p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerInputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p> A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p> A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p> You can specify any of the following languages supported by Amazon Comprehend: English
        /// ("en"), Spanish ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt").
        /// All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p> You can specify any of the following languages supported by Amazon Comprehend: English
        /// ("en"), Spanish ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt").
        /// All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your custom entity recognizer. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your custom entity recognizer. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn model_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// trained custom models. The ModelKmsKeyId can be either of the following formats</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_model_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEntityRecognizerInput`](crate::input::CreateEntityRecognizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEntityRecognizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEntityRecognizerInput {
                recognizer_name: self.recognizer_name,
                version_name: self.version_name,
                data_access_role_arn: self.data_access_role_arn,
                tags: self.tags,
                input_data_config: self.input_data_config,
                client_request_token: self.client_request_token,
                language_code: self.language_code,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
                model_kms_key_id: self.model_kms_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEntityRecognizerInputOperationOutputAlias = crate::operation::CreateEntityRecognizer;
#[doc(hidden)]
pub type CreateEntityRecognizerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEntityRecognizerInput {
    /// Consumes the builder and constructs an Operation<[`CreateEntityRecognizer`](crate::operation::CreateEntityRecognizer)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEntityRecognizer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEntityRecognizerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEntityRecognizerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEntityRecognizerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.CreateEntityRecognizer",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_entity_recognizer(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEntityRecognizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEntityRecognizer",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEntityRecognizerInput`](crate::input::CreateEntityRecognizerInput)
    pub fn builder() -> crate::input::create_entity_recognizer_input::Builder {
        crate::input::create_entity_recognizer_input::Builder::default()
    }
}

/// See [`DeleteDocumentClassifierInput`](crate::input::DeleteDocumentClassifierInput)
pub mod delete_document_classifier_input {
    /// A builder for [`DeleteDocumentClassifierInput`](crate::input::DeleteDocumentClassifierInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_classifier_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
        pub fn document_classifier_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_classifier_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_classifier_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDocumentClassifierInput`](crate::input::DeleteDocumentClassifierInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDocumentClassifierInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDocumentClassifierInput {
                document_classifier_arn: self.document_classifier_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDocumentClassifierInputOperationOutputAlias =
    crate::operation::DeleteDocumentClassifier;
#[doc(hidden)]
pub type DeleteDocumentClassifierInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDocumentClassifierInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDocumentClassifier`](crate::operation::DeleteDocumentClassifier)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDocumentClassifier,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDocumentClassifierInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDocumentClassifierInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDocumentClassifierInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DeleteDocumentClassifier",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_document_classifier(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDocumentClassifier::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDocumentClassifier",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDocumentClassifierInput`](crate::input::DeleteDocumentClassifierInput)
    pub fn builder() -> crate::input::delete_document_classifier_input::Builder {
        crate::input::delete_document_classifier_input::Builder::default()
    }
}

/// See [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
pub mod delete_endpoint_input {
    /// A builder for [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the endpoint being deleted.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being deleted.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEndpointInput {
                endpoint_arn: self.endpoint_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEndpointInputOperationOutputAlias = crate::operation::DeleteEndpoint;
#[doc(hidden)]
pub type DeleteEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEndpoint`](crate::operation::DeleteEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DeleteEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_endpoint(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEndpoint",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    pub fn builder() -> crate::input::delete_endpoint_input::Builder {
        crate::input::delete_endpoint_input::Builder::default()
    }
}

/// See [`DeleteEntityRecognizerInput`](crate::input::DeleteEntityRecognizerInput)
pub mod delete_entity_recognizer_input {
    /// A builder for [`DeleteEntityRecognizerInput`](crate::input::DeleteEntityRecognizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_recognizer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn entity_recognizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_recognizer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entity_recognizer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEntityRecognizerInput`](crate::input::DeleteEntityRecognizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEntityRecognizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEntityRecognizerInput {
                entity_recognizer_arn: self.entity_recognizer_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEntityRecognizerInputOperationOutputAlias = crate::operation::DeleteEntityRecognizer;
#[doc(hidden)]
pub type DeleteEntityRecognizerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEntityRecognizerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEntityRecognizer`](crate::operation::DeleteEntityRecognizer)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEntityRecognizer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEntityRecognizerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEntityRecognizerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEntityRecognizerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DeleteEntityRecognizer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_entity_recognizer(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEntityRecognizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEntityRecognizer",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEntityRecognizerInput`](crate::input::DeleteEntityRecognizerInput)
    pub fn builder() -> crate::input::delete_entity_recognizer_input::Builder {
        crate::input::delete_entity_recognizer_input::Builder::default()
    }
}

/// See [`DescribeDocumentClassificationJobInput`](crate::input::DescribeDocumentClassificationJobInput)
pub mod describe_document_classification_job_input {
    /// A builder for [`DescribeDocumentClassificationJobInput`](crate::input::DescribeDocumentClassificationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDocumentClassificationJobInput`](crate::input::DescribeDocumentClassificationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDocumentClassificationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDocumentClassificationJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDocumentClassificationJobInputOperationOutputAlias =
    crate::operation::DescribeDocumentClassificationJob;
#[doc(hidden)]
pub type DescribeDocumentClassificationJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDocumentClassificationJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDocumentClassificationJob`](crate::operation::DescribeDocumentClassificationJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDocumentClassificationJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDocumentClassificationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDocumentClassificationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDocumentClassificationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DescribeDocumentClassificationJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_document_classification_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDocumentClassificationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDocumentClassificationJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDocumentClassificationJobInput`](crate::input::DescribeDocumentClassificationJobInput)
    pub fn builder() -> crate::input::describe_document_classification_job_input::Builder {
        crate::input::describe_document_classification_job_input::Builder::default()
    }
}

/// See [`DescribeDocumentClassifierInput`](crate::input::DescribeDocumentClassifierInput)
pub mod describe_document_classifier_input {
    /// A builder for [`DescribeDocumentClassifierInput`](crate::input::DescribeDocumentClassifierInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_classifier_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. The  operation returns this identifier in its
        /// response.</p>
        pub fn document_classifier_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_classifier_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_classifier_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDocumentClassifierInput`](crate::input::DescribeDocumentClassifierInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDocumentClassifierInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDocumentClassifierInput {
                document_classifier_arn: self.document_classifier_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDocumentClassifierInputOperationOutputAlias =
    crate::operation::DescribeDocumentClassifier;
#[doc(hidden)]
pub type DescribeDocumentClassifierInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDocumentClassifierInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDocumentClassifier`](crate::operation::DescribeDocumentClassifier)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDocumentClassifier,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDocumentClassifierInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDocumentClassifierInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDocumentClassifierInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DescribeDocumentClassifier",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_document_classifier(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDocumentClassifier::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDocumentClassifier",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDocumentClassifierInput`](crate::input::DescribeDocumentClassifierInput)
    pub fn builder() -> crate::input::describe_document_classifier_input::Builder {
        crate::input::describe_document_classifier_input::Builder::default()
    }
}

/// See [`DescribeDominantLanguageDetectionJobInput`](crate::input::DescribeDominantLanguageDetectionJobInput)
pub mod describe_dominant_language_detection_job_input {
    /// A builder for [`DescribeDominantLanguageDetectionJobInput`](crate::input::DescribeDominantLanguageDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDominantLanguageDetectionJobInput`](crate::input::DescribeDominantLanguageDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDominantLanguageDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDominantLanguageDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDominantLanguageDetectionJobInputOperationOutputAlias =
    crate::operation::DescribeDominantLanguageDetectionJob;
#[doc(hidden)]
pub type DescribeDominantLanguageDetectionJobInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeDominantLanguageDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDominantLanguageDetectionJob`](crate::operation::DescribeDominantLanguageDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDominantLanguageDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDominantLanguageDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDominantLanguageDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDominantLanguageDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DescribeDominantLanguageDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_dominant_language_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDominantLanguageDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDominantLanguageDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDominantLanguageDetectionJobInput`](crate::input::DescribeDominantLanguageDetectionJobInput)
    pub fn builder() -> crate::input::describe_dominant_language_detection_job_input::Builder {
        crate::input::describe_dominant_language_detection_job_input::Builder::default()
    }
}

/// See [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
pub mod describe_endpoint_input {
    /// A builder for [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the endpoint being described.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being described.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEndpointInput {
                endpoint_arn: self.endpoint_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEndpointInputOperationOutputAlias = crate::operation::DescribeEndpoint;
#[doc(hidden)]
pub type DescribeEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEndpoint`](crate::operation::DescribeEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DescribeEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_endpoint(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEndpoint",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
    pub fn builder() -> crate::input::describe_endpoint_input::Builder {
        crate::input::describe_endpoint_input::Builder::default()
    }
}

/// See [`DescribeEntitiesDetectionJobInput`](crate::input::DescribeEntitiesDetectionJobInput)
pub mod describe_entities_detection_job_input {
    /// A builder for [`DescribeEntitiesDetectionJobInput`](crate::input::DescribeEntitiesDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEntitiesDetectionJobInput`](crate::input::DescribeEntitiesDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEntitiesDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEntitiesDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEntitiesDetectionJobInputOperationOutputAlias =
    crate::operation::DescribeEntitiesDetectionJob;
#[doc(hidden)]
pub type DescribeEntitiesDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEntitiesDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEntitiesDetectionJob`](crate::operation::DescribeEntitiesDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEntitiesDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEntitiesDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEntitiesDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEntitiesDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DescribeEntitiesDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_entities_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEntitiesDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEntitiesDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEntitiesDetectionJobInput`](crate::input::DescribeEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::describe_entities_detection_job_input::Builder {
        crate::input::describe_entities_detection_job_input::Builder::default()
    }
}

/// See [`DescribeEntityRecognizerInput`](crate::input::DescribeEntityRecognizerInput)
pub mod describe_entity_recognizer_input {
    /// A builder for [`DescribeEntityRecognizerInput`](crate::input::DescribeEntityRecognizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_recognizer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn entity_recognizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_recognizer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entity_recognizer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEntityRecognizerInput`](crate::input::DescribeEntityRecognizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEntityRecognizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEntityRecognizerInput {
                entity_recognizer_arn: self.entity_recognizer_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEntityRecognizerInputOperationOutputAlias =
    crate::operation::DescribeEntityRecognizer;
#[doc(hidden)]
pub type DescribeEntityRecognizerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEntityRecognizerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEntityRecognizer`](crate::operation::DescribeEntityRecognizer)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEntityRecognizer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEntityRecognizerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEntityRecognizerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEntityRecognizerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DescribeEntityRecognizer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_entity_recognizer(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEntityRecognizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEntityRecognizer",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEntityRecognizerInput`](crate::input::DescribeEntityRecognizerInput)
    pub fn builder() -> crate::input::describe_entity_recognizer_input::Builder {
        crate::input::describe_entity_recognizer_input::Builder::default()
    }
}

/// See [`DescribeEventsDetectionJobInput`](crate::input::DescribeEventsDetectionJobInput)
pub mod describe_events_detection_job_input {
    /// A builder for [`DescribeEventsDetectionJobInput`](crate::input::DescribeEventsDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the events detection job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the events detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsDetectionJobInput`](crate::input::DescribeEventsDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsDetectionJobInputOperationOutputAlias =
    crate::operation::DescribeEventsDetectionJob;
#[doc(hidden)]
pub type DescribeEventsDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventsDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventsDetectionJob`](crate::operation::DescribeEventsDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventsDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventsDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventsDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventsDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DescribeEventsDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_events_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventsDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventsDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsDetectionJobInput`](crate::input::DescribeEventsDetectionJobInput)
    pub fn builder() -> crate::input::describe_events_detection_job_input::Builder {
        crate::input::describe_events_detection_job_input::Builder::default()
    }
}

/// See [`DescribeKeyPhrasesDetectionJobInput`](crate::input::DescribeKeyPhrasesDetectionJobInput)
pub mod describe_key_phrases_detection_job_input {
    /// A builder for [`DescribeKeyPhrasesDetectionJobInput`](crate::input::DescribeKeyPhrasesDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeKeyPhrasesDetectionJobInput`](crate::input::DescribeKeyPhrasesDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeKeyPhrasesDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeKeyPhrasesDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeKeyPhrasesDetectionJobInputOperationOutputAlias =
    crate::operation::DescribeKeyPhrasesDetectionJob;
#[doc(hidden)]
pub type DescribeKeyPhrasesDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeKeyPhrasesDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeKeyPhrasesDetectionJob`](crate::operation::DescribeKeyPhrasesDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeKeyPhrasesDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeKeyPhrasesDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeKeyPhrasesDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeKeyPhrasesDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DescribeKeyPhrasesDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_key_phrases_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeKeyPhrasesDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeKeyPhrasesDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeKeyPhrasesDetectionJobInput`](crate::input::DescribeKeyPhrasesDetectionJobInput)
    pub fn builder() -> crate::input::describe_key_phrases_detection_job_input::Builder {
        crate::input::describe_key_phrases_detection_job_input::Builder::default()
    }
}

/// See [`DescribePiiEntitiesDetectionJobInput`](crate::input::DescribePiiEntitiesDetectionJobInput)
pub mod describe_pii_entities_detection_job_input {
    /// A builder for [`DescribePiiEntitiesDetectionJobInput`](crate::input::DescribePiiEntitiesDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePiiEntitiesDetectionJobInput`](crate::input::DescribePiiEntitiesDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePiiEntitiesDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePiiEntitiesDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePiiEntitiesDetectionJobInputOperationOutputAlias =
    crate::operation::DescribePiiEntitiesDetectionJob;
#[doc(hidden)]
pub type DescribePiiEntitiesDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePiiEntitiesDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribePiiEntitiesDetectionJob`](crate::operation::DescribePiiEntitiesDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePiiEntitiesDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePiiEntitiesDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePiiEntitiesDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePiiEntitiesDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DescribePiiEntitiesDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_pii_entities_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePiiEntitiesDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePiiEntitiesDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePiiEntitiesDetectionJobInput`](crate::input::DescribePiiEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::describe_pii_entities_detection_job_input::Builder {
        crate::input::describe_pii_entities_detection_job_input::Builder::default()
    }
}

/// See [`DescribeSentimentDetectionJobInput`](crate::input::DescribeSentimentDetectionJobInput)
pub mod describe_sentiment_detection_job_input {
    /// A builder for [`DescribeSentimentDetectionJobInput`](crate::input::DescribeSentimentDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSentimentDetectionJobInput`](crate::input::DescribeSentimentDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSentimentDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSentimentDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSentimentDetectionJobInputOperationOutputAlias =
    crate::operation::DescribeSentimentDetectionJob;
#[doc(hidden)]
pub type DescribeSentimentDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSentimentDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSentimentDetectionJob`](crate::operation::DescribeSentimentDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSentimentDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSentimentDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSentimentDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSentimentDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DescribeSentimentDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_sentiment_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSentimentDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSentimentDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSentimentDetectionJobInput`](crate::input::DescribeSentimentDetectionJobInput)
    pub fn builder() -> crate::input::describe_sentiment_detection_job_input::Builder {
        crate::input::describe_sentiment_detection_job_input::Builder::default()
    }
}

/// See [`DescribeTopicsDetectionJobInput`](crate::input::DescribeTopicsDetectionJobInput)
pub mod describe_topics_detection_job_input {
    /// A builder for [`DescribeTopicsDetectionJobInput`](crate::input::DescribeTopicsDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier assigned by the user to the detection job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier assigned by the user to the detection job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTopicsDetectionJobInput`](crate::input::DescribeTopicsDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTopicsDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTopicsDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTopicsDetectionJobInputOperationOutputAlias =
    crate::operation::DescribeTopicsDetectionJob;
#[doc(hidden)]
pub type DescribeTopicsDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTopicsDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTopicsDetectionJob`](crate::operation::DescribeTopicsDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTopicsDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTopicsDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTopicsDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTopicsDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DescribeTopicsDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_topics_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTopicsDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTopicsDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTopicsDetectionJobInput`](crate::input::DescribeTopicsDetectionJobInput)
    pub fn builder() -> crate::input::describe_topics_detection_job_input::Builder {
        crate::input::describe_topics_detection_job_input::Builder::default()
    }
}

/// See [`DetectDominantLanguageInput`](crate::input::DetectDominantLanguageInput)
pub mod detect_dominant_language_input {
    /// A builder for [`DetectDominantLanguageInput`](crate::input::DetectDominantLanguageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A UTF-8 text string. Each string should contain at least 20 characters and must contain
        /// fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>A UTF-8 text string. Each string should contain at least 20 characters and must contain
        /// fewer that 5,000 bytes of UTF-8 encoded characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectDominantLanguageInput`](crate::input::DetectDominantLanguageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetectDominantLanguageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetectDominantLanguageInput { text: self.text })
        }
    }
}
#[doc(hidden)]
pub type DetectDominantLanguageInputOperationOutputAlias = crate::operation::DetectDominantLanguage;
#[doc(hidden)]
pub type DetectDominantLanguageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetectDominantLanguageInput {
    /// Consumes the builder and constructs an Operation<[`DetectDominantLanguage`](crate::operation::DetectDominantLanguage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetectDominantLanguage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetectDominantLanguageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetectDominantLanguageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetectDominantLanguageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DetectDominantLanguage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detect_dominant_language(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetectDominantLanguage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetectDominantLanguage",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetectDominantLanguageInput`](crate::input::DetectDominantLanguageInput)
    pub fn builder() -> crate::input::detect_dominant_language_input::Builder {
        crate::input::detect_dominant_language_input::Builder::default()
    }
}

/// See [`DetectEntitiesInput`](crate::input::DetectEntitiesInput)
pub mod detect_entities_input {
    /// A builder for [`DetectEntitiesInput`](crate::input::DetectEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        /// <p>If your request includes the endpoint for a custom entity recognition model, Amazon
        /// Comprehend uses the language of your custom model, and it ignores any language code that you
        /// specify here.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        /// <p>If your request includes the endpoint for a custom entity recognition model, Amazon
        /// Comprehend uses the language of your custom model, and it ignores any language code that you
        /// specify here.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The Amazon Resource Name of an endpoint that is associated with a custom entity
        /// recognition model. Provide an endpoint if you want to detect entities by using your own custom
        /// model instead of the default model that is used by Amazon Comprehend.</p>
        /// <p>If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and
        /// it ignores any language code that you provide in your request.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of an endpoint that is associated with a custom entity
        /// recognition model. Provide an endpoint if you want to detect entities by using your own custom
        /// model instead of the default model that is used by Amazon Comprehend.</p>
        /// <p>If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and
        /// it ignores any language code that you provide in your request.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectEntitiesInput`](crate::input::DetectEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetectEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetectEntitiesInput {
                text: self.text,
                language_code: self.language_code,
                endpoint_arn: self.endpoint_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DetectEntitiesInputOperationOutputAlias = crate::operation::DetectEntities;
#[doc(hidden)]
pub type DetectEntitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetectEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`DetectEntities`](crate::operation::DetectEntities)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetectEntities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetectEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetectEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetectEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DetectEntities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_detect_entities(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetectEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetectEntities",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetectEntitiesInput`](crate::input::DetectEntitiesInput)
    pub fn builder() -> crate::input::detect_entities_input::Builder {
        crate::input::detect_entities_input::Builder::default()
    }
}

/// See [`DetectKeyPhrasesInput`](crate::input::DetectKeyPhrasesInput)
pub mod detect_key_phrases_input {
    /// A builder for [`DetectKeyPhrasesInput`](crate::input::DetectKeyPhrasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
    }
    impl Builder {
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectKeyPhrasesInput`](crate::input::DetectKeyPhrasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetectKeyPhrasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetectKeyPhrasesInput {
                text: self.text,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type DetectKeyPhrasesInputOperationOutputAlias = crate::operation::DetectKeyPhrases;
#[doc(hidden)]
pub type DetectKeyPhrasesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetectKeyPhrasesInput {
    /// Consumes the builder and constructs an Operation<[`DetectKeyPhrases`](crate::operation::DetectKeyPhrases)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetectKeyPhrases,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetectKeyPhrasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetectKeyPhrasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetectKeyPhrasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DetectKeyPhrases",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detect_key_phrases(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetectKeyPhrases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetectKeyPhrases",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetectKeyPhrasesInput`](crate::input::DetectKeyPhrasesInput)
    pub fn builder() -> crate::input::detect_key_phrases_input::Builder {
        crate::input::detect_key_phrases_input::Builder::default()
    }
}

/// See [`DetectPiiEntitiesInput`](crate::input::DetectPiiEntitiesInput)
pub mod detect_pii_entities_input {
    /// A builder for [`DetectPiiEntitiesInput`](crate::input::DetectPiiEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
    }
    impl Builder {
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectPiiEntitiesInput`](crate::input::DetectPiiEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetectPiiEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetectPiiEntitiesInput {
                text: self.text,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type DetectPiiEntitiesInputOperationOutputAlias = crate::operation::DetectPiiEntities;
#[doc(hidden)]
pub type DetectPiiEntitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetectPiiEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`DetectPiiEntities`](crate::operation::DetectPiiEntities)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetectPiiEntities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetectPiiEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetectPiiEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetectPiiEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DetectPiiEntities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detect_pii_entities(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetectPiiEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetectPiiEntities",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetectPiiEntitiesInput`](crate::input::DetectPiiEntitiesInput)
    pub fn builder() -> crate::input::detect_pii_entities_input::Builder {
        crate::input::detect_pii_entities_input::Builder::default()
    }
}

/// See [`DetectSentimentInput`](crate::input::DetectSentimentInput)
pub mod detect_sentiment_input {
    /// A builder for [`DetectSentimentInput`](crate::input::DetectSentimentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
    }
    impl Builder {
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
        /// characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectSentimentInput`](crate::input::DetectSentimentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetectSentimentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetectSentimentInput {
                text: self.text,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type DetectSentimentInputOperationOutputAlias = crate::operation::DetectSentiment;
#[doc(hidden)]
pub type DetectSentimentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetectSentimentInput {
    /// Consumes the builder and constructs an Operation<[`DetectSentiment`](crate::operation::DetectSentiment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetectSentiment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetectSentimentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetectSentimentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetectSentimentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DetectSentiment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detect_sentiment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetectSentiment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetectSentiment",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetectSentimentInput`](crate::input::DetectSentimentInput)
    pub fn builder() -> crate::input::detect_sentiment_input::Builder {
        crate::input::detect_sentiment_input::Builder::default()
    }
}

/// See [`DetectSyntaxInput`](crate::input::DetectSyntaxInput)
pub mod detect_syntax_input {
    /// A builder for [`DetectSyntaxInput`](crate::input::DetectSyntaxInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::SyntaxLanguageCode>,
    }
    impl Builder {
        /// <p>A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF encoded
        /// characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF encoded
        /// characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The language code of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt").</p>
        pub fn language_code(mut self, input: crate::model::SyntaxLanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the input documents. You can specify any of the following languages
        /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
        /// Italian ("it"), or Portuguese ("pt").</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::SyntaxLanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectSyntaxInput`](crate::input::DetectSyntaxInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetectSyntaxInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetectSyntaxInput {
                text: self.text,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type DetectSyntaxInputOperationOutputAlias = crate::operation::DetectSyntax;
#[doc(hidden)]
pub type DetectSyntaxInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetectSyntaxInput {
    /// Consumes the builder and constructs an Operation<[`DetectSyntax`](crate::operation::DetectSyntax)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetectSyntax,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetectSyntaxInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetectSyntaxInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetectSyntaxInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.DetectSyntax",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_detect_syntax(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetectSyntax::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetectSyntax",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetectSyntaxInput`](crate::input::DetectSyntaxInput)
    pub fn builder() -> crate::input::detect_syntax_input::Builder {
        crate::input::detect_syntax_input::Builder::default()
    }
}

/// See [`ListDocumentClassificationJobsInput`](crate::input::ListDocumentClassificationJobsInput)
pub mod list_document_classification_jobs_input {
    /// A builder for [`ListDocumentClassificationJobsInput`](crate::input::ListDocumentClassificationJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::DocumentClassificationJobFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the jobs that are returned. You can filter jobs on their names, status, or the
        /// date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::DocumentClassificationJobFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their names, status, or the
        /// date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DocumentClassificationJobFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDocumentClassificationJobsInput`](crate::input::ListDocumentClassificationJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDocumentClassificationJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDocumentClassificationJobsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDocumentClassificationJobsInputOperationOutputAlias =
    crate::operation::ListDocumentClassificationJobs;
#[doc(hidden)]
pub type ListDocumentClassificationJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDocumentClassificationJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListDocumentClassificationJobs`](crate::operation::ListDocumentClassificationJobs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDocumentClassificationJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDocumentClassificationJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDocumentClassificationJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDocumentClassificationJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListDocumentClassificationJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_document_classification_jobs(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDocumentClassificationJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDocumentClassificationJobs",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDocumentClassificationJobsInput`](crate::input::ListDocumentClassificationJobsInput)
    pub fn builder() -> crate::input::list_document_classification_jobs_input::Builder {
        crate::input::list_document_classification_jobs_input::Builder::default()
    }
}

/// See [`ListDocumentClassifiersInput`](crate::input::ListDocumentClassifiersInput)
pub mod list_document_classifiers_input {
    /// A builder for [`ListDocumentClassifiersInput`](crate::input::ListDocumentClassifiersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::DocumentClassifierFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::DocumentClassifierFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DocumentClassifierFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDocumentClassifiersInput`](crate::input::ListDocumentClassifiersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDocumentClassifiersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDocumentClassifiersInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDocumentClassifiersInputOperationOutputAlias =
    crate::operation::ListDocumentClassifiers;
#[doc(hidden)]
pub type ListDocumentClassifiersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDocumentClassifiersInput {
    /// Consumes the builder and constructs an Operation<[`ListDocumentClassifiers`](crate::operation::ListDocumentClassifiers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDocumentClassifiers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDocumentClassifiersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDocumentClassifiersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDocumentClassifiersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListDocumentClassifiers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_document_classifiers(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDocumentClassifiers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDocumentClassifiers",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDocumentClassifiersInput`](crate::input::ListDocumentClassifiersInput)
    pub fn builder() -> crate::input::list_document_classifiers_input::Builder {
        crate::input::list_document_classifiers_input::Builder::default()
    }
}

/// See [`ListDocumentClassifierSummariesInput`](crate::input::ListDocumentClassifierSummariesInput)
pub mod list_document_classifier_summaries_input {
    /// A builder for [`ListDocumentClassifierSummariesInput`](crate::input::ListDocumentClassifierSummariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDocumentClassifierSummariesInput`](crate::input::ListDocumentClassifierSummariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDocumentClassifierSummariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDocumentClassifierSummariesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDocumentClassifierSummariesInputOperationOutputAlias =
    crate::operation::ListDocumentClassifierSummaries;
#[doc(hidden)]
pub type ListDocumentClassifierSummariesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDocumentClassifierSummariesInput {
    /// Consumes the builder and constructs an Operation<[`ListDocumentClassifierSummaries`](crate::operation::ListDocumentClassifierSummaries)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDocumentClassifierSummaries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDocumentClassifierSummariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDocumentClassifierSummariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDocumentClassifierSummariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListDocumentClassifierSummaries",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_document_classifier_summaries(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDocumentClassifierSummaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDocumentClassifierSummaries",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDocumentClassifierSummariesInput`](crate::input::ListDocumentClassifierSummariesInput)
    pub fn builder() -> crate::input::list_document_classifier_summaries_input::Builder {
        crate::input::list_document_classifier_summaries_input::Builder::default()
    }
}

/// See [`ListDominantLanguageDetectionJobsInput`](crate::input::ListDominantLanguageDetectionJobsInput)
pub mod list_dominant_language_detection_jobs_input {
    /// A builder for [`ListDominantLanguageDetectionJobsInput`](crate::input::ListDominantLanguageDetectionJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::DominantLanguageDetectionJobFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters that jobs that are returned. You can filter jobs on their name, status, or the
        /// date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::DominantLanguageDetectionJobFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters that jobs that are returned. You can filter jobs on their name, status, or the
        /// date and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DominantLanguageDetectionJobFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDominantLanguageDetectionJobsInput`](crate::input::ListDominantLanguageDetectionJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDominantLanguageDetectionJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDominantLanguageDetectionJobsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDominantLanguageDetectionJobsInputOperationOutputAlias =
    crate::operation::ListDominantLanguageDetectionJobs;
#[doc(hidden)]
pub type ListDominantLanguageDetectionJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDominantLanguageDetectionJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListDominantLanguageDetectionJobs`](crate::operation::ListDominantLanguageDetectionJobs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDominantLanguageDetectionJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDominantLanguageDetectionJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDominantLanguageDetectionJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDominantLanguageDetectionJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListDominantLanguageDetectionJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_dominant_language_detection_jobs(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDominantLanguageDetectionJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDominantLanguageDetectionJobs",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDominantLanguageDetectionJobsInput`](crate::input::ListDominantLanguageDetectionJobsInput)
    pub fn builder() -> crate::input::list_dominant_language_detection_jobs_input::Builder {
        crate::input::list_dominant_language_detection_jobs_input::Builder::default()
    }
}

/// See [`ListEndpointsInput`](crate::input::ListEndpointsInput)
pub mod list_endpoints_input {
    /// A builder for [`ListEndpointsInput`](crate::input::ListEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::EndpointFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the endpoints that are returned. You can filter endpoints on their name, model,
        /// status, or the date and time that they were created. You can only set one filter at a time.
        /// </p>
        pub fn filter(mut self, input: crate::model::EndpointFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters the endpoints that are returned. You can filter endpoints on their name, model,
        /// status, or the date and time that they were created. You can only set one filter at a time.
        /// </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EndpointFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEndpointsInput`](crate::input::ListEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEndpointsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEndpointsInputOperationOutputAlias = crate::operation::ListEndpoints;
#[doc(hidden)]
pub type ListEndpointsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`ListEndpoints`](crate::operation::ListEndpoints)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEndpoints,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEndpointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEndpointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEndpointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListEndpoints",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_endpoints(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEndpoints",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEndpointsInput`](crate::input::ListEndpointsInput)
    pub fn builder() -> crate::input::list_endpoints_input::Builder {
        crate::input::list_endpoints_input::Builder::default()
    }
}

/// See [`ListEntitiesDetectionJobsInput`](crate::input::ListEntitiesDetectionJobsInput)
pub mod list_entities_detection_jobs_input {
    /// A builder for [`ListEntitiesDetectionJobsInput`](crate::input::ListEntitiesDetectionJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::EntitiesDetectionJobFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::EntitiesDetectionJobFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EntitiesDetectionJobFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntitiesDetectionJobsInput`](crate::input::ListEntitiesDetectionJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEntitiesDetectionJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEntitiesDetectionJobsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEntitiesDetectionJobsInputOperationOutputAlias =
    crate::operation::ListEntitiesDetectionJobs;
#[doc(hidden)]
pub type ListEntitiesDetectionJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEntitiesDetectionJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListEntitiesDetectionJobs`](crate::operation::ListEntitiesDetectionJobs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEntitiesDetectionJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEntitiesDetectionJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEntitiesDetectionJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEntitiesDetectionJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListEntitiesDetectionJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_entities_detection_jobs(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEntitiesDetectionJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEntitiesDetectionJobs",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEntitiesDetectionJobsInput`](crate::input::ListEntitiesDetectionJobsInput)
    pub fn builder() -> crate::input::list_entities_detection_jobs_input::Builder {
        crate::input::list_entities_detection_jobs_input::Builder::default()
    }
}

/// See [`ListEntityRecognizersInput`](crate::input::ListEntityRecognizersInput)
pub mod list_entity_recognizers_input {
    /// A builder for [`ListEntityRecognizersInput`](crate::input::ListEntityRecognizersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::EntityRecognizerFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the list of entities returned. You can filter on <code>Status</code>,
        /// <code>SubmitTimeBefore</code>, or <code>SubmitTimeAfter</code>. You can only set one filter
        /// at a time.</p>
        pub fn filter(mut self, input: crate::model::EntityRecognizerFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters the list of entities returned. You can filter on <code>Status</code>,
        /// <code>SubmitTimeBefore</code>, or <code>SubmitTimeAfter</code>. You can only set one filter
        /// at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EntityRecognizerFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of results to return on each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of results to return on each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntityRecognizersInput`](crate::input::ListEntityRecognizersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEntityRecognizersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEntityRecognizersInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEntityRecognizersInputOperationOutputAlias = crate::operation::ListEntityRecognizers;
#[doc(hidden)]
pub type ListEntityRecognizersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEntityRecognizersInput {
    /// Consumes the builder and constructs an Operation<[`ListEntityRecognizers`](crate::operation::ListEntityRecognizers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEntityRecognizers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEntityRecognizersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEntityRecognizersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEntityRecognizersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListEntityRecognizers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_entity_recognizers(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEntityRecognizers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEntityRecognizers",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEntityRecognizersInput`](crate::input::ListEntityRecognizersInput)
    pub fn builder() -> crate::input::list_entity_recognizers_input::Builder {
        crate::input::list_entity_recognizers_input::Builder::default()
    }
}

/// See [`ListEntityRecognizerSummariesInput`](crate::input::ListEntityRecognizerSummariesInput)
pub mod list_entity_recognizer_summaries_input {
    /// A builder for [`ListEntityRecognizerSummariesInput`](crate::input::ListEntityRecognizerSummariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return on each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntityRecognizerSummariesInput`](crate::input::ListEntityRecognizerSummariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEntityRecognizerSummariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEntityRecognizerSummariesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEntityRecognizerSummariesInputOperationOutputAlias =
    crate::operation::ListEntityRecognizerSummaries;
#[doc(hidden)]
pub type ListEntityRecognizerSummariesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEntityRecognizerSummariesInput {
    /// Consumes the builder and constructs an Operation<[`ListEntityRecognizerSummaries`](crate::operation::ListEntityRecognizerSummaries)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEntityRecognizerSummaries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEntityRecognizerSummariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEntityRecognizerSummariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEntityRecognizerSummariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListEntityRecognizerSummaries",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_entity_recognizer_summaries(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEntityRecognizerSummaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEntityRecognizerSummaries",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEntityRecognizerSummariesInput`](crate::input::ListEntityRecognizerSummariesInput)
    pub fn builder() -> crate::input::list_entity_recognizer_summaries_input::Builder {
        crate::input::list_entity_recognizer_summaries_input::Builder::default()
    }
}

/// See [`ListEventsDetectionJobsInput`](crate::input::ListEventsDetectionJobsInput)
pub mod list_events_detection_jobs_input {
    /// A builder for [`ListEventsDetectionJobsInput`](crate::input::ListEventsDetectionJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::EventsDetectionJobFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::EventsDetectionJobFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EventsDetectionJobFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventsDetectionJobsInput`](crate::input::ListEventsDetectionJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEventsDetectionJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEventsDetectionJobsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEventsDetectionJobsInputOperationOutputAlias =
    crate::operation::ListEventsDetectionJobs;
#[doc(hidden)]
pub type ListEventsDetectionJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEventsDetectionJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListEventsDetectionJobs`](crate::operation::ListEventsDetectionJobs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEventsDetectionJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEventsDetectionJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEventsDetectionJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEventsDetectionJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListEventsDetectionJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_events_detection_jobs(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEventsDetectionJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEventsDetectionJobs",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEventsDetectionJobsInput`](crate::input::ListEventsDetectionJobsInput)
    pub fn builder() -> crate::input::list_events_detection_jobs_input::Builder {
        crate::input::list_events_detection_jobs_input::Builder::default()
    }
}

/// See [`ListKeyPhrasesDetectionJobsInput`](crate::input::ListKeyPhrasesDetectionJobsInput)
pub mod list_key_phrases_detection_jobs_input {
    /// A builder for [`ListKeyPhrasesDetectionJobsInput`](crate::input::ListKeyPhrasesDetectionJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::KeyPhrasesDetectionJobFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::KeyPhrasesDetectionJobFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::KeyPhrasesDetectionJobFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListKeyPhrasesDetectionJobsInput`](crate::input::ListKeyPhrasesDetectionJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListKeyPhrasesDetectionJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListKeyPhrasesDetectionJobsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListKeyPhrasesDetectionJobsInputOperationOutputAlias =
    crate::operation::ListKeyPhrasesDetectionJobs;
#[doc(hidden)]
pub type ListKeyPhrasesDetectionJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListKeyPhrasesDetectionJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListKeyPhrasesDetectionJobs`](crate::operation::ListKeyPhrasesDetectionJobs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListKeyPhrasesDetectionJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListKeyPhrasesDetectionJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListKeyPhrasesDetectionJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListKeyPhrasesDetectionJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListKeyPhrasesDetectionJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_key_phrases_detection_jobs(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListKeyPhrasesDetectionJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListKeyPhrasesDetectionJobs",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListKeyPhrasesDetectionJobsInput`](crate::input::ListKeyPhrasesDetectionJobsInput)
    pub fn builder() -> crate::input::list_key_phrases_detection_jobs_input::Builder {
        crate::input::list_key_phrases_detection_jobs_input::Builder::default()
    }
}

/// See [`ListPiiEntitiesDetectionJobsInput`](crate::input::ListPiiEntitiesDetectionJobsInput)
pub mod list_pii_entities_detection_jobs_input {
    /// A builder for [`ListPiiEntitiesDetectionJobsInput`](crate::input::ListPiiEntitiesDetectionJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::PiiEntitiesDetectionJobFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::PiiEntitiesDetectionJobFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::PiiEntitiesDetectionJobFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in each page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPiiEntitiesDetectionJobsInput`](crate::input::ListPiiEntitiesDetectionJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPiiEntitiesDetectionJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPiiEntitiesDetectionJobsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPiiEntitiesDetectionJobsInputOperationOutputAlias =
    crate::operation::ListPiiEntitiesDetectionJobs;
#[doc(hidden)]
pub type ListPiiEntitiesDetectionJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPiiEntitiesDetectionJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListPiiEntitiesDetectionJobs`](crate::operation::ListPiiEntitiesDetectionJobs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPiiEntitiesDetectionJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPiiEntitiesDetectionJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPiiEntitiesDetectionJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPiiEntitiesDetectionJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListPiiEntitiesDetectionJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_pii_entities_detection_jobs(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPiiEntitiesDetectionJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPiiEntitiesDetectionJobs",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPiiEntitiesDetectionJobsInput`](crate::input::ListPiiEntitiesDetectionJobsInput)
    pub fn builder() -> crate::input::list_pii_entities_detection_jobs_input::Builder {
        crate::input::list_pii_entities_detection_jobs_input::Builder::default()
    }
}

/// See [`ListSentimentDetectionJobsInput`](crate::input::ListSentimentDetectionJobsInput)
pub mod list_sentiment_detection_jobs_input {
    /// A builder for [`ListSentimentDetectionJobsInput`](crate::input::ListSentimentDetectionJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::SentimentDetectionJobFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::SentimentDetectionJobFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
        /// and time that they were submitted. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::SentimentDetectionJobFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSentimentDetectionJobsInput`](crate::input::ListSentimentDetectionJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSentimentDetectionJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSentimentDetectionJobsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSentimentDetectionJobsInputOperationOutputAlias =
    crate::operation::ListSentimentDetectionJobs;
#[doc(hidden)]
pub type ListSentimentDetectionJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSentimentDetectionJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListSentimentDetectionJobs`](crate::operation::ListSentimentDetectionJobs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSentimentDetectionJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSentimentDetectionJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSentimentDetectionJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSentimentDetectionJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListSentimentDetectionJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_sentiment_detection_jobs(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSentimentDetectionJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSentimentDetectionJobs",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSentimentDetectionJobsInput`](crate::input::ListSentimentDetectionJobsInput)
    pub fn builder() -> crate::input::list_sentiment_detection_jobs_input::Builder {
        crate::input::list_sentiment_detection_jobs_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you are querying.
        /// </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you are querying.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTopicsDetectionJobsInput`](crate::input::ListTopicsDetectionJobsInput)
pub mod list_topics_detection_jobs_input {
    /// A builder for [`ListTopicsDetectionJobsInput`](crate::input::ListTopicsDetectionJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::TopicsDetectionJobFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Filters the jobs that are returned. Jobs can be filtered on their name, status, or the
        /// date and time that they were submitted. You can set only one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::TopicsDetectionJobFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters the jobs that are returned. Jobs can be filtered on their name, status, or the
        /// date and time that they were submitted. You can set only one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::TopicsDetectionJobFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTopicsDetectionJobsInput`](crate::input::ListTopicsDetectionJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTopicsDetectionJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTopicsDetectionJobsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTopicsDetectionJobsInputOperationOutputAlias =
    crate::operation::ListTopicsDetectionJobs;
#[doc(hidden)]
pub type ListTopicsDetectionJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTopicsDetectionJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListTopicsDetectionJobs`](crate::operation::ListTopicsDetectionJobs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTopicsDetectionJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTopicsDetectionJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTopicsDetectionJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTopicsDetectionJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.ListTopicsDetectionJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_topics_detection_jobs(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTopicsDetectionJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTopicsDetectionJobs",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTopicsDetectionJobsInput`](crate::input::ListTopicsDetectionJobsInput)
    pub fn builder() -> crate::input::list_topics_detection_jobs_input::Builder {
        crate::input::list_topics_detection_jobs_input::Builder::default()
    }
}

/// See [`StartDocumentClassificationJobInput`](crate::input::StartDocumentClassificationJobInput)
pub mod start_document_classification_job_input {
    /// A builder for [`StartDocumentClassificationJobInput`](crate::input::StartDocumentClassificationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) document_classifier_arn: std::option::Option<std::string::String>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the document classifier to use to process the
        /// job.</p>
        pub fn document_classifier_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_classifier_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the document classifier to use to process the
        /// job.</p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_classifier_arn = input;
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your document classification job. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your document classification job. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the document classification job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be associated with the document classification job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDocumentClassificationJobInput`](crate::input::StartDocumentClassificationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDocumentClassificationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDocumentClassificationJobInput {
                job_name: self.job_name,
                document_classifier_arn: self.document_classifier_arn,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                client_request_token: self.client_request_token,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDocumentClassificationJobInputOperationOutputAlias =
    crate::operation::StartDocumentClassificationJob;
#[doc(hidden)]
pub type StartDocumentClassificationJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartDocumentClassificationJobInput {
    /// Consumes the builder and constructs an Operation<[`StartDocumentClassificationJob`](crate::operation::StartDocumentClassificationJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDocumentClassificationJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDocumentClassificationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDocumentClassificationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDocumentClassificationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StartDocumentClassificationJob",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_document_classification_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDocumentClassificationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDocumentClassificationJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDocumentClassificationJobInput`](crate::input::StartDocumentClassificationJobInput)
    pub fn builder() -> crate::input::start_document_classification_job_input::Builder {
        crate::input::start_document_classification_job_input::Builder::default()
    }
}

/// See [`StartDominantLanguageDetectionJobInput`](crate::input::StartDominantLanguageDetectionJobInput)
pub mod start_dominant_language_detection_job_input {
    /// A builder for [`StartDominantLanguageDetectionJobInput`](crate::input::StartDominantLanguageDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>An identifier for the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>An identifier for the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your dominant language detection job. For more information,
        /// see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your dominant language detection job. For more information,
        /// see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the dominant language detection job. A tag is a key-value pair
        /// that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as
        /// the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be associated with the dominant language detection job. A tag is a key-value pair
        /// that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as
        /// the key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDominantLanguageDetectionJobInput`](crate::input::StartDominantLanguageDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDominantLanguageDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDominantLanguageDetectionJobInput {
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                job_name: self.job_name,
                client_request_token: self.client_request_token,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDominantLanguageDetectionJobInputOperationOutputAlias =
    crate::operation::StartDominantLanguageDetectionJob;
#[doc(hidden)]
pub type StartDominantLanguageDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartDominantLanguageDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StartDominantLanguageDetectionJob`](crate::operation::StartDominantLanguageDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDominantLanguageDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDominantLanguageDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDominantLanguageDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDominantLanguageDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StartDominantLanguageDetectionJob",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_dominant_language_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDominantLanguageDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDominantLanguageDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDominantLanguageDetectionJobInput`](crate::input::StartDominantLanguageDetectionJobInput)
    pub fn builder() -> crate::input::start_dominant_language_detection_job_input::Builder {
        crate::input::start_dominant_language_detection_job_input::Builder::default()
    }
}

/// See [`StartEntitiesDetectionJobInput`](crate::input::StartEntitiesDetectionJobInput)
pub mod start_entities_detection_job_input {
    /// A builder for [`StartEntitiesDetectionJobInput`](crate::input::StartEntitiesDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) entity_recognizer_arn: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the specific entity recognizer to be used
        /// by the <code>StartEntitiesDetectionJob</code>. This ARN is optional and is only used for a
        /// custom entity recognition job.</p>
        pub fn entity_recognizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_recognizer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the specific entity recognizer to be used
        /// by the <code>StartEntitiesDetectionJob</code>. This ARN is optional and is only used for a
        /// custom entity recognition job.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entity_recognizer_arn = input;
            self
        }
        /// <p>The language of the input documents. All documents must be in the same language. You can
        /// specify any of the languages supported by Amazon Comprehend. If custom entities recognition is
        /// used, this parameter is ignored and the language used for training the model is used
        /// instead.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents. All documents must be in the same language. You can
        /// specify any of the languages supported by Amazon Comprehend. If custom entities recognition is
        /// used, this parameter is ignored and the language used for training the model is used
        /// instead.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the entities detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be associated with the entities detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartEntitiesDetectionJobInput`](crate::input::StartEntitiesDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartEntitiesDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartEntitiesDetectionJobInput {
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                job_name: self.job_name,
                entity_recognizer_arn: self.entity_recognizer_arn,
                language_code: self.language_code,
                client_request_token: self.client_request_token,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartEntitiesDetectionJobInputOperationOutputAlias =
    crate::operation::StartEntitiesDetectionJob;
#[doc(hidden)]
pub type StartEntitiesDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartEntitiesDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StartEntitiesDetectionJob`](crate::operation::StartEntitiesDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartEntitiesDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartEntitiesDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartEntitiesDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartEntitiesDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StartEntitiesDetectionJob",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_entities_detection_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartEntitiesDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartEntitiesDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartEntitiesDetectionJobInput`](crate::input::StartEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::start_entities_detection_job_input::Builder {
        crate::input::start_entities_detection_job_input::Builder::default()
    }
}

/// See [`StartEventsDetectionJobInput`](crate::input::StartEventsDetectionJobInput)
pub mod start_events_detection_job_input {
    /// A builder for [`StartEventsDetectionJobInput`](crate::input::StartEventsDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) target_event_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>The identifier of the events detection job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The identifier of the events detection job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>An unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>An unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `target_event_types`.
        ///
        /// To override the contents of this collection use [`set_target_event_types`](Self::set_target_event_types).
        ///
        /// <p>The types of events to detect in the input documents.</p>
        pub fn target_event_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_event_types.unwrap_or_default();
            v.push(input.into());
            self.target_event_types = Some(v);
            self
        }
        /// <p>The types of events to detect in the input documents.</p>
        pub fn set_target_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_event_types = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the events detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be associated with the events detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartEventsDetectionJobInput`](crate::input::StartEventsDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartEventsDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartEventsDetectionJobInput {
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                job_name: self.job_name,
                language_code: self.language_code,
                client_request_token: self.client_request_token,
                target_event_types: self.target_event_types,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartEventsDetectionJobInputOperationOutputAlias =
    crate::operation::StartEventsDetectionJob;
#[doc(hidden)]
pub type StartEventsDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartEventsDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StartEventsDetectionJob`](crate::operation::StartEventsDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartEventsDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartEventsDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartEventsDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartEventsDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StartEventsDetectionJob",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_events_detection_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartEventsDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartEventsDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartEventsDetectionJobInput`](crate::input::StartEventsDetectionJobInput)
    pub fn builder() -> crate::input::start_events_detection_job_input::Builder {
        crate::input::start_events_detection_job_input::Builder::default()
    }
}

/// See [`StartKeyPhrasesDetectionJobInput`](crate::input::StartKeyPhrasesDetectionJobInput)
pub mod start_key_phrases_detection_job_input {
    /// A builder for [`StartKeyPhrasesDetectionJobInput`](crate::input::StartKeyPhrasesDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Specifies where to send the output files.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p> Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your key phrases detection job. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p> Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your key phrases detection job. For more information, see
        /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the key phrases detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be associated with the key phrases detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartKeyPhrasesDetectionJobInput`](crate::input::StartKeyPhrasesDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartKeyPhrasesDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartKeyPhrasesDetectionJobInput {
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                job_name: self.job_name,
                language_code: self.language_code,
                client_request_token: self.client_request_token,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartKeyPhrasesDetectionJobInputOperationOutputAlias =
    crate::operation::StartKeyPhrasesDetectionJob;
#[doc(hidden)]
pub type StartKeyPhrasesDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartKeyPhrasesDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StartKeyPhrasesDetectionJob`](crate::operation::StartKeyPhrasesDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartKeyPhrasesDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartKeyPhrasesDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartKeyPhrasesDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartKeyPhrasesDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StartKeyPhrasesDetectionJob",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_key_phrases_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartKeyPhrasesDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartKeyPhrasesDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartKeyPhrasesDetectionJobInput`](crate::input::StartKeyPhrasesDetectionJobInput)
    pub fn builder() -> crate::input::start_key_phrases_detection_job_input::Builder {
        crate::input::start_key_phrases_detection_job_input::Builder::default()
    }
}

/// See [`StartPiiEntitiesDetectionJobInput`](crate::input::StartPiiEntitiesDetectionJobInput)
pub mod start_pii_entities_detection_job_input {
    /// A builder for [`StartPiiEntitiesDetectionJobInput`](crate::input::StartPiiEntitiesDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) mode: std::option::Option<crate::model::PiiEntitiesDetectionMode>,
        pub(crate) redaction_config: std::option::Option<crate::model::RedactionConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The input properties for a PII entities detection job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input properties for a PII entities detection job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Provides conﬁguration parameters for the output of PII entity detection jobs.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Provides conﬁguration parameters for the output of PII entity detection jobs.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in
        /// which PII entities are redacted.</p>
        pub fn mode(mut self, input: crate::model::PiiEntitiesDetectionMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in
        /// which PII entities are redacted.</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::PiiEntitiesDetectionMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// <p>Provides configuration parameters for PII entity redaction.</p>
        /// <p>This parameter is required if you set the <code>Mode</code> parameter to
        /// <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code>
        /// definition that includes the <code>PiiEntityTypes</code> parameter.</p>
        pub fn redaction_config(mut self, input: crate::model::RedactionConfig) -> Self {
            self.redaction_config = Some(input);
            self
        }
        /// <p>Provides configuration parameters for PII entity redaction.</p>
        /// <p>This parameter is required if you set the <code>Mode</code> parameter to
        /// <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code>
        /// definition that includes the <code>PiiEntityTypes</code> parameter.</p>
        pub fn set_redaction_config(
            mut self,
            input: std::option::Option<crate::model::RedactionConfig>,
        ) -> Self {
            self.redaction_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the PII entities detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be associated with the PII entities detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartPiiEntitiesDetectionJobInput`](crate::input::StartPiiEntitiesDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartPiiEntitiesDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartPiiEntitiesDetectionJobInput {
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                mode: self.mode,
                redaction_config: self.redaction_config,
                data_access_role_arn: self.data_access_role_arn,
                job_name: self.job_name,
                language_code: self.language_code,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartPiiEntitiesDetectionJobInputOperationOutputAlias =
    crate::operation::StartPiiEntitiesDetectionJob;
#[doc(hidden)]
pub type StartPiiEntitiesDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartPiiEntitiesDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StartPiiEntitiesDetectionJob`](crate::operation::StartPiiEntitiesDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartPiiEntitiesDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartPiiEntitiesDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartPiiEntitiesDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartPiiEntitiesDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StartPiiEntitiesDetectionJob",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_pii_entities_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartPiiEntitiesDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartPiiEntitiesDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartPiiEntitiesDetectionJobInput`](crate::input::StartPiiEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::start_pii_entities_detection_job_input::Builder {
        crate::input::start_pii_entities_detection_job_input::Builder::default()
    }
}

/// See [`StartSentimentDetectionJobInput`](crate::input::StartSentimentDetectionJobInput)
pub mod start_sentiment_detection_job_input {
    /// A builder for [`StartSentimentDetectionJobInput`](crate::input::StartSentimentDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Specifies where to send the output files. </p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Specifies where to send the output files. </p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language of the input documents. You can specify any of the primary languages
        /// supported by Amazon Comprehend. All documents must be in the same language.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the sentiment detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be associated with the sentiment detection job. A tag is a key-value pair that
        /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
        /// key might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSentimentDetectionJobInput`](crate::input::StartSentimentDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartSentimentDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartSentimentDetectionJobInput {
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                job_name: self.job_name,
                language_code: self.language_code,
                client_request_token: self.client_request_token,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartSentimentDetectionJobInputOperationOutputAlias =
    crate::operation::StartSentimentDetectionJob;
#[doc(hidden)]
pub type StartSentimentDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartSentimentDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StartSentimentDetectionJob`](crate::operation::StartSentimentDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartSentimentDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartSentimentDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartSentimentDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartSentimentDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StartSentimentDetectionJob",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_sentiment_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartSentimentDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartSentimentDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartSentimentDetectionJobInput`](crate::input::StartSentimentDetectionJobInput)
    pub fn builder() -> crate::input::start_sentiment_detection_job_input::Builder {
        crate::input::start_sentiment_detection_job_input::Builder::default()
    }
}

/// See [`StartTopicsDetectionJobInput`](crate::input::StartTopicsDetectionJobInput)
pub mod start_topics_detection_job_input {
    /// A builder for [`StartTopicsDetectionJobInput`](crate::input::StartTopicsDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) number_of_topics: std::option::Option<i32>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and location of the input data for the job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Specifies where to send the output files. The output is a compressed archive with two
        /// files, <code>topic-terms.csv</code> that lists the terms associated with each topic, and
        /// <code>doc-topics.csv</code> that lists the documents associated with each topic</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Specifies where to send the output files. The output is a compressed archive with two
        /// files, <code>topic-terms.csv</code> that lists the terms associated with each topic, and
        /// <code>doc-topics.csv</code> that lists the documents associated with each topic</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role
        /// that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role
        /// that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The identifier of the job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The number of topics to detect.</p>
        pub fn number_of_topics(mut self, input: i32) -> Self {
            self.number_of_topics = Some(input);
            self
        }
        /// <p>The number of topics to detect.</p>
        pub fn set_number_of_topics(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_topics = input;
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
        /// Comprehend generates one.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
        /// data on the storage volume attached to the ML compute instance(s) that process the analysis
        /// job. The VolumeKmsKeyId can be either of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Amazon Resource Name (ARN) of a KMS Key:
        /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
        /// the resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
        /// VPC</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the topics detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be associated with the topics detection job. A tag is a key-value pair that adds
        /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
        /// might be added to a resource to indicate its use by the sales department.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTopicsDetectionJobInput`](crate::input::StartTopicsDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartTopicsDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartTopicsDetectionJobInput {
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                job_name: self.job_name,
                number_of_topics: self.number_of_topics,
                client_request_token: self.client_request_token,
                volume_kms_key_id: self.volume_kms_key_id,
                vpc_config: self.vpc_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartTopicsDetectionJobInputOperationOutputAlias =
    crate::operation::StartTopicsDetectionJob;
#[doc(hidden)]
pub type StartTopicsDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartTopicsDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StartTopicsDetectionJob`](crate::operation::StartTopicsDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartTopicsDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartTopicsDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartTopicsDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartTopicsDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StartTopicsDetectionJob",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_topics_detection_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartTopicsDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartTopicsDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartTopicsDetectionJobInput`](crate::input::StartTopicsDetectionJobInput)
    pub fn builder() -> crate::input::start_topics_detection_job_input::Builder {
        crate::input::start_topics_detection_job_input::Builder::default()
    }
}

/// See [`StopDominantLanguageDetectionJobInput`](crate::input::StopDominantLanguageDetectionJobInput)
pub mod stop_dominant_language_detection_job_input {
    /// A builder for [`StopDominantLanguageDetectionJobInput`](crate::input::StopDominantLanguageDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the dominant language detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the dominant language detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDominantLanguageDetectionJobInput`](crate::input::StopDominantLanguageDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopDominantLanguageDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopDominantLanguageDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopDominantLanguageDetectionJobInputOperationOutputAlias =
    crate::operation::StopDominantLanguageDetectionJob;
#[doc(hidden)]
pub type StopDominantLanguageDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopDominantLanguageDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StopDominantLanguageDetectionJob`](crate::operation::StopDominantLanguageDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopDominantLanguageDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopDominantLanguageDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopDominantLanguageDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopDominantLanguageDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StopDominantLanguageDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_dominant_language_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopDominantLanguageDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopDominantLanguageDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopDominantLanguageDetectionJobInput`](crate::input::StopDominantLanguageDetectionJobInput)
    pub fn builder() -> crate::input::stop_dominant_language_detection_job_input::Builder {
        crate::input::stop_dominant_language_detection_job_input::Builder::default()
    }
}

/// See [`StopEntitiesDetectionJobInput`](crate::input::StopEntitiesDetectionJobInput)
pub mod stop_entities_detection_job_input {
    /// A builder for [`StopEntitiesDetectionJobInput`](crate::input::StopEntitiesDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the entities detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the entities detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopEntitiesDetectionJobInput`](crate::input::StopEntitiesDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopEntitiesDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopEntitiesDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopEntitiesDetectionJobInputOperationOutputAlias =
    crate::operation::StopEntitiesDetectionJob;
#[doc(hidden)]
pub type StopEntitiesDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopEntitiesDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StopEntitiesDetectionJob`](crate::operation::StopEntitiesDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopEntitiesDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopEntitiesDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopEntitiesDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopEntitiesDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StopEntitiesDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_entities_detection_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopEntitiesDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopEntitiesDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopEntitiesDetectionJobInput`](crate::input::StopEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::stop_entities_detection_job_input::Builder {
        crate::input::stop_entities_detection_job_input::Builder::default()
    }
}

/// See [`StopEventsDetectionJobInput`](crate::input::StopEventsDetectionJobInput)
pub mod stop_events_detection_job_input {
    /// A builder for [`StopEventsDetectionJobInput`](crate::input::StopEventsDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the events detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the events detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopEventsDetectionJobInput`](crate::input::StopEventsDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopEventsDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopEventsDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopEventsDetectionJobInputOperationOutputAlias = crate::operation::StopEventsDetectionJob;
#[doc(hidden)]
pub type StopEventsDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopEventsDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StopEventsDetectionJob`](crate::operation::StopEventsDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopEventsDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopEventsDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopEventsDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopEventsDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StopEventsDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_events_detection_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopEventsDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopEventsDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopEventsDetectionJobInput`](crate::input::StopEventsDetectionJobInput)
    pub fn builder() -> crate::input::stop_events_detection_job_input::Builder {
        crate::input::stop_events_detection_job_input::Builder::default()
    }
}

/// See [`StopKeyPhrasesDetectionJobInput`](crate::input::StopKeyPhrasesDetectionJobInput)
pub mod stop_key_phrases_detection_job_input {
    /// A builder for [`StopKeyPhrasesDetectionJobInput`](crate::input::StopKeyPhrasesDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the key phrases detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the key phrases detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopKeyPhrasesDetectionJobInput`](crate::input::StopKeyPhrasesDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopKeyPhrasesDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopKeyPhrasesDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopKeyPhrasesDetectionJobInputOperationOutputAlias =
    crate::operation::StopKeyPhrasesDetectionJob;
#[doc(hidden)]
pub type StopKeyPhrasesDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopKeyPhrasesDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StopKeyPhrasesDetectionJob`](crate::operation::StopKeyPhrasesDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopKeyPhrasesDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopKeyPhrasesDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopKeyPhrasesDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopKeyPhrasesDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StopKeyPhrasesDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_key_phrases_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopKeyPhrasesDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopKeyPhrasesDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopKeyPhrasesDetectionJobInput`](crate::input::StopKeyPhrasesDetectionJobInput)
    pub fn builder() -> crate::input::stop_key_phrases_detection_job_input::Builder {
        crate::input::stop_key_phrases_detection_job_input::Builder::default()
    }
}

/// See [`StopPiiEntitiesDetectionJobInput`](crate::input::StopPiiEntitiesDetectionJobInput)
pub mod stop_pii_entities_detection_job_input {
    /// A builder for [`StopPiiEntitiesDetectionJobInput`](crate::input::StopPiiEntitiesDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the PII entities detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the PII entities detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopPiiEntitiesDetectionJobInput`](crate::input::StopPiiEntitiesDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopPiiEntitiesDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopPiiEntitiesDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopPiiEntitiesDetectionJobInputOperationOutputAlias =
    crate::operation::StopPiiEntitiesDetectionJob;
#[doc(hidden)]
pub type StopPiiEntitiesDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopPiiEntitiesDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StopPiiEntitiesDetectionJob`](crate::operation::StopPiiEntitiesDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopPiiEntitiesDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopPiiEntitiesDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopPiiEntitiesDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopPiiEntitiesDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StopPiiEntitiesDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_pii_entities_detection_job(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopPiiEntitiesDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopPiiEntitiesDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopPiiEntitiesDetectionJobInput`](crate::input::StopPiiEntitiesDetectionJobInput)
    pub fn builder() -> crate::input::stop_pii_entities_detection_job_input::Builder {
        crate::input::stop_pii_entities_detection_job_input::Builder::default()
    }
}

/// See [`StopSentimentDetectionJobInput`](crate::input::StopSentimentDetectionJobInput)
pub mod stop_sentiment_detection_job_input {
    /// A builder for [`StopSentimentDetectionJobInput`](crate::input::StopSentimentDetectionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the sentiment detection job to stop.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the sentiment detection job to stop.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopSentimentDetectionJobInput`](crate::input::StopSentimentDetectionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopSentimentDetectionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopSentimentDetectionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopSentimentDetectionJobInputOperationOutputAlias =
    crate::operation::StopSentimentDetectionJob;
#[doc(hidden)]
pub type StopSentimentDetectionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopSentimentDetectionJobInput {
    /// Consumes the builder and constructs an Operation<[`StopSentimentDetectionJob`](crate::operation::StopSentimentDetectionJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopSentimentDetectionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopSentimentDetectionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopSentimentDetectionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopSentimentDetectionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StopSentimentDetectionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_sentiment_detection_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopSentimentDetectionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopSentimentDetectionJob",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopSentimentDetectionJobInput`](crate::input::StopSentimentDetectionJobInput)
    pub fn builder() -> crate::input::stop_sentiment_detection_job_input::Builder {
        crate::input::stop_sentiment_detection_job_input::Builder::default()
    }
}

/// See [`StopTrainingDocumentClassifierInput`](crate::input::StopTrainingDocumentClassifierInput)
pub mod stop_training_document_classifier_input {
    /// A builder for [`StopTrainingDocumentClassifierInput`](crate::input::StopTrainingDocumentClassifierInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_classifier_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier currently being
        /// trained.</p>
        pub fn document_classifier_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_classifier_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the document classifier currently being
        /// trained.</p>
        pub fn set_document_classifier_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_classifier_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopTrainingDocumentClassifierInput`](crate::input::StopTrainingDocumentClassifierInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopTrainingDocumentClassifierInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopTrainingDocumentClassifierInput {
                document_classifier_arn: self.document_classifier_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type StopTrainingDocumentClassifierInputOperationOutputAlias =
    crate::operation::StopTrainingDocumentClassifier;
#[doc(hidden)]
pub type StopTrainingDocumentClassifierInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopTrainingDocumentClassifierInput {
    /// Consumes the builder and constructs an Operation<[`StopTrainingDocumentClassifier`](crate::operation::StopTrainingDocumentClassifier)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopTrainingDocumentClassifier,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopTrainingDocumentClassifierInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopTrainingDocumentClassifierInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopTrainingDocumentClassifierInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StopTrainingDocumentClassifier",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_training_document_classifier(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopTrainingDocumentClassifier::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopTrainingDocumentClassifier",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopTrainingDocumentClassifierInput`](crate::input::StopTrainingDocumentClassifierInput)
    pub fn builder() -> crate::input::stop_training_document_classifier_input::Builder {
        crate::input::stop_training_document_classifier_input::Builder::default()
    }
}

/// See [`StopTrainingEntityRecognizerInput`](crate::input::StopTrainingEntityRecognizerInput)
pub mod stop_training_entity_recognizer_input {
    /// A builder for [`StopTrainingEntityRecognizerInput`](crate::input::StopTrainingEntityRecognizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_recognizer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer currently being
        /// trained.</p>
        pub fn entity_recognizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_recognizer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer currently being
        /// trained.</p>
        pub fn set_entity_recognizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entity_recognizer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopTrainingEntityRecognizerInput`](crate::input::StopTrainingEntityRecognizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopTrainingEntityRecognizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopTrainingEntityRecognizerInput {
                entity_recognizer_arn: self.entity_recognizer_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type StopTrainingEntityRecognizerInputOperationOutputAlias =
    crate::operation::StopTrainingEntityRecognizer;
#[doc(hidden)]
pub type StopTrainingEntityRecognizerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopTrainingEntityRecognizerInput {
    /// Consumes the builder and constructs an Operation<[`StopTrainingEntityRecognizer`](crate::operation::StopTrainingEntityRecognizer)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopTrainingEntityRecognizer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopTrainingEntityRecognizerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopTrainingEntityRecognizerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopTrainingEntityRecognizerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.StopTrainingEntityRecognizer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_training_entity_recognizer(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopTrainingEntityRecognizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopTrainingEntityRecognizer",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopTrainingEntityRecognizerInput`](crate::input::StopTrainingEntityRecognizerInput)
    pub fn builder() -> crate::input::stop_training_entity_recognizer_input::Builder {
        crate::input::stop_training_entity_recognizer_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource to which you want
        /// to associate the tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource to which you want
        /// to associate the tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags being associated with a specific Amazon Comprehend resource. There can be a maximum
        /// of 50 tags (both existing and pending) associated with a specific resource. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags being associated with a specific Amazon Comprehend resource. There can be a maximum
        /// of 50 tags (both existing and pending) associated with a specific resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the given Amazon Comprehend resource from which you
        /// want to remove the tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the given Amazon Comprehend resource from which you
        /// want to remove the tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The initial part of a key-value pair that forms a tag being removed from a given resource.
        /// For example, a tag with "Sales" as the key might be added to a resource to indicate its use by
        /// the sales department. Keys must be unique and cannot be duplicated for a particular resource.
        /// </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The initial part of a key-value pair that forms a tag being removed from a given resource.
        /// For example, a tag with "Sales" as the key might be added to a resource to indicate its use by
        /// the sales department. Keys must be unique and cannot be duplicated for a particular resource.
        /// </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
pub mod update_endpoint_input {
    /// A builder for [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) desired_model_arn: std::option::Option<std::string::String>,
        pub(crate) desired_inference_units: std::option::Option<i32>,
        pub(crate) desired_data_access_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the endpoint being updated.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the endpoint being updated.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// <p>The ARN of the new model to use when updating an existing endpoint.</p>
        pub fn desired_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.desired_model_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the new model to use when updating an existing endpoint.</p>
        pub fn set_desired_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.desired_model_arn = input;
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint.
        ///
        /// Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn desired_inference_units(mut self, input: i32) -> Self {
            self.desired_inference_units = Some(input);
            self
        }
        /// <p> The desired number of inference units to be used by the model using this endpoint.
        ///
        /// Each inference unit represents of a throughput of 100 characters per second.</p>
        pub fn set_desired_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_inference_units = input;
            self
        }
        /// <p>Data access role ARN to use in case the new model is encrypted with a customer CMK.</p>
        pub fn desired_data_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.desired_data_access_role_arn = Some(input.into());
            self
        }
        /// <p>Data access role ARN to use in case the new model is encrypted with a customer CMK.</p>
        pub fn set_desired_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.desired_data_access_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEndpointInput {
                endpoint_arn: self.endpoint_arn,
                desired_model_arn: self.desired_model_arn,
                desired_inference_units: self.desired_inference_units,
                desired_data_access_role_arn: self.desired_data_access_role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEndpointInputOperationOutputAlias = crate::operation::UpdateEndpoint;
#[doc(hidden)]
pub type UpdateEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateEndpointInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEndpoint`](crate::operation::UpdateEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Comprehend_20171127.UpdateEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_endpoint(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEndpoint",
            "comprehend",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
    pub fn builder() -> crate::input::update_endpoint_input::Builder {
        crate::input::update_endpoint_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEndpointInput {
    /// <p>The Amazon Resource Number (ARN) of the endpoint being updated.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the new model to use when updating an existing endpoint.</p>
    pub desired_model_arn: std::option::Option<std::string::String>,
    /// <p> The desired number of inference units to be used by the model using this endpoint.
    ///
    /// Each inference unit represents of a throughput of 100 characters per second.</p>
    pub desired_inference_units: std::option::Option<i32>,
    /// <p>Data access role ARN to use in case the new model is encrypted with a customer CMK.</p>
    pub desired_data_access_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEndpointInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("desired_model_arn", &self.desired_model_arn);
        formatter.field("desired_inference_units", &self.desired_inference_units);
        formatter.field(
            "desired_data_access_role_arn",
            &self.desired_data_access_role_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the given Amazon Comprehend resource from which you
    /// want to remove the tags. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The initial part of a key-value pair that forms a tag being removed from a given resource.
    /// For example, a tag with "Sales" as the key might be added to a resource to indicate its use by
    /// the sales department. Keys must be unique and cannot be duplicated for a particular resource.
    /// </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource to which you want
    /// to associate the tags. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Tags being associated with a specific Amazon Comprehend resource. There can be a maximum
    /// of 50 tags (both existing and pending) associated with a specific resource. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopTrainingEntityRecognizerInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer currently being
    /// trained.</p>
    pub entity_recognizer_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopTrainingEntityRecognizerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopTrainingEntityRecognizerInput");
        formatter.field("entity_recognizer_arn", &self.entity_recognizer_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopTrainingDocumentClassifierInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the document classifier currently being
    /// trained.</p>
    pub document_classifier_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopTrainingDocumentClassifierInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopTrainingDocumentClassifierInput");
        formatter.field("document_classifier_arn", &self.document_classifier_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopSentimentDetectionJobInput {
    /// <p>The identifier of the sentiment detection job to stop.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopSentimentDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopSentimentDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopPiiEntitiesDetectionJobInput {
    /// <p>The identifier of the PII entities detection job to stop.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopPiiEntitiesDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopPiiEntitiesDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopKeyPhrasesDetectionJobInput {
    /// <p>The identifier of the key phrases detection job to stop.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopKeyPhrasesDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopKeyPhrasesDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopEventsDetectionJobInput {
    /// <p>The identifier of the events detection job to stop.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopEventsDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopEventsDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopEntitiesDetectionJobInput {
    /// <p>The identifier of the entities detection job to stop.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopEntitiesDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopEntitiesDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDominantLanguageDetectionJobInput {
    /// <p>The identifier of the dominant language detection job to stop.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopDominantLanguageDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDominantLanguageDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTopicsDetectionJobInput {
    /// <p>Specifies the format and location of the input data for the job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>Specifies where to send the output files. The output is a compressed archive with two
    /// files, <code>topic-terms.csv</code> that lists the terms associated with each topic, and
    /// <code>doc-topics.csv</code> that lists the documents associated with each topic</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role
    /// that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The number of topics to detect.</p>
    pub number_of_topics: std::option::Option<i32>,
    /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
    /// Comprehend generates one.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
    /// the resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Tags to be associated with the topics detection job. A tag is a key-value pair that adds
    /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
    /// might be added to a resource to indicate its use by the sales department.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for StartTopicsDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTopicsDetectionJobInput");
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("number_of_topics", &self.number_of_topics);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSentimentDetectionJobInput {
    /// <p>Specifies the format and location of the input data for the job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>Specifies where to send the output files. </p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The language of the input documents. You can specify any of the primary languages
    /// supported by Amazon Comprehend. All documents must be in the same language.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
    /// Comprehend generates one.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
    /// the resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Tags to be associated with the sentiment detection job. A tag is a key-value pair that
    /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
    /// key might be added to a resource to indicate its use by the sales department.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for StartSentimentDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSentimentDetectionJobInput");
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("language_code", &self.language_code);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartPiiEntitiesDetectionJobInput {
    /// <p>The input properties for a PII entities detection job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>Provides conﬁguration parameters for the output of PII entity detection jobs.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>Specifies whether the output provides the locations (offsets) of PII entities or a file in
    /// which PII entities are redacted.</p>
    pub mode: std::option::Option<crate::model::PiiEntitiesDetectionMode>,
    /// <p>Provides configuration parameters for PII entity redaction.</p>
    /// <p>This parameter is required if you set the <code>Mode</code> parameter to
    /// <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code>
    /// definition that includes the <code>PiiEntityTypes</code> parameter.</p>
    pub redaction_config: std::option::Option<crate::model::RedactionConfig>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to your input data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The language of the input documents.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
    /// Comprehend generates one.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Tags to be associated with the PII entities detection job. A tag is a key-value pair that
    /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
    /// key might be added to a resource to indicate its use by the sales department.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for StartPiiEntitiesDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartPiiEntitiesDetectionJobInput");
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("mode", &self.mode);
        formatter.field("redaction_config", &self.redaction_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("language_code", &self.language_code);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartKeyPhrasesDetectionJobInput {
    /// <p>Specifies the format and location of the input data for the job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>Specifies where to send the output files.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The language of the input documents. You can specify any of the primary languages
    /// supported by Amazon Comprehend. All documents must be in the same language.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
    /// Comprehend generates one.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p> Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
    /// the resources you are using for your key phrases detection job. For more information, see
    /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Tags to be associated with the key phrases detection job. A tag is a key-value pair that
    /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
    /// key might be added to a resource to indicate its use by the sales department.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for StartKeyPhrasesDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartKeyPhrasesDetectionJobInput");
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("language_code", &self.language_code);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartEventsDetectionJobInput {
    /// <p>Specifies the format and location of the input data for the job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>Specifies where to send the output files.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to your input data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the events detection job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The language code of the input documents.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>An unique identifier for the request. If you don't set the client request token, Amazon
    /// Comprehend generates one.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The types of events to detect in the input documents.</p>
    pub target_event_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Tags to be associated with the events detection job. A tag is a key-value pair that adds
    /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
    /// might be added to a resource to indicate its use by the sales department.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for StartEventsDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartEventsDetectionJobInput");
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("language_code", &self.language_code);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("target_event_types", &self.target_event_types);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartEntitiesDetectionJobInput {
    /// <p>Specifies the format and location of the input data for the job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>Specifies where to send the output files.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that identifies the specific entity recognizer to be used
    /// by the <code>StartEntitiesDetectionJob</code>. This ARN is optional and is only used for a
    /// custom entity recognition job.</p>
    pub entity_recognizer_arn: std::option::Option<std::string::String>,
    /// <p>The language of the input documents. All documents must be in the same language. You can
    /// specify any of the languages supported by Amazon Comprehend. If custom entities recognition is
    /// used, this parameter is ignored and the language used for training the model is used
    /// instead.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
    /// Comprehend generates one.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
    /// the resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Tags to be associated with the entities detection job. A tag is a key-value pair that adds
    /// metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key
    /// might be added to a resource to indicate its use by the sales department.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for StartEntitiesDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartEntitiesDetectionJobInput");
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("entity_recognizer_arn", &self.entity_recognizer_arn);
        formatter.field("language_code", &self.language_code);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDominantLanguageDetectionJobInput {
    /// <p>Specifies the format and location of the input data for the job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>Specifies where to send the output files.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions">https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions</a>.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>An identifier for the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
    /// Comprehend generates one.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
    /// the resources you are using for your dominant language detection job. For more information,
    /// see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Tags to be associated with the dominant language detection job. A tag is a key-value pair
    /// that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as
    /// the key might be added to a resource to indicate its use by the sales department.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for StartDominantLanguageDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDominantLanguageDetectionJobInput");
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("job_name", &self.job_name);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDocumentClassificationJobInput {
    /// <p>The identifier of the job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the document classifier to use to process the
    /// job.</p>
    pub document_classifier_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the format and location of the input data for the job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>Specifies where to send the output files.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to your input data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the request. If you do not set the client request token, Amazon
    /// Comprehend generates one.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
    /// the resources you are using for your document classification job. For more information, see
    /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Tags to be associated with the document classification job. A tag is a key-value pair that
    /// adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
    /// key might be added to a resource to indicate its use by the sales department.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for StartDocumentClassificationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDocumentClassificationJobInput");
        formatter.field("job_name", &self.job_name);
        formatter.field("document_classifier_arn", &self.document_classifier_arn);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTopicsDetectionJobsInput {
    /// <p>Filters the jobs that are returned. Jobs can be filtered on their name, status, or the
    /// date and time that they were submitted. You can set only one filter at a time.</p>
    pub filter: std::option::Option<crate::model::TopicsDetectionJobFilter>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in each page. The default is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListTopicsDetectionJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTopicsDetectionJobsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you are querying.
    /// </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSentimentDetectionJobsInput {
    /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
    /// and time that they were submitted. You can only set one filter at a time.</p>
    pub filter: std::option::Option<crate::model::SentimentDetectionJobFilter>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in each page. The default is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListSentimentDetectionJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSentimentDetectionJobsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPiiEntitiesDetectionJobsInput {
    /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
    /// and time that they were submitted. You can only set one filter at a time.</p>
    pub filter: std::option::Option<crate::model::PiiEntitiesDetectionJobFilter>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in each page.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListPiiEntitiesDetectionJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPiiEntitiesDetectionJobsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListKeyPhrasesDetectionJobsInput {
    /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
    /// and time that they were submitted. You can only set one filter at a time.</p>
    pub filter: std::option::Option<crate::model::KeyPhrasesDetectionJobFilter>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in each page. The default is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListKeyPhrasesDetectionJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListKeyPhrasesDetectionJobsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventsDetectionJobsInput {
    /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
    /// and time that they were submitted. You can only set one filter at a time.</p>
    pub filter: std::option::Option<crate::model::EventsDetectionJobFilter>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in each page.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListEventsDetectionJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventsDetectionJobsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEntityRecognizerSummariesInput {
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return on each page. The default is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListEntityRecognizerSummariesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEntityRecognizerSummariesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEntityRecognizersInput {
    /// <p>Filters the list of entities returned. You can filter on <code>Status</code>,
    /// <code>SubmitTimeBefore</code>, or <code>SubmitTimeAfter</code>. You can only set one filter
    /// at a time.</p>
    pub filter: std::option::Option<crate::model::EntityRecognizerFilter>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of results to return on each page. The default is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListEntityRecognizersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEntityRecognizersInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEntitiesDetectionJobsInput {
    /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
    /// and time that they were submitted. You can only set one filter at a time.</p>
    pub filter: std::option::Option<crate::model::EntitiesDetectionJobFilter>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in each page. The default is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListEntitiesDetectionJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEntitiesDetectionJobsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEndpointsInput {
    /// <p>Filters the endpoints that are returned. You can filter endpoints on their name, model,
    /// status, or the date and time that they were created. You can only set one filter at a time.
    /// </p>
    pub filter: std::option::Option<crate::model::EndpointFilter>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in each page. The default is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListEndpointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEndpointsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDominantLanguageDetectionJobsInput {
    /// <p>Filters that jobs that are returned. You can filter jobs on their name, status, or the
    /// date and time that they were submitted. You can only set one filter at a time.</p>
    pub filter: std::option::Option<crate::model::DominantLanguageDetectionJobFilter>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in each page. The default is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListDominantLanguageDetectionJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDominantLanguageDetectionJobsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDocumentClassifierSummariesInput {
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return on each page. The default is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListDocumentClassifierSummariesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDocumentClassifierSummariesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDocumentClassifiersInput {
    /// <p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date
    /// and time that they were submitted. You can only set one filter at a time.</p>
    pub filter: std::option::Option<crate::model::DocumentClassifierFilter>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in each page. The default is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListDocumentClassifiersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDocumentClassifiersInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDocumentClassificationJobsInput {
    /// <p>Filters the jobs that are returned. You can filter jobs on their names, status, or the
    /// date and time that they were submitted. You can only set one filter at a time.</p>
    pub filter: std::option::Option<crate::model::DocumentClassificationJobFilter>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in each page. The default is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListDocumentClassificationJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDocumentClassificationJobsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectSyntaxInput {
    /// <p>A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF encoded
    /// characters.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The language code of the input documents. You can specify any of the following languages
    /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
    /// Italian ("it"), or Portuguese ("pt").</p>
    pub language_code: std::option::Option<crate::model::SyntaxLanguageCode>,
}
impl std::fmt::Debug for DetectSyntaxInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectSyntaxInput");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectSentimentInput {
    /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
    /// characters.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The language of the input documents. You can specify any of the primary languages
    /// supported by Amazon Comprehend. All documents must be in the same language.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
}
impl std::fmt::Debug for DetectSentimentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectSentimentInput");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectPiiEntitiesInput {
    /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
    /// characters.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The language of the input documents.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
}
impl std::fmt::Debug for DetectPiiEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectPiiEntitiesInput");
        formatter.field("text", &self.text);
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectKeyPhrasesInput {
    /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
    /// characters.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The language of the input documents. You can specify any of the primary languages
    /// supported by Amazon Comprehend. All documents must be in the same language.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
}
impl std::fmt::Debug for DetectKeyPhrasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectKeyPhrasesInput");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectEntitiesInput {
    /// <p>A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded
    /// characters.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The language of the input documents. You can specify any of the primary languages
    /// supported by Amazon Comprehend. All documents must be in the same language.</p>
    /// <p>If your request includes the endpoint for a custom entity recognition model, Amazon
    /// Comprehend uses the language of your custom model, and it ignores any language code that you
    /// specify here.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>The Amazon Resource Name of an endpoint that is associated with a custom entity
    /// recognition model. Provide an endpoint if you want to detect entities by using your own custom
    /// model instead of the default model that is used by Amazon Comprehend.</p>
    /// <p>If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and
    /// it ignores any language code that you provide in your request.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DetectEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectEntitiesInput");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("language_code", &self.language_code);
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectDominantLanguageInput {
    /// <p>A UTF-8 text string. Each string should contain at least 20 characters and must contain
    /// fewer that 5,000 bytes of UTF-8 encoded characters.</p>
    pub text: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DetectDominantLanguageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectDominantLanguageInput");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTopicsDetectionJobInput {
    /// <p>The identifier assigned by the user to the detection job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeTopicsDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTopicsDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSentimentDetectionJobInput {
    /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
    /// response.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeSentimentDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSentimentDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePiiEntitiesDetectionJobInput {
    /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
    /// response.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribePiiEntitiesDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePiiEntitiesDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeKeyPhrasesDetectionJobInput {
    /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
    /// response.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeKeyPhrasesDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeKeyPhrasesDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsDetectionJobInput {
    /// <p>The identifier of the events detection job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEventsDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEntityRecognizerInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
    pub entity_recognizer_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEntityRecognizerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEntityRecognizerInput");
        formatter.field("entity_recognizer_arn", &self.entity_recognizer_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEntitiesDetectionJobInput {
    /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
    /// response.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEntitiesDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEntitiesDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointInput {
    /// <p>The Amazon Resource Number (ARN) of the endpoint being described.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDominantLanguageDetectionJobInput {
    /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
    /// response.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDominantLanguageDetectionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDominantLanguageDetectionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDocumentClassifierInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. The  operation returns this identifier in its
    /// response.</p>
    pub document_classifier_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDocumentClassifierInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDocumentClassifierInput");
        formatter.field("document_classifier_arn", &self.document_classifier_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDocumentClassificationJobInput {
    /// <p>The identifier that Amazon Comprehend generated for the job. The  operation returns this identifier in its
    /// response.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDocumentClassificationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDocumentClassificationJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEntityRecognizerInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>
    pub entity_recognizer_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEntityRecognizerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEntityRecognizerInput");
        formatter.field("entity_recognizer_arn", &self.entity_recognizer_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEndpointInput {
    /// <p>The Amazon Resource Number (ARN) of the endpoint being deleted.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEndpointInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDocumentClassifierInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>
    pub document_classifier_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDocumentClassifierInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDocumentClassifierInput");
        formatter.field("document_classifier_arn", &self.document_classifier_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEntityRecognizerInput {
    /// <p>The name given to the newly created recognizer. Recognizer names can be a maximum of 256
    /// characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name
    /// must be unique in the account/region.</p>
    pub recognizer_name: std::option::Option<std::string::String>,
    /// <p>The version name given to the newly created recognizer.
    /// Version names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed.
    /// The version name must be unique among all models with the same recognizer name in the account/ AWS Region.</p>
    pub version_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
    /// Amazon Comprehend read access to your input data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>Tags to be associated with the entity recognizer being created. A tag is a key-value pair
    /// that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with
    /// "Sales" as the key might be added to a resource to indicate its use by the sales department.
    /// </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Specifies the format and location of the input data. The S3 bucket containing the input
    /// data must be located in the same region as the entity recognizer being created. </p>
    pub input_data_config: std::option::Option<crate::model::EntityRecognizerInputDataConfig>,
    /// <p> A unique identifier for the request. If you don't set the client request token, Amazon
    /// Comprehend generates one.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p> You can specify any of the following languages supported by Amazon Comprehend: English
    /// ("en"), Spanish ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt").
    /// All documents must be in the same language.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
    /// the resources you are using for your custom entity recognizer. For more information, see
    /// <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// trained custom models. The ModelKmsKeyId can be either of the following formats</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub model_kms_key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateEntityRecognizerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEntityRecognizerInput");
        formatter.field("recognizer_name", &self.recognizer_name);
        formatter.field("version_name", &self.version_name);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("language_code", &self.language_code);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("model_kms_key_id", &self.model_kms_key_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEndpointInput {
    /// <p>This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for
    /// all subsequent requests to this resource. </p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Number (ARN) of the model to which the endpoint will be
    /// attached.</p>
    pub model_arn: std::option::Option<std::string::String>,
    /// <p> The desired number of inference units to be used by the model using this endpoint.
    ///
    /// Each inference unit represents of a throughput of 100 characters per second.</p>
    pub desired_inference_units: std::option::Option<i32>,
    /// <p>An idempotency token provided by the customer. If this token matches a previous endpoint
    /// creation request, Amazon Comprehend will not return a <code>ResourceInUseException</code>.
    /// </p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Tags associated with the endpoint being created. A tag is a key-value pair that adds
    /// metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an
    /// endpoint to indicate its use by the sales department. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that
    /// grants Amazon Comprehend read access to trained custom models encrypted with a customer
    /// managed key (ModelKmsKeyId).</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEndpointInput");
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("model_arn", &self.model_arn);
        formatter.field("desired_inference_units", &self.desired_inference_units);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDocumentClassifierInput {
    /// <p>The name of the document classifier.</p>
    pub document_classifier_name: std::option::Option<std::string::String>,
    /// <p>The version name given to the newly created classifier.
    /// Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed.
    /// The version name must be unique among all models with the same classifier name in the account/AWS Region.</p>
    pub version_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants
    /// Amazon Comprehend read access to your input data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>Tags to be associated with the document classifier being created. A tag is a key-value
    /// pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with
    /// "Sales" as the key might be added to a resource to indicate its use by the sales department.
    /// </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Specifies the format and location of the input data for the job.</p>
    pub input_data_config: std::option::Option<crate::model::DocumentClassifierInputDataConfig>,
    /// <p>Enables the addition of output results configuration parameters for custom classifier
    /// jobs.</p>
    pub output_data_config: std::option::Option<crate::model::DocumentClassifierOutputDataConfig>,
    /// <p>A unique identifier for the request. If you don't set the client request token, Amazon
    /// Comprehend generates one.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The language of the input documents. You can specify any of the following languages
    /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
    /// Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// data on the storage volume attached to the ML compute instance(s) that process the analysis
    /// job. The VolumeKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
    /// <p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing
    /// the resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon
    /// VPC</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Indicates the mode in which the classifier will be trained. The classifier can be trained
    /// in multi-class mode, which identifies one and only one class for each document, or multi-label
    /// mode, which identifies one or more labels for each document. In multi-label mode, multiple
    /// labels for an individual document are separated by a delimiter. The default delimiter between
    /// labels is a pipe (|).</p>
    pub mode: std::option::Option<crate::model::DocumentClassifierMode>,
    /// <p>ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
    /// trained custom models. The ModelKmsKeyId can be either of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Amazon Resource Name (ARN) of a KMS Key:
    /// <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub model_kms_key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateDocumentClassifierInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDocumentClassifierInput");
        formatter.field("document_classifier_name", &self.document_classifier_name);
        formatter.field("version_name", &self.version_name);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("language_code", &self.language_code);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("mode", &self.mode);
        formatter.field("model_kms_key_id", &self.model_kms_key_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainsPiiEntitiesInput {
    /// <p>Creates a new document classification request to analyze a single document in real-time,
    /// returning personally identifiable information (PII) entity labels.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The language of the input documents.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
}
impl std::fmt::Debug for ContainsPiiEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainsPiiEntitiesInput");
        formatter.field("text", &self.text);
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClassifyDocumentInput {
    /// <p>The document text to be analyzed.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Number (ARN) of the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClassifyDocumentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClassifyDocumentInput");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetectSyntaxInput {
    /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
    /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
    /// characters.</p>
    pub text_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The language of the input documents. You can specify any of the following languages
    /// supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"),
    /// Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>
    pub language_code: std::option::Option<crate::model::SyntaxLanguageCode>,
}
impl std::fmt::Debug for BatchDetectSyntaxInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetectSyntaxInput");
        formatter.field("text_list", &"*** Sensitive Data Redacted ***");
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetectSentimentInput {
    /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
    /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
    /// characters.</p>
    pub text_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The language of the input documents. You can specify any of the primary languages
    /// supported by Amazon Comprehend. All documents must be in the same language.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
}
impl std::fmt::Debug for BatchDetectSentimentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetectSentimentInput");
        formatter.field("text_list", &"*** Sensitive Data Redacted ***");
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetectKeyPhrasesInput {
    /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
    /// documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded
    /// characters.</p>
    pub text_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The language of the input documents. You can specify any of the primary languages
    /// supported by Amazon Comprehend. All documents must be in the same language.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
}
impl std::fmt::Debug for BatchDetectKeyPhrasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetectKeyPhrasesInput");
        formatter.field("text_list", &"*** Sensitive Data Redacted ***");
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetectEntitiesInput {
    /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
    /// documents. Each document must contain fewer than 5,000 bytes of UTF-8 encoded
    /// characters.</p>
    pub text_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The language of the input documents. You can specify any of the primary languages
    /// supported by Amazon Comprehend. All documents must be in the same language.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
}
impl std::fmt::Debug for BatchDetectEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetectEntitiesInput");
        formatter.field("text_list", &"*** Sensitive Data Redacted ***");
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDetectDominantLanguageInput {
    /// <p>A list containing the text of the input documents. The list can contain a maximum of 25
    /// documents. Each document should contain at least 20 characters and must contain fewer than
    /// 5,000 bytes of UTF-8 encoded characters.</p>
    pub text_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchDetectDominantLanguageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDetectDominantLanguageInput");
        formatter.field("text_list", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
