// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Returned for a successful UpdateRecordsRequest.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecordsOutput {
    /// A list of records that have been updated.
    pub records: std::option::Option<std::vec::Vec<crate::model::Record>>,
}
impl UpdateRecordsOutput {
    /// A list of records that have been updated.
    pub fn records(&self) -> std::option::Option<&[crate::model::Record]> {
        self.records.as_deref()
    }
}
impl std::fmt::Debug for UpdateRecordsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecordsOutput");
        formatter.field("records", &self.records);
        formatter.finish()
    }
}
/// See [`UpdateRecordsOutput`](crate::output::UpdateRecordsOutput)
pub mod update_records_output {
    /// A builder for [`UpdateRecordsOutput`](crate::output::UpdateRecordsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) records: std::option::Option<std::vec::Vec<crate::model::Record>>,
    }
    impl Builder {
        /// Appends an item to `records`.
        ///
        /// To override the contents of this collection use [`set_records`](Self::set_records).
        ///
        /// A list of records that have been updated.
        pub fn records(mut self, input: crate::model::Record) -> Self {
            let mut v = self.records.unwrap_or_default();
            v.push(input);
            self.records = Some(v);
            self
        }
        /// A list of records that have been updated.
        pub fn set_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Record>>,
        ) -> Self {
            self.records = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecordsOutput`](crate::output::UpdateRecordsOutput)
        pub fn build(self) -> crate::output::UpdateRecordsOutput {
            crate::output::UpdateRecordsOutput {
                records: self.records,
            }
        }
    }
}
impl UpdateRecordsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRecordsOutput`](crate::output::UpdateRecordsOutput)
    pub fn builder() -> crate::output::update_records_output::Builder {
        crate::output::update_records_output::Builder::default()
    }
}

/// <p>Response to an UnsubscribeFromDataset request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsubscribeFromDatasetOutput {}
impl std::fmt::Debug for UnsubscribeFromDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsubscribeFromDatasetOutput");
        formatter.finish()
    }
}
/// See [`UnsubscribeFromDatasetOutput`](crate::output::UnsubscribeFromDatasetOutput)
pub mod unsubscribe_from_dataset_output {
    /// A builder for [`UnsubscribeFromDatasetOutput`](crate::output::UnsubscribeFromDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UnsubscribeFromDatasetOutput`](crate::output::UnsubscribeFromDatasetOutput)
        pub fn build(self) -> crate::output::UnsubscribeFromDatasetOutput {
            crate::output::UnsubscribeFromDatasetOutput {}
        }
    }
}
impl UnsubscribeFromDatasetOutput {
    /// Creates a new builder-style object to manufacture [`UnsubscribeFromDatasetOutput`](crate::output::UnsubscribeFromDatasetOutput)
    pub fn builder() -> crate::output::unsubscribe_from_dataset_output::Builder {
        crate::output::unsubscribe_from_dataset_output::Builder::default()
    }
}

/// <p>Response to a SubscribeToDataset request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscribeToDatasetOutput {}
impl std::fmt::Debug for SubscribeToDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscribeToDatasetOutput");
        formatter.finish()
    }
}
/// See [`SubscribeToDatasetOutput`](crate::output::SubscribeToDatasetOutput)
pub mod subscribe_to_dataset_output {
    /// A builder for [`SubscribeToDatasetOutput`](crate::output::SubscribeToDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SubscribeToDatasetOutput`](crate::output::SubscribeToDatasetOutput)
        pub fn build(self) -> crate::output::SubscribeToDatasetOutput {
            crate::output::SubscribeToDatasetOutput {}
        }
    }
}
impl SubscribeToDatasetOutput {
    /// Creates a new builder-style object to manufacture [`SubscribeToDatasetOutput`](crate::output::SubscribeToDatasetOutput)
    pub fn builder() -> crate::output::subscribe_to_dataset_output::Builder {
        crate::output::subscribe_to_dataset_output::Builder::default()
    }
}

/// <p>The output for the SetIdentityPoolConfiguration operation</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityPoolConfigurationOutput {
    /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>Options to apply to this identity pool for push synchronization.</p>
    pub push_sync: std::option::Option<crate::model::PushSync>,
    /// Options to apply to this identity pool for Amazon Cognito streams.
    pub cognito_streams: std::option::Option<crate::model::CognitoStreams>,
}
impl SetIdentityPoolConfigurationOutput {
    /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>Options to apply to this identity pool for push synchronization.</p>
    pub fn push_sync(&self) -> std::option::Option<&crate::model::PushSync> {
        self.push_sync.as_ref()
    }
    /// Options to apply to this identity pool for Amazon Cognito streams.
    pub fn cognito_streams(&self) -> std::option::Option<&crate::model::CognitoStreams> {
        self.cognito_streams.as_ref()
    }
}
impl std::fmt::Debug for SetIdentityPoolConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityPoolConfigurationOutput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("push_sync", &self.push_sync);
        formatter.field("cognito_streams", &self.cognito_streams);
        formatter.finish()
    }
}
/// See [`SetIdentityPoolConfigurationOutput`](crate::output::SetIdentityPoolConfigurationOutput)
pub mod set_identity_pool_configuration_output {
    /// A builder for [`SetIdentityPoolConfigurationOutput`](crate::output::SetIdentityPoolConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) push_sync: std::option::Option<crate::model::PushSync>,
        pub(crate) cognito_streams: std::option::Option<crate::model::CognitoStreams>,
    }
    impl Builder {
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>Options to apply to this identity pool for push synchronization.</p>
        pub fn push_sync(mut self, input: crate::model::PushSync) -> Self {
            self.push_sync = Some(input);
            self
        }
        /// <p>Options to apply to this identity pool for push synchronization.</p>
        pub fn set_push_sync(mut self, input: std::option::Option<crate::model::PushSync>) -> Self {
            self.push_sync = input;
            self
        }
        /// Options to apply to this identity pool for Amazon Cognito streams.
        pub fn cognito_streams(mut self, input: crate::model::CognitoStreams) -> Self {
            self.cognito_streams = Some(input);
            self
        }
        /// Options to apply to this identity pool for Amazon Cognito streams.
        pub fn set_cognito_streams(
            mut self,
            input: std::option::Option<crate::model::CognitoStreams>,
        ) -> Self {
            self.cognito_streams = input;
            self
        }
        /// Consumes the builder and constructs a [`SetIdentityPoolConfigurationOutput`](crate::output::SetIdentityPoolConfigurationOutput)
        pub fn build(self) -> crate::output::SetIdentityPoolConfigurationOutput {
            crate::output::SetIdentityPoolConfigurationOutput {
                identity_pool_id: self.identity_pool_id,
                push_sync: self.push_sync,
                cognito_streams: self.cognito_streams,
            }
        }
    }
}
impl SetIdentityPoolConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`SetIdentityPoolConfigurationOutput`](crate::output::SetIdentityPoolConfigurationOutput)
    pub fn builder() -> crate::output::set_identity_pool_configuration_output::Builder {
        crate::output::set_identity_pool_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetCognitoEventsOutput {}
impl std::fmt::Debug for SetCognitoEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetCognitoEventsOutput");
        formatter.finish()
    }
}
/// See [`SetCognitoEventsOutput`](crate::output::SetCognitoEventsOutput)
pub mod set_cognito_events_output {
    /// A builder for [`SetCognitoEventsOutput`](crate::output::SetCognitoEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetCognitoEventsOutput`](crate::output::SetCognitoEventsOutput)
        pub fn build(self) -> crate::output::SetCognitoEventsOutput {
            crate::output::SetCognitoEventsOutput {}
        }
    }
}
impl SetCognitoEventsOutput {
    /// Creates a new builder-style object to manufacture [`SetCognitoEventsOutput`](crate::output::SetCognitoEventsOutput)
    pub fn builder() -> crate::output::set_cognito_events_output::Builder {
        crate::output::set_cognito_events_output::Builder::default()
    }
}

/// <p>Response to a RegisterDevice request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterDeviceOutput {
    /// <p>The unique ID generated for this device by Cognito.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl RegisterDeviceOutput {
    /// <p>The unique ID generated for this device by Cognito.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterDeviceOutput");
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}
/// See [`RegisterDeviceOutput`](crate::output::RegisterDeviceOutput)
pub mod register_device_output {
    /// A builder for [`RegisterDeviceOutput`](crate::output::RegisterDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterDeviceOutput`](crate::output::RegisterDeviceOutput)
        pub fn build(self) -> crate::output::RegisterDeviceOutput {
            crate::output::RegisterDeviceOutput {
                device_id: self.device_id,
            }
        }
    }
}
impl RegisterDeviceOutput {
    /// Creates a new builder-style object to manufacture [`RegisterDeviceOutput`](crate::output::RegisterDeviceOutput)
    pub fn builder() -> crate::output::register_device_output::Builder {
        crate::output::register_device_output::Builder::default()
    }
}

/// Returned for a successful ListRecordsRequest.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecordsOutput {
    /// A list of all records.
    pub records: std::option::Option<std::vec::Vec<crate::model::Record>>,
    /// A pagination token for obtaining the next page of results.
    pub next_token: std::option::Option<std::string::String>,
    /// Total number of records.
    pub count: i32,
    /// Server sync count for this dataset.
    pub dataset_sync_count: std::option::Option<i64>,
    /// The user/device that made the last change to this record.
    pub last_modified_by: std::option::Option<std::string::String>,
    /// Names of merged datasets.
    pub merged_dataset_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Indicates whether the dataset exists.
    pub dataset_exists: bool,
    /// A boolean value specifying whether to delete the dataset locally.
    pub dataset_deleted_after_requested_sync_count: bool,
    /// A token containing a session ID, identity ID, and expiration.
    pub sync_session_token: std::option::Option<std::string::String>,
}
impl ListRecordsOutput {
    /// A list of all records.
    pub fn records(&self) -> std::option::Option<&[crate::model::Record]> {
        self.records.as_deref()
    }
    /// A pagination token for obtaining the next page of results.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// Total number of records.
    pub fn count(&self) -> i32 {
        self.count
    }
    /// Server sync count for this dataset.
    pub fn dataset_sync_count(&self) -> std::option::Option<i64> {
        self.dataset_sync_count
    }
    /// The user/device that made the last change to this record.
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// Names of merged datasets.
    pub fn merged_dataset_names(&self) -> std::option::Option<&[std::string::String]> {
        self.merged_dataset_names.as_deref()
    }
    /// Indicates whether the dataset exists.
    pub fn dataset_exists(&self) -> bool {
        self.dataset_exists
    }
    /// A boolean value specifying whether to delete the dataset locally.
    pub fn dataset_deleted_after_requested_sync_count(&self) -> bool {
        self.dataset_deleted_after_requested_sync_count
    }
    /// A token containing a session ID, identity ID, and expiration.
    pub fn sync_session_token(&self) -> std::option::Option<&str> {
        self.sync_session_token.as_deref()
    }
}
impl std::fmt::Debug for ListRecordsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecordsOutput");
        formatter.field("records", &self.records);
        formatter.field("next_token", &self.next_token);
        formatter.field("count", &self.count);
        formatter.field("dataset_sync_count", &self.dataset_sync_count);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("merged_dataset_names", &self.merged_dataset_names);
        formatter.field("dataset_exists", &self.dataset_exists);
        formatter.field(
            "dataset_deleted_after_requested_sync_count",
            &self.dataset_deleted_after_requested_sync_count,
        );
        formatter.field("sync_session_token", &self.sync_session_token);
        formatter.finish()
    }
}
/// See [`ListRecordsOutput`](crate::output::ListRecordsOutput)
pub mod list_records_output {
    /// A builder for [`ListRecordsOutput`](crate::output::ListRecordsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) records: std::option::Option<std::vec::Vec<crate::model::Record>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) dataset_sync_count: std::option::Option<i64>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) merged_dataset_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) dataset_exists: std::option::Option<bool>,
        pub(crate) dataset_deleted_after_requested_sync_count: std::option::Option<bool>,
        pub(crate) sync_session_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `records`.
        ///
        /// To override the contents of this collection use [`set_records`](Self::set_records).
        ///
        /// A list of all records.
        pub fn records(mut self, input: crate::model::Record) -> Self {
            let mut v = self.records.unwrap_or_default();
            v.push(input);
            self.records = Some(v);
            self
        }
        /// A list of all records.
        pub fn set_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Record>>,
        ) -> Self {
            self.records = input;
            self
        }
        /// A pagination token for obtaining the next page of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A pagination token for obtaining the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Total number of records.
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// Total number of records.
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Server sync count for this dataset.
        pub fn dataset_sync_count(mut self, input: i64) -> Self {
            self.dataset_sync_count = Some(input);
            self
        }
        /// Server sync count for this dataset.
        pub fn set_dataset_sync_count(mut self, input: std::option::Option<i64>) -> Self {
            self.dataset_sync_count = input;
            self
        }
        /// The user/device that made the last change to this record.
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// The user/device that made the last change to this record.
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Appends an item to `merged_dataset_names`.
        ///
        /// To override the contents of this collection use [`set_merged_dataset_names`](Self::set_merged_dataset_names).
        ///
        /// Names of merged datasets.
        pub fn merged_dataset_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.merged_dataset_names.unwrap_or_default();
            v.push(input.into());
            self.merged_dataset_names = Some(v);
            self
        }
        /// Names of merged datasets.
        pub fn set_merged_dataset_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.merged_dataset_names = input;
            self
        }
        /// Indicates whether the dataset exists.
        pub fn dataset_exists(mut self, input: bool) -> Self {
            self.dataset_exists = Some(input);
            self
        }
        /// Indicates whether the dataset exists.
        pub fn set_dataset_exists(mut self, input: std::option::Option<bool>) -> Self {
            self.dataset_exists = input;
            self
        }
        /// A boolean value specifying whether to delete the dataset locally.
        pub fn dataset_deleted_after_requested_sync_count(mut self, input: bool) -> Self {
            self.dataset_deleted_after_requested_sync_count = Some(input);
            self
        }
        /// A boolean value specifying whether to delete the dataset locally.
        pub fn set_dataset_deleted_after_requested_sync_count(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.dataset_deleted_after_requested_sync_count = input;
            self
        }
        /// A token containing a session ID, identity ID, and expiration.
        pub fn sync_session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_session_token = Some(input.into());
            self
        }
        /// A token containing a session ID, identity ID, and expiration.
        pub fn set_sync_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sync_session_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecordsOutput`](crate::output::ListRecordsOutput)
        pub fn build(self) -> crate::output::ListRecordsOutput {
            crate::output::ListRecordsOutput {
                records: self.records,
                next_token: self.next_token,
                count: self.count.unwrap_or_default(),
                dataset_sync_count: self.dataset_sync_count,
                last_modified_by: self.last_modified_by,
                merged_dataset_names: self.merged_dataset_names,
                dataset_exists: self.dataset_exists.unwrap_or_default(),
                dataset_deleted_after_requested_sync_count: self
                    .dataset_deleted_after_requested_sync_count
                    .unwrap_or_default(),
                sync_session_token: self.sync_session_token,
            }
        }
    }
}
impl ListRecordsOutput {
    /// Creates a new builder-style object to manufacture [`ListRecordsOutput`](crate::output::ListRecordsOutput)
    pub fn builder() -> crate::output::list_records_output::Builder {
        crate::output::list_records_output::Builder::default()
    }
}

/// Returned for a successful ListIdentityPoolUsage request.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentityPoolUsageOutput {
    /// Usage information for the identity pools.
    pub identity_pool_usages: std::option::Option<std::vec::Vec<crate::model::IdentityPoolUsage>>,
    /// The maximum number of results to be returned.
    pub max_results: i32,
    /// Total number of identities for the identity pool.
    pub count: i32,
    /// A pagination token for obtaining the next page of results.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIdentityPoolUsageOutput {
    /// Usage information for the identity pools.
    pub fn identity_pool_usages(&self) -> std::option::Option<&[crate::model::IdentityPoolUsage]> {
        self.identity_pool_usages.as_deref()
    }
    /// The maximum number of results to be returned.
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// Total number of identities for the identity pool.
    pub fn count(&self) -> i32 {
        self.count
    }
    /// A pagination token for obtaining the next page of results.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIdentityPoolUsageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentityPoolUsageOutput");
        formatter.field("identity_pool_usages", &self.identity_pool_usages);
        formatter.field("max_results", &self.max_results);
        formatter.field("count", &self.count);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListIdentityPoolUsageOutput`](crate::output::ListIdentityPoolUsageOutput)
pub mod list_identity_pool_usage_output {
    /// A builder for [`ListIdentityPoolUsageOutput`](crate::output::ListIdentityPoolUsageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_usages:
            std::option::Option<std::vec::Vec<crate::model::IdentityPoolUsage>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `identity_pool_usages`.
        ///
        /// To override the contents of this collection use [`set_identity_pool_usages`](Self::set_identity_pool_usages).
        ///
        /// Usage information for the identity pools.
        pub fn identity_pool_usages(mut self, input: crate::model::IdentityPoolUsage) -> Self {
            let mut v = self.identity_pool_usages.unwrap_or_default();
            v.push(input);
            self.identity_pool_usages = Some(v);
            self
        }
        /// Usage information for the identity pools.
        pub fn set_identity_pool_usages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IdentityPoolUsage>>,
        ) -> Self {
            self.identity_pool_usages = input;
            self
        }
        /// The maximum number of results to be returned.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// The maximum number of results to be returned.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Total number of identities for the identity pool.
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// Total number of identities for the identity pool.
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// A pagination token for obtaining the next page of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A pagination token for obtaining the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentityPoolUsageOutput`](crate::output::ListIdentityPoolUsageOutput)
        pub fn build(self) -> crate::output::ListIdentityPoolUsageOutput {
            crate::output::ListIdentityPoolUsageOutput {
                identity_pool_usages: self.identity_pool_usages,
                max_results: self.max_results.unwrap_or_default(),
                count: self.count.unwrap_or_default(),
                next_token: self.next_token,
            }
        }
    }
}
impl ListIdentityPoolUsageOutput {
    /// Creates a new builder-style object to manufacture [`ListIdentityPoolUsageOutput`](crate::output::ListIdentityPoolUsageOutput)
    pub fn builder() -> crate::output::list_identity_pool_usage_output::Builder {
        crate::output::list_identity_pool_usage_output::Builder::default()
    }
}

/// Returned for a successful ListDatasets request.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetsOutput {
    /// A set of datasets.
    pub datasets: std::option::Option<std::vec::Vec<crate::model::Dataset>>,
    /// Number of datasets returned.
    pub count: i32,
    /// A pagination token for obtaining the next page of results.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetsOutput {
    /// A set of datasets.
    pub fn datasets(&self) -> std::option::Option<&[crate::model::Dataset]> {
        self.datasets.as_deref()
    }
    /// Number of datasets returned.
    pub fn count(&self) -> i32 {
        self.count
    }
    /// A pagination token for obtaining the next page of results.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetsOutput");
        formatter.field("datasets", &self.datasets);
        formatter.field("count", &self.count);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
pub mod list_datasets_output {
    /// A builder for [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datasets: std::option::Option<std::vec::Vec<crate::model::Dataset>>,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `datasets`.
        ///
        /// To override the contents of this collection use [`set_datasets`](Self::set_datasets).
        ///
        /// A set of datasets.
        pub fn datasets(mut self, input: crate::model::Dataset) -> Self {
            let mut v = self.datasets.unwrap_or_default();
            v.push(input);
            self.datasets = Some(v);
            self
        }
        /// A set of datasets.
        pub fn set_datasets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Dataset>>,
        ) -> Self {
            self.datasets = input;
            self
        }
        /// Number of datasets returned.
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// Number of datasets returned.
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// A pagination token for obtaining the next page of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A pagination token for obtaining the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
        pub fn build(self) -> crate::output::ListDatasetsOutput {
            crate::output::ListDatasetsOutput {
                datasets: self.datasets,
                count: self.count.unwrap_or_default(),
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatasetsOutput {
    /// Creates a new builder-style object to manufacture [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
    pub fn builder() -> crate::output::list_datasets_output::Builder {
        crate::output::list_datasets_output::Builder::default()
    }
}

/// <p>The output for the GetIdentityPoolConfiguration operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityPoolConfigurationOutput {
    /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>Options to apply to this identity pool for push synchronization.</p>
    pub push_sync: std::option::Option<crate::model::PushSync>,
    /// Options to apply to this identity pool for Amazon Cognito streams.
    pub cognito_streams: std::option::Option<crate::model::CognitoStreams>,
}
impl GetIdentityPoolConfigurationOutput {
    /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>Options to apply to this identity pool for push synchronization.</p>
    pub fn push_sync(&self) -> std::option::Option<&crate::model::PushSync> {
        self.push_sync.as_ref()
    }
    /// Options to apply to this identity pool for Amazon Cognito streams.
    pub fn cognito_streams(&self) -> std::option::Option<&crate::model::CognitoStreams> {
        self.cognito_streams.as_ref()
    }
}
impl std::fmt::Debug for GetIdentityPoolConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityPoolConfigurationOutput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("push_sync", &self.push_sync);
        formatter.field("cognito_streams", &self.cognito_streams);
        formatter.finish()
    }
}
/// See [`GetIdentityPoolConfigurationOutput`](crate::output::GetIdentityPoolConfigurationOutput)
pub mod get_identity_pool_configuration_output {
    /// A builder for [`GetIdentityPoolConfigurationOutput`](crate::output::GetIdentityPoolConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) push_sync: std::option::Option<crate::model::PushSync>,
        pub(crate) cognito_streams: std::option::Option<crate::model::CognitoStreams>,
    }
    impl Builder {
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>Options to apply to this identity pool for push synchronization.</p>
        pub fn push_sync(mut self, input: crate::model::PushSync) -> Self {
            self.push_sync = Some(input);
            self
        }
        /// <p>Options to apply to this identity pool for push synchronization.</p>
        pub fn set_push_sync(mut self, input: std::option::Option<crate::model::PushSync>) -> Self {
            self.push_sync = input;
            self
        }
        /// Options to apply to this identity pool for Amazon Cognito streams.
        pub fn cognito_streams(mut self, input: crate::model::CognitoStreams) -> Self {
            self.cognito_streams = Some(input);
            self
        }
        /// Options to apply to this identity pool for Amazon Cognito streams.
        pub fn set_cognito_streams(
            mut self,
            input: std::option::Option<crate::model::CognitoStreams>,
        ) -> Self {
            self.cognito_streams = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityPoolConfigurationOutput`](crate::output::GetIdentityPoolConfigurationOutput)
        pub fn build(self) -> crate::output::GetIdentityPoolConfigurationOutput {
            crate::output::GetIdentityPoolConfigurationOutput {
                identity_pool_id: self.identity_pool_id,
                push_sync: self.push_sync,
                cognito_streams: self.cognito_streams,
            }
        }
    }
}
impl GetIdentityPoolConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetIdentityPoolConfigurationOutput`](crate::output::GetIdentityPoolConfigurationOutput)
    pub fn builder() -> crate::output::get_identity_pool_configuration_output::Builder {
        crate::output::get_identity_pool_configuration_output::Builder::default()
    }
}

/// <p>The response from the GetCognitoEvents request</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCognitoEventsOutput {
    /// <p>The Cognito Events returned from the GetCognitoEvents request</p>
    pub events:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetCognitoEventsOutput {
    /// <p>The Cognito Events returned from the GetCognitoEvents request</p>
    pub fn events(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.events.as_ref()
    }
}
impl std::fmt::Debug for GetCognitoEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCognitoEventsOutput");
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`GetCognitoEventsOutput`](crate::output::GetCognitoEventsOutput)
pub mod get_cognito_events_output {
    /// A builder for [`GetCognitoEventsOutput`](crate::output::GetCognitoEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The Cognito Events returned from the GetCognitoEvents request</p>
        pub fn events(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.events.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.events = Some(hash_map);
            self
        }
        /// <p>The Cognito Events returned from the GetCognitoEvents request</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCognitoEventsOutput`](crate::output::GetCognitoEventsOutput)
        pub fn build(self) -> crate::output::GetCognitoEventsOutput {
            crate::output::GetCognitoEventsOutput {
                events: self.events,
            }
        }
    }
}
impl GetCognitoEventsOutput {
    /// Creates a new builder-style object to manufacture [`GetCognitoEventsOutput`](crate::output::GetCognitoEventsOutput)
    pub fn builder() -> crate::output::get_cognito_events_output::Builder {
        crate::output::get_cognito_events_output::Builder::default()
    }
}

/// The output for the GetBulkPublishDetails operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBulkPublishDetailsOutput {
    /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// The date/time at which the last bulk publish was initiated.
    pub bulk_publish_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation completed.
    pub bulk_publish_complete_time: std::option::Option<aws_smithy_types::DateTime>,
    /// Status of the last bulk publish operation, valid values are:
    /// <p>NOT_STARTED - No bulk publish has been requested for this identity pool</p>
    /// <p>IN_PROGRESS - Data is being published to the configured stream</p>
    /// <p>SUCCEEDED - All data for the identity pool has been published to the configured stream</p>
    /// <p>FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.</p>
    pub bulk_publish_status: std::option::Option<crate::model::BulkPublishStatus>,
    /// If BulkPublishStatus is FAILED this field will contain the error message that caused the bulk publish to fail.
    pub failure_message: std::option::Option<std::string::String>,
}
impl GetBulkPublishDetailsOutput {
    /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// The date/time at which the last bulk publish was initiated.
    pub fn bulk_publish_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.bulk_publish_start_time.as_ref()
    }
    /// If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation completed.
    pub fn bulk_publish_complete_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.bulk_publish_complete_time.as_ref()
    }
    /// Status of the last bulk publish operation, valid values are:
    /// <p>NOT_STARTED - No bulk publish has been requested for this identity pool</p>
    /// <p>IN_PROGRESS - Data is being published to the configured stream</p>
    /// <p>SUCCEEDED - All data for the identity pool has been published to the configured stream</p>
    /// <p>FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.</p>
    pub fn bulk_publish_status(&self) -> std::option::Option<&crate::model::BulkPublishStatus> {
        self.bulk_publish_status.as_ref()
    }
    /// If BulkPublishStatus is FAILED this field will contain the error message that caused the bulk publish to fail.
    pub fn failure_message(&self) -> std::option::Option<&str> {
        self.failure_message.as_deref()
    }
}
impl std::fmt::Debug for GetBulkPublishDetailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBulkPublishDetailsOutput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("bulk_publish_start_time", &self.bulk_publish_start_time);
        formatter.field(
            "bulk_publish_complete_time",
            &self.bulk_publish_complete_time,
        );
        formatter.field("bulk_publish_status", &self.bulk_publish_status);
        formatter.field("failure_message", &self.failure_message);
        formatter.finish()
    }
}
/// See [`GetBulkPublishDetailsOutput`](crate::output::GetBulkPublishDetailsOutput)
pub mod get_bulk_publish_details_output {
    /// A builder for [`GetBulkPublishDetailsOutput`](crate::output::GetBulkPublishDetailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) bulk_publish_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) bulk_publish_complete_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) bulk_publish_status: std::option::Option<crate::model::BulkPublishStatus>,
        pub(crate) failure_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// The date/time at which the last bulk publish was initiated.
        pub fn bulk_publish_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.bulk_publish_start_time = Some(input);
            self
        }
        /// The date/time at which the last bulk publish was initiated.
        pub fn set_bulk_publish_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.bulk_publish_start_time = input;
            self
        }
        /// If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation completed.
        pub fn bulk_publish_complete_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.bulk_publish_complete_time = Some(input);
            self
        }
        /// If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation completed.
        pub fn set_bulk_publish_complete_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.bulk_publish_complete_time = input;
            self
        }
        /// Status of the last bulk publish operation, valid values are:
        /// <p>NOT_STARTED - No bulk publish has been requested for this identity pool</p>
        /// <p>IN_PROGRESS - Data is being published to the configured stream</p>
        /// <p>SUCCEEDED - All data for the identity pool has been published to the configured stream</p>
        /// <p>FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.</p>
        pub fn bulk_publish_status(mut self, input: crate::model::BulkPublishStatus) -> Self {
            self.bulk_publish_status = Some(input);
            self
        }
        /// Status of the last bulk publish operation, valid values are:
        /// <p>NOT_STARTED - No bulk publish has been requested for this identity pool</p>
        /// <p>IN_PROGRESS - Data is being published to the configured stream</p>
        /// <p>SUCCEEDED - All data for the identity pool has been published to the configured stream</p>
        /// <p>FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.</p>
        pub fn set_bulk_publish_status(
            mut self,
            input: std::option::Option<crate::model::BulkPublishStatus>,
        ) -> Self {
            self.bulk_publish_status = input;
            self
        }
        /// If BulkPublishStatus is FAILED this field will contain the error message that caused the bulk publish to fail.
        pub fn failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_message = Some(input.into());
            self
        }
        /// If BulkPublishStatus is FAILED this field will contain the error message that caused the bulk publish to fail.
        pub fn set_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_message = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBulkPublishDetailsOutput`](crate::output::GetBulkPublishDetailsOutput)
        pub fn build(self) -> crate::output::GetBulkPublishDetailsOutput {
            crate::output::GetBulkPublishDetailsOutput {
                identity_pool_id: self.identity_pool_id,
                bulk_publish_start_time: self.bulk_publish_start_time,
                bulk_publish_complete_time: self.bulk_publish_complete_time,
                bulk_publish_status: self.bulk_publish_status,
                failure_message: self.failure_message,
            }
        }
    }
}
impl GetBulkPublishDetailsOutput {
    /// Creates a new builder-style object to manufacture [`GetBulkPublishDetailsOutput`](crate::output::GetBulkPublishDetailsOutput)
    pub fn builder() -> crate::output::get_bulk_publish_details_output::Builder {
        crate::output::get_bulk_publish_details_output::Builder::default()
    }
}

/// The response to a successful DescribeIdentityUsage request.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIdentityUsageOutput {
    /// Usage information for the identity.
    pub identity_usage: std::option::Option<crate::model::IdentityUsage>,
}
impl DescribeIdentityUsageOutput {
    /// Usage information for the identity.
    pub fn identity_usage(&self) -> std::option::Option<&crate::model::IdentityUsage> {
        self.identity_usage.as_ref()
    }
}
impl std::fmt::Debug for DescribeIdentityUsageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIdentityUsageOutput");
        formatter.field("identity_usage", &self.identity_usage);
        formatter.finish()
    }
}
/// See [`DescribeIdentityUsageOutput`](crate::output::DescribeIdentityUsageOutput)
pub mod describe_identity_usage_output {
    /// A builder for [`DescribeIdentityUsageOutput`](crate::output::DescribeIdentityUsageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_usage: std::option::Option<crate::model::IdentityUsage>,
    }
    impl Builder {
        /// Usage information for the identity.
        pub fn identity_usage(mut self, input: crate::model::IdentityUsage) -> Self {
            self.identity_usage = Some(input);
            self
        }
        /// Usage information for the identity.
        pub fn set_identity_usage(
            mut self,
            input: std::option::Option<crate::model::IdentityUsage>,
        ) -> Self {
            self.identity_usage = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIdentityUsageOutput`](crate::output::DescribeIdentityUsageOutput)
        pub fn build(self) -> crate::output::DescribeIdentityUsageOutput {
            crate::output::DescribeIdentityUsageOutput {
                identity_usage: self.identity_usage,
            }
        }
    }
}
impl DescribeIdentityUsageOutput {
    /// Creates a new builder-style object to manufacture [`DescribeIdentityUsageOutput`](crate::output::DescribeIdentityUsageOutput)
    pub fn builder() -> crate::output::describe_identity_usage_output::Builder {
        crate::output::describe_identity_usage_output::Builder::default()
    }
}

/// Response to a successful DescribeIdentityPoolUsage request.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIdentityPoolUsageOutput {
    /// Information about the usage of the identity pool.
    pub identity_pool_usage: std::option::Option<crate::model::IdentityPoolUsage>,
}
impl DescribeIdentityPoolUsageOutput {
    /// Information about the usage of the identity pool.
    pub fn identity_pool_usage(&self) -> std::option::Option<&crate::model::IdentityPoolUsage> {
        self.identity_pool_usage.as_ref()
    }
}
impl std::fmt::Debug for DescribeIdentityPoolUsageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIdentityPoolUsageOutput");
        formatter.field("identity_pool_usage", &self.identity_pool_usage);
        formatter.finish()
    }
}
/// See [`DescribeIdentityPoolUsageOutput`](crate::output::DescribeIdentityPoolUsageOutput)
pub mod describe_identity_pool_usage_output {
    /// A builder for [`DescribeIdentityPoolUsageOutput`](crate::output::DescribeIdentityPoolUsageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_usage: std::option::Option<crate::model::IdentityPoolUsage>,
    }
    impl Builder {
        /// Information about the usage of the identity pool.
        pub fn identity_pool_usage(mut self, input: crate::model::IdentityPoolUsage) -> Self {
            self.identity_pool_usage = Some(input);
            self
        }
        /// Information about the usage of the identity pool.
        pub fn set_identity_pool_usage(
            mut self,
            input: std::option::Option<crate::model::IdentityPoolUsage>,
        ) -> Self {
            self.identity_pool_usage = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIdentityPoolUsageOutput`](crate::output::DescribeIdentityPoolUsageOutput)
        pub fn build(self) -> crate::output::DescribeIdentityPoolUsageOutput {
            crate::output::DescribeIdentityPoolUsageOutput {
                identity_pool_usage: self.identity_pool_usage,
            }
        }
    }
}
impl DescribeIdentityPoolUsageOutput {
    /// Creates a new builder-style object to manufacture [`DescribeIdentityPoolUsageOutput`](crate::output::DescribeIdentityPoolUsageOutput)
    pub fn builder() -> crate::output::describe_identity_pool_usage_output::Builder {
        crate::output::describe_identity_pool_usage_output::Builder::default()
    }
}

/// Response to a successful DescribeDataset request.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetOutput {
    /// Meta data for a collection of data for an identity. An identity can have multiple datasets. A dataset can be general or associated with a particular entity in an application (like a saved game). Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.
    pub dataset: std::option::Option<crate::model::Dataset>,
}
impl DescribeDatasetOutput {
    /// Meta data for a collection of data for an identity. An identity can have multiple datasets. A dataset can be general or associated with a particular entity in an application (like a saved game). Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.
    pub fn dataset(&self) -> std::option::Option<&crate::model::Dataset> {
        self.dataset.as_ref()
    }
}
impl std::fmt::Debug for DescribeDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetOutput");
        formatter.field("dataset", &self.dataset);
        formatter.finish()
    }
}
/// See [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
pub mod describe_dataset_output {
    /// A builder for [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset: std::option::Option<crate::model::Dataset>,
    }
    impl Builder {
        /// Meta data for a collection of data for an identity. An identity can have multiple datasets. A dataset can be general or associated with a particular entity in an application (like a saved game). Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.
        pub fn dataset(mut self, input: crate::model::Dataset) -> Self {
            self.dataset = Some(input);
            self
        }
        /// Meta data for a collection of data for an identity. An identity can have multiple datasets. A dataset can be general or associated with a particular entity in an application (like a saved game). Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.
        pub fn set_dataset(mut self, input: std::option::Option<crate::model::Dataset>) -> Self {
            self.dataset = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
        pub fn build(self) -> crate::output::DescribeDatasetOutput {
            crate::output::DescribeDatasetOutput {
                dataset: self.dataset,
            }
        }
    }
}
impl DescribeDatasetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
    pub fn builder() -> crate::output::describe_dataset_output::Builder {
        crate::output::describe_dataset_output::Builder::default()
    }
}

/// Response to a successful DeleteDataset request.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetOutput {
    /// A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is per identity and can be general or associated with a particular entity in an application (like a saved game). Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.
    pub dataset: std::option::Option<crate::model::Dataset>,
}
impl DeleteDatasetOutput {
    /// A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is per identity and can be general or associated with a particular entity in an application (like a saved game). Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.
    pub fn dataset(&self) -> std::option::Option<&crate::model::Dataset> {
        self.dataset.as_ref()
    }
}
impl std::fmt::Debug for DeleteDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetOutput");
        formatter.field("dataset", &self.dataset);
        formatter.finish()
    }
}
/// See [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
pub mod delete_dataset_output {
    /// A builder for [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset: std::option::Option<crate::model::Dataset>,
    }
    impl Builder {
        /// A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is per identity and can be general or associated with a particular entity in an application (like a saved game). Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.
        pub fn dataset(mut self, input: crate::model::Dataset) -> Self {
            self.dataset = Some(input);
            self
        }
        /// A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is per identity and can be general or associated with a particular entity in an application (like a saved game). Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.
        pub fn set_dataset(mut self, input: std::option::Option<crate::model::Dataset>) -> Self {
            self.dataset = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
        pub fn build(self) -> crate::output::DeleteDatasetOutput {
            crate::output::DeleteDatasetOutput {
                dataset: self.dataset,
            }
        }
    }
}
impl DeleteDatasetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    pub fn builder() -> crate::output::delete_dataset_output::Builder {
        crate::output::delete_dataset_output::Builder::default()
    }
}

/// The output for the BulkPublish operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BulkPublishOutput {
    /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
}
impl BulkPublishOutput {
    /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
}
impl std::fmt::Debug for BulkPublishOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BulkPublishOutput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.finish()
    }
}
/// See [`BulkPublishOutput`](crate::output::BulkPublishOutput)
pub mod bulk_publish_output {
    /// A builder for [`BulkPublishOutput`](crate::output::BulkPublishOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BulkPublishOutput`](crate::output::BulkPublishOutput)
        pub fn build(self) -> crate::output::BulkPublishOutput {
            crate::output::BulkPublishOutput {
                identity_pool_id: self.identity_pool_id,
            }
        }
    }
}
impl BulkPublishOutput {
    /// Creates a new builder-style object to manufacture [`BulkPublishOutput`](crate::output::BulkPublishOutput)
    pub fn builder() -> crate::output::bulk_publish_output::Builder {
        crate::output::bulk_publish_output::Builder::default()
    }
}
