// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Cognito Sync
///
/// Client for invoking operations on Amazon Cognito Sync. Each operation on Amazon Cognito Sync is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cognitosync::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_cognitosync::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_cognitosync::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BulkPublish`](crate::client::fluent_builders::BulkPublish) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::BulkPublish::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::BulkPublish::set_identity_pool_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    /// - On success, responds with [`BulkPublishOutput`](crate::output::BulkPublishOutput) with field(s):
    ///   - [`identity_pool_id(Option<String>)`](crate::output::BulkPublishOutput::identity_pool_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    /// - On failure, responds with [`SdkError<BulkPublishError>`](crate::error::BulkPublishError)
    pub fn bulk_publish(&self) -> fluent_builders::BulkPublish {
        fluent_builders::BulkPublish::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataset::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::DeleteDataset::set_identity_pool_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataset::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::DeleteDataset::set_identity_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDataset::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::DeleteDataset::set_dataset_name): A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
    /// - On success, responds with [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput) with field(s):
    ///   - [`dataset(Option<Dataset>)`](crate::output::DeleteDatasetOutput::dataset): A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is per identity and can be general or associated with a particular entity in an application (like a saved game). Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.
    /// - On failure, responds with [`SdkError<DeleteDatasetError>`](crate::error::DeleteDatasetError)
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDataset::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::DescribeDataset::set_identity_pool_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDataset::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::DescribeDataset::set_identity_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDataset::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::DescribeDataset::set_dataset_name): A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
    /// - On success, responds with [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput) with field(s):
    ///   - [`dataset(Option<Dataset>)`](crate::output::DescribeDatasetOutput::dataset): Meta data for a collection of data for an identity. An identity can have multiple datasets. A dataset can be general or associated with a particular entity in an application (like a saved game). Datasets are automatically created if they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.
    /// - On failure, responds with [`SdkError<DescribeDatasetError>`](crate::error::DescribeDatasetError)
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIdentityPoolUsage`](crate::client::fluent_builders::DescribeIdentityPoolUsage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIdentityPoolUsage::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::DescribeIdentityPoolUsage::set_identity_pool_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    /// - On success, responds with [`DescribeIdentityPoolUsageOutput`](crate::output::DescribeIdentityPoolUsageOutput) with field(s):
    ///   - [`identity_pool_usage(Option<IdentityPoolUsage>)`](crate::output::DescribeIdentityPoolUsageOutput::identity_pool_usage): Information about the usage of the identity pool.
    /// - On failure, responds with [`SdkError<DescribeIdentityPoolUsageError>`](crate::error::DescribeIdentityPoolUsageError)
    pub fn describe_identity_pool_usage(&self) -> fluent_builders::DescribeIdentityPoolUsage {
        fluent_builders::DescribeIdentityPoolUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIdentityUsage`](crate::client::fluent_builders::DescribeIdentityUsage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIdentityUsage::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::DescribeIdentityUsage::set_identity_pool_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIdentityUsage::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::DescribeIdentityUsage::set_identity_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    /// - On success, responds with [`DescribeIdentityUsageOutput`](crate::output::DescribeIdentityUsageOutput) with field(s):
    ///   - [`identity_usage(Option<IdentityUsage>)`](crate::output::DescribeIdentityUsageOutput::identity_usage): Usage information for the identity.
    /// - On failure, responds with [`SdkError<DescribeIdentityUsageError>`](crate::error::DescribeIdentityUsageError)
    pub fn describe_identity_usage(&self) -> fluent_builders::DescribeIdentityUsage {
        fluent_builders::DescribeIdentityUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBulkPublishDetails`](crate::client::fluent_builders::GetBulkPublishDetails) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetBulkPublishDetails::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::GetBulkPublishDetails::set_identity_pool_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    /// - On success, responds with [`GetBulkPublishDetailsOutput`](crate::output::GetBulkPublishDetailsOutput) with field(s):
    ///   - [`identity_pool_id(Option<String>)`](crate::output::GetBulkPublishDetailsOutput::identity_pool_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`bulk_publish_start_time(Option<DateTime>)`](crate::output::GetBulkPublishDetailsOutput::bulk_publish_start_time): The date/time at which the last bulk publish was initiated.
    ///   - [`bulk_publish_complete_time(Option<DateTime>)`](crate::output::GetBulkPublishDetailsOutput::bulk_publish_complete_time): If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation completed.
    ///   - [`bulk_publish_status(Option<BulkPublishStatus>)`](crate::output::GetBulkPublishDetailsOutput::bulk_publish_status): Status of the last bulk publish operation, valid values are:  <p>NOT_STARTED - No bulk publish has been requested for this identity pool</p>  <p>IN_PROGRESS - Data is being published to the configured stream</p>  <p>SUCCEEDED - All data for the identity pool has been published to the configured stream</p>  <p>FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.</p>
    ///   - [`failure_message(Option<String>)`](crate::output::GetBulkPublishDetailsOutput::failure_message): If BulkPublishStatus is FAILED this field will contain the error message that caused the bulk publish to fail.
    /// - On failure, responds with [`SdkError<GetBulkPublishDetailsError>`](crate::error::GetBulkPublishDetailsError)
    pub fn get_bulk_publish_details(&self) -> fluent_builders::GetBulkPublishDetails {
        fluent_builders::GetBulkPublishDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCognitoEvents`](crate::client::fluent_builders::GetCognitoEvents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetCognitoEvents::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::GetCognitoEvents::set_identity_pool_id): <p>The Cognito Identity Pool ID for the request</p>
    /// - On success, responds with [`GetCognitoEventsOutput`](crate::output::GetCognitoEventsOutput) with field(s):
    ///   - [`events(Option<HashMap<String, String>>)`](crate::output::GetCognitoEventsOutput::events): <p>The Cognito Events returned from the GetCognitoEvents request</p>
    /// - On failure, responds with [`SdkError<GetCognitoEventsError>`](crate::error::GetCognitoEventsError)
    pub fn get_cognito_events(&self) -> fluent_builders::GetCognitoEvents {
        fluent_builders::GetCognitoEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIdentityPoolConfiguration`](crate::client::fluent_builders::GetIdentityPoolConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetIdentityPoolConfiguration::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::GetIdentityPoolConfiguration::set_identity_pool_id): <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. This is the ID of the pool for which to return a configuration.</p>
    /// - On success, responds with [`GetIdentityPoolConfigurationOutput`](crate::output::GetIdentityPoolConfigurationOutput) with field(s):
    ///   - [`identity_pool_id(Option<String>)`](crate::output::GetIdentityPoolConfigurationOutput::identity_pool_id): <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.</p>
    ///   - [`push_sync(Option<PushSync>)`](crate::output::GetIdentityPoolConfigurationOutput::push_sync): <p>Options to apply to this identity pool for push synchronization.</p>
    ///   - [`cognito_streams(Option<CognitoStreams>)`](crate::output::GetIdentityPoolConfigurationOutput::cognito_streams): Options to apply to this identity pool for Amazon Cognito streams.
    /// - On failure, responds with [`SdkError<GetIdentityPoolConfigurationError>`](crate::error::GetIdentityPoolConfigurationError)
    pub fn get_identity_pool_configuration(&self) -> fluent_builders::GetIdentityPoolConfiguration {
        fluent_builders::GetIdentityPoolConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDatasets`](crate::client::fluent_builders::ListDatasets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::ListDatasets::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::ListDatasets::set_identity_pool_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::ListDatasets::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::ListDatasets::set_identity_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDatasets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDatasets::set_next_token): A pagination token for obtaining the next page of results.
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDatasets::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDatasets::set_max_results): The maximum number of results to be returned.
    /// - On success, responds with [`ListDatasetsOutput`](crate::output::ListDatasetsOutput) with field(s):
    ///   - [`datasets(Option<Vec<Dataset>>)`](crate::output::ListDatasetsOutput::datasets): A set of datasets.
    ///   - [`count(i32)`](crate::output::ListDatasetsOutput::count): Number of datasets returned.
    ///   - [`next_token(Option<String>)`](crate::output::ListDatasetsOutput::next_token): A pagination token for obtaining the next page of results.
    /// - On failure, responds with [`SdkError<ListDatasetsError>`](crate::error::ListDatasetsError)
    pub fn list_datasets(&self) -> fluent_builders::ListDatasets {
        fluent_builders::ListDatasets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIdentityPoolUsage`](crate::client::fluent_builders::ListIdentityPoolUsage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIdentityPoolUsage::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIdentityPoolUsage::set_next_token): A pagination token for obtaining the next page of results.
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIdentityPoolUsage::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListIdentityPoolUsage::set_max_results): The maximum number of results to be returned.
    /// - On success, responds with [`ListIdentityPoolUsageOutput`](crate::output::ListIdentityPoolUsageOutput) with field(s):
    ///   - [`identity_pool_usages(Option<Vec<IdentityPoolUsage>>)`](crate::output::ListIdentityPoolUsageOutput::identity_pool_usages): Usage information for the identity pools.
    ///   - [`max_results(i32)`](crate::output::ListIdentityPoolUsageOutput::max_results): The maximum number of results to be returned.
    ///   - [`count(i32)`](crate::output::ListIdentityPoolUsageOutput::count): Total number of identities for the identity pool.
    ///   - [`next_token(Option<String>)`](crate::output::ListIdentityPoolUsageOutput::next_token): A pagination token for obtaining the next page of results.
    /// - On failure, responds with [`SdkError<ListIdentityPoolUsageError>`](crate::error::ListIdentityPoolUsageError)
    pub fn list_identity_pool_usage(&self) -> fluent_builders::ListIdentityPoolUsage {
        fluent_builders::ListIdentityPoolUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRecords`](crate::client::fluent_builders::ListRecords) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::ListRecords::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::ListRecords::set_identity_pool_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::ListRecords::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::ListRecords::set_identity_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::ListRecords::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::ListRecords::set_dataset_name): A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
    ///   - [`last_sync_count(i64)`](crate::client::fluent_builders::ListRecords::last_sync_count) / [`set_last_sync_count(Option<i64>)`](crate::client::fluent_builders::ListRecords::set_last_sync_count): The last server sync count for this record.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRecords::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRecords::set_next_token): A pagination token for obtaining the next page of results.
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRecords::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListRecords::set_max_results): The maximum number of results to be returned.
    ///   - [`sync_session_token(impl Into<String>)`](crate::client::fluent_builders::ListRecords::sync_session_token) / [`set_sync_session_token(Option<String>)`](crate::client::fluent_builders::ListRecords::set_sync_session_token): A token containing a session ID, identity ID, and expiration.
    /// - On success, responds with [`ListRecordsOutput`](crate::output::ListRecordsOutput) with field(s):
    ///   - [`records(Option<Vec<Record>>)`](crate::output::ListRecordsOutput::records): A list of all records.
    ///   - [`next_token(Option<String>)`](crate::output::ListRecordsOutput::next_token): A pagination token for obtaining the next page of results.
    ///   - [`count(i32)`](crate::output::ListRecordsOutput::count): Total number of records.
    ///   - [`dataset_sync_count(Option<i64>)`](crate::output::ListRecordsOutput::dataset_sync_count): Server sync count for this dataset.
    ///   - [`last_modified_by(Option<String>)`](crate::output::ListRecordsOutput::last_modified_by): The user/device that made the last change to this record.
    ///   - [`merged_dataset_names(Option<Vec<String>>)`](crate::output::ListRecordsOutput::merged_dataset_names): Names of merged datasets.
    ///   - [`dataset_exists(bool)`](crate::output::ListRecordsOutput::dataset_exists): Indicates whether the dataset exists.
    ///   - [`dataset_deleted_after_requested_sync_count(bool)`](crate::output::ListRecordsOutput::dataset_deleted_after_requested_sync_count): A boolean value specifying whether to delete the dataset locally.
    ///   - [`sync_session_token(Option<String>)`](crate::output::ListRecordsOutput::sync_session_token): A token containing a session ID, identity ID, and expiration.
    /// - On failure, responds with [`SdkError<ListRecordsError>`](crate::error::ListRecordsError)
    pub fn list_records(&self) -> fluent_builders::ListRecords {
        fluent_builders::ListRecords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterDevice`](crate::client::fluent_builders::RegisterDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::RegisterDevice::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::RegisterDevice::set_identity_pool_id): <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. Here, the ID of the pool that the identity belongs to.</p>
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::RegisterDevice::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::RegisterDevice::set_identity_id): <p>The unique ID for this identity.</p>
    ///   - [`platform(Platform)`](crate::client::fluent_builders::RegisterDevice::platform) / [`set_platform(Option<Platform>)`](crate::client::fluent_builders::RegisterDevice::set_platform): <p>The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::RegisterDevice::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::RegisterDevice::set_token): <p>The push token.</p>
    /// - On success, responds with [`RegisterDeviceOutput`](crate::output::RegisterDeviceOutput) with field(s):
    ///   - [`device_id(Option<String>)`](crate::output::RegisterDeviceOutput::device_id): <p>The unique ID generated for this device by Cognito.</p>
    /// - On failure, responds with [`SdkError<RegisterDeviceError>`](crate::error::RegisterDeviceError)
    pub fn register_device(&self) -> fluent_builders::RegisterDevice {
        fluent_builders::RegisterDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetCognitoEvents`](crate::client::fluent_builders::SetCognitoEvents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::SetCognitoEvents::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::SetCognitoEvents::set_identity_pool_id): <p>The Cognito Identity Pool to use when configuring Cognito Events</p>
    ///   - [`events(HashMap<String, String>)`](crate::client::fluent_builders::SetCognitoEvents::events) / [`set_events(Option<HashMap<String, String>>)`](crate::client::fluent_builders::SetCognitoEvents::set_events): <p>The events to configure</p>
    /// - On success, responds with [`SetCognitoEventsOutput`](crate::output::SetCognitoEventsOutput)

    /// - On failure, responds with [`SdkError<SetCognitoEventsError>`](crate::error::SetCognitoEventsError)
    pub fn set_cognito_events(&self) -> fluent_builders::SetCognitoEvents {
        fluent_builders::SetCognitoEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetIdentityPoolConfiguration`](crate::client::fluent_builders::SetIdentityPoolConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::SetIdentityPoolConfiguration::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::SetIdentityPoolConfiguration::set_identity_pool_id): <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. This is the ID of the pool to modify.</p>
    ///   - [`push_sync(PushSync)`](crate::client::fluent_builders::SetIdentityPoolConfiguration::push_sync) / [`set_push_sync(Option<PushSync>)`](crate::client::fluent_builders::SetIdentityPoolConfiguration::set_push_sync): <p>Options to apply to this identity pool for push synchronization.</p>
    ///   - [`cognito_streams(CognitoStreams)`](crate::client::fluent_builders::SetIdentityPoolConfiguration::cognito_streams) / [`set_cognito_streams(Option<CognitoStreams>)`](crate::client::fluent_builders::SetIdentityPoolConfiguration::set_cognito_streams): Options to apply to this identity pool for Amazon Cognito streams.
    /// - On success, responds with [`SetIdentityPoolConfigurationOutput`](crate::output::SetIdentityPoolConfigurationOutput) with field(s):
    ///   - [`identity_pool_id(Option<String>)`](crate::output::SetIdentityPoolConfigurationOutput::identity_pool_id): <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.</p>
    ///   - [`push_sync(Option<PushSync>)`](crate::output::SetIdentityPoolConfigurationOutput::push_sync): <p>Options to apply to this identity pool for push synchronization.</p>
    ///   - [`cognito_streams(Option<CognitoStreams>)`](crate::output::SetIdentityPoolConfigurationOutput::cognito_streams): Options to apply to this identity pool for Amazon Cognito streams.
    /// - On failure, responds with [`SdkError<SetIdentityPoolConfigurationError>`](crate::error::SetIdentityPoolConfigurationError)
    pub fn set_identity_pool_configuration(&self) -> fluent_builders::SetIdentityPoolConfiguration {
        fluent_builders::SetIdentityPoolConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SubscribeToDataset`](crate::client::fluent_builders::SubscribeToDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::SubscribeToDataset::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::SubscribeToDataset::set_identity_pool_id): <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. The ID of the pool to which the identity belongs.</p>
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::SubscribeToDataset::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::SubscribeToDataset::set_identity_id): <p>Unique ID for this identity.</p>
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::SubscribeToDataset::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::SubscribeToDataset::set_dataset_name): <p>The name of the dataset to subcribe to.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::SubscribeToDataset::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::SubscribeToDataset::set_device_id): <p>The unique ID generated for this device by Cognito.</p>
    /// - On success, responds with [`SubscribeToDatasetOutput`](crate::output::SubscribeToDatasetOutput)

    /// - On failure, responds with [`SdkError<SubscribeToDatasetError>`](crate::error::SubscribeToDatasetError)
    pub fn subscribe_to_dataset(&self) -> fluent_builders::SubscribeToDataset {
        fluent_builders::SubscribeToDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UnsubscribeFromDataset`](crate::client::fluent_builders::UnsubscribeFromDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::UnsubscribeFromDataset::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::UnsubscribeFromDataset::set_identity_pool_id): <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. The ID of the pool to which this identity belongs.</p>
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::UnsubscribeFromDataset::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::UnsubscribeFromDataset::set_identity_id): <p>Unique ID for this identity.</p>
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::UnsubscribeFromDataset::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::UnsubscribeFromDataset::set_dataset_name): <p>The name of the dataset from which to unsubcribe.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::UnsubscribeFromDataset::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::UnsubscribeFromDataset::set_device_id): <p>The unique ID generated for this device by Cognito.</p>
    /// - On success, responds with [`UnsubscribeFromDatasetOutput`](crate::output::UnsubscribeFromDatasetOutput)

    /// - On failure, responds with [`SdkError<UnsubscribeFromDatasetError>`](crate::error::UnsubscribeFromDatasetError)
    pub fn unsubscribe_from_dataset(&self) -> fluent_builders::UnsubscribeFromDataset {
        fluent_builders::UnsubscribeFromDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRecords`](crate::client::fluent_builders::UpdateRecords) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRecords::identity_pool_id) / [`set_identity_pool_id(Option<String>)`](crate::client::fluent_builders::UpdateRecords::set_identity_pool_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRecords::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::UpdateRecords::set_identity_id): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRecords::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::UpdateRecords::set_dataset_name): A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRecords::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::UpdateRecords::set_device_id): <p>The unique ID generated for this device by Cognito.</p>
    ///   - [`record_patches(Vec<RecordPatch>)`](crate::client::fluent_builders::UpdateRecords::record_patches) / [`set_record_patches(Option<Vec<RecordPatch>>)`](crate::client::fluent_builders::UpdateRecords::set_record_patches): A list of patch operations.
    ///   - [`sync_session_token(impl Into<String>)`](crate::client::fluent_builders::UpdateRecords::sync_session_token) / [`set_sync_session_token(Option<String>)`](crate::client::fluent_builders::UpdateRecords::set_sync_session_token): The SyncSessionToken returned by a previous call to ListRecords for this dataset and identity.
    ///   - [`client_context(impl Into<String>)`](crate::client::fluent_builders::UpdateRecords::client_context) / [`set_client_context(Option<String>)`](crate::client::fluent_builders::UpdateRecords::set_client_context): Intended to supply a device ID that will populate the lastModifiedBy field referenced in other methods. The ClientContext field is not yet implemented.
    /// - On success, responds with [`UpdateRecordsOutput`](crate::output::UpdateRecordsOutput) with field(s):
    ///   - [`records(Option<Vec<Record>>)`](crate::output::UpdateRecordsOutput::records): A list of records that have been updated.
    /// - On failure, responds with [`SdkError<UpdateRecordsError>`](crate::error::UpdateRecordsError)
    pub fn update_records(&self) -> fluent_builders::UpdateRecords {
        fluent_builders::UpdateRecords::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BulkPublish`.
    ///
    /// <p>Initiates a bulk publish of all existing datasets for an Identity Pool to the configured stream. Customers are limited to one successful bulk publish per 24 hours. Bulk publish is an asynchronous request, customers can see the status of the request via the GetBulkPublishDetails operation.</p>
    /// <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BulkPublish {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::bulk_publish_input::Builder,
    }
    impl BulkPublish {
        /// Creates a new `BulkPublish`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BulkPublishOutput,
            aws_smithy_http::result::SdkError<crate::error::BulkPublishError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes the specific dataset. The dataset will be deleted permanently, and the action can't be undone. Datasets that this dataset was merged with will no longer report the merge. Any subsequent operation on this dataset will result in a ResourceNotFoundException.</p>
    /// <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl DeleteDataset {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p>Gets meta data about a dataset by identity and dataset name. With Amazon Cognito Sync, each identity has access only to its own data. Thus, the credentials used to make this API call need to have access to the identity data.</p>
    /// <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials. You should use Cognito Identity credentials to make this API call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl DescribeDataset {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentityPoolUsage`.
    ///
    /// <p>Gets usage details (for example, data storage) about a particular identity pool.</p>
    /// <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p> <examples>
    /// <example>
    /// <name>
    /// DescribeIdentityPoolUsage
    /// </name>
    /// <description>
    /// The following examples have been edited for readability.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 CONTENT-TYPE: application/json X-AMZN-REQUESTID: 8dc0e749-c8cd-48bd-8520-da6be00d528b X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.DescribeIdentityPoolUsage HOST: cognito-sync.us-east-1.amazonaws.com:443 X-AMZ-DATE: 20141111T205737Z AUTHORIZATION: AWS4-HMAC-SHA256 Credential=
    /// <credential>
    /// , SignedHeaders=content-type;host;x-amz-date;x-amz-target;x-amzn-requestid, Signature=
    /// <signature>
    /// { "Operation": "com.amazonaws.cognito.sync.model#DescribeIdentityPoolUsage", "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService", "Input": { "IdentityPoolId": "IDENTITY_POOL_ID" } }
    /// </signature>
    /// </credential>
    /// </request>
    /// <response>
    /// 1.1 200 OK x-amzn-requestid: 8dc0e749-c8cd-48bd-8520-da6be00d528b content-type: application/json content-length: 271 date: Tue, 11 Nov 2014 20:57:37 GMT { "Output": { "__type": "com.amazonaws.cognito.sync.model#DescribeIdentityPoolUsageResponse", "IdentityPoolUsage": { "DataStorage": 0, "IdentityPoolId": "IDENTITY_POOL_ID", "LastModifiedDate": 1.413231134115E9, "SyncSessionsCount": null } }, "Version": "1.0" }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIdentityPoolUsage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_identity_pool_usage_input::Builder,
    }
    impl DescribeIdentityPoolUsage {
        /// Creates a new `DescribeIdentityPoolUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityPoolUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIdentityPoolUsageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentityUsage`.
    ///
    /// <p>Gets usage information for an identity, including number of datasets and data usage.</p>
    /// <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials.</p> <examples>
    /// <example>
    /// <name>
    /// DescribeIdentityUsage
    /// </name>
    /// <description>
    /// The following examples have been edited for readability.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 CONTENT-TYPE: application/json X-AMZN-REQUESTID: 33f9b4e4-a177-4aad-a3bb-6edb7980b283 X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.DescribeIdentityUsage HOST: cognito-sync.us-east-1.amazonaws.com:443 X-AMZ-DATE: 20141111T215129Z AUTHORIZATION: AWS4-HMAC-SHA256 Credential=
    /// <credential>
    /// , SignedHeaders=content-type;host;x-amz-date;x-amz-target;x-amzn-requestid, Signature=
    /// <signature>
    /// { "Operation": "com.amazonaws.cognito.sync.model#DescribeIdentityUsage", "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService", "Input": { "IdentityPoolId": "IDENTITY_POOL_ID", "IdentityId": "IDENTITY_ID" } }
    /// </signature>
    /// </credential>
    /// </request>
    /// <response>
    /// 1.1 200 OK x-amzn-requestid: 33f9b4e4-a177-4aad-a3bb-6edb7980b283 content-type: application/json content-length: 318 date: Tue, 11 Nov 2014 21:51:29 GMT { "Output": { "__type": "com.amazonaws.cognito.sync.model#DescribeIdentityUsageResponse", "IdentityUsage": { "DataStorage": 16, "DatasetCount": 1, "IdentityId": "IDENTITY_ID", "IdentityPoolId": "IDENTITY_POOL_ID", "LastModifiedDate": 1.412974081336E9 } }, "Version": "1.0" }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIdentityUsage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_identity_usage_input::Builder,
    }
    impl DescribeIdentityUsage {
        /// Creates a new `DescribeIdentityUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIdentityUsageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBulkPublishDetails`.
    ///
    /// <p>Get the status of the last BulkPublish operation for an identity pool.</p>
    /// <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBulkPublishDetails {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bulk_publish_details_input::Builder,
    }
    impl GetBulkPublishDetails {
        /// Creates a new `GetBulkPublishDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBulkPublishDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBulkPublishDetailsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCognitoEvents`.
    ///
    /// <p>Gets the events and the corresponding Lambda functions associated with an identity pool.</p>
    /// <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCognitoEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_cognito_events_input::Builder,
    }
    impl GetCognitoEvents {
        /// Creates a new `GetCognitoEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCognitoEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCognitoEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Cognito Identity Pool ID for the request</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>The Cognito Identity Pool ID for the request</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityPoolConfiguration`.
    ///
    /// <p>Gets the configuration settings of an identity pool.</p>
    /// <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p> <examples>
    /// <example>
    /// <name>
    /// GetIdentityPoolConfiguration
    /// </name>
    /// <description>
    /// The following examples have been edited for readability.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 CONTENT-TYPE: application/json X-AMZN-REQUESTID: b1cfdd4b-f620-4fe4-be0f-02024a1d33da X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.GetIdentityPoolConfiguration HOST: cognito-sync.us-east-1.amazonaws.com X-AMZ-DATE: 20141004T195722Z AUTHORIZATION: AWS4-HMAC-SHA256 Credential=
    /// <credential>
    /// , SignedHeaders=content-type;content-length;host;x-amz-date;x-amz-target, Signature=
    /// <signature>
    /// { "Operation": "com.amazonaws.cognito.sync.model#GetIdentityPoolConfiguration", "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService", "Input": { "IdentityPoolId": "ID_POOL_ID" } }
    /// </signature>
    /// </credential>
    /// </request>
    /// <response>
    /// 1.1 200 OK x-amzn-requestid: b1cfdd4b-f620-4fe4-be0f-02024a1d33da date: Sat, 04 Oct 2014 19:57:22 GMT content-type: application/json content-length: 332 { "Output": { "__type": "com.amazonaws.cognito.sync.model#GetIdentityPoolConfigurationResponse", "IdentityPoolId": "ID_POOL_ID", "PushSync": { "ApplicationArns": ["PLATFORMARN1", "PLATFORMARN2"], "RoleArn": "ROLEARN" } }, "Version": "1.0" }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIdentityPoolConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_identity_pool_configuration_input::Builder,
    }
    impl GetIdentityPoolConfiguration {
        /// Creates a new `GetIdentityPoolConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityPoolConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityPoolConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. This is the ID of the pool for which to return a configuration.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. This is the ID of the pool for which to return a configuration.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasets`.
    ///
    /// <p>Lists datasets for an identity. With Amazon Cognito Sync, each identity has access only to its own data. Thus, the credentials used to make this API call need to have access to the identity data.</p>
    /// <p>ListDatasets can be called with temporary user credentials provided by Cognito Identity or with developer credentials. You should use the Cognito Identity credentials to make this API call.</p> <examples>
    /// <example>
    /// <name>
    /// ListDatasets
    /// </name>
    /// <description>
    /// The following examples have been edited for readability.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 CONTENT-TYPE: application/json X-AMZN-REQUESTID: 15225768-209f-4078-aaed-7494ace9f2db X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.ListDatasets HOST: cognito-sync.us-east-1.amazonaws.com:443 X-AMZ-DATE: 20141111T215640Z AUTHORIZATION: AWS4-HMAC-SHA256 Credential=
    /// <credential>
    /// , SignedHeaders=content-type;host;x-amz-date;x-amz-target;x-amzn-requestid, Signature=
    /// <signature>
    /// { "Operation": "com.amazonaws.cognito.sync.model#ListDatasets", "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService", "Input": { "IdentityPoolId": "IDENTITY_POOL_ID", "IdentityId": "IDENTITY_ID", "MaxResults": "3" } }
    /// </signature>
    /// </credential>
    /// </request>
    /// <response>
    /// 1.1 200 OK x-amzn-requestid: 15225768-209f-4078-aaed-7494ace9f2db, 15225768-209f-4078-aaed-7494ace9f2db content-type: application/json content-length: 355 date: Tue, 11 Nov 2014 21:56:40 GMT { "Output": { "__type": "com.amazonaws.cognito.sync.model#ListDatasetsResponse", "Count": 1, "Datasets": [ { "CreationDate": 1.412974057151E9, "DataStorage": 16, "DatasetName": "my_list", "IdentityId": "IDENTITY_ID", "LastModifiedBy": "123456789012", "LastModifiedDate": 1.412974057244E9, "NumRecords": 1 }], "NextToken": null }, "Version": "1.0" }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDatasets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_datasets_input::Builder,
    }
    impl ListDatasets {
        /// Creates a new `ListDatasets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// A pagination token for obtaining the next page of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A pagination token for obtaining the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The maximum number of results to be returned.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// The maximum number of results to be returned.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentityPoolUsage`.
    ///
    /// <p>Gets a list of identity pools registered with Cognito.</p>
    /// <p>ListIdentityPoolUsage can only be called with developer credentials. You cannot make this API call with the temporary user credentials provided by Cognito Identity.</p> <examples>
    /// <example>
    /// <name>
    /// ListIdentityPoolUsage
    /// </name>
    /// <description>
    /// The following examples have been edited for readability.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 CONTENT-TYPE: application/json X-AMZN-REQUESTID: 9be7c425-ef05-48c0-aef3-9f0ff2fe17d3 X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.ListIdentityPoolUsage HOST: cognito-sync.us-east-1.amazonaws.com:443 X-AMZ-DATE: 20141111T211414Z AUTHORIZATION: AWS4-HMAC-SHA256 Credential=
    /// <credential>
    /// , SignedHeaders=content-type;host;x-amz-date;x-amz-target;x-amzn-requestid, Signature=
    /// <signature>
    /// { "Operation": "com.amazonaws.cognito.sync.model#ListIdentityPoolUsage", "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService", "Input": { "MaxResults": "2" } }
    /// </signature>
    /// </credential>
    /// </request>
    /// <response>
    /// 1.1 200 OK x-amzn-requestid: 9be7c425-ef05-48c0-aef3-9f0ff2fe17d3 content-type: application/json content-length: 519 date: Tue, 11 Nov 2014 21:14:14 GMT { "Output": { "__type": "com.amazonaws.cognito.sync.model#ListIdentityPoolUsageResponse", "Count": 2, "IdentityPoolUsages": [ { "DataStorage": 0, "IdentityPoolId": "IDENTITY_POOL_ID", "LastModifiedDate": 1.413836234607E9, "SyncSessionsCount": null }, { "DataStorage": 0, "IdentityPoolId": "IDENTITY_POOL_ID", "LastModifiedDate": 1.410892165601E9, "SyncSessionsCount": null }], "MaxResults": 2, "NextToken": "dXMtZWFzdC0xOjBjMWJhMDUyLWUwOTgtNDFmYS1hNzZlLWVhYTJjMTI1Zjg2MQ==" }, "Version": "1.0" }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIdentityPoolUsage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_identity_pool_usage_input::Builder,
    }
    impl ListIdentityPoolUsage {
        /// Creates a new `ListIdentityPoolUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentityPoolUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentityPoolUsageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A pagination token for obtaining the next page of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A pagination token for obtaining the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The maximum number of results to be returned.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// The maximum number of results to be returned.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecords`.
    ///
    /// <p>Gets paginated records, optionally changed after a particular sync count for a dataset and identity. With Amazon Cognito Sync, each identity has access only to its own data. Thus, the credentials used to make this API call need to have access to the identity data.</p>
    /// <p>ListRecords can be called with temporary user credentials provided by Cognito Identity or with developer credentials. You should use Cognito Identity credentials to make this API call.</p> <examples>
    /// <example>
    /// <name>
    /// ListRecords
    /// </name>
    /// <description>
    /// The following examples have been edited for readability.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 CONTENT-TYPE: application/json X-AMZN-REQUESTID: b3d2e31e-d6b7-4612-8e84-c9ba288dab5d X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.ListRecords HOST: cognito-sync.us-east-1.amazonaws.com:443 X-AMZ-DATE: 20141111T183230Z AUTHORIZATION: AWS4-HMAC-SHA256 Credential=
    /// <credential>
    /// , SignedHeaders=content-type;host;x-amz-date;x-amz-target;x-amzn-requestid, Signature=
    /// <signature>
    /// { "Operation": "com.amazonaws.cognito.sync.model#ListRecords", "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService", "Input": { "IdentityPoolId": "IDENTITY_POOL_ID", "IdentityId": "IDENTITY_ID", "DatasetName": "newDataSet" } }
    /// </signature>
    /// </credential>
    /// </request>
    /// <response>
    /// 1.1 200 OK x-amzn-requestid: b3d2e31e-d6b7-4612-8e84-c9ba288dab5d content-type: application/json content-length: 623 date: Tue, 11 Nov 2014 18:32:30 GMT { "Output": { "__type": "com.amazonaws.cognito.sync.model#ListRecordsResponse", "Count": 0, "DatasetDeletedAfterRequestedSyncCount": false, "DatasetExists": false, "DatasetSyncCount": 0, "LastModifiedBy": null, "MergedDatasetNames": null, "NextToken": null, "Records": [], "SyncSessionToken": "SYNC_SESSION_TOKEN" }, "Version": "1.0" }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRecords {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_records_input::Builder,
    }
    impl ListRecords {
        /// Creates a new `ListRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecordsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// The last server sync count for this record.
        pub fn last_sync_count(mut self, input: i64) -> Self {
            self.inner = self.inner.last_sync_count(input);
            self
        }
        /// The last server sync count for this record.
        pub fn set_last_sync_count(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_last_sync_count(input);
            self
        }
        /// A pagination token for obtaining the next page of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A pagination token for obtaining the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The maximum number of results to be returned.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// The maximum number of results to be returned.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token containing a session ID, identity ID, and expiration.
        pub fn sync_session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_session_token(input.into());
            self
        }
        /// A token containing a session ID, identity ID, and expiration.
        pub fn set_sync_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sync_session_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterDevice`.
    ///
    /// <p>Registers a device to receive push sync notifications.</p>
    /// <p>This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API with developer credentials.</p> <examples>
    /// <example>
    /// <name>
    /// RegisterDevice
    /// </name>
    /// <description>
    /// The following examples have been edited for readability.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 CONTENT-TYPE: application/json X-AMZN-REQUESTID: 368f9200-3eca-449e-93b3-7b9c08d8e185 X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.RegisterDevice HOST: cognito-sync.us-east-1.amazonaws.com X-AMZ-DATE: 20141004T194643Z X-AMZ-SECURITY-TOKEN:
    /// <securitytoken>
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=
    /// <credential>
    /// , SignedHeaders=content-type;content-length;host;x-amz-date;x-amz-target, Signature=
    /// <signature>
    /// { "Operation": "com.amazonaws.cognito.sync.model#RegisterDevice", "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService", "Input": { "IdentityPoolId": "ID_POOL_ID", "IdentityId": "IDENTITY_ID", "Platform": "GCM", "Token": "PUSH_TOKEN" } }
    /// </signature>
    /// </credential>
    /// </securitytoken>
    /// </request>
    /// <response>
    /// 1.1 200 OK x-amzn-requestid: 368f9200-3eca-449e-93b3-7b9c08d8e185 date: Sat, 04 Oct 2014 19:46:44 GMT content-type: application/json content-length: 145 { "Output": { "__type": "com.amazonaws.cognito.sync.model#RegisterDeviceResponse", "DeviceId": "5cd28fbe-dd83-47ab-9f83-19093a5fb014" }, "Version": "1.0" }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterDevice {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_device_input::Builder,
    }
    impl RegisterDevice {
        /// Creates a new `RegisterDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterDeviceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. Here, the ID of the pool that the identity belongs to.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. Here, the ID of the pool that the identity belongs to.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>The unique ID for this identity.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>The unique ID for this identity.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p>The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>The push token.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>The push token.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetCognitoEvents`.
    ///
    /// <p>Sets the AWS Lambda function for a given event type for an identity pool. This request only updates the key/value pair specified. Other key/values pairs are not updated. To remove a key value pair, pass a empty value for the particular key.</p>
    /// <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetCognitoEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_cognito_events_input::Builder,
    }
    impl SetCognitoEvents {
        /// Creates a new `SetCognitoEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetCognitoEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::SetCognitoEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Cognito Identity Pool to use when configuring Cognito Events</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>The Cognito Identity Pool to use when configuring Cognito Events</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// Adds a key-value pair to `Events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The events to configure</p>
        pub fn events(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.events(k.into(), v.into());
            self
        }
        /// <p>The events to configure</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_events(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityPoolConfiguration`.
    ///
    /// <p>Sets the necessary configuration for push sync.</p>
    /// <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p> <examples>
    /// <example>
    /// <name>
    /// SetIdentityPoolConfiguration
    /// </name>
    /// <description>
    /// The following examples have been edited for readability.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 CONTENT-TYPE: application/json X-AMZN-REQUESTID: a46db021-f5dd-45d6-af5b-7069fa4a211b X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.SetIdentityPoolConfiguration HOST: cognito-sync.us-east-1.amazonaws.com X-AMZ-DATE: 20141004T200006Z AUTHORIZATION: AWS4-HMAC-SHA256 Credential=
    /// <credential>
    /// , SignedHeaders=content-type;content-length;host;x-amz-date;x-amz-target, Signature=
    /// <signature>
    /// { "Operation": "com.amazonaws.cognito.sync.model#SetIdentityPoolConfiguration", "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService", "Input": { "IdentityPoolId": "ID_POOL_ID", "PushSync": { "ApplicationArns": ["PLATFORMARN1", "PLATFORMARN2"], "RoleArn": "ROLEARN" } } }
    /// </signature>
    /// </credential>
    /// </request>
    /// <response>
    /// 1.1 200 OK x-amzn-requestid: a46db021-f5dd-45d6-af5b-7069fa4a211b date: Sat, 04 Oct 2014 20:00:06 GMT content-type: application/json content-length: 332 { "Output": { "__type": "com.amazonaws.cognito.sync.model#SetIdentityPoolConfigurationResponse", "IdentityPoolId": "ID_POOL_ID", "PushSync": { "ApplicationArns": ["PLATFORMARN1", "PLATFORMARN2"], "RoleArn": "ROLEARN" } }, "Version": "1.0" }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetIdentityPoolConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_identity_pool_configuration_input::Builder,
    }
    impl SetIdentityPoolConfiguration {
        /// Creates a new `SetIdentityPoolConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityPoolConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIdentityPoolConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. This is the ID of the pool to modify.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. This is the ID of the pool to modify.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>Options to apply to this identity pool for push synchronization.</p>
        pub fn push_sync(mut self, input: crate::model::PushSync) -> Self {
            self.inner = self.inner.push_sync(input);
            self
        }
        /// <p>Options to apply to this identity pool for push synchronization.</p>
        pub fn set_push_sync(mut self, input: std::option::Option<crate::model::PushSync>) -> Self {
            self.inner = self.inner.set_push_sync(input);
            self
        }
        /// Options to apply to this identity pool for Amazon Cognito streams.
        pub fn cognito_streams(mut self, input: crate::model::CognitoStreams) -> Self {
            self.inner = self.inner.cognito_streams(input);
            self
        }
        /// Options to apply to this identity pool for Amazon Cognito streams.
        pub fn set_cognito_streams(
            mut self,
            input: std::option::Option<crate::model::CognitoStreams>,
        ) -> Self {
            self.inner = self.inner.set_cognito_streams(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SubscribeToDataset`.
    ///
    /// <p>Subscribes to receive notifications when a dataset is modified by another device.</p>
    /// <p>This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API with developer credentials.</p> <examples>
    /// <example>
    /// <name>
    /// SubscribeToDataset
    /// </name>
    /// <description>
    /// The following examples have been edited for readability.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 CONTENT-TYPE: application/json X-AMZN-REQUESTID: 8b9932b7-201d-4418-a960-0a470e11de9f X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.SubscribeToDataset HOST: cognito-sync.us-east-1.amazonaws.com X-AMZ-DATE: 20141004T195350Z X-AMZ-SECURITY-TOKEN:
    /// <securitytoken>
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=
    /// <credential>
    /// , SignedHeaders=content-type;content-length;host;x-amz-date;x-amz-target, Signature=
    /// <signature>
    /// { "Operation": "com.amazonaws.cognito.sync.model#SubscribeToDataset", "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService", "Input": { "IdentityPoolId": "ID_POOL_ID", "IdentityId": "IDENTITY_ID", "DatasetName": "Rufus", "DeviceId": "5cd28fbe-dd83-47ab-9f83-19093a5fb014" } }
    /// </signature>
    /// </credential>
    /// </securitytoken>
    /// </request>
    /// <response>
    /// 1.1 200 OK x-amzn-requestid: 8b9932b7-201d-4418-a960-0a470e11de9f date: Sat, 04 Oct 2014 19:53:50 GMT content-type: application/json content-length: 99 { "Output": { "__type": "com.amazonaws.cognito.sync.model#SubscribeToDatasetResponse" }, "Version": "1.0" }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SubscribeToDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::subscribe_to_dataset_input::Builder,
    }
    impl SubscribeToDataset {
        /// Creates a new `SubscribeToDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SubscribeToDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::SubscribeToDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. The ID of the pool to which the identity belongs.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. The ID of the pool to which the identity belongs.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The name of the dataset to subcribe to.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset to subcribe to.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnsubscribeFromDataset`.
    ///
    /// <p>Unsubscribes from receiving notifications when a dataset is modified by another device.</p>
    /// <p>This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API with developer credentials.</p> <examples>
    /// <example>
    /// <name>
    /// UnsubscribeFromDataset
    /// </name>
    /// <description>
    /// The following examples have been edited for readability.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 CONTENT-TYPE: application/json X-AMZ-REQUESTSUPERTRACE: true X-AMZN-REQUESTID: 676896d6-14ca-45b1-8029-6d36b10a077e X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.UnsubscribeFromDataset HOST: cognito-sync.us-east-1.amazonaws.com X-AMZ-DATE: 20141004T195446Z X-AMZ-SECURITY-TOKEN:
    /// <securitytoken>
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=
    /// <credential>
    /// , SignedHeaders=content-type;content-length;host;x-amz-date;x-amz-target, Signature=
    /// <signature>
    /// { "Operation": "com.amazonaws.cognito.sync.model#UnsubscribeFromDataset", "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService", "Input": { "IdentityPoolId": "ID_POOL_ID", "IdentityId": "IDENTITY_ID", "DatasetName": "Rufus", "DeviceId": "5cd28fbe-dd83-47ab-9f83-19093a5fb014" } }
    /// </signature>
    /// </credential>
    /// </securitytoken>
    /// </request>
    /// <response>
    /// 1.1 200 OK x-amzn-requestid: 676896d6-14ca-45b1-8029-6d36b10a077e date: Sat, 04 Oct 2014 19:54:46 GMT content-type: application/json content-length: 103 { "Output": { "__type": "com.amazonaws.cognito.sync.model#UnsubscribeFromDatasetResponse" }, "Version": "1.0" }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UnsubscribeFromDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::unsubscribe_from_dataset_input::Builder,
    }
    impl UnsubscribeFromDataset {
        /// Creates a new `UnsubscribeFromDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnsubscribeFromDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::UnsubscribeFromDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. The ID of the pool to which this identity belongs.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. The ID of the pool to which this identity belongs.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The name of the dataset from which to unsubcribe.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset from which to unsubcribe.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecords`.
    ///
    /// <p>Posts updates to records and adds and deletes records for a dataset and user.</p>
    /// <p>The sync count in the record patch is your last known sync count for that record. The server will reject an UpdateRecords request with a ResourceConflictException if you try to patch a record with a new value but a stale sync count.</p>
    /// <p>For example, if the sync count on the server is 5 for a key called highScore and you try and submit a new highScore with sync count of 4, the request will be rejected. To obtain the current sync count for a record, call ListRecords. On a successful update of the record, the response returns the new sync count for that record. You should present that sync count the next time you try to update that same record. When the record does not exist, specify the sync count as 0.</p>
    /// <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRecords {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_records_input::Builder,
    }
    impl UpdateRecords {
        /// Creates a new `UpdateRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecordsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// Appends an item to `RecordPatches`.
        ///
        /// To override the contents of this collection use [`set_record_patches`](Self::set_record_patches).
        ///
        /// A list of patch operations.
        pub fn record_patches(mut self, input: crate::model::RecordPatch) -> Self {
            self.inner = self.inner.record_patches(input);
            self
        }
        /// A list of patch operations.
        pub fn set_record_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecordPatch>>,
        ) -> Self {
            self.inner = self.inner.set_record_patches(input);
            self
        }
        /// The SyncSessionToken returned by a previous call to ListRecords for this dataset and identity.
        pub fn sync_session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_session_token(input.into());
            self
        }
        /// The SyncSessionToken returned by a previous call to ListRecords for this dataset and identity.
        pub fn set_sync_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sync_session_token(input);
            self
        }
        /// Intended to supply a device ID that will populate the lastModifiedBy field referenced in other methods. The ClientContext field is not yet implemented.
        pub fn client_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_context(input.into());
            self
        }
        /// Intended to supply a device ID that will populate the lastModifiedBy field referenced in other methods. The ClientContext field is not yet implemented.
        pub fn set_client_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_context(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
