// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// The basic data structure of a dataset.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Record {
    /// The key for the record.
    pub key: std::option::Option<std::string::String>,
    /// The value for the record.
    pub value: std::option::Option<std::string::String>,
    /// The server sync count for this record.
    pub sync_count: std::option::Option<i64>,
    /// The date on which the record was last
    /// modified.
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// The user/device that made the last change to this
    /// record.
    pub last_modified_by: std::option::Option<std::string::String>,
    /// The last modified date of the client
    /// device.
    pub device_last_modified_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Record {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Record");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("sync_count", &self.sync_count);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("device_last_modified_date", &self.device_last_modified_date);
        formatter.finish()
    }
}
/// See [`Record`](crate::model::Record)
pub mod record {
    /// A builder for [`Record`](crate::model::Record)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) sync_count: std::option::Option<i64>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) device_last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// The key for the record.
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// The key for the record.
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// The value for the record.
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// The value for the record.
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// The server sync count for this record.
        pub fn sync_count(mut self, input: i64) -> Self {
            self.sync_count = Some(input);
            self
        }
        /// The server sync count for this record.
        pub fn set_sync_count(mut self, input: std::option::Option<i64>) -> Self {
            self.sync_count = input;
            self
        }
        /// The date on which the record was last
        /// modified.
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// The date on which the record was last
        /// modified.
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// The user/device that made the last change to this
        /// record.
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// The user/device that made the last change to this
        /// record.
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// The last modified date of the client
        /// device.
        pub fn device_last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.device_last_modified_date = Some(input);
            self
        }
        /// The last modified date of the client
        /// device.
        pub fn set_device_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.device_last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Record`](crate::model::Record)
        pub fn build(self) -> crate::model::Record {
            crate::model::Record {
                key: self.key,
                value: self.value,
                sync_count: self.sync_count,
                last_modified_date: self.last_modified_date,
                last_modified_by: self.last_modified_by,
                device_last_modified_date: self.device_last_modified_date,
            }
        }
    }
}
impl Record {
    /// Creates a new builder-style object to manufacture [`Record`](crate::model::Record)
    pub fn builder() -> crate::model::record::Builder {
        crate::model::record::Builder::default()
    }
}

/// An update operation for a record.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordPatch {
    /// An operation, either replace or remove.
    pub op: std::option::Option<crate::model::Operation>,
    /// The key associated with the record patch.
    pub key: std::option::Option<std::string::String>,
    /// The value associated with the record
    /// patch.
    pub value: std::option::Option<std::string::String>,
    /// Last known server sync count for this record. Set
    /// to 0 if unknown.
    pub sync_count: std::option::Option<i64>,
    /// The last modified date of the client
    /// device.
    pub device_last_modified_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for RecordPatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordPatch");
        formatter.field("op", &self.op);
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("sync_count", &self.sync_count);
        formatter.field("device_last_modified_date", &self.device_last_modified_date);
        formatter.finish()
    }
}
/// See [`RecordPatch`](crate::model::RecordPatch)
pub mod record_patch {
    /// A builder for [`RecordPatch`](crate::model::RecordPatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) op: std::option::Option<crate::model::Operation>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) sync_count: std::option::Option<i64>,
        pub(crate) device_last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// An operation, either replace or remove.
        pub fn op(mut self, input: crate::model::Operation) -> Self {
            self.op = Some(input);
            self
        }
        /// An operation, either replace or remove.
        pub fn set_op(mut self, input: std::option::Option<crate::model::Operation>) -> Self {
            self.op = input;
            self
        }
        /// The key associated with the record patch.
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// The key associated with the record patch.
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// The value associated with the record
        /// patch.
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// The value associated with the record
        /// patch.
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Last known server sync count for this record. Set
        /// to 0 if unknown.
        pub fn sync_count(mut self, input: i64) -> Self {
            self.sync_count = Some(input);
            self
        }
        /// Last known server sync count for this record. Set
        /// to 0 if unknown.
        pub fn set_sync_count(mut self, input: std::option::Option<i64>) -> Self {
            self.sync_count = input;
            self
        }
        /// The last modified date of the client
        /// device.
        pub fn device_last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.device_last_modified_date = Some(input);
            self
        }
        /// The last modified date of the client
        /// device.
        pub fn set_device_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.device_last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordPatch`](crate::model::RecordPatch)
        pub fn build(self) -> crate::model::RecordPatch {
            crate::model::RecordPatch {
                op: self.op,
                key: self.key,
                value: self.value,
                sync_count: self.sync_count,
                device_last_modified_date: self.device_last_modified_date,
            }
        }
    }
}
impl RecordPatch {
    /// Creates a new builder-style object to manufacture [`RecordPatch`](crate::model::RecordPatch)
    pub fn builder() -> crate::model::record_patch::Builder {
        crate::model::record_patch::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Operation {
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    #[allow(missing_docs)] // documentation missing in model
    Replace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Operation {
    fn from(s: &str) -> Self {
        match s {
            "remove" => Operation::Remove,
            "replace" => Operation::Replace,
            other => Operation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Operation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Operation::from(s))
    }
}
impl Operation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Operation::Remove => "remove",
            Operation::Replace => "replace",
            Operation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["remove", "replace"]
    }
}
impl AsRef<str> for Operation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Configuration options for configure Cognito streams.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CognitoStreams {
    /// The name of the Cognito stream to receive updates. This stream must be in the developers account and in the same region as the identity pool.
    pub stream_name: std::option::Option<std::string::String>,
    /// The ARN of the role Amazon Cognito can assume in order to publish to the stream. This role must grant access to Amazon Cognito (cognito-sync) to invoke PutRecord on your Cognito stream.
    pub role_arn: std::option::Option<std::string::String>,
    /// Status of the Cognito streams. Valid values are:
    /// <p>ENABLED - Streaming of updates to identity pool is enabled.</p>
    /// <p>DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if StreamingStatus is DISABLED.</p>
    pub streaming_status: std::option::Option<crate::model::StreamingStatus>,
}
impl std::fmt::Debug for CognitoStreams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CognitoStreams");
        formatter.field("stream_name", &self.stream_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("streaming_status", &self.streaming_status);
        formatter.finish()
    }
}
/// See [`CognitoStreams`](crate::model::CognitoStreams)
pub mod cognito_streams {
    /// A builder for [`CognitoStreams`](crate::model::CognitoStreams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) streaming_status: std::option::Option<crate::model::StreamingStatus>,
    }
    impl Builder {
        /// The name of the Cognito stream to receive updates. This stream must be in the developers account and in the same region as the identity pool.
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// The name of the Cognito stream to receive updates. This stream must be in the developers account and in the same region as the identity pool.
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// The ARN of the role Amazon Cognito can assume in order to publish to the stream. This role must grant access to Amazon Cognito (cognito-sync) to invoke PutRecord on your Cognito stream.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The ARN of the role Amazon Cognito can assume in order to publish to the stream. This role must grant access to Amazon Cognito (cognito-sync) to invoke PutRecord on your Cognito stream.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Status of the Cognito streams. Valid values are:
        /// <p>ENABLED - Streaming of updates to identity pool is enabled.</p>
        /// <p>DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if StreamingStatus is DISABLED.</p>
        pub fn streaming_status(mut self, input: crate::model::StreamingStatus) -> Self {
            self.streaming_status = Some(input);
            self
        }
        /// Status of the Cognito streams. Valid values are:
        /// <p>ENABLED - Streaming of updates to identity pool is enabled.</p>
        /// <p>DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if StreamingStatus is DISABLED.</p>
        pub fn set_streaming_status(
            mut self,
            input: std::option::Option<crate::model::StreamingStatus>,
        ) -> Self {
            self.streaming_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CognitoStreams`](crate::model::CognitoStreams)
        pub fn build(self) -> crate::model::CognitoStreams {
            crate::model::CognitoStreams {
                stream_name: self.stream_name,
                role_arn: self.role_arn,
                streaming_status: self.streaming_status,
            }
        }
    }
}
impl CognitoStreams {
    /// Creates a new builder-style object to manufacture [`CognitoStreams`](crate::model::CognitoStreams)
    pub fn builder() -> crate::model::cognito_streams::Builder {
        crate::model::cognito_streams::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamingStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamingStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => StreamingStatus::Disabled,
            "ENABLED" => StreamingStatus::Enabled,
            other => StreamingStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamingStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamingStatus::from(s))
    }
}
impl StreamingStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamingStatus::Disabled => "DISABLED",
            StreamingStatus::Enabled => "ENABLED",
            StreamingStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for StreamingStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration options to be applied to the identity pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PushSync {
    /// <p>List of SNS platform application ARNs that could be used by clients.</p>
    pub application_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A role configured to allow Cognito to call SNS on behalf of the developer.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PushSync {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PushSync");
        formatter.field("application_arns", &self.application_arns);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`PushSync`](crate::model::PushSync)
pub mod push_sync {
    /// A builder for [`PushSync`](crate::model::PushSync)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `application_arns`.
        ///
        /// To override the contents of this collection use [`set_application_arns`](Self::set_application_arns).
        ///
        /// <p>List of SNS platform application ARNs that could be used by clients.</p>
        pub fn application_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.application_arns.unwrap_or_default();
            v.push(input.into());
            self.application_arns = Some(v);
            self
        }
        /// <p>List of SNS platform application ARNs that could be used by clients.</p>
        pub fn set_application_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.application_arns = input;
            self
        }
        /// <p>A role configured to allow Cognito to call SNS on behalf of the developer.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>A role configured to allow Cognito to call SNS on behalf of the developer.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PushSync`](crate::model::PushSync)
        pub fn build(self) -> crate::model::PushSync {
            crate::model::PushSync {
                application_arns: self.application_arns,
                role_arn: self.role_arn,
            }
        }
    }
}
impl PushSync {
    /// Creates a new builder-style object to manufacture [`PushSync`](crate::model::PushSync)
    pub fn builder() -> crate::model::push_sync::Builder {
        crate::model::push_sync::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Platform {
    #[allow(missing_docs)] // documentation missing in model
    Adm,
    #[allow(missing_docs)] // documentation missing in model
    Apns,
    #[allow(missing_docs)] // documentation missing in model
    ApnsSandbox,
    #[allow(missing_docs)] // documentation missing in model
    Gcm,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Platform {
    fn from(s: &str) -> Self {
        match s {
            "ADM" => Platform::Adm,
            "APNS" => Platform::Apns,
            "APNS_SANDBOX" => Platform::ApnsSandbox,
            "GCM" => Platform::Gcm,
            other => Platform::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Platform {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Platform::from(s))
    }
}
impl Platform {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Platform::Adm => "ADM",
            Platform::Apns => "APNS",
            Platform::ApnsSandbox => "APNS_SANDBOX",
            Platform::Gcm => "GCM",
            Platform::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADM", "APNS", "APNS_SANDBOX", "GCM"]
    }
}
impl AsRef<str> for Platform {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Usage information for the identity
/// pool.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityPoolUsage {
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// Number of sync sessions for the
    /// identity pool.
    pub sync_sessions_count: std::option::Option<i64>,
    /// Data storage information for the identity
    /// pool.
    pub data_storage: std::option::Option<i64>,
    /// Date on which the identity pool was
    /// last modified.
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for IdentityPoolUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityPoolUsage");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("sync_sessions_count", &self.sync_sessions_count);
        formatter.field("data_storage", &self.data_storage);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`IdentityPoolUsage`](crate::model::IdentityPoolUsage)
pub mod identity_pool_usage {
    /// A builder for [`IdentityPoolUsage`](crate::model::IdentityPoolUsage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) sync_sessions_count: std::option::Option<i64>,
        pub(crate) data_storage: std::option::Option<i64>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Number of sync sessions for the
        /// identity pool.
        pub fn sync_sessions_count(mut self, input: i64) -> Self {
            self.sync_sessions_count = Some(input);
            self
        }
        /// Number of sync sessions for the
        /// identity pool.
        pub fn set_sync_sessions_count(mut self, input: std::option::Option<i64>) -> Self {
            self.sync_sessions_count = input;
            self
        }
        /// Data storage information for the identity
        /// pool.
        pub fn data_storage(mut self, input: i64) -> Self {
            self.data_storage = Some(input);
            self
        }
        /// Data storage information for the identity
        /// pool.
        pub fn set_data_storage(mut self, input: std::option::Option<i64>) -> Self {
            self.data_storage = input;
            self
        }
        /// Date on which the identity pool was
        /// last modified.
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// Date on which the identity pool was
        /// last modified.
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityPoolUsage`](crate::model::IdentityPoolUsage)
        pub fn build(self) -> crate::model::IdentityPoolUsage {
            crate::model::IdentityPoolUsage {
                identity_pool_id: self.identity_pool_id,
                sync_sessions_count: self.sync_sessions_count,
                data_storage: self.data_storage,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl IdentityPoolUsage {
    /// Creates a new builder-style object to manufacture [`IdentityPoolUsage`](crate::model::IdentityPoolUsage)
    pub fn builder() -> crate::model::identity_pool_usage::Builder {
        crate::model::identity_pool_usage::Builder::default()
    }
}

/// A collection of data for an identity pool. An identity pool can
/// have multiple datasets. A dataset is per identity and can be general or associated with a
/// particular entity in an application (like a saved game). Datasets are automatically created if
/// they don't exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value
/// pairs.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Dataset {
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_id: std::option::Option<std::string::String>,
    /// A string of up to 128 characters. Allowed characters
    /// are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
    pub dataset_name: std::option::Option<std::string::String>,
    /// Date on which the dataset was
    /// created.
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// Date when the dataset was last
    /// modified.
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// The device that made the last change to this
    /// dataset.
    pub last_modified_by: std::option::Option<std::string::String>,
    /// Total size in bytes of the records in this
    /// dataset.
    pub data_storage: std::option::Option<i64>,
    /// Number of records in this dataset.
    pub num_records: std::option::Option<i64>,
}
impl std::fmt::Debug for Dataset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Dataset");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("data_storage", &self.data_storage);
        formatter.field("num_records", &self.num_records);
        formatter.finish()
    }
}
/// See [`Dataset`](crate::model::Dataset)
pub mod dataset {
    /// A builder for [`Dataset`](crate::model::Dataset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) data_storage: std::option::Option<i64>,
        pub(crate) num_records: std::option::Option<i64>,
    }
    impl Builder {
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// A string of up to 128 characters. Allowed characters
        /// are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// A string of up to 128 characters. Allowed characters
        /// are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// Date on which the dataset was
        /// created.
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// Date on which the dataset was
        /// created.
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Date when the dataset was last
        /// modified.
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// Date when the dataset was last
        /// modified.
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// The device that made the last change to this
        /// dataset.
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// The device that made the last change to this
        /// dataset.
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Total size in bytes of the records in this
        /// dataset.
        pub fn data_storage(mut self, input: i64) -> Self {
            self.data_storage = Some(input);
            self
        }
        /// Total size in bytes of the records in this
        /// dataset.
        pub fn set_data_storage(mut self, input: std::option::Option<i64>) -> Self {
            self.data_storage = input;
            self
        }
        /// Number of records in this dataset.
        pub fn num_records(mut self, input: i64) -> Self {
            self.num_records = Some(input);
            self
        }
        /// Number of records in this dataset.
        pub fn set_num_records(mut self, input: std::option::Option<i64>) -> Self {
            self.num_records = input;
            self
        }
        /// Consumes the builder and constructs a [`Dataset`](crate::model::Dataset)
        pub fn build(self) -> crate::model::Dataset {
            crate::model::Dataset {
                identity_id: self.identity_id,
                dataset_name: self.dataset_name,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
                last_modified_by: self.last_modified_by,
                data_storage: self.data_storage,
                num_records: self.num_records,
            }
        }
    }
}
impl Dataset {
    /// Creates a new builder-style object to manufacture [`Dataset`](crate::model::Dataset)
    pub fn builder() -> crate::model::dataset::Builder {
        crate::model::dataset::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BulkPublishStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BulkPublishStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => BulkPublishStatus::Failed,
            "IN_PROGRESS" => BulkPublishStatus::InProgress,
            "NOT_STARTED" => BulkPublishStatus::NotStarted,
            "SUCCEEDED" => BulkPublishStatus::Succeeded,
            other => BulkPublishStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BulkPublishStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BulkPublishStatus::from(s))
    }
}
impl BulkPublishStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BulkPublishStatus::Failed => "FAILED",
            BulkPublishStatus::InProgress => "IN_PROGRESS",
            BulkPublishStatus::NotStarted => "NOT_STARTED",
            BulkPublishStatus::Succeeded => "SUCCEEDED",
            BulkPublishStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "NOT_STARTED", "SUCCEEDED"]
    }
}
impl AsRef<str> for BulkPublishStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Usage information for the identity.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityUsage {
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_id: std::option::Option<std::string::String>,
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// Date on which the identity was last
    /// modified.
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// Number of datasets for the
    /// identity.
    pub dataset_count: i32,
    /// Total data storage for this
    /// identity.
    pub data_storage: std::option::Option<i64>,
}
impl std::fmt::Debug for IdentityUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityUsage");
        formatter.field("identity_id", &self.identity_id);
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("dataset_count", &self.dataset_count);
        formatter.field("data_storage", &self.data_storage);
        formatter.finish()
    }
}
/// See [`IdentityUsage`](crate::model::IdentityUsage)
pub mod identity_usage {
    /// A builder for [`IdentityUsage`](crate::model::IdentityUsage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) dataset_count: std::option::Option<i32>,
        pub(crate) data_storage: std::option::Option<i64>,
    }
    impl Builder {
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Date on which the identity was last
        /// modified.
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// Date on which the identity was last
        /// modified.
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Number of datasets for the
        /// identity.
        pub fn dataset_count(mut self, input: i32) -> Self {
            self.dataset_count = Some(input);
            self
        }
        /// Number of datasets for the
        /// identity.
        pub fn set_dataset_count(mut self, input: std::option::Option<i32>) -> Self {
            self.dataset_count = input;
            self
        }
        /// Total data storage for this
        /// identity.
        pub fn data_storage(mut self, input: i64) -> Self {
            self.data_storage = Some(input);
            self
        }
        /// Total data storage for this
        /// identity.
        pub fn set_data_storage(mut self, input: std::option::Option<i64>) -> Self {
            self.data_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityUsage`](crate::model::IdentityUsage)
        pub fn build(self) -> crate::model::IdentityUsage {
            crate::model::IdentityUsage {
                identity_id: self.identity_id,
                identity_pool_id: self.identity_pool_id,
                last_modified_date: self.last_modified_date,
                dataset_count: self.dataset_count.unwrap_or_default(),
                data_storage: self.data_storage,
            }
        }
    }
}
impl IdentityUsage {
    /// Creates a new builder-style object to manufacture [`IdentityUsage`](crate::model::IdentityUsage)
    pub fn builder() -> crate::model::identity_usage::Builder {
        crate::model::identity_usage::Builder::default()
    }
}
