// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BulkPublishInput`](crate::input::BulkPublishInput)
pub mod bulk_publish_input {
    /// A builder for [`BulkPublishInput`](crate::input::BulkPublishInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BulkPublishInput`](crate::input::BulkPublishInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BulkPublishInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BulkPublishInput {
                identity_pool_id: self.identity_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type BulkPublishInputOperationOutputAlias = crate::operation::BulkPublish;
#[doc(hidden)]
pub type BulkPublishInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BulkPublishInput {
    /// Consumes the builder and constructs an Operation<[`BulkPublish`](crate::operation::BulkPublish)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BulkPublish,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BulkPublishInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.identity_pool_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_1, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/bulkpublish",
                IdentityPoolId = identity_pool_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BulkPublishInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BulkPublishInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BulkPublish::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BulkPublish",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BulkPublishInput`](crate::input::BulkPublishInput)
    pub fn builder() -> crate::input::bulk_publish_input::Builder {
        crate::input::bulk_publish_input::Builder::default()
    }
}

/// See [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
pub mod delete_dataset_input {
    /// A builder for [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDatasetInput {
                identity_pool_id: self.identity_pool_id,
                identity_id: self.identity_id,
                dataset_name: self.dataset_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDatasetInputOperationOutputAlias = crate::operation::DeleteDataset;
#[doc(hidden)]
pub type DeleteDatasetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDatasetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataset`](crate::operation::DeleteDataset)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDatasetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.identity_pool_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_2, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.identity_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_id = aws_smithy_http::label::fmt_string(input_3, false);
            if identity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_4 = &_input.dataset_name;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_name",
                        details: "cannot be empty or unset",
                    })?;
            let dataset_name = aws_smithy_http::label::fmt_string(input_4, false);
            if dataset_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dataset_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
                IdentityPoolId = identity_pool_id,
                IdentityId = identity_id,
                DatasetName = dataset_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDatasetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDatasetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataset",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
}

/// See [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
pub mod describe_dataset_input {
    /// A builder for [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDatasetInput {
                identity_pool_id: self.identity_pool_id,
                identity_id: self.identity_id,
                dataset_name: self.dataset_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDatasetInputOperationOutputAlias = crate::operation::DescribeDataset;
#[doc(hidden)]
pub type DescribeDatasetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDatasetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataset`](crate::operation::DescribeDataset)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDatasetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.identity_pool_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_5, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.identity_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_id = aws_smithy_http::label::fmt_string(input_6, false);
            if identity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_7 = &_input.dataset_name;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_name",
                        details: "cannot be empty or unset",
                    })?;
            let dataset_name = aws_smithy_http::label::fmt_string(input_7, false);
            if dataset_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dataset_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
                IdentityPoolId = identity_pool_id,
                IdentityId = identity_id,
                DatasetName = dataset_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDatasetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDatasetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataset",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    pub fn builder() -> crate::input::describe_dataset_input::Builder {
        crate::input::describe_dataset_input::Builder::default()
    }
}

/// See [`DescribeIdentityPoolUsageInput`](crate::input::DescribeIdentityPoolUsageInput)
pub mod describe_identity_pool_usage_input {
    /// A builder for [`DescribeIdentityPoolUsageInput`](crate::input::DescribeIdentityPoolUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A name-spaced GUID (for
        /// example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
        /// generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for
        /// example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
        /// generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIdentityPoolUsageInput`](crate::input::DescribeIdentityPoolUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIdentityPoolUsageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIdentityPoolUsageInput {
                identity_pool_id: self.identity_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeIdentityPoolUsageInputOperationOutputAlias =
    crate::operation::DescribeIdentityPoolUsage;
#[doc(hidden)]
pub type DescribeIdentityPoolUsageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeIdentityPoolUsageInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIdentityPoolUsage`](crate::operation::DescribeIdentityPoolUsage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIdentityPoolUsage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeIdentityPoolUsageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.identity_pool_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_8, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}",
                IdentityPoolId = identity_pool_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeIdentityPoolUsageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeIdentityPoolUsageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIdentityPoolUsage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIdentityPoolUsage",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeIdentityPoolUsageInput`](crate::input::DescribeIdentityPoolUsageInput)
    pub fn builder() -> crate::input::describe_identity_pool_usage_input::Builder {
        crate::input::describe_identity_pool_usage_input::Builder::default()
    }
}

/// See [`DescribeIdentityUsageInput`](crate::input::DescribeIdentityUsageInput)
pub mod describe_identity_usage_input {
    /// A builder for [`DescribeIdentityUsageInput`](crate::input::DescribeIdentityUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A name-spaced GUID (for
        /// example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
        /// generation is unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for
        /// example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
        /// generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIdentityUsageInput`](crate::input::DescribeIdentityUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIdentityUsageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIdentityUsageInput {
                identity_pool_id: self.identity_pool_id,
                identity_id: self.identity_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeIdentityUsageInputOperationOutputAlias = crate::operation::DescribeIdentityUsage;
#[doc(hidden)]
pub type DescribeIdentityUsageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeIdentityUsageInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIdentityUsage`](crate::operation::DescribeIdentityUsage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIdentityUsage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeIdentityUsageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.identity_pool_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_9, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.identity_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_id = aws_smithy_http::label::fmt_string(input_10, false);
            if identity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/identities/{IdentityId}",
                IdentityPoolId = identity_pool_id,
                IdentityId = identity_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeIdentityUsageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeIdentityUsageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIdentityUsage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIdentityUsage",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeIdentityUsageInput`](crate::input::DescribeIdentityUsageInput)
    pub fn builder() -> crate::input::describe_identity_usage_input::Builder {
        crate::input::describe_identity_usage_input::Builder::default()
    }
}

/// See [`GetBulkPublishDetailsInput`](crate::input::GetBulkPublishDetailsInput)
pub mod get_bulk_publish_details_input {
    /// A builder for [`GetBulkPublishDetailsInput`](crate::input::GetBulkPublishDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBulkPublishDetailsInput`](crate::input::GetBulkPublishDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBulkPublishDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBulkPublishDetailsInput {
                identity_pool_id: self.identity_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBulkPublishDetailsInputOperationOutputAlias = crate::operation::GetBulkPublishDetails;
#[doc(hidden)]
pub type GetBulkPublishDetailsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBulkPublishDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GetBulkPublishDetails`](crate::operation::GetBulkPublishDetails)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBulkPublishDetails,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBulkPublishDetailsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.identity_pool_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_11, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/getBulkPublishDetails",
                IdentityPoolId = identity_pool_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBulkPublishDetailsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBulkPublishDetailsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBulkPublishDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBulkPublishDetails",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBulkPublishDetailsInput`](crate::input::GetBulkPublishDetailsInput)
    pub fn builder() -> crate::input::get_bulk_publish_details_input::Builder {
        crate::input::get_bulk_publish_details_input::Builder::default()
    }
}

/// See [`GetCognitoEventsInput`](crate::input::GetCognitoEventsInput)
pub mod get_cognito_events_input {
    /// A builder for [`GetCognitoEventsInput`](crate::input::GetCognitoEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Cognito Identity Pool ID for the request</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>The Cognito Identity Pool ID for the request</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCognitoEventsInput`](crate::input::GetCognitoEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCognitoEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCognitoEventsInput {
                identity_pool_id: self.identity_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCognitoEventsInputOperationOutputAlias = crate::operation::GetCognitoEvents;
#[doc(hidden)]
pub type GetCognitoEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCognitoEventsInput {
    /// Consumes the builder and constructs an Operation<[`GetCognitoEvents`](crate::operation::GetCognitoEvents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCognitoEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCognitoEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.identity_pool_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_12, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/events",
                IdentityPoolId = identity_pool_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCognitoEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCognitoEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCognitoEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCognitoEvents",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCognitoEventsInput`](crate::input::GetCognitoEventsInput)
    pub fn builder() -> crate::input::get_cognito_events_input::Builder {
        crate::input::get_cognito_events_input::Builder::default()
    }
}

/// See [`GetIdentityPoolConfigurationInput`](crate::input::GetIdentityPoolConfigurationInput)
pub mod get_identity_pool_configuration_input {
    /// A builder for [`GetIdentityPoolConfigurationInput`](crate::input::GetIdentityPoolConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. This is the ID of the pool for which to return a configuration.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. This is the ID of the pool for which to return a configuration.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityPoolConfigurationInput`](crate::input::GetIdentityPoolConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIdentityPoolConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIdentityPoolConfigurationInput {
                identity_pool_id: self.identity_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIdentityPoolConfigurationInputOperationOutputAlias =
    crate::operation::GetIdentityPoolConfiguration;
#[doc(hidden)]
pub type GetIdentityPoolConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIdentityPoolConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetIdentityPoolConfiguration`](crate::operation::GetIdentityPoolConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIdentityPoolConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIdentityPoolConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.identity_pool_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_13, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/configuration",
                IdentityPoolId = identity_pool_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIdentityPoolConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIdentityPoolConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIdentityPoolConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIdentityPoolConfiguration",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIdentityPoolConfigurationInput`](crate::input::GetIdentityPoolConfigurationInput)
    pub fn builder() -> crate::input::get_identity_pool_configuration_input::Builder {
        crate::input::get_identity_pool_configuration_input::Builder::default()
    }
}

/// See [`ListDatasetsInput`](crate::input::ListDatasetsInput)
pub mod list_datasets_input {
    /// A builder for [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// A pagination token for obtaining the next
        /// page of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A pagination token for obtaining the next
        /// page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// The maximum number of results to be
        /// returned.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// The maximum number of results to be
        /// returned.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetsInput`](crate::input::ListDatasetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDatasetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDatasetsInput {
                identity_pool_id: self.identity_pool_id,
                identity_id: self.identity_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListDatasetsInputOperationOutputAlias = crate::operation::ListDatasets;
#[doc(hidden)]
pub type ListDatasetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDatasetsInput {
    /// Consumes the builder and constructs an Operation<[`ListDatasets`](crate::operation::ListDatasets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDatasets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDatasetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.identity_pool_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_14, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_15 = &_input.identity_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_id = aws_smithy_http::label::fmt_string(input_15, false);
            if identity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets",
                IdentityPoolId = identity_pool_id,
                IdentityId = identity_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListDatasetsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_16) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_16));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDatasetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDatasetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDatasets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDatasets",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    pub fn builder() -> crate::input::list_datasets_input::Builder {
        crate::input::list_datasets_input::Builder::default()
    }
}

/// See [`ListIdentityPoolUsageInput`](crate::input::ListIdentityPoolUsageInput)
pub mod list_identity_pool_usage_input {
    /// A builder for [`ListIdentityPoolUsageInput`](crate::input::ListIdentityPoolUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// A pagination token for obtaining
        /// the next page of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A pagination token for obtaining
        /// the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// The maximum number of results to
        /// be returned.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// The maximum number of results to
        /// be returned.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentityPoolUsageInput`](crate::input::ListIdentityPoolUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIdentityPoolUsageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIdentityPoolUsageInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListIdentityPoolUsageInputOperationOutputAlias = crate::operation::ListIdentityPoolUsage;
#[doc(hidden)]
pub type ListIdentityPoolUsageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListIdentityPoolUsageInput {
    /// Consumes the builder and constructs an Operation<[`ListIdentityPoolUsage`](crate::operation::ListIdentityPoolUsage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIdentityPoolUsage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIdentityPoolUsageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/identitypools").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListIdentityPoolUsageInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_17) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_17));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIdentityPoolUsageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIdentityPoolUsageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIdentityPoolUsage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIdentityPoolUsage",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIdentityPoolUsageInput`](crate::input::ListIdentityPoolUsageInput)
    pub fn builder() -> crate::input::list_identity_pool_usage_input::Builder {
        crate::input::list_identity_pool_usage_input::Builder::default()
    }
}

/// See [`ListRecordsInput`](crate::input::ListRecordsInput)
pub mod list_records_input {
    /// A builder for [`ListRecordsInput`](crate::input::ListRecordsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) last_sync_count: std::option::Option<i64>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) sync_session_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// A string of up to 128 characters. Allowed
        /// characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// A string of up to 128 characters. Allowed
        /// characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// The last server sync count for this
        /// record.
        pub fn last_sync_count(mut self, input: i64) -> Self {
            self.last_sync_count = Some(input);
            self
        }
        /// The last server sync count for this
        /// record.
        pub fn set_last_sync_count(mut self, input: std::option::Option<i64>) -> Self {
            self.last_sync_count = input;
            self
        }
        /// A pagination token for obtaining the next
        /// page of results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A pagination token for obtaining the next
        /// page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// The maximum number of results to be
        /// returned.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// The maximum number of results to be
        /// returned.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token containing a session ID,
        /// identity ID, and expiration.
        pub fn sync_session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_session_token = Some(input.into());
            self
        }
        /// A token containing a session ID,
        /// identity ID, and expiration.
        pub fn set_sync_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sync_session_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecordsInput`](crate::input::ListRecordsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecordsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecordsInput {
                identity_pool_id: self.identity_pool_id,
                identity_id: self.identity_id,
                dataset_name: self.dataset_name,
                last_sync_count: self.last_sync_count,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
                sync_session_token: self.sync_session_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecordsInputOperationOutputAlias = crate::operation::ListRecords;
#[doc(hidden)]
pub type ListRecordsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRecordsInput {
    /// Consumes the builder and constructs an Operation<[`ListRecords`](crate::operation::ListRecords)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecords,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecordsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.identity_pool_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_18, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_19 = &_input.identity_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_id = aws_smithy_http::label::fmt_string(input_19, false);
            if identity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_20 = &_input.dataset_name;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_name",
                        details: "cannot be empty or unset",
                    })?;
            let dataset_name = aws_smithy_http::label::fmt_string(input_20, false);
            if dataset_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dataset_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records", IdentityPoolId = identity_pool_id, IdentityId = identity_id, DatasetName = dataset_name).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListRecordsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_21) = &_input.last_sync_count {
                query.push_kv(
                    "lastSyncCount",
                    &aws_smithy_types::primitive::Encoder::from(*inner_21).encode(),
                );
            }
            if let Some(inner_22) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_22));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_23) = &_input.sync_session_token {
                query.push_kv(
                    "syncSessionToken",
                    &aws_smithy_http::query::fmt_string(&inner_23),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecordsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecordsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecords::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecords",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecordsInput`](crate::input::ListRecordsInput)
    pub fn builder() -> crate::input::list_records_input::Builder {
        crate::input::list_records_input::Builder::default()
    }
}

/// See [`RegisterDeviceInput`](crate::input::RegisterDeviceInput)
pub mod register_device_input {
    /// A builder for [`RegisterDeviceInput`](crate::input::RegisterDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. Here, the ID of the pool that the identity belongs to.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. Here, the ID of the pool that the identity belongs to.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>The unique ID for this identity.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>The unique ID for this identity.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The push token.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The push token.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterDeviceInput`](crate::input::RegisterDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterDeviceInput {
                identity_pool_id: self.identity_pool_id,
                identity_id: self.identity_id,
                platform: self.platform,
                token: self.token,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterDeviceInputOperationOutputAlias = crate::operation::RegisterDevice;
#[doc(hidden)]
pub type RegisterDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterDeviceInput {
    /// Consumes the builder and constructs an Operation<[`RegisterDevice`](crate::operation::RegisterDevice)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.identity_pool_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_24, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_25 = &_input.identity_id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_id = aws_smithy_http::label::fmt_string(input_25, false);
            if identity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/identity/{IdentityId}/device",
                IdentityPoolId = identity_pool_id,
                IdentityId = identity_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_register_device(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterDevice",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterDeviceInput`](crate::input::RegisterDeviceInput)
    pub fn builder() -> crate::input::register_device_input::Builder {
        crate::input::register_device_input::Builder::default()
    }
}

/// See [`SetCognitoEventsInput`](crate::input::SetCognitoEventsInput)
pub mod set_cognito_events_input {
    /// A builder for [`SetCognitoEventsInput`](crate::input::SetCognitoEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Cognito Identity Pool to use when configuring Cognito Events</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>The Cognito Identity Pool to use when configuring Cognito Events</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Adds a key-value pair to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The events to configure</p>
        pub fn events(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.events.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.events = Some(hash_map);
            self
        }
        /// <p>The events to configure</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`SetCognitoEventsInput`](crate::input::SetCognitoEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetCognitoEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetCognitoEventsInput {
                identity_pool_id: self.identity_pool_id,
                events: self.events,
            })
        }
    }
}
#[doc(hidden)]
pub type SetCognitoEventsInputOperationOutputAlias = crate::operation::SetCognitoEvents;
#[doc(hidden)]
pub type SetCognitoEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetCognitoEventsInput {
    /// Consumes the builder and constructs an Operation<[`SetCognitoEvents`](crate::operation::SetCognitoEvents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetCognitoEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetCognitoEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.identity_pool_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_26, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/events",
                IdentityPoolId = identity_pool_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetCognitoEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetCognitoEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_cognito_events(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetCognitoEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetCognitoEvents",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetCognitoEventsInput`](crate::input::SetCognitoEventsInput)
    pub fn builder() -> crate::input::set_cognito_events_input::Builder {
        crate::input::set_cognito_events_input::Builder::default()
    }
}

/// See [`SetIdentityPoolConfigurationInput`](crate::input::SetIdentityPoolConfigurationInput)
pub mod set_identity_pool_configuration_input {
    /// A builder for [`SetIdentityPoolConfigurationInput`](crate::input::SetIdentityPoolConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) push_sync: std::option::Option<crate::model::PushSync>,
        pub(crate) cognito_streams: std::option::Option<crate::model::CognitoStreams>,
    }
    impl Builder {
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. This is the ID of the pool to modify.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. This is the ID of the pool to modify.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>Options to apply to this identity pool for push synchronization.</p>
        pub fn push_sync(mut self, input: crate::model::PushSync) -> Self {
            self.push_sync = Some(input);
            self
        }
        /// <p>Options to apply to this identity pool for push synchronization.</p>
        pub fn set_push_sync(mut self, input: std::option::Option<crate::model::PushSync>) -> Self {
            self.push_sync = input;
            self
        }
        /// Options to apply to this identity pool for Amazon Cognito streams.
        pub fn cognito_streams(mut self, input: crate::model::CognitoStreams) -> Self {
            self.cognito_streams = Some(input);
            self
        }
        /// Options to apply to this identity pool for Amazon Cognito streams.
        pub fn set_cognito_streams(
            mut self,
            input: std::option::Option<crate::model::CognitoStreams>,
        ) -> Self {
            self.cognito_streams = input;
            self
        }
        /// Consumes the builder and constructs a [`SetIdentityPoolConfigurationInput`](crate::input::SetIdentityPoolConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetIdentityPoolConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetIdentityPoolConfigurationInput {
                identity_pool_id: self.identity_pool_id,
                push_sync: self.push_sync,
                cognito_streams: self.cognito_streams,
            })
        }
    }
}
#[doc(hidden)]
pub type SetIdentityPoolConfigurationInputOperationOutputAlias =
    crate::operation::SetIdentityPoolConfiguration;
#[doc(hidden)]
pub type SetIdentityPoolConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetIdentityPoolConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`SetIdentityPoolConfiguration`](crate::operation::SetIdentityPoolConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetIdentityPoolConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetIdentityPoolConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.identity_pool_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_27, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/configuration",
                IdentityPoolId = identity_pool_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetIdentityPoolConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetIdentityPoolConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_identity_pool_configuration(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetIdentityPoolConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetIdentityPoolConfiguration",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetIdentityPoolConfigurationInput`](crate::input::SetIdentityPoolConfigurationInput)
    pub fn builder() -> crate::input::set_identity_pool_configuration_input::Builder {
        crate::input::set_identity_pool_configuration_input::Builder::default()
    }
}

/// See [`SubscribeToDatasetInput`](crate::input::SubscribeToDatasetInput)
pub mod subscribe_to_dataset_input {
    /// A builder for [`SubscribeToDatasetInput`](crate::input::SubscribeToDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. The ID of the pool to which the identity belongs.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. The ID of the pool to which the identity belongs.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>The name of the dataset to subcribe to.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset to subcribe to.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscribeToDatasetInput`](crate::input::SubscribeToDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SubscribeToDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SubscribeToDatasetInput {
                identity_pool_id: self.identity_pool_id,
                identity_id: self.identity_id,
                dataset_name: self.dataset_name,
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type SubscribeToDatasetInputOperationOutputAlias = crate::operation::SubscribeToDataset;
#[doc(hidden)]
pub type SubscribeToDatasetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SubscribeToDatasetInput {
    /// Consumes the builder and constructs an Operation<[`SubscribeToDataset`](crate::operation::SubscribeToDataset)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SubscribeToDataset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SubscribeToDatasetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.identity_pool_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_28, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_29 = &_input.identity_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_id = aws_smithy_http::label::fmt_string(input_29, false);
            if identity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_30 = &_input.dataset_name;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_name",
                        details: "cannot be empty or unset",
                    })?;
            let dataset_name = aws_smithy_http::label::fmt_string(input_30, false);
            if dataset_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dataset_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_31 = &_input.device_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_31, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}", IdentityPoolId = identity_pool_id, IdentityId = identity_id, DatasetName = dataset_name, DeviceId = device_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SubscribeToDatasetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SubscribeToDatasetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SubscribeToDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SubscribeToDataset",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SubscribeToDatasetInput`](crate::input::SubscribeToDatasetInput)
    pub fn builder() -> crate::input::subscribe_to_dataset_input::Builder {
        crate::input::subscribe_to_dataset_input::Builder::default()
    }
}

/// See [`UnsubscribeFromDatasetInput`](crate::input::UnsubscribeFromDatasetInput)
pub mod unsubscribe_from_dataset_input {
    /// A builder for [`UnsubscribeFromDatasetInput`](crate::input::UnsubscribeFromDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. The ID of the pool to which this identity belongs.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. The ID of the pool to which this identity belongs.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>The name of the dataset from which to unsubcribe.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset from which to unsubcribe.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsubscribeFromDatasetInput`](crate::input::UnsubscribeFromDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UnsubscribeFromDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UnsubscribeFromDatasetInput {
                identity_pool_id: self.identity_pool_id,
                identity_id: self.identity_id,
                dataset_name: self.dataset_name,
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UnsubscribeFromDatasetInputOperationOutputAlias = crate::operation::UnsubscribeFromDataset;
#[doc(hidden)]
pub type UnsubscribeFromDatasetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UnsubscribeFromDatasetInput {
    /// Consumes the builder and constructs an Operation<[`UnsubscribeFromDataset`](crate::operation::UnsubscribeFromDataset)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UnsubscribeFromDataset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UnsubscribeFromDatasetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.identity_pool_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_32, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_33 = &_input.identity_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_id = aws_smithy_http::label::fmt_string(input_33, false);
            if identity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_34 = &_input.dataset_name;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_name",
                        details: "cannot be empty or unset",
                    })?;
            let dataset_name = aws_smithy_http::label::fmt_string(input_34, false);
            if dataset_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dataset_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_35 = &_input.device_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_35, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}", IdentityPoolId = identity_pool_id, IdentityId = identity_id, DatasetName = dataset_name, DeviceId = device_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UnsubscribeFromDatasetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UnsubscribeFromDatasetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UnsubscribeFromDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UnsubscribeFromDataset",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UnsubscribeFromDatasetInput`](crate::input::UnsubscribeFromDatasetInput)
    pub fn builder() -> crate::input::unsubscribe_from_dataset_input::Builder {
        crate::input::unsubscribe_from_dataset_input::Builder::default()
    }
}

/// See [`UpdateRecordsInput`](crate::input::UpdateRecordsInput)
pub mod update_records_input {
    /// A builder for [`UpdateRecordsInput`](crate::input::UpdateRecordsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) record_patches: std::option::Option<std::vec::Vec<crate::model::RecordPatch>>,
        pub(crate) sync_session_token: std::option::Option<std::string::String>,
        pub(crate) client_context: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Appends an item to `record_patches`.
        ///
        /// To override the contents of this collection use [`set_record_patches`](Self::set_record_patches).
        ///
        /// A list of patch
        /// operations.
        pub fn record_patches(mut self, input: impl Into<crate::model::RecordPatch>) -> Self {
            let mut v = self.record_patches.unwrap_or_default();
            v.push(input.into());
            self.record_patches = Some(v);
            self
        }
        /// A list of patch
        /// operations.
        pub fn set_record_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecordPatch>>,
        ) -> Self {
            self.record_patches = input;
            self
        }
        /// The SyncSessionToken returned by a
        /// previous call to ListRecords for this dataset and identity.
        pub fn sync_session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_session_token = Some(input.into());
            self
        }
        /// The SyncSessionToken returned by a
        /// previous call to ListRecords for this dataset and identity.
        pub fn set_sync_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sync_session_token = input;
            self
        }
        /// Intended to supply a device ID that
        /// will populate the lastModifiedBy field referenced in other methods. The
        /// ClientContext field is not yet implemented.
        pub fn client_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_context = Some(input.into());
            self
        }
        /// Intended to supply a device ID that
        /// will populate the lastModifiedBy field referenced in other methods. The
        /// ClientContext field is not yet implemented.
        pub fn set_client_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_context = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecordsInput`](crate::input::UpdateRecordsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRecordsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRecordsInput {
                identity_pool_id: self.identity_pool_id,
                identity_id: self.identity_id,
                dataset_name: self.dataset_name,
                device_id: self.device_id,
                record_patches: self.record_patches,
                sync_session_token: self.sync_session_token,
                client_context: self.client_context,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRecordsInputOperationOutputAlias = crate::operation::UpdateRecords;
#[doc(hidden)]
pub type UpdateRecordsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRecordsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRecords`](crate::operation::UpdateRecords)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRecords,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRecordsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.identity_pool_id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_pool_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_pool_id = aws_smithy_http::label::fmt_string(input_36, false);
            if identity_pool_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_pool_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_37 = &_input.identity_id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identity_id",
                        details: "cannot be empty or unset",
                    })?;
            let identity_id = aws_smithy_http::label::fmt_string(input_37, false);
            if identity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identity_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_38 = &_input.dataset_name;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_name",
                        details: "cannot be empty or unset",
                    })?;
            let dataset_name = aws_smithy_http::label::fmt_string(input_38, false);
            if dataset_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dataset_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
                IdentityPoolId = identity_pool_id,
                IdentityId = identity_id,
                DatasetName = dataset_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UpdateRecordsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_39) = &_input.client_context {
                let formatted_40 = AsRef::<str>::as_ref(inner_39);
                if !formatted_40.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_40;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "client_context",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-Client-Context", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRecordsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRecordsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_records(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRecords::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRecords",
            "cognitosync",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRecordsInput`](crate::input::UpdateRecordsInput)
    pub fn builder() -> crate::input::update_records_input::Builder {
        crate::input::update_records_input::Builder::default()
    }
}

/// A request to post updates to records or add and
/// delete records for a dataset and user.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecordsInput {
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_id: std::option::Option<std::string::String>,
    /// A string of up to 128 characters.
    /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
    /// (dot).
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The unique ID generated for this device by Cognito.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// A list of patch
    /// operations.
    pub record_patches: std::option::Option<std::vec::Vec<crate::model::RecordPatch>>,
    /// The SyncSessionToken returned by a
    /// previous call to ListRecords for this dataset and identity.
    pub sync_session_token: std::option::Option<std::string::String>,
    /// Intended to supply a device ID that
    /// will populate the lastModifiedBy field referenced in other methods. The
    /// ClientContext field is not yet implemented.
    pub client_context: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateRecordsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecordsInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("device_id", &self.device_id);
        formatter.field("record_patches", &self.record_patches);
        formatter.field("sync_session_token", &self.sync_session_token);
        formatter.field("client_context", &self.client_context);
        formatter.finish()
    }
}

/// <p>A request to UnsubscribeFromDataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsubscribeFromDatasetInput {
    /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
    /// Amazon Cognito. The ID of the pool to which this identity belongs.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>Unique ID for this identity.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The name of the dataset from which to unsubcribe.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The unique ID generated for this device by Cognito.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsubscribeFromDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsubscribeFromDatasetInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

/// <p>A request to SubscribeToDatasetRequest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscribeToDatasetInput {
    /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
    /// Amazon Cognito. The ID of the pool to which the identity belongs.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>Unique ID for this identity.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The name of the dataset to subcribe to.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The unique ID generated for this device by Cognito.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscribeToDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscribeToDatasetInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

/// <p>The input for the SetIdentityPoolConfiguration operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityPoolConfigurationInput {
    /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
    /// Amazon Cognito. This is the ID of the pool to modify.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>Options to apply to this identity pool for push synchronization.</p>
    pub push_sync: std::option::Option<crate::model::PushSync>,
    /// Options to apply to this identity pool for Amazon Cognito streams.
    pub cognito_streams: std::option::Option<crate::model::CognitoStreams>,
}
impl std::fmt::Debug for SetIdentityPoolConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityPoolConfigurationInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("push_sync", &self.push_sync);
        formatter.field("cognito_streams", &self.cognito_streams);
        formatter.finish()
    }
}

/// <p>A request to configure Cognito Events"</p>"
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetCognitoEventsInput {
    /// <p>The Cognito Identity Pool to use when configuring Cognito Events</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>The events to configure</p>
    pub events:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for SetCognitoEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetCognitoEventsInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}

/// <p>A request to RegisterDevice.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterDeviceInput {
    /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
    /// Amazon Cognito. Here, the ID of the pool that the identity belongs to.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>The unique ID for this identity.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>The push token.</p>
    pub token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RegisterDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterDeviceInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("platform", &self.platform);
        formatter.field("token", &self.token);
        formatter.finish()
    }
}

/// A request for a list of records.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecordsInput {
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_id: std::option::Option<std::string::String>,
    /// A string of up to 128 characters. Allowed
    /// characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
    pub dataset_name: std::option::Option<std::string::String>,
    /// The last server sync count for this
    /// record.
    pub last_sync_count: std::option::Option<i64>,
    /// A pagination token for obtaining the next
    /// page of results.
    pub next_token: std::option::Option<std::string::String>,
    /// The maximum number of results to be
    /// returned.
    pub max_results: i32,
    /// A token containing a session ID,
    /// identity ID, and expiration.
    pub sync_session_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListRecordsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecordsInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("last_sync_count", &self.last_sync_count);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("sync_session_token", &self.sync_session_token);
        formatter.finish()
    }
}

/// A request for usage information on an
/// identity pool.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentityPoolUsageInput {
    /// A pagination token for obtaining
    /// the next page of results.
    pub next_token: std::option::Option<std::string::String>,
    /// The maximum number of results to
    /// be returned.
    pub max_results: i32,
}
impl std::fmt::Debug for ListIdentityPoolUsageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentityPoolUsageInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// Request for a list of datasets for an
/// identity.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetsInput {
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_id: std::option::Option<std::string::String>,
    /// A pagination token for obtaining the next
    /// page of results.
    pub next_token: std::option::Option<std::string::String>,
    /// The maximum number of results to be
    /// returned.
    pub max_results: i32,
}
impl std::fmt::Debug for ListDatasetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetsInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>The input for the GetIdentityPoolConfiguration operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityPoolConfigurationInput {
    /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
    /// Amazon Cognito. This is the ID of the pool for which to return a configuration.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetIdentityPoolConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityPoolConfigurationInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.finish()
    }
}

/// <p>A request for a list of the configured Cognito Events</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCognitoEventsInput {
    /// <p>The Cognito Identity Pool ID for the request</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCognitoEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCognitoEventsInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.finish()
    }
}

/// The input for the GetBulkPublishDetails operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBulkPublishDetailsInput {
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetBulkPublishDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBulkPublishDetailsInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.finish()
    }
}

/// A request for information about the usage of
/// an identity pool.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIdentityUsageInput {
    /// A name-spaced GUID (for
    /// example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
    /// generation is unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeIdentityUsageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIdentityUsageInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.finish()
    }
}

/// A request for usage information about
/// the identity pool.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIdentityPoolUsageInput {
    /// A name-spaced GUID (for
    /// example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
    /// generation is unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeIdentityPoolUsageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIdentityPoolUsageInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.finish()
    }
}

/// A request for meta data about a dataset (creation
/// date, number of records, size) by owner and dataset name.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetInput {
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_id: std::option::Option<std::string::String>,
    /// A string of up to 128 characters.
    /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
    /// (dot).
    pub dataset_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.finish()
    }
}

/// A request to delete the specific
/// dataset.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetInput {
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_id: std::option::Option<std::string::String>,
    /// A string of up to 128 characters.
    /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
    /// (dot).
    pub dataset_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.finish()
    }
}

/// The input for the BulkPublish operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BulkPublishInput {
    /// A name-spaced GUID (for example,
    /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
    /// unique within a region.
    pub identity_pool_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BulkPublishInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BulkPublishInput");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.finish()
    }
}
