// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSCognitoSyncService`.
///
/// This client allows ergonomic access to a `AWSCognitoSyncService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BulkPublish` operation.
    ///
    /// See [`BulkPublish`](crate::client::fluent_builders::BulkPublish) for more information about the
    /// operation and its arguments.
    pub fn bulk_publish(&self) -> fluent_builders::BulkPublish<C, M, R> {
        fluent_builders::BulkPublish::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataset` operation.
    ///
    /// See [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) for more information about the
    /// operation and its arguments.
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset<C, M, R> {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataset` operation.
    ///
    /// See [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset<C, M, R> {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIdentityPoolUsage` operation.
    ///
    /// See [`DescribeIdentityPoolUsage`](crate::client::fluent_builders::DescribeIdentityPoolUsage) for more information about the
    /// operation and its arguments.
    pub fn describe_identity_pool_usage(
        &self,
    ) -> fluent_builders::DescribeIdentityPoolUsage<C, M, R> {
        fluent_builders::DescribeIdentityPoolUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIdentityUsage` operation.
    ///
    /// See [`DescribeIdentityUsage`](crate::client::fluent_builders::DescribeIdentityUsage) for more information about the
    /// operation and its arguments.
    pub fn describe_identity_usage(&self) -> fluent_builders::DescribeIdentityUsage<C, M, R> {
        fluent_builders::DescribeIdentityUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBulkPublishDetails` operation.
    ///
    /// See [`GetBulkPublishDetails`](crate::client::fluent_builders::GetBulkPublishDetails) for more information about the
    /// operation and its arguments.
    pub fn get_bulk_publish_details(&self) -> fluent_builders::GetBulkPublishDetails<C, M, R> {
        fluent_builders::GetBulkPublishDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCognitoEvents` operation.
    ///
    /// See [`GetCognitoEvents`](crate::client::fluent_builders::GetCognitoEvents) for more information about the
    /// operation and its arguments.
    pub fn get_cognito_events(&self) -> fluent_builders::GetCognitoEvents<C, M, R> {
        fluent_builders::GetCognitoEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIdentityPoolConfiguration` operation.
    ///
    /// See [`GetIdentityPoolConfiguration`](crate::client::fluent_builders::GetIdentityPoolConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_identity_pool_configuration(
        &self,
    ) -> fluent_builders::GetIdentityPoolConfiguration<C, M, R> {
        fluent_builders::GetIdentityPoolConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasets` operation.
    ///
    /// See [`ListDatasets`](crate::client::fluent_builders::ListDatasets) for more information about the
    /// operation and its arguments.
    pub fn list_datasets(&self) -> fluent_builders::ListDatasets<C, M, R> {
        fluent_builders::ListDatasets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIdentityPoolUsage` operation.
    ///
    /// See [`ListIdentityPoolUsage`](crate::client::fluent_builders::ListIdentityPoolUsage) for more information about the
    /// operation and its arguments.
    pub fn list_identity_pool_usage(&self) -> fluent_builders::ListIdentityPoolUsage<C, M, R> {
        fluent_builders::ListIdentityPoolUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecords` operation.
    ///
    /// See [`ListRecords`](crate::client::fluent_builders::ListRecords) for more information about the
    /// operation and its arguments.
    pub fn list_records(&self) -> fluent_builders::ListRecords<C, M, R> {
        fluent_builders::ListRecords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterDevice` operation.
    ///
    /// See [`RegisterDevice`](crate::client::fluent_builders::RegisterDevice) for more information about the
    /// operation and its arguments.
    pub fn register_device(&self) -> fluent_builders::RegisterDevice<C, M, R> {
        fluent_builders::RegisterDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetCognitoEvents` operation.
    ///
    /// See [`SetCognitoEvents`](crate::client::fluent_builders::SetCognitoEvents) for more information about the
    /// operation and its arguments.
    pub fn set_cognito_events(&self) -> fluent_builders::SetCognitoEvents<C, M, R> {
        fluent_builders::SetCognitoEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetIdentityPoolConfiguration` operation.
    ///
    /// See [`SetIdentityPoolConfiguration`](crate::client::fluent_builders::SetIdentityPoolConfiguration) for more information about the
    /// operation and its arguments.
    pub fn set_identity_pool_configuration(
        &self,
    ) -> fluent_builders::SetIdentityPoolConfiguration<C, M, R> {
        fluent_builders::SetIdentityPoolConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SubscribeToDataset` operation.
    ///
    /// See [`SubscribeToDataset`](crate::client::fluent_builders::SubscribeToDataset) for more information about the
    /// operation and its arguments.
    pub fn subscribe_to_dataset(&self) -> fluent_builders::SubscribeToDataset<C, M, R> {
        fluent_builders::SubscribeToDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnsubscribeFromDataset` operation.
    ///
    /// See [`UnsubscribeFromDataset`](crate::client::fluent_builders::UnsubscribeFromDataset) for more information about the
    /// operation and its arguments.
    pub fn unsubscribe_from_dataset(&self) -> fluent_builders::UnsubscribeFromDataset<C, M, R> {
        fluent_builders::UnsubscribeFromDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRecords` operation.
    ///
    /// See [`UpdateRecords`](crate::client::fluent_builders::UpdateRecords) for more information about the
    /// operation and its arguments.
    pub fn update_records(&self) -> fluent_builders::UpdateRecords<C, M, R> {
        fluent_builders::UpdateRecords::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BulkPublish`.
    ///
    /// <p>Initiates a bulk publish of all existing datasets for an Identity Pool to the configured stream. Customers are limited to one successful bulk publish per 24 hours. Bulk publish is an asynchronous request, customers can see the status of the request via the GetBulkPublishDetails operation.</p><p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>
    #[derive(std::fmt::Debug)]
    pub struct BulkPublish<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::bulk_publish_input::Builder,
    }
    impl<C, M, R> BulkPublish<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BulkPublish`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BulkPublishOutput,
            aws_smithy_http::result::SdkError<crate::error::BulkPublishError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BulkPublishInputOperationOutputAlias,
                crate::output::BulkPublishOutput,
                crate::error::BulkPublishError,
                crate::input::BulkPublishInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes the specific dataset. The dataset will be deleted permanently, and the action can't
    /// be undone. Datasets that this dataset was merged with will no longer report the merge. Any
    /// subsequent operation on this dataset will result in a
    /// ResourceNotFoundException.</p>
    /// <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl<C, M, R> DeleteDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatasetInputOperationOutputAlias,
                crate::output::DeleteDatasetOutput,
                crate::error::DeleteDatasetError,
                crate::input::DeleteDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p>Gets meta data about a dataset by identity and dataset name. With Amazon Cognito Sync, each
    /// identity has access only to its own data. Thus, the credentials used to make this API call
    /// need to have access to the identity data.</p>
    /// <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials. You should use Cognito Identity credentials to make this API call.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl<C, M, R> DescribeDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetInputOperationOutputAlias,
                crate::output::DescribeDatasetOutput,
                crate::error::DescribeDatasetError,
                crate::input::DescribeDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentityPoolUsage`.
    ///
    /// <p>Gets usage details (for example, data storage) about a particular identity pool.</p>
    /// <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>
    ///
    /// <examples>
    /// <example>
    /// <name>DescribeIdentityPoolUsage</name>
    /// <description>The following examples have been edited for readability.</description>
    /// <request>
    /// POST / HTTP/1.1
    /// CONTENT-TYPE: application/json
    /// X-AMZN-REQUESTID: 8dc0e749-c8cd-48bd-8520-da6be00d528b
    /// X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.DescribeIdentityPoolUsage
    /// HOST: cognito-sync.us-east-1.amazonaws.com:443
    /// X-AMZ-DATE: 20141111T205737Z
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=<credential>, SignedHeaders=content-type;host;x-amz-date;x-amz-target;x-amzn-requestid, Signature=<signature>
    ///
    /// {
    /// "Operation": "com.amazonaws.cognito.sync.model#DescribeIdentityPoolUsage",
    /// "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService",
    /// "Input":
    /// {
    /// "IdentityPoolId": "IDENTITY_POOL_ID"
    /// }
    /// }
    /// </request>
    /// <response>
    /// 1.1 200 OK
    /// x-amzn-requestid: 8dc0e749-c8cd-48bd-8520-da6be00d528b
    /// content-type: application/json
    /// content-length: 271
    /// date: Tue, 11 Nov 2014 20:57:37 GMT
    ///
    /// {
    /// "Output":
    /// {
    /// "__type": "com.amazonaws.cognito.sync.model#DescribeIdentityPoolUsageResponse",
    /// "IdentityPoolUsage":
    /// {
    /// "DataStorage": 0,
    /// "IdentityPoolId": "IDENTITY_POOL_ID",
    /// "LastModifiedDate": 1.413231134115E9,
    /// "SyncSessionsCount": null
    /// }
    /// },
    /// "Version": "1.0"
    /// }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::fmt::Debug)]
    pub struct DescribeIdentityPoolUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_identity_pool_usage_input::Builder,
    }
    impl<C, M, R> DescribeIdentityPoolUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIdentityPoolUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityPoolUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIdentityPoolUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIdentityPoolUsageInputOperationOutputAlias,
                crate::output::DescribeIdentityPoolUsageOutput,
                crate::error::DescribeIdentityPoolUsageError,
                crate::input::DescribeIdentityPoolUsageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for
        /// example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
        /// generation is unique within a region.
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// A name-spaced GUID (for
        /// example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
        /// generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentityUsage`.
    ///
    /// <p>Gets usage information for an identity, including number of datasets and data usage.</p>
    /// <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials.</p>
    /// <examples>
    /// <example>
    /// <name>DescribeIdentityUsage</name>
    /// <description>The following examples have been edited for readability.</description>
    /// <request>
    /// POST / HTTP/1.1
    /// CONTENT-TYPE: application/json
    /// X-AMZN-REQUESTID: 33f9b4e4-a177-4aad-a3bb-6edb7980b283
    /// X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.DescribeIdentityUsage
    /// HOST: cognito-sync.us-east-1.amazonaws.com:443
    /// X-AMZ-DATE: 20141111T215129Z
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=<credential>, SignedHeaders=content-type;host;x-amz-date;x-amz-target;x-amzn-requestid, Signature=<signature>
    ///
    /// {
    /// "Operation": "com.amazonaws.cognito.sync.model#DescribeIdentityUsage",
    /// "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService",
    /// "Input":
    /// {
    /// "IdentityPoolId": "IDENTITY_POOL_ID",
    /// "IdentityId": "IDENTITY_ID"
    /// }
    /// }
    /// </request>
    /// <response>
    /// 1.1 200 OK
    /// x-amzn-requestid: 33f9b4e4-a177-4aad-a3bb-6edb7980b283
    /// content-type: application/json
    /// content-length: 318
    /// date: Tue, 11 Nov 2014 21:51:29 GMT
    ///
    /// {
    /// "Output":
    /// {
    /// "__type": "com.amazonaws.cognito.sync.model#DescribeIdentityUsageResponse",
    /// "IdentityUsage":
    /// {
    /// "DataStorage": 16,
    /// "DatasetCount": 1,
    /// "IdentityId": "IDENTITY_ID",
    /// "IdentityPoolId": "IDENTITY_POOL_ID",
    /// "LastModifiedDate": 1.412974081336E9
    /// }
    /// },
    /// "Version": "1.0"
    /// }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::fmt::Debug)]
    pub struct DescribeIdentityUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_identity_usage_input::Builder,
    }
    impl<C, M, R> DescribeIdentityUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIdentityUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIdentityUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIdentityUsageInputOperationOutputAlias,
                crate::output::DescribeIdentityUsageOutput,
                crate::error::DescribeIdentityUsageError,
                crate::input::DescribeIdentityUsageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for
        /// example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
        /// generation is unique within a region.
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// A name-spaced GUID (for
        /// example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
        /// generation is unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBulkPublishDetails`.
    ///
    /// <p>Get the status of the last BulkPublish operation for an identity pool.</p><p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBulkPublishDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bulk_publish_details_input::Builder,
    }
    impl<C, M, R> GetBulkPublishDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBulkPublishDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBulkPublishDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBulkPublishDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBulkPublishDetailsInputOperationOutputAlias,
                crate::output::GetBulkPublishDetailsOutput,
                crate::error::GetBulkPublishDetailsError,
                crate::input::GetBulkPublishDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCognitoEvents`.
    ///
    /// <p>Gets the events and the corresponding Lambda functions associated with an identity pool.</p><p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCognitoEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cognito_events_input::Builder,
    }
    impl<C, M, R> GetCognitoEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCognitoEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCognitoEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCognitoEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCognitoEventsInputOperationOutputAlias,
                crate::output::GetCognitoEventsOutput,
                crate::error::GetCognitoEventsError,
                crate::input::GetCognitoEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Cognito Identity Pool ID for the request</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>The Cognito Identity Pool ID for the request</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityPoolConfiguration`.
    ///
    /// <p>Gets the configuration settings of an identity pool.</p><p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>
    /// <examples>
    /// <example>
    /// <name>GetIdentityPoolConfiguration</name>
    /// <description>The following examples have been edited for readability.</description>
    /// <request>
    /// POST / HTTP/1.1
    /// CONTENT-TYPE: application/json
    /// X-AMZN-REQUESTID: b1cfdd4b-f620-4fe4-be0f-02024a1d33da
    /// X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.GetIdentityPoolConfiguration
    /// HOST: cognito-sync.us-east-1.amazonaws.com
    /// X-AMZ-DATE: 20141004T195722Z
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=<credential>, SignedHeaders=content-type;content-length;host;x-amz-date;x-amz-target, Signature=<signature>
    ///
    /// {
    /// "Operation": "com.amazonaws.cognito.sync.model#GetIdentityPoolConfiguration",
    /// "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService",
    /// "Input":
    /// {
    /// "IdentityPoolId": "ID_POOL_ID"
    /// }
    /// }
    ///
    /// </request>
    /// <response>
    /// 1.1 200 OK
    /// x-amzn-requestid: b1cfdd4b-f620-4fe4-be0f-02024a1d33da
    /// date: Sat, 04 Oct 2014 19:57:22 GMT
    /// content-type: application/json
    /// content-length: 332
    ///
    /// {
    /// "Output":
    /// {
    /// "__type": "com.amazonaws.cognito.sync.model#GetIdentityPoolConfigurationResponse",
    /// "IdentityPoolId": "ID_POOL_ID",
    /// "PushSync":
    /// {
    /// "ApplicationArns": ["PLATFORMARN1", "PLATFORMARN2"],
    /// "RoleArn": "ROLEARN"
    /// }
    /// },
    /// "Version": "1.0"
    /// }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::fmt::Debug)]
    pub struct GetIdentityPoolConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_identity_pool_configuration_input::Builder,
    }
    impl<C, M, R> GetIdentityPoolConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIdentityPoolConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityPoolConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityPoolConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIdentityPoolConfigurationInputOperationOutputAlias,
                crate::output::GetIdentityPoolConfigurationOutput,
                crate::error::GetIdentityPoolConfigurationError,
                crate::input::GetIdentityPoolConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. This is the ID of the pool for which to return a configuration.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. This is the ID of the pool for which to return a configuration.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasets`.
    ///
    /// <p>Lists datasets for an identity. With Amazon Cognito Sync, each identity has access only to
    /// its own data. Thus, the credentials used to make this API call need to have access to the
    /// identity data.</p>
    /// <p>ListDatasets can be called with temporary user credentials provided by Cognito
    /// Identity or with developer credentials. You should use the Cognito Identity credentials to
    /// make this API call.</p>
    /// <examples>
    /// <example>
    /// <name>ListDatasets</name>
    /// <description>The following examples have been edited for readability.</description>
    /// <request>
    /// POST / HTTP/1.1
    /// CONTENT-TYPE: application/json
    /// X-AMZN-REQUESTID: 15225768-209f-4078-aaed-7494ace9f2db
    /// X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.ListDatasets
    /// HOST: cognito-sync.us-east-1.amazonaws.com:443
    /// X-AMZ-DATE: 20141111T215640Z
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=<credential>, SignedHeaders=content-type;host;x-amz-date;x-amz-target;x-amzn-requestid, Signature=<signature>
    ///
    /// {
    /// "Operation": "com.amazonaws.cognito.sync.model#ListDatasets",
    /// "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService",
    /// "Input":
    /// {
    /// "IdentityPoolId": "IDENTITY_POOL_ID",
    /// "IdentityId": "IDENTITY_ID",
    /// "MaxResults": "3"
    /// }
    /// }
    /// </request>
    /// <response>
    /// 1.1 200 OK
    /// x-amzn-requestid: 15225768-209f-4078-aaed-7494ace9f2db, 15225768-209f-4078-aaed-7494ace9f2db
    /// content-type: application/json
    /// content-length: 355
    /// date: Tue, 11 Nov 2014 21:56:40 GMT
    ///
    /// {
    /// "Output":
    /// {
    /// "__type": "com.amazonaws.cognito.sync.model#ListDatasetsResponse",
    /// "Count": 1,
    /// "Datasets": [
    /// {
    /// "CreationDate": 1.412974057151E9,
    /// "DataStorage": 16,
    /// "DatasetName": "my_list",
    /// "IdentityId": "IDENTITY_ID",
    /// "LastModifiedBy": "123456789012",
    /// "LastModifiedDate": 1.412974057244E9,
    /// "NumRecords": 1
    /// }],
    /// "NextToken": null
    /// },
    /// "Version": "1.0"
    /// }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_datasets_input::Builder,
    }
    impl<C, M, R> ListDatasets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetsInputOperationOutputAlias,
                crate::output::ListDatasetsOutput,
                crate::error::ListDatasetsError,
                crate::input::ListDatasetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// A pagination token for obtaining the next
        /// page of results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A pagination token for obtaining the next
        /// page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The maximum number of results to be
        /// returned.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be
        /// returned.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentityPoolUsage`.
    ///
    /// <p>Gets a list of identity pools registered with Cognito.</p>
    /// <p>ListIdentityPoolUsage can only be called with developer credentials. You
    /// cannot make this API call with the temporary user credentials provided by Cognito
    /// Identity.</p>
    /// <examples>
    /// <example>
    /// <name>ListIdentityPoolUsage</name>
    /// <description>The following examples have been edited for readability.</description>
    /// <request>
    /// POST / HTTP/1.1
    /// CONTENT-TYPE: application/json
    /// X-AMZN-REQUESTID: 9be7c425-ef05-48c0-aef3-9f0ff2fe17d3
    /// X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.ListIdentityPoolUsage
    /// HOST: cognito-sync.us-east-1.amazonaws.com:443
    /// X-AMZ-DATE: 20141111T211414Z
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=<credential>, SignedHeaders=content-type;host;x-amz-date;x-amz-target;x-amzn-requestid, Signature=<signature>
    ///
    /// {
    /// "Operation": "com.amazonaws.cognito.sync.model#ListIdentityPoolUsage",
    /// "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService",
    /// "Input":
    /// {
    /// "MaxResults": "2"
    /// }
    /// }
    /// </request>
    /// <response>
    /// 1.1 200 OK
    /// x-amzn-requestid: 9be7c425-ef05-48c0-aef3-9f0ff2fe17d3
    /// content-type: application/json
    /// content-length: 519
    /// date: Tue, 11 Nov 2014 21:14:14 GMT
    ///
    /// {
    /// "Output":
    /// {
    /// "__type": "com.amazonaws.cognito.sync.model#ListIdentityPoolUsageResponse",
    /// "Count": 2,
    /// "IdentityPoolUsages": [
    /// {
    /// "DataStorage": 0,
    /// "IdentityPoolId": "IDENTITY_POOL_ID",
    /// "LastModifiedDate": 1.413836234607E9,
    /// "SyncSessionsCount": null
    /// },
    /// {
    /// "DataStorage": 0,
    /// "IdentityPoolId": "IDENTITY_POOL_ID",
    /// "LastModifiedDate": 1.410892165601E9,
    /// "SyncSessionsCount": null
    /// }],
    /// "MaxResults": 2,
    /// "NextToken": "dXMtZWFzdC0xOjBjMWJhMDUyLWUwOTgtNDFmYS1hNzZlLWVhYTJjMTI1Zjg2MQ=="
    /// },
    /// "Version": "1.0"
    /// }               
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::fmt::Debug)]
    pub struct ListIdentityPoolUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_identity_pool_usage_input::Builder,
    }
    impl<C, M, R> ListIdentityPoolUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIdentityPoolUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentityPoolUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentityPoolUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIdentityPoolUsageInputOperationOutputAlias,
                crate::output::ListIdentityPoolUsageOutput,
                crate::error::ListIdentityPoolUsageError,
                crate::input::ListIdentityPoolUsageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// A pagination token for obtaining
        /// the next page of results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A pagination token for obtaining
        /// the next page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The maximum number of results to
        /// be returned.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to
        /// be returned.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecords`.
    ///
    /// <p>Gets paginated records, optionally changed after a particular sync count for a dataset and
    /// identity. With Amazon Cognito Sync, each identity has access only to its own data. Thus,
    /// the credentials used to make this API call need to have access to the identity data.</p>
    /// <p>ListRecords can be called with temporary user credentials provided by Cognito
    /// Identity or with developer credentials. You should use Cognito Identity credentials to make
    /// this API call.</p>
    /// <examples>
    /// <example>
    /// <name>ListRecords</name>
    /// <description>The following examples have been edited for readability.</description>
    /// <request>
    /// POST / HTTP/1.1
    /// CONTENT-TYPE: application/json
    /// X-AMZN-REQUESTID: b3d2e31e-d6b7-4612-8e84-c9ba288dab5d
    /// X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.ListRecords
    /// HOST: cognito-sync.us-east-1.amazonaws.com:443
    /// X-AMZ-DATE: 20141111T183230Z
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=<credential>, SignedHeaders=content-type;host;x-amz-date;x-amz-target;x-amzn-requestid, Signature=<signature>
    ///
    /// {
    /// "Operation": "com.amazonaws.cognito.sync.model#ListRecords",
    /// "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService",
    /// "Input":
    /// {
    /// "IdentityPoolId": "IDENTITY_POOL_ID",
    /// "IdentityId": "IDENTITY_ID",
    /// "DatasetName": "newDataSet"
    /// }
    /// }
    /// </request>
    /// <response>
    /// 1.1 200 OK
    /// x-amzn-requestid: b3d2e31e-d6b7-4612-8e84-c9ba288dab5d
    /// content-type: application/json
    /// content-length: 623
    /// date: Tue, 11 Nov 2014 18:32:30 GMT
    ///
    /// {
    /// "Output":
    /// {
    /// "__type": "com.amazonaws.cognito.sync.model#ListRecordsResponse",
    /// "Count": 0,
    /// "DatasetDeletedAfterRequestedSyncCount": false,
    /// "DatasetExists": false,
    /// "DatasetSyncCount": 0,
    /// "LastModifiedBy": null,
    /// "MergedDatasetNames": null,
    /// "NextToken": null,
    /// "Records": [],
    /// "SyncSessionToken": "SYNC_SESSION_TOKEN"
    /// },
    /// "Version": "1.0"
    /// }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::fmt::Debug)]
    pub struct ListRecords<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_records_input::Builder,
    }
    impl<C, M, R> ListRecords<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecordsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecordsInputOperationOutputAlias,
                crate::output::ListRecordsOutput,
                crate::error::ListRecordsError,
                crate::input::ListRecordsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// A string of up to 128 characters. Allowed
        /// characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// A string of up to 128 characters. Allowed
        /// characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// The last server sync count for this
        /// record.
        pub fn last_sync_count(mut self, inp: i64) -> Self {
            self.inner = self.inner.last_sync_count(inp);
            self
        }
        /// The last server sync count for this
        /// record.
        pub fn set_last_sync_count(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_last_sync_count(input);
            self
        }
        /// A pagination token for obtaining the next
        /// page of results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A pagination token for obtaining the next
        /// page of results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The maximum number of results to be
        /// returned.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be
        /// returned.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token containing a session ID,
        /// identity ID, and expiration.
        pub fn sync_session_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_session_token(inp);
            self
        }
        /// A token containing a session ID,
        /// identity ID, and expiration.
        pub fn set_sync_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sync_session_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterDevice`.
    ///
    /// <p>Registers a device to receive push sync notifications.</p><p>This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API with developer credentials.</p>
    /// <examples>
    /// <example>
    /// <name>RegisterDevice</name>
    /// <description>The following examples have been edited for readability.</description>
    /// <request>
    /// POST / HTTP/1.1
    /// CONTENT-TYPE: application/json
    /// X-AMZN-REQUESTID: 368f9200-3eca-449e-93b3-7b9c08d8e185
    /// X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.RegisterDevice
    /// HOST: cognito-sync.us-east-1.amazonaws.com
    /// X-AMZ-DATE: 20141004T194643Z
    /// X-AMZ-SECURITY-TOKEN: <securitytoken>
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=<credential>, SignedHeaders=content-type;content-length;host;x-amz-date;x-amz-target, Signature=<signature>
    ///
    /// {
    /// "Operation": "com.amazonaws.cognito.sync.model#RegisterDevice",
    /// "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService",
    /// "Input":
    /// {
    /// "IdentityPoolId": "ID_POOL_ID",
    /// "IdentityId": "IDENTITY_ID",
    /// "Platform": "GCM",
    /// "Token": "PUSH_TOKEN"
    /// }
    /// }
    /// </request>
    /// <response>
    /// 1.1 200 OK
    /// x-amzn-requestid: 368f9200-3eca-449e-93b3-7b9c08d8e185
    /// date: Sat, 04 Oct 2014 19:46:44 GMT
    /// content-type: application/json
    /// content-length: 145
    ///
    /// {
    /// "Output":
    /// {
    /// "__type": "com.amazonaws.cognito.sync.model#RegisterDeviceResponse",
    /// "DeviceId": "5cd28fbe-dd83-47ab-9f83-19093a5fb014"
    /// },
    /// "Version": "1.0"
    /// }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::fmt::Debug)]
    pub struct RegisterDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_device_input::Builder,
    }
    impl<C, M, R> RegisterDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterDeviceInputOperationOutputAlias,
                crate::output::RegisterDeviceOutput,
                crate::error::RegisterDeviceError,
                crate::input::RegisterDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. Here, the ID of the pool that the identity belongs to.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. Here, the ID of the pool that the identity belongs to.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>The unique ID for this identity.</p>
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// <p>The unique ID for this identity.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).</p>
        pub fn platform(mut self, inp: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(inp);
            self
        }
        /// <p>The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>The push token.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>The push token.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetCognitoEvents`.
    ///
    /// <p>Sets the AWS Lambda function for a given event type for an identity pool. This request only updates the key/value pair specified. Other key/values pairs are not updated. To remove a key value pair, pass a empty value for the particular key.</p><p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetCognitoEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_cognito_events_input::Builder,
    }
    impl<C, M, R> SetCognitoEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetCognitoEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetCognitoEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::SetCognitoEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetCognitoEventsInputOperationOutputAlias,
                crate::output::SetCognitoEventsOutput,
                crate::error::SetCognitoEventsError,
                crate::input::SetCognitoEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Cognito Identity Pool to use when configuring Cognito Events</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>The Cognito Identity Pool to use when configuring Cognito Events</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// Adds a key-value pair to `Events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The events to configure</p>
        pub fn events(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.events(k, v);
            self
        }
        /// <p>The events to configure</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_events(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityPoolConfiguration`.
    ///
    /// <p>Sets the necessary configuration for push sync.</p><p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>
    /// <examples>
    /// <example>
    /// <name>SetIdentityPoolConfiguration</name>
    /// <description>The following examples have been edited for readability.</description>
    /// <request>
    /// POST / HTTP/1.1
    /// CONTENT-TYPE: application/json
    /// X-AMZN-REQUESTID: a46db021-f5dd-45d6-af5b-7069fa4a211b
    /// X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.SetIdentityPoolConfiguration
    /// HOST: cognito-sync.us-east-1.amazonaws.com
    /// X-AMZ-DATE: 20141004T200006Z
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=<credential>, SignedHeaders=content-type;content-length;host;x-amz-date;x-amz-target, Signature=<signature>
    ///
    /// {
    /// "Operation": "com.amazonaws.cognito.sync.model#SetIdentityPoolConfiguration",
    /// "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService",
    /// "Input":
    /// {
    /// "IdentityPoolId": "ID_POOL_ID",
    /// "PushSync":
    /// {
    /// "ApplicationArns": ["PLATFORMARN1", "PLATFORMARN2"],
    /// "RoleArn": "ROLEARN"
    /// }
    /// }
    /// }
    /// </request>
    /// <response>
    /// 1.1 200 OK
    /// x-amzn-requestid: a46db021-f5dd-45d6-af5b-7069fa4a211b
    /// date: Sat, 04 Oct 2014 20:00:06 GMT
    /// content-type: application/json
    /// content-length: 332
    ///
    /// {
    /// "Output":
    /// {
    /// "__type": "com.amazonaws.cognito.sync.model#SetIdentityPoolConfigurationResponse",
    /// "IdentityPoolId": "ID_POOL_ID",
    /// "PushSync":
    /// {
    /// "ApplicationArns": ["PLATFORMARN1", "PLATFORMARN2"],
    /// "RoleArn": "ROLEARN"
    /// }
    /// },
    /// "Version": "1.0"
    /// }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::fmt::Debug)]
    pub struct SetIdentityPoolConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_identity_pool_configuration_input::Builder,
    }
    impl<C, M, R> SetIdentityPoolConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetIdentityPoolConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityPoolConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIdentityPoolConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetIdentityPoolConfigurationInputOperationOutputAlias,
                crate::output::SetIdentityPoolConfigurationOutput,
                crate::error::SetIdentityPoolConfigurationError,
                crate::input::SetIdentityPoolConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. This is the ID of the pool to modify.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. This is the ID of the pool to modify.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>Options to apply to this identity pool for push synchronization.</p>
        pub fn push_sync(mut self, inp: crate::model::PushSync) -> Self {
            self.inner = self.inner.push_sync(inp);
            self
        }
        /// <p>Options to apply to this identity pool for push synchronization.</p>
        pub fn set_push_sync(mut self, input: std::option::Option<crate::model::PushSync>) -> Self {
            self.inner = self.inner.set_push_sync(input);
            self
        }
        /// Options to apply to this identity pool for Amazon Cognito streams.
        pub fn cognito_streams(mut self, inp: crate::model::CognitoStreams) -> Self {
            self.inner = self.inner.cognito_streams(inp);
            self
        }
        /// Options to apply to this identity pool for Amazon Cognito streams.
        pub fn set_cognito_streams(
            mut self,
            input: std::option::Option<crate::model::CognitoStreams>,
        ) -> Self {
            self.inner = self.inner.set_cognito_streams(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SubscribeToDataset`.
    ///
    /// <p>Subscribes to receive notifications when a dataset is modified by another device.</p><p>This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API with developer credentials.</p>
    /// <examples>
    /// <example>
    /// <name>SubscribeToDataset</name>
    /// <description>The following examples have been edited for readability.</description>
    /// <request>
    /// POST / HTTP/1.1
    /// CONTENT-TYPE: application/json
    /// X-AMZN-REQUESTID: 8b9932b7-201d-4418-a960-0a470e11de9f
    /// X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.SubscribeToDataset
    /// HOST: cognito-sync.us-east-1.amazonaws.com
    /// X-AMZ-DATE: 20141004T195350Z
    /// X-AMZ-SECURITY-TOKEN: <securitytoken>
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=<credential>, SignedHeaders=content-type;content-length;host;x-amz-date;x-amz-target, Signature=<signature>
    ///
    /// {
    /// "Operation": "com.amazonaws.cognito.sync.model#SubscribeToDataset",
    /// "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService",
    /// "Input":
    /// {
    /// "IdentityPoolId": "ID_POOL_ID",
    /// "IdentityId": "IDENTITY_ID",
    /// "DatasetName": "Rufus",
    /// "DeviceId": "5cd28fbe-dd83-47ab-9f83-19093a5fb014"
    /// }
    /// }
    /// </request>
    /// <response>
    /// 1.1 200 OK
    /// x-amzn-requestid: 8b9932b7-201d-4418-a960-0a470e11de9f
    /// date: Sat, 04 Oct 2014 19:53:50 GMT
    /// content-type: application/json
    /// content-length: 99
    ///
    /// {
    /// "Output":
    /// {
    /// "__type": "com.amazonaws.cognito.sync.model#SubscribeToDatasetResponse"
    /// },
    /// "Version": "1.0"
    /// }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::fmt::Debug)]
    pub struct SubscribeToDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::subscribe_to_dataset_input::Builder,
    }
    impl<C, M, R> SubscribeToDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SubscribeToDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SubscribeToDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::SubscribeToDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SubscribeToDatasetInputOperationOutputAlias,
                crate::output::SubscribeToDatasetOutput,
                crate::error::SubscribeToDatasetError,
                crate::input::SubscribeToDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. The ID of the pool to which the identity belongs.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. The ID of the pool to which the identity belongs.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The name of the dataset to subcribe to.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset to subcribe to.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(inp);
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnsubscribeFromDataset`.
    ///
    /// <p>Unsubscribes from receiving notifications when a dataset is modified by another device.</p><p>This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API with developer credentials.</p>
    /// <examples>
    /// <example>
    /// <name>UnsubscribeFromDataset</name>
    /// <description>The following examples have been edited for readability.</description>
    /// <request>
    /// POST / HTTP/1.1
    /// CONTENT-TYPE: application/json
    /// X-AMZ-REQUESTSUPERTRACE: true
    /// X-AMZN-REQUESTID: 676896d6-14ca-45b1-8029-6d36b10a077e
    /// X-AMZ-TARGET: com.amazonaws.cognito.sync.model.AWSCognitoSyncService.UnsubscribeFromDataset
    /// HOST: cognito-sync.us-east-1.amazonaws.com
    /// X-AMZ-DATE: 20141004T195446Z
    /// X-AMZ-SECURITY-TOKEN: <securitytoken>
    /// AUTHORIZATION: AWS4-HMAC-SHA256 Credential=<credential>, SignedHeaders=content-type;content-length;host;x-amz-date;x-amz-target, Signature=<signature>
    ///
    /// {
    /// "Operation": "com.amazonaws.cognito.sync.model#UnsubscribeFromDataset",
    /// "Service": "com.amazonaws.cognito.sync.model#AWSCognitoSyncService",
    /// "Input":
    /// {
    /// "IdentityPoolId": "ID_POOL_ID",
    /// "IdentityId": "IDENTITY_ID",
    /// "DatasetName": "Rufus",
    /// "DeviceId": "5cd28fbe-dd83-47ab-9f83-19093a5fb014"
    /// }
    /// }
    /// </request>
    /// <response>
    /// 1.1 200 OK
    /// x-amzn-requestid: 676896d6-14ca-45b1-8029-6d36b10a077e
    /// date: Sat, 04 Oct 2014 19:54:46 GMT
    /// content-type: application/json
    /// content-length: 103
    ///
    /// {
    /// "Output":
    /// {
    /// "__type": "com.amazonaws.cognito.sync.model#UnsubscribeFromDatasetResponse"
    /// },
    /// "Version": "1.0"
    /// }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::fmt::Debug)]
    pub struct UnsubscribeFromDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unsubscribe_from_dataset_input::Builder,
    }
    impl<C, M, R> UnsubscribeFromDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UnsubscribeFromDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnsubscribeFromDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::UnsubscribeFromDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnsubscribeFromDatasetInputOperationOutputAlias,
                crate::output::UnsubscribeFromDatasetOutput,
                crate::error::UnsubscribeFromDatasetError,
                crate::input::UnsubscribeFromDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. The ID of the pool to which this identity belongs.</p>
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// <p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by
        /// Amazon Cognito. The ID of the pool to which this identity belongs.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// <p>Unique ID for this identity.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The name of the dataset from which to unsubcribe.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset from which to unsubcribe.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(inp);
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecords`.
    ///
    /// <p>Posts updates to records and adds and deletes records for a dataset and user.</p>
    /// <p>The sync count in the record patch is your last known sync count for that record. The server will reject an UpdateRecords request with a ResourceConflictException if you try to patch a record with a new value but a stale sync count.</p><p>For example, if the sync count on the server is 5 for a key called highScore and you try and submit a new highScore with sync count of 4, the request will be rejected. To obtain the current sync count for a record, call ListRecords. On a successful update of the record, the response returns the new sync count for that record. You should present that sync count the next time you try to update that same record. When the record does not exist, specify the sync count as 0.</p>
    /// <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRecords<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_records_input::Builder,
    }
    impl<C, M, R> UpdateRecords<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecordsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRecordsInputOperationOutputAlias,
                crate::output::UpdateRecordsOutput,
                crate::error::UpdateRecordsError,
                crate::input::UpdateRecordsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_pool_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_pool_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_identity_pool_id(input);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// A name-spaced GUID (for example,
        /// us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is
        /// unique within a region.
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// A string of up to 128 characters.
        /// Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
        /// (dot).
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(inp);
            self
        }
        /// <p>The unique ID generated for this device by Cognito.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// Appends an item to `RecordPatches`.
        ///
        /// To override the contents of this collection use [`set_record_patches`](Self::set_record_patches).
        ///
        /// A list of patch
        /// operations.
        pub fn record_patches(mut self, inp: impl Into<crate::model::RecordPatch>) -> Self {
            self.inner = self.inner.record_patches(inp);
            self
        }
        /// A list of patch
        /// operations.
        pub fn set_record_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecordPatch>>,
        ) -> Self {
            self.inner = self.inner.set_record_patches(input);
            self
        }
        /// The SyncSessionToken returned by a
        /// previous call to ListRecords for this dataset and identity.
        pub fn sync_session_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_session_token(inp);
            self
        }
        /// The SyncSessionToken returned by a
        /// previous call to ListRecords for this dataset and identity.
        pub fn set_sync_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sync_session_token(input);
            self
        }
        /// Intended to supply a device ID that
        /// will populate the lastModifiedBy field referenced in other methods. The
        /// ClientContext field is not yet implemented.
        pub fn client_context(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_context(inp);
            self
        }
        /// Intended to supply a device ID that
        /// will populate the lastModifiedBy field referenced in other methods. The
        /// ClientContext field is not yet implemented.
        pub fn set_client_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_context(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
