// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddCustomAttributesInput`](crate::input::AddCustomAttributesInput)
pub mod add_custom_attributes_input {
    /// A builder for [`AddCustomAttributesInput`](crate::input::AddCustomAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) custom_attributes:
            std::option::Option<std::vec::Vec<crate::model::SchemaAttributeType>>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to add custom attributes.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to add custom attributes.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Appends an item to `custom_attributes`.
        ///
        /// To override the contents of this collection use [`set_custom_attributes`](Self::set_custom_attributes).
        ///
        /// <p>An array of custom attributes, such as Mutable and Name.</p>
        pub fn custom_attributes(mut self, input: crate::model::SchemaAttributeType) -> Self {
            let mut v = self.custom_attributes.unwrap_or_default();
            v.push(input);
            self.custom_attributes = Some(v);
            self
        }
        /// <p>An array of custom attributes, such as Mutable and Name.</p>
        pub fn set_custom_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaAttributeType>>,
        ) -> Self {
            self.custom_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`AddCustomAttributesInput`](crate::input::AddCustomAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddCustomAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddCustomAttributesInput {
                user_pool_id: self.user_pool_id,
                custom_attributes: self.custom_attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type AddCustomAttributesInputOperationOutputAlias = crate::operation::AddCustomAttributes;
#[doc(hidden)]
pub type AddCustomAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddCustomAttributesInput {
    /// Consumes the builder and constructs an Operation<[`AddCustomAttributes`](crate::operation::AddCustomAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddCustomAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddCustomAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddCustomAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddCustomAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AddCustomAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_custom_attributes(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddCustomAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddCustomAttributes",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddCustomAttributesInput`](crate::input::AddCustomAttributesInput)
    pub fn builder() -> crate::input::add_custom_attributes_input::Builder {
        crate::input::add_custom_attributes_input::Builder::default()
    }
}

/// See [`AdminAddUserToGroupInput`](crate::input::AdminAddUserToGroupInput)
pub mod admin_add_user_to_group_input {
    /// A builder for [`AdminAddUserToGroupInput`](crate::input::AdminAddUserToGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The username for the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The username for the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The group name.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The group name.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminAddUserToGroupInput`](crate::input::AdminAddUserToGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminAddUserToGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminAddUserToGroupInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                group_name: self.group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminAddUserToGroupInputOperationOutputAlias = crate::operation::AdminAddUserToGroup;
#[doc(hidden)]
pub type AdminAddUserToGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminAddUserToGroupInput {
    /// Consumes the builder and constructs an Operation<[`AdminAddUserToGroup`](crate::operation::AdminAddUserToGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminAddUserToGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminAddUserToGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminAddUserToGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminAddUserToGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminAddUserToGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_add_user_to_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminAddUserToGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminAddUserToGroup",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminAddUserToGroupInput`](crate::input::AdminAddUserToGroupInput)
    pub fn builder() -> crate::input::admin_add_user_to_group_input::Builder {
        crate::input::admin_add_user_to_group_input::Builder::default()
    }
}

/// See [`AdminConfirmSignUpInput`](crate::input::AdminConfirmSignUpInput)
pub mod admin_confirm_sign_up_input {
    /// A builder for [`AdminConfirmSignUpInput`](crate::input::AdminConfirmSignUpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The user pool ID for which you want to confirm user registration.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for which you want to confirm user registration.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name for which you want to confirm user registration.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name for which you want to confirm user registration.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>If your user pool configuration includes triggers, the AdminConfirmSignUp API action invokes the Lambda function that is specified for the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. In this payload, the <code>clientMetadata</code> attribute provides the data that you assigned to the ClientMetadata parameter in your AdminConfirmSignUp request. In your function code in Lambda, you can process the ClientMetadata value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>If your user pool configuration includes triggers, the AdminConfirmSignUp API action invokes the Lambda function that is specified for the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. In this payload, the <code>clientMetadata</code> attribute provides the data that you assigned to the ClientMetadata parameter in your AdminConfirmSignUp request. In your function code in Lambda, you can process the ClientMetadata value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminConfirmSignUpInput`](crate::input::AdminConfirmSignUpInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminConfirmSignUpInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminConfirmSignUpInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminConfirmSignUpInputOperationOutputAlias = crate::operation::AdminConfirmSignUp;
#[doc(hidden)]
pub type AdminConfirmSignUpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminConfirmSignUpInput {
    /// Consumes the builder and constructs an Operation<[`AdminConfirmSignUp`](crate::operation::AdminConfirmSignUp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminConfirmSignUp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminConfirmSignUpInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminConfirmSignUpInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminConfirmSignUpInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminConfirmSignUp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_confirm_sign_up(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminConfirmSignUp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminConfirmSignUp",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminConfirmSignUpInput`](crate::input::AdminConfirmSignUpInput)
    pub fn builder() -> crate::input::admin_confirm_sign_up_input::Builder {
        crate::input::admin_confirm_sign_up_input::Builder::default()
    }
}

/// See [`AdminCreateUserInput`](crate::input::AdminCreateUserInput)
pub mod admin_create_user_input {
    /// A builder for [`AdminCreateUserInput`](crate::input::AdminCreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) user_attributes: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        pub(crate) validation_data: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        pub(crate) temporary_password: std::option::Option<std::string::String>,
        pub(crate) force_alias_creation: std::option::Option<bool>,
        pub(crate) message_action: std::option::Option<crate::model::MessageActionType>,
        pub(crate) desired_delivery_mediums:
            std::option::Option<std::vec::Vec<crate::model::DeliveryMediumType>>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where the user will be created.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where the user will be created.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username can't be changed.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username can't be changed.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Appends an item to `user_attributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>An array of name-value pairs that contain user attributes and attribute values to be set for the user to be created. You can create a user without specifying any attributes other than <code>Username</code>. However, any attributes that you specify as required (when creating a user pool or in the <b>Attributes</b> tab of the console) either you should supply (in your call to <code>AdminCreateUser</code>) or the user should supply (when they sign up in response to your welcome message).</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        /// <p>To send a message inviting the user to sign up, you must specify the user's email address or phone number. You can do this in your call to AdminCreateUser or in the <b>Users</b> tab of the Amazon Cognito console for managing your user pools.</p>
        /// <p>In your call to <code>AdminCreateUser</code>, you can set the <code>email_verified</code> attribute to <code>True</code>, and you can set the <code>phone_number_verified</code> attribute to <code>True</code>. You can also do this by calling <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html">AdminUpdateUserAttributes</a>.</p>
        /// <ul>
        /// <li> <p> <b>email</b>: The email address of the user to whom the message that contains the code and username will be sent. Required if the <code>email_verified</code> attribute is set to <code>True</code>, or if <code>"EMAIL"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li>
        /// <li> <p> <b>phone_number</b>: The phone number of the user to whom the message that contains the code and username will be sent. Required if the <code>phone_number_verified</code> attribute is set to <code>True</code>, or if <code>"SMS"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li>
        /// </ul>
        pub fn user_attributes(mut self, input: crate::model::AttributeType) -> Self {
            let mut v = self.user_attributes.unwrap_or_default();
            v.push(input);
            self.user_attributes = Some(v);
            self
        }
        /// <p>An array of name-value pairs that contain user attributes and attribute values to be set for the user to be created. You can create a user without specifying any attributes other than <code>Username</code>. However, any attributes that you specify as required (when creating a user pool or in the <b>Attributes</b> tab of the console) either you should supply (in your call to <code>AdminCreateUser</code>) or the user should supply (when they sign up in response to your welcome message).</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        /// <p>To send a message inviting the user to sign up, you must specify the user's email address or phone number. You can do this in your call to AdminCreateUser or in the <b>Users</b> tab of the Amazon Cognito console for managing your user pools.</p>
        /// <p>In your call to <code>AdminCreateUser</code>, you can set the <code>email_verified</code> attribute to <code>True</code>, and you can set the <code>phone_number_verified</code> attribute to <code>True</code>. You can also do this by calling <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html">AdminUpdateUserAttributes</a>.</p>
        /// <ul>
        /// <li> <p> <b>email</b>: The email address of the user to whom the message that contains the code and username will be sent. Required if the <code>email_verified</code> attribute is set to <code>True</code>, or if <code>"EMAIL"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li>
        /// <li> <p> <b>phone_number</b>: The phone number of the user to whom the message that contains the code and username will be sent. Required if the <code>phone_number_verified</code> attribute is set to <code>True</code>, or if <code>"SMS"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li>
        /// </ul>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.user_attributes = input;
            self
        }
        /// Appends an item to `validation_data`.
        ///
        /// To override the contents of this collection use [`set_validation_data`](Self::set_validation_data).
        ///
        /// <p>The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user's domain.</p>
        /// <p>To configure custom validation, you must create a Pre Sign-up Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.</p>
        /// <p>The user's validation data isn't persisted.</p>
        pub fn validation_data(mut self, input: crate::model::AttributeType) -> Self {
            let mut v = self.validation_data.unwrap_or_default();
            v.push(input);
            self.validation_data = Some(v);
            self
        }
        /// <p>The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user's domain.</p>
        /// <p>To configure custom validation, you must create a Pre Sign-up Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.</p>
        /// <p>The user's validation data isn't persisted.</p>
        pub fn set_validation_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.validation_data = input;
            self
        }
        /// <p>The user's temporary password. This password must conform to the password policy that you specified when you created the user pool.</p>
        /// <p>The temporary password is valid only once. To complete the Admin Create User flow, the user must enter the temporary password in the sign-in page, along with a new password to be used in all future sign-ins.</p>
        /// <p>This parameter isn't required. If you don't specify a value, Amazon Cognito generates one for you.</p>
        /// <p>The temporary password can only be used until the user account expiration limit that you specified when you created the user pool. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter.</p>
        pub fn temporary_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.temporary_password = Some(input.into());
            self
        }
        /// <p>The user's temporary password. This password must conform to the password policy that you specified when you created the user pool.</p>
        /// <p>The temporary password is valid only once. To complete the Admin Create User flow, the user must enter the temporary password in the sign-in page, along with a new password to be used in all future sign-ins.</p>
        /// <p>This parameter isn't required. If you don't specify a value, Amazon Cognito generates one for you.</p>
        /// <p>The temporary password can only be used until the user account expiration limit that you specified when you created the user pool. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter.</p>
        pub fn set_temporary_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.temporary_password = input;
            self
        }
        /// <p>This parameter is used only if the <code>phone_number_verified</code> or <code>email_verified</code> attribute is set to <code>True</code>. Otherwise, it is ignored.</p>
        /// <p>If this parameter is set to <code>True</code> and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.</p>
        /// <p>If this parameter is set to <code>False</code>, the API throws an <code>AliasExistsException</code> error if the alias already exists. The default value is <code>False</code>.</p>
        pub fn force_alias_creation(mut self, input: bool) -> Self {
            self.force_alias_creation = Some(input);
            self
        }
        /// <p>This parameter is used only if the <code>phone_number_verified</code> or <code>email_verified</code> attribute is set to <code>True</code>. Otherwise, it is ignored.</p>
        /// <p>If this parameter is set to <code>True</code> and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.</p>
        /// <p>If this parameter is set to <code>False</code>, the API throws an <code>AliasExistsException</code> error if the alias already exists. The default value is <code>False</code>.</p>
        pub fn set_force_alias_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.force_alias_creation = input;
            self
        }
        /// <p>Set to <code>RESEND</code> to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to <code>SUPPRESS</code> to suppress sending the message. You can specify only one value.</p>
        pub fn message_action(mut self, input: crate::model::MessageActionType) -> Self {
            self.message_action = Some(input);
            self
        }
        /// <p>Set to <code>RESEND</code> to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to <code>SUPPRESS</code> to suppress sending the message. You can specify only one value.</p>
        pub fn set_message_action(
            mut self,
            input: std::option::Option<crate::model::MessageActionType>,
        ) -> Self {
            self.message_action = input;
            self
        }
        /// Appends an item to `desired_delivery_mediums`.
        ///
        /// To override the contents of this collection use [`set_desired_delivery_mediums`](Self::set_desired_delivery_mediums).
        ///
        /// <p>Specify <code>"EMAIL"</code> if email will be used to send the welcome message. Specify <code>"SMS"</code> if the phone number will be used. The default value is <code>"SMS"</code>. You can specify more than one value.</p>
        pub fn desired_delivery_mediums(mut self, input: crate::model::DeliveryMediumType) -> Self {
            let mut v = self.desired_delivery_mediums.unwrap_or_default();
            v.push(input);
            self.desired_delivery_mediums = Some(v);
            self
        }
        /// <p>Specify <code>"EMAIL"</code> if email will be used to send the welcome message. Specify <code>"SMS"</code> if the phone number will be used. The default value is <code>"SMS"</code>. You can specify more than one value.</p>
        pub fn set_desired_delivery_mediums(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeliveryMediumType>>,
        ) -> Self {
            self.desired_delivery_mediums = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminCreateUser API action, Amazon Cognito invokes the function that is assigned to the <i>pre sign-up</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminCreateUser request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminCreateUser API action, Amazon Cognito invokes the function that is assigned to the <i>pre sign-up</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminCreateUser request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminCreateUserInput`](crate::input::AdminCreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminCreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminCreateUserInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                user_attributes: self.user_attributes,
                validation_data: self.validation_data,
                temporary_password: self.temporary_password,
                force_alias_creation: self.force_alias_creation.unwrap_or_default(),
                message_action: self.message_action,
                desired_delivery_mediums: self.desired_delivery_mediums,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminCreateUserInputOperationOutputAlias = crate::operation::AdminCreateUser;
#[doc(hidden)]
pub type AdminCreateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminCreateUserInput {
    /// Consumes the builder and constructs an Operation<[`AdminCreateUser`](crate::operation::AdminCreateUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminCreateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminCreateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminCreateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminCreateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminCreateUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_create_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminCreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminCreateUser",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminCreateUserInput`](crate::input::AdminCreateUserInput)
    pub fn builder() -> crate::input::admin_create_user_input::Builder {
        crate::input::admin_create_user_input::Builder::default()
    }
}

/// See [`AdminDeleteUserInput`](crate::input::AdminDeleteUserInput)
pub mod admin_delete_user_input {
    /// A builder for [`AdminDeleteUserInput`](crate::input::AdminDeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to delete the user.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to delete the user.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name of the user you want to delete.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user you want to delete.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminDeleteUserInput`](crate::input::AdminDeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminDeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminDeleteUserInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminDeleteUserInputOperationOutputAlias = crate::operation::AdminDeleteUser;
#[doc(hidden)]
pub type AdminDeleteUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminDeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`AdminDeleteUser`](crate::operation::AdminDeleteUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminDeleteUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminDeleteUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminDeleteUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminDeleteUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminDeleteUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_delete_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminDeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminDeleteUser",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminDeleteUserInput`](crate::input::AdminDeleteUserInput)
    pub fn builder() -> crate::input::admin_delete_user_input::Builder {
        crate::input::admin_delete_user_input::Builder::default()
    }
}

/// See [`AdminDeleteUserAttributesInput`](crate::input::AdminDeleteUserAttributesInput)
pub mod admin_delete_user_attributes_input {
    /// A builder for [`AdminDeleteUserAttributesInput`](crate::input::AdminDeleteUserAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) user_attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to delete user attributes.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to delete user attributes.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name of the user from which you would like to delete attributes.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user from which you would like to delete attributes.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Appends an item to `user_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_user_attribute_names`](Self::set_user_attribute_names).
        ///
        /// <p>An array of strings representing the user attribute names you want to delete.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn user_attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_attribute_names.unwrap_or_default();
            v.push(input.into());
            self.user_attribute_names = Some(v);
            self
        }
        /// <p>An array of strings representing the user attribute names you want to delete.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn set_user_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_attribute_names = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminDeleteUserAttributesInput`](crate::input::AdminDeleteUserAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminDeleteUserAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminDeleteUserAttributesInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                user_attribute_names: self.user_attribute_names,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminDeleteUserAttributesInputOperationOutputAlias =
    crate::operation::AdminDeleteUserAttributes;
#[doc(hidden)]
pub type AdminDeleteUserAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminDeleteUserAttributesInput {
    /// Consumes the builder and constructs an Operation<[`AdminDeleteUserAttributes`](crate::operation::AdminDeleteUserAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminDeleteUserAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminDeleteUserAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminDeleteUserAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminDeleteUserAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminDeleteUserAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_delete_user_attributes(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminDeleteUserAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminDeleteUserAttributes",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminDeleteUserAttributesInput`](crate::input::AdminDeleteUserAttributesInput)
    pub fn builder() -> crate::input::admin_delete_user_attributes_input::Builder {
        crate::input::admin_delete_user_attributes_input::Builder::default()
    }
}

/// See [`AdminDisableProviderForUserInput`](crate::input::AdminDisableProviderForUserInput)
pub mod admin_disable_provider_for_user_input {
    /// A builder for [`AdminDisableProviderForUserInput`](crate::input::AdminDisableProviderForUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) user: std::option::Option<crate::model::ProviderUserIdentifierType>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user to be disabled.</p>
        pub fn user(mut self, input: crate::model::ProviderUserIdentifierType) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>The user to be disabled.</p>
        pub fn set_user(
            mut self,
            input: std::option::Option<crate::model::ProviderUserIdentifierType>,
        ) -> Self {
            self.user = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminDisableProviderForUserInput`](crate::input::AdminDisableProviderForUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminDisableProviderForUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminDisableProviderForUserInput {
                user_pool_id: self.user_pool_id,
                user: self.user,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminDisableProviderForUserInputOperationOutputAlias =
    crate::operation::AdminDisableProviderForUser;
#[doc(hidden)]
pub type AdminDisableProviderForUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminDisableProviderForUserInput {
    /// Consumes the builder and constructs an Operation<[`AdminDisableProviderForUser`](crate::operation::AdminDisableProviderForUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminDisableProviderForUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminDisableProviderForUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminDisableProviderForUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminDisableProviderForUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminDisableProviderForUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_disable_provider_for_user(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminDisableProviderForUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminDisableProviderForUser",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminDisableProviderForUserInput`](crate::input::AdminDisableProviderForUserInput)
    pub fn builder() -> crate::input::admin_disable_provider_for_user_input::Builder {
        crate::input::admin_disable_provider_for_user_input::Builder::default()
    }
}

/// See [`AdminDisableUserInput`](crate::input::AdminDisableUserInput)
pub mod admin_disable_user_input {
    /// A builder for [`AdminDisableUserInput`](crate::input::AdminDisableUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to disable the user.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to disable the user.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name of the user you want to disable.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user you want to disable.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminDisableUserInput`](crate::input::AdminDisableUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminDisableUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminDisableUserInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminDisableUserInputOperationOutputAlias = crate::operation::AdminDisableUser;
#[doc(hidden)]
pub type AdminDisableUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminDisableUserInput {
    /// Consumes the builder and constructs an Operation<[`AdminDisableUser`](crate::operation::AdminDisableUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminDisableUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminDisableUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminDisableUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminDisableUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminDisableUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_disable_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminDisableUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminDisableUser",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminDisableUserInput`](crate::input::AdminDisableUserInput)
    pub fn builder() -> crate::input::admin_disable_user_input::Builder {
        crate::input::admin_disable_user_input::Builder::default()
    }
}

/// See [`AdminEnableUserInput`](crate::input::AdminEnableUserInput)
pub mod admin_enable_user_input {
    /// A builder for [`AdminEnableUserInput`](crate::input::AdminEnableUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to enable the user.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to enable the user.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name of the user you want to enable.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user you want to enable.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminEnableUserInput`](crate::input::AdminEnableUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminEnableUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminEnableUserInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminEnableUserInputOperationOutputAlias = crate::operation::AdminEnableUser;
#[doc(hidden)]
pub type AdminEnableUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminEnableUserInput {
    /// Consumes the builder and constructs an Operation<[`AdminEnableUser`](crate::operation::AdminEnableUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminEnableUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminEnableUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminEnableUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminEnableUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminEnableUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_enable_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminEnableUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminEnableUser",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminEnableUserInput`](crate::input::AdminEnableUserInput)
    pub fn builder() -> crate::input::admin_enable_user_input::Builder {
        crate::input::admin_enable_user_input::Builder::default()
    }
}

/// See [`AdminForgetDeviceInput`](crate::input::AdminForgetDeviceInput)
pub mod admin_forget_device_input {
    /// A builder for [`AdminForgetDeviceInput`](crate::input::AdminForgetDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) device_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_key = Some(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_key = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminForgetDeviceInput`](crate::input::AdminForgetDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminForgetDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminForgetDeviceInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                device_key: self.device_key,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminForgetDeviceInputOperationOutputAlias = crate::operation::AdminForgetDevice;
#[doc(hidden)]
pub type AdminForgetDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminForgetDeviceInput {
    /// Consumes the builder and constructs an Operation<[`AdminForgetDevice`](crate::operation::AdminForgetDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminForgetDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminForgetDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminForgetDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminForgetDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminForgetDevice",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_forget_device(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminForgetDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminForgetDevice",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminForgetDeviceInput`](crate::input::AdminForgetDeviceInput)
    pub fn builder() -> crate::input::admin_forget_device_input::Builder {
        crate::input::admin_forget_device_input::Builder::default()
    }
}

/// See [`AdminGetDeviceInput`](crate::input::AdminGetDeviceInput)
pub mod admin_get_device_input {
    /// A builder for [`AdminGetDeviceInput`](crate::input::AdminGetDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_key: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_key = Some(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_key = input;
            self
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminGetDeviceInput`](crate::input::AdminGetDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminGetDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminGetDeviceInput {
                device_key: self.device_key,
                user_pool_id: self.user_pool_id,
                username: self.username,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminGetDeviceInputOperationOutputAlias = crate::operation::AdminGetDevice;
#[doc(hidden)]
pub type AdminGetDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminGetDeviceInput {
    /// Consumes the builder and constructs an Operation<[`AdminGetDevice`](crate::operation::AdminGetDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminGetDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminGetDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminGetDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminGetDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminGetDevice",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_get_device(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminGetDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminGetDevice",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminGetDeviceInput`](crate::input::AdminGetDeviceInput)
    pub fn builder() -> crate::input::admin_get_device_input::Builder {
        crate::input::admin_get_device_input::Builder::default()
    }
}

/// See [`AdminGetUserInput`](crate::input::AdminGetUserInput)
pub mod admin_get_user_input {
    /// A builder for [`AdminGetUserInput`](crate::input::AdminGetUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to get information about the user.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to get information about the user.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name of the user you want to retrieve.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user you want to retrieve.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminGetUserInput`](crate::input::AdminGetUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminGetUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminGetUserInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminGetUserInputOperationOutputAlias = crate::operation::AdminGetUser;
#[doc(hidden)]
pub type AdminGetUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminGetUserInput {
    /// Consumes the builder and constructs an Operation<[`AdminGetUser`](crate::operation::AdminGetUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminGetUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminGetUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminGetUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminGetUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminGetUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_get_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminGetUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminGetUser",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminGetUserInput`](crate::input::AdminGetUserInput)
    pub fn builder() -> crate::input::admin_get_user_input::Builder {
        crate::input::admin_get_user_input::Builder::default()
    }
}

/// See [`AdminInitiateAuthInput`](crate::input::AdminInitiateAuthInput)
pub mod admin_initiate_auth_input {
    /// A builder for [`AdminInitiateAuthInput`](crate::input::AdminInitiateAuthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) auth_flow: std::option::Option<crate::model::AuthFlowType>,
        pub(crate) auth_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) analytics_metadata: std::option::Option<crate::model::AnalyticsMetadataType>,
        pub(crate) context_data: std::option::Option<crate::model::ContextDataType>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The app client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The app client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The authentication flow for this call to run. The API action will depend on this value. For example:</p>
        /// <ul>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li>
        /// <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the Secure Remote Password (SRP) protocol variables to be used for next challenge execution.</p> </li>
        /// <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code> will take in <code>USERNAME</code> and <code>PASSWORD</code> and return the next challenge or tokens.</p> </li>
        /// </ul>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li>
        /// <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li>
        /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: Non-SRP authentication flow; you can pass in the USERNAME and PASSWORD directly if the flow is enabled for calling the app client.</p> </li>
        /// <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code>: Admin-based user password authentication. This replaces the <code>ADMIN_NO_SRP_AUTH</code> authentication flow. In this flow, Amazon Cognito receives the password in the request instead of using the SRP process to verify passwords.</p> </li>
        /// </ul>
        pub fn auth_flow(mut self, input: crate::model::AuthFlowType) -> Self {
            self.auth_flow = Some(input);
            self
        }
        /// <p>The authentication flow for this call to run. The API action will depend on this value. For example:</p>
        /// <ul>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li>
        /// <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the Secure Remote Password (SRP) protocol variables to be used for next challenge execution.</p> </li>
        /// <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code> will take in <code>USERNAME</code> and <code>PASSWORD</code> and return the next challenge or tokens.</p> </li>
        /// </ul>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li>
        /// <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li>
        /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: Non-SRP authentication flow; you can pass in the USERNAME and PASSWORD directly if the flow is enabled for calling the app client.</p> </li>
        /// <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code>: Admin-based user password authentication. This replaces the <code>ADMIN_NO_SRP_AUTH</code> authentication flow. In this flow, Amazon Cognito receives the password in the request instead of using the SRP process to verify passwords.</p> </li>
        /// </ul>
        pub fn set_auth_flow(
            mut self,
            input: std::option::Option<crate::model::AuthFlowType>,
        ) -> Self {
            self.auth_flow = input;
            self
        }
        /// Adds a key-value pair to `auth_parameters`.
        ///
        /// To override the contents of this collection use [`set_auth_parameters`](Self::set_auth_parameters).
        ///
        /// <p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you're invoking. The required values depend on the value of <code>AuthFlow</code>:</p>
        /// <ul>
        /// <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>ADMIN_NO_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>PASSWORD</code> (required), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li>
        /// </ul>
        pub fn auth_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.auth_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.auth_parameters = Some(hash_map);
            self
        }
        /// <p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you're invoking. The required values depend on the value of <code>AuthFlow</code>:</p>
        /// <ul>
        /// <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>ADMIN_NO_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>PASSWORD</code> (required), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li>
        /// </ul>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.auth_parameters = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminInitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p>
        /// <ul>
        /// <li> <p>Pre signup</p> </li>
        /// <li> <p>Pre authentication</p> </li>
        /// <li> <p>User migration</p> </li>
        /// </ul>
        /// <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminInitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p>
        /// <p>When you use the AdminInitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it doesn't provide the ClientMetadata value as input:</p>
        /// <ul>
        /// <li> <p>Post authentication</p> </li>
        /// <li> <p>Custom message</p> </li>
        /// <li> <p>Pre token generation</p> </li>
        /// <li> <p>Create auth challenge</p> </li>
        /// <li> <p>Define auth challenge</p> </li>
        /// <li> <p>Verify auth challenge</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminInitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p>
        /// <ul>
        /// <li> <p>Pre signup</p> </li>
        /// <li> <p>Pre authentication</p> </li>
        /// <li> <p>User migration</p> </li>
        /// </ul>
        /// <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminInitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p>
        /// <p>When you use the AdminInitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it doesn't provide the ClientMetadata value as input:</p>
        /// <ul>
        /// <li> <p>Post authentication</p> </li>
        /// <li> <p>Custom message</p> </li>
        /// <li> <p>Pre token generation</p> </li>
        /// <li> <p>Create auth challenge</p> </li>
        /// <li> <p>Define auth challenge</p> </li>
        /// <li> <p>Verify auth challenge</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// <p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminInitiateAuth</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.analytics_metadata = Some(input);
            self
        }
        /// <p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminInitiateAuth</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.analytics_metadata = input;
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn context_data(mut self, input: crate::model::ContextDataType) -> Self {
            self.context_data = Some(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_context_data(
            mut self,
            input: std::option::Option<crate::model::ContextDataType>,
        ) -> Self {
            self.context_data = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminInitiateAuthInput`](crate::input::AdminInitiateAuthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminInitiateAuthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminInitiateAuthInput {
                user_pool_id: self.user_pool_id,
                client_id: self.client_id,
                auth_flow: self.auth_flow,
                auth_parameters: self.auth_parameters,
                client_metadata: self.client_metadata,
                analytics_metadata: self.analytics_metadata,
                context_data: self.context_data,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminInitiateAuthInputOperationOutputAlias = crate::operation::AdminInitiateAuth;
#[doc(hidden)]
pub type AdminInitiateAuthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminInitiateAuthInput {
    /// Consumes the builder and constructs an Operation<[`AdminInitiateAuth`](crate::operation::AdminInitiateAuth)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminInitiateAuth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminInitiateAuthInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminInitiateAuthInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminInitiateAuthInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminInitiateAuth",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_initiate_auth(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminInitiateAuth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminInitiateAuth",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminInitiateAuthInput`](crate::input::AdminInitiateAuthInput)
    pub fn builder() -> crate::input::admin_initiate_auth_input::Builder {
        crate::input::admin_initiate_auth_input::Builder::default()
    }
}

/// See [`AdminLinkProviderForUserInput`](crate::input::AdminLinkProviderForUserInput)
pub mod admin_link_provider_for_user_input {
    /// A builder for [`AdminLinkProviderForUserInput`](crate::input::AdminLinkProviderForUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) destination_user: std::option::Option<crate::model::ProviderUserIdentifierType>,
        pub(crate) source_user: std::option::Option<crate::model::ProviderUserIdentifierType>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The existing user in the user pool to be linked to the external identity provider user account. Can be a native (Username + Password) Amazon Cognito User Pools user or a federated user (for example, a SAML or Facebook user). If the user doesn't exist, an exception is thrown. This is the user that is returned when the new user (with the linked identity provider attribute) signs in.</p>
        /// <p>For a native username + password user, the <code>ProviderAttributeValue</code> for the <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should be the provider-specific <code>user_id</code>.</p>
        /// <p>The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.</p>
        /// <p>The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.</p> <important>
        /// <p>All attributes in the DestinationUser profile must be mutable. If you have assigned the user any immutable custom attributes, the operation won't succeed.</p>
        /// </important>
        pub fn destination_user(mut self, input: crate::model::ProviderUserIdentifierType) -> Self {
            self.destination_user = Some(input);
            self
        }
        /// <p>The existing user in the user pool to be linked to the external identity provider user account. Can be a native (Username + Password) Amazon Cognito User Pools user or a federated user (for example, a SAML or Facebook user). If the user doesn't exist, an exception is thrown. This is the user that is returned when the new user (with the linked identity provider attribute) signs in.</p>
        /// <p>For a native username + password user, the <code>ProviderAttributeValue</code> for the <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should be the provider-specific <code>user_id</code>.</p>
        /// <p>The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.</p>
        /// <p>The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.</p> <important>
        /// <p>All attributes in the DestinationUser profile must be mutable. If you have assigned the user any immutable custom attributes, the operation won't succeed.</p>
        /// </important>
        pub fn set_destination_user(
            mut self,
            input: std::option::Option<crate::model::ProviderUserIdentifierType>,
        ) -> Self {
            self.destination_user = input;
            self
        }
        /// <p>An external identity provider account for a user who doesn't exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.</p>
        /// <p>If the <code>SourceUser</code> is using a federated social identity provider, such as Facebook, Google, or Login with Amazon, you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social identity providers, the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or <code>LoginWithAmazon</code>, and Amazon Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>, <code>sub</code>, or <code>user_id</code> value found in the social identity provider token.</p>
        /// <p></p>
        /// <p>For SAML, the <code>ProviderAttributeName</code> can be any value that matches a claim in the SAML assertion. If you want to link SAML users based on the subject of the SAML assertion, you should map the subject to a claim through the SAML identity provider and submit that claim name as the <code>ProviderAttributeName</code>. If you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Amazon Cognito will automatically parse the default unique identifier found in the subject from the SAML token.</p>
        pub fn source_user(mut self, input: crate::model::ProviderUserIdentifierType) -> Self {
            self.source_user = Some(input);
            self
        }
        /// <p>An external identity provider account for a user who doesn't exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.</p>
        /// <p>If the <code>SourceUser</code> is using a federated social identity provider, such as Facebook, Google, or Login with Amazon, you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social identity providers, the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or <code>LoginWithAmazon</code>, and Amazon Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>, <code>sub</code>, or <code>user_id</code> value found in the social identity provider token.</p>
        /// <p></p>
        /// <p>For SAML, the <code>ProviderAttributeName</code> can be any value that matches a claim in the SAML assertion. If you want to link SAML users based on the subject of the SAML assertion, you should map the subject to a claim through the SAML identity provider and submit that claim name as the <code>ProviderAttributeName</code>. If you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Amazon Cognito will automatically parse the default unique identifier found in the subject from the SAML token.</p>
        pub fn set_source_user(
            mut self,
            input: std::option::Option<crate::model::ProviderUserIdentifierType>,
        ) -> Self {
            self.source_user = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminLinkProviderForUserInput`](crate::input::AdminLinkProviderForUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminLinkProviderForUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminLinkProviderForUserInput {
                user_pool_id: self.user_pool_id,
                destination_user: self.destination_user,
                source_user: self.source_user,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminLinkProviderForUserInputOperationOutputAlias =
    crate::operation::AdminLinkProviderForUser;
#[doc(hidden)]
pub type AdminLinkProviderForUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminLinkProviderForUserInput {
    /// Consumes the builder and constructs an Operation<[`AdminLinkProviderForUser`](crate::operation::AdminLinkProviderForUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminLinkProviderForUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminLinkProviderForUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminLinkProviderForUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminLinkProviderForUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminLinkProviderForUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_link_provider_for_user(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminLinkProviderForUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminLinkProviderForUser",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminLinkProviderForUserInput`](crate::input::AdminLinkProviderForUserInput)
    pub fn builder() -> crate::input::admin_link_provider_for_user_input::Builder {
        crate::input::admin_link_provider_for_user_input::Builder::default()
    }
}

/// See [`AdminListDevicesInput`](crate::input::AdminListDevicesInput)
pub mod admin_list_devices_input {
    /// A builder for [`AdminListDevicesInput`](crate::input::AdminListDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) pagination_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The limit of the devices request.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The limit of the devices request.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The pagination token.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.pagination_token = Some(input.into());
            self
        }
        /// <p>The pagination token.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pagination_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminListDevicesInput`](crate::input::AdminListDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminListDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminListDevicesInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                limit: self.limit,
                pagination_token: self.pagination_token,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminListDevicesInputOperationOutputAlias = crate::operation::AdminListDevices;
#[doc(hidden)]
pub type AdminListDevicesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminListDevicesInput {
    /// Consumes the builder and constructs an Operation<[`AdminListDevices`](crate::operation::AdminListDevices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminListDevices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminListDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminListDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminListDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminListDevices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_list_devices(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminListDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminListDevices",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminListDevicesInput`](crate::input::AdminListDevicesInput)
    pub fn builder() -> crate::input::admin_list_devices_input::Builder {
        crate::input::admin_list_devices_input::Builder::default()
    }
}

/// See [`AdminListGroupsForUserInput`](crate::input::AdminListGroupsForUserInput)
pub mod admin_list_groups_for_user_input {
    /// A builder for [`AdminListGroupsForUserInput`](crate::input::AdminListGroupsForUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The username for the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The username for the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The limit of the request to list groups.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The limit of the request to list groups.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminListGroupsForUserInput`](crate::input::AdminListGroupsForUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminListGroupsForUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminListGroupsForUserInput {
                username: self.username,
                user_pool_id: self.user_pool_id,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminListGroupsForUserInputOperationOutputAlias = crate::operation::AdminListGroupsForUser;
#[doc(hidden)]
pub type AdminListGroupsForUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminListGroupsForUserInput {
    /// Consumes the builder and constructs an Operation<[`AdminListGroupsForUser`](crate::operation::AdminListGroupsForUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminListGroupsForUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminListGroupsForUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminListGroupsForUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminListGroupsForUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminListGroupsForUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_list_groups_for_user(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminListGroupsForUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminListGroupsForUser",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminListGroupsForUserInput`](crate::input::AdminListGroupsForUserInput)
    pub fn builder() -> crate::input::admin_list_groups_for_user_input::Builder {
        crate::input::admin_list_groups_for_user_input::Builder::default()
    }
}

/// See [`AdminListUserAuthEventsInput`](crate::input::AdminListUserAuthEventsInput)
pub mod admin_list_user_auth_events_input {
    /// A builder for [`AdminListUserAuthEventsInput`](crate::input::AdminListUserAuthEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user pool username or an alias.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user pool username or an alias.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The maximum number of authentication events to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of authentication events to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminListUserAuthEventsInput`](crate::input::AdminListUserAuthEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminListUserAuthEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminListUserAuthEventsInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminListUserAuthEventsInputOperationOutputAlias =
    crate::operation::AdminListUserAuthEvents;
#[doc(hidden)]
pub type AdminListUserAuthEventsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminListUserAuthEventsInput {
    /// Consumes the builder and constructs an Operation<[`AdminListUserAuthEvents`](crate::operation::AdminListUserAuthEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminListUserAuthEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminListUserAuthEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminListUserAuthEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminListUserAuthEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminListUserAuthEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_list_user_auth_events(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminListUserAuthEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminListUserAuthEvents",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminListUserAuthEventsInput`](crate::input::AdminListUserAuthEventsInput)
    pub fn builder() -> crate::input::admin_list_user_auth_events_input::Builder {
        crate::input::admin_list_user_auth_events_input::Builder::default()
    }
}

/// See [`AdminRemoveUserFromGroupInput`](crate::input::AdminRemoveUserFromGroupInput)
pub mod admin_remove_user_from_group_input {
    /// A builder for [`AdminRemoveUserFromGroupInput`](crate::input::AdminRemoveUserFromGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The username for the user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The username for the user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The group name.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The group name.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminRemoveUserFromGroupInput`](crate::input::AdminRemoveUserFromGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminRemoveUserFromGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminRemoveUserFromGroupInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                group_name: self.group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminRemoveUserFromGroupInputOperationOutputAlias =
    crate::operation::AdminRemoveUserFromGroup;
#[doc(hidden)]
pub type AdminRemoveUserFromGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminRemoveUserFromGroupInput {
    /// Consumes the builder and constructs an Operation<[`AdminRemoveUserFromGroup`](crate::operation::AdminRemoveUserFromGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminRemoveUserFromGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminRemoveUserFromGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminRemoveUserFromGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminRemoveUserFromGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminRemoveUserFromGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_remove_user_from_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminRemoveUserFromGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminRemoveUserFromGroup",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminRemoveUserFromGroupInput`](crate::input::AdminRemoveUserFromGroupInput)
    pub fn builder() -> crate::input::admin_remove_user_from_group_input::Builder {
        crate::input::admin_remove_user_from_group_input::Builder::default()
    }
}

/// See [`AdminResetUserPasswordInput`](crate::input::AdminResetUserPasswordInput)
pub mod admin_reset_user_password_input {
    /// A builder for [`AdminResetUserPasswordInput`](crate::input::AdminResetUserPasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to reset the user's password.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to reset the user's password.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name of the user whose password you want to reset.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user whose password you want to reset.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminResetUserPassword API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminResetUserPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminResetUserPassword API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminResetUserPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminResetUserPasswordInput`](crate::input::AdminResetUserPasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminResetUserPasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminResetUserPasswordInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminResetUserPasswordInputOperationOutputAlias = crate::operation::AdminResetUserPassword;
#[doc(hidden)]
pub type AdminResetUserPasswordInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminResetUserPasswordInput {
    /// Consumes the builder and constructs an Operation<[`AdminResetUserPassword`](crate::operation::AdminResetUserPassword)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminResetUserPassword,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminResetUserPasswordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminResetUserPasswordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminResetUserPasswordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminResetUserPassword",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_reset_user_password(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminResetUserPassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminResetUserPassword",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminResetUserPasswordInput`](crate::input::AdminResetUserPasswordInput)
    pub fn builder() -> crate::input::admin_reset_user_password_input::Builder {
        crate::input::admin_reset_user_password_input::Builder::default()
    }
}

/// See [`AdminRespondToAuthChallengeInput`](crate::input::AdminRespondToAuthChallengeInput)
pub mod admin_respond_to_auth_challenge_input {
    /// A builder for [`AdminRespondToAuthChallengeInput`](crate::input::AdminRespondToAuthChallengeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) challenge_name: std::option::Option<crate::model::ChallengeNameType>,
        pub(crate) challenge_responses: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) session: std::option::Option<std::string::String>,
        pub(crate) analytics_metadata: std::option::Option<crate::model::AnalyticsMetadataType>,
        pub(crate) context_data: std::option::Option<crate::model::ContextDataType>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The app client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The app client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
        pub fn challenge_name(mut self, input: crate::model::ChallengeNameType) -> Self {
            self.challenge_name = Some(input);
            self
        }
        /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>
        pub fn set_challenge_name(
            mut self,
            input: std::option::Option<crate::model::ChallengeNameType>,
        ) -> Self {
            self.challenge_name = input;
            self
        }
        /// Adds a key-value pair to `challenge_responses`.
        ///
        /// To override the contents of this collection use [`set_challenge_responses`](Self::set_challenge_responses).
        ///
        /// <p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p>
        /// <ul>
        /// <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> <note>
        /// <p> <code>PASSWORD_VERIFIER</code> requires <code>DEVICE_KEY</code> when signing in with a remembered device.</p>
        /// </note> </li>
        /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: <code>PASSWORD</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li>
        /// <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you must use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li>
        /// </ul>
        /// <p>The value of the <code>USERNAME</code> attribute must be the user's actual username, not an alias (such as an email address or phone number). To make this simpler, the <code>AdminInitiateAuth</code> response includes the actual username value in the <code>USERNAMEUSER_ID_FOR_SRP</code> attribute. This happens even if you specified an alias in your call to <code>AdminInitiateAuth</code>.</p>
        pub fn challenge_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.challenge_responses.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.challenge_responses = Some(hash_map);
            self
        }
        /// <p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p>
        /// <ul>
        /// <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> <note>
        /// <p> <code>PASSWORD_VERIFIER</code> requires <code>DEVICE_KEY</code> when signing in with a remembered device.</p>
        /// </note> </li>
        /// <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: <code>PASSWORD</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li>
        /// <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you must use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li>
        /// </ul>
        /// <p>The value of the <code>USERNAME</code> attribute must be the user's actual username, not an alias (such as an email address or phone number). To make this simpler, the <code>AdminInitiateAuth</code> response includes the actual username value in the <code>USERNAMEUSER_ID_FOR_SRP</code> attribute. This happens even if you specified an alias in your call to <code>AdminInitiateAuth</code>.</p>
        pub fn set_challenge_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.challenge_responses = input;
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. If an <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller must pass another challenge, it returns a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.session = Some(input.into());
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. If an <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller must pass another challenge, it returns a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session = input;
            self
        }
        /// <p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminRespondToAuthChallenge</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.analytics_metadata = Some(input);
            self
        }
        /// <p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminRespondToAuthChallenge</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.analytics_metadata = input;
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn context_data(mut self, input: crate::model::ContextDataType) -> Self {
            self.context_data = Some(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_context_data(
            mut self,
            input: std::option::Option<crate::model::ContextDataType>,
        ) -> Self {
            self.context_data = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminRespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, <i>post authentication</i>, <i>user migration</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge response</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminRespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminRespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, <i>post authentication</i>, <i>user migration</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge response</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminRespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminRespondToAuthChallengeInput`](crate::input::AdminRespondToAuthChallengeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminRespondToAuthChallengeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminRespondToAuthChallengeInput {
                user_pool_id: self.user_pool_id,
                client_id: self.client_id,
                challenge_name: self.challenge_name,
                challenge_responses: self.challenge_responses,
                session: self.session,
                analytics_metadata: self.analytics_metadata,
                context_data: self.context_data,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminRespondToAuthChallengeInputOperationOutputAlias =
    crate::operation::AdminRespondToAuthChallenge;
#[doc(hidden)]
pub type AdminRespondToAuthChallengeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminRespondToAuthChallengeInput {
    /// Consumes the builder and constructs an Operation<[`AdminRespondToAuthChallenge`](crate::operation::AdminRespondToAuthChallenge)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminRespondToAuthChallenge,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminRespondToAuthChallengeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminRespondToAuthChallengeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminRespondToAuthChallengeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminRespondToAuthChallenge",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_respond_to_auth_challenge(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminRespondToAuthChallenge::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminRespondToAuthChallenge",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminRespondToAuthChallengeInput`](crate::input::AdminRespondToAuthChallengeInput)
    pub fn builder() -> crate::input::admin_respond_to_auth_challenge_input::Builder {
        crate::input::admin_respond_to_auth_challenge_input::Builder::default()
    }
}

/// See [`AdminSetUserMfaPreferenceInput`](crate::input::AdminSetUserMfaPreferenceInput)
pub mod admin_set_user_mfa_preference_input {
    /// A builder for [`AdminSetUserMfaPreferenceInput`](crate::input::AdminSetUserMfaPreferenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sms_mfa_settings: std::option::Option<crate::model::SmsMfaSettingsType>,
        pub(crate) software_token_mfa_settings:
            std::option::Option<crate::model::SoftwareTokenMfaSettingsType>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SMS text message MFA settings.</p>
        pub fn sms_mfa_settings(mut self, input: crate::model::SmsMfaSettingsType) -> Self {
            self.sms_mfa_settings = Some(input);
            self
        }
        /// <p>The SMS text message MFA settings.</p>
        pub fn set_sms_mfa_settings(
            mut self,
            input: std::option::Option<crate::model::SmsMfaSettingsType>,
        ) -> Self {
            self.sms_mfa_settings = input;
            self
        }
        /// <p>The time-based one-time password software token MFA settings.</p>
        pub fn software_token_mfa_settings(
            mut self,
            input: crate::model::SoftwareTokenMfaSettingsType,
        ) -> Self {
            self.software_token_mfa_settings = Some(input);
            self
        }
        /// <p>The time-based one-time password software token MFA settings.</p>
        pub fn set_software_token_mfa_settings(
            mut self,
            input: std::option::Option<crate::model::SoftwareTokenMfaSettingsType>,
        ) -> Self {
            self.software_token_mfa_settings = input;
            self
        }
        /// <p>The user pool username or alias.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user pool username or alias.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminSetUserMfaPreferenceInput`](crate::input::AdminSetUserMfaPreferenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminSetUserMfaPreferenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminSetUserMfaPreferenceInput {
                sms_mfa_settings: self.sms_mfa_settings,
                software_token_mfa_settings: self.software_token_mfa_settings,
                username: self.username,
                user_pool_id: self.user_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminSetUserMfaPreferenceInputOperationOutputAlias =
    crate::operation::AdminSetUserMFAPreference;
#[doc(hidden)]
pub type AdminSetUserMfaPreferenceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminSetUserMfaPreferenceInput {
    /// Consumes the builder and constructs an Operation<[`AdminSetUserMFAPreference`](crate::operation::AdminSetUserMFAPreference)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminSetUserMFAPreference,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminSetUserMfaPreferenceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminSetUserMfaPreferenceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminSetUserMfaPreferenceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminSetUserMFAPreference",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_set_user_mfa_preference(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminSetUserMFAPreference::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminSetUserMFAPreference",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminSetUserMfaPreferenceInput`](crate::input::AdminSetUserMfaPreferenceInput)
    pub fn builder() -> crate::input::admin_set_user_mfa_preference_input::Builder {
        crate::input::admin_set_user_mfa_preference_input::Builder::default()
    }
}

/// See [`AdminSetUserPasswordInput`](crate::input::AdminSetUserPasswordInput)
pub mod admin_set_user_password_input {
    /// A builder for [`AdminSetUserPasswordInput`](crate::input::AdminSetUserPasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) permanent: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to set the user's password.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to set the user's password.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name of the user whose password you want to set.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user whose password you want to set.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The password for the user.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password for the user.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p> <code>True</code> if the password is permanent, <code>False</code> if it is temporary.</p>
        pub fn permanent(mut self, input: bool) -> Self {
            self.permanent = Some(input);
            self
        }
        /// <p> <code>True</code> if the password is permanent, <code>False</code> if it is temporary.</p>
        pub fn set_permanent(mut self, input: std::option::Option<bool>) -> Self {
            self.permanent = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminSetUserPasswordInput`](crate::input::AdminSetUserPasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminSetUserPasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminSetUserPasswordInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                password: self.password,
                permanent: self.permanent.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type AdminSetUserPasswordInputOperationOutputAlias = crate::operation::AdminSetUserPassword;
#[doc(hidden)]
pub type AdminSetUserPasswordInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminSetUserPasswordInput {
    /// Consumes the builder and constructs an Operation<[`AdminSetUserPassword`](crate::operation::AdminSetUserPassword)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminSetUserPassword,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminSetUserPasswordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminSetUserPasswordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminSetUserPasswordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminSetUserPassword",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_set_user_password(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminSetUserPassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminSetUserPassword",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminSetUserPasswordInput`](crate::input::AdminSetUserPasswordInput)
    pub fn builder() -> crate::input::admin_set_user_password_input::Builder {
        crate::input::admin_set_user_password_input::Builder::default()
    }
}

/// See [`AdminSetUserSettingsInput`](crate::input::AdminSetUserSettingsInput)
pub mod admin_set_user_settings_input {
    /// A builder for [`AdminSetUserSettingsInput`](crate::input::AdminSetUserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) mfa_options: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
    }
    impl Builder {
        /// <p>The ID of the user pool that contains the user whose options you're setting.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the user pool that contains the user whose options you're setting.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name of the user whose options you're setting.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user whose options you're setting.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Appends an item to `mfa_options`.
        ///
        /// To override the contents of this collection use [`set_mfa_options`](Self::set_mfa_options).
        ///
        /// <p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>
        pub fn mfa_options(mut self, input: crate::model::MfaOptionType) -> Self {
            let mut v = self.mfa_options.unwrap_or_default();
            v.push(input);
            self.mfa_options = Some(v);
            self
        }
        /// <p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>
        pub fn set_mfa_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
        ) -> Self {
            self.mfa_options = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminSetUserSettingsInput`](crate::input::AdminSetUserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminSetUserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminSetUserSettingsInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                mfa_options: self.mfa_options,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminSetUserSettingsInputOperationOutputAlias = crate::operation::AdminSetUserSettings;
#[doc(hidden)]
pub type AdminSetUserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminSetUserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`AdminSetUserSettings`](crate::operation::AdminSetUserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminSetUserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminSetUserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminSetUserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminSetUserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminSetUserSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_set_user_settings(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminSetUserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminSetUserSettings",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminSetUserSettingsInput`](crate::input::AdminSetUserSettingsInput)
    pub fn builder() -> crate::input::admin_set_user_settings_input::Builder {
        crate::input::admin_set_user_settings_input::Builder::default()
    }
}

/// See [`AdminUpdateAuthEventFeedbackInput`](crate::input::AdminUpdateAuthEventFeedbackInput)
pub mod admin_update_auth_event_feedback_input {
    /// A builder for [`AdminUpdateAuthEventFeedbackInput`](crate::input::AdminUpdateAuthEventFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) feedback_value: std::option::Option<crate::model::FeedbackValueType>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user pool username.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user pool username.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The authentication event ID.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The authentication event ID.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The authentication event feedback value.</p>
        pub fn feedback_value(mut self, input: crate::model::FeedbackValueType) -> Self {
            self.feedback_value = Some(input);
            self
        }
        /// <p>The authentication event feedback value.</p>
        pub fn set_feedback_value(
            mut self,
            input: std::option::Option<crate::model::FeedbackValueType>,
        ) -> Self {
            self.feedback_value = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminUpdateAuthEventFeedbackInput`](crate::input::AdminUpdateAuthEventFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminUpdateAuthEventFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminUpdateAuthEventFeedbackInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                event_id: self.event_id,
                feedback_value: self.feedback_value,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminUpdateAuthEventFeedbackInputOperationOutputAlias =
    crate::operation::AdminUpdateAuthEventFeedback;
#[doc(hidden)]
pub type AdminUpdateAuthEventFeedbackInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AdminUpdateAuthEventFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`AdminUpdateAuthEventFeedback`](crate::operation::AdminUpdateAuthEventFeedback)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminUpdateAuthEventFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminUpdateAuthEventFeedbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminUpdateAuthEventFeedbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminUpdateAuthEventFeedbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminUpdateAuthEventFeedback",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_update_auth_event_feedback(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminUpdateAuthEventFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminUpdateAuthEventFeedback",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminUpdateAuthEventFeedbackInput`](crate::input::AdminUpdateAuthEventFeedbackInput)
    pub fn builder() -> crate::input::admin_update_auth_event_feedback_input::Builder {
        crate::input::admin_update_auth_event_feedback_input::Builder::default()
    }
}

/// See [`AdminUpdateDeviceStatusInput`](crate::input::AdminUpdateDeviceStatusInput)
pub mod admin_update_device_status_input {
    /// A builder for [`AdminUpdateDeviceStatusInput`](crate::input::AdminUpdateDeviceStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) device_key: std::option::Option<std::string::String>,
        pub(crate) device_remembered_status:
            std::option::Option<crate::model::DeviceRememberedStatusType>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_key = Some(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_key = input;
            self
        }
        /// <p>The status indicating whether a device has been remembered or not.</p>
        pub fn device_remembered_status(
            mut self,
            input: crate::model::DeviceRememberedStatusType,
        ) -> Self {
            self.device_remembered_status = Some(input);
            self
        }
        /// <p>The status indicating whether a device has been remembered or not.</p>
        pub fn set_device_remembered_status(
            mut self,
            input: std::option::Option<crate::model::DeviceRememberedStatusType>,
        ) -> Self {
            self.device_remembered_status = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminUpdateDeviceStatusInput`](crate::input::AdminUpdateDeviceStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminUpdateDeviceStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminUpdateDeviceStatusInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                device_key: self.device_key,
                device_remembered_status: self.device_remembered_status,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminUpdateDeviceStatusInputOperationOutputAlias =
    crate::operation::AdminUpdateDeviceStatus;
#[doc(hidden)]
pub type AdminUpdateDeviceStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminUpdateDeviceStatusInput {
    /// Consumes the builder and constructs an Operation<[`AdminUpdateDeviceStatus`](crate::operation::AdminUpdateDeviceStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminUpdateDeviceStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminUpdateDeviceStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminUpdateDeviceStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminUpdateDeviceStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminUpdateDeviceStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_update_device_status(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminUpdateDeviceStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminUpdateDeviceStatus",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminUpdateDeviceStatusInput`](crate::input::AdminUpdateDeviceStatusInput)
    pub fn builder() -> crate::input::admin_update_device_status_input::Builder {
        crate::input::admin_update_device_status_input::Builder::default()
    }
}

/// See [`AdminUpdateUserAttributesInput`](crate::input::AdminUpdateUserAttributesInput)
pub mod admin_update_user_attributes_input {
    /// A builder for [`AdminUpdateUserAttributesInput`](crate::input::AdminUpdateUserAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) user_attributes: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to update user attributes.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to update user attributes.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name of the user for whom you want to update user attributes.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user for whom you want to update user attributes.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Appends an item to `user_attributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn user_attributes(mut self, input: crate::model::AttributeType) -> Self {
            let mut v = self.user_attributes.unwrap_or_default();
            v.push(input);
            self.user_attributes = Some(v);
            self
        }
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.user_attributes = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminUpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminUpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminUpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminUpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminUpdateUserAttributesInput`](crate::input::AdminUpdateUserAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminUpdateUserAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminUpdateUserAttributesInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                user_attributes: self.user_attributes,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminUpdateUserAttributesInputOperationOutputAlias =
    crate::operation::AdminUpdateUserAttributes;
#[doc(hidden)]
pub type AdminUpdateUserAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminUpdateUserAttributesInput {
    /// Consumes the builder and constructs an Operation<[`AdminUpdateUserAttributes`](crate::operation::AdminUpdateUserAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminUpdateUserAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminUpdateUserAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminUpdateUserAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminUpdateUserAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminUpdateUserAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_update_user_attributes(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminUpdateUserAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminUpdateUserAttributes",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminUpdateUserAttributesInput`](crate::input::AdminUpdateUserAttributesInput)
    pub fn builder() -> crate::input::admin_update_user_attributes_input::Builder {
        crate::input::admin_update_user_attributes_input::Builder::default()
    }
}

/// See [`AdminUserGlobalSignOutInput`](crate::input::AdminUserGlobalSignOutInput)
pub mod admin_user_global_sign_out_input {
    /// A builder for [`AdminUserGlobalSignOutInput`](crate::input::AdminUserGlobalSignOutInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminUserGlobalSignOutInput`](crate::input::AdminUserGlobalSignOutInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdminUserGlobalSignOutInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdminUserGlobalSignOutInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
            })
        }
    }
}
#[doc(hidden)]
pub type AdminUserGlobalSignOutInputOperationOutputAlias = crate::operation::AdminUserGlobalSignOut;
#[doc(hidden)]
pub type AdminUserGlobalSignOutInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdminUserGlobalSignOutInput {
    /// Consumes the builder and constructs an Operation<[`AdminUserGlobalSignOut`](crate::operation::AdminUserGlobalSignOut)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdminUserGlobalSignOut,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdminUserGlobalSignOutInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdminUserGlobalSignOutInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdminUserGlobalSignOutInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AdminUserGlobalSignOut",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_admin_user_global_sign_out(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdminUserGlobalSignOut::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdminUserGlobalSignOut",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdminUserGlobalSignOutInput`](crate::input::AdminUserGlobalSignOutInput)
    pub fn builder() -> crate::input::admin_user_global_sign_out_input::Builder {
        crate::input::admin_user_global_sign_out_input::Builder::default()
    }
}

/// See [`AssociateSoftwareTokenInput`](crate::input::AssociateSoftwareTokenInput)
pub mod associate_software_token_input {
    /// A builder for [`AssociateSoftwareTokenInput`](crate::input::AssociateSoftwareTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) session: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.session = Some(input.into());
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateSoftwareTokenInput`](crate::input::AssociateSoftwareTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateSoftwareTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateSoftwareTokenInput {
                access_token: self.access_token,
                session: self.session,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateSoftwareTokenInputOperationOutputAlias = crate::operation::AssociateSoftwareToken;
#[doc(hidden)]
pub type AssociateSoftwareTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateSoftwareTokenInput {
    /// Consumes the builder and constructs an Operation<[`AssociateSoftwareToken`](crate::operation::AssociateSoftwareToken)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateSoftwareToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateSoftwareTokenInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateSoftwareTokenInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateSoftwareTokenInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.AssociateSoftwareToken",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_software_token(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateSoftwareToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateSoftwareToken",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateSoftwareTokenInput`](crate::input::AssociateSoftwareTokenInput)
    pub fn builder() -> crate::input::associate_software_token_input::Builder {
        crate::input::associate_software_token_input::Builder::default()
    }
}

/// See [`ChangePasswordInput`](crate::input::ChangePasswordInput)
pub mod change_password_input {
    /// A builder for [`ChangePasswordInput`](crate::input::ChangePasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) previous_password: std::option::Option<std::string::String>,
        pub(crate) proposed_password: std::option::Option<std::string::String>,
        pub(crate) access_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The old password.</p>
        pub fn previous_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.previous_password = Some(input.into());
            self
        }
        /// <p>The old password.</p>
        pub fn set_previous_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.previous_password = input;
            self
        }
        /// <p>The new password.</p>
        pub fn proposed_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposed_password = Some(input.into());
            self
        }
        /// <p>The new password.</p>
        pub fn set_proposed_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proposed_password = input;
            self
        }
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangePasswordInput`](crate::input::ChangePasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ChangePasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ChangePasswordInput {
                previous_password: self.previous_password,
                proposed_password: self.proposed_password,
                access_token: self.access_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ChangePasswordInputOperationOutputAlias = crate::operation::ChangePassword;
#[doc(hidden)]
pub type ChangePasswordInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ChangePasswordInput {
    /// Consumes the builder and constructs an Operation<[`ChangePassword`](crate::operation::ChangePassword)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ChangePassword,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ChangePasswordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ChangePasswordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ChangePasswordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ChangePassword",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_change_password(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ChangePassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ChangePassword",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ChangePasswordInput`](crate::input::ChangePasswordInput)
    pub fn builder() -> crate::input::change_password_input::Builder {
        crate::input::change_password_input::Builder::default()
    }
}

/// See [`ConfirmDeviceInput`](crate::input::ConfirmDeviceInput)
pub mod confirm_device_input {
    /// A builder for [`ConfirmDeviceInput`](crate::input::ConfirmDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) device_key: std::option::Option<std::string::String>,
        pub(crate) device_secret_verifier_config:
            std::option::Option<crate::model::DeviceSecretVerifierConfigType>,
        pub(crate) device_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_key = Some(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_key = input;
            self
        }
        /// <p>The configuration of the device secret verifier.</p>
        pub fn device_secret_verifier_config(
            mut self,
            input: crate::model::DeviceSecretVerifierConfigType,
        ) -> Self {
            self.device_secret_verifier_config = Some(input);
            self
        }
        /// <p>The configuration of the device secret verifier.</p>
        pub fn set_device_secret_verifier_config(
            mut self,
            input: std::option::Option<crate::model::DeviceSecretVerifierConfigType>,
        ) -> Self {
            self.device_secret_verifier_config = input;
            self
        }
        /// <p>The device name.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The device name.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmDeviceInput`](crate::input::ConfirmDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfirmDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfirmDeviceInput {
                access_token: self.access_token,
                device_key: self.device_key,
                device_secret_verifier_config: self.device_secret_verifier_config,
                device_name: self.device_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfirmDeviceInputOperationOutputAlias = crate::operation::ConfirmDevice;
#[doc(hidden)]
pub type ConfirmDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ConfirmDeviceInput {
    /// Consumes the builder and constructs an Operation<[`ConfirmDevice`](crate::operation::ConfirmDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfirmDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ConfirmDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ConfirmDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ConfirmDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ConfirmDevice",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_confirm_device(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfirmDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfirmDevice",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ConfirmDeviceInput`](crate::input::ConfirmDeviceInput)
    pub fn builder() -> crate::input::confirm_device_input::Builder {
        crate::input::confirm_device_input::Builder::default()
    }
}

/// See [`ConfirmForgotPasswordInput`](crate::input::ConfirmForgotPasswordInput)
pub mod confirm_forgot_password_input {
    /// A builder for [`ConfirmForgotPasswordInput`](crate::input::ConfirmForgotPasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) secret_hash: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) confirmation_code: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) analytics_metadata: std::option::Option<crate::model::AnalyticsMetadataType>,
        pub(crate) user_context_data: std::option::Option<crate::model::UserContextDataType>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn secret_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_hash = Some(input.into());
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn set_secret_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_hash = input;
            self
        }
        /// <p>The user name of the user for whom you want to enter a code to retrieve a forgotten password.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user for whom you want to enter a code to retrieve a forgotten password.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The confirmation code sent by a user's request to retrieve a forgotten password. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgotPassword.html">ForgotPassword</a>.</p>
        pub fn confirmation_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.confirmation_code = Some(input.into());
            self
        }
        /// <p>The confirmation code sent by a user's request to retrieve a forgotten password. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgotPassword.html">ForgotPassword</a>.</p>
        pub fn set_confirmation_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.confirmation_code = input;
            self
        }
        /// <p>The password sent by a user's request to retrieve a forgotten password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password sent by a user's request to retrieve a forgotten password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmForgotPassword</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.analytics_metadata = Some(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmForgotPassword</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.analytics_metadata = input;
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.user_context_data = Some(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.user_context_data = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmForgotPassword API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmForgotPassword API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmForgotPasswordInput`](crate::input::ConfirmForgotPasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfirmForgotPasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfirmForgotPasswordInput {
                client_id: self.client_id,
                secret_hash: self.secret_hash,
                username: self.username,
                confirmation_code: self.confirmation_code,
                password: self.password,
                analytics_metadata: self.analytics_metadata,
                user_context_data: self.user_context_data,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfirmForgotPasswordInputOperationOutputAlias = crate::operation::ConfirmForgotPassword;
#[doc(hidden)]
pub type ConfirmForgotPasswordInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ConfirmForgotPasswordInput {
    /// Consumes the builder and constructs an Operation<[`ConfirmForgotPassword`](crate::operation::ConfirmForgotPassword)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfirmForgotPassword,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ConfirmForgotPasswordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ConfirmForgotPasswordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ConfirmForgotPasswordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ConfirmForgotPassword",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_confirm_forgot_password(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfirmForgotPassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfirmForgotPassword",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ConfirmForgotPasswordInput`](crate::input::ConfirmForgotPasswordInput)
    pub fn builder() -> crate::input::confirm_forgot_password_input::Builder {
        crate::input::confirm_forgot_password_input::Builder::default()
    }
}

/// See [`ConfirmSignUpInput`](crate::input::ConfirmSignUpInput)
pub mod confirm_sign_up_input {
    /// A builder for [`ConfirmSignUpInput`](crate::input::ConfirmSignUpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) secret_hash: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) confirmation_code: std::option::Option<std::string::String>,
        pub(crate) force_alias_creation: std::option::Option<bool>,
        pub(crate) analytics_metadata: std::option::Option<crate::model::AnalyticsMetadataType>,
        pub(crate) user_context_data: std::option::Option<crate::model::UserContextDataType>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the app client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The ID of the app client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn secret_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_hash = Some(input.into());
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn set_secret_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_hash = input;
            self
        }
        /// <p>The user name of the user whose registration you want to confirm.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user whose registration you want to confirm.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The confirmation code sent by a user's request to confirm registration.</p>
        pub fn confirmation_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.confirmation_code = Some(input.into());
            self
        }
        /// <p>The confirmation code sent by a user's request to confirm registration.</p>
        pub fn set_confirmation_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.confirmation_code = input;
            self
        }
        /// <p>Boolean to be specified to force user confirmation irrespective of existing alias. By default set to <code>False</code>. If this parameter is set to <code>True</code> and the phone number/email used for sign up confirmation already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user being confirmed. If set to <code>False</code>, the API will throw an <b>AliasExistsException</b> error.</p>
        pub fn force_alias_creation(mut self, input: bool) -> Self {
            self.force_alias_creation = Some(input);
            self
        }
        /// <p>Boolean to be specified to force user confirmation irrespective of existing alias. By default set to <code>False</code>. If this parameter is set to <code>True</code> and the phone number/email used for sign up confirmation already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user being confirmed. If set to <code>False</code>, the API will throw an <b>AliasExistsException</b> error.</p>
        pub fn set_force_alias_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.force_alias_creation = input;
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmSignUp</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.analytics_metadata = Some(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmSignUp</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.analytics_metadata = input;
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.user_context_data = Some(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.user_context_data = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmSignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmSignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmSignUpInput`](crate::input::ConfirmSignUpInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfirmSignUpInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfirmSignUpInput {
                client_id: self.client_id,
                secret_hash: self.secret_hash,
                username: self.username,
                confirmation_code: self.confirmation_code,
                force_alias_creation: self.force_alias_creation.unwrap_or_default(),
                analytics_metadata: self.analytics_metadata,
                user_context_data: self.user_context_data,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfirmSignUpInputOperationOutputAlias = crate::operation::ConfirmSignUp;
#[doc(hidden)]
pub type ConfirmSignUpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ConfirmSignUpInput {
    /// Consumes the builder and constructs an Operation<[`ConfirmSignUp`](crate::operation::ConfirmSignUp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfirmSignUp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ConfirmSignUpInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ConfirmSignUpInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ConfirmSignUpInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ConfirmSignUp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_confirm_sign_up(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfirmSignUp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfirmSignUp",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ConfirmSignUpInput`](crate::input::ConfirmSignUpInput)
    pub fn builder() -> crate::input::confirm_sign_up_input::Builder {
        crate::input::confirm_sign_up_input::Builder::default()
    }
}

/// See [`CreateGroupInput`](crate::input::CreateGroupInput)
pub mod create_group_input {
    /// A builder for [`CreateGroupInput`](crate::input::CreateGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) precedence: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the group. Must be unique.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group. Must be unique.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>A string containing the description of the group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A string containing the description of the group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The role Amazon Resource Name (ARN) for the group.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The role Amazon Resource Name (ARN) for the group.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher ornull <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims.</p>
        /// <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn't set in users' tokens.</p>
        /// <p>The default <code>Precedence</code> value is null.</p>
        pub fn precedence(mut self, input: i32) -> Self {
            self.precedence = Some(input);
            self
        }
        /// <p>A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher ornull <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims.</p>
        /// <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn't set in users' tokens.</p>
        /// <p>The default <code>Precedence</code> value is null.</p>
        pub fn set_precedence(mut self, input: std::option::Option<i32>) -> Self {
            self.precedence = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupInput`](crate::input::CreateGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGroupInput {
                group_name: self.group_name,
                user_pool_id: self.user_pool_id,
                description: self.description,
                role_arn: self.role_arn,
                precedence: self.precedence,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGroupInputOperationOutputAlias = crate::operation::CreateGroup;
#[doc(hidden)]
pub type CreateGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateGroup`](crate::operation::CreateGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.CreateGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_group(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGroup",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGroupInput`](crate::input::CreateGroupInput)
    pub fn builder() -> crate::input::create_group_input::Builder {
        crate::input::create_group_input::Builder::default()
    }
}

/// See [`CreateIdentityProviderInput`](crate::input::CreateIdentityProviderInput)
pub mod create_identity_provider_input {
    /// A builder for [`CreateIdentityProviderInput`](crate::input::CreateIdentityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) provider_type: std::option::Option<crate::model::IdentityProviderTypeType>,
        pub(crate) provider_details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) attribute_mapping: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) idp_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The identity provider name.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>The identity provider type.</p>
        pub fn provider_type(mut self, input: crate::model::IdentityProviderTypeType) -> Self {
            self.provider_type = Some(input);
            self
        }
        /// <p>The identity provider type.</p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderTypeType>,
        ) -> Self {
            self.provider_type = input;
            self
        }
        /// Adds a key-value pair to `provider_details`.
        ///
        /// To override the contents of this collection use [`set_provider_details`](Self::set_provider_details).
        ///
        /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type.</p>
        /// <ul>
        /// <li> <p>For Google and Login with Amazon:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For Facebook:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>api_version</p> </li>
        /// </ul> </li>
        /// <li> <p>For Sign in with Apple:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>team_id</p> </li>
        /// <li> <p>key_id</p> </li>
        /// <li> <p>private_key</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For OpenID Connect (OIDC) providers:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>attributes_request_method</p> </li>
        /// <li> <p>oidc_issuer</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>authorize_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>token_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>attributes_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>jwks_uri <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>attributes_url_add_attributes <i>a read-only property that is set automatically</i> </p> </li>
        /// </ul> </li>
        /// <li> <p>For SAML providers:</p>
        /// <ul>
        /// <li> <p>MetadataFile OR MetadataURL</p> </li>
        /// <li> <p>IDPSignout (optional)</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.provider_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.provider_details = Some(hash_map);
            self
        }
        /// <p>The identity provider details. The following list describes the provider detail keys for each identity provider type.</p>
        /// <ul>
        /// <li> <p>For Google and Login with Amazon:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For Facebook:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>api_version</p> </li>
        /// </ul> </li>
        /// <li> <p>For Sign in with Apple:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>team_id</p> </li>
        /// <li> <p>key_id</p> </li>
        /// <li> <p>private_key</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// </ul> </li>
        /// <li> <p>For OpenID Connect (OIDC) providers:</p>
        /// <ul>
        /// <li> <p>client_id</p> </li>
        /// <li> <p>client_secret</p> </li>
        /// <li> <p>attributes_request_method</p> </li>
        /// <li> <p>oidc_issuer</p> </li>
        /// <li> <p>authorize_scopes</p> </li>
        /// <li> <p>authorize_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>token_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>attributes_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>jwks_uri <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li>
        /// <li> <p>attributes_url_add_attributes <i>a read-only property that is set automatically</i> </p> </li>
        /// </ul> </li>
        /// <li> <p>For SAML providers:</p>
        /// <ul>
        /// <li> <p>MetadataFile OR MetadataURL</p> </li>
        /// <li> <p>IDPSignout (optional)</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.provider_details = input;
            self
        }
        /// Adds a key-value pair to `attribute_mapping`.
        ///
        /// To override the contents of this collection use [`set_attribute_mapping`](Self::set_attribute_mapping).
        ///
        /// <p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>
        pub fn attribute_mapping(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attribute_mapping.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attribute_mapping = Some(hash_map);
            self
        }
        /// <p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>
        pub fn set_attribute_mapping(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attribute_mapping = input;
            self
        }
        /// Appends an item to `idp_identifiers`.
        ///
        /// To override the contents of this collection use [`set_idp_identifiers`](Self::set_idp_identifiers).
        ///
        /// <p>A list of identity provider identifiers.</p>
        pub fn idp_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.idp_identifiers.unwrap_or_default();
            v.push(input.into());
            self.idp_identifiers = Some(v);
            self
        }
        /// <p>A list of identity provider identifiers.</p>
        pub fn set_idp_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.idp_identifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIdentityProviderInput`](crate::input::CreateIdentityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIdentityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIdentityProviderInput {
                user_pool_id: self.user_pool_id,
                provider_name: self.provider_name,
                provider_type: self.provider_type,
                provider_details: self.provider_details,
                attribute_mapping: self.attribute_mapping,
                idp_identifiers: self.idp_identifiers,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIdentityProviderInputOperationOutputAlias = crate::operation::CreateIdentityProvider;
#[doc(hidden)]
pub type CreateIdentityProviderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIdentityProviderInput {
    /// Consumes the builder and constructs an Operation<[`CreateIdentityProvider`](crate::operation::CreateIdentityProvider)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIdentityProvider,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIdentityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIdentityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIdentityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.CreateIdentityProvider",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_identity_provider(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIdentityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIdentityProvider",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIdentityProviderInput`](crate::input::CreateIdentityProviderInput)
    pub fn builder() -> crate::input::create_identity_provider_input::Builder {
        crate::input::create_identity_provider_input::Builder::default()
    }
}

/// See [`CreateResourceServerInput`](crate::input::CreateResourceServerInput)
pub mod create_resource_server_input {
    /// A builder for [`CreateResourceServerInput`](crate::input::CreateResourceServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) scopes:
            std::option::Option<std::vec::Vec<crate::model::ResourceServerScopeType>>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>A unique resource server identifier for the resource server. This could be an HTTPS endpoint where the resource server is located, such as <code>https://my-weather-api.example.com</code>.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>A unique resource server identifier for the resource server. This could be an HTTPS endpoint where the resource server is located, such as <code>https://my-weather-api.example.com</code>.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>A friendly name for the resource server.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name for the resource server.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `scopes`.
        ///
        /// To override the contents of this collection use [`set_scopes`](Self::set_scopes).
        ///
        /// <p>A list of scopes. Each scope is a key-value map with the keys <code>name</code> and <code>description</code>.</p>
        pub fn scopes(mut self, input: crate::model::ResourceServerScopeType) -> Self {
            let mut v = self.scopes.unwrap_or_default();
            v.push(input);
            self.scopes = Some(v);
            self
        }
        /// <p>A list of scopes. Each scope is a key-value map with the keys <code>name</code> and <code>description</code>.</p>
        pub fn set_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceServerScopeType>>,
        ) -> Self {
            self.scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceServerInput`](crate::input::CreateResourceServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResourceServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResourceServerInput {
                user_pool_id: self.user_pool_id,
                identifier: self.identifier,
                name: self.name,
                scopes: self.scopes,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResourceServerInputOperationOutputAlias = crate::operation::CreateResourceServer;
#[doc(hidden)]
pub type CreateResourceServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateResourceServerInput {
    /// Consumes the builder and constructs an Operation<[`CreateResourceServer`](crate::operation::CreateResourceServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResourceServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResourceServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResourceServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResourceServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.CreateResourceServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_resource_server(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResourceServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResourceServer",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResourceServerInput`](crate::input::CreateResourceServerInput)
    pub fn builder() -> crate::input::create_resource_server_input::Builder {
        crate::input::create_resource_server_input::Builder::default()
    }
}

/// See [`CreateUserImportJobInput`](crate::input::CreateUserImportJobInput)
pub mod create_user_import_job_input {
    /// A builder for [`CreateUserImportJobInput`](crate::input::CreateUserImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job name for the user import job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The job name for the user import job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The role ARN for the Amazon CloudWatch Logs Logging role for the user import job.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>The role ARN for the Amazon CloudWatch Logs Logging role for the user import job.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserImportJobInput`](crate::input::CreateUserImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserImportJobInput {
                job_name: self.job_name,
                user_pool_id: self.user_pool_id,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserImportJobInputOperationOutputAlias = crate::operation::CreateUserImportJob;
#[doc(hidden)]
pub type CreateUserImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserImportJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateUserImportJob`](crate::operation::CreateUserImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUserImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.CreateUserImportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_user_import_job(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUserImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUserImportJob",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserImportJobInput`](crate::input::CreateUserImportJobInput)
    pub fn builder() -> crate::input::create_user_import_job_input::Builder {
        crate::input::create_user_import_job_input::Builder::default()
    }
}

/// See [`CreateUserPoolInput`](crate::input::CreateUserPoolInput)
pub mod create_user_pool_input {
    /// A builder for [`CreateUserPoolInput`](crate::input::CreateUserPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_name: std::option::Option<std::string::String>,
        pub(crate) policies: std::option::Option<crate::model::UserPoolPolicyType>,
        pub(crate) lambda_config: std::option::Option<crate::model::LambdaConfigType>,
        pub(crate) auto_verified_attributes:
            std::option::Option<std::vec::Vec<crate::model::VerifiedAttributeType>>,
        pub(crate) alias_attributes:
            std::option::Option<std::vec::Vec<crate::model::AliasAttributeType>>,
        pub(crate) username_attributes:
            std::option::Option<std::vec::Vec<crate::model::UsernameAttributeType>>,
        pub(crate) sms_verification_message: std::option::Option<std::string::String>,
        pub(crate) email_verification_message: std::option::Option<std::string::String>,
        pub(crate) email_verification_subject: std::option::Option<std::string::String>,
        pub(crate) verification_message_template:
            std::option::Option<crate::model::VerificationMessageTemplateType>,
        pub(crate) sms_authentication_message: std::option::Option<std::string::String>,
        pub(crate) mfa_configuration: std::option::Option<crate::model::UserPoolMfaType>,
        pub(crate) device_configuration: std::option::Option<crate::model::DeviceConfigurationType>,
        pub(crate) email_configuration: std::option::Option<crate::model::EmailConfigurationType>,
        pub(crate) sms_configuration: std::option::Option<crate::model::SmsConfigurationType>,
        pub(crate) user_pool_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) admin_create_user_config:
            std::option::Option<crate::model::AdminCreateUserConfigType>,
        pub(crate) schema: std::option::Option<std::vec::Vec<crate::model::SchemaAttributeType>>,
        pub(crate) user_pool_add_ons: std::option::Option<crate::model::UserPoolAddOnsType>,
        pub(crate) username_configuration:
            std::option::Option<crate::model::UsernameConfigurationType>,
        pub(crate) account_recovery_setting:
            std::option::Option<crate::model::AccountRecoverySettingType>,
    }
    impl Builder {
        /// <p>A string used to name the user pool.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_name = Some(input.into());
            self
        }
        /// <p>A string used to name the user pool.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_name = input;
            self
        }
        /// <p>The policies associated with the new user pool.</p>
        pub fn policies(mut self, input: crate::model::UserPoolPolicyType) -> Self {
            self.policies = Some(input);
            self
        }
        /// <p>The policies associated with the new user pool.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<crate::model::UserPoolPolicyType>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>The Lambda trigger configuration information for the new user pool.</p> <note>
        /// <p>In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.</p>
        /// <p></p>
        /// <p>For more information on using the Lambda API to add permission, see<a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>. </p>
        /// <p>For adding permission using the CLI, see<a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission </a>.</p>
        /// </note>
        pub fn lambda_config(mut self, input: crate::model::LambdaConfigType) -> Self {
            self.lambda_config = Some(input);
            self
        }
        /// <p>The Lambda trigger configuration information for the new user pool.</p> <note>
        /// <p>In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.</p>
        /// <p></p>
        /// <p>For more information on using the Lambda API to add permission, see<a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>. </p>
        /// <p>For adding permission using the CLI, see<a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission </a>.</p>
        /// </note>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaConfigType>,
        ) -> Self {
            self.lambda_config = input;
            self
        }
        /// Appends an item to `auto_verified_attributes`.
        ///
        /// To override the contents of this collection use [`set_auto_verified_attributes`](Self::set_auto_verified_attributes).
        ///
        /// <p>The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.</p>
        pub fn auto_verified_attributes(
            mut self,
            input: crate::model::VerifiedAttributeType,
        ) -> Self {
            let mut v = self.auto_verified_attributes.unwrap_or_default();
            v.push(input);
            self.auto_verified_attributes = Some(v);
            self
        }
        /// <p>The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.</p>
        pub fn set_auto_verified_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VerifiedAttributeType>>,
        ) -> Self {
            self.auto_verified_attributes = input;
            self
        }
        /// Appends an item to `alias_attributes`.
        ///
        /// To override the contents of this collection use [`set_alias_attributes`](Self::set_alias_attributes).
        ///
        /// <p>Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or <b>preferred_username</b>.</p>
        pub fn alias_attributes(mut self, input: crate::model::AliasAttributeType) -> Self {
            let mut v = self.alias_attributes.unwrap_or_default();
            v.push(input);
            self.alias_attributes = Some(v);
            self
        }
        /// <p>Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or <b>preferred_username</b>.</p>
        pub fn set_alias_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AliasAttributeType>>,
        ) -> Self {
            self.alias_attributes = input;
            self
        }
        /// Appends an item to `username_attributes`.
        ///
        /// To override the contents of this collection use [`set_username_attributes`](Self::set_username_attributes).
        ///
        /// <p>Specifies whether a user can use an email address or phone number as a username when they sign up.</p>
        pub fn username_attributes(mut self, input: crate::model::UsernameAttributeType) -> Self {
            let mut v = self.username_attributes.unwrap_or_default();
            v.push(input);
            self.username_attributes = Some(v);
            self
        }
        /// <p>Specifies whether a user can use an email address or phone number as a username when they sign up.</p>
        pub fn set_username_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsernameAttributeType>>,
        ) -> Self {
            self.username_attributes = input;
            self
        }
        /// <p>A string representing the SMS verification message.</p>
        pub fn sms_verification_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_verification_message = Some(input.into());
            self
        }
        /// <p>A string representing the SMS verification message.</p>
        pub fn set_sms_verification_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sms_verification_message = input;
            self
        }
        /// <p>A string representing the email verification message. EmailVerificationMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn email_verification_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_verification_message = Some(input.into());
            self
        }
        /// <p>A string representing the email verification message. EmailVerificationMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn set_email_verification_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_verification_message = input;
            self
        }
        /// <p>A string representing the email verification subject. EmailVerificationSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn email_verification_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_verification_subject = Some(input.into());
            self
        }
        /// <p>A string representing the email verification subject. EmailVerificationSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>
        pub fn set_email_verification_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_verification_subject = input;
            self
        }
        /// <p>The template for the verification message that the user sees when the app requests permission to access the user's information.</p>
        pub fn verification_message_template(
            mut self,
            input: crate::model::VerificationMessageTemplateType,
        ) -> Self {
            self.verification_message_template = Some(input);
            self
        }
        /// <p>The template for the verification message that the user sees when the app requests permission to access the user's information.</p>
        pub fn set_verification_message_template(
            mut self,
            input: std::option::Option<crate::model::VerificationMessageTemplateType>,
        ) -> Self {
            self.verification_message_template = input;
            self
        }
        /// <p>A string representing the SMS authentication message.</p>
        pub fn sms_authentication_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_authentication_message = Some(input.into());
            self
        }
        /// <p>A string representing the SMS authentication message.</p>
        pub fn set_sms_authentication_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sms_authentication_message = input;
            self
        }
        /// <p>Specifies MFA configuration details.</p>
        pub fn mfa_configuration(mut self, input: crate::model::UserPoolMfaType) -> Self {
            self.mfa_configuration = Some(input);
            self
        }
        /// <p>Specifies MFA configuration details.</p>
        pub fn set_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::UserPoolMfaType>,
        ) -> Self {
            self.mfa_configuration = input;
            self
        }
        /// <p>The device configuration.</p>
        pub fn device_configuration(
            mut self,
            input: crate::model::DeviceConfigurationType,
        ) -> Self {
            self.device_configuration = Some(input);
            self
        }
        /// <p>The device configuration.</p>
        pub fn set_device_configuration(
            mut self,
            input: std::option::Option<crate::model::DeviceConfigurationType>,
        ) -> Self {
            self.device_configuration = input;
            self
        }
        /// <p>The email configuration.</p>
        pub fn email_configuration(mut self, input: crate::model::EmailConfigurationType) -> Self {
            self.email_configuration = Some(input);
            self
        }
        /// <p>The email configuration.</p>
        pub fn set_email_configuration(
            mut self,
            input: std::option::Option<crate::model::EmailConfigurationType>,
        ) -> Self {
            self.email_configuration = input;
            self
        }
        /// <p>The SMS configuration.</p>
        pub fn sms_configuration(mut self, input: crate::model::SmsConfigurationType) -> Self {
            self.sms_configuration = Some(input);
            self
        }
        /// <p>The SMS configuration.</p>
        pub fn set_sms_configuration(
            mut self,
            input: std::option::Option<crate::model::SmsConfigurationType>,
        ) -> Self {
            self.sms_configuration = input;
            self
        }
        /// Adds a key-value pair to `user_pool_tags`.
        ///
        /// To override the contents of this collection use [`set_user_pool_tags`](Self::set_user_pool_tags).
        ///
        /// <p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn user_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.user_pool_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.user_pool_tags = Some(hash_map);
            self
        }
        /// <p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn set_user_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.user_pool_tags = input;
            self
        }
        /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
        pub fn admin_create_user_config(
            mut self,
            input: crate::model::AdminCreateUserConfigType,
        ) -> Self {
            self.admin_create_user_config = Some(input);
            self
        }
        /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
        pub fn set_admin_create_user_config(
            mut self,
            input: std::option::Option<crate::model::AdminCreateUserConfigType>,
        ) -> Self {
            self.admin_create_user_config = input;
            self
        }
        /// Appends an item to `schema`.
        ///
        /// To override the contents of this collection use [`set_schema`](Self::set_schema).
        ///
        /// <p>An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.</p>
        pub fn schema(mut self, input: crate::model::SchemaAttributeType) -> Self {
            let mut v = self.schema.unwrap_or_default();
            v.push(input);
            self.schema = Some(v);
            self
        }
        /// <p>An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.</p>
        pub fn set_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaAttributeType>>,
        ) -> Self {
            self.schema = input;
            self
        }
        /// <p>Enables advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>
        pub fn user_pool_add_ons(mut self, input: crate::model::UserPoolAddOnsType) -> Self {
            self.user_pool_add_ons = Some(input);
            self
        }
        /// <p>Enables advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>
        pub fn set_user_pool_add_ons(
            mut self,
            input: std::option::Option<crate::model::UserPoolAddOnsType>,
        ) -> Self {
            self.user_pool_add_ons = input;
            self
        }
        /// <p>Case sensitivity on the username input for the selected sign-in option. For example, when case sensitivity is set to <code>False</code>, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>
        pub fn username_configuration(
            mut self,
            input: crate::model::UsernameConfigurationType,
        ) -> Self {
            self.username_configuration = Some(input);
            self
        }
        /// <p>Case sensitivity on the username input for the selected sign-in option. For example, when case sensitivity is set to <code>False</code>, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>
        pub fn set_username_configuration(
            mut self,
            input: std::option::Option<crate::model::UsernameConfigurationType>,
        ) -> Self {
            self.username_configuration = input;
            self
        }
        /// <p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>
        pub fn account_recovery_setting(
            mut self,
            input: crate::model::AccountRecoverySettingType,
        ) -> Self {
            self.account_recovery_setting = Some(input);
            self
        }
        /// <p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>
        pub fn set_account_recovery_setting(
            mut self,
            input: std::option::Option<crate::model::AccountRecoverySettingType>,
        ) -> Self {
            self.account_recovery_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserPoolInput`](crate::input::CreateUserPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserPoolInput {
                pool_name: self.pool_name,
                policies: self.policies,
                lambda_config: self.lambda_config,
                auto_verified_attributes: self.auto_verified_attributes,
                alias_attributes: self.alias_attributes,
                username_attributes: self.username_attributes,
                sms_verification_message: self.sms_verification_message,
                email_verification_message: self.email_verification_message,
                email_verification_subject: self.email_verification_subject,
                verification_message_template: self.verification_message_template,
                sms_authentication_message: self.sms_authentication_message,
                mfa_configuration: self.mfa_configuration,
                device_configuration: self.device_configuration,
                email_configuration: self.email_configuration,
                sms_configuration: self.sms_configuration,
                user_pool_tags: self.user_pool_tags,
                admin_create_user_config: self.admin_create_user_config,
                schema: self.schema,
                user_pool_add_ons: self.user_pool_add_ons,
                username_configuration: self.username_configuration,
                account_recovery_setting: self.account_recovery_setting,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserPoolInputOperationOutputAlias = crate::operation::CreateUserPool;
#[doc(hidden)]
pub type CreateUserPoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserPoolInput {
    /// Consumes the builder and constructs an Operation<[`CreateUserPool`](crate::operation::CreateUserPool)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUserPool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserPoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserPoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserPoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.CreateUserPool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_user_pool(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUserPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUserPool",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserPoolInput`](crate::input::CreateUserPoolInput)
    pub fn builder() -> crate::input::create_user_pool_input::Builder {
        crate::input::create_user_pool_input::Builder::default()
    }
}

/// See [`CreateUserPoolClientInput`](crate::input::CreateUserPoolClientInput)
pub mod create_user_pool_client_input {
    /// A builder for [`CreateUserPoolClientInput`](crate::input::CreateUserPoolClientInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_name: std::option::Option<std::string::String>,
        pub(crate) generate_secret: std::option::Option<bool>,
        pub(crate) refresh_token_validity: std::option::Option<i32>,
        pub(crate) access_token_validity: std::option::Option<i32>,
        pub(crate) id_token_validity: std::option::Option<i32>,
        pub(crate) token_validity_units: std::option::Option<crate::model::TokenValidityUnitsType>,
        pub(crate) read_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) write_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) explicit_auth_flows:
            std::option::Option<std::vec::Vec<crate::model::ExplicitAuthFlowsType>>,
        pub(crate) supported_identity_providers:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) callback_ur_ls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) logout_ur_ls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_redirect_uri: std::option::Option<std::string::String>,
        pub(crate) allowed_o_auth_flows:
            std::option::Option<std::vec::Vec<crate::model::OAuthFlowType>>,
        pub(crate) allowed_o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) allowed_o_auth_flows_user_pool_client: std::option::Option<bool>,
        pub(crate) analytics_configuration:
            std::option::Option<crate::model::AnalyticsConfigurationType>,
        pub(crate) prevent_user_existence_errors:
            std::option::Option<crate::model::PreventUserExistenceErrorTypes>,
        pub(crate) enable_token_revocation: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to create a user pool client.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to create a user pool client.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The client name for the user pool client you would like to create.</p>
        pub fn client_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_name = Some(input.into());
            self
        }
        /// <p>The client name for the user pool client you would like to create.</p>
        pub fn set_client_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_name = input;
            self
        }
        /// <p>Boolean to specify whether you want to generate a secret for the user pool client being created.</p>
        pub fn generate_secret(mut self, input: bool) -> Self {
            self.generate_secret = Some(input);
            self
        }
        /// <p>Boolean to specify whether you want to generate a secret for the user pool client being created.</p>
        pub fn set_generate_secret(mut self, input: std::option::Option<bool>) -> Self {
            self.generate_secret = input;
            self
        }
        /// <p>The time limit, in days, after which the refresh token is no longer valid and can't be used.</p>
        pub fn refresh_token_validity(mut self, input: i32) -> Self {
            self.refresh_token_validity = Some(input);
            self
        }
        /// <p>The time limit, in days, after which the refresh token is no longer valid and can't be used.</p>
        pub fn set_refresh_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.refresh_token_validity = input;
            self
        }
        /// <p>The time limit, between 5 minutes and 1 day, after which the access token is no longer valid and can't be used. If you supply a TokenValidityUnits value, you will override the default time unit.</p>
        pub fn access_token_validity(mut self, input: i32) -> Self {
            self.access_token_validity = Some(input);
            self
        }
        /// <p>The time limit, between 5 minutes and 1 day, after which the access token is no longer valid and can't be used. If you supply a TokenValidityUnits value, you will override the default time unit.</p>
        pub fn set_access_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.access_token_validity = input;
            self
        }
        /// <p>The time limit, between 5 minutes and 1 day, after which the access token is no longer valid and can't be used. If you supply a TokenValidityUnits value, you will override the default time unit.</p>
        pub fn id_token_validity(mut self, input: i32) -> Self {
            self.id_token_validity = Some(input);
            self
        }
        /// <p>The time limit, between 5 minutes and 1 day, after which the access token is no longer valid and can't be used. If you supply a TokenValidityUnits value, you will override the default time unit.</p>
        pub fn set_id_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.id_token_validity = input;
            self
        }
        /// <p>The units in which the validity times are represented. Default for RefreshToken is days, and default for ID and access tokens are hours.</p>
        pub fn token_validity_units(mut self, input: crate::model::TokenValidityUnitsType) -> Self {
            self.token_validity_units = Some(input);
            self
        }
        /// <p>The units in which the validity times are represented. Default for RefreshToken is days, and default for ID and access tokens are hours.</p>
        pub fn set_token_validity_units(
            mut self,
            input: std::option::Option<crate::model::TokenValidityUnitsType>,
        ) -> Self {
            self.token_validity_units = input;
            self
        }
        /// Appends an item to `read_attributes`.
        ///
        /// To override the contents of this collection use [`set_read_attributes`](Self::set_read_attributes).
        ///
        /// <p>The read attributes.</p>
        pub fn read_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.read_attributes.unwrap_or_default();
            v.push(input.into());
            self.read_attributes = Some(v);
            self
        }
        /// <p>The read attributes.</p>
        pub fn set_read_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.read_attributes = input;
            self
        }
        /// Appends an item to `write_attributes`.
        ///
        /// To override the contents of this collection use [`set_write_attributes`](Self::set_write_attributes).
        ///
        /// <p>The user pool attributes that the app client can write to.</p>
        /// <p>If your app client allows users to sign in through an identity provider, this array must include all attributes that are mapped to identity provider attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If your app client lacks write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>
        pub fn write_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.write_attributes.unwrap_or_default();
            v.push(input.into());
            self.write_attributes = Some(v);
            self
        }
        /// <p>The user pool attributes that the app client can write to.</p>
        /// <p>If your app client allows users to sign in through an identity provider, this array must include all attributes that are mapped to identity provider attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If your app client lacks write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>
        pub fn set_write_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.write_attributes = input;
            self
        }
        /// Appends an item to `explicit_auth_flows`.
        ///
        /// To override the contents of this collection use [`set_explicit_auth_flows`](Self::set_explicit_auth_flows).
        ///
        /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are no longer supported, in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix must be used only along with the <code>ALLOW_</code> prefix.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
        /// </ul>
        pub fn explicit_auth_flows(mut self, input: crate::model::ExplicitAuthFlowsType) -> Self {
            let mut v = self.explicit_auth_flows.unwrap_or_default();
            v.push(input);
            self.explicit_auth_flows = Some(v);
            self
        }
        /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are no longer supported, in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix must be used only along with the <code>ALLOW_</code> prefix.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
        /// </ul>
        pub fn set_explicit_auth_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExplicitAuthFlowsType>>,
        ) -> Self {
            self.explicit_auth_flows = input;
            self
        }
        /// Appends an item to `supported_identity_providers`.
        ///
        /// To override the contents of this collection use [`set_supported_identity_providers`](Self::set_supported_identity_providers).
        ///
        /// <p>A list of provider names for the identity providers that are supported on this client. The following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code> and <code>LoginWithAmazon</code>.</p>
        pub fn supported_identity_providers(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.supported_identity_providers.unwrap_or_default();
            v.push(input.into());
            self.supported_identity_providers = Some(v);
            self
        }
        /// <p>A list of provider names for the identity providers that are supported on this client. The following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code> and <code>LoginWithAmazon</code>.</p>
        pub fn set_supported_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_identity_providers = input;
            self
        }
        /// Appends an item to `callback_ur_ls`.
        ///
        /// To override the contents of this collection use [`set_callback_ur_ls`](Self::set_callback_ur_ls).
        ///
        /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn callback_ur_ls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.callback_ur_ls.unwrap_or_default();
            v.push(input.into());
            self.callback_ur_ls = Some(v);
            self
        }
        /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn set_callback_ur_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.callback_ur_ls = input;
            self
        }
        /// Appends an item to `logout_ur_ls`.
        ///
        /// To override the contents of this collection use [`set_logout_ur_ls`](Self::set_logout_ur_ls).
        ///
        /// <p>A list of allowed logout URLs for the identity providers.</p>
        pub fn logout_ur_ls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.logout_ur_ls.unwrap_or_default();
            v.push(input.into());
            self.logout_ur_ls = Some(v);
            self
        }
        /// <p>A list of allowed logout URLs for the identity providers.</p>
        pub fn set_logout_ur_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.logout_ur_ls = input;
            self
        }
        /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn default_redirect_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_redirect_uri = Some(input.into());
            self
        }
        /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as myapp://example are also supported.</p>
        pub fn set_default_redirect_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_redirect_uri = input;
            self
        }
        /// Appends an item to `allowed_o_auth_flows`.
        ///
        /// To override the contents of this collection use [`set_allowed_o_auth_flows`](Self::set_allowed_o_auth_flows).
        ///
        /// <p>The allowed OAuth flows.</p>
        /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
        /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
        /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
        pub fn allowed_o_auth_flows(mut self, input: crate::model::OAuthFlowType) -> Self {
            let mut v = self.allowed_o_auth_flows.unwrap_or_default();
            v.push(input);
            self.allowed_o_auth_flows = Some(v);
            self
        }
        /// <p>The allowed OAuth flows.</p>
        /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
        /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
        /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
        pub fn set_allowed_o_auth_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OAuthFlowType>>,
        ) -> Self {
            self.allowed_o_auth_flows = input;
            self
        }
        /// Appends an item to `allowed_o_auth_scopes`.
        ///
        /// To override the contents of this collection use [`set_allowed_o_auth_scopes`](Self::set_allowed_o_auth_scopes).
        ///
        /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
        pub fn allowed_o_auth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_o_auth_scopes.unwrap_or_default();
            v.push(input.into());
            self.allowed_o_auth_scopes = Some(v);
            self
        }
        /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
        pub fn set_allowed_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_o_auth_scopes = input;
            self
        }
        /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.</p>
        pub fn allowed_o_auth_flows_user_pool_client(mut self, input: bool) -> Self {
            self.allowed_o_auth_flows_user_pool_client = Some(input);
            self
        }
        /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.</p>
        pub fn set_allowed_o_auth_flows_user_pool_client(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allowed_o_auth_flows_user_pool_client = input;
            self
        }
        /// <p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note>
        /// <p>In Amazon Web Services Regions where isn't available, User Pools only supports sending events to Amazon Pinpoint projects in Amazon Web Services Region us-east-1. In Regions where is available, User Pools will support sending events to Amazon Pinpoint projects within that same Region. </p>
        /// </note>
        pub fn analytics_configuration(
            mut self,
            input: crate::model::AnalyticsConfigurationType,
        ) -> Self {
            self.analytics_configuration = Some(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note>
        /// <p>In Amazon Web Services Regions where isn't available, User Pools only supports sending events to Amazon Pinpoint projects in Amazon Web Services Region us-east-1. In Regions where is available, User Pools will support sending events to Amazon Pinpoint projects within that same Region. </p>
        /// </note>
        pub fn set_analytics_configuration(
            mut self,
            input: std::option::Option<crate::model::AnalyticsConfigurationType>,
        ) -> Self {
            self.analytics_configuration = input;
            self
        }
        /// <p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
        /// <li> <p> <code>LEGACY</code> - This represents the early behavior of Amazon Cognito where user existence related errors aren't prevented.</p> </li>
        /// </ul>
        pub fn prevent_user_existence_errors(
            mut self,
            input: crate::model::PreventUserExistenceErrorTypes,
        ) -> Self {
            self.prevent_user_existence_errors = Some(input);
            self
        }
        /// <p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
        /// <li> <p> <code>LEGACY</code> - This represents the early behavior of Amazon Cognito where user existence related errors aren't prevented.</p> </li>
        /// </ul>
        pub fn set_prevent_user_existence_errors(
            mut self,
            input: std::option::Option<crate::model::PreventUserExistenceErrorTypes>,
        ) -> Self {
            self.prevent_user_existence_errors = input;
            self
        }
        /// <p>Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
        /// <p>If you don't include this parameter, token revocation is automatically activated for the new user pool client.</p>
        pub fn enable_token_revocation(mut self, input: bool) -> Self {
            self.enable_token_revocation = Some(input);
            self
        }
        /// <p>Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
        /// <p>If you don't include this parameter, token revocation is automatically activated for the new user pool client.</p>
        pub fn set_enable_token_revocation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_token_revocation = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserPoolClientInput`](crate::input::CreateUserPoolClientInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserPoolClientInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserPoolClientInput {
                user_pool_id: self.user_pool_id,
                client_name: self.client_name,
                generate_secret: self.generate_secret.unwrap_or_default(),
                refresh_token_validity: self.refresh_token_validity.unwrap_or_default(),
                access_token_validity: self.access_token_validity,
                id_token_validity: self.id_token_validity,
                token_validity_units: self.token_validity_units,
                read_attributes: self.read_attributes,
                write_attributes: self.write_attributes,
                explicit_auth_flows: self.explicit_auth_flows,
                supported_identity_providers: self.supported_identity_providers,
                callback_ur_ls: self.callback_ur_ls,
                logout_ur_ls: self.logout_ur_ls,
                default_redirect_uri: self.default_redirect_uri,
                allowed_o_auth_flows: self.allowed_o_auth_flows,
                allowed_o_auth_scopes: self.allowed_o_auth_scopes,
                allowed_o_auth_flows_user_pool_client: self
                    .allowed_o_auth_flows_user_pool_client
                    .unwrap_or_default(),
                analytics_configuration: self.analytics_configuration,
                prevent_user_existence_errors: self.prevent_user_existence_errors,
                enable_token_revocation: self.enable_token_revocation,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserPoolClientInputOperationOutputAlias = crate::operation::CreateUserPoolClient;
#[doc(hidden)]
pub type CreateUserPoolClientInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserPoolClientInput {
    /// Consumes the builder and constructs an Operation<[`CreateUserPoolClient`](crate::operation::CreateUserPoolClient)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUserPoolClient,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserPoolClientInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserPoolClientInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserPoolClientInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.CreateUserPoolClient",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_user_pool_client(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUserPoolClient::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUserPoolClient",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserPoolClientInput`](crate::input::CreateUserPoolClientInput)
    pub fn builder() -> crate::input::create_user_pool_client_input::Builder {
        crate::input::create_user_pool_client_input::Builder::default()
    }
}

/// See [`CreateUserPoolDomainInput`](crate::input::CreateUserPoolDomainInput)
pub mod create_user_pool_domain_input {
    /// A builder for [`CreateUserPoolDomainInput`](crate::input::CreateUserPoolDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) custom_domain_config: std::option::Option<crate::model::CustomDomainConfigType>,
    }
    impl Builder {
        /// <p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>
        /// <p>Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead.</p>
        /// <p>For more information about the hosted domain and custom domains, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html">Configuring a User Pool Domain</a>.</p>
        pub fn custom_domain_config(mut self, input: crate::model::CustomDomainConfigType) -> Self {
            self.custom_domain_config = Some(input);
            self
        }
        /// <p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>
        /// <p>Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead.</p>
        /// <p>For more information about the hosted domain and custom domains, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html">Configuring a User Pool Domain</a>.</p>
        pub fn set_custom_domain_config(
            mut self,
            input: std::option::Option<crate::model::CustomDomainConfigType>,
        ) -> Self {
            self.custom_domain_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserPoolDomainInput`](crate::input::CreateUserPoolDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserPoolDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserPoolDomainInput {
                domain: self.domain,
                user_pool_id: self.user_pool_id,
                custom_domain_config: self.custom_domain_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserPoolDomainInputOperationOutputAlias = crate::operation::CreateUserPoolDomain;
#[doc(hidden)]
pub type CreateUserPoolDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserPoolDomainInput {
    /// Consumes the builder and constructs an Operation<[`CreateUserPoolDomain`](crate::operation::CreateUserPoolDomain)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUserPoolDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserPoolDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserPoolDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserPoolDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.CreateUserPoolDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_user_pool_domain(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUserPoolDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUserPoolDomain",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserPoolDomainInput`](crate::input::CreateUserPoolDomainInput)
    pub fn builder() -> crate::input::create_user_pool_domain_input::Builder {
        crate::input::create_user_pool_domain_input::Builder::default()
    }
}

/// See [`DeleteGroupInput`](crate::input::DeleteGroupInput)
pub mod delete_group_input {
    /// A builder for [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupInput`](crate::input::DeleteGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGroupInput {
                group_name: self.group_name,
                user_pool_id: self.user_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGroupInputOperationOutputAlias = crate::operation::DeleteGroup;
#[doc(hidden)]
pub type DeleteGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGroup`](crate::operation::DeleteGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DeleteGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_group(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGroup",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    pub fn builder() -> crate::input::delete_group_input::Builder {
        crate::input::delete_group_input::Builder::default()
    }
}

/// See [`DeleteIdentityProviderInput`](crate::input::DeleteIdentityProviderInput)
pub mod delete_identity_provider_input {
    /// A builder for [`DeleteIdentityProviderInput`](crate::input::DeleteIdentityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The identity provider name.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIdentityProviderInput`](crate::input::DeleteIdentityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIdentityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIdentityProviderInput {
                user_pool_id: self.user_pool_id,
                provider_name: self.provider_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIdentityProviderInputOperationOutputAlias = crate::operation::DeleteIdentityProvider;
#[doc(hidden)]
pub type DeleteIdentityProviderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteIdentityProviderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIdentityProvider`](crate::operation::DeleteIdentityProvider)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIdentityProvider,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIdentityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIdentityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIdentityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DeleteIdentityProvider",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_identity_provider(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIdentityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIdentityProvider",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIdentityProviderInput`](crate::input::DeleteIdentityProviderInput)
    pub fn builder() -> crate::input::delete_identity_provider_input::Builder {
        crate::input::delete_identity_provider_input::Builder::default()
    }
}

/// See [`DeleteResourceServerInput`](crate::input::DeleteResourceServerInput)
pub mod delete_resource_server_input {
    /// A builder for [`DeleteResourceServerInput`](crate::input::DeleteResourceServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool that hosts the resource server.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that hosts the resource server.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The identifier for the resource server.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the resource server.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourceServerInput`](crate::input::DeleteResourceServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourceServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourceServerInput {
                user_pool_id: self.user_pool_id,
                identifier: self.identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourceServerInputOperationOutputAlias = crate::operation::DeleteResourceServer;
#[doc(hidden)]
pub type DeleteResourceServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteResourceServerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourceServer`](crate::operation::DeleteResourceServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourceServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourceServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourceServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourceServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DeleteResourceServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_resource_server(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourceServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourceServer",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourceServerInput`](crate::input::DeleteResourceServerInput)
    pub fn builder() -> crate::input::delete_resource_server_input::Builder {
        crate::input::delete_resource_server_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access token from a request to delete a user.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token from a request to delete a user.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                access_token: self.access_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DeleteUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DeleteUserAttributesInput`](crate::input::DeleteUserAttributesInput)
pub mod delete_user_attributes_input {
    /// A builder for [`DeleteUserAttributesInput`](crate::input::DeleteUserAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) access_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `user_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_user_attribute_names`](Self::set_user_attribute_names).
        ///
        /// <p>An array of strings representing the user attribute names you want to delete.</p>
        /// <p>For custom attributes, you must prependattach the <code>custom:</code> prefix to the front of the attribute name.</p>
        pub fn user_attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_attribute_names.unwrap_or_default();
            v.push(input.into());
            self.user_attribute_names = Some(v);
            self
        }
        /// <p>An array of strings representing the user attribute names you want to delete.</p>
        /// <p>For custom attributes, you must prependattach the <code>custom:</code> prefix to the front of the attribute name.</p>
        pub fn set_user_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_attribute_names = input;
            self
        }
        /// <p>The access token used in the request to delete user attributes.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token used in the request to delete user attributes.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserAttributesInput`](crate::input::DeleteUserAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserAttributesInput {
                user_attribute_names: self.user_attribute_names,
                access_token: self.access_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserAttributesInputOperationOutputAlias = crate::operation::DeleteUserAttributes;
#[doc(hidden)]
pub type DeleteUserAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserAttributes`](crate::operation::DeleteUserAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DeleteUserAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_user_attributes(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserAttributes",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserAttributesInput`](crate::input::DeleteUserAttributesInput)
    pub fn builder() -> crate::input::delete_user_attributes_input::Builder {
        crate::input::delete_user_attributes_input::Builder::default()
    }
}

/// See [`DeleteUserPoolInput`](crate::input::DeleteUserPoolInput)
pub mod delete_user_pool_input {
    /// A builder for [`DeleteUserPoolInput`](crate::input::DeleteUserPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool you want to delete.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool you want to delete.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserPoolInput`](crate::input::DeleteUserPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserPoolInput {
                user_pool_id: self.user_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserPoolInputOperationOutputAlias = crate::operation::DeleteUserPool;
#[doc(hidden)]
pub type DeleteUserPoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserPoolInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserPool`](crate::operation::DeleteUserPool)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserPool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserPoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserPoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserPoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DeleteUserPool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_user_pool(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserPool",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserPoolInput`](crate::input::DeleteUserPoolInput)
    pub fn builder() -> crate::input::delete_user_pool_input::Builder {
        crate::input::delete_user_pool_input::Builder::default()
    }
}

/// See [`DeleteUserPoolClientInput`](crate::input::DeleteUserPoolClientInput)
pub mod delete_user_pool_client_input {
    /// A builder for [`DeleteUserPoolClientInput`](crate::input::DeleteUserPoolClientInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to delete the client.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to delete the client.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserPoolClientInput`](crate::input::DeleteUserPoolClientInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserPoolClientInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserPoolClientInput {
                user_pool_id: self.user_pool_id,
                client_id: self.client_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserPoolClientInputOperationOutputAlias = crate::operation::DeleteUserPoolClient;
#[doc(hidden)]
pub type DeleteUserPoolClientInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserPoolClientInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserPoolClient`](crate::operation::DeleteUserPoolClient)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserPoolClient,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserPoolClientInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserPoolClientInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserPoolClientInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DeleteUserPoolClient",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_user_pool_client(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserPoolClient::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserPoolClient",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserPoolClientInput`](crate::input::DeleteUserPoolClientInput)
    pub fn builder() -> crate::input::delete_user_pool_client_input::Builder {
        crate::input::delete_user_pool_client_input::Builder::default()
    }
}

/// See [`DeleteUserPoolDomainInput`](crate::input::DeleteUserPoolDomainInput)
pub mod delete_user_pool_domain_input {
    /// A builder for [`DeleteUserPoolDomainInput`](crate::input::DeleteUserPoolDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserPoolDomainInput`](crate::input::DeleteUserPoolDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserPoolDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserPoolDomainInput {
                domain: self.domain,
                user_pool_id: self.user_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserPoolDomainInputOperationOutputAlias = crate::operation::DeleteUserPoolDomain;
#[doc(hidden)]
pub type DeleteUserPoolDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserPoolDomainInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserPoolDomain`](crate::operation::DeleteUserPoolDomain)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserPoolDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserPoolDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserPoolDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserPoolDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DeleteUserPoolDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_user_pool_domain(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserPoolDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserPoolDomain",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserPoolDomainInput`](crate::input::DeleteUserPoolDomainInput)
    pub fn builder() -> crate::input::delete_user_pool_domain_input::Builder {
        crate::input::delete_user_pool_domain_input::Builder::default()
    }
}

/// See [`DescribeIdentityProviderInput`](crate::input::DescribeIdentityProviderInput)
pub mod describe_identity_provider_input {
    /// A builder for [`DescribeIdentityProviderInput`](crate::input::DescribeIdentityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The identity provider name.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIdentityProviderInput`](crate::input::DescribeIdentityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIdentityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIdentityProviderInput {
                user_pool_id: self.user_pool_id,
                provider_name: self.provider_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeIdentityProviderInputOperationOutputAlias =
    crate::operation::DescribeIdentityProvider;
#[doc(hidden)]
pub type DescribeIdentityProviderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeIdentityProviderInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIdentityProvider`](crate::operation::DescribeIdentityProvider)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIdentityProvider,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeIdentityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeIdentityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeIdentityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DescribeIdentityProvider",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_identity_provider(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIdentityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIdentityProvider",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeIdentityProviderInput`](crate::input::DescribeIdentityProviderInput)
    pub fn builder() -> crate::input::describe_identity_provider_input::Builder {
        crate::input::describe_identity_provider_input::Builder::default()
    }
}

/// See [`DescribeResourceServerInput`](crate::input::DescribeResourceServerInput)
pub mod describe_resource_server_input {
    /// A builder for [`DescribeResourceServerInput`](crate::input::DescribeResourceServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool that hosts the resource server.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that hosts the resource server.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The identifier for the resource server</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the resource server</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourceServerInput`](crate::input::DescribeResourceServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeResourceServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeResourceServerInput {
                user_pool_id: self.user_pool_id,
                identifier: self.identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeResourceServerInputOperationOutputAlias = crate::operation::DescribeResourceServer;
#[doc(hidden)]
pub type DescribeResourceServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeResourceServerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeResourceServer`](crate::operation::DescribeResourceServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeResourceServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeResourceServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeResourceServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeResourceServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DescribeResourceServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_resource_server(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeResourceServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeResourceServer",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeResourceServerInput`](crate::input::DescribeResourceServerInput)
    pub fn builder() -> crate::input::describe_resource_server_input::Builder {
        crate::input::describe_resource_server_input::Builder::default()
    }
}

/// See [`DescribeRiskConfigurationInput`](crate::input::DescribeRiskConfigurationInput)
pub mod describe_risk_configuration_input {
    /// A builder for [`DescribeRiskConfigurationInput`](crate::input::DescribeRiskConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The app client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The app client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRiskConfigurationInput`](crate::input::DescribeRiskConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRiskConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRiskConfigurationInput {
                user_pool_id: self.user_pool_id,
                client_id: self.client_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRiskConfigurationInputOperationOutputAlias =
    crate::operation::DescribeRiskConfiguration;
#[doc(hidden)]
pub type DescribeRiskConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRiskConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRiskConfiguration`](crate::operation::DescribeRiskConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRiskConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRiskConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRiskConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRiskConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DescribeRiskConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_risk_configuration(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRiskConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRiskConfiguration",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRiskConfigurationInput`](crate::input::DescribeRiskConfigurationInput)
    pub fn builder() -> crate::input::describe_risk_configuration_input::Builder {
        crate::input::describe_risk_configuration_input::Builder::default()
    }
}

/// See [`DescribeUserImportJobInput`](crate::input::DescribeUserImportJobInput)
pub mod describe_user_import_job_input {
    /// A builder for [`DescribeUserImportJobInput`](crate::input::DescribeUserImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserImportJobInput`](crate::input::DescribeUserImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserImportJobInput {
                user_pool_id: self.user_pool_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserImportJobInputOperationOutputAlias = crate::operation::DescribeUserImportJob;
#[doc(hidden)]
pub type DescribeUserImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserImportJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUserImportJob`](crate::operation::DescribeUserImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUserImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DescribeUserImportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_user_import_job(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUserImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUserImportJob",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserImportJobInput`](crate::input::DescribeUserImportJobInput)
    pub fn builder() -> crate::input::describe_user_import_job_input::Builder {
        crate::input::describe_user_import_job_input::Builder::default()
    }
}

/// See [`DescribeUserPoolInput`](crate::input::DescribeUserPoolInput)
pub mod describe_user_pool_input {
    /// A builder for [`DescribeUserPoolInput`](crate::input::DescribeUserPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool you want to describe.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool you want to describe.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserPoolInput`](crate::input::DescribeUserPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserPoolInput {
                user_pool_id: self.user_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserPoolInputOperationOutputAlias = crate::operation::DescribeUserPool;
#[doc(hidden)]
pub type DescribeUserPoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserPoolInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUserPool`](crate::operation::DescribeUserPool)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUserPool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserPoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserPoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserPoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DescribeUserPool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_user_pool(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUserPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUserPool",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserPoolInput`](crate::input::DescribeUserPoolInput)
    pub fn builder() -> crate::input::describe_user_pool_input::Builder {
        crate::input::describe_user_pool_input::Builder::default()
    }
}

/// See [`DescribeUserPoolClientInput`](crate::input::DescribeUserPoolClientInput)
pub mod describe_user_pool_client_input {
    /// A builder for [`DescribeUserPoolClientInput`](crate::input::DescribeUserPoolClientInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool you want to describe.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool you want to describe.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The app client ID of the app associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserPoolClientInput`](crate::input::DescribeUserPoolClientInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserPoolClientInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserPoolClientInput {
                user_pool_id: self.user_pool_id,
                client_id: self.client_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserPoolClientInputOperationOutputAlias = crate::operation::DescribeUserPoolClient;
#[doc(hidden)]
pub type DescribeUserPoolClientInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserPoolClientInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUserPoolClient`](crate::operation::DescribeUserPoolClient)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUserPoolClient,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserPoolClientInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserPoolClientInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserPoolClientInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DescribeUserPoolClient",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_user_pool_client(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUserPoolClient::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUserPoolClient",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserPoolClientInput`](crate::input::DescribeUserPoolClientInput)
    pub fn builder() -> crate::input::describe_user_pool_client_input::Builder {
        crate::input::describe_user_pool_client_input::Builder::default()
    }
}

/// See [`DescribeUserPoolDomainInput`](crate::input::DescribeUserPoolDomainInput)
pub mod describe_user_pool_domain_input {
    /// A builder for [`DescribeUserPoolDomainInput`](crate::input::DescribeUserPoolDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserPoolDomainInput`](crate::input::DescribeUserPoolDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserPoolDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserPoolDomainInput {
                domain: self.domain,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserPoolDomainInputOperationOutputAlias = crate::operation::DescribeUserPoolDomain;
#[doc(hidden)]
pub type DescribeUserPoolDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserPoolDomainInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUserPoolDomain`](crate::operation::DescribeUserPoolDomain)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUserPoolDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserPoolDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserPoolDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserPoolDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.DescribeUserPoolDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_user_pool_domain(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUserPoolDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUserPoolDomain",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserPoolDomainInput`](crate::input::DescribeUserPoolDomainInput)
    pub fn builder() -> crate::input::describe_user_pool_domain_input::Builder {
        crate::input::describe_user_pool_domain_input::Builder::default()
    }
}

/// See [`ForgetDeviceInput`](crate::input::ForgetDeviceInput)
pub mod forget_device_input {
    /// A builder for [`ForgetDeviceInput`](crate::input::ForgetDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) device_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access token for the forgotten device request.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token for the forgotten device request.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_key = Some(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_key = input;
            self
        }
        /// Consumes the builder and constructs a [`ForgetDeviceInput`](crate::input::ForgetDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ForgetDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ForgetDeviceInput {
                access_token: self.access_token,
                device_key: self.device_key,
            })
        }
    }
}
#[doc(hidden)]
pub type ForgetDeviceInputOperationOutputAlias = crate::operation::ForgetDevice;
#[doc(hidden)]
pub type ForgetDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ForgetDeviceInput {
    /// Consumes the builder and constructs an Operation<[`ForgetDevice`](crate::operation::ForgetDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ForgetDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ForgetDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ForgetDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ForgetDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ForgetDevice",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_forget_device(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ForgetDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ForgetDevice",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ForgetDeviceInput`](crate::input::ForgetDeviceInput)
    pub fn builder() -> crate::input::forget_device_input::Builder {
        crate::input::forget_device_input::Builder::default()
    }
}

/// See [`ForgotPasswordInput`](crate::input::ForgotPasswordInput)
pub mod forgot_password_input {
    /// A builder for [`ForgotPasswordInput`](crate::input::ForgotPasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) secret_hash: std::option::Option<std::string::String>,
        pub(crate) user_context_data: std::option::Option<crate::model::UserContextDataType>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) analytics_metadata: std::option::Option<crate::model::AnalyticsMetadataType>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn secret_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_hash = Some(input.into());
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn set_secret_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_hash = input;
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.user_context_data = Some(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.user_context_data = input;
            self
        }
        /// <p>The user name of the user for whom you want to enter a code to reset a forgotten password.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user for whom you want to enter a code to reset a forgotten password.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ForgotPassword</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.analytics_metadata = Some(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ForgotPassword</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.analytics_metadata = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ForgotPassword API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>user migration</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ForgotPassword API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>user migration</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`ForgotPasswordInput`](crate::input::ForgotPasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ForgotPasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ForgotPasswordInput {
                client_id: self.client_id,
                secret_hash: self.secret_hash,
                user_context_data: self.user_context_data,
                username: self.username,
                analytics_metadata: self.analytics_metadata,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type ForgotPasswordInputOperationOutputAlias = crate::operation::ForgotPassword;
#[doc(hidden)]
pub type ForgotPasswordInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ForgotPasswordInput {
    /// Consumes the builder and constructs an Operation<[`ForgotPassword`](crate::operation::ForgotPassword)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ForgotPassword,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ForgotPasswordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ForgotPasswordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ForgotPasswordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ForgotPassword",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_forgot_password(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ForgotPassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ForgotPassword",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ForgotPasswordInput`](crate::input::ForgotPasswordInput)
    pub fn builder() -> crate::input::forgot_password_input::Builder {
        crate::input::forgot_password_input::Builder::default()
    }
}

/// See [`GetCsvHeaderInput`](crate::input::GetCsvHeaderInput)
pub mod get_csv_header_input {
    /// A builder for [`GetCsvHeaderInput`](crate::input::GetCsvHeaderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool that the users are to be imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are to be imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCsvHeaderInput`](crate::input::GetCsvHeaderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCsvHeaderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCsvHeaderInput {
                user_pool_id: self.user_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCsvHeaderInputOperationOutputAlias = crate::operation::GetCSVHeader;
#[doc(hidden)]
pub type GetCsvHeaderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCsvHeaderInput {
    /// Consumes the builder and constructs an Operation<[`GetCSVHeader`](crate::operation::GetCSVHeader)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCSVHeader,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCsvHeaderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCsvHeaderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCsvHeaderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.GetCSVHeader",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_csv_header(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCSVHeader::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCSVHeader",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCsvHeaderInput`](crate::input::GetCsvHeaderInput)
    pub fn builder() -> crate::input::get_csv_header_input::Builder {
        crate::input::get_csv_header_input::Builder::default()
    }
}

/// See [`GetDeviceInput`](crate::input::GetDeviceInput)
pub mod get_device_input {
    /// A builder for [`GetDeviceInput`](crate::input::GetDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_key: std::option::Option<std::string::String>,
        pub(crate) access_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_key = Some(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_key = input;
            self
        }
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceInput`](crate::input::GetDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetDeviceInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetDeviceInput {
                device_key: self.device_key,
                access_token: self.access_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeviceInputOperationOutputAlias = crate::operation::GetDevice;
#[doc(hidden)]
pub type GetDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeviceInput {
    /// Consumes the builder and constructs an Operation<[`GetDevice`](crate::operation::GetDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.GetDevice",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_device(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetDevice::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetDevice",
                    "cognitoidentityprovider",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeviceInput`](crate::input::GetDeviceInput)
    pub fn builder() -> crate::input::get_device_input::Builder {
        crate::input::get_device_input::Builder::default()
    }
}

/// See [`GetGroupInput`](crate::input::GetGroupInput)
pub mod get_group_input {
    /// A builder for [`GetGroupInput`](crate::input::GetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupInput`](crate::input::GetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetGroupInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetGroupInput {
                group_name: self.group_name,
                user_pool_id: self.user_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGroupInputOperationOutputAlias = crate::operation::GetGroup;
#[doc(hidden)]
pub type GetGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetGroup`](crate::operation::GetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.GetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_group(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetGroup::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetGroup",
                    "cognitoidentityprovider",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupInput`](crate::input::GetGroupInput)
    pub fn builder() -> crate::input::get_group_input::Builder {
        crate::input::get_group_input::Builder::default()
    }
}

/// See [`GetIdentityProviderByIdentifierInput`](crate::input::GetIdentityProviderByIdentifierInput)
pub mod get_identity_provider_by_identifier_input {
    /// A builder for [`GetIdentityProviderByIdentifierInput`](crate::input::GetIdentityProviderByIdentifierInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) idp_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The identity provider ID.</p>
        pub fn idp_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.idp_identifier = Some(input.into());
            self
        }
        /// <p>The identity provider ID.</p>
        pub fn set_idp_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idp_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityProviderByIdentifierInput`](crate::input::GetIdentityProviderByIdentifierInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIdentityProviderByIdentifierInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIdentityProviderByIdentifierInput {
                user_pool_id: self.user_pool_id,
                idp_identifier: self.idp_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIdentityProviderByIdentifierInputOperationOutputAlias =
    crate::operation::GetIdentityProviderByIdentifier;
#[doc(hidden)]
pub type GetIdentityProviderByIdentifierInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetIdentityProviderByIdentifierInput {
    /// Consumes the builder and constructs an Operation<[`GetIdentityProviderByIdentifier`](crate::operation::GetIdentityProviderByIdentifier)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIdentityProviderByIdentifier,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIdentityProviderByIdentifierInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIdentityProviderByIdentifierInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIdentityProviderByIdentifierInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.GetIdentityProviderByIdentifier",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_identity_provider_by_identifier(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIdentityProviderByIdentifier::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIdentityProviderByIdentifier",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIdentityProviderByIdentifierInput`](crate::input::GetIdentityProviderByIdentifierInput)
    pub fn builder() -> crate::input::get_identity_provider_by_identifier_input::Builder {
        crate::input::get_identity_provider_by_identifier_input::Builder::default()
    }
}

/// See [`GetSigningCertificateInput`](crate::input::GetSigningCertificateInput)
pub mod get_signing_certificate_input {
    /// A builder for [`GetSigningCertificateInput`](crate::input::GetSigningCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSigningCertificateInput`](crate::input::GetSigningCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSigningCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSigningCertificateInput {
                user_pool_id: self.user_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSigningCertificateInputOperationOutputAlias = crate::operation::GetSigningCertificate;
#[doc(hidden)]
pub type GetSigningCertificateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSigningCertificateInput {
    /// Consumes the builder and constructs an Operation<[`GetSigningCertificate`](crate::operation::GetSigningCertificate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSigningCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSigningCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSigningCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSigningCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.GetSigningCertificate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_signing_certificate(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSigningCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSigningCertificate",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSigningCertificateInput`](crate::input::GetSigningCertificateInput)
    pub fn builder() -> crate::input::get_signing_certificate_input::Builder {
        crate::input::get_signing_certificate_input::Builder::default()
    }
}

/// See [`GetUiCustomizationInput`](crate::input::GetUiCustomizationInput)
pub mod get_ui_customization_input {
    /// A builder for [`GetUiCustomizationInput`](crate::input::GetUiCustomizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The client ID for the client app.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID for the client app.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUiCustomizationInput`](crate::input::GetUiCustomizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUiCustomizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUiCustomizationInput {
                user_pool_id: self.user_pool_id,
                client_id: self.client_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUiCustomizationInputOperationOutputAlias = crate::operation::GetUICustomization;
#[doc(hidden)]
pub type GetUiCustomizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUiCustomizationInput {
    /// Consumes the builder and constructs an Operation<[`GetUICustomization`](crate::operation::GetUICustomization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUICustomization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUiCustomizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUiCustomizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUiCustomizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.GetUICustomization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_ui_customization(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUICustomization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUICustomization",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUiCustomizationInput`](crate::input::GetUiCustomizationInput)
    pub fn builder() -> crate::input::get_ui_customization_input::Builder {
        crate::input::get_ui_customization_input::Builder::default()
    }
}

/// See [`GetUserInput`](crate::input::GetUserInput)
pub mod get_user_input {
    /// A builder for [`GetUserInput`](crate::input::GetUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access token returned by the server response to get information about the user.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token returned by the server response to get information about the user.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserInput`](crate::input::GetUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetUserInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetUserInput {
                access_token: self.access_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUserInputOperationOutputAlias = crate::operation::GetUser;
#[doc(hidden)]
pub type GetUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUserInput {
    /// Consumes the builder and constructs an Operation<[`GetUser`](crate::operation::GetUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.GetUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_user(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetUser::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetUser",
                    "cognitoidentityprovider",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUserInput`](crate::input::GetUserInput)
    pub fn builder() -> crate::input::get_user_input::Builder {
        crate::input::get_user_input::Builder::default()
    }
}

/// See [`GetUserAttributeVerificationCodeInput`](crate::input::GetUserAttributeVerificationCodeInput)
pub mod get_user_attribute_verification_code_input {
    /// A builder for [`GetUserAttributeVerificationCodeInput`](crate::input::GetUserAttributeVerificationCodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The access token returned by the server response to get the user attribute verification code.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token returned by the server response to get the user attribute verification code.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p>The attribute name returned by the server response to get the user attribute verification code.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The attribute name returned by the server response to get the user attribute verification code.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the GetUserAttributeVerificationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your GetUserAttributeVerificationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the GetUserAttributeVerificationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your GetUserAttributeVerificationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserAttributeVerificationCodeInput`](crate::input::GetUserAttributeVerificationCodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUserAttributeVerificationCodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUserAttributeVerificationCodeInput {
                access_token: self.access_token,
                attribute_name: self.attribute_name,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUserAttributeVerificationCodeInputOperationOutputAlias =
    crate::operation::GetUserAttributeVerificationCode;
#[doc(hidden)]
pub type GetUserAttributeVerificationCodeInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetUserAttributeVerificationCodeInput {
    /// Consumes the builder and constructs an Operation<[`GetUserAttributeVerificationCode`](crate::operation::GetUserAttributeVerificationCode)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUserAttributeVerificationCode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUserAttributeVerificationCodeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUserAttributeVerificationCodeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUserAttributeVerificationCodeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.GetUserAttributeVerificationCode",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_user_attribute_verification_code(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUserAttributeVerificationCode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUserAttributeVerificationCode",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUserAttributeVerificationCodeInput`](crate::input::GetUserAttributeVerificationCodeInput)
    pub fn builder() -> crate::input::get_user_attribute_verification_code_input::Builder {
        crate::input::get_user_attribute_verification_code_input::Builder::default()
    }
}

/// See [`GetUserPoolMfaConfigInput`](crate::input::GetUserPoolMfaConfigInput)
pub mod get_user_pool_mfa_config_input {
    /// A builder for [`GetUserPoolMfaConfigInput`](crate::input::GetUserPoolMfaConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserPoolMfaConfigInput`](crate::input::GetUserPoolMfaConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUserPoolMfaConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUserPoolMfaConfigInput {
                user_pool_id: self.user_pool_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUserPoolMfaConfigInputOperationOutputAlias = crate::operation::GetUserPoolMfaConfig;
#[doc(hidden)]
pub type GetUserPoolMfaConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUserPoolMfaConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetUserPoolMfaConfig`](crate::operation::GetUserPoolMfaConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUserPoolMfaConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUserPoolMfaConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUserPoolMfaConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUserPoolMfaConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.GetUserPoolMfaConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_user_pool_mfa_config(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUserPoolMfaConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUserPoolMfaConfig",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUserPoolMfaConfigInput`](crate::input::GetUserPoolMfaConfigInput)
    pub fn builder() -> crate::input::get_user_pool_mfa_config_input::Builder {
        crate::input::get_user_pool_mfa_config_input::Builder::default()
    }
}

/// See [`GlobalSignOutInput`](crate::input::GlobalSignOutInput)
pub mod global_sign_out_input {
    /// A builder for [`GlobalSignOutInput`](crate::input::GlobalSignOutInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalSignOutInput`](crate::input::GlobalSignOutInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GlobalSignOutInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GlobalSignOutInput {
                access_token: self.access_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GlobalSignOutInputOperationOutputAlias = crate::operation::GlobalSignOut;
#[doc(hidden)]
pub type GlobalSignOutInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GlobalSignOutInput {
    /// Consumes the builder and constructs an Operation<[`GlobalSignOut`](crate::operation::GlobalSignOut)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GlobalSignOut,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GlobalSignOutInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GlobalSignOutInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GlobalSignOutInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.GlobalSignOut",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_global_sign_out(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GlobalSignOut::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GlobalSignOut",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GlobalSignOutInput`](crate::input::GlobalSignOutInput)
    pub fn builder() -> crate::input::global_sign_out_input::Builder {
        crate::input::global_sign_out_input::Builder::default()
    }
}

/// See [`InitiateAuthInput`](crate::input::InitiateAuthInput)
pub mod initiate_auth_input {
    /// A builder for [`InitiateAuthInput`](crate::input::InitiateAuthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auth_flow: std::option::Option<crate::model::AuthFlowType>,
        pub(crate) auth_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) analytics_metadata: std::option::Option<crate::model::AnalyticsMetadataType>,
        pub(crate) user_context_data: std::option::Option<crate::model::UserContextDataType>,
    }
    impl Builder {
        /// <p>The authentication flow for this call to run. The API action will depend on this value. For example:</p>
        /// <ul>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code> takes in a valid refresh token and returns new tokens.</p> </li>
        /// <li> <p> <code>USER_SRP_AUTH</code> takes in <code>USERNAME</code> and <code>SRP_A</code> and returns the SRP variables to be used for next challenge execution.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code> takes in <code>USERNAME</code> and <code>PASSWORD</code> and returns the next challenge or tokens.</p> </li>
        /// </ul>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li>
        /// <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code>: Non-SRP authentication flow; USERNAME and PASSWORD are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if it doesn't find the USERNAME in the user pool. </p> </li>
        /// </ul>
        /// <p> <code>ADMIN_NO_SRP_AUTH</code> isn't a valid value.</p>
        pub fn auth_flow(mut self, input: crate::model::AuthFlowType) -> Self {
            self.auth_flow = Some(input);
            self
        }
        /// <p>The authentication flow for this call to run. The API action will depend on this value. For example:</p>
        /// <ul>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code> takes in a valid refresh token and returns new tokens.</p> </li>
        /// <li> <p> <code>USER_SRP_AUTH</code> takes in <code>USERNAME</code> and <code>SRP_A</code> and returns the SRP variables to be used for next challenge execution.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code> takes in <code>USERNAME</code> and <code>PASSWORD</code> and returns the next challenge or tokens.</p> </li>
        /// </ul>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li>
        /// <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li>
        /// <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li>
        /// <li> <p> <code>USER_PASSWORD_AUTH</code>: Non-SRP authentication flow; USERNAME and PASSWORD are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if it doesn't find the USERNAME in the user pool. </p> </li>
        /// </ul>
        /// <p> <code>ADMIN_NO_SRP_AUTH</code> isn't a valid value.</p>
        pub fn set_auth_flow(
            mut self,
            input: std::option::Option<crate::model::AuthFlowType>,
        ) -> Self {
            self.auth_flow = input;
            self
        }
        /// Adds a key-value pair to `auth_parameters`.
        ///
        /// To override the contents of this collection use [`set_auth_parameters`](Self::set_auth_parameters).
        ///
        /// <p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you're invoking. The required values depend on the value of <code>AuthFlow</code>:</p>
        /// <ul>
        /// <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li>
        /// </ul>
        pub fn auth_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.auth_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.auth_parameters = Some(hash_map);
            self
        }
        /// <p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you're invoking. The required values depend on the value of <code>AuthFlow</code>:</p>
        /// <ul>
        /// <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li>
        /// </ul>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.auth_parameters = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the InitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p>
        /// <ul>
        /// <li> <p>Pre signup</p> </li>
        /// <li> <p>Pre authentication</p> </li>
        /// <li> <p>User migration</p> </li>
        /// </ul>
        /// <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your InitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p>
        /// <p>When you use the InitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it doesn't provide the ClientMetadata value as input:</p>
        /// <ul>
        /// <li> <p>Post authentication</p> </li>
        /// <li> <p>Custom message</p> </li>
        /// <li> <p>Pre token generation</p> </li>
        /// <li> <p>Create auth challenge</p> </li>
        /// <li> <p>Define auth challenge</p> </li>
        /// <li> <p>Verify auth challenge</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the InitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p>
        /// <ul>
        /// <li> <p>Pre signup</p> </li>
        /// <li> <p>Pre authentication</p> </li>
        /// <li> <p>User migration</p> </li>
        /// </ul>
        /// <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your InitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p>
        /// <p>When you use the InitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it doesn't provide the ClientMetadata value as input:</p>
        /// <ul>
        /// <li> <p>Post authentication</p> </li>
        /// <li> <p>Custom message</p> </li>
        /// <li> <p>Pre token generation</p> </li>
        /// <li> <p>Create auth challenge</p> </li>
        /// <li> <p>Define auth challenge</p> </li>
        /// <li> <p>Verify auth challenge</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// <p>The app client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The app client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>InitiateAuth</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.analytics_metadata = Some(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>InitiateAuth</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.analytics_metadata = input;
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.user_context_data = Some(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.user_context_data = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateAuthInput`](crate::input::InitiateAuthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InitiateAuthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InitiateAuthInput {
                auth_flow: self.auth_flow,
                auth_parameters: self.auth_parameters,
                client_metadata: self.client_metadata,
                client_id: self.client_id,
                analytics_metadata: self.analytics_metadata,
                user_context_data: self.user_context_data,
            })
        }
    }
}
#[doc(hidden)]
pub type InitiateAuthInputOperationOutputAlias = crate::operation::InitiateAuth;
#[doc(hidden)]
pub type InitiateAuthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl InitiateAuthInput {
    /// Consumes the builder and constructs an Operation<[`InitiateAuth`](crate::operation::InitiateAuth)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InitiateAuth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InitiateAuthInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InitiateAuthInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InitiateAuthInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.InitiateAuth",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_initiate_auth(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InitiateAuth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InitiateAuth",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InitiateAuthInput`](crate::input::InitiateAuthInput)
    pub fn builder() -> crate::input::initiate_auth_input::Builder {
        crate::input::initiate_auth_input::Builder::default()
    }
}

/// See [`ListDevicesInput`](crate::input::ListDevicesInput)
pub mod list_devices_input {
    /// A builder for [`ListDevicesInput`](crate::input::ListDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) pagination_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access tokens for the request to list devices.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access tokens for the request to list devices.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p>The limit of the device request.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The limit of the device request.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The pagination token for the list request.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.pagination_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the list request.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pagination_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicesInput`](crate::input::ListDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDevicesInput {
                access_token: self.access_token,
                limit: self.limit,
                pagination_token: self.pagination_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDevicesInputOperationOutputAlias = crate::operation::ListDevices;
#[doc(hidden)]
pub type ListDevicesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDevicesInput {
    /// Consumes the builder and constructs an Operation<[`ListDevices`](crate::operation::ListDevices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDevices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ListDevices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_devices(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDevices",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDevicesInput`](crate::input::ListDevicesInput)
    pub fn builder() -> crate::input::list_devices_input::Builder {
        crate::input::list_devices_input::Builder::default()
    }
}

/// See [`ListGroupsInput`](crate::input::ListGroupsInput)
pub mod list_groups_input {
    /// A builder for [`ListGroupsInput`](crate::input::ListGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The limit of the request to list groups.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The limit of the request to list groups.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsInput`](crate::input::ListGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupsInput {
                user_pool_id: self.user_pool_id,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupsInputOperationOutputAlias = crate::operation::ListGroups;
#[doc(hidden)]
pub type ListGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListGroups`](crate::operation::ListGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ListGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_groups(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroups",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupsInput`](crate::input::ListGroupsInput)
    pub fn builder() -> crate::input::list_groups_input::Builder {
        crate::input::list_groups_input::Builder::default()
    }
}

/// See [`ListIdentityProvidersInput`](crate::input::ListIdentityProvidersInput)
pub mod list_identity_providers_input {
    /// A builder for [`ListIdentityProvidersInput`](crate::input::ListIdentityProvidersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The maximum number of identity providers to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of identity providers to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentityProvidersInput`](crate::input::ListIdentityProvidersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIdentityProvidersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIdentityProvidersInput {
                user_pool_id: self.user_pool_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIdentityProvidersInputOperationOutputAlias = crate::operation::ListIdentityProviders;
#[doc(hidden)]
pub type ListIdentityProvidersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIdentityProvidersInput {
    /// Consumes the builder and constructs an Operation<[`ListIdentityProviders`](crate::operation::ListIdentityProviders)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIdentityProviders,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIdentityProvidersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIdentityProvidersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIdentityProvidersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ListIdentityProviders",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_identity_providers(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIdentityProviders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIdentityProviders",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIdentityProvidersInput`](crate::input::ListIdentityProvidersInput)
    pub fn builder() -> crate::input::list_identity_providers_input::Builder {
        crate::input::list_identity_providers_input::Builder::default()
    }
}

/// See [`ListResourceServersInput`](crate::input::ListResourceServersInput)
pub mod list_resource_servers_input {
    /// A builder for [`ListResourceServersInput`](crate::input::ListResourceServersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The maximum number of resource servers to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of resource servers to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceServersInput`](crate::input::ListResourceServersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourceServersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourceServersInput {
                user_pool_id: self.user_pool_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourceServersInputOperationOutputAlias = crate::operation::ListResourceServers;
#[doc(hidden)]
pub type ListResourceServersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListResourceServersInput {
    /// Consumes the builder and constructs an Operation<[`ListResourceServers`](crate::operation::ListResourceServers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourceServers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourceServersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourceServersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourceServersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ListResourceServers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_resource_servers(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourceServers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourceServers",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourceServersInput`](crate::input::ListResourceServersInput)
    pub fn builder() -> crate::input::list_resource_servers_input::Builder {
        crate::input::list_resource_servers_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListUserImportJobsInput`](crate::input::ListUserImportJobsInput)
pub mod list_user_import_jobs_input {
    /// A builder for [`ListUserImportJobsInput`](crate::input::ListUserImportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) pagination_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The maximum number of import jobs you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of import jobs you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to <code>ListUserImportJobs</code>, which can be used to return the next set of import jobs in the list.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.pagination_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to <code>ListUserImportJobs</code>, which can be used to return the next set of import jobs in the list.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pagination_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserImportJobsInput`](crate::input::ListUserImportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUserImportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUserImportJobsInput {
                user_pool_id: self.user_pool_id,
                max_results: self.max_results.unwrap_or_default(),
                pagination_token: self.pagination_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUserImportJobsInputOperationOutputAlias = crate::operation::ListUserImportJobs;
#[doc(hidden)]
pub type ListUserImportJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUserImportJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListUserImportJobs`](crate::operation::ListUserImportJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUserImportJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUserImportJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUserImportJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUserImportJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ListUserImportJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_user_import_jobs(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUserImportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUserImportJobs",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUserImportJobsInput`](crate::input::ListUserImportJobsInput)
    pub fn builder() -> crate::input::list_user_import_jobs_input::Builder {
        crate::input::list_user_import_jobs_input::Builder::default()
    }
}

/// See [`ListUserPoolClientsInput`](crate::input::ListUserPoolClientsInput)
pub mod list_user_pool_clients_input {
    /// A builder for [`ListUserPoolClientsInput`](crate::input::ListUserPoolClientsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to list user pool clients.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to list user pool clients.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The maximum number of results you want the request to return when listing the user pool clients.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results you want the request to return when listing the user pool clients.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserPoolClientsInput`](crate::input::ListUserPoolClientsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUserPoolClientsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUserPoolClientsInput {
                user_pool_id: self.user_pool_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUserPoolClientsInputOperationOutputAlias = crate::operation::ListUserPoolClients;
#[doc(hidden)]
pub type ListUserPoolClientsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUserPoolClientsInput {
    /// Consumes the builder and constructs an Operation<[`ListUserPoolClients`](crate::operation::ListUserPoolClients)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUserPoolClients,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUserPoolClientsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUserPoolClientsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUserPoolClientsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ListUserPoolClients",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_user_pool_clients(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUserPoolClients::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUserPoolClients",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUserPoolClientsInput`](crate::input::ListUserPoolClientsInput)
    pub fn builder() -> crate::input::list_user_pool_clients_input::Builder {
        crate::input::list_user_pool_clients_input::Builder::default()
    }
}

/// See [`ListUserPoolsInput`](crate::input::ListUserPoolsInput)
pub mod list_user_pools_input {
    /// A builder for [`ListUserPoolsInput`](crate::input::ListUserPoolsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results you want the request to return when listing the user pools.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results you want the request to return when listing the user pools.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserPoolsInput`](crate::input::ListUserPoolsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUserPoolsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUserPoolsInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListUserPoolsInputOperationOutputAlias = crate::operation::ListUserPools;
#[doc(hidden)]
pub type ListUserPoolsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUserPoolsInput {
    /// Consumes the builder and constructs an Operation<[`ListUserPools`](crate::operation::ListUserPools)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUserPools,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUserPoolsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUserPoolsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUserPoolsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ListUserPools",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_user_pools(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUserPools::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUserPools",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUserPoolsInput`](crate::input::ListUserPoolsInput)
    pub fn builder() -> crate::input::list_user_pools_input::Builder {
        crate::input::list_user_pools_input::Builder::default()
    }
}

/// See [`ListUsersInput`](crate::input::ListUsersInput)
pub mod list_users_input {
    /// A builder for [`ListUsersInput`](crate::input::ListUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) attributes_to_get: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) pagination_token: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool on which the search should be performed.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool on which the search should be performed.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// Appends an item to `attributes_to_get`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>An array of strings, where each string is the name of a user attribute to be returned for each user in the search results. If the array is null, all attributes are returned.</p>
        pub fn attributes_to_get(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attributes_to_get.unwrap_or_default();
            v.push(input.into());
            self.attributes_to_get = Some(v);
            self
        }
        /// <p>An array of strings, where each string is the name of a user attribute to be returned for each user in the search results. If the array is null, all attributes are returned.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attributes_to_get = input;
            self
        }
        /// <p>Maximum number of users to be returned.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Maximum number of users to be returned.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn pagination_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.pagination_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_pagination_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pagination_token = input;
            self
        }
        /// <p>A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"". Quotation marks within the filter string must be escaped using the backslash (\) character. For example, "<code>family_name</code> = \"Reddy\"".</p>
        /// <ul>
        /// <li> <p> <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute at a time.</p> </li>
        /// <li> <p> <i>Filter-Type</i>: For an exact match, use =, for example, "<code>given_name</code> = \"Jon\"". For a prefix ("starts with") match, use ^=, for example, "<code>given_name</code> ^= \"Jon\"". </p> </li>
        /// <li> <p> <i>AttributeValue</i>: The attribute value that must be matched for each user.</p> </li>
        /// </ul>
        /// <p>If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.</p>
        /// <p>You can only search for the following standard attributes:</p>
        /// <ul>
        /// <li> <p> <code>username</code> (case-sensitive)</p> </li>
        /// <li> <p> <code>email</code> </p> </li>
        /// <li> <p> <code>phone_number</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>given_name</code> </p> </li>
        /// <li> <p> <code>family_name</code> </p> </li>
        /// <li> <p> <code>preferred_username</code> </p> </li>
        /// <li> <p> <code>cognito:user_status</code> (called <b>Status</b> in the Console) (case-insensitive)</p> </li>
        /// <li> <p> <code>status (called <b>Enabled</b> in the Console) (case-sensitive)</code> </p> </li>
        /// <li> <p> <code>sub</code> </p> </li>
        /// </ul>
        /// <p>Custom attributes aren't searchable.</p> <note>
        /// <p>You can also list users with a client-side filter. The server-side filter matches no more than 1 attribute. For an advanced search, use a client-side filter with the <code>--query</code> parameter of the <code>list-users</code> action in the CLI. When you use a client-side filter, ListUsers returns a paginated list of zero or more users. You can receive multiple pages in a row with zero results. Repeat the query with each pagination token that is returned until you receive a null pagination token value, and then review the combined result. </p>
        /// <p>For more information about server-side and client-side filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">FilteringCLI output</a> in the <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Command Line Interface User Guide</a>. </p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api">Searching for Users Using the ListUsers API</a> and <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples">Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter = Some(input.into());
            self
        }
        /// <p>A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"". Quotation marks within the filter string must be escaped using the backslash (\) character. For example, "<code>family_name</code> = \"Reddy\"".</p>
        /// <ul>
        /// <li> <p> <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute at a time.</p> </li>
        /// <li> <p> <i>Filter-Type</i>: For an exact match, use =, for example, "<code>given_name</code> = \"Jon\"". For a prefix ("starts with") match, use ^=, for example, "<code>given_name</code> ^= \"Jon\"". </p> </li>
        /// <li> <p> <i>AttributeValue</i>: The attribute value that must be matched for each user.</p> </li>
        /// </ul>
        /// <p>If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.</p>
        /// <p>You can only search for the following standard attributes:</p>
        /// <ul>
        /// <li> <p> <code>username</code> (case-sensitive)</p> </li>
        /// <li> <p> <code>email</code> </p> </li>
        /// <li> <p> <code>phone_number</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>given_name</code> </p> </li>
        /// <li> <p> <code>family_name</code> </p> </li>
        /// <li> <p> <code>preferred_username</code> </p> </li>
        /// <li> <p> <code>cognito:user_status</code> (called <b>Status</b> in the Console) (case-insensitive)</p> </li>
        /// <li> <p> <code>status (called <b>Enabled</b> in the Console) (case-sensitive)</code> </p> </li>
        /// <li> <p> <code>sub</code> </p> </li>
        /// </ul>
        /// <p>Custom attributes aren't searchable.</p> <note>
        /// <p>You can also list users with a client-side filter. The server-side filter matches no more than 1 attribute. For an advanced search, use a client-side filter with the <code>--query</code> parameter of the <code>list-users</code> action in the CLI. When you use a client-side filter, ListUsers returns a paginated list of zero or more users. You can receive multiple pages in a row with zero results. Repeat the query with each pagination token that is returned until you receive a null pagination token value, and then review the combined result. </p>
        /// <p>For more information about server-side and client-side filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">FilteringCLI output</a> in the <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Command Line Interface User Guide</a>. </p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api">Searching for Users Using the ListUsers API</a> and <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples">Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.</p>
        pub fn set_filter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersInput`](crate::input::ListUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListUsersInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListUsersInput {
                user_pool_id: self.user_pool_id,
                attributes_to_get: self.attributes_to_get,
                limit: self.limit,
                pagination_token: self.pagination_token,
                filter: self.filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUsersInputOperationOutputAlias = crate::operation::ListUsers;
#[doc(hidden)]
pub type ListUsersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUsersInput {
    /// Consumes the builder and constructs an Operation<[`ListUsers`](crate::operation::ListUsers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUsers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ListUsers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_users(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListUsers::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListUsers",
                    "cognitoidentityprovider",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
}

/// See [`ListUsersInGroupInput`](crate::input::ListUsersInGroupInput)
pub mod list_users_in_group_input {
    /// A builder for [`ListUsersInGroupInput`](crate::input::ListUsersInGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The limit of the request to list users.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The limit of the request to list users.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersInGroupInput`](crate::input::ListUsersInGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUsersInGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUsersInGroupInput {
                user_pool_id: self.user_pool_id,
                group_name: self.group_name,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUsersInGroupInputOperationOutputAlias = crate::operation::ListUsersInGroup;
#[doc(hidden)]
pub type ListUsersInGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUsersInGroupInput {
    /// Consumes the builder and constructs an Operation<[`ListUsersInGroup`](crate::operation::ListUsersInGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUsersInGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUsersInGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUsersInGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUsersInGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ListUsersInGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_users_in_group(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUsersInGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUsersInGroup",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUsersInGroupInput`](crate::input::ListUsersInGroupInput)
    pub fn builder() -> crate::input::list_users_in_group_input::Builder {
        crate::input::list_users_in_group_input::Builder::default()
    }
}

/// See [`ResendConfirmationCodeInput`](crate::input::ResendConfirmationCodeInput)
pub mod resend_confirmation_code_input {
    /// A builder for [`ResendConfirmationCodeInput`](crate::input::ResendConfirmationCodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) secret_hash: std::option::Option<std::string::String>,
        pub(crate) user_context_data: std::option::Option<crate::model::UserContextDataType>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) analytics_metadata: std::option::Option<crate::model::AnalyticsMetadataType>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn secret_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_hash = Some(input.into());
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn set_secret_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_hash = input;
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.user_context_data = Some(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.user_context_data = input;
            self
        }
        /// <p>The <code>username</code> attribute of the user to whom you want to resend a confirmation code.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The <code>username</code> attribute of the user to whom you want to resend a confirmation code.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ResendConfirmationCode</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.analytics_metadata = Some(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ResendConfirmationCode</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.analytics_metadata = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ResendConfirmationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ResendConfirmationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ResendConfirmationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ResendConfirmationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`ResendConfirmationCodeInput`](crate::input::ResendConfirmationCodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResendConfirmationCodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResendConfirmationCodeInput {
                client_id: self.client_id,
                secret_hash: self.secret_hash,
                user_context_data: self.user_context_data,
                username: self.username,
                analytics_metadata: self.analytics_metadata,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type ResendConfirmationCodeInputOperationOutputAlias = crate::operation::ResendConfirmationCode;
#[doc(hidden)]
pub type ResendConfirmationCodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResendConfirmationCodeInput {
    /// Consumes the builder and constructs an Operation<[`ResendConfirmationCode`](crate::operation::ResendConfirmationCode)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResendConfirmationCode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResendConfirmationCodeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResendConfirmationCodeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResendConfirmationCodeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.ResendConfirmationCode",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_resend_confirmation_code(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResendConfirmationCode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResendConfirmationCode",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResendConfirmationCodeInput`](crate::input::ResendConfirmationCodeInput)
    pub fn builder() -> crate::input::resend_confirmation_code_input::Builder {
        crate::input::resend_confirmation_code_input::Builder::default()
    }
}

/// See [`RespondToAuthChallengeInput`](crate::input::RespondToAuthChallengeInput)
pub mod respond_to_auth_challenge_input {
    /// A builder for [`RespondToAuthChallengeInput`](crate::input::RespondToAuthChallengeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) challenge_name: std::option::Option<crate::model::ChallengeNameType>,
        pub(crate) session: std::option::Option<std::string::String>,
        pub(crate) challenge_responses: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) analytics_metadata: std::option::Option<crate::model::AnalyticsMetadataType>,
        pub(crate) user_context_data: std::option::Option<crate::model::UserContextDataType>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The app client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The app client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
        /// <p> <code>ADMIN_NO_SRP_AUTH</code> isn't a valid value.</p>
        pub fn challenge_name(mut self, input: crate::model::ChallengeNameType) -> Self {
            self.challenge_name = Some(input);
            self
        }
        /// <p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>
        /// <p> <code>ADMIN_NO_SRP_AUTH</code> isn't a valid value.</p>
        pub fn set_challenge_name(
            mut self,
            input: std::option::Option<crate::model::ChallengeNameType>,
        ) -> Self {
            self.challenge_name = input;
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn session(mut self, input: impl Into<std::string::String>) -> Self {
            self.session = Some(input.into());
            self
        }
        /// <p>The session that should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>
        pub fn set_session(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session = input;
            self
        }
        /// Adds a key-value pair to `challenge_responses`.
        ///
        /// To override the contents of this collection use [`set_challenge_responses`](Self::set_challenge_responses).
        ///
        /// <p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p> <note>
        /// <p> <code>SECRET_HASH</code> (if app client is configured with client secret) applies to all of the inputs that follow (including <code>SOFTWARE_TOKEN_MFA</code>).</p>
        /// </note>
        /// <ul>
        /// <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>.</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>.</p> <note>
        /// <p> <code>PASSWORD_VERIFIER</code> requires <code>DEVICE_KEY</code> when signing in with a remembered device.</p>
        /// </note> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>. </p> </li>
        /// <li> <p> <code>SOFTWARE_TOKEN_MFA</code>: <code>USERNAME</code> and <code>SOFTWARE_TOKEN_MFA_CODE</code> are required attributes.</p> </li>
        /// <li> <p> <code>DEVICE_SRP_AUTH</code> requires <code>USERNAME</code>, <code>DEVICE_KEY</code>, <code>SRP_A</code> (and <code>SECRET_HASH</code>).</p> </li>
        /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code> requires everything that <code>PASSWORD_VERIFIER</code> requires, plus <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you must use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li>
        /// </ul>
        pub fn challenge_responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.challenge_responses.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.challenge_responses = Some(hash_map);
            self
        }
        /// <p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p> <note>
        /// <p> <code>SECRET_HASH</code> (if app client is configured with client secret) applies to all of the inputs that follow (including <code>SOFTWARE_TOKEN_MFA</code>).</p>
        /// </note>
        /// <ul>
        /// <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>.</p> </li>
        /// <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>.</p> <note>
        /// <p> <code>PASSWORD_VERIFIER</code> requires <code>DEVICE_KEY</code> when signing in with a remembered device.</p>
        /// </note> </li>
        /// <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>. </p> </li>
        /// <li> <p> <code>SOFTWARE_TOKEN_MFA</code>: <code>USERNAME</code> and <code>SOFTWARE_TOKEN_MFA_CODE</code> are required attributes.</p> </li>
        /// <li> <p> <code>DEVICE_SRP_AUTH</code> requires <code>USERNAME</code>, <code>DEVICE_KEY</code>, <code>SRP_A</code> (and <code>SECRET_HASH</code>).</p> </li>
        /// <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code> requires everything that <code>PASSWORD_VERIFIER</code> requires, plus <code>DEVICE_KEY</code>.</p> </li>
        /// <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you must use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li>
        /// </ul>
        pub fn set_challenge_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.challenge_responses = input;
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>RespondToAuthChallenge</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.analytics_metadata = Some(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>RespondToAuthChallenge</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.analytics_metadata = input;
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.user_context_data = Some(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.user_context_data = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the RespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>post authentication</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your RespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the RespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>post authentication</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your RespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`RespondToAuthChallengeInput`](crate::input::RespondToAuthChallengeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RespondToAuthChallengeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RespondToAuthChallengeInput {
                client_id: self.client_id,
                challenge_name: self.challenge_name,
                session: self.session,
                challenge_responses: self.challenge_responses,
                analytics_metadata: self.analytics_metadata,
                user_context_data: self.user_context_data,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type RespondToAuthChallengeInputOperationOutputAlias = crate::operation::RespondToAuthChallenge;
#[doc(hidden)]
pub type RespondToAuthChallengeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RespondToAuthChallengeInput {
    /// Consumes the builder and constructs an Operation<[`RespondToAuthChallenge`](crate::operation::RespondToAuthChallenge)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RespondToAuthChallenge,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RespondToAuthChallengeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RespondToAuthChallengeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RespondToAuthChallengeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.RespondToAuthChallenge",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_respond_to_auth_challenge(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RespondToAuthChallenge::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RespondToAuthChallenge",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RespondToAuthChallengeInput`](crate::input::RespondToAuthChallengeInput)
    pub fn builder() -> crate::input::respond_to_auth_challenge_input::Builder {
        crate::input::respond_to_auth_challenge_input::Builder::default()
    }
}

/// See [`RevokeTokenInput`](crate::input::RevokeTokenInput)
pub mod revoke_token_input {
    /// A builder for [`RevokeTokenInput`](crate::input::RevokeTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The refresh token that you want to revoke.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The refresh token that you want to revoke.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// <p>The client ID for the token that you want to revoke.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID for the token that you want to revoke.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The secret for the client ID. This is required only if the client ID has a secret.</p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p>The secret for the client ID. This is required only if the client ID has a secret.</p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeTokenInput`](crate::input::RevokeTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RevokeTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RevokeTokenInput {
                token: self.token,
                client_id: self.client_id,
                client_secret: self.client_secret,
            })
        }
    }
}
#[doc(hidden)]
pub type RevokeTokenInputOperationOutputAlias = crate::operation::RevokeToken;
#[doc(hidden)]
pub type RevokeTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RevokeTokenInput {
    /// Consumes the builder and constructs an Operation<[`RevokeToken`](crate::operation::RevokeToken)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RevokeToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RevokeTokenInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RevokeTokenInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RevokeTokenInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.RevokeToken",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_revoke_token(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RevokeToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RevokeToken",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RevokeTokenInput`](crate::input::RevokeTokenInput)
    pub fn builder() -> crate::input::revoke_token_input::Builder {
        crate::input::revoke_token_input::Builder::default()
    }
}

/// See [`SetRiskConfigurationInput`](crate::input::SetRiskConfigurationInput)
pub mod set_risk_configuration_input {
    /// A builder for [`SetRiskConfigurationInput`](crate::input::SetRiskConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) compromised_credentials_risk_configuration:
            std::option::Option<crate::model::CompromisedCredentialsRiskConfigurationType>,
        pub(crate) account_takeover_risk_configuration:
            std::option::Option<crate::model::AccountTakeoverRiskConfigurationType>,
        pub(crate) risk_exception_configuration:
            std::option::Option<crate::model::RiskExceptionConfigurationType>,
    }
    impl Builder {
        /// <p>The user pool ID. </p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID. </p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The app client ID. If <code>ClientId</code> is null, then the risk configuration is mapped to <code>userPoolId</code>. When the client ID is null, the same risk configuration is applied to all the clients in the userPool.</p>
        /// <p>Otherwise, <code>ClientId</code> is mapped to the client. When the client ID isn't null, the user pool configuration is overridden and the risk configuration for the client is used instead.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The app client ID. If <code>ClientId</code> is null, then the risk configuration is mapped to <code>userPoolId</code>. When the client ID is null, the same risk configuration is applied to all the clients in the userPool.</p>
        /// <p>Otherwise, <code>ClientId</code> is mapped to the client. When the client ID isn't null, the user pool configuration is overridden and the risk configuration for the client is used instead.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The compromised credentials risk configuration.</p>
        pub fn compromised_credentials_risk_configuration(
            mut self,
            input: crate::model::CompromisedCredentialsRiskConfigurationType,
        ) -> Self {
            self.compromised_credentials_risk_configuration = Some(input);
            self
        }
        /// <p>The compromised credentials risk configuration.</p>
        pub fn set_compromised_credentials_risk_configuration(
            mut self,
            input: std::option::Option<crate::model::CompromisedCredentialsRiskConfigurationType>,
        ) -> Self {
            self.compromised_credentials_risk_configuration = input;
            self
        }
        /// <p>The account takeover risk configuration.</p>
        pub fn account_takeover_risk_configuration(
            mut self,
            input: crate::model::AccountTakeoverRiskConfigurationType,
        ) -> Self {
            self.account_takeover_risk_configuration = Some(input);
            self
        }
        /// <p>The account takeover risk configuration.</p>
        pub fn set_account_takeover_risk_configuration(
            mut self,
            input: std::option::Option<crate::model::AccountTakeoverRiskConfigurationType>,
        ) -> Self {
            self.account_takeover_risk_configuration = input;
            self
        }
        /// <p>The configuration to override the risk decision.</p>
        pub fn risk_exception_configuration(
            mut self,
            input: crate::model::RiskExceptionConfigurationType,
        ) -> Self {
            self.risk_exception_configuration = Some(input);
            self
        }
        /// <p>The configuration to override the risk decision.</p>
        pub fn set_risk_exception_configuration(
            mut self,
            input: std::option::Option<crate::model::RiskExceptionConfigurationType>,
        ) -> Self {
            self.risk_exception_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`SetRiskConfigurationInput`](crate::input::SetRiskConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetRiskConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetRiskConfigurationInput {
                user_pool_id: self.user_pool_id,
                client_id: self.client_id,
                compromised_credentials_risk_configuration: self
                    .compromised_credentials_risk_configuration,
                account_takeover_risk_configuration: self.account_takeover_risk_configuration,
                risk_exception_configuration: self.risk_exception_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type SetRiskConfigurationInputOperationOutputAlias = crate::operation::SetRiskConfiguration;
#[doc(hidden)]
pub type SetRiskConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetRiskConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`SetRiskConfiguration`](crate::operation::SetRiskConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetRiskConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetRiskConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetRiskConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetRiskConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.SetRiskConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_risk_configuration(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetRiskConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetRiskConfiguration",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetRiskConfigurationInput`](crate::input::SetRiskConfigurationInput)
    pub fn builder() -> crate::input::set_risk_configuration_input::Builder {
        crate::input::set_risk_configuration_input::Builder::default()
    }
}

/// See [`SetUiCustomizationInput`](crate::input::SetUiCustomizationInput)
pub mod set_ui_customization_input {
    /// A builder for [`SetUiCustomizationInput`](crate::input::SetUiCustomizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) css: std::option::Option<std::string::String>,
        pub(crate) image_file: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The client ID for the client app.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID for the client app.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The CSS values in the UI customization.</p>
        pub fn css(mut self, input: impl Into<std::string::String>) -> Self {
            self.css = Some(input.into());
            self
        }
        /// <p>The CSS values in the UI customization.</p>
        pub fn set_css(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.css = input;
            self
        }
        /// <p>The uploaded logo image for the UI customization.</p>
        pub fn image_file(mut self, input: aws_smithy_types::Blob) -> Self {
            self.image_file = Some(input);
            self
        }
        /// <p>The uploaded logo image for the UI customization.</p>
        pub fn set_image_file(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.image_file = input;
            self
        }
        /// Consumes the builder and constructs a [`SetUiCustomizationInput`](crate::input::SetUiCustomizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetUiCustomizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetUiCustomizationInput {
                user_pool_id: self.user_pool_id,
                client_id: self.client_id,
                css: self.css,
                image_file: self.image_file,
            })
        }
    }
}
#[doc(hidden)]
pub type SetUiCustomizationInputOperationOutputAlias = crate::operation::SetUICustomization;
#[doc(hidden)]
pub type SetUiCustomizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetUiCustomizationInput {
    /// Consumes the builder and constructs an Operation<[`SetUICustomization`](crate::operation::SetUICustomization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetUICustomization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetUiCustomizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetUiCustomizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetUiCustomizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.SetUICustomization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_ui_customization(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetUICustomization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetUICustomization",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetUiCustomizationInput`](crate::input::SetUiCustomizationInput)
    pub fn builder() -> crate::input::set_ui_customization_input::Builder {
        crate::input::set_ui_customization_input::Builder::default()
    }
}

/// See [`SetUserMfaPreferenceInput`](crate::input::SetUserMfaPreferenceInput)
pub mod set_user_mfa_preference_input {
    /// A builder for [`SetUserMfaPreferenceInput`](crate::input::SetUserMfaPreferenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sms_mfa_settings: std::option::Option<crate::model::SmsMfaSettingsType>,
        pub(crate) software_token_mfa_settings:
            std::option::Option<crate::model::SoftwareTokenMfaSettingsType>,
        pub(crate) access_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SMS text message multi-factor authentication (MFA) settings.</p>
        pub fn sms_mfa_settings(mut self, input: crate::model::SmsMfaSettingsType) -> Self {
            self.sms_mfa_settings = Some(input);
            self
        }
        /// <p>The SMS text message multi-factor authentication (MFA) settings.</p>
        pub fn set_sms_mfa_settings(
            mut self,
            input: std::option::Option<crate::model::SmsMfaSettingsType>,
        ) -> Self {
            self.sms_mfa_settings = input;
            self
        }
        /// <p>The time-based one-time password software token MFA settings.</p>
        pub fn software_token_mfa_settings(
            mut self,
            input: crate::model::SoftwareTokenMfaSettingsType,
        ) -> Self {
            self.software_token_mfa_settings = Some(input);
            self
        }
        /// <p>The time-based one-time password software token MFA settings.</p>
        pub fn set_software_token_mfa_settings(
            mut self,
            input: std::option::Option<crate::model::SoftwareTokenMfaSettingsType>,
        ) -> Self {
            self.software_token_mfa_settings = input;
            self
        }
        /// <p>The access token for the user.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token for the user.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SetUserMfaPreferenceInput`](crate::input::SetUserMfaPreferenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetUserMfaPreferenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetUserMfaPreferenceInput {
                sms_mfa_settings: self.sms_mfa_settings,
                software_token_mfa_settings: self.software_token_mfa_settings,
                access_token: self.access_token,
            })
        }
    }
}
#[doc(hidden)]
pub type SetUserMfaPreferenceInputOperationOutputAlias = crate::operation::SetUserMFAPreference;
#[doc(hidden)]
pub type SetUserMfaPreferenceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetUserMfaPreferenceInput {
    /// Consumes the builder and constructs an Operation<[`SetUserMFAPreference`](crate::operation::SetUserMFAPreference)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetUserMFAPreference,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetUserMfaPreferenceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetUserMfaPreferenceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetUserMfaPreferenceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.SetUserMFAPreference",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_user_mfa_preference(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetUserMFAPreference::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetUserMFAPreference",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetUserMfaPreferenceInput`](crate::input::SetUserMfaPreferenceInput)
    pub fn builder() -> crate::input::set_user_mfa_preference_input::Builder {
        crate::input::set_user_mfa_preference_input::Builder::default()
    }
}

/// See [`SetUserPoolMfaConfigInput`](crate::input::SetUserPoolMfaConfigInput)
pub mod set_user_pool_mfa_config_input {
    /// A builder for [`SetUserPoolMfaConfigInput`](crate::input::SetUserPoolMfaConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) sms_mfa_configuration: std::option::Option<crate::model::SmsMfaConfigType>,
        pub(crate) software_token_mfa_configuration:
            std::option::Option<crate::model::SoftwareTokenMfaConfigType>,
        pub(crate) mfa_configuration: std::option::Option<crate::model::UserPoolMfaType>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The SMS text message MFA configuration.</p>
        pub fn sms_mfa_configuration(mut self, input: crate::model::SmsMfaConfigType) -> Self {
            self.sms_mfa_configuration = Some(input);
            self
        }
        /// <p>The SMS text message MFA configuration.</p>
        pub fn set_sms_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::SmsMfaConfigType>,
        ) -> Self {
            self.sms_mfa_configuration = input;
            self
        }
        /// <p>The software token MFA configuration.</p>
        pub fn software_token_mfa_configuration(
            mut self,
            input: crate::model::SoftwareTokenMfaConfigType,
        ) -> Self {
            self.software_token_mfa_configuration = Some(input);
            self
        }
        /// <p>The software token MFA configuration.</p>
        pub fn set_software_token_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::SoftwareTokenMfaConfigType>,
        ) -> Self {
            self.software_token_mfa_configuration = input;
            self
        }
        /// <p>The MFA configuration. If you set the MfaConfiguration value to ‘ON’, only users with an MFA factor set up can sign in. To learn more, see <a href="cognito/latest/developerguide/user-pool-settings-mfa.html">Adding Multi-Factor Authentication (MFA) to a User Pool</a>. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> MFA won't be used for any users.</p> </li>
        /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
        /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</p> </li>
        /// </ul>
        pub fn mfa_configuration(mut self, input: crate::model::UserPoolMfaType) -> Self {
            self.mfa_configuration = Some(input);
            self
        }
        /// <p>The MFA configuration. If you set the MfaConfiguration value to ‘ON’, only users with an MFA factor set up can sign in. To learn more, see <a href="cognito/latest/developerguide/user-pool-settings-mfa.html">Adding Multi-Factor Authentication (MFA) to a User Pool</a>. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> MFA won't be used for any users.</p> </li>
        /// <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li>
        /// <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</p> </li>
        /// </ul>
        pub fn set_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::UserPoolMfaType>,
        ) -> Self {
            self.mfa_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`SetUserPoolMfaConfigInput`](crate::input::SetUserPoolMfaConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetUserPoolMfaConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetUserPoolMfaConfigInput {
                user_pool_id: self.user_pool_id,
                sms_mfa_configuration: self.sms_mfa_configuration,
                software_token_mfa_configuration: self.software_token_mfa_configuration,
                mfa_configuration: self.mfa_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type SetUserPoolMfaConfigInputOperationOutputAlias = crate::operation::SetUserPoolMfaConfig;
#[doc(hidden)]
pub type SetUserPoolMfaConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetUserPoolMfaConfigInput {
    /// Consumes the builder and constructs an Operation<[`SetUserPoolMfaConfig`](crate::operation::SetUserPoolMfaConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetUserPoolMfaConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetUserPoolMfaConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetUserPoolMfaConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetUserPoolMfaConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.SetUserPoolMfaConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_user_pool_mfa_config(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetUserPoolMfaConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetUserPoolMfaConfig",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetUserPoolMfaConfigInput`](crate::input::SetUserPoolMfaConfigInput)
    pub fn builder() -> crate::input::set_user_pool_mfa_config_input::Builder {
        crate::input::set_user_pool_mfa_config_input::Builder::default()
    }
}

/// See [`SetUserSettingsInput`](crate::input::SetUserSettingsInput)
pub mod set_user_settings_input {
    /// A builder for [`SetUserSettingsInput`](crate::input::SetUserSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) mfa_options: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
    }
    impl Builder {
        /// <p>The access token for the set user settings request.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token for the set user settings request.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// Appends an item to `mfa_options`.
        ///
        /// To override the contents of this collection use [`set_mfa_options`](Self::set_mfa_options).
        ///
        /// <p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>
        pub fn mfa_options(mut self, input: crate::model::MfaOptionType) -> Self {
            let mut v = self.mfa_options.unwrap_or_default();
            v.push(input);
            self.mfa_options = Some(v);
            self
        }
        /// <p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>
        pub fn set_mfa_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MfaOptionType>>,
        ) -> Self {
            self.mfa_options = input;
            self
        }
        /// Consumes the builder and constructs a [`SetUserSettingsInput`](crate::input::SetUserSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetUserSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetUserSettingsInput {
                access_token: self.access_token,
                mfa_options: self.mfa_options,
            })
        }
    }
}
#[doc(hidden)]
pub type SetUserSettingsInputOperationOutputAlias = crate::operation::SetUserSettings;
#[doc(hidden)]
pub type SetUserSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetUserSettingsInput {
    /// Consumes the builder and constructs an Operation<[`SetUserSettings`](crate::operation::SetUserSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetUserSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetUserSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetUserSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetUserSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.SetUserSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_user_settings(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetUserSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetUserSettings",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetUserSettingsInput`](crate::input::SetUserSettingsInput)
    pub fn builder() -> crate::input::set_user_settings_input::Builder {
        crate::input::set_user_settings_input::Builder::default()
    }
}

/// See [`SignUpInput`](crate::input::SignUpInput)
pub mod sign_up_input {
    /// A builder for [`SignUpInput`](crate::input::SignUpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) secret_hash: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) user_attributes: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        pub(crate) validation_data: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        pub(crate) analytics_metadata: std::option::Option<crate::model::AnalyticsMetadataType>,
        pub(crate) user_context_data: std::option::Option<crate::model::UserContextDataType>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn secret_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_hash = Some(input.into());
            self
        }
        /// <p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>
        pub fn set_secret_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_hash = input;
            self
        }
        /// <p>The user name of the user you want to register.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name of the user you want to register.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The password of the user you want to register.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password of the user you want to register.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Appends an item to `user_attributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn user_attributes(mut self, input: crate::model::AttributeType) -> Self {
            let mut v = self.user_attributes.unwrap_or_default();
            v.push(input);
            self.user_attributes = Some(v);
            self
        }
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.user_attributes = input;
            self
        }
        /// Appends an item to `validation_data`.
        ///
        /// To override the contents of this collection use [`set_validation_data`](Self::set_validation_data).
        ///
        /// <p>The validation data in the request to register a user.</p>
        pub fn validation_data(mut self, input: crate::model::AttributeType) -> Self {
            let mut v = self.validation_data.unwrap_or_default();
            v.push(input);
            self.validation_data = Some(v);
            self
        }
        /// <p>The validation data in the request to register a user.</p>
        pub fn set_validation_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.validation_data = input;
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>SignUp</code> calls.</p>
        pub fn analytics_metadata(mut self, input: crate::model::AnalyticsMetadataType) -> Self {
            self.analytics_metadata = Some(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>SignUp</code> calls.</p>
        pub fn set_analytics_metadata(
            mut self,
            input: std::option::Option<crate::model::AnalyticsMetadataType>,
        ) -> Self {
            self.analytics_metadata = input;
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn user_context_data(mut self, input: crate::model::UserContextDataType) -> Self {
            self.user_context_data = Some(input);
            self
        }
        /// <p>Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>
        pub fn set_user_context_data(
            mut self,
            input: std::option::Option<crate::model::UserContextDataType>,
        ) -> Self {
            self.user_context_data = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the SignUp API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>post confirmation</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your SignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the SignUp API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>post confirmation</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your SignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`SignUpInput`](crate::input::SignUpInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::SignUpInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::SignUpInput {
                client_id: self.client_id,
                secret_hash: self.secret_hash,
                username: self.username,
                password: self.password,
                user_attributes: self.user_attributes,
                validation_data: self.validation_data,
                analytics_metadata: self.analytics_metadata,
                user_context_data: self.user_context_data,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type SignUpInputOperationOutputAlias = crate::operation::SignUp;
#[doc(hidden)]
pub type SignUpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SignUpInput {
    /// Consumes the builder and constructs an Operation<[`SignUp`](crate::operation::SignUp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SignUp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SignUpInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SignUpInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SignUpInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.SignUp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_sign_up(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::SignUp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "SignUp",
                    "cognitoidentityprovider",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SignUpInput`](crate::input::SignUpInput)
    pub fn builder() -> crate::input::sign_up_input::Builder {
        crate::input::sign_up_input::Builder::default()
    }
}

/// See [`StartUserImportJobInput`](crate::input::StartUserImportJobInput)
pub mod start_user_import_job_input {
    /// A builder for [`StartUserImportJobInput`](crate::input::StartUserImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartUserImportJobInput`](crate::input::StartUserImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartUserImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartUserImportJobInput {
                user_pool_id: self.user_pool_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartUserImportJobInputOperationOutputAlias = crate::operation::StartUserImportJob;
#[doc(hidden)]
pub type StartUserImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartUserImportJobInput {
    /// Consumes the builder and constructs an Operation<[`StartUserImportJob`](crate::operation::StartUserImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartUserImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartUserImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartUserImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartUserImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.StartUserImportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_user_import_job(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartUserImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartUserImportJob",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartUserImportJobInput`](crate::input::StartUserImportJobInput)
    pub fn builder() -> crate::input::start_user_import_job_input::Builder {
        crate::input::start_user_import_job_input::Builder::default()
    }
}

/// See [`StopUserImportJobInput`](crate::input::StopUserImportJobInput)
pub mod stop_user_import_job_input {
    /// A builder for [`StopUserImportJobInput`](crate::input::StopUserImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool that the users are being imported into.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID for the user import job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopUserImportJobInput`](crate::input::StopUserImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopUserImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopUserImportJobInput {
                user_pool_id: self.user_pool_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopUserImportJobInputOperationOutputAlias = crate::operation::StopUserImportJob;
#[doc(hidden)]
pub type StopUserImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopUserImportJobInput {
    /// Consumes the builder and constructs an Operation<[`StopUserImportJob`](crate::operation::StopUserImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopUserImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopUserImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopUserImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopUserImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.StopUserImportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_user_import_job(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopUserImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopUserImportJob",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopUserImportJobInput`](crate::input::StopUserImportJobInput)
    pub fn builder() -> crate::input::stop_user_import_job_input::Builder {
        crate::input::stop_user_import_job_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user pool to assign the tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user pool to assign the tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the user pool.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to assign to the user pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove from the user pool.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the tags to remove from the user pool.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAuthEventFeedbackInput`](crate::input::UpdateAuthEventFeedbackInput)
pub mod update_auth_event_feedback_input {
    /// A builder for [`UpdateAuthEventFeedbackInput`](crate::input::UpdateAuthEventFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) feedback_token: std::option::Option<std::string::String>,
        pub(crate) feedback_value: std::option::Option<crate::model::FeedbackValueType>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The user pool username.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user pool username.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The event ID.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The event ID.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The feedback token.</p>
        pub fn feedback_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.feedback_token = Some(input.into());
            self
        }
        /// <p>The feedback token.</p>
        pub fn set_feedback_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feedback_token = input;
            self
        }
        /// <p>The authentication event feedback value.</p>
        pub fn feedback_value(mut self, input: crate::model::FeedbackValueType) -> Self {
            self.feedback_value = Some(input);
            self
        }
        /// <p>The authentication event feedback value.</p>
        pub fn set_feedback_value(
            mut self,
            input: std::option::Option<crate::model::FeedbackValueType>,
        ) -> Self {
            self.feedback_value = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAuthEventFeedbackInput`](crate::input::UpdateAuthEventFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAuthEventFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAuthEventFeedbackInput {
                user_pool_id: self.user_pool_id,
                username: self.username,
                event_id: self.event_id,
                feedback_token: self.feedback_token,
                feedback_value: self.feedback_value,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAuthEventFeedbackInputOperationOutputAlias =
    crate::operation::UpdateAuthEventFeedback;
#[doc(hidden)]
pub type UpdateAuthEventFeedbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAuthEventFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAuthEventFeedback`](crate::operation::UpdateAuthEventFeedback)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAuthEventFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAuthEventFeedbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAuthEventFeedbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAuthEventFeedbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.UpdateAuthEventFeedback",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_auth_event_feedback(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAuthEventFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAuthEventFeedback",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAuthEventFeedbackInput`](crate::input::UpdateAuthEventFeedbackInput)
    pub fn builder() -> crate::input::update_auth_event_feedback_input::Builder {
        crate::input::update_auth_event_feedback_input::Builder::default()
    }
}

/// See [`UpdateDeviceStatusInput`](crate::input::UpdateDeviceStatusInput)
pub mod update_device_status_input {
    /// A builder for [`UpdateDeviceStatusInput`](crate::input::UpdateDeviceStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) device_key: std::option::Option<std::string::String>,
        pub(crate) device_remembered_status:
            std::option::Option<crate::model::DeviceRememberedStatusType>,
    }
    impl Builder {
        /// <p>The access token.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// <p>The device key.</p>
        pub fn device_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_key = Some(input.into());
            self
        }
        /// <p>The device key.</p>
        pub fn set_device_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_key = input;
            self
        }
        /// <p>The status of whether a device is remembered.</p>
        pub fn device_remembered_status(
            mut self,
            input: crate::model::DeviceRememberedStatusType,
        ) -> Self {
            self.device_remembered_status = Some(input);
            self
        }
        /// <p>The status of whether a device is remembered.</p>
        pub fn set_device_remembered_status(
            mut self,
            input: std::option::Option<crate::model::DeviceRememberedStatusType>,
        ) -> Self {
            self.device_remembered_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceStatusInput`](crate::input::UpdateDeviceStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDeviceStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDeviceStatusInput {
                access_token: self.access_token,
                device_key: self.device_key,
                device_remembered_status: self.device_remembered_status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDeviceStatusInputOperationOutputAlias = crate::operation::UpdateDeviceStatus;
#[doc(hidden)]
pub type UpdateDeviceStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDeviceStatusInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDeviceStatus`](crate::operation::UpdateDeviceStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDeviceStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDeviceStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDeviceStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDeviceStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.UpdateDeviceStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_device_status(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDeviceStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDeviceStatus",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDeviceStatusInput`](crate::input::UpdateDeviceStatusInput)
    pub fn builder() -> crate::input::update_device_status_input::Builder {
        crate::input::update_device_status_input::Builder::default()
    }
}

/// See [`UpdateGroupInput`](crate::input::UpdateGroupInput)
pub mod update_group_input {
    /// A builder for [`UpdateGroupInput`](crate::input::UpdateGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) precedence: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>A string containing the new description of the group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A string containing the new description of the group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The new role Amazon Resource Name (ARN) for the group. This is used for setting the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the token.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The new role Amazon Resource Name (ARN) for the group. This is used for setting the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the token.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The new precedence value for the group. For more information about this parameter, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateGroup.html">CreateGroup</a>.</p>
        pub fn precedence(mut self, input: i32) -> Self {
            self.precedence = Some(input);
            self
        }
        /// <p>The new precedence value for the group. For more information about this parameter, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateGroup.html">CreateGroup</a>.</p>
        pub fn set_precedence(mut self, input: std::option::Option<i32>) -> Self {
            self.precedence = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGroupInput`](crate::input::UpdateGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGroupInput {
                group_name: self.group_name,
                user_pool_id: self.user_pool_id,
                description: self.description,
                role_arn: self.role_arn,
                precedence: self.precedence,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGroupInputOperationOutputAlias = crate::operation::UpdateGroup;
#[doc(hidden)]
pub type UpdateGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGroup`](crate::operation::UpdateGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.UpdateGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_group(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGroup",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGroupInput`](crate::input::UpdateGroupInput)
    pub fn builder() -> crate::input::update_group_input::Builder {
        crate::input::update_group_input::Builder::default()
    }
}

/// See [`UpdateIdentityProviderInput`](crate::input::UpdateIdentityProviderInput)
pub mod update_identity_provider_input {
    /// A builder for [`UpdateIdentityProviderInput`](crate::input::UpdateIdentityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) provider_details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) attribute_mapping: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) idp_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The identity provider name.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The identity provider name.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// Adds a key-value pair to `provider_details`.
        ///
        /// To override the contents of this collection use [`set_provider_details`](Self::set_provider_details).
        ///
        /// <p>The identity provider details to be updated, such as <code>MetadataURL</code> and <code>MetadataFile</code>.</p>
        pub fn provider_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.provider_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.provider_details = Some(hash_map);
            self
        }
        /// <p>The identity provider details to be updated, such as <code>MetadataURL</code> and <code>MetadataFile</code>.</p>
        pub fn set_provider_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.provider_details = input;
            self
        }
        /// Adds a key-value pair to `attribute_mapping`.
        ///
        /// To override the contents of this collection use [`set_attribute_mapping`](Self::set_attribute_mapping).
        ///
        /// <p>The identity provider attribute mapping to be changed.</p>
        pub fn attribute_mapping(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attribute_mapping.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attribute_mapping = Some(hash_map);
            self
        }
        /// <p>The identity provider attribute mapping to be changed.</p>
        pub fn set_attribute_mapping(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attribute_mapping = input;
            self
        }
        /// Appends an item to `idp_identifiers`.
        ///
        /// To override the contents of this collection use [`set_idp_identifiers`](Self::set_idp_identifiers).
        ///
        /// <p>A list of identity provider identifiers.</p>
        pub fn idp_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.idp_identifiers.unwrap_or_default();
            v.push(input.into());
            self.idp_identifiers = Some(v);
            self
        }
        /// <p>A list of identity provider identifiers.</p>
        pub fn set_idp_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.idp_identifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIdentityProviderInput`](crate::input::UpdateIdentityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateIdentityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateIdentityProviderInput {
                user_pool_id: self.user_pool_id,
                provider_name: self.provider_name,
                provider_details: self.provider_details,
                attribute_mapping: self.attribute_mapping,
                idp_identifiers: self.idp_identifiers,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateIdentityProviderInputOperationOutputAlias = crate::operation::UpdateIdentityProvider;
#[doc(hidden)]
pub type UpdateIdentityProviderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateIdentityProviderInput {
    /// Consumes the builder and constructs an Operation<[`UpdateIdentityProvider`](crate::operation::UpdateIdentityProvider)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateIdentityProvider,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateIdentityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateIdentityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateIdentityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.UpdateIdentityProvider",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_identity_provider(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateIdentityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateIdentityProvider",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateIdentityProviderInput`](crate::input::UpdateIdentityProviderInput)
    pub fn builder() -> crate::input::update_identity_provider_input::Builder {
        crate::input::update_identity_provider_input::Builder::default()
    }
}

/// See [`UpdateResourceServerInput`](crate::input::UpdateResourceServerInput)
pub mod update_resource_server_input {
    /// A builder for [`UpdateResourceServerInput`](crate::input::UpdateResourceServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) scopes:
            std::option::Option<std::vec::Vec<crate::model::ResourceServerScopeType>>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The identifier for the resource server.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the resource server.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The name of the resource server.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource server.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `scopes`.
        ///
        /// To override the contents of this collection use [`set_scopes`](Self::set_scopes).
        ///
        /// <p>The scope values to be set for the resource server.</p>
        pub fn scopes(mut self, input: crate::model::ResourceServerScopeType) -> Self {
            let mut v = self.scopes.unwrap_or_default();
            v.push(input);
            self.scopes = Some(v);
            self
        }
        /// <p>The scope values to be set for the resource server.</p>
        pub fn set_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceServerScopeType>>,
        ) -> Self {
            self.scopes = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceServerInput`](crate::input::UpdateResourceServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResourceServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResourceServerInput {
                user_pool_id: self.user_pool_id,
                identifier: self.identifier,
                name: self.name,
                scopes: self.scopes,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResourceServerInputOperationOutputAlias = crate::operation::UpdateResourceServer;
#[doc(hidden)]
pub type UpdateResourceServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateResourceServerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResourceServer`](crate::operation::UpdateResourceServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResourceServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResourceServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResourceServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResourceServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.UpdateResourceServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_resource_server(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResourceServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResourceServer",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResourceServerInput`](crate::input::UpdateResourceServerInput)
    pub fn builder() -> crate::input::update_resource_server_input::Builder {
        crate::input::update_resource_server_input::Builder::default()
    }
}

/// See [`UpdateUserAttributesInput`](crate::input::UpdateUserAttributesInput)
pub mod update_user_attributes_input {
    /// A builder for [`UpdateUserAttributesInput`](crate::input::UpdateUserAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_attributes: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        pub(crate) access_token: std::option::Option<std::string::String>,
        pub(crate) client_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `user_attributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn user_attributes(mut self, input: crate::model::AttributeType) -> Self {
            let mut v = self.user_attributes.unwrap_or_default();
            v.push(input);
            self.user_attributes = Some(v);
            self
        }
        /// <p>An array of name-value pairs representing user attributes.</p>
        /// <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeType>>,
        ) -> Self {
            self.user_attributes = input;
            self
        }
        /// <p>The access token for the request to update user attributes.</p>
        pub fn access_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_token = Some(input.into());
            self
        }
        /// <p>The access token for the request to update user attributes.</p>
        pub fn set_access_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_token = input;
            self
        }
        /// Adds a key-value pair to `client_metadata`.
        ///
        /// To override the contents of this collection use [`set_client_metadata`](Self::set_client_metadata).
        ///
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action initiates. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the UpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your UpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn client_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_metadata = Some(hash_map);
            self
        }
        /// <p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action initiates. </p>
        /// <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the UpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your UpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note>
        /// <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:</p>
        /// <ul>
        /// <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.</p> </li>
        /// <li> <p>Validate the ClientMetadata value.</p> </li>
        /// <li> <p>Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_client_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserAttributesInput`](crate::input::UpdateUserAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUserAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUserAttributesInput {
                user_attributes: self.user_attributes,
                access_token: self.access_token,
                client_metadata: self.client_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUserAttributesInputOperationOutputAlias = crate::operation::UpdateUserAttributes;
#[doc(hidden)]
pub type UpdateUserAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateUserAttributesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUserAttributes`](crate::operation::UpdateUserAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUserAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateUserAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateUserAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateUserAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.UpdateUserAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_user_attributes(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_requirements = aws_sig_auth::signer::SigningRequirements::Disabled;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUserAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUserAttributes",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateUserAttributesInput`](crate::input::UpdateUserAttributesInput)
    pub fn builder() -> crate::input::update_user_attributes_input::Builder {
        crate::input::update_user_attributes_input::Builder::default()
    }
}

/// See [`UpdateUserPoolInput`](crate::input::UpdateUserPoolInput)
pub mod update_user_pool_input {
    /// A builder for [`UpdateUserPoolInput`](crate::input::UpdateUserPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) policies: std::option::Option<crate::model::UserPoolPolicyType>,
        pub(crate) lambda_config: std::option::Option<crate::model::LambdaConfigType>,
        pub(crate) auto_verified_attributes:
            std::option::Option<std::vec::Vec<crate::model::VerifiedAttributeType>>,
        pub(crate) sms_verification_message: std::option::Option<std::string::String>,
        pub(crate) email_verification_message: std::option::Option<std::string::String>,
        pub(crate) email_verification_subject: std::option::Option<std::string::String>,
        pub(crate) verification_message_template:
            std::option::Option<crate::model::VerificationMessageTemplateType>,
        pub(crate) sms_authentication_message: std::option::Option<std::string::String>,
        pub(crate) mfa_configuration: std::option::Option<crate::model::UserPoolMfaType>,
        pub(crate) device_configuration: std::option::Option<crate::model::DeviceConfigurationType>,
        pub(crate) email_configuration: std::option::Option<crate::model::EmailConfigurationType>,
        pub(crate) sms_configuration: std::option::Option<crate::model::SmsConfigurationType>,
        pub(crate) user_pool_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) admin_create_user_config:
            std::option::Option<crate::model::AdminCreateUserConfigType>,
        pub(crate) user_pool_add_ons: std::option::Option<crate::model::UserPoolAddOnsType>,
        pub(crate) account_recovery_setting:
            std::option::Option<crate::model::AccountRecoverySettingType>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool you want to update.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool you want to update.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>A container with the policies you want to update in a user pool.</p>
        pub fn policies(mut self, input: crate::model::UserPoolPolicyType) -> Self {
            self.policies = Some(input);
            self
        }
        /// <p>A container with the policies you want to update in a user pool.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<crate::model::UserPoolPolicyType>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>The Lambda configuration information from the request to update the user pool.</p>
        pub fn lambda_config(mut self, input: crate::model::LambdaConfigType) -> Self {
            self.lambda_config = Some(input);
            self
        }
        /// <p>The Lambda configuration information from the request to update the user pool.</p>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaConfigType>,
        ) -> Self {
            self.lambda_config = input;
            self
        }
        /// Appends an item to `auto_verified_attributes`.
        ///
        /// To override the contents of this collection use [`set_auto_verified_attributes`](Self::set_auto_verified_attributes).
        ///
        /// <p>The attributes that are automatically verified when Amazon Cognito requests to update user pools.</p>
        pub fn auto_verified_attributes(
            mut self,
            input: crate::model::VerifiedAttributeType,
        ) -> Self {
            let mut v = self.auto_verified_attributes.unwrap_or_default();
            v.push(input);
            self.auto_verified_attributes = Some(v);
            self
        }
        /// <p>The attributes that are automatically verified when Amazon Cognito requests to update user pools.</p>
        pub fn set_auto_verified_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VerifiedAttributeType>>,
        ) -> Self {
            self.auto_verified_attributes = input;
            self
        }
        /// <p>A container with information about the SMS verification message.</p>
        pub fn sms_verification_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_verification_message = Some(input.into());
            self
        }
        /// <p>A container with information about the SMS verification message.</p>
        pub fn set_sms_verification_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sms_verification_message = input;
            self
        }
        /// <p>The contents of the email verification message.</p>
        pub fn email_verification_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_verification_message = Some(input.into());
            self
        }
        /// <p>The contents of the email verification message.</p>
        pub fn set_email_verification_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_verification_message = input;
            self
        }
        /// <p>The subject of the email verification message.</p>
        pub fn email_verification_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_verification_subject = Some(input.into());
            self
        }
        /// <p>The subject of the email verification message.</p>
        pub fn set_email_verification_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_verification_subject = input;
            self
        }
        /// <p>The template for verification messages.</p>
        pub fn verification_message_template(
            mut self,
            input: crate::model::VerificationMessageTemplateType,
        ) -> Self {
            self.verification_message_template = Some(input);
            self
        }
        /// <p>The template for verification messages.</p>
        pub fn set_verification_message_template(
            mut self,
            input: std::option::Option<crate::model::VerificationMessageTemplateType>,
        ) -> Self {
            self.verification_message_template = input;
            self
        }
        /// <p>The contents of the SMS authentication message.</p>
        pub fn sms_authentication_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.sms_authentication_message = Some(input.into());
            self
        }
        /// <p>The contents of the SMS authentication message.</p>
        pub fn set_sms_authentication_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sms_authentication_message = input;
            self
        }
        /// <p>Can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> - MFA tokens aren't required and can't be specified during user registration.</p> </li>
        /// <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify ON when you're initially creating a user pool. You can use the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html">SetUserPoolMfaConfig</a> API operation to turn MFA "ON" for existing user pools. </p> </li>
        /// <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li>
        /// </ul>
        pub fn mfa_configuration(mut self, input: crate::model::UserPoolMfaType) -> Self {
            self.mfa_configuration = Some(input);
            self
        }
        /// <p>Can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>OFF</code> - MFA tokens aren't required and can't be specified during user registration.</p> </li>
        /// <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify ON when you're initially creating a user pool. You can use the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html">SetUserPoolMfaConfig</a> API operation to turn MFA "ON" for existing user pools. </p> </li>
        /// <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li>
        /// </ul>
        pub fn set_mfa_configuration(
            mut self,
            input: std::option::Option<crate::model::UserPoolMfaType>,
        ) -> Self {
            self.mfa_configuration = input;
            self
        }
        /// <p>Device configuration.</p>
        pub fn device_configuration(
            mut self,
            input: crate::model::DeviceConfigurationType,
        ) -> Self {
            self.device_configuration = Some(input);
            self
        }
        /// <p>Device configuration.</p>
        pub fn set_device_configuration(
            mut self,
            input: std::option::Option<crate::model::DeviceConfigurationType>,
        ) -> Self {
            self.device_configuration = input;
            self
        }
        /// <p>Email configuration.</p>
        pub fn email_configuration(mut self, input: crate::model::EmailConfigurationType) -> Self {
            self.email_configuration = Some(input);
            self
        }
        /// <p>Email configuration.</p>
        pub fn set_email_configuration(
            mut self,
            input: std::option::Option<crate::model::EmailConfigurationType>,
        ) -> Self {
            self.email_configuration = input;
            self
        }
        /// <p>SMS configuration.</p>
        pub fn sms_configuration(mut self, input: crate::model::SmsConfigurationType) -> Self {
            self.sms_configuration = Some(input);
            self
        }
        /// <p>SMS configuration.</p>
        pub fn set_sms_configuration(
            mut self,
            input: std::option::Option<crate::model::SmsConfigurationType>,
        ) -> Self {
            self.sms_configuration = input;
            self
        }
        /// Adds a key-value pair to `user_pool_tags`.
        ///
        /// To override the contents of this collection use [`set_user_pool_tags`](Self::set_user_pool_tags).
        ///
        /// <p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn user_pool_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.user_pool_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.user_pool_tags = Some(hash_map);
            self
        }
        /// <p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>
        pub fn set_user_pool_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.user_pool_tags = input;
            self
        }
        /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
        pub fn admin_create_user_config(
            mut self,
            input: crate::model::AdminCreateUserConfigType,
        ) -> Self {
            self.admin_create_user_config = Some(input);
            self
        }
        /// <p>The configuration for <code>AdminCreateUser</code> requests.</p>
        pub fn set_admin_create_user_config(
            mut self,
            input: std::option::Option<crate::model::AdminCreateUserConfigType>,
        ) -> Self {
            self.admin_create_user_config = input;
            self
        }
        /// <p>Enables advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>
        pub fn user_pool_add_ons(mut self, input: crate::model::UserPoolAddOnsType) -> Self {
            self.user_pool_add_ons = Some(input);
            self
        }
        /// <p>Enables advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>
        pub fn set_user_pool_add_ons(
            mut self,
            input: std::option::Option<crate::model::UserPoolAddOnsType>,
        ) -> Self {
            self.user_pool_add_ons = input;
            self
        }
        /// <p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>
        pub fn account_recovery_setting(
            mut self,
            input: crate::model::AccountRecoverySettingType,
        ) -> Self {
            self.account_recovery_setting = Some(input);
            self
        }
        /// <p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>
        pub fn set_account_recovery_setting(
            mut self,
            input: std::option::Option<crate::model::AccountRecoverySettingType>,
        ) -> Self {
            self.account_recovery_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserPoolInput`](crate::input::UpdateUserPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUserPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUserPoolInput {
                user_pool_id: self.user_pool_id,
                policies: self.policies,
                lambda_config: self.lambda_config,
                auto_verified_attributes: self.auto_verified_attributes,
                sms_verification_message: self.sms_verification_message,
                email_verification_message: self.email_verification_message,
                email_verification_subject: self.email_verification_subject,
                verification_message_template: self.verification_message_template,
                sms_authentication_message: self.sms_authentication_message,
                mfa_configuration: self.mfa_configuration,
                device_configuration: self.device_configuration,
                email_configuration: self.email_configuration,
                sms_configuration: self.sms_configuration,
                user_pool_tags: self.user_pool_tags,
                admin_create_user_config: self.admin_create_user_config,
                user_pool_add_ons: self.user_pool_add_ons,
                account_recovery_setting: self.account_recovery_setting,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUserPoolInputOperationOutputAlias = crate::operation::UpdateUserPool;
#[doc(hidden)]
pub type UpdateUserPoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateUserPoolInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUserPool`](crate::operation::UpdateUserPool)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUserPool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateUserPoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateUserPoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateUserPoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.UpdateUserPool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_user_pool(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUserPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUserPool",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateUserPoolInput`](crate::input::UpdateUserPoolInput)
    pub fn builder() -> crate::input::update_user_pool_input::Builder {
        crate::input::update_user_pool_input::Builder::default()
    }
}

/// See [`UpdateUserPoolClientInput`](crate::input::UpdateUserPoolClientInput)
pub mod update_user_pool_client_input {
    /// A builder for [`UpdateUserPoolClientInput`](crate::input::UpdateUserPoolClientInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_name: std::option::Option<std::string::String>,
        pub(crate) refresh_token_validity: std::option::Option<i32>,
        pub(crate) access_token_validity: std::option::Option<i32>,
        pub(crate) id_token_validity: std::option::Option<i32>,
        pub(crate) token_validity_units: std::option::Option<crate::model::TokenValidityUnitsType>,
        pub(crate) read_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) write_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) explicit_auth_flows:
            std::option::Option<std::vec::Vec<crate::model::ExplicitAuthFlowsType>>,
        pub(crate) supported_identity_providers:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) callback_ur_ls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) logout_ur_ls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_redirect_uri: std::option::Option<std::string::String>,
        pub(crate) allowed_o_auth_flows:
            std::option::Option<std::vec::Vec<crate::model::OAuthFlowType>>,
        pub(crate) allowed_o_auth_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) allowed_o_auth_flows_user_pool_client: std::option::Option<bool>,
        pub(crate) analytics_configuration:
            std::option::Option<crate::model::AnalyticsConfigurationType>,
        pub(crate) prevent_user_existence_errors:
            std::option::Option<crate::model::PreventUserExistenceErrorTypes>,
        pub(crate) enable_token_revocation: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The user pool ID for the user pool where you want to update the user pool client.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID for the user pool where you want to update the user pool client.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The ID of the client associated with the user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The client name from the update user pool client request.</p>
        pub fn client_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_name = Some(input.into());
            self
        }
        /// <p>The client name from the update user pool client request.</p>
        pub fn set_client_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_name = input;
            self
        }
        /// <p>The time limit, in days, after which the refresh token is no longer valid and can't be used.</p>
        pub fn refresh_token_validity(mut self, input: i32) -> Self {
            self.refresh_token_validity = Some(input);
            self
        }
        /// <p>The time limit, in days, after which the refresh token is no longer valid and can't be used.</p>
        pub fn set_refresh_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.refresh_token_validity = input;
            self
        }
        /// <p>The time limit after which the access token is no longer valid and can't be used.</p>
        pub fn access_token_validity(mut self, input: i32) -> Self {
            self.access_token_validity = Some(input);
            self
        }
        /// <p>The time limit after which the access token is no longer valid and can't be used.</p>
        pub fn set_access_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.access_token_validity = input;
            self
        }
        /// <p>The time limit after which the ID token is no longer valid and can't be used.</p>
        pub fn id_token_validity(mut self, input: i32) -> Self {
            self.id_token_validity = Some(input);
            self
        }
        /// <p>The time limit after which the ID token is no longer valid and can't be used.</p>
        pub fn set_id_token_validity(mut self, input: std::option::Option<i32>) -> Self {
            self.id_token_validity = input;
            self
        }
        /// <p>The units in which the validity times are represented. Default for RefreshToken is days, and default for ID and access tokens is hours.</p>
        pub fn token_validity_units(mut self, input: crate::model::TokenValidityUnitsType) -> Self {
            self.token_validity_units = Some(input);
            self
        }
        /// <p>The units in which the validity times are represented. Default for RefreshToken is days, and default for ID and access tokens is hours.</p>
        pub fn set_token_validity_units(
            mut self,
            input: std::option::Option<crate::model::TokenValidityUnitsType>,
        ) -> Self {
            self.token_validity_units = input;
            self
        }
        /// Appends an item to `read_attributes`.
        ///
        /// To override the contents of this collection use [`set_read_attributes`](Self::set_read_attributes).
        ///
        /// <p>The read-only attributes of the user pool.</p>
        pub fn read_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.read_attributes.unwrap_or_default();
            v.push(input.into());
            self.read_attributes = Some(v);
            self
        }
        /// <p>The read-only attributes of the user pool.</p>
        pub fn set_read_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.read_attributes = input;
            self
        }
        /// Appends an item to `write_attributes`.
        ///
        /// To override the contents of this collection use [`set_write_attributes`](Self::set_write_attributes).
        ///
        /// <p>The writeable attributes of the user pool.</p>
        pub fn write_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.write_attributes.unwrap_or_default();
            v.push(input.into());
            self.write_attributes = Some(v);
            self
        }
        /// <p>The writeable attributes of the user pool.</p>
        pub fn set_write_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.write_attributes = input;
            self
        }
        /// Appends an item to `explicit_auth_flows`.
        ///
        /// To override the contents of this collection use [`set_explicit_auth_flows`](Self::set_explicit_auth_flows).
        ///
        /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are no longer supported in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix must be used only along with values with the <code>ALLOW_</code> prefix.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
        /// </ul>
        pub fn explicit_auth_flows(mut self, input: crate::model::ExplicitAuthFlowsType) -> Self {
            let mut v = self.explicit_auth_flows.unwrap_or_default();
            v.push(input);
            self.explicit_auth_flows = Some(v);
            self
        }
        /// <p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are no longer supported in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix must be used only along with values with the <code>ALLOW_</code> prefix.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li>
        /// <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li>
        /// <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li>
        /// </ul>
        pub fn set_explicit_auth_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExplicitAuthFlowsType>>,
        ) -> Self {
            self.explicit_auth_flows = input;
            self
        }
        /// Appends an item to `supported_identity_providers`.
        ///
        /// To override the contents of this collection use [`set_supported_identity_providers`](Self::set_supported_identity_providers).
        ///
        /// <p>A list of provider names for the identity providers that are supported on this client.</p>
        pub fn supported_identity_providers(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.supported_identity_providers.unwrap_or_default();
            v.push(input.into());
            self.supported_identity_providers = Some(v);
            self
        }
        /// <p>A list of provider names for the identity providers that are supported on this client.</p>
        pub fn set_supported_identity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_identity_providers = input;
            self
        }
        /// Appends an item to `callback_ur_ls`.
        ///
        /// To override the contents of this collection use [`set_callback_ur_ls`](Self::set_callback_ur_ls).
        ///
        /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as <code>myapp://example</code> are also supported.</p>
        pub fn callback_ur_ls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.callback_ur_ls.unwrap_or_default();
            v.push(input.into());
            self.callback_ur_ls = Some(v);
            self
        }
        /// <p>A list of allowed redirect (callback) URLs for the identity providers.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p>
        /// <p>App callback URLs such as <code>myapp://example</code> are also supported.</p>
        pub fn set_callback_ur_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.callback_ur_ls = input;
            self
        }
        /// Appends an item to `logout_ur_ls`.
        ///
        /// To override the contents of this collection use [`set_logout_ur_ls`](Self::set_logout_ur_ls).
        ///
        /// <p>A list of allowed logout URLs for the identity providers.</p>
        pub fn logout_ur_ls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.logout_ur_ls.unwrap_or_default();
            v.push(input.into());
            self.logout_ur_ls = Some(v);
            self
        }
        /// <p>A list of allowed logout URLs for the identity providers.</p>
        pub fn set_logout_ur_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.logout_ur_ls = input;
            self
        }
        /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for <code>http://localhost</code> for testing purposes only.</p>
        /// <p>App callback URLs such as <code>myapp://example</code> are also supported.</p>
        pub fn default_redirect_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_redirect_uri = Some(input.into());
            self
        }
        /// <p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
        /// <p>A redirect URI must:</p>
        /// <ul>
        /// <li> <p>Be an absolute URI.</p> </li>
        /// <li> <p>Be registered with the authorization server.</p> </li>
        /// <li> <p>Not include a fragment component.</p> </li>
        /// </ul>
        /// <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p>
        /// <p>Amazon Cognito requires HTTPS over HTTP except for <code>http://localhost</code> for testing purposes only.</p>
        /// <p>App callback URLs such as <code>myapp://example</code> are also supported.</p>
        pub fn set_default_redirect_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_redirect_uri = input;
            self
        }
        /// Appends an item to `allowed_o_auth_flows`.
        ///
        /// To override the contents of this collection use [`set_allowed_o_auth_flows`](Self::set_allowed_o_auth_flows).
        ///
        /// <p>The allowed OAuth flows.</p>
        /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
        /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
        /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
        pub fn allowed_o_auth_flows(mut self, input: crate::model::OAuthFlowType) -> Self {
            let mut v = self.allowed_o_auth_flows.unwrap_or_default();
            v.push(input);
            self.allowed_o_auth_flows = Some(v);
            self
        }
        /// <p>The allowed OAuth flows.</p>
        /// <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p>
        /// <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p>
        /// <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>
        pub fn set_allowed_o_auth_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OAuthFlowType>>,
        ) -> Self {
            self.allowed_o_auth_flows = input;
            self
        }
        /// Appends an item to `allowed_o_auth_scopes`.
        ///
        /// To override the contents of this collection use [`set_allowed_o_auth_scopes`](Self::set_allowed_o_auth_scopes).
        ///
        /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
        pub fn allowed_o_auth_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_o_auth_scopes.unwrap_or_default();
            v.push(input.into());
            self.allowed_o_auth_scopes = Some(v);
            self
        }
        /// <p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>
        pub fn set_allowed_o_auth_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_o_auth_scopes = input;
            self
        }
        /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.</p>
        pub fn allowed_o_auth_flows_user_pool_client(mut self, input: bool) -> Self {
            self.allowed_o_auth_flows_user_pool_client = Some(input);
            self
        }
        /// <p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.</p>
        pub fn set_allowed_o_auth_flows_user_pool_client(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allowed_o_auth_flows_user_pool_client = input;
            self
        }
        /// <p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note>
        /// <p>In Amazon Web Services Regions where isn't available, User Pools only supports sending events to Amazon Pinpoint projects in us-east-1. In Regions where Pinpoint is available, User Pools will support sending events to Amazon Pinpoint projects within that same Region. </p>
        /// </note>
        pub fn analytics_configuration(
            mut self,
            input: crate::model::AnalyticsConfigurationType,
        ) -> Self {
            self.analytics_configuration = Some(input);
            self
        }
        /// <p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note>
        /// <p>In Amazon Web Services Regions where isn't available, User Pools only supports sending events to Amazon Pinpoint projects in us-east-1. In Regions where Pinpoint is available, User Pools will support sending events to Amazon Pinpoint projects within that same Region. </p>
        /// </note>
        pub fn set_analytics_configuration(
            mut self,
            input: std::option::Option<crate::model::AnalyticsConfigurationType>,
        ) -> Self {
            self.analytics_configuration = input;
            self
        }
        /// <p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
        /// <li> <p> <code>LEGACY</code> - This represents the early behavior of Amazon Cognito where user existence related errors aren't prevented.</p> </li>
        /// </ul>
        pub fn prevent_user_existence_errors(
            mut self,
            input: crate::model::PreventUserExistenceErrorTypes,
        ) -> Self {
            self.prevent_user_existence_errors = Some(input);
            self
        }
        /// <p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to <code>ENABLED</code> and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn't exist in the user pool.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li>
        /// <li> <p> <code>LEGACY</code> - This represents the early behavior of Amazon Cognito where user existence related errors aren't prevented.</p> </li>
        /// </ul>
        pub fn set_prevent_user_existence_errors(
            mut self,
            input: std::option::Option<crate::model::PreventUserExistenceErrorTypes>,
        ) -> Self {
            self.prevent_user_existence_errors = input;
            self
        }
        /// <p>Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
        pub fn enable_token_revocation(mut self, input: bool) -> Self {
            self.enable_token_revocation = Some(input);
            self
        }
        /// <p>Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>
        pub fn set_enable_token_revocation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_token_revocation = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserPoolClientInput`](crate::input::UpdateUserPoolClientInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUserPoolClientInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUserPoolClientInput {
                user_pool_id: self.user_pool_id,
                client_id: self.client_id,
                client_name: self.client_name,
                refresh_token_validity: self.refresh_token_validity.unwrap_or_default(),
                access_token_validity: self.access_token_validity,
                id_token_validity: self.id_token_validity,
                token_validity_units: self.token_validity_units,
                read_attributes: self.read_attributes,
                write_attributes: self.write_attributes,
                explicit_auth_flows: self.explicit_auth_flows,
                supported_identity_providers: self.supported_identity_providers,
                callback_ur_ls: self.callback_ur_ls,
                logout_ur_ls: self.logout_ur_ls,
                default_redirect_uri: self.default_redirect_uri,
                allowed_o_auth_flows: self.allowed_o_auth_flows,
                allowed_o_auth_scopes: self.allowed_o_auth_scopes,
                allowed_o_auth_flows_user_pool_client: self
                    .allowed_o_auth_flows_user_pool_client
                    .unwrap_or_default(),
                analytics_configuration: self.analytics_configuration,
                prevent_user_existence_errors: self.prevent_user_existence_errors,
                enable_token_revocation: self.enable_token_revocation,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUserPoolClientInputOperationOutputAlias = crate::operation::UpdateUserPoolClient;
#[doc(hidden)]
pub type UpdateUserPoolClientInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateUserPoolClientInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUserPoolClient`](crate::operation::UpdateUserPoolClient)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUserPoolClient,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateUserPoolClientInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateUserPoolClientInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateUserPoolClientInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSCognitoIdentityProviderService.UpdateUserPoolClient",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_user_pool_client(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUserPoolClient::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUserPoolClient",
            "cognitoidentityprovider",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateUserPoolClientInput`](crate::input::UpdateUserPoolClientInput)
    pub fn builder() -> crate::input::update_user_pool_client_input::Builder {
        crate::input::update_user_pool_client_input::Builder::default()
    }
}

/// See [`UpdateUserPoolDomainInput`](crate::input::UpdateUserPoolDomainInput)
pub mod update_user_pool_domain_input {
    /// A builder for [`UpdateUserPoolDomainInput`](crate::input::UpdateUserPoolDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) custom_domain_config: std::option::Option<crate::model::CustomDomainConfigType>,
    }
    impl Builder {
        /// <p>The domain name for the custom domain that hosts the sign-up and sign-in pages for your application. One example might be <code>auth.example.com</code>. </p>
        /// <p>This string can include only lowercase letters, numbers, and hyphens. Don't use a hyphen for the first or last character. Use periods to separate subdomain names.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain name for the custom domain that hosts the sign-up and sign-in pages for your application. One example might be <code>auth.example.com</code>. </p>
        /// <p>This string can include only lowercase letters, numbers, and hyphens. Don't use a hyphen for the first or last character. Use periods to separate subdomain names.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String