// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_custom_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddCustomAttributesOutput,
    crate::error::AddCustomAttributesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddCustomAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddCustomAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AddCustomAttributesError {
            meta: generic,
            kind: crate::error::AddCustomAttributesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AddCustomAttributesError {
            meta: generic,
            kind: crate::error::AddCustomAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AddCustomAttributesError {
            meta: generic,
            kind: crate::error::AddCustomAttributesErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AddCustomAttributesError {
            meta: generic,
            kind: crate::error::AddCustomAttributesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AddCustomAttributesError {
            meta: generic,
            kind: crate::error::AddCustomAttributesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserImportInProgressException" => crate::error::AddCustomAttributesError {
            meta: generic,
            kind: crate::error::AddCustomAttributesErrorKind::UserImportInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_import_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_import_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddCustomAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_custom_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddCustomAttributesOutput,
    crate::error::AddCustomAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_custom_attributes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_add_user_to_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminAddUserToGroupOutput,
    crate::error::AdminAddUserToGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminAddUserToGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminAddUserToGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminAddUserToGroupError {
            meta: generic,
            kind: crate::error::AdminAddUserToGroupErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminAddUserToGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminAddUserToGroupError {
            meta: generic,
            kind: crate::error::AdminAddUserToGroupErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminAddUserToGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminAddUserToGroupError {
            meta: generic,
            kind: crate::error::AdminAddUserToGroupErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminAddUserToGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminAddUserToGroupError {
            meta: generic,
            kind: crate::error::AdminAddUserToGroupErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminAddUserToGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminAddUserToGroupError {
            meta: generic,
            kind: crate::error::AdminAddUserToGroupErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminAddUserToGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminAddUserToGroupError {
            meta: generic,
            kind: crate::error::AdminAddUserToGroupErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminAddUserToGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminAddUserToGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_add_user_to_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminAddUserToGroupOutput,
    crate::error::AdminAddUserToGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_add_user_to_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_confirm_sign_up_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminConfirmSignUpOutput,
    crate::error::AdminConfirmSignUpError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminConfirmSignUpError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminConfirmSignUpError {
            meta: generic,
            kind: crate::error::AdminConfirmSignUpErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLambdaResponseException" => crate::error::AdminConfirmSignUpError {
            meta: generic,
            kind: crate::error::AdminConfirmSignUpErrorKind::InvalidLambdaResponseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminConfirmSignUpError {
            meta: generic,
            kind: crate::error::AdminConfirmSignUpErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::AdminConfirmSignUpError {
            meta: generic,
            kind: crate::error::AdminConfirmSignUpErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminConfirmSignUpError {
            meta: generic,
            kind: crate::error::AdminConfirmSignUpErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminConfirmSignUpError {
            meta: generic,
            kind: crate::error::AdminConfirmSignUpErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyFailedAttemptsException" => crate::error::AdminConfirmSignUpError {
            meta: generic,
            kind: crate::error::AdminConfirmSignUpErrorKind::TooManyFailedAttemptsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_failed_attempts_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_failed_attempts_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminConfirmSignUpError {
            meta: generic,
            kind: crate::error::AdminConfirmSignUpErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnexpectedLambdaException" => crate::error::AdminConfirmSignUpError {
            meta: generic,
            kind: crate::error::AdminConfirmSignUpErrorKind::UnexpectedLambdaException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserLambdaValidationException" => crate::error::AdminConfirmSignUpError {
            meta: generic,
            kind: crate::error::AdminConfirmSignUpErrorKind::UserLambdaValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminConfirmSignUpError {
            meta: generic,
            kind: crate::error::AdminConfirmSignUpErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminConfirmSignUpError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_confirm_sign_up_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminConfirmSignUpOutput,
    crate::error::AdminConfirmSignUpError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_confirm_sign_up_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_create_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminCreateUserOutput, crate::error::AdminCreateUserError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminCreateUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminCreateUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeDeliveryFailureException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::CodeDeliveryFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_delivery_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_delivery_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLambdaResponseException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::InvalidLambdaResponseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPasswordException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::InvalidPasswordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_password_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_password_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSmsRoleAccessPolicyException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::InvalidSmsRoleAccessPolicyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSmsRoleTrustRelationshipException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::InvalidSmsRoleTrustRelationshipException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotAuthorizedException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionNotMetException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::PreconditionNotMetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_not_met_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_not_met_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnexpectedLambdaException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::UnexpectedLambdaException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedUserStateException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::UnsupportedUserStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_user_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_user_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserLambdaValidationException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::UserLambdaValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UsernameExistsException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::UsernameExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::username_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_username_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminCreateUserError {
            meta: generic,
            kind: crate::error::AdminCreateUserErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminCreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminCreateUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_create_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminCreateUserOutput, crate::error::AdminCreateUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_create_user_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_admin_create_user(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AdminCreateUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_delete_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminDeleteUserOutput, crate::error::AdminDeleteUserError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminDeleteUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminDeleteUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminDeleteUserError {
            meta: generic,
            kind: crate::error::AdminDeleteUserErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminDeleteUserError {
            meta: generic,
            kind: crate::error::AdminDeleteUserErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminDeleteUserError {
            meta: generic,
            kind: crate::error::AdminDeleteUserErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminDeleteUserError {
            meta: generic,
            kind: crate::error::AdminDeleteUserErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminDeleteUserError {
            meta: generic,
            kind: crate::error::AdminDeleteUserErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminDeleteUserError {
            meta: generic,
            kind: crate::error::AdminDeleteUserErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminDeleteUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_delete_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminDeleteUserOutput, crate::error::AdminDeleteUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_delete_user_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_delete_user_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminDeleteUserAttributesOutput,
    crate::error::AdminDeleteUserAttributesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminDeleteUserAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminDeleteUserAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminDeleteUserAttributesError {
            meta: generic,
            kind: crate::error::AdminDeleteUserAttributesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminDeleteUserAttributesError {
            meta: generic,
            kind: crate::error::AdminDeleteUserAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminDeleteUserAttributesError {
            meta: generic,
            kind: crate::error::AdminDeleteUserAttributesErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminDeleteUserAttributesError {
            meta: generic,
            kind: crate::error::AdminDeleteUserAttributesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminDeleteUserAttributesError {
            meta: generic,
            kind: crate::error::AdminDeleteUserAttributesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminDeleteUserAttributesError {
            meta: generic,
            kind: crate::error::AdminDeleteUserAttributesErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminDeleteUserAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_delete_user_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminDeleteUserAttributesOutput,
    crate::error::AdminDeleteUserAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_delete_user_attributes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_disable_provider_for_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminDisableProviderForUserOutput,
    crate::error::AdminDisableProviderForUserError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminDisableProviderForUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminDisableProviderForUserError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AliasExistsException" => crate::error::AdminDisableProviderForUserError {
            meta: generic,
            kind: crate::error::AdminDisableProviderForUserErrorKind::AliasExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::alias_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_alias_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::AdminDisableProviderForUserError {
            meta: generic,
            kind: crate::error::AdminDisableProviderForUserErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminDisableProviderForUserError {
            meta: generic,
            kind: crate::error::AdminDisableProviderForUserErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminDisableProviderForUserError {
            meta: generic,
            kind: crate::error::AdminDisableProviderForUserErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminDisableProviderForUserError {
            meta: generic,
            kind: crate::error::AdminDisableProviderForUserErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminDisableProviderForUserError {
            meta: generic,
            kind: crate::error::AdminDisableProviderForUserErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminDisableProviderForUserError {
            meta: generic,
            kind: crate::error::AdminDisableProviderForUserErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminDisableProviderForUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_disable_provider_for_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminDisableProviderForUserOutput,
    crate::error::AdminDisableProviderForUserError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_disable_provider_for_user_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_disable_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminDisableUserOutput, crate::error::AdminDisableUserError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminDisableUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminDisableUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminDisableUserError {
            meta: generic,
            kind: crate::error::AdminDisableUserErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminDisableUserError {
            meta: generic,
            kind: crate::error::AdminDisableUserErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminDisableUserError {
            meta: generic,
            kind: crate::error::AdminDisableUserErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminDisableUserError {
            meta: generic,
            kind: crate::error::AdminDisableUserErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminDisableUserError {
            meta: generic,
            kind: crate::error::AdminDisableUserErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminDisableUserError {
            meta: generic,
            kind: crate::error::AdminDisableUserErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminDisableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminDisableUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_disable_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminDisableUserOutput, crate::error::AdminDisableUserError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_disable_user_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_enable_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminEnableUserOutput, crate::error::AdminEnableUserError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminEnableUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminEnableUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminEnableUserError {
            meta: generic,
            kind: crate::error::AdminEnableUserErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminEnableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminEnableUserError {
            meta: generic,
            kind: crate::error::AdminEnableUserErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminEnableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminEnableUserError {
            meta: generic,
            kind: crate::error::AdminEnableUserErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminEnableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminEnableUserError {
            meta: generic,
            kind: crate::error::AdminEnableUserErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminEnableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminEnableUserError {
            meta: generic,
            kind: crate::error::AdminEnableUserErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminEnableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminEnableUserError {
            meta: generic,
            kind: crate::error::AdminEnableUserErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminEnableUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminEnableUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_enable_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminEnableUserOutput, crate::error::AdminEnableUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_enable_user_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_forget_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminForgetDeviceOutput, crate::error::AdminForgetDeviceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminForgetDeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminForgetDeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminForgetDeviceError {
            meta: generic,
            kind: crate::error::AdminForgetDeviceErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminForgetDeviceError {
            meta: generic,
            kind: crate::error::AdminForgetDeviceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserPoolConfigurationException" => crate::error::AdminForgetDeviceError {
            meta: generic,
            kind: crate::error::AdminForgetDeviceErrorKind::InvalidUserPoolConfigurationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_user_pool_configuration_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminForgetDeviceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotAuthorizedException" => crate::error::AdminForgetDeviceError {
            meta: generic,
            kind: crate::error::AdminForgetDeviceErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminForgetDeviceError {
            meta: generic,
            kind: crate::error::AdminForgetDeviceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminForgetDeviceError {
            meta: generic,
            kind: crate::error::AdminForgetDeviceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminForgetDeviceError {
            meta: generic,
            kind: crate::error::AdminForgetDeviceErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminForgetDeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_forget_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminForgetDeviceOutput, crate::error::AdminForgetDeviceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_forget_device_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_get_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminGetDeviceOutput, crate::error::AdminGetDeviceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminGetDeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminGetDeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminGetDeviceError {
            meta: generic,
            kind: crate::error::AdminGetDeviceErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminGetDeviceError {
            meta: generic,
            kind: crate::error::AdminGetDeviceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserPoolConfigurationException" => crate::error::AdminGetDeviceError {
            meta: generic,
            kind: crate::error::AdminGetDeviceErrorKind::InvalidUserPoolConfigurationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_user_pool_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminGetDeviceError {
            meta: generic,
            kind: crate::error::AdminGetDeviceErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminGetDeviceError {
            meta: generic,
            kind: crate::error::AdminGetDeviceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminGetDeviceError {
            meta: generic,
            kind: crate::error::AdminGetDeviceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminGetDeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_get_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminGetDeviceOutput, crate::error::AdminGetDeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_get_device_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_admin_get_device(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AdminGetDeviceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_get_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminGetUserOutput, crate::error::AdminGetUserError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminGetUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminGetUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminGetUserError {
            meta: generic,
            kind: crate::error::AdminGetUserErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminGetUserError {
            meta: generic,
            kind: crate::error::AdminGetUserErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminGetUserError {
            meta: generic,
            kind: crate::error::AdminGetUserErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminGetUserError {
            meta: generic,
            kind: crate::error::AdminGetUserErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminGetUserError {
            meta: generic,
            kind: crate::error::AdminGetUserErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminGetUserError {
            meta: generic,
            kind: crate::error::AdminGetUserErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminGetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminGetUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_get_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminGetUserOutput, crate::error::AdminGetUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_get_user_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_admin_get_user(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AdminGetUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_initiate_auth_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminInitiateAuthOutput, crate::error::AdminInitiateAuthError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminInitiateAuthError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminInitiateAuthError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLambdaResponseException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::InvalidLambdaResponseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSmsRoleAccessPolicyException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::InvalidSmsRoleAccessPolicyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSmsRoleTrustRelationshipException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind:
                crate::error::AdminInitiateAuthErrorKind::InvalidSmsRoleTrustRelationshipException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidUserPoolConfigurationException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::InvalidUserPoolConfigurationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_user_pool_configuration_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "MFAMethodNotFoundException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::MfaMethodNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::mfa_method_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_mfa_method_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnexpectedLambdaException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::UnexpectedLambdaException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserLambdaValidationException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::UserLambdaValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminInitiateAuthError {
            meta: generic,
            kind: crate::error::AdminInitiateAuthErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminInitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminInitiateAuthError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_initiate_auth_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminInitiateAuthOutput, crate::error::AdminInitiateAuthError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_initiate_auth_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_admin_initiate_auth(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AdminInitiateAuthError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_link_provider_for_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminLinkProviderForUserOutput,
    crate::error::AdminLinkProviderForUserError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminLinkProviderForUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminLinkProviderForUserError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AliasExistsException" => crate::error::AdminLinkProviderForUserError {
            meta: generic,
            kind: crate::error::AdminLinkProviderForUserErrorKind::AliasExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::alias_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_alias_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminLinkProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::AdminLinkProviderForUserError {
            meta: generic,
            kind: crate::error::AdminLinkProviderForUserErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminLinkProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminLinkProviderForUserError {
            meta: generic,
            kind: crate::error::AdminLinkProviderForUserErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminLinkProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::AdminLinkProviderForUserError {
            meta: generic,
            kind: crate::error::AdminLinkProviderForUserErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminLinkProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminLinkProviderForUserError {
            meta: generic,
            kind: crate::error::AdminLinkProviderForUserErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminLinkProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminLinkProviderForUserError {
            meta: generic,
            kind: crate::error::AdminLinkProviderForUserErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminLinkProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminLinkProviderForUserError {
            meta: generic,
            kind: crate::error::AdminLinkProviderForUserErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminLinkProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminLinkProviderForUserError {
            meta: generic,
            kind: crate::error::AdminLinkProviderForUserErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminLinkProviderForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminLinkProviderForUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_link_provider_for_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminLinkProviderForUserOutput,
    crate::error::AdminLinkProviderForUserError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_link_provider_for_user_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_list_devices_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminListDevicesOutput, crate::error::AdminListDevicesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminListDevicesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminListDevicesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminListDevicesError {
            meta: generic,
            kind: crate::error::AdminListDevicesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminListDevicesError {
            meta: generic,
            kind: crate::error::AdminListDevicesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserPoolConfigurationException" => crate::error::AdminListDevicesError {
            meta: generic,
            kind: crate::error::AdminListDevicesErrorKind::InvalidUserPoolConfigurationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_user_pool_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminListDevicesError {
            meta: generic,
            kind: crate::error::AdminListDevicesErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminListDevicesError {
            meta: generic,
            kind: crate::error::AdminListDevicesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminListDevicesError {
            meta: generic,
            kind: crate::error::AdminListDevicesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminListDevicesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_list_devices_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AdminListDevicesOutput, crate::error::AdminListDevicesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_list_devices_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_admin_list_devices(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AdminListDevicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_list_groups_for_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminListGroupsForUserOutput,
    crate::error::AdminListGroupsForUserError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminListGroupsForUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminListGroupsForUserError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminListGroupsForUserError {
            meta: generic,
            kind: crate::error::AdminListGroupsForUserErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListGroupsForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminListGroupsForUserError {
            meta: generic,
            kind: crate::error::AdminListGroupsForUserErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListGroupsForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminListGroupsForUserError {
            meta: generic,
            kind: crate::error::AdminListGroupsForUserErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListGroupsForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminListGroupsForUserError {
            meta: generic,
            kind: crate::error::AdminListGroupsForUserErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListGroupsForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminListGroupsForUserError {
            meta: generic,
            kind: crate::error::AdminListGroupsForUserErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListGroupsForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminListGroupsForUserError {
            meta: generic,
            kind: crate::error::AdminListGroupsForUserErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListGroupsForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminListGroupsForUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_list_groups_for_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminListGroupsForUserOutput,
    crate::error::AdminListGroupsForUserError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_list_groups_for_user_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_admin_list_groups_for_user(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AdminListGroupsForUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_list_user_auth_events_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminListUserAuthEventsOutput,
    crate::error::AdminListUserAuthEventsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminListUserAuthEventsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminListUserAuthEventsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminListUserAuthEventsError {
            meta: generic,
            kind: crate::error::AdminListUserAuthEventsErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListUserAuthEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminListUserAuthEventsError {
            meta: generic,
            kind: crate::error::AdminListUserAuthEventsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListUserAuthEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminListUserAuthEventsError {
            meta: generic,
            kind: crate::error::AdminListUserAuthEventsErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListUserAuthEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminListUserAuthEventsError {
            meta: generic,
            kind: crate::error::AdminListUserAuthEventsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListUserAuthEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminListUserAuthEventsError {
            meta: generic,
            kind: crate::error::AdminListUserAuthEventsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListUserAuthEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminListUserAuthEventsError {
            meta: generic,
            kind: crate::error::AdminListUserAuthEventsErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListUserAuthEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserPoolAddOnNotEnabledException" => {
            crate::error::AdminListUserAuthEventsError {
                meta: generic,
                kind:
                    crate::error::AdminListUserAuthEventsErrorKind::UserPoolAddOnNotEnabledException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::user_pool_add_on_not_enabled_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_user_pool_add_on_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminListUserAuthEventsError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        _ => crate::error::AdminListUserAuthEventsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_list_user_auth_events_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminListUserAuthEventsOutput,
    crate::error::AdminListUserAuthEventsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_list_user_auth_events_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_admin_list_user_auth_events(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AdminListUserAuthEventsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_remove_user_from_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminRemoveUserFromGroupOutput,
    crate::error::AdminRemoveUserFromGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminRemoveUserFromGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminRemoveUserFromGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminRemoveUserFromGroupError {
            meta: generic,
            kind: crate::error::AdminRemoveUserFromGroupErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRemoveUserFromGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminRemoveUserFromGroupError {
            meta: generic,
            kind: crate::error::AdminRemoveUserFromGroupErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRemoveUserFromGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminRemoveUserFromGroupError {
            meta: generic,
            kind: crate::error::AdminRemoveUserFromGroupErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRemoveUserFromGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminRemoveUserFromGroupError {
            meta: generic,
            kind: crate::error::AdminRemoveUserFromGroupErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRemoveUserFromGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminRemoveUserFromGroupError {
            meta: generic,
            kind: crate::error::AdminRemoveUserFromGroupErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRemoveUserFromGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminRemoveUserFromGroupError {
            meta: generic,
            kind: crate::error::AdminRemoveUserFromGroupErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRemoveUserFromGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminRemoveUserFromGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_remove_user_from_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminRemoveUserFromGroupOutput,
    crate::error::AdminRemoveUserFromGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_remove_user_from_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_reset_user_password_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminResetUserPasswordOutput,
    crate::error::AdminResetUserPasswordError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminResetUserPasswordError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::InternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidEmailRoleAccessPolicyException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::InvalidEmailRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_email_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_email_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLambdaResponseException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::InvalidLambdaResponseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleAccessPolicyException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::InvalidSmsRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleTrustRelationshipException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::InvalidSmsRoleTrustRelationshipException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotAuthorizedException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::NotAuthorizedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnexpectedLambdaException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::UnexpectedLambdaException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserLambdaValidationException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::UserLambdaValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotFoundException" => crate::error::AdminResetUserPasswordError { meta: generic, kind: crate::error::AdminResetUserPasswordErrorKind::UserNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminResetUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AdminResetUserPasswordError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_reset_user_password_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminResetUserPasswordOutput,
    crate::error::AdminResetUserPasswordError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_reset_user_password_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_respond_to_auth_challenge_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminRespondToAuthChallengeOutput,
    crate::error::AdminRespondToAuthChallengeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminRespondToAuthChallengeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AliasExistsException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::AliasExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::alias_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_alias_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CodeMismatchException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::CodeMismatchException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::code_mismatch_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ExpiredCodeException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::ExpiredCodeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::expired_code_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_expired_code_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalErrorException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::InternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLambdaResponseException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::InvalidLambdaResponseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidPasswordException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::InvalidPasswordException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_password_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_password_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleAccessPolicyException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::InvalidSmsRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleTrustRelationshipException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::InvalidSmsRoleTrustRelationshipException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidUserPoolConfigurationException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::InvalidUserPoolConfigurationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_user_pool_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MFAMethodNotFoundException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::MfaMethodNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::mfa_method_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_mfa_method_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotAuthorizedException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::NotAuthorizedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PasswordResetRequiredException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::PasswordResetRequiredException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SoftwareTokenMFANotFoundException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::SoftwareTokenMfaNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::software_token_mfa_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_software_token_mfa_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnexpectedLambdaException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::UnexpectedLambdaException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserLambdaValidationException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::UserLambdaValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotConfirmedException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::UserNotConfirmedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotFoundException" => crate::error::AdminRespondToAuthChallengeError { meta: generic, kind: crate::error::AdminRespondToAuthChallengeErrorKind::UserNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AdminRespondToAuthChallengeError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_respond_to_auth_challenge_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminRespondToAuthChallengeOutput,
    crate::error::AdminRespondToAuthChallengeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_respond_to_auth_challenge_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_admin_respond_to_auth_challenge(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::AdminRespondToAuthChallengeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_set_user_mfa_preference_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminSetUserMfaPreferenceOutput,
    crate::error::AdminSetUserMFAPreferenceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminSetUserMFAPreferenceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminSetUserMFAPreferenceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminSetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::AdminSetUserMFAPreferenceErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminSetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::AdminSetUserMFAPreferenceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminSetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::AdminSetUserMFAPreferenceErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::AdminSetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::AdminSetUserMFAPreferenceErrorKind::PasswordResetRequiredException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::password_reset_required_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserMFAPreferenceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::AdminSetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::AdminSetUserMFAPreferenceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::AdminSetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::AdminSetUserMFAPreferenceErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminSetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::AdminSetUserMFAPreferenceErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminSetUserMFAPreferenceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_set_user_mfa_preference_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminSetUserMfaPreferenceOutput,
    crate::error::AdminSetUserMFAPreferenceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_set_user_mfa_preference_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_set_user_password_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminSetUserPasswordOutput,
    crate::error::AdminSetUserPasswordError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminSetUserPasswordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminSetUserPasswordError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminSetUserPasswordError {
            meta: generic,
            kind: crate::error::AdminSetUserPasswordErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminSetUserPasswordError {
            meta: generic,
            kind: crate::error::AdminSetUserPasswordErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPasswordException" => crate::error::AdminSetUserPasswordError {
            meta: generic,
            kind: crate::error::AdminSetUserPasswordErrorKind::InvalidPasswordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_password_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_password_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminSetUserPasswordError {
            meta: generic,
            kind: crate::error::AdminSetUserPasswordErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminSetUserPasswordError {
            meta: generic,
            kind: crate::error::AdminSetUserPasswordErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminSetUserPasswordError {
            meta: generic,
            kind: crate::error::AdminSetUserPasswordErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminSetUserPasswordError {
            meta: generic,
            kind: crate::error::AdminSetUserPasswordErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminSetUserPasswordError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_set_user_password_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminSetUserPasswordOutput,
    crate::error::AdminSetUserPasswordError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_set_user_password_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_set_user_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminSetUserSettingsOutput,
    crate::error::AdminSetUserSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminSetUserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdminSetUserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminSetUserSettingsError {
            meta: generic,
            kind: crate::error::AdminSetUserSettingsErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminSetUserSettingsError {
            meta: generic,
            kind: crate::error::AdminSetUserSettingsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminSetUserSettingsError {
            meta: generic,
            kind: crate::error::AdminSetUserSettingsErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminSetUserSettingsError {
            meta: generic,
            kind: crate::error::AdminSetUserSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminSetUserSettingsError {
            meta: generic,
            kind: crate::error::AdminSetUserSettingsErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminSetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminSetUserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_set_user_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminSetUserSettingsOutput,
    crate::error::AdminSetUserSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_set_user_settings_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_update_auth_event_feedback_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminUpdateAuthEventFeedbackOutput,
    crate::error::AdminUpdateAuthEventFeedbackError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminUpdateAuthEventFeedbackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminUpdateAuthEventFeedbackError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminUpdateAuthEventFeedbackError { meta: generic, kind: crate::error::AdminUpdateAuthEventFeedbackErrorKind::InternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::AdminUpdateAuthEventFeedbackError { meta: generic, kind: crate::error::AdminUpdateAuthEventFeedbackErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotAuthorizedException" => crate::error::AdminUpdateAuthEventFeedbackError { meta: generic, kind: crate::error::AdminUpdateAuthEventFeedbackErrorKind::NotAuthorizedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::AdminUpdateAuthEventFeedbackError { meta: generic, kind: crate::error::AdminUpdateAuthEventFeedbackErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::AdminUpdateAuthEventFeedbackError { meta: generic, kind: crate::error::AdminUpdateAuthEventFeedbackErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotFoundException" => crate::error::AdminUpdateAuthEventFeedbackError { meta: generic, kind: crate::error::AdminUpdateAuthEventFeedbackErrorKind::UserNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserPoolAddOnNotEnabledException" => crate::error::AdminUpdateAuthEventFeedbackError { meta: generic, kind: crate::error::AdminUpdateAuthEventFeedbackErrorKind::UserPoolAddOnNotEnabledException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_pool_add_on_not_enabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_pool_add_on_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AdminUpdateAuthEventFeedbackError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_update_auth_event_feedback_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminUpdateAuthEventFeedbackOutput,
    crate::error::AdminUpdateAuthEventFeedbackError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_update_auth_event_feedback_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_update_device_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminUpdateDeviceStatusOutput,
    crate::error::AdminUpdateDeviceStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminUpdateDeviceStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminUpdateDeviceStatusError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminUpdateDeviceStatusError { meta: generic, kind: crate::error::AdminUpdateDeviceStatusErrorKind::InternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateDeviceStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::AdminUpdateDeviceStatusError { meta: generic, kind: crate::error::AdminUpdateDeviceStatusErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateDeviceStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidUserPoolConfigurationException" => crate::error::AdminUpdateDeviceStatusError { meta: generic, kind: crate::error::AdminUpdateDeviceStatusErrorKind::InvalidUserPoolConfigurationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_user_pool_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateDeviceStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotAuthorizedException" => crate::error::AdminUpdateDeviceStatusError { meta: generic, kind: crate::error::AdminUpdateDeviceStatusErrorKind::NotAuthorizedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateDeviceStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::AdminUpdateDeviceStatusError { meta: generic, kind: crate::error::AdminUpdateDeviceStatusErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateDeviceStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::AdminUpdateDeviceStatusError { meta: generic, kind: crate::error::AdminUpdateDeviceStatusErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateDeviceStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotFoundException" => crate::error::AdminUpdateDeviceStatusError { meta: generic, kind: crate::error::AdminUpdateDeviceStatusErrorKind::UserNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateDeviceStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AdminUpdateDeviceStatusError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_update_device_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminUpdateDeviceStatusOutput,
    crate::error::AdminUpdateDeviceStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_update_device_status_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_update_user_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminUpdateUserAttributesOutput,
    crate::error::AdminUpdateUserAttributesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminUpdateUserAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AliasExistsException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::AliasExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::alias_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_alias_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalErrorException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::InternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidEmailRoleAccessPolicyException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::InvalidEmailRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_email_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_email_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLambdaResponseException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::InvalidLambdaResponseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleAccessPolicyException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::InvalidSmsRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleTrustRelationshipException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::InvalidSmsRoleTrustRelationshipException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotAuthorizedException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::NotAuthorizedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnexpectedLambdaException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::UnexpectedLambdaException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserLambdaValidationException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::UserLambdaValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotFoundException" => crate::error::AdminUpdateUserAttributesError { meta: generic, kind: crate::error::AdminUpdateUserAttributesErrorKind::UserNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AdminUpdateUserAttributesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_update_user_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminUpdateUserAttributesOutput,
    crate::error::AdminUpdateUserAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_update_user_attributes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_user_global_sign_out_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminUserGlobalSignOutOutput,
    crate::error::AdminUserGlobalSignOutError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdminUserGlobalSignOutError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AdminUserGlobalSignOutError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::AdminUserGlobalSignOutError {
            meta: generic,
            kind: crate::error::AdminUserGlobalSignOutErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUserGlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AdminUserGlobalSignOutError {
            meta: generic,
            kind: crate::error::AdminUserGlobalSignOutErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUserGlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AdminUserGlobalSignOutError {
            meta: generic,
            kind: crate::error::AdminUserGlobalSignOutErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUserGlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AdminUserGlobalSignOutError {
            meta: generic,
            kind: crate::error::AdminUserGlobalSignOutErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUserGlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::AdminUserGlobalSignOutError {
            meta: generic,
            kind: crate::error::AdminUserGlobalSignOutErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUserGlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::AdminUserGlobalSignOutError {
            meta: generic,
            kind: crate::error::AdminUserGlobalSignOutErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdminUserGlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdminUserGlobalSignOutError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_admin_user_global_sign_out_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdminUserGlobalSignOutOutput,
    crate::error::AdminUserGlobalSignOutError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::admin_user_global_sign_out_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_software_token_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateSoftwareTokenOutput,
    crate::error::AssociateSoftwareTokenError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateSoftwareTokenError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateSoftwareTokenError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::AssociateSoftwareTokenError {
            meta: generic,
            kind: crate::error::AssociateSoftwareTokenErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::AssociateSoftwareTokenError {
            meta: generic,
            kind: crate::error::AssociateSoftwareTokenErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::AssociateSoftwareTokenError {
            meta: generic,
            kind: crate::error::AssociateSoftwareTokenErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::AssociateSoftwareTokenError {
            meta: generic,
            kind: crate::error::AssociateSoftwareTokenErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociateSoftwareTokenError {
            meta: generic,
            kind: crate::error::AssociateSoftwareTokenErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SoftwareTokenMFANotFoundException" => {
            crate::error::AssociateSoftwareTokenError {
                meta: generic,
                kind:
                    crate::error::AssociateSoftwareTokenErrorKind::SoftwareTokenMfaNotFoundException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::software_token_mfa_not_found_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_software_token_mfa_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateSoftwareTokenError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        _ => crate::error::AssociateSoftwareTokenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_software_token_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateSoftwareTokenOutput,
    crate::error::AssociateSoftwareTokenError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_software_token_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_software_token(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateSoftwareTokenError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_change_password_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ChangePasswordOutput, crate::error::ChangePasswordError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ChangePasswordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ChangePasswordError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPasswordException" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::InvalidPasswordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_password_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_password_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ChangePasswordError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_change_password_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ChangePasswordOutput, crate::error::ChangePasswordError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::change_password_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_confirm_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ConfirmDeviceOutput, crate::error::ConfirmDeviceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ConfirmDeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ConfirmDeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLambdaResponseException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::InvalidLambdaResponseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPasswordException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::InvalidPasswordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_password_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_password_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserPoolConfigurationException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::InvalidUserPoolConfigurationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_user_pool_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UsernameExistsException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::UsernameExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::username_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_username_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::ConfirmDeviceError {
            meta: generic,
            kind: crate::error::ConfirmDeviceErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ConfirmDeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_confirm_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ConfirmDeviceOutput, crate::error::ConfirmDeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::confirm_device_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_confirm_device(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ConfirmDeviceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_confirm_forgot_password_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ConfirmForgotPasswordOutput,
    crate::error::ConfirmForgotPasswordError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ConfirmForgotPasswordError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeMismatchException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::CodeMismatchException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::code_mismatch_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ExpiredCodeException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::ExpiredCodeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::expired_code_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_expired_code_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLambdaResponseException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::InvalidLambdaResponseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPasswordException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::InvalidPasswordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_password_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_password_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyFailedAttemptsException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::TooManyFailedAttemptsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_failed_attempts_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_failed_attempts_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnexpectedLambdaException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::UnexpectedLambdaException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserLambdaValidationException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::UserLambdaValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::ConfirmForgotPasswordError {
            meta: generic,
            kind: crate::error::ConfirmForgotPasswordErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ConfirmForgotPasswordError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_confirm_forgot_password_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ConfirmForgotPasswordOutput,
    crate::error::ConfirmForgotPasswordError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::confirm_forgot_password_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_confirm_sign_up_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ConfirmSignUpOutput, crate::error::ConfirmSignUpError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ConfirmSignUpError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ConfirmSignUpError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AliasExistsException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::AliasExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::alias_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_alias_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CodeMismatchException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::CodeMismatchException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::code_mismatch_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ExpiredCodeException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::ExpiredCodeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::expired_code_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_expired_code_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLambdaResponseException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::InvalidLambdaResponseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyFailedAttemptsException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::TooManyFailedAttemptsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_failed_attempts_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_failed_attempts_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnexpectedLambdaException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::UnexpectedLambdaException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserLambdaValidationException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::UserLambdaValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::ConfirmSignUpError {
            meta: generic,
            kind: crate::error::ConfirmSignUpErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ConfirmSignUpError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_confirm_sign_up_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ConfirmSignUpOutput, crate::error::ConfirmSignUpError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::confirm_sign_up_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateGroupOutput, crate::error::CreateGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GroupExistsException" => crate::error::CreateGroupError {
            meta: generic,
            kind: crate::error::CreateGroupErrorKind::GroupExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::group_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_group_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::CreateGroupError {
            meta: generic,
            kind: crate::error::CreateGroupErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateGroupError {
            meta: generic,
            kind: crate::error::CreateGroupErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateGroupError {
            meta: generic,
            kind: crate::error::CreateGroupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::CreateGroupError {
            meta: generic,
            kind: crate::error::CreateGroupErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateGroupError {
            meta: generic,
            kind: crate::error::CreateGroupErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateGroupError {
            meta: generic,
            kind: crate::error::CreateGroupErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateGroupOutput, crate::error::CreateGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_identity_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateIdentityProviderOutput,
    crate::error::CreateIdentityProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateIdentityProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateIdentityProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateProviderException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::DuplicateProviderException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_provider_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_provider_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateIdentityProviderError {
            meta: generic,
            kind: crate::error::CreateIdentityProviderErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateIdentityProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_identity_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateIdentityProviderOutput,
    crate::error::CreateIdentityProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_identity_provider_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_identity_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateIdentityProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_resource_server_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateResourceServerOutput,
    crate::error::CreateResourceServerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateResourceServerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateResourceServerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::CreateResourceServerError {
            meta: generic,
            kind: crate::error::CreateResourceServerErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateResourceServerError {
            meta: generic,
            kind: crate::error::CreateResourceServerErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateResourceServerError {
            meta: generic,
            kind: crate::error::CreateResourceServerErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::CreateResourceServerError {
            meta: generic,
            kind: crate::error::CreateResourceServerErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateResourceServerError {
            meta: generic,
            kind: crate::error::CreateResourceServerErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateResourceServerError {
            meta: generic,
            kind: crate::error::CreateResourceServerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateResourceServerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_resource_server_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateResourceServerOutput,
    crate::error::CreateResourceServerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_resource_server_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_resource_server(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateResourceServerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_import_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateUserImportJobOutput,
    crate::error::CreateUserImportJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUserImportJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUserImportJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::CreateUserImportJobError {
            meta: generic,
            kind: crate::error::CreateUserImportJobErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateUserImportJobError {
            meta: generic,
            kind: crate::error::CreateUserImportJobErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateUserImportJobError {
            meta: generic,
            kind: crate::error::CreateUserImportJobErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::CreateUserImportJobError {
            meta: generic,
            kind: crate::error::CreateUserImportJobErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionNotMetException" => crate::error::CreateUserImportJobError {
            meta: generic,
            kind: crate::error::CreateUserImportJobErrorKind::PreconditionNotMetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_not_met_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_not_met_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateUserImportJobError {
            meta: generic,
            kind: crate::error::CreateUserImportJobErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateUserImportJobError {
            meta: generic,
            kind: crate::error::CreateUserImportJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUserImportJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_import_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateUserImportJobOutput,
    crate::error::CreateUserImportJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_user_import_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_user_import_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUserImportJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_pool_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserPoolOutput, crate::error::CreateUserPoolError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUserPoolError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUserPoolError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::CreateUserPoolError {
            meta: generic,
            kind: crate::error::CreateUserPoolErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEmailRoleAccessPolicyException" => crate::error::CreateUserPoolError {
            meta: generic,
            kind: crate::error::CreateUserPoolErrorKind::InvalidEmailRoleAccessPolicyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_email_role_access_policy_exception::Builder::default(
                        );
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_email_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateUserPoolError {
            meta: generic,
            kind: crate::error::CreateUserPoolErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSmsRoleAccessPolicyException" => {
            crate::error::CreateUserPoolError {
                meta: generic,
                kind: crate::error::CreateUserPoolErrorKind::InvalidSmsRoleAccessPolicyException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidSmsRoleTrustRelationshipException" => crate::error::CreateUserPoolError {
            meta: generic,
            kind: crate::error::CreateUserPoolErrorKind::InvalidSmsRoleTrustRelationshipException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "LimitExceededException" => crate::error::CreateUserPoolError {
            meta: generic,
            kind: crate::error::CreateUserPoolErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::CreateUserPoolError {
            meta: generic,
            kind: crate::error::CreateUserPoolErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateUserPoolError {
            meta: generic,
            kind: crate::error::CreateUserPoolErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserPoolTaggingException" => crate::error::CreateUserPoolError {
            meta: generic,
            kind: crate::error::CreateUserPoolErrorKind::UserPoolTaggingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_pool_tagging_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_pool_tagging_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUserPoolError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_pool_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserPoolOutput, crate::error::CreateUserPoolError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_user_pool_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_user_pool(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUserPoolError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_pool_client_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateUserPoolClientOutput,
    crate::error::CreateUserPoolClientError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUserPoolClientError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUserPoolClientError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::CreateUserPoolClientError {
            meta: generic,
            kind: crate::error::CreateUserPoolClientErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidOAuthFlowException" => crate::error::CreateUserPoolClientError {
            meta: generic,
            kind: crate::error::CreateUserPoolClientErrorKind::InvalidOAuthFlowException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_o_auth_flow_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_o_auth_flow_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateUserPoolClientError {
            meta: generic,
            kind: crate::error::CreateUserPoolClientErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateUserPoolClientError {
            meta: generic,
            kind: crate::error::CreateUserPoolClientErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::CreateUserPoolClientError {
            meta: generic,
            kind: crate::error::CreateUserPoolClientErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateUserPoolClientError {
            meta: generic,
            kind: crate::error::CreateUserPoolClientErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ScopeDoesNotExistException" => crate::error::CreateUserPoolClientError {
            meta: generic,
            kind: crate::error::CreateUserPoolClientErrorKind::ScopeDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::scope_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_scope_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateUserPoolClientError {
            meta: generic,
            kind: crate::error::CreateUserPoolClientErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUserPoolClientError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_pool_client_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateUserPoolClientOutput,
    crate::error::CreateUserPoolClientError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_user_pool_client_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_user_pool_client(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUserPoolClientError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_pool_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateUserPoolDomainOutput,
    crate::error::CreateUserPoolDomainError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUserPoolDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUserPoolDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::CreateUserPoolDomainError {
            meta: generic,
            kind: crate::error::CreateUserPoolDomainErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateUserPoolDomainError {
            meta: generic,
            kind: crate::error::CreateUserPoolDomainErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateUserPoolDomainError {
            meta: generic,
            kind: crate::error::CreateUserPoolDomainErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::CreateUserPoolDomainError {
            meta: generic,
            kind: crate::error::CreateUserPoolDomainErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateUserPoolDomainError {
            meta: generic,
            kind: crate::error::CreateUserPoolDomainErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUserPoolDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_pool_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateUserPoolDomainOutput,
    crate::error::CreateUserPoolDomainError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_user_pool_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_user_pool_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUserPoolDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteGroupOutput, crate::error::DeleteGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DeleteGroupError {
            meta: generic,
            kind: crate::error::DeleteGroupErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteGroupError {
            meta: generic,
            kind: crate::error::DeleteGroupErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DeleteGroupError {
            meta: generic,
            kind: crate::error::DeleteGroupErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteGroupError {
            meta: generic,
            kind: crate::error::DeleteGroupErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteGroupError {
            meta: generic,
            kind: crate::error::DeleteGroupErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteGroupOutput, crate::error::DeleteGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_identity_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteIdentityProviderOutput,
    crate::error::DeleteIdentityProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteIdentityProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DeleteIdentityProviderError {
            meta: generic,
            kind: crate::error::DeleteIdentityProviderErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteIdentityProviderError {
            meta: generic,
            kind: crate::error::DeleteIdentityProviderErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DeleteIdentityProviderError {
            meta: generic,
            kind: crate::error::DeleteIdentityProviderErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteIdentityProviderError {
            meta: generic,
            kind: crate::error::DeleteIdentityProviderErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteIdentityProviderError {
            meta: generic,
            kind: crate::error::DeleteIdentityProviderErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedIdentityProviderException" => crate::error::DeleteIdentityProviderError {
            meta: generic,
            kind:
                crate::error::DeleteIdentityProviderErrorKind::UnsupportedIdentityProviderException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::unsupported_identity_provider_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_unsupported_identity_provider_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIdentityProviderError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DeleteIdentityProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_identity_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteIdentityProviderOutput,
    crate::error::DeleteIdentityProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_identity_provider_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_resource_server_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteResourceServerOutput,
    crate::error::DeleteResourceServerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteResourceServerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteResourceServerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DeleteResourceServerError {
            meta: generic,
            kind: crate::error::DeleteResourceServerErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteResourceServerError {
            meta: generic,
            kind: crate::error::DeleteResourceServerErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DeleteResourceServerError {
            meta: generic,
            kind: crate::error::DeleteResourceServerErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteResourceServerError {
            meta: generic,
            kind: crate::error::DeleteResourceServerErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteResourceServerError {
            meta: generic,
            kind: crate::error::DeleteResourceServerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteResourceServerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_resource_server_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteResourceServerOutput,
    crate::error::DeleteResourceServerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_resource_server_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteUserAttributesOutput,
    crate::error::DeleteUserAttributesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DeleteUserAttributesError {
            meta: generic,
            kind: crate::error::DeleteUserAttributesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteUserAttributesError {
            meta: generic,
            kind: crate::error::DeleteUserAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DeleteUserAttributesError {
            meta: generic,
            kind: crate::error::DeleteUserAttributesErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::DeleteUserAttributesError {
            meta: generic,
            kind: crate::error::DeleteUserAttributesErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteUserAttributesError {
            meta: generic,
            kind: crate::error::DeleteUserAttributesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteUserAttributesError {
            meta: generic,
            kind: crate::error::DeleteUserAttributesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::DeleteUserAttributesError {
            meta: generic,
            kind: crate::error::DeleteUserAttributesErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::DeleteUserAttributesError {
            meta: generic,
            kind: crate::error::DeleteUserAttributesErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteUserAttributesOutput,
    crate::error::DeleteUserAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_attributes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_pool_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserPoolOutput, crate::error::DeleteUserPoolError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserPoolError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserPoolError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DeleteUserPoolError {
            meta: generic,
            kind: crate::error::DeleteUserPoolErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteUserPoolError {
            meta: generic,
            kind: crate::error::DeleteUserPoolErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DeleteUserPoolError {
            meta: generic,
            kind: crate::error::DeleteUserPoolErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteUserPoolError {
            meta: generic,
            kind: crate::error::DeleteUserPoolErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteUserPoolError {
            meta: generic,
            kind: crate::error::DeleteUserPoolErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserImportInProgressException" => crate::error::DeleteUserPoolError {
            meta: generic,
            kind: crate::error::DeleteUserPoolErrorKind::UserImportInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_import_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_import_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserPoolError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_pool_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserPoolOutput, crate::error::DeleteUserPoolError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_pool_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_pool_client_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteUserPoolClientOutput,
    crate::error::DeleteUserPoolClientError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserPoolClientError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserPoolClientError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DeleteUserPoolClientError {
            meta: generic,
            kind: crate::error::DeleteUserPoolClientErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteUserPoolClientError {
            meta: generic,
            kind: crate::error::DeleteUserPoolClientErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DeleteUserPoolClientError {
            meta: generic,
            kind: crate::error::DeleteUserPoolClientErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteUserPoolClientError {
            meta: generic,
            kind: crate::error::DeleteUserPoolClientErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DeleteUserPoolClientError {
            meta: generic,
            kind: crate::error::DeleteUserPoolClientErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserPoolClientError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_pool_client_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteUserPoolClientOutput,
    crate::error::DeleteUserPoolClientError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_pool_client_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_pool_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteUserPoolDomainOutput,
    crate::error::DeleteUserPoolDomainError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserPoolDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserPoolDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DeleteUserPoolDomainError {
            meta: generic,
            kind: crate::error::DeleteUserPoolDomainErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteUserPoolDomainError {
            meta: generic,
            kind: crate::error::DeleteUserPoolDomainErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DeleteUserPoolDomainError {
            meta: generic,
            kind: crate::error::DeleteUserPoolDomainErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteUserPoolDomainError {
            meta: generic,
            kind: crate::error::DeleteUserPoolDomainErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserPoolDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_pool_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteUserPoolDomainOutput,
    crate::error::DeleteUserPoolDomainError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_pool_domain_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_identity_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeIdentityProviderOutput,
    crate::error::DescribeIdentityProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeIdentityProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeIdentityProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DescribeIdentityProviderError {
            meta: generic,
            kind: crate::error::DescribeIdentityProviderErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeIdentityProviderError {
            meta: generic,
            kind: crate::error::DescribeIdentityProviderErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DescribeIdentityProviderError {
            meta: generic,
            kind: crate::error::DescribeIdentityProviderErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeIdentityProviderError {
            meta: generic,
            kind: crate::error::DescribeIdentityProviderErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeIdentityProviderError {
            meta: generic,
            kind: crate::error::DescribeIdentityProviderErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeIdentityProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_identity_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeIdentityProviderOutput,
    crate::error::DescribeIdentityProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_identity_provider_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_identity_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeIdentityProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_resource_server_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeResourceServerOutput,
    crate::error::DescribeResourceServerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeResourceServerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeResourceServerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DescribeResourceServerError {
            meta: generic,
            kind: crate::error::DescribeResourceServerErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeResourceServerError {
            meta: generic,
            kind: crate::error::DescribeResourceServerErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DescribeResourceServerError {
            meta: generic,
            kind: crate::error::DescribeResourceServerErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeResourceServerError {
            meta: generic,
            kind: crate::error::DescribeResourceServerErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeResourceServerError {
            meta: generic,
            kind: crate::error::DescribeResourceServerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeResourceServerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_resource_server_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeResourceServerOutput,
    crate::error::DescribeResourceServerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_resource_server_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_resource_server(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeResourceServerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_risk_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeRiskConfigurationOutput,
    crate::error::DescribeRiskConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeRiskConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeRiskConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DescribeRiskConfigurationError {
            meta: generic,
            kind: crate::error::DescribeRiskConfigurationErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeRiskConfigurationError {
            meta: generic,
            kind: crate::error::DescribeRiskConfigurationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DescribeRiskConfigurationError {
            meta: generic,
            kind: crate::error::DescribeRiskConfigurationErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeRiskConfigurationError {
            meta: generic,
            kind: crate::error::DescribeRiskConfigurationErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeRiskConfigurationError {
            meta: generic,
            kind: crate::error::DescribeRiskConfigurationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserPoolAddOnNotEnabledException" => crate::error::DescribeRiskConfigurationError {
            meta: generic,
            kind:
                crate::error::DescribeRiskConfigurationErrorKind::UserPoolAddOnNotEnabledException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::user_pool_add_on_not_enabled_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_user_pool_add_on_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRiskConfigurationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeRiskConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_risk_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeRiskConfigurationOutput,
    crate::error::DescribeRiskConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_risk_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_risk_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeRiskConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_import_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserImportJobOutput,
    crate::error::DescribeUserImportJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeUserImportJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeUserImportJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DescribeUserImportJobError {
            meta: generic,
            kind: crate::error::DescribeUserImportJobErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeUserImportJobError {
            meta: generic,
            kind: crate::error::DescribeUserImportJobErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DescribeUserImportJobError {
            meta: generic,
            kind: crate::error::DescribeUserImportJobErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeUserImportJobError {
            meta: generic,
            kind: crate::error::DescribeUserImportJobErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeUserImportJobError {
            meta: generic,
            kind: crate::error::DescribeUserImportJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeUserImportJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_import_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserImportJobOutput,
    crate::error::DescribeUserImportJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_user_import_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_user_import_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeUserImportJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_pool_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeUserPoolOutput, crate::error::DescribeUserPoolError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeUserPoolError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeUserPoolError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DescribeUserPoolError {
            meta: generic,
            kind: crate::error::DescribeUserPoolErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeUserPoolError {
            meta: generic,
            kind: crate::error::DescribeUserPoolErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DescribeUserPoolError {
            meta: generic,
            kind: crate::error::DescribeUserPoolErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeUserPoolError {
            meta: generic,
            kind: crate::error::DescribeUserPoolErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeUserPoolError {
            meta: generic,
            kind: crate::error::DescribeUserPoolErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserPoolTaggingException" => crate::error::DescribeUserPoolError {
            meta: generic,
            kind: crate::error::DescribeUserPoolErrorKind::UserPoolTaggingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_pool_tagging_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_pool_tagging_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeUserPoolError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_pool_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeUserPoolOutput, crate::error::DescribeUserPoolError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_user_pool_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_user_pool(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeUserPoolError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_pool_client_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserPoolClientOutput,
    crate::error::DescribeUserPoolClientError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeUserPoolClientError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeUserPoolClientError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DescribeUserPoolClientError {
            meta: generic,
            kind: crate::error::DescribeUserPoolClientErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeUserPoolClientError {
            meta: generic,
            kind: crate::error::DescribeUserPoolClientErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DescribeUserPoolClientError {
            meta: generic,
            kind: crate::error::DescribeUserPoolClientErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeUserPoolClientError {
            meta: generic,
            kind: crate::error::DescribeUserPoolClientErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::DescribeUserPoolClientError {
            meta: generic,
            kind: crate::error::DescribeUserPoolClientErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeUserPoolClientError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_pool_client_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserPoolClientOutput,
    crate::error::DescribeUserPoolClientError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_user_pool_client_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_user_pool_client(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeUserPoolClientError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_pool_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserPoolDomainOutput,
    crate::error::DescribeUserPoolDomainError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeUserPoolDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeUserPoolDomainError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::DescribeUserPoolDomainError {
            meta: generic,
            kind: crate::error::DescribeUserPoolDomainErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeUserPoolDomainError {
            meta: generic,
            kind: crate::error::DescribeUserPoolDomainErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::DescribeUserPoolDomainError {
            meta: generic,
            kind: crate::error::DescribeUserPoolDomainErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeUserPoolDomainError {
            meta: generic,
            kind: crate::error::DescribeUserPoolDomainErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeUserPoolDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_pool_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserPoolDomainOutput,
    crate::error::DescribeUserPoolDomainError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_user_pool_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_user_pool_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeUserPoolDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_forget_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ForgetDeviceOutput, crate::error::ForgetDeviceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ForgetDeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ForgetDeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ForgetDeviceError {
            meta: generic,
            kind: crate::error::ForgetDeviceErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ForgetDeviceError {
            meta: generic,
            kind: crate::error::ForgetDeviceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserPoolConfigurationException" => {
            crate::error::ForgetDeviceError {
                meta: generic,
                kind: crate::error::ForgetDeviceErrorKind::InvalidUserPoolConfigurationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_user_pool_configuration_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgetDeviceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotAuthorizedException" => crate::error::ForgetDeviceError {
            meta: generic,
            kind: crate::error::ForgetDeviceErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::ForgetDeviceError {
            meta: generic,
            kind: crate::error::ForgetDeviceErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ForgetDeviceError {
            meta: generic,
            kind: crate::error::ForgetDeviceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ForgetDeviceError {
            meta: generic,
            kind: crate::error::ForgetDeviceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::ForgetDeviceError {
            meta: generic,
            kind: crate::error::ForgetDeviceErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::ForgetDeviceError {
            meta: generic,
            kind: crate::error::ForgetDeviceErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ForgetDeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_forget_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ForgetDeviceOutput, crate::error::ForgetDeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::forget_device_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_forgot_password_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ForgotPasswordOutput, crate::error::ForgotPasswordError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ForgotPasswordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ForgotPasswordError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeDeliveryFailureException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::CodeDeliveryFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_delivery_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_delivery_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEmailRoleAccessPolicyException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::InvalidEmailRoleAccessPolicyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_email_role_access_policy_exception::Builder::default(
                        );
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_email_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLambdaResponseException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::InvalidLambdaResponseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSmsRoleAccessPolicyException" => {
            crate::error::ForgotPasswordError {
                meta: generic,
                kind: crate::error::ForgotPasswordErrorKind::InvalidSmsRoleAccessPolicyException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidSmsRoleTrustRelationshipException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::InvalidSmsRoleTrustRelationshipException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "LimitExceededException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnexpectedLambdaException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::UnexpectedLambdaException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserLambdaValidationException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::UserLambdaValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::ForgotPasswordError {
            meta: generic,
            kind: crate::error::ForgotPasswordErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ForgotPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ForgotPasswordError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_forgot_password_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ForgotPasswordOutput, crate::error::ForgotPasswordError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::forgot_password_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_forgot_password(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ForgotPasswordError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_csv_header_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCsvHeaderOutput, crate::error::GetCSVHeaderError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCSVHeaderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetCSVHeaderError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::GetCSVHeaderError {
            meta: generic,
            kind: crate::error::GetCSVHeaderErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCSVHeaderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetCSVHeaderError {
            meta: generic,
            kind: crate::error::GetCSVHeaderErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCSVHeaderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::GetCSVHeaderError {
            meta: generic,
            kind: crate::error::GetCSVHeaderErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCSVHeaderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetCSVHeaderError {
            meta: generic,
            kind: crate::error::GetCSVHeaderErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCSVHeaderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetCSVHeaderError {
            meta: generic,
            kind: crate::error::GetCSVHeaderErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCSVHeaderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetCSVHeaderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_csv_header_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCsvHeaderOutput, crate::error::GetCSVHeaderError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_csv_header_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_csv_header(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetCSVHeaderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDeviceOutput, crate::error::GetDeviceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::GetDeviceError {
            meta: generic,
            kind: crate::error::GetDeviceErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetDeviceError {
            meta: generic,
            kind: crate::error::GetDeviceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserPoolConfigurationException" => {
            crate::error::GetDeviceError {
                meta: generic,
                kind: crate::error::GetDeviceErrorKind::InvalidUserPoolConfigurationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_user_pool_configuration_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeviceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotAuthorizedException" => crate::error::GetDeviceError {
            meta: generic,
            kind: crate::error::GetDeviceErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::GetDeviceError {
            meta: generic,
            kind: crate::error::GetDeviceErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetDeviceError {
            meta: generic,
            kind: crate::error::GetDeviceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetDeviceError {
            meta: generic,
            kind: crate::error::GetDeviceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::GetDeviceError {
            meta: generic,
            kind: crate::error::GetDeviceErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::GetDeviceError {
            meta: generic,
            kind: crate::error::GetDeviceErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDeviceOutput, crate::error::GetDeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_device_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_device(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDeviceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGroupOutput, crate::error::GetGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::GetGroupError {
            meta: generic,
            kind: crate::error::GetGroupErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetGroupError {
            meta: generic,
            kind: crate::error::GetGroupErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::GetGroupError {
            meta: generic,
            kind: crate::error::GetGroupErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetGroupError {
            meta: generic,
            kind: crate::error::GetGroupErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetGroupError {
            meta: generic,
            kind: crate::error::GetGroupErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGroupOutput, crate::error::GetGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_provider_by_identifier_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityProviderByIdentifierOutput,
    crate::error::GetIdentityProviderByIdentifierError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIdentityProviderByIdentifierError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetIdentityProviderByIdentifierError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::GetIdentityProviderByIdentifierError {
            meta: generic,
            kind: crate::error::GetIdentityProviderByIdentifierErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIdentityProviderByIdentifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetIdentityProviderByIdentifierError {
            meta: generic,
            kind: crate::error::GetIdentityProviderByIdentifierErrorKind::InvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIdentityProviderByIdentifierError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotAuthorizedException" => crate::error::GetIdentityProviderByIdentifierError {
            meta: generic,
            kind: crate::error::GetIdentityProviderByIdentifierErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIdentityProviderByIdentifierError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetIdentityProviderByIdentifierError {
            meta: generic,
            kind: crate::error::GetIdentityProviderByIdentifierErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIdentityProviderByIdentifierError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "TooManyRequestsException" => crate::error::GetIdentityProviderByIdentifierError {
            meta: generic,
            kind: crate::error::GetIdentityProviderByIdentifierErrorKind::TooManyRequestsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::too_many_requests_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIdentityProviderByIdentifierError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::GetIdentityProviderByIdentifierError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_provider_by_identifier_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityProviderByIdentifierOutput,
    crate::error::GetIdentityProviderByIdentifierError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_identity_provider_by_identifier_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_identity_provider_by_identifier(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetIdentityProviderByIdentifierError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_signing_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSigningCertificateOutput,
    crate::error::GetSigningCertificateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSigningCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSigningCertificateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::GetSigningCertificateError {
            meta: generic,
            kind: crate::error::GetSigningCertificateErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetSigningCertificateError {
            meta: generic,
            kind: crate::error::GetSigningCertificateErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetSigningCertificateError {
            meta: generic,
            kind: crate::error::GetSigningCertificateErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSigningCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_signing_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSigningCertificateOutput,
    crate::error::GetSigningCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_signing_certificate_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_signing_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSigningCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_ui_customization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetUiCustomizationOutput,
    crate::error::GetUICustomizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetUICustomizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetUICustomizationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::GetUICustomizationError {
            meta: generic,
            kind: crate::error::GetUICustomizationErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUICustomizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetUICustomizationError {
            meta: generic,
            kind: crate::error::GetUICustomizationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUICustomizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::GetUICustomizationError {
            meta: generic,
            kind: crate::error::GetUICustomizationErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUICustomizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetUICustomizationError {
            meta: generic,
            kind: crate::error::GetUICustomizationErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUICustomizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetUICustomizationError {
            meta: generic,
            kind: crate::error::GetUICustomizationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUICustomizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetUICustomizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_ui_customization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetUiCustomizationOutput,
    crate::error::GetUICustomizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_ui_customization_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_ui_customization(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetUICustomizationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUserOutput, crate::error::GetUserError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::GetUserError {
            meta: generic,
            kind: crate::error::GetUserErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetUserError {
            meta: generic,
            kind: crate::error::GetUserErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::GetUserError {
            meta: generic,
            kind: crate::error::GetUserErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::GetUserError {
            meta: generic,
            kind: crate::error::GetUserErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetUserError {
            meta: generic,
            kind: crate::error::GetUserErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetUserError {
            meta: generic,
            kind: crate::error::GetUserErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::GetUserError {
            meta: generic,
            kind: crate::error::GetUserErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::GetUserError {
            meta: generic,
            kind: crate::error::GetUserErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUserOutput, crate::error::GetUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_user_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_user(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_attribute_verification_code_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetUserAttributeVerificationCodeOutput,
    crate::error::GetUserAttributeVerificationCodeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetUserAttributeVerificationCodeError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeDeliveryFailureException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::CodeDeliveryFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::code_delivery_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_delivery_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalErrorException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::InternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidEmailRoleAccessPolicyException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::InvalidEmailRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_email_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_email_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLambdaResponseException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::InvalidLambdaResponseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleAccessPolicyException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::InvalidSmsRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleTrustRelationshipException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::InvalidSmsRoleTrustRelationshipException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotAuthorizedException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::NotAuthorizedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PasswordResetRequiredException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::PasswordResetRequiredException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnexpectedLambdaException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::UnexpectedLambdaException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserLambdaValidationException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::UserLambdaValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotConfirmedException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::UserNotConfirmedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotFoundException" => crate::error::GetUserAttributeVerificationCodeError { meta: generic, kind: crate::error::GetUserAttributeVerificationCodeErrorKind::UserNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetUserAttributeVerificationCodeError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_attribute_verification_code_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetUserAttributeVerificationCodeOutput,
    crate::error::GetUserAttributeVerificationCodeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_user_attribute_verification_code_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_user_attribute_verification_code(response.body().as_ref(), output).map_err(crate::error::GetUserAttributeVerificationCodeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_pool_mfa_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetUserPoolMfaConfigOutput,
    crate::error::GetUserPoolMfaConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetUserPoolMfaConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetUserPoolMfaConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::GetUserPoolMfaConfigError {
            meta: generic,
            kind: crate::error::GetUserPoolMfaConfigErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetUserPoolMfaConfigError {
            meta: generic,
            kind: crate::error::GetUserPoolMfaConfigErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::GetUserPoolMfaConfigError {
            meta: generic,
            kind: crate::error::GetUserPoolMfaConfigErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetUserPoolMfaConfigError {
            meta: generic,
            kind: crate::error::GetUserPoolMfaConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GetUserPoolMfaConfigError {
            meta: generic,
            kind: crate::error::GetUserPoolMfaConfigErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetUserPoolMfaConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_pool_mfa_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetUserPoolMfaConfigOutput,
    crate::error::GetUserPoolMfaConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_user_pool_mfa_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_user_pool_mfa_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetUserPoolMfaConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_global_sign_out_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GlobalSignOutOutput, crate::error::GlobalSignOutError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GlobalSignOutError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GlobalSignOutError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::GlobalSignOutError {
            meta: generic,
            kind: crate::error::GlobalSignOutErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GlobalSignOutError {
            meta: generic,
            kind: crate::error::GlobalSignOutErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::GlobalSignOutError {
            meta: generic,
            kind: crate::error::GlobalSignOutErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::GlobalSignOutError {
            meta: generic,
            kind: crate::error::GlobalSignOutErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GlobalSignOutError {
            meta: generic,
            kind: crate::error::GlobalSignOutErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::GlobalSignOutError {
            meta: generic,
            kind: crate::error::GlobalSignOutErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::GlobalSignOutError {
            meta: generic,
            kind: crate::error::GlobalSignOutErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GlobalSignOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GlobalSignOutError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_global_sign_out_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GlobalSignOutOutput, crate::error::GlobalSignOutError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::global_sign_out_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_initiate_auth_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::InitiateAuthOutput, crate::error::InitiateAuthError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::InitiateAuthError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::InitiateAuthError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLambdaResponseException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::InvalidLambdaResponseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSmsRoleAccessPolicyException" => {
            crate::error::InitiateAuthError {
                meta: generic,
                kind: crate::error::InitiateAuthErrorKind::InvalidSmsRoleAccessPolicyException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidSmsRoleTrustRelationshipException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::InvalidSmsRoleTrustRelationshipException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserPoolConfigurationException" => {
            crate::error::InitiateAuthError {
                meta: generic,
                kind: crate::error::InitiateAuthErrorKind::InvalidUserPoolConfigurationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_user_pool_configuration_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotAuthorizedException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnexpectedLambdaException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::UnexpectedLambdaException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserLambdaValidationException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::UserLambdaValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::InitiateAuthError {
            meta: generic,
            kind: crate::error::InitiateAuthErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateAuthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::InitiateAuthError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_initiate_auth_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::InitiateAuthOutput, crate::error::InitiateAuthError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::initiate_auth_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_initiate_auth(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::InitiateAuthError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_devices_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDevicesOutput, crate::error::ListDevicesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDevicesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListDevicesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ListDevicesError {
            meta: generic,
            kind: crate::error::ListDevicesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListDevicesError {
            meta: generic,
            kind: crate::error::ListDevicesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserPoolConfigurationException" => {
            crate::error::ListDevicesError {
                meta: generic,
                kind: crate::error::ListDevicesErrorKind::InvalidUserPoolConfigurationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_user_pool_configuration_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDevicesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotAuthorizedException" => crate::error::ListDevicesError {
            meta: generic,
            kind: crate::error::ListDevicesErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::ListDevicesError {
            meta: generic,
            kind: crate::error::ListDevicesErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListDevicesError {
            meta: generic,
            kind: crate::error::ListDevicesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListDevicesError {
            meta: generic,
            kind: crate::error::ListDevicesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::ListDevicesError {
            meta: generic,
            kind: crate::error::ListDevicesErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::ListDevicesError {
            meta: generic,
            kind: crate::error::ListDevicesErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListDevicesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_devices_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDevicesOutput, crate::error::ListDevicesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_devices_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_devices(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDevicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGroupsOutput, crate::error::ListGroupsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ListGroupsError {
            meta: generic,
            kind: crate::error::ListGroupsErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListGroupsError {
            meta: generic,
            kind: crate::error::ListGroupsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ListGroupsError {
            meta: generic,
            kind: crate::error::ListGroupsErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListGroupsError {
            meta: generic,
            kind: crate::error::ListGroupsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListGroupsError {
            meta: generic,
            kind: crate::error::ListGroupsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGroupsOutput, crate::error::ListGroupsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_identity_providers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListIdentityProvidersOutput,
    crate::error::ListIdentityProvidersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListIdentityProvidersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListIdentityProvidersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ListIdentityProvidersError {
            meta: generic,
            kind: crate::error::ListIdentityProvidersErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIdentityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListIdentityProvidersError {
            meta: generic,
            kind: crate::error::ListIdentityProvidersErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIdentityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ListIdentityProvidersError {
            meta: generic,
            kind: crate::error::ListIdentityProvidersErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIdentityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListIdentityProvidersError {
            meta: generic,
            kind: crate::error::ListIdentityProvidersErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIdentityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListIdentityProvidersError {
            meta: generic,
            kind: crate::error::ListIdentityProvidersErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIdentityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListIdentityProvidersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_identity_providers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListIdentityProvidersOutput,
    crate::error::ListIdentityProvidersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_identity_providers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_identity_providers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListIdentityProvidersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resource_servers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResourceServersOutput,
    crate::error::ListResourceServersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListResourceServersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListResourceServersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ListResourceServersError {
            meta: generic,
            kind: crate::error::ListResourceServersErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourceServersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListResourceServersError {
            meta: generic,
            kind: crate::error::ListResourceServersErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourceServersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ListResourceServersError {
            meta: generic,
            kind: crate::error::ListResourceServersErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourceServersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListResourceServersError {
            meta: generic,
            kind: crate::error::ListResourceServersErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourceServersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListResourceServersError {
            meta: generic,
            kind: crate::error::ListResourceServersErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourceServersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListResourceServersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resource_servers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResourceServersOutput,
    crate::error::ListResourceServersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_resource_servers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_resource_servers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListResourceServersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_import_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListUserImportJobsOutput,
    crate::error::ListUserImportJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListUserImportJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListUserImportJobsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ListUserImportJobsError {
            meta: generic,
            kind: crate::error::ListUserImportJobsErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserImportJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListUserImportJobsError {
            meta: generic,
            kind: crate::error::ListUserImportJobsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserImportJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ListUserImportJobsError {
            meta: generic,
            kind: crate::error::ListUserImportJobsErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserImportJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListUserImportJobsError {
            meta: generic,
            kind: crate::error::ListUserImportJobsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserImportJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListUserImportJobsError {
            meta: generic,
            kind: crate::error::ListUserImportJobsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserImportJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListUserImportJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_import_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListUserImportJobsOutput,
    crate::error::ListUserImportJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_user_import_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_user_import_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListUserImportJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_pool_clients_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListUserPoolClientsOutput,
    crate::error::ListUserPoolClientsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListUserPoolClientsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListUserPoolClientsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ListUserPoolClientsError {
            meta: generic,
            kind: crate::error::ListUserPoolClientsErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserPoolClientsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListUserPoolClientsError {
            meta: generic,
            kind: crate::error::ListUserPoolClientsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserPoolClientsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ListUserPoolClientsError {
            meta: generic,
            kind: crate::error::ListUserPoolClientsErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserPoolClientsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListUserPoolClientsError {
            meta: generic,
            kind: crate::error::ListUserPoolClientsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserPoolClientsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListUserPoolClientsError {
            meta: generic,
            kind: crate::error::ListUserPoolClientsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserPoolClientsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListUserPoolClientsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_pool_clients_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListUserPoolClientsOutput,
    crate::error::ListUserPoolClientsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_user_pool_clients_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_user_pool_clients(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListUserPoolClientsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_pools_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserPoolsOutput, crate::error::ListUserPoolsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListUserPoolsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListUserPoolsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ListUserPoolsError {
            meta: generic,
            kind: crate::error::ListUserPoolsErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserPoolsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListUserPoolsError {
            meta: generic,
            kind: crate::error::ListUserPoolsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserPoolsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ListUserPoolsError {
            meta: generic,
            kind: crate::error::ListUserPoolsErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserPoolsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListUserPoolsError {
            meta: generic,
            kind: crate::error::ListUserPoolsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUserPoolsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListUserPoolsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_pools_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserPoolsOutput, crate::error::ListUserPoolsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_user_pools_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_user_pools(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListUserPoolsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_users_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUsersOutput, crate::error::ListUsersError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListUsersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListUsersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ListUsersError {
            meta: generic,
            kind: crate::error::ListUsersErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUsersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListUsersError {
            meta: generic,
            kind: crate::error::ListUsersErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUsersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ListUsersError {
            meta: generic,
            kind: crate::error::ListUsersErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUsersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListUsersError {
            meta: generic,
            kind: crate::error::ListUsersErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUsersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListUsersError {
            meta: generic,
            kind: crate::error::ListUsersErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUsersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListUsersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_users_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUsersOutput, crate::error::ListUsersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_users_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_users(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListUsersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_users_in_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUsersInGroupOutput, crate::error::ListUsersInGroupError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListUsersInGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListUsersInGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::ListUsersInGroupError {
            meta: generic,
            kind: crate::error::ListUsersInGroupErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUsersInGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListUsersInGroupError {
            meta: generic,
            kind: crate::error::ListUsersInGroupErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUsersInGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::ListUsersInGroupError {
            meta: generic,
            kind: crate::error::ListUsersInGroupErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUsersInGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListUsersInGroupError {
            meta: generic,
            kind: crate::error::ListUsersInGroupErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUsersInGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::ListUsersInGroupError {
            meta: generic,
            kind: crate::error::ListUsersInGroupErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListUsersInGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListUsersInGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_users_in_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUsersInGroupOutput, crate::error::ListUsersInGroupError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_users_in_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_users_in_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListUsersInGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resend_confirmation_code_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResendConfirmationCodeOutput,
    crate::error::ResendConfirmationCodeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ResendConfirmationCodeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeDeliveryFailureException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::CodeDeliveryFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::code_delivery_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_delivery_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalErrorException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::InternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidEmailRoleAccessPolicyException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::InvalidEmailRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_email_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_email_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLambdaResponseException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::InvalidLambdaResponseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleAccessPolicyException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::InvalidSmsRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleTrustRelationshipException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::InvalidSmsRoleTrustRelationshipException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotAuthorizedException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::NotAuthorizedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnexpectedLambdaException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::UnexpectedLambdaException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserLambdaValidationException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::UserLambdaValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotFoundException" => crate::error::ResendConfirmationCodeError { meta: generic, kind: crate::error::ResendConfirmationCodeErrorKind::UserNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ResendConfirmationCodeError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resend_confirmation_code_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResendConfirmationCodeOutput,
    crate::error::ResendConfirmationCodeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::resend_confirmation_code_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_resend_confirmation_code(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ResendConfirmationCodeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_respond_to_auth_challenge_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RespondToAuthChallengeOutput,
    crate::error::RespondToAuthChallengeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RespondToAuthChallengeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AliasExistsException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::AliasExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::alias_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_alias_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CodeMismatchException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::CodeMismatchException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::code_mismatch_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ExpiredCodeException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::ExpiredCodeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::expired_code_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_expired_code_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalErrorException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::InternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLambdaResponseException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::InvalidLambdaResponseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidPasswordException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::InvalidPasswordException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_password_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_password_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleAccessPolicyException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::InvalidSmsRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleTrustRelationshipException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::InvalidSmsRoleTrustRelationshipException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidUserPoolConfigurationException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::InvalidUserPoolConfigurationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_user_pool_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MFAMethodNotFoundException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::MfaMethodNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::mfa_method_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_mfa_method_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotAuthorizedException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::NotAuthorizedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PasswordResetRequiredException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::PasswordResetRequiredException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SoftwareTokenMFANotFoundException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::SoftwareTokenMfaNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::software_token_mfa_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_software_token_mfa_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnexpectedLambdaException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::UnexpectedLambdaException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserLambdaValidationException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::UserLambdaValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotConfirmedException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::UserNotConfirmedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotFoundException" => crate::error::RespondToAuthChallengeError { meta: generic, kind: crate::error::RespondToAuthChallengeErrorKind::UserNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RespondToAuthChallengeError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_respond_to_auth_challenge_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RespondToAuthChallengeOutput,
    crate::error::RespondToAuthChallengeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::respond_to_auth_challenge_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_respond_to_auth_challenge(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RespondToAuthChallengeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_token_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RevokeTokenOutput, crate::error::RevokeTokenError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RevokeTokenError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RevokeTokenError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::RevokeTokenError {
            meta: generic,
            kind: crate::error::RevokeTokenErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::RevokeTokenError {
            meta: generic,
            kind: crate::error::RevokeTokenErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::RevokeTokenError {
            meta: generic,
            kind: crate::error::RevokeTokenErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedException" => crate::error::RevokeTokenError {
            meta: generic,
            kind: crate::error::RevokeTokenErrorKind::UnauthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::RevokeTokenError {
            meta: generic,
            kind: crate::error::RevokeTokenErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedTokenTypeException" => crate::error::RevokeTokenError {
            meta: generic,
            kind: crate::error::RevokeTokenErrorKind::UnsupportedTokenTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_token_type_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_token_type_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RevokeTokenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_token_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RevokeTokenOutput, crate::error::RevokeTokenError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::revoke_token_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_risk_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetRiskConfigurationOutput,
    crate::error::SetRiskConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetRiskConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetRiskConfigurationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeDeliveryFailureException" => crate::error::SetRiskConfigurationError {
            meta: generic,
            kind: crate::error::SetRiskConfigurationErrorKind::CodeDeliveryFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_delivery_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_delivery_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::SetRiskConfigurationError {
            meta: generic,
            kind: crate::error::SetRiskConfigurationErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEmailRoleAccessPolicyException" => crate::error::SetRiskConfigurationError {
            meta: generic,
            kind:
                crate::error::SetRiskConfigurationErrorKind::InvalidEmailRoleAccessPolicyException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_email_role_access_policy_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_email_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetRiskConfigurationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidParameterException" => crate::error::SetRiskConfigurationError {
            meta: generic,
            kind: crate::error::SetRiskConfigurationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::SetRiskConfigurationError {
            meta: generic,
            kind: crate::error::SetRiskConfigurationErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::SetRiskConfigurationError {
            meta: generic,
            kind: crate::error::SetRiskConfigurationErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::SetRiskConfigurationError {
            meta: generic,
            kind: crate::error::SetRiskConfigurationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserPoolAddOnNotEnabledException" => crate::error::SetRiskConfigurationError {
            meta: generic,
            kind: crate::error::SetRiskConfigurationErrorKind::UserPoolAddOnNotEnabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_pool_add_on_not_enabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_pool_add_on_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetRiskConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetRiskConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_risk_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetRiskConfigurationOutput,
    crate::error::SetRiskConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_risk_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_set_risk_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetRiskConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_ui_customization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetUiCustomizationOutput,
    crate::error::SetUICustomizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetUICustomizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetUICustomizationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::SetUICustomizationError {
            meta: generic,
            kind: crate::error::SetUICustomizationErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUICustomizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::SetUICustomizationError {
            meta: generic,
            kind: crate::error::SetUICustomizationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUICustomizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::SetUICustomizationError {
            meta: generic,
            kind: crate::error::SetUICustomizationErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUICustomizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::SetUICustomizationError {
            meta: generic,
            kind: crate::error::SetUICustomizationErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUICustomizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::SetUICustomizationError {
            meta: generic,
            kind: crate::error::SetUICustomizationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUICustomizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetUICustomizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_ui_customization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetUiCustomizationOutput,
    crate::error::SetUICustomizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_ui_customization_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_set_ui_customization(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetUICustomizationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_user_mfa_preference_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetUserMfaPreferenceOutput,
    crate::error::SetUserMFAPreferenceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetUserMFAPreferenceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetUserMFAPreferenceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::SetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::SetUserMFAPreferenceErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::SetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::SetUserMFAPreferenceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::SetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::SetUserMFAPreferenceErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::SetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::SetUserMFAPreferenceErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::SetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::SetUserMFAPreferenceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::SetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::SetUserMFAPreferenceErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::SetUserMFAPreferenceError {
            meta: generic,
            kind: crate::error::SetUserMFAPreferenceErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserMFAPreferenceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetUserMFAPreferenceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_user_mfa_preference_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetUserMfaPreferenceOutput,
    crate::error::SetUserMFAPreferenceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_user_mfa_preference_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_user_pool_mfa_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetUserPoolMfaConfigOutput,
    crate::error::SetUserPoolMfaConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetUserPoolMfaConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetUserPoolMfaConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::SetUserPoolMfaConfigError { meta: generic, kind: crate::error::SetUserPoolMfaConfigErrorKind::InternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::SetUserPoolMfaConfigError { meta: generic, kind: crate::error::SetUserPoolMfaConfigErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleAccessPolicyException" => crate::error::SetUserPoolMfaConfigError { meta: generic, kind: crate::error::SetUserPoolMfaConfigErrorKind::InvalidSmsRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleTrustRelationshipException" => crate::error::SetUserPoolMfaConfigError { meta: generic, kind: crate::error::SetUserPoolMfaConfigErrorKind::InvalidSmsRoleTrustRelationshipException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotAuthorizedException" => crate::error::SetUserPoolMfaConfigError { meta: generic, kind: crate::error::SetUserPoolMfaConfigErrorKind::NotAuthorizedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::SetUserPoolMfaConfigError { meta: generic, kind: crate::error::SetUserPoolMfaConfigErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::SetUserPoolMfaConfigError { meta: generic, kind: crate::error::SetUserPoolMfaConfigErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserPoolMfaConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::SetUserPoolMfaConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_user_pool_mfa_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetUserPoolMfaConfigOutput,
    crate::error::SetUserPoolMfaConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_user_pool_mfa_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_set_user_pool_mfa_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetUserPoolMfaConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_user_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetUserSettingsOutput, crate::error::SetUserSettingsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetUserSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetUserSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::SetUserSettingsError {
            meta: generic,
            kind: crate::error::SetUserSettingsErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::SetUserSettingsError {
            meta: generic,
            kind: crate::error::SetUserSettingsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::SetUserSettingsError {
            meta: generic,
            kind: crate::error::SetUserSettingsErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::SetUserSettingsError {
            meta: generic,
            kind: crate::error::SetUserSettingsErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::SetUserSettingsError {
            meta: generic,
            kind: crate::error::SetUserSettingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::SetUserSettingsError {
            meta: generic,
            kind: crate::error::SetUserSettingsErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::SetUserSettingsError {
            meta: generic,
            kind: crate::error::SetUserSettingsErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetUserSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetUserSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_user_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetUserSettingsOutput, crate::error::SetUserSettingsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_user_settings_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_sign_up_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SignUpOutput, crate::error::SignUpError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SignUpError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SignUpError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeDeliveryFailureException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::CodeDeliveryFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_delivery_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_delivery_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEmailRoleAccessPolicyException" => {
            crate::error::SignUpError {
                meta: generic,
                kind: crate::error::SignUpErrorKind::InvalidEmailRoleAccessPolicyException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_email_role_access_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_email_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidLambdaResponseException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::InvalidLambdaResponseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPasswordException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::InvalidPasswordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_password_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_password_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSmsRoleAccessPolicyException" => {
            crate::error::SignUpError {
                meta: generic,
                kind: crate::error::SignUpErrorKind::InvalidSmsRoleAccessPolicyException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidSmsRoleTrustRelationshipException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::InvalidSmsRoleTrustRelationshipException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnexpectedLambdaException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::UnexpectedLambdaException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserLambdaValidationException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::UserLambdaValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UsernameExistsException" => crate::error::SignUpError {
            meta: generic,
            kind: crate::error::SignUpErrorKind::UsernameExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::username_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_username_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignUpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SignUpError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_sign_up_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SignUpOutput, crate::error::SignUpError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::sign_up_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_sign_up(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SignUpError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_user_import_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartUserImportJobOutput,
    crate::error::StartUserImportJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartUserImportJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartUserImportJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::StartUserImportJobError {
            meta: generic,
            kind: crate::error::StartUserImportJobErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StartUserImportJobError {
            meta: generic,
            kind: crate::error::StartUserImportJobErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::StartUserImportJobError {
            meta: generic,
            kind: crate::error::StartUserImportJobErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionNotMetException" => crate::error::StartUserImportJobError {
            meta: generic,
            kind: crate::error::StartUserImportJobErrorKind::PreconditionNotMetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_not_met_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_not_met_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::StartUserImportJobError {
            meta: generic,
            kind: crate::error::StartUserImportJobErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::StartUserImportJobError {
            meta: generic,
            kind: crate::error::StartUserImportJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartUserImportJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_user_import_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartUserImportJobOutput,
    crate::error::StartUserImportJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_user_import_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_user_import_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartUserImportJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_user_import_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopUserImportJobOutput, crate::error::StopUserImportJobError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopUserImportJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopUserImportJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::StopUserImportJobError {
            meta: generic,
            kind: crate::error::StopUserImportJobErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StopUserImportJobError {
            meta: generic,
            kind: crate::error::StopUserImportJobErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::StopUserImportJobError {
            meta: generic,
            kind: crate::error::StopUserImportJobErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionNotMetException" => crate::error::StopUserImportJobError {
            meta: generic,
            kind: crate::error::StopUserImportJobErrorKind::PreconditionNotMetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_not_met_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_not_met_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::StopUserImportJobError {
            meta: generic,
            kind: crate::error::StopUserImportJobErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::StopUserImportJobError {
            meta: generic,
            kind: crate::error::StopUserImportJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopUserImportJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopUserImportJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_user_import_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopUserImportJobOutput, crate::error::StopUserImportJobError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_user_import_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_user_import_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopUserImportJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_auth_event_feedback_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAuthEventFeedbackOutput,
    crate::error::UpdateAuthEventFeedbackError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAuthEventFeedbackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateAuthEventFeedbackError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::UpdateAuthEventFeedbackError {
            meta: generic,
            kind: crate::error::UpdateAuthEventFeedbackErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateAuthEventFeedbackError {
            meta: generic,
            kind: crate::error::UpdateAuthEventFeedbackErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::UpdateAuthEventFeedbackError {
            meta: generic,
            kind: crate::error::UpdateAuthEventFeedbackErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateAuthEventFeedbackError {
            meta: generic,
            kind: crate::error::UpdateAuthEventFeedbackErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateAuthEventFeedbackError {
            meta: generic,
            kind: crate::error::UpdateAuthEventFeedbackErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::UpdateAuthEventFeedbackError {
            meta: generic,
            kind: crate::error::UpdateAuthEventFeedbackErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAuthEventFeedbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserPoolAddOnNotEnabledException" => {
            crate::error::UpdateAuthEventFeedbackError {
                meta: generic,
                kind:
                    crate::error::UpdateAuthEventFeedbackErrorKind::UserPoolAddOnNotEnabledException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::user_pool_add_on_not_enabled_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_user_pool_add_on_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAuthEventFeedbackError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        _ => crate::error::UpdateAuthEventFeedbackError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_auth_event_feedback_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAuthEventFeedbackOutput,
    crate::error::UpdateAuthEventFeedbackError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_auth_event_feedback_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_device_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateDeviceStatusOutput,
    crate::error::UpdateDeviceStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateDeviceStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateDeviceStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::UpdateDeviceStatusError {
            meta: generic,
            kind: crate::error::UpdateDeviceStatusErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateDeviceStatusError {
            meta: generic,
            kind: crate::error::UpdateDeviceStatusErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserPoolConfigurationException" => crate::error::UpdateDeviceStatusError {
            meta: generic,
            kind: crate::error::UpdateDeviceStatusErrorKind::InvalidUserPoolConfigurationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_user_pool_configuration_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotAuthorizedException" => crate::error::UpdateDeviceStatusError {
            meta: generic,
            kind: crate::error::UpdateDeviceStatusErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::UpdateDeviceStatusError {
            meta: generic,
            kind: crate::error::UpdateDeviceStatusErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateDeviceStatusError {
            meta: generic,
            kind: crate::error::UpdateDeviceStatusErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateDeviceStatusError {
            meta: generic,
            kind: crate::error::UpdateDeviceStatusErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::UpdateDeviceStatusError {
            meta: generic,
            kind: crate::error::UpdateDeviceStatusErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::UpdateDeviceStatusError {
            meta: generic,
            kind: crate::error::UpdateDeviceStatusErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateDeviceStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_device_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateDeviceStatusOutput,
    crate::error::UpdateDeviceStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_device_status_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateGroupOutput, crate::error::UpdateGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::UpdateGroupError {
            meta: generic,
            kind: crate::error::UpdateGroupErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateGroupError {
            meta: generic,
            kind: crate::error::UpdateGroupErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::UpdateGroupError {
            meta: generic,
            kind: crate::error::UpdateGroupErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateGroupError {
            meta: generic,
            kind: crate::error::UpdateGroupErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateGroupError {
            meta: generic,
            kind: crate::error::UpdateGroupErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateGroupOutput, crate::error::UpdateGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_identity_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateIdentityProviderOutput,
    crate::error::UpdateIdentityProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateIdentityProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::UpdateIdentityProviderError {
            meta: generic,
            kind: crate::error::UpdateIdentityProviderErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateIdentityProviderError {
            meta: generic,
            kind: crate::error::UpdateIdentityProviderErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::UpdateIdentityProviderError {
            meta: generic,
            kind: crate::error::UpdateIdentityProviderErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateIdentityProviderError {
            meta: generic,
            kind: crate::error::UpdateIdentityProviderErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateIdentityProviderError {
            meta: generic,
            kind: crate::error::UpdateIdentityProviderErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedIdentityProviderException" => crate::error::UpdateIdentityProviderError {
            meta: generic,
            kind:
                crate::error::UpdateIdentityProviderErrorKind::UnsupportedIdentityProviderException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::unsupported_identity_provider_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_unsupported_identity_provider_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::UpdateIdentityProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_identity_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateIdentityProviderOutput,
    crate::error::UpdateIdentityProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_identity_provider_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_identity_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateIdentityProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_resource_server_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateResourceServerOutput,
    crate::error::UpdateResourceServerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateResourceServerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateResourceServerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::UpdateResourceServerError {
            meta: generic,
            kind: crate::error::UpdateResourceServerErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateResourceServerError {
            meta: generic,
            kind: crate::error::UpdateResourceServerErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::UpdateResourceServerError {
            meta: generic,
            kind: crate::error::UpdateResourceServerErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateResourceServerError {
            meta: generic,
            kind: crate::error::UpdateResourceServerErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateResourceServerError {
            meta: generic,
            kind: crate::error::UpdateResourceServerErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateResourceServerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateResourceServerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_resource_server_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateResourceServerOutput,
    crate::error::UpdateResourceServerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_resource_server_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_resource_server(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateResourceServerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateUserAttributesOutput,
    crate::error::UpdateUserAttributesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateUserAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateUserAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AliasExistsException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::AliasExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::alias_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_alias_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CodeDeliveryFailureException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::CodeDeliveryFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::code_delivery_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_delivery_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CodeMismatchException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::CodeMismatchException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::code_mismatch_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ExpiredCodeException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::ExpiredCodeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::expired_code_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_expired_code_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalErrorException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::InternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidEmailRoleAccessPolicyException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::InvalidEmailRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_email_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_email_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLambdaResponseException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::InvalidLambdaResponseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_lambda_response_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lambda_response_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleAccessPolicyException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::InvalidSmsRoleAccessPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSmsRoleTrustRelationshipException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::InvalidSmsRoleTrustRelationshipException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotAuthorizedException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::NotAuthorizedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PasswordResetRequiredException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::PasswordResetRequiredException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnexpectedLambdaException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::UnexpectedLambdaException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unexpected_lambda_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unexpected_lambda_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserLambdaValidationException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::UserLambdaValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_lambda_validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_lambda_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotConfirmedException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::UserNotConfirmedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UserNotFoundException" => crate::error::UpdateUserAttributesError { meta: generic, kind: crate::error::UpdateUserAttributesErrorKind::UserNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateUserAttributesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateUserAttributesOutput,
    crate::error::UpdateUserAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_user_attributes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_user_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateUserAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_pool_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateUserPoolOutput, crate::error::UpdateUserPoolError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateUserPoolError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateUserPoolError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UpdateUserPoolError {
            meta: generic,
            kind: crate::error::UpdateUserPoolErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::UpdateUserPoolError {
            meta: generic,
            kind: crate::error::UpdateUserPoolErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEmailRoleAccessPolicyException" => crate::error::UpdateUserPoolError {
            meta: generic,
            kind: crate::error::UpdateUserPoolErrorKind::InvalidEmailRoleAccessPolicyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_email_role_access_policy_exception::Builder::default(
                        );
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_email_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateUserPoolError {
            meta: generic,
            kind: crate::error::UpdateUserPoolErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSmsRoleAccessPolicyException" => {
            crate::error::UpdateUserPoolError {
                meta: generic,
                kind: crate::error::UpdateUserPoolErrorKind::InvalidSmsRoleAccessPolicyException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_access_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_access_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidSmsRoleTrustRelationshipException" => crate::error::UpdateUserPoolError {
            meta: generic,
            kind: crate::error::UpdateUserPoolErrorKind::InvalidSmsRoleTrustRelationshipException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_sms_role_trust_relationship_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_sms_role_trust_relationship_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotAuthorizedException" => crate::error::UpdateUserPoolError {
            meta: generic,
            kind: crate::error::UpdateUserPoolErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateUserPoolError {
            meta: generic,
            kind: crate::error::UpdateUserPoolErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateUserPoolError {
            meta: generic,
            kind: crate::error::UpdateUserPoolErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserImportInProgressException" => crate::error::UpdateUserPoolError {
            meta: generic,
            kind: crate::error::UpdateUserPoolErrorKind::UserImportInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::user_import_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_import_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserPoolTaggingException" => crate::error::UpdateUserPoolError {
            meta: generic,
            kind: crate::error::UpdateUserPoolErrorKind::UserPoolTaggingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_pool_tagging_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_pool_tagging_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateUserPoolError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_pool_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateUserPoolOutput, crate::error::UpdateUserPoolError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_user_pool_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_pool_client_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateUserPoolClientOutput,
    crate::error::UpdateUserPoolClientError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateUserPoolClientError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateUserPoolClientError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UpdateUserPoolClientError {
            meta: generic,
            kind: crate::error::UpdateUserPoolClientErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_modification_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::UpdateUserPoolClientError {
            meta: generic,
            kind: crate::error::UpdateUserPoolClientErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidOAuthFlowException" => crate::error::UpdateUserPoolClientError {
            meta: generic,
            kind: crate::error::UpdateUserPoolClientErrorKind::InvalidOAuthFlowException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_o_auth_flow_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_o_auth_flow_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateUserPoolClientError {
            meta: generic,
            kind: crate::error::UpdateUserPoolClientErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::UpdateUserPoolClientError {
            meta: generic,
            kind: crate::error::UpdateUserPoolClientErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateUserPoolClientError {
            meta: generic,
            kind: crate::error::UpdateUserPoolClientErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ScopeDoesNotExistException" => crate::error::UpdateUserPoolClientError {
            meta: generic,
            kind: crate::error::UpdateUserPoolClientErrorKind::ScopeDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::scope_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_scope_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateUserPoolClientError {
            meta: generic,
            kind: crate::error::UpdateUserPoolClientErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolClientError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateUserPoolClientError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_pool_client_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateUserPoolClientOutput,
    crate::error::UpdateUserPoolClientError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_user_pool_client_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_user_pool_client(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateUserPoolClientError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_pool_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateUserPoolDomainOutput,
    crate::error::UpdateUserPoolDomainError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateUserPoolDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateUserPoolDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalErrorException" => crate::error::UpdateUserPoolDomainError {
            meta: generic,
            kind: crate::error::UpdateUserPoolDomainErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateUserPoolDomainError {
            meta: generic,
            kind: crate::error::UpdateUserPoolDomainErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::UpdateUserPoolDomainError {
            meta: generic,
            kind: crate::error::UpdateUserPoolDomainErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateUserPoolDomainError {
            meta: generic,
            kind: crate::error::UpdateUserPoolDomainErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::UpdateUserPoolDomainError {
            meta: generic,
            kind: crate::error::UpdateUserPoolDomainErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserPoolDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateUserPoolDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_pool_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateUserPoolDomainOutput,
    crate::error::UpdateUserPoolDomainError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_user_pool_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_user_pool_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateUserPoolDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_software_token_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifySoftwareTokenOutput,
    crate::error::VerifySoftwareTokenError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::VerifySoftwareTokenError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeMismatchException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::CodeMismatchException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::code_mismatch_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EnableSoftwareTokenMFAException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::EnableSoftwareTokenMfaException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::enable_software_token_mfa_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_enable_software_token_mfa_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserPoolConfigurationException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::InvalidUserPoolConfigurationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_user_pool_configuration_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_user_pool_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotAuthorizedException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SoftwareTokenMFANotFoundException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::SoftwareTokenMfaNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::software_token_mfa_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_software_token_mfa_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::VerifySoftwareTokenError {
            meta: generic,
            kind: crate::error::VerifySoftwareTokenErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::VerifySoftwareTokenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_software_token_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifySoftwareTokenOutput,
    crate::error::VerifySoftwareTokenError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::verify_software_token_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_verify_software_token(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::VerifySoftwareTokenError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_user_attribute_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifyUserAttributeOutput,
    crate::error::VerifyUserAttributeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::VerifyUserAttributeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::VerifyUserAttributeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeMismatchException" => crate::error::VerifyUserAttributeError {
            meta: generic,
            kind: crate::error::VerifyUserAttributeErrorKind::CodeMismatchException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::code_mismatch_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyUserAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ExpiredCodeException" => crate::error::VerifyUserAttributeError {
            meta: generic,
            kind: crate::error::VerifyUserAttributeErrorKind::ExpiredCodeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::expired_code_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_expired_code_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyUserAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::VerifyUserAttributeError {
            meta: generic,
            kind: crate::error::VerifyUserAttributeErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyUserAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::VerifyUserAttributeError {
            meta: generic,
            kind: crate::error::VerifyUserAttributeErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyUserAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::VerifyUserAttributeError {
            meta: generic,
            kind: crate::error::VerifyUserAttributeErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyUserAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAuthorizedException" => crate::error::VerifyUserAttributeError {
            meta: generic,
            kind: crate::error::VerifyUserAttributeErrorKind::NotAuthorizedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_authorized_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_authorized_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyUserAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordResetRequiredException" => crate::error::VerifyUserAttributeError {
            meta: generic,
            kind: crate::error::VerifyUserAttributeErrorKind::PasswordResetRequiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_reset_required_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_password_reset_required_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyUserAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::VerifyUserAttributeError {
            meta: generic,
            kind: crate::error::VerifyUserAttributeErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyUserAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::VerifyUserAttributeError {
            meta: generic,
            kind: crate::error::VerifyUserAttributeErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyUserAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotConfirmedException" => crate::error::VerifyUserAttributeError {
            meta: generic,
            kind: crate::error::VerifyUserAttributeErrorKind::UserNotConfirmedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_confirmed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_confirmed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyUserAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UserNotFoundException" => crate::error::VerifyUserAttributeError {
            meta: generic,
            kind: crate::error::VerifyUserAttributeErrorKind::UserNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::user_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_user_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyUserAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::VerifyUserAttributeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_user_attribute_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifyUserAttributeOutput,
    crate::error::VerifyUserAttributeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::verify_user_attribute_output::Builder::default();
        let _ = response;
        output.build()
    })
}
